// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__77711 = arguments.length;
switch (G__77711) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77756){
var state_val_77757 = (state_77756[(1)]);
if((state_val_77757 === (7))){
var inst_77726 = typeof user === 'string';
var state_77756__$1 = state_77756;
if(cljs.core.truth_(inst_77726)){
var statearr_77758_77787 = state_77756__$1;
(statearr_77758_77787[(1)] = (9));

} else {
var statearr_77759_77788 = state_77756__$1;
(statearr_77759_77788[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77757 === (1))){
var state_77756__$1 = state_77756;
var statearr_77760_77789 = state_77756__$1;
(statearr_77760_77789[(2)] = null);

(statearr_77760_77789[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77757 === (4))){
var inst_77712 = (state_77756[(2)]);
var inst_77713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77714 = [inst_77712];
var inst_77715 = (new cljs.core.PersistentVector(null,1,(5),inst_77713,inst_77714,null));
var inst_77716 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77715);
var inst_77717 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_77712) : reject.call(null,inst_77712));
var state_77756__$1 = (function (){var statearr_77761 = state_77756;
(statearr_77761[(7)] = inst_77716);

return statearr_77761;
})();
var statearr_77762_77790 = state_77756__$1;
(statearr_77762_77790[(2)] = inst_77717);

(statearr_77762_77790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77757 === (15))){
var inst_77745 = (state_77756[(2)]);
var inst_77746 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_77745);
var inst_77747 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_77748 = cljs.core.constantly(inst_77746);
var inst_77749 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_77747,inst_77748);
var inst_77750 = fluree.db.connection.add_token(conn,inst_77746);
var inst_77751 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_77745) : resolve.call(null,inst_77745));
var _ = (function (){var statearr_77763 = state_77756;
(statearr_77763[(4)] = cljs.core.rest((state_77756[(4)])));

return statearr_77763;
})();
var state_77756__$1 = (function (){var statearr_77764 = state_77756;
(statearr_77764[(8)] = inst_77749);

(statearr_77764[(9)] = inst_77750);

return statearr_77764;
})();
var statearr_77765_77791 = state_77756__$1;
(statearr_77765_77791[(2)] = inst_77751);

(statearr_77765_77791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77757 === (13))){
var state_77756__$1 = state_77756;
var statearr_77766_77792 = state_77756__$1;
(statearr_77766_77792[(2)] = null);

(statearr_77766_77792[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77757 === (6))){
var state_77756__$1 = state_77756;
var statearr_77767_77793 = state_77756__$1;
(statearr_77767_77793[(2)] = user);

(statearr_77767_77793[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77757 === (3))){
var inst_77754 = (state_77756[(2)]);
var state_77756__$1 = state_77756;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77756__$1,inst_77754);
} else {
if((state_val_77757 === (12))){
var state_77756__$1 = state_77756;
var statearr_77768_77794 = state_77756__$1;
(statearr_77768_77794[(2)] = user);

(statearr_77768_77794[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77757 === (2))){
var _ = (function (){var statearr_77769 = state_77756;
(statearr_77769[(4)] = cljs.core.cons((5),(state_77756[(4)])));

return statearr_77769;
})();
var inst_77723 = typeof user === 'number';
var state_77756__$1 = state_77756;
if(cljs.core.truth_(inst_77723)){
var statearr_77770_77795 = state_77756__$1;
(statearr_77770_77795[(1)] = (6));

} else {
var statearr_77771_77796 = state_77756__$1;
(statearr_77771_77796[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77757 === (11))){
var inst_77737 = (state_77756[(2)]);
var state_77756__$1 = state_77756;
var statearr_77773_77797 = state_77756__$1;
(statearr_77773_77797[(2)] = inst_77737);

(statearr_77773_77797[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77757 === (9))){
var inst_77728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77729 = ["_user/username",user];
var inst_77730 = (new cljs.core.PersistentVector(null,2,(5),inst_77728,inst_77729,null));
var state_77756__$1 = state_77756;
var statearr_77774_77798 = state_77756__$1;
(statearr_77774_77798[(2)] = inst_77730);

(statearr_77774_77798[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77757 === (5))){
var _ = (function (){var statearr_77775 = state_77756;
(statearr_77775[(4)] = cljs.core.rest((state_77756[(4)])));

return statearr_77775;
})();
var state_77756__$1 = state_77756;
var ex77772 = (state_77756__$1[(2)]);
var statearr_77776_77799 = state_77756__$1;
(statearr_77776_77799[(5)] = ex77772);


var statearr_77777_77800 = state_77756__$1;
(statearr_77777_77800[(1)] = (4));

(statearr_77777_77800[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77757 === (14))){
var inst_77735 = (state_77756[(2)]);
var state_77756__$1 = state_77756;
var statearr_77778_77801 = state_77756__$1;
(statearr_77778_77801[(2)] = inst_77735);

(statearr_77778_77801[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77757 === (10))){
var state_77756__$1 = state_77756;
var statearr_77779_77802 = state_77756__$1;
(statearr_77779_77802[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77757 === (8))){
var inst_77739 = (state_77756[(2)]);
var inst_77740 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_77741 = [account,inst_77739,password,expireSeconds,syncTo];
var inst_77742 = cljs.core.PersistentHashMap.fromArrays(inst_77740,inst_77741);
var inst_77743 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_77742);
var state_77756__$1 = state_77756;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77756__$1,(15),inst_77743);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_77781 = [null,null,null,null,null,null,null,null,null,null];
(statearr_77781[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_77781[(1)] = (1));

return statearr_77781;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_77756){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77756);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77782){var ex__2730__auto__ = e77782;
var statearr_77783_77803 = state_77756;
(statearr_77783_77803[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77756[(4)]))){
var statearr_77784_77804 = state_77756;
(statearr_77784_77804[(1)] = cljs.core.first((state_77756[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77805 = state_77756;
state_77756 = G__77805;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_77756){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_77756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77785 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77785[(6)] = c__2749__auto__);

return statearr_77785;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__77807 = arguments.length;
switch (G__77807) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77816){
var state_val_77817 = (state_77816[(1)]);
if((state_val_77817 === (1))){
var inst_77808 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_77809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77810 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_77811 = (new cljs.core.PersistentVector(null,4,(5),inst_77809,inst_77810,null));
var inst_77812 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_77808,inst_77811);
var inst_77813 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__77818 = cljs.core.seq(cljs.core.keys(x));
var chunk__77819 = null;
var count__77820 = (0);
var i__77821 = (0);
while(true){
if((i__77821 < count__77820)){
var k = chunk__77819.cljs$core$IIndexed$_nth$arity$2(null,i__77821);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__77829 = seq__77818;
var G__77830 = chunk__77819;
var G__77831 = count__77820;
var G__77832 = (i__77821 + (1));
seq__77818 = G__77829;
chunk__77819 = G__77830;
count__77820 = G__77831;
i__77821 = G__77832;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__77818);
if(temp__5804__auto__){
var seq__77818__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__77818__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__77818__$1);
var G__77833 = cljs.core.chunk_rest(seq__77818__$1);
var G__77834 = c__5568__auto__;
var G__77835 = cljs.core.count(c__5568__auto__);
var G__77836 = (0);
seq__77818 = G__77833;
chunk__77819 = G__77834;
count__77820 = G__77835;
i__77821 = G__77836;
continue;
} else {
var k = cljs.core.first(seq__77818__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__77837 = cljs.core.next(seq__77818__$1);
var G__77838 = null;
var G__77839 = (0);
var G__77840 = (0);
seq__77818 = G__77837;
chunk__77819 = G__77838;
count__77820 = G__77839;
i__77821 = G__77840;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_77814 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_77813);
var state_77816__$1 = (function (){var statearr_77822 = state_77816;
(statearr_77822[(7)] = inst_77812);

return statearr_77822;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_77816__$1,inst_77814);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_77823 = [null,null,null,null,null,null,null,null];
(statearr_77823[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_77823[(1)] = (1));

return statearr_77823;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_77816){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77816);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77824){var ex__2730__auto__ = e77824;
var statearr_77825_77841 = state_77816;
(statearr_77825_77841[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77816[(4)]))){
var statearr_77826_77842 = state_77816;
(statearr_77826_77842[(1)] = cljs.core.first((state_77816[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77843 = state_77816;
state_77816 = G__77843;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_77816){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_77816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77827 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77827[(6)] = c__2749__auto__);

return statearr_77827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__77845 = arguments.length;
switch (G__77845) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77882){
var state_val_77883 = (state_77882[(1)]);
if((state_val_77883 === (1))){
var state_77882__$1 = state_77882;
var statearr_77884_77905 = state_77882__$1;
(statearr_77884_77905[(2)] = null);

(statearr_77884_77905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77883 === (2))){
var _ = (function (){var statearr_77885 = state_77882;
(statearr_77885[(4)] = cljs.core.cons((5),(state_77882[(4)])));

return statearr_77885;
})();
var inst_77857 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_77858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77859 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_77860 = (new cljs.core.PersistentVector(null,1,(5),inst_77858,inst_77859,null));
var inst_77861 = cljs.core.PersistentHashMap.EMPTY;
var inst_77862 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_77861);
var inst_77863 = cljs.core.assoc_in(inst_77857,inst_77860,inst_77862);
var inst_77864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77865 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_77866 = (new cljs.core.PersistentVector(null,1,(5),inst_77864,inst_77865,null));
var inst_77867 = cljs.core.PersistentHashMap.EMPTY;
var inst_77868 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_77867);
var inst_77869 = cljs.core.assoc_in(inst_77863,inst_77866,inst_77868);
var inst_77870 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_77871 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_77869);
var inst_77872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77873 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_77870,null];
var inst_77874 = (new cljs.core.PersistentVector(null,4,(5),inst_77872,inst_77873,null));
var inst_77875 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_77871,inst_77874);
var inst_77876 = (function (){var conn = inst_77869;
var pc = inst_77870;
return (function (x){
if((x == null)){
} else {
var seq__77886_77906 = cljs.core.seq(cljs.core.keys(x));
var chunk__77887_77907 = null;
var count__77888_77908 = (0);
var i__77889_77909 = (0);
while(true){
if((i__77889_77909 < count__77888_77908)){
var k_77910 = chunk__77887_77907.cljs$core$IIndexed$_nth$arity$2(null,i__77889_77909);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_77910], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_77910,null));


var G__77911 = seq__77886_77906;
var G__77912 = chunk__77887_77907;
var G__77913 = count__77888_77908;
var G__77914 = (i__77889_77909 + (1));
seq__77886_77906 = G__77911;
chunk__77887_77907 = G__77912;
count__77888_77908 = G__77913;
i__77889_77909 = G__77914;
continue;
} else {
var temp__5804__auto___77915 = cljs.core.seq(seq__77886_77906);
if(temp__5804__auto___77915){
var seq__77886_77916__$1 = temp__5804__auto___77915;
if(cljs.core.chunked_seq_QMARK_(seq__77886_77916__$1)){
var c__5568__auto___77917 = cljs.core.chunk_first(seq__77886_77916__$1);
var G__77918 = cljs.core.chunk_rest(seq__77886_77916__$1);
var G__77919 = c__5568__auto___77917;
var G__77920 = cljs.core.count(c__5568__auto___77917);
var G__77921 = (0);
seq__77886_77906 = G__77918;
chunk__77887_77907 = G__77919;
count__77888_77908 = G__77920;
i__77889_77909 = G__77921;
continue;
} else {
var k_77922 = cljs.core.first(seq__77886_77916__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_77922], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_77922,null));


var G__77923 = cljs.core.next(seq__77886_77916__$1);
var G__77924 = null;
var G__77925 = (0);
var G__77926 = (0);
seq__77886_77906 = G__77923;
chunk__77887_77907 = G__77924;
count__77888_77908 = G__77925;
i__77889_77909 = G__77926;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_77877 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_77870,inst_77876);
var ___$1 = (function (){var statearr_77890 = state_77882;
(statearr_77890[(4)] = cljs.core.rest((state_77882[(4)])));

return statearr_77890;
})();
var state_77882__$1 = (function (){var statearr_77891 = state_77882;
(statearr_77891[(7)] = inst_77875);

return statearr_77891;
})();
var statearr_77892_77927 = state_77882__$1;
(statearr_77892_77927[(2)] = inst_77877);

(statearr_77892_77927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77883 === (3))){
var inst_77880 = (state_77882[(2)]);
var state_77882__$1 = state_77882;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77882__$1,inst_77880);
} else {
if((state_val_77883 === (4))){
var inst_77846 = (state_77882[(2)]);
var inst_77847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77848 = [inst_77846];
var inst_77849 = (new cljs.core.PersistentVector(null,1,(5),inst_77847,inst_77848,null));
var inst_77850 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77849);
var inst_77851 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_77846) : reject.call(null,inst_77846));
var state_77882__$1 = (function (){var statearr_77894 = state_77882;
(statearr_77894[(8)] = inst_77850);

return statearr_77894;
})();
var statearr_77895_77928 = state_77882__$1;
(statearr_77895_77928[(2)] = inst_77851);

(statearr_77895_77928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77883 === (5))){
var _ = (function (){var statearr_77896 = state_77882;
(statearr_77896[(4)] = cljs.core.rest((state_77882[(4)])));

return statearr_77896;
})();
var state_77882__$1 = state_77882;
var ex77893 = (state_77882__$1[(2)]);
var statearr_77897_77929 = state_77882__$1;
(statearr_77897_77929[(5)] = ex77893);


var statearr_77898_77930 = state_77882__$1;
(statearr_77898_77930[(1)] = (4));

(statearr_77898_77930[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_77899 = [null,null,null,null,null,null,null,null,null];
(statearr_77899[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_77899[(1)] = (1));

return statearr_77899;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_77882){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77882);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77900){var ex__2730__auto__ = e77900;
var statearr_77901_77931 = state_77882;
(statearr_77901_77931[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77882[(4)]))){
var statearr_77902_77932 = state_77882;
(statearr_77902_77932[(1)] = cljs.core.first((state_77882[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77933 = state_77882;
state_77882 = G__77933;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_77882){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_77882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77903 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_77903[(6)] = c__2749__auto__);

return statearr_77903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__77935 = arguments.length;
switch (G__77935) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__77937 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__77937,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__77937,(1),null);
var cb_STAR_ = (function (header,data){
var G__77940 = cljs.core.clj__GT_js(header);
var G__77941 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__77940,G__77941) : callback.call(null,G__77940,G__77941));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__77942 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__77942,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__77942,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77995){
var state_val_77996 = (state_77995[(1)]);
if((state_val_77996 === (7))){
var inst_77956 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77957 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_77958 = cljs.core.PersistentHashMap.fromArrays(inst_77956,inst_77957);
var inst_77959 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_77958);
var inst_77960 = (function(){throw inst_77959})();
var state_77995__$1 = state_77995;
var statearr_77997_78029 = state_77995__$1;
(statearr_77997_78029[(2)] = inst_77960);

(statearr_77997_78029[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77996 === (1))){
var state_77995__$1 = state_77995;
var statearr_77998_78030 = state_77995__$1;
(statearr_77998_78030[(2)] = null);

(statearr_77998_78030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77996 === (4))){
var inst_77945 = (state_77995[(2)]);
var inst_77946 = cljs.core.clj__GT_js(inst_77945);
var inst_77947 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_77946) : reject.call(null,inst_77946));
var state_77995__$1 = state_77995;
var statearr_77999_78031 = state_77995__$1;
(statearr_77999_78031[(2)] = inst_77947);

(statearr_77999_78031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77996 === (13))){
var inst_77974 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77975 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_77976 = cljs.core.PersistentHashMap.fromArrays(inst_77974,inst_77975);
var inst_77977 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_77976);
var inst_77978 = (function(){throw inst_77977})();
var state_77995__$1 = state_77995;
var statearr_78000_78032 = state_77995__$1;
(statearr_78000_78032[(2)] = inst_77978);

(statearr_78000_78032[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77996 === (6))){
var state_77995__$1 = state_77995;
var statearr_78001_78033 = state_77995__$1;
(statearr_78001_78033[(2)] = null);

(statearr_78001_78033[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77996 === (3))){
var inst_77993 = (state_77995[(2)]);
var state_77995__$1 = state_77995;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77995__$1,inst_77993);
} else {
if((state_val_77996 === (12))){
var state_77995__$1 = state_77995;
var statearr_78002_78034 = state_77995__$1;
(statearr_78002_78034[(2)] = null);

(statearr_78002_78034[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77996 === (2))){
var _ = (function (){var statearr_78003 = state_77995;
(statearr_78003[(4)] = cljs.core.cons((5),(state_77995[(4)])));

return statearr_78003;
})();
var inst_77953 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_77995__$1 = state_77995;
if(cljs.core.truth_(inst_77953)){
var statearr_78004_78035 = state_77995__$1;
(statearr_78004_78035[(1)] = (6));

} else {
var statearr_78005_78036 = state_77995__$1;
(statearr_78005_78036[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77996 === (11))){
var inst_77971 = (state_77995[(2)]);
var state_77995__$1 = (function (){var statearr_78007 = state_77995;
(statearr_78007[(7)] = inst_77971);

return statearr_78007;
})();
if(cljs.core.truth_(password)){
var statearr_78008_78037 = state_77995__$1;
(statearr_78008_78037[(1)] = (12));

} else {
var statearr_78009_78038 = state_77995__$1;
(statearr_78009_78038[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77996 === (9))){
var state_77995__$1 = state_77995;
var statearr_78010_78039 = state_77995__$1;
(statearr_78010_78039[(2)] = null);

(statearr_78010_78039[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77996 === (5))){
var _ = (function (){var statearr_78011 = state_77995;
(statearr_78011[(4)] = cljs.core.rest((state_77995[(4)])));

return statearr_78011;
})();
var state_77995__$1 = state_77995;
var ex78006 = (state_77995__$1[(2)]);
var statearr_78012_78040 = state_77995__$1;
(statearr_78012_78040[(5)] = ex78006);


var statearr_78013_78041 = state_77995__$1;
(statearr_78013_78041[(1)] = (4));

(statearr_78013_78041[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77996 === (14))){
var inst_77980 = (state_77995[(2)]);
var inst_77981 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_77982 = fluree.db.util.core.without_nils(inst_77981);
var inst_77983 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_77984 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_77985 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77986 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_77982,inst_77983,null];
var inst_77987 = (new cljs.core.PersistentVector(null,4,(5),inst_77985,inst_77986,null));
var inst_77988 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_77984,inst_77987);
var inst_77989 = (function (){var _ = inst_77980;
var data = inst_77982;
var pc = inst_77983;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__78014 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__78014) : reject.call(null,G__78014));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__78015 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__78015) : reject.call(null,G__78015));
} else {
var G__78016 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__78016) : resolve.call(null,G__78016));

}
}
});
})();
var inst_77990 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_77983,inst_77989);
var _ = (function (){var statearr_78017 = state_77995;
(statearr_78017[(4)] = cljs.core.rest((state_77995[(4)])));

return statearr_78017;
})();
var state_77995__$1 = (function (){var statearr_78018 = state_77995;
(statearr_78018[(8)] = inst_77988);

return statearr_78018;
})();
var statearr_78019_78042 = state_77995__$1;
(statearr_78019_78042[(2)] = inst_77990);

(statearr_78019_78042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77996 === (10))){
var inst_77965 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77966 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_77967 = cljs.core.PersistentHashMap.fromArrays(inst_77965,inst_77966);
var inst_77968 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_77967);
var inst_77969 = (function(){throw inst_77968})();
var state_77995__$1 = state_77995;
var statearr_78020_78043 = state_77995__$1;
(statearr_78020_78043[(2)] = inst_77969);

(statearr_78020_78043[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77996 === (8))){
var inst_77962 = (state_77995[(2)]);
var state_77995__$1 = (function (){var statearr_78021 = state_77995;
(statearr_78021[(9)] = inst_77962);

return statearr_78021;
})();
if(cljs.core.truth_(ledger)){
var statearr_78022_78044 = state_77995__$1;
(statearr_78022_78044[(1)] = (9));

} else {
var statearr_78023_78045 = state_77995__$1;
(statearr_78023_78045[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0 = (function (){
var statearr_78024 = [null,null,null,null,null,null,null,null,null,null];
(statearr_78024[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2727__auto__);

(statearr_78024[(1)] = (1));

return statearr_78024;
});
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1 = (function (state_77995){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_77995);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e78025){var ex__2730__auto__ = e78025;
var statearr_78026_78046 = state_77995;
(statearr_78026_78046[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_77995[(4)]))){
var statearr_78027_78047 = state_77995;
(statearr_78027_78047[(1)] = cljs.core.first((state_77995[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78048 = state_77995;
state_77995 = G__78048;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = function(state_77995){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1.call(this,state_77995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_78028 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_78028[(6)] = c__2749__auto__);

return statearr_78028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__78050 = arguments.length;
switch (G__78050) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_78117){
var state_val_78118 = (state_78117[(1)]);
if((state_val_78118 === (7))){
var inst_78062 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78063 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_78064 = cljs.core.PersistentHashMap.fromArrays(inst_78062,inst_78063);
var inst_78065 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_78064);
var inst_78066 = (function(){throw inst_78065})();
var state_78117__$1 = state_78117;
var statearr_78119_78161 = state_78117__$1;
(statearr_78119_78161[(2)] = inst_78066);

(statearr_78119_78161[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (20))){
var inst_78100 = (state_78117[(2)]);
var inst_78101 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_78102 = [ledger,password,user,auth,expire];
var inst_78103 = cljs.core.PersistentHashMap.fromArrays(inst_78101,inst_78102);
var inst_78104 = fluree.db.util.core.without_nils(inst_78103);
var inst_78105 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_78106 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_78107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78108 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_78104,inst_78105,null];
var inst_78109 = (new cljs.core.PersistentVector(null,4,(5),inst_78107,inst_78108,null));
var inst_78110 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_78106,inst_78109);
var inst_78111 = (function (){var _ = inst_78100;
var data = inst_78104;
var pc = inst_78105;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__78120 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__78120) : reject.call(null,G__78120));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__78121 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__78121) : reject.call(null,G__78121));
} else {
fluree.db.connection.add_token(conn,result);

var G__78122 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__78122) : resolve.call(null,G__78122));

}
}
});
})();
var inst_78112 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_78105,inst_78111);
var _ = (function (){var statearr_78123 = state_78117;
(statearr_78123[(4)] = cljs.core.rest((state_78117[(4)])));

return statearr_78123;
})();
var state_78117__$1 = (function (){var statearr_78124 = state_78117;
(statearr_78124[(7)] = inst_78110);

return statearr_78124;
})();
var statearr_78125_78162 = state_78117__$1;
(statearr_78125_78162[(2)] = inst_78112);

(statearr_78125_78162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (1))){
var state_78117__$1 = state_78117;
var statearr_78126_78163 = state_78117__$1;
(statearr_78126_78163[(2)] = null);

(statearr_78126_78163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (4))){
var inst_78051 = (state_78117[(2)]);
var inst_78052 = cljs.core.clj__GT_js(inst_78051);
var inst_78053 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78052) : reject.call(null,inst_78052));
var state_78117__$1 = state_78117;
var statearr_78127_78164 = state_78117__$1;
(statearr_78127_78164[(2)] = inst_78053);

(statearr_78127_78164[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (15))){
var inst_78087 = (state_78117[(8)]);
var state_78117__$1 = state_78117;
var statearr_78128_78165 = state_78117__$1;
(statearr_78128_78165[(2)] = inst_78087);

(statearr_78128_78165[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (13))){
var inst_78080 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78081 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_78082 = cljs.core.PersistentHashMap.fromArrays(inst_78080,inst_78081);
var inst_78083 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_78082);
var inst_78084 = (function(){throw inst_78083})();
var state_78117__$1 = state_78117;
var statearr_78129_78166 = state_78117__$1;
(statearr_78129_78166[(2)] = inst_78084);

(statearr_78129_78166[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (6))){
var state_78117__$1 = state_78117;
var statearr_78130_78167 = state_78117__$1;
(statearr_78130_78167[(2)] = null);

(statearr_78130_78167[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (17))){
var inst_78091 = (state_78117[(2)]);
var state_78117__$1 = state_78117;
if(cljs.core.truth_(inst_78091)){
var statearr_78131_78168 = state_78117__$1;
(statearr_78131_78168[(1)] = (18));

} else {
var statearr_78132_78169 = state_78117__$1;
(statearr_78132_78169[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (3))){
var inst_78115 = (state_78117[(2)]);
var state_78117__$1 = state_78117;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78117__$1,inst_78115);
} else {
if((state_val_78118 === (12))){
var state_78117__$1 = state_78117;
var statearr_78133_78170 = state_78117__$1;
(statearr_78133_78170[(2)] = null);

(statearr_78133_78170[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (2))){
var _ = (function (){var statearr_78134 = state_78117;
(statearr_78134[(4)] = cljs.core.cons((5),(state_78117[(4)])));

return statearr_78134;
})();
var inst_78059 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_78117__$1 = state_78117;
if(cljs.core.truth_(inst_78059)){
var statearr_78135_78171 = state_78117__$1;
(statearr_78135_78171[(1)] = (6));

} else {
var statearr_78136_78172 = state_78117__$1;
(statearr_78136_78172[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (19))){
var inst_78094 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78095 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_78096 = cljs.core.PersistentHashMap.fromArrays(inst_78094,inst_78095);
var inst_78097 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_78096);
var inst_78098 = (function(){throw inst_78097})();
var state_78117__$1 = state_78117;
var statearr_78137_78173 = state_78117__$1;
(statearr_78137_78173[(2)] = inst_78098);

(statearr_78137_78173[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (11))){
var inst_78077 = (state_78117[(2)]);
var state_78117__$1 = (function (){var statearr_78139 = state_78117;
(statearr_78139[(9)] = inst_78077);

return statearr_78139;
})();
if(cljs.core.truth_(password)){
var statearr_78140_78174 = state_78117__$1;
(statearr_78140_78174[(1)] = (12));

} else {
var statearr_78141_78175 = state_78117__$1;
(statearr_78141_78175[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (9))){
var state_78117__$1 = state_78117;
var statearr_78142_78176 = state_78117__$1;
(statearr_78142_78176[(2)] = null);

(statearr_78142_78176[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (5))){
var _ = (function (){var statearr_78143 = state_78117;
(statearr_78143[(4)] = cljs.core.rest((state_78117[(4)])));

return statearr_78143;
})();
var state_78117__$1 = state_78117;
var ex78138 = (state_78117__$1[(2)]);
var statearr_78144_78177 = state_78117__$1;
(statearr_78144_78177[(5)] = ex78138);


var statearr_78145_78178 = state_78117__$1;
(statearr_78145_78178[(1)] = (4));

(statearr_78145_78178[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (14))){
var inst_78087 = (state_78117[(8)]);
var inst_78086 = (state_78117[(2)]);
var inst_78087__$1 = user;
var state_78117__$1 = (function (){var statearr_78146 = state_78117;
(statearr_78146[(8)] = inst_78087__$1);

(statearr_78146[(10)] = inst_78086);

return statearr_78146;
})();
if(cljs.core.truth_(inst_78087__$1)){
var statearr_78147_78179 = state_78117__$1;
(statearr_78147_78179[(1)] = (15));

} else {
var statearr_78148_78180 = state_78117__$1;
(statearr_78148_78180[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (16))){
var state_78117__$1 = state_78117;
var statearr_78149_78181 = state_78117__$1;
(statearr_78149_78181[(2)] = auth);

(statearr_78149_78181[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (10))){
var inst_78071 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78072 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_78073 = cljs.core.PersistentHashMap.fromArrays(inst_78071,inst_78072);
var inst_78074 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_78073);
var inst_78075 = (function(){throw inst_78074})();
var state_78117__$1 = state_78117;
var statearr_78150_78182 = state_78117__$1;
(statearr_78150_78182[(2)] = inst_78075);

(statearr_78150_78182[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (18))){
var state_78117__$1 = state_78117;
var statearr_78151_78183 = state_78117__$1;
(statearr_78151_78183[(2)] = null);

(statearr_78151_78183[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78118 === (8))){
var inst_78068 = (state_78117[(2)]);
var state_78117__$1 = (function (){var statearr_78152 = state_78117;
(statearr_78152[(11)] = inst_78068);

return statearr_78152;
})();
if(cljs.core.truth_(ledger)){
var statearr_78153_78184 = state_78117__$1;
(statearr_78153_78184[(1)] = (9));

} else {
var statearr_78154_78185 = state_78117__$1;
(statearr_78154_78185[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_78155 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78155[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_78155[(1)] = (1));

return statearr_78155;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_78117){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_78117);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e78156){var ex__2730__auto__ = e78156;
var statearr_78157_78186 = state_78117;
(statearr_78157_78186[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_78117[(4)]))){
var statearr_78158_78187 = state_78117;
(statearr_78158_78187[(1)] = cljs.core.first((state_78117[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78188 = state_78117;
state_78117 = G__78188;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_78117){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_78117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_78159 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_78159[(6)] = c__2749__auto__);

return statearr_78159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__78190 = arguments.length;
switch (G__78190) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_78225){
var state_val_78226 = (state_78225[(1)]);
if((state_val_78226 === (1))){
var state_78225__$1 = state_78225;
var statearr_78227_78249 = state_78225__$1;
(statearr_78227_78249[(2)] = null);

(statearr_78227_78249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (2))){
var _ = (function (){var statearr_78228 = state_78225;
(statearr_78228[(4)] = cljs.core.cons((5),(state_78225[(4)])));

return statearr_78228;
})();
var inst_78199 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_78225__$1 = state_78225;
if(cljs.core.truth_(inst_78199)){
var statearr_78229_78250 = state_78225__$1;
(statearr_78229_78250[(1)] = (6));

} else {
var statearr_78230_78251 = state_78225__$1;
(statearr_78230_78251[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (3))){
var inst_78223 = (state_78225[(2)]);
var state_78225__$1 = state_78225;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78225__$1,inst_78223);
} else {
if((state_val_78226 === (4))){
var inst_78191 = (state_78225[(2)]);
var inst_78192 = cljs.core.clj__GT_js(inst_78191);
var inst_78193 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_78192) : reject.call(null,inst_78192));
var state_78225__$1 = state_78225;
var statearr_78232_78252 = state_78225__$1;
(statearr_78232_78252[(2)] = inst_78193);

(statearr_78232_78252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (5))){
var _ = (function (){var statearr_78233 = state_78225;
(statearr_78233[(4)] = cljs.core.rest((state_78225[(4)])));

return statearr_78233;
})();
var state_78225__$1 = state_78225;
var ex78231 = (state_78225__$1[(2)]);
var statearr_78234_78253 = state_78225__$1;
(statearr_78234_78253[(5)] = ex78231);


var statearr_78235_78254 = state_78225__$1;
(statearr_78235_78254[(1)] = (4));

(statearr_78235_78254[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (6))){
var state_78225__$1 = state_78225;
var statearr_78236_78255 = state_78225__$1;
(statearr_78236_78255[(2)] = null);

(statearr_78236_78255[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (7))){
var inst_78202 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78203 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_78204 = cljs.core.PersistentHashMap.fromArrays(inst_78202,inst_78203);
var inst_78205 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_78204);
var inst_78206 = (function(){throw inst_78205})();
var state_78225__$1 = state_78225;
var statearr_78237_78256 = state_78225__$1;
(statearr_78237_78256[(2)] = inst_78206);

(statearr_78237_78256[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78226 === (8))){
var inst_78208 = (state_78225[(2)]);
var inst_78209 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_78210 = [jwt,expire];
var inst_78211 = cljs.core.PersistentHashMap.fromArrays(inst_78209,inst_78210);
var inst_78212 = fluree.db.util.core.without_nils(inst_78211);
var inst_78213 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_78214 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_78215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78216 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_78212,inst_78213,null];
var inst_78217 = (new cljs.core.PersistentVector(null,4,(5),inst_78215,inst_78216,null));
var inst_78218 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_78214,inst_78217);
var inst_78219 = (function (){var _ = inst_78208;
var data = inst_78212;
var pc = inst_78213;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__78238 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__78238) : reject.call(null,G__78238));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__78239 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__78239) : resolve.call(null,G__78239));

}
});
})();
var inst_78220 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_78213,inst_78219);
var _ = (function (){var statearr_78240 = state_78225;
(statearr_78240[(4)] = cljs.core.rest((state_78225[(4)])));

return statearr_78240;
})();
var state_78225__$1 = (function (){var statearr_78241 = state_78225;
(statearr_78241[(7)] = inst_78218);

return statearr_78241;
})();
var statearr_78242_78257 = state_78225__$1;
(statearr_78242_78257[(2)] = inst_78220);

(statearr_78242_78257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_78243 = [null,null,null,null,null,null,null,null];
(statearr_78243[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_78243[(1)] = (1));

return statearr_78243;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_78225){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_78225);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e78244){var ex__2730__auto__ = e78244;
var statearr_78245_78258 = state_78225;
(statearr_78245_78258[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_78225[(4)]))){
var statearr_78246_78259 = state_78225;
(statearr_78246_78259[(1)] = cljs.core.first((state_78225[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78260 = state_78225;
state_78225 = G__78260;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_78225){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_78225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_78247 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_78247[(6)] = c__2749__auto__);

return statearr_78247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

