// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.query.fql_resp');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___78337 = arguments.length;
var i__5770__auto___78338 = (0);
while(true){
if((i__5770__auto___78338 < len__5769__auto___78337)){
args__5775__auto__.push((arguments[i__5770__auto___78338]));

var G__78339 = (i__5770__auto___78338 + (1));
i__5770__auto___78338 = G__78339;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__78266){
var vec__78267 = p__78266;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78267,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___78340 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_78314){
var state_val_78315 = (state_78314[(1)]);
if((state_val_78315 === (7))){
var inst_78291 = (state_78314[(7)]);
var inst_78300 = (state_78314[(8)]);
var inst_78302 = fluree.db.time_travel.as_of_block(inst_78300,inst_78291);
var state_78314__$1 = state_78314;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78314__$1,(10),inst_78302);
} else {
if((state_val_78315 === (1))){
var state_78314__$1 = state_78314;
var statearr_78316_78341 = state_78314__$1;
(statearr_78316_78341[(2)] = null);

(statearr_78316_78341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78315 === (4))){
var inst_78270 = (state_78314[(2)]);
var inst_78271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78272 = [inst_78270];
var inst_78273 = (new cljs.core.PersistentVector(null,1,(5),inst_78271,inst_78272,null));
var inst_78274 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78273);
var inst_78275 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_78270);
var inst_78276 = cljs.core.async.close_BANG_(pc);
var state_78314__$1 = (function (){var statearr_78317 = state_78314;
(statearr_78317[(9)] = inst_78275);

(statearr_78317[(10)] = inst_78274);

return statearr_78317;
})();
var statearr_78318_78342 = state_78314__$1;
(statearr_78318_78342[(2)] = inst_78276);

(statearr_78318_78342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78315 === (6))){
var inst_78291 = (state_78314[(7)]);
var inst_78294 = (state_78314[(11)]);
var inst_78295 = (state_78314[(12)]);
var inst_78298 = (state_78314[(2)]);
var inst_78299 = fluree.db.util.async.throw_err(inst_78298);
var inst_78300 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_78299,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_78294,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_78295], 0));
var state_78314__$1 = (function (){var statearr_78319 = state_78314;
(statearr_78319[(8)] = inst_78300);

return statearr_78319;
})();
if(cljs.core.truth_(inst_78291)){
var statearr_78320_78343 = state_78314__$1;
(statearr_78320_78343[(1)] = (7));

} else {
var statearr_78321_78344 = state_78314__$1;
(statearr_78321_78344[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78315 === (3))){
var inst_78312 = (state_78314[(2)]);
var state_78314__$1 = state_78314;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78314__$1,inst_78312);
} else {
if((state_val_78315 === (2))){
var _ = (function (){var statearr_78323 = state_78314;
(statearr_78323[(4)] = cljs.core.cons((5),(state_78314[(4)])));

return statearr_78323;
})();
var inst_78286 = opts;
var inst_78287 = cljs.core.__destructure_map(inst_78286);
var inst_78288 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78287,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_78289 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78287,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_78290 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78287,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_78291 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78287,new cljs.core.Keyword(null,"block","block",664686210));
var inst_78292 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_78293 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_78294 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78293,(0),null);
var inst_78295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78293,(1),null);
var inst_78296 = fluree.db.session.db(conn,ledger,opts);
var state_78314__$1 = (function (){var statearr_78324 = state_78314;
(statearr_78324[(7)] = inst_78291);

(statearr_78324[(13)] = inst_78289);

(statearr_78324[(14)] = inst_78288);

(statearr_78324[(11)] = inst_78294);

(statearr_78324[(15)] = inst_78290);

(statearr_78324[(16)] = inst_78292);

(statearr_78324[(12)] = inst_78295);

return statearr_78324;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78314__$1,(6),inst_78296);
} else {
if((state_val_78315 === (9))){
var inst_78308 = (state_78314[(2)]);
var inst_78309 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_78308);
var _ = (function (){var statearr_78325 = state_78314;
(statearr_78325[(4)] = cljs.core.rest((state_78314[(4)])));

return statearr_78325;
})();
var state_78314__$1 = state_78314;
var statearr_78326_78345 = state_78314__$1;
(statearr_78326_78345[(2)] = inst_78309);

(statearr_78326_78345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78315 === (5))){
var _ = (function (){var statearr_78327 = state_78314;
(statearr_78327[(4)] = cljs.core.rest((state_78314[(4)])));

return statearr_78327;
})();
var state_78314__$1 = state_78314;
var ex78322 = (state_78314__$1[(2)]);
var statearr_78328_78346 = state_78314__$1;
(statearr_78328_78346[(5)] = ex78322);


var statearr_78329_78347 = state_78314__$1;
(statearr_78329_78347[(1)] = (4));

(statearr_78329_78347[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78315 === (10))){
var inst_78304 = (state_78314[(2)]);
var inst_78305 = fluree.db.util.async.throw_err(inst_78304);
var state_78314__$1 = state_78314;
var statearr_78330_78348 = state_78314__$1;
(statearr_78330_78348[(2)] = inst_78305);

(statearr_78330_78348[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78315 === (8))){
var inst_78300 = (state_78314[(8)]);
var state_78314__$1 = state_78314;
var statearr_78331_78349 = state_78314__$1;
(statearr_78331_78349[(2)] = inst_78300);

(statearr_78331_78349[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_78332 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78332[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_78332[(1)] = (1));

return statearr_78332;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_78314){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_78314);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e78333){var ex__2730__auto__ = e78333;
var statearr_78334_78350 = state_78314;
(statearr_78334_78350[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_78314[(4)]))){
var statearr_78335_78351 = state_78314;
(statearr_78335_78351[(1)] = cljs.core.first((state_78314[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78352 = state_78314;
state_78314 = G__78352;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_78314){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_78314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_78336 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_78336[(6)] = c__2749__auto___78340);

return statearr_78336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq78263){
var G__78264 = cljs.core.first(seq78263);
var seq78263__$1 = cljs.core.next(seq78263);
var G__78265 = cljs.core.first(seq78263__$1);
var seq78263__$2 = cljs.core.next(seq78263__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__78264,G__78265,seq78263__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(ledger_id){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__78354 = arguments.length;
switch (G__78354) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_78483){
var state_val_78484 = (state_78483[(1)]);
if((state_val_78484 === (7))){
var inst_78383 = (state_78483[(7)]);
var inst_78373 = (state_78483[(8)]);
var inst_78385 = fluree.db.time_travel.as_of_block(inst_78383,inst_78373);
var state_78483__$1 = state_78483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78483__$1,(10),inst_78385);
} else {
if((state_val_78484 === (20))){
var inst_78377 = (state_78483[(9)]);
var state_78483__$1 = state_78483;
var statearr_78485_78565 = state_78483__$1;
(statearr_78485_78565[(2)] = inst_78377);

(statearr_78485_78565[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (27))){
var inst_78371 = (state_78483[(10)]);
var state_78483__$1 = state_78483;
var statearr_78486_78566 = state_78483__$1;
(statearr_78486_78566[(2)] = inst_78371);

(statearr_78486_78566[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (1))){
var state_78483__$1 = state_78483;
var statearr_78487_78567 = state_78483__$1;
(statearr_78487_78567[(2)] = null);

(statearr_78487_78567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (24))){
var inst_78380 = (state_78483[(11)]);
var state_78483__$1 = state_78483;
if(cljs.core.truth_(inst_78380)){
var statearr_78488_78568 = state_78483__$1;
(statearr_78488_78568[(1)] = (26));

} else {
var statearr_78489_78569 = state_78483__$1;
(statearr_78489_78569[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (39))){
var inst_78445 = (state_78483[(12)]);
var inst_78448 = cljs.core.ex_data(inst_78445);
var inst_78449 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78450 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_78448);
var inst_78451 = cljs.core.ex_message(inst_78445);
var inst_78452 = [inst_78450,inst_78451,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_78453 = cljs.core.PersistentHashMap.fromArrays(inst_78449,inst_78452);
var state_78483__$1 = state_78483;
var statearr_78490_78570 = state_78483__$1;
(statearr_78490_78570[(2)] = inst_78453);

(statearr_78490_78570[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (46))){
var inst_78445 = (state_78483[(12)]);
var state_78483__$1 = state_78483;
var statearr_78491_78571 = state_78483__$1;
(statearr_78491_78571[(2)] = inst_78445);

(statearr_78491_78571[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (4))){
var inst_78355 = (state_78483[(2)]);
var inst_78356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78357 = [inst_78355];
var inst_78358 = (new cljs.core.PersistentVector(null,1,(5),inst_78356,inst_78357,null));
var inst_78359 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78358);
var inst_78360 = cljs.core.ex_data(inst_78355);
var inst_78361 = cljs.core.ex_message(inst_78355);
var inst_78362 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_78360,new cljs.core.Keyword(null,"message","message",-406056002),inst_78361);
var state_78483__$1 = (function (){var statearr_78492 = state_78483;
(statearr_78492[(13)] = inst_78359);

return statearr_78492;
})();
var statearr_78493_78572 = state_78483__$1;
(statearr_78493_78572[(2)] = inst_78362);

(statearr_78493_78572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (15))){
var state_78483__$1 = state_78483;
var statearr_78494_78573 = state_78483__$1;
(statearr_78494_78573[(2)] = (1000000));

(statearr_78494_78573[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (48))){
var inst_78445 = (state_78483[(12)]);
var state_78483__$1 = state_78483;
var statearr_78495_78574 = state_78483__$1;
(statearr_78495_78574[(2)] = inst_78445);

(statearr_78495_78574[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (50))){
var inst_78472 = (state_78483[(2)]);
var state_78483__$1 = state_78483;
var statearr_78496_78575 = state_78483__$1;
(statearr_78496_78575[(2)] = inst_78472);

(statearr_78496_78575[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (21))){
var inst_78376 = (state_78483[(14)]);
var state_78483__$1 = state_78483;
if(cljs.core.truth_(inst_78376)){
var statearr_78497_78576 = state_78483__$1;
(statearr_78497_78576[(1)] = (23));

} else {
var statearr_78498_78577 = state_78483__$1;
(statearr_78498_78577[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (31))){
var inst_78434 = (state_78483[(2)]);
var inst_78435 = cljs.core.not(inst_78434);
var state_78483__$1 = state_78483;
if(inst_78435){
var statearr_78499_78578 = state_78483__$1;
(statearr_78499_78578[(1)] = (35));

} else {
var statearr_78500_78579 = state_78483__$1;
(statearr_78500_78579[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (32))){
var inst_78378 = (state_78483[(15)]);
var state_78483__$1 = state_78483;
var statearr_78501_78580 = state_78483__$1;
(statearr_78501_78580[(2)] = inst_78378);

(statearr_78501_78580[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (40))){
var inst_78408 = (state_78483[(16)]);
var state_78483__$1 = state_78483;
if(cljs.core.truth_(inst_78408)){
var statearr_78502_78581 = state_78483__$1;
(statearr_78502_78581[(1)] = (42));

} else {
var statearr_78503_78582 = state_78483__$1;
(statearr_78503_78582[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (33))){
var inst_78374 = (state_78483[(17)]);
var state_78483__$1 = state_78483;
var statearr_78504_78583 = state_78483__$1;
(statearr_78504_78583[(2)] = inst_78374);

(statearr_78504_78583[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (13))){
var inst_78403 = (state_78483[(18)]);
var inst_78379 = (state_78483[(19)]);
var inst_78401 = (state_78483[(2)]);
var inst_78402 = cljs.core.volatile_BANG_((0));
var inst_78403__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_78379);
var state_78483__$1 = (function (){var statearr_78505 = state_78483;
(statearr_78505[(18)] = inst_78403__$1);

(statearr_78505[(20)] = inst_78401);

(statearr_78505[(21)] = inst_78402);

return statearr_78505;
})();
if(cljs.core.truth_(inst_78403__$1)){
var statearr_78506_78584 = state_78483__$1;
(statearr_78506_78584[(1)] = (14));

} else {
var statearr_78507_78585 = state_78483__$1;
(statearr_78507_78585[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (22))){
var inst_78424 = (state_78483[(2)]);
var state_78483__$1 = state_78483;
var statearr_78508_78586 = state_78483__$1;
(statearr_78508_78586[(2)] = inst_78424);

(statearr_78508_78586[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (36))){
var inst_78391 = (state_78483[(22)]);
var inst_78410 = (state_78483[(23)]);
var inst_78441 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_78410);
var inst_78442 = fluree.db.query.fql.query(inst_78391,inst_78441);
var state_78483__$1 = state_78483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78483__$1,(38),inst_78442);
} else {
if((state_val_78484 === (41))){
var inst_78476 = (state_78483[(2)]);
var state_78483__$1 = state_78483;
var statearr_78509_78587 = state_78483__$1;
(statearr_78509_78587[(2)] = inst_78476);

(statearr_78509_78587[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (43))){
var state_78483__$1 = state_78483;
var statearr_78510_78588 = state_78483__$1;
(statearr_78510_78588[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (29))){
var inst_78378 = (state_78483[(15)]);
var state_78483__$1 = state_78483;
if(cljs.core.truth_(inst_78378)){
var statearr_78512_78589 = state_78483__$1;
(statearr_78512_78589[(1)] = (32));

} else {
var statearr_78513_78590 = state_78483__$1;
(statearr_78513_78590[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (44))){
var inst_78474 = (state_78483[(2)]);
var state_78483__$1 = state_78483;
var statearr_78514_78591 = state_78483__$1;
(statearr_78514_78591[(2)] = inst_78474);

(statearr_78514_78591[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (6))){
var inst_78373 = (state_78483[(8)]);
var inst_78382 = (state_78483[(2)]);
var inst_78383 = fluree.db.util.async.throw_err(inst_78382);
var state_78483__$1 = (function (){var statearr_78515 = state_78483;
(statearr_78515[(7)] = inst_78383);

return statearr_78515;
})();
if(cljs.core.truth_(inst_78373)){
var statearr_78516_78592 = state_78483__$1;
(statearr_78516_78592[(1)] = (7));

} else {
var statearr_78517_78593 = state_78483__$1;
(statearr_78517_78593[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (28))){
var inst_78420 = (state_78483[(2)]);
var state_78483__$1 = state_78483;
var statearr_78518_78594 = state_78483__$1;
(statearr_78518_78594[(2)] = inst_78420);

(statearr_78518_78594[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (25))){
var inst_78422 = (state_78483[(2)]);
var state_78483__$1 = state_78483;
var statearr_78519_78595 = state_78483__$1;
(statearr_78519_78595[(2)] = inst_78422);

(statearr_78519_78595[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (34))){
var inst_78431 = (state_78483[(2)]);
var state_78483__$1 = state_78483;
var statearr_78520_78596 = state_78483__$1;
(statearr_78520_78596[(2)] = inst_78431);

(statearr_78520_78596[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (17))){
var inst_78372 = (state_78483[(24)]);
var state_78483__$1 = state_78483;
var statearr_78521_78597 = state_78483__$1;
(statearr_78521_78597[(2)] = inst_78372);

(statearr_78521_78597[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (3))){
var inst_78481 = (state_78483[(2)]);
var state_78483__$1 = state_78483;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78483__$1,inst_78481);
} else {
if((state_val_78484 === (12))){
var inst_78399 = cljs.core.PersistentHashMap.EMPTY;
var state_78483__$1 = state_78483;
var statearr_78522_78598 = state_78483__$1;
(statearr_78522_78598[(2)] = inst_78399);

(statearr_78522_78598[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (2))){
var _ = (function (){var statearr_78523 = state_78483;
(statearr_78523[(4)] = cljs.core.cons((5),(state_78483[(4)])));

return statearr_78523;
})();
var inst_78369 = query_map;
var inst_78370 = cljs.core.__destructure_map(inst_78369);
var inst_78371 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78370,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_78372 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78370,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_78373 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78370,new cljs.core.Keyword(null,"block","block",664686210));
var inst_78374 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78370,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_78375 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78370,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_78376 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78370,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_78377 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78370,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_78378 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78370,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_78379 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78370,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_78380 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78370,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_78483__$1 = (function (){var statearr_78524 = state_78483;
(statearr_78524[(10)] = inst_78371);

(statearr_78524[(15)] = inst_78378);

(statearr_78524[(14)] = inst_78376);

(statearr_78524[(17)] = inst_78374);

(statearr_78524[(8)] = inst_78373);

(statearr_78524[(9)] = inst_78377);

(statearr_78524[(11)] = inst_78380);

(statearr_78524[(19)] = inst_78379);

(statearr_78524[(24)] = inst_78372);

(statearr_78524[(25)] = inst_78375);

return statearr_78524;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78483__$1,(6),sources);
} else {
if((state_val_78484 === (23))){
var inst_78376 = (state_78483[(14)]);
var state_78483__$1 = state_78483;
var statearr_78525_78599 = state_78483__$1;
(statearr_78525_78599[(2)] = inst_78376);

(statearr_78525_78599[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (47))){
var inst_78456 = (state_78483[(26)]);
var inst_78391 = (state_78483[(22)]);
var inst_78402 = (state_78483[(21)]);
var inst_78409 = (state_78483[(27)]);
var inst_78462 = (state_78483[(2)]);
var inst_78463 = cljs.core.deref(inst_78402);
var inst_78464 = fluree.db.util.core.response_time_formatted(inst_78409);
var inst_78465 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_78391);
var inst_78466 = [(200),inst_78462,inst_78463,inst_78464,inst_78465];
var inst_78467 = cljs.core.PersistentHashMap.fromArrays(inst_78456,inst_78466);
var state_78483__$1 = state_78483;
var statearr_78526_78600 = state_78483__$1;
(statearr_78526_78600[(2)] = inst_78467);

(statearr_78526_78600[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (35))){
var inst_78437 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78438 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_78439 = cljs.core.PersistentHashMap.fromArrays(inst_78437,inst_78438);
var state_78483__$1 = state_78483;
var statearr_78527_78601 = state_78483__$1;
(statearr_78527_78601[(2)] = inst_78439);

(statearr_78527_78601[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (19))){
var inst_78426 = (state_78483[(28)]);
var inst_78426__$1 = (state_78483[(2)]);
var state_78483__$1 = (function (){var statearr_78528 = state_78483;
(statearr_78528[(28)] = inst_78426__$1);

return statearr_78528;
})();
if(cljs.core.truth_(inst_78426__$1)){
var statearr_78529_78602 = state_78483__$1;
(statearr_78529_78602[(1)] = (29));

} else {
var statearr_78530_78603 = state_78483__$1;
(statearr_78530_78603[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (11))){
var inst_78392 = (state_78483[(29)]);
var inst_78391 = (state_78483[(22)]);
var inst_78375 = (state_78483[(25)]);
var inst_78394 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_78391);
var inst_78395 = fluree.db.connection_js.open_api_QMARK_(inst_78392);
var inst_78396 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_78391);
var inst_78397 = fluree.db.api_js.get_sources(inst_78392,inst_78394,inst_78395,inst_78396,inst_78375,db_fn);
var state_78483__$1 = state_78483;
var statearr_78532_78604 = state_78483__$1;
(statearr_78532_78604[(2)] = inst_78397);

(statearr_78532_78604[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (9))){
var inst_78391 = (state_78483[(22)]);
var inst_78375 = (state_78483[(25)]);
var inst_78391__$1 = (state_78483[(2)]);
var inst_78392 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_78391__$1);
var state_78483__$1 = (function (){var statearr_78533 = state_78483;
(statearr_78533[(29)] = inst_78392);

(statearr_78533[(22)] = inst_78391__$1);

return statearr_78533;
})();
if(cljs.core.truth_(inst_78375)){
var statearr_78534_78605 = state_78483__$1;
(statearr_78534_78605[(1)] = (11));

} else {
var statearr_78535_78606 = state_78483__$1;
(statearr_78535_78606[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (5))){
var _ = (function (){var statearr_78536 = state_78483;
(statearr_78536[(4)] = cljs.core.rest((state_78483[(4)])));

return statearr_78536;
})();
var state_78483__$1 = state_78483;
var ex78531 = (state_78483__$1[(2)]);
var statearr_78537_78607 = state_78483__$1;
(statearr_78537_78607[(5)] = ex78531);


var statearr_78538_78608 = state_78483__$1;
(statearr_78538_78608[(1)] = (4));

(statearr_78538_78608[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (14))){
var inst_78403 = (state_78483[(18)]);
var state_78483__$1 = state_78483;
var statearr_78539_78609 = state_78483__$1;
(statearr_78539_78609[(2)] = inst_78403);

(statearr_78539_78609[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (45))){
var inst_78445 = (state_78483[(12)]);
var inst_78459 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_78445);
var state_78483__$1 = state_78483;
var statearr_78540_78610 = state_78483__$1;
(statearr_78540_78610[(2)] = inst_78459);

(statearr_78540_78610[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (26))){
var inst_78380 = (state_78483[(11)]);
var state_78483__$1 = state_78483;
var statearr_78541_78611 = state_78483__$1;
(statearr_78541_78611[(2)] = inst_78380);

(statearr_78541_78611[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (16))){
var inst_78379 = (state_78483[(19)]);
var inst_78401 = (state_78483[(20)]);
var inst_78372 = (state_78483[(24)]);
var inst_78402 = (state_78483[(21)]);
var inst_78407 = (state_78483[(2)]);
var inst_78408 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_78379);
var inst_78409 = fluree.db.util.core.current_time_millis();
var inst_78410 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_78379,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_78401,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_78407,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_78402], 0));
var state_78483__$1 = (function (){var statearr_78542 = state_78483;
(statearr_78542[(16)] = inst_78408);

(statearr_78542[(23)] = inst_78410);

(statearr_78542[(27)] = inst_78409);

return statearr_78542;
})();
if(cljs.core.truth_(inst_78372)){
var statearr_78543_78612 = state_78483__$1;
(statearr_78543_78612[(1)] = (17));

} else {
var statearr_78544_78613 = state_78483__$1;
(statearr_78544_78613[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (38))){
var inst_78445 = (state_78483[(12)]);
var inst_78444 = (state_78483[(2)]);
var inst_78445__$1 = fluree.db.util.async.throw_err(inst_78444);
var inst_78446 = (inst_78445__$1 instanceof cljs.core.ExceptionInfo);
var state_78483__$1 = (function (){var statearr_78545 = state_78483;
(statearr_78545[(12)] = inst_78445__$1);

return statearr_78545;
})();
if(cljs.core.truth_(inst_78446)){
var statearr_78546_78614 = state_78483__$1;
(statearr_78546_78614[(1)] = (39));

} else {
var statearr_78547_78615 = state_78483__$1;
(statearr_78547_78615[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (30))){
var inst_78426 = (state_78483[(28)]);
var state_78483__$1 = state_78483;
var statearr_78548_78616 = state_78483__$1;
(statearr_78548_78616[(2)] = inst_78426);

(statearr_78548_78616[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (10))){
var inst_78387 = (state_78483[(2)]);
var inst_78388 = fluree.db.util.async.throw_err(inst_78387);
var state_78483__$1 = state_78483;
var statearr_78549_78617 = state_78483__$1;
(statearr_78549_78617[(2)] = inst_78388);

(statearr_78549_78617[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (18))){
var inst_78377 = (state_78483[(9)]);
var state_78483__$1 = state_78483;
if(cljs.core.truth_(inst_78377)){
var statearr_78550_78618 = state_78483__$1;
(statearr_78550_78618[(1)] = (20));

} else {
var statearr_78551_78619 = state_78483__$1;
(statearr_78551_78619[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (42))){
var inst_78445 = (state_78483[(12)]);
var inst_78456 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_78457 = cljs.core.sequential_QMARK_(inst_78445);
var state_78483__$1 = (function (){var statearr_78552 = state_78483;
(statearr_78552[(26)] = inst_78456);

return statearr_78552;
})();
if(inst_78457){
var statearr_78553_78620 = state_78483__$1;
(statearr_78553_78620[(1)] = (45));

} else {
var statearr_78554_78621 = state_78483__$1;
(statearr_78554_78621[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (37))){
var inst_78478 = (state_78483[(2)]);
var _ = (function (){var statearr_78555 = state_78483;
(statearr_78555[(4)] = cljs.core.rest((state_78483[(4)])));

return statearr_78555;
})();
var state_78483__$1 = state_78483;
var statearr_78556_78622 = state_78483__$1;
(statearr_78556_78622[(2)] = inst_78478);

(statearr_78556_78622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (8))){
var inst_78383 = (state_78483[(7)]);
var state_78483__$1 = state_78483;
var statearr_78557_78623 = state_78483__$1;
(statearr_78557_78623[(2)] = inst_78383);

(statearr_78557_78623[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78484 === (49))){
var state_78483__$1 = state_78483;
var statearr_78558_78624 = state_78483__$1;
(statearr_78558_78624[(2)] = null);

(statearr_78558_78624[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_78559 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78559[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_78559[(1)] = (1));

return statearr_78559;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_78483){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_78483);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e78560){var ex__2730__auto__ = e78560;
var statearr_78561_78625 = state_78483;
(statearr_78561_78625[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_78483[(4)]))){
var statearr_78562_78626 = state_78483;
(statearr_78562_78626[(1)] = cljs.core.first((state_78483[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78627 = state_78483;
state_78483 = G__78627;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_78483){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_78483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_78563 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_78563[(6)] = c__2749__auto__);

return statearr_78563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__78628_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__78628_SHARP_);
}));

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_78650){
var state_val_78651 = (state_78650[(1)]);
if((state_val_78651 === (1))){
var inst_78632 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78633 = [resp_chan,timeout_chan];
var inst_78634 = (new cljs.core.PersistentVector(null,2,(5),inst_78632,inst_78633,null));
var state_78650__$1 = state_78650;
return cljs.core.async.ioc_alts_BANG_(state_78650__$1,(2),inst_78634);
} else {
if((state_val_78651 === (2))){
var inst_78636 = (state_78650[(2)]);
var inst_78637 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78636,(0),null);
var inst_78638 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_78636,(1),null);
var inst_78639 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_78638);
var state_78650__$1 = (function (){var statearr_78652 = state_78650;
(statearr_78652[(7)] = inst_78637);

return statearr_78652;
})();
if(inst_78639){
var statearr_78653_78663 = state_78650__$1;
(statearr_78653_78663[(1)] = (3));

} else {
var statearr_78654_78664 = state_78650__$1;
(statearr_78654_78664[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78651 === (3))){
var inst_78641 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_78642 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_78643 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_78644 = [tid,(408),inst_78643];
var inst_78645 = cljs.core.PersistentHashMap.fromArrays(inst_78642,inst_78644);
var state_78650__$1 = (function (){var statearr_78655 = state_78650;
(statearr_78655[(8)] = inst_78641);

return statearr_78655;
})();
var statearr_78656_78665 = state_78650__$1;
(statearr_78656_78665[(2)] = inst_78645);

(statearr_78656_78665[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78651 === (4))){
var inst_78637 = (state_78650[(7)]);
var state_78650__$1 = state_78650;
var statearr_78657_78666 = state_78650__$1;
(statearr_78657_78666[(2)] = inst_78637);

(statearr_78657_78666[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78651 === (5))){
var inst_78648 = (state_78650[(2)]);
var state_78650__$1 = state_78650;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78650__$1,inst_78648);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0 = (function (){
var statearr_78658 = [null,null,null,null,null,null,null,null,null];
(statearr_78658[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__);

(statearr_78658[(1)] = (1));

return statearr_78658;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1 = (function (state_78650){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_78650);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e78659){var ex__2730__auto__ = e78659;
var statearr_78660_78667 = state_78650;
(statearr_78660_78667[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_78650[(4)]))){
var statearr_78661_78668 = state_78650;
(statearr_78661_78668[(1)] = cljs.core.first((state_78650[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78669 = state_78650;
state_78650 = G__78669;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__ = function(state_78650){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1.call(this,state_78650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_78662 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_78662[(6)] = c__2749__auto__);

return statearr_78662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__78671 = arguments.length;
switch (G__78671) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__78672 = opts;
var map__78672__$1 = cljs.core.__destructure_map(map__78672);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78672__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78672__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78672__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78672__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__78673 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78673,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78673,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e78676){var e = e78676;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__78679 = arguments.length;
switch (G__78679) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_78748){
var state_val_78749 = (state_78748[(1)]);
if((state_val_78749 === (7))){
var inst_78704 = (state_78748[(7)]);
var inst_78703 = (state_78748[(8)]);
var inst_78699 = (state_78748[(9)]);
var inst_78702 = (state_78748[(10)]);
var inst_78701 = (state_78748[(11)]);
var inst_78717 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_78718 = [ledger,txn,inst_78699,inst_78701,inst_78702,inst_78703,inst_78704];
var inst_78719 = cljs.core.PersistentHashMap.fromArrays(inst_78717,inst_78718);
var inst_78720 = fluree.db.util.core.without_nils(inst_78719);
var inst_78721 = fluree.db.operations.transact_async(conn,inst_78720);
var state_78748__$1 = state_78748;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78748__$1,(13),inst_78721);
} else {
if((state_val_78749 === (20))){
var inst_78739 = (state_78748[(2)]);
var state_78748__$1 = state_78748;
var statearr_78750_78786 = state_78748__$1;
(statearr_78750_78786[(2)] = inst_78739);

(statearr_78750_78786[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (1))){
var state_78748__$1 = state_78748;
var statearr_78751_78787 = state_78748__$1;
(statearr_78751_78787[(2)] = null);

(statearr_78751_78787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (4))){
var inst_78680 = (state_78748[(2)]);
var inst_78681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78682 = [inst_78680];
var inst_78683 = (new cljs.core.PersistentVector(null,1,(5),inst_78681,inst_78682,null));
var inst_78684 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78683);
var inst_78685 = cljs.core.ex_data(inst_78680);
var inst_78686 = cljs.core.ex_message(inst_78680);
var inst_78687 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_78685,new cljs.core.Keyword(null,"message","message",-406056002),inst_78686);
var state_78748__$1 = (function (){var statearr_78752 = state_78748;
(statearr_78752[(12)] = inst_78684);

return statearr_78752;
})();
var statearr_78753_78788 = state_78748__$1;
(statearr_78753_78788[(2)] = inst_78687);

(statearr_78753_78788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (15))){
var inst_78698 = (state_78748[(13)]);
var inst_78723 = (state_78748[(14)]);
var inst_78726 = fluree.db.api_js.monitor_tx(conn,ledger,inst_78723,inst_78698);
var state_78748__$1 = state_78748;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78748__$1,(17),inst_78726);
} else {
if((state_val_78749 === (13))){
var inst_78697 = (state_78748[(15)]);
var inst_78723 = (state_78748[(2)]);
var state_78748__$1 = (function (){var statearr_78754 = state_78748;
(statearr_78754[(14)] = inst_78723);

return statearr_78754;
})();
if(cljs.core.truth_(inst_78697)){
var statearr_78755_78789 = state_78748__$1;
(statearr_78755_78789[(1)] = (14));

} else {
var statearr_78756_78790 = state_78748__$1;
(statearr_78756_78790[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (6))){
var inst_78697 = (state_78748[(15)]);
var inst_78696 = (state_78748[(16)]);
var inst_78706 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_78696,opts);
var inst_78707 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_78706);
var inst_78708 = fluree.db.operations.command_async(conn,inst_78706);
var state_78748__$1 = (function (){var statearr_78757 = state_78748;
(statearr_78757[(17)] = inst_78708);

(statearr_78757[(18)] = inst_78707);

return statearr_78757;
})();
if(cljs.core.truth_(inst_78697)){
var statearr_78758_78791 = state_78748__$1;
(statearr_78758_78791[(1)] = (9));

} else {
var statearr_78759_78792 = state_78748__$1;
(statearr_78759_78792[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (17))){
var inst_78728 = (state_78748[(19)]);
var inst_78728__$1 = (state_78748[(2)]);
var inst_78729 = (inst_78728__$1 instanceof cljs.core.ExceptionInfo);
var state_78748__$1 = (function (){var statearr_78760 = state_78748;
(statearr_78760[(19)] = inst_78728__$1);

return statearr_78760;
})();
if(cljs.core.truth_(inst_78729)){
var statearr_78761_78793 = state_78748__$1;
(statearr_78761_78793[(1)] = (18));

} else {
var statearr_78762_78794 = state_78748__$1;
(statearr_78762_78794[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (3))){
var inst_78746 = (state_78748[(2)]);
var state_78748__$1 = state_78748;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78748__$1,inst_78746);
} else {
if((state_val_78749 === (12))){
var inst_78713 = (state_78748[(2)]);
var state_78748__$1 = state_78748;
var statearr_78763_78795 = state_78748__$1;
(statearr_78763_78795[(2)] = inst_78713);

(statearr_78763_78795[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (2))){
var inst_78696 = (state_78748[(16)]);
var _ = (function (){var statearr_78764 = state_78748;
(statearr_78764[(4)] = cljs.core.cons((5),(state_78748[(4)])));

return statearr_78764;
})();
var inst_78694 = opts;
var inst_78695 = cljs.core.__destructure_map(inst_78694);
var inst_78696__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78695,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_78697 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78695,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_78698 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_78695,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_78699 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78695,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_78700 = fluree.db.util.core.current_time_millis();
var inst_78701 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_78695,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_78700);
var inst_78702 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78695,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_78703 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78695,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_78704 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_78695,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_78748__$1 = (function (){var statearr_78765 = state_78748;
(statearr_78765[(13)] = inst_78698);

(statearr_78765[(15)] = inst_78697);

(statearr_78765[(7)] = inst_78704);

(statearr_78765[(8)] = inst_78703);

(statearr_78765[(9)] = inst_78699);

(statearr_78765[(10)] = inst_78702);

(statearr_78765[(16)] = inst_78696__$1);

(statearr_78765[(11)] = inst_78701);

return statearr_78765;
})();
if(cljs.core.truth_(inst_78696__$1)){
var statearr_78766_78796 = state_78748__$1;
(statearr_78766_78796[(1)] = (6));

} else {
var statearr_78767_78797 = state_78748__$1;
(statearr_78767_78797[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (19))){
var inst_78728 = (state_78748[(19)]);
var state_78748__$1 = state_78748;
var statearr_78768_78798 = state_78748__$1;
(statearr_78768_78798[(2)] = inst_78728);

(statearr_78768_78798[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (11))){
var inst_78715 = (state_78748[(2)]);
var state_78748__$1 = state_78748;
var statearr_78770_78799 = state_78748__$1;
(statearr_78770_78799[(2)] = inst_78715);

(statearr_78770_78799[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (9))){
var inst_78708 = (state_78748[(17)]);
var state_78748__$1 = state_78748;
var statearr_78771_78800 = state_78748__$1;
(statearr_78771_78800[(2)] = inst_78708);

(statearr_78771_78800[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (5))){
var _ = (function (){var statearr_78772 = state_78748;
(statearr_78772[(4)] = cljs.core.rest((state_78748[(4)])));

return statearr_78772;
})();
var state_78748__$1 = state_78748;
var ex78769 = (state_78748__$1[(2)]);
var statearr_78773_78801 = state_78748__$1;
(statearr_78773_78801[(5)] = ex78769);


var statearr_78774_78802 = state_78748__$1;
(statearr_78774_78802[(1)] = (4));

(statearr_78774_78802[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (14))){
var inst_78723 = (state_78748[(14)]);
var state_78748__$1 = state_78748;
var statearr_78775_78803 = state_78748__$1;
(statearr_78775_78803[(2)] = inst_78723);

(statearr_78775_78803[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (16))){
var inst_78741 = (state_78748[(2)]);
var state_78748__$1 = state_78748;
var statearr_78776_78804 = state_78748__$1;
(statearr_78776_78804[(2)] = inst_78741);

(statearr_78776_78804[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (10))){
var inst_78698 = (state_78748[(13)]);
var inst_78707 = (state_78748[(18)]);
var inst_78711 = fluree.db.api_js.monitor_tx(conn,ledger,inst_78707,inst_78698);
var state_78748__$1 = state_78748;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78748__$1,(12),inst_78711);
} else {
if((state_val_78749 === (18))){
var inst_78728 = (state_78748[(19)]);
var inst_78731 = cljs.core.ex_data(inst_78728);
var inst_78732 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78733 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_78731);
var inst_78734 = cljs.core.ex_message(inst_78728);
var inst_78735 = [inst_78733,inst_78734,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_78736 = cljs.core.PersistentHashMap.fromArrays(inst_78732,inst_78735);
var state_78748__$1 = state_78748;
var statearr_78777_78805 = state_78748__$1;
(statearr_78777_78805[(2)] = inst_78736);

(statearr_78777_78805[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78749 === (8))){
var inst_78743 = (state_78748[(2)]);
var _ = (function (){var statearr_78778 = state_78748;
(statearr_78778[(4)] = cljs.core.rest((state_78748[(4)])));

return statearr_78778;
})();
var state_78748__$1 = state_78748;
var statearr_78779_78806 = state_78748__$1;
(statearr_78779_78806[(2)] = inst_78743);

(statearr_78779_78806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_78780 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78780[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_78780[(1)] = (1));

return statearr_78780;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_78748){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_78748);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e78781){var ex__2730__auto__ = e78781;
var statearr_78782_78807 = state_78748;
(statearr_78782_78807[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_78748[(4)]))){
var statearr_78783_78808 = state_78748;
(statearr_78783_78808[(1)] = cljs.core.first((state_78748[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78809 = state_78748;
state_78748 = G__78809;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_78748){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_78748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_78784 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_78784[(6)] = c__2749__auto__);

return statearr_78784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___78811 = arguments.length;
var i__5770__auto___78812 = (0);
while(true){
if((i__5770__auto___78812 < len__5769__auto___78811)){
args__5775__auto__.push((arguments[i__5770__auto___78812]));

var G__78813 = (i__5770__auto___78812 + (1));
i__5770__auto___78812 = G__78813;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq78810){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq78810));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_78844){
var state_val_78845 = (state_78844[(1)]);
if((state_val_78845 === (1))){
var inst_78814 = cljs.core.first(flakes);
var inst_78815 = cljs.core.rest(flakes);
var inst_78816 = cljs.core.PersistentVector.EMPTY;
var inst_78817 = inst_78814;
var inst_78818 = inst_78815;
var inst_78819 = inst_78816;
var state_78844__$1 = (function (){var statearr_78846 = state_78844;
(statearr_78846[(7)] = inst_78819);

(statearr_78846[(8)] = inst_78817);

(statearr_78846[(9)] = inst_78818);

return statearr_78846;
})();
var statearr_78847_78860 = state_78844__$1;
(statearr_78847_78860[(2)] = null);

(statearr_78847_78860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (2))){
var inst_78817 = (state_78844[(8)]);
var inst_78821 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_78822 = cljs.core.PersistentHashMap.EMPTY;
var inst_78823 = [true,inst_78822];
var inst_78824 = cljs.core.PersistentHashMap.fromArrays(inst_78821,inst_78823);
var inst_78825 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_78824,inst_78817);
var state_78844__$1 = state_78844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78844__$1,(4),inst_78825);
} else {
if((state_val_78845 === (3))){
var inst_78842 = (state_78844[(2)]);
var state_78844__$1 = state_78844;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78844__$1,inst_78842);
} else {
if((state_val_78845 === (4))){
var inst_78819 = (state_78844[(7)]);
var inst_78818 = (state_78844[(9)]);
var inst_78827 = (state_78844[(2)]);
var inst_78828 = fluree.db.util.async.throw_err(inst_78827);
var inst_78829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78830 = [inst_78828];
var inst_78831 = (new cljs.core.PersistentVector(null,1,(5),inst_78829,inst_78830,null));
var inst_78832 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_78819,inst_78831);
var inst_78833 = cljs.core.first(inst_78818);
var state_78844__$1 = (function (){var statearr_78848 = state_78844;
(statearr_78848[(10)] = inst_78832);

return statearr_78848;
})();
if(cljs.core.truth_(inst_78833)){
var statearr_78849_78861 = state_78844__$1;
(statearr_78849_78861[(1)] = (5));

} else {
var statearr_78850_78862 = state_78844__$1;
(statearr_78850_78862[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (5))){
var inst_78818 = (state_78844[(9)]);
var inst_78832 = (state_78844[(10)]);
var inst_78835 = cljs.core.first(inst_78818);
var inst_78836 = cljs.core.rest(inst_78818);
var inst_78817 = inst_78835;
var inst_78818__$1 = inst_78836;
var inst_78819 = inst_78832;
var state_78844__$1 = (function (){var statearr_78851 = state_78844;
(statearr_78851[(7)] = inst_78819);

(statearr_78851[(8)] = inst_78817);

(statearr_78851[(9)] = inst_78818__$1);

return statearr_78851;
})();
var statearr_78852_78863 = state_78844__$1;
(statearr_78852_78863[(2)] = null);

(statearr_78852_78863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (6))){
var inst_78832 = (state_78844[(10)]);
var state_78844__$1 = state_78844;
var statearr_78853_78864 = state_78844__$1;
(statearr_78853_78864[(2)] = inst_78832);

(statearr_78853_78864[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78845 === (7))){
var inst_78840 = (state_78844[(2)]);
var state_78844__$1 = state_78844;
var statearr_78854_78865 = state_78844__$1;
(statearr_78854_78865[(2)] = inst_78840);

(statearr_78854_78865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_78855 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_78855[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__);

(statearr_78855[(1)] = (1));

return statearr_78855;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1 = (function (state_78844){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_78844);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e78856){var ex__2730__auto__ = e78856;
var statearr_78857_78866 = state_78844;
(statearr_78857_78866[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_78844[(4)]))){
var statearr_78858_78867 = state_78844;
(statearr_78858_78867[(1)] = cljs.core.first((state_78844[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78868 = state_78844;
state_78844 = G__78868;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__ = function(state_78844){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1.call(this,state_78844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_78859 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_78859[(6)] = c__2749__auto__);

return statearr_78859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_78936){
var state_val_78937 = (state_78936[(1)]);
if((state_val_78937 === (7))){
var inst_78896 = (state_78936[(2)]);
var inst_78897 = fluree.db.util.async.throw_err(inst_78896);
var state_78936__$1 = state_78936;
var statearr_78938_78964 = state_78936__$1;
(statearr_78938_78964[(2)] = inst_78897);

(statearr_78938_78964[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78937 === (1))){
var inst_78873 = cljs.core.volatile_BANG_((0));
var inst_78874 = cljs.core.PersistentHashMap.EMPTY;
var inst_78875 = cljs.core.volatile_BANG_(inst_78874);
var inst_78876 = cljs.core.first(resp);
var inst_78877 = cljs.core.rest(resp);
var inst_78878 = cljs.core.PersistentVector.EMPTY;
var inst_78879 = inst_78873;
var inst_78880 = inst_78875;
var inst_78881 = inst_78876;
var inst_78882 = inst_78877;
var inst_78883 = inst_78878;
var state_78936__$1 = (function (){var statearr_78939 = state_78936;
(statearr_78939[(7)] = inst_78880);

(statearr_78939[(8)] = inst_78883);

(statearr_78939[(9)] = inst_78881);

(statearr_78939[(10)] = inst_78879);

(statearr_78939[(11)] = inst_78882);

return statearr_78939;
})();
var statearr_78940_78965 = state_78936__$1;
(statearr_78940_78965[(2)] = null);

(statearr_78940_78965[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78937 === (4))){
var inst_78887 = (state_78936[(12)]);
var inst_78885 = (state_78936[(13)]);
var inst_78880 = (state_78936[(7)]);
var inst_78883 = (state_78936[(8)]);
var inst_78881 = (state_78936[(9)]);
var inst_78879 = (state_78936[(10)]);
var inst_78882 = (state_78936[(11)]);
var inst_78891 = (function (){var fuel = inst_78879;
var cache = inst_78880;
var curr_block = inst_78881;
var rest_blocks = inst_78882;
var acc = inst_78883;
var flakes = inst_78885;
var asserted = inst_78887;
return (function (p1__78870_SHARP_){
return p1__78870_SHARP_.s;
});
})();
var inst_78892 = cljs.core.group_by(inst_78891,inst_78887);
var inst_78893 = cljs.core.vals(inst_78892);
var inst_78894 = fluree.db.api_js.format_flake_groups_pretty(db,inst_78880,inst_78879,inst_78893);
var state_78936__$1 = state_78936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78936__$1,(7),inst_78894);
} else {
if((state_val_78937 === (13))){
var inst_78924 = (state_78936[(14)]);
var state_78936__$1 = state_78936;
var statearr_78941_78966 = state_78936__$1;
(statearr_78941_78966[(2)] = inst_78924);

(statearr_78941_78966[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78937 === (6))){
var inst_78900 = (state_78936[(15)]);
var inst_78887 = (state_78936[(12)]);
var inst_78885 = (state_78936[(13)]);
var inst_78902 = (state_78936[(16)]);
var inst_78880 = (state_78936[(7)]);
var inst_78883 = (state_78936[(8)]);
var inst_78881 = (state_78936[(9)]);
var inst_78879 = (state_78936[(10)]);
var inst_78882 = (state_78936[(11)]);
var inst_78900__$1 = (state_78936[(2)]);
var inst_78901 = (function (){var fuel = inst_78879;
var cache = inst_78880;
var curr_block = inst_78881;
var rest_blocks = inst_78882;
var acc = inst_78883;
var flakes = inst_78885;
var asserted = inst_78887;
var asserted_SINGLEQUOTE_ = inst_78900__$1;
return (function (p1__78871_SHARP_){
return p1__78871_SHARP_.op === false;
});
})();
var inst_78902__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_78901,inst_78885);
var inst_78903 = cljs.core.empty_QMARK_(inst_78902__$1);
var inst_78904 = (!(inst_78903));
var state_78936__$1 = (function (){var statearr_78944 = state_78936;
(statearr_78944[(15)] = inst_78900__$1);

(statearr_78944[(16)] = inst_78902__$1);

return statearr_78944;
})();
if(inst_78904){
var statearr_78945_78967 = state_78936__$1;
(statearr_78945_78967[(1)] = (8));

} else {
var statearr_78946_78968 = state_78936__$1;
(statearr_78946_78968[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78937 === (3))){
var inst_78934 = (state_78936[(2)]);
var state_78936__$1 = state_78936;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78936__$1,inst_78934);
} else {
if((state_val_78937 === (12))){
var inst_78924 = (state_78936[(14)]);
var inst_78880 = (state_78936[(7)]);
var inst_78879 = (state_78936[(10)]);
var inst_78882 = (state_78936[(11)]);
var inst_78927 = cljs.core.first(inst_78882);
var inst_78928 = cljs.core.rest(inst_78882);
var tmp78942 = inst_78880;
var tmp78943 = inst_78879;
var inst_78879__$1 = tmp78943;
var inst_78880__$1 = tmp78942;
var inst_78881 = inst_78927;
var inst_78882__$1 = inst_78928;
var inst_78883 = inst_78924;
var state_78936__$1 = (function (){var statearr_78947 = state_78936;
(statearr_78947[(7)] = inst_78880__$1);

(statearr_78947[(8)] = inst_78883);

(statearr_78947[(9)] = inst_78881);

(statearr_78947[(10)] = inst_78879__$1);

(statearr_78947[(11)] = inst_78882__$1);

return statearr_78947;
})();
var statearr_78948_78969 = state_78936__$1;
(statearr_78948_78969[(2)] = null);

(statearr_78948_78969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78937 === (2))){
var inst_78887 = (state_78936[(12)]);
var inst_78885 = (state_78936[(13)]);
var inst_78880 = (state_78936[(7)]);
var inst_78883 = (state_78936[(8)]);
var inst_78881 = (state_78936[(9)]);
var inst_78879 = (state_78936[(10)]);
var inst_78882 = (state_78936[(11)]);
var inst_78885__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_78881);
var inst_78886 = (function (){var fuel = inst_78879;
var cache = inst_78880;
var curr_block = inst_78881;
var rest_blocks = inst_78882;
var acc = inst_78883;
var flakes = inst_78885__$1;
return (function (p1__78869_SHARP_){
return p1__78869_SHARP_.op;
});
})();
var inst_78887__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_78886,inst_78885__$1);
var inst_78888 = cljs.core.empty_QMARK_(inst_78887__$1);
var inst_78889 = (!(inst_78888));
var state_78936__$1 = (function (){var statearr_78949 = state_78936;
(statearr_78949[(12)] = inst_78887__$1);

(statearr_78949[(13)] = inst_78885__$1);

return statearr_78949;
})();
if(inst_78889){
var statearr_78950_78970 = state_78936__$1;
(statearr_78950_78970[(1)] = (4));

} else {
var statearr_78951_78971 = state_78936__$1;
(statearr_78951_78971[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78937 === (11))){
var inst_78912 = (state_78936[(2)]);
var inst_78913 = fluree.db.util.async.throw_err(inst_78912);
var state_78936__$1 = state_78936;
var statearr_78952_78972 = state_78936__$1;
(statearr_78952_78972[(2)] = inst_78913);

(statearr_78952_78972[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78937 === (9))){
var state_78936__$1 = state_78936;
var statearr_78953_78973 = state_78936__$1;
(statearr_78953_78973[(2)] = null);

(statearr_78953_78973[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78937 === (5))){
var state_78936__$1 = state_78936;
var statearr_78954_78974 = state_78936__$1;
(statearr_78954_78974[(2)] = null);

(statearr_78954_78974[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78937 === (14))){
var inst_78932 = (state_78936[(2)]);
var state_78936__$1 = state_78936;
var statearr_78955_78975 = state_78936__$1;
(statearr_78955_78975[(2)] = inst_78932);

(statearr_78955_78975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78937 === (10))){
var inst_78900 = (state_78936[(15)]);
var inst_78883 = (state_78936[(8)]);
var inst_78881 = (state_78936[(9)]);
var inst_78882 = (state_78936[(11)]);
var inst_78916 = (state_78936[(2)]);
var inst_78917 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_78918 = [inst_78900,inst_78916];
var inst_78919 = cljs.core.PersistentHashMap.fromArrays(inst_78917,inst_78918);
var inst_78920 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_78881,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_78919);
var inst_78921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78922 = [inst_78920];
var inst_78923 = (new cljs.core.PersistentVector(null,1,(5),inst_78921,inst_78922,null));
var inst_78924 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_78883,inst_78923);
var inst_78925 = cljs.core.first(inst_78882);
var state_78936__$1 = (function (){var statearr_78956 = state_78936;
(statearr_78956[(14)] = inst_78924);

return statearr_78956;
})();
if(cljs.core.truth_(inst_78925)){
var statearr_78957_78976 = state_78936__$1;
(statearr_78957_78976[(1)] = (12));

} else {
var statearr_78958_78977 = state_78936__$1;
(statearr_78958_78977[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78937 === (8))){
var inst_78900 = (state_78936[(15)]);
var inst_78887 = (state_78936[(12)]);
var inst_78885 = (state_78936[(13)]);
var inst_78902 = (state_78936[(16)]);
var inst_78880 = (state_78936[(7)]);
var inst_78883 = (state_78936[(8)]);
var inst_78881 = (state_78936[(9)]);
var inst_78879 = (state_78936[(10)]);
var inst_78882 = (state_78936[(11)]);
var inst_78906 = (function (){var flakes = inst_78885;
var rest_blocks = inst_78882;
var curr_block = inst_78881;
var asserted_SINGLEQUOTE_ = inst_78900;
var acc = inst_78883;
var fuel = inst_78879;
var cache = inst_78880;
var retracted = inst_78902;
var asserted = inst_78887;
return (function (p1__78872_SHARP_){
return p1__78872_SHARP_.s;
});
})();
var inst_78907 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_78902);
var inst_78908 = cljs.core.group_by(inst_78906,inst_78907);
var inst_78909 = cljs.core.vals(inst_78908);
var inst_78910 = fluree.db.api_js.format_flake_groups_pretty(db,inst_78880,inst_78879,inst_78909);
var state_78936__$1 = state_78936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78936__$1,(11),inst_78910);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_78959 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78959[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_78959[(1)] = (1));

return statearr_78959;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_78936){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_78936);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e78960){var ex__2730__auto__ = e78960;
var statearr_78961_78978 = state_78936;
(statearr_78961_78978[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_78936[(4)]))){
var statearr_78962_78979 = state_78936;
(statearr_78962_78979[(1)] = cljs.core.first((state_78936[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78980 = state_78936;
state_78936 = G__78980;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_78936){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_78936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_78963 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_78963[(6)] = c__2749__auto__);

return statearr_78963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_79080){
var state_val_79081 = (state_79080[(1)]);
if((state_val_79081 === (7))){
var inst_79052 = (state_79080[(7)]);
var inst_79045 = (state_79080[(8)]);
var inst_79051 = cljs.core.seq(inst_79045);
var inst_79052__$1 = cljs.core.first(inst_79051);
var inst_79053 = cljs.core.next(inst_79051);
var state_79080__$1 = (function (){var statearr_79082 = state_79080;
(statearr_79082[(7)] = inst_79052__$1);

(statearr_79082[(9)] = inst_79053);

return statearr_79082;
})();
if(cljs.core.truth_(inst_79052__$1)){
var statearr_79083_79120 = state_79080__$1;
(statearr_79083_79120[(1)] = (9));

} else {
var statearr_79084_79121 = state_79080__$1;
(statearr_79084_79121[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79081 === (1))){
var state_79080__$1 = state_79080;
var statearr_79085_79122 = state_79080__$1;
(statearr_79085_79122[(2)] = null);

(statearr_79085_79122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79081 === (4))){
var inst_78982 = (state_79080[(2)]);
var state_79080__$1 = state_79080;
var statearr_79086_79123 = state_79080__$1;
(statearr_79086_79123[(2)] = inst_78982);

(statearr_79086_79123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79081 === (6))){
var inst_79031 = (state_79080[(2)]);
var inst_79032 = fluree.db.util.async.throw_err(inst_79031);
var inst_79040 = resp;
var inst_79041 = cljs.core.seq(inst_79040);
var inst_79042 = cljs.core.first(inst_79041);
var inst_79043 = cljs.core.next(inst_79041);
var inst_79044 = cljs.core.PersistentHashMap.EMPTY;
var inst_79045 = inst_79040;
var inst_79046 = inst_79044;
var state_79080__$1 = (function (){var statearr_79087 = state_79080;
(statearr_79087[(10)] = inst_79043);

(statearr_79087[(11)] = inst_79032);

(statearr_79087[(12)] = inst_79042);

(statearr_79087[(13)] = inst_79046);

(statearr_79087[(8)] = inst_79045);

return statearr_79087;
})();
var statearr_79088_79124 = state_79080__$1;
(statearr_79088_79124[(2)] = null);

(statearr_79088_79124[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79081 === (3))){
var inst_79078 = (state_79080[(2)]);
var state_79080__$1 = state_79080;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79080__$1,inst_79078);
} else {
if((state_val_79081 === (2))){
var _ = (function (){var statearr_79089 = state_79080;
(statearr_79089[(4)] = cljs.core.cons((5),(state_79080[(4)])));

return statearr_79089;
})();
var inst_78988 = (function (){return (function (p1__78981_SHARP_){
return p1__78981_SHARP_.t;
});
})();
var inst_78989 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_78988,resp);
var inst_78990 = cljs.core.set(inst_78989);
var inst_79027 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_79028 = (function (){var ts = inst_78990;
var c__2749__auto____$1 = inst_79027;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_79025){
var state_val_79026 = (state_79025[(1)]);
if((state_val_79026 === (1))){
var inst_78998 = ts;
var inst_78999 = cljs.core.seq(inst_78998);
var inst_79000 = cljs.core.first(inst_78999);
var inst_79001 = cljs.core.next(inst_78999);
var inst_79002 = cljs.core.PersistentHashMap.EMPTY;
var inst_79003 = inst_78998;
var inst_79004 = inst_79002;
var state_79025__$1 = (function (){var statearr_79090 = state_79025;
(statearr_79090[(7)] = inst_79003);

(statearr_79090[(8)] = inst_79004);

(statearr_79090[(9)] = inst_79001);

(statearr_79090[(10)] = inst_79000);

return statearr_79090;
})();
var statearr_79091_79125 = state_79025__$1;
(statearr_79091_79125[(2)] = null);

(statearr_79091_79125[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79026 === (2))){
var inst_79010 = (state_79025[(11)]);
var inst_79003 = (state_79025[(7)]);
var inst_79009 = cljs.core.seq(inst_79003);
var inst_79010__$1 = cljs.core.first(inst_79009);
var inst_79011 = cljs.core.next(inst_79009);
var state_79025__$1 = (function (){var statearr_79092 = state_79025;
(statearr_79092[(11)] = inst_79010__$1);

(statearr_79092[(12)] = inst_79011);

return statearr_79092;
})();
if(cljs.core.truth_(inst_79010__$1)){
var statearr_79093_79126 = state_79025__$1;
(statearr_79093_79126[(1)] = (4));

} else {
var statearr_79094_79127 = state_79025__$1;
(statearr_79094_79127[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79026 === (3))){
var inst_79023 = (state_79025[(2)]);
var state_79025__$1 = state_79025;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79025__$1,inst_79023);
} else {
if((state_val_79026 === (4))){
var inst_79010 = (state_79025[(11)]);
var inst_79013 = fluree.db.time_travel.non_border_t_to_block(db,inst_79010);
var state_79025__$1 = state_79025;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79025__$1,(7),inst_79013);
} else {
if((state_val_79026 === (5))){
var inst_79004 = (state_79025[(8)]);
var state_79025__$1 = state_79025;
var statearr_79095_79128 = state_79025__$1;
(statearr_79095_79128[(2)] = inst_79004);

(statearr_79095_79128[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79026 === (6))){
var inst_79021 = (state_79025[(2)]);
var state_79025__$1 = state_79025;
var statearr_79096_79129 = state_79025__$1;
(statearr_79096_79129[(2)] = inst_79021);

(statearr_79096_79129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79026 === (7))){
var inst_79010 = (state_79025[(11)]);
var inst_79004 = (state_79025[(8)]);
var inst_79011 = (state_79025[(12)]);
var inst_79015 = (state_79025[(2)]);
var inst_79016 = fluree.db.util.async.throw_err(inst_79015);
var inst_79017 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_79004,inst_79010,inst_79016);
var inst_79003 = inst_79011;
var inst_79004__$1 = inst_79017;
var state_79025__$1 = (function (){var statearr_79097 = state_79025;
(statearr_79097[(7)] = inst_79003);

(statearr_79097[(8)] = inst_79004__$1);

return statearr_79097;
})();
var statearr_79098_79130 = state_79025__$1;
(statearr_79098_79130[(2)] = null);

(statearr_79098_79130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_79099 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79099[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__);

(statearr_79099[(1)] = (1));

return statearr_79099;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1 = (function (state_79025){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_79025);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e79100){var ex__2730__auto__ = e79100;
var statearr_79101_79131 = state_79025;
(statearr_79101_79131[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_79025[(4)]))){
var statearr_79102_79132 = state_79025;
(statearr_79102_79132[(1)] = cljs.core.first((state_79025[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79133 = state_79025;
state_79025 = G__79133;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = function(state_79025){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1.call(this,state_79025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_79103 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_79103[(6)] = c__2749__auto____$1);

return statearr_79103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_79029 = cljs.core.async.impl.dispatch.run(inst_79028);
var state_79080__$1 = (function (){var statearr_79104 = state_79080;
(statearr_79104[(14)] = inst_79029);

return statearr_79104;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79080__$1,(6),inst_79027);
} else {
if((state_val_79081 === (11))){
var inst_79072 = (state_79080[(2)]);
var state_79080__$1 = state_79080;
var statearr_79106_79134 = state_79080__$1;
(statearr_79106_79134[(2)] = inst_79072);

(statearr_79106_79134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79081 === (9))){
var inst_79032 = (state_79080[(11)]);
var inst_79046 = (state_79080[(13)]);
var inst_79052 = (state_79080[(7)]);
var inst_79053 = (state_79080[(9)]);
var inst_79055 = inst_79052.t;
var inst_79056 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79032,inst_79055);
var inst_79057 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79058 = [inst_79056,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_79059 = (new cljs.core.PersistentVector(null,2,(5),inst_79057,inst_79058,null));
var inst_79060 = cljs.core.assoc_in(inst_79046,inst_79059,inst_79056);
var inst_79061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79062 = [inst_79056,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_79063 = (new cljs.core.PersistentVector(null,2,(5),inst_79061,inst_79062,null));
var inst_79064 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_79060,inst_79063,cljs.core.conj,inst_79052);
var inst_79065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79066 = [inst_79056,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_79067 = (new cljs.core.PersistentVector(null,2,(5),inst_79065,inst_79066,null));
var inst_79068 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_79064,inst_79067,fluree.db.api_js.min_safe,inst_79055);
var inst_79045 = inst_79053;
var inst_79046__$1 = inst_79068;
var state_79080__$1 = (function (){var statearr_79107 = state_79080;
(statearr_79107[(13)] = inst_79046__$1);

(statearr_79107[(8)] = inst_79045);

return statearr_79107;
})();
var statearr_79108_79135 = state_79080__$1;
(statearr_79108_79135[(2)] = null);

(statearr_79108_79135[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79081 === (5))){
var _ = (function (){var statearr_79109 = state_79080;
(statearr_79109[(4)] = cljs.core.rest((state_79080[(4)])));

return statearr_79109;
})();
var state_79080__$1 = state_79080;
var ex79105 = (state_79080__$1[(2)]);
var statearr_79110_79136 = state_79080__$1;
(statearr_79110_79136[(5)] = ex79105);


if((ex79105 instanceof Error)){
var statearr_79111_79137 = state_79080__$1;
(statearr_79111_79137[(1)] = (4));

(statearr_79111_79137[(5)] = null);

} else {
throw ex79105;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79081 === (10))){
var inst_79046 = (state_79080[(13)]);
var state_79080__$1 = state_79080;
var statearr_79112_79138 = state_79080__$1;
(statearr_79112_79138[(2)] = inst_79046);

(statearr_79112_79138[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79081 === (8))){
var inst_79074 = (state_79080[(2)]);
var inst_79075 = cljs.core.vals(inst_79074);
var _ = (function (){var statearr_79113 = state_79080;
(statearr_79113[(4)] = cljs.core.rest((state_79080[(4)])));

return statearr_79113;
})();
var state_79080__$1 = state_79080;
var statearr_79114_79139 = state_79080__$1;
(statearr_79114_79139[(2)] = inst_79075);

(statearr_79114_79139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_79115 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79115[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__);

(statearr_79115[(1)] = (1));

return statearr_79115;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1 = (function (state_79080){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_79080);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e79116){var ex__2730__auto__ = e79116;
var statearr_79117_79140 = state_79080;
(statearr_79117_79140[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_79080[(4)]))){
var statearr_79118_79141 = state_79080;
(statearr_79118_79141[(1)] = cljs.core.first((state_79080[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79142 = state_79080;
state_79080 = G__79142;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = function(state_79080){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1.call(this,state_79080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_79119 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_79119[(6)] = c__2749__auto__);

return statearr_79119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_79290){
var state_val_79291 = (state_79290[(1)]);
if((state_val_79291 === (7))){
var inst_79170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79171 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_79172 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_79173 = [inst_79171,inst_79172];
var inst_79174 = (new cljs.core.PersistentVector(null,2,(5),inst_79170,inst_79173,null));
var state_79290__$1 = state_79290;
var statearr_79292_79363 = state_79290__$1;
(statearr_79292_79363[(2)] = inst_79174);

(statearr_79292_79363[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (20))){
var inst_79200 = (state_79290[(7)]);
var state_79290__$1 = state_79290;
var statearr_79293_79364 = state_79290__$1;
(statearr_79293_79364[(2)] = inst_79200);

(statearr_79293_79364[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (27))){
var state_79290__$1 = state_79290;
var statearr_79294_79365 = state_79290__$1;
(statearr_79294_79365[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (1))){
var state_79290__$1 = state_79290;
var statearr_79296_79366 = state_79290__$1;
(statearr_79296_79366[(2)] = null);

(statearr_79296_79366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (24))){
var inst_79199 = (state_79290[(8)]);
var state_79290__$1 = state_79290;
if(cljs.core.truth_(inst_79199)){
var statearr_79297_79367 = state_79290__$1;
(statearr_79297_79367[(1)] = (26));

} else {
var statearr_79298_79368 = state_79290__$1;
(statearr_79298_79368[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (39))){
var inst_79246 = (state_79290[(9)]);
var inst_79245 = (state_79290[(10)]);
var inst_79271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79272 = [inst_79245,inst_79246];
var inst_79273 = (new cljs.core.PersistentVector(null,2,(5),inst_79271,inst_79272,null));
var state_79290__$1 = state_79290;
var statearr_79299_79369 = state_79290__$1;
(statearr_79299_79369[(2)] = inst_79273);

(statearr_79299_79369[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (4))){
var inst_79143 = (state_79290[(2)]);
var inst_79144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79145 = [inst_79143];
var inst_79146 = (new cljs.core.PersistentVector(null,1,(5),inst_79144,inst_79145,null));
var inst_79147 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_79146);
var inst_79148 = cljs.core.ex_data(inst_79143);
var inst_79149 = cljs.core.ex_message(inst_79143);
var inst_79150 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_79148,new cljs.core.Keyword(null,"message","message",-406056002),inst_79149);
var state_79290__$1 = (function (){var statearr_79300 = state_79290;
(statearr_79300[(11)] = inst_79147);

return statearr_79300;
})();
var statearr_79301_79370 = state_79290__$1;
(statearr_79301_79370[(2)] = inst_79150);

(statearr_79301_79370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (15))){
var inst_79179 = (state_79290[(12)]);
var inst_79184 = (state_79290[(13)]);
var inst_79193 = (state_79290[(2)]);
var inst_79194 = [inst_79184,inst_79193];
var inst_79195 = (new cljs.core.PersistentVector(null,2,(5),inst_79179,inst_79194,null));
var state_79290__$1 = state_79290;
var statearr_79302_79371 = state_79290__$1;
(statearr_79302_79371[(2)] = inst_79195);

(statearr_79302_79371[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (21))){
var inst_79199 = (state_79290[(8)]);
var state_79290__$1 = state_79290;
var statearr_79303_79372 = state_79290__$1;
(statearr_79303_79372[(2)] = inst_79199);

(statearr_79303_79372[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (31))){
var inst_79240 = (state_79290[(2)]);
var state_79290__$1 = state_79290;
var statearr_79304_79373 = state_79290__$1;
(statearr_79304_79373[(2)] = inst_79240);

(statearr_79304_79373[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (32))){
var inst_79246 = (state_79290[(9)]);
var inst_79249 = cljs.core.pos_int_QMARK_(inst_79246);
var state_79290__$1 = state_79290;
var statearr_79305_79374 = state_79290__$1;
(statearr_79305_79374[(2)] = inst_79249);

(statearr_79305_79374[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (40))){
var inst_79201 = (state_79290[(14)]);
var inst_79277 = (state_79290[(15)]);
var inst_79275 = (state_79290[(2)]);
var inst_79276 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79275,(0),null);
var inst_79277__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79275,(1),null);
var inst_79278 = (inst_79277__$1 > inst_79201);
var state_79290__$1 = (function (){var statearr_79306 = state_79290;
(statearr_79306[(15)] = inst_79277__$1);

(statearr_79306[(16)] = inst_79276);

return statearr_79306;
})();
if(cljs.core.truth_(inst_79278)){
var statearr_79307_79375 = state_79290__$1;
(statearr_79307_79375[(1)] = (41));

} else {
var statearr_79308_79376 = state_79290__$1;
(statearr_79308_79376[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (33))){
var inst_79247 = (state_79290[(17)]);
var state_79290__$1 = state_79290;
var statearr_79309_79377 = state_79290__$1;
(statearr_79309_79377[(2)] = inst_79247);

(statearr_79309_79377[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (13))){
var inst_79185 = (state_79290[(18)]);
var inst_79187 = fluree.db.time_travel.block_to_int_format(db,inst_79185);
var state_79290__$1 = state_79290;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79290__$1,(16),inst_79187);
} else {
if((state_val_79291 === (22))){
var inst_79218 = (state_79290[(2)]);
var state_79290__$1 = state_79290;
if(cljs.core.truth_(inst_79218)){
var statearr_79310_79378 = state_79290__$1;
(statearr_79310_79378[(1)] = (23));

} else {
var statearr_79311_79379 = state_79290__$1;
(statearr_79311_79379[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (36))){
var state_79290__$1 = state_79290;
var statearr_79312_79380 = state_79290__$1;
(statearr_79312_79380[(2)] = null);

(statearr_79312_79380[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (41))){
var inst_79201 = (state_79290[(14)]);
var state_79290__$1 = state_79290;
var statearr_79313_79381 = state_79290__$1;
(statearr_79313_79381[(2)] = inst_79201);

(statearr_79313_79381[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (43))){
var inst_79276 = (state_79290[(16)]);
var inst_79282 = (state_79290[(2)]);
var inst_79283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79284 = [inst_79276,inst_79282];
var inst_79285 = (new cljs.core.PersistentVector(null,2,(5),inst_79283,inst_79284,null));
var _ = (function (){var statearr_79314 = state_79290;
(statearr_79314[(4)] = cljs.core.rest((state_79290[(4)])));

return statearr_79314;
})();
var state_79290__$1 = state_79290;
var statearr_79315_79382 = state_79290__$1;
(statearr_79315_79382[(2)] = inst_79285);

(statearr_79315_79382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (29))){
var inst_79176 = (state_79290[(19)]);
var inst_79231 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79176], 0));
var inst_79232 = ["Invalid block range provided: ",inst_79231].join('');
var inst_79233 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79234 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_79235 = cljs.core.PersistentHashMap.fromArrays(inst_79233,inst_79234);
var inst_79236 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_79232,inst_79235);
var inst_79237 = (function(){throw inst_79236})();
var state_79290__$1 = state_79290;
var statearr_79316_79383 = state_79290__$1;
(statearr_79316_79383[(2)] = inst_79237);

(statearr_79316_79383[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (6))){
var inst_79168 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_79290__$1 = state_79290;
var statearr_79317_79384 = state_79290__$1;
(statearr_79317_79384[(2)] = inst_79168);

(statearr_79317_79384[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (28))){
var inst_79242 = (state_79290[(2)]);
var state_79290__$1 = state_79290;
var statearr_79318_79385 = state_79290__$1;
(statearr_79318_79385[(2)] = inst_79242);

(statearr_79318_79385[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (25))){
var inst_79247 = (state_79290[(17)]);
var inst_79245 = (state_79290[(10)]);
var inst_79244 = (state_79290[(2)]);
var inst_79245__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79244,(0),null);
var inst_79246 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79244,(1),null);
var inst_79247__$1 = cljs.core.pos_int_QMARK_(inst_79245__$1);
var state_79290__$1 = (function (){var statearr_79319 = state_79290;
(statearr_79319[(17)] = inst_79247__$1);

(statearr_79319[(9)] = inst_79246);

(statearr_79319[(10)] = inst_79245__$1);

return statearr_79319;
})();
if(inst_79247__$1){
var statearr_79320_79386 = state_79290__$1;
(statearr_79320_79386[(1)] = (32));

} else {
var statearr_79321_79387 = state_79290__$1;
(statearr_79321_79387[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (34))){
var inst_79252 = (state_79290[(2)]);
var inst_79253 = cljs.core.not(inst_79252);
var state_79290__$1 = state_79290;
if(inst_79253){
var statearr_79322_79388 = state_79290__$1;
(statearr_79322_79388[(1)] = (35));

} else {
var statearr_79323_79389 = state_79290__$1;
(statearr_79323_79389[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (17))){
var inst_79201 = (state_79290[(14)]);
var inst_79199 = (state_79290[(8)]);
var inst_79204 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79199], 0));
var inst_79205 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79201], 0));
var inst_79206 = ["Start block is out of range for this ledger. Start block provided: ",inst_79204,". Database block: ",inst_79205].join('');
var inst_79207 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79208 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_79209 = cljs.core.PersistentHashMap.fromArrays(inst_79207,inst_79208);
var inst_79210 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_79206,inst_79209);
var inst_79211 = (function(){throw inst_79210})();
var state_79290__$1 = state_79290;
var statearr_79324_79390 = state_79290__$1;
(statearr_79324_79390[(2)] = inst_79211);

(statearr_79324_79390[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (3))){
var inst_79288 = (state_79290[(2)]);
var state_79290__$1 = state_79290;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79290__$1,inst_79288);
} else {
if((state_val_79291 === (12))){
var inst_79185 = (state_79290[(18)]);
var inst_79176 = (state_79290[(19)]);
var inst_79183 = (state_79290[(2)]);
var inst_79184 = fluree.db.util.async.throw_err(inst_79183);
var inst_79185__$1 = cljs.core.second(inst_79176);
var state_79290__$1 = (function (){var statearr_79325 = state_79290;
(statearr_79325[(18)] = inst_79185__$1);

(statearr_79325[(13)] = inst_79184);

return statearr_79325;
})();
if(cljs.core.truth_(inst_79185__$1)){
var statearr_79326_79391 = state_79290__$1;
(statearr_79326_79391[(1)] = (13));

} else {
var statearr_79327_79392 = state_79290__$1;
(statearr_79327_79392[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (2))){
var _ = (function (){var statearr_79328 = state_79290;
(statearr_79328[(4)] = cljs.core.cons((5),(state_79290[(4)])));

return statearr_79328;
})();
var inst_79165 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_79166 = cljs.core.sequential_QMARK_(inst_79165);
var state_79290__$1 = state_79290;
if(inst_79166){
var statearr_79329_79393 = state_79290__$1;
(statearr_79329_79393[(1)] = (6));

} else {
var statearr_79330_79394 = state_79290__$1;
(statearr_79330_79394[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (23))){
var inst_79200 = (state_79290[(7)]);
var inst_79199 = (state_79290[(8)]);
var inst_79220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79221 = [inst_79199,inst_79200];
var inst_79222 = (new cljs.core.PersistentVector(null,2,(5),inst_79220,inst_79221,null));
var state_79290__$1 = state_79290;
var statearr_79331_79395 = state_79290__$1;
(statearr_79331_79395[(2)] = inst_79222);

(statearr_79331_79395[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (35))){
var inst_79176 = (state_79290[(19)]);
var inst_79255 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_79176], 0));
var inst_79256 = ["Invalid block range provided: ",inst_79255].join('');
var inst_79257 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79258 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_79259 = cljs.core.PersistentHashMap.fromArrays(inst_79257,inst_79258);
var inst_79260 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_79256,inst_79259);
var inst_79261 = (function(){throw inst_79260})();
var state_79290__$1 = state_79290;
var statearr_79332_79396 = state_79290__$1;
(statearr_79332_79396[(2)] = inst_79261);

(statearr_79332_79396[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (19))){
var inst_79199 = (state_79290[(8)]);
var inst_79214 = (state_79290[(2)]);
var state_79290__$1 = (function (){var statearr_79333 = state_79290;
(statearr_79333[(20)] = inst_79214);

return statearr_79333;
})();
if(cljs.core.truth_(inst_79199)){
var statearr_79334_79397 = state_79290__$1;
(statearr_79334_79397[(1)] = (20));

} else {
var statearr_79335_79398 = state_79290__$1;
(statearr_79335_79398[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (11))){
var inst_79201 = (state_79290[(14)]);
var inst_79199 = (state_79290[(8)]);
var inst_79198 = (state_79290[(2)]);
var inst_79199__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79198,(0),null);
var inst_79200 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79198,(1),null);
var inst_79201__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_79202 = (inst_79199__$1 > inst_79201__$1);
var state_79290__$1 = (function (){var statearr_79337 = state_79290;
(statearr_79337[(14)] = inst_79201__$1);

(statearr_79337[(7)] = inst_79200);

(statearr_79337[(8)] = inst_79199__$1);

return statearr_79337;
})();
if(cljs.core.truth_(inst_79202)){
var statearr_79338_79399 = state_79290__$1;
(statearr_79338_79399[(1)] = (17));

} else {
var statearr_79339_79400 = state_79290__$1;
(statearr_79339_79400[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (9))){
var inst_79176 = (state_79290[(19)]);
var inst_79179 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79180 = cljs.core.first(inst_79176);
var inst_79181 = fluree.db.time_travel.block_to_int_format(db,inst_79180);
var state_79290__$1 = (function (){var statearr_79340 = state_79290;
(statearr_79340[(12)] = inst_79179);

return statearr_79340;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79290__$1,(12),inst_79181);
} else {
if((state_val_79291 === (5))){
var _ = (function (){var statearr_79341 = state_79290;
(statearr_79341[(4)] = cljs.core.rest((state_79290[(4)])));

return statearr_79341;
})();
var state_79290__$1 = state_79290;
var ex79336 = (state_79290__$1[(2)]);
var statearr_79342_79401 = state_79290__$1;
(statearr_79342_79401[(5)] = ex79336);


var statearr_79343_79402 = state_79290__$1;
(statearr_79343_79402[(1)] = (4));

(statearr_79343_79402[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (14))){
var state_79290__$1 = state_79290;
var statearr_79344_79403 = state_79290__$1;
(statearr_79344_79403[(2)] = null);

(statearr_79344_79403[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (26))){
var inst_79199 = (state_79290[(8)]);
var inst_79225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79226 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_79227 = [inst_79199,inst_79226];
var inst_79228 = (new cljs.core.PersistentVector(null,2,(5),inst_79225,inst_79227,null));
var state_79290__$1 = state_79290;
var statearr_79345_79404 = state_79290__$1;
(statearr_79345_79404[(2)] = inst_79228);

(statearr_79345_79404[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (16))){
var inst_79189 = (state_79290[(2)]);
var inst_79190 = fluree.db.util.async.throw_err(inst_79189);
var state_79290__$1 = state_79290;
var statearr_79346_79405 = state_79290__$1;
(statearr_79346_79405[(2)] = inst_79190);

(statearr_79346_79405[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (38))){
var inst_79246 = (state_79290[(9)]);
var inst_79245 = (state_79290[(10)]);
var inst_79267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79268 = [inst_79246,inst_79245];
var inst_79269 = (new cljs.core.PersistentVector(null,2,(5),inst_79267,inst_79268,null));
var state_79290__$1 = state_79290;
var statearr_79347_79406 = state_79290__$1;
(statearr_79347_79406[(2)] = inst_79269);

(statearr_79347_79406[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (30))){
var state_79290__$1 = state_79290;
var statearr_79348_79407 = state_79290__$1;
(statearr_79348_79407[(2)] = null);

(statearr_79348_79407[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (10))){
var inst_79176 = (state_79290[(19)]);
var state_79290__$1 = state_79290;
var statearr_79349_79408 = state_79290__$1;
(statearr_79349_79408[(2)] = inst_79176);

(statearr_79349_79408[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (18))){
var state_79290__$1 = state_79290;
var statearr_79350_79409 = state_79290__$1;
(statearr_79350_79409[(2)] = null);

(statearr_79350_79409[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (42))){
var inst_79277 = (state_79290[(15)]);
var state_79290__$1 = state_79290;
var statearr_79351_79410 = state_79290__$1;
(statearr_79351_79410[(2)] = inst_79277);

(statearr_79351_79410[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (37))){
var inst_79246 = (state_79290[(9)]);
var inst_79245 = (state_79290[(10)]);
var inst_79264 = (state_79290[(2)]);
var inst_79265 = (inst_79246 < inst_79245);
var state_79290__$1 = (function (){var statearr_79352 = state_79290;
(statearr_79352[(21)] = inst_79264);

return statearr_79352;
})();
if(cljs.core.truth_(inst_79265)){
var statearr_79353_79411 = state_79290__$1;
(statearr_79353_79411[(1)] = (38));

} else {
var statearr_79354_79412 = state_79290__$1;
(statearr_79354_79412[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79291 === (8))){
var inst_79176 = (state_79290[(19)]);
var inst_79176__$1 = (state_79290[(2)]);
var inst_79177 = cljs.core.some(cljs.core.string_QMARK_,inst_79176__$1);
var state_79290__$1 = (function (){var statearr_79355 = state_79290;
(statearr_79355[(19)] = inst_79176__$1);

return statearr_79355;
})();
if(cljs.core.truth_(inst_79177)){
var statearr_79356_79413 = state_79290__$1;
(statearr_79356_79413[(1)] = (9));

} else {
var statearr_79357_79414 = state_79290__$1;
(statearr_79357_79414[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_79358 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79358[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__);

(statearr_79358[(1)] = (1));

return statearr_79358;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_79290){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_79290);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e79359){var ex__2730__auto__ = e79359;
var statearr_79360_79415 = state_79290;
(statearr_79360_79415[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_79290[(4)]))){
var statearr_79361_79416 = state_79290;
(statearr_79361_79416[(1)] = cljs.core.first((state_79290[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79417 = state_79290;
state_79290 = G__79417;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__ = function(state_79290){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_79290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_79362 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_79362[(6)] = c__2749__auto__);

return statearr_79362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__79419 = arguments.length;
switch (G__79419) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_79513){
var state_val_79514 = (state_79513[(1)]);
if((state_val_79514 === (7))){
var inst_79445 = (state_79513[(7)]);
var inst_79448 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_79445);
var state_79513__$1 = state_79513;
var statearr_79515_79566 = state_79513__$1;
(statearr_79515_79566[(2)] = inst_79448);

(statearr_79515_79566[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (20))){
var inst_79484 = (state_79513[(8)]);
var inst_79487 = fluree.db.api_js.format_block_resp_pretty(db,inst_79484);
var state_79513__$1 = state_79513;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79513__$1,(23),inst_79487);
} else {
if((state_val_79514 === (27))){
var inst_79493 = (state_79513[(9)]);
var inst_79499 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_79493);
var state_79513__$1 = state_79513;
var statearr_79516_79567 = state_79513__$1;
(statearr_79516_79567[(2)] = inst_79499);

(statearr_79516_79567[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (1))){
var state_79513__$1 = state_79513;
var statearr_79517_79568 = state_79513__$1;
(statearr_79517_79568[(2)] = null);

(statearr_79517_79568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (24))){
var inst_79493 = (state_79513[(9)]);
var inst_79496 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_79497 = cljs.core.sequential_QMARK_(inst_79493);
var state_79513__$1 = (function (){var statearr_79518 = state_79513;
(statearr_79518[(10)] = inst_79496);

return statearr_79518;
})();
if(inst_79497){
var statearr_79519_79569 = state_79513__$1;
(statearr_79519_79569[(1)] = (27));

} else {
var statearr_79520_79570 = state_79513__$1;
(statearr_79520_79570[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (4))){
var inst_79420 = (state_79513[(2)]);
var inst_79421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79422 = [inst_79420];
var inst_79423 = (new cljs.core.PersistentVector(null,1,(5),inst_79421,inst_79422,null));
var inst_79424 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_79423);
var inst_79425 = cljs.core.ex_data(inst_79420);
var inst_79426 = cljs.core.ex_message(inst_79420);
var inst_79427 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_79425,new cljs.core.Keyword(null,"message","message",-406056002),inst_79426);
var state_79513__$1 = (function (){var statearr_79521 = state_79513;
(statearr_79521[(11)] = inst_79424);

return statearr_79521;
})();
var statearr_79522_79571 = state_79513__$1;
(statearr_79522_79571[(2)] = inst_79427);

(statearr_79522_79571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (15))){
var inst_79445 = (state_79513[(7)]);
var inst_79458 = (state_79513[(2)]);
var inst_79459 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_79458,inst_79445);
var inst_79460 = (function(){throw inst_79459})();
var state_79513__$1 = state_79513;
var statearr_79523_79572 = state_79513__$1;
(statearr_79523_79572[(2)] = inst_79460);

(statearr_79523_79572[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (21))){
var inst_79484 = (state_79513[(8)]);
var state_79513__$1 = state_79513;
var statearr_79524_79573 = state_79513__$1;
(statearr_79524_79573[(2)] = inst_79484);

(statearr_79524_79573[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (13))){
var inst_79453 = (state_79513[(12)]);
var state_79513__$1 = state_79513;
var statearr_79525_79574 = state_79513__$1;
(statearr_79525_79574[(2)] = inst_79453);

(statearr_79525_79574[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (22))){
var inst_79493 = (state_79513[(2)]);
var inst_79494 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_79513__$1 = (function (){var statearr_79526 = state_79513;
(statearr_79526[(9)] = inst_79493);

return statearr_79526;
})();
if(cljs.core.truth_(inst_79494)){
var statearr_79527_79575 = state_79513__$1;
(statearr_79527_79575[(1)] = (24));

} else {
var statearr_79528_79576 = state_79513__$1;
(statearr_79528_79576[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (29))){
var inst_79437 = (state_79513[(13)]);
var inst_79496 = (state_79513[(10)]);
var inst_79502 = (state_79513[(2)]);
var inst_79503 = fluree.db.util.core.response_time_formatted(inst_79437);
var inst_79504 = [(200),inst_79502,(100),inst_79503];
var inst_79505 = cljs.core.PersistentHashMap.fromArrays(inst_79496,inst_79504);
var state_79513__$1 = state_79513;
var statearr_79529_79577 = state_79513__$1;
(statearr_79529_79577[(2)] = inst_79505);

(statearr_79529_79577[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (6))){
var inst_79445 = (state_79513[(7)]);
var inst_79446 = (state_79513[(14)]);
var inst_79444 = (state_79513[(2)]);
var inst_79445__$1 = fluree.db.util.async.throw_err(inst_79444);
var inst_79446__$1 = cljs.core.map_QMARK_(inst_79445__$1);
var state_79513__$1 = (function (){var statearr_79530 = state_79513;
(statearr_79530[(7)] = inst_79445__$1);

(statearr_79530[(14)] = inst_79446__$1);

return statearr_79530;
})();
if(inst_79446__$1){
var statearr_79531_79578 = state_79513__$1;
(statearr_79531_79578[(1)] = (7));

} else {
var statearr_79532_79579 = state_79513__$1;
(statearr_79532_79579[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (28))){
var inst_79493 = (state_79513[(9)]);
var state_79513__$1 = state_79513;
var statearr_79533_79580 = state_79513__$1;
(statearr_79533_79580[(2)] = inst_79493);

(statearr_79533_79580[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (25))){
var inst_79493 = (state_79513[(9)]);
var state_79513__$1 = state_79513;
var statearr_79534_79581 = state_79513__$1;
(statearr_79534_79581[(2)] = inst_79493);

(statearr_79534_79581[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (17))){
var inst_79476 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_79477 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_79476].join('');
var inst_79478 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79479 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_79480 = cljs.core.PersistentHashMap.fromArrays(inst_79478,inst_79479);
var inst_79481 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_79477,inst_79480);
var inst_79482 = (function(){throw inst_79481})();
var state_79513__$1 = state_79513;
var statearr_79535_79582 = state_79513__$1;
(statearr_79535_79582[(2)] = inst_79482);

(statearr_79535_79582[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (3))){
var inst_79511 = (state_79513[(2)]);
var state_79513__$1 = state_79513;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79513__$1,inst_79511);
} else {
if((state_val_79514 === (12))){
var inst_79445 = (state_79513[(7)]);
var inst_79463 = (state_79513[(2)]);
var inst_79464 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79445,(0),null);
var inst_79465 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79445,(1),null);
var inst_79466 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_79467 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_79468 = cljs.core.keys(inst_79467);
var inst_79469 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_79466,inst_79468);
var state_79513__$1 = (function (){var statearr_79536 = state_79513;
(statearr_79536[(15)] = inst_79464);

(statearr_79536[(16)] = inst_79465);

(statearr_79536[(17)] = inst_79463);

return statearr_79536;
})();
if(inst_79469){
var statearr_79537_79583 = state_79513__$1;
(statearr_79537_79583[(1)] = (16));

} else {
var statearr_79538_79584 = state_79513__$1;
(statearr_79538_79584[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (2))){
var _ = (function (){var statearr_79539 = state_79513;
(statearr_79539[(4)] = cljs.core.cons((5),(state_79513[(4)])));

return statearr_79539;
})();
var inst_79437 = fluree.db.util.core.current_time_millis();
var inst_79438 = db;
var inst_79439 = cljs.core.__destructure_map(inst_79438);
var inst_79440 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79439,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_79441 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79439,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_79442 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_79513__$1 = (function (){var statearr_79540 = state_79513;
(statearr_79540[(18)] = inst_79441);

(statearr_79540[(13)] = inst_79437);

(statearr_79540[(19)] = inst_79440);

return statearr_79540;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79513__$1,(6),inst_79442);
} else {
if((state_val_79514 === (23))){
var inst_79489 = (state_79513[(2)]);
var inst_79490 = fluree.db.util.async.throw_err(inst_79489);
var state_79513__$1 = state_79513;
var statearr_79541_79585 = state_79513__$1;
(statearr_79541_79585[(2)] = inst_79490);

(statearr_79541_79585[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (19))){
var inst_79473 = (state_79513[(2)]);
var inst_79474 = fluree.db.util.async.throw_err(inst_79473);
var state_79513__$1 = state_79513;
var statearr_79542_79586 = state_79513__$1;
(statearr_79542_79586[(2)] = inst_79474);

(statearr_79542_79586[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (11))){
var state_79513__$1 = state_79513;
var statearr_79544_79587 = state_79513__$1;
(statearr_79544_79587[(2)] = null);

(statearr_79544_79587[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (9))){
var inst_79451 = (state_79513[(2)]);
var state_79513__$1 = state_79513;
if(cljs.core.truth_(inst_79451)){
var statearr_79545_79588 = state_79513__$1;
(statearr_79545_79588[(1)] = (10));

} else {
var statearr_79546_79589 = state_79513__$1;
(statearr_79546_79589[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (5))){
var _ = (function (){var statearr_79547 = state_79513;
(statearr_79547[(4)] = cljs.core.rest((state_79513[(4)])));

return statearr_79547;
})();
var state_79513__$1 = state_79513;
var ex79543 = (state_79513__$1[(2)]);
var statearr_79548_79590 = state_79513__$1;
(statearr_79548_79590[(5)] = ex79543);


var statearr_79549_79591 = state_79513__$1;
(statearr_79549_79591[(1)] = (4));

(statearr_79549_79591[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (14))){
var inst_79441 = (state_79513[(18)]);
var inst_79440 = (state_79513[(19)]);
var inst_79456 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_79440),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_79441)].join('');
var state_79513__$1 = state_79513;
var statearr_79550_79592 = state_79513__$1;
(statearr_79550_79592[(2)] = inst_79456);

(statearr_79550_79592[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (26))){
var inst_79508 = (state_79513[(2)]);
var _ = (function (){var statearr_79551 = state_79513;
(statearr_79551[(4)] = cljs.core.rest((state_79513[(4)])));

return statearr_79551;
})();
var state_79513__$1 = state_79513;
var statearr_79552_79593 = state_79513__$1;
(statearr_79552_79593[(2)] = inst_79508);

(statearr_79552_79593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (16))){
var inst_79464 = (state_79513[(15)]);
var inst_79465 = (state_79513[(16)]);
var inst_79471 = fluree.db.query.block.block_range(db,inst_79464,inst_79465,opts);
var state_79513__$1 = state_79513;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79513__$1,(19),inst_79471);
} else {
if((state_val_79514 === (10))){
var inst_79445 = (state_79513[(7)]);
var inst_79453 = (state_79513[(12)]);
var inst_79453__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_79445);
var state_79513__$1 = (function (){var statearr_79553 = state_79513;
(statearr_79553[(12)] = inst_79453__$1);

return statearr_79553;
})();
if(cljs.core.truth_(inst_79453__$1)){
var statearr_79554_79594 = state_79513__$1;
(statearr_79554_79594[(1)] = (13));

} else {
var statearr_79555_79595 = state_79513__$1;
(statearr_79555_79595[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (18))){
var inst_79484 = (state_79513[(2)]);
var inst_79485 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_79513__$1 = (function (){var statearr_79556 = state_79513;
(statearr_79556[(8)] = inst_79484);

return statearr_79556;
})();
if(cljs.core.truth_(inst_79485)){
var statearr_79557_79596 = state_79513__$1;
(statearr_79557_79596[(1)] = (20));

} else {
var statearr_79558_79597 = state_79513__$1;
(statearr_79558_79597[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79514 === (8))){
var inst_79446 = (state_79513[(14)]);
var state_79513__$1 = state_79513;
var statearr_79559_79598 = state_79513__$1;
(statearr_79559_79598[(2)] = inst_79446);

(statearr_79559_79598[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_79560 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79560[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_79560[(1)] = (1));

return statearr_79560;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_79513){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_79513);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e79561){var ex__2730__auto__ = e79561;
var statearr_79562_79599 = state_79513;
(statearr_79562_79599[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_79513[(4)]))){
var statearr_79563_79600 = state_79513;
(statearr_79563_79600[(1)] = cljs.core.first((state_79513[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79601 = state_79513;
state_79513 = G__79601;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_79513){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_79513);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_79564 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_79564[(6)] = c__2749__auto__);

return statearr_79564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__79603 = arguments.length;
switch (G__79603) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_79798){
var state_val_79799 = (state_79798[(1)]);
if((state_val_79799 === (62))){
var inst_79796 = (state_79798[(2)]);
var state_79798__$1 = state_79798;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79798__$1,inst_79796);
} else {
if((state_val_79799 === (7))){
var inst_79624 = (state_79798[(7)]);
var inst_79634 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_79624);
var state_79798__$1 = state_79798;
var statearr_79800_79891 = state_79798__$1;
(statearr_79800_79891[(2)] = inst_79634);

(statearr_79800_79891[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (59))){
var inst_79784 = (state_79798[(2)]);
var inst_79785 = fluree.db.util.async.throw_err(inst_79784);
var state_79798__$1 = state_79798;
var statearr_79801_79892 = state_79798__$1;
(statearr_79801_79892[(2)] = inst_79785);

(statearr_79801_79892[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (20))){
var inst_79692 = (state_79798[(8)]);
var inst_79700 = (state_79798[(9)]);
var inst_79692__$1 = (state_79798[(2)]);
var inst_79693 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79694 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79692__$1,(0));
var inst_79695 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79692__$1,(1));
var inst_79696 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79692__$1,(2));
var inst_79697 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79692__$1,(3));
var inst_79698 = [inst_79694,inst_79695,inst_79696,inst_79697];
var inst_79699 = (new cljs.core.PersistentVector(null,4,(5),inst_79693,inst_79698,null));
var inst_79700__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79699,(0),null);
var inst_79701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79699,(1),null);
var inst_79702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79699,(2),null);
var inst_79703 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79699,(3),null);
var inst_79704 = (inst_79700__$1 == null);
var inst_79705 = cljs.core.not(inst_79704);
var state_79798__$1 = (function (){var statearr_79802 = state_79798;
(statearr_79802[(8)] = inst_79692__$1);

(statearr_79802[(9)] = inst_79700__$1);

(statearr_79802[(10)] = inst_79702);

(statearr_79802[(11)] = inst_79701);

(statearr_79802[(12)] = inst_79703);

return statearr_79802;
})();
if(inst_79705){
var statearr_79803_79893 = state_79798__$1;
(statearr_79803_79893[(1)] = (30));

} else {
var statearr_79804_79894 = state_79798__$1;
(statearr_79804_79894[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (58))){
var inst_79632 = (state_79798[(13)]);
var inst_79788 = (state_79798[(2)]);
var state_79798__$1 = (function (){var statearr_79805 = state_79798;
(statearr_79805[(14)] = inst_79788);

return statearr_79805;
})();
if(cljs.core.truth_(inst_79632)){
var statearr_79806_79895 = state_79798__$1;
(statearr_79806_79895[(1)] = (60));

} else {
var statearr_79807_79896 = state_79798__$1;
(statearr_79807_79896[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (60))){
var inst_79788 = (state_79798[(14)]);
var inst_79776 = (state_79798[(15)]);
var inst_79790 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_79791 = cljs.core.count(inst_79776);
var inst_79792 = [inst_79788,inst_79791,(200)];
var inst_79793 = cljs.core.PersistentHashMap.fromArrays(inst_79790,inst_79792);
var state_79798__$1 = state_79798;
var statearr_79808_79897 = state_79798__$1;
(statearr_79808_79897[(2)] = inst_79793);

(statearr_79808_79897[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (27))){
var inst_79611 = (state_79798[(16)]);
var inst_79680 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_79611)].join('');
var inst_79681 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79682 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_79683 = cljs.core.PersistentHashMap.fromArrays(inst_79681,inst_79682);
var inst_79684 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_79680,inst_79683);
var inst_79685 = (function(){throw inst_79684})();
var state_79798__$1 = state_79798;
var statearr_79809_79898 = state_79798__$1;
(statearr_79809_79898[(2)] = inst_79685);

(statearr_79809_79898[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (1))){
var inst_79608 = query_map;
var inst_79609 = cljs.core.__destructure_map(inst_79608);
var inst_79610 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79609,new cljs.core.Keyword(null,"block","block",664686210));
var inst_79611 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79609,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_79612 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_79609,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_79798__$1 = (function (){var statearr_79810 = state_79798;
(statearr_79810[(17)] = inst_79612);

(statearr_79810[(18)] = inst_79610);

(statearr_79810[(16)] = inst_79611);

return statearr_79810;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79798__$1,(2),sources);
} else {
if((state_val_79799 === (24))){
var inst_79611 = (state_79798[(16)]);
var inst_79669 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_79611)].join('');
var inst_79670 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79671 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_79672 = cljs.core.PersistentHashMap.fromArrays(inst_79670,inst_79671);
var inst_79673 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_79669,inst_79672);
var inst_79674 = (function(){throw inst_79673})();
var state_79798__$1 = state_79798;
var statearr_79811_79899 = state_79798__$1;
(statearr_79811_79899[(2)] = inst_79674);

(statearr_79811_79899[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (55))){
var inst_79612 = (state_79798[(17)]);
var inst_79779 = (state_79798[(2)]);
var inst_79780 = fluree.db.util.async.throw_err(inst_79779);
var state_79798__$1 = (function (){var statearr_79812 = state_79798;
(statearr_79812[(19)] = inst_79780);

return statearr_79812;
})();
if(cljs.core.truth_(inst_79612)){
var statearr_79813_79900 = state_79798__$1;
(statearr_79813_79900[(1)] = (56));

} else {
var statearr_79814_79901 = state_79798__$1;
(statearr_79814_79901[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (39))){
var inst_79700 = (state_79798[(9)]);
var inst_79702 = (state_79798[(10)]);
var inst_79701 = (state_79798[(11)]);
var inst_79703 = (state_79798[(12)]);
var inst_79724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79726 = [inst_79701,inst_79700,inst_79702,inst_79703];
var inst_79727 = (new cljs.core.PersistentVector(null,4,(5),inst_79725,inst_79726,null));
var inst_79728 = [inst_79727,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_79729 = (new cljs.core.PersistentVector(null,2,(5),inst_79724,inst_79728,null));
var state_79798__$1 = state_79798;
var statearr_79815_79902 = state_79798__$1;
(statearr_79815_79902[(2)] = inst_79729);

(statearr_79815_79902[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (46))){
var inst_79734 = (state_79798[(20)]);
var state_79798__$1 = state_79798;
var statearr_79816_79903 = state_79798__$1;
(statearr_79816_79903[(2)] = inst_79734);

(statearr_79816_79903[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (4))){
var state_79798__$1 = state_79798;
var statearr_79817_79904 = state_79798__$1;
(statearr_79817_79904[(2)] = null);

(statearr_79817_79904[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (54))){
var inst_79615 = (state_79798[(21)]);
var inst_79776 = (state_79798[(15)]);
var inst_79775 = (state_79798[(2)]);
var inst_79776__$1 = fluree.db.util.async.throw_err(inst_79775);
var inst_79777 = fluree.db.api_js.format_history_resp(inst_79615,inst_79776__$1);
var state_79798__$1 = (function (){var statearr_79818 = state_79798;
(statearr_79818[(15)] = inst_79776__$1);

return statearr_79818;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79798__$1,(55),inst_79777);
} else {
if((state_val_79799 === (15))){
var inst_79615 = (state_79798[(21)]);
var inst_79656 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_79615);
var state_79798__$1 = state_79798;
var statearr_79819_79905 = state_79798__$1;
(statearr_79819_79905[(2)] = inst_79656);

(statearr_79819_79905[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (48))){
var inst_79700 = (state_79798[(9)]);
var inst_79702 = (state_79798[(10)]);
var inst_79701 = (state_79798[(11)]);
var inst_79703 = (state_79798[(12)]);
var inst_79745 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79747 = [inst_79701,inst_79702,inst_79700,inst_79703];
var inst_79748 = (new cljs.core.PersistentVector(null,4,(5),inst_79746,inst_79747,null));
var inst_79749 = [inst_79748,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_79750 = (new cljs.core.PersistentVector(null,2,(5),inst_79745,inst_79749,null));
var state_79798__$1 = state_79798;
var statearr_79820_79906 = state_79798__$1;
(statearr_79820_79906[(2)] = inst_79750);

(statearr_79820_79906[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (50))){
var inst_79763 = (state_79798[(2)]);
var state_79798__$1 = state_79798;
var statearr_79821_79907 = state_79798__$1;
(statearr_79821_79907[(2)] = inst_79763);

(statearr_79821_79907[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (21))){
var inst_79611 = (state_79798[(16)]);
var inst_79667 = cljs.core.empty_QMARK_(inst_79611);
var state_79798__$1 = state_79798;
if(inst_79667){
var statearr_79822_79908 = state_79798__$1;
(statearr_79822_79908[(1)] = (24));

} else {
var statearr_79823_79909 = state_79798__$1;
(statearr_79823_79909[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (31))){
var inst_79711 = (state_79798[(22)]);
var inst_79700 = (state_79798[(9)]);
var inst_79711__$1 = (inst_79700 == null);
var state_79798__$1 = (function (){var statearr_79824 = state_79798;
(statearr_79824[(22)] = inst_79711__$1);

return statearr_79824;
})();
if(cljs.core.truth_(inst_79711__$1)){
var statearr_79825_79910 = state_79798__$1;
(statearr_79825_79910[(1)] = (33));

} else {
var statearr_79826_79911 = state_79798__$1;
(statearr_79826_79911[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (32))){
var inst_79615 = (state_79798[(21)]);
var inst_79658 = (state_79798[(23)]);
var inst_79648 = (state_79798[(24)]);
var inst_79767 = (state_79798[(2)]);
var inst_79768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79767,(0),null);
var inst_79769 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79767,(1),null);
var inst_79770 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_79771 = [inst_79648,inst_79658];
var inst_79772 = cljs.core.PersistentHashMap.fromArrays(inst_79770,inst_79771);
var inst_79773 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_79615,inst_79769,cljs.core._EQ_,inst_79768,inst_79772);
var state_79798__$1 = state_79798;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79798__$1,(54),inst_79773);
} else {
if((state_val_79799 === (40))){
var inst_79700 = (state_79798[(9)]);
var inst_79731 = (state_79798[(25)]);
var inst_79731__$1 = (inst_79700 == null);
var state_79798__$1 = (function (){var statearr_79827 = state_79798;
(statearr_79827[(25)] = inst_79731__$1);

return statearr_79827;
})();
if(cljs.core.truth_(inst_79731__$1)){
var statearr_79828_79912 = state_79798__$1;
(statearr_79828_79912[(1)] = (42));

} else {
var statearr_79829_79913 = state_79798__$1;
(statearr_79829_79913[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (56))){
var inst_79615 = (state_79798[(21)]);
var inst_79780 = (state_79798[(19)]);
var inst_79782 = fluree.db.api_js.format_block_resp_pretty(inst_79615,inst_79780);
var state_79798__$1 = state_79798;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79798__$1,(59),inst_79782);
} else {
if((state_val_79799 === (33))){
var inst_79714 = (state_79798[(26)]);
var inst_79701 = (state_79798[(11)]);
var inst_79713 = (inst_79701 == null);
var inst_79714__$1 = cljs.core.not(inst_79713);
var state_79798__$1 = (function (){var statearr_79830 = state_79798;
(statearr_79830[(26)] = inst_79714__$1);

return statearr_79830;
})();
if(inst_79714__$1){
var statearr_79831_79914 = state_79798__$1;
(statearr_79831_79914[(1)] = (36));

} else {
var statearr_79832_79915 = state_79798__$1;
(statearr_79832_79915[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (13))){
var inst_79642 = (state_79798[(2)]);
var inst_79643 = fluree.db.util.async.throw_err(inst_79642);
var inst_79644 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_79643);
var inst_79645 = (inst_79644 - (1));
var state_79798__$1 = state_79798;
var statearr_79833_79916 = state_79798__$1;
(statearr_79833_79916[(2)] = inst_79645);

(statearr_79833_79916[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (22))){
var state_79798__$1 = state_79798;
var statearr_79834_79917 = state_79798__$1;
(statearr_79834_79917[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (36))){
var inst_79702 = (state_79798[(10)]);
var inst_79716 = (inst_79702 == null);
var state_79798__$1 = state_79798;
var statearr_79836_79918 = state_79798__$1;
(statearr_79836_79918[(2)] = inst_79716);

(statearr_79836_79918[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (41))){
var inst_79765 = (state_79798[(2)]);
var state_79798__$1 = state_79798;
var statearr_79837_79919 = state_79798__$1;
(statearr_79837_79919[(2)] = inst_79765);

(statearr_79837_79919[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (43))){
var inst_79731 = (state_79798[(25)]);
var state_79798__$1 = state_79798;
var statearr_79838_79920 = state_79798__$1;
(statearr_79838_79920[(2)] = inst_79731);

(statearr_79838_79920[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (61))){
var inst_79788 = (state_79798[(14)]);
var state_79798__$1 = state_79798;
var statearr_79839_79921 = state_79798__$1;
(statearr_79839_79921[(2)] = inst_79788);

(statearr_79839_79921[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (29))){
var inst_79688 = (state_79798[(2)]);
var state_79798__$1 = state_79798;
var statearr_79840_79922 = state_79798__$1;
(statearr_79840_79922[(2)] = inst_79688);

(statearr_79840_79922[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (44))){
var inst_79743 = (state_79798[(2)]);
var state_79798__$1 = state_79798;
if(cljs.core.truth_(inst_79743)){
var statearr_79841_79923 = state_79798__$1;
(statearr_79841_79923[(1)] = (48));

} else {
var statearr_79842_79924 = state_79798__$1;
(statearr_79842_79924[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (6))){
var inst_79619 = (state_79798[(2)]);
var inst_79620 = fluree.db.util.async.throw_err(inst_79619);
var state_79798__$1 = state_79798;
var statearr_79843_79925 = state_79798__$1;
(statearr_79843_79925[(2)] = inst_79620);

(statearr_79843_79925[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (28))){
var state_79798__$1 = state_79798;
var statearr_79844_79926 = state_79798__$1;
(statearr_79844_79926[(2)] = null);

(statearr_79844_79926[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (51))){
var inst_79611 = (state_79798[(16)]);
var inst_79753 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_79611)].join('');
var inst_79754 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_79755 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_79756 = cljs.core.PersistentHashMap.fromArrays(inst_79754,inst_79755);
var inst_79757 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_79753,inst_79756);
var inst_79758 = (function(){throw inst_79757})();
var state_79798__$1 = state_79798;
var statearr_79845_79927 = state_79798__$1;
(statearr_79845_79927[(2)] = inst_79758);

(statearr_79845_79927[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (25))){
var inst_79611 = (state_79798[(16)]);
var state_79798__$1 = state_79798;
var statearr_79846_79928 = state_79798__$1;
(statearr_79846_79928[(2)] = inst_79611);

(statearr_79846_79928[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (34))){
var inst_79711 = (state_79798[(22)]);
var state_79798__$1 = state_79798;
var statearr_79847_79929 = state_79798__$1;
(statearr_79847_79929[(2)] = inst_79711);

(statearr_79847_79929[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (17))){
var inst_79652 = (state_79798[(2)]);
var inst_79653 = fluree.db.util.async.throw_err(inst_79652);
var inst_79654 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_79653);
var state_79798__$1 = state_79798;
var statearr_79848_79930 = state_79798__$1;
(statearr_79848_79930[(2)] = inst_79654);

(statearr_79848_79930[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (3))){
var inst_79615 = (state_79798[(21)]);
var inst_79617 = fluree.db.api_js.resolve_block_range(inst_79615,query_map);
var state_79798__$1 = state_79798;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79798__$1,(6),inst_79617);
} else {
if((state_val_79799 === (12))){
var inst_79625 = (state_79798[(27)]);
var inst_79648 = (state_79798[(2)]);
var state_79798__$1 = (function (){var statearr_79849 = state_79798;
(statearr_79849[(24)] = inst_79648);

return statearr_79849;
})();
if(cljs.core.truth_(inst_79625)){
var statearr_79850_79931 = state_79798__$1;
(statearr_79850_79931[(1)] = (14));

} else {
var statearr_79851_79932 = state_79798__$1;
(statearr_79851_79932[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (2))){
var inst_79610 = (state_79798[(18)]);
var inst_79614 = (state_79798[(2)]);
var inst_79615 = fluree.db.util.async.throw_err(inst_79614);
var state_79798__$1 = (function (){var statearr_79852 = state_79798;
(statearr_79852[(21)] = inst_79615);

return statearr_79852;
})();
if(cljs.core.truth_(inst_79610)){
var statearr_79853_79933 = state_79798__$1;
(statearr_79853_79933[(1)] = (3));

} else {
var statearr_79854_79934 = state_79798__$1;
(statearr_79854_79934[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (23))){
var inst_79690 = (state_79798[(2)]);
var state_79798__$1 = state_79798;
var statearr_79855_79935 = state_79798__$1;
(statearr_79855_79935[(2)] = inst_79690);

(statearr_79855_79935[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (47))){
var inst_79740 = (state_79798[(2)]);
var state_79798__$1 = state_79798;
var statearr_79856_79936 = state_79798__$1;
(statearr_79856_79936[(2)] = inst_79740);

(statearr_79856_79936[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (35))){
var inst_79722 = (state_79798[(2)]);
var state_79798__$1 = state_79798;
if(cljs.core.truth_(inst_79722)){
var statearr_79857_79937 = state_79798__$1;
(statearr_79857_79937[(1)] = (39));

} else {
var statearr_79858_79938 = state_79798__$1;
(statearr_79858_79938[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (19))){
var inst_79611 = (state_79798[(16)]);
var inst_79665 = cljs.core.sequential_QMARK_(inst_79611);
var state_79798__$1 = state_79798;
if(inst_79665){
var statearr_79859_79939 = state_79798__$1;
(statearr_79859_79939[(1)] = (21));

} else {
var statearr_79860_79940 = state_79798__$1;
(statearr_79860_79940[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (57))){
var inst_79780 = (state_79798[(19)]);
var state_79798__$1 = state_79798;
var statearr_79861_79941 = state_79798__$1;
(statearr_79861_79941[(2)] = inst_79780);

(statearr_79861_79941[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (11))){
var state_79798__$1 = state_79798;
var statearr_79862_79942 = state_79798__$1;
(statearr_79862_79942[(2)] = (-1));

(statearr_79862_79942[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (9))){
var inst_79637 = (state_79798[(2)]);
var state_79798__$1 = state_79798;
if(cljs.core.truth_(inst_79637)){
var statearr_79863_79943 = state_79798__$1;
(statearr_79863_79943[(1)] = (10));

} else {
var statearr_79864_79944 = state_79798__$1;
(statearr_79864_79944[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (5))){
var inst_79624 = (state_79798[(7)]);
var inst_79623 = (state_79798[(2)]);
var inst_79624__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79623,(0),null);
var inst_79625 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79623,(1),null);
var inst_79632 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_79798__$1 = (function (){var statearr_79865 = state_79798;
(statearr_79865[(13)] = inst_79632);

(statearr_79865[(27)] = inst_79625);

(statearr_79865[(7)] = inst_79624__$1);

return statearr_79865;
})();
if(cljs.core.truth_(inst_79624__$1)){
var statearr_79866_79945 = state_79798__$1;
(statearr_79866_79945[(1)] = (7));

} else {
var statearr_79867_79946 = state_79798__$1;
(statearr_79867_79946[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (14))){
var inst_79615 = (state_79798[(21)]);
var inst_79625 = (state_79798[(27)]);
var inst_79650 = fluree.db.time_travel.as_of_block(inst_79615,inst_79625);
var state_79798__$1 = state_79798;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79798__$1,(17),inst_79650);
} else {
if((state_val_79799 === (45))){
var inst_79702 = (state_79798[(10)]);
var inst_79736 = (inst_79702 == null);
var inst_79737 = cljs.core.not(inst_79736);
var state_79798__$1 = state_79798;
var statearr_79868_79947 = state_79798__$1;
(statearr_79868_79947[(2)] = inst_79737);

(statearr_79868_79947[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (53))){
var inst_79761 = (state_79798[(2)]);
var state_79798__$1 = state_79798;
var statearr_79869_79948 = state_79798__$1;
(statearr_79869_79948[(2)] = inst_79761);

(statearr_79869_79948[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (26))){
var inst_79677 = (state_79798[(2)]);
var state_79798__$1 = state_79798;
var statearr_79870_79949 = state_79798__$1;
(statearr_79870_79949[(2)] = inst_79677);

(statearr_79870_79949[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (16))){
var inst_79611 = (state_79798[(16)]);
var inst_79658 = (state_79798[(2)]);
var inst_79659 = fluree.db.util.core.subj_ident_QMARK_(inst_79611);
var state_79798__$1 = (function (){var statearr_79871 = state_79798;
(statearr_79871[(23)] = inst_79658);

return statearr_79871;
})();
if(inst_79659){
var statearr_79872_79950 = state_79798__$1;
(statearr_79872_79950[(1)] = (18));

} else {
var statearr_79873_79951 = state_79798__$1;
(statearr_79873_79951[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (38))){
var inst_79719 = (state_79798[(2)]);
var state_79798__$1 = state_79798;
var statearr_79874_79952 = state_79798__$1;
(statearr_79874_79952[(2)] = inst_79719);

(statearr_79874_79952[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (30))){
var inst_79692 = (state_79798[(8)]);
var inst_79707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79708 = [inst_79692,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_79709 = (new cljs.core.PersistentVector(null,2,(5),inst_79707,inst_79708,null));
var state_79798__$1 = state_79798;
var statearr_79875_79953 = state_79798__$1;
(statearr_79875_79953[(2)] = inst_79709);

(statearr_79875_79953[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (10))){
var inst_79615 = (state_79798[(21)]);
var inst_79624 = (state_79798[(7)]);
var inst_79639 = (inst_79624 - (1));
var inst_79640 = fluree.db.time_travel.as_of_block(inst_79615,inst_79639);
var state_79798__$1 = state_79798;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79798__$1,(13),inst_79640);
} else {
if((state_val_79799 === (18))){
var inst_79611 = (state_79798[(16)]);
var inst_79661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79662 = [inst_79611];
var inst_79663 = (new cljs.core.PersistentVector(null,1,(5),inst_79661,inst_79662,null));
var state_79798__$1 = state_79798;
var statearr_79876_79954 = state_79798__$1;
(statearr_79876_79954[(2)] = inst_79663);

(statearr_79876_79954[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (52))){
var state_79798__$1 = state_79798;
var statearr_79877_79955 = state_79798__$1;
(statearr_79877_79955[(2)] = null);

(statearr_79877_79955[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (42))){
var inst_79734 = (state_79798[(20)]);
var inst_79701 = (state_79798[(11)]);
var inst_79733 = (inst_79701 == null);
var inst_79734__$1 = cljs.core.not(inst_79733);
var state_79798__$1 = (function (){var statearr_79878 = state_79798;
(statearr_79878[(20)] = inst_79734__$1);

return statearr_79878;
})();
if(inst_79734__$1){
var statearr_79879_79956 = state_79798__$1;
(statearr_79879_79956[(1)] = (45));

} else {
var statearr_79880_79957 = state_79798__$1;
(statearr_79880_79957[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (37))){
var inst_79714 = (state_79798[(26)]);
var state_79798__$1 = state_79798;
var statearr_79881_79958 = state_79798__$1;
(statearr_79881_79958[(2)] = inst_79714);

(statearr_79881_79958[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (8))){
var inst_79624 = (state_79798[(7)]);
var state_79798__$1 = state_79798;
var statearr_79882_79959 = state_79798__$1;
(statearr_79882_79959[(2)] = inst_79624);

(statearr_79882_79959[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79799 === (49))){
var state_79798__$1 = state_79798;
var statearr_79883_79960 = state_79798__$1;
(statearr_79883_79960[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_79885 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79885[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_79885[(1)] = (1));

return statearr_79885;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_79798){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_79798);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e79886){var ex__2730__auto__ = e79886;
var statearr_79887_79961 = state_79798;
(statearr_79887_79961[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_79798[(4)]))){
var statearr_79888_79962 = state_79798;
(statearr_79888_79962[(1)] = cljs.core.first((state_79798[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79963 = state_79798;
state_79798 = G__79963;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_79798){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_79798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_79889 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_79889[(6)] = c__2749__auto__);

return statearr_79889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__79971 = arguments.length;
switch (G__79971) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__79964_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__79964_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_80060){
var state_val_80061 = (state_80060[(1)]);
if((state_val_80061 === (7))){
var inst_80014 = (state_80060[(7)]);
var inst_80017 = (state_80060[(8)]);
var inst_80011 = (state_80060[(9)]);
var inst_80021 = (state_80060[(10)]);
var inst_80027 = (function (){var responses = inst_80011;
var responses_STAR_ = inst_80014;
var statuses = inst_80017;
var fuel = inst_80021;
return (function (p1__79967_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__79967_SHARP_);
});
})();
var inst_80028 = cljs.core.some(inst_80027,inst_80017);
var state_80060__$1 = state_80060;
if(cljs.core.truth_(inst_80028)){
var statearr_80062_80110 = state_80060__$1;
(statearr_80062_80110[(1)] = (9));

} else {
var statearr_80063_80111 = state_80060__$1;
(statearr_80063_80111[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (20))){
var inst_80055 = (state_80060[(2)]);
var state_80060__$1 = state_80060;
var statearr_80064_80112 = state_80060__$1;
(statearr_80064_80112[(2)] = inst_80055);

(statearr_80064_80112[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (1))){
var inst_80006 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_80007 = (function (){var c__2749__auto____$1 = inst_80006;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_80004){
var state_val_80005 = (state_80004[(1)]);
if((state_val_80005 === (1))){
var inst_79972 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_79973 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_79974 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_79973,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_79975 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_79976 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_79977 = cljs.core.PersistentHashMap.EMPTY;
var inst_79978 = inst_79972;
var inst_79979 = inst_79974;
var inst_79980 = inst_79975;
var inst_79981 = inst_79976;
var inst_79982 = inst_79977;
var state_80004__$1 = (function (){var statearr_80065 = state_80004;
(statearr_80065[(7)] = inst_79979);

(statearr_80065[(8)] = inst_79981);

(statearr_80065[(9)] = inst_79980);

(statearr_80065[(10)] = inst_79982);

(statearr_80065[(11)] = inst_79978);

return statearr_80065;
})();
var statearr_80066_80113 = state_80004__$1;
(statearr_80066_80113[(2)] = null);

(statearr_80066_80113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80005 === (2))){
var inst_79979 = (state_80004[(7)]);
var inst_79984 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_79979);
var inst_79985 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_79984], 0));
var inst_79986 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_79979,new cljs.core.Keyword(null,"opts","opts",155075701),inst_79985);
var inst_79987 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_79986,db_fn);
var state_80004__$1 = state_80004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80004__$1,(4),inst_79987);
} else {
if((state_val_80005 === (3))){
var inst_80002 = (state_80004[(2)]);
var state_80004__$1 = state_80004;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80004__$1,inst_80002);
} else {
if((state_val_80005 === (4))){
var inst_79980 = (state_80004[(9)]);
var inst_79982 = (state_80004[(10)]);
var inst_79978 = (state_80004[(11)]);
var inst_79989 = (state_80004[(2)]);
var inst_79990 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_79982,inst_79978,inst_79989);
var inst_79991 = cljs.core.first(inst_79980);
var state_80004__$1 = (function (){var statearr_80067 = state_80004;
(statearr_80067[(12)] = inst_79990);

return statearr_80067;
})();
if(cljs.core.truth_(inst_79991)){
var statearr_80068_80114 = state_80004__$1;
(statearr_80068_80114[(1)] = (5));

} else {
var statearr_80069_80115 = state_80004__$1;
(statearr_80069_80115[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80005 === (5))){
var inst_79981 = (state_80004[(8)]);
var inst_79980 = (state_80004[(9)]);
var inst_79990 = (state_80004[(12)]);
var inst_79993 = cljs.core.first(inst_79980);
var inst_79994 = cljs.core.first(inst_79981);
var inst_79995 = cljs.core.rest(inst_79980);
var inst_79996 = cljs.core.rest(inst_79981);
var inst_79978 = inst_79993;
var inst_79979 = inst_79994;
var inst_79980__$1 = inst_79995;
var inst_79981__$1 = inst_79996;
var inst_79982 = inst_79990;
var state_80004__$1 = (function (){var statearr_80070 = state_80004;
(statearr_80070[(7)] = inst_79979);

(statearr_80070[(8)] = inst_79981__$1);

(statearr_80070[(9)] = inst_79980__$1);

(statearr_80070[(10)] = inst_79982);

(statearr_80070[(11)] = inst_79978);

return statearr_80070;
})();
var statearr_80071_80116 = state_80004__$1;
(statearr_80071_80116[(2)] = null);

(statearr_80071_80116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80005 === (6))){
var inst_79990 = (state_80004[(12)]);
var state_80004__$1 = state_80004;
var statearr_80072_80117 = state_80004__$1;
(statearr_80072_80117[(2)] = inst_79990);

(statearr_80072_80117[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80005 === (7))){
var inst_80000 = (state_80004[(2)]);
var state_80004__$1 = state_80004;
var statearr_80073_80118 = state_80004__$1;
(statearr_80073_80118[(2)] = inst_80000);

(statearr_80073_80118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_80074 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80074[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_80074[(1)] = (1));

return statearr_80074;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_80004){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_80004);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e80075){var ex__2730__auto__ = e80075;
var statearr_80076_80119 = state_80004;
(statearr_80076_80119[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_80004[(4)]))){
var statearr_80077_80120 = state_80004;
(statearr_80077_80120[(1)] = cljs.core.first((state_80004[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80121 = state_80004;
state_80004 = G__80121;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_80004){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_80004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_80078 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_80078[(6)] = c__2749__auto____$1);

return statearr_80078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_80008 = cljs.core.async.impl.dispatch.run(inst_80007);
var state_80060__$1 = (function (){var statearr_80079 = state_80060;
(statearr_80079[(11)] = inst_80008);

return statearr_80079;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80060__$1,(2),inst_80006);
} else {
if((state_val_80061 === (4))){
var inst_80011 = (state_80060[(9)]);
var state_80060__$1 = state_80060;
var statearr_80080_80122 = state_80060__$1;
(statearr_80080_80122[(2)] = inst_80011);

(statearr_80080_80122[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (15))){
var state_80060__$1 = state_80060;
var statearr_80081_80123 = state_80060__$1;
(statearr_80081_80123[(2)] = (400));

(statearr_80081_80123[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (13))){
var state_80060__$1 = state_80060;
var statearr_80082_80124 = state_80060__$1;
(statearr_80082_80124[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (6))){
var inst_80017 = (state_80060[(8)]);
var inst_80025 = cljs.core.first(inst_80017);
var state_80060__$1 = state_80060;
var statearr_80084_80125 = state_80060__$1;
(statearr_80084_80125[(2)] = inst_80025);

(statearr_80084_80125[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (17))){
var inst_80038 = (state_80060[(2)]);
var state_80060__$1 = state_80060;
var statearr_80085_80126 = state_80060__$1;
(statearr_80085_80126[(2)] = inst_80038);

(statearr_80085_80126[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (3))){
var inst_80014 = (state_80060[(7)]);
var inst_80017 = (state_80060[(8)]);
var inst_80011 = (state_80060[(9)]);
var inst_80021 = (state_80060[(10)]);
var inst_80016 = cljs.core.vals(inst_80011);
var inst_80017__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_80016);
var inst_80018 = (function (){var responses = inst_80011;
var responses_STAR_ = inst_80014;
var statuses = inst_80017__$1;
return (function (p1__79965_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__79965_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_80019 = cljs.core.vals(inst_80011);
var inst_80020 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_80018,inst_80019);
var inst_80021__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_80020);
var inst_80022 = (function (){var responses = inst_80011;
var responses_STAR_ = inst_80014;
var statuses = inst_80017__$1;
var fuel = inst_80021__$1;
return (function (p1__79966_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__79966_SHARP_);
});
})();
var inst_80023 = cljs.core.every_QMARK_(inst_80022,inst_80017__$1);
var state_80060__$1 = (function (){var statearr_80086 = state_80060;
(statearr_80086[(8)] = inst_80017__$1);

(statearr_80086[(10)] = inst_80021__$1);

return statearr_80086;
})();
if(inst_80023){
var statearr_80087_80127 = state_80060__$1;
(statearr_80087_80127[(1)] = (6));

} else {
var statearr_80088_80128 = state_80060__$1;
(statearr_80088_80128[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (12))){
var state_80060__$1 = state_80060;
var statearr_80089_80129 = state_80060__$1;
(statearr_80089_80129[(2)] = (500));

(statearr_80089_80129[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (2))){
var inst_80011 = (state_80060[(9)]);
var inst_80010 = (state_80060[(2)]);
var inst_80011__$1 = fluree.db.util.async.throw_err(inst_80010);
var inst_80012 = (function (){var responses = inst_80011__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_80013 = cljs.core.PersistentHashMap.EMPTY;
var inst_80014 = cljs.core.reduce_kv(inst_80012,inst_80013,inst_80011__$1);
var state_80060__$1 = (function (){var statearr_80090 = state_80060;
(statearr_80090[(7)] = inst_80014);

(statearr_80090[(9)] = inst_80011__$1);

return statearr_80090;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_80091_80130 = state_80060__$1;
(statearr_80091_80130[(1)] = (3));

} else {
var statearr_80092_80131 = state_80060__$1;
(statearr_80092_80131[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (19))){
var inst_80014 = (state_80060[(7)]);
var inst_80044 = (state_80060[(12)]);
var inst_80021 = (state_80060[(10)]);
var inst_80053 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_80014,new cljs.core.Keyword(null,"status","status",-1997798413),inst_80044,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_80021], 0));
var state_80060__$1 = state_80060;
var statearr_80093_80132 = state_80060__$1;
(statearr_80093_80132[(2)] = inst_80053);

(statearr_80093_80132[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (11))){
var inst_80042 = (state_80060[(2)]);
var state_80060__$1 = state_80060;
var statearr_80094_80133 = state_80060__$1;
(statearr_80094_80133[(2)] = inst_80042);

(statearr_80094_80133[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (9))){
var state_80060__$1 = state_80060;
var statearr_80095_80134 = state_80060__$1;
(statearr_80095_80134[(2)] = (207));

(statearr_80095_80134[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (5))){
var inst_80058 = (state_80060[(2)]);
var state_80060__$1 = state_80060;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80060__$1,inst_80058);
} else {
if((state_val_80061 === (14))){
var inst_80040 = (state_80060[(2)]);
var state_80060__$1 = state_80060;
var statearr_80096_80135 = state_80060__$1;
(statearr_80096_80135[(2)] = inst_80040);

(statearr_80096_80135[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (16))){
var state_80060__$1 = state_80060;
var statearr_80097_80136 = state_80060__$1;
(statearr_80097_80136[(2)] = null);

(statearr_80097_80136[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (10))){
var inst_80014 = (state_80060[(7)]);
var inst_80017 = (state_80060[(8)]);
var inst_80011 = (state_80060[(9)]);
var inst_80021 = (state_80060[(10)]);
var inst_80031 = (function (){var responses = inst_80011;
var responses_STAR_ = inst_80014;
var statuses = inst_80017;
var fuel = inst_80021;
return (function (p1__79968_SHARP_){
return ((499) < p1__79968_SHARP_);
});
})();
var inst_80032 = cljs.core.some(inst_80031,inst_80017);
var state_80060__$1 = state_80060;
if(cljs.core.truth_(inst_80032)){
var statearr_80098_80137 = state_80060__$1;
(statearr_80098_80137[(1)] = (12));

} else {
var statearr_80099_80138 = state_80060__$1;
(statearr_80099_80138[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (18))){
var inst_80014 = (state_80060[(7)]);
var inst_80049 = (state_80060[(13)]);
var inst_80044 = (state_80060[(12)]);
var inst_80021 = (state_80060[(10)]);
var inst_80051 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_80014,new cljs.core.Keyword(null,"status","status",-1997798413),inst_80044,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_80021,new cljs.core.Keyword(null,"block","block",664686210),inst_80049], 0));
var state_80060__$1 = state_80060;
var statearr_80100_80139 = state_80060__$1;
(statearr_80100_80139[(2)] = inst_80051);

(statearr_80100_80139[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80061 === (8))){
var inst_80014 = (state_80060[(7)]);
var inst_80017 = (state_80060[(8)]);
var inst_80049 = (state_80060[(13)]);
var inst_80044 = (state_80060[(12)]);
var inst_80011 = (state_80060[(9)]);
var inst_80021 = (state_80060[(10)]);
var inst_80044__$1 = (state_80060[(2)]);
var inst_80045 = (function (){var responses = inst_80011;
var responses_STAR_ = inst_80014;
var statuses = inst_80017;
var fuel = inst_80021;
var status = inst_80044__$1;
return (function (p1__79969_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__79969_SHARP_));
});
})();
var inst_80046 = cljs.core.vals(inst_80011);
var inst_80047 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_80045,inst_80046);
var inst_80048 = cljs.core.first(inst_80047);
var inst_80049__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_80048);
var state_80060__$1 = (function (){var statearr_80101 = state_80060;
(statearr_80101[(13)] = inst_80049__$1);

(statearr_80101[(12)] = inst_80044__$1);

return statearr_80101;
})();
if(cljs.core.truth_(inst_80049__$1)){
var statearr_80102_80140 = state_80060__$1;
(statearr_80102_80140[(1)] = (18));

} else {
var statearr_80103_80141 = state_80060__$1;
(statearr_80103_80141[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_80104 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80104[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_80104[(1)] = (1));

return statearr_80104;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_80060){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_80060);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e80105){var ex__2730__auto__ = e80105;
var statearr_80106_80142 = state_80060;
(statearr_80106_80142[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_80060[(4)]))){
var statearr_80107_80143 = state_80060;
(statearr_80107_80143[(1)] = cljs.core.first((state_80060[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80144 = state_80060;
state_80060 = G__80144;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_80060){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_80060);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_80108 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_80108[(6)] = c__2749__auto__);

return statearr_80108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__80146 = arguments.length;
switch (G__80146) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__80147 = opts;
var map__80147__$1 = cljs.core.__destructure_map(map__80147);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__80147__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__80147__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__80147__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__80147__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__80148 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80148,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80148,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e80151){var e = e80151;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__80154 = arguments.length;
switch (G__80154) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_80188){
var state_val_80189 = (state_80188[(1)]);
if((state_val_80189 === (7))){
var state_80188__$1 = state_80188;
var statearr_80190_80211 = state_80188__$1;
(statearr_80190_80211[(2)] = opts);

(statearr_80190_80211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80189 === (1))){
var state_80188__$1 = state_80188;
var statearr_80191_80212 = state_80188__$1;
(statearr_80191_80212[(2)] = null);

(statearr_80191_80212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80189 === (4))){
var inst_80155 = (state_80188[(2)]);
var inst_80156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80157 = [inst_80155];
var inst_80158 = (new cljs.core.PersistentVector(null,1,(5),inst_80156,inst_80157,null));
var inst_80159 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_80158);
var inst_80160 = cljs.core.ex_data(inst_80155);
var inst_80161 = cljs.core.ex_message(inst_80155);
var inst_80162 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_80160,new cljs.core.Keyword(null,"message","message",-406056002),inst_80161);
var state_80188__$1 = (function (){var statearr_80192 = state_80188;
(statearr_80192[(7)] = inst_80159);

return statearr_80192;
})();
var statearr_80193_80213 = state_80188__$1;
(statearr_80193_80213[(2)] = inst_80162);

(statearr_80193_80213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80189 === (6))){
var inst_80172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80173 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_80174 = (new cljs.core.PersistentVector(null,1,(5),inst_80172,inst_80173,null));
var inst_80175 = cljs.core.assoc_in(opts,inst_80174,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_80188__$1 = state_80188;
var statearr_80194_80214 = state_80188__$1;
(statearr_80194_80214[(2)] = inst_80175);

(statearr_80194_80214[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80189 === (3))){
var inst_80186 = (state_80188[(2)]);
var state_80188__$1 = state_80188;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80188__$1,inst_80186);
} else {
if((state_val_80189 === (2))){
var _ = (function (){var statearr_80196 = state_80188;
(statearr_80196[(4)] = cljs.core.cons((5),(state_80188[(4)])));

return statearr_80196;
})();
var inst_80168 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_80169 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_80170 = (inst_80169 == null);
var state_80188__$1 = (function (){var statearr_80197 = state_80188;
(statearr_80197[(8)] = inst_80168);

return statearr_80197;
})();
if(cljs.core.truth_(inst_80170)){
var statearr_80198_80215 = state_80188__$1;
(statearr_80198_80215[(1)] = (6));

} else {
var statearr_80199_80216 = state_80188__$1;
(statearr_80199_80216[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80189 === (9))){
var inst_80182 = (state_80188[(2)]);
var inst_80183 = fluree.db.util.async.throw_err(inst_80182);
var _ = (function (){var statearr_80200 = state_80188;
(statearr_80200[(4)] = cljs.core.rest((state_80188[(4)])));

return statearr_80200;
})();
var state_80188__$1 = state_80188;
var statearr_80201_80217 = state_80188__$1;
(statearr_80201_80217[(2)] = inst_80183);

(statearr_80201_80217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80189 === (5))){
var _ = (function (){var statearr_80202 = state_80188;
(statearr_80202[(4)] = cljs.core.rest((state_80188[(4)])));

return statearr_80202;
})();
var state_80188__$1 = state_80188;
var ex80195 = (state_80188__$1[(2)]);
var statearr_80203_80218 = state_80188__$1;
(statearr_80203_80218[(5)] = ex80195);


var statearr_80204_80219 = state_80188__$1;
(statearr_80204_80219[(1)] = (4));

(statearr_80204_80219[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80189 === (8))){
var inst_80168 = (state_80188[(8)]);
var inst_80178 = (state_80188[(2)]);
var inst_80179 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_80168,inst_80178);
var inst_80180 = fluree.db.operations.command_async(conn,inst_80179);
var state_80188__$1 = state_80188;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80188__$1,(9),inst_80180);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_80205 = [null,null,null,null,null,null,null,null,null];
(statearr_80205[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_80205[(1)] = (1));

return statearr_80205;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_80188){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_80188);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e80206){var ex__2730__auto__ = e80206;
var statearr_80207_80220 = state_80188;
(statearr_80207_80220[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_80188[(4)]))){
var statearr_80208_80221 = state_80188;
(statearr_80208_80221[(1)] = cljs.core.first((state_80188[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80222 = state_80188;
state_80188 = G__80222;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_80188){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_80188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_80209 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_80209[(6)] = c__2749__auto__);

return statearr_80209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

