// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.connection_js');
goog.require('goog.object');
goog.scope(function(){
flureeworker.goog$module$goog$object = goog.module.get('goog.object');
});
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__73892 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__73892__$1 = cljs.core.__destructure_map(map__73892);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73892__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73892__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"block","block",664686210),time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = flureeworker.goog$module$goog$object.get.call(null,obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__73893 = cljs.core.get_global_hierarchy;
return (fexpr__73893.cljs$core$IFn$_invoke$arity$0 ? fexpr__73893.cljs$core$IFn$_invoke$arity$0() : fexpr__73893.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),(function() { 
var G__73894__delegate = function (conn_id,event,_){
return event;
};
var G__73894 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__73895__i = 0, G__73895__a = new Array(arguments.length -  2);
while (G__73895__i < G__73895__a.length) {G__73895__a[G__73895__i] = arguments[G__73895__i + 2]; ++G__73895__i;}
  _ = new cljs.core.IndexedSeq(G__73895__a,0,null);
} 
return G__73894__delegate.call(this,conn_id,event,_);};
G__73894.cljs$lang$maxFixedArity = 2;
G__73894.cljs$lang$applyTo = (function (arglist__73896){
var conn_id = cljs.core.first(arglist__73896);
arglist__73896 = cljs.core.next(arglist__73896);
var event = cljs.core.first(arglist__73896);
var _ = cljs.core.rest(arglist__73896);
return G__73894__delegate(conn_id,event,_);
});
G__73894.cljs$core$IFn$_invoke$arity$variadic = G__73894__delegate;
return G__73894;
})()
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setState","setState",552299271),(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setState",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connStatus","connStatus",63327857),(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connStatus",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"login","login",55217519),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"login",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"pwGenerate",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connClosed","connClosed",1810797125),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connClosed",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connReset","connReset",-1382938159),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connReset",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setTransact","setTransact",1791803585),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setTransact",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connInit","connInit",-148647574),(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn","conn",278309663),(0),new cljs.core.Keyword(null,"event","event",301435442),"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),(function (){var or__4253__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unknown Error.";
}
})(),new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),e_map,new cljs.core.Keyword(null,"status","status",-1997798413),"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt);
if(cljs.core.truth_(flureeql)){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73914){
var state_val_73915 = (state_73914[(1)]);
if((state_val_73915 === (1))){
var inst_73897 = new cljs.core.Keyword(null,"forceTime","forceTime",827124337).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_73898 = flureeworker.conn_id__GT_db(conn_id,inst_73897);
var inst_73899 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,new cljs.core.Keyword(null,"opts","opts",155075701),opts_SINGLEQUOTE_);
var inst_73900 = fluree.db.api.query.query(inst_73898,inst_73899);
var state_73914__$1 = state_73914;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73914__$1,(2),inst_73900);
} else {
if((state_val_73915 === (2))){
var inst_73902 = (state_73914[(7)]);
var inst_73902__$1 = (state_73914[(2)]);
var inst_73903 = fluree.db.util.core.exception_QMARK_(inst_73902__$1);
var state_73914__$1 = (function (){var statearr_73916 = state_73914;
(statearr_73916[(7)] = inst_73902__$1);

return statearr_73916;
})();
if(inst_73903){
var statearr_73917_73930 = state_73914__$1;
(statearr_73917_73930[(1)] = (3));

} else {
var statearr_73918_73931 = state_73914__$1;
(statearr_73918_73931[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73915 === (3))){
var inst_73902 = (state_73914[(7)]);
var inst_73905 = flureeworker.error_return_map(inst_73902);
var state_73914__$1 = state_73914;
var statearr_73919_73932 = state_73914__$1;
(statearr_73919_73932[(2)] = inst_73905);

(statearr_73919_73932[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73915 === (4))){
var inst_73902 = (state_73914[(7)]);
var inst_73907 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_73908 = [inst_73902,"loaded"];
var inst_73909 = cljs.core.PersistentHashMap.fromArrays(inst_73907,inst_73908);
var state_73914__$1 = state_73914;
var statearr_73920_73933 = state_73914__$1;
(statearr_73920_73933[(2)] = inst_73909);

(statearr_73920_73933[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73915 === (5))){
var inst_73911 = (state_73914[(2)]);
var inst_73912 = (function (){var G__73921 = conn_id;
var G__73922 = new cljs.core.Keyword(null,"setState","setState",552299271);
var G__73923 = id;
var G__73924 = inst_73911;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73921,G__73922,G__73923,G__73924) : flureeworker.worker_action.call(null,G__73921,G__73922,G__73923,G__73924));
})();
var state_73914__$1 = state_73914;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73914__$1,inst_73912);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$process_query_$_state_machine__2727__auto__ = null;
var flureeworker$process_query_$_state_machine__2727__auto____0 = (function (){
var statearr_73925 = [null,null,null,null,null,null,null,null];
(statearr_73925[(0)] = flureeworker$process_query_$_state_machine__2727__auto__);

(statearr_73925[(1)] = (1));

return statearr_73925;
});
var flureeworker$process_query_$_state_machine__2727__auto____1 = (function (state_73914){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73914);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73926){var ex__2730__auto__ = e73926;
var statearr_73927_73934 = state_73914;
(statearr_73927_73934[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73914[(4)]))){
var statearr_73928_73935 = state_73914;
(statearr_73928_73935[(1)] = cljs.core.first((state_73914[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73936 = state_73914;
state_73914 = G__73936;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__2727__auto__ = function(state_73914){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__2727__auto____1.call(this,state_73914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__2727__auto____0;
flureeworker$process_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__2727__auto____1;
return flureeworker$process_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73929 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73929[(6)] = c__2749__auto__);

return statearr_73929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__73937 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__73937__$1 = cljs.core.__destructure_map(map__73937);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73937__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73937__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var query_ids = cljs.core.keys(queries);
var seq__73938 = cljs.core.seq(query_ids);
var chunk__73939 = null;
var count__73940 = (0);
var i__73941 = (0);
while(true){
if((i__73941 < count__73940)){
var id = chunk__73939.cljs$core$IIndexed$_nth$arity$2(null,i__73941);
flureeworker.process_query(conn_id,id,opts);


var G__73942 = seq__73938;
var G__73943 = chunk__73939;
var G__73944 = count__73940;
var G__73945 = (i__73941 + (1));
seq__73938 = G__73942;
chunk__73939 = G__73943;
count__73940 = G__73944;
i__73941 = G__73945;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__73938);
if(temp__5804__auto__){
var seq__73938__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__73938__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__73938__$1);
var G__73946 = cljs.core.chunk_rest(seq__73938__$1);
var G__73947 = c__4679__auto__;
var G__73948 = cljs.core.count(c__4679__auto__);
var G__73949 = (0);
seq__73938 = G__73946;
chunk__73939 = G__73947;
count__73940 = G__73948;
i__73941 = G__73949;
continue;
} else {
var id = cljs.core.first(seq__73938__$1);
flureeworker.process_query(conn_id,id,opts);


var G__73950 = cljs.core.next(seq__73938__$1);
var G__73951 = null;
var G__73952 = (0);
var G__73953 = (0);
seq__73938 = G__73950;
chunk__73939 = G__73951;
count__73940 = G__73952;
i__73941 = G__73953;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__73954 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73954,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73954,(1),null);
var cb = (function (header,data){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73962){
var state_val_73963 = (state_73962[(1)]);
if((state_val_73963 === (1))){
var inst_73957 = cljs.core.async.timeout((100));
var state_73962__$1 = state_73962;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73962__$1,(2),inst_73957);
} else {
if((state_val_73963 === (2))){
var inst_73959 = (state_73962[(2)]);
var inst_73960 = flureeworker.process_all_queries(conn_id);
var state_73962__$1 = (function (){var statearr_73964 = state_73962;
(statearr_73964[(7)] = inst_73959);

return statearr_73964;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_73962__$1,inst_73960);
} else {
return null;
}
}
});
return (function() {
var flureeworker$ledger_listener_$_state_machine__2727__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__2727__auto____0 = (function (){
var statearr_73965 = [null,null,null,null,null,null,null,null];
(statearr_73965[(0)] = flureeworker$ledger_listener_$_state_machine__2727__auto__);

(statearr_73965[(1)] = (1));

return statearr_73965;
});
var flureeworker$ledger_listener_$_state_machine__2727__auto____1 = (function (state_73962){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73962);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73966){var ex__2730__auto__ = e73966;
var statearr_73967_73970 = state_73962;
(statearr_73967_73970[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73962[(4)]))){
var statearr_73968_73971 = state_73962;
(statearr_73968_73971[(1)] = cljs.core.first((state_73962[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73972 = state_73962;
state_73962 = G__73972;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__2727__auto__ = function(state_73962){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__2727__auto____1.call(this,state_73962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__2727__auto____0;
flureeworker$ledger_listener_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__2727__auto____1;
return flureeworker$ledger_listener_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73969 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73969[(6)] = c__2749__auto__);

return statearr_73969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__73973 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73973,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73973,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__73976 = config;
var map__73976__$1 = cljs.core.__destructure_map(map__73976);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73976__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73976__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73976__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73976__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73976__$1,new cljs.core.Keyword(null,"compact","compact",-348732150));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73976__$1,new cljs.core.Keyword(null,"private","private",-558947994));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"closed","closed",-919675359),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"conn","conn",278309663)],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"compact","compact",-348732150),compact], null),servers,(function (){var or__4253__auto__ = queries;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__73977 = conn_data;
var map__73977__$1 = cljs.core.__destructure_map(map__73977);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73977__$1,new cljs.core.Keyword(null,"config","config",994861415));
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73977__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73977__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var map__73978 = config;
var map__73978__$1 = cljs.core.__destructure_map(map__73978);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73978__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73978__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73978__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73978__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73984){
var state_val_73985 = (state_73984[(1)]);
if((state_val_73985 === (1))){
var inst_73979 = cljs.core.async.timeout((100));
var state_73984__$1 = state_73984;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73984__$1,(2),inst_73979);
} else {
if((state_val_73985 === (2))){
var inst_73981 = (state_73984[(2)]);
var inst_73982 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_73984__$1 = (function (){var statearr_73986 = state_73984;
(statearr_73986[(7)] = inst_73981);

return statearr_73986;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_73984__$1,inst_73982);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_STAR__$_state_machine__2727__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__2727__auto____0 = (function (){
var statearr_73987 = [null,null,null,null,null,null,null,null];
(statearr_73987[(0)] = flureeworker$connect_STAR__$_state_machine__2727__auto__);

(statearr_73987[(1)] = (1));

return statearr_73987;
});
var flureeworker$connect_STAR__$_state_machine__2727__auto____1 = (function (state_73984){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73984);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73988){var ex__2730__auto__ = e73988;
var statearr_73989_74000 = state_73984;
(statearr_73989_74000[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73984[(4)]))){
var statearr_73990_74001 = state_73984;
(statearr_73990_74001[(1)] = cljs.core.first((state_73984[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74002 = state_73984;
state_73984 = G__74002;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__2727__auto__ = function(state_73984){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__2727__auto____1.call(this,state_73984);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__2727__auto____0;
flureeworker$connect_STAR__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__2727__auto____1;
return flureeworker$connect_STAR__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73991 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73991[(6)] = c__2749__auto__);

return statearr_73991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}):null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__73992_74003 = conn_id;
var G__73993_74004 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__73994_74005 = ref;
var G__73995_74006 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73992_74003,G__73993_74004,G__73994_74005,G__73995_74006) : flureeworker.worker_action.call(null,G__73992_74003,G__73993_74004,G__73994_74005,G__73995_74006));

return flureeworker.process_all_queries(conn_id);
})).catch((function (error){
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__73996 = conn_id;
var G__73997 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__73998 = ref;
var G__73999 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__73996,G__73997,G__73998,G__73999) : flureeworker.worker_action.call(null,G__73996,G__73997,G__73998,G__73999));
}));
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__74008 = arguments.length;
switch (G__74008) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
}));

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__74009 = conn_data;
var map__74009__$1 = cljs.core.__destructure_map(map__74009);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74009__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74009__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74009__$1,new cljs.core.Keyword(null,"config","config",994861415));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74009__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"closed","closed",-919675359),true,new cljs.core.Keyword(null,"config","config",994861415),config,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null));
if((((conn_data == null)) || (new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection closed."], null);
}
}));

(flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2);

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__74016 = conn_id;
var G__74017 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__74018 = ref;
var G__74019 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74016,G__74017,G__74018,G__74019) : flureeworker.worker_action.call(null,G__74016,G__74017,G__74018,G__74019));
}catch (e74011){var e = e74011;
var msg = (function (){var or__4253__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4253__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__74012 = conn_id;
var G__74013 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__74014 = ref;
var G__74015 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74012,G__74013,G__74014,G__74015) : flureeworker.worker_action.call(null,G__74012,G__74013,G__74014,G__74015));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e74020){var e = e74020;
var msg = (function (){var or__4253__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4253__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__74021 = conn_id;
var G__74022 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__74023 = ref;
var G__74024 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74021,G__74022,G__74023,G__74024) : flureeworker.worker_action.call(null,G__74021,G__74022,G__74023,G__74024));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__74025 = config_STAR_;
var map__74025__$1 = cljs.core.__destructure_map(map__74025);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74025__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74025__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74025__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74025__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"finest","finest",-1359568890)):null);
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74031){
var state_val_74032 = (state_74031[(1)]);
if((state_val_74032 === (1))){
var inst_74026 = cljs.core.async.timeout((100));
var state_74031__$1 = state_74031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74031__$1,(2),inst_74026);
} else {
if((state_val_74032 === (2))){
var inst_74028 = (state_74031[(2)]);
var inst_74029 = flureeworker.connect_STAR_(id,ref);
var state_74031__$1 = (function (){var statearr_74033 = state_74031;
(statearr_74033[(7)] = inst_74028);

return statearr_74033;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_74031__$1,inst_74029);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_p_$_state_machine__2727__auto__ = null;
var flureeworker$connect_p_$_state_machine__2727__auto____0 = (function (){
var statearr_74034 = [null,null,null,null,null,null,null,null];
(statearr_74034[(0)] = flureeworker$connect_p_$_state_machine__2727__auto__);

(statearr_74034[(1)] = (1));

return statearr_74034;
});
var flureeworker$connect_p_$_state_machine__2727__auto____1 = (function (state_74031){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74031);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74035){var ex__2730__auto__ = e74035;
var statearr_74036_74047 = state_74031;
(statearr_74036_74047[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74031[(4)]))){
var statearr_74037_74048 = state_74031;
(statearr_74037_74048[(1)] = cljs.core.first((state_74031[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74049 = state_74031;
state_74031 = G__74049;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__2727__auto__ = function(state_74031){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__2727__auto____1.call(this,state_74031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__2727__auto____0;
flureeworker$connect_p_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__2727__auto____1;
return flureeworker$connect_p_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74038 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74038[(6)] = c__2749__auto__);

return statearr_74038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}):null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__74039 = id;
var G__74040 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__74041 = ref;
var G__74042 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74039,G__74040,G__74041,G__74042) : flureeworker.worker_action.call(null,G__74039,G__74040,G__74041,G__74042));
})).catch((function (error){
var G__74043 = id;
var G__74044 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__74045 = ref;
var G__74046 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74043,G__74044,G__74045,G__74046) : flureeworker.worker_action.call(null,G__74043,G__74044,G__74045,G__74046));
}));
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"closed","closed",-919675359)], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__4870__auto__ = [];
var len__4864__auto___74117 = arguments.length;
var i__4865__auto___74118 = (0);
while(true){
if((i__4865__auto___74118 < len__4864__auto___74117)){
args__4870__auto__.push((arguments[i__4865__auto___74118]));

var G__74119 = (i__4865__auto___74118 + (1));
i__4865__auto___74118 = G__74119;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((4) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4871__auto__);
});

(flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__74055){
var vec__74056 = p__74055;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74056,(0),null);
var map__74059 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__74059__$1 = cljs.core.__destructure_map(map__74059);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74059__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74059__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74059__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__74060 = conn_id;
var G__74061 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74062 = ref;
var G__74063 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74060,G__74061,G__74062,G__74063) : flureeworker.worker_action.call(null,G__74060,G__74061,G__74062,G__74063));
})());
var auth = null;
var c__2749__auto___74120 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74084){
var state_val_74085 = (state_74084[(1)]);
if((state_val_74085 === (1))){
var state_74084__$1 = state_74084;
var statearr_74086_74121 = state_74084__$1;
(statearr_74086_74121[(2)] = null);

(statearr_74086_74121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74085 === (2))){
var ___$1 = (function (){var statearr_74087 = state_74084;
(statearr_74087[(4)] = cljs.core.cons((5),(state_74084[(4)])));

return statearr_74087;
})();
var inst_74075 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_74076 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__74088 = conn_id;
var G__74089 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74090 = ref;
var G__74091 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74088,G__74089,G__74090,G__74091) : flureeworker.worker_action.call(null,G__74088,G__74089,G__74090,G__74091));
});
})();
var inst_74077 = inst_74075.then(inst_74076);
var inst_74078 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e74092){var ___$2 = e74092;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__74093 = conn_id;
var G__74094 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74095 = ref;
var G__74096 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74093,G__74094,G__74095,G__74096) : flureeworker.worker_action.call(null,G__74093,G__74094,G__74095,G__74096));
} else {
var G__74097 = conn_id;
var G__74098 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74099 = ref;
var G__74100 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74097,G__74098,G__74099,G__74100) : flureeworker.worker_action.call(null,G__74097,G__74098,G__74099,G__74100));

}
});
})();
var inst_74079 = inst_74077.catch(inst_74078);
var ___$2 = (function (){var statearr_74101 = state_74084;
(statearr_74101[(4)] = cljs.core.rest((state_74084[(4)])));

return statearr_74101;
})();
var state_74084__$1 = state_74084;
var statearr_74102_74122 = state_74084__$1;
(statearr_74102_74122[(2)] = inst_74079);

(statearr_74102_74122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74085 === (3))){
var inst_74082 = (state_74084[(2)]);
var state_74084__$1 = state_74084;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74084__$1,inst_74082);
} else {
if((state_val_74085 === (4))){
var inst_74064 = (state_74084[(2)]);
var inst_74065 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_74066 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74064);
var inst_74067 = [(400),inst_74066];
var inst_74068 = cljs.core.PersistentHashMap.fromArrays(inst_74065,inst_74067);
var inst_74069 = (function (){var G__74104 = conn_id;
var G__74105 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74106 = ref;
var G__74107 = inst_74068;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74104,G__74105,G__74106,G__74107) : flureeworker.worker_action.call(null,G__74104,G__74105,G__74106,G__74107));
})();
var state_74084__$1 = state_74084;
var statearr_74108_74123 = state_74084__$1;
(statearr_74108_74123[(2)] = inst_74069);

(statearr_74108_74123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74085 === (5))){
var ___$1 = (function (){var statearr_74109 = state_74084;
(statearr_74109[(4)] = cljs.core.rest((state_74084[(4)])));

return statearr_74109;
})();
var state_74084__$1 = state_74084;
var ex74103 = (state_74084__$1[(2)]);
var statearr_74110_74124 = state_74084__$1;
(statearr_74110_74124[(5)] = ex74103);


var statearr_74111_74125 = state_74084__$1;
(statearr_74111_74125[(1)] = (4));

(statearr_74111_74125[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$state_machine__2727__auto__ = null;
var flureeworker$state_machine__2727__auto____0 = (function (){
var statearr_74112 = [null,null,null,null,null,null,null];
(statearr_74112[(0)] = flureeworker$state_machine__2727__auto__);

(statearr_74112[(1)] = (1));

return statearr_74112;
});
var flureeworker$state_machine__2727__auto____1 = (function (state_74084){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74084);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74113){var ex__2730__auto__ = e74113;
var statearr_74114_74126 = state_74084;
(statearr_74114_74126[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74084[(4)]))){
var statearr_74115_74127 = state_74084;
(statearr_74115_74127[(1)] = cljs.core.first((state_74084[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74128 = state_74084;
state_74084 = G__74128;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$state_machine__2727__auto__ = function(state_74084){
switch(arguments.length){
case 0:
return flureeworker$state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$state_machine__2727__auto____1.call(this,state_74084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__2727__auto____0;
flureeworker$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__2727__auto____1;
return flureeworker$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74116 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74116[(6)] = c__2749__auto___74120);

return statearr_74116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return true;
}));

(flureeworker.login.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(flureeworker.login.cljs$lang$applyTo = (function (seq74050){
var G__74051 = cljs.core.first(seq74050);
var seq74050__$1 = cljs.core.next(seq74050);
var G__74052 = cljs.core.first(seq74050__$1);
var seq74050__$2 = cljs.core.next(seq74050__$1);
var G__74053 = cljs.core.first(seq74050__$2);
var seq74050__$3 = cljs.core.next(seq74050__$2);
var G__74054 = cljs.core.first(seq74050__$3);
var seq74050__$4 = cljs.core.next(seq74050__$3);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74051,G__74052,G__74053,G__74054,seq74050__$4);
}));

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__74129 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__74129__$1 = cljs.core.__destructure_map(map__74129);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74129__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74129__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__74131 = conn_id;
var G__74132 = new cljs.core.Keyword(null,"login","login",55217519);
var G__74133 = ref;
var G__74134 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74131,G__74132,G__74133,G__74134) : flureeworker.worker_action.call(null,G__74131,G__74132,G__74133,G__74134));
})());
var map__74130 = map_data;
var map__74130__$1 = cljs.core.__destructure_map(map__74130);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74130__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74130__$1,new cljs.core.Keyword(null,"password","password",417022471));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74130__$1,new cljs.core.Keyword(null,"options","options",99638489));
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),new cljs.core.Keyword(null,"user","user",1532431356),username);
var c__2749__auto___74188 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74155){
var state_val_74156 = (state_74155[(1)]);
if((state_val_74156 === (1))){
var state_74155__$1 = state_74155;
var statearr_74157_74189 = state_74155__$1;
(statearr_74157_74189[(2)] = null);

(statearr_74157_74189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74156 === (2))){
var ___$1 = (function (){var statearr_74158 = state_74155;
(statearr_74158[(4)] = cljs.core.cons((5),(state_74155[(4)])));

return statearr_74158;
})();
var inst_74146 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_74147 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__74159 = conn_id;
var G__74160 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__74161 = ref;
var G__74162 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74159,G__74160,G__74161,G__74162) : flureeworker.worker_action.call(null,G__74159,G__74160,G__74161,G__74162));
});
})();
var inst_74148 = inst_74146.then(inst_74147);
var inst_74149 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e74163){var ___$2 = e74163;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__74164 = conn_id;
var G__74165 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__74166 = ref;
var G__74167 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74164,G__74165,G__74166,G__74167) : flureeworker.worker_action.call(null,G__74164,G__74165,G__74166,G__74167));
} else {
var G__74168 = conn_id;
var G__74169 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__74170 = ref;
var G__74171 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74168,G__74169,G__74170,G__74171) : flureeworker.worker_action.call(null,G__74168,G__74169,G__74170,G__74171));

}
});
})();
var inst_74150 = inst_74148.catch(inst_74149);
var ___$2 = (function (){var statearr_74172 = state_74155;
(statearr_74172[(4)] = cljs.core.rest((state_74155[(4)])));

return statearr_74172;
})();
var state_74155__$1 = state_74155;
var statearr_74173_74190 = state_74155__$1;
(statearr_74173_74190[(2)] = inst_74150);

(statearr_74173_74190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74156 === (3))){
var inst_74153 = (state_74155[(2)]);
var state_74155__$1 = state_74155;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74155__$1,inst_74153);
} else {
if((state_val_74156 === (4))){
var inst_74135 = (state_74155[(2)]);
var inst_74136 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_74137 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74135);
var inst_74138 = [(400),inst_74137];
var inst_74139 = cljs.core.PersistentHashMap.fromArrays(inst_74136,inst_74138);
var inst_74140 = (function (){var G__74175 = conn_id;
var G__74176 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__74177 = ref;
var G__74178 = inst_74139;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__74175,G__74176,G__74177,G__74178) : flureeworker.worker_action.call(null,G__74175,G__74176,G__74177,G__74178));
})();
var state_74155__$1 = state_74155;
var statearr_74179_74191 = state_74155__$1;
(statearr_74179_74191[(2)] = inst_74140);

(statearr_74179_74191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74156 === (5))){
var ___$1 = (function (){var statearr_74180 = state_74155;
(statearr_74180[(4)] = cljs.core.rest((state_74155[(4)])));

return statearr_74180;
})();
var state_74155__$1 = state_74155;
var ex74174 = (state_74155__$1[(2)]);
var statearr_74181_74192 = state_74155__$1;
(statearr_74181_74192[(5)] = ex74174);


var statearr_74182_74193 = state_74155__$1;
(statearr_74182_74193[(1)] = (4));

(statearr_74182_74193[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$pw_generate_$_state_machine__2727__auto__ = null;
var flureeworker$pw_generate_$_state_machine__2727__auto____0 = (function (){
var statearr_74183 = [null,null,null,null,null,null,null];
(statearr_74183[(0)] = flureeworker$pw_generate_$_state_machine__2727__auto__);

(statearr_74183[(1)] = (1));

return statearr_74183;
});
var flureeworker$pw_generate_$_state_machine__2727__auto____1 = (function (state_74155){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_74155);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74184){var ex__2730__auto__ = e74184;
var statearr_74185_74194 = state_74155;
(statearr_74185_74194[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_74155[(4)]))){
var statearr_74186_74195 = state_74155;
(statearr_74186_74195[(1)] = cljs.core.first((state_74155[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74196 = state_74155;
state_74155 = G__74196;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__2727__auto__ = function(state_74155){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__2727__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__2727__auto____1.call(this,state_74155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__2727__auto____0;
flureeworker$pw_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__2727__auto____1;
return flureeworker$pw_generate_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74187 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_74187[(6)] = c__2749__auto___74188);

return statearr_74187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"opts","opts",155075701)], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return new cljs.core.Keyword(null,"TODO","TODO",-523795145);
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__74197_SHARP_){
return (js_array[p1__74197_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),action_str,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"status","status",-1997798413),(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e74198){var e = e74198;
var data = (event["data"]);
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),(data["conn"]),new cljs.core.Keyword(null,"event","event",301435442),(data["action"]),new cljs.core.Keyword(null,"ref","ref",1289896967),(data["ref"]),new cljs.core.Keyword(null,"data","data",-232669377),error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5804__auto___74199 = cljs.core.not(self.document);
if(temp__5804__auto___74199){
var worker_QMARK__74200 = temp__5804__auto___74199;
(self.onerror = flureeworker.log_error);

(self.onmessage = flureeworker.decode_message);
} else {
}
var G__74201_74203 = null;
var G__74202_74204 = new cljs.core.Keyword(null,"connInit","connInit",-148647574);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__74201_74203,G__74202_74204) : flureeworker.worker_action.call(null,G__74201_74203,G__74202_74204));
