// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('fluree.db.util.bytes');
goog.require('fluree.db.util.core');
goog.require('goog.object');
goog.scope(function(){
fluree.db.util.json.goog$module$goog$object = goog.module.get('goog.object');
});
fluree.db.util.json.clj__GT_js_SINGLEQUOTE_ = (function fluree$db$util$json$clj__GT_js_SINGLEQUOTE_(var_args){
var G__11656 = arguments.length;
switch (G__11656) {
case 1:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675),fluree.db.util.core.keyword__GT_str], null));
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var map__11657 = options;
var map__11657__$1 = cljs.core.__destructure_map(map__11657);
var keyword_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11657__$1,new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675));
var keyfn = (function fluree$db$util$json$keyfn(k){
return cljs.core.key__GT_js.cljs$core$IFn$_invoke$arity$2(k,thisfn);
});
var thisfn = (function fluree$db$util$json$thisfn(x__$1){
if((x__$1 == null)){
return null;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js(x__$1);
} else {
if((x__$1 instanceof cljs.core.Keyword)){
return (keyword_fn.cljs$core$IFn$_invoke$arity$1 ? keyword_fn.cljs$core$IFn$_invoke$arity$1(x__$1) : keyword_fn.call(null,x__$1));
} else {
if((x__$1 instanceof cljs.core.Symbol)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1);
} else {
if(cljs.core.map_QMARK_(x__$1)){
var m = ({});
var seq__11696_11729 = cljs.core.seq(x__$1);
var chunk__11697_11730 = null;
var count__11698_11731 = (0);
var i__11699_11732 = (0);
while(true){
if((i__11699_11732 < count__11698_11731)){
var vec__11712_11733 = chunk__11697_11730.cljs$core$IIndexed$_nth$arity$2(null,i__11699_11732);
var k_11734 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11712_11733,(0),null);
var v_11735 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11712_11733,(1),null);
var G__11715_11736 = m;
var G__11716_11737 = keyfn(k_11734);
var G__11717_11738 = fluree$db$util$json$thisfn(v_11735);
fluree.db.util.json.goog$module$goog$object.set.call(null,G__11715_11736,G__11716_11737,G__11717_11738);


var G__11739 = seq__11696_11729;
var G__11740 = chunk__11697_11730;
var G__11741 = count__11698_11731;
var G__11742 = (i__11699_11732 + (1));
seq__11696_11729 = G__11739;
chunk__11697_11730 = G__11740;
count__11698_11731 = G__11741;
i__11699_11732 = G__11742;
continue;
} else {
var temp__5804__auto___11743 = cljs.core.seq(seq__11696_11729);
if(temp__5804__auto___11743){
var seq__11696_11744__$1 = temp__5804__auto___11743;
if(cljs.core.chunked_seq_QMARK_(seq__11696_11744__$1)){
var c__4679__auto___11745 = cljs.core.chunk_first(seq__11696_11744__$1);
var G__11746 = cljs.core.chunk_rest(seq__11696_11744__$1);
var G__11747 = c__4679__auto___11745;
var G__11748 = cljs.core.count(c__4679__auto___11745);
var G__11749 = (0);
seq__11696_11729 = G__11746;
chunk__11697_11730 = G__11747;
count__11698_11731 = G__11748;
i__11699_11732 = G__11749;
continue;
} else {
var vec__11718_11750 = cljs.core.first(seq__11696_11744__$1);
var k_11751 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11718_11750,(0),null);
var v_11752 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11718_11750,(1),null);
var G__11721_11753 = m;
var G__11722_11754 = keyfn(k_11751);
var G__11723_11755 = fluree$db$util$json$thisfn(v_11752);
fluree.db.util.json.goog$module$goog$object.set.call(null,G__11721_11753,G__11722_11754,G__11723_11755);


var G__11756 = cljs.core.next(seq__11696_11744__$1);
var G__11757 = null;
var G__11758 = (0);
var G__11759 = (0);
seq__11696_11729 = G__11756;
chunk__11697_11730 = G__11757;
count__11698_11731 = G__11758;
i__11699_11732 = G__11759;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x__$1)){
var arr = [];
var seq__11724_11760 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree$db$util$json$thisfn,x__$1));
var chunk__11725_11761 = null;
var count__11726_11762 = (0);
var i__11727_11763 = (0);
while(true){
if((i__11727_11763 < count__11726_11762)){
var x_11764__$2 = chunk__11725_11761.cljs$core$IIndexed$_nth$arity$2(null,i__11727_11763);
arr.push(x_11764__$2);


var G__11765 = seq__11724_11760;
var G__11766 = chunk__11725_11761;
var G__11767 = count__11726_11762;
var G__11768 = (i__11727_11763 + (1));
seq__11724_11760 = G__11765;
chunk__11725_11761 = G__11766;
count__11726_11762 = G__11767;
i__11727_11763 = G__11768;
continue;
} else {
var temp__5804__auto___11769 = cljs.core.seq(seq__11724_11760);
if(temp__5804__auto___11769){
var seq__11724_11770__$1 = temp__5804__auto___11769;
if(cljs.core.chunked_seq_QMARK_(seq__11724_11770__$1)){
var c__4679__auto___11771 = cljs.core.chunk_first(seq__11724_11770__$1);
var G__11772 = cljs.core.chunk_rest(seq__11724_11770__$1);
var G__11773 = c__4679__auto___11771;
var G__11774 = cljs.core.count(c__4679__auto___11771);
var G__11775 = (0);
seq__11724_11760 = G__11772;
chunk__11725_11761 = G__11773;
count__11726_11762 = G__11774;
i__11727_11763 = G__11775;
continue;
} else {
var x_11776__$2 = cljs.core.first(seq__11724_11770__$1);
arr.push(x_11776__$2);


var G__11777 = cljs.core.next(seq__11724_11770__$1);
var G__11778 = null;
var G__11779 = (0);
var G__11780 = (0);
seq__11724_11760 = G__11777;
chunk__11725_11761 = G__11778;
count__11726_11762 = G__11779;
i__11727_11763 = G__11780;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x__$1;

}
}
}
}
}
}
});
return thisfn(x);
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2);

fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string(x))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
});
fluree.db.util.json.stringify_preserve_namespace = (function fluree$db$util$json$stringify_preserve_namespace(x){
return JSON.stringify(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1(x));
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js(x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8(fluree.db.util.json.stringify(x));
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),depth)){
return ((cljs.core.every_QMARK_(cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count(coordinates))));
} else {
return (((!((coordinates == null)))) && (((cljs.core.every_QMARK_(cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11781_SHARP_){
var G__11782 = (depth - (1));
var G__11783 = p1__11781_SHARP_;
return (fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2(G__11782,G__11783) : fluree.db.util.json.valid_coordinates_QMARK_.call(null,G__11782,G__11783));
}),coordinates))))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_(coordinates)) && (((((4) <= cljs.core.count(coordinates))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(coordinates),cljs.core.last(coordinates))))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__11784 = cljs.core.get_global_hierarchy;
return (fexpr__11784.cljs$core$IFn$_invoke$arity$0 ? fexpr__11784.cljs$core$IFn$_invoke$arity$0() : fexpr__11784.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.util.json","valid-geojson?"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Feature",(function (geometry){
var and__4251__auto__ = (function (){var or__4253__auto__ = (function (){var G__11785 = new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry);
return (fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1(G__11785) : fluree.db.util.json.valid_geojson_QMARK_.call(null,G__11785));
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__4251__auto__)){
return ((cljs.core.map_QMARK_(new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry))) || ((new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__4251__auto__;
}
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((1),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((4),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_((function (p1__11786_SHARP_){
return cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,p1__11786_SHARP_);
}),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (geometry){
return false;
}));
