// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.subject');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('fluree.db.index');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.common');
goog.require('fluree.db.dbproto');
/**
 * Returns chan of subjects in chunks per index-leaf
 *   that can be pulled as needed based on the selection criteria of a where clause.
 */
fluree.db.query.subject_crawl.subject.subjects_chan = (function fluree$db$query$subject_crawl$subject$subjects_chan(p__21800,error_ch,vars,p__21801){
var map__21802 = p__21800;
var map__21802__$1 = cljs.core.__destructure_map(map__21802);
var db = map__21802__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21802__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var novelty = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21802__$1,new cljs.core.Keyword(null,"novelty","novelty",-1590246024));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21802__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__21803 = p__21801;
var map__21803__$1 = cljs.core.__destructure_map(map__21803);
var _where_clause = map__21803__$1;
var p = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21803__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21803__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21803__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var o_STAR_ = (function (){var temp__5806__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if((temp__5806__auto__ == null)){
var temp__5804__auto__ = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(temp__5804__auto__)){
var variable = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,variable);
} else {
return null;
}
} else {
var v = temp__5806__auto__;
return v;
}
})();
var vec__21804 = (function (){var G__21807 = idx;
var G__21807__$1 = (((G__21807 instanceof cljs.core.Keyword))?G__21807.fqn:null);
switch (G__21807__$1) {
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake(null,p,o_STAR_,null,null,(-2147483647)),fluree.db.flake.__GT_Flake(null,p,o_STAR_,null,null,(2147483647))], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake(null,p,null,null,null,(-2147483647)),fluree.db.flake.__GT_Flake(null,p,null,null,null,(2147483647))], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__21807__$1)].join('')));

}
})();
var fflake = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21804,(0),null);
var lflake = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21804,(1),null);
var filter_fn = (cljs.core.truth_((function (){var and__4251__auto__ = o_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"psot","psot",2111653059),idx);
} else {
return and__4251__auto__;
}
})())?(function (p1__21798_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o_STAR_,fluree.db.flake.o(p1__21798_SHARP_));
}):(cljs.core.truth_(new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(o))?(function (){var f = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(o,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"function","function",-2127255473)], null));
return (function (p1__21799_SHARP_){
var G__21808 = fluree.db.flake.o(p1__21799_SHARP_);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__21808) : f.call(null,G__21808));
});
})():null));
var idx_root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(idx_root);
var range_set = fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fflake,lflake], 0));
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_(node,range_set);
});
var query_xf = fluree.db.query.subject_crawl.common.where_subj_xf(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"start-test","start-test",-952983565),cljs.core._GT__EQ_,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),fflake,new cljs.core.Keyword(null,"end-test","end-test",481973727),cljs.core._LT__EQ_,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),lflake,new cljs.core.Keyword(null,"xf","xf",401902988),(cljs.core.truth_(filter_fn)?cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(filter_fn,flakes);
})):null)], null));
var resolver = fluree.db.index.__GT_CachedTRangeResolver(conn,cljs.core.get.cljs$core$IFn$_invoke$arity$2(novelty,idx),t,t,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(conn));
var tree_chan = fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(resolver,idx_root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
var return_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((10),cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.flake.s),cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0()));
var c__2749__auto___21878 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21847){
var state_val_21848 = (state_21847[(1)]);
if((state_val_21848 === (7))){
var inst_21843 = (state_21847[(2)]);
var state_21847__$1 = state_21847;
var statearr_21849_21879 = state_21847__$1;
(statearr_21849_21879[(2)] = inst_21843);

(statearr_21849_21879[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (1))){
var state_21847__$1 = state_21847;
var statearr_21850_21880 = state_21847__$1;
(statearr_21850_21880[(2)] = null);

(statearr_21850_21880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (4))){
var inst_21811 = (state_21847[(7)]);
var inst_21811__$1 = (state_21847[(2)]);
var inst_21812 = (inst_21811__$1 == null);
var state_21847__$1 = (function (){var statearr_21851 = state_21847;
(statearr_21851[(7)] = inst_21811__$1);

return statearr_21851;
})();
if(cljs.core.truth_(inst_21812)){
var statearr_21852_21881 = state_21847__$1;
(statearr_21852_21881[(1)] = (5));

} else {
var statearr_21853_21882 = state_21847__$1;
(statearr_21853_21882[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (15))){
var state_21847__$1 = state_21847;
var statearr_21854_21883 = state_21847__$1;
(statearr_21854_21883[(2)] = false);

(statearr_21854_21883[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (13))){
var inst_21823 = (state_21847[(2)]);
var state_21847__$1 = state_21847;
if(cljs.core.truth_(inst_21823)){
var statearr_21855_21884 = state_21847__$1;
(statearr_21855_21884[(1)] = (14));

} else {
var statearr_21856_21885 = state_21847__$1;
(statearr_21856_21885[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (6))){
var inst_21811 = (state_21847[(7)]);
var inst_21816 = cljs.core.seq(inst_21811);
var inst_21817 = inst_21816;
var inst_21818 = (0);
var state_21847__$1 = (function (){var statearr_21857 = state_21847;
(statearr_21857[(8)] = inst_21818);

(statearr_21857[(9)] = inst_21817);

return statearr_21857;
})();
var statearr_21858_21886 = state_21847__$1;
(statearr_21858_21886[(2)] = null);

(statearr_21858_21886[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (17))){
var state_21847__$1 = state_21847;
var statearr_21859_21887 = state_21847__$1;
(statearr_21859_21887[(2)] = null);

(statearr_21859_21887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (3))){
var inst_21845 = (state_21847[(2)]);
var state_21847__$1 = state_21847;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21847__$1,inst_21845);
} else {
if((state_val_21848 === (12))){
var inst_21833 = (state_21847[(2)]);
var state_21847__$1 = state_21847;
var statearr_21860_21888 = state_21847__$1;
(statearr_21860_21888[(2)] = inst_21833);

(statearr_21860_21888[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (2))){
var state_21847__$1 = state_21847;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21847__$1,(4),tree_chan);
} else {
if((state_val_21848 === (19))){
var inst_21841 = (state_21847[(2)]);
var state_21847__$1 = state_21847;
var statearr_21861_21889 = state_21847__$1;
(statearr_21861_21889[(2)] = inst_21841);

(statearr_21861_21889[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (11))){
var state_21847__$1 = state_21847;
var statearr_21862_21890 = state_21847__$1;
(statearr_21862_21890[(2)] = true);

(statearr_21862_21890[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (9))){
var inst_21835 = (state_21847[(2)]);
var state_21847__$1 = state_21847;
if(cljs.core.truth_(inst_21835)){
var statearr_21863_21891 = state_21847__$1;
(statearr_21863_21891[(1)] = (17));

} else {
var statearr_21864_21892 = state_21847__$1;
(statearr_21864_21892[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (5))){
var inst_21814 = cljs.core.async.close_BANG_(return_chan);
var state_21847__$1 = state_21847;
var statearr_21865_21893 = state_21847__$1;
(statearr_21865_21893[(2)] = inst_21814);

(statearr_21865_21893[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (14))){
var inst_21818 = (state_21847[(8)]);
var inst_21817 = (state_21847[(9)]);
var inst_21825 = cljs.core.next(inst_21817);
var inst_21826 = (inst_21818 + (1));
var inst_21817__$1 = inst_21825;
var inst_21818__$1 = inst_21826;
var state_21847__$1 = (function (){var statearr_21866 = state_21847;
(statearr_21866[(8)] = inst_21818__$1);

(statearr_21866[(9)] = inst_21817__$1);

return statearr_21866;
})();
var statearr_21867_21894 = state_21847__$1;
(statearr_21867_21894[(2)] = null);

(statearr_21867_21894[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (16))){
var inst_21830 = (state_21847[(2)]);
var state_21847__$1 = state_21847;
var statearr_21868_21895 = state_21847__$1;
(statearr_21868_21895[(2)] = inst_21830);

(statearr_21868_21895[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (10))){
var inst_21817 = (state_21847[(9)]);
var inst_21821 = cljs.core.first(inst_21817);
var state_21847__$1 = state_21847;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21847__$1,(13),return_chan,inst_21821);
} else {
if((state_val_21848 === (18))){
var inst_21839 = cljs.core.async.close_BANG_(return_chan);
var state_21847__$1 = state_21847;
var statearr_21869_21896 = state_21847__$1;
(statearr_21869_21896[(2)] = inst_21839);

(statearr_21869_21896[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21848 === (8))){
var inst_21817 = (state_21847[(9)]);
var state_21847__$1 = state_21847;
if(cljs.core.truth_(inst_21817)){
var statearr_21870_21897 = state_21847__$1;
(statearr_21870_21897[(1)] = (10));

} else {
var statearr_21871_21898 = state_21847__$1;
(statearr_21871_21898[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0 = (function (){
var statearr_21872 = [null,null,null,null,null,null,null,null,null,null];
(statearr_21872[(0)] = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__);

(statearr_21872[(1)] = (1));

return statearr_21872;
});
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1 = (function (state_21847){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21847);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21873){var ex__2730__auto__ = e21873;
var statearr_21874_21899 = state_21847;
(statearr_21874_21899[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21847[(4)]))){
var statearr_21875_21900 = state_21847;
(statearr_21875_21900[(1)] = cljs.core.first((state_21847[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21901 = state_21847;
state_21847 = G__21901;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__ = function(state_21847){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1.call(this,state_21847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21876 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21876[(6)] = c__2749__auto___21878);

return statearr_21876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_chan;
});
fluree.db.query.subject_crawl.subject.flakes_xf = (function fluree$db$query$subject_crawl$subject$flakes_xf(p__21902){
var map__21903 = p__21902;
var map__21903__$1 = cljs.core.__destructure_map(map__21903);
var _opts = map__21903__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21903__$1,new cljs.core.Keyword(null,"db","db",993250759));
var fuel_vol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21903__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21903__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21903__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21903__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var filter_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21903__$1,new cljs.core.Keyword(null,"filter-map","filter-map",-314788257));
var permissioned_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21903__$1,new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803));
var permissions = (cljs.core.truth_(permissioned_QMARK_)?fluree.db.query.subject_crawl.common.subj_perm_filter_fn(db):null);
return (function (sid,port){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21948){
var state_val_21949 = (state_21948[(1)]);
if((state_val_21949 === (7))){
var inst_21919 = (state_21948[(7)]);
var inst_21921 = fluree.db.query.subject_crawl.common.filter_subject(vars,filter_map,inst_21919);
var state_21948__$1 = state_21948;
var statearr_21950_21986 = state_21948__$1;
(statearr_21950_21986[(2)] = inst_21921);

(statearr_21950_21986[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (1))){
var state_21948__$1 = state_21948;
var statearr_21951_21987 = state_21948__$1;
(statearr_21951_21987[(2)] = null);

(statearr_21951_21987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (4))){
var inst_21904 = (state_21948[(2)]);
var inst_21905 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_21904);
var inst_21906 = cljs.core.async.close_BANG_(port);
var state_21948__$1 = (function (){var statearr_21952 = state_21948;
(statearr_21952[(8)] = inst_21906);

(statearr_21952[(9)] = inst_21905);

return statearr_21952;
})();
var statearr_21953_21988 = state_21948__$1;
(statearr_21953_21988[(2)] = null);

(statearr_21953_21988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (15))){
var inst_21936 = (state_21948[(10)]);
var inst_21936__$1 = (state_21948[(2)]);
var inst_21937 = cljs.core.seq(inst_21936__$1);
var state_21948__$1 = (function (){var statearr_21954 = state_21948;
(statearr_21954[(10)] = inst_21936__$1);

return statearr_21954;
})();
if(inst_21937){
var statearr_21955_21989 = state_21948__$1;
(statearr_21955_21989[(1)] = (17));

} else {
var statearr_21956_21990 = state_21948__$1;
(statearr_21956_21990[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (13))){
var inst_21929 = (state_21948[(11)]);
var state_21948__$1 = state_21948;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21948__$1,(16),inst_21929);
} else {
if((state_val_21949 === (6))){
var inst_21918 = (state_21948[(2)]);
var inst_21919 = fluree.db.util.async.throw_err(inst_21918);
var state_21948__$1 = (function (){var statearr_21957 = state_21948;
(statearr_21957[(7)] = inst_21919);

return statearr_21957;
})();
if(cljs.core.truth_(filter_map)){
var statearr_21958_21991 = state_21948__$1;
(statearr_21958_21991[(1)] = (7));

} else {
var statearr_21959_21992 = state_21948__$1;
(statearr_21959_21992[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (17))){
var inst_21936 = (state_21948[(10)]);
var inst_21939 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_21936);
var state_21948__$1 = state_21948;
var statearr_21960_21993 = state_21948__$1;
(statearr_21960_21993[(2)] = inst_21939);

(statearr_21960_21993[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (3))){
var inst_21946 = (state_21948[(2)]);
var state_21948__$1 = state_21948;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21948__$1,inst_21946);
} else {
if((state_val_21949 === (12))){
var inst_21929 = (state_21948[(2)]);
var state_21948__$1 = (function (){var statearr_21961 = state_21948;
(statearr_21961[(11)] = inst_21929);

return statearr_21961;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_21962_21994 = state_21948__$1;
(statearr_21962_21994[(1)] = (13));

} else {
var statearr_21963_21995 = state_21948__$1;
(statearr_21963_21995[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (2))){
var _ = (function (){var statearr_21964 = state_21948;
(statearr_21964[(4)] = cljs.core.cons((5),(state_21948[(4)])));

return statearr_21964;
})();
var inst_21913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21914 = [sid];
var inst_21915 = (new cljs.core.PersistentVector(null,1,(5),inst_21913,inst_21914,null));
var inst_21916 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21915);
var state_21948__$1 = state_21948;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21948__$1,(6),inst_21916);
} else {
if((state_val_21949 === (19))){
var inst_21942 = (state_21948[(2)]);
var inst_21943 = cljs.core.async.close_BANG_(port);
var _ = (function (){var statearr_21965 = state_21948;
(statearr_21965[(4)] = cljs.core.rest((state_21948[(4)])));

return statearr_21965;
})();
var state_21948__$1 = (function (){var statearr_21966 = state_21948;
(statearr_21966[(12)] = inst_21942);

return statearr_21966;
})();
var statearr_21967_21996 = state_21948__$1;
(statearr_21967_21996[(2)] = inst_21943);

(statearr_21967_21996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (11))){
var inst_21924 = (state_21948[(13)]);
var state_21948__$1 = state_21948;
var statearr_21969_21997 = state_21948__$1;
(statearr_21969_21997[(2)] = inst_21924);

(statearr_21969_21997[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (9))){
var inst_21924 = (state_21948[(2)]);
var state_21948__$1 = (function (){var statearr_21970 = state_21948;
(statearr_21970[(13)] = inst_21924);

return statearr_21970;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_21971_21998 = state_21948__$1;
(statearr_21971_21998[(1)] = (10));

} else {
var statearr_21972_21999 = state_21948__$1;
(statearr_21972_21999[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (5))){
var _ = (function (){var statearr_21973 = state_21948;
(statearr_21973[(4)] = cljs.core.rest((state_21948[(4)])));

return statearr_21973;
})();
var state_21948__$1 = state_21948;
var ex21968 = (state_21948__$1[(2)]);
var statearr_21974_22000 = state_21948__$1;
(statearr_21974_22000[(5)] = ex21968);


var statearr_21975_22001 = state_21948__$1;
(statearr_21975_22001[(1)] = (4));

(statearr_21975_22001[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (14))){
var inst_21929 = (state_21948[(11)]);
var state_21948__$1 = state_21948;
var statearr_21976_22002 = state_21948__$1;
(statearr_21976_22002[(2)] = inst_21929);

(statearr_21976_22002[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (16))){
var inst_21932 = (state_21948[(2)]);
var inst_21933 = fluree.db.util.async.throw_err(inst_21932);
var state_21948__$1 = state_21948;
var statearr_21977_22003 = state_21948__$1;
(statearr_21977_22003[(2)] = inst_21933);

(statearr_21977_22003[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (10))){
var inst_21924 = (state_21948[(13)]);
var inst_21926 = (permissions.cljs$core$IFn$_invoke$arity$1 ? permissions.cljs$core$IFn$_invoke$arity$1(inst_21924) : permissions.call(null,inst_21924));
var state_21948__$1 = state_21948;
var statearr_21978_22004 = state_21948__$1;
(statearr_21978_22004[(2)] = inst_21926);

(statearr_21978_22004[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (18))){
var state_21948__$1 = state_21948;
var statearr_21979_22005 = state_21948__$1;
(statearr_21979_22005[(2)] = null);

(statearr_21979_22005[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21949 === (8))){
var inst_21919 = (state_21948[(7)]);
var state_21948__$1 = state_21948;
var statearr_21980_22006 = state_21948__$1;
(statearr_21980_22006[(2)] = inst_21919);

(statearr_21980_22006[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0 = (function (){
var statearr_21981 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21981[(0)] = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__);

(statearr_21981[(1)] = (1));

return statearr_21981;
});
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1 = (function (state_21948){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21948);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21982){var ex__2730__auto__ = e21982;
var statearr_21983_22007 = state_21948;
(statearr_21983_22007[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21948[(4)]))){
var statearr_21984_22008 = state_21948;
(statearr_21984_22008[(1)] = cljs.core.first((state_21948[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22009 = state_21948;
state_21948 = G__22009;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__ = function(state_21948){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1.call(this,state_21948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21985 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21985[(6)] = c__2749__auto__);

return statearr_21985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
});
/**
 * For queries that specify _id as the predicate, we will have a
 *   single subject as a value.
 */
fluree.db.query.subject_crawl.subject.subjects_id_chan = (function fluree$db$query$subject_crawl$subject$subjects_id_chan(db,error_ch,vars,p__22010){
var map__22011 = p__22010;
var map__22011__$1 = cljs.core.__destructure_map(map__22011);
var f_where = map__22011__$1;
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22011__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var return_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var _id_val = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
}
})();
if(cljs.core.truth_(_id_val)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["When using _id as the predicate, a value must be provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f_where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var c__2749__auto___22048 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22031){
var state_val_22032 = (state_22031[(1)]);
if((state_val_22032 === (7))){
var inst_22019 = (state_22031[(7)]);
var inst_22022 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_22019);
var state_22031__$1 = state_22031;
var statearr_22033_22049 = state_22031__$1;
(statearr_22033_22049[(2)] = inst_22022);

(statearr_22033_22049[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22032 === (1))){
var inst_22012 = typeof _id_val === 'number';
var state_22031__$1 = state_22031;
if(cljs.core.truth_(inst_22012)){
var statearr_22034_22050 = state_22031__$1;
(statearr_22034_22050[(1)] = (2));

} else {
var statearr_22035_22051 = state_22031__$1;
(statearr_22035_22051[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22032 === (4))){
var inst_22028 = (state_22031[(2)]);
var inst_22029 = cljs.core.async.close_BANG_(return_ch);
var state_22031__$1 = (function (){var statearr_22036 = state_22031;
(statearr_22036[(8)] = inst_22028);

return statearr_22036;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_22031__$1,inst_22029);
} else {
if((state_val_22032 === (6))){
var inst_22019 = (state_22031[(7)]);
var inst_22019__$1 = (state_22031[(2)]);
var inst_22020 = fluree.db.util.core.exception_QMARK_(inst_22019__$1);
var state_22031__$1 = (function (){var statearr_22037 = state_22031;
(statearr_22037[(7)] = inst_22019__$1);

return statearr_22037;
})();
if(inst_22020){
var statearr_22038_22052 = state_22031__$1;
(statearr_22038_22052[(1)] = (7));

} else {
var statearr_22039_22053 = state_22031__$1;
(statearr_22039_22053[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22032 === (3))){
var inst_22017 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,_id_val);
var state_22031__$1 = state_22031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22031__$1,(6),inst_22017);
} else {
if((state_val_22032 === (2))){
var state_22031__$1 = state_22031;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22031__$1,(5),return_ch,_id_val);
} else {
if((state_val_22032 === (9))){
var inst_22026 = (state_22031[(2)]);
var state_22031__$1 = state_22031;
var statearr_22040_22054 = state_22031__$1;
(statearr_22040_22054[(2)] = inst_22026);

(statearr_22040_22054[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22032 === (5))){
var inst_22015 = (state_22031[(2)]);
var state_22031__$1 = state_22031;
var statearr_22041_22055 = state_22031__$1;
(statearr_22041_22055[(2)] = inst_22015);

(statearr_22041_22055[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22032 === (8))){
var inst_22019 = (state_22031[(7)]);
var inst_22024 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_22019);
var state_22031__$1 = state_22031;
var statearr_22042_22056 = state_22031__$1;
(statearr_22042_22056[(2)] = inst_22024);

(statearr_22042_22056[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0 = (function (){
var statearr_22043 = [null,null,null,null,null,null,null,null,null];
(statearr_22043[(0)] = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__);

(statearr_22043[(1)] = (1));

return statearr_22043;
});
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1 = (function (state_22031){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22031);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22044){var ex__2730__auto__ = e22044;
var statearr_22045_22057 = state_22031;
(statearr_22045_22057[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22031[(4)]))){
var statearr_22046_22058 = state_22031;
(statearr_22046_22058[(1)] = cljs.core.first((state_22031[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22059 = state_22031;
state_22031 = G__22059;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__ = function(state_22031){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1.call(this,state_22031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22047 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22047[(6)] = c__2749__auto___22048);

return statearr_22047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_ch;
});
fluree.db.query.subject_crawl.subject.subj_crawl = (function fluree$db$query$subject_crawl$subject$subj_crawl(p__22060){
var map__22061 = p__22060;
var map__22061__$1 = cljs.core.__destructure_map(map__22061);
var opts = map__22061__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22061__$1,new cljs.core.Keyword(null,"db","db",993250759));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22061__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var f_where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22061__$1,new cljs.core.Keyword(null,"f-where","f-where",-958007776));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22061__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22061__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22061__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22061__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var finish_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22061__$1,new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22128){
var state_val_22129 = (state_22128[(1)]);
if((state_val_22129 === (7))){
var inst_22073 = fluree.db.query.subject_crawl.subject.subjects_chan(db,error_ch,vars,f_where);
var state_22128__$1 = state_22128;
var statearr_22130_22167 = state_22128__$1;
(statearr_22130_22167[(2)] = inst_22073);

(statearr_22130_22167[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (20))){
var inst_22117 = (state_22128[(2)]);
var state_22128__$1 = state_22128;
var statearr_22131_22168 = state_22128__$1;
(statearr_22131_22168[(2)] = inst_22117);

(statearr_22131_22168[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (1))){
var state_22128__$1 = state_22128;
var statearr_22132_22169 = state_22128__$1;
(statearr_22132_22169[(2)] = null);

(statearr_22132_22169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (4))){
var inst_22062 = (state_22128[(2)]);
var state_22128__$1 = state_22128;
var statearr_22133_22170 = state_22128__$1;
(statearr_22133_22170[(2)] = inst_22062);

(statearr_22133_22170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (15))){
var inst_22081 = (state_22128[(7)]);
var inst_22080 = (state_22128[(8)]);
var inst_22086 = (state_22128[(9)]);
var inst_22075 = (state_22128[(10)]);
var inst_22107 = cljs.core.async.close_BANG_(inst_22075);
var inst_22108 = cljs.core.async.close_BANG_(inst_22080);
var inst_22109 = cljs.core.async.close_BANG_(inst_22081);
var inst_22110 = (finish_fn.cljs$core$IFn$_invoke$arity$1 ? finish_fn.cljs$core$IFn$_invoke$arity$1(inst_22086) : finish_fn.call(null,inst_22086));
var state_22128__$1 = (function (){var statearr_22134 = state_22128;
(statearr_22134[(11)] = inst_22108);

(statearr_22134[(12)] = inst_22107);

(statearr_22134[(13)] = inst_22109);

return statearr_22134;
})();
var statearr_22135_22171 = state_22128__$1;
(statearr_22135_22171[(2)] = inst_22110);

(statearr_22135_22171[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (13))){
var inst_22096 = (state_22128[(14)]);
var inst_22105 = (inst_22096 == null);
var state_22128__$1 = state_22128;
if(cljs.core.truth_(inst_22105)){
var statearr_22136_22172 = state_22128__$1;
(statearr_22136_22172[(1)] = (15));

} else {
var statearr_22137_22173 = state_22128__$1;
(statearr_22137_22173[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (6))){
var inst_22071 = fluree.db.query.subject_crawl.subject.subjects_id_chan(db,error_ch,vars,f_where);
var state_22128__$1 = state_22128;
var statearr_22138_22174 = state_22128__$1;
(statearr_22138_22174[(2)] = inst_22071);

(statearr_22138_22174[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (17))){
var inst_22119 = (state_22128[(2)]);
var state_22128__$1 = state_22128;
var statearr_22139_22175 = state_22128__$1;
(statearr_22139_22175[(2)] = inst_22119);

(statearr_22139_22175[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (3))){
var inst_22126 = (state_22128[(2)]);
var state_22128__$1 = state_22128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22128__$1,inst_22126);
} else {
if((state_val_22129 === (12))){
var inst_22081 = (state_22128[(7)]);
var inst_22080 = (state_22128[(8)]);
var inst_22096 = (state_22128[(14)]);
var inst_22075 = (state_22128[(10)]);
var inst_22100 = cljs.core.async.close_BANG_(inst_22075);
var inst_22101 = cljs.core.async.close_BANG_(inst_22080);
var inst_22102 = cljs.core.async.close_BANG_(inst_22081);
var inst_22103 = (function(){throw inst_22096})();
var state_22128__$1 = (function (){var statearr_22140 = state_22128;
(statearr_22140[(15)] = inst_22101);

(statearr_22140[(16)] = inst_22100);

(statearr_22140[(17)] = inst_22102);

return statearr_22140;
})();
var statearr_22141_22176 = state_22128__$1;
(statearr_22141_22176[(2)] = inst_22103);

(statearr_22141_22176[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (2))){
var _ = (function (){var statearr_22142 = state_22128;
(statearr_22142[(4)] = cljs.core.cons((5),(state_22128[(4)])));

return statearr_22142;
})();
var inst_22068 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where);
var inst_22069 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"_id","_id",-789960287),inst_22068);
var state_22128__$1 = state_22128;
if(inst_22069){
var statearr_22143_22177 = state_22128__$1;
(statearr_22143_22177[(1)] = (6));

} else {
var statearr_22144_22178 = state_22128__$1;
(statearr_22144_22178[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (19))){
var state_22128__$1 = state_22128;
var statearr_22145_22179 = state_22128__$1;
(statearr_22145_22179[(2)] = null);

(statearr_22145_22179[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (11))){
var inst_22095 = (state_22128[(2)]);
var inst_22096 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22095,(0),null);
var inst_22097 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22095,(1),null);
var inst_22098 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_22097,error_ch);
var state_22128__$1 = (function (){var statearr_22147 = state_22128;
(statearr_22147[(14)] = inst_22096);

return statearr_22147;
})();
if(inst_22098){
var statearr_22148_22180 = state_22128__$1;
(statearr_22148_22180[(1)] = (12));

} else {
var statearr_22149_22181 = state_22128__$1;
(statearr_22149_22181[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (9))){
var inst_22081 = (state_22128[(7)]);
var inst_22091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22092 = [error_ch,inst_22081];
var inst_22093 = (new cljs.core.PersistentVector(null,2,(5),inst_22091,inst_22092,null));
var state_22128__$1 = state_22128;
return cljs.core.async.ioc_alts_BANG_(state_22128__$1,(11),inst_22093);
} else {
if((state_val_22129 === (5))){
var _ = (function (){var statearr_22150 = state_22128;
(statearr_22150[(4)] = cljs.core.rest((state_22128[(4)])));

return statearr_22150;
})();
var state_22128__$1 = state_22128;
var ex22146 = (state_22128__$1[(2)]);
var statearr_22151_22182 = state_22128__$1;
(statearr_22151_22182[(5)] = ex22146);


if((ex22146 instanceof Error)){
var statearr_22152_22183 = state_22128__$1;
(statearr_22152_22183[(1)] = (4));

(statearr_22152_22183[(5)] = null);

} else {
throw ex22146;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (14))){
var inst_22121 = (state_22128[(2)]);
var state_22128__$1 = state_22128;
var statearr_22153_22184 = state_22128__$1;
(statearr_22153_22184[(2)] = inst_22121);

(statearr_22153_22184[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (16))){
var state_22128__$1 = state_22128;
var statearr_22154_22185 = state_22128__$1;
(statearr_22154_22185[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (10))){
var inst_22123 = (state_22128[(2)]);
var _ = (function (){var statearr_22156 = state_22128;
(statearr_22156[(4)] = cljs.core.rest((state_22128[(4)])));

return statearr_22156;
})();
var state_22128__$1 = state_22128;
var statearr_22157_22186 = state_22128__$1;
(statearr_22157_22186[(2)] = inst_22123);

(statearr_22157_22186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (18))){
var inst_22086 = (state_22128[(9)]);
var inst_22096 = (state_22128[(14)]);
var inst_22113 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22086,inst_22096);
var inst_22086__$1 = inst_22113;
var state_22128__$1 = (function (){var statearr_22158 = state_22128;
(statearr_22158[(9)] = inst_22086__$1);

return statearr_22158;
})();
var statearr_22159_22187 = state_22128__$1;
(statearr_22159_22187[(2)] = null);

(statearr_22159_22187[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22129 === (8))){
var inst_22081 = (state_22128[(7)]);
var inst_22080 = (state_22128[(8)]);
var inst_22075 = (state_22128[(10)]);
var inst_22075__$1 = (state_22128[(2)]);
var inst_22076 = fluree.db.query.subject_crawl.subject.flakes_xf(opts);
var inst_22077 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_22078 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_22079 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_22077,inst_22078);
var inst_22080__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((32),inst_22079);
var inst_22081__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_22082 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_22080__$1,inst_22076,inst_22075__$1);
var inst_22083 = fluree.db.query.subject_crawl.common.result_af(opts);
var inst_22084 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_22081__$1,inst_22083,inst_22080__$1);
var inst_22085 = cljs.core.PersistentVector.EMPTY;
var inst_22086 = inst_22085;
var state_22128__$1 = (function (){var statearr_22160 = state_22128;
(statearr_22160[(7)] = inst_22081__$1);

(statearr_22160[(8)] = inst_22080__$1);

(statearr_22160[(18)] = inst_22082);

(statearr_22160[(9)] = inst_22086);

(statearr_22160[(19)] = inst_22084);

(statearr_22160[(10)] = inst_22075__$1);

return statearr_22160;
})();
var statearr_22161_22188 = state_22128__$1;
(statearr_22161_22188[(2)] = null);

(statearr_22161_22188[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0 = (function (){
var statearr_22162 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22162[(0)] = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__);

(statearr_22162[(1)] = (1));

return statearr_22162;
});
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1 = (function (state_22128){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22128);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22163){var ex__2730__auto__ = e22163;
var statearr_22164_22189 = state_22128;
(statearr_22164_22189[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22128[(4)]))){
var statearr_22165_22190 = state_22128;
(statearr_22165_22190[(1)] = cljs.core.first((state_22128[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22191 = state_22128;
state_22128 = G__22191;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__ = function(state_22128){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1.call(this,state_22128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22166 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22166[(6)] = c__2749__auto__);

return statearr_22166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
