// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.common');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.query.fql_resp');
/**
 * Transducing function to extract matching subjects from initial where clause.
 */
fluree.db.query.subject_crawl.common.where_subj_xf = (function fluree$db$query$subject_crawl$common$where_subj_xf(p__21612){
var map__21613 = p__21612;
var map__21613__$1 = cljs.core.__destructure_map(map__21613);
var start_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21613__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21613__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21613__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21613__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var xf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21613__$1,new cljs.core.Keyword(null,"xf","xf",401902988));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,(function (){var G__21614 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$5(flakes,start_test,start_flake,end_test,end_flake);
}))], null);
if(cljs.core.truth_(xf)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__21614,xf);
} else {
return G__21614;
}
})());
});
fluree.db.query.subject_crawl.common.result_af = (function fluree$db$query$subject_crawl$common$result_af(p__21615){
var map__21616 = p__21615;
var map__21616__$1 = cljs.core.__destructure_map(map__21616);
var _opts = map__21616__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21616__$1,new cljs.core.Keyword(null,"db","db",993250759));
var cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21616__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var fuel_vol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21616__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21616__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var select_spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21616__$1,new cljs.core.Keyword(null,"select-spec","select-spec",55073283));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21616__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
return (function (flakes,port){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21647){
var state_val_21648 = (state_21647[(1)]);
if((state_val_21648 === (7))){
var state_21647__$1 = state_21647;
var statearr_21649_21675 = state_21647__$1;
(statearr_21649_21675[(2)] = null);

(statearr_21649_21675[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21648 === (1))){
var state_21647__$1 = state_21647;
var statearr_21650_21676 = state_21647__$1;
(statearr_21650_21676[(2)] = null);

(statearr_21650_21676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21648 === (4))){
var inst_21617 = (state_21647[(2)]);
var inst_21618 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_21617);
var inst_21619 = cljs.core.async.close_BANG_(port);
var state_21647__$1 = (function (){var statearr_21651 = state_21647;
(statearr_21651[(7)] = inst_21618);

(statearr_21651[(8)] = inst_21619);

return statearr_21651;
})();
var statearr_21652_21677 = state_21647__$1;
(statearr_21652_21677[(2)] = null);

(statearr_21652_21677[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21648 === (6))){
var inst_21629 = (state_21647[(9)]);
var inst_21628 = (state_21647[(2)]);
var inst_21629__$1 = fluree.db.util.async.throw_err(inst_21628);
var inst_21630 = (inst_21629__$1 == null);
var state_21647__$1 = (function (){var statearr_21653 = state_21647;
(statearr_21653[(9)] = inst_21629__$1);

return statearr_21653;
})();
if(cljs.core.truth_(inst_21630)){
var statearr_21654_21678 = state_21647__$1;
(statearr_21654_21678[(1)] = (7));

} else {
var statearr_21655_21679 = state_21647__$1;
(statearr_21655_21679[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21648 === (3))){
var inst_21645 = (state_21647[(2)]);
var state_21647__$1 = state_21647;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21647__$1,inst_21645);
} else {
if((state_val_21648 === (12))){
var inst_21641 = (state_21647[(2)]);
var inst_21642 = cljs.core.async.close_BANG_(port);
var _ = (function (){var statearr_21656 = state_21647;
(statearr_21656[(4)] = cljs.core.rest((state_21647[(4)])));

return statearr_21656;
})();
var state_21647__$1 = (function (){var statearr_21657 = state_21647;
(statearr_21657[(10)] = inst_21641);

return statearr_21657;
})();
var statearr_21658_21680 = state_21647__$1;
(statearr_21658_21680[(2)] = inst_21642);

(statearr_21658_21680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21648 === (2))){
var _ = (function (){var statearr_21659 = state_21647;
(statearr_21659[(4)] = cljs.core.cons((5),(state_21647[(4)])));

return statearr_21659;
})();
var inst_21626 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel_vol,max_fuel,select_spec,flakes);
var state_21647__$1 = state_21647;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21647__$1,(6),inst_21626);
} else {
if((state_val_21648 === (11))){
var inst_21635 = (state_21647[(11)]);
var inst_21639 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_21635);
var state_21647__$1 = state_21647;
var statearr_21661_21681 = state_21647__$1;
(statearr_21661_21681[(2)] = inst_21639);

(statearr_21661_21681[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21648 === (9))){
var inst_21635 = (state_21647[(11)]);
var inst_21635__$1 = (state_21647[(2)]);
var inst_21636 = (inst_21635__$1 == null);
var state_21647__$1 = (function (){var statearr_21662 = state_21647;
(statearr_21662[(11)] = inst_21635__$1);

return statearr_21662;
})();
if(cljs.core.truth_(inst_21636)){
var statearr_21663_21682 = state_21647__$1;
(statearr_21663_21682[(1)] = (10));

} else {
var statearr_21664_21683 = state_21647__$1;
(statearr_21664_21683[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21648 === (5))){
var _ = (function (){var statearr_21665 = state_21647;
(statearr_21665[(4)] = cljs.core.rest((state_21647[(4)])));

return statearr_21665;
})();
var state_21647__$1 = state_21647;
var ex21660 = (state_21647__$1[(2)]);
var statearr_21666_21684 = state_21647__$1;
(statearr_21666_21684[(5)] = ex21660);


var statearr_21667_21685 = state_21647__$1;
(statearr_21667_21685[(1)] = (4));

(statearr_21667_21685[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21648 === (10))){
var state_21647__$1 = state_21647;
var statearr_21668_21686 = state_21647__$1;
(statearr_21668_21686[(2)] = null);

(statearr_21668_21686[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21648 === (8))){
var inst_21629 = (state_21647[(9)]);
var inst_21633 = cljs.core.not_empty(inst_21629);
var state_21647__$1 = state_21647;
var statearr_21669_21687 = state_21647__$1;
(statearr_21669_21687[(2)] = inst_21633);

(statearr_21669_21687[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0 = (function (){
var statearr_21670 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21670[(0)] = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__);

(statearr_21670[(1)] = (1));

return statearr_21670;
});
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1 = (function (state_21647){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21647);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21671){var ex__2730__auto__ = e21671;
var statearr_21672_21688 = state_21647;
(statearr_21672_21688[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21647[(4)]))){
var statearr_21673_21689 = state_21647;
(statearr_21673_21689[(1)] = cljs.core.first((state_21647[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21690 = state_21647;
state_21647 = G__21690;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__ = function(state_21647){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1.call(this,state_21647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21674 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21674[(6)] = c__2749__auto__);

return statearr_21674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
});
/**
 * Returns a specific filtering function which takes all subject flakes and
 *   returns the flakes allowed, or nil if none are allowed.
 */
fluree.db.query.subject_crawl.common.subj_perm_filter_fn = (function fluree$db$query$subject_crawl$common$subj_perm_filter_fn(p__21691){
var map__21692 = p__21691;
var map__21692__$1 = cljs.core.__destructure_map(map__21692);
var db = map__21692__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21692__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var pred_permissions_QMARK_ = cljs.core.contains_QMARK_(permissions,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
var coll_permissions = new cljs.core.Keyword(null,"collection","collection",-683361892).cljs$core$IFn$_invoke$arity$1(permissions);
var filter_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var default_deny_QMARK_ = ((new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(coll_permissions) === true)?false:true);
var filter_predicates_QMARK_ = (function (cid){
var temp__5806__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(filter_cache),cid);
if((temp__5806__auto__ == null)){
var coll_perm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll_permissions,cid);
var filter_QMARK_ = ((fluree.db.util.schema.is_schema_cid_QMARK_(cid))?false:((pred_permissions_QMARK_)?true:(((coll_perm == null))?default_deny_QMARK_:((((cljs.core.contains_QMARK_(coll_perm,new cljs.core.Keyword(null,"all","all",892129742))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(coll_perm)))))?false:true
))));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(filter_cache,cljs.core.assoc,cid,filter_QMARK_);

return cljs.core.filter;
} else {
var cached = temp__5806__auto__;
return cached;
}
});
return (function (flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21723){
var state_val_21724 = (state_21723[(1)]);
if((state_val_21724 === (7))){
var inst_21699 = (state_21723[(7)]);
var inst_21709 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_21699);
var state_21723__$1 = state_21723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21723__$1,(10),inst_21709);
} else {
if((state_val_21724 === (1))){
var state_21723__$1 = state_21723;
var statearr_21725_21748 = state_21723__$1;
(statearr_21725_21748[(2)] = null);

(statearr_21725_21748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21724 === (4))){
var inst_21693 = (state_21723[(2)]);
var state_21723__$1 = state_21723;
var statearr_21726_21749 = state_21723__$1;
(statearr_21726_21749[(2)] = inst_21693);

(statearr_21726_21749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21724 === (13))){
var inst_21716 = (state_21723[(2)]);
var state_21723__$1 = state_21723;
var statearr_21727_21750 = state_21723__$1;
(statearr_21727_21750[(2)] = inst_21716);

(statearr_21727_21750[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21724 === (6))){
var inst_21704 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,flakes);
var state_21723__$1 = state_21723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21723__$1,(9),inst_21704);
} else {
if((state_val_21724 === (3))){
var inst_21721 = (state_21723[(2)]);
var state_21723__$1 = state_21723;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21723__$1,inst_21721);
} else {
if((state_val_21724 === (12))){
var state_21723__$1 = state_21723;
var statearr_21728_21751 = state_21723__$1;
(statearr_21728_21751[(2)] = null);

(statearr_21728_21751[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21724 === (2))){
var inst_21699 = (state_21723[(7)]);
var _ = (function (){var statearr_21729 = state_21723;
(statearr_21729[(4)] = cljs.core.cons((5),(state_21723[(4)])));

return statearr_21729;
})();
var inst_21699__$1 = cljs.core.first(flakes);
var inst_21700 = fluree.db.flake.s(inst_21699__$1);
var inst_21701 = fluree.db.flake.sid__GT_cid(inst_21700);
var inst_21702 = filter_predicates_QMARK_(inst_21701);
var state_21723__$1 = (function (){var statearr_21730 = state_21723;
(statearr_21730[(7)] = inst_21699__$1);

return statearr_21730;
})();
if(cljs.core.truth_(inst_21702)){
var statearr_21731_21752 = state_21723__$1;
(statearr_21731_21752[(1)] = (6));

} else {
var statearr_21732_21753 = state_21723__$1;
(statearr_21732_21753[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21724 === (11))){
var state_21723__$1 = state_21723;
var statearr_21734_21754 = state_21723__$1;
(statearr_21734_21754[(2)] = flakes);

(statearr_21734_21754[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21724 === (9))){
var inst_21706 = (state_21723[(2)]);
var inst_21707 = fluree.db.util.async.throw_err(inst_21706);
var state_21723__$1 = state_21723;
var statearr_21735_21755 = state_21723__$1;
(statearr_21735_21755[(2)] = inst_21707);

(statearr_21735_21755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21724 === (5))){
var _ = (function (){var statearr_21736 = state_21723;
(statearr_21736[(4)] = cljs.core.rest((state_21723[(4)])));

return statearr_21736;
})();
var state_21723__$1 = state_21723;
var ex21733 = (state_21723__$1[(2)]);
var statearr_21737_21756 = state_21723__$1;
(statearr_21737_21756[(5)] = ex21733);


if((ex21733 instanceof Error)){
var statearr_21738_21757 = state_21723__$1;
(statearr_21738_21757[(1)] = (4));

(statearr_21738_21757[(5)] = null);

} else {
throw ex21733;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21724 === (10))){
var inst_21711 = (state_21723[(2)]);
var inst_21712 = fluree.db.util.async.throw_err(inst_21711);
var state_21723__$1 = state_21723;
if(cljs.core.truth_(inst_21712)){
var statearr_21739_21758 = state_21723__$1;
(statearr_21739_21758[(1)] = (11));

} else {
var statearr_21740_21759 = state_21723__$1;
(statearr_21740_21759[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21724 === (8))){
var inst_21718 = (state_21723[(2)]);
var _ = (function (){var statearr_21741 = state_21723;
(statearr_21741[(4)] = cljs.core.rest((state_21723[(4)])));

return statearr_21741;
})();
var state_21723__$1 = state_21723;
var statearr_21742_21760 = state_21723__$1;
(statearr_21742_21760[(2)] = inst_21718);

(statearr_21742_21760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_21743 = [null,null,null,null,null,null,null,null];
(statearr_21743[(0)] = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__);

(statearr_21743[(1)] = (1));

return statearr_21743;
});
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1 = (function (state_21723){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21723);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21744){var ex__2730__auto__ = e21744;
var statearr_21745_21761 = state_21723;
(statearr_21745_21761[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21723[(4)]))){
var statearr_21746_21762 = state_21723;
(statearr_21746_21762[(1)] = cljs.core.first((state_21723[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21763 = state_21723;
state_21723 = G__21763;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__ = function(state_21723){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1.call(this,state_21723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21747 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21747[(6)] = c__2749__auto__);

return statearr_21747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
});
fluree.db.query.subject_crawl.common.passes_filter_QMARK_ = (function fluree$db$query$subject_crawl$common$passes_filter_QMARK_(filter_fn,vars,pred_flakes){
return cljs.core.some((function (p1__21764_SHARP_){
return (filter_fn.cljs$core$IFn$_invoke$arity$2 ? filter_fn.cljs$core$IFn$_invoke$arity$2(p1__21764_SHARP_,vars) : filter_fn.call(null,p1__21764_SHARP_,vars));
}),pred_flakes);
});
/**
 * For a group of predicate flakes (all same .-p value)
 *   and a list of filter-functions, returns true if at least
 *   one of the predicates passes every function, else returns false.
 */
fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_ = (function fluree$db$query$subject_crawl$common$pass_all_filters_QMARK_(filter_fns,vars,pred_flakes){
var G__21768 = filter_fns;
var vec__21769 = G__21768;
var seq__21770 = cljs.core.seq(vec__21769);
var first__21771 = cljs.core.first(seq__21770);
var seq__21770__$1 = cljs.core.next(seq__21770);
var filter_fn = first__21771;
var r_fns = seq__21770__$1;
var G__21768__$1 = G__21768;
while(true){
var vec__21772 = G__21768__$1;
var seq__21773 = cljs.core.seq(vec__21772);
var first__21774 = cljs.core.first(seq__21773);
var seq__21773__$1 = cljs.core.next(seq__21773);
var filter_fn__$1 = first__21774;
var r_fns__$1 = seq__21773__$1;
if(cljs.core.truth_(filter_fn__$1)){
if(cljs.core.truth_(fluree.db.query.subject_crawl.common.passes_filter_QMARK_(filter_fn__$1,vars,pred_flakes))){
var G__21775 = r_fns__$1;
G__21768__$1 = G__21775;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});
/**
 * Filters a set of flakes for a single subject and returns true if
 *   the subject meets the filter map.
 * 
 *   filter-map is a map where pred-ids are keys and values are a list of filtering functions
 *   where each flake of pred-id must return a truthy value if the subject is allowed.
 */
fluree.db.query.subject_crawl.common.filter_subject = (function fluree$db$query$subject_crawl$common$filter_subject(vars,filter_map,flakes){
var G__21779 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p,flakes);
var vec__21780 = G__21779;
var seq__21781 = cljs.core.seq(vec__21780);
var first__21782 = cljs.core.first(seq__21781);
var seq__21781__$1 = cljs.core.next(seq__21781);
var p_flakes = first__21782;
var r = seq__21781__$1;
var required_p = new cljs.core.Keyword(null,"required-p","required-p",-2091946078).cljs$core$IFn$_invoke$arity$1(filter_map);
var G__21779__$1 = G__21779;
var required_p__$1 = required_p;
while(true){
var vec__21786 = G__21779__$1;
var seq__21787 = cljs.core.seq(vec__21786);
var first__21788 = cljs.core.first(seq__21787);
var seq__21787__$1 = cljs.core.next(seq__21787);
var p_flakes__$1 = first__21788;
var r__$1 = seq__21787__$1;
var required_p__$2 = required_p__$1;
if(cljs.core.truth_(p_flakes__$1)){
var p = fluree.db.flake.p(cljs.core.first(p_flakes__$1));
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(filter_map,p);
if(cljs.core.truth_(temp__5802__auto__)){
var filter_fns = temp__5802__auto__;
if(fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_(filter_fns,vars,p_flakes__$1)){
var G__21789 = r__$1;
var G__21790 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(required_p__$2,p);
G__21779__$1 = G__21789;
required_p__$1 = G__21790;
continue;
} else {
return null;
}
} else {
var G__21791 = r__$1;
var G__21792 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(required_p__$2,p);
G__21779__$1 = G__21791;
required_p__$1 = G__21792;
continue;
}
} else {
if(cljs.core.empty_QMARK_(required_p__$2)){
return flakes;
} else {
return null;
}
}
break;
}
});
/**
 * If order-by exists in query, orders final results.
 *   order-by is defined by a map with keys (see analytical-parse for code):
 *   - :type - :variable or :predicate
 *   - :order - :asc or :desc
 *   - :predicate - if type = :predicate, contains predicate pid or name
 *   - :variable - if type = :variable, contains variable name (not supported for simple subject crawl)
 */
fluree.db.query.subject_crawl.common.order_results = (function fluree$db$query$subject_crawl$common$order_results(results,p__21793){
var map__21794 = p__21793;
var map__21794__$1 = cljs.core.__destructure_map(map__21794);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21794__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var order = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21794__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var predicate = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21794__$1,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"variable","variable",-281346492),type)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Ordering by a variable not supported in this type of query.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var G__21795 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (result){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(result,predicate);
}),results);
var G__21795__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"desc","desc",2093485764),order))?cljs.core.reverse(G__21795):G__21795);
return cljs.core.vec(G__21795__$1);

}
});
