// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
/**
 * Map of default index comparators for the five index types
 */
fluree.db.index.default_comparators = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"post","post",269697687),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"tspo","tspo",-440144953),fluree.db.flake.cmp_flakes_block], null);
/**
 * The five possible index orderings based on the subject, predicate, object,
 *   and transaction flake attributes
 */
fluree.db.index.types = cljs.core.set(cljs.core.keys(fluree.db.index.default_comparators));
/**
 * Returns `true` if `node` is a map for a leaf node
 */
fluree.db.index.leaf_QMARK_ = (function fluree$db$index$leaf_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === true;
});
/**
 * Returns `true` if `node` is a map for branch node
 */
fluree.db.index.branch_QMARK_ = (function fluree$db$index$branch_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === false;
});

/**
 * @interface
 */
fluree.db.index.Resolver = function(){};

var fluree$db$index$Resolver$resolve$dyn_13863 = (function (r,node){
var x__4550__auto__ = (((r == null))?null:r);
var m__4551__auto__ = (fluree.db.index.resolve[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(r,node) : m__4551__auto__.call(null,r,node));
} else {
var m__4549__auto__ = (fluree.db.index.resolve["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(r,node) : m__4549__auto__.call(null,r,node));
} else {
throw cljs.core.missing_protocol("Resolver.resolve",r);
}
}
});
/**
 * Populate index branch and leaf node maps with either their child node
 *   attributes or the flakes the store, respectively.
 */
fluree.db.index.resolve = (function fluree$db$index$resolve(r,node){
if((((!((r == null)))) && ((!((r.fluree$db$index$Resolver$resolve$arity$2 == null)))))){
return r.fluree$db$index$Resolver$resolve$arity$2(r,node);
} else {
return fluree$db$index$Resolver$resolve$dyn_13863(r,node);
}
});

fluree.db.index.try_resolve = (function fluree$db$index$try_resolve(r,error_ch,node){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_13885){
var state_val_13886 = (state_13885[(1)]);
if((state_val_13886 === (1))){
var state_13885__$1 = state_13885;
var statearr_13887_13902 = state_13885__$1;
(statearr_13887_13902[(2)] = null);

(statearr_13887_13902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13886 === (2))){
var _ = (function (){var statearr_13888 = state_13885;
(statearr_13888[(4)] = cljs.core.cons((6),(state_13885[(4)])));

return statearr_13888;
})();
var inst_13877 = fluree.db.index.resolve(r,node);
var state_13885__$1 = state_13885;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13885__$1,(7),inst_13877);
} else {
if((state_val_13886 === (3))){
var inst_13883 = (state_13885[(2)]);
var state_13885__$1 = state_13885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13885__$1,inst_13883);
} else {
if((state_val_13886 === (4))){
var inst_13864 = (state_13885[(2)]);
var inst_13865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13866 = [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015)];
var inst_13867 = (new cljs.core.PersistentVector(null,3,(5),inst_13865,inst_13866,null));
var inst_13868 = cljs.core.select_keys(node,inst_13867);
var inst_13869 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_13864,"Error resolving index node:",inst_13868) : fluree.db.util.log.error.call(null,inst_13864,"Error resolving index node:",inst_13868));
var state_13885__$1 = (function (){var statearr_13890 = state_13885;
(statearr_13890[(7)] = inst_13869);

return statearr_13890;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13885__$1,(5),error_ch,inst_13864);
} else {
if((state_val_13886 === (5))){
var inst_13871 = (state_13885[(2)]);
var state_13885__$1 = state_13885;
var statearr_13891_13903 = state_13885__$1;
(statearr_13891_13903[(2)] = inst_13871);

(statearr_13891_13903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13886 === (6))){
var _ = (function (){var statearr_13892 = state_13885;
(statearr_13892[(4)] = cljs.core.rest((state_13885[(4)])));

return statearr_13892;
})();
var state_13885__$1 = state_13885;
var ex13889 = (state_13885__$1[(2)]);
var statearr_13893_13904 = state_13885__$1;
(statearr_13893_13904[(5)] = ex13889);


var statearr_13894_13905 = state_13885__$1;
(statearr_13894_13905[(1)] = (4));

(statearr_13894_13905[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13886 === (7))){
var inst_13879 = (state_13885[(2)]);
var inst_13880 = fluree.db.util.async.throw_err(inst_13879);
var _ = (function (){var statearr_13895 = state_13885;
(statearr_13895[(4)] = cljs.core.rest((state_13885[(4)])));

return statearr_13895;
})();
var state_13885__$1 = state_13885;
var statearr_13896_13906 = state_13885__$1;
(statearr_13896_13906[(2)] = inst_13880);

(statearr_13896_13906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$try_resolve_$_state_machine__2727__auto__ = null;
var fluree$db$index$try_resolve_$_state_machine__2727__auto____0 = (function (){
var statearr_13897 = [null,null,null,null,null,null,null,null];
(statearr_13897[(0)] = fluree$db$index$try_resolve_$_state_machine__2727__auto__);

(statearr_13897[(1)] = (1));

return statearr_13897;
});
var fluree$db$index$try_resolve_$_state_machine__2727__auto____1 = (function (state_13885){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_13885);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e13898){var ex__2730__auto__ = e13898;
var statearr_13899_13907 = state_13885;
(statearr_13899_13907[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_13885[(4)]))){
var statearr_13900_13908 = state_13885;
(statearr_13900_13908[(1)] = cljs.core.first((state_13885[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13909 = state_13885;
state_13885 = G__13909;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$try_resolve_$_state_machine__2727__auto__ = function(state_13885){
switch(arguments.length){
case 0:
return fluree$db$index$try_resolve_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$try_resolve_$_state_machine__2727__auto____1.call(this,state_13885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$try_resolve_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$try_resolve_$_state_machine__2727__auto____0;
fluree$db$index$try_resolve_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$try_resolve_$_state_machine__2727__auto____1;
return fluree$db$index$try_resolve_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_13901 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_13901[(6)] = c__2749__auto__);

return statearr_13901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns `true` if the data associated with the index node map `node` is fully
 *   resolved from storage
 */
fluree.db.index.resolved_QMARK_ = (function fluree$db$index$resolved_QMARK_(node){
if(fluree.db.index.leaf_QMARK_(node)){
return (!((new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
if(fluree.db.index.branch_QMARK_(node)){
return (!((new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
return null;
}
}
});
fluree.db.index.lookup = (function fluree$db$index$lookup(branch,flake){
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.index.branch_QMARK_(branch);
if(and__4251__auto__){
return fluree.db.index.resolved_QMARK_(branch);
} else {
return and__4251__auto__;
}
})())){
var map__13910 = branch;
var map__13910__$1 = cljs.core.__destructure_map(map__13910);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13910__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.val((function (){var or__4253__auto__ = clojure.data.avl.nearest(children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.first(children);
}
})());
} else {
return null;
}
});
fluree.db.index.lookup_leaf = (function fluree$db$index$lookup_leaf(r,branch,flake){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_13946){
var state_val_13947 = (state_13946[(1)]);
if((state_val_13947 === (7))){
var inst_13917 = (state_13946[(7)]);
var state_13946__$1 = state_13946;
var statearr_13948_13979 = state_13946__$1;
(statearr_13948_13979[(2)] = inst_13917);

(statearr_13948_13979[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13947 === (1))){
var state_13946__$1 = state_13946;
var statearr_13949_13980 = state_13946__$1;
(statearr_13949_13980[(2)] = null);

(statearr_13949_13980[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13947 === (4))){
var inst_13911 = (state_13946[(2)]);
var state_13946__$1 = state_13946;
var statearr_13950_13981 = state_13946__$1;
(statearr_13950_13981[(2)] = inst_13911);

(statearr_13950_13981[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13947 === (15))){
var inst_13925 = (state_13946[(8)]);
var inst_13930 = fluree.db.index.resolve(r,inst_13925);
var state_13946__$1 = state_13946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13946__$1,(17),inst_13930);
} else {
if((state_val_13947 === (13))){
var inst_13938 = (state_13946[(2)]);
var state_13946__$1 = state_13946;
var statearr_13951_13982 = state_13946__$1;
(statearr_13951_13982[(2)] = inst_13938);

(statearr_13951_13982[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13947 === (6))){
var inst_13919 = fluree.db.index.resolved_QMARK_(branch);
var state_13946__$1 = state_13946;
var statearr_13952_13983 = state_13946__$1;
(statearr_13952_13983[(2)] = inst_13919);

(statearr_13952_13983[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13947 === (17))){
var inst_13932 = (state_13946[(2)]);
var inst_13933 = fluree.db.util.async.throw_err(inst_13932);
var inst_13925 = inst_13933;
var state_13946__$1 = (function (){var statearr_13953 = state_13946;
(statearr_13953[(8)] = inst_13925);

return statearr_13953;
})();
var statearr_13954_13984 = state_13946__$1;
(statearr_13954_13984[(2)] = null);

(statearr_13954_13984[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13947 === (3))){
var inst_13944 = (state_13946[(2)]);
var state_13946__$1 = state_13946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13946__$1,inst_13944);
} else {
if((state_val_13947 === (12))){
var inst_13925 = (state_13946[(8)]);
var inst_13927 = fluree.db.index.leaf_QMARK_(inst_13925);
var state_13946__$1 = state_13946;
if(inst_13927){
var statearr_13955_13985 = state_13946__$1;
(statearr_13955_13985[(1)] = (14));

} else {
var statearr_13956_13986 = state_13946__$1;
(statearr_13956_13986[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13947 === (2))){
var inst_13917 = (state_13946[(7)]);
var _ = (function (){var statearr_13957 = state_13946;
(statearr_13957[(4)] = cljs.core.cons((5),(state_13946[(4)])));

return statearr_13957;
})();
var inst_13917__$1 = fluree.db.index.branch_QMARK_(branch);
var state_13946__$1 = (function (){var statearr_13958 = state_13946;
(statearr_13958[(7)] = inst_13917__$1);

return statearr_13958;
})();
if(inst_13917__$1){
var statearr_13959_13987 = state_13946__$1;
(statearr_13959_13987[(1)] = (6));

} else {
var statearr_13960_13988 = state_13946__$1;
(statearr_13960_13988[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13947 === (11))){
var inst_13941 = (state_13946[(2)]);
var _ = (function (){var statearr_13962 = state_13946;
(statearr_13962[(4)] = cljs.core.rest((state_13946[(4)])));

return statearr_13962;
})();
var state_13946__$1 = state_13946;
var statearr_13963_13989 = state_13946__$1;
(statearr_13963_13989[(2)] = inst_13941);

(statearr_13963_13989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13947 === (9))){
var inst_13924 = fluree.db.index.lookup(branch,flake);
var inst_13925 = inst_13924;
var state_13946__$1 = (function (){var statearr_13964 = state_13946;
(statearr_13964[(8)] = inst_13925);

return statearr_13964;
})();
var statearr_13965_13990 = state_13946__$1;
(statearr_13965_13990[(2)] = null);

(statearr_13965_13990[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13947 === (5))){
var _ = (function (){var statearr_13966 = state_13946;
(statearr_13966[(4)] = cljs.core.rest((state_13946[(4)])));

return statearr_13966;
})();
var state_13946__$1 = state_13946;
var ex13961 = (state_13946__$1[(2)]);
var statearr_13967_13991 = state_13946__$1;
(statearr_13967_13991[(5)] = ex13961);


if((ex13961 instanceof Error)){
var statearr_13968_13992 = state_13946__$1;
(statearr_13968_13992[(1)] = (4));

(statearr_13968_13992[(5)] = null);

} else {
throw ex13961;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13947 === (14))){
var inst_13925 = (state_13946[(8)]);
var state_13946__$1 = state_13946;
var statearr_13969_13993 = state_13946__$1;
(statearr_13969_13993[(2)] = inst_13925);

(statearr_13969_13993[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13947 === (16))){
var inst_13936 = (state_13946[(2)]);
var state_13946__$1 = state_13946;
var statearr_13970_13994 = state_13946__$1;
(statearr_13970_13994[(2)] = inst_13936);

(statearr_13970_13994[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13947 === (10))){
var state_13946__$1 = state_13946;
var statearr_13971_13995 = state_13946__$1;
(statearr_13971_13995[(2)] = null);

(statearr_13971_13995[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13947 === (8))){
var inst_13922 = (state_13946[(2)]);
var state_13946__$1 = state_13946;
if(cljs.core.truth_(inst_13922)){
var statearr_13972_13996 = state_13946__$1;
(statearr_13972_13996[(1)] = (9));

} else {
var statearr_13973_13997 = state_13946__$1;
(statearr_13973_13997[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_13974 = [null,null,null,null,null,null,null,null,null];
(statearr_13974[(0)] = fluree$db$index$lookup_leaf_$_state_machine__2727__auto__);

(statearr_13974[(1)] = (1));

return statearr_13974;
});
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1 = (function (state_13946){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_13946);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e13975){var ex__2730__auto__ = e13975;
var statearr_13976_13998 = state_13946;
(statearr_13976_13998[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_13946[(4)]))){
var statearr_13977_13999 = state_13946;
(statearr_13977_13999[(1)] = cljs.core.first((state_13946[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14000 = state_13946;
state_13946 = G__14000;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__ = function(state_13946){
switch(arguments.length){
case 0:
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1.call(this,state_13946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0;
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1;
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_13978 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_13978[(6)] = c__2749__auto__);

return statearr_13978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.index.add_flakes = (function fluree$db$index$add_flakes(leaf,flakes){
var new_leaf = cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$4(leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.conj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__4253__auto__ = (function (){var G__14001 = new_leaf;
var G__14001__$1 = (((G__14001 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14001));
if((G__14001__$1 == null)){
return null;
} else {
return cljs.core.first(G__14001__$1);
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
fluree.db.index.rem_flakes = (function fluree$db$index$rem_flakes(leaf,flakes){
var new_leaf = cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$4(leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.disj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__4253__auto__ = (function (){var G__14002 = new_leaf;
var G__14002__$1 = (((G__14002 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14002));
if((G__14002__$1 == null)){
return null;
} else {
return cljs.core.first(G__14002__$1);
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
/**
 * Returns a blank leaf node map for the provided `network`, `ledger-id`, and index
 *   comparator `cmp`.
 */
fluree.db.index.empty_leaf = (function fluree$db$index$empty_leaf(network,ledger_id,cmp){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[(0),ledger_id,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.new_leaf = (function fluree$db$index$new_leaf(network,ledger_id,cmp,flakes){
var empty_set = fluree.db.flake.sorted_set_by(cmp);
return fluree.db.index.add_flakes(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(fluree.db.index.empty_leaf(network,ledger_id,cmp),new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set),flakes);
});
/**
 * Checks if the `node` passed in the second argument is a descendant of the
 *   `branch` passed in the first argument
 */
fluree.db.index.descendant_QMARK_ = (function fluree$db$index$descendant_QMARK_(p__14003,p__14004){
var map__14005 = p__14003;
var map__14005__$1 = cljs.core.__destructure_map(map__14005);
var branch = map__14005__$1;
var cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14005__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var first_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14005__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14005__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14005__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var map__14006 = p__14004;
var map__14006__$1 = cljs.core.__destructure_map(map__14006);
var node = map__14006__$1;
var node_first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14006__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var node_rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14006__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
if((!(fluree.db.index.branch_QMARK_(branch)))){
return false;
} else {
var and__4251__auto__ = (function (){var or__4253__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (!(((cmp.cljs$core$IFn$_invoke$arity$2 ? cmp.cljs$core$IFn$_invoke$arity$2(first_flake,node_first) : cmp.call(null,first_flake,node_first)) > (0))));
}
})();
if(cljs.core.truth_(and__4251__auto__)){
return (((rhs == null)) || ((((!((node_rhs == null)))) && ((!(((cmp.cljs$core$IFn$_invoke$arity$2 ? cmp.cljs$core$IFn$_invoke$arity$2(node_rhs,rhs) : cmp.call(null,node_rhs,rhs)) > (0))))))));
} else {
return and__4251__auto__;
}
}
});
fluree.db.index.child_entry = (function fluree$db$index$child_entry(p__14007){
var map__14008 = p__14007;
var map__14008__$1 = cljs.core.__destructure_map(map__14008);
var node = map__14008__$1;
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14008__$1,new cljs.core.Keyword(null,"first","first",-644103046));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [first,node], null);
});
/**
 * Returns avl sorted map whose keys are the first flakes of the index node
 *   sequence `child-nodes`, and whose values are the corresponding nodes from
 *   `child-nodes`.
 */
fluree.db.index.child_map = (function fluree$db$index$child_map(var_args){
var args__4870__auto__ = [];
var len__4864__auto___14011 = arguments.length;
var i__4865__auto___14012 = (0);
while(true){
if((i__4865__auto___14012 < len__4864__auto___14011)){
args__4870__auto__.push((arguments[i__4865__auto___14012]));

var G__14013 = (i__4865__auto___14012 + (1));
i__4865__auto___14012 = G__14013;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic = (function (cmp,child_nodes){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_map_by,cmp,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(fluree.db.index.child_entry,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([child_nodes], 0)));
}));

(fluree.db.index.child_map.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.index.child_map.cljs$lang$applyTo = (function (seq14009){
var G__14010 = cljs.core.first(seq14009);
var seq14009__$1 = cljs.core.next(seq14009);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14010,seq14009__$1);
}));

/**
 * Returns a blank branch node which contains a single empty leaf node for the
 *   provided `network`, `ledger-id`, and index comparator `cmp`.
 */
fluree.db.index.empty_branch = (function fluree$db$index$empty_branch(network,ledger_id,cmp){
var child_node = fluree.db.index.empty_leaf(network,ledger_id,cmp);
var children = fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([child_node], 0));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[children,(0),ledger_id,false,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.reset_children = (function fluree$db$index$reset_children(p__14014,new_child_nodes){
var map__14015 = p__14014;
var map__14015__$1 = cljs.core.__destructure_map(map__14015);
var branch = map__14015__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14015__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14015__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var new_kids = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.index.child_map,comparator,new_child_nodes);
var new_first = (function (){var or__4253__auto__ = (function (){var G__14016 = new_kids;
var G__14016__$1 = (((G__14016 == null))?null:cljs.core.first(G__14016));
if((G__14016__$1 == null)){
return null;
} else {
return cljs.core.key(G__14016__$1);
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
var new_size = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"size","size",1098693007),new_child_nodes));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(branch,new cljs.core.Keyword(null,"first","first",-644103046),new_first,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"size","size",1098693007),new_size,new cljs.core.Keyword(null,"children","children",-940561982),new_kids], 0));
});
fluree.db.index.new_branch = (function fluree$db$index$new_branch(network,ledger_id,cmp,child_nodes){
return fluree.db.index.reset_children(fluree.db.index.empty_branch(network,ledger_id,cmp),child_nodes);
});
/**
 * Returns `true` if `flake` has a transaction value after the provided `t`
 */
fluree.db.index.after_t_QMARK_ = (function fluree$db$index$after_t_QMARK_(t,flake){
return (fluree.db.flake.t(flake) < t);
});
/**
 * Returns a sequence containing only flakes from the flake set `flakes` with
 *   transaction values after the provided `t`.
 */
fluree.db.index.filter_after = (function fluree$db$index$filter_after(t,flakes){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.index.after_t_QMARK_,t),flakes);
});
/**
 * Returns an avl-subset of the avl-set `flakes` with transaction values on or
 *   before the provided `t`.
 */
fluree.db.index.flakes_through = (function fluree$db$index$flakes_through(t,flakes){
return fluree.db.flake.disj_all(flakes,fluree.db.index.filter_after(t,flakes));
});
fluree.db.index.novelty_subrange = (function fluree$db$index$novelty_subrange(p__14017,through_t,novelty){
var map__14018 = p__14017;
var map__14018__$1 = cljs.core.__destructure_map(map__14018);
var node = map__14018__$1;
var first_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14018__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14018__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14018__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var subrange = (cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4251__auto__ = (rhs == null);
if(and__4251__auto__){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?novelty:null))));
return fluree.db.index.flakes_through(through_t,subrange);
});
/**
 * Returns a sequence of flakes from the sorted set `flakes` that are out of date
 *   by the transaction `t` because `flakes` contains another flake with the same
 *   subject and predicate and a transaction value later than that flake but on or
 *   before `t`.
 */
fluree.db.index.stale_by = (function fluree$db$index$stale_by(t,flakes){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (flakes__$1){
var last_flake = cljs.core.last(flakes__$1);
if(cljs.core.truth_(fluree.db.flake.op(last_flake))){
return cljs.core.butlast(flakes__$1);
} else {
return flakes__$1;
}
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.s,fluree.db.flake.p,fluree.db.flake.o),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.index.after_t_QMARK_,t)),flakes))], 0));
});
/**
 * Returns a sorted set of flakes that are not out of date between the
 *   transactions `from-t` and `to-t`.
 */
fluree.db.index.t_range = (function fluree$db$index$t_range(p__14019,novelty,from_t,to_t){
var map__14020 = p__14019;
var map__14020__$1 = cljs.core.__destructure_map(map__14020);
var leaf = map__14020__$1;
var leaf_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14020__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14020__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var latest = (function (){var G__14021 = flakes;
if((leaf_t > to_t)){
return fluree.db.flake.conj_all(G__14021,fluree.db.index.novelty_subrange(leaf,to_t,novelty));
} else {
return G__14021;
}
})();
var stale_flakes = fluree.db.index.stale_by(from_t,latest);
var subsequent = fluree.db.index.filter_after(to_t,latest);
var out_of_range = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(stale_flakes,subsequent);
return fluree.db.flake.disj_all(latest,out_of_range);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.CachedTRangeResolver = (function (node_resolver,novelty,from_t,to_t,async_cache,__meta,__extmap,__hash){
this.node_resolver = node_resolver;
this.novelty = novelty;
this.from_t = from_t;
this.to_t = to_t;
this.async_cache = async_cache;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (_,p__14027){
var self__ = this;
var map__14028 = p__14027;
var map__14028__$1 = cljs.core.__destructure_map(map__14028);
var node = map__14028__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14028__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14028__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var tt_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14028__$1,new cljs.core.Keyword(null,"tt-id","tt-id",725587484));
var ___$1 = this;
if(fluree.db.index.branch_QMARK_(node)){
return fluree.db.index.resolve(self__.node_resolver,node);
} else {
var G__14029 = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.index","t-range","fluree.db.index/t-range",437950593),id,tempid,tt_id,self__.from_t,self__.to_t], null);
var G__14030 = (function (___$2){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14048){
var state_val_14049 = (state_14048[(1)]);
if((state_val_14049 === (1))){
var state_14048__$1 = state_14048;
var statearr_14050_14085 = state_14048__$1;
(statearr_14050_14085[(2)] = null);

(statearr_14050_14085[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14049 === (2))){
var ___$3 = (function (){var statearr_14051 = state_14048;
(statearr_14051[(4)] = cljs.core.cons((5),(state_14048[(4)])));

return statearr_14051;
})();
var inst_14037 = fluree.db.index.resolve(self__.node_resolver,node);
var state_14048__$1 = state_14048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14048__$1,(6),inst_14037);
} else {
if((state_val_14049 === (3))){
var inst_14046 = (state_14048[(2)]);
var state_14048__$1 = state_14048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14048__$1,inst_14046);
} else {
if((state_val_14049 === (4))){
var inst_14031 = (state_14048[(2)]);
var state_14048__$1 = state_14048;
var statearr_14053_14086 = state_14048__$1;
(statearr_14053_14086[(2)] = inst_14031);

(statearr_14053_14086[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14049 === (5))){
var ___$3 = (function (){var statearr_14054 = state_14048;
(statearr_14054[(4)] = cljs.core.rest((state_14048[(4)])));

return statearr_14054;
})();
var state_14048__$1 = state_14048;
var ex14052 = (state_14048__$1[(2)]);
var statearr_14055_14087 = state_14048__$1;
(statearr_14055_14087[(5)] = ex14052);


if((ex14052 instanceof Error)){
var statearr_14056_14088 = state_14048__$1;
(statearr_14056_14088[(1)] = (4));

(statearr_14056_14088[(5)] = null);

} else {
throw ex14052;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14049 === (6))){
var inst_14039 = (state_14048[(2)]);
var inst_14040 = fluree.db.util.async.throw_err(inst_14039);
var inst_14041 = fluree.db.index.t_range(inst_14040,self__.novelty,self__.from_t,self__.to_t);
var inst_14042 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_14040,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_14043 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_14042,new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_14041], 0));
var ___$3 = (function (){var statearr_14057 = state_14048;
(statearr_14057[(4)] = cljs.core.rest((state_14048[(4)])));

return statearr_14057;
})();
var state_14048__$1 = state_14048;
var statearr_14058_14089 = state_14048__$1;
(statearr_14058_14089[(2)] = inst_14043);

(statearr_14058_14089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2727__auto__ = null;
var fluree$db$index$state_machine__2727__auto____0 = (function (){
var statearr_14059 = [null,null,null,null,null,null,null];
(statearr_14059[(0)] = fluree$db$index$state_machine__2727__auto__);

(statearr_14059[(1)] = (1));

return statearr_14059;
});
var fluree$db$index$state_machine__2727__auto____1 = (function (state_14048){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14048);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14060){var ex__2730__auto__ = e14060;
var statearr_14061_14090 = state_14048;
(statearr_14061_14090[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14048[(4)]))){
var statearr_14062_14091 = state_14048;
(statearr_14062_14091[(1)] = cljs.core.first((state_14048[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14092 = state_14048;
state_14048 = G__14092;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$state_machine__2727__auto__ = function(state_14048){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2727__auto____1.call(this,state_14048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2727__auto____0;
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2727__auto____1;
return fluree$db$index$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14063 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14063[(6)] = c__2749__auto__);

return statearr_14063;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__14029,G__14030) : self__.async_cache.call(null,G__14029,G__14030));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k14023,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__14064 = k14023;
var G__14064__$1 = (((G__14064 instanceof cljs.core.Keyword))?G__14064.fqn:null);
switch (G__14064__$1) {
case "node-resolver":
return self__.node_resolver;

break;
case "novelty":
return self__.novelty;

break;
case "from-t":
return self__.from_t;

break;
case "to-t":
return self__.to_t;

break;
case "async-cache":
return self__.async_cache;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k14023,else__4505__auto__);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__14065){
var vec__14066 = p__14065;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14066,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14066,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.index.CachedTRangeResolver{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14022){
var self__ = this;
var G__14022__$1 = this;
return (new cljs.core.RecordIter((0),G__14022__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__14069 = (function (coll__4499__auto__){
return (361103374 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__14069(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14024,other14025){
var self__ = this;
var this14024__$1 = this;
return (((!((other14025 == null)))) && ((((this14024__$1.constructor === other14025.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14024__$1.node_resolver,other14025.node_resolver)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14024__$1.novelty,other14025.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14024__$1.from_t,other14025.from_t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14024__$1.to_t,other14025.to_t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14024__$1.async_cache,other14025.async_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14024__$1.__extmap,other14025.__extmap)))))))))))))));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),null,new cljs.core.Keyword(null,"from-t","from-t",1730913525),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"to-t","to-t",569467359),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k14023){
var self__ = this;
var this__4509__auto____$1 = this;
var G__14070 = k14023;
var G__14070__$1 = (((G__14070 instanceof cljs.core.Keyword))?G__14070.fqn:null);
switch (G__14070__$1) {
case "node-resolver":
case "novelty":
case "from-t":
case "to-t":
case "async-cache":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k14023);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__14022){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__14071 = cljs.core.keyword_identical_QMARK_;
var expr__14072 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__14074 = new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078);
var G__14075 = expr__14072;
return (pred__14071.cljs$core$IFn$_invoke$arity$2 ? pred__14071.cljs$core$IFn$_invoke$arity$2(G__14074,G__14075) : pred__14071.call(null,G__14074,G__14075));
})())){
return (new fluree.db.index.CachedTRangeResolver(G__14022,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14076 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__14077 = expr__14072;
return (pred__14071.cljs$core$IFn$_invoke$arity$2 ? pred__14071.cljs$core$IFn$_invoke$arity$2(G__14076,G__14077) : pred__14071.call(null,G__14076,G__14077));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,G__14022,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14078 = new cljs.core.Keyword(null,"from-t","from-t",1730913525);
var G__14079 = expr__14072;
return (pred__14071.cljs$core$IFn$_invoke$arity$2 ? pred__14071.cljs$core$IFn$_invoke$arity$2(G__14078,G__14079) : pred__14071.call(null,G__14078,G__14079));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,G__14022,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14080 = new cljs.core.Keyword(null,"to-t","to-t",569467359);
var G__14081 = expr__14072;
return (pred__14071.cljs$core$IFn$_invoke$arity$2 ? pred__14071.cljs$core$IFn$_invoke$arity$2(G__14080,G__14081) : pred__14071.call(null,G__14080,G__14081));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,G__14022,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14082 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__14083 = expr__14072;
return (pred__14071.cljs$core$IFn$_invoke$arity$2 ? pred__14071.cljs$core$IFn$_invoke$arity$2(G__14082,G__14083) : pred__14071.call(null,G__14082,G__14083));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,G__14022,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__14022),null));
}
}
}
}
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__14022){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,G__14022,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.index.CachedTRangeResolver.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node-resolver","node-resolver",-1971835691,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"from-t","from-t",-923522244,null),new cljs.core.Symbol(null,"to-t","to-t",-2084968410,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null)], null);
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$type = true);

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.index/CachedTRangeResolver",null,(1),null));
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.index/CachedTRangeResolver");
}));

/**
 * Positional factory function for fluree.db.index/CachedTRangeResolver.
 */
fluree.db.index.__GT_CachedTRangeResolver = (function fluree$db$index$__GT_CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache){
return (new fluree.db.index.CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache,null,null,null));
});

/**
 * Factory function for fluree.db.index/CachedTRangeResolver, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_CachedTRangeResolver = (function fluree$db$index$map__GT_CachedTRangeResolver(G__14026){
var extmap__4542__auto__ = (function (){var G__14084 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__14026,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], 0));
if(cljs.core.record_QMARK_(G__14026)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__14084);
} else {
return G__14084;
}
})();
return (new fluree.db.index.CachedTRangeResolver(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078).cljs$core$IFn$_invoke$arity$1(G__14026),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__14026),new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(G__14026),new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(G__14026),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__14026),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

/**
 * Find the value of `leaf` at transaction `t` by adding new flakes from
 *   `idx-novelty` to `leaf` if `t` is newer than `leaf`, or removing flakes later
 *   than `t` from `leaf` if `t` is older than `leaf`.
 */
fluree.db.index.at_t = (function fluree$db$index$at_t(p__14095,t,idx_novelty){
var map__14096 = p__14095;
var map__14096__$1 = cljs.core.__destructure_map(map__14096);
var leaf = map__14096__$1;
var leaf_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14096__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14096__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14096__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14096__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(leaf_t,t)){
return leaf;
} else {
var G__14097 = leaf;
var G__14097__$1 = (((leaf_t > t))?fluree.db.index.add_flakes(G__14097,fluree.db.index.novelty_subrange(leaf,t,idx_novelty)):G__14097);
var G__14097__$2 = (((leaf_t < t))?fluree.db.index.rem_flakes(G__14097__$1,fluree.db.index.filter_after(t,flakes)):G__14097__$1);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__14097__$2,new cljs.core.Keyword(null,"t","t",-1397832519),t);

}
});
fluree.db.index.mark_expanded = (function fluree$db$index$mark_expanded(node){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179),true);
});
fluree.db.index.unmark_expanded = (function fluree$db$index$unmark_expanded(node){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179));
});
fluree.db.index.expanded_QMARK_ = (function fluree$db$index$expanded_QMARK_(node){
return new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179).cljs$core$IFn$_invoke$arity$1(node) === true;
});
fluree.db.index.resolve_when = (function fluree$db$index$resolve_when(r,resolve_QMARK_,error_ch,node){
if(cljs.core.truth_((resolve_QMARK_.cljs$core$IFn$_invoke$arity$1 ? resolve_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : resolve_QMARK_.call(null,node)))){
return fluree.db.index.try_resolve(r,error_ch,node);
} else {
var G__14098 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(G__14098,node);

return G__14098;
}
});
fluree.db.index.resolve_children_when = (function fluree$db$index$resolve_children_when(r,resolve_QMARK_,error_ch,branch){
if(cljs.core.truth_(fluree.db.index.resolved_QMARK_(branch))){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14099){
var vec__14100 = p__14099;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14100,(0),null);
var child = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14100,(1),null);
return fluree.db.index.resolve_when(r,resolve_QMARK_,error_ch,child);
}),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(branch)));
} else {
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14105){
var state_val_14106 = (state_14105[(1)]);
if((state_val_14106 === (1))){
var inst_14103 = cljs.core.PersistentVector.EMPTY;
var state_14105__$1 = state_14105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14105__$1,inst_14103);
} else {
return null;
}
});
return (function() {
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto__ = null;
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0 = (function (){
var statearr_14107 = [null,null,null,null,null,null,null];
(statearr_14107[(0)] = fluree$db$index$resolve_children_when_$_state_machine__2727__auto__);

(statearr_14107[(1)] = (1));

return statearr_14107;
});
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1 = (function (state_14105){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14105);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14108){var ex__2730__auto__ = e14108;
var statearr_14109_14112 = state_14105;
(statearr_14109_14112[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14105[(4)]))){
var statearr_14110_14113 = state_14105;
(statearr_14110_14113[(1)] = cljs.core.first((state_14105[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14114 = state_14105;
state_14105 = G__14114;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__ = function(state_14105){
switch(arguments.length){
case 0:
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1.call(this,state_14105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0;
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1;
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14111 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14111[(6)] = c__2749__auto__);

return statearr_14111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}
});
/**
 * Returns a channel that will eventually contain the stream of index nodes
 *   descended from `root` in depth-first order. `resolve?` is a boolean function
 *   that will be applied to each node to determine whether or not the data
 *   associated with that node will be resolved from disk using the supplied
 *   `Resolver` `r`. `include?` is a boolean function that will be applied to each
 *   node to determine if it will be included in the final output node stream, `n`
 *   is an optional parameter specifying the number of nodes to load concurrently,
 *   and `xf` is an optional transducer that will transform the output stream if
 *   supplied.
 */
fluree.db.index.tree_chan = (function fluree$db$index$tree_chan(var_args){
var G__14116 = arguments.length;
switch (G__14116) {
case 5:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 7:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5 = (function (r,root,resolve_QMARK_,include_QMARK_,error_ch){
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(r,root,resolve_QMARK_,include_QMARK_,(1),cljs.core.identity,error_ch);
}));

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7 = (function (r,root,resolve_QMARK_,include_QMARK_,n,xf,error_ch){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(n,xf);
var c__2749__auto___14194 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14162){
var state_val_14163 = (state_14162[(1)]);
if((state_val_14163 === (7))){
var inst_14157 = (state_14162[(2)]);
var state_14162__$1 = state_14162;
var statearr_14164_14195 = state_14162__$1;
(statearr_14164_14195[(2)] = inst_14157);

(statearr_14164_14195[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14163 === (1))){
var inst_14117 = fluree.db.index.resolve_when(r,resolve_QMARK_,error_ch,root);
var state_14162__$1 = state_14162;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14162__$1,(2),inst_14117);
} else {
if((state_val_14163 === (4))){
var inst_14159 = (state_14162[(2)]);
var inst_14160 = cljs.core.async.close_BANG_(out);
var state_14162__$1 = (function (){var statearr_14165 = state_14162;
(statearr_14165[(7)] = inst_14159);

return statearr_14165;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14162__$1,inst_14160);
} else {
if((state_val_14163 === (15))){
var state_14162__$1 = state_14162;
var statearr_14166_14196 = state_14162__$1;
(statearr_14166_14196[(2)] = null);

(statearr_14166_14196[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14163 === (13))){
var inst_14154 = (state_14162[(2)]);
var state_14162__$1 = state_14162;
var statearr_14167_14197 = state_14162__$1;
(statearr_14167_14197[(2)] = inst_14154);

(statearr_14167_14197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14163 === (6))){
var state_14162__$1 = state_14162;
var statearr_14168_14198 = state_14162__$1;
(statearr_14168_14198[(2)] = null);

(statearr_14168_14198[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14163 === (17))){
var inst_14139 = (state_14162[(2)]);
var state_14162__$1 = state_14162;
var statearr_14169_14199 = state_14162__$1;
(statearr_14169_14199[(2)] = inst_14139);

(statearr_14169_14199[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14163 === (3))){
var inst_14123 = (state_14162[(8)]);
var inst_14125 = (state_14162[(9)]);
var inst_14125__$1 = cljs.core.peek(inst_14123);
var state_14162__$1 = (function (){var statearr_14170 = state_14162;
(statearr_14170[(9)] = inst_14125__$1);

return statearr_14170;
})();
if(cljs.core.truth_(inst_14125__$1)){
var statearr_14171_14200 = state_14162__$1;
(statearr_14171_14200[(1)] = (5));

} else {
var statearr_14172_14201 = state_14162__$1;
(statearr_14172_14201[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14163 === (12))){
var inst_14125 = (state_14162[(9)]);
var inst_14145 = fluree.db.index.resolve_children_when(r,resolve_QMARK_,error_ch,inst_14125);
var state_14162__$1 = state_14162;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14162__$1,(18),inst_14145);
} else {
if((state_val_14163 === (2))){
var inst_14119 = (state_14162[(2)]);
var inst_14120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14121 = [inst_14119];
var inst_14122 = (new cljs.core.PersistentVector(null,1,(5),inst_14120,inst_14121,null));
var inst_14123 = inst_14122;
var state_14162__$1 = (function (){var statearr_14173 = state_14162;
(statearr_14173[(8)] = inst_14123);

return statearr_14173;
})();
var statearr_14174_14202 = state_14162__$1;
(statearr_14174_14202[(2)] = null);

(statearr_14174_14202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14163 === (11))){
var inst_14125 = (state_14162[(9)]);
var inst_14135 = (include_QMARK_.cljs$core$IFn$_invoke$arity$1 ? include_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_14125) : include_QMARK_.call(null,inst_14125));
var state_14162__$1 = state_14162;
if(cljs.core.truth_(inst_14135)){
var statearr_14175_14203 = state_14162__$1;
(statearr_14175_14203[(1)] = (14));

} else {
var statearr_14176_14204 = state_14162__$1;
(statearr_14176_14204[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14163 === (9))){
var inst_14125 = (state_14162[(9)]);
var inst_14131 = fluree.db.index.expanded_QMARK_(inst_14125);
var state_14162__$1 = state_14162;
var statearr_14177_14205 = state_14162__$1;
(statearr_14177_14205[(2)] = inst_14131);

(statearr_14177_14205[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14163 === (5))){
var inst_14123 = (state_14162[(8)]);
var inst_14125 = (state_14162[(9)]);
var inst_14128 = (state_14162[(10)]);
var inst_14127 = cljs.core.pop(inst_14123);
var inst_14128__$1 = fluree.db.index.leaf_QMARK_(inst_14125);
var state_14162__$1 = (function (){var statearr_14178 = state_14162;
(statearr_14178[(11)] = inst_14127);

(statearr_14178[(10)] = inst_14128__$1);

return statearr_14178;
})();
if(inst_14128__$1){
var statearr_14179_14206 = state_14162__$1;
(statearr_14179_14206[(1)] = (8));

} else {
var statearr_14180_14207 = state_14162__$1;
(statearr_14180_14207[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14163 === (14))){
var inst_14125 = (state_14162[(9)]);
var inst_14137 = fluree.db.index.unmark_expanded(inst_14125);
var state_14162__$1 = state_14162;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14162__$1,(17),out,inst_14137);
} else {
if((state_val_14163 === (16))){
var inst_14127 = (state_14162[(11)]);
var inst_14142 = (state_14162[(2)]);
var inst_14123 = inst_14127;
var state_14162__$1 = (function (){var statearr_14181 = state_14162;
(statearr_14181[(12)] = inst_14142);

(statearr_14181[(8)] = inst_14123);

return statearr_14181;
})();
var statearr_14182_14208 = state_14162__$1;
(statearr_14182_14208[(2)] = null);

(statearr_14182_14208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14163 === (10))){
var inst_14133 = (state_14162[(2)]);
var state_14162__$1 = state_14162;
if(cljs.core.truth_(inst_14133)){
var statearr_14183_14209 = state_14162__$1;
(statearr_14183_14209[(1)] = (11));

} else {
var statearr_14184_14210 = state_14162__$1;
(statearr_14184_14210[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14163 === (18))){
var inst_14127 = (state_14162[(11)]);
var inst_14125 = (state_14162[(9)]);
var inst_14147 = (state_14162[(2)]);
var inst_14148 = fluree.db.index.mark_expanded(inst_14125);
var inst_14149 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_14127,inst_14148);
var inst_14150 = cljs.core.rseq(inst_14147);
var inst_14151 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14149,inst_14150);
var inst_14123 = inst_14151;
var state_14162__$1 = (function (){var statearr_14185 = state_14162;
(statearr_14185[(8)] = inst_14123);

return statearr_14185;
})();
var statearr_14186_14211 = state_14162__$1;
(statearr_14186_14211[(2)] = null);

(statearr_14186_14211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14163 === (8))){
var inst_14128 = (state_14162[(10)]);
var state_14162__$1 = state_14162;
var statearr_14187_14212 = state_14162__$1;
(statearr_14187_14212[(2)] = inst_14128);

(statearr_14187_14212[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2727__auto__ = null;
var fluree$db$index$state_machine__2727__auto____0 = (function (){
var statearr_14188 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14188[(0)] = fluree$db$index$state_machine__2727__auto__);

(statearr_14188[(1)] = (1));

return statearr_14188;
});
var fluree$db$index$state_machine__2727__auto____1 = (function (state_14162){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14162);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14189){var ex__2730__auto__ = e14189;
var statearr_14190_14213 = state_14162;
(statearr_14190_14213[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14162[(4)]))){
var statearr_14191_14214 = state_14162;
(statearr_14191_14214[(1)] = cljs.core.first((state_14162[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14215 = state_14162;
state_14162 = G__14215;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$state_machine__2727__auto__ = function(state_14162){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2727__auto____1.call(this,state_14162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2727__auto____0;
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2727__auto____1;
return fluree$db$index$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14192 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14192[(6)] = c__2749__auto___14194);

return statearr_14192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return out;
}));

(fluree.db.index.tree_chan.cljs$lang$maxFixedArity = 7);

