// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.call(null,self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.call(null,self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer.call(null,writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer.call(null,writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count.call(null,self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first.call(null,self__.priority__GT_set_of_items);
var item = cljs.core.first.call(null,cljs.core.val.call(null,f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key.call(null,f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first.call(null,self__.priority__GT_set_of_items);
var item_set = cljs.core.val.call(null,f);
var item = cljs.core.first.call(null,item_set);
var priority_key = cljs.core.key.call(null,f);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.disj.call(null,item_set,item)),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__36394(s__36395){
return (new cljs.core.LazySeq(null,(function (){
var s__36395__$1 = s__36395;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__36395__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__36400 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__36400,(0),null);
var item_set = cljs.core.nth.call(null,vec__36400,(1),null);
var iterys__4648__auto__ = ((function (s__36395__$1,vec__36400,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__36394_$_iter__36396(s__36397){
return (new cljs.core.LazySeq(null,((function (s__36395__$1,vec__36400,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__36397__$1 = s__36397;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__36397__$1);
if(temp__5753__auto____$1){
var s__36397__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__36397__$2)){
var c__4650__auto__ = cljs.core.chunk_first.call(null,s__36397__$2);
var size__4651__auto__ = cljs.core.count.call(null,c__4650__auto__);
var b__36399 = cljs.core.chunk_buffer.call(null,size__4651__auto__);
if((function (){var i__36398 = (0);
while(true){
if((i__36398 < size__4651__auto__)){
var item = cljs.core._nth.call(null,c__4650__auto__,i__36398);
cljs.core.chunk_append.call(null,b__36399,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__36448 = (i__36398 + (1));
i__36398 = G__36448;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36399),tailrecursion$priority_map$iter__36394_$_iter__36396.call(null,cljs.core.chunk_rest.call(null,s__36397__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36399),null);
}
} else {
var item = cljs.core.first.call(null,s__36397__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__36394_$_iter__36396.call(null,cljs.core.rest.call(null,s__36397__$2)));
}
} else {
return null;
}
break;
}
});})(s__36395__$1,vec__36400,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__36395__$1,vec__36400,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4649__auto__ = cljs.core.seq.call(null,iterys__4648__auto__.call(null,item_set));
if(fs__4649__auto__){
return cljs.core.concat.call(null,fs__4649__auto__,tailrecursion$priority_map$iter__36394.call(null,cljs.core.rest.call(null,s__36395__$1)));
} else {
var G__36449 = cljs.core.rest.call(null,s__36395__$1);
s__36395__$1 = G__36449;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__.call(null,cljs.core.rseq.call(null,self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__36403(s__36404){
return (new cljs.core.LazySeq(null,(function (){
var s__36404__$1 = s__36404;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__36404__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__36409 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__36409,(0),null);
var item_set = cljs.core.nth.call(null,vec__36409,(1),null);
var iterys__4648__auto__ = ((function (s__36404__$1,vec__36409,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__36403_$_iter__36405(s__36406){
return (new cljs.core.LazySeq(null,((function (s__36404__$1,vec__36409,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__36406__$1 = s__36406;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__36406__$1);
if(temp__5753__auto____$1){
var s__36406__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__36406__$2)){
var c__4650__auto__ = cljs.core.chunk_first.call(null,s__36406__$2);
var size__4651__auto__ = cljs.core.count.call(null,c__4650__auto__);
var b__36408 = cljs.core.chunk_buffer.call(null,size__4651__auto__);
if((function (){var i__36407 = (0);
while(true){
if((i__36407 < size__4651__auto__)){
var item = cljs.core._nth.call(null,c__4650__auto__,i__36407);
cljs.core.chunk_append.call(null,b__36408,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__36450 = (i__36407 + (1));
i__36407 = G__36450;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36408),tailrecursion$priority_map$iter__36403_$_iter__36405.call(null,cljs.core.chunk_rest.call(null,s__36406__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36408),null);
}
} else {
var item = cljs.core.first.call(null,s__36406__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__36403_$_iter__36405.call(null,cljs.core.rest.call(null,s__36406__$2)));
}
} else {
return null;
}
break;
}
});})(s__36404__$1,vec__36409,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__36404__$1,vec__36409,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4649__auto__ = cljs.core.seq.call(null,iterys__4648__auto__.call(null,item_set));
if(fs__4649__auto__){
return cljs.core.concat.call(null,fs__4649__auto__,tailrecursion$priority_map$iter__36403.call(null,cljs.core.rest.call(null,s__36404__$1)));
} else {
var G__36451 = cljs.core.rest.call(null,s__36404__$1);
s__36404__$1 = G__36451;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__.call(null,cljs.core.rseq.call(null,self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = cljs.core.hash_unordered_coll.call(null,this$__$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv.call(null,self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta.call(null,tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = self__.item__GT_priority.call(null,item,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517));
if(cljs.core._EQ_.call(null,priority,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517))){
return this$__$1;
} else {
var priority_key = self__.keyfn.call(null,priority);
var item_set = self__.priority__GT_set_of_items.call(null,priority_key);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.disj.call(null,item_set,item)),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.call(null,self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.call(null,current_priority,priority)){
return this$__$1;
} else {
var priority_key = self__.keyfn.call(null,priority);
var current_priority_key = self__.keyfn.call(null,current_priority);
var item_set = cljs.core.get.call(null,self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,current_priority_key),item),priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = self__.keyfn.call(null,priority);
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_.call(null,self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__36412(s__36413){
return (new cljs.core.LazySeq(null,(function (){
var s__36413__$1 = s__36413;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__36413__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__36418 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__36418,(0),null);
var item_set = cljs.core.nth.call(null,vec__36418,(1),null);
var iterys__4648__auto__ = ((function (s__36413__$1,vec__36418,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__36412_$_iter__36414(s__36415){
return (new cljs.core.LazySeq(null,((function (s__36413__$1,vec__36418,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__36415__$1 = s__36415;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__36415__$1);
if(temp__5753__auto____$1){
var s__36415__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__36415__$2)){
var c__4650__auto__ = cljs.core.chunk_first.call(null,s__36415__$2);
var size__4651__auto__ = cljs.core.count.call(null,c__4650__auto__);
var b__36417 = cljs.core.chunk_buffer.call(null,size__4651__auto__);
if((function (){var i__36416 = (0);
while(true){
if((i__36416 < size__4651__auto__)){
var item = cljs.core._nth.call(null,c__4650__auto__,i__36416);
cljs.core.chunk_append.call(null,b__36417,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__36452 = (i__36416 + (1));
i__36416 = G__36452;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36417),tailrecursion$priority_map$iter__36412_$_iter__36414.call(null,cljs.core.chunk_rest.call(null,s__36415__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36417),null);
}
} else {
var item = cljs.core.first.call(null,s__36415__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__36412_$_iter__36414.call(null,cljs.core.rest.call(null,s__36415__$2)));
}
} else {
return null;
}
break;
}
});})(s__36413__$1,vec__36418,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__36413__$1,vec__36418,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4649__auto__ = cljs.core.seq.call(null,iterys__4648__auto__.call(null,item_set));
if(fs__4649__auto__){
return cljs.core.concat.call(null,fs__4649__auto__,tailrecursion$priority_map$iter__36412.call(null,cljs.core.rest.call(null,s__36413__$1)));
} else {
var G__36453 = cljs.core.rest.call(null,s__36413__$1);
s__36413__$1 = G__36453;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__.call(null,self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__36421(s__36422){
return (new cljs.core.LazySeq(null,(function (){
var s__36422__$1 = s__36422;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__36422__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__36427 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__36427,(0),null);
var item_set = cljs.core.nth.call(null,vec__36427,(1),null);
var iterys__4648__auto__ = ((function (s__36422__$1,vec__36427,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__36421_$_iter__36423(s__36424){
return (new cljs.core.LazySeq(null,((function (s__36422__$1,vec__36427,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__36424__$1 = s__36424;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__36424__$1);
if(temp__5753__auto____$1){
var s__36424__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__36424__$2)){
var c__4650__auto__ = cljs.core.chunk_first.call(null,s__36424__$2);
var size__4651__auto__ = cljs.core.count.call(null,c__4650__auto__);
var b__36426 = cljs.core.chunk_buffer.call(null,size__4651__auto__);
if((function (){var i__36425 = (0);
while(true){
if((i__36425 < size__4651__auto__)){
var item = cljs.core._nth.call(null,c__4650__auto__,i__36425);
cljs.core.chunk_append.call(null,b__36426,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__36454 = (i__36425 + (1));
i__36425 = G__36454;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36426),tailrecursion$priority_map$iter__36421_$_iter__36423.call(null,cljs.core.chunk_rest.call(null,s__36424__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36426),null);
}
} else {
var item = cljs.core.first.call(null,s__36424__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__36421_$_iter__36423.call(null,cljs.core.rest.call(null,s__36424__$2)));
}
} else {
return null;
}
break;
}
});})(s__36422__$1,vec__36427,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__36422__$1,vec__36427,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4649__auto__ = cljs.core.seq.call(null,iterys__4648__auto__.call(null,item_set));
if(fs__4649__auto__){
return cljs.core.concat.call(null,fs__4649__auto__,tailrecursion$priority_map$iter__36421.call(null,cljs.core.rest.call(null,s__36422__$1)));
} else {
var G__36455 = cljs.core.rest.call(null,s__36422__$1);
s__36422__$1 = G__36455;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__.call(null,self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry)){
return cljs.core._assoc.call(null,this$__$1,cljs.core._nth.call(null,entry,(0)),cljs.core._nth.call(null,entry,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__36456 = null;
var G__36456__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.call(null,this$,item);
});
var G__36456__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.call(null,this$,item,not_found);
});
G__36456 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__36456__2.call(this,self__,item);
case 3:
return G__36456__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__36456.cljs$core$IFn$_invoke$arity$2 = G__36456__2;
G__36456.cljs$core$IFn$_invoke$arity$3 = G__36456__3;
return G__36456;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args36393){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args36393)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return cljs.core._lookup.call(null,this$,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return cljs.core._lookup.call(null,this$,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
return (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq).call(null,this$__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.call(null,self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.call(null,self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__36430(s__36431){
return (new cljs.core.LazySeq(null,(function (){
var s__36431__$1 = s__36431;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__36431__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__36436 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__36436,(0),null);
var item_set = cljs.core.nth.call(null,vec__36436,(1),null);
var iterys__4648__auto__ = ((function (s__36431__$1,vec__36436,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__36430_$_iter__36432(s__36433){
return (new cljs.core.LazySeq(null,((function (s__36431__$1,vec__36436,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__36433__$1 = s__36433;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__36433__$1);
if(temp__5753__auto____$1){
var s__36433__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__36433__$2)){
var c__4650__auto__ = cljs.core.chunk_first.call(null,s__36433__$2);
var size__4651__auto__ = cljs.core.count.call(null,c__4650__auto__);
var b__36435 = cljs.core.chunk_buffer.call(null,size__4651__auto__);
if((function (){var i__36434 = (0);
while(true){
if((i__36434 < size__4651__auto__)){
var item = cljs.core._nth.call(null,c__4650__auto__,i__36434);
cljs.core.chunk_append.call(null,b__36435,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__36457 = (i__36434 + (1));
i__36434 = G__36457;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36435),tailrecursion$priority_map$iter__36430_$_iter__36432.call(null,cljs.core.chunk_rest.call(null,s__36433__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36435),null);
}
} else {
var item = cljs.core.first.call(null,s__36433__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__36430_$_iter__36432.call(null,cljs.core.rest.call(null,s__36433__$2)));
}
} else {
return null;
}
break;
}
});})(s__36431__$1,vec__36436,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__36431__$1,vec__36436,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4649__auto__ = cljs.core.seq.call(null,iterys__4648__auto__.call(null,item_set));
if(fs__4649__auto__){
return cljs.core.concat.call(null,fs__4649__auto__,tailrecursion$priority_map$iter__36430.call(null,cljs.core.rest.call(null,s__36431__$1)));
} else {
var G__36458 = cljs.core.rest.call(null,s__36431__$1);
s__36431__$1 = G__36458;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__.call(null,sets);
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4652__auto__ = (function tailrecursion$priority_map$iter__36439(s__36440){
return (new cljs.core.LazySeq(null,(function (){
var s__36440__$1 = s__36440;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__36440__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__36445 = cljs.core.first.call(null,xs__6308__auto__);
var priority = cljs.core.nth.call(null,vec__36445,(0),null);
var item_set = cljs.core.nth.call(null,vec__36445,(1),null);
var iterys__4648__auto__ = ((function (s__36440__$1,vec__36445,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__36439_$_iter__36441(s__36442){
return (new cljs.core.LazySeq(null,((function (s__36440__$1,vec__36445,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__36442__$1 = s__36442;
while(true){
var temp__5753__auto____$1 = cljs.core.seq.call(null,s__36442__$1);
if(temp__5753__auto____$1){
var s__36442__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__36442__$2)){
var c__4650__auto__ = cljs.core.chunk_first.call(null,s__36442__$2);
var size__4651__auto__ = cljs.core.count.call(null,c__4650__auto__);
var b__36444 = cljs.core.chunk_buffer.call(null,size__4651__auto__);
if((function (){var i__36443 = (0);
while(true){
if((i__36443 < size__4651__auto__)){
var item = cljs.core._nth.call(null,c__4650__auto__,i__36443);
cljs.core.chunk_append.call(null,b__36444,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__36459 = (i__36443 + (1));
i__36443 = G__36459;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36444),tailrecursion$priority_map$iter__36439_$_iter__36441.call(null,cljs.core.chunk_rest.call(null,s__36442__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__36444),null);
}
} else {
var item = cljs.core.first.call(null,s__36442__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__36439_$_iter__36441.call(null,cljs.core.rest.call(null,s__36442__$2)));
}
} else {
return null;
}
break;
}
});})(s__36440__$1,vec__36445,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__36440__$1,vec__36445,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4649__auto__ = cljs.core.seq.call(null,iterys__4648__auto__.call(null,item_set));
if(fs__4649__auto__){
return cljs.core.concat.call(null,fs__4649__auto__,tailrecursion$priority_map$iter__36439.call(null,cljs.core.rest.call(null,s__36440__$1)));
} else {
var G__36460 = cljs.core.rest.call(null,s__36440__$1);
s__36440__$1 = G__36460;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__.call(null,sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
return self__.keyfn.call(null,cljs.core.val.call(null,entry));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"priority->set-of-items","priority->set-of-items",-1256537211,null),new cljs.core.Symbol(null,"item->priority","item->priority",-899999435,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map.call(null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by.call(null,comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__36462 = arguments.length;
switch (G__36462) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map.call(null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by.call(null,comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_.call(null,elems)){
return cljs.core.into.call(null,tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_.call(null,"tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4870__auto__ = [];
var len__4864__auto___36465 = arguments.length;
var i__4865__auto___36466 = (0);
while(true){
if((i__4865__auto___36466 < len__4864__auto___36465)){
args__4870__auto__.push((arguments[i__4865__auto___36466]));

var G__36467 = (i__4865__auto___36466 + (1));
i__4865__auto___36466 = G__36467;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__36468 = cljs.core.nnext.call(null,in$);
var G__36469 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__36468;
out = G__36469;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq36464){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36464));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4870__auto__ = [];
var len__4864__auto___36472 = arguments.length;
var i__4865__auto___36473 = (0);
while(true){
if((i__4865__auto___36473 < len__4864__auto___36472)){
args__4870__auto__.push((arguments[i__4865__auto___36473]));

var G__36474 = (i__4865__auto___36473 + (1));
i__4865__auto___36473 = G__36474;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_by.call(null,comparator);
while(true){
if(in$){
var G__36475 = cljs.core.nnext.call(null,in$);
var G__36476 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__36475;
out = G__36476;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq36470){
var G__36471 = cljs.core.first.call(null,seq36470);
var seq36470__$1 = cljs.core.next.call(null,seq36470);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36471,seq36470__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4870__auto__ = [];
var len__4864__auto___36479 = arguments.length;
var i__4865__auto___36480 = (0);
while(true){
if((i__4865__auto___36480 < len__4864__auto___36479)){
args__4870__auto__.push((arguments[i__4865__auto___36480]));

var G__36481 = (i__4865__auto___36480 + (1));
i__4865__auto___36480 = G__36481;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.call(null,keyfn);
while(true){
if(in$){
var G__36482 = cljs.core.nnext.call(null,in$);
var G__36483 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__36482;
out = G__36483;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq36477){
var G__36478 = cljs.core.first.call(null,seq36477);
var seq36477__$1 = cljs.core.next.call(null,seq36477);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36478,seq36477__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4870__auto__ = [];
var len__4864__auto___36487 = arguments.length;
var i__4865__auto___36488 = (0);
while(true){
if((i__4865__auto___36488 < len__4864__auto___36487)){
args__4870__auto__.push((arguments[i__4865__auto___36488]));

var G__36489 = (i__4865__auto___36488 + (1));
i__4865__auto___36488 = G__36489;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.call(null,keyfn,comparator);
while(true){
if(in$){
var G__36490 = cljs.core.nnext.call(null,in$);
var G__36491 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__36490;
out = G__36491;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq36484){
var G__36485 = cljs.core.first.call(null,seq36484);
var seq36484__$1 = cljs.core.next.call(null,seq36484);
var G__36486 = cljs.core.first.call(null,seq36484__$1);
var seq36484__$2 = cljs.core.next.call(null,seq36484__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36485,G__36486,seq36484__$2);
}));

