// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('sci.impl.load');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('sci.impl.utils');
goog.require('sci.impl.vars');
sci.impl.load.handle_refer_all = (function sci$impl$load$handle_refer_all(the_current_ns,the_loaded_ns,include_sym_QMARK_,rename_sym,only){
var referred = new cljs.core.Keyword(null,"refers","refers",158076809).cljs$core$IFn$_invoke$arity$1(the_current_ns);
var only__$1 = (cljs.core.truth_(only)?cljs.core.set.call(null,only):null);
var referred__$1 = cljs.core.reduce.call(null,(function (ns,p__35858){
var vec__35859 = p__35858;
var k = cljs.core.nth.call(null,vec__35859,(0),null);
var v = cljs.core.nth.call(null,vec__35859,(1),null);
if(cljs.core.truth_((function (){var and__4251__auto__ = (k instanceof cljs.core.Symbol);
if(and__4251__auto__){
var and__4251__auto____$1 = include_sym_QMARK_.call(null,k);
if(cljs.core.truth_(and__4251__auto____$1)){
return ((cljs.core.not.call(null,only__$1)) || (cljs.core.contains_QMARK_.call(null,only__$1,k)));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
return cljs.core.assoc.call(null,ns,rename_sym.call(null,k),v);
} else {
return ns;
}
}),referred,the_loaded_ns);
return cljs.core.assoc.call(null,the_current_ns,new cljs.core.Keyword(null,"refers","refers",158076809),referred__$1);
});
sci.impl.load.handle_require_libspec_env = (function sci$impl$load$handle_require_libspec_env(_ctx,env,current_ns,the_loaded_ns,lib_name,p__35862){
var map__35863 = p__35862;
var map__35863__$1 = cljs.core.__destructure_map.call(null,map__35863);
var _parsed_libspec = map__35863__$1;
var as = cljs.core.get.call(null,map__35863__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var refer = cljs.core.get.call(null,map__35863__$1,new cljs.core.Keyword(null,"refer","refer",-964295553));
var rename = cljs.core.get.call(null,map__35863__$1,new cljs.core.Keyword(null,"rename","rename",1508157613));
var exclude = cljs.core.get.call(null,map__35863__$1,new cljs.core.Keyword(null,"exclude","exclude",-1230250334));
var only = cljs.core.get.call(null,map__35863__$1,new cljs.core.Keyword(null,"only","only",1907811652));
var use = cljs.core.get.call(null,map__35863__$1,new cljs.core.Keyword(null,"use","use",-1846382424));
var the_current_ns = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),current_ns], null));
var the_current_ns__$1 = (cljs.core.truth_(as)?cljs.core.assoc_in.call(null,the_current_ns,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"aliases","aliases",1346874714),as], null),lib_name):the_current_ns);
var rename_sym = (cljs.core.truth_(rename)?(function (sym){
var or__4253__auto__ = rename.call(null,sym);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return sym;
}
}):cljs.core.identity);
var include_sym_QMARK_ = (cljs.core.truth_(exclude)?(function (){var excludes = cljs.core.set.call(null,exclude);
return (function (sym){
return (!(cljs.core.contains_QMARK_.call(null,excludes,sym)));
});
})():cljs.core.constantly.call(null,true));
var the_current_ns__$2 = (cljs.core.truth_(refer)?(cljs.core.truth_((function (){var or__4253__auto__ = cljs.core.keyword_identical_QMARK_.call(null,new cljs.core.Keyword(null,"all","all",892129742),refer);
if(or__4253__auto__){
return or__4253__auto__;
} else {
return use;
}
})())?sci.impl.load.handle_refer_all.call(null,the_current_ns__$1,the_loaded_ns,include_sym_QMARK_,rename_sym,null):((cljs.core.sequential_QMARK_.call(null,refer))?(function (){var referred = new cljs.core.Keyword(null,"refers","refers",158076809).cljs$core$IFn$_invoke$arity$1(the_current_ns__$1);
var referred__$1 = cljs.core.reduce.call(null,(function (ns,sym){
if(cljs.core.truth_(include_sym_QMARK_.call(null,sym))){
return cljs.core.assoc.call(null,ns,rename_sym.call(null,sym),(function (){var temp__5802__auto__ = cljs.core.find.call(null,the_loaded_ns,sym);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__35864 = temp__5802__auto__;
var _k = cljs.core.nth.call(null,vec__35864,(0),null);
var v = cljs.core.nth.call(null,vec__35864,(1),null);
return v;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)," does not exist"].join('')));
}
})());
} else {
return ns;
}
}),referred,refer);
return cljs.core.assoc.call(null,the_current_ns__$1,new cljs.core.Keyword(null,"refers","refers",158076809),referred__$1);
})():(function(){throw (new Error(":refer value must be a sequential collection of symbols"))})()
)):(cljs.core.truth_(use)?sci.impl.load.handle_refer_all.call(null,the_current_ns__$1,the_loaded_ns,include_sym_QMARK_,rename_sym,only):the_current_ns__$1
));
var env__$1 = cljs.core.assoc_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),current_ns], null),the_current_ns__$2);
var temp__5804__auto___35868 = (function (){var G__35867 = the_loaded_ns;
var G__35867__$1 = (((G__35867 == null))?null:new cljs.core.Keyword(null,"obj","obj",981763962).cljs$core$IFn$_invoke$arity$1(G__35867));
var G__35867__$2 = (((G__35867__$1 == null))?null:cljs.core.meta.call(null,G__35867__$1));
if((G__35867__$2 == null)){
return null;
} else {
return new cljs.core.Keyword("sci.impl","required-fn","sci.impl/required-fn",2082701278).cljs$core$IFn$_invoke$arity$1(G__35867__$2);
}
})();
if(cljs.core.truth_(temp__5804__auto___35868)){
var on_loaded_35869 = temp__5804__auto___35868;
on_loaded_35869.call(null,cljs.core.PersistentArrayMap.EMPTY);
} else {
}

return env__$1;
});
sci.impl.load.add_loaded_lib = (function sci$impl$load$add_loaded_lib(env,lib){
cljs.core.swap_BANG_.call(null,env,cljs.core.update,new cljs.core.Keyword(null,"loaded-libs","loaded-libs",-1156389652),(function (loaded_libs){
if((loaded_libs == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([lib]);
} else {
return cljs.core.conj.call(null,loaded_libs,lib);
}
}));

return null;
});
sci.impl.load.handle_require_libspec = (function sci$impl$load$handle_require_libspec(ctx,lib,opts){
var env_STAR_ = new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx);
var env = cljs.core.deref.call(null,env_STAR_);
var cnn = sci.impl.vars.current_ns_name.call(null);
var temp__5802__auto__ = new cljs.core.Keyword(null,"as-alias","as-alias",82482467).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var as_alias = temp__5802__auto__;
return cljs.core.reset_BANG_.call(null,env_STAR_,sci.impl.load.handle_require_libspec_env.call(null,ctx,env,cnn,null,lib,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as","as",1148689641),as_alias], null)));
} else {
var map__35870 = opts;
var map__35870__$1 = cljs.core.__destructure_map.call(null,map__35870);
var reload = cljs.core.get.call(null,map__35870__$1,new cljs.core.Keyword(null,"reload","reload",863702807));
var reload_all = cljs.core.get.call(null,map__35870__$1,new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
var namespaces = cljs.core.get.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var reload_STAR_ = (function (){var or__4253__auto__ = reload;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = reload_all;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(ctx);
}
}
})();
var temp__5802__auto___35873__$1 = (cljs.core.truth_(reload_STAR_)?null:cljs.core.get.call(null,namespaces,lib));
if(cljs.core.truth_(temp__5802__auto___35873__$1)){
var the_loaded_ns_35874 = temp__5802__auto___35873__$1;
var loading_35875 = new cljs.core.Keyword(null,"loading","loading",-737050189).cljs$core$IFn$_invoke$arity$1(ctx);
if(cljs.core.truth_((function (){var and__4251__auto__ = loading_35875;
if(cljs.core.truth_(and__4251__auto__)){
return (((!(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"loaded-libs","loaded-libs",-1156389652).cljs$core$IFn$_invoke$arity$1(env),lib)))) && (cljs.core.nat_int_QMARK_.call(null,loading_35875.indexOf(lib))));
} else {
return and__4251__auto__;
}
})())){
sci.impl.utils.throw_error_with_location.call(null,(function (){var lib_emphasized = ["[ ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib)," ]"].join('');
var loading__$1 = cljs.core.conj.call(null,loading_35875,lib);
var loading__$2 = cljs.core.replace.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([lib,lib_emphasized]),loading__$1);
return ["Cyclic load dependency: ",clojure.string.join.call(null,"->",loading__$2)].join('');
})(),lib);
} else {
cljs.core.reset_BANG_.call(null,env_STAR_,sci.impl.load.handle_require_libspec_env.call(null,ctx,env,cnn,the_loaded_ns_35874,lib,opts));
}
} else {
var temp__5802__auto___35876__$2 = new cljs.core.Keyword(null,"load-fn","load-fn",-2121144334).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_(temp__5802__auto___35876__$2)){
var load_fn_35877 = temp__5802__auto___35876__$2;
var temp__5802__auto___35878__$3 = load_fn_35877.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),lib,new cljs.core.Keyword(null,"reload","reload",863702807),(function (){var or__4253__auto__ = reload;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return reload_all;
}
})()], null));
if(cljs.core.truth_(temp__5802__auto___35878__$3)){
var map__35871_35879 = temp__5802__auto___35878__$3;
var map__35871_35880__$1 = cljs.core.__destructure_map.call(null,map__35871_35879);
var file_35881 = cljs.core.get.call(null,map__35871_35880__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var source_35882 = cljs.core.get.call(null,map__35871_35880__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var ctx_35883__$1 = cljs.core.update.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,ctx,new cljs.core.Keyword(null,"bindings","bindings",1271397192),cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"reload-all","reload-all",761570200),reload_all),new cljs.core.Keyword(null,"loading","loading",-737050189),(function (loading){
if((loading == null)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lib], null);
} else {
return cljs.core.conj.call(null,loading,lib);
}
}));
try{sci.impl.vars.push_thread_bindings.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([sci.impl.vars.current_ns,cljs.core.deref.call(null,sci.impl.vars.current_ns),sci.impl.vars.current_file,file_35881]));

try{cljs.core.deref.call(null,sci.impl.utils.eval_string_STAR_).call(null,ctx_35883__$1,source_35882);
}finally {sci.impl.vars.pop_thread_bindings.call(null);
}}catch (e35872){if((e35872 instanceof Error)){
var e_35884 = e35872;
cljs.core.swap_BANG_.call(null,env_STAR_,cljs.core.update,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cljs.core.dissoc,lib);

throw e_35884;
} else {
throw e35872;

}
}
cljs.core.swap_BANG_.call(null,env_STAR_,(function (env__$1){
var namespaces__$1 = cljs.core.get.call(null,env__$1,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var the_loaded_ns = cljs.core.get.call(null,namespaces__$1,lib);
return sci.impl.load.handle_require_libspec_env.call(null,ctx,env__$1,cnn,the_loaded_ns,lib,opts);
}));
} else {
var or__4253__auto___35885 = (cljs.core.truth_(reload_STAR_)?(function (){var temp__5804__auto__ = cljs.core.get.call(null,namespaces,lib);
if(cljs.core.truth_(temp__5804__auto__)){
var the_loaded_ns = temp__5804__auto__;
return cljs.core.reset_BANG_.call(null,env_STAR_,sci.impl.load.handle_require_libspec_env.call(null,ctx,env,cnn,the_loaded_ns,lib,opts));
} else {
return null;
}
})():null);
if(cljs.core.truth_(or__4253__auto___35885)){
} else {
throw (new Error(["Could not find namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib),"."].join('')));
}
}
} else {
throw (new Error(["Could not find namespace ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib),"."].join('')));
}
}

sci.impl.load.add_loaded_lib.call(null,env_STAR_,lib);

return null;
}
});
sci.impl.load.load_lib = (function sci$impl$load$load_lib(var_args){
var args__4870__auto__ = [];
var len__4864__auto___35890 = arguments.length;
var i__4865__auto___35891 = (0);
while(true){
if((i__4865__auto___35891 < len__4864__auto___35890)){
args__4870__auto__.push((arguments[i__4865__auto___35891]));

var G__35892 = (i__4865__auto___35891 + (1));
i__4865__auto___35891 = G__35892;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return sci.impl.load.load_lib.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(sci.impl.load.load_lib.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,prefix,lib,options){
if(cljs.core.truth_((function (){var and__4251__auto__ = prefix;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.name.call(null,lib).indexOf(".") > (0));
} else {
return and__4251__auto__;
}
})())){
sci.impl.utils.throw_error_with_location.call(null,["Found lib name '",cljs.core.name.call(null,lib),"' containing period with prefix '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),"'.  lib names inside prefix lists must not contain periods"].join(''),lib);
} else {
}

var lib__$1 = (cljs.core.truth_(prefix)?cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib)].join('')):lib);
var opts = cljs.core.apply.call(null,cljs.core.hash_map,options);
return sci.impl.load.handle_require_libspec.call(null,ctx,lib__$1,opts);
}));

(sci.impl.load.load_lib.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(sci.impl.load.load_lib.cljs$lang$applyTo = (function (seq35886){
var G__35887 = cljs.core.first.call(null,seq35886);
var seq35886__$1 = cljs.core.next.call(null,seq35886);
var G__35888 = cljs.core.first.call(null,seq35886__$1);
var seq35886__$2 = cljs.core.next.call(null,seq35886__$1);
var G__35889 = cljs.core.first.call(null,seq35886__$2);
var seq35886__$3 = cljs.core.next.call(null,seq35886__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35887,G__35888,G__35889,seq35886__$3);
}));

/**
 * Prepends a symbol or a seq to coll
 */
sci.impl.load.prependss = (function sci$impl$load$prependss(x,coll){
if((x instanceof cljs.core.Symbol)){
return cljs.core.cons.call(null,x,coll);
} else {
return cljs.core.concat.call(null,x,coll);
}
});
/**
 * Returns true if x is a libspec
 */
sci.impl.load.libspec_QMARK_ = (function sci$impl$load$libspec_QMARK_(x){
return (((x instanceof cljs.core.Symbol)) || (((cljs.core.vector_QMARK_.call(null,x)) && ((((cljs.core.second.call(null,x) == null)) || ((cljs.core.second.call(null,x) instanceof cljs.core.Keyword)))))));
});
/**
 * Loads libs, evaling libspecs, prefix lists, and flags for
 *   forwarding to load-lib
 */
sci.impl.load.load_libs = (function sci$impl$load$load_libs(ctx,kw,args){
var args_STAR_ = cljs.core.cons.call(null,kw,args);
var flags = cljs.core.filter.call(null,cljs.core.keyword_QMARK_,args_STAR_);
var opts = cljs.core.interleave.call(null,flags,cljs.core.repeat.call(null,true));
var args_STAR___$1 = cljs.core.filter.call(null,cljs.core.complement.call(null,cljs.core.keyword_QMARK_),args_STAR_);
var supported_35925 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"use","use",-1846382424),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"require","require",-468001333),null,new cljs.core.Keyword(null,"verbose","verbose",1694226060),null,new cljs.core.Keyword(null,"reload","reload",863702807),null,new cljs.core.Keyword(null,"reload-all","reload-all",761570200),null,new cljs.core.Keyword(null,"refer","refer",-964295553),null], null), null);
var unsupported_35926 = cljs.core.seq.call(null,cljs.core.remove.call(null,supported_35925,flags));
if(unsupported_35926){
sci.impl.utils.throw_error_with_location.call(null,cljs.core.apply.call(null,cljs.core.str,"Unsupported option(s) supplied: ",cljs.core.interpose.call(null,",",unsupported_35926)),args);
} else {
}

if(cljs.core.seq.call(null,args_STAR___$1)){
} else {
sci.impl.utils.throw_error_with_location.call(null,"Nothing specified to load",args);
}

var seq__35893 = cljs.core.seq.call(null,args_STAR___$1);
var chunk__35894 = null;
var count__35895 = (0);
var i__35896 = (0);
while(true){
if((i__35896 < count__35895)){
var arg = cljs.core._nth.call(null,chunk__35894,i__35896);
if(sci.impl.load.libspec_QMARK_.call(null,arg)){
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,null,sci.impl.load.prependss.call(null,arg,opts));
} else {
var vec__35911_35927 = arg;
var seq__35912_35928 = cljs.core.seq.call(null,vec__35911_35927);
var first__35913_35929 = cljs.core.first.call(null,seq__35912_35928);
var seq__35912_35930__$1 = cljs.core.next.call(null,seq__35912_35928);
var prefix_35931 = first__35913_35929;
var args_STAR__35932__$2 = seq__35912_35930__$1;
if((prefix_35931 == null)){
sci.impl.utils.throw_error_with_location.call(null,"prefix cannot be nil",args);
} else {
}

var seq__35914_35933 = cljs.core.seq.call(null,args_STAR__35932__$2);
var chunk__35915_35934 = null;
var count__35916_35935 = (0);
var i__35917_35936 = (0);
while(true){
if((i__35917_35936 < count__35916_35935)){
var arg_35937__$1 = cljs.core._nth.call(null,chunk__35915_35934,i__35917_35936);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_35931,sci.impl.load.prependss.call(null,arg_35937__$1,opts));


var G__35938 = seq__35914_35933;
var G__35939 = chunk__35915_35934;
var G__35940 = count__35916_35935;
var G__35941 = (i__35917_35936 + (1));
seq__35914_35933 = G__35938;
chunk__35915_35934 = G__35939;
count__35916_35935 = G__35940;
i__35917_35936 = G__35941;
continue;
} else {
var temp__5804__auto___35942 = cljs.core.seq.call(null,seq__35914_35933);
if(temp__5804__auto___35942){
var seq__35914_35943__$1 = temp__5804__auto___35942;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35914_35943__$1)){
var c__4679__auto___35944 = cljs.core.chunk_first.call(null,seq__35914_35943__$1);
var G__35945 = cljs.core.chunk_rest.call(null,seq__35914_35943__$1);
var G__35946 = c__4679__auto___35944;
var G__35947 = cljs.core.count.call(null,c__4679__auto___35944);
var G__35948 = (0);
seq__35914_35933 = G__35945;
chunk__35915_35934 = G__35946;
count__35916_35935 = G__35947;
i__35917_35936 = G__35948;
continue;
} else {
var arg_35949__$1 = cljs.core.first.call(null,seq__35914_35943__$1);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_35931,sci.impl.load.prependss.call(null,arg_35949__$1,opts));


var G__35950 = cljs.core.next.call(null,seq__35914_35943__$1);
var G__35951 = null;
var G__35952 = (0);
var G__35953 = (0);
seq__35914_35933 = G__35950;
chunk__35915_35934 = G__35951;
count__35916_35935 = G__35952;
i__35917_35936 = G__35953;
continue;
}
} else {
}
}
break;
}
}


var G__35954 = seq__35893;
var G__35955 = chunk__35894;
var G__35956 = count__35895;
var G__35957 = (i__35896 + (1));
seq__35893 = G__35954;
chunk__35894 = G__35955;
count__35895 = G__35956;
i__35896 = G__35957;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__35893);
if(temp__5804__auto__){
var seq__35893__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35893__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__35893__$1);
var G__35958 = cljs.core.chunk_rest.call(null,seq__35893__$1);
var G__35959 = c__4679__auto__;
var G__35960 = cljs.core.count.call(null,c__4679__auto__);
var G__35961 = (0);
seq__35893 = G__35958;
chunk__35894 = G__35959;
count__35895 = G__35960;
i__35896 = G__35961;
continue;
} else {
var arg = cljs.core.first.call(null,seq__35893__$1);
if(sci.impl.load.libspec_QMARK_.call(null,arg)){
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,null,sci.impl.load.prependss.call(null,arg,opts));
} else {
var vec__35918_35962 = arg;
var seq__35919_35963 = cljs.core.seq.call(null,vec__35918_35962);
var first__35920_35964 = cljs.core.first.call(null,seq__35919_35963);
var seq__35919_35965__$1 = cljs.core.next.call(null,seq__35919_35963);
var prefix_35966 = first__35920_35964;
var args_STAR__35967__$2 = seq__35919_35965__$1;
if((prefix_35966 == null)){
sci.impl.utils.throw_error_with_location.call(null,"prefix cannot be nil",args);
} else {
}

var seq__35921_35968 = cljs.core.seq.call(null,args_STAR__35967__$2);
var chunk__35922_35969 = null;
var count__35923_35970 = (0);
var i__35924_35971 = (0);
while(true){
if((i__35924_35971 < count__35923_35970)){
var arg_35972__$1 = cljs.core._nth.call(null,chunk__35922_35969,i__35924_35971);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_35966,sci.impl.load.prependss.call(null,arg_35972__$1,opts));


var G__35973 = seq__35921_35968;
var G__35974 = chunk__35922_35969;
var G__35975 = count__35923_35970;
var G__35976 = (i__35924_35971 + (1));
seq__35921_35968 = G__35973;
chunk__35922_35969 = G__35974;
count__35923_35970 = G__35975;
i__35924_35971 = G__35976;
continue;
} else {
var temp__5804__auto___35977__$1 = cljs.core.seq.call(null,seq__35921_35968);
if(temp__5804__auto___35977__$1){
var seq__35921_35978__$1 = temp__5804__auto___35977__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35921_35978__$1)){
var c__4679__auto___35979 = cljs.core.chunk_first.call(null,seq__35921_35978__$1);
var G__35980 = cljs.core.chunk_rest.call(null,seq__35921_35978__$1);
var G__35981 = c__4679__auto___35979;
var G__35982 = cljs.core.count.call(null,c__4679__auto___35979);
var G__35983 = (0);
seq__35921_35968 = G__35980;
chunk__35922_35969 = G__35981;
count__35923_35970 = G__35982;
i__35924_35971 = G__35983;
continue;
} else {
var arg_35984__$1 = cljs.core.first.call(null,seq__35921_35978__$1);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_35966,sci.impl.load.prependss.call(null,arg_35984__$1,opts));


var G__35985 = cljs.core.next.call(null,seq__35921_35978__$1);
var G__35986 = null;
var G__35987 = (0);
var G__35988 = (0);
seq__35921_35968 = G__35985;
chunk__35922_35969 = G__35986;
count__35923_35970 = G__35987;
i__35924_35971 = G__35988;
continue;
}
} else {
}
}
break;
}
}


var G__35989 = cljs.core.next.call(null,seq__35893__$1);
var G__35990 = null;
var G__35991 = (0);
var G__35992 = (0);
seq__35893 = G__35989;
chunk__35894 = G__35990;
count__35895 = G__35991;
i__35896 = G__35992;
continue;
}
} else {
return null;
}
}
break;
}
});
sci.impl.load.eval_require = (function sci$impl$load$eval_require(var_args){
var args__4870__auto__ = [];
var len__4864__auto___35995 = arguments.length;
var i__4865__auto___35996 = (0);
while(true){
if((i__4865__auto___35996 < len__4864__auto___35995)){
args__4870__auto__.push((arguments[i__4865__auto___35996]));

var G__35997 = (i__4865__auto___35996 + (1));
i__4865__auto___35996 = G__35997;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return sci.impl.load.eval_require.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(sci.impl.load.eval_require.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,args){
return sci.impl.load.load_libs.call(null,ctx,new cljs.core.Keyword(null,"require","require",-468001333),args);
}));

(sci.impl.load.eval_require.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.load.eval_require.cljs$lang$applyTo = (function (seq35993){
var G__35994 = cljs.core.first.call(null,seq35993);
var seq35993__$1 = cljs.core.next.call(null,seq35993);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35994,seq35993__$1);
}));

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_require_state,sci.impl.load.eval_require);
sci.impl.load.eval_use = (function sci$impl$load$eval_use(var_args){
var args__4870__auto__ = [];
var len__4864__auto___36000 = arguments.length;
var i__4865__auto___36001 = (0);
while(true){
if((i__4865__auto___36001 < len__4864__auto___36000)){
args__4870__auto__.push((arguments[i__4865__auto___36001]));

var G__36002 = (i__4865__auto___36001 + (1));
i__4865__auto___36001 = G__36002;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return sci.impl.load.eval_use.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(sci.impl.load.eval_use.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,args){
return sci.impl.load.load_libs.call(null,ctx,new cljs.core.Keyword(null,"use","use",-1846382424),args);
}));

(sci.impl.load.eval_use.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.load.eval_use.cljs$lang$applyTo = (function (seq35998){
var G__35999 = cljs.core.first.call(null,seq35998);
var seq35998__$1 = cljs.core.next.call(null,seq35998);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35999,seq35998__$1);
}));

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_use_state,sci.impl.load.eval_use);
sci.impl.load.eval_refer_clojure = (function sci$impl$load$eval_refer_clojure(ctx,exprs){
var ns_sym = new cljs.core.Symbol(null,"clojure.core","clojure.core",-189332625,null);
var exprs__$1 = exprs;
while(true){
if(cljs.core.truth_(exprs__$1)){
var vec__36003 = exprs__$1;
var k = cljs.core.nth.call(null,vec__36003,(0),null);
var v = cljs.core.nth.call(null,vec__36003,(1),null);
var G__36006_36011 = k;
var G__36006_36012__$1 = (((G__36006_36011 instanceof cljs.core.Keyword))?G__36006_36011.fqn:null);
switch (G__36006_36012__$1) {
case "exclude":
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__36006_36011,G__36006_36012__$1,vec__36003,k,v,ns_sym){
return (function (env){
var cnn = sci.impl.vars.current_ns_name.call(null);
return cljs.core.update_in.call(null,env,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,new cljs.core.Keyword(null,"refer","refer",-964295553),ns_sym,new cljs.core.Keyword(null,"exclude","exclude",-1230250334)], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),v);
});})(exprs__$1,G__36006_36011,G__36006_36012__$1,vec__36003,k,v,ns_sym))
);

break;
case "only":
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__36006_36011,G__36006_36012__$1,vec__36003,k,v,ns_sym){
return (function (env){
var cnn = sci.impl.vars.current_ns_name.call(null);
var other_ns = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),ns_sym], null));
var other_vars = cljs.core.select_keys.call(null,other_ns,v);
return cljs.core.update_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),cljs.core.merge,other_vars);
});})(exprs__$1,G__36006_36011,G__36006_36012__$1,vec__36003,k,v,ns_sym))
);

break;
case "rename":
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__36006_36011,G__36006_36012__$1,vec__36003,k,v,ns_sym){
return (function (env){
var cnn = sci.impl.vars.current_ns_name.call(null);
var namespaces = new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469).cljs$core$IFn$_invoke$arity$1(env);
var the_current_ns = cljs.core.get.call(null,namespaces,cnn);
var other_ns = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),ns_sym], null));
var the_current_ns__$1 = cljs.core.reduce.call(null,((function (exprs__$1,cnn,namespaces,the_current_ns,other_ns,G__36006_36011,G__36006_36012__$1,vec__36003,k,v,ns_sym){
return (function (acc,p__36007){
var vec__36008 = p__36007;
var original_name = cljs.core.nth.call(null,vec__36008,(0),null);
var new_name = cljs.core.nth.call(null,vec__36008,(1),null);
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"refers","refers",158076809),new_name], null),cljs.core.get.call(null,other_ns,original_name)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"refer","refer",-964295553),ns_sym,new cljs.core.Keyword(null,"exclude","exclude",-1230250334)], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),original_name);
});})(exprs__$1,cnn,namespaces,the_current_ns,other_ns,G__36006_36011,G__36006_36012__$1,vec__36003,k,v,ns_sym))
,the_current_ns,v);
return cljs.core.assoc_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),the_current_ns__$1);
});})(exprs__$1,G__36006_36011,G__36006_36012__$1,vec__36003,k,v,ns_sym))
);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__36006_36012__$1)].join('')));

}

var G__36014 = cljs.core.nnext.call(null,exprs__$1);
exprs__$1 = G__36014;
continue;
} else {
return null;
}
break;
}
});
sci.impl.load.eval_refer_STAR_ = (function sci$impl$load$eval_refer_STAR_(env,ns_sym,filters){

var cnn = sci.impl.vars.current_ns_name.call(null);
var namespaces = new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469).cljs$core$IFn$_invoke$arity$1(env);
var ns = (function (){var or__4253__auto__ = cljs.core.get.call(null,namespaces,ns_sym);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw (new Error(["No namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns_sym)].join('')));
}
})();
var fs = cljs.core.apply.call(null,cljs.core.hash_map,filters);
var public_keys = cljs.core.filter.call(null,cljs.core.symbol_QMARK_,cljs.core.keys.call(null,ns));
var rename = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"rename","rename",1508157613).cljs$core$IFn$_invoke$arity$1(fs);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var exclude = cljs.core.set.call(null,new cljs.core.Keyword(null,"exclude","exclude",-1230250334).cljs$core$IFn$_invoke$arity$1(fs));
var to_do = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"refer","refer",-964295553).cljs$core$IFn$_invoke$arity$1(fs)))?public_keys:(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"refer","refer",-964295553).cljs$core$IFn$_invoke$arity$1(fs);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"only","only",1907811652).cljs$core$IFn$_invoke$arity$1(fs);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return public_keys;
}
}
})());
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = to_do;
if(cljs.core.truth_(and__4251__auto__)){
return (!(cljs.core.sequential_QMARK_.call(null,to_do)));
} else {
return and__4251__auto__;
}
})())?(function(){throw (new Error(":only/:refer value must be a sequential collection of symbols"))})():null);
var the_current_ns = cljs.core.get.call(null,namespaces,cnn);
var referred = new cljs.core.Keyword(null,"refers","refers",158076809).cljs$core$IFn$_invoke$arity$1(the_current_ns);
var referred__$1 = cljs.core.reduce.call(null,(function (referred__$1,sym){
if(cljs.core.not.call(null,exclude.call(null,sym))){
var v = cljs.core.get.call(null,ns,sym);
if(cljs.core.truth_(v)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)," does not exist"].join('')
));
}

return cljs.core.assoc.call(null,referred__$1,(function (){var or__4253__auto__ = rename.call(null,sym);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return sym;
}
})(),v);
} else {
return referred__$1;
}
}),referred,to_do);
var the_current_ns__$1 = cljs.core.assoc.call(null,the_current_ns,new cljs.core.Keyword(null,"refers","refers",158076809),referred__$1);
var namespaces__$1 = cljs.core.assoc.call(null,namespaces,cnn,the_current_ns__$1);
var env__$1 = cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),namespaces__$1);
return env__$1;
});
/**
 * The function equivalent of :refer is handled differently than what we
 *   did before (this is more like what Clojure itself does.) For
 *   referring clojure.core we still use the old code.
 */
sci.impl.load.eval_refer = (function sci$impl$load$eval_refer(var_args){
var args__4870__auto__ = [];
var len__4864__auto___36018 = arguments.length;
var i__4865__auto___36019 = (0);
while(true){
if((i__4865__auto___36019 < len__4864__auto___36018)){
args__4870__auto__.push((arguments[i__4865__auto___36019]));

var G__36020 = (i__4865__auto___36019 + (1));
i__4865__auto___36019 = G__36020;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return sci.impl.load.eval_refer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(sci.impl.load.eval_refer.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,ns_sym,filters){
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"clojure.core","clojure.core",-189332625,null),ns_sym)){
sci.impl.load.eval_refer_clojure.call(null,ctx,filters);
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),sci.impl.load.eval_refer_STAR_,ns_sym,filters);
}

return null;
}));

(sci.impl.load.eval_refer.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(sci.impl.load.eval_refer.cljs$lang$applyTo = (function (seq36015){
var G__36016 = cljs.core.first.call(null,seq36015);
var seq36015__$1 = cljs.core.next.call(null,seq36015);
var G__36017 = cljs.core.first.call(null,seq36015__$1);
var seq36015__$2 = cljs.core.next.call(null,seq36015__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36016,G__36017,seq36015__$2);
}));

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_refer_state,sci.impl.load.eval_refer);
