// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4253__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_11547){
var state_val_11548 = (state_11547[(1)]);
if((state_val_11548 === (7))){
var inst_11542 = (state_11547[(2)]);
var _ = (function (){var statearr_11549 = state_11547;
(statearr_11549[(4)] = cljs.core.rest.call(null,(state_11547[(4)])));

return statearr_11549;
})();
var state_11547__$1 = state_11547;
var statearr_11550_11572 = state_11547__$1;
(statearr_11550_11572[(2)] = inst_11542);

(statearr_11550_11572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11548 === (1))){
var state_11547__$1 = state_11547;
var statearr_11551_11573 = state_11547__$1;
(statearr_11551_11573[(2)] = null);

(statearr_11551_11573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11548 === (4))){
var inst_11504 = (state_11547[(2)]);
var state_11547__$1 = state_11547;
var statearr_11552_11574 = state_11547__$1;
(statearr_11552_11574[(2)] = inst_11504);

(statearr_11552_11574[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11548 === (6))){
var inst_11522 = (state_11547[(7)]);
var inst_11529 = (state_11547[(8)]);
var inst_11528 = cljs.core.seq.call(null,inst_11522);
var inst_11529__$1 = cljs.core.first.call(null,inst_11528);
var inst_11530 = cljs.core.next.call(null,inst_11528);
var inst_11531 = cljs.core.not.call(null,inst_11529__$1);
var state_11547__$1 = (function (){var statearr_11553 = state_11547;
(statearr_11553[(9)] = inst_11530);

(statearr_11553[(8)] = inst_11529__$1);

return statearr_11553;
})();
if(inst_11531){
var statearr_11554_11575 = state_11547__$1;
(statearr_11554_11575[(1)] = (8));

} else {
var statearr_11555_11576 = state_11547__$1;
(statearr_11555_11576[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11548 === (3))){
var inst_11545 = (state_11547[(2)]);
var state_11547__$1 = state_11547;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11547__$1,inst_11545);
} else {
if((state_val_11548 === (2))){
var _ = (function (){var statearr_11556 = state_11547;
(statearr_11556[(4)] = cljs.core.cons.call(null,(5),(state_11547[(4)])));

return statearr_11556;
})();
var inst_11517 = chs;
var inst_11518 = cljs.core.seq.call(null,inst_11517);
var inst_11519 = cljs.core.first.call(null,inst_11518);
var inst_11520 = cljs.core.next.call(null,inst_11518);
var inst_11521 = coll;
var inst_11522 = inst_11517;
var inst_11523 = inst_11521;
var state_11547__$1 = (function (){var statearr_11557 = state_11547;
(statearr_11557[(10)] = inst_11519);

(statearr_11557[(11)] = inst_11523);

(statearr_11557[(12)] = inst_11520);

(statearr_11557[(7)] = inst_11522);

return statearr_11557;
})();
var statearr_11558_11577 = state_11547__$1;
(statearr_11558_11577[(2)] = null);

(statearr_11558_11577[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11548 === (11))){
var inst_11523 = (state_11547[(11)]);
var inst_11530 = (state_11547[(9)]);
var inst_11535 = (state_11547[(2)]);
var inst_11536 = fluree.db.util.async.throw_err.call(null,inst_11535);
var inst_11537 = cljs.core.conj.call(null,inst_11523,inst_11536);
var inst_11522 = inst_11530;
var inst_11523__$1 = inst_11537;
var state_11547__$1 = (function (){var statearr_11560 = state_11547;
(statearr_11560[(11)] = inst_11523__$1);

(statearr_11560[(7)] = inst_11522);

return statearr_11560;
})();
var statearr_11561_11578 = state_11547__$1;
(statearr_11561_11578[(2)] = null);

(statearr_11561_11578[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11548 === (9))){
var inst_11529 = (state_11547[(8)]);
var state_11547__$1 = state_11547;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11547__$1,(11),inst_11529);
} else {
if((state_val_11548 === (5))){
var _ = (function (){var statearr_11562 = state_11547;
(statearr_11562[(4)] = cljs.core.rest.call(null,(state_11547[(4)])));

return statearr_11562;
})();
var state_11547__$1 = state_11547;
var ex11559 = (state_11547__$1[(2)]);
var statearr_11563_11579 = state_11547__$1;
(statearr_11563_11579[(5)] = ex11559);


var statearr_11564_11580 = state_11547__$1;
(statearr_11564_11580[(1)] = (4));

(statearr_11564_11580[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11548 === (10))){
var inst_11540 = (state_11547[(2)]);
var state_11547__$1 = state_11547;
var statearr_11565_11581 = state_11547__$1;
(statearr_11565_11581[(2)] = inst_11540);

(statearr_11565_11581[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11548 === (8))){
var inst_11523 = (state_11547[(11)]);
var state_11547__$1 = state_11547;
var statearr_11566_11582 = state_11547__$1;
(statearr_11566_11582[(2)] = inst_11523);

(statearr_11566_11582[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_11567 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11567[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__);

(statearr_11567[(1)] = (1));

return statearr_11567;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1 = (function (state_11547){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_11547);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e11568){var ex__2730__auto__ = e11568;
var statearr_11569_11583 = state_11547;
(statearr_11569_11583[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_11547[(4)]))){
var statearr_11570_11584 = state_11547;
(statearr_11570_11584[(1)] = cljs.core.first.call(null,(state_11547[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11585 = state_11547;
state_11547 = G__11585;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__ = function(state_11547){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1.call(this,state_11547);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_11571 = f__2750__auto__.call(null);
(statearr_11571[(6)] = c__2749__auto__);

return statearr_11571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_11611){
var state_val_11612 = (state_11611[(1)]);
if((state_val_11612 === (7))){
var inst_11606 = (state_11611[(2)]);
var _ = (function (){var statearr_11613 = state_11611;
(statearr_11613[(4)] = cljs.core.rest.call(null,(state_11611[(4)])));

return statearr_11613;
})();
var state_11611__$1 = state_11611;
var statearr_11614_11636 = state_11611__$1;
(statearr_11614_11636[(2)] = inst_11606);

(statearr_11614_11636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (1))){
var state_11611__$1 = state_11611;
var statearr_11615_11637 = state_11611__$1;
(statearr_11615_11637[(2)] = null);

(statearr_11615_11637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (4))){
var inst_11586 = (state_11611[(2)]);
var state_11611__$1 = state_11611;
var statearr_11616_11638 = state_11611__$1;
(statearr_11616_11638[(2)] = inst_11586);

(statearr_11616_11638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (6))){
var state_11611__$1 = state_11611;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11611__$1,(8),chan);
} else {
if((state_val_11612 === (3))){
var inst_11609 = (state_11611[(2)]);
var state_11611__$1 = state_11611;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11611__$1,inst_11609);
} else {
if((state_val_11612 === (2))){
var _ = (function (){var statearr_11617 = state_11611;
(statearr_11617[(4)] = cljs.core.cons.call(null,(5),(state_11611[(4)])));

return statearr_11617;
})();
var inst_11592 = coll;
var inst_11593 = inst_11592;
var state_11611__$1 = (function (){var statearr_11618 = state_11611;
(statearr_11618[(7)] = inst_11593);

return statearr_11618;
})();
var statearr_11619_11639 = state_11611__$1;
(statearr_11619_11639[(2)] = null);

(statearr_11619_11639[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (11))){
var inst_11604 = (state_11611[(2)]);
var state_11611__$1 = state_11611;
var statearr_11621_11640 = state_11611__$1;
(statearr_11621_11640[(2)] = inst_11604);

(statearr_11621_11640[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (9))){
var inst_11593 = (state_11611[(7)]);
var state_11611__$1 = state_11611;
var statearr_11622_11641 = state_11611__$1;
(statearr_11622_11641[(2)] = inst_11593);

(statearr_11622_11641[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (5))){
var _ = (function (){var statearr_11623 = state_11611;
(statearr_11623[(4)] = cljs.core.rest.call(null,(state_11611[(4)])));

return statearr_11623;
})();
var state_11611__$1 = state_11611;
var ex11620 = (state_11611__$1[(2)]);
var statearr_11624_11642 = state_11611__$1;
(statearr_11624_11642[(5)] = ex11620);


var statearr_11625_11643 = state_11611__$1;
(statearr_11625_11643[(1)] = (4));

(statearr_11625_11643[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (10))){
var inst_11593 = (state_11611[(7)]);
var inst_11597 = (state_11611[(8)]);
var inst_11601 = cljs.core.conj.call(null,inst_11593,inst_11597);
var inst_11593__$1 = inst_11601;
var state_11611__$1 = (function (){var statearr_11626 = state_11611;
(statearr_11626[(7)] = inst_11593__$1);

return statearr_11626;
})();
var statearr_11627_11644 = state_11611__$1;
(statearr_11627_11644[(2)] = null);

(statearr_11627_11644[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11612 === (8))){
var inst_11597 = (state_11611[(8)]);
var inst_11596 = (state_11611[(2)]);
var inst_11597__$1 = fluree.db.util.async.throw_err.call(null,inst_11596);
var inst_11598 = (inst_11597__$1 == null);
var state_11611__$1 = (function (){var statearr_11628 = state_11611;
(statearr_11628[(8)] = inst_11597__$1);

return statearr_11628;
})();
if(cljs.core.truth_(inst_11598)){
var statearr_11629_11645 = state_11611__$1;
(statearr_11629_11645[(1)] = (9));

} else {
var statearr_11630_11646 = state_11611__$1;
(statearr_11630_11646[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_11631 = [null,null,null,null,null,null,null,null,null];
(statearr_11631[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__);

(statearr_11631[(1)] = (1));

return statearr_11631;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1 = (function (state_11611){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_11611);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e11632){var ex__2730__auto__ = e11632;
var statearr_11633_11647 = state_11611;
(statearr_11633_11647[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_11611[(4)]))){
var statearr_11634_11648 = state_11611;
(statearr_11634_11648[(1)] = cljs.core.first.call(null,(state_11611[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11649 = state_11611;
state_11611 = G__11649;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__ = function(state_11611){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1.call(this,state_11611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2727__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_11635 = f__2750__auto__.call(null);
(statearr_11635[(6)] = c__2749__auto__);

return statearr_11635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
