// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.subject');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('fluree.db.index');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.common');
goog.require('fluree.db.dbproto');
/**
 * Returns chan of subjects in chunks per index-leaf
 *   that can be pulled as needed based on the selection criteria of a where clause.
 */
fluree.db.query.subject_crawl.subject.subjects_chan = (function fluree$db$query$subject_crawl$subject$subjects_chan(p__21660,error_ch,vars,p__21661){
var map__21662 = p__21660;
var map__21662__$1 = cljs.core.__destructure_map.call(null,map__21662);
var db = map__21662__$1;
var conn = cljs.core.get.call(null,map__21662__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var novelty = cljs.core.get.call(null,map__21662__$1,new cljs.core.Keyword(null,"novelty","novelty",-1590246024));
var t = cljs.core.get.call(null,map__21662__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__21663 = p__21661;
var map__21663__$1 = cljs.core.__destructure_map.call(null,map__21663);
var _where_clause = map__21663__$1;
var p = cljs.core.get.call(null,map__21663__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.call(null,map__21663__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var idx = cljs.core.get.call(null,map__21663__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var o_STAR_ = (function (){var temp__5806__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if((temp__5806__auto__ == null)){
var temp__5804__auto__ = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(temp__5804__auto__)){
var variable = temp__5804__auto__;
return cljs.core.get.call(null,vars,variable);
} else {
return null;
}
} else {
var v = temp__5806__auto__;
return v;
}
})();
var vec__21664 = (function (){var G__21667 = idx;
var G__21667__$1 = (((G__21667 instanceof cljs.core.Keyword))?G__21667.fqn:null);
switch (G__21667__$1) {
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake.call(null,null,p,o_STAR_,null,null,(-2147483647)),fluree.db.flake.__GT_Flake.call(null,null,p,o_STAR_,null,null,(2147483647))], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake.call(null,null,p,null,null,null,(-2147483647)),fluree.db.flake.__GT_Flake.call(null,null,p,null,null,null,(2147483647))], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__21667__$1)].join('')));

}
})();
var fflake = cljs.core.nth.call(null,vec__21664,(0),null);
var lflake = cljs.core.nth.call(null,vec__21664,(1),null);
var filter_fn = (cljs.core.truth_((function (){var and__4251__auto__ = o_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),idx);
} else {
return and__4251__auto__;
}
})())?(function (p1__21658_SHARP_){
return cljs.core._EQ_.call(null,o_STAR_,fluree.db.flake.o.call(null,p1__21658_SHARP_));
}):(cljs.core.truth_(new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(o))?(function (){var f = cljs.core.get_in.call(null,o,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"function","function",-2127255473)], null));
return (function (p1__21659_SHARP_){
return f.call(null,fluree.db.flake.o.call(null,p1__21659_SHARP_));
});
})():null));
var idx_root = cljs.core.get.call(null,db,idx);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(idx_root);
var range_set = fluree.db.flake.sorted_set_by.call(null,cmp,fflake,lflake);
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_.call(null,node,range_set);
});
var query_xf = fluree.db.query.subject_crawl.common.where_subj_xf.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"start-test","start-test",-952983565),cljs.core._GT__EQ_,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),fflake,new cljs.core.Keyword(null,"end-test","end-test",481973727),cljs.core._LT__EQ_,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),lflake,new cljs.core.Keyword(null,"xf","xf",401902988),(cljs.core.truth_(filter_fn)?cljs.core.map.call(null,(function (flakes){
return cljs.core.filter.call(null,filter_fn,flakes);
})):null)], null));
var resolver = fluree.db.index.__GT_CachedTRangeResolver.call(null,conn,cljs.core.get.call(null,novelty,idx),t,t,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(conn));
var tree_chan = fluree.db.index.tree_chan.call(null,resolver,idx_root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
var return_chan = cljs.core.async.chan.call(null,(10),cljs.core.comp.call(null,cljs.core.map.call(null,fluree.db.flake.s),cljs.core.dedupe.call(null)));
var c__2749__auto___21737 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21706){
var state_val_21707 = (state_21706[(1)]);
if((state_val_21707 === (7))){
var inst_21702 = (state_21706[(2)]);
var state_21706__$1 = state_21706;
var statearr_21708_21738 = state_21706__$1;
(statearr_21708_21738[(2)] = inst_21702);

(statearr_21708_21738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (1))){
var state_21706__$1 = state_21706;
var statearr_21709_21739 = state_21706__$1;
(statearr_21709_21739[(2)] = null);

(statearr_21709_21739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (4))){
var inst_21670 = (state_21706[(7)]);
var inst_21670__$1 = (state_21706[(2)]);
var inst_21671 = (inst_21670__$1 == null);
var state_21706__$1 = (function (){var statearr_21710 = state_21706;
(statearr_21710[(7)] = inst_21670__$1);

return statearr_21710;
})();
if(cljs.core.truth_(inst_21671)){
var statearr_21711_21740 = state_21706__$1;
(statearr_21711_21740[(1)] = (5));

} else {
var statearr_21712_21741 = state_21706__$1;
(statearr_21712_21741[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (15))){
var state_21706__$1 = state_21706;
var statearr_21713_21742 = state_21706__$1;
(statearr_21713_21742[(2)] = false);

(statearr_21713_21742[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (13))){
var inst_21682 = (state_21706[(2)]);
var state_21706__$1 = state_21706;
if(cljs.core.truth_(inst_21682)){
var statearr_21714_21743 = state_21706__$1;
(statearr_21714_21743[(1)] = (14));

} else {
var statearr_21715_21744 = state_21706__$1;
(statearr_21715_21744[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (6))){
var inst_21670 = (state_21706[(7)]);
var inst_21675 = cljs.core.seq.call(null,inst_21670);
var inst_21676 = inst_21675;
var inst_21677 = (0);
var state_21706__$1 = (function (){var statearr_21716 = state_21706;
(statearr_21716[(8)] = inst_21676);

(statearr_21716[(9)] = inst_21677);

return statearr_21716;
})();
var statearr_21717_21745 = state_21706__$1;
(statearr_21717_21745[(2)] = null);

(statearr_21717_21745[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (17))){
var state_21706__$1 = state_21706;
var statearr_21718_21746 = state_21706__$1;
(statearr_21718_21746[(2)] = null);

(statearr_21718_21746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (3))){
var inst_21704 = (state_21706[(2)]);
var state_21706__$1 = state_21706;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21706__$1,inst_21704);
} else {
if((state_val_21707 === (12))){
var inst_21692 = (state_21706[(2)]);
var state_21706__$1 = state_21706;
var statearr_21719_21747 = state_21706__$1;
(statearr_21719_21747[(2)] = inst_21692);

(statearr_21719_21747[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (2))){
var state_21706__$1 = state_21706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21706__$1,(4),tree_chan);
} else {
if((state_val_21707 === (19))){
var inst_21700 = (state_21706[(2)]);
var state_21706__$1 = state_21706;
var statearr_21720_21748 = state_21706__$1;
(statearr_21720_21748[(2)] = inst_21700);

(statearr_21720_21748[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (11))){
var state_21706__$1 = state_21706;
var statearr_21721_21749 = state_21706__$1;
(statearr_21721_21749[(2)] = true);

(statearr_21721_21749[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (9))){
var inst_21694 = (state_21706[(2)]);
var state_21706__$1 = state_21706;
if(cljs.core.truth_(inst_21694)){
var statearr_21722_21750 = state_21706__$1;
(statearr_21722_21750[(1)] = (17));

} else {
var statearr_21723_21751 = state_21706__$1;
(statearr_21723_21751[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (5))){
var inst_21673 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_21706__$1 = state_21706;
var statearr_21724_21752 = state_21706__$1;
(statearr_21724_21752[(2)] = inst_21673);

(statearr_21724_21752[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (14))){
var inst_21676 = (state_21706[(8)]);
var inst_21677 = (state_21706[(9)]);
var inst_21684 = cljs.core.next.call(null,inst_21676);
var inst_21685 = (inst_21677 + (1));
var inst_21676__$1 = inst_21684;
var inst_21677__$1 = inst_21685;
var state_21706__$1 = (function (){var statearr_21725 = state_21706;
(statearr_21725[(8)] = inst_21676__$1);

(statearr_21725[(9)] = inst_21677__$1);

return statearr_21725;
})();
var statearr_21726_21753 = state_21706__$1;
(statearr_21726_21753[(2)] = null);

(statearr_21726_21753[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (16))){
var inst_21689 = (state_21706[(2)]);
var state_21706__$1 = state_21706;
var statearr_21727_21754 = state_21706__$1;
(statearr_21727_21754[(2)] = inst_21689);

(statearr_21727_21754[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (10))){
var inst_21676 = (state_21706[(8)]);
var inst_21680 = cljs.core.first.call(null,inst_21676);
var state_21706__$1 = state_21706;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21706__$1,(13),return_chan,inst_21680);
} else {
if((state_val_21707 === (18))){
var inst_21698 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_21706__$1 = state_21706;
var statearr_21728_21755 = state_21706__$1;
(statearr_21728_21755[(2)] = inst_21698);

(statearr_21728_21755[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (8))){
var inst_21676 = (state_21706[(8)]);
var state_21706__$1 = state_21706;
if(cljs.core.truth_(inst_21676)){
var statearr_21729_21756 = state_21706__$1;
(statearr_21729_21756[(1)] = (10));

} else {
var statearr_21730_21757 = state_21706__$1;
(statearr_21730_21757[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0 = (function (){
var statearr_21731 = [null,null,null,null,null,null,null,null,null,null];
(statearr_21731[(0)] = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__);

(statearr_21731[(1)] = (1));

return statearr_21731;
});
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1 = (function (state_21706){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_21706);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21732){var ex__2730__auto__ = e21732;
var statearr_21733_21758 = state_21706;
(statearr_21733_21758[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_21706[(4)]))){
var statearr_21734_21759 = state_21706;
(statearr_21734_21759[(1)] = cljs.core.first.call(null,(state_21706[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21760 = state_21706;
state_21706 = G__21760;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__ = function(state_21706){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1.call(this,state_21706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21735 = f__2750__auto__.call(null);
(statearr_21735[(6)] = c__2749__auto___21737);

return statearr_21735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));


return return_chan;
});
fluree.db.query.subject_crawl.subject.flakes_xf = (function fluree$db$query$subject_crawl$subject$flakes_xf(p__21761){
var map__21762 = p__21761;
var map__21762__$1 = cljs.core.__destructure_map.call(null,map__21762);
var _opts = map__21762__$1;
var db = cljs.core.get.call(null,map__21762__$1,new cljs.core.Keyword(null,"db","db",993250759));
var fuel_vol = cljs.core.get.call(null,map__21762__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.call(null,map__21762__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var error_ch = cljs.core.get.call(null,map__21762__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var vars = cljs.core.get.call(null,map__21762__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var filter_map = cljs.core.get.call(null,map__21762__$1,new cljs.core.Keyword(null,"filter-map","filter-map",-314788257));
var permissioned_QMARK_ = cljs.core.get.call(null,map__21762__$1,new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803));
var permissions = (cljs.core.truth_(permissioned_QMARK_)?fluree.db.query.subject_crawl.common.subj_perm_filter_fn.call(null,db):null);
return (function (sid,port){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21807){
var state_val_21808 = (state_21807[(1)]);
if((state_val_21808 === (7))){
var inst_21778 = (state_21807[(7)]);
var inst_21780 = fluree.db.query.subject_crawl.common.filter_subject.call(null,vars,filter_map,inst_21778);
var state_21807__$1 = state_21807;
var statearr_21809_21845 = state_21807__$1;
(statearr_21809_21845[(2)] = inst_21780);

(statearr_21809_21845[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (1))){
var state_21807__$1 = state_21807;
var statearr_21810_21846 = state_21807__$1;
(statearr_21810_21846[(2)] = null);

(statearr_21810_21846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (4))){
var inst_21763 = (state_21807[(2)]);
var inst_21764 = cljs.core.async.put_BANG_.call(null,error_ch,inst_21763);
var inst_21765 = cljs.core.async.close_BANG_.call(null,port);
var state_21807__$1 = (function (){var statearr_21811 = state_21807;
(statearr_21811[(8)] = inst_21764);

(statearr_21811[(9)] = inst_21765);

return statearr_21811;
})();
var statearr_21812_21847 = state_21807__$1;
(statearr_21812_21847[(2)] = null);

(statearr_21812_21847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (15))){
var inst_21795 = (state_21807[(10)]);
var inst_21795__$1 = (state_21807[(2)]);
var inst_21796 = cljs.core.seq.call(null,inst_21795__$1);
var state_21807__$1 = (function (){var statearr_21813 = state_21807;
(statearr_21813[(10)] = inst_21795__$1);

return statearr_21813;
})();
if(inst_21796){
var statearr_21814_21848 = state_21807__$1;
(statearr_21814_21848[(1)] = (17));

} else {
var statearr_21815_21849 = state_21807__$1;
(statearr_21815_21849[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (13))){
var inst_21788 = (state_21807[(11)]);
var state_21807__$1 = state_21807;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21807__$1,(16),inst_21788);
} else {
if((state_val_21808 === (6))){
var inst_21777 = (state_21807[(2)]);
var inst_21778 = fluree.db.util.async.throw_err.call(null,inst_21777);
var state_21807__$1 = (function (){var statearr_21816 = state_21807;
(statearr_21816[(7)] = inst_21778);

return statearr_21816;
})();
if(cljs.core.truth_(filter_map)){
var statearr_21817_21850 = state_21807__$1;
(statearr_21817_21850[(1)] = (7));

} else {
var statearr_21818_21851 = state_21807__$1;
(statearr_21818_21851[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (17))){
var inst_21795 = (state_21807[(10)]);
var inst_21798 = cljs.core.async.put_BANG_.call(null,port,inst_21795);
var state_21807__$1 = state_21807;
var statearr_21819_21852 = state_21807__$1;
(statearr_21819_21852[(2)] = inst_21798);

(statearr_21819_21852[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (3))){
var inst_21805 = (state_21807[(2)]);
var state_21807__$1 = state_21807;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21807__$1,inst_21805);
} else {
if((state_val_21808 === (12))){
var inst_21788 = (state_21807[(2)]);
var state_21807__$1 = (function (){var statearr_21820 = state_21807;
(statearr_21820[(11)] = inst_21788);

return statearr_21820;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_21821_21853 = state_21807__$1;
(statearr_21821_21853[(1)] = (13));

} else {
var statearr_21822_21854 = state_21807__$1;
(statearr_21822_21854[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (2))){
var _ = (function (){var statearr_21823 = state_21807;
(statearr_21823[(4)] = cljs.core.cons.call(null,(5),(state_21807[(4)])));

return statearr_21823;
})();
var inst_21772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21773 = [sid];
var inst_21774 = (new cljs.core.PersistentVector(null,1,(5),inst_21772,inst_21773,null));
var inst_21775 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21774);
var state_21807__$1 = state_21807;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21807__$1,(6),inst_21775);
} else {
if((state_val_21808 === (19))){
var inst_21801 = (state_21807[(2)]);
var inst_21802 = cljs.core.async.close_BANG_.call(null,port);
var _ = (function (){var statearr_21824 = state_21807;
(statearr_21824[(4)] = cljs.core.rest.call(null,(state_21807[(4)])));

return statearr_21824;
})();
var state_21807__$1 = (function (){var statearr_21825 = state_21807;
(statearr_21825[(12)] = inst_21801);

return statearr_21825;
})();
var statearr_21826_21855 = state_21807__$1;
(statearr_21826_21855[(2)] = inst_21802);

(statearr_21826_21855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (11))){
var inst_21783 = (state_21807[(13)]);
var state_21807__$1 = state_21807;
var statearr_21828_21856 = state_21807__$1;
(statearr_21828_21856[(2)] = inst_21783);

(statearr_21828_21856[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (9))){
var inst_21783 = (state_21807[(2)]);
var state_21807__$1 = (function (){var statearr_21829 = state_21807;
(statearr_21829[(13)] = inst_21783);

return statearr_21829;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_21830_21857 = state_21807__$1;
(statearr_21830_21857[(1)] = (10));

} else {
var statearr_21831_21858 = state_21807__$1;
(statearr_21831_21858[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (5))){
var _ = (function (){var statearr_21832 = state_21807;
(statearr_21832[(4)] = cljs.core.rest.call(null,(state_21807[(4)])));

return statearr_21832;
})();
var state_21807__$1 = state_21807;
var ex21827 = (state_21807__$1[(2)]);
var statearr_21833_21859 = state_21807__$1;
(statearr_21833_21859[(5)] = ex21827);


var statearr_21834_21860 = state_21807__$1;
(statearr_21834_21860[(1)] = (4));

(statearr_21834_21860[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (14))){
var inst_21788 = (state_21807[(11)]);
var state_21807__$1 = state_21807;
var statearr_21835_21861 = state_21807__$1;
(statearr_21835_21861[(2)] = inst_21788);

(statearr_21835_21861[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (16))){
var inst_21791 = (state_21807[(2)]);
var inst_21792 = fluree.db.util.async.throw_err.call(null,inst_21791);
var state_21807__$1 = state_21807;
var statearr_21836_21862 = state_21807__$1;
(statearr_21836_21862[(2)] = inst_21792);

(statearr_21836_21862[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (10))){
var inst_21783 = (state_21807[(13)]);
var inst_21785 = permissions.call(null,inst_21783);
var state_21807__$1 = state_21807;
var statearr_21837_21863 = state_21807__$1;
(statearr_21837_21863[(2)] = inst_21785);

(statearr_21837_21863[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (18))){
var state_21807__$1 = state_21807;
var statearr_21838_21864 = state_21807__$1;
(statearr_21838_21864[(2)] = null);

(statearr_21838_21864[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21808 === (8))){
var inst_21778 = (state_21807[(7)]);
var state_21807__$1 = state_21807;
var statearr_21839_21865 = state_21807__$1;
(statearr_21839_21865[(2)] = inst_21778);

(statearr_21839_21865[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0 = (function (){
var statearr_21840 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21840[(0)] = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__);

(statearr_21840[(1)] = (1));

return statearr_21840;
});
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1 = (function (state_21807){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_21807);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21841){var ex__2730__auto__ = e21841;
var statearr_21842_21866 = state_21807;
(statearr_21842_21866[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_21807[(4)]))){
var statearr_21843_21867 = state_21807;
(statearr_21843_21867[(1)] = cljs.core.first.call(null,(state_21807[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21868 = state_21807;
state_21807 = G__21868;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__ = function(state_21807){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1.call(this,state_21807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21844 = f__2750__auto__.call(null);
(statearr_21844[(6)] = c__2749__auto__);

return statearr_21844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
});
/**
 * For queries that specify _id as the predicate, we will have a
 *   single subject as a value.
 */
fluree.db.query.subject_crawl.subject.subjects_id_chan = (function fluree$db$query$subject_crawl$subject$subjects_id_chan(db,error_ch,vars,p__21869){
var map__21870 = p__21869;
var map__21870__$1 = cljs.core.__destructure_map.call(null,map__21870);
var f_where = map__21870__$1;
var o = cljs.core.get.call(null,map__21870__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var return_ch = cljs.core.async.chan.call(null);
var _id_val = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.call(null,vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
}
})();
if(cljs.core.truth_(_id_val)){
} else {
throw cljs.core.ex_info.call(null,["When using _id as the predicate, a value must be provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f_where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var c__2749__auto___21907 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21890){
var state_val_21891 = (state_21890[(1)]);
if((state_val_21891 === (7))){
var inst_21878 = (state_21890[(7)]);
var inst_21881 = cljs.core.async.put_BANG_.call(null,error_ch,inst_21878);
var state_21890__$1 = state_21890;
var statearr_21892_21908 = state_21890__$1;
(statearr_21892_21908[(2)] = inst_21881);

(statearr_21892_21908[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21891 === (1))){
var inst_21871 = typeof _id_val === 'number';
var state_21890__$1 = state_21890;
if(cljs.core.truth_(inst_21871)){
var statearr_21893_21909 = state_21890__$1;
(statearr_21893_21909[(1)] = (2));

} else {
var statearr_21894_21910 = state_21890__$1;
(statearr_21894_21910[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21891 === (4))){
var inst_21887 = (state_21890[(2)]);
var inst_21888 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_21890__$1 = (function (){var statearr_21895 = state_21890;
(statearr_21895[(8)] = inst_21887);

return statearr_21895;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21890__$1,inst_21888);
} else {
if((state_val_21891 === (6))){
var inst_21878 = (state_21890[(7)]);
var inst_21878__$1 = (state_21890[(2)]);
var inst_21879 = fluree.db.util.core.exception_QMARK_.call(null,inst_21878__$1);
var state_21890__$1 = (function (){var statearr_21896 = state_21890;
(statearr_21896[(7)] = inst_21878__$1);

return statearr_21896;
})();
if(inst_21879){
var statearr_21897_21911 = state_21890__$1;
(statearr_21897_21911[(1)] = (7));

} else {
var statearr_21898_21912 = state_21890__$1;
(statearr_21898_21912[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21891 === (3))){
var inst_21876 = fluree.db.dbproto._subid.call(null,db,_id_val);
var state_21890__$1 = state_21890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21890__$1,(6),inst_21876);
} else {
if((state_val_21891 === (2))){
var state_21890__$1 = state_21890;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21890__$1,(5),return_ch,_id_val);
} else {
if((state_val_21891 === (9))){
var inst_21885 = (state_21890[(2)]);
var state_21890__$1 = state_21890;
var statearr_21899_21913 = state_21890__$1;
(statearr_21899_21913[(2)] = inst_21885);

(statearr_21899_21913[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21891 === (5))){
var inst_21874 = (state_21890[(2)]);
var state_21890__$1 = state_21890;
var statearr_21900_21914 = state_21890__$1;
(statearr_21900_21914[(2)] = inst_21874);

(statearr_21900_21914[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21891 === (8))){
var inst_21878 = (state_21890[(7)]);
var inst_21883 = cljs.core.async.put_BANG_.call(null,return_ch,inst_21878);
var state_21890__$1 = state_21890;
var statearr_21901_21915 = state_21890__$1;
(statearr_21901_21915[(2)] = inst_21883);

(statearr_21901_21915[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0 = (function (){
var statearr_21902 = [null,null,null,null,null,null,null,null,null];
(statearr_21902[(0)] = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__);

(statearr_21902[(1)] = (1));

return statearr_21902;
});
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1 = (function (state_21890){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_21890);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21903){var ex__2730__auto__ = e21903;
var statearr_21904_21916 = state_21890;
(statearr_21904_21916[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_21890[(4)]))){
var statearr_21905_21917 = state_21890;
(statearr_21905_21917[(1)] = cljs.core.first.call(null,(state_21890[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21918 = state_21890;
state_21890 = G__21918;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__ = function(state_21890){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1.call(this,state_21890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21906 = f__2750__auto__.call(null);
(statearr_21906[(6)] = c__2749__auto___21907);

return statearr_21906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));


return return_ch;
});
fluree.db.query.subject_crawl.subject.subj_crawl = (function fluree$db$query$subject_crawl$subject$subj_crawl(p__21919){
var map__21920 = p__21919;
var map__21920__$1 = cljs.core.__destructure_map.call(null,map__21920);
var opts = map__21920__$1;
var db = cljs.core.get.call(null,map__21920__$1,new cljs.core.Keyword(null,"db","db",993250759));
var error_ch = cljs.core.get.call(null,map__21920__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var f_where = cljs.core.get.call(null,map__21920__$1,new cljs.core.Keyword(null,"f-where","f-where",-958007776));
var limit = cljs.core.get.call(null,map__21920__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__21920__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var parallelism = cljs.core.get.call(null,map__21920__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333));
var vars = cljs.core.get.call(null,map__21920__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var finish_fn = cljs.core.get.call(null,map__21920__$1,new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21987){
var state_val_21988 = (state_21987[(1)]);
if((state_val_21988 === (7))){
var inst_21932 = fluree.db.query.subject_crawl.subject.subjects_chan.call(null,db,error_ch,vars,f_where);
var state_21987__$1 = state_21987;
var statearr_21989_22026 = state_21987__$1;
(statearr_21989_22026[(2)] = inst_21932);

(statearr_21989_22026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (20))){
var inst_21976 = (state_21987[(2)]);
var state_21987__$1 = state_21987;
var statearr_21990_22027 = state_21987__$1;
(statearr_21990_22027[(2)] = inst_21976);

(statearr_21990_22027[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (1))){
var state_21987__$1 = state_21987;
var statearr_21991_22028 = state_21987__$1;
(statearr_21991_22028[(2)] = null);

(statearr_21991_22028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (4))){
var inst_21921 = (state_21987[(2)]);
var state_21987__$1 = state_21987;
var statearr_21992_22029 = state_21987__$1;
(statearr_21992_22029[(2)] = inst_21921);

(statearr_21992_22029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (15))){
var inst_21934 = (state_21987[(7)]);
var inst_21945 = (state_21987[(8)]);
var inst_21939 = (state_21987[(9)]);
var inst_21940 = (state_21987[(10)]);
var inst_21966 = cljs.core.async.close_BANG_.call(null,inst_21934);
var inst_21967 = cljs.core.async.close_BANG_.call(null,inst_21939);
var inst_21968 = cljs.core.async.close_BANG_.call(null,inst_21940);
var inst_21969 = finish_fn.call(null,inst_21945);
var state_21987__$1 = (function (){var statearr_21993 = state_21987;
(statearr_21993[(11)] = inst_21968);

(statearr_21993[(12)] = inst_21967);

(statearr_21993[(13)] = inst_21966);

return statearr_21993;
})();
var statearr_21994_22030 = state_21987__$1;
(statearr_21994_22030[(2)] = inst_21969);

(statearr_21994_22030[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (13))){
var inst_21955 = (state_21987[(14)]);
var inst_21964 = (inst_21955 == null);
var state_21987__$1 = state_21987;
if(cljs.core.truth_(inst_21964)){
var statearr_21995_22031 = state_21987__$1;
(statearr_21995_22031[(1)] = (15));

} else {
var statearr_21996_22032 = state_21987__$1;
(statearr_21996_22032[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (6))){
var inst_21930 = fluree.db.query.subject_crawl.subject.subjects_id_chan.call(null,db,error_ch,vars,f_where);
var state_21987__$1 = state_21987;
var statearr_21997_22033 = state_21987__$1;
(statearr_21997_22033[(2)] = inst_21930);

(statearr_21997_22033[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (17))){
var inst_21978 = (state_21987[(2)]);
var state_21987__$1 = state_21987;
var statearr_21998_22034 = state_21987__$1;
(statearr_21998_22034[(2)] = inst_21978);

(statearr_21998_22034[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (3))){
var inst_21985 = (state_21987[(2)]);
var state_21987__$1 = state_21987;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21987__$1,inst_21985);
} else {
if((state_val_21988 === (12))){
var inst_21934 = (state_21987[(7)]);
var inst_21939 = (state_21987[(9)]);
var inst_21940 = (state_21987[(10)]);
var inst_21955 = (state_21987[(14)]);
var inst_21959 = cljs.core.async.close_BANG_.call(null,inst_21934);
var inst_21960 = cljs.core.async.close_BANG_.call(null,inst_21939);
var inst_21961 = cljs.core.async.close_BANG_.call(null,inst_21940);
var inst_21962 = (function(){throw inst_21955})();
var state_21987__$1 = (function (){var statearr_21999 = state_21987;
(statearr_21999[(15)] = inst_21959);

(statearr_21999[(16)] = inst_21961);

(statearr_21999[(17)] = inst_21960);

return statearr_21999;
})();
var statearr_22000_22035 = state_21987__$1;
(statearr_22000_22035[(2)] = inst_21962);

(statearr_22000_22035[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (2))){
var _ = (function (){var statearr_22001 = state_21987;
(statearr_22001[(4)] = cljs.core.cons.call(null,(5),(state_21987[(4)])));

return statearr_22001;
})();
var inst_21927 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where);
var inst_21928 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_21927);
var state_21987__$1 = state_21987;
if(inst_21928){
var statearr_22002_22036 = state_21987__$1;
(statearr_22002_22036[(1)] = (6));

} else {
var statearr_22003_22037 = state_21987__$1;
(statearr_22003_22037[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (19))){
var state_21987__$1 = state_21987;
var statearr_22004_22038 = state_21987__$1;
(statearr_22004_22038[(2)] = null);

(statearr_22004_22038[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (11))){
var inst_21954 = (state_21987[(2)]);
var inst_21955 = cljs.core.nth.call(null,inst_21954,(0),null);
var inst_21956 = cljs.core.nth.call(null,inst_21954,(1),null);
var inst_21957 = cljs.core._EQ_.call(null,inst_21956,error_ch);
var state_21987__$1 = (function (){var statearr_22006 = state_21987;
(statearr_22006[(14)] = inst_21955);

return statearr_22006;
})();
if(inst_21957){
var statearr_22007_22039 = state_21987__$1;
(statearr_22007_22039[(1)] = (12));

} else {
var statearr_22008_22040 = state_21987__$1;
(statearr_22008_22040[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (9))){
var inst_21940 = (state_21987[(10)]);
var inst_21950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21951 = [error_ch,inst_21940];
var inst_21952 = (new cljs.core.PersistentVector(null,2,(5),inst_21950,inst_21951,null));
var state_21987__$1 = state_21987;
return cljs.core.async.ioc_alts_BANG_.call(null,state_21987__$1,(11),inst_21952);
} else {
if((state_val_21988 === (5))){
var _ = (function (){var statearr_22009 = state_21987;
(statearr_22009[(4)] = cljs.core.rest.call(null,(state_21987[(4)])));

return statearr_22009;
})();
var state_21987__$1 = state_21987;
var ex22005 = (state_21987__$1[(2)]);
var statearr_22010_22041 = state_21987__$1;
(statearr_22010_22041[(5)] = ex22005);


if((ex22005 instanceof Error)){
var statearr_22011_22042 = state_21987__$1;
(statearr_22011_22042[(1)] = (4));

(statearr_22011_22042[(5)] = null);

} else {
throw ex22005;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (14))){
var inst_21980 = (state_21987[(2)]);
var state_21987__$1 = state_21987;
var statearr_22012_22043 = state_21987__$1;
(statearr_22012_22043[(2)] = inst_21980);

(statearr_22012_22043[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (16))){
var state_21987__$1 = state_21987;
var statearr_22013_22044 = state_21987__$1;
(statearr_22013_22044[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (10))){
var inst_21982 = (state_21987[(2)]);
var _ = (function (){var statearr_22015 = state_21987;
(statearr_22015[(4)] = cljs.core.rest.call(null,(state_21987[(4)])));

return statearr_22015;
})();
var state_21987__$1 = state_21987;
var statearr_22016_22045 = state_21987__$1;
(statearr_22016_22045[(2)] = inst_21982);

(statearr_22016_22045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (18))){
var inst_21945 = (state_21987[(8)]);
var inst_21955 = (state_21987[(14)]);
var inst_21972 = cljs.core.conj.call(null,inst_21945,inst_21955);
var inst_21945__$1 = inst_21972;
var state_21987__$1 = (function (){var statearr_22017 = state_21987;
(statearr_22017[(8)] = inst_21945__$1);

return statearr_22017;
})();
var statearr_22018_22046 = state_21987__$1;
(statearr_22018_22046[(2)] = null);

(statearr_22018_22046[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21988 === (8))){
var inst_21934 = (state_21987[(7)]);
var inst_21939 = (state_21987[(9)]);
var inst_21940 = (state_21987[(10)]);
var inst_21934__$1 = (state_21987[(2)]);
var inst_21935 = fluree.db.query.subject_crawl.subject.flakes_xf.call(null,opts);
var inst_21936 = cljs.core.drop.call(null,offset);
var inst_21937 = cljs.core.take.call(null,limit);
var inst_21938 = cljs.core.comp.call(null,inst_21936,inst_21937);
var inst_21939__$1 = cljs.core.async.chan.call(null,(32),inst_21938);
var inst_21940__$1 = cljs.core.async.chan.call(null);
var inst_21941 = cljs.core.async.pipeline_async.call(null,parallelism,inst_21939__$1,inst_21935,inst_21934__$1);
var inst_21942 = fluree.db.query.subject_crawl.common.result_af.call(null,opts);
var inst_21943 = cljs.core.async.pipeline_async.call(null,parallelism,inst_21940__$1,inst_21942,inst_21939__$1);
var inst_21944 = cljs.core.PersistentVector.EMPTY;
var inst_21945 = inst_21944;
var state_21987__$1 = (function (){var statearr_22019 = state_21987;
(statearr_22019[(7)] = inst_21934__$1);

(statearr_22019[(8)] = inst_21945);

(statearr_22019[(18)] = inst_21941);

(statearr_22019[(9)] = inst_21939__$1);

(statearr_22019[(19)] = inst_21943);

(statearr_22019[(10)] = inst_21940__$1);

return statearr_22019;
})();
var statearr_22020_22047 = state_21987__$1;
(statearr_22020_22047[(2)] = null);

(statearr_22020_22047[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0 = (function (){
var statearr_22021 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22021[(0)] = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__);

(statearr_22021[(1)] = (1));

return statearr_22021;
});
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1 = (function (state_21987){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_21987);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22022){var ex__2730__auto__ = e22022;
var statearr_22023_22048 = state_21987;
(statearr_22023_22048[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_21987[(4)]))){
var statearr_22024_22049 = state_21987;
(statearr_22024_22049[(1)] = cljs.core.first.call(null,(state_21987[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22050 = state_21987;
state_21987 = G__22050;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__ = function(state_21987){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1.call(this,state_21987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22025 = f__2750__auto__.call(null);
(statearr_22025[(6)] = c__2749__auto__);

return statearr_22025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
