// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.subject');
goog.require('fluree.db.query.subject_crawl.rdf_type');
goog.require('fluree.db.query.subject_crawl.common');
/**
 * Returns a parsed selection specification.
 * 
 *   This strategy is only deployed if there is a single selection graph crawl,
 *   so this assumes this case is true in code.
 */
fluree.db.query.subject_crawl.core.retrieve_select_spec = (function fluree$db$query$subject_crawl$core$retrieve_select_spec(db,p__22370){
var map__22371 = p__22370;
var map__22371__$1 = cljs.core.__destructure_map.call(null,map__22371);
var parsed_query = map__22371__$1;
var select = cljs.core.get.call(null,map__22371__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var opts = cljs.core.get.call(null,map__22371__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var select_smt = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(select)));
return fluree.db.query.fql_parser.parse_db.call(null,db,select_smt,opts);
});
fluree.db.query.subject_crawl.core.relationship_binding = (function fluree$db$query$subject_crawl$core$relationship_binding(p__22372){
var map__22373 = p__22372;
var map__22373__$1 = cljs.core.__destructure_map.call(null,map__22373);
var opts = map__22373__$1;
var rdf_type_QMARK_ = cljs.core.get.call(null,map__22373__$1,new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441));
var vars = cljs.core.get.call(null,map__22373__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22417){
var state_val_22418 = (state_22417[(1)]);
if((state_val_22418 === (7))){
var inst_22396 = (state_22417[(7)]);
var inst_22398 = fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl.call(null,inst_22396);
var state_22417__$1 = state_22417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22417__$1,(10),inst_22398);
} else {
if((state_val_22418 === (1))){
var inst_22381 = vars;
var inst_22382 = cljs.core.seq.call(null,inst_22381);
var inst_22383 = cljs.core.first.call(null,inst_22382);
var inst_22384 = cljs.core.next.call(null,inst_22382);
var inst_22385 = cljs.core.PersistentVector.EMPTY;
var inst_22386 = inst_22381;
var inst_22387 = inst_22385;
var state_22417__$1 = (function (){var statearr_22419 = state_22417;
(statearr_22419[(8)] = inst_22384);

(statearr_22419[(9)] = inst_22387);

(statearr_22419[(10)] = inst_22383);

(statearr_22419[(11)] = inst_22386);

return statearr_22419;
})();
var statearr_22420_22438 = state_22417__$1;
(statearr_22420_22438[(2)] = null);

(statearr_22420_22438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22418 === (4))){
var inst_22393 = (state_22417[(12)]);
var inst_22396 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_22393);
var state_22417__$1 = (function (){var statearr_22421 = state_22417;
(statearr_22421[(7)] = inst_22396);

return statearr_22421;
})();
if(cljs.core.truth_(rdf_type_QMARK_)){
var statearr_22422_22439 = state_22417__$1;
(statearr_22422_22439[(1)] = (7));

} else {
var statearr_22423_22440 = state_22417__$1;
(statearr_22423_22440[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22418 === (6))){
var inst_22413 = (state_22417[(2)]);
var state_22417__$1 = state_22417;
var statearr_22424_22441 = state_22417__$1;
(statearr_22424_22441[(2)] = inst_22413);

(statearr_22424_22441[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22418 === (3))){
var inst_22415 = (state_22417[(2)]);
var state_22417__$1 = state_22417;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22417__$1,inst_22415);
} else {
if((state_val_22418 === (2))){
var inst_22393 = (state_22417[(12)]);
var inst_22386 = (state_22417[(11)]);
var inst_22392 = cljs.core.seq.call(null,inst_22386);
var inst_22393__$1 = cljs.core.first.call(null,inst_22392);
var inst_22394 = cljs.core.next.call(null,inst_22392);
var state_22417__$1 = (function (){var statearr_22425 = state_22417;
(statearr_22425[(13)] = inst_22394);

(statearr_22425[(12)] = inst_22393__$1);

return statearr_22425;
})();
if(cljs.core.truth_(inst_22393__$1)){
var statearr_22426_22442 = state_22417__$1;
(statearr_22426_22442[(1)] = (4));

} else {
var statearr_22427_22443 = state_22417__$1;
(statearr_22427_22443[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22418 === (11))){
var inst_22405 = (state_22417[(2)]);
var inst_22406 = fluree.db.util.async.throw_err.call(null,inst_22405);
var state_22417__$1 = state_22417;
var statearr_22428_22444 = state_22417__$1;
(statearr_22428_22444[(2)] = inst_22406);

(statearr_22428_22444[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22418 === (9))){
var inst_22394 = (state_22417[(13)]);
var inst_22387 = (state_22417[(9)]);
var inst_22408 = (state_22417[(2)]);
var inst_22409 = cljs.core.into.call(null,inst_22387,inst_22408);
var inst_22386 = inst_22394;
var inst_22387__$1 = inst_22409;
var state_22417__$1 = (function (){var statearr_22429 = state_22417;
(statearr_22429[(9)] = inst_22387__$1);

(statearr_22429[(11)] = inst_22386);

return statearr_22429;
})();
var statearr_22430_22445 = state_22417__$1;
(statearr_22430_22445[(2)] = null);

(statearr_22430_22445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22418 === (5))){
var inst_22387 = (state_22417[(9)]);
var state_22417__$1 = state_22417;
var statearr_22431_22446 = state_22417__$1;
(statearr_22431_22446[(2)] = inst_22387);

(statearr_22431_22446[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22418 === (10))){
var inst_22400 = (state_22417[(2)]);
var inst_22401 = fluree.db.util.async.throw_err.call(null,inst_22400);
var state_22417__$1 = state_22417;
var statearr_22432_22447 = state_22417__$1;
(statearr_22432_22447[(2)] = inst_22401);

(statearr_22432_22447[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22418 === (8))){
var inst_22396 = (state_22417[(7)]);
var inst_22403 = fluree.db.query.subject_crawl.subject.subj_crawl.call(null,inst_22396);
var state_22417__$1 = state_22417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22417__$1,(11),inst_22403);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0 = (function (){
var statearr_22433 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22433[(0)] = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__);

(statearr_22433[(1)] = (1));

return statearr_22433;
});
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1 = (function (state_22417){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_22417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22434){var ex__2730__auto__ = e22434;
var statearr_22435_22448 = state_22417;
(statearr_22435_22448[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_22417[(4)]))){
var statearr_22436_22449 = state_22417;
(statearr_22436_22449[(1)] = cljs.core.first.call(null,(state_22417[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22450 = state_22417;
state_22417 = G__22450;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__ = function(state_22417){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1.call(this,state_22417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22437 = f__2750__auto__.call(null);
(statearr_22437[(6)] = c__2749__auto__);

return statearr_22437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * After results are processed, the response may be modified if:
 *   - order-by exists, in which case we need to perform a sort
 *   - selectOne? exists, in which case we take the (first result)
 *   - pretty-print is true, in which case each result needs to get embedded in a map
 */
fluree.db.query.subject_crawl.core.build_finishing_fn = (function fluree$db$query$subject_crawl$core$build_finishing_fn(p__22452){
var map__22453 = p__22452;
var map__22453__$1 = cljs.core.__destructure_map.call(null,map__22453);
var parsed_query = map__22453__$1;
var selectOne_QMARK_ = cljs.core.get.call(null,map__22453__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var order_by = cljs.core.get.call(null,map__22453__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var pretty_print = cljs.core.get.call(null,map__22453__$1,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var fns = (function (){var G__22454 = cljs.core.PersistentVector.EMPTY;
var G__22454__$1 = (cljs.core.truth_(selectOne_QMARK_)?cljs.core.conj.call(null,G__22454,(function (result){
return cljs.core.first.call(null,result);
})):G__22454);
var G__22454__$2 = (cljs.core.truth_(pretty_print)?cljs.core.conj.call(null,G__22454__$1,(function (){var select_var = cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query))))),(1));
return (function (result){
return cljs.core.mapv.call(null,(function (p1__22451_SHARP_){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([select_var,p1__22451_SHARP_]);
}),result);
});
})()):G__22454__$1);
if(cljs.core.truth_(order_by)){
return cljs.core.conj.call(null,G__22454__$2,(function (result){
return fluree.db.query.subject_crawl.common.order_results.call(null,result,order_by);
}));
} else {
return G__22454__$2;
}
})();
if(cljs.core.empty_QMARK_.call(null,fns)){
return cljs.core.identity;
} else {
return cljs.core.apply.call(null,cljs.core.comp,fns);
}
});
/**
 * Executes a simple subject crawl analytical query execution strategy.
 * 
 *   Strategy involves:
 *   (a) Get a list of subjects from first where clause
 *   (b) select all flakes for each subject
 *   (c) filter subjects based on subsequent where clause(s)
 *   (d) apply offset/limit for (c)
 *   (e) send result into :select graph crawl
 */
fluree.db.query.subject_crawl.core.simple_subject_crawl = (function fluree$db$query$subject_crawl$core$simple_subject_crawl(db,p__22455){
var map__22456 = p__22455;
var map__22456__$1 = cljs.core.__destructure_map.call(null,map__22456);
var parsed_query = map__22456__$1;
var vars = cljs.core.get.call(null,map__22456__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var where = cljs.core.get.call(null,map__22456__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__22456__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__22456__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var fuel = cljs.core.get.call(null,map__22456__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var rel_binding_QMARK_ = cljs.core.get.call(null,map__22456__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var error_ch = cljs.core.async.chan.call(null);
var f_where = cljs.core.first.call(null,where);
var rdf_type_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Keyword("rdf","type","rdf/type",1175423232),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where));
var filter_map = new cljs.core.Keyword(null,"s-filter","s-filter",-1111214020).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,where));
var cache = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentArrayMap.EMPTY);
var fuel_vol = cljs.core.volatile_BANG_.call(null,(0));
var select_spec = fluree.db.query.subject_crawl.core.retrieve_select_spec.call(null,db,parsed_query);
var finish_fn = fluree.db.query.subject_crawl.core.build_finishing_fn.call(null,parsed_query);
var opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"f-where","f-where",-958007776),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"select-spec","select-spec",55073283),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736),new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803),new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441),new cljs.core.Keyword(null,"cache","cache",-1237023054),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"filter-map","filter-map",-314788257)],[f_where,(3),select_spec,limit,offset,db,error_ch,cljs.core.not.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"root?","root?",-2045639518)], null))),rdf_type_QMARK_,cache,fuel,fuel_vol,parsed_query,finish_fn,vars,filter_map]);
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.subject_crawl.core.relationship_binding.call(null,opts);
} else {
if(rdf_type_QMARK_){
return fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl.call(null,opts);
} else {
return fluree.db.query.subject_crawl.subject.subj_crawl.call(null,opts);
}
}
});
