// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.common');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.query.fql_resp');
/**
 * Transducing function to extract matching subjects from initial where clause.
 */
fluree.db.query.subject_crawl.common.where_subj_xf = (function fluree$db$query$subject_crawl$common$where_subj_xf(p__21472){
var map__21473 = p__21472;
var map__21473__$1 = cljs.core.__destructure_map.call(null,map__21473);
var start_test = cljs.core.get.call(null,map__21473__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var start_flake = cljs.core.get.call(null,map__21473__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_test = cljs.core.get.call(null,map__21473__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
var end_flake = cljs.core.get.call(null,map__21473__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var xf = cljs.core.get.call(null,map__21473__$1,new cljs.core.Keyword(null,"xf","xf",401902988));
return cljs.core.apply.call(null,cljs.core.comp,(function (){var G__21474 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.call(null,(function (flakes){
return fluree.db.flake.subrange.call(null,flakes,start_test,start_flake,end_test,end_flake);
}))], null);
if(cljs.core.truth_(xf)){
return cljs.core.conj.call(null,G__21474,xf);
} else {
return G__21474;
}
})());
});
fluree.db.query.subject_crawl.common.result_af = (function fluree$db$query$subject_crawl$common$result_af(p__21475){
var map__21476 = p__21475;
var map__21476__$1 = cljs.core.__destructure_map.call(null,map__21476);
var _opts = map__21476__$1;
var db = cljs.core.get.call(null,map__21476__$1,new cljs.core.Keyword(null,"db","db",993250759));
var cache = cljs.core.get.call(null,map__21476__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var fuel_vol = cljs.core.get.call(null,map__21476__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.call(null,map__21476__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var select_spec = cljs.core.get.call(null,map__21476__$1,new cljs.core.Keyword(null,"select-spec","select-spec",55073283));
var error_ch = cljs.core.get.call(null,map__21476__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
return (function (flakes,port){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21507){
var state_val_21508 = (state_21507[(1)]);
if((state_val_21508 === (7))){
var state_21507__$1 = state_21507;
var statearr_21509_21535 = state_21507__$1;
(statearr_21509_21535[(2)] = null);

(statearr_21509_21535[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21508 === (1))){
var state_21507__$1 = state_21507;
var statearr_21510_21536 = state_21507__$1;
(statearr_21510_21536[(2)] = null);

(statearr_21510_21536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21508 === (4))){
var inst_21477 = (state_21507[(2)]);
var inst_21478 = cljs.core.async.put_BANG_.call(null,error_ch,inst_21477);
var inst_21479 = cljs.core.async.close_BANG_.call(null,port);
var state_21507__$1 = (function (){var statearr_21511 = state_21507;
(statearr_21511[(7)] = inst_21479);

(statearr_21511[(8)] = inst_21478);

return statearr_21511;
})();
var statearr_21512_21537 = state_21507__$1;
(statearr_21512_21537[(2)] = null);

(statearr_21512_21537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21508 === (6))){
var inst_21489 = (state_21507[(9)]);
var inst_21488 = (state_21507[(2)]);
var inst_21489__$1 = fluree.db.util.async.throw_err.call(null,inst_21488);
var inst_21490 = (inst_21489__$1 == null);
var state_21507__$1 = (function (){var statearr_21513 = state_21507;
(statearr_21513[(9)] = inst_21489__$1);

return statearr_21513;
})();
if(cljs.core.truth_(inst_21490)){
var statearr_21514_21538 = state_21507__$1;
(statearr_21514_21538[(1)] = (7));

} else {
var statearr_21515_21539 = state_21507__$1;
(statearr_21515_21539[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21508 === (3))){
var inst_21505 = (state_21507[(2)]);
var state_21507__$1 = state_21507;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21507__$1,inst_21505);
} else {
if((state_val_21508 === (12))){
var inst_21501 = (state_21507[(2)]);
var inst_21502 = cljs.core.async.close_BANG_.call(null,port);
var _ = (function (){var statearr_21516 = state_21507;
(statearr_21516[(4)] = cljs.core.rest.call(null,(state_21507[(4)])));

return statearr_21516;
})();
var state_21507__$1 = (function (){var statearr_21517 = state_21507;
(statearr_21517[(10)] = inst_21501);

return statearr_21517;
})();
var statearr_21518_21540 = state_21507__$1;
(statearr_21518_21540[(2)] = inst_21502);

(statearr_21518_21540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21508 === (2))){
var _ = (function (){var statearr_21519 = state_21507;
(statearr_21519[(4)] = cljs.core.cons.call(null,(5),(state_21507[(4)])));

return statearr_21519;
})();
var inst_21486 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel_vol,max_fuel,select_spec,flakes);
var state_21507__$1 = state_21507;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21507__$1,(6),inst_21486);
} else {
if((state_val_21508 === (11))){
var inst_21495 = (state_21507[(11)]);
var inst_21499 = cljs.core.async.put_BANG_.call(null,port,inst_21495);
var state_21507__$1 = state_21507;
var statearr_21521_21541 = state_21507__$1;
(statearr_21521_21541[(2)] = inst_21499);

(statearr_21521_21541[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21508 === (9))){
var inst_21495 = (state_21507[(11)]);
var inst_21495__$1 = (state_21507[(2)]);
var inst_21496 = (inst_21495__$1 == null);
var state_21507__$1 = (function (){var statearr_21522 = state_21507;
(statearr_21522[(11)] = inst_21495__$1);

return statearr_21522;
})();
if(cljs.core.truth_(inst_21496)){
var statearr_21523_21542 = state_21507__$1;
(statearr_21523_21542[(1)] = (10));

} else {
var statearr_21524_21543 = state_21507__$1;
(statearr_21524_21543[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21508 === (5))){
var _ = (function (){var statearr_21525 = state_21507;
(statearr_21525[(4)] = cljs.core.rest.call(null,(state_21507[(4)])));

return statearr_21525;
})();
var state_21507__$1 = state_21507;
var ex21520 = (state_21507__$1[(2)]);
var statearr_21526_21544 = state_21507__$1;
(statearr_21526_21544[(5)] = ex21520);


var statearr_21527_21545 = state_21507__$1;
(statearr_21527_21545[(1)] = (4));

(statearr_21527_21545[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21508 === (10))){
var state_21507__$1 = state_21507;
var statearr_21528_21546 = state_21507__$1;
(statearr_21528_21546[(2)] = null);

(statearr_21528_21546[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21508 === (8))){
var inst_21489 = (state_21507[(9)]);
var inst_21493 = cljs.core.not_empty.call(null,inst_21489);
var state_21507__$1 = state_21507;
var statearr_21529_21547 = state_21507__$1;
(statearr_21529_21547[(2)] = inst_21493);

(statearr_21529_21547[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0 = (function (){
var statearr_21530 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21530[(0)] = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__);

(statearr_21530[(1)] = (1));

return statearr_21530;
});
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1 = (function (state_21507){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_21507);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21531){var ex__2730__auto__ = e21531;
var statearr_21532_21548 = state_21507;
(statearr_21532_21548[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_21507[(4)]))){
var statearr_21533_21549 = state_21507;
(statearr_21533_21549[(1)] = cljs.core.first.call(null,(state_21507[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21550 = state_21507;
state_21507 = G__21550;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__ = function(state_21507){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1.call(this,state_21507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21534 = f__2750__auto__.call(null);
(statearr_21534[(6)] = c__2749__auto__);

return statearr_21534;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
});
/**
 * Returns a specific filtering function which takes all subject flakes and
 *   returns the flakes allowed, or nil if none are allowed.
 */
fluree.db.query.subject_crawl.common.subj_perm_filter_fn = (function fluree$db$query$subject_crawl$common$subj_perm_filter_fn(p__21551){
var map__21552 = p__21551;
var map__21552__$1 = cljs.core.__destructure_map.call(null,map__21552);
var db = map__21552__$1;
var permissions = cljs.core.get.call(null,map__21552__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var pred_permissions_QMARK_ = cljs.core.contains_QMARK_.call(null,permissions,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
var coll_permissions = new cljs.core.Keyword(null,"collection","collection",-683361892).cljs$core$IFn$_invoke$arity$1(permissions);
var filter_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var default_deny_QMARK_ = ((new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(coll_permissions) === true)?false:true);
var filter_predicates_QMARK_ = (function (cid){
var temp__5806__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,filter_cache),cid);
if((temp__5806__auto__ == null)){
var coll_perm = cljs.core.get.call(null,coll_permissions,cid);
var filter_QMARK_ = ((fluree.db.util.schema.is_schema_cid_QMARK_.call(null,cid))?false:((pred_permissions_QMARK_)?true:(((coll_perm == null))?default_deny_QMARK_:((((cljs.core.contains_QMARK_.call(null,coll_perm,new cljs.core.Keyword(null,"all","all",892129742))) && (cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,coll_perm)))))?false:true
))));
cljs.core.swap_BANG_.call(null,filter_cache,cljs.core.assoc,cid,filter_QMARK_);

return cljs.core.filter;
} else {
var cached = temp__5806__auto__;
return cached;
}
});
return (function (flakes){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21583){
var state_val_21584 = (state_21583[(1)]);
if((state_val_21584 === (7))){
var inst_21559 = (state_21583[(7)]);
var inst_21569 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_21559);
var state_21583__$1 = state_21583;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21583__$1,(10),inst_21569);
} else {
if((state_val_21584 === (1))){
var state_21583__$1 = state_21583;
var statearr_21585_21608 = state_21583__$1;
(statearr_21585_21608[(2)] = null);

(statearr_21585_21608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21584 === (4))){
var inst_21553 = (state_21583[(2)]);
var state_21583__$1 = state_21583;
var statearr_21586_21609 = state_21583__$1;
(statearr_21586_21609[(2)] = inst_21553);

(statearr_21586_21609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21584 === (13))){
var inst_21576 = (state_21583[(2)]);
var state_21583__$1 = state_21583;
var statearr_21587_21610 = state_21583__$1;
(statearr_21587_21610[(2)] = inst_21576);

(statearr_21587_21610[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21584 === (6))){
var inst_21564 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,flakes);
var state_21583__$1 = state_21583;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21583__$1,(9),inst_21564);
} else {
if((state_val_21584 === (3))){
var inst_21581 = (state_21583[(2)]);
var state_21583__$1 = state_21583;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21583__$1,inst_21581);
} else {
if((state_val_21584 === (12))){
var state_21583__$1 = state_21583;
var statearr_21588_21611 = state_21583__$1;
(statearr_21588_21611[(2)] = null);

(statearr_21588_21611[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21584 === (2))){
var inst_21559 = (state_21583[(7)]);
var _ = (function (){var statearr_21589 = state_21583;
(statearr_21589[(4)] = cljs.core.cons.call(null,(5),(state_21583[(4)])));

return statearr_21589;
})();
var inst_21559__$1 = cljs.core.first.call(null,flakes);
var inst_21560 = fluree.db.flake.s.call(null,inst_21559__$1);
var inst_21561 = fluree.db.flake.sid__GT_cid.call(null,inst_21560);
var inst_21562 = filter_predicates_QMARK_.call(null,inst_21561);
var state_21583__$1 = (function (){var statearr_21590 = state_21583;
(statearr_21590[(7)] = inst_21559__$1);

return statearr_21590;
})();
if(cljs.core.truth_(inst_21562)){
var statearr_21591_21612 = state_21583__$1;
(statearr_21591_21612[(1)] = (6));

} else {
var statearr_21592_21613 = state_21583__$1;
(statearr_21592_21613[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21584 === (11))){
var state_21583__$1 = state_21583;
var statearr_21594_21614 = state_21583__$1;
(statearr_21594_21614[(2)] = flakes);

(statearr_21594_21614[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21584 === (9))){
var inst_21566 = (state_21583[(2)]);
var inst_21567 = fluree.db.util.async.throw_err.call(null,inst_21566);
var state_21583__$1 = state_21583;
var statearr_21595_21615 = state_21583__$1;
(statearr_21595_21615[(2)] = inst_21567);

(statearr_21595_21615[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21584 === (5))){
var _ = (function (){var statearr_21596 = state_21583;
(statearr_21596[(4)] = cljs.core.rest.call(null,(state_21583[(4)])));

return statearr_21596;
})();
var state_21583__$1 = state_21583;
var ex21593 = (state_21583__$1[(2)]);
var statearr_21597_21616 = state_21583__$1;
(statearr_21597_21616[(5)] = ex21593);


if((ex21593 instanceof Error)){
var statearr_21598_21617 = state_21583__$1;
(statearr_21598_21617[(1)] = (4));

(statearr_21598_21617[(5)] = null);

} else {
throw ex21593;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21584 === (10))){
var inst_21571 = (state_21583[(2)]);
var inst_21572 = fluree.db.util.async.throw_err.call(null,inst_21571);
var state_21583__$1 = state_21583;
if(cljs.core.truth_(inst_21572)){
var statearr_21599_21618 = state_21583__$1;
(statearr_21599_21618[(1)] = (11));

} else {
var statearr_21600_21619 = state_21583__$1;
(statearr_21600_21619[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21584 === (8))){
var inst_21578 = (state_21583[(2)]);
var _ = (function (){var statearr_21601 = state_21583;
(statearr_21601[(4)] = cljs.core.rest.call(null,(state_21583[(4)])));

return statearr_21601;
})();
var state_21583__$1 = state_21583;
var statearr_21602_21620 = state_21583__$1;
(statearr_21602_21620[(2)] = inst_21578);

(statearr_21602_21620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_21603 = [null,null,null,null,null,null,null,null];
(statearr_21603[(0)] = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__);

(statearr_21603[(1)] = (1));

return statearr_21603;
});
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1 = (function (state_21583){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_21583);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21604){var ex__2730__auto__ = e21604;
var statearr_21605_21621 = state_21583;
(statearr_21605_21621[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_21583[(4)]))){
var statearr_21606_21622 = state_21583;
(statearr_21606_21622[(1)] = cljs.core.first.call(null,(state_21583[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21623 = state_21583;
state_21583 = G__21623;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__ = function(state_21583){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1.call(this,state_21583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21607 = f__2750__auto__.call(null);
(statearr_21607[(6)] = c__2749__auto__);

return statearr_21607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
});
fluree.db.query.subject_crawl.common.passes_filter_QMARK_ = (function fluree$db$query$subject_crawl$common$passes_filter_QMARK_(filter_fn,vars,pred_flakes){
return cljs.core.some.call(null,(function (p1__21624_SHARP_){
return filter_fn.call(null,p1__21624_SHARP_,vars);
}),pred_flakes);
});
/**
 * For a group of predicate flakes (all same .-p value)
 *   and a list of filter-functions, returns true if at least
 *   one of the predicates passes every function, else returns false.
 */
fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_ = (function fluree$db$query$subject_crawl$common$pass_all_filters_QMARK_(filter_fns,vars,pred_flakes){
var G__21628 = filter_fns;
var vec__21629 = G__21628;
var seq__21630 = cljs.core.seq.call(null,vec__21629);
var first__21631 = cljs.core.first.call(null,seq__21630);
var seq__21630__$1 = cljs.core.next.call(null,seq__21630);
var filter_fn = first__21631;
var r_fns = seq__21630__$1;
var G__21628__$1 = G__21628;
while(true){
var vec__21632 = G__21628__$1;
var seq__21633 = cljs.core.seq.call(null,vec__21632);
var first__21634 = cljs.core.first.call(null,seq__21633);
var seq__21633__$1 = cljs.core.next.call(null,seq__21633);
var filter_fn__$1 = first__21634;
var r_fns__$1 = seq__21633__$1;
if(cljs.core.truth_(filter_fn__$1)){
if(cljs.core.truth_(fluree.db.query.subject_crawl.common.passes_filter_QMARK_.call(null,filter_fn__$1,vars,pred_flakes))){
var G__21635 = r_fns__$1;
G__21628__$1 = G__21635;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});
/**
 * Filters a set of flakes for a single subject and returns true if
 *   the subject meets the filter map.
 * 
 *   filter-map is a map where pred-ids are keys and values are a list of filtering functions
 *   where each flake of pred-id must return a truthy value if the subject is allowed.
 */
fluree.db.query.subject_crawl.common.filter_subject = (function fluree$db$query$subject_crawl$common$filter_subject(vars,filter_map,flakes){
var G__21639 = cljs.core.partition_by.call(null,fluree.db.flake.p,flakes);
var vec__21640 = G__21639;
var seq__21641 = cljs.core.seq.call(null,vec__21640);
var first__21642 = cljs.core.first.call(null,seq__21641);
var seq__21641__$1 = cljs.core.next.call(null,seq__21641);
var p_flakes = first__21642;
var r = seq__21641__$1;
var required_p = new cljs.core.Keyword(null,"required-p","required-p",-2091946078).cljs$core$IFn$_invoke$arity$1(filter_map);
var G__21639__$1 = G__21639;
var required_p__$1 = required_p;
while(true){
var vec__21646 = G__21639__$1;
var seq__21647 = cljs.core.seq.call(null,vec__21646);
var first__21648 = cljs.core.first.call(null,seq__21647);
var seq__21647__$1 = cljs.core.next.call(null,seq__21647);
var p_flakes__$1 = first__21648;
var r__$1 = seq__21647__$1;
var required_p__$2 = required_p__$1;
if(cljs.core.truth_(p_flakes__$1)){
var p = fluree.db.flake.p.call(null,cljs.core.first.call(null,p_flakes__$1));
var temp__5802__auto__ = cljs.core.get.call(null,filter_map,p);
if(cljs.core.truth_(temp__5802__auto__)){
var filter_fns = temp__5802__auto__;
if(fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_.call(null,filter_fns,vars,p_flakes__$1)){
var G__21649 = r__$1;
var G__21650 = cljs.core.disj.call(null,required_p__$2,p);
G__21639__$1 = G__21649;
required_p__$1 = G__21650;
continue;
} else {
return null;
}
} else {
var G__21651 = r__$1;
var G__21652 = cljs.core.disj.call(null,required_p__$2,p);
G__21639__$1 = G__21651;
required_p__$1 = G__21652;
continue;
}
} else {
if(cljs.core.empty_QMARK_.call(null,required_p__$2)){
return flakes;
} else {
return null;
}
}
break;
}
});
/**
 * If order-by exists in query, orders final results.
 *   order-by is defined by a map with keys (see analytical-parse for code):
 *   - :type - :variable or :predicate
 *   - :order - :asc or :desc
 *   - :predicate - if type = :predicate, contains predicate pid or name
 *   - :variable - if type = :variable, contains variable name (not supported for simple subject crawl)
 */
fluree.db.query.subject_crawl.common.order_results = (function fluree$db$query$subject_crawl$common$order_results(results,p__21653){
var map__21654 = p__21653;
var map__21654__$1 = cljs.core.__destructure_map.call(null,map__21654);
var type = cljs.core.get.call(null,map__21654__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var order = cljs.core.get.call(null,map__21654__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var predicate = cljs.core.get.call(null,map__21654__$1,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"variable","variable",-281346492),type)){
throw cljs.core.ex_info.call(null,"Ordering by a variable not supported in this type of query.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var G__21655 = cljs.core.sort_by.call(null,(function (result){
return cljs.core.get.call(null,result,predicate);
}),results);
var G__21655__$1 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"desc","desc",2093485764),order))?cljs.core.reverse.call(null,G__21655):G__21655);
return cljs.core.vec.call(null,G__21655__$1);

}
});
