// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15209){
var state_val_15210 = (state_15209[(1)]);
if((state_val_15210 === (1))){
var state_15209__$1 = state_15209;
var statearr_15211_15225 = state_15209__$1;
(statearr_15211_15225[(2)] = null);

(statearr_15211_15225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15210 === (2))){
var _ = (function (){var statearr_15212 = state_15209;
(statearr_15212[(4)] = cljs.core.cons.call(null,(5),(state_15209[(4)])));

return statearr_15212;
})();
var inst_15200 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_15209__$1 = state_15209;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15209__$1,(6),inst_15200);
} else {
if((state_val_15210 === (3))){
var inst_15207 = (state_15209[(2)]);
var state_15209__$1 = state_15209;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15209__$1,inst_15207);
} else {
if((state_val_15210 === (4))){
var inst_15194 = (state_15209[(2)]);
var state_15209__$1 = state_15209;
var statearr_15214_15226 = state_15209__$1;
(statearr_15214_15226[(2)] = inst_15194);

(statearr_15214_15226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15210 === (5))){
var _ = (function (){var statearr_15215 = state_15209;
(statearr_15215[(4)] = cljs.core.rest.call(null,(state_15209[(4)])));

return statearr_15215;
})();
var state_15209__$1 = state_15209;
var ex15213 = (state_15209__$1[(2)]);
var statearr_15216_15227 = state_15209__$1;
(statearr_15216_15227[(5)] = ex15213);


if((ex15213 instanceof Error)){
var statearr_15217_15228 = state_15209__$1;
(statearr_15217_15228[(1)] = (4));

(statearr_15217_15228[(5)] = null);

} else {
throw ex15213;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15210 === (6))){
var inst_15202 = (state_15209[(2)]);
var inst_15203 = fluree.db.util.async.throw_err.call(null,inst_15202);
var inst_15204 = cljs.core.keyword.call(null,inst_15203);
var _ = (function (){var statearr_15218 = state_15209;
(statearr_15218[(4)] = cljs.core.rest.call(null,(state_15209[(4)])));

return statearr_15218;
})();
var state_15209__$1 = state_15209;
var statearr_15219_15229 = state_15209__$1;
(statearr_15219_15229[(2)] = inst_15204);

(statearr_15219_15229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0 = (function (){
var statearr_15220 = [null,null,null,null,null,null,null];
(statearr_15220[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__);

(statearr_15220[(1)] = (1));

return statearr_15220;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1 = (function (state_15209){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_15209);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15221){var ex__2730__auto__ = e15221;
var statearr_15222_15230 = state_15209;
(statearr_15222_15230[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_15209[(4)]))){
var statearr_15223_15231 = state_15209;
(statearr_15223_15231[(1)] = cljs.core.first.call(null,(state_15209[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15232 = state_15209;
state_15209 = G__15232;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__ = function(state_15209){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1.call(this,state_15209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15224 = f__2750__auto__.call(null);
(statearr_15224[(6)] = c__2749__auto__);

return statearr_15224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15264){
var state_val_15265 = (state_15264[(1)]);
if((state_val_15265 === (7))){
var inst_15248 = (state_15264[(7)]);
var inst_15250 = cljs.core.empty_QMARK_.call(null,inst_15248);
var inst_15251 = (!(inst_15250));
var state_15264__$1 = state_15264;
var statearr_15266_15290 = state_15264__$1;
(statearr_15266_15290[(2)] = inst_15251);

(statearr_15266_15290[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (1))){
var state_15264__$1 = state_15264;
var statearr_15267_15291 = state_15264__$1;
(statearr_15267_15291[(2)] = null);

(statearr_15267_15291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (4))){
var inst_15234 = (state_15264[(2)]);
var state_15264__$1 = state_15264;
var statearr_15268_15292 = state_15264__$1;
(statearr_15268_15292[(2)] = inst_15234);

(statearr_15268_15292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (6))){
var inst_15248 = (state_15264[(7)]);
var inst_15240 = (state_15264[(8)]);
var inst_15246 = (state_15264[(2)]);
var inst_15247 = fluree.db.util.async.throw_err.call(null,inst_15246);
var inst_15248__$1 = cljs.core.map.call(null,inst_15240,inst_15247);
var state_15264__$1 = (function (){var statearr_15269 = state_15264;
(statearr_15269[(7)] = inst_15248__$1);

return statearr_15269;
})();
if(cljs.core.truth_(inst_15248__$1)){
var statearr_15270_15293 = state_15264__$1;
(statearr_15270_15293[(1)] = (7));

} else {
var statearr_15271_15294 = state_15264__$1;
(statearr_15271_15294[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (3))){
var inst_15262 = (state_15264[(2)]);
var state_15264__$1 = state_15264;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15264__$1,inst_15262);
} else {
if((state_val_15265 === (12))){
var inst_15259 = (state_15264[(2)]);
var _ = (function (){var statearr_15272 = state_15264;
(statearr_15272[(4)] = cljs.core.rest.call(null,(state_15264[(4)])));

return statearr_15272;
})();
var state_15264__$1 = state_15264;
var statearr_15273_15295 = state_15264__$1;
(statearr_15273_15295[(2)] = inst_15259);

(statearr_15273_15295[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (2))){
var _ = (function (){var statearr_15274 = state_15264;
(statearr_15274[(4)] = cljs.core.cons.call(null,(5),(state_15264[(4)])));

return statearr_15274;
})();
var inst_15240 = (function (){return (function (p1__15233_SHARP_){
return fluree.db.flake.o.call(null,p1__15233_SHARP_);
});
})();
var inst_15241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15242 = [pred_id];
var inst_15243 = (new cljs.core.PersistentVector(null,1,(5),inst_15241,inst_15242,null));
var inst_15244 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15243);
var state_15264__$1 = (function (){var statearr_15275 = state_15264;
(statearr_15275[(8)] = inst_15240);

return statearr_15275;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15264__$1,(6),inst_15244);
} else {
if((state_val_15265 === (11))){
var state_15264__$1 = state_15264;
var statearr_15277_15296 = state_15264__$1;
(statearr_15277_15296[(2)] = true);

(statearr_15277_15296[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (9))){
var inst_15254 = (state_15264[(2)]);
var state_15264__$1 = state_15264;
if(cljs.core.truth_(inst_15254)){
var statearr_15278_15297 = state_15264__$1;
(statearr_15278_15297[(1)] = (10));

} else {
var statearr_15279_15298 = state_15264__$1;
(statearr_15279_15298[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (5))){
var _ = (function (){var statearr_15280 = state_15264;
(statearr_15280[(4)] = cljs.core.rest.call(null,(state_15264[(4)])));

return statearr_15280;
})();
var state_15264__$1 = state_15264;
var ex15276 = (state_15264__$1[(2)]);
var statearr_15281_15299 = state_15264__$1;
(statearr_15281_15299[(5)] = ex15276);


if((ex15276 instanceof Error)){
var statearr_15282_15300 = state_15264__$1;
(statearr_15282_15300[(1)] = (4));

(statearr_15282_15300[(5)] = null);

} else {
throw ex15276;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (10))){
var inst_15248 = (state_15264[(7)]);
var inst_15256 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_15248);
var state_15264__$1 = state_15264;
var statearr_15283_15301 = state_15264__$1;
(statearr_15283_15301[(2)] = inst_15256);

(statearr_15283_15301[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15265 === (8))){
var inst_15248 = (state_15264[(7)]);
var state_15264__$1 = state_15264;
var statearr_15284_15302 = state_15264__$1;
(statearr_15284_15302[(2)] = inst_15248);

(statearr_15284_15302[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_15285 = [null,null,null,null,null,null,null,null,null];
(statearr_15285[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__);

(statearr_15285[(1)] = (1));

return statearr_15285;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1 = (function (state_15264){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_15264);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15286){var ex__2730__auto__ = e15286;
var statearr_15287_15303 = state_15264;
(statearr_15287_15303[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_15264[(4)]))){
var statearr_15288_15304 = state_15264;
(statearr_15288_15304[(1)] = cljs.core.first.call(null,(state_15264[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15305 = state_15264;
state_15264 = G__15305;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__ = function(state_15264){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1.call(this,state_15264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15289 = f__2750__auto__.call(null);
(statearr_15289[(6)] = c__2749__auto__);

return statearr_15289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15386){
var state_val_15387 = (state_15386[(1)]);
if((state_val_15387 === (7))){
var state_15386__$1 = state_15386;
var statearr_15388_15425 = state_15386__$1;
(statearr_15388_15425[(2)] = flakes);

(statearr_15388_15425[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (20))){
var inst_15343 = (state_15386[(7)]);
var inst_15376 = (state_15386[(2)]);
var inst_15335 = inst_15343;
var inst_15336 = inst_15376;
var state_15386__$1 = (function (){var statearr_15389 = state_15386;
(statearr_15389[(8)] = inst_15335);

(statearr_15389[(9)] = inst_15336);

return statearr_15389;
})();
var statearr_15390_15426 = state_15386__$1;
(statearr_15390_15426[(2)] = null);

(statearr_15390_15426[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (1))){
var state_15386__$1 = state_15386;
var statearr_15391_15427 = state_15386__$1;
(statearr_15391_15427[(2)] = null);

(statearr_15391_15427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (4))){
var inst_15308 = (state_15386[(2)]);
var state_15386__$1 = state_15386;
var statearr_15392_15428 = state_15386__$1;
(statearr_15392_15428[(2)] = inst_15308);

(statearr_15392_15428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (15))){
var inst_15342 = (state_15386[(10)]);
var inst_15360 = fluree.db.flake.o.call(null,inst_15342);
var state_15386__$1 = state_15386;
var statearr_15393_15429 = state_15386__$1;
(statearr_15393_15429[(2)] = inst_15360);

(statearr_15393_15429[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (13))){
var inst_15379 = (state_15386[(2)]);
var state_15386__$1 = state_15386;
var statearr_15394_15430 = state_15386__$1;
(statearr_15394_15430[(2)] = inst_15379);

(statearr_15394_15430[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (6))){
var inst_15315 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_15386__$1 = state_15386;
var statearr_15395_15431 = state_15386__$1;
(statearr_15395_15431[(2)] = inst_15315);

(statearr_15395_15431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (17))){
var inst_15357 = (state_15386[(2)]);
var inst_15358 = fluree.db.util.async.throw_err.call(null,inst_15357);
var state_15386__$1 = state_15386;
var statearr_15396_15432 = state_15386__$1;
(statearr_15396_15432[(2)] = inst_15358);

(statearr_15396_15432[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (3))){
var inst_15384 = (state_15386[(2)]);
var state_15386__$1 = state_15386;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15386__$1,inst_15384);
} else {
if((state_val_15387 === (12))){
var inst_15342 = (state_15386[(10)]);
var inst_15349 = (state_15386[(11)]);
var inst_15347 = fluree.db.flake.p.call(null,inst_15342);
var inst_15348 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15347);
var inst_15349__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_15348);
var inst_15350 = fluree.db.flake.op.call(null,inst_15342);
var inst_15351 = inst_15350 === false;
var inst_15352 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_15349__$1);
var state_15386__$1 = (function (){var statearr_15397 = state_15386;
(statearr_15397[(12)] = inst_15351);

(statearr_15397[(11)] = inst_15349__$1);

return statearr_15397;
})();
if(inst_15352){
var statearr_15398_15433 = state_15386__$1;
(statearr_15398_15433[(1)] = (14));

} else {
var statearr_15399_15434 = state_15386__$1;
(statearr_15399_15434[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (2))){
var _ = (function (){var statearr_15400 = state_15386;
(statearr_15400[(4)] = cljs.core.cons.call(null,(5),(state_15386[(4)])));

return statearr_15400;
})();
var state_15386__$1 = state_15386;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_15401_15435 = state_15386__$1;
(statearr_15401_15435[(1)] = (6));

} else {
var statearr_15402_15436 = state_15386__$1;
(statearr_15402_15436[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (19))){
var inst_15362 = (state_15386[(13)]);
var inst_15336 = (state_15386[(9)]);
var inst_15342 = (state_15386[(10)]);
var inst_15349 = (state_15386[(11)]);
var inst_15370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15371 = fluree.db.flake.s.call(null,inst_15342);
var inst_15372 = [inst_15371,inst_15349,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_15373 = (new cljs.core.PersistentVector(null,3,(5),inst_15370,inst_15372,null));
var inst_15374 = cljs.core.assoc_in.call(null,inst_15336,inst_15373,inst_15362);
var state_15386__$1 = state_15386;
var statearr_15403_15437 = state_15386__$1;
(statearr_15403_15437[(2)] = inst_15374);

(statearr_15403_15437[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (11))){
var inst_15336 = (state_15386[(9)]);
var state_15386__$1 = state_15386;
var statearr_15405_15438 = state_15386__$1;
(statearr_15405_15438[(2)] = inst_15336);

(statearr_15405_15438[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (9))){
var inst_15335 = (state_15386[(8)]);
var inst_15342 = (state_15386[(10)]);
var inst_15341 = cljs.core.seq.call(null,inst_15335);
var inst_15342__$1 = cljs.core.first.call(null,inst_15341);
var inst_15343 = cljs.core.next.call(null,inst_15341);
var inst_15344 = cljs.core.not.call(null,inst_15342__$1);
var state_15386__$1 = (function (){var statearr_15406 = state_15386;
(statearr_15406[(7)] = inst_15343);

(statearr_15406[(10)] = inst_15342__$1);

return statearr_15406;
})();
if(inst_15344){
var statearr_15407_15439 = state_15386__$1;
(statearr_15407_15439[(1)] = (11));

} else {
var statearr_15408_15440 = state_15386__$1;
(statearr_15408_15440[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (5))){
var _ = (function (){var statearr_15409 = state_15386;
(statearr_15409[(4)] = cljs.core.rest.call(null,(state_15386[(4)])));

return statearr_15409;
})();
var state_15386__$1 = state_15386;
var ex15404 = (state_15386__$1[(2)]);
var statearr_15410_15441 = state_15386__$1;
(statearr_15410_15441[(5)] = ex15404);


if((ex15404 instanceof Error)){
var statearr_15411_15442 = state_15386__$1;
(statearr_15411_15442[(1)] = (4));

(statearr_15411_15442[(5)] = null);

} else {
throw ex15404;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (14))){
var inst_15342 = (state_15386[(10)]);
var inst_15354 = fluree.db.flake.o.call(null,inst_15342);
var inst_15355 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_15354,db);
var state_15386__$1 = state_15386;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15386__$1,(17),inst_15355);
} else {
if((state_val_15387 === (16))){
var inst_15351 = (state_15386[(12)]);
var inst_15362 = (state_15386[(2)]);
var state_15386__$1 = (function (){var statearr_15412 = state_15386;
(statearr_15412[(13)] = inst_15362);

return statearr_15412;
})();
if(cljs.core.truth_(inst_15351)){
var statearr_15413_15443 = state_15386__$1;
(statearr_15413_15443[(1)] = (18));

} else {
var statearr_15414_15444 = state_15386__$1;
(statearr_15414_15444[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (10))){
var inst_15381 = (state_15386[(2)]);
var _ = (function (){var statearr_15415 = state_15386;
(statearr_15415[(4)] = cljs.core.rest.call(null,(state_15386[(4)])));

return statearr_15415;
})();
var state_15386__$1 = state_15386;
var statearr_15416_15445 = state_15386__$1;
(statearr_15416_15445[(2)] = inst_15381);

(statearr_15416_15445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (18))){
var inst_15362 = (state_15386[(13)]);
var inst_15336 = (state_15386[(9)]);
var inst_15342 = (state_15386[(10)]);
var inst_15349 = (state_15386[(11)]);
var inst_15364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15365 = fluree.db.flake.s.call(null,inst_15342);
var inst_15366 = [inst_15365,inst_15349,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_15367 = (new cljs.core.PersistentVector(null,3,(5),inst_15364,inst_15366,null));
var inst_15368 = cljs.core.assoc_in.call(null,inst_15336,inst_15367,inst_15362);
var state_15386__$1 = state_15386;
var statearr_15417_15446 = state_15386__$1;
(statearr_15417_15446[(2)] = inst_15368);

(statearr_15417_15446[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15387 === (8))){
var inst_15318 = (state_15386[(2)]);
var inst_15319 = cljs.core.PersistentHashSet.EMPTY;
var inst_15320 = cljs.core.vals.call(null,tempids);
var inst_15321 = cljs.core.into.call(null,inst_15319,inst_15320);
var inst_15322 = (function (){var pred_flakes = inst_15318;
var is_new_QMARK_ = inst_15321;
return (function (p1__15307_SHARP_,p2__15306_SHARP_){
var f = p2__15306_SHARP_;
return cljs.core.assoc_in.call(null,p1__15307_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.s.call(null,f),new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,fluree.db.flake.s.call(null,f))));
});
})();
var inst_15323 = cljs.core.PersistentHashMap.EMPTY;
var inst_15324 = cljs.core.reduce.call(null,inst_15322,inst_15323,inst_15318);
var inst_15332 = cljs.core.seq.call(null,inst_15318);
var inst_15333 = cljs.core.first.call(null,inst_15332);
var inst_15334 = cljs.core.next.call(null,inst_15332);
var inst_15335 = inst_15318;
var inst_15336 = inst_15324;
var state_15386__$1 = (function (){var statearr_15418 = state_15386;
(statearr_15418[(8)] = inst_15335);

(statearr_15418[(14)] = inst_15333);

(statearr_15418[(9)] = inst_15336);

(statearr_15418[(15)] = inst_15334);

return statearr_15418;
})();
var statearr_15419_15447 = state_15386__$1;
(statearr_15419_15447[(2)] = null);

(statearr_15419_15447[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0 = (function (){
var statearr_15420 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15420[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__);

(statearr_15420[(1)] = (1));

return statearr_15420;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1 = (function (state_15386){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_15386);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15421){var ex__2730__auto__ = e15421;
var statearr_15422_15448 = state_15386;
(statearr_15422_15448[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_15386[(4)]))){
var statearr_15423_15449 = state_15386;
(statearr_15423_15449[(1)] = cljs.core.first.call(null,(state_15386[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15450 = state_15386;
state_15386 = G__15450;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__ = function(state_15386){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1.call(this,state_15386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15424 = f__2750__auto__.call(null);
(statearr_15424[(6)] = c__2749__auto__);

return statearr_15424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__15452 = arguments.length;
switch (G__15452) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__15455 = arguments.length;
switch (G__15455) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15767){
var state_val_15768 = (state_15767[(1)]);
if((state_val_15768 === (121))){
var inst_15722 = (state_15767[(7)]);
var state_15767__$1 = state_15767;
var statearr_15769_15962 = state_15767__$1;
(statearr_15769_15962[(2)] = inst_15722);

(statearr_15769_15962[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (65))){
var inst_15621 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15621)){
var statearr_15770_15963 = state_15767__$1;
(statearr_15770_15963[(1)] = (66));

} else {
var statearr_15771_15964 = state_15767__$1;
(statearr_15771_15964[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (70))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15631 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_15632 = inst_15627.call(null,cljs.core.PersistentArrayMap,null,3,inst_15631,null);
var inst_15633 = inst_15627.call(null,cljs.core.PersistentHashSet,null,inst_15632,null);
var inst_15634 = inst_15633.call(null,inst_15626);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15634)){
var statearr_15772_15965 = state_15767__$1;
(statearr_15772_15965[(1)] = (72));

} else {
var statearr_15773_15966 = state_15767__$1;
(statearr_15773_15966[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (62))){
var inst_15611 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15774_15967 = state_15767__$1;
(statearr_15774_15967[(2)] = inst_15611);

(statearr_15774_15967[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (74))){
var inst_15717 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15775_15968 = state_15767__$1;
(statearr_15775_15968[(2)] = inst_15717);

(statearr_15775_15968[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (110))){
var inst_15744 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15744)){
var statearr_15776_15969 = state_15767__$1;
(statearr_15776_15969[(1)] = (117));

} else {
var statearr_15777_15970 = state_15767__$1;
(statearr_15777_15970[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (7))){
var inst_15762 = (state_15767[(2)]);
var _ = (function (){var statearr_15778 = state_15767;
(statearr_15778[(4)] = cljs.core.rest.call(null,(state_15767[(4)])));

return statearr_15778;
})();
var state_15767__$1 = state_15767;
var statearr_15779_15971 = state_15767__$1;
(statearr_15779_15971[(2)] = inst_15762);

(statearr_15779_15971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (59))){
var inst_15615 = (state_15767[(10)]);
var inst_15495 = (state_15767[(11)]);
var inst_15614 = (state_15767[(2)]);
var inst_15615__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15495);
var state_15767__$1 = (function (){var statearr_15780 = state_15767;
(statearr_15780[(10)] = inst_15615__$1);

(statearr_15780[(12)] = inst_15614);

return statearr_15780;
})();
if(cljs.core.truth_(inst_15615__$1)){
var statearr_15781_15972 = state_15767__$1;
(statearr_15781_15972[(1)] = (63));

} else {
var statearr_15782_15973 = state_15767__$1;
(statearr_15782_15973[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (86))){
var inst_15657 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15783_15974 = state_15767__$1;
(statearr_15783_15974[(2)] = inst_15657);

(statearr_15783_15974[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (20))){
var inst_15495 = (state_15767[(11)]);
var inst_15521 = (state_15767[(13)]);
var inst_15521__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15495);
var state_15767__$1 = (function (){var statearr_15784 = state_15767;
(statearr_15784[(13)] = inst_15521__$1);

return statearr_15784;
})();
if(cljs.core.truth_(inst_15521__$1)){
var statearr_15785_15975 = state_15767__$1;
(statearr_15785_15975[(1)] = (23));

} else {
var statearr_15786_15976 = state_15767__$1;
(statearr_15786_15976[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (72))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15636 = fluree.db.query.schema.type_error.call(null,inst_15626,inst_15627,throw_QMARK_);
var state_15767__$1 = state_15767;
var statearr_15787_15977 = state_15767__$1;
(statearr_15787_15977[(2)] = inst_15636);

(statearr_15787_15977[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (58))){
var inst_15576 = (state_15767[(14)]);
var state_15767__$1 = state_15767;
var statearr_15788_15978 = state_15767__$1;
(statearr_15788_15978[(2)] = inst_15576);

(statearr_15788_15978[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (60))){
var inst_15483 = (state_15767[(15)]);
var inst_15494 = (state_15767[(16)]);
var inst_15602 = fluree.db.dbproto._p_prop.call(null,inst_15483,new cljs.core.Keyword(null,"name","name",1843675177),inst_15494);
var inst_15603 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15602)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_15604 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15605 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15606 = cljs.core.PersistentHashMap.fromArrays(inst_15604,inst_15605);
var inst_15607 = cljs.core.ex_info.call(null,inst_15603,inst_15606);
var inst_15608 = (function(){throw inst_15607})();
var state_15767__$1 = state_15767;
var statearr_15789_15979 = state_15767__$1;
(statearr_15789_15979[(2)] = inst_15608);

(statearr_15789_15979[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (27))){
var inst_15524 = (state_15767[(17)]);
var state_15767__$1 = state_15767;
var statearr_15790_15980 = state_15767__$1;
(statearr_15790_15980[(2)] = inst_15524);

(statearr_15790_15980[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (1))){
var state_15767__$1 = state_15767;
var statearr_15791_15981 = state_15767__$1;
(statearr_15791_15981[(2)] = null);

(statearr_15791_15981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (69))){
var inst_15614 = (state_15767[(12)]);
var state_15767__$1 = state_15767;
var statearr_15792_15982 = state_15767__$1;
(statearr_15792_15982[(2)] = inst_15614);

(statearr_15792_15982[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (101))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15695 = fluree.db.query.schema.type_error.call(null,inst_15626,inst_15627,throw_QMARK_);
var state_15767__$1 = state_15767;
var statearr_15793_15983 = state_15767__$1;
(statearr_15793_15983[(2)] = inst_15695);

(statearr_15793_15983[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (24))){
var inst_15521 = (state_15767[(13)]);
var state_15767__$1 = state_15767;
var statearr_15794_15984 = state_15767__$1;
(statearr_15794_15984[(2)] = inst_15521);

(statearr_15794_15984[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (102))){
var inst_15697 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15795_15985 = state_15767__$1;
(statearr_15795_15985[(2)] = inst_15697);

(statearr_15795_15985[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (55))){
var inst_15593 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15796_15986 = state_15767__$1;
(statearr_15796_15986[(2)] = inst_15593);

(statearr_15796_15986[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (85))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15655 = fluree.db.query.schema.type_error.call(null,inst_15626,inst_15627,throw_QMARK_);
var state_15767__$1 = state_15767;
var statearr_15797_15987 = state_15767__$1;
(statearr_15797_15987[(2)] = inst_15655);

(statearr_15797_15987[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (39))){
var inst_15558 = (state_15767[(18)]);
var state_15767__$1 = state_15767;
var statearr_15798_15988 = state_15767__$1;
(statearr_15798_15988[(2)] = inst_15558);

(statearr_15798_15988[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (88))){
var inst_15614 = (state_15767[(12)]);
var state_15767__$1 = state_15767;
var statearr_15799_15989 = state_15767__$1;
(statearr_15799_15989[(2)] = inst_15614);

(statearr_15799_15989[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (46))){
var inst_15577 = (state_15767[(19)]);
var inst_15495 = (state_15767[(11)]);
var inst_15576 = (state_15767[(2)]);
var inst_15577__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15495);
var state_15767__$1 = (function (){var statearr_15800 = state_15767;
(statearr_15800[(19)] = inst_15577__$1);

(statearr_15800[(14)] = inst_15576);

return statearr_15800;
})();
if(cljs.core.truth_(inst_15577__$1)){
var statearr_15801_15990 = state_15767__$1;
(statearr_15801_15990[(1)] = (47));

} else {
var statearr_15802_15991 = state_15767__$1;
(statearr_15802_15991[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (4))){
var inst_15456 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15803_15992 = state_15767__$1;
(statearr_15803_15992[(2)] = inst_15456);

(statearr_15803_15992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (77))){
var inst_15715 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15804_15993 = state_15767__$1;
(statearr_15804_15993[(2)] = inst_15715);

(statearr_15804_15993[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (106))){
var inst_15707 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15805_15994 = state_15767__$1;
(statearr_15805_15994[(2)] = inst_15707);

(statearr_15805_15994[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (119))){
var inst_15493 = (state_15767[(20)]);
var inst_15757 = (state_15767[(2)]);
var inst_15482 = inst_15493;
var inst_15483 = inst_15757;
var state_15767__$1 = (function (){var statearr_15806 = state_15767;
(statearr_15806[(15)] = inst_15483);

(statearr_15806[(21)] = inst_15482);

return statearr_15806;
})();
var statearr_15807_15995 = state_15767__$1;
(statearr_15807_15995[(2)] = null);

(statearr_15807_15995[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (95))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15679 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15680 = inst_15627.call(null,cljs.core.PersistentArrayMap,null,5,inst_15679,null);
var inst_15681 = inst_15627.call(null,cljs.core.PersistentHashSet,null,inst_15680,null);
var inst_15682 = inst_15681.call(null,inst_15626);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15682)){
var statearr_15808_15996 = state_15767__$1;
(statearr_15808_15996[(1)] = (96));

} else {
var statearr_15809_15997 = state_15767__$1;
(statearr_15809_15997[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (54))){
var inst_15584 = (state_15767[(22)]);
var state_15767__$1 = state_15767;
var statearr_15810_15998 = state_15767__$1;
(statearr_15810_15998[(2)] = inst_15584);

(statearr_15810_15998[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (92))){
var inst_15614 = (state_15767[(12)]);
var state_15767__$1 = state_15767;
var statearr_15811_15999 = state_15767__$1;
(statearr_15811_15999[(2)] = inst_15614);

(statearr_15811_15999[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (104))){
var inst_15614 = (state_15767[(12)]);
var state_15767__$1 = state_15767;
var statearr_15812_16000 = state_15767__$1;
(statearr_15812_16000[(2)] = inst_15614);

(statearr_15812_16000[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (15))){
var inst_15503 = (state_15767[(23)]);
var state_15767__$1 = state_15767;
var statearr_15813_16001 = state_15767__$1;
(statearr_15813_16001[(2)] = inst_15503);

(statearr_15813_16001[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (48))){
var inst_15577 = (state_15767[(19)]);
var state_15767__$1 = state_15767;
var statearr_15814_16002 = state_15767__$1;
(statearr_15814_16002[(2)] = inst_15577);

(statearr_15814_16002[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (50))){
var inst_15584 = (state_15767[(22)]);
var inst_15495 = (state_15767[(11)]);
var inst_15582 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15495);
var inst_15583 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15582);
var inst_15584__$1 = inst_15583 === true;
var state_15767__$1 = (function (){var statearr_15815 = state_15767;
(statearr_15815[(22)] = inst_15584__$1);

return statearr_15815;
})();
if(cljs.core.truth_(inst_15584__$1)){
var statearr_15816_16003 = state_15767__$1;
(statearr_15816_16003[(1)] = (53));

} else {
var statearr_15817_16004 = state_15767__$1;
(statearr_15817_16004[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (116))){
var inst_15738 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15818_16005 = state_15767__$1;
(statearr_15818_16005[(2)] = inst_15738);

(statearr_15818_16005[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (75))){
var inst_15627 = (state_15767[(9)]);
var state_15767__$1 = state_15767;
var G__15819_16006 = inst_15627;
var G__15819_16007__$1 = (((G__15819_16006 instanceof cljs.core.Keyword))?G__15819_16006.fqn:null);
switch (G__15819_16007__$1) {
case "long":
var statearr_15820_16009 = state_15767__$1;
(statearr_15820_16009[(1)] = (79));


break;
case "bigint":
var statearr_15821_16010 = state_15767__$1;
(statearr_15821_16010[(1)] = (83));


break;
case "double":
var statearr_15822_16011 = state_15767__$1;
(statearr_15822_16011[(1)] = (87));


break;
case "float":
var statearr_15823_16012 = state_15767__$1;
(statearr_15823_16012[(1)] = (91));


break;
case "bigdec":
var statearr_15824_16013 = state_15767__$1;
(statearr_15824_16013[(1)] = (95));


break;
case "string":
var statearr_15825_16014 = state_15767__$1;
(statearr_15825_16014[(1)] = (99));


break;
case "instant":
var statearr_15826_16015 = state_15767__$1;
(statearr_15826_16015[(1)] = (103));


break;
default:
var statearr_15827_16016 = state_15767__$1;
(statearr_15827_16016[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (99))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15689 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_15690 = inst_15627.call(null,cljs.core.PersistentArrayMap,null,5,inst_15689,null);
var inst_15691 = inst_15627.call(null,cljs.core.PersistentHashSet,null,inst_15690,null);
var inst_15692 = inst_15691.call(null,inst_15626);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15692)){
var statearr_15828_16017 = state_15767__$1;
(statearr_15828_16017[(1)] = (100));

} else {
var statearr_15829_16018 = state_15767__$1;
(statearr_15829_16018[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (21))){
var inst_15519 = (state_15767[(24)]);
var state_15767__$1 = state_15767;
var statearr_15830_16019 = state_15767__$1;
(statearr_15830_16019[(2)] = inst_15519);

(statearr_15830_16019[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (31))){
var inst_15535 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15831_16020 = state_15767__$1;
(statearr_15831_16020[(2)] = inst_15535);

(statearr_15831_16020[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (113))){
var inst_15741 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15832_16021 = state_15767__$1;
(statearr_15832_16021[(2)] = inst_15741);

(statearr_15832_16021[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (32))){
var state_15767__$1 = state_15767;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15833_16022 = state_15767__$1;
(statearr_15833_16022[(1)] = (35));

} else {
var statearr_15834_16023 = state_15767__$1;
(statearr_15834_16023[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (40))){
var inst_15571 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15571)){
var statearr_15835_16024 = state_15767__$1;
(statearr_15835_16024[(1)] = (44));

} else {
var statearr_15836_16025 = state_15767__$1;
(statearr_15836_16025[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (91))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15669 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15670 = inst_15627.call(null,cljs.core.PersistentArrayMap,null,3,inst_15669,null);
var inst_15671 = inst_15627.call(null,cljs.core.PersistentHashSet,null,inst_15670,null);
var inst_15672 = inst_15671.call(null,inst_15626);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15672)){
var statearr_15837_16026 = state_15767__$1;
(statearr_15837_16026[(1)] = (92));

} else {
var statearr_15838_16027 = state_15767__$1;
(statearr_15838_16027[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (117))){
var state_15767__$1 = state_15767;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15839_16028 = state_15767__$1;
(statearr_15839_16028[(1)] = (120));

} else {
var statearr_15840_16029 = state_15767__$1;
(statearr_15840_16029[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (108))){
var inst_15495 = (state_15767[(11)]);
var inst_15726 = (state_15767[(25)]);
var inst_15726__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15495);
var state_15767__$1 = (function (){var statearr_15841 = state_15767;
(statearr_15841[(25)] = inst_15726__$1);

return statearr_15841;
})();
if(cljs.core.truth_(inst_15726__$1)){
var statearr_15842_16030 = state_15767__$1;
(statearr_15842_16030[(1)] = (111));

} else {
var statearr_15843_16031 = state_15767__$1;
(statearr_15843_16031[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (56))){
var inst_15588 = (state_15767[(2)]);
var inst_15589 = fluree.db.util.async.throw_err.call(null,inst_15588);
var inst_15590 = cljs.core.not.call(null,inst_15589);
var state_15767__$1 = state_15767;
var statearr_15844_16032 = state_15767__$1;
(statearr_15844_16032[(2)] = inst_15590);

(statearr_15844_16032[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (33))){
var inst_15518 = (state_15767[(26)]);
var state_15767__$1 = state_15767;
var statearr_15845_16033 = state_15767__$1;
(statearr_15845_16033[(2)] = inst_15518);

(statearr_15845_16033[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (13))){
var inst_15513 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15513)){
var statearr_15846_16034 = state_15767__$1;
(statearr_15846_16034[(1)] = (17));

} else {
var statearr_15847_16035 = state_15767__$1;
(statearr_15847_16035[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (22))){
var inst_15544 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15544)){
var statearr_15848_16036 = state_15767__$1;
(statearr_15848_16036[(1)] = (32));

} else {
var statearr_15849_16037 = state_15767__$1;
(statearr_15849_16037[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (90))){
var inst_15667 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15850_16038 = state_15767__$1;
(statearr_15850_16038[(2)] = inst_15667);

(statearr_15850_16038[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (109))){
var inst_15724 = (state_15767[(27)]);
var state_15767__$1 = state_15767;
var statearr_15851_16039 = state_15767__$1;
(statearr_15851_16039[(2)] = inst_15724);

(statearr_15851_16039[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (36))){
var inst_15518 = (state_15767[(26)]);
var state_15767__$1 = state_15767;
var statearr_15852_16040 = state_15767__$1;
(statearr_15852_16040[(2)] = inst_15518);

(statearr_15852_16040[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (41))){
var inst_15495 = (state_15767[(11)]);
var inst_15563 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15495);
var inst_15564 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15563);
var inst_15565 = inst_15564 === true;
var state_15767__$1 = state_15767;
var statearr_15853_16041 = state_15767__$1;
(statearr_15853_16041[(2)] = inst_15565);

(statearr_15853_16041[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (118))){
var inst_15722 = (state_15767[(7)]);
var state_15767__$1 = state_15767;
var statearr_15854_16042 = state_15767__$1;
(statearr_15854_16042[(2)] = inst_15722);

(statearr_15854_16042[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (89))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15665 = fluree.db.query.schema.type_error.call(null,inst_15626,inst_15627,throw_QMARK_);
var state_15767__$1 = state_15767;
var statearr_15855_16043 = state_15767__$1;
(statearr_15855_16043[(2)] = inst_15665);

(statearr_15855_16043[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (100))){
var inst_15614 = (state_15767[(12)]);
var state_15767__$1 = state_15767;
var statearr_15856_16044 = state_15767__$1;
(statearr_15856_16044[(2)] = inst_15614);

(statearr_15856_16044[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (122))){
var inst_15754 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15857_16045 = state_15767__$1;
(statearr_15857_16045[(2)] = inst_15754);

(statearr_15857_16045[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (43))){
var inst_15568 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15858_16046 = state_15767__$1;
(statearr_15858_16046[(2)] = inst_15568);

(statearr_15858_16046[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (61))){
var inst_15576 = (state_15767[(14)]);
var state_15767__$1 = state_15767;
var statearr_15859_16047 = state_15767__$1;
(statearr_15859_16047[(2)] = inst_15576);

(statearr_15859_16047[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (29))){
var inst_15495 = (state_15767[(11)]);
var inst_15530 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15495);
var inst_15531 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15530);
var inst_15532 = inst_15531 === true;
var state_15767__$1 = state_15767;
var statearr_15860_16048 = state_15767__$1;
(statearr_15860_16048[(2)] = inst_15532);

(statearr_15860_16048[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (44))){
var inst_15557 = (state_15767[(28)]);
var inst_15573 = fluree.db.query.schema.type_error.call(null,inst_15557,"a component","a non-component",throw_QMARK_);
var state_15767__$1 = state_15767;
var statearr_15861_16049 = state_15767__$1;
(statearr_15861_16049[(2)] = inst_15573);

(statearr_15861_16049[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (93))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15675 = fluree.db.query.schema.type_error.call(null,inst_15626,inst_15627,throw_QMARK_);
var state_15767__$1 = state_15767;
var statearr_15862_16050 = state_15767__$1;
(statearr_15862_16050[(2)] = inst_15675);

(statearr_15862_16050[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (6))){
var inst_15494 = (state_15767[(16)]);
var inst_15482 = (state_15767[(21)]);
var inst_15491 = cljs.core.seq.call(null,inst_15482);
var inst_15492 = cljs.core.first.call(null,inst_15491);
var inst_15493 = cljs.core.next.call(null,inst_15491);
var inst_15494__$1 = cljs.core.nth.call(null,inst_15492,(0),null);
var inst_15495 = cljs.core.nth.call(null,inst_15492,(1),null);
var inst_15496 = cljs.core.not.call(null,inst_15494__$1);
var state_15767__$1 = (function (){var statearr_15863 = state_15767;
(statearr_15863[(11)] = inst_15495);

(statearr_15863[(20)] = inst_15493);

(statearr_15863[(16)] = inst_15494__$1);

return statearr_15863;
})();
if(inst_15496){
var statearr_15864_16051 = state_15767__$1;
(statearr_15864_16051[(1)] = (8));

} else {
var statearr_15865_16052 = state_15767__$1;
(statearr_15865_16052[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (111))){
var inst_15495 = (state_15767[(11)]);
var inst_15730 = (state_15767[(29)]);
var inst_15728 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15495);
var inst_15729 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15728);
var inst_15730__$1 = inst_15729 === true;
var state_15767__$1 = (function (){var statearr_15866 = state_15767;
(statearr_15866[(29)] = inst_15730__$1);

return statearr_15866;
})();
if(cljs.core.truth_(inst_15730__$1)){
var statearr_15867_16053 = state_15767__$1;
(statearr_15867_16053[(1)] = (114));

} else {
var statearr_15868_16054 = state_15767__$1;
(statearr_15868_16054[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (28))){
var inst_15538 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15869_16055 = state_15767__$1;
(statearr_15869_16055[(2)] = inst_15538);

(statearr_15869_16055[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (64))){
var inst_15615 = (state_15767[(10)]);
var state_15767__$1 = state_15767;
var statearr_15870_16056 = state_15767__$1;
(statearr_15870_16056[(2)] = inst_15615);

(statearr_15870_16056[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (103))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15699 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15700 = inst_15627.call(null,cljs.core.PersistentArrayMap,null,2,inst_15699,null);
var inst_15701 = inst_15627.call(null,cljs.core.PersistentHashSet,null,inst_15700,null);
var inst_15702 = inst_15701.call(null,inst_15626);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15702)){
var statearr_15871_16057 = state_15767__$1;
(statearr_15871_16057[(1)] = (104));

} else {
var statearr_15872_16058 = state_15767__$1;
(statearr_15872_16058[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (51))){
var inst_15580 = (state_15767[(30)]);
var state_15767__$1 = state_15767;
var statearr_15873_16059 = state_15767__$1;
(statearr_15873_16059[(2)] = inst_15580);

(statearr_15873_16059[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (25))){
var inst_15541 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15874_16060 = state_15767__$1;
(statearr_15874_16060[(2)] = inst_15541);

(statearr_15874_16060[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (34))){
var inst_15558 = (state_15767[(18)]);
var inst_15495 = (state_15767[(11)]);
var inst_15557 = (state_15767[(2)]);
var inst_15558__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15495);
var state_15767__$1 = (function (){var statearr_15875 = state_15767;
(statearr_15875[(18)] = inst_15558__$1);

(statearr_15875[(28)] = inst_15557);

return statearr_15875;
})();
if(cljs.core.truth_(inst_15558__$1)){
var statearr_15876_16061 = state_15767__$1;
(statearr_15876_16061[(1)] = (38));

} else {
var statearr_15877_16062 = state_15767__$1;
(statearr_15877_16062[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (17))){
var inst_15483 = (state_15767[(15)]);
var inst_15515 = fluree.db.query.schema.type_error.call(null,inst_15483,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_15767__$1 = state_15767;
var statearr_15878_16063 = state_15767__$1;
(statearr_15878_16063[(2)] = inst_15515);

(statearr_15878_16063[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (3))){
var inst_15765 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15767__$1,inst_15765);
} else {
if((state_val_15768 === (12))){
var inst_15499 = (state_15767[(31)]);
var state_15767__$1 = state_15767;
var statearr_15879_16064 = state_15767__$1;
(statearr_15879_16064[(2)] = inst_15499);

(statearr_15879_16064[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (2))){
var _ = (function (){var statearr_15880 = state_15767;
(statearr_15880[(4)] = cljs.core.cons.call(null,(5),(state_15767[(4)])));

return statearr_15880;
})();
var inst_15475 = pred_changes;
var inst_15476 = cljs.core.seq.call(null,inst_15475);
var inst_15477 = cljs.core.first.call(null,inst_15476);
var inst_15478 = cljs.core.next.call(null,inst_15476);
var inst_15479 = cljs.core.nth.call(null,inst_15477,(0),null);
var inst_15480 = cljs.core.nth.call(null,inst_15477,(1),null);
var inst_15481 = db;
var inst_15482 = inst_15475;
var inst_15483 = inst_15481;
var state_15767__$1 = (function (){var statearr_15881 = state_15767;
(statearr_15881[(32)] = inst_15478);

(statearr_15881[(33)] = inst_15480);

(statearr_15881[(15)] = inst_15483);

(statearr_15881[(34)] = inst_15479);

(statearr_15881[(21)] = inst_15482);

return statearr_15881;
})();
var statearr_15882_16065 = state_15767__$1;
(statearr_15882_16065[(2)] = null);

(statearr_15882_16065[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (66))){
var inst_15626 = (state_15767[(8)]);
var inst_15495 = (state_15767[(11)]);
var inst_15627 = (state_15767[(9)]);
var inst_15624 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15495);
var inst_15625 = cljs.core.__destructure_map.call(null,inst_15624);
var inst_15626__$1 = cljs.core.get.call(null,inst_15625,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_15627__$1 = cljs.core.get.call(null,inst_15625,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_15628 = cljs.core._EQ_.call(null,inst_15627__$1,inst_15626__$1);
var state_15767__$1 = (function (){var statearr_15883 = state_15767;
(statearr_15883[(8)] = inst_15626__$1);

(statearr_15883[(9)] = inst_15627__$1);

return statearr_15883;
})();
if(inst_15628){
var statearr_15884_16066 = state_15767__$1;
(statearr_15884_16066[(1)] = (69));

} else {
var statearr_15885_16067 = state_15767__$1;
(statearr_15885_16067[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (107))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15709 = fluree.db.query.schema.type_error.call(null,inst_15626,inst_15627,throw_QMARK_);
var state_15767__$1 = state_15767;
var statearr_15886_16068 = state_15767__$1;
(statearr_15886_16068[(2)] = inst_15709);

(statearr_15886_16068[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (23))){
var inst_15524 = (state_15767[(17)]);
var inst_15495 = (state_15767[(11)]);
var inst_15523 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15495);
var inst_15524__$1 = inst_15523 === true;
var state_15767__$1 = (function (){var statearr_15887 = state_15767;
(statearr_15887[(17)] = inst_15524__$1);

return statearr_15887;
})();
if(cljs.core.truth_(inst_15524__$1)){
var statearr_15888_16069 = state_15767__$1;
(statearr_15888_16069[(1)] = (26));

} else {
var statearr_15889_16070 = state_15767__$1;
(statearr_15889_16070[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (47))){
var inst_15495 = (state_15767[(11)]);
var inst_15580 = (state_15767[(30)]);
var inst_15579 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15495);
var inst_15580__$1 = cljs.core.not.call(null,inst_15579);
var state_15767__$1 = (function (){var statearr_15890 = state_15767;
(statearr_15890[(30)] = inst_15580__$1);

return statearr_15890;
})();
if(inst_15580__$1){
var statearr_15891_16071 = state_15767__$1;
(statearr_15891_16071[(1)] = (50));

} else {
var statearr_15892_16072 = state_15767__$1;
(statearr_15892_16072[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (35))){
var inst_15547 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15548 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15549 = cljs.core.PersistentHashMap.fromArrays(inst_15547,inst_15548);
var inst_15550 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_15549);
var inst_15551 = (function(){throw inst_15550})();
var state_15767__$1 = state_15767;
var statearr_15893_16073 = state_15767__$1;
(statearr_15893_16073[(2)] = inst_15551);

(statearr_15893_16073[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (82))){
var inst_15647 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15894_16074 = state_15767__$1;
(statearr_15894_16074[(2)] = inst_15647);

(statearr_15894_16074[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (76))){
var state_15767__$1 = state_15767;
var statearr_15895_16075 = state_15767__$1;
(statearr_15895_16075[(2)] = null);

(statearr_15895_16075[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (97))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15685 = fluree.db.query.schema.type_error.call(null,inst_15626,inst_15627,throw_QMARK_);
var state_15767__$1 = state_15767;
var statearr_15896_16076 = state_15767__$1;
(statearr_15896_16076[(2)] = inst_15685);

(statearr_15896_16076[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (19))){
var inst_15519 = (state_15767[(24)]);
var inst_15495 = (state_15767[(11)]);
var inst_15518 = (state_15767[(2)]);
var inst_15519__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15495);
var state_15767__$1 = (function (){var statearr_15897 = state_15767;
(statearr_15897[(24)] = inst_15519__$1);

(statearr_15897[(26)] = inst_15518);

return statearr_15897;
})();
if(cljs.core.truth_(inst_15519__$1)){
var statearr_15898_16077 = state_15767__$1;
(statearr_15898_16077[(1)] = (20));

} else {
var statearr_15899_16078 = state_15767__$1;
(statearr_15899_16078[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (57))){
var state_15767__$1 = state_15767;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15900_16079 = state_15767__$1;
(statearr_15900_16079[(1)] = (60));

} else {
var statearr_15901_16080 = state_15767__$1;
(statearr_15901_16080[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (68))){
var inst_15724 = (state_15767[(27)]);
var inst_15495 = (state_15767[(11)]);
var inst_15722 = (state_15767[(2)]);
var inst_15723 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15495);
var inst_15724__$1 = inst_15723 === true;
var state_15767__$1 = (function (){var statearr_15902 = state_15767;
(statearr_15902[(27)] = inst_15724__$1);

(statearr_15902[(7)] = inst_15722);

return statearr_15902;
})();
if(cljs.core.truth_(inst_15724__$1)){
var statearr_15903_16081 = state_15767__$1;
(statearr_15903_16081[(1)] = (108));

} else {
var statearr_15904_16082 = state_15767__$1;
(statearr_15904_16082[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (11))){
var inst_15495 = (state_15767[(11)]);
var inst_15503 = (state_15767[(23)]);
var inst_15501 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15495);
var inst_15502 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15501);
var inst_15503__$1 = inst_15502 === false;
var state_15767__$1 = (function (){var statearr_15905 = state_15767;
(statearr_15905[(23)] = inst_15503__$1);

return statearr_15905;
})();
if(cljs.core.truth_(inst_15503__$1)){
var statearr_15906_16083 = state_15767__$1;
(statearr_15906_16083[(1)] = (14));

} else {
var statearr_15907_16084 = state_15767__$1;
(statearr_15907_16084[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (115))){
var inst_15730 = (state_15767[(29)]);
var state_15767__$1 = state_15767;
var statearr_15909_16085 = state_15767__$1;
(statearr_15909_16085[(2)] = inst_15730);

(statearr_15909_16085[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (9))){
var inst_15499 = (state_15767[(31)]);
var inst_15495 = (state_15767[(11)]);
var inst_15499__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15495);
var state_15767__$1 = (function (){var statearr_15910 = state_15767;
(statearr_15910[(31)] = inst_15499__$1);

return statearr_15910;
})();
if(cljs.core.truth_(inst_15499__$1)){
var statearr_15911_16086 = state_15767__$1;
(statearr_15911_16086[(1)] = (11));

} else {
var statearr_15912_16087 = state_15767__$1;
(statearr_15912_16087[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (5))){
var _ = (function (){var statearr_15913 = state_15767;
(statearr_15913[(4)] = cljs.core.rest.call(null,(state_15767[(4)])));

return statearr_15913;
})();
var state_15767__$1 = state_15767;
var ex15908 = (state_15767__$1[(2)]);
var statearr_15914_16088 = state_15767__$1;
(statearr_15914_16088[(5)] = ex15908);


if((ex15908 instanceof Error)){
var statearr_15915_16089 = state_15767__$1;
(statearr_15915_16089[(1)] = (4));

(statearr_15915_16089[(5)] = null);

} else {
throw ex15908;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (112))){
var inst_15726 = (state_15767[(25)]);
var state_15767__$1 = state_15767;
var statearr_15916_16090 = state_15767__$1;
(statearr_15916_16090[(2)] = inst_15726);

(statearr_15916_16090[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (83))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15649 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15650 = inst_15627.call(null,cljs.core.PersistentArrayMap,null,3,inst_15649,null);
var inst_15651 = inst_15627.call(null,cljs.core.PersistentHashSet,null,inst_15650,null);
var inst_15652 = inst_15651.call(null,inst_15626);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15652)){
var statearr_15917_16091 = state_15767__$1;
(statearr_15917_16091[(1)] = (84));

} else {
var statearr_15918_16092 = state_15767__$1;
(statearr_15918_16092[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (14))){
var inst_15495 = (state_15767[(11)]);
var inst_15505 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15495);
var inst_15506 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_15505);
var inst_15507 = inst_15506 === true;
var state_15767__$1 = state_15767;
var statearr_15919_16093 = state_15767__$1;
(statearr_15919_16093[(2)] = inst_15507);

(statearr_15919_16093[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (45))){
var inst_15557 = (state_15767[(28)]);
var state_15767__$1 = state_15767;
var statearr_15920_16094 = state_15767__$1;
(statearr_15920_16094[(2)] = inst_15557);

(statearr_15920_16094[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (53))){
var inst_15483 = (state_15767[(15)]);
var inst_15494 = (state_15767[(16)]);
var inst_15586 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_15483,inst_15494);
var state_15767__$1 = state_15767;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15767__$1,(56),inst_15586);
} else {
if((state_val_15768 === (78))){
var inst_15712 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15921_16095 = state_15767__$1;
(statearr_15921_16095[(2)] = inst_15712);

(statearr_15921_16095[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (26))){
var inst_15528 = (state_15767[(35)]);
var inst_15495 = (state_15767[(11)]);
var inst_15526 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15495);
var inst_15527 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15526);
var inst_15528__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_15527);
var state_15767__$1 = (function (){var statearr_15922 = state_15767;
(statearr_15922[(35)] = inst_15528__$1);

return statearr_15922;
})();
if(inst_15528__$1){
var statearr_15923_16096 = state_15767__$1;
(statearr_15923_16096[(1)] = (29));

} else {
var statearr_15924_16097 = state_15767__$1;
(statearr_15924_16097[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (16))){
var inst_15510 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15925_16098 = state_15767__$1;
(statearr_15925_16098[(2)] = inst_15510);

(statearr_15925_16098[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (81))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15645 = fluree.db.query.schema.type_error.call(null,inst_15626,inst_15627,throw_QMARK_);
var state_15767__$1 = state_15767;
var statearr_15926_16099 = state_15767__$1;
(statearr_15926_16099[(2)] = inst_15645);

(statearr_15926_16099[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (120))){
var inst_15747 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15748 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15749 = cljs.core.PersistentHashMap.fromArrays(inst_15747,inst_15748);
var inst_15750 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_15749);
var inst_15751 = (function(){throw inst_15750})();
var state_15767__$1 = state_15767;
var statearr_15927_16100 = state_15767__$1;
(statearr_15927_16100[(2)] = inst_15751);

(statearr_15927_16100[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (79))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15639 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15640 = inst_15627.call(null,cljs.core.PersistentArrayMap,null,2,inst_15639,null);
var inst_15641 = inst_15627.call(null,cljs.core.PersistentHashSet,null,inst_15640,null);
var inst_15642 = inst_15641.call(null,inst_15626);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15642)){
var statearr_15928_16101 = state_15767__$1;
(statearr_15928_16101[(1)] = (80));

} else {
var statearr_15929_16102 = state_15767__$1;
(statearr_15929_16102[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (38))){
var inst_15495 = (state_15767[(11)]);
var inst_15561 = (state_15767[(36)]);
var inst_15560 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15495);
var inst_15561__$1 = cljs.core.not.call(null,inst_15560);
var state_15767__$1 = (function (){var statearr_15930 = state_15767;
(statearr_15930[(36)] = inst_15561__$1);

return statearr_15930;
})();
if(inst_15561__$1){
var statearr_15931_16103 = state_15767__$1;
(statearr_15931_16103[(1)] = (41));

} else {
var statearr_15932_16104 = state_15767__$1;
(statearr_15932_16104[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (98))){
var inst_15687 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15933_16105 = state_15767__$1;
(statearr_15933_16105[(2)] = inst_15687);

(statearr_15933_16105[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (87))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15659 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15660 = inst_15627.call(null,cljs.core.PersistentArrayMap,null,3,inst_15659,null);
var inst_15661 = inst_15627.call(null,cljs.core.PersistentHashSet,null,inst_15660,null);
var inst_15662 = inst_15661.call(null,inst_15626);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15662)){
var statearr_15934_16106 = state_15767__$1;
(statearr_15934_16106[(1)] = (88));

} else {
var statearr_15935_16107 = state_15767__$1;
(statearr_15935_16107[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (30))){
var inst_15528 = (state_15767[(35)]);
var state_15767__$1 = state_15767;
var statearr_15936_16108 = state_15767__$1;
(statearr_15936_16108[(2)] = inst_15528);

(statearr_15936_16108[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (73))){
var state_15767__$1 = state_15767;
var statearr_15937_16109 = state_15767__$1;
(statearr_15937_16109[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (96))){
var inst_15614 = (state_15767[(12)]);
var state_15767__$1 = state_15767;
var statearr_15939_16110 = state_15767__$1;
(statearr_15939_16110[(2)] = inst_15614);

(statearr_15939_16110[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (10))){
var inst_15760 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15940_16111 = state_15767__$1;
(statearr_15940_16111[(2)] = inst_15760);

(statearr_15940_16111[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (18))){
var inst_15483 = (state_15767[(15)]);
var state_15767__$1 = state_15767;
var statearr_15941_16112 = state_15767__$1;
(statearr_15941_16112[(2)] = inst_15483);

(statearr_15941_16112[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (105))){
var inst_15626 = (state_15767[(8)]);
var inst_15627 = (state_15767[(9)]);
var inst_15705 = fluree.db.query.schema.type_error.call(null,inst_15626,inst_15627,throw_QMARK_);
var state_15767__$1 = state_15767;
var statearr_15942_16113 = state_15767__$1;
(statearr_15942_16113[(2)] = inst_15705);

(statearr_15942_16113[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (52))){
var inst_15596 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15943_16114 = state_15767__$1;
(statearr_15943_16114[(2)] = inst_15596);

(statearr_15943_16114[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (114))){
var inst_15495 = (state_15767[(11)]);
var inst_15732 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15495);
var inst_15733 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15732);
var inst_15734 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_15733);
var inst_15735 = (!(inst_15734));
var state_15767__$1 = state_15767;
var statearr_15944_16115 = state_15767__$1;
(statearr_15944_16115[(2)] = inst_15735);

(statearr_15944_16115[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (67))){
var inst_15614 = (state_15767[(12)]);
var state_15767__$1 = state_15767;
var statearr_15945_16116 = state_15767__$1;
(statearr_15945_16116[(2)] = inst_15614);

(statearr_15945_16116[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (71))){
var inst_15719 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15946_16117 = state_15767__$1;
(statearr_15946_16117[(2)] = inst_15719);

(statearr_15946_16117[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (42))){
var inst_15561 = (state_15767[(36)]);
var state_15767__$1 = state_15767;
var statearr_15947_16118 = state_15767__$1;
(statearr_15947_16118[(2)] = inst_15561);

(statearr_15947_16118[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (80))){
var inst_15614 = (state_15767[(12)]);
var state_15767__$1 = state_15767;
var statearr_15948_16119 = state_15767__$1;
(statearr_15948_16119[(2)] = inst_15614);

(statearr_15948_16119[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (37))){
var inst_15554 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15949_16120 = state_15767__$1;
(statearr_15949_16120[(2)] = inst_15554);

(statearr_15949_16120[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (63))){
var inst_15495 = (state_15767[(11)]);
var inst_15617 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15495);
var inst_15618 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_15617);
var state_15767__$1 = state_15767;
var statearr_15950_16121 = state_15767__$1;
(statearr_15950_16121[(2)] = inst_15618);

(statearr_15950_16121[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (94))){
var inst_15677 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
var statearr_15951_16122 = state_15767__$1;
(statearr_15951_16122[(2)] = inst_15677);

(statearr_15951_16122[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (8))){
var inst_15483 = (state_15767[(15)]);
var state_15767__$1 = state_15767;
var statearr_15952_16123 = state_15767__$1;
(statearr_15952_16123[(2)] = inst_15483);

(statearr_15952_16123[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (49))){
var inst_15599 = (state_15767[(2)]);
var state_15767__$1 = state_15767;
if(cljs.core.truth_(inst_15599)){
var statearr_15953_16124 = state_15767__$1;
(statearr_15953_16124[(1)] = (57));

} else {
var statearr_15954_16125 = state_15767__$1;
(statearr_15954_16125[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15768 === (84))){
var inst_15614 = (state_15767[(12)]);
var state_15767__$1 = state_15767;
var statearr_15955_16126 = state_15767__$1;
(statearr_15955_16126[(2)] = inst_15614);

(statearr_15955_16126[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2727__auto__ = null;
var fluree$db$query$schema$state_machine__2727__auto____0 = (function (){
var statearr_15956 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15956[(0)] = fluree$db$query$schema$state_machine__2727__auto__);

(statearr_15956[(1)] = (1));

return statearr_15956;
});
var fluree$db$query$schema$state_machine__2727__auto____1 = (function (state_15767){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_15767);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15957){var ex__2730__auto__ = e15957;
var statearr_15958_16127 = state_15767;
(statearr_15958_16127[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_15767[(4)]))){
var statearr_15959_16128 = state_15767;
(statearr_15959_16128[(1)] = cljs.core.first.call(null,(state_15767[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16129 = state_15767;
state_15767 = G__16129;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2727__auto__ = function(state_15767){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2727__auto____1.call(this,state_15767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2727__auto____0;
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2727__auto____1;
return fluree$db$query$schema$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15960 = f__2750__auto__.call(null);
(statearr_15960[(6)] = c__2749__auto__);

return statearr_15960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16131 = arguments.length;
switch (G__16131) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.call(null,db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16155){
var state_val_16156 = (state_16155[(1)]);
if((state_val_16156 === (7))){
var state_16155__$1 = state_16155;
var statearr_16157_16177 = state_16155__$1;
(statearr_16157_16177[(2)] = db);

(statearr_16157_16177[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16156 === (1))){
var state_16155__$1 = state_16155;
var statearr_16158_16178 = state_16155__$1;
(statearr_16158_16178[(2)] = null);

(statearr_16158_16178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16156 === (4))){
var inst_16132 = (state_16155[(2)]);
var state_16155__$1 = state_16155;
var statearr_16159_16179 = state_16155__$1;
(statearr_16159_16179[(2)] = inst_16132);

(statearr_16159_16179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16156 === (6))){
var inst_16141 = (state_16155[(7)]);
var inst_16140 = (state_16155[(2)]);
var inst_16141__$1 = fluree.db.util.async.throw_err.call(null,inst_16140);
var inst_16142 = cljs.core.empty_QMARK_.call(null,inst_16141__$1);
var state_16155__$1 = (function (){var statearr_16160 = state_16155;
(statearr_16160[(7)] = inst_16141__$1);

return statearr_16160;
})();
if(inst_16142){
var statearr_16161_16180 = state_16155__$1;
(statearr_16161_16180[(1)] = (7));

} else {
var statearr_16162_16181 = state_16155__$1;
(statearr_16162_16181[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16156 === (3))){
var inst_16153 = (state_16155[(2)]);
var state_16155__$1 = state_16155;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16155__$1,inst_16153);
} else {
if((state_val_16156 === (2))){
var _ = (function (){var statearr_16164 = state_16155;
(statearr_16164[(4)] = cljs.core.cons.call(null,(5),(state_16155[(4)])));

return statearr_16164;
})();
var inst_16138 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes,filter_QMARK_);
var state_16155__$1 = state_16155;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16155__$1,(6),inst_16138);
} else {
if((state_val_16156 === (9))){
var inst_16150 = (state_16155[(2)]);
var _ = (function (){var statearr_16165 = state_16155;
(statearr_16165[(4)] = cljs.core.rest.call(null,(state_16155[(4)])));

return statearr_16165;
})();
var state_16155__$1 = state_16155;
var statearr_16166_16182 = state_16155__$1;
(statearr_16166_16182[(2)] = inst_16150);

(statearr_16166_16182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16156 === (5))){
var _ = (function (){var statearr_16167 = state_16155;
(statearr_16167[(4)] = cljs.core.rest.call(null,(state_16155[(4)])));

return statearr_16167;
})();
var state_16155__$1 = state_16155;
var ex16163 = (state_16155__$1[(2)]);
var statearr_16168_16183 = state_16155__$1;
(statearr_16168_16183[(5)] = ex16163);


if((ex16163 instanceof Error)){
var statearr_16169_16184 = state_16155__$1;
(statearr_16169_16184[(1)] = (4));

(statearr_16169_16184[(5)] = null);

} else {
throw ex16163;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16156 === (10))){
var inst_16147 = (state_16155[(2)]);
var inst_16148 = fluree.db.util.async.throw_err.call(null,inst_16147);
var state_16155__$1 = state_16155;
var statearr_16170_16185 = state_16155__$1;
(statearr_16170_16185[(2)] = inst_16148);

(statearr_16170_16185[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16156 === (8))){
var inst_16141 = (state_16155[(7)]);
var inst_16145 = fluree.db.query.schema.predicate_change_error.call(null,inst_16141,db,true);
var state_16155__$1 = state_16155;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16155__$1,(10),inst_16145);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2727__auto__ = null;
var fluree$db$query$schema$state_machine__2727__auto____0 = (function (){
var statearr_16171 = [null,null,null,null,null,null,null,null];
(statearr_16171[(0)] = fluree$db$query$schema$state_machine__2727__auto__);

(statearr_16171[(1)] = (1));

return statearr_16171;
});
var fluree$db$query$schema$state_machine__2727__auto____1 = (function (state_16155){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_16155);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16172){var ex__2730__auto__ = e16172;
var statearr_16173_16186 = state_16155;
(statearr_16173_16186[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_16155[(4)]))){
var statearr_16174_16187 = state_16155;
(statearr_16174_16187[(1)] = cljs.core.first.call(null,(state_16155[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16188 = state_16155;
state_16155 = G__16188;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2727__auto__ = function(state_16155){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2727__auto____1.call(this,state_16155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2727__auto____0;
fluree$db$query$schema$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2727__auto____1;
return fluree$db$query$schema$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16175 = f__2750__auto__.call(null);
(statearr_16175[(6)] = c__2749__auto__);

return statearr_16175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16190 = arguments.length;
switch (G__16190) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16192 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__16192,(0),null);
var ns = cljs.core.nth.call(null,vec__16192,(1),null);
var name = cljs.core.nth.call(null,vec__16192,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = fluree.db.flake.p.call(null,flake);
var o = fluree.db.flake.o.call(null,flake);
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__4251__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__4251__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__16195_SHARP_,p2__16196_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16195_SHARP_,p2__16196_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec.call(null,cljs.core.keep.call(null,(function (p1__16197_SHARP_){
var f = p1__16197_SHARP_;
if(cljs.core._EQ_.call(null,spec_pid,fluree.db.flake.p.call(null,f))){
return fluree.db.flake.o.call(null,f);
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16263){
var state_val_16264 = (state_16263[(1)]);
if((state_val_16264 === (1))){
var state_16263__$1 = state_16263;
var statearr_16265_16282 = state_16263__$1;
(statearr_16265_16282[(2)] = null);

(statearr_16265_16282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16264 === (2))){
var _ = (function (){var statearr_16266 = state_16263;
(statearr_16266[(4)] = cljs.core.cons.call(null,(5),(state_16263[(4)])));

return statearr_16266;
})();
var inst_16215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16216 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_16217 = [inst_16216];
var inst_16218 = (new cljs.core.PersistentVector(null,1,(5),inst_16215,inst_16217,null));
var inst_16219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16220 = [(0)];
var inst_16221 = (new cljs.core.PersistentVector(null,1,(5),inst_16219,inst_16220,null));
var inst_16222 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16218,cljs.core._LT__EQ_,inst_16221);
var state_16263__$1 = state_16263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16263__$1,(6),inst_16222);
} else {
if((state_val_16264 === (3))){
var inst_16261 = (state_16263[(2)]);
var state_16263__$1 = state_16263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16263__$1,inst_16261);
} else {
if((state_val_16264 === (4))){
var inst_16203 = (state_16263[(2)]);
var state_16263__$1 = state_16263;
var statearr_16268_16283 = state_16263__$1;
(statearr_16268_16283[(2)] = inst_16203);

(statearr_16268_16283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16264 === (5))){
var _ = (function (){var statearr_16269 = state_16263;
(statearr_16269[(4)] = cljs.core.rest.call(null,(state_16263[(4)])));

return statearr_16269;
})();
var state_16263__$1 = state_16263;
var ex16267 = (state_16263__$1[(2)]);
var statearr_16270_16284 = state_16263__$1;
(statearr_16270_16284[(5)] = ex16267);


if((ex16267 instanceof Error)){
var statearr_16271_16285 = state_16263__$1;
(statearr_16271_16285[(1)] = (4));

(statearr_16271_16285[(5)] = null);

} else {
throw ex16267;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16264 === (6))){
var inst_16224 = (state_16263[(2)]);
var inst_16225 = fluree.db.util.async.throw_err.call(null,inst_16224);
var inst_16226 = (function (){var schema_flakes = inst_16225;
return (function (p1__16198_SHARP_){
return (fluree.db.flake.s.call(null,p1__16198_SHARP_) <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_16227 = cljs.core.partition_by.call(null,inst_16226,inst_16225);
var inst_16228 = cljs.core.nth.call(null,inst_16227,(0),null);
var inst_16229 = cljs.core.nth.call(null,inst_16227,(1),null);
var inst_16230 = (function (){var schema_flakes = inst_16225;
var vec__16209 = inst_16227;
var collection_flakes = inst_16228;
var predicate_flakes = inst_16229;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first.call(null,coll_flakes);
var sid = fluree.db.flake.s.call(null,first_flake);
var p__GT_v = cljs.core.reduce.call(null,(function (p1__16201_SHARP_,p2__16200_SHARP_){
var f = p2__16200_SHARP_;
return cljs.core.assoc.call(null,p1__16201_SHARP_,fluree.db.flake.p.call(null,f),fluree.db.flake.o.call(null,f));
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4253__auto__ = cljs.core.get.call(null,p__GT_v,(47));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.sid__GT_i.call(null,sid);
}
})();
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids.call(null,(43),coll_flakes):null);
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.call(null,acc,partition,c_props,c_name,c_props);
});
})();
var inst_16231 = [(-1),"_tx"];
var inst_16232 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16233 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16234 = cljs.core.PersistentHashMap.fromArrays(inst_16232,inst_16233);
var inst_16235 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16236 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16237 = cljs.core.PersistentHashMap.fromArrays(inst_16235,inst_16236);
var inst_16238 = [inst_16234,inst_16237];
var inst_16239 = cljs.core.PersistentHashMap.fromArrays(inst_16231,inst_16238);
var inst_16240 = (function (){var schema_flakes = inst_16225;
var vec__16209 = inst_16227;
var collection_flakes = inst_16228;
var predicate_flakes = inst_16229;
return (function (p1__16199_SHARP_){
return fluree.db.flake.s.call(null,p1__16199_SHARP_);
});
})();
var inst_16241 = cljs.core.partition_by.call(null,inst_16240,inst_16228);
var inst_16242 = cljs.core.reduce.call(null,inst_16230,inst_16239,inst_16241);
var inst_16244 = (function (){var schema_flakes = inst_16225;
var vec__16209 = inst_16227;
var collection_flakes = inst_16228;
var predicate_flakes = inst_16229;
var coll = inst_16242;
return (function (p__16243,pred_flakes){
var vec__16272 = p__16243;
var pred = cljs.core.nth.call(null,vec__16272,(0),null);
var fullText = cljs.core.nth.call(null,vec__16272,(1),null);
var first_flake = cljs.core.first.call(null,pred_flakes);
var id = fluree.db.flake.s.call(null,first_flake);
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__4253__auto__ = ref_QMARK_;
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids.call(null,(24),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids.call(null,(20),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(29))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_16245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16246 = cljs.core.PersistentHashMap.EMPTY;
var inst_16247 = cljs.core.PersistentHashSet.EMPTY;
var inst_16248 = [inst_16246,inst_16247];
var inst_16249 = (new cljs.core.PersistentVector(null,2,(5),inst_16245,inst_16248,null));
var inst_16250 = (function (){var schema_flakes = inst_16225;
var vec__16209 = inst_16227;
var collection_flakes = inst_16228;
var predicate_flakes = inst_16229;
var coll = inst_16242;
return (function (p1__16202_SHARP_){
return fluree.db.flake.s.call(null,p1__16202_SHARP_);
});
})();
var inst_16251 = cljs.core.partition_by.call(null,inst_16250,inst_16229);
var inst_16252 = cljs.core.reduce.call(null,inst_16244,inst_16249,inst_16251);
var inst_16253 = cljs.core.nth.call(null,inst_16252,(0),null);
var inst_16254 = cljs.core.nth.call(null,inst_16252,(1),null);
var inst_16255 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_16256 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_16257 = [inst_16256,inst_16242,inst_16253,inst_16254];
var inst_16258 = cljs.core.PersistentHashMap.fromArrays(inst_16255,inst_16257);
var _ = (function (){var statearr_16275 = state_16263;
(statearr_16275[(4)] = cljs.core.rest.call(null,(state_16263[(4)])));

return statearr_16275;
})();
var state_16263__$1 = state_16263;
var statearr_16276_16286 = state_16263__$1;
(statearr_16276_16286[(2)] = inst_16258);

(statearr_16276_16286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0 = (function (){
var statearr_16277 = [null,null,null,null,null,null,null];
(statearr_16277[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2727__auto__);

(statearr_16277[(1)] = (1));

return statearr_16277;
});
var fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1 = (function (state_16263){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_16263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16278){var ex__2730__auto__ = e16278;
var statearr_16279_16287 = state_16263;
(statearr_16279_16287[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_16263[(4)]))){
var statearr_16280_16288 = state_16263;
(statearr_16280_16288[(1)] = cljs.core.first.call(null,(state_16263[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16289 = state_16263;
state_16263 = G__16289;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__ = function(state_16263){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1.call(this,state_16263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2727__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2727__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16281 = f__2750__auto__.call(null);
(statearr_16281[(6)] = c__2749__auto__);

return statearr_16281;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_16331){
var state_val_16332 = (state_16331[(1)]);
if((state_val_16332 === (7))){
var inst_16314 = (state_16331[(2)]);
var inst_16315 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_16314);
var inst_16316 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_16317 = cljs.core.get.call(null,inst_16315,(114));
var inst_16318 = cljs.core.boolean$.call(null,inst_16317);
var inst_16319 = cljs.core.get.call(null,inst_16315,(110));
var inst_16320 = cljs.core.get.call(null,inst_16315,(117));
var inst_16321 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_16320);
var inst_16322 = cljs.core.get.call(null,inst_16315,(111));
var inst_16323 = cljs.core.get.call(null,inst_16315,(115));
var inst_16324 = cljs.core.get.call(null,inst_16315,(112));
var inst_16325 = [inst_16318,inst_16319,inst_16321,inst_16322,inst_16323,inst_16324];
var inst_16326 = cljs.core.PersistentHashMap.fromArrays(inst_16316,inst_16325);
var _ = (function (){var statearr_16333 = state_16331;
(statearr_16333[(4)] = cljs.core.rest.call(null,(state_16331[(4)])));

return statearr_16333;
})();
var state_16331__$1 = state_16331;
var statearr_16334_16357 = state_16331__$1;
(statearr_16334_16357[(2)] = inst_16326);

(statearr_16334_16357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16332 === (1))){
var state_16331__$1 = state_16331;
var statearr_16335_16358 = state_16331__$1;
(statearr_16335_16358[(2)] = null);

(statearr_16335_16358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16332 === (4))){
var inst_16290 = (state_16331[(2)]);
var state_16331__$1 = state_16331;
var statearr_16336_16359 = state_16331__$1;
(statearr_16336_16359[(2)] = inst_16290);

(statearr_16336_16359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16332 === (6))){
var _ = (function (){var statearr_16337 = state_16331;
(statearr_16337[(4)] = cljs.core.cons.call(null,(9),(state_16331[(4)])));

return statearr_16337;
})();
var inst_16302 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16304 = ["_setting/id","root"];
var inst_16305 = (new cljs.core.PersistentVector(null,2,(5),inst_16303,inst_16304,null));
var inst_16306 = [inst_16305];
var inst_16307 = (new cljs.core.PersistentVector(null,1,(5),inst_16302,inst_16306,null));
var inst_16308 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16307);
var state_16331__$1 = state_16331;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16331__$1,(10),inst_16308);
} else {
if((state_val_16332 === (3))){
var inst_16329 = (state_16331[(2)]);
var state_16331__$1 = state_16331;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16331__$1,inst_16329);
} else {
if((state_val_16332 === (2))){
var _ = (function (){var statearr_16340 = state_16331;
(statearr_16340[(4)] = cljs.core.cons.call(null,(5),(state_16331[(4)])));

return statearr_16340;
})();
var state_16331__$1 = state_16331;
var statearr_16341_16360 = state_16331__$1;
(statearr_16341_16360[(2)] = null);

(statearr_16341_16360[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16332 === (9))){
var _ = (function (){var statearr_16342 = state_16331;
(statearr_16342[(4)] = cljs.core.rest.call(null,(state_16331[(4)])));

return statearr_16342;
})();
var state_16331__$1 = state_16331;
var ex16338 = (state_16331__$1[(2)]);
var statearr_16343_16361 = state_16331__$1;
(statearr_16343_16361[(5)] = ex16338);


var statearr_16344_16362 = state_16331__$1;
(statearr_16344_16362[(1)] = (8));

(statearr_16344_16362[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16332 === (5))){
var _ = (function (){var statearr_16345 = state_16331;
(statearr_16345[(4)] = cljs.core.rest.call(null,(state_16331[(4)])));

return statearr_16345;
})();
var state_16331__$1 = state_16331;
var ex16339 = (state_16331__$1[(2)]);
var statearr_16346_16363 = state_16331__$1;
(statearr_16346_16363[(5)] = ex16339);


if((ex16339 instanceof Error)){
var statearr_16347_16364 = state_16331__$1;
(statearr_16347_16364[(1)] = (4));

(statearr_16347_16364[(5)] = null);

} else {
throw ex16339;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16332 === (10))){
var inst_16310 = (state_16331[(2)]);
var inst_16311 = fluree.db.util.async.throw_err.call(null,inst_16310);
var _ = (function (){var statearr_16348 = state_16331;
(statearr_16348[(4)] = cljs.core.rest.call(null,(state_16331[(4)])));

return statearr_16348;
})();
var state_16331__$1 = state_16331;
var statearr_16349_16365 = state_16331__$1;
(statearr_16349_16365[(2)] = inst_16311);

(statearr_16349_16365[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16332 === (8))){
var inst_16296 = (state_16331[(2)]);
var state_16331__$1 = (function (){var statearr_16350 = state_16331;
(statearr_16350[(7)] = inst_16296);

return statearr_16350;
})();
var statearr_16351_16366 = state_16331__$1;
(statearr_16351_16366[(2)] = null);

(statearr_16351_16366[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0 = (function (){
var statearr_16352 = [null,null,null,null,null,null,null,null];
(statearr_16352[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2727__auto__);

(statearr_16352[(1)] = (1));

return statearr_16352;
});
var fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1 = (function (state_16331){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_16331);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e16353){var ex__2730__auto__ = e16353;
var statearr_16354_16367 = state_16331;
(statearr_16354_16367[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_16331[(4)]))){
var statearr_16355_16368 = state_16331;
(statearr_16355_16368[(1)] = cljs.core.first.call(null,(state_16331[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16369 = state_16331;
state_16331 = G__16369;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__ = function(state_16331){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1.call(this,state_16331);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2727__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2727__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_16356 = f__2750__auto__.call(null);
(statearr_16356[(6)] = c__2749__auto__);

return statearr_16356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
