// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
goog.require('fluree.db.query.subject_crawl.core');
goog.require('fluree.db.query.fql_resp');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__22460 = arguments.length;
switch (G__22460) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__22463 = arguments.length;
switch (G__22463) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22465 = null;
var G__22465__0 = (function (){
return xf.call(null);
});
var G__22465__1 = (function (result){
return xf.call(null,result);
});
var G__22465__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__22465 = function(result,flake){
switch(arguments.length){
case 0:
return G__22465__0.call(this);
case 1:
return G__22465__1.call(this,result);
case 2:
return G__22465__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22465.cljs$core$IFn$_invoke$arity$0 = G__22465__0;
G__22465.cljs$core$IFn$_invoke$arity$1 = G__22465__1;
G__22465.cljs$core$IFn$_invoke$arity$2 = G__22465__2;
return G__22465;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__22466_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__22466_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__22470 = vars;
var vec__22471 = G__22470;
var seq__22472 = cljs.core.seq.call(null,vec__22471);
var first__22473 = cljs.core.first.call(null,seq__22472);
var seq__22472__$1 = cljs.core.next.call(null,seq__22472);
var var$ = first__22473;
var r = seq__22472__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__22470__$1 = G__22470;
var all_vars__$1 = all_vars;
while(true){
var vec__22477 = G__22470__$1;
var seq__22478 = cljs.core.seq.call(null,vec__22477);
var first__22479 = cljs.core.first.call(null,seq__22478);
var seq__22478__$1 = cljs.core.next.call(null,seq__22478);
var var$__$1 = first__22479;
var r__$1 = seq__22478__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__22480 = r__$1;
var G__22481 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__22470__$1 = G__22480;
all_vars__$1 = G__22481;
continue;
} else {
var G__22482 = r__$1;
var G__22483 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__22470__$1 = G__22482;
all_vars__$1 = G__22483;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__22484){
var vec__22485 = p__22484;
var tuple_index = cljs.core.nth.call(null,vec__22485,(0),null);
var query_map = cljs.core.nth.call(null,vec__22485,(1),null);
var temp__5804__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22499){
var state_val_22500 = (state_22499[(1)]);
if((state_val_22500 === (1))){
var inst_22488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22489 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_22490 = [query_map,_id,query_opts];
var inst_22491 = cljs.core.PersistentHashMap.fromArrays(inst_22489,inst_22490);
var inst_22492 = fluree.db.query.fql.query.call(null,db,inst_22491);
var state_22499__$1 = (function (){var statearr_22501 = state_22499;
(statearr_22501[(7)] = inst_22488);

return statearr_22501;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22499__$1,(2),inst_22492);
} else {
if((state_val_22500 === (2))){
var inst_22488 = (state_22499[(7)]);
var inst_22494 = (state_22499[(2)]);
var inst_22495 = fluree.db.util.async.throw_err.call(null,inst_22494);
var inst_22496 = [tuple_index,inst_22495];
var inst_22497 = (new cljs.core.PersistentVector(null,2,(5),inst_22488,inst_22496,null));
var state_22499__$1 = state_22499;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22499__$1,inst_22497);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0 = (function (){
var statearr_22502 = [null,null,null,null,null,null,null,null];
(statearr_22502[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2727__auto__);

(statearr_22502[(1)] = (1));

return statearr_22502;
});
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1 = (function (state_22499){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_22499);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22503){var ex__2730__auto__ = e22503;
var statearr_22504_22507 = state_22499;
(statearr_22504_22507[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_22499[(4)]))){
var statearr_22505_22508 = state_22499;
(statearr_22505_22508[(1)] = cljs.core.first.call(null,(state_22499[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22509 = state_22499;
state_22499 = G__22509;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__ = function(state_22499){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1.call(this,state_22499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22506 = f__2750__auto__.call(null);
(statearr_22506[(6)] = c__2749__auto__);

return statearr_22506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__22510 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__22510,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__22510,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22573){
var state_val_22574 = (state_22573[(1)]);
if((state_val_22574 === (7))){
var inst_22568 = (state_22573[(2)]);
var _ = (function (){var statearr_22575 = state_22573;
(statearr_22575[(4)] = cljs.core.rest.call(null,(state_22573[(4)])));

return statearr_22575;
})();
var state_22573__$1 = state_22573;
var statearr_22576_22667 = state_22573__$1;
(statearr_22576_22667[(2)] = inst_22568);

(statearr_22576_22667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (20))){
var inst_22559 = (state_22573[(2)]);
var state_22573__$1 = state_22573;
var statearr_22577_22668 = state_22573__$1;
(statearr_22577_22668[(2)] = inst_22559);

(statearr_22577_22668[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (1))){
var state_22573__$1 = state_22573;
var statearr_22578_22669 = state_22573__$1;
(statearr_22578_22669[(2)] = null);

(statearr_22578_22669[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (4))){
var inst_22515 = (state_22573[(2)]);
var state_22573__$1 = state_22573;
var statearr_22579_22670 = state_22573__$1;
(statearr_22579_22670[(2)] = inst_22515);

(statearr_22579_22670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (15))){
var inst_22535 = (state_22573[(7)]);
var inst_22544 = cljs.core.second.call(null,inst_22535);
var inst_22545 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22544);
var inst_22546 = (inst_22545 > max_fuel);
var state_22573__$1 = state_22573;
if(cljs.core.truth_(inst_22546)){
var statearr_22580_22671 = state_22573__$1;
(statearr_22580_22671[(1)] = (18));

} else {
var statearr_22581_22672 = state_22573__$1;
(statearr_22581_22672[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (13))){
var state_22573__$1 = state_22573;
var statearr_22582_22673 = state_22573__$1;
(statearr_22582_22673[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (6))){
var inst_22523 = (state_22573[(8)]);
var state_22573__$1 = state_22573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22573__$1,(8),inst_22523);
} else {
if((state_val_22574 === (17))){
var inst_22562 = (state_22573[(2)]);
var state_22573__$1 = state_22573;
var statearr_22584_22674 = state_22573__$1;
(statearr_22584_22674[(2)] = inst_22562);

(statearr_22584_22674[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (3))){
var inst_22571 = (state_22573[(2)]);
var state_22573__$1 = state_22573;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22573__$1,inst_22571);
} else {
if((state_val_22574 === (12))){
var inst_22524 = (state_22573[(9)]);
var inst_22535 = (state_22573[(7)]);
var inst_22541 = inst_22524.call(null);
var state_22573__$1 = (function (){var statearr_22585 = state_22573;
(statearr_22585[(10)] = inst_22541);

return statearr_22585;
})();
var statearr_22586_22675 = state_22573__$1;
(statearr_22586_22675[(2)] = inst_22535);

(statearr_22586_22675[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (2))){
var inst_22523 = (state_22573[(8)]);
var inst_22524 = (state_22573[(9)]);
var _ = (function (){var statearr_22587 = state_22573;
(statearr_22587[(4)] = cljs.core.cons.call(null,(5),(state_22573[(4)])));

return statearr_22587;
})();
var inst_22521 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_22522 = cljs.core.async.chan.call(null);
var inst_22523__$1 = cljs.core.async.chan.call(null);
var inst_22524__$1 = (function (){var expandMaps = inst_22521;
var queue_ch = inst_22522;
var res_ch = inst_22523__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_22525 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_22526 = cljs.core.volatile_BANG_.call(null,(0));
var inst_22527 = cljs.core.assoc.call(null,inst_22525,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_22526);
var inst_22528 = (function (){var expandMaps = inst_22521;
var queue_ch = inst_22522;
var res_ch = inst_22523__$1;
var stop_BANG_ = inst_22524__$1;
var opts_STAR_ = inst_22527;
return (function (tuple_res,port){
var c__2749__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22620){
var state_val_22621 = (state_22620[(1)]);
if((state_val_22621 === (7))){
var state_22620__$1 = state_22620;
var statearr_22622_22676 = state_22620__$1;
(statearr_22622_22676[(2)] = tuple_res);

(statearr_22622_22676[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22621 === (1))){
var state_22620__$1 = state_22620;
var statearr_22623_22677 = state_22620__$1;
(statearr_22623_22677[(2)] = null);

(statearr_22623_22677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22621 === (4))){
var inst_22588 = (state_22620[(2)]);
var inst_22589 = cljs.core.async.put_BANG_.call(null,port,inst_22588);
var inst_22590 = cljs.core.async.close_BANG_.call(null,port);
var state_22620__$1 = (function (){var statearr_22624 = state_22620;
(statearr_22624[(7)] = inst_22589);

return statearr_22624;
})();
var statearr_22625_22678 = state_22620__$1;
(statearr_22625_22678[(2)] = inst_22590);

(statearr_22625_22678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22621 === (6))){
var inst_22597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22598 = [tuple_res];
var inst_22599 = (new cljs.core.PersistentVector(null,1,(5),inst_22597,inst_22598,null));
var state_22620__$1 = state_22620;
var statearr_22626_22679 = state_22620__$1;
(statearr_22626_22679[(2)] = inst_22599);

(statearr_22626_22679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22621 === (3))){
var inst_22618 = (state_22620[(2)]);
var state_22620__$1 = state_22620;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22620__$1,inst_22618);
} else {
if((state_val_22621 === (2))){
var ___$1 = (function (){var statearr_22628 = state_22620;
(statearr_22628[(4)] = cljs.core.cons.call(null,(5),(state_22620[(4)])));

return statearr_22628;
})();
var state_22620__$1 = state_22620;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_22629_22680 = state_22620__$1;
(statearr_22629_22680[(1)] = (6));

} else {
var statearr_22630_22681 = state_22620__$1;
(statearr_22630_22681[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22621 === (9))){
var inst_22602 = (state_22620[(8)]);
var inst_22604 = (state_22620[(9)]);
var inst_22611 = (state_22620[(2)]);
var inst_22612 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_22602,inst_22611);
var inst_22613 = inst_22604.call(null,inst_22612);
var inst_22614 = cljs.core.async.put_BANG_.call(null,port,inst_22613);
var inst_22615 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_22631 = state_22620;
(statearr_22631[(4)] = cljs.core.rest.call(null,(state_22620[(4)])));

return statearr_22631;
})();
var state_22620__$1 = (function (){var statearr_22632 = state_22620;
(statearr_22632[(10)] = inst_22614);

return statearr_22632;
})();
var statearr_22633_22682 = state_22620__$1;
(statearr_22633_22682[(2)] = inst_22615);

(statearr_22633_22682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22621 === (5))){
var ___$1 = (function (){var statearr_22634 = state_22620;
(statearr_22634[(4)] = cljs.core.rest.call(null,(state_22620[(4)])));

return statearr_22634;
})();
var state_22620__$1 = state_22620;
var ex22627 = (state_22620__$1[(2)]);
var statearr_22635_22683 = state_22620__$1;
(statearr_22635_22683[(5)] = ex22627);


var statearr_22636_22684 = state_22620__$1;
(statearr_22636_22684[(1)] = (4));

(statearr_22636_22684[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22621 === (8))){
var inst_22602 = (state_22620[(8)]);
var inst_22602__$1 = (state_22620[(2)]);
var inst_22603 = cljs.core.volatile_BANG_.call(null,(0));
var inst_22604 = (function (){var tuple_res_SINGLEQUOTE_ = inst_22602__$1;
var query_fuel = inst_22603;
return (function (p1__22514_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__22514_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22514_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_22605 = cljs.core.PersistentVector.EMPTY;
var inst_22606 = (function (){var tuple_res_SINGLEQUOTE_ = inst_22602__$1;
var query_fuel = inst_22603;
return (function (p1__22513_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__22513_SHARP_);
});
})();
var inst_22607 = cljs.core.keep.call(null,inst_22606,expandMaps);
var inst_22608 = cljs.core.async.merge.call(null,inst_22607);
var inst_22609 = cljs.core.async.into.call(null,inst_22605,inst_22608);
var state_22620__$1 = (function (){var statearr_22637 = state_22620;
(statearr_22637[(8)] = inst_22602__$1);

(statearr_22637[(9)] = inst_22604);

return statearr_22637;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22620__$1,(9),inst_22609);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0 = (function (){
var statearr_22638 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22638[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__);

(statearr_22638[(1)] = (1));

return statearr_22638;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1 = (function (state_22620){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_22620);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22639){var ex__2730__auto__ = e22639;
var statearr_22640_22685 = state_22620;
(statearr_22640_22685[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_22620[(4)]))){
var statearr_22641_22686 = state_22620;
(statearr_22641_22686[(1)] = cljs.core.first.call(null,(state_22620[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22687 = state_22620;
state_22620 = G__22687;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = function(state_22620){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1.call(this,state_22620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22642 = f__2750__auto__.call(null);
(statearr_22642[(6)] = c__2749__auto____$1);

return statearr_22642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto____$1;
});
})();
var inst_22529 = cljs.core.async.onto_chan_BANG_.call(null,inst_22522,tuples_res);
var inst_22530 = cljs.core.async.pipeline_async.call(null,parallelism,inst_22523__$1,inst_22528,inst_22522);
var inst_22531 = cljs.core.PersistentVector.EMPTY;
var inst_22532 = inst_22531;
var state_22573__$1 = (function (){var statearr_22643 = state_22573;
(statearr_22643[(8)] = inst_22523__$1);

(statearr_22643[(11)] = inst_22529);

(statearr_22643[(9)] = inst_22524__$1);

(statearr_22643[(12)] = inst_22530);

(statearr_22643[(13)] = inst_22532);

return statearr_22643;
})();
var statearr_22644_22688 = state_22573__$1;
(statearr_22644_22688[(2)] = null);

(statearr_22644_22688[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (19))){
var inst_22535 = (state_22573[(7)]);
var inst_22532 = (state_22573[(13)]);
var inst_22555 = cljs.core.first.call(null,inst_22535);
var inst_22556 = cljs.core.conj.call(null,inst_22532,inst_22555);
var inst_22532__$1 = inst_22556;
var state_22573__$1 = (function (){var statearr_22645 = state_22573;
(statearr_22645[(13)] = inst_22532__$1);

return statearr_22645;
})();
var statearr_22646_22689 = state_22573__$1;
(statearr_22646_22689[(2)] = null);

(statearr_22646_22689[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (11))){
var inst_22566 = (state_22573[(2)]);
var state_22573__$1 = state_22573;
var statearr_22648_22690 = state_22573__$1;
(statearr_22648_22690[(2)] = inst_22566);

(statearr_22648_22690[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (9))){
var inst_22532 = (state_22573[(13)]);
var state_22573__$1 = state_22573;
var statearr_22649_22691 = state_22573__$1;
(statearr_22649_22691[(2)] = inst_22532);

(statearr_22649_22691[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (5))){
var _ = (function (){var statearr_22650 = state_22573;
(statearr_22650[(4)] = cljs.core.rest.call(null,(state_22573[(4)])));

return statearr_22650;
})();
var state_22573__$1 = state_22573;
var ex22647 = (state_22573__$1[(2)]);
var statearr_22651_22692 = state_22573__$1;
(statearr_22651_22692[(5)] = ex22647);


if((ex22647 instanceof Error)){
var statearr_22652_22693 = state_22573__$1;
(statearr_22652_22693[(1)] = (4));

(statearr_22652_22693[(5)] = null);

} else {
throw ex22647;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (14))){
var inst_22564 = (state_22573[(2)]);
var state_22573__$1 = state_22573;
var statearr_22653_22694 = state_22573__$1;
(statearr_22653_22694[(2)] = inst_22564);

(statearr_22653_22694[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (16))){
var state_22573__$1 = state_22573;
var statearr_22654_22695 = state_22573__$1;
(statearr_22654_22695[(2)] = null);

(statearr_22654_22695[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (10))){
var inst_22535 = (state_22573[(7)]);
var inst_22539 = fluree.db.util.core.exception_QMARK_.call(null,inst_22535);
var state_22573__$1 = state_22573;
if(inst_22539){
var statearr_22655_22696 = state_22573__$1;
(statearr_22655_22696[(1)] = (12));

} else {
var statearr_22656_22697 = state_22573__$1;
(statearr_22656_22697[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (18))){
var inst_22524 = (state_22573[(9)]);
var inst_22548 = inst_22524.call(null);
var inst_22549 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_22550 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_22551 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_22552 = cljs.core.PersistentHashMap.fromArrays(inst_22550,inst_22551);
var inst_22553 = cljs.core.ex_info.call(null,inst_22549,inst_22552);
var state_22573__$1 = (function (){var statearr_22657 = state_22573;
(statearr_22657[(14)] = inst_22548);

return statearr_22657;
})();
var statearr_22658_22698 = state_22573__$1;
(statearr_22658_22698[(2)] = inst_22553);

(statearr_22658_22698[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22574 === (8))){
var inst_22535 = (state_22573[(7)]);
var inst_22535__$1 = (state_22573[(2)]);
var inst_22536 = (inst_22535__$1 == null);
var state_22573__$1 = (function (){var statearr_22659 = state_22573;
(statearr_22659[(7)] = inst_22535__$1);

return statearr_22659;
})();
if(cljs.core.truth_(inst_22536)){
var statearr_22660_22699 = state_22573__$1;
(statearr_22660_22699[(1)] = (9));

} else {
var statearr_22661_22700 = state_22573__$1;
(statearr_22661_22700[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0 = (function (){
var statearr_22662 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22662[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__);

(statearr_22662[(1)] = (1));

return statearr_22662;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1 = (function (state_22573){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_22573);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22663){var ex__2730__auto__ = e22663;
var statearr_22664_22701 = state_22573;
(statearr_22664_22701[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_22573[(4)]))){
var statearr_22665_22702 = state_22573;
(statearr_22665_22702[(1)] = cljs.core.first.call(null,(state_22573[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22703 = state_22573;
state_22573 = G__22703;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = function(state_22573){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1.call(this,state_22573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22666 = f__2750__auto__.call(null);
(statearr_22666[(6)] = c__2749__auto__);

return statearr_22666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__22704 = select;
var map__22704__$1 = cljs.core.__destructure_map.call(null,map__22704);
var as = cljs.core.get.call(null,map__22704__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__22704__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__22704__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4253__auto__ = as;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__22707 = orderBy;
var order = cljs.core.nth.call(null,vec__22707,(0),null);
var var$ = cljs.core.nth.call(null,vec__22707,(1),null);
var option = cljs.core.nth.call(null,vec__22707,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__22705_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__22705_SHARP_,compare_idx));
}):(function (p1__22706_SHARP_){
return cljs.core.nth.call(null,p1__22706_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__22712 = arguments.length;
switch (G__22712) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__22713,p__22714,group_limit,opts){
var map__22715 = p__22713;
var map__22715__$1 = cljs.core.__destructure_map.call(null,map__22715);
var res = map__22715__$1;
var vars = cljs.core.get.call(null,map__22715__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__22716 = p__22714;
var map__22716__$1 = cljs.core.__destructure_map.call(null,map__22716);
var select_spec = map__22716__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__22716__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__22716__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__22716__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__22716__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__22716__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__22716__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__22716__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__22716__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__22716__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__22716__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22853){
var state_val_22854 = (state_22853[(1)]);
if((state_val_22854 === (7))){
var inst_22723 = (state_22853[(7)]);
var state_22853__$1 = state_22853;
var statearr_22855_22957 = state_22853__$1;
(statearr_22855_22957[(2)] = inst_22723);

(statearr_22855_22957[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (59))){
var inst_22846 = (state_22853[(2)]);
var state_22853__$1 = state_22853;
var statearr_22856_22958 = state_22853__$1;
(statearr_22856_22958[(2)] = inst_22846);

(statearr_22856_22958[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (20))){
var inst_22759 = (state_22853[(8)]);
var inst_22762 = (state_22853[(9)]);
var inst_22758 = (state_22853[(2)]);
var inst_22759__$1 = cljs.core.__destructure_map.call(null,inst_22758);
var inst_22760 = cljs.core.get.call(null,inst_22759__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_22761 = cljs.core.get.call(null,inst_22759__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_22762__$1 = offset;
var state_22853__$1 = (function (){var statearr_22857 = state_22853;
(statearr_22857[(10)] = inst_22760);

(statearr_22857[(11)] = inst_22761);

(statearr_22857[(8)] = inst_22759__$1);

(statearr_22857[(9)] = inst_22762__$1);

return statearr_22857;
})();
if(cljs.core.truth_(inst_22762__$1)){
var statearr_22858_22959 = state_22853__$1;
(statearr_22858_22959[(1)] = (21));

} else {
var statearr_22859_22960 = state_22853__$1;
(statearr_22859_22960[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (58))){
var inst_22838 = (state_22853[(12)]);
var state_22853__$1 = state_22853;
var statearr_22860_22961 = state_22853__$1;
(statearr_22860_22961[(2)] = inst_22838);

(statearr_22860_22961[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (60))){
var inst_22842 = (state_22853[(2)]);
var inst_22843 = fluree.db.util.async.throw_err.call(null,inst_22842);
var state_22853__$1 = state_22853;
var statearr_22861_22962 = state_22853__$1;
(statearr_22861_22962[(2)] = inst_22843);

(statearr_22861_22962[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (27))){
var inst_22774 = cljs.core.not.call(null,inVector_QMARK_);
var state_22853__$1 = state_22853;
var statearr_22862_22963 = state_22853__$1;
(statearr_22862_22963[(2)] = inst_22774);

(statearr_22862_22963[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (1))){
var state_22853__$1 = state_22853;
var statearr_22863_22964 = state_22853__$1;
(statearr_22863_22964[(2)] = null);

(statearr_22863_22964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (24))){
var state_22853__$1 = state_22853;
var statearr_22864_22965 = state_22853__$1;
(statearr_22864_22965[(2)] = offset);

(statearr_22864_22965[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (55))){
var inst_22832 = (state_22853[(13)]);
var state_22853__$1 = state_22853;
var statearr_22865_22966 = state_22853__$1;
(statearr_22865_22966[(2)] = inst_22832);

(statearr_22865_22966[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (39))){
var inst_22800 = (state_22853[(14)]);
var inst_22802 = cljs.core.distinct.call(null);
var inst_22803 = cljs.core.conj.call(null,inst_22800,inst_22802);
var state_22853__$1 = state_22853;
var statearr_22866_22967 = state_22853__$1;
(statearr_22866_22967[(2)] = inst_22803);

(statearr_22866_22967[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (46))){
var inst_22812 = (state_22853[(15)]);
var state_22853__$1 = state_22853;
var statearr_22867_22968 = state_22853__$1;
(statearr_22867_22968[(2)] = inst_22812);

(statearr_22867_22968[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (4))){
var inst_22717 = (state_22853[(2)]);
var state_22853__$1 = state_22853;
var statearr_22868_22969 = state_22853__$1;
(statearr_22868_22969[(2)] = inst_22717);

(statearr_22868_22969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (54))){
var inst_22832 = (state_22853[(13)]);
var inst_22826 = (state_22853[(16)]);
var inst_22834 = cljs.core.PersistentVector.EMPTY;
var inst_22835 = cljs.core.into.call(null,inst_22834,inst_22826,inst_22832);
var state_22853__$1 = state_22853;
var statearr_22869_22970 = state_22853__$1;
(statearr_22869_22970[(2)] = inst_22835);

(statearr_22869_22970[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (15))){
var inst_22744 = (state_22853[(17)]);
var inst_22746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22747 = [inst_22744];
var inst_22748 = (new cljs.core.PersistentVector(null,1,(5),inst_22746,inst_22747,null));
var state_22853__$1 = state_22853;
var statearr_22870_22971 = state_22853__$1;
(statearr_22870_22971[(2)] = inst_22748);

(statearr_22870_22971[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (48))){
var inst_22782 = (state_22853[(18)]);
var inst_22760 = (state_22853[(10)]);
var inst_22761 = (state_22853[(11)]);
var inst_22771 = (state_22853[(19)]);
var inst_22759 = (state_22853[(8)]);
var inst_22777 = (state_22853[(20)]);
var inst_22818 = (state_22853[(21)]);
var inst_22820 = (function (){var map__22753 = inst_22759;
var headers = inst_22760;
var tuples = inst_22761;
var offset_SINGLEQUOTE_ = inst_22771;
var single_result_QMARK_ = inst_22777;
var pp_keys = inst_22782;
var G__22783 = inst_22818;
return (function (p1__22710_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__22710_SHARP_);
});
})();
var inst_22821 = cljs.core.map.call(null,inst_22820);
var inst_22822 = cljs.core.conj.call(null,inst_22818,inst_22821);
var state_22853__$1 = state_22853;
var statearr_22871_22972 = state_22853__$1;
(statearr_22871_22972[(2)] = inst_22822);

(statearr_22871_22972[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (50))){
var inst_22825 = (state_22853[(2)]);
var inst_22826 = cljs.core.apply.call(null,cljs.core.comp,inst_22825);
var state_22853__$1 = (function (){var statearr_22872 = state_22853;
(statearr_22872[(16)] = inst_22826);

return statearr_22872;
})();
if(cljs.core.truth_(orderBy)){
var statearr_22873_22973 = state_22853__$1;
(statearr_22873_22973[(1)] = (51));

} else {
var statearr_22874_22974 = state_22853__$1;
(statearr_22874_22974[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (21))){
var inst_22764 = cljs.core.not.call(null,groupBy);
var state_22853__$1 = state_22853;
var statearr_22875_22975 = state_22853__$1;
(statearr_22875_22975[(2)] = inst_22764);

(statearr_22875_22975[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (31))){
var state_22853__$1 = state_22853;
var statearr_22876_22976 = state_22853__$1;
(statearr_22876_22976[(2)] = null);

(statearr_22876_22976[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (32))){
var inst_22760 = (state_22853[(10)]);
var inst_22777 = (state_22853[(20)]);
var inst_22782 = (state_22853[(2)]);
var inst_22784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22785 = fluree.db.query.fql.select_tuples_fn.call(null,inst_22760,vars,select);
var inst_22786 = cljs.core.map.call(null,inst_22785);
var inst_22787 = [inst_22786];
var inst_22788 = (new cljs.core.PersistentVector(null,1,(5),inst_22784,inst_22787,null));
var state_22853__$1 = (function (){var statearr_22877 = state_22853;
(statearr_22877[(18)] = inst_22782);

(statearr_22877[(22)] = inst_22788);

return statearr_22877;
})();
if(cljs.core.truth_(inst_22777)){
var statearr_22878_22977 = state_22853__$1;
(statearr_22878_22977[(1)] = (33));

} else {
var statearr_22879_22978 = state_22853__$1;
(statearr_22879_22978[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (40))){
var inst_22800 = (state_22853[(14)]);
var state_22853__$1 = state_22853;
var statearr_22880_22979 = state_22853__$1;
(statearr_22880_22979[(2)] = inst_22800);

(statearr_22880_22979[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (56))){
var inst_22838 = (state_22853[(2)]);
var state_22853__$1 = (function (){var statearr_22881 = state_22853;
(statearr_22881[(12)] = inst_22838);

return statearr_22881;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_22882_22980 = state_22853__$1;
(statearr_22882_22980[(1)] = (57));

} else {
var statearr_22883_22981 = state_22853__$1;
(statearr_22883_22981[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (33))){
var inst_22788 = (state_22853[(22)]);
var inst_22790 = cljs.core.map.call(null,cljs.core.first);
var inst_22791 = cljs.core.conj.call(null,inst_22788,inst_22790);
var state_22853__$1 = state_22853;
var statearr_22884_22982 = state_22853__$1;
(statearr_22884_22982[(2)] = inst_22791);

(statearr_22884_22982[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (13))){
var inst_22733 = (state_22853[(23)]);
var state_22853__$1 = state_22853;
var statearr_22885_22983 = state_22853__$1;
(statearr_22885_22983[(2)] = inst_22733);

(statearr_22885_22983[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (22))){
var inst_22762 = (state_22853[(9)]);
var state_22853__$1 = state_22853;
var statearr_22886_22984 = state_22853__$1;
(statearr_22886_22984[(2)] = inst_22762);

(statearr_22886_22984[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (36))){
var inst_22794 = (state_22853[(24)]);
var inst_22796 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_22797 = cljs.core.conj.call(null,inst_22794,inst_22796);
var state_22853__$1 = state_22853;
var statearr_22887_22985 = state_22853__$1;
(statearr_22887_22985[(2)] = inst_22797);

(statearr_22887_22985[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (41))){
var inst_22771 = (state_22853[(19)]);
var inst_22806 = (state_22853[(2)]);
var state_22853__$1 = (function (){var statearr_22888 = state_22853;
(statearr_22888[(25)] = inst_22806);

return statearr_22888;
})();
if(cljs.core.truth_(inst_22771)){
var statearr_22889_22986 = state_22853__$1;
(statearr_22889_22986[(1)] = (42));

} else {
var statearr_22890_22987 = state_22853__$1;
(statearr_22890_22987[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (43))){
var inst_22806 = (state_22853[(25)]);
var state_22853__$1 = state_22853;
var statearr_22891_22988 = state_22853__$1;
(statearr_22891_22988[(2)] = inst_22806);

(statearr_22891_22988[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (29))){
var inst_22777 = (state_22853[(2)]);
var state_22853__$1 = (function (){var statearr_22892 = state_22853;
(statearr_22892[(20)] = inst_22777);

return statearr_22892;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_22893_22989 = state_22853__$1;
(statearr_22893_22989[(1)] = (30));

} else {
var statearr_22894_22990 = state_22853__$1;
(statearr_22894_22990[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (44))){
var inst_22812 = (state_22853[(2)]);
var state_22853__$1 = (function (){var statearr_22895 = state_22853;
(statearr_22895[(15)] = inst_22812);

return statearr_22895;
})();
if(cljs.core.truth_(group_limit)){
var statearr_22896_22991 = state_22853__$1;
(statearr_22896_22991[(1)] = (45));

} else {
var statearr_22897_22992 = state_22853__$1;
(statearr_22897_22992[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (6))){
var inst_22725 = cljs.core.count.call(null,select);
var inst_22726 = cljs.core._EQ_.call(null,(1),inst_22725);
var state_22853__$1 = state_22853;
var statearr_22898_22993 = state_22853__$1;
(statearr_22898_22993[(2)] = inst_22726);

(statearr_22898_22993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (28))){
var inst_22772 = (state_22853[(26)]);
var state_22853__$1 = state_22853;
var statearr_22899_22994 = state_22853__$1;
(statearr_22899_22994[(2)] = inst_22772);

(statearr_22899_22994[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (51))){
var inst_22760 = (state_22853[(10)]);
var inst_22761 = (state_22853[(11)]);
var inst_22829 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_22760,orderBy,inst_22761);
var state_22853__$1 = state_22853;
var statearr_22900_22995 = state_22853__$1;
(statearr_22900_22995[(2)] = inst_22829);

(statearr_22900_22995[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (25))){
var state_22853__$1 = state_22853;
var statearr_22901_22996 = state_22853__$1;
(statearr_22901_22996[(2)] = null);

(statearr_22901_22996[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (34))){
var inst_22788 = (state_22853[(22)]);
var state_22853__$1 = state_22853;
var statearr_22902_22997 = state_22853__$1;
(statearr_22902_22997[(2)] = inst_22788);

(statearr_22902_22997[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (17))){
var inst_22751 = (state_22853[(2)]);
var state_22853__$1 = state_22853;
var statearr_22903_22998 = state_22853__$1;
(statearr_22903_22998[(2)] = inst_22751);

(statearr_22903_22998[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (3))){
var inst_22851 = (state_22853[(2)]);
var state_22853__$1 = state_22853;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22853__$1,inst_22851);
} else {
if((state_val_22854 === (12))){
var inst_22733 = (state_22853[(23)]);
var inst_22735 = cljs.core.first.call(null,select);
var inst_22736 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22735);
var inst_22737 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_22736);
var inst_22738 = cljs.core.subs.call(null,inst_22737,(1));
var inst_22739 = [inst_22738];
var inst_22740 = [inst_22733];
var inst_22741 = cljs.core.PersistentHashMap.fromArrays(inst_22739,inst_22740);
var state_22853__$1 = state_22853;
var statearr_22904_22999 = state_22853__$1;
(statearr_22904_22999[(2)] = inst_22741);

(statearr_22904_22999[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (2))){
var inst_22723 = (state_22853[(7)]);
var _ = (function (){var statearr_22905 = state_22853;
(statearr_22905[(4)] = cljs.core.cons.call(null,(5),(state_22853[(4)])));

return statearr_22905;
})();
var inst_22723__$1 = aggregates;
var state_22853__$1 = (function (){var statearr_22906 = state_22853;
(statearr_22906[(7)] = inst_22723__$1);

return statearr_22906;
})();
if(cljs.core.truth_(inst_22723__$1)){
var statearr_22907_23000 = state_22853__$1;
(statearr_22907_23000[(1)] = (6));

} else {
var statearr_22908_23001 = state_22853__$1;
(statearr_22908_23001[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (23))){
var inst_22767 = (state_22853[(2)]);
var state_22853__$1 = state_22853;
if(cljs.core.truth_(inst_22767)){
var statearr_22909_23002 = state_22853__$1;
(statearr_22909_23002[(1)] = (24));

} else {
var statearr_22910_23003 = state_22853__$1;
(statearr_22910_23003[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (47))){
var inst_22818 = (state_22853[(2)]);
var state_22853__$1 = (function (){var statearr_22911 = state_22853;
(statearr_22911[(21)] = inst_22818);

return statearr_22911;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_22912_23004 = state_22853__$1;
(statearr_22912_23004[(1)] = (48));

} else {
var statearr_22913_23005 = state_22853__$1;
(statearr_22913_23005[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (35))){
var inst_22794 = (state_22853[(2)]);
var state_22853__$1 = (function (){var statearr_22914 = state_22853;
(statearr_22914[(24)] = inst_22794);

return statearr_22914;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_22915_23006 = state_22853__$1;
(statearr_22915_23006[(1)] = (36));

} else {
var statearr_22916_23007 = state_22853__$1;
(statearr_22916_23007[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (19))){
var state_22853__$1 = state_22853;
var statearr_22917_23008 = state_22853__$1;
(statearr_22917_23008[(2)] = res);

(statearr_22917_23008[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (57))){
var inst_22782 = (state_22853[(18)]);
var inst_22838 = (state_22853[(12)]);
var inst_22777 = (state_22853[(20)]);
var inst_22840 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_22782,inst_22777,db,fuel,max_fuel,opts,(8),inst_22838);
var state_22853__$1 = state_22853;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22853__$1,(60),inst_22840);
} else {
if((state_val_22854 === (11))){
var inst_22848 = (state_22853[(2)]);
var _ = (function (){var statearr_22919 = state_22853;
(statearr_22919[(4)] = cljs.core.rest.call(null,(state_22853[(4)])));

return statearr_22919;
})();
var state_22853__$1 = state_22853;
var statearr_22920_23009 = state_22853__$1;
(statearr_22920_23009[(2)] = inst_22848);

(statearr_22920_23009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (9))){
var inst_22731 = cljs.core.first.call(null,aggregates);
var inst_22732 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_22731);
var inst_22733 = cljs.core.second.call(null,inst_22732);
var state_22853__$1 = (function (){var statearr_22921 = state_22853;
(statearr_22921[(23)] = inst_22733);

return statearr_22921;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_22922_23010 = state_22853__$1;
(statearr_22922_23010[(1)] = (12));

} else {
var statearr_22923_23011 = state_22853__$1;
(statearr_22923_23011[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (5))){
var _ = (function (){var statearr_22924 = state_22853;
(statearr_22924[(4)] = cljs.core.rest.call(null,(state_22853[(4)])));

return statearr_22924;
})();
var state_22853__$1 = state_22853;
var ex22918 = (state_22853__$1[(2)]);
var statearr_22925_23012 = state_22853__$1;
(statearr_22925_23012[(5)] = ex22918);


if((ex22918 instanceof Error)){
var statearr_22926_23013 = state_22853__$1;
(statearr_22926_23013[(1)] = (4));

(statearr_22926_23013[(5)] = null);

} else {
throw ex22918;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (14))){
var inst_22744 = (state_22853[(2)]);
var state_22853__$1 = (function (){var statearr_22927 = state_22853;
(statearr_22927[(17)] = inst_22744);

return statearr_22927;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_22928_23014 = state_22853__$1;
(statearr_22928_23014[(1)] = (15));

} else {
var statearr_22929_23015 = state_22853__$1;
(statearr_22929_23015[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (45))){
var inst_22812 = (state_22853[(15)]);
var inst_22814 = cljs.core.take.call(null,group_limit);
var inst_22815 = cljs.core.conj.call(null,inst_22812,inst_22814);
var state_22853__$1 = state_22853;
var statearr_22930_23016 = state_22853__$1;
(statearr_22930_23016[(2)] = inst_22815);

(statearr_22930_23016[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (53))){
var inst_22832 = (state_22853[(2)]);
var state_22853__$1 = (function (){var statearr_22931 = state_22853;
(statearr_22931[(13)] = inst_22832);

return statearr_22931;
})();
var statearr_22932_23017 = state_22853__$1;
(statearr_22932_23017[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (26))){
var inst_22772 = (state_22853[(26)]);
var inst_22771 = (state_22853[(2)]);
var inst_22772__$1 = cljs.core.not.call(null,prettyPrint);
var state_22853__$1 = (function (){var statearr_22934 = state_22853;
(statearr_22934[(19)] = inst_22771);

(statearr_22934[(26)] = inst_22772__$1);

return statearr_22934;
})();
if(inst_22772__$1){
var statearr_22935_23018 = state_22853__$1;
(statearr_22935_23018[(1)] = (27));

} else {
var statearr_22936_23019 = state_22853__$1;
(statearr_22936_23019[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (16))){
var inst_22744 = (state_22853[(17)]);
var state_22853__$1 = state_22853;
var statearr_22937_23020 = state_22853__$1;
(statearr_22937_23020[(2)] = inst_22744);

(statearr_22937_23020[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (38))){
var inst_22800 = (state_22853[(2)]);
var state_22853__$1 = (function (){var statearr_22938 = state_22853;
(statearr_22938[(14)] = inst_22800);

return statearr_22938;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_22939_23021 = state_22853__$1;
(statearr_22939_23021[(1)] = (39));

} else {
var statearr_22940_23022 = state_22853__$1;
(statearr_22940_23022[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (30))){
var inst_22779 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_22853__$1 = state_22853;
var statearr_22941_23023 = state_22853__$1;
(statearr_22941_23023[(2)] = inst_22779);

(statearr_22941_23023[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (10))){
var state_22853__$1 = state_22853;
if(cljs.core.truth_(aggregates)){
var statearr_22942_23024 = state_22853__$1;
(statearr_22942_23024[(1)] = (18));

} else {
var statearr_22943_23025 = state_22853__$1;
(statearr_22943_23025[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (18))){
var inst_22755 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_22853__$1 = state_22853;
var statearr_22944_23026 = state_22853__$1;
(statearr_22944_23026[(2)] = inst_22755);

(statearr_22944_23026[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (52))){
var inst_22761 = (state_22853[(11)]);
var state_22853__$1 = state_22853;
var statearr_22945_23027 = state_22853__$1;
(statearr_22945_23027[(2)] = inst_22761);

(statearr_22945_23027[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (42))){
var inst_22771 = (state_22853[(19)]);
var inst_22806 = (state_22853[(25)]);
var inst_22808 = cljs.core.drop.call(null,inst_22771);
var inst_22809 = cljs.core.conj.call(null,inst_22806,inst_22808);
var state_22853__$1 = state_22853;
var statearr_22946_23028 = state_22853__$1;
(statearr_22946_23028[(2)] = inst_22809);

(statearr_22946_23028[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (37))){
var inst_22794 = (state_22853[(24)]);
var state_22853__$1 = state_22853;
var statearr_22947_23029 = state_22853__$1;
(statearr_22947_23029[(2)] = inst_22794);

(statearr_22947_23029[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (8))){
var inst_22729 = (state_22853[(2)]);
var state_22853__$1 = state_22853;
if(cljs.core.truth_(inst_22729)){
var statearr_22948_23030 = state_22853__$1;
(statearr_22948_23030[(1)] = (9));

} else {
var statearr_22949_23031 = state_22853__$1;
(statearr_22949_23031[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22854 === (49))){
var inst_22818 = (state_22853[(21)]);
var state_22853__$1 = state_22853;
var statearr_22950_23032 = state_22853__$1;
(statearr_22950_23032[(2)] = inst_22818);

(statearr_22950_23032[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_22951 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22951[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_22951[(1)] = (1));

return statearr_22951;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_22853){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_22853);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22952){var ex__2730__auto__ = e22952;
var statearr_22953_23033 = state_22853;
(statearr_22953_23033[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_22853[(4)]))){
var statearr_22954_23034 = state_22853;
(statearr_22954_23034[(1)] = cljs.core.first.call(null,(state_22853[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23035 = state_22853;
state_22853 = G__23035;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_22853){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_22853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22955 = f__2750__auto__.call(null);
(statearr_22955[(6)] = c__2749__auto__);

return statearr_22955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__23038,groupBy){
var map__23039 = p__23038;
var map__23039__$1 = cljs.core.__destructure_map.call(null,map__23039);
var res = map__23039__$1;
var headers = cljs.core.get.call(null,map__23039__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__23039__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__23040 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__23040,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__23040,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__23036_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__23036_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__23037_SHARP_){
return cljs.core.nth.call(null,tuple,p1__23037_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__23043 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__23043,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__23043,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__23046,p__23047,opts){
var map__23048 = p__23046;
var map__23048__$1 = cljs.core.__destructure_map.call(null,map__23048);
var res = map__23048__$1;
var headers = cljs.core.get.call(null,map__23048__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__23048__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__23049 = p__23047;
var map__23049__$1 = cljs.core.__destructure_map.call(null,map__23049);
var select_spec = map__23049__$1;
var groupBy = cljs.core.get.call(null,map__23049__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__23049__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__23049__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__23049__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__23049__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__23049__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__23049__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23291){
var state_val_23292 = (state_23291[(1)]);
if((state_val_23292 === (65))){
var state_23291__$1 = state_23291;
var statearr_23293_23444 = state_23291__$1;
(statearr_23293_23444[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (70))){
var inst_23212 = (state_23291[(7)]);
var state_23291__$1 = state_23291;
var statearr_23295_23445 = state_23291__$1;
(statearr_23295_23445[(2)] = inst_23212);

(statearr_23295_23445[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (62))){
var state_23291__$1 = state_23291;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_23296_23446 = state_23291__$1;
(statearr_23296_23446[(1)] = (64));

} else {
var statearr_23297_23447 = state_23291__$1;
(statearr_23297_23447[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (74))){
var inst_23187 = (state_23291[(8)]);
var inst_23128 = (state_23291[(9)]);
var inst_23119 = (state_23291[(10)]);
var inst_23220 = cljs.core.assoc.call(null,inst_23119,inst_23128,inst_23187);
var state_23291__$1 = state_23291;
var statearr_23298_23448 = state_23291__$1;
(statearr_23298_23448[(2)] = inst_23220);

(statearr_23298_23448[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (7))){
var state_23291__$1 = state_23291;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_23299_23449 = state_23291__$1;
(statearr_23299_23449[(1)] = (82));

} else {
var statearr_23300_23450 = state_23291__$1;
(statearr_23300_23450[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (59))){
var inst_23187 = (state_23291[(8)]);
var inst_23117 = (state_23291[(11)]);
var inst_23191 = cljs.core.count.call(null,inst_23187);
var inst_23192 = (inst_23117 - inst_23191);
var state_23291__$1 = state_23291;
var statearr_23301_23451 = state_23291__$1;
(statearr_23301_23451[(2)] = inst_23192);

(statearr_23301_23451[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (86))){
var state_23291__$1 = state_23291;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_23302_23452 = state_23291__$1;
(statearr_23302_23452[(1)] = (89));

} else {
var statearr_23303_23453 = state_23291__$1;
(statearr_23303_23453[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (20))){
var state_23291__$1 = state_23291;
var statearr_23304_23454 = state_23291__$1;
(statearr_23304_23454[(2)] = (0));

(statearr_23304_23454[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (72))){
var inst_23217 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
if(cljs.core.truth_(inst_23217)){
var statearr_23305_23455 = state_23291__$1;
(statearr_23305_23455[(1)] = (73));

} else {
var statearr_23306_23456 = state_23291__$1;
(statearr_23306_23456[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (58))){
var state_23291__$1 = state_23291;
var statearr_23307_23457 = state_23291__$1;
(statearr_23307_23457[(2)] = null);

(statearr_23307_23457[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (60))){
var inst_23118 = (state_23291[(12)]);
var inst_23194 = (state_23291[(2)]);
var inst_23195 = (inst_23118 <= (0));
var state_23291__$1 = (function (){var statearr_23308 = state_23291;
(statearr_23308[(13)] = inst_23194);

return statearr_23308;
})();
if(cljs.core.truth_(inst_23195)){
var statearr_23309_23458 = state_23291__$1;
(statearr_23309_23458[(1)] = (61));

} else {
var statearr_23310_23459 = state_23291__$1;
(statearr_23310_23459[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (27))){
var inst_23117 = (state_23291[(11)]);
var inst_23141 = (inst_23117 < (1));
var state_23291__$1 = state_23291;
var statearr_23311_23460 = state_23291__$1;
(statearr_23311_23460[(2)] = inst_23141);

(statearr_23311_23460[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (1))){
var state_23291__$1 = state_23291;
var statearr_23312_23461 = state_23291__$1;
(statearr_23312_23461[(2)] = null);

(statearr_23312_23461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (69))){
var inst_23207 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
var statearr_23313_23462 = state_23291__$1;
(statearr_23313_23462[(2)] = inst_23207);

(statearr_23313_23462[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (24))){
var inst_23119 = (state_23291[(10)]);
var state_23291__$1 = state_23291;
var statearr_23314_23463 = state_23291__$1;
(statearr_23314_23463[(2)] = inst_23119);

(statearr_23314_23463[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (55))){
var inst_23177 = (state_23291[(14)]);
var inst_23117 = (state_23291[(11)]);
var inst_23184 = cljs.core.take.call(null,inst_23117,inst_23177);
var state_23291__$1 = state_23291;
var statearr_23315_23464 = state_23291__$1;
(statearr_23315_23464[(2)] = inst_23184);

(statearr_23315_23464[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (85))){
var inst_23262 = (state_23291[(15)]);
var inst_23261 = (state_23291[(2)]);
var inst_23262__$1 = fluree.db.util.async.throw_err.call(null,inst_23261);
var inst_23263 = cljs.core.coll_QMARK_.call(null,inst_23262__$1);
var inst_23264 = (!(inst_23263));
var state_23291__$1 = (function (){var statearr_23316 = state_23291;
(statearr_23316[(15)] = inst_23262__$1);

return statearr_23316;
})();
if(inst_23264){
var statearr_23317_23465 = state_23291__$1;
(statearr_23317_23465[(1)] = (86));

} else {
var statearr_23318_23466 = state_23291__$1;
(statearr_23318_23466[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (39))){
var inst_23136 = (state_23291[(16)]);
var inst_23158 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_23159 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_23160 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_23136,inst_23158,inst_23159);
var state_23291__$1 = state_23291;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23291__$1,(42),inst_23160);
} else {
if((state_val_23292 === (88))){
var inst_23284 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
var statearr_23319_23467 = state_23291__$1;
(statearr_23319_23467[(2)] = inst_23284);

(statearr_23319_23467[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (46))){
var inst_23118 = (state_23291[(12)]);
var inst_23172 = ((0) < inst_23118);
var state_23291__$1 = state_23291;
if(cljs.core.truth_(inst_23172)){
var statearr_23320_23468 = state_23291__$1;
(statearr_23320_23468[(1)] = (49));

} else {
var statearr_23321_23469 = state_23291__$1;
(statearr_23321_23469[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (4))){
var inst_23050 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
var statearr_23322_23470 = state_23291__$1;
(statearr_23322_23470[(2)] = inst_23050);

(statearr_23322_23470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (77))){
var inst_23117 = (state_23291[(11)]);
var inst_23228 = (inst_23117 - (1));
var state_23291__$1 = state_23291;
var statearr_23323_23471 = state_23291__$1;
(statearr_23323_23471[(2)] = inst_23228);

(statearr_23323_23471[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (95))){
var inst_23262 = (state_23291[(15)]);
var state_23291__$1 = state_23291;
var statearr_23324_23472 = state_23291__$1;
(statearr_23324_23472[(2)] = inst_23262);

(statearr_23324_23472[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (54))){
var inst_23182 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
if(cljs.core.truth_(inst_23182)){
var statearr_23325_23473 = state_23291__$1;
(statearr_23325_23473[(1)] = (55));

} else {
var statearr_23326_23474 = state_23291__$1;
(statearr_23326_23474[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (92))){
var inst_23262 = (state_23291[(15)]);
var inst_23275 = cljs.core.first.call(null,inst_23262);
var state_23291__$1 = state_23291;
var statearr_23327_23475 = state_23291__$1;
(statearr_23327_23475[(2)] = inst_23275);

(statearr_23327_23475[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (15))){
var inst_23068 = (state_23291[(17)]);
var inst_23076 = (state_23291[(2)]);
var inst_23077 = fluree.db.util.async.throw_err.call(null,inst_23076);
var inst_23078 = [inst_23068];
var inst_23079 = [inst_23077];
var inst_23080 = cljs.core.PersistentHashMap.fromArrays(inst_23078,inst_23079);
var state_23291__$1 = state_23291;
var statearr_23328_23476 = state_23291__$1;
(statearr_23328_23476[(2)] = inst_23080);

(statearr_23328_23476[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (48))){
var inst_23240 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
var statearr_23329_23477 = state_23291__$1;
(statearr_23329_23477[(2)] = inst_23240);

(statearr_23329_23477[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (50))){
var inst_23163 = (state_23291[(18)]);
var state_23291__$1 = state_23291;
var statearr_23330_23478 = state_23291__$1;
(statearr_23330_23478[(2)] = inst_23163);

(statearr_23330_23478[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (75))){
var inst_23194 = (state_23291[(13)]);
var inst_23211 = (state_23291[(19)]);
var inst_23132 = (state_23291[(20)]);
var inst_23129 = (state_23291[(21)]);
var inst_23222 = (state_23291[(2)]);
var inst_23115 = inst_23129;
var inst_23116 = inst_23132;
var inst_23117 = inst_23194;
var inst_23118 = inst_23211;
var inst_23119 = inst_23222;
var state_23291__$1 = (function (){var statearr_23331 = state_23291;
(statearr_23331[(12)] = inst_23118);

(statearr_23331[(22)] = inst_23115);

(statearr_23331[(23)] = inst_23116);

(statearr_23331[(11)] = inst_23117);

(statearr_23331[(10)] = inst_23119);

return statearr_23331;
})();
var statearr_23332_23479 = state_23291__$1;
(statearr_23332_23479[(2)] = null);

(statearr_23332_23479[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (21))){
var inst_23096 = (state_23291[(24)]);
var inst_23108 = (state_23291[(25)]);
var inst_23100 = (state_23291[(26)]);
var inst_23113 = (state_23291[(2)]);
var inst_23114 = cljs.core.PersistentHashMap.EMPTY;
var inst_23115 = inst_23096;
var inst_23116 = inst_23100;
var inst_23117 = inst_23108;
var inst_23118 = inst_23113;
var inst_23119 = inst_23114;
var state_23291__$1 = (function (){var statearr_23333 = state_23291;
(statearr_23333[(12)] = inst_23118);

(statearr_23333[(22)] = inst_23115);

(statearr_23333[(23)] = inst_23116);

(statearr_23333[(11)] = inst_23117);

(statearr_23333[(10)] = inst_23119);

return statearr_23333;
})();
var statearr_23334_23480 = state_23291__$1;
(statearr_23334_23480[(2)] = null);

(statearr_23334_23480[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (31))){
var inst_23118 = (state_23291[(12)]);
var inst_23133 = (state_23291[(27)]);
var inst_23147 = (inst_23118 >= inst_23133);
var state_23291__$1 = state_23291;
if(cljs.core.truth_(inst_23147)){
var statearr_23335_23481 = state_23291__$1;
(statearr_23335_23481[(1)] = (33));

} else {
var statearr_23336_23482 = state_23291__$1;
(statearr_23336_23482[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (32))){
var inst_23247 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
var statearr_23337_23483 = state_23291__$1;
(statearr_23337_23483[(2)] = inst_23247);

(statearr_23337_23483[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (40))){
var state_23291__$1 = state_23291;
var statearr_23338_23484 = state_23291__$1;
(statearr_23338_23484[(2)] = null);

(statearr_23338_23484[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (91))){
var inst_23272 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
var statearr_23339_23485 = state_23291__$1;
(statearr_23339_23485[(2)] = inst_23272);

(statearr_23339_23485[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (56))){
var inst_23177 = (state_23291[(14)]);
var state_23291__$1 = state_23291;
var statearr_23340_23486 = state_23291__$1;
(statearr_23340_23486[(2)] = inst_23177);

(statearr_23340_23486[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (33))){
var state_23291__$1 = state_23291;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_23341_23487 = state_23291__$1;
(statearr_23341_23487[(1)] = (36));

} else {
var statearr_23342_23488 = state_23291__$1;
(statearr_23342_23488[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (13))){
var inst_23096 = (state_23291[(24)]);
var inst_23100 = (state_23291[(26)]);
var inst_23065 = (state_23291[(28)]);
var inst_23096__$1 = cljs.core.keys.call(null,inst_23065);
var inst_23097 = cljs.core.seq.call(null,inst_23096__$1);
var inst_23098 = cljs.core.first.call(null,inst_23097);
var inst_23099 = cljs.core.next.call(null,inst_23097);
var inst_23100__$1 = cljs.core.vals.call(null,inst_23065);
var inst_23101 = cljs.core.seq.call(null,inst_23100__$1);
var inst_23102 = cljs.core.first.call(null,inst_23101);
var inst_23103 = cljs.core.next.call(null,inst_23101);
var inst_23104 = cljs.core._EQ_.call(null,(0),limit);
var state_23291__$1 = (function (){var statearr_23343 = state_23291;
(statearr_23343[(29)] = inst_23099);

(statearr_23343[(24)] = inst_23096__$1);

(statearr_23343[(30)] = inst_23102);

(statearr_23343[(26)] = inst_23100__$1);

(statearr_23343[(31)] = inst_23098);

(statearr_23343[(32)] = inst_23103);

return statearr_23343;
})();
if(inst_23104){
var statearr_23344_23489 = state_23291__$1;
(statearr_23344_23489[(1)] = (16));

} else {
var statearr_23345_23490 = state_23291__$1;
(statearr_23345_23490[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (22))){
var inst_23115 = (state_23291[(22)]);
var inst_23116 = (state_23291[(23)]);
var inst_23127 = cljs.core.seq.call(null,inst_23115);
var inst_23128 = cljs.core.first.call(null,inst_23127);
var inst_23129 = cljs.core.next.call(null,inst_23127);
var inst_23130 = cljs.core.seq.call(null,inst_23116);
var inst_23131 = cljs.core.first.call(null,inst_23130);
var inst_23132 = cljs.core.next.call(null,inst_23130);
var inst_23133 = cljs.core.count.call(null,inst_23131);
var inst_23134 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_23135 = [headers,vars,inst_23131];
var inst_23136 = cljs.core.PersistentHashMap.fromArrays(inst_23134,inst_23135);
var inst_23137 = (inst_23131 == null);
var state_23291__$1 = (function (){var statearr_23346 = state_23291;
(statearr_23346[(9)] = inst_23128);

(statearr_23346[(16)] = inst_23136);

(statearr_23346[(27)] = inst_23133);

(statearr_23346[(20)] = inst_23132);

(statearr_23346[(21)] = inst_23129);

return statearr_23346;
})();
if(cljs.core.truth_(inst_23137)){
var statearr_23347_23491 = state_23291__$1;
(statearr_23347_23491[(1)] = (24));

} else {
var statearr_23348_23492 = state_23291__$1;
(statearr_23348_23492[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (90))){
var inst_23262 = (state_23291[(15)]);
var state_23291__$1 = state_23291;
var statearr_23349_23493 = state_23291__$1;
(statearr_23349_23493[(2)] = inst_23262);

(statearr_23349_23493[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (36))){
var inst_23118 = (state_23291[(12)]);
var inst_23150 = (inst_23118 - (1));
var state_23291__$1 = state_23291;
var statearr_23350_23494 = state_23291__$1;
(statearr_23350_23494[(2)] = inst_23150);

(statearr_23350_23494[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (41))){
var inst_23243 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
var statearr_23351_23495 = state_23291__$1;
(statearr_23351_23495[(2)] = inst_23243);

(statearr_23351_23495[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (89))){
var inst_23262 = (state_23291[(15)]);
var inst_23267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23268 = [inst_23262];
var inst_23269 = (new cljs.core.PersistentVector(null,1,(5),inst_23267,inst_23268,null));
var state_23291__$1 = state_23291;
var statearr_23352_23496 = state_23291__$1;
(statearr_23352_23496[(2)] = inst_23269);

(statearr_23352_23496[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (43))){
var inst_23163 = (state_23291[(18)]);
var inst_23166 = cljs.core.seq.call(null,inst_23163);
var state_23291__$1 = state_23291;
var statearr_23353_23497 = state_23291__$1;
(statearr_23353_23497[(2)] = inst_23166);

(statearr_23353_23497[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (61))){
var state_23291__$1 = state_23291;
var statearr_23354_23498 = state_23291__$1;
(statearr_23354_23498[(2)] = (0));

(statearr_23354_23498[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (29))){
var inst_23144 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
if(cljs.core.truth_(inst_23144)){
var statearr_23355_23499 = state_23291__$1;
(statearr_23355_23499[(1)] = (30));

} else {
var statearr_23356_23500 = state_23291__$1;
(statearr_23356_23500[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (44))){
var inst_23164 = (state_23291[(33)]);
var state_23291__$1 = state_23291;
var statearr_23357_23501 = state_23291__$1;
(statearr_23357_23501[(2)] = inst_23164);

(statearr_23357_23501[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (93))){
var state_23291__$1 = state_23291;
var statearr_23358_23502 = state_23291__$1;
(statearr_23358_23502[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (6))){
var inst_23057 = (state_23291[(34)]);
var inst_23057__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_23059 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_23291__$1 = (function (){var statearr_23360 = state_23291;
(statearr_23360[(34)] = inst_23057__$1);

(statearr_23360[(35)] = inst_23059);

return statearr_23360;
})();
if(cljs.core.truth_(inst_23057__$1)){
var statearr_23361_23503 = state_23291__$1;
(statearr_23361_23503[(1)] = (9));

} else {
var statearr_23362_23504 = state_23291__$1;
(statearr_23362_23504[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (28))){
var inst_23117 = (state_23291[(11)]);
var state_23291__$1 = state_23291;
var statearr_23363_23505 = state_23291__$1;
(statearr_23363_23505[(2)] = inst_23117);

(statearr_23363_23505[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (64))){
var inst_23118 = (state_23291[(12)]);
var inst_23199 = (inst_23118 - (1));
var state_23291__$1 = state_23291;
var statearr_23364_23506 = state_23291__$1;
(statearr_23364_23506[(2)] = inst_23199);

(statearr_23364_23506[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (51))){
var inst_23117 = (state_23291[(11)]);
var inst_23177 = (state_23291[(2)]);
var state_23291__$1 = (function (){var statearr_23365 = state_23291;
(statearr_23365[(14)] = inst_23177);

return statearr_23365;
})();
if(cljs.core.truth_(inst_23117)){
var statearr_23366_23507 = state_23291__$1;
(statearr_23366_23507[(1)] = (52));

} else {
var statearr_23367_23508 = state_23291__$1;
(statearr_23367_23508[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (25))){
var inst_23117 = (state_23291[(11)]);
var state_23291__$1 = state_23291;
if(cljs.core.truth_(inst_23117)){
var statearr_23368_23509 = state_23291__$1;
(statearr_23368_23509[(1)] = (27));

} else {
var statearr_23369_23510 = state_23291__$1;
(statearr_23369_23510[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (34))){
var state_23291__$1 = state_23291;
var statearr_23370_23511 = state_23291__$1;
(statearr_23370_23511[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (17))){
var state_23291__$1 = state_23291;
var statearr_23372_23512 = state_23291__$1;
(statearr_23372_23512[(2)] = limit);

(statearr_23372_23512[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (3))){
var inst_23289 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23291__$1,inst_23289);
} else {
if((state_val_23292 === (12))){
var inst_23065 = (state_23291[(28)]);
var inst_23067 = cljs.core.keys.call(null,inst_23065);
var inst_23068 = cljs.core.first.call(null,inst_23067);
var inst_23069 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_23070 = cljs.core.vals.call(null,inst_23065);
var inst_23071 = cljs.core.first.call(null,inst_23070);
var inst_23072 = [headers,vars,inst_23071];
var inst_23073 = cljs.core.PersistentHashMap.fromArrays(inst_23069,inst_23072);
var inst_23074 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_23073,select_spec,limit,opts);
var state_23291__$1 = (function (){var statearr_23373 = state_23291;
(statearr_23373[(17)] = inst_23068);

return statearr_23373;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23291__$1,(15),inst_23074);
} else {
if((state_val_23292 === (2))){
var _ = (function (){var statearr_23374 = state_23291;
(statearr_23374[(4)] = cljs.core.cons.call(null,(5),(state_23291[(4)])));

return statearr_23374;
})();
var state_23291__$1 = state_23291;
if(cljs.core.truth_(groupBy)){
var statearr_23375_23513 = state_23291__$1;
(statearr_23375_23513[(1)] = (6));

} else {
var statearr_23376_23514 = state_23291__$1;
(statearr_23376_23514[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (66))){
var inst_23209 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
var statearr_23377_23515 = state_23291__$1;
(statearr_23377_23515[(2)] = inst_23209);

(statearr_23377_23515[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (23))){
var inst_23251 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
var statearr_23378_23516 = state_23291__$1;
(statearr_23378_23516[(2)] = inst_23251);

(statearr_23378_23516[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (47))){
var inst_23117 = (state_23291[(11)]);
var inst_23225 = (inst_23117 == null);
var state_23291__$1 = state_23291;
if(cljs.core.truth_(inst_23225)){
var statearr_23379_23517 = state_23291__$1;
(statearr_23379_23517[(1)] = (76));

} else {
var statearr_23380_23518 = state_23291__$1;
(statearr_23380_23518[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (35))){
var inst_23245 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
var statearr_23381_23519 = state_23291__$1;
(statearr_23381_23519[(2)] = inst_23245);

(statearr_23381_23519[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (82))){
var state_23291__$1 = state_23291;
var statearr_23382_23520 = state_23291__$1;
(statearr_23382_23520[(2)] = (1));

(statearr_23382_23520[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (76))){
var state_23291__$1 = state_23291;
var statearr_23383_23521 = state_23291__$1;
(statearr_23383_23521[(2)] = null);

(statearr_23383_23521[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (97))){
var inst_23280 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
var statearr_23384_23522 = state_23291__$1;
(statearr_23384_23522[(2)] = inst_23280);

(statearr_23384_23522[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (19))){
var inst_23109 = (state_23291[(36)]);
var state_23291__$1 = state_23291;
var statearr_23385_23523 = state_23291__$1;
(statearr_23385_23523[(2)] = inst_23109);

(statearr_23385_23523[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (57))){
var inst_23117 = (state_23291[(11)]);
var inst_23187 = (state_23291[(2)]);
var inst_23188 = (inst_23117 == null);
var state_23291__$1 = (function (){var statearr_23386 = state_23291;
(statearr_23386[(8)] = inst_23187);

return statearr_23386;
})();
if(cljs.core.truth_(inst_23188)){
var statearr_23387_23524 = state_23291__$1;
(statearr_23387_23524[(1)] = (58));

} else {
var statearr_23388_23525 = state_23291__$1;
(statearr_23388_23525[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (68))){
var state_23291__$1 = state_23291;
var statearr_23389_23526 = state_23291__$1;
(statearr_23389_23526[(2)] = null);

(statearr_23389_23526[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (11))){
var inst_23065 = (state_23291[(2)]);
var state_23291__$1 = (function (){var statearr_23391 = state_23291;
(statearr_23391[(28)] = inst_23065);

return statearr_23391;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_23392_23527 = state_23291__$1;
(statearr_23392_23527[(1)] = (12));

} else {
var statearr_23393_23528 = state_23291__$1;
(statearr_23393_23528[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (9))){
var inst_23057 = (state_23291[(34)]);
var inst_23059 = (state_23291[(35)]);
var inst_23061 = cljs.core.sorted_map_by.call(null,inst_23057);
var inst_23062 = cljs.core.into.call(null,inst_23061,inst_23059);
var state_23291__$1 = state_23291;
var statearr_23394_23529 = state_23291__$1;
(statearr_23394_23529[(2)] = inst_23062);

(statearr_23394_23529[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (5))){
var _ = (function (){var statearr_23395 = state_23291;
(statearr_23395[(4)] = cljs.core.rest.call(null,(state_23291[(4)])));

return statearr_23395;
})();
var state_23291__$1 = state_23291;
var ex23390 = (state_23291__$1[(2)]);
var statearr_23396_23530 = state_23291__$1;
(statearr_23396_23530[(5)] = ex23390);


if((ex23390 instanceof Error)){
var statearr_23397_23531 = state_23291__$1;
(statearr_23397_23531[(1)] = (4));

(statearr_23397_23531[(5)] = null);

} else {
throw ex23390;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (83))){
var state_23291__$1 = state_23291;
var statearr_23398_23532 = state_23291__$1;
(statearr_23398_23532[(2)] = limit);

(statearr_23398_23532[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (14))){
var inst_23253 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
var statearr_23399_23533 = state_23291__$1;
(statearr_23399_23533[(2)] = inst_23253);

(statearr_23399_23533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (45))){
var inst_23169 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
if(cljs.core.truth_(inst_23169)){
var statearr_23400_23534 = state_23291__$1;
(statearr_23400_23534[(1)] = (46));

} else {
var statearr_23401_23535 = state_23291__$1;
(statearr_23401_23535[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (53))){
var inst_23117 = (state_23291[(11)]);
var state_23291__$1 = state_23291;
var statearr_23402_23536 = state_23291__$1;
(statearr_23402_23536[(2)] = inst_23117);

(statearr_23402_23536[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (78))){
var inst_23118 = (state_23291[(12)]);
var inst_23230 = (state_23291[(2)]);
var inst_23231 = (inst_23118 <= (0));
var state_23291__$1 = (function (){var statearr_23403 = state_23291;
(statearr_23403[(37)] = inst_23230);

return statearr_23403;
})();
if(cljs.core.truth_(inst_23231)){
var statearr_23404_23537 = state_23291__$1;
(statearr_23404_23537[(1)] = (79));

} else {
var statearr_23405_23538 = state_23291__$1;
(statearr_23405_23538[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (26))){
var inst_23249 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
var statearr_23406_23539 = state_23291__$1;
(statearr_23406_23539[(2)] = inst_23249);

(statearr_23406_23539[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (16))){
var state_23291__$1 = state_23291;
var statearr_23407_23540 = state_23291__$1;
(statearr_23407_23540[(2)] = null);

(statearr_23407_23540[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (81))){
var inst_23230 = (state_23291[(37)]);
var inst_23128 = (state_23291[(9)]);
var inst_23163 = (state_23291[(18)]);
var inst_23132 = (state_23291[(20)]);
var inst_23129 = (state_23291[(21)]);
var inst_23119 = (state_23291[(10)]);
var inst_23236 = (state_23291[(2)]);
var inst_23237 = cljs.core.assoc.call(null,inst_23119,inst_23128,inst_23163);
var inst_23115 = inst_23129;
var inst_23116 = inst_23132;
var inst_23117 = inst_23230;
var inst_23118 = inst_23236;
var inst_23119__$1 = inst_23237;
var state_23291__$1 = (function (){var statearr_23410 = state_23291;
(statearr_23410[(12)] = inst_23118);

(statearr_23410[(22)] = inst_23115);

(statearr_23410[(23)] = inst_23116);

(statearr_23410[(11)] = inst_23117);

(statearr_23410[(10)] = inst_23119__$1);

return statearr_23410;
})();
var statearr_23411_23541 = state_23291__$1;
(statearr_23411_23541[(2)] = null);

(statearr_23411_23541[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (79))){
var state_23291__$1 = state_23291;
var statearr_23412_23542 = state_23291__$1;
(statearr_23412_23542[(2)] = (0));

(statearr_23412_23542[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (38))){
var inst_23117 = (state_23291[(11)]);
var inst_23132 = (state_23291[(20)]);
var inst_23129 = (state_23291[(21)]);
var inst_23119 = (state_23291[(10)]);
var inst_23154 = (state_23291[(2)]);
var tmp23408 = inst_23117;
var tmp23409 = inst_23119;
var inst_23115 = inst_23129;
var inst_23116 = inst_23132;
var inst_23117__$1 = tmp23408;
var inst_23118 = inst_23154;
var inst_23119__$1 = tmp23409;
var state_23291__$1 = (function (){var statearr_23413 = state_23291;
(statearr_23413[(12)] = inst_23118);

(statearr_23413[(22)] = inst_23115);

(statearr_23413[(23)] = inst_23116);

(statearr_23413[(11)] = inst_23117__$1);

(statearr_23413[(10)] = inst_23119__$1);

return statearr_23413;
})();
var statearr_23414_23543 = state_23291__$1;
(statearr_23414_23543[(2)] = null);

(statearr_23414_23543[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (87))){
var state_23291__$1 = state_23291;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_23415_23544 = state_23291__$1;
(statearr_23415_23544[(1)] = (92));

} else {
var statearr_23416_23545 = state_23291__$1;
(statearr_23416_23545[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (30))){
var inst_23119 = (state_23291[(10)]);
var state_23291__$1 = state_23291;
var statearr_23417_23546 = state_23291__$1;
(statearr_23417_23546[(2)] = inst_23119);

(statearr_23417_23546[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (73))){
var inst_23119 = (state_23291[(10)]);
var state_23291__$1 = state_23291;
var statearr_23418_23547 = state_23291__$1;
(statearr_23418_23547[(2)] = inst_23119);

(statearr_23418_23547[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (96))){
var state_23291__$1 = state_23291;
var statearr_23419_23548 = state_23291__$1;
(statearr_23419_23548[(2)] = null);

(statearr_23419_23548[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (10))){
var inst_23059 = (state_23291[(35)]);
var state_23291__$1 = state_23291;
var statearr_23420_23549 = state_23291__$1;
(statearr_23420_23549[(2)] = inst_23059);

(statearr_23420_23549[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (18))){
var inst_23109 = (state_23291[(36)]);
var inst_23108 = (state_23291[(2)]);
var inst_23109__$1 = offset;
var state_23291__$1 = (function (){var statearr_23421 = state_23291;
(statearr_23421[(25)] = inst_23108);

(statearr_23421[(36)] = inst_23109__$1);

return statearr_23421;
})();
if(cljs.core.truth_(inst_23109__$1)){
var statearr_23422_23550 = state_23291__$1;
(statearr_23422_23550[(1)] = (19));

} else {
var statearr_23423_23551 = state_23291__$1;
(statearr_23423_23551[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (52))){
var inst_23117 = (state_23291[(11)]);
var inst_23179 = ((0) < inst_23117);
var state_23291__$1 = state_23291;
var statearr_23424_23552 = state_23291__$1;
(statearr_23424_23552[(2)] = inst_23179);

(statearr_23424_23552[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (67))){
var inst_23187 = (state_23291[(8)]);
var inst_23118 = (state_23291[(12)]);
var inst_23133 = (state_23291[(27)]);
var inst_23202 = cljs.core.count.call(null,inst_23187);
var inst_23203 = (inst_23133 - inst_23202);
var inst_23204 = (inst_23118 - inst_23203);
var state_23291__$1 = state_23291;
var statearr_23425_23553 = state_23291__$1;
(statearr_23425_23553[(2)] = inst_23204);

(statearr_23425_23553[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (71))){
var inst_23187 = (state_23291[(8)]);
var inst_23215 = cljs.core.empty_QMARK_.call(null,inst_23187);
var state_23291__$1 = state_23291;
var statearr_23426_23554 = state_23291__$1;
(statearr_23426_23554[(2)] = inst_23215);

(statearr_23426_23554[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (42))){
var inst_23164 = (state_23291[(33)]);
var inst_23163 = (state_23291[(18)]);
var inst_23162 = (state_23291[(2)]);
var inst_23163__$1 = fluree.db.util.async.throw_err.call(null,inst_23162);
var inst_23164__$1 = cljs.core.coll_QMARK_.call(null,inst_23163__$1);
var state_23291__$1 = (function (){var statearr_23427 = state_23291;
(statearr_23427[(33)] = inst_23164__$1);

(statearr_23427[(18)] = inst_23163__$1);

return statearr_23427;
})();
if(inst_23164__$1){
var statearr_23428_23555 = state_23291__$1;
(statearr_23428_23555[(1)] = (43));

} else {
var statearr_23429_23556 = state_23291__$1;
(statearr_23429_23556[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (80))){
var inst_23118 = (state_23291[(12)]);
var inst_23234 = (inst_23118 - (1));
var state_23291__$1 = state_23291;
var statearr_23430_23557 = state_23291__$1;
(statearr_23430_23557[(2)] = inst_23234);

(statearr_23430_23557[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (37))){
var inst_23118 = (state_23291[(12)]);
var inst_23133 = (state_23291[(27)]);
var inst_23152 = (inst_23118 - inst_23133);
var state_23291__$1 = state_23291;
var statearr_23431_23558 = state_23291__$1;
(statearr_23431_23558[(2)] = inst_23152);

(statearr_23431_23558[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (63))){
var inst_23187 = (state_23291[(8)]);
var inst_23212 = (state_23291[(7)]);
var inst_23211 = (state_23291[(2)]);
var inst_23212__$1 = (inst_23187 == null);
var state_23291__$1 = (function (){var statearr_23432 = state_23291;
(statearr_23432[(7)] = inst_23212__$1);

(statearr_23432[(19)] = inst_23211);

return statearr_23432;
})();
if(cljs.core.truth_(inst_23212__$1)){
var statearr_23433_23559 = state_23291__$1;
(statearr_23433_23559[(1)] = (70));

} else {
var statearr_23434_23560 = state_23291__$1;
(statearr_23434_23560[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (94))){
var inst_23282 = (state_23291[(2)]);
var state_23291__$1 = state_23291;
var statearr_23435_23561 = state_23291__$1;
(statearr_23435_23561[(2)] = inst_23282);

(statearr_23435_23561[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (8))){
var inst_23286 = (state_23291[(2)]);
var _ = (function (){var statearr_23436 = state_23291;
(statearr_23436[(4)] = cljs.core.rest.call(null,(state_23291[(4)])));

return statearr_23436;
})();
var state_23291__$1 = state_23291;
var statearr_23437_23562 = state_23291__$1;
(statearr_23437_23562[(2)] = inst_23286);

(statearr_23437_23562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (49))){
var inst_23118 = (state_23291[(12)]);
var inst_23163 = (state_23291[(18)]);
var inst_23174 = cljs.core.drop.call(null,inst_23118,inst_23163);
var state_23291__$1 = state_23291;
var statearr_23438_23563 = state_23291__$1;
(statearr_23438_23563[(2)] = inst_23174);

(statearr_23438_23563[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23292 === (84))){
var inst_23258 = (state_23291[(2)]);
var inst_23259 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_23258,opts);
var state_23291__$1 = state_23291;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23291__$1,(85),inst_23259);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0 = (function (){
var statearr_23439 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23439[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__);

(statearr_23439[(1)] = (1));

return statearr_23439;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1 = (function (state_23291){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_23291);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23440){var ex__2730__auto__ = e23440;
var statearr_23441_23564 = state_23291;
(statearr_23441_23564[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_23291[(4)]))){
var statearr_23442_23565 = state_23291;
(statearr_23442_23565[(1)] = cljs.core.first.call(null,(state_23291[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23566 = state_23291;
state_23291 = G__23566;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__ = function(state_23291){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1.call(this,state_23291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23443 = f__2750__auto__.call(null);
(statearr_23443[(6)] = c__2749__auto__);

return statearr_23443;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Legacy ad-hoc query processor
 */
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,parsed_query,query_map){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23627){
var state_val_23628 = (state_23627[(1)]);
if((state_val_23628 === (7))){
var state_23627__$1 = state_23627;
var statearr_23629_23667 = state_23627__$1;
(statearr_23629_23667[(2)] = (0));

(statearr_23629_23667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (20))){
var inst_23611 = (state_23627[(2)]);
var state_23627__$1 = state_23627;
var statearr_23630_23668 = state_23627__$1;
(statearr_23630_23668[(2)] = inst_23611);

(statearr_23630_23668[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (1))){
var state_23627__$1 = state_23627;
var statearr_23631_23669 = state_23627__$1;
(statearr_23631_23669[(2)] = null);

(statearr_23631_23669[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (4))){
var inst_23567 = (state_23627[(2)]);
var state_23627__$1 = state_23627;
var statearr_23632_23670 = state_23627__$1;
(statearr_23632_23670[(2)] = inst_23567);

(statearr_23632_23670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (15))){
var inst_23598 = (state_23627[(7)]);
var state_23627__$1 = state_23627;
var statearr_23633_23671 = state_23627__$1;
(statearr_23633_23671[(2)] = inst_23598);

(statearr_23633_23671[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (21))){
var inst_23598 = (state_23627[(7)]);
var inst_23613 = (state_23627[(8)]);
var inst_23583 = (state_23627[(9)]);
var inst_23616 = (state_23627[(2)]);
var inst_23617 = fluree.db.util.async.throw_err.call(null,inst_23616);
var inst_23618 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query);
var inst_23619 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,inst_23613,inst_23598,inst_23617,inst_23618,inst_23583);
var state_23627__$1 = state_23627;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23627__$1,(22),inst_23619);
} else {
if((state_val_23628 === (13))){
var inst_23598 = (state_23627[(7)]);
var state_23627__$1 = state_23627;
if(cljs.core.truth_(inst_23598)){
var statearr_23634_23672 = state_23627__$1;
(statearr_23634_23672[(1)] = (15));

} else {
var statearr_23635_23673 = state_23627__$1;
(statearr_23635_23673[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (22))){
var inst_23621 = (state_23627[(2)]);
var inst_23622 = fluree.db.util.async.throw_err.call(null,inst_23621);
var _ = (function (){var statearr_23636 = state_23627;
(statearr_23636[(4)] = cljs.core.rest.call(null,(state_23627[(4)])));

return statearr_23636;
})();
var state_23627__$1 = state_23627;
var statearr_23637_23674 = state_23627__$1;
(statearr_23637_23674[(2)] = inst_23622);

(statearr_23637_23674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (6))){
var inst_23578 = (state_23627[(10)]);
var state_23627__$1 = state_23627;
var statearr_23638_23675 = state_23627__$1;
(statearr_23638_23675[(2)] = inst_23578);

(statearr_23638_23675[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (17))){
var inst_23606 = (state_23627[(2)]);
var state_23627__$1 = state_23627;
if(cljs.core.truth_(inst_23606)){
var statearr_23639_23676 = state_23627__$1;
(statearr_23639_23676[(1)] = (18));

} else {
var statearr_23640_23677 = state_23627__$1;
(statearr_23640_23677[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (3))){
var inst_23625 = (state_23627[(2)]);
var state_23627__$1 = state_23627;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23627__$1,inst_23625);
} else {
if((state_val_23628 === (12))){
var inst_23599 = (state_23627[(11)]);
var state_23627__$1 = state_23627;
var statearr_23641_23678 = state_23627__$1;
(statearr_23641_23678[(2)] = inst_23599);

(statearr_23641_23678[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (2))){
var inst_23578 = (state_23627[(10)]);
var _ = (function (){var statearr_23642 = state_23627;
(statearr_23642[(4)] = cljs.core.cons.call(null,(5),(state_23627[(4)])));

return statearr_23642;
})();
var inst_23574 = query_map;
var inst_23575 = cljs.core.__destructure_map.call(null,inst_23574);
var inst_23576 = cljs.core.get.call(null,inst_23575,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_23577 = cljs.core.get.call(null,inst_23575,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23578__$1 = cljs.core.get.call(null,inst_23575,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_23579 = cljs.core.get.call(null,inst_23575,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_23580 = cljs.core.get.call(null,inst_23575,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_23581 = cljs.core.get.call(null,inst_23575,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_23582 = cljs.core.get.call(null,inst_23575,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_23583 = cljs.core.get.call(null,inst_23575,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_23585 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)];
var state_23627__$1 = (function (){var statearr_23643 = state_23627;
(statearr_23643[(12)] = inst_23581);

(statearr_23643[(13)] = inst_23580);

(statearr_23643[(10)] = inst_23578__$1);

(statearr_23643[(14)] = inst_23582);

(statearr_23643[(15)] = inst_23579);

(statearr_23643[(9)] = inst_23583);

(statearr_23643[(16)] = inst_23577);

(statearr_23643[(17)] = inst_23576);

(statearr_23643[(18)] = inst_23585);

return statearr_23643;
})();
if(cljs.core.truth_(inst_23578__$1)){
var statearr_23644_23679 = state_23627__$1;
(statearr_23644_23679[(1)] = (6));

} else {
var statearr_23645_23680 = state_23627__$1;
(statearr_23645_23680[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (19))){
var state_23627__$1 = state_23627;
var statearr_23646_23681 = state_23627__$1;
(statearr_23646_23681[(2)] = null);

(statearr_23646_23681[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (11))){
var inst_23583 = (state_23627[(9)]);
var inst_23599 = (state_23627[(11)]);
var inst_23597 = (state_23627[(19)]);
var inst_23597__$1 = (state_23627[(2)]);
var inst_23598 = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(inst_23597__$1);
var inst_23599__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_23583);
var state_23627__$1 = (function (){var statearr_23648 = state_23627;
(statearr_23648[(7)] = inst_23598);

(statearr_23648[(11)] = inst_23599__$1);

(statearr_23648[(19)] = inst_23597__$1);

return statearr_23648;
})();
if(cljs.core.truth_(inst_23599__$1)){
var statearr_23649_23682 = state_23627__$1;
(statearr_23649_23682[(1)] = (12));

} else {
var statearr_23650_23683 = state_23627__$1;
(statearr_23650_23683[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (9))){
var inst_23592 = (state_23627[(20)]);
var inst_23594 = cljs.core.assoc.call(null,inst_23592,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var state_23627__$1 = state_23627;
var statearr_23651_23684 = state_23627__$1;
(statearr_23651_23684[(2)] = inst_23594);

(statearr_23651_23684[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (5))){
var _ = (function (){var statearr_23652 = state_23627;
(statearr_23652[(4)] = cljs.core.rest.call(null,(state_23627[(4)])));

return statearr_23652;
})();
var state_23627__$1 = state_23627;
var ex23647 = (state_23627__$1[(2)]);
var statearr_23653_23685 = state_23627__$1;
(statearr_23653_23685[(5)] = ex23647);


if((ex23647 instanceof Error)){
var statearr_23654_23686 = state_23627__$1;
(statearr_23654_23686[(1)] = (4));

(statearr_23654_23686[(5)] = null);

} else {
throw ex23647;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (14))){
var inst_23598 = (state_23627[(7)]);
var inst_23613 = (state_23627[(8)]);
var inst_23597 = (state_23627[(19)]);
var inst_23613__$1 = (state_23627[(2)]);
var inst_23614 = fluree.db.query.analytical.q.call(null,query_map,inst_23613__$1,inst_23598,db,inst_23597);
var state_23627__$1 = (function (){var statearr_23655 = state_23627;
(statearr_23655[(8)] = inst_23613__$1);

return statearr_23655;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23627__$1,(21),inst_23614);
} else {
if((state_val_23628 === (16))){
var inst_23583 = (state_23627[(9)]);
var inst_23604 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_23583);
var state_23627__$1 = state_23627;
var statearr_23656_23687 = state_23627__$1;
(statearr_23656_23687[(2)] = inst_23604);

(statearr_23656_23687[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (10))){
var inst_23592 = (state_23627[(20)]);
var state_23627__$1 = state_23627;
var statearr_23657_23688 = state_23627__$1;
(statearr_23657_23688[(2)] = inst_23592);

(statearr_23657_23688[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (18))){
var inst_23608 = cljs.core.volatile_BANG_.call(null,(0));
var state_23627__$1 = state_23627;
var statearr_23658_23689 = state_23627__$1;
(statearr_23658_23689[(2)] = inst_23608);

(statearr_23658_23689[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23628 === (8))){
var inst_23581 = (state_23627[(12)]);
var inst_23580 = (state_23627[(13)]);
var inst_23582 = (state_23627[(14)]);
var inst_23579 = (state_23627[(15)]);
var inst_23583 = (state_23627[(9)]);
var inst_23577 = (state_23627[(16)]);
var inst_23576 = (state_23627[(17)]);
var inst_23585 = (state_23627[(18)]);
var inst_23589 = (state_23627[(2)]);
var inst_23590 = [inst_23577,inst_23589,inst_23579,inst_23580,inst_23581,inst_23582];
var inst_23591 = cljs.core.PersistentHashMap.fromArrays(inst_23585,inst_23590);
var inst_23592 = cljs.core.merge.call(null,inst_23591,inst_23583);
var state_23627__$1 = (function (){var statearr_23659 = state_23627;
(statearr_23659[(20)] = inst_23592);

return statearr_23659;
})();
if(cljs.core.truth_(inst_23576)){
var statearr_23660_23690 = state_23627__$1;
(statearr_23660_23690[(1)] = (9));

} else {
var statearr_23661_23691 = state_23627__$1;
(statearr_23661_23691[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0 = (function (){
var statearr_23662 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23662[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__);

(statearr_23662[(1)] = (1));

return statearr_23662;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1 = (function (state_23627){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_23627);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23663){var ex__2730__auto__ = e23663;
var statearr_23664_23692 = state_23627;
(statearr_23664_23692[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_23627[(4)]))){
var statearr_23665_23693 = state_23627;
(statearr_23665_23693[(1)] = cljs.core.first.call(null,(state_23627[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23694 = state_23627;
state_23627 = G__23694;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__ = function(state_23627){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1.call(this,state_23627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23666 = f__2750__auto__.call(null);
(statearr_23666[(6)] = c__2749__auto__);

return statearr_23666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns already cached query from cache if available, else
 *   executes and stores query into cache.
 */
fluree.db.query.fql.cache_query = (function fluree$db$query$fql$cache_query(p__23695,p__23696){
var map__23697 = p__23695;
var map__23697__$1 = cljs.core.__destructure_map.call(null,map__23697);
var db = map__23697__$1;
var network = cljs.core.get.call(null,map__23697__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__23697__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var block = cljs.core.get.call(null,map__23697__$1,new cljs.core.Keyword(null,"block","block",664686210));
var auth = cljs.core.get.call(null,map__23697__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var conn = cljs.core.get.call(null,map__23697__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__23698 = p__23696;
var map__23698__$1 = cljs.core.__destructure_map.call(null,map__23698);
var query_map = map__23698__$1;
var opts = cljs.core.get.call(null,map__23698__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var oc = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
var query_STAR_ = cljs.core.update.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.dissoc,new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var cache_key = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510),network,ledger_id,block,auth,query_STAR_], null);
return oc.call(null,cache_key,(function (_){
var pc = cljs.core.async.promise_chan.call(null);
var c__2749__auto___23715 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23708){
var state_val_23709 = (state_23708[(1)]);
if((state_val_23709 === (1))){
var inst_23699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23700 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"cache","cache",-1237023054)];
var inst_23701 = (new cljs.core.PersistentVector(null,2,(5),inst_23699,inst_23700,null));
var inst_23702 = cljs.core.assoc_in.call(null,query_map,inst_23701,false);
var inst_23703 = fluree.db.query.fql.query.call(null,db,inst_23702);
var state_23708__$1 = state_23708;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23708__$1,(2),inst_23703);
} else {
if((state_val_23709 === (2))){
var inst_23705 = (state_23708[(2)]);
var inst_23706 = cljs.core.async.put_BANG_.call(null,pc,inst_23705);
var state_23708__$1 = state_23708;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23708__$1,inst_23706);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0 = (function (){
var statearr_23710 = [null,null,null,null,null,null,null];
(statearr_23710[(0)] = fluree$db$query$fql$cache_query_$_state_machine__2727__auto__);

(statearr_23710[(1)] = (1));

return statearr_23710;
});
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1 = (function (state_23708){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_23708);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23711){var ex__2730__auto__ = e23711;
var statearr_23712_23716 = state_23708;
(statearr_23712_23716[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_23708[(4)]))){
var statearr_23713_23717 = state_23708;
(statearr_23713_23717[(1)] = cljs.core.first.call(null,(state_23708[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23718 = state_23708;
state_23708 = G__23718;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__ = function(state_23708){
switch(arguments.length){
case 0:
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1.call(this,state_23708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0;
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1;
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23714 = f__2750__auto__.call(null);
(statearr_23714[(6)] = c__2749__auto___23715);

return statearr_23714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));


return pc;
}));
});
/**
 * Returns true if query was requested to run from the cache.
 */
fluree.db.query.fql.cache_QMARK_ = (function fluree$db$query$fql$cache_QMARK_(p__23719){
var map__23720 = p__23719;
var map__23720__$1 = cljs.core.__destructure_map.call(null,map__23720);
var _query_map = map__23720__$1;
var opts = cljs.core.get.call(null,map__23720__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return false;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.call(null,"Running query:",cljs.core.pr_str.call(null,query_map));

if(fluree.db.query.fql.cache_QMARK_.call(null,query_map)){
return fluree.db.query.fql.cache_query.call(null,db,query_map);
} else {
var parsed_query = fluree.db.query.analytical_parse.parse.call(null,db,query_map);
var db_STAR_ = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"ctx-cache","ctx-cache",-391738418),cljs.core.volatile_BANG_.call(null,cljs.core.PersistentArrayMap.EMPTY));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044),new cljs.core.Keyword(null,"strategy","strategy",-1471631918).cljs$core$IFn$_invoke$arity$1(parsed_query))){
return fluree.db.query.subject_crawl.core.simple_subject_crawl.call(null,db_STAR_,parsed_query);
} else {
return fluree.db.query.fql.ad_hoc_query.call(null,db_STAR_,parsed_query,query_map);
}
}
});
