// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__17798_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17798_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__17802 = coll;
var vec__17803 = G__17802;
var seq__17804 = cljs.core.seq.call(null,vec__17803);
var first__17805 = cljs.core.first.call(null,seq__17804);
var seq__17804__$1 = cljs.core.next.call(null,seq__17804);
var clause = first__17805;
var r = seq__17804__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__17802__$1 = G__17802;
var res__$1 = res;
while(true){
var vec__17809 = G__17802__$1;
var seq__17810 = cljs.core.seq.call(null,vec__17809);
var first__17811 = cljs.core.first.call(null,seq__17810);
var seq__17810__$1 = cljs.core.next.call(null,seq__17810);
var clause__$1 = first__17811;
var r__$1 = seq__17810__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__17812 = r__$1;
var G__17813 = cljs.core.conj.call(null,res__$2,clause__$1);
G__17802__$1 = G__17812;
res__$1 = G__17813;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.call(null,(function (res,p__17814){
var map__17815 = p__17814;
var map__17815__$1 = cljs.core.__destructure_map.call(null,map__17815);
var optional = cljs.core.get.call(null,map__17815__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.call(null,res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__17819 = coll;
var vec__17820 = G__17819;
var seq__17821 = cljs.core.seq.call(null,vec__17820);
var first__17822 = cljs.core.first.call(null,seq__17821);
var seq__17821__$1 = cljs.core.next.call(null,seq__17821);
var clause = first__17822;
var r = seq__17821__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__17819__$1 = G__17819;
var res__$1 = res;
while(true){
var vec__17826 = G__17819__$1;
var seq__17827 = cljs.core.seq.call(null,vec__17826);
var first__17828 = cljs.core.first.call(null,seq__17827);
var seq__17827__$1 = cljs.core.next.call(null,seq__17827);
var clause__$1 = first__17828;
var r__$1 = seq__17827__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__17829 = r__$1;
var G__17830 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__17819__$1 = G__17829;
res__$1 = G__17830;
continue;
} else {
var G__17831 = r__$1;
var G__17832 = res__$2;
G__17819__$1 = G__17831;
res__$1 = G__17832;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__17836 = coll;
var vec__17837 = G__17836;
var seq__17838 = cljs.core.seq.call(null,vec__17837);
var first__17839 = cljs.core.first.call(null,seq__17838);
var seq__17838__$1 = cljs.core.next.call(null,seq__17838);
var clause = first__17839;
var r = seq__17838__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__17836__$1 = G__17836;
var res__$1 = res;
while(true){
var vec__17843 = G__17836__$1;
var seq__17844 = cljs.core.seq.call(null,vec__17843);
var first__17845 = cljs.core.first.call(null,seq__17844);
var seq__17844__$1 = cljs.core.next.call(null,seq__17844);
var clause__$1 = first__17845;
var r__$1 = seq__17844__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__17846 = r__$1;
var G__17847 = res__$2;
G__17836__$1 = G__17846;
res__$1 = G__17847;
continue;
} else {
var G__17848 = r__$1;
var G__17849 = cljs.core.conj.call(null,res__$2,clause__$1);
G__17836__$1 = G__17848;
res__$1 = G__17849;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__17852 = clause;
var G__17852__$1 = ((cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause)))?cljs.core.drop.call(null,(1),G__17852):G__17852);
var G__17852__$2 = clojure.string.join.call(null," ",G__17852__$1)
;
var G__17852__$3 = (function (p1__17850_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17850_SHARP_)," ."].join('');
}).call(null,G__17852__$2)
;
if(cljs.core.truth_(optional_QMARK_)){
return (function (p1__17851_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17851_SHARP_),"}"].join('');
}).call(null,G__17852__$3);
} else {
return G__17852__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__17856 = opts;
var map__17856__$1 = cljs.core.__destructure_map.call(null,map__17856);
var limit = cljs.core.get.call(null,map__17856__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__17856__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__17856__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__17856__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__17856__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__17853_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17853_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__17854_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__17854_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__17855_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__17855_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = language;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17870){
var state_val_17871 = (state_17870[(1)]);
if((state_val_17871 === (1))){
var inst_17857 = fluree.db.util.core.url_encode.call(null,query);
var inst_17858 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17857)].join('');
var inst_17859 = ["User-Agent","Accept"];
var inst_17860 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_17861 = cljs.core.PersistentHashMap.fromArrays(inst_17859,inst_17860);
var inst_17862 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_17863 = [inst_17861,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_17864 = cljs.core.PersistentHashMap.fromArrays(inst_17862,inst_17863);
var inst_17865 = fluree.db.util.xhttp.get.call(null,inst_17858,inst_17864);
var state_17870__$1 = state_17870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17870__$1,(2),inst_17865);
} else {
if((state_val_17871 === (2))){
var inst_17867 = (state_17870[(2)]);
var inst_17868 = fluree.db.util.async.throw_err.call(null,inst_17867);
var state_17870__$1 = state_17870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17870__$1,inst_17868);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0 = (function (){
var statearr_17872 = [null,null,null,null,null,null,null];
(statearr_17872[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__);

(statearr_17872[(1)] = (1));

return statearr_17872;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1 = (function (state_17870){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_17870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17873){var ex__2730__auto__ = e17873;
var statearr_17874_17877 = state_17870;
(statearr_17874_17877[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_17870[(4)]))){
var statearr_17875_17878 = state_17870;
(statearr_17875_17878[(1)] = cljs.core.first.call(null,(state_17870[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17879 = state_17870;
state_17870 = G__17879;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__ = function(state_17870){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1.call(this,state_17870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17876 = f__2750__auto__.call(null);
(statearr_17876[(6)] = c__2749__auto__);

return statearr_17876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17897){
var state_val_17898 = (state_17897[(1)]);
if((state_val_17898 === (1))){
var inst_17880 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_17897__$1 = state_17897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17897__$1,(2),inst_17880);
} else {
if((state_val_17898 === (2))){
var inst_17883 = (state_17897[(7)]);
var inst_17882 = (state_17897[(2)]);
var inst_17883__$1 = fluree.db.util.async.throw_err.call(null,inst_17882);
var inst_17884 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_17883__$1);
var inst_17885 = cljs.core.not_EQ_.call(null,(200),inst_17884);
var state_17897__$1 = (function (){var statearr_17899 = state_17897;
(statearr_17899[(7)] = inst_17883__$1);

return statearr_17899;
})();
if(inst_17885){
var statearr_17900_17909 = state_17897__$1;
(statearr_17900_17909[(1)] = (3));

} else {
var statearr_17901_17910 = state_17897__$1;
(statearr_17901_17910[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17898 === (3))){
var inst_17883 = (state_17897[(7)]);
var state_17897__$1 = state_17897;
var statearr_17902_17911 = state_17897__$1;
(statearr_17902_17911[(2)] = inst_17883);

(statearr_17902_17911[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17898 === (4))){
var inst_17883 = (state_17897[(7)]);
var inst_17888 = (function (){var body = inst_17883;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_17889 = cljs.core.second.call(null,inst_17883);
var inst_17890 = cljs.core.second.call(null,inst_17889);
var inst_17891 = cljs.core.first.call(null,inst_17890);
var inst_17892 = cljs.core.second.call(null,inst_17891);
var inst_17893 = cljs.core.mapv.call(null,inst_17888,inst_17892);
var state_17897__$1 = state_17897;
var statearr_17903_17912 = state_17897__$1;
(statearr_17903_17912[(2)] = inst_17893);

(statearr_17903_17912[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17898 === (5))){
var inst_17895 = (state_17897[(2)]);
var state_17897__$1 = state_17897;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17897__$1,inst_17895);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0 = (function (){
var statearr_17904 = [null,null,null,null,null,null,null,null];
(statearr_17904[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__);

(statearr_17904[(1)] = (1));

return statearr_17904;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1 = (function (state_17897){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_17897);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17905){var ex__2730__auto__ = e17905;
var statearr_17906_17913 = state_17897;
(statearr_17906_17913[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_17897[(4)]))){
var statearr_17907_17914 = state_17897;
(statearr_17907_17914[(1)] = cljs.core.first.call(null,(state_17897[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17915 = state_17897;
state_17897 = G__17915;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__ = function(state_17897){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1.call(this,state_17897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17908 = f__2750__auto__.call(null);
(statearr_17908[(6)] = c__2749__auto__);

return statearr_17908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__17916_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17916_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__17917_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17917_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__17918_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__17918_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17964){
var state_val_17965 = (state_17964[(1)]);
if((state_val_17965 === (7))){
var inst_17929 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_17964__$1 = state_17964;
var statearr_17966_17994 = state_17964__$1;
(statearr_17966_17994[(2)] = inst_17929);

(statearr_17966_17994[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17965 === (1))){
var state_17964__$1 = state_17964;
var statearr_17967_17995 = state_17964__$1;
(statearr_17967_17995[(2)] = null);

(statearr_17967_17995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17965 === (4))){
var inst_17919 = (state_17964[(2)]);
var state_17964__$1 = state_17964;
var statearr_17968_17996 = state_17964__$1;
(statearr_17968_17996[(2)] = inst_17919);

(statearr_17968_17996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17965 === (15))){
var inst_17937 = (state_17964[(7)]);
var inst_17938 = (state_17964[(8)]);
var inst_17943 = (state_17964[(9)]);
var inst_17948 = (state_17964[(2)]);
var inst_17949 = cljs.core.subs.call(null,inst_17943,(0),inst_17948);
var inst_17950 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17951 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_17937);
var inst_17952 = [inst_17938,inst_17951];
var inst_17953 = cljs.core.PersistentHashMap.fromArrays(inst_17950,inst_17952);
var inst_17954 = cljs.core.ex_info.call(null,inst_17949,inst_17953);
var inst_17955 = (function(){throw inst_17954})();
var state_17964__$1 = state_17964;
var statearr_17969_17997 = state_17964__$1;
(statearr_17969_17997[(2)] = inst_17955);

(statearr_17969_17997[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17965 === (13))){
var inst_17942 = (state_17964[(10)]);
var state_17964__$1 = state_17964;
var statearr_17970_17998 = state_17964__$1;
(statearr_17970_17998[(2)] = inst_17942);

(statearr_17970_17998[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17965 === (6))){
var state_17964__$1 = state_17964;
var statearr_17971_17999 = state_17964__$1;
(statearr_17971_17999[(2)] = null);

(statearr_17971_17999[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17965 === (3))){
var inst_17962 = (state_17964[(2)]);
var state_17964__$1 = state_17964;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17964__$1,inst_17962);
} else {
if((state_val_17965 === (12))){
var inst_17959 = (state_17964[(2)]);
var _ = (function (){var statearr_17972 = state_17964;
(statearr_17972[(4)] = cljs.core.rest.call(null,(state_17964[(4)])));

return statearr_17972;
})();
var state_17964__$1 = state_17964;
var statearr_17973_18000 = state_17964__$1;
(statearr_17973_18000[(2)] = inst_17959);

(statearr_17973_18000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17965 === (2))){
var _ = (function (){var statearr_17974 = state_17964;
(statearr_17974[(4)] = cljs.core.cons.call(null,(5),(state_17964[(4)])));

return statearr_17974;
})();
var inst_17926 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_17964__$1 = state_17964;
if(inst_17926){
var statearr_17975_18001 = state_17964__$1;
(statearr_17975_18001[(1)] = (6));

} else {
var statearr_17976_18002 = state_17964__$1;
(statearr_17976_18002[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17965 === (11))){
var inst_17937 = (state_17964[(7)]);
var inst_17957 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_17937,all_vars);
var state_17964__$1 = state_17964;
var statearr_17978_18003 = state_17964__$1;
(statearr_17978_18003[(2)] = inst_17957);

(statearr_17978_18003[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17965 === (9))){
var inst_17937 = (state_17964[(7)]);
var inst_17938 = (state_17964[(8)]);
var inst_17935 = (state_17964[(2)]);
var inst_17936 = fluree.db.util.async.throw_err.call(null,inst_17935);
var inst_17937__$1 = cljs.core.__destructure_map.call(null,inst_17936);
var inst_17938__$1 = cljs.core.get.call(null,inst_17937__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_17939 = cljs.core.get.call(null,inst_17937__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_17940 = cljs.core._EQ_.call(null,(400),inst_17938__$1);
var state_17964__$1 = (function (){var statearr_17979 = state_17964;
(statearr_17979[(7)] = inst_17937__$1);

(statearr_17979[(8)] = inst_17938__$1);

(statearr_17979[(11)] = inst_17939);

return statearr_17979;
})();
if(inst_17940){
var statearr_17980_18004 = state_17964__$1;
(statearr_17980_18004[(1)] = (10));

} else {
var statearr_17981_18005 = state_17964__$1;
(statearr_17981_18005[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17965 === (5))){
var _ = (function (){var statearr_17982 = state_17964;
(statearr_17982[(4)] = cljs.core.rest.call(null,(state_17964[(4)])));

return statearr_17982;
})();
var state_17964__$1 = state_17964;
var ex17977 = (state_17964__$1[(2)]);
var statearr_17983_18006 = state_17964__$1;
(statearr_17983_18006[(5)] = ex17977);


if((ex17977 instanceof Error)){
var statearr_17984_18007 = state_17964__$1;
(statearr_17984_18007[(1)] = (4));

(statearr_17984_18007[(5)] = null);

} else {
throw ex17977;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17965 === (14))){
var state_17964__$1 = state_17964;
var statearr_17985_18008 = state_17964__$1;
(statearr_17985_18008[(2)] = (1000));

(statearr_17985_18008[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17965 === (10))){
var inst_17937 = (state_17964[(7)]);
var inst_17942 = (state_17964[(10)]);
var inst_17939 = (state_17964[(11)]);
var inst_17942__$1 = cljs.core.count.call(null,inst_17939);
var inst_17943 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_17937);
var inst_17944 = (inst_17942__$1 < (1000));
var state_17964__$1 = (function (){var statearr_17986 = state_17964;
(statearr_17986[(9)] = inst_17943);

(statearr_17986[(10)] = inst_17942__$1);

return statearr_17986;
})();
if(cljs.core.truth_(inst_17944)){
var statearr_17987_18009 = state_17964__$1;
(statearr_17987_18009[(1)] = (13));

} else {
var statearr_17988_18010 = state_17964__$1;
(statearr_17988_18010[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17965 === (8))){
var inst_17931 = (state_17964[(2)]);
var inst_17932 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_17931,optional_clauses);
var inst_17933 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_17932);
var state_17964__$1 = state_17964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17964__$1,(9),inst_17933);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_17989 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17989[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__);

(statearr_17989[(1)] = (1));

return statearr_17989;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1 = (function (state_17964){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_17964);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17990){var ex__2730__auto__ = e17990;
var statearr_17991_18011 = state_17964;
(statearr_17991_18011[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_17964[(4)]))){
var statearr_17992_18012 = state_17964;
(statearr_17992_18012[(1)] = cljs.core.first.call(null,(state_17964[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18013 = state_17964;
state_17964 = G__18013;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__ = function(state_17964){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1.call(this,state_17964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17993 = f__2750__auto__.call(null);
(statearr_17993[(6)] = c__2749__auto__);

return statearr_17993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
