// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.query.analytical_parse');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e18016){var e = e18016;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__18017_SHARP_){
var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__18017_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__18017_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__18017_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (((cljs.core.not.call(null,key_as_var)) && (((cljs.core.not_EQ_.call(null,"_id",key)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__18018_SHARP_){
return cljs.core.conj.call(null,p1__18018_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__18019_SHARP_){
return cljs.core.conj.call(null,p1__18019_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.call(null,idx,(2));
if(and__4251__auto__){
return fluree.db.query.analytical_parse.query_fn_QMARK_.call(null,key);
} else {
return and__4251__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__4253__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__18024 = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__18024,(0),null);
var _ = cljs.core.nth.call(null,vec__18024,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__18020_SHARP_){
return cljs.core.conj.call(null,p1__18020_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.call(null,idx,(1));
if(and__4251__auto__){
return cljs.core.re_find.call(null,/\+/,key);
} else {
return and__4251__auto__;
}
})())){
var vec__18027 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__18027,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__18027,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4253__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__18021_SHARP_){
return cljs.core.conj.call(null,p1__18021_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__18022_SHARP_){
return cljs.core.conj.call(null,p1__18022_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__18023_SHARP_){
return cljs.core.conj.call(null,p1__18023_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__18030_SHARP_){
return cljs.core.nth.call(null,array,p1__18030_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (add_amount > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fuel;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__4251__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5802__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__18033,optional_QMARK_,fuel,max_fuel){
var map__18034 = p__18033;
var map__18034__$1 = cljs.core.__destructure_map.call(null,map__18034);
var res = map__18034__$1;
var vars = cljs.core.get.call(null,map__18034__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18100){
var state_val_18101 = (state_18100[(1)]);
if((state_val_18101 === (7))){
var inst_18089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18090 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_18091 = cljs.core.conj.call(null,inst_18090,clause);
var inst_18092 = [null,inst_18091];
var inst_18093 = (new cljs.core.PersistentVector(null,2,(5),inst_18089,inst_18092,null));
var state_18100__$1 = state_18100;
var statearr_18102_18130 = state_18100__$1;
(statearr_18102_18130[(2)] = inst_18093);

(statearr_18102_18130[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18101 === (1))){
var state_18100__$1 = state_18100;
var statearr_18103_18131 = state_18100__$1;
(statearr_18103_18131[(2)] = null);

(statearr_18103_18131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18101 === (4))){
var inst_18035 = (state_18100[(2)]);
var state_18100__$1 = state_18100;
var statearr_18104_18132 = state_18100__$1;
(statearr_18104_18132[(2)] = inst_18035);

(statearr_18104_18132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18101 === (15))){
var inst_18078 = (state_18100[(2)]);
var inst_18079 = fluree.db.util.async.throw_err.call(null,inst_18078);
var inst_18080 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_18079);
var inst_18081 = cljs.core.count.call(null,inst_18080);
var inst_18082 = fluree.db.query.analytical.add_fuel.call(null,inst_18081,fuel,max_fuel);
var inst_18083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18084 = [inst_18079,r];
var inst_18085 = (new cljs.core.PersistentVector(null,2,(5),inst_18083,inst_18084,null));
var state_18100__$1 = (function (){var statearr_18105 = state_18100;
(statearr_18105[(7)] = inst_18082);

return statearr_18105;
})();
var statearr_18106_18133 = state_18100__$1;
(statearr_18106_18133[(2)] = inst_18085);

(statearr_18106_18133[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18101 === (13))){
var inst_18044 = (state_18100[(8)]);
var inst_18057 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_18058 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses.call(null,inst_18057);
var inst_18059 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_18044);
var inst_18060 = cljs.core.apply.call(null,cljs.core.concat,inst_18059);
var inst_18061 = cljs.core.set.call(null,inst_18060);
var inst_18062 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_18058);
var inst_18063 = cljs.core.apply.call(null,cljs.core.concat,inst_18062);
var inst_18064 = cljs.core.into.call(null,inst_18061,inst_18063);
var inst_18065 = (function (){var all_wd = inst_18044;
var optional = inst_18058;
var all_wd_vars = inst_18061;
var all_vars = inst_18064;
return (function (p1__18031_SHARP_){
return all_vars.call(null,p1__18031_SHARP_);
});
})();
var inst_18066 = cljs.core.keys.call(null,vars);
var inst_18067 = cljs.core.map.call(null,inst_18065,inst_18066);
var inst_18068 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_18067);
var inst_18069 = cljs.core.set.call(null,inst_18068);
var inst_18070 = (function (){var all_wd = inst_18044;
var optional = inst_18058;
var all_wd_vars = inst_18061;
var all_vars = inst_18064;
var intersecting_vars = inst_18069;
return (function (p1__18032_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__18032_SHARP_);
});
})();
var inst_18071 = cljs.core.map.call(null,inst_18070,inst_18044);
var inst_18072 = cljs.core.apply.call(null,cljs.core.concat,inst_18071);
var inst_18073 = fluree.db.query.analytical.select_from_tuples.call(null,inst_18072,res);
var inst_18074 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_18044,inst_18069,vars);
var inst_18075 = cljs.core.remove.call(null,inst_18069,inst_18064);
var inst_18076 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_18074,inst_18072,inst_18073,inst_18075,inst_18058);
var state_18100__$1 = state_18100;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18100__$1,(15),inst_18076);
} else {
if((state_val_18101 === (6))){
var inst_18045 = (state_18100[(9)]);
var inst_18043 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_18044 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_18043);
var inst_18045__$1 = optional_QMARK_;
var state_18100__$1 = (function (){var statearr_18107 = state_18100;
(statearr_18107[(9)] = inst_18045__$1);

(statearr_18107[(8)] = inst_18044);

return statearr_18107;
})();
if(cljs.core.truth_(inst_18045__$1)){
var statearr_18108_18134 = state_18100__$1;
(statearr_18108_18134[(1)] = (9));

} else {
var statearr_18109_18135 = state_18100__$1;
(statearr_18109_18135[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18101 === (3))){
var inst_18098 = (state_18100[(2)]);
var state_18100__$1 = state_18100;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18100__$1,inst_18098);
} else {
if((state_val_18101 === (12))){
var inst_18053 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18054 = [null,r];
var inst_18055 = (new cljs.core.PersistentVector(null,2,(5),inst_18053,inst_18054,null));
var state_18100__$1 = state_18100;
var statearr_18110_18136 = state_18100__$1;
(statearr_18110_18136[(2)] = inst_18055);

(statearr_18110_18136[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18101 === (2))){
var _ = (function (){var statearr_18111 = state_18100;
(statearr_18111[(4)] = cljs.core.cons.call(null,(5),(state_18100[(4)])));

return statearr_18111;
})();
var inst_18041 = (r == null);
var state_18100__$1 = state_18100;
if(cljs.core.truth_(inst_18041)){
var statearr_18112_18137 = state_18100__$1;
(statearr_18112_18137[(1)] = (6));

} else {
var statearr_18113_18138 = state_18100__$1;
(statearr_18113_18138[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18101 === (11))){
var inst_18051 = (state_18100[(2)]);
var state_18100__$1 = state_18100;
if(cljs.core.truth_(inst_18051)){
var statearr_18115_18139 = state_18100__$1;
(statearr_18115_18139[(1)] = (12));

} else {
var statearr_18116_18140 = state_18100__$1;
(statearr_18116_18140[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18101 === (9))){
var inst_18044 = (state_18100[(8)]);
var inst_18047 = cljs.core.empty_QMARK_.call(null,inst_18044);
var inst_18048 = (!(inst_18047));
var state_18100__$1 = state_18100;
var statearr_18117_18141 = state_18100__$1;
(statearr_18117_18141[(2)] = inst_18048);

(statearr_18117_18141[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18101 === (5))){
var _ = (function (){var statearr_18118 = state_18100;
(statearr_18118[(4)] = cljs.core.rest.call(null,(state_18100[(4)])));

return statearr_18118;
})();
var state_18100__$1 = state_18100;
var ex18114 = (state_18100__$1[(2)]);
var statearr_18119_18142 = state_18100__$1;
(statearr_18119_18142[(5)] = ex18114);


if((ex18114 instanceof Error)){
var statearr_18120_18143 = state_18100__$1;
(statearr_18120_18143[(1)] = (4));

(statearr_18120_18143[(5)] = null);

} else {
throw ex18114;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18101 === (14))){
var inst_18087 = (state_18100[(2)]);
var state_18100__$1 = state_18100;
var statearr_18121_18144 = state_18100__$1;
(statearr_18121_18144[(2)] = inst_18087);

(statearr_18121_18144[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18101 === (10))){
var inst_18045 = (state_18100[(9)]);
var state_18100__$1 = state_18100;
var statearr_18122_18145 = state_18100__$1;
(statearr_18122_18145[(2)] = inst_18045);

(statearr_18122_18145[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18101 === (8))){
var inst_18095 = (state_18100[(2)]);
var _ = (function (){var statearr_18123 = state_18100;
(statearr_18123[(4)] = cljs.core.rest.call(null,(state_18100[(4)])));

return statearr_18123;
})();
var state_18100__$1 = state_18100;
var statearr_18124_18146 = state_18100__$1;
(statearr_18124_18146[(2)] = inst_18095);

(statearr_18124_18146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_18125 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18125[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__);

(statearr_18125[(1)] = (1));

return statearr_18125;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1 = (function (state_18100){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_18100);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18126){var ex__2730__auto__ = e18126;
var statearr_18127_18147 = state_18100;
(statearr_18127_18147[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_18100[(4)]))){
var statearr_18128_18148 = state_18100;
(statearr_18128_18148[(1)] = cljs.core.first.call(null,(state_18100[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18149 = state_18100;
state_18100 = G__18149;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__ = function(state_18100){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1.call(this,state_18100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18129 = f__2750__auto__.call(null);
(statearr_18129[(6)] = c__2749__auto__);

return statearr_18129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(ledger_id){
return cljs.core.re_find.call(null,/[a-z]+/,ledger_id);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(ledger_id){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,ledger_id);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__18151 = arguments.length;
switch (G__18151) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18245){
var state_val_18246 = (state_18245[(1)]);
if((state_val_18246 === (7))){
var inst_18158 = (state_18245[(7)]);
var inst_18168 = clojure.string.starts_with_QMARK_.call(null,inst_18158,"$fdb");
var state_18245__$1 = state_18245;
if(inst_18168){
var statearr_18247_18296 = state_18245__$1;
(statearr_18247_18296[(1)] = (9));

} else {
var statearr_18248_18297 = state_18245__$1;
(statearr_18248_18297[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (20))){
var state_18245__$1 = state_18245;
var statearr_18249_18298 = state_18245__$1;
(statearr_18249_18298[(2)] = null);

(statearr_18249_18298[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (27))){
var inst_18208 = (state_18245[(8)]);
var state_18245__$1 = state_18245;
var statearr_18250_18299 = state_18245__$1;
(statearr_18250_18299[(2)] = inst_18208);

(statearr_18250_18299[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (1))){
var state_18245__$1 = state_18245;
var statearr_18251_18300 = state_18245__$1;
(statearr_18251_18300[(2)] = null);

(statearr_18251_18300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (24))){
var inst_18231 = (state_18245[(2)]);
var state_18245__$1 = state_18245;
var statearr_18252_18301 = state_18245__$1;
(statearr_18252_18301[(2)] = inst_18231);

(statearr_18252_18301[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (4))){
var inst_18152 = (state_18245[(2)]);
var state_18245__$1 = state_18245;
var statearr_18253_18302 = state_18245__$1;
(statearr_18253_18302[(2)] = inst_18152);

(statearr_18253_18302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (15))){
var inst_18175 = (state_18245[(9)]);
var inst_18181 = (state_18245[(2)]);
var inst_18182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18183 = cljs.core.PersistentVector.EMPTY;
var inst_18184 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_18185 = cljs.core.into.call(null,inst_18183,inst_18184);
var inst_18186 = [inst_18175,inst_18185];
var inst_18187 = (new cljs.core.PersistentVector(null,2,(5),inst_18182,inst_18186,null));
var state_18245__$1 = (function (){var statearr_18254 = state_18245;
(statearr_18254[(10)] = inst_18181);

return statearr_18254;
})();
var statearr_18255_18303 = state_18245__$1;
(statearr_18255_18303[(2)] = inst_18187);

(statearr_18255_18303[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (21))){
var inst_18234 = (state_18245[(2)]);
var state_18245__$1 = state_18245;
var statearr_18256_18304 = state_18245__$1;
(statearr_18256_18304[(2)] = inst_18234);

(statearr_18256_18304[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (13))){
var inst_18175 = (state_18245[(9)]);
var inst_18178 = (function(){throw inst_18175})();
var state_18245__$1 = state_18245;
var statearr_18257_18305 = state_18245__$1;
(statearr_18257_18305[(2)] = inst_18178);

(statearr_18257_18305[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (22))){
var inst_18197 = (state_18245[(11)]);
var inst_18199 = (state_18245[(12)]);
var inst_18201 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_18197);
var inst_18202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18203 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_18199];
var inst_18204 = (new cljs.core.PersistentVector(null,2,(5),inst_18202,inst_18203,null));
var inst_18205 = cljs.core.get_in.call(null,opts,inst_18204);
var state_18245__$1 = (function (){var statearr_18258 = state_18245;
(statearr_18258[(13)] = inst_18201);

return statearr_18258;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18245__$1,(25),inst_18205);
} else {
if((state_val_18246 === (29))){
var inst_18212 = (state_18245[(2)]);
var inst_18213 = fluree.db.util.async.throw_err.call(null,inst_18212);
var state_18245__$1 = state_18245;
var statearr_18259_18306 = state_18245__$1;
(statearr_18259_18306[(2)] = inst_18213);

(statearr_18259_18306[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (6))){
var inst_18161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18162 = cljs.core.PersistentVector.EMPTY;
var inst_18163 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_18164 = cljs.core.into.call(null,inst_18162,inst_18163);
var inst_18165 = [db,inst_18164];
var inst_18166 = (new cljs.core.PersistentVector(null,2,(5),inst_18161,inst_18165,null));
var state_18245__$1 = state_18245;
var statearr_18260_18307 = state_18245__$1;
(statearr_18260_18307[(2)] = inst_18166);

(statearr_18260_18307[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (28))){
var inst_18216 = (state_18245[(2)]);
var inst_18217 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18218 = cljs.core.PersistentVector.EMPTY;
var inst_18219 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_18220 = cljs.core.into.call(null,inst_18218,inst_18219);
var inst_18221 = [inst_18216,inst_18220];
var inst_18222 = (new cljs.core.PersistentVector(null,2,(5),inst_18217,inst_18221,null));
var state_18245__$1 = state_18245;
var statearr_18261_18308 = state_18245__$1;
(statearr_18261_18308[(2)] = inst_18222);

(statearr_18261_18308[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (25))){
var inst_18201 = (state_18245[(13)]);
var inst_18207 = (state_18245[(2)]);
var inst_18208 = fluree.db.util.async.throw_err.call(null,inst_18207);
var state_18245__$1 = (function (){var statearr_18262 = state_18245;
(statearr_18262[(8)] = inst_18208);

return statearr_18262;
})();
if(cljs.core.truth_(inst_18201)){
var statearr_18263_18309 = state_18245__$1;
(statearr_18263_18309[(1)] = (26));

} else {
var statearr_18264_18310 = state_18245__$1;
(statearr_18264_18310[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (17))){
var state_18245__$1 = state_18245;
var statearr_18265_18311 = state_18245__$1;
(statearr_18265_18311[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (3))){
var inst_18243 = (state_18245[(2)]);
var state_18245__$1 = state_18245;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18245__$1,inst_18243);
} else {
if((state_val_18246 === (12))){
var inst_18175 = (state_18245[(9)]);
var inst_18174 = (state_18245[(2)]);
var inst_18175__$1 = fluree.db.util.async.throw_err.call(null,inst_18174);
var inst_18176 = fluree.db.util.core.exception_QMARK_.call(null,inst_18175__$1);
var state_18245__$1 = (function (){var statearr_18267 = state_18245;
(statearr_18267[(9)] = inst_18175__$1);

return statearr_18267;
})();
if(inst_18176){
var statearr_18268_18312 = state_18245__$1;
(statearr_18268_18312[(1)] = (13));

} else {
var statearr_18269_18313 = state_18245__$1;
(statearr_18269_18313[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (2))){
var inst_18158 = (state_18245[(7)]);
var _ = (function (){var statearr_18270 = state_18245;
(statearr_18270[(4)] = cljs.core.cons.call(null,(5),(state_18245[(4)])));

return statearr_18270;
})();
var inst_18158__$1 = cljs.core.first.call(null,clause);
var inst_18159 = cljs.core._EQ_.call(null,"$fdb",inst_18158__$1);
var state_18245__$1 = (function (){var statearr_18271 = state_18245;
(statearr_18271[(7)] = inst_18158__$1);

return statearr_18271;
})();
if(inst_18159){
var statearr_18272_18314 = state_18245__$1;
(statearr_18272_18314[(1)] = (6));

} else {
var statearr_18273_18315 = state_18245__$1;
(statearr_18273_18315[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (23))){
var inst_18158 = (state_18245[(7)]);
var inst_18224 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18158)," is not supported in Fluree"].join('');
var inst_18225 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18226 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_18227 = cljs.core.PersistentHashMap.fromArrays(inst_18225,inst_18226);
var inst_18228 = cljs.core.ex_info.call(null,inst_18224,inst_18227);
var inst_18229 = (function(){throw inst_18228})();
var state_18245__$1 = state_18245;
var statearr_18274_18316 = state_18245__$1;
(statearr_18274_18316[(2)] = inst_18229);

(statearr_18274_18316[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (19))){
var inst_18158 = (state_18245[(7)]);
var inst_18199 = (state_18245[(12)]);
var inst_18196 = fluree.db.query.analytical.isolate_source_name.call(null,inst_18158);
var inst_18197 = fluree.db.query.analytical.isolate_source_block.call(null,inst_18158);
var inst_18198 = cljs.core.keyword.call(null,inst_18196);
var inst_18199__$1 = cljs.core.get.call(null,prefixes,inst_18198);
var state_18245__$1 = (function (){var statearr_18275 = state_18245;
(statearr_18275[(11)] = inst_18197);

(statearr_18275[(12)] = inst_18199__$1);

return statearr_18275;
})();
if(cljs.core.truth_(inst_18199__$1)){
var statearr_18276_18317 = state_18245__$1;
(statearr_18276_18317[(1)] = (22));

} else {
var statearr_18277_18318 = state_18245__$1;
(statearr_18277_18318[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (11))){
var inst_18238 = (state_18245[(2)]);
var state_18245__$1 = state_18245;
var statearr_18279_18319 = state_18245__$1;
(statearr_18279_18319[(2)] = inst_18238);

(statearr_18279_18319[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (9))){
var inst_18158 = (state_18245[(7)]);
var inst_18170 = cljs.core.subs.call(null,inst_18158,(4));
var inst_18171 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_18170);
var inst_18172 = fluree.db.time_travel.as_of_block.call(null,db,inst_18171);
var state_18245__$1 = state_18245;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18245__$1,(12),inst_18172);
} else {
if((state_val_18246 === (5))){
var _ = (function (){var statearr_18280 = state_18245;
(statearr_18280[(4)] = cljs.core.rest.call(null,(state_18245[(4)])));

return statearr_18280;
})();
var state_18245__$1 = state_18245;
var ex18278 = (state_18245__$1[(2)]);
var statearr_18281_18320 = state_18245__$1;
(statearr_18281_18320[(5)] = ex18278);


if((ex18278 instanceof Error)){
var statearr_18282_18321 = state_18245__$1;
(statearr_18282_18321[(1)] = (4));

(statearr_18282_18321[(5)] = null);

} else {
throw ex18278;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (14))){
var state_18245__$1 = state_18245;
var statearr_18283_18322 = state_18245__$1;
(statearr_18283_18322[(2)] = null);

(statearr_18283_18322[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (26))){
var inst_18208 = (state_18245[(8)]);
var inst_18201 = (state_18245[(13)]);
var inst_18210 = fluree.db.time_travel.as_of_block.call(null,inst_18208,inst_18201);
var state_18245__$1 = state_18245;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18245__$1,(29),inst_18210);
} else {
if((state_val_18246 === (16))){
var inst_18191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18192 = ["$wd",clause];
var inst_18193 = (new cljs.core.PersistentVector(null,2,(5),inst_18191,inst_18192,null));
var state_18245__$1 = state_18245;
var statearr_18284_18323 = state_18245__$1;
(statearr_18284_18323[(2)] = inst_18193);

(statearr_18284_18323[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (10))){
var inst_18158 = (state_18245[(7)]);
var inst_18189 = cljs.core._EQ_.call(null,"$wd",inst_18158);
var state_18245__$1 = state_18245;
if(inst_18189){
var statearr_18285_18324 = state_18245__$1;
(statearr_18285_18324[(1)] = (16));

} else {
var statearr_18286_18325 = state_18245__$1;
(statearr_18286_18325[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (18))){
var inst_18236 = (state_18245[(2)]);
var state_18245__$1 = state_18245;
var statearr_18287_18326 = state_18245__$1;
(statearr_18287_18326[(2)] = inst_18236);

(statearr_18287_18326[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18246 === (8))){
var inst_18240 = (state_18245[(2)]);
var _ = (function (){var statearr_18288 = state_18245;
(statearr_18288[(4)] = cljs.core.rest.call(null,(state_18245[(4)])));

return statearr_18288;
})();
var state_18245__$1 = state_18245;
var statearr_18289_18327 = state_18245__$1;
(statearr_18289_18327[(2)] = inst_18240);

(statearr_18289_18327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2727__auto__ = null;
var fluree$db$query$analytical$state_machine__2727__auto____0 = (function (){
var statearr_18290 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18290[(0)] = fluree$db$query$analytical$state_machine__2727__auto__);

(statearr_18290[(1)] = (1));

return statearr_18290;
});
var fluree$db$query$analytical$state_machine__2727__auto____1 = (function (state_18245){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_18245);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18291){var ex__2730__auto__ = e18291;
var statearr_18292_18328 = state_18245;
(statearr_18292_18328[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_18245[(4)]))){
var statearr_18293_18329 = state_18245;
(statearr_18293_18329[(1)] = cljs.core.first.call(null,(state_18245[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18330 = state_18245;
state_18245 = G__18330;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2727__auto__ = function(state_18245){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2727__auto____1.call(this,state_18245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2727__auto____0;
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2727__auto____1;
return fluree$db$query$analytical$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18294 = f__2750__auto__.call(null);
(statearr_18294[(6)] = c__2749__auto__);

return statearr_18294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__18331){
var vec__18332 = p__18331;
var sub = cljs.core.nth.call(null,vec__18332,(0),null);
var obj = cljs.core.nth.call(null,vec__18332,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__18335_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__18335_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__18339 = subjects;
var vec__18340 = G__18339;
var seq__18341 = cljs.core.seq.call(null,vec__18340);
var first__18342 = cljs.core.first.call(null,seq__18341);
var seq__18341__$1 = cljs.core.next.call(null,seq__18341);
var subject = first__18342;
var r = seq__18341__$1;
var acc = expanded_map;
var G__18339__$1 = G__18339;
var acc__$1 = acc;
while(true){
var vec__18346 = G__18339__$1;
var seq__18347 = cljs.core.seq.call(null,vec__18346);
var first__18348 = cljs.core.first.call(null,seq__18347);
var seq__18347__$1 = cljs.core.next.call(null,seq__18347);
var subject__$1 = first__18348;
var r__$1 = seq__18347__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__18349 = r__$1;
var G__18350 = acc__$2;
G__18339__$1 = G__18349;
acc__$1 = G__18350;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__18339__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__18346,seq__18347,first__18348,seq__18347__$1,subject__$1,r__$1,acc__$2,G__18339,vec__18340,seq__18341,first__18342,seq__18341__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4253__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__18339__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__18346,seq__18347,first__18348,seq__18347__$1,subject__$1,r__$1,acc__$2,G__18339,vec__18340,seq__18341,first__18342,seq__18341__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__18339__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__18346,seq__18347,first__18348,seq__18347__$1,subject__$1,r__$1,acc__$2,G__18339,vec__18340,seq__18341,first__18342,seq__18341__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__18339__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__18346,seq__18347,first__18348,seq__18347__$1,subject__$1,r__$1,acc__$2,G__18339,vec__18340,seq__18341,first__18342,seq__18341__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__18339__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__18346,seq__18347,first__18348,seq__18347__$1,subject__$1,r__$1,acc__$2,G__18339,vec__18340,seq__18341,first__18342,seq__18341__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__18339__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__18346,seq__18347,first__18348,seq__18347__$1,subject__$1,r__$1,acc__$2,G__18339,vec__18340,seq__18341,first__18342,seq__18341__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__18351 = r__$1;
var G__18352 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__18339__$1 = G__18351;
acc__$1 = G__18352;
continue;
} else {
var G__18353 = subjects;
var G__18354 = acc_STAR_;
G__18339__$1 = G__18353;
acc__$1 = G__18354;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__18355_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__18355_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18446){
var state_val_18447 = (state_18446[(1)]);
if((state_val_18447 === (7))){
var state_18446__$1 = state_18446;
var statearr_18448_18494 = state_18446__$1;
(statearr_18448_18494[(2)] = (100));

(statearr_18448_18494[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (20))){
var inst_18395 = (state_18446[(7)]);
var state_18446__$1 = state_18446;
var statearr_18449_18495 = state_18446__$1;
(statearr_18449_18495[(2)] = inst_18395);

(statearr_18449_18495[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (1))){
var state_18446__$1 = state_18446;
var statearr_18450_18496 = state_18446__$1;
(statearr_18450_18496[(2)] = null);

(statearr_18450_18496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (24))){
var inst_18434 = (state_18446[(8)]);
var inst_18367 = (state_18446[(9)]);
var inst_18433 = (state_18446[(10)]);
var inst_18432 = (state_18446[(11)]);
var inst_18437 = (function (){var max_depth = inst_18367;
var recur_map__$1 = inst_18433;
var subjects = inst_18432;
var tuples = inst_18434;
return (function (p1__18356_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__18356_SHARP_)],null));
});
})();
var inst_18438 = cljs.core.map.call(null,inst_18437,inst_18434);
var inst_18439 = cljs.core.distinct.call(null,inst_18438);
var state_18446__$1 = state_18446;
var statearr_18451_18497 = state_18446__$1;
(statearr_18451_18497[(2)] = inst_18439);

(statearr_18451_18497[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (4))){
var inst_18357 = (state_18446[(2)]);
var state_18446__$1 = state_18446;
var statearr_18452_18498 = state_18446__$1;
(statearr_18452_18498[(2)] = inst_18357);

(statearr_18452_18498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (15))){
var inst_18380 = (state_18446[(12)]);
var inst_18391 = cljs.core.PersistentVector.EMPTY;
var inst_18392 = cljs.core.seq.call(null,inst_18380);
var inst_18393 = cljs.core.first.call(null,inst_18392);
var inst_18394 = cljs.core.next.call(null,inst_18392);
var inst_18395 = inst_18391;
var inst_18396 = inst_18380;
var state_18446__$1 = (function (){var statearr_18453 = state_18446;
(statearr_18453[(13)] = inst_18396);

(statearr_18453[(14)] = inst_18393);

(statearr_18453[(7)] = inst_18395);

(statearr_18453[(15)] = inst_18394);

return statearr_18453;
})();
var statearr_18454_18499 = state_18446__$1;
(statearr_18454_18499[(2)] = null);

(statearr_18454_18499[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (21))){
var inst_18416 = (state_18446[(2)]);
var state_18446__$1 = state_18446;
var statearr_18455_18500 = state_18446__$1;
(statearr_18455_18500[(2)] = inst_18416);

(statearr_18455_18500[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (13))){
var inst_18429 = (state_18446[(2)]);
var state_18446__$1 = state_18446;
var statearr_18456_18501 = state_18446__$1;
(statearr_18456_18501[(2)] = inst_18429);

(statearr_18456_18501[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (22))){
var inst_18403 = (state_18446[(16)]);
var inst_18395 = (state_18446[(7)]);
var inst_18410 = (state_18446[(2)]);
var inst_18411 = fluree.db.util.async.throw_err.call(null,inst_18410);
var inst_18412 = cljs.core.concat.call(null,inst_18395,inst_18411);
var inst_18395__$1 = inst_18412;
var inst_18396 = inst_18403;
var state_18446__$1 = (function (){var statearr_18457 = state_18446;
(statearr_18457[(13)] = inst_18396);

(statearr_18457[(7)] = inst_18395__$1);

return statearr_18457;
})();
var statearr_18458_18502 = state_18446__$1;
(statearr_18458_18502[(2)] = null);

(statearr_18458_18502[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (6))){
var inst_18363 = (state_18446[(17)]);
var state_18446__$1 = state_18446;
var statearr_18459_18503 = state_18446__$1;
(statearr_18459_18503[(2)] = inst_18363);

(statearr_18459_18503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (25))){
var inst_18441 = (state_18446[(2)]);
var _ = (function (){var statearr_18460 = state_18446;
(statearr_18460[(4)] = cljs.core.rest.call(null,(state_18446[(4)])));

return statearr_18460;
})();
var state_18446__$1 = state_18446;
var statearr_18461_18504 = state_18446__$1;
(statearr_18461_18504[(2)] = inst_18441);

(statearr_18461_18504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (17))){
var inst_18402 = (state_18446[(18)]);
var inst_18396 = (state_18446[(13)]);
var inst_18401 = cljs.core.seq.call(null,inst_18396);
var inst_18402__$1 = cljs.core.first.call(null,inst_18401);
var inst_18403 = cljs.core.next.call(null,inst_18401);
var state_18446__$1 = (function (){var statearr_18462 = state_18446;
(statearr_18462[(18)] = inst_18402__$1);

(statearr_18462[(16)] = inst_18403);

return statearr_18462;
})();
if(cljs.core.truth_(inst_18402__$1)){
var statearr_18463_18505 = state_18446__$1;
(statearr_18463_18505[(1)] = (19));

} else {
var statearr_18464_18506 = state_18446__$1;
(statearr_18464_18506[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (3))){
var inst_18444 = (state_18446[(2)]);
var state_18446__$1 = state_18446;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18446__$1,inst_18444);
} else {
if((state_val_18447 === (12))){
var inst_18380 = (state_18446[(12)]);
var inst_18369 = (state_18446[(19)]);
var inst_18375 = cljs.core.vals.call(null,inst_18369);
var inst_18376 = cljs.core.flatten.call(null,inst_18375);
var inst_18377 = cljs.core.set.call(null,inst_18376);
var inst_18378 = cljs.core.keys.call(null,inst_18369);
var inst_18379 = cljs.core.set.call(null,inst_18378);
var inst_18380__$1 = clojure.set.difference.call(null,inst_18377,inst_18379);
var inst_18381 = cljs.core.empty_QMARK_.call(null,inst_18380__$1);
var state_18446__$1 = (function (){var statearr_18465 = state_18446;
(statearr_18465[(12)] = inst_18380__$1);

return statearr_18465;
})();
if(inst_18381){
var statearr_18466_18507 = state_18446__$1;
(statearr_18466_18507[(1)] = (14));

} else {
var statearr_18467_18508 = state_18446__$1;
(statearr_18467_18508[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (2))){
var inst_18363 = (state_18446[(17)]);
var _ = (function (){var statearr_18468 = state_18446;
(statearr_18468[(4)] = cljs.core.cons.call(null,(5),(state_18446[(4)])));

return statearr_18468;
})();
var inst_18363__$1 = depth;
var state_18446__$1 = (function (){var statearr_18469 = state_18446;
(statearr_18469[(17)] = inst_18363__$1);

return statearr_18469;
})();
if(cljs.core.truth_(inst_18363__$1)){
var statearr_18470_18509 = state_18446__$1;
(statearr_18470_18509[(1)] = (6));

} else {
var statearr_18471_18510 = state_18446__$1;
(statearr_18471_18510[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (23))){
var inst_18434 = (state_18446[(8)]);
var state_18446__$1 = state_18446;
var statearr_18472_18511 = state_18446__$1;
(statearr_18472_18511[(2)] = inst_18434);

(statearr_18472_18511[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (19))){
var inst_18402 = (state_18446[(18)]);
var inst_18405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18406 = [inst_18402,predicate];
var inst_18407 = (new cljs.core.PersistentVector(null,2,(5),inst_18405,inst_18406,null));
var inst_18408 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_18407);
var state_18446__$1 = state_18446;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18446__$1,(22),inst_18408);
} else {
if((state_val_18447 === (11))){
var inst_18369 = (state_18446[(19)]);
var state_18446__$1 = state_18446;
var statearr_18474_18512 = state_18446__$1;
(statearr_18474_18512[(2)] = inst_18369);

(statearr_18474_18512[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (9))){
var inst_18370 = (state_18446[(20)]);
var inst_18367 = (state_18446[(9)]);
var inst_18372 = (inst_18370 >= inst_18367);
var state_18446__$1 = state_18446;
if(cljs.core.truth_(inst_18372)){
var statearr_18475_18513 = state_18446__$1;
(statearr_18475_18513[(1)] = (11));

} else {
var statearr_18476_18514 = state_18446__$1;
(statearr_18476_18514[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (5))){
var _ = (function (){var statearr_18477 = state_18446;
(statearr_18477[(4)] = cljs.core.rest.call(null,(state_18446[(4)])));

return statearr_18477;
})();
var state_18446__$1 = state_18446;
var ex18473 = (state_18446__$1[(2)]);
var statearr_18478_18515 = state_18446__$1;
(statearr_18478_18515[(5)] = ex18473);


if((ex18473 instanceof Error)){
var statearr_18479_18516 = state_18446__$1;
(statearr_18479_18516[(1)] = (4));

(statearr_18479_18516[(5)] = null);

} else {
throw ex18473;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (14))){
var inst_18369 = (state_18446[(19)]);
var state_18446__$1 = state_18446;
var statearr_18480_18517 = state_18446__$1;
(statearr_18480_18517[(2)] = inst_18369);

(statearr_18480_18517[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (16))){
var inst_18427 = (state_18446[(2)]);
var state_18446__$1 = state_18446;
var statearr_18481_18518 = state_18446__$1;
(statearr_18481_18518[(2)] = inst_18427);

(statearr_18481_18518[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (10))){
var inst_18433 = (state_18446[(10)]);
var inst_18432 = (state_18446[(11)]);
var inst_18431 = (state_18446[(2)]);
var inst_18432__$1 = cljs.core.keys.call(null,inst_18431);
var inst_18433__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_18432__$1,inst_18431);
var inst_18434 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_18432__$1,inst_18433__$1);
var state_18446__$1 = (function (){var statearr_18482 = state_18446;
(statearr_18482[(8)] = inst_18434);

(statearr_18482[(10)] = inst_18433__$1);

(statearr_18482[(11)] = inst_18432__$1);

return statearr_18482;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_18483_18519 = state_18446__$1;
(statearr_18483_18519[(1)] = (23));

} else {
var statearr_18484_18520 = state_18446__$1;
(statearr_18484_18520[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (18))){
var inst_18370 = (state_18446[(20)]);
var inst_18369 = (state_18446[(19)]);
var inst_18418 = (state_18446[(2)]);
var inst_18419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18420 = [(0),(2)];
var inst_18421 = (new cljs.core.PersistentVector(null,2,(5),inst_18419,inst_18420,null));
var inst_18422 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_18421,inst_18418);
var inst_18423 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_18369,inst_18422);
var inst_18424 = (inst_18370 + (1));
var inst_18369__$1 = inst_18423;
var inst_18370__$1 = inst_18424;
var state_18446__$1 = (function (){var statearr_18485 = state_18446;
(statearr_18485[(20)] = inst_18370__$1);

(statearr_18485[(19)] = inst_18369__$1);

return statearr_18485;
})();
var statearr_18486_18521 = state_18446__$1;
(statearr_18486_18521[(2)] = null);

(statearr_18486_18521[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18447 === (8))){
var inst_18367 = (state_18446[(2)]);
var inst_18368 = recur_map;
var inst_18369 = inst_18368;
var inst_18370 = (1);
var state_18446__$1 = (function (){var statearr_18487 = state_18446;
(statearr_18487[(20)] = inst_18370);

(statearr_18487[(9)] = inst_18367);

(statearr_18487[(19)] = inst_18369);

return statearr_18487;
})();
var statearr_18488_18522 = state_18446__$1;
(statearr_18488_18522[(2)] = null);

(statearr_18488_18522[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0 = (function (){
var statearr_18489 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18489[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__);

(statearr_18489[(1)] = (1));

return statearr_18489;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1 = (function (state_18446){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_18446);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18490){var ex__2730__auto__ = e18490;
var statearr_18491_18523 = state_18446;
(statearr_18491_18523[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_18446[(4)]))){
var statearr_18492_18524 = state_18446;
(statearr_18492_18524[(1)] = cljs.core.first.call(null,(state_18446[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18525 = state_18446;
state_18446 = G__18525;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__ = function(state_18446){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1.call(this,state_18446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18493 = f__2750__auto__.call(null);
(statearr_18493[(6)] = c__2749__auto__);

return statearr_18493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__18526,clause,fuel,max_fuel){
var map__18527 = p__18526;
var map__18527__$1 = cljs.core.__destructure_map.call(null,map__18527);
var res = map__18527__$1;
var headers = cljs.core.get.call(null,map__18527__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__18527__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__18527__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18638){
var state_val_18639 = (state_18638[(1)]);
if((state_val_18639 === (7))){
var inst_18544 = (state_18638[(7)]);
var state_18638__$1 = state_18638;
var statearr_18640_18693 = state_18638__$1;
(statearr_18640_18693[(2)] = inst_18544);

(statearr_18640_18693[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (20))){
var inst_18572 = (state_18638[(8)]);
var inst_18603 = typeof inst_18572 === 'number';
var state_18638__$1 = state_18638;
if(cljs.core.truth_(inst_18603)){
var statearr_18641_18694 = state_18638__$1;
(statearr_18641_18694[(1)] = (22));

} else {
var statearr_18642_18695 = state_18638__$1;
(statearr_18642_18695[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (27))){
var inst_18618 = (state_18638[(2)]);
var state_18638__$1 = state_18638;
var statearr_18643_18696 = state_18638__$1;
(statearr_18643_18696[(2)] = inst_18618);

(statearr_18643_18696[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (1))){
var state_18638__$1 = state_18638;
var statearr_18644_18697 = state_18638__$1;
(statearr_18644_18697[(2)] = null);

(statearr_18644_18697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (24))){
var inst_18620 = (state_18638[(2)]);
var state_18638__$1 = state_18638;
var statearr_18645_18698 = state_18638__$1;
(statearr_18645_18698[(2)] = inst_18620);

(statearr_18645_18698[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (4))){
var inst_18528 = (state_18638[(2)]);
var state_18638__$1 = state_18638;
var statearr_18646_18699 = state_18638__$1;
(statearr_18646_18699[(2)] = inst_18528);

(statearr_18646_18699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (15))){
var inst_18586 = (state_18638[(2)]);
var inst_18587 = cljs.core.nth.call(null,clause,(2));
var inst_18588 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_18587);
var state_18638__$1 = (function (){var statearr_18647 = state_18638;
(statearr_18647[(9)] = inst_18586);

return statearr_18647;
})();
if(cljs.core.truth_(inst_18588)){
var statearr_18648_18700 = state_18638__$1;
(statearr_18648_18700[(1)] = (16));

} else {
var statearr_18649_18701 = state_18638__$1;
(statearr_18649_18701[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (21))){
var inst_18545 = (state_18638[(10)]);
var inst_18575 = (state_18638[(11)]);
var inst_18574 = (state_18638[(12)]);
var inst_18622 = (state_18638[(2)]);
var inst_18623 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_18575,inst_18622,inst_18545,inst_18574);
var state_18638__$1 = state_18638;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18638__$1,(28),inst_18623);
} else {
if((state_val_18639 === (13))){
var inst_18554 = (state_18638[(13)]);
var inst_18578 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18554)].join('');
var inst_18579 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18580 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_18581 = cljs.core.PersistentHashMap.fromArrays(inst_18579,inst_18580);
var inst_18582 = cljs.core.ex_info.call(null,inst_18578,inst_18581);
var inst_18583 = (function(){throw inst_18582})();
var state_18638__$1 = state_18638;
var statearr_18650_18702 = state_18638__$1;
(statearr_18650_18702[(2)] = inst_18583);

(statearr_18650_18702[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (22))){
var inst_18570 = (state_18638[(14)]);
var inst_18572 = (state_18638[(8)]);
var inst_18605 = cljs.core.PersistentHashMap.EMPTY;
var inst_18606 = cljs.core.flatten.call(null,inst_18570);
var inst_18607 = cljs.core.assoc.call(null,inst_18605,inst_18572,inst_18606);
var state_18638__$1 = state_18638;
var statearr_18651_18703 = state_18638__$1;
(statearr_18651_18703[(2)] = inst_18607);

(statearr_18651_18703[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (6))){
var inst_18556 = (state_18638[(15)]);
var state_18638__$1 = state_18638;
var statearr_18652_18704 = state_18638__$1;
(statearr_18652_18704[(2)] = inst_18556);

(statearr_18652_18704[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (28))){
var inst_18625 = (state_18638[(2)]);
var inst_18626 = fluree.db.util.async.throw_err.call(null,inst_18625);
var state_18638__$1 = state_18638;
var statearr_18653_18705 = state_18638__$1;
(statearr_18653_18705[(2)] = inst_18626);

(statearr_18653_18705[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (25))){
var inst_18566 = (state_18638[(16)]);
var inst_18570 = (state_18638[(14)]);
var inst_18611 = cljs.core.PersistentHashMap.EMPTY;
var inst_18612 = cljs.core.first.call(null,inst_18566);
var inst_18613 = cljs.core.first.call(null,inst_18612);
var inst_18614 = cljs.core.flatten.call(null,inst_18570);
var inst_18615 = cljs.core.assoc.call(null,inst_18611,inst_18613,inst_18614);
var state_18638__$1 = state_18638;
var statearr_18654_18706 = state_18638__$1;
(statearr_18654_18706[(2)] = inst_18615);

(statearr_18654_18706[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (17))){
var inst_18554 = (state_18638[(13)]);
var inst_18591 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18554)].join('');
var inst_18592 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18593 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_18594 = cljs.core.PersistentHashMap.fromArrays(inst_18592,inst_18593);
var inst_18595 = cljs.core.ex_info.call(null,inst_18591,inst_18594);
var inst_18596 = (function(){throw inst_18595})();
var state_18638__$1 = state_18638;
var statearr_18655_18707 = state_18638__$1;
(statearr_18655_18707[(2)] = inst_18596);

(statearr_18655_18707[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (3))){
var inst_18636 = (state_18638[(2)]);
var state_18638__$1 = state_18638;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18638__$1,inst_18636);
} else {
if((state_val_18639 === (12))){
var inst_18541 = (state_18638[(17)]);
var inst_18629 = (state_18638[(2)]);
var inst_18630 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_18631 = cljs.core.keys.call(null,inst_18541);
var inst_18632 = [inst_18631,vars,inst_18629];
var inst_18633 = cljs.core.PersistentHashMap.fromArrays(inst_18630,inst_18632);
var _ = (function (){var statearr_18656 = state_18638;
(statearr_18656[(4)] = cljs.core.rest.call(null,(state_18638[(4)])));

return statearr_18656;
})();
var state_18638__$1 = state_18638;
var statearr_18657_18708 = state_18638__$1;
(statearr_18657_18708[(2)] = inst_18633);

(statearr_18657_18708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (2))){
var inst_18545 = (state_18638[(10)]);
var inst_18556 = (state_18638[(15)]);
var inst_18541 = (state_18638[(17)]);
var inst_18544 = (state_18638[(7)]);
var _ = (function (){var statearr_18658 = state_18638;
(statearr_18658[(4)] = cljs.core.cons.call(null,(5),(state_18638[(4)])));

return statearr_18658;
})();
var inst_18538 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_18539 = cljs.core.__destructure_map.call(null,inst_18538);
var inst_18540 = cljs.core.get.call(null,inst_18539,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_18541__$1 = cljs.core.get.call(null,inst_18539,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_18542 = cljs.core.get.call(null,inst_18539,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_18543 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_18544__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_18542);
var inst_18545__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_18542);
var inst_18547 = (function (){var map__18534 = inst_18539;
var search = inst_18540;
var rel = inst_18541__$1;
var opts = inst_18542;
var common_keys = inst_18543;
var object_fn = inst_18544__$1;
var recur_depth = inst_18545__$1;
return (function (p__18546,common_key){
var vec__18659 = p__18546;
var acc = cljs.core.nth.call(null,vec__18659,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__18659,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__18662 = cljs.core._EQ_;
var expr__18663 = idx_of;
if(cljs.core.truth_(pred__18662.call(null,(0),expr__18663))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__18662.call(null,(1),expr__18663))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__18662.call(null,(2),expr__18663))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__18663)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((function (){var and__4251__auto__ = (!(single_v_QMARK_));
if(and__4251__auto__){
var and__4251__auto____$1 = object_fn;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_18548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18549 = cljs.core.PersistentHashMap.EMPTY;
var inst_18550 = [inst_18549,inst_18540];
var inst_18551 = (new cljs.core.PersistentVector(null,2,(5),inst_18548,inst_18550,null));
var inst_18552 = cljs.core.reduce.call(null,inst_18547,inst_18551,inst_18543);
var inst_18553 = cljs.core.nth.call(null,inst_18552,(0),null);
var inst_18554 = cljs.core.nth.call(null,inst_18552,(1),null);
var inst_18555 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_18556__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_18553);
var state_18638__$1 = (function (){var statearr_18665 = state_18638;
(statearr_18665[(13)] = inst_18554);

(statearr_18665[(10)] = inst_18545__$1);

(statearr_18665[(15)] = inst_18556__$1);

(statearr_18665[(17)] = inst_18541__$1);

(statearr_18665[(18)] = inst_18555);

(statearr_18665[(7)] = inst_18544__$1);

return statearr_18665;
})();
if(cljs.core.truth_(inst_18556__$1)){
var statearr_18666_18709 = state_18638__$1;
(statearr_18666_18709[(1)] = (6));

} else {
var statearr_18667_18710 = state_18638__$1;
(statearr_18667_18710[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (23))){
var inst_18572 = (state_18638[(8)]);
var inst_18609 = cljs.core.coll_QMARK_.call(null,inst_18572);
var state_18638__$1 = state_18638;
if(inst_18609){
var statearr_18668_18711 = state_18638__$1;
(statearr_18668_18711[(1)] = (25));

} else {
var statearr_18669_18712 = state_18638__$1;
(statearr_18669_18712[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (19))){
var inst_18570 = (state_18638[(14)]);
var inst_18600 = cljs.core.PersistentHashMap.EMPTY;
var inst_18601 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_18600,inst_18570);
var state_18638__$1 = state_18638;
var statearr_18670_18713 = state_18638__$1;
(statearr_18670_18713[(2)] = inst_18601);

(statearr_18670_18713[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (11))){
var inst_18570 = (state_18638[(14)]);
var state_18638__$1 = state_18638;
var statearr_18672_18714 = state_18638__$1;
(statearr_18672_18714[(2)] = inst_18570);

(statearr_18672_18714[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (9))){
var inst_18566 = (state_18638[(16)]);
var inst_18545 = (state_18638[(10)]);
var inst_18541 = (state_18638[(17)]);
var inst_18565 = (state_18638[(2)]);
var inst_18566__$1 = fluree.db.util.async.throw_err.call(null,inst_18565);
var inst_18567 = cljs.core.count.call(null,inst_18566__$1);
var inst_18568 = fluree.db.query.analytical.add_fuel.call(null,inst_18567,fuel,max_fuel);
var inst_18569 = cljs.core.vals.call(null,inst_18541);
var inst_18570 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_18569,inst_18566__$1);
var state_18638__$1 = (function (){var statearr_18673 = state_18638;
(statearr_18673[(16)] = inst_18566__$1);

(statearr_18673[(14)] = inst_18570);

(statearr_18673[(19)] = inst_18568);

return statearr_18673;
})();
if(cljs.core.truth_(inst_18545)){
var statearr_18674_18715 = state_18638__$1;
(statearr_18674_18715[(1)] = (10));

} else {
var statearr_18675_18716 = state_18638__$1;
(statearr_18675_18716[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (5))){
var _ = (function (){var statearr_18676 = state_18638;
(statearr_18676[(4)] = cljs.core.rest.call(null,(state_18638[(4)])));

return statearr_18676;
})();
var state_18638__$1 = state_18638;
var ex18671 = (state_18638__$1[(2)]);
var statearr_18677_18717 = state_18638__$1;
(statearr_18677_18717[(5)] = ex18671);


if((ex18671 instanceof Error)){
var statearr_18678_18718 = state_18638__$1;
(statearr_18678_18718[(1)] = (4));

(statearr_18678_18718[(5)] = null);

} else {
throw ex18671;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (14))){
var state_18638__$1 = state_18638;
var statearr_18679_18719 = state_18638__$1;
(statearr_18679_18719[(2)] = null);

(statearr_18679_18719[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (26))){
var state_18638__$1 = state_18638;
var statearr_18680_18720 = state_18638__$1;
(statearr_18680_18720[(2)] = null);

(statearr_18680_18720[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (16))){
var state_18638__$1 = state_18638;
var statearr_18681_18721 = state_18638__$1;
(statearr_18681_18721[(2)] = null);

(statearr_18681_18721[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (10))){
var inst_18554 = (state_18638[(13)]);
var inst_18575 = (state_18638[(11)]);
var inst_18572 = cljs.core.first.call(null,inst_18554);
var inst_18573 = cljs.core.first.call(null,clause);
var inst_18574 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_18573);
var inst_18575__$1 = cljs.core.nth.call(null,inst_18554,(1));
var inst_18576 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_18575__$1);
var state_18638__$1 = (function (){var statearr_18682 = state_18638;
(statearr_18682[(11)] = inst_18575__$1);

(statearr_18682[(12)] = inst_18574);

(statearr_18682[(8)] = inst_18572);

return statearr_18682;
})();
if(cljs.core.truth_(inst_18576)){
var statearr_18683_18722 = state_18638__$1;
(statearr_18683_18722[(1)] = (13));

} else {
var statearr_18684_18723 = state_18638__$1;
(statearr_18684_18723[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (18))){
var inst_18574 = (state_18638[(12)]);
var inst_18598 = (state_18638[(2)]);
var state_18638__$1 = (function (){var statearr_18685 = state_18638;
(statearr_18685[(20)] = inst_18598);

return statearr_18685;
})();
if(cljs.core.truth_(inst_18574)){
var statearr_18686_18724 = state_18638__$1;
(statearr_18686_18724[(1)] = (19));

} else {
var statearr_18687_18725 = state_18638__$1;
(statearr_18687_18725[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (8))){
var inst_18554 = (state_18638[(13)]);
var inst_18555 = (state_18638[(18)]);
var inst_18560 = (state_18638[(2)]);
var inst_18561 = [inst_18560];
var inst_18562 = cljs.core.PersistentHashMap.fromArrays(inst_18555,inst_18561);
var inst_18563 = fluree.db.query.range.search.call(null,db,inst_18554,inst_18562);
var state_18638__$1 = state_18638;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18638__$1,(9),inst_18563);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_18688 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18688[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__);

(statearr_18688[(1)] = (1));

return statearr_18688;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1 = (function (state_18638){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_18638);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18689){var ex__2730__auto__ = e18689;
var statearr_18690_18726 = state_18638;
(statearr_18690_18726[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_18638[(4)]))){
var statearr_18691_18727 = state_18638;
(statearr_18691_18727[(1)] = cljs.core.first.call(null,(state_18638[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18728 = state_18638;
state_18638 = G__18728;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__ = function(state_18638){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1.call(this,state_18638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18692 = f__2750__auto__.call(null);
(statearr_18692[(6)] = c__2749__auto__);

return statearr_18692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__18729,res,clause){
var map__18730 = p__18729;
var map__18730__$1 = cljs.core.__destructure_map.call(null,map__18730);
var db = map__18730__$1;
var conn = cljs.core.get.call(null,map__18730__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__18730__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__18730__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18839){
var state_val_18840 = (state_18839[(1)]);
if((state_val_18840 === (7))){
var inst_18739 = (state_18839[(7)]);
var state_18839__$1 = state_18839;
var statearr_18841_18882 = state_18839__$1;
(statearr_18841_18882[(2)] = inst_18739);

(statearr_18841_18882[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (20))){
var state_18839__$1 = state_18839;
var statearr_18842_18883 = state_18839__$1;
(statearr_18842_18883[(2)] = null);

(statearr_18842_18883[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (1))){
var state_18839__$1 = state_18839;
var statearr_18843_18884 = state_18839__$1;
(statearr_18843_18884[(2)] = null);

(statearr_18843_18884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (24))){
var inst_18741 = (state_18839[(8)]);
var inst_18812 = (state_18839[(2)]);
var inst_18813 = fluree.db.flake.sid__GT_cid.call(null,inst_18812);
var inst_18814 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_18813);
var inst_18815 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_18816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18817 = [inst_18741];
var inst_18818 = (new cljs.core.PersistentVector(null,1,(5),inst_18816,inst_18817,null));
var inst_18819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18821 = [inst_18814];
var inst_18822 = (new cljs.core.PersistentVector(null,1,(5),inst_18820,inst_18821,null));
var inst_18823 = [inst_18822];
var inst_18824 = (new cljs.core.PersistentVector(null,1,(5),inst_18819,inst_18823,null));
var inst_18825 = cljs.core.PersistentHashMap.EMPTY;
var inst_18826 = [inst_18818,inst_18824,inst_18825];
var inst_18827 = cljs.core.PersistentHashMap.fromArrays(inst_18815,inst_18826);
var state_18839__$1 = state_18839;
var statearr_18844_18885 = state_18839__$1;
(statearr_18844_18885[(2)] = inst_18827);

(statearr_18844_18885[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (4))){
var inst_18732 = (state_18839[(2)]);
var state_18839__$1 = state_18839;
var statearr_18845_18886 = state_18839__$1;
(statearr_18845_18886[(2)] = inst_18732);

(statearr_18845_18886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (15))){
var inst_18739 = (state_18839[(7)]);
var inst_18741 = (state_18839[(8)]);
var inst_18760 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_18761 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_18762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18763 = [inst_18739];
var inst_18764 = (new cljs.core.PersistentVector(null,1,(5),inst_18762,inst_18763,null));
var inst_18765 = (function (){var subject_var = inst_18739;
var object_var = inst_18741;
var min_sid = inst_18760;
var max_sid = (0);
return (function (p1__18731_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__18731_SHARP_);
});
})();
var inst_18766 = cljs.core.range.call(null,inst_18760,(0));
var inst_18767 = cljs.core.map.call(null,inst_18765,inst_18766);
var inst_18768 = cljs.core.PersistentHashMap.EMPTY;
var inst_18769 = [inst_18764,inst_18767,inst_18768];
var inst_18770 = cljs.core.PersistentHashMap.fromArrays(inst_18761,inst_18769);
var state_18839__$1 = state_18839;
var statearr_18846_18887 = state_18839__$1;
(statearr_18846_18887[(2)] = inst_18770);

(statearr_18846_18887[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (21))){
var inst_18830 = (state_18839[(2)]);
var state_18839__$1 = state_18839;
var statearr_18847_18888 = state_18839__$1;
(statearr_18847_18888[(2)] = inst_18830);

(statearr_18847_18888[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (13))){
var inst_18741 = (state_18839[(8)]);
var state_18839__$1 = state_18839;
if(cljs.core.truth_(inst_18741)){
var statearr_18848_18889 = state_18839__$1;
(statearr_18848_18889[(1)] = (19));

} else {
var statearr_18849_18890 = state_18839__$1;
(statearr_18849_18890[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (22))){
var inst_18803 = (state_18839[(9)]);
var state_18839__$1 = state_18839;
var statearr_18850_18891 = state_18839__$1;
(statearr_18850_18891[(2)] = inst_18803);

(statearr_18850_18891[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (6))){
var inst_18741 = (state_18839[(8)]);
var state_18839__$1 = state_18839;
var statearr_18851_18892 = state_18839__$1;
(statearr_18851_18892[(2)] = inst_18741);

(statearr_18851_18892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (25))){
var inst_18809 = (state_18839[(2)]);
var inst_18810 = fluree.db.util.async.throw_err.call(null,inst_18809);
var state_18839__$1 = state_18839;
var statearr_18852_18893 = state_18839__$1;
(statearr_18852_18893[(2)] = inst_18810);

(statearr_18852_18893[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (17))){
var inst_18800 = (state_18839[(2)]);
var state_18839__$1 = state_18839;
var statearr_18853_18894 = state_18839__$1;
(statearr_18853_18894[(2)] = inst_18800);

(statearr_18853_18894[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (3))){
var inst_18837 = (state_18839[(2)]);
var state_18839__$1 = state_18839;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18839__$1,inst_18837);
} else {
if((state_val_18840 === (12))){
var inst_18754 = ["_tx",null,"_block",null];
var inst_18755 = (new cljs.core.PersistentArrayMap(null,2,inst_18754,null));
var inst_18756 = (new cljs.core.PersistentHashSet(null,inst_18755,null));
var inst_18757 = cljs.core.last.call(null,clause);
var inst_18758 = inst_18756.call(null,inst_18757);
var state_18839__$1 = state_18839;
if(cljs.core.truth_(inst_18758)){
var statearr_18854_18895 = state_18839__$1;
(statearr_18854_18895[(1)] = (15));

} else {
var statearr_18855_18896 = state_18839__$1;
(statearr_18855_18896[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (2))){
var inst_18739 = (state_18839[(7)]);
var _ = (function (){var statearr_18856 = state_18839;
(statearr_18856[(4)] = cljs.core.cons.call(null,(5),(state_18839[(4)])));

return statearr_18856;
})();
var inst_18738 = cljs.core.first.call(null,clause);
var inst_18739__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_18738);
var inst_18740 = cljs.core.last.call(null,clause);
var inst_18741 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_18740);
var state_18839__$1 = (function (){var statearr_18857 = state_18839;
(statearr_18857[(7)] = inst_18739__$1);

(statearr_18857[(8)] = inst_18741);

return statearr_18857;
})();
if(cljs.core.truth_(inst_18739__$1)){
var statearr_18858_18897 = state_18839__$1;
(statearr_18858_18897[(1)] = (6));

} else {
var statearr_18859_18898 = state_18839__$1;
(statearr_18859_18898[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (23))){
var inst_18803 = (state_18839[(9)]);
var inst_18807 = fluree.db.dbproto._subid.call(null,db,inst_18803);
var state_18839__$1 = state_18839;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18839__$1,(25),inst_18807);
} else {
if((state_val_18840 === (19))){
var inst_18803 = (state_18839[(9)]);
var inst_18803__$1 = cljs.core.first.call(null,clause);
var inst_18804 = typeof inst_18803__$1 === 'number';
var state_18839__$1 = (function (){var statearr_18860 = state_18839;
(statearr_18860[(9)] = inst_18803__$1);

return statearr_18860;
})();
if(cljs.core.truth_(inst_18804)){
var statearr_18861_18899 = state_18839__$1;
(statearr_18861_18899[(1)] = (22));

} else {
var statearr_18862_18900 = state_18839__$1;
(statearr_18862_18900[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (11))){
var inst_18834 = (state_18839[(2)]);
var _ = (function (){var statearr_18864 = state_18839;
(statearr_18864[(4)] = cljs.core.rest.call(null,(state_18839[(4)])));

return statearr_18864;
})();
var state_18839__$1 = state_18839;
var statearr_18865_18901 = state_18839__$1;
(statearr_18865_18901[(2)] = inst_18834);

(statearr_18865_18901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (9))){
var inst_18747 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18748 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_18749 = cljs.core.PersistentHashMap.fromArrays(inst_18747,inst_18748);
var inst_18750 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_18749);
var inst_18751 = (function(){throw inst_18750})();
var state_18839__$1 = state_18839;
var statearr_18866_18902 = state_18839__$1;
(statearr_18866_18902[(2)] = inst_18751);

(statearr_18866_18902[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (5))){
var _ = (function (){var statearr_18867 = state_18839;
(statearr_18867[(4)] = cljs.core.rest.call(null,(state_18839[(4)])));

return statearr_18867;
})();
var state_18839__$1 = state_18839;
var ex18863 = (state_18839__$1[(2)]);
var statearr_18868_18903 = state_18839__$1;
(statearr_18868_18903[(5)] = ex18863);


if((ex18863 instanceof Error)){
var statearr_18869_18904 = state_18839__$1;
(statearr_18869_18904[(1)] = (4));

(statearr_18869_18904[(5)] = null);

} else {
throw ex18863;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (14))){
var inst_18832 = (state_18839[(2)]);
var state_18839__$1 = state_18839;
var statearr_18870_18905 = state_18839__$1;
(statearr_18870_18905[(2)] = inst_18832);

(statearr_18870_18905[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (16))){
var inst_18773 = (state_18839[(10)]);
var inst_18776 = (state_18839[(11)]);
var inst_18775 = (state_18839[(12)]);
var inst_18772 = cljs.core.last.call(null,clause);
var inst_18773__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_18772);
var inst_18774 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_18775__$1 = cljs.core.get.call(null,inst_18774,inst_18773__$1);
var inst_18776__$1 = fluree.db.flake.min_subject_id.call(null,inst_18773__$1);
var inst_18777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18778 = [inst_18775__$1];
var inst_18779 = (new cljs.core.PersistentVector(null,1,(5),inst_18777,inst_18778,null));
var inst_18780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18781 = [inst_18776__$1];
var inst_18782 = (new cljs.core.PersistentVector(null,1,(5),inst_18780,inst_18781,null));
var inst_18783 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_18779,cljs.core._LT__EQ_,inst_18782);
var state_18839__$1 = (function (){var statearr_18871 = state_18839;
(statearr_18871[(10)] = inst_18773__$1);

(statearr_18871[(11)] = inst_18776__$1);

(statearr_18871[(12)] = inst_18775__$1);

return statearr_18871;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18839__$1,(18),inst_18783);
} else {
if((state_val_18840 === (10))){
var inst_18739 = (state_18839[(7)]);
var state_18839__$1 = state_18839;
if(cljs.core.truth_(inst_18739)){
var statearr_18872_18906 = state_18839__$1;
(statearr_18872_18906[(1)] = (12));

} else {
var statearr_18873_18907 = state_18839__$1;
(statearr_18873_18907[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (18))){
var inst_18773 = (state_18839[(10)]);
var inst_18739 = (state_18839[(7)]);
var inst_18776 = (state_18839[(11)]);
var inst_18741 = (state_18839[(8)]);
var inst_18775 = (state_18839[(12)]);
var inst_18785 = (state_18839[(2)]);
var inst_18786 = fluree.db.util.async.throw_err.call(null,inst_18785);
var inst_18787 = (function (){var subject_var = inst_18739;
var object_var = inst_18741;
var partition = inst_18773;
var max_sid = inst_18775;
var min_sid = inst_18776;
var flakes = inst_18786;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_18788 = cljs.core.map.call(null,inst_18787);
var inst_18789 = cljs.core.distinct.call(null);
var inst_18790 = cljs.core.comp.call(null,inst_18788,inst_18789);
var inst_18791 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_18792 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18793 = [inst_18739];
var inst_18794 = (new cljs.core.PersistentVector(null,1,(5),inst_18792,inst_18793,null));
var inst_18795 = cljs.core.sequence.call(null,inst_18790,inst_18786);
var inst_18796 = cljs.core.PersistentHashMap.EMPTY;
var inst_18797 = [inst_18794,inst_18795,inst_18796];
var inst_18798 = cljs.core.PersistentHashMap.fromArrays(inst_18791,inst_18797);
var state_18839__$1 = state_18839;
var statearr_18874_18908 = state_18839__$1;
(statearr_18874_18908[(2)] = inst_18798);

(statearr_18874_18908[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18840 === (8))){
var inst_18745 = (state_18839[(2)]);
var state_18839__$1 = state_18839;
if(cljs.core.truth_(inst_18745)){
var statearr_18875_18909 = state_18839__$1;
(statearr_18875_18909[(1)] = (9));

} else {
var statearr_18876_18910 = state_18839__$1;
(statearr_18876_18910[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_18877 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18877[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__);

(statearr_18877[(1)] = (1));

return statearr_18877;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1 = (function (state_18839){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_18839);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18878){var ex__2730__auto__ = e18878;
var statearr_18879_18911 = state_18839;
(statearr_18879_18911[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_18839[(4)]))){
var statearr_18880_18912 = state_18839;
(statearr_18880_18912[(1)] = cljs.core.first.call(null,(state_18839[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18913 = state_18839;
state_18839 = G__18913;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__ = function(state_18839){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1.call(this,state_18839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18881 = f__2750__auto__.call(null);
(statearr_18881[(6)] = c__2749__auto__);

return statearr_18881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__18919 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__18919 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__18919;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__4652__auto__ = (function fluree$db$query$analytical$variance_$_iter__18920(s__18921){
return (new cljs.core.LazySeq(null,(function (){
var s__18921__$1 = s__18921;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__18921__$1);
if(temp__5804__auto__){
var s__18921__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__18921__$2)){
var c__4650__auto__ = cljs.core.chunk_first.call(null,s__18921__$2);
var size__4651__auto__ = cljs.core.count.call(null,c__4650__auto__);
var b__18923 = cljs.core.chunk_buffer.call(null,size__4651__auto__);
if((function (){var i__18922 = (0);
while(true){
if((i__18922 < size__4651__auto__)){
var x = cljs.core._nth.call(null,c__4650__auto__,i__18922);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__18923,(delta * delta));

var G__18924 = (i__18922 + (1));
i__18922 = G__18924;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18923),fluree$db$query$analytical$variance_$_iter__18920.call(null,cljs.core.chunk_rest.call(null,s__18921__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18923),null);
}
} else {
var x = cljs.core.first.call(null,s__18921__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__18920.call(null,cljs.core.rest.call(null,s__18921__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4336__auto__ = n;
var y__4337__auto__ = (- n);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
}),(function() {
var G__18925 = null;
var G__18925__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__18925__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__18925 = function(n,coll){
switch(arguments.length){
case 1:
return G__18925__1.call(this,n);
case 2:
return G__18925__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18925.cljs$core$IFn$_invoke$arity$1 = G__18925__1;
G__18925.cljs$core$IFn$_invoke$arity$2 = G__18925__2;
return G__18925;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__18926 = null;
var G__18926__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__18926__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__18926 = function(n,coll){
switch(arguments.length){
case 1:
return G__18926__1.call(this,n);
case 2:
return G__18926__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18926.cljs$core$IFn$_invoke$arity$1 = G__18926__1;
G__18926.cljs$core$IFn$_invoke$arity$2 = G__18926__2;
return G__18926;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__18927 = null;
var G__18927__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__18927__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__18927 = function(n,coll){
switch(arguments.length){
case 1:
return G__18927__1.call(this,n);
case 2:
return G__18927__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18927.cljs$core$IFn$_invoke$arity$1 = G__18927__1;
G__18927.cljs$core$IFn$_invoke$arity$2 = G__18927__2;
return G__18927;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__18928 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__18928,(0),null);
var arg = cljs.core.nth.call(null,vec__18928,(1),null);
var var$ = cljs.core.nth.call(null,vec__18928,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__18931 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__18931,(0),null);
var variable = cljs.core.nth.call(null,vec__18931,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__18934 = agg;
var map__18934__$1 = cljs.core.__destructure_map.call(null,map__18934);
var variable = cljs.core.get.call(null,map__18934__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__18934__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var function$ = cljs.core.get.call(null,map__18934__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = function$.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__18936 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__18936,(0),null);
var agg_result = cljs.core.nth.call(null,vec__18936,(1),null);
var map__18939 = res__$1;
var map__18939__$1 = cljs.core.__destructure_map.call(null,map__18939);
var headers = cljs.core.get.call(null,map__18939__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__18939__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__18935_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__18935_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__18940_SHARP_){
return cljs.core.nth.call(null,tuple,p1__18940_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__18941_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__18941_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.call(null,(function (p1__18942_SHARP_,p2__18943_SHARP_){
return cljs.core.conj.call(null,p1__18942_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__18943_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__18944_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__18944_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__18947,row,b_tuple){
var vec__18948 = p__18947;
var acc = cljs.core.nth.call(null,vec__18948,(0),null);
var b_rows = cljs.core.nth.call(null,vec__18948,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__18945_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__18945_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__4253__auto__ = acc;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__18946_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__18946_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__18951_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__18951_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__18952_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__18952_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__18954_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__18954_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__18953_SHARP_){
return cljs.core.range.call(null,(0),p1__18953_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__18955_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__18955_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__18956_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__18956_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__18957_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__18957_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__18959_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__18959_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__18958_SHARP_){
return cljs.core.range.call(null,(0),p1__18958_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__18960_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__18960_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__18962 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__18962,(0),null);
var _ = cljs.core.nth.call(null,vec__18962,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__18961_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__18961_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var vec__18967 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filt,valid_vars);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__18967,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__18967,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__18965_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__18965_SHARP_);
}),filt_vars);
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__18966_SHARP_){
return cljs.core.nth.call(null,clause,p1__18966_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__18970,filters,optional_QMARK_){
var map__18971 = p__18970;
var map__18971__$1 = cljs.core.__destructure_map.call(null,map__18971);
var tuple_map = map__18971__$1;
var headers = cljs.core.get.call(null,map__18971__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__18971__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__18971__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__18972 = clause;
var k = cljs.core.nth.call(null,vec__18972,(0),null);
var v = cljs.core.nth.call(null,vec__18972,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__18975 = res;
var map__18975__$1 = cljs.core.__destructure_map.call(null,map__18975);
var headers = cljs.core.get.call(null,map__18975__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__18975__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5802__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19031){
var state_val_19032 = (state_19031[(1)]);
if((state_val_19032 === (7))){
var inst_19005 = (state_19031[(7)]);
var inst_19003 = (state_19031[(2)]);
var inst_19004 = fluree.db.util.async.throw_err.call(null,inst_19003);
var inst_19005__$1 = cljs.core.nth.call(null,inst_19004,(0),null);
var inst_19006 = cljs.core.nth.call(null,inst_19004,(1),null);
var inst_19007 = (inst_19005__$1 == null);
var state_19031__$1 = (function (){var statearr_19033 = state_19031;
(statearr_19033[(7)] = inst_19005__$1);

(statearr_19033[(8)] = inst_19006);

return statearr_19033;
})();
if(cljs.core.truth_(inst_19007)){
var statearr_19034_19063 = state_19031__$1;
(statearr_19034_19063[(1)] = (8));

} else {
var statearr_19035_19064 = state_19031__$1;
(statearr_19035_19064[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19032 === (1))){
var inst_18983 = optional_clauses;
var inst_18984 = cljs.core.seq.call(null,inst_18983);
var inst_18985 = cljs.core.first.call(null,inst_18984);
var inst_18986 = cljs.core.next.call(null,inst_18984);
var inst_18987 = where_tuples;
var inst_18988 = inst_18983;
var inst_18989 = inst_18987;
var state_19031__$1 = (function (){var statearr_19036 = state_19031;
(statearr_19036[(9)] = inst_18985);

(statearr_19036[(10)] = inst_18989);

(statearr_19036[(11)] = inst_18988);

(statearr_19036[(12)] = inst_18986);

return statearr_19036;
})();
var statearr_19037_19065 = state_19031__$1;
(statearr_19037_19065[(2)] = null);

(statearr_19037_19065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19032 === (4))){
var inst_18995 = (state_19031[(13)]);
var inst_18996 = (state_19031[(14)]);
var inst_18989 = (state_19031[(10)]);
var inst_19001 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_18989,inst_18995,inst_18996,true,fuel,max_fuel,opts);
var state_19031__$1 = state_19031;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19031__$1,(7),inst_19001);
} else {
if((state_val_19032 === (15))){
var state_19031__$1 = state_19031;
var statearr_19038_19066 = state_19031__$1;
(statearr_19038_19066[(2)] = null);

(statearr_19038_19066[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19032 === (13))){
var inst_19022 = (state_19031[(2)]);
var state_19031__$1 = state_19031;
var statearr_19039_19067 = state_19031__$1;
(statearr_19039_19067[(2)] = inst_19022);

(statearr_19039_19067[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19032 === (6))){
var inst_19027 = (state_19031[(2)]);
var state_19031__$1 = state_19031;
var statearr_19040_19068 = state_19031__$1;
(statearr_19040_19068[(2)] = inst_19027);

(statearr_19040_19068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19032 === (3))){
var inst_19029 = (state_19031[(2)]);
var state_19031__$1 = state_19031;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19031__$1,inst_19029);
} else {
if((state_val_19032 === (12))){
var state_19031__$1 = state_19031;
var statearr_19041_19069 = state_19031__$1;
(statearr_19041_19069[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19032 === (2))){
var inst_18995 = (state_19031[(13)]);
var inst_18988 = (state_19031[(11)]);
var inst_18994 = cljs.core.seq.call(null,inst_18988);
var inst_18995__$1 = cljs.core.first.call(null,inst_18994);
var inst_18996 = cljs.core.next.call(null,inst_18994);
var state_19031__$1 = (function (){var statearr_19043 = state_19031;
(statearr_19043[(13)] = inst_18995__$1);

(statearr_19043[(14)] = inst_18996);

return statearr_19043;
})();
if(cljs.core.truth_(inst_18995__$1)){
var statearr_19044_19070 = state_19031__$1;
(statearr_19044_19070[(1)] = (4));

} else {
var statearr_19045_19071 = state_19031__$1;
(statearr_19045_19071[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19032 === (11))){
var inst_19005 = (state_19031[(7)]);
var inst_19006 = (state_19031[(8)]);
var inst_18988 = inst_19006;
var inst_18989 = inst_19005;
var state_19031__$1 = (function (){var statearr_19046 = state_19031;
(statearr_19046[(10)] = inst_18989);

(statearr_19046[(11)] = inst_18988);

return statearr_19046;
})();
var statearr_19047_19072 = state_19031__$1;
(statearr_19047_19072[(2)] = null);

(statearr_19047_19072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19032 === (9))){
var inst_18995 = (state_19031[(13)]);
var inst_19011 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_18995);
var state_19031__$1 = state_19031;
if(cljs.core.truth_(inst_19011)){
var statearr_19048_19073 = state_19031__$1;
(statearr_19048_19073[(1)] = (11));

} else {
var statearr_19049_19074 = state_19031__$1;
(statearr_19049_19074[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19032 === (5))){
var inst_18989 = (state_19031[(10)]);
var state_19031__$1 = state_19031;
var statearr_19050_19075 = state_19031__$1;
(statearr_19050_19075[(2)] = inst_18989);

(statearr_19050_19075[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19032 === (14))){
var inst_19005 = (state_19031[(7)]);
var inst_18989 = (state_19031[(10)]);
var inst_19006 = (state_19031[(8)]);
var inst_19016 = fluree.db.query.analytical.left_outer_join.call(null,inst_18989,inst_19005);
var inst_18988 = inst_19006;
var inst_18989__$1 = inst_19016;
var state_19031__$1 = (function (){var statearr_19051 = state_19031;
(statearr_19051[(10)] = inst_18989__$1);

(statearr_19051[(11)] = inst_18988);

return statearr_19051;
})();
var statearr_19052_19076 = state_19031__$1;
(statearr_19052_19076[(2)] = null);

(statearr_19052_19076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19032 === (16))){
var inst_19020 = (state_19031[(2)]);
var state_19031__$1 = state_19031;
var statearr_19054_19077 = state_19031__$1;
(statearr_19054_19077[(2)] = inst_19020);

(statearr_19054_19077[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19032 === (10))){
var inst_19024 = (state_19031[(2)]);
var state_19031__$1 = state_19031;
var statearr_19055_19078 = state_19031__$1;
(statearr_19055_19078[(2)] = inst_19024);

(statearr_19055_19078[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19032 === (8))){
var inst_18989 = (state_19031[(10)]);
var inst_19006 = (state_19031[(8)]);
var tmp19053 = inst_18989;
var inst_18988 = inst_19006;
var inst_18989__$1 = tmp19053;
var state_19031__$1 = (function (){var statearr_19056 = state_19031;
(statearr_19056[(10)] = inst_18989__$1);

(statearr_19056[(11)] = inst_18988);

return statearr_19056;
})();
var statearr_19057_19079 = state_19031__$1;
(statearr_19057_19079[(2)] = null);

(statearr_19057_19079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0 = (function (){
var statearr_19058 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19058[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__);

(statearr_19058[(1)] = (1));

return statearr_19058;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1 = (function (state_19031){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_19031);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19059){var ex__2730__auto__ = e19059;
var statearr_19060_19080 = state_19031;
(statearr_19060_19080[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_19031[(4)]))){
var statearr_19061_19081 = state_19031;
(statearr_19061_19081[(1)] = cljs.core.first.call(null,(state_19031[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19082 = state_19031;
state_19031 = G__19082;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__ = function(state_19031){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1.call(this,state_19031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19062 = f__2750__auto__.call(null);
(statearr_19062[(6)] = c__2749__auto__);

return statearr_19062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__19084){
var vec__19085 = p__19084;
var var_name = cljs.core.nth.call(null,vec__19085,(0),null);
var var_val = cljs.core.nth.call(null,vec__19085,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__19083_SHARP_){
return cljs.core.conj.call(null,p1__19083_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__19089,p__19090,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__19091 = p__19089;
var map__19091__$1 = cljs.core.__destructure_map.call(null,map__19091);
var q_map = map__19091__$1;
var prefixes = cljs.core.get.call(null,map__19091__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__19092 = p__19090;
var map__19092__$1 = cljs.core.__destructure_map.call(null,map__19092);
var res = map__19092__$1;
var vars = cljs.core.get.call(null,map__19092__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19329){
var state_val_19330 = (state_19329[(1)]);
if((state_val_19330 === (65))){
var inst_19279 = (state_19329[(7)]);
var inst_19278 = (state_19329[(8)]);
var inst_19290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19291 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_19278,res,inst_19279);
var inst_19292 = [inst_19291,r];
var inst_19293 = (new cljs.core.PersistentVector(null,2,(5),inst_19290,inst_19292,null));
var state_19329__$1 = state_19329;
var statearr_19331_19436 = state_19329__$1;
(statearr_19331_19436[(2)] = inst_19293);

(statearr_19331_19436[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (70))){
var inst_19305 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19332_19437 = state_19329__$1;
(statearr_19332_19437[(2)] = inst_19305);

(statearr_19332_19437[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (62))){
var inst_19279 = (state_19329[(7)]);
var inst_19287 = cljs.core.second.call(null,inst_19279);
var inst_19288 = clojure.string.starts_with_QMARK_.call(null,inst_19287,"fullText:");
var state_19329__$1 = state_19329;
if(inst_19288){
var statearr_19333_19438 = state_19329__$1;
(statearr_19333_19438[(1)] = (65));

} else {
var statearr_19334_19439 = state_19329__$1;
(statearr_19334_19439[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (7))){
var inst_19198 = (state_19329[(9)]);
var inst_19197 = cljs.core.count.call(null,clause);
var inst_19198__$1 = cljs.core._EQ_.call(null,(3),inst_19197);
var state_19329__$1 = (function (){var statearr_19335 = state_19329;
(statearr_19335[(9)] = inst_19198__$1);

return statearr_19335;
})();
if(inst_19198__$1){
var statearr_19336_19440 = state_19329__$1;
(statearr_19336_19440[(1)] = (31));

} else {
var statearr_19337_19441 = state_19329__$1;
(statearr_19337_19441[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (59))){
var inst_19312 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19338_19442 = state_19329__$1;
(statearr_19338_19442[(2)] = inst_19312);

(statearr_19338_19442[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (20))){
var inst_19161 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19339_19443 = state_19329__$1;
(statearr_19339_19443[(2)] = inst_19161);

(statearr_19339_19443[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (58))){
var state_19329__$1 = state_19329;
var statearr_19340_19444 = state_19329__$1;
(statearr_19340_19444[(2)] = null);

(statearr_19340_19444[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (60))){
var inst_19278 = (state_19329[(8)]);
var inst_19276 = (state_19329[(2)]);
var inst_19277 = fluree.db.util.async.throw_err.call(null,inst_19276);
var inst_19278__$1 = cljs.core.nth.call(null,inst_19277,(0),null);
var inst_19279 = cljs.core.nth.call(null,inst_19277,(1),null);
var inst_19280 = cljs.core._EQ_.call(null,"$wd",inst_19278__$1);
var state_19329__$1 = (function (){var statearr_19341 = state_19329;
(statearr_19341[(7)] = inst_19279);

(statearr_19341[(8)] = inst_19278__$1);

return statearr_19341;
})();
if(inst_19280){
var statearr_19342_19445 = state_19329__$1;
(statearr_19342_19445[(1)] = (61));

} else {
var statearr_19343_19446 = state_19329__$1;
(statearr_19343_19446[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (27))){
var inst_19191 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19344_19447 = state_19329__$1;
(statearr_19344_19447[(2)] = inst_19191);

(statearr_19344_19447[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (1))){
var state_19329__$1 = state_19329;
var statearr_19345_19448 = state_19329__$1;
(statearr_19345_19448[(2)] = null);

(statearr_19345_19448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (69))){
var state_19329__$1 = state_19329;
var statearr_19346_19449 = state_19329__$1;
(statearr_19346_19449[(2)] = null);

(statearr_19346_19449[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (24))){
var inst_19155 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19347_19450 = state_19329__$1;
(statearr_19347_19450[(2)] = inst_19155);

(statearr_19347_19450[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (55))){
var inst_19261 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_19262 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19263 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19264 = cljs.core.PersistentHashMap.fromArrays(inst_19262,inst_19263);
var inst_19265 = cljs.core.ex_info.call(null,inst_19261,inst_19264);
var inst_19266 = (function(){throw inst_19265})();
var state_19329__$1 = state_19329;
var statearr_19348_19451 = state_19329__$1;
(statearr_19348_19451[(2)] = inst_19266);

(statearr_19348_19451[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (39))){
var inst_19218 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
if(cljs.core.truth_(inst_19218)){
var statearr_19349_19452 = state_19329__$1;
(statearr_19349_19452[(1)] = (40));

} else {
var statearr_19350_19453 = state_19329__$1;
(statearr_19350_19453[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (46))){
var inst_19318 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19351_19454 = state_19329__$1;
(statearr_19351_19454[(2)] = inst_19318);

(statearr_19351_19454[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (4))){
var inst_19093 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19352_19455 = state_19329__$1;
(statearr_19352_19455[(2)] = inst_19093);

(statearr_19352_19455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (54))){
var inst_19254 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_19255 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19256 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_19257 = cljs.core.PersistentHashMap.fromArrays(inst_19255,inst_19256);
var inst_19258 = cljs.core.ex_info.call(null,inst_19254,inst_19257);
var inst_19259 = (function(){throw inst_19258})();
var state_19329__$1 = state_19329;
var statearr_19353_19456 = state_19329__$1;
(statearr_19353_19456[(2)] = inst_19259);

(statearr_19353_19456[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (15))){
var inst_19193 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19354_19457 = state_19329__$1;
(statearr_19354_19457[(2)] = inst_19193);

(statearr_19354_19457[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (48))){
var inst_19242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19243 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_19244 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_19243);
var inst_19245 = [inst_19244,r];
var inst_19246 = (new cljs.core.PersistentVector(null,2,(5),inst_19242,inst_19245,null));
var state_19329__$1 = state_19329;
var statearr_19355_19458 = state_19329__$1;
(statearr_19355_19458[(2)] = inst_19246);

(statearr_19355_19458[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (50))){
var inst_19316 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19356_19459 = state_19329__$1;
(statearr_19356_19459[(2)] = inst_19316);

(statearr_19356_19459[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (21))){
var inst_19129 = (state_19329[(10)]);
var inst_19139 = (state_19329[(11)]);
var inst_19130 = (state_19329[(12)]);
var inst_19102 = (state_19329[(13)]);
var inst_19138 = (state_19329[(14)]);
var inst_19132 = (state_19329[(15)]);
var inst_19127 = (state_19329[(16)]);
var inst_19131 = (state_19329[(17)]);
var inst_19106 = (state_19329[(18)]);
var inst_19143 = (state_19329[(2)]);
var inst_19144 = fluree.db.util.async.throw_err.call(null,inst_19143);
var inst_19145 = (function (){var new_res = inst_19144;
var vec__19124 = inst_19127;
var rest = inst_19139;
var seq__19125 = inst_19130;
var seq__19135 = inst_19139;
var vec__19134 = inst_19131;
var tuples = inst_19132;
var first__19136 = inst_19138;
var G__19123 = inst_19131;
var pred__19103 = inst_19106;
var first__19126 = inst_19129;
var segment_type = inst_19102;
var clause_group = inst_19138;
var expr__19104 = inst_19102;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_19146 = cljs.core.keys.call(null,vars);
var inst_19147 = cljs.core.reduce.call(null,inst_19145,inst_19144,inst_19146);
var inst_19148 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_19147);
var state_19329__$1 = (function (){var statearr_19357 = state_19329;
(statearr_19357[(19)] = inst_19148);

return statearr_19357;
})();
if(cljs.core.truth_(inst_19132)){
var statearr_19358_19460 = state_19329__$1;
(statearr_19358_19460[(1)] = (22));

} else {
var statearr_19359_19461 = state_19329__$1;
(statearr_19359_19461[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (31))){
var inst_19200 = cljs.core.second.call(null,clause);
var inst_19201 = clojure.string.starts_with_QMARK_.call(null,inst_19200,"fullText:");
var state_19329__$1 = state_19329;
var statearr_19360_19462 = state_19329__$1;
(statearr_19360_19462[(2)] = inst_19201);

(statearr_19360_19462[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (32))){
var inst_19198 = (state_19329[(9)]);
var state_19329__$1 = state_19329;
var statearr_19361_19463 = state_19329__$1;
(statearr_19361_19463[(2)] = inst_19198);

(statearr_19361_19463[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (40))){
var inst_19220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19221 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_19329__$1 = (function (){var statearr_19362 = state_19329;
(statearr_19362[(20)] = inst_19220);

return statearr_19362;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19329__$1,(43),inst_19221);
} else {
if((state_val_19330 === (56))){
var inst_19268 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19363_19464 = state_19329__$1;
(statearr_19363_19464[(2)] = inst_19268);

(statearr_19363_19464[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (33))){
var inst_19204 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
if(cljs.core.truth_(inst_19204)){
var statearr_19364_19465 = state_19329__$1;
(statearr_19364_19465[(1)] = (34));

} else {
var statearr_19365_19466 = state_19329__$1;
(statearr_19365_19466[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (13))){
var inst_19127 = (state_19329[(16)]);
var inst_19127__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_19128 = cljs.core.seq.call(null,inst_19127__$1);
var inst_19129 = cljs.core.first.call(null,inst_19128);
var inst_19130 = cljs.core.next.call(null,inst_19128);
var inst_19131 = inst_19127__$1;
var inst_19132 = null;
var state_19329__$1 = (function (){var statearr_19366 = state_19329;
(statearr_19366[(10)] = inst_19129);

(statearr_19366[(12)] = inst_19130);

(statearr_19366[(15)] = inst_19132);

(statearr_19366[(16)] = inst_19127__$1);

(statearr_19366[(17)] = inst_19131);

return statearr_19366;
})();
var statearr_19367_19467 = state_19329__$1;
(statearr_19367_19467[(2)] = null);

(statearr_19367_19467[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (22))){
var inst_19139 = (state_19329[(11)]);
var inst_19148 = (state_19329[(19)]);
var inst_19132 = (state_19329[(15)]);
var inst_19150 = fluree.db.query.union.results.call(null,inst_19132,inst_19148);
var inst_19131 = inst_19139;
var inst_19132__$1 = inst_19150;
var state_19329__$1 = (function (){var statearr_19368 = state_19329;
(statearr_19368[(15)] = inst_19132__$1);

(statearr_19368[(17)] = inst_19131);

return statearr_19368;
})();
var statearr_19369_19468 = state_19329__$1;
(statearr_19369_19468[(2)] = null);

(statearr_19369_19468[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (36))){
var inst_19322 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19370_19469 = state_19329__$1;
(statearr_19370_19469[(2)] = inst_19322);

(statearr_19370_19469[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (41))){
var inst_19228 = cljs.core.count.call(null,clause);
var inst_19229 = cljs.core._EQ_.call(null,(3),inst_19228);
var state_19329__$1 = state_19329;
if(inst_19229){
var statearr_19371_19470 = state_19329__$1;
(statearr_19371_19470[(1)] = (44));

} else {
var statearr_19372_19471 = state_19329__$1;
(statearr_19372_19471[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (43))){
var inst_19220 = (state_19329[(20)]);
var inst_19223 = (state_19329[(2)]);
var inst_19224 = fluree.db.util.async.throw_err.call(null,inst_19223);
var inst_19225 = [inst_19224,r];
var inst_19226 = (new cljs.core.PersistentVector(null,2,(5),inst_19220,inst_19225,null));
var state_19329__$1 = state_19329;
var statearr_19373_19472 = state_19329__$1;
(statearr_19373_19472[(2)] = inst_19226);

(statearr_19373_19472[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (61))){
var inst_19279 = (state_19329[(7)]);
var inst_19282 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_19279,r,res,optional_QMARK_,fuel,max_fuel);
var state_19329__$1 = state_19329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19329__$1,(64),inst_19282);
} else {
if((state_val_19330 === (29))){
var inst_19102 = (state_19329[(13)]);
var inst_19185 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19102)].join('');
var inst_19186 = (new Error(inst_19185));
var inst_19187 = (function(){throw inst_19186})();
var state_19329__$1 = state_19329;
var statearr_19374_19473 = state_19329__$1;
(statearr_19374_19473[(2)] = inst_19187);

(statearr_19374_19473[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (44))){
var inst_19231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19232 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_19329__$1 = (function (){var statearr_19375 = state_19329;
(statearr_19375[(21)] = inst_19231);

return statearr_19375;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19329__$1,(47),inst_19232);
} else {
if((state_val_19330 === (6))){
var inst_19102 = (state_19329[(13)]);
var inst_19106 = (state_19329[(18)]);
var inst_19101 = cljs.core.keys.call(null,clause);
var inst_19102__$1 = cljs.core.first.call(null,inst_19101);
var inst_19106__$1 = cljs.core._EQ_;
var inst_19107 = inst_19106__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_19102__$1);
var state_19329__$1 = (function (){var statearr_19376 = state_19329;
(statearr_19376[(13)] = inst_19102__$1);

(statearr_19376[(18)] = inst_19106__$1);

return statearr_19376;
})();
if(cljs.core.truth_(inst_19107)){
var statearr_19377_19474 = state_19329__$1;
(statearr_19377_19474[(1)] = (9));

} else {
var statearr_19378_19475 = state_19329__$1;
(statearr_19378_19475[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (28))){
var inst_19179 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19180 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_19181 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_19180,optional_QMARK_);
var inst_19182 = [inst_19181,r];
var inst_19183 = (new cljs.core.PersistentVector(null,2,(5),inst_19179,inst_19182,null));
var state_19329__$1 = state_19329;
var statearr_19379_19476 = state_19329__$1;
(statearr_19379_19476[(2)] = inst_19183);

(statearr_19379_19476[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (64))){
var inst_19284 = (state_19329[(2)]);
var inst_19285 = fluree.db.util.async.throw_err.call(null,inst_19284);
var state_19329__$1 = state_19329;
var statearr_19380_19477 = state_19329__$1;
(statearr_19380_19477[(2)] = inst_19285);

(statearr_19380_19477[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (51))){
var inst_19251 = cljs.core.first.call(null,clause);
var inst_19252 = cljs.core.sequential_QMARK_.call(null,inst_19251);
var state_19329__$1 = state_19329;
if(inst_19252){
var statearr_19381_19478 = state_19329__$1;
(statearr_19381_19478[(1)] = (54));

} else {
var statearr_19382_19479 = state_19329__$1;
(statearr_19382_19479[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (25))){
var inst_19102 = (state_19329[(13)]);
var inst_19106 = (state_19329[(18)]);
var inst_19167 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_19168 = (function (){var segment_type = inst_19102;
var pred__19103 = inst_19106;
var expr__19104 = inst_19102;
var bindings = inst_19167;
return (function (p1__19088_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__19088_SHARP_);
});
})();
var inst_19169 = cljs.core.map.call(null,inst_19168,inst_19167);
var inst_19170 = cljs.core.PersistentHashMap.EMPTY;
var inst_19171 = cljs.core.into.call(null,inst_19170,inst_19169);
var inst_19172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19173 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_19171);
var inst_19174 = [inst_19173,r];
var inst_19175 = (new cljs.core.PersistentVector(null,2,(5),inst_19172,inst_19174,null));
var state_19329__$1 = state_19329;
var statearr_19383_19480 = state_19329__$1;
(statearr_19383_19480[(2)] = inst_19175);

(statearr_19383_19480[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (34))){
var inst_19206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19207 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_19208 = [inst_19207,r];
var inst_19209 = (new cljs.core.PersistentVector(null,2,(5),inst_19206,inst_19208,null));
var state_19329__$1 = state_19329;
var statearr_19384_19481 = state_19329__$1;
(statearr_19384_19481[(2)] = inst_19209);

(statearr_19384_19481[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (17))){
var inst_19163 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19385_19482 = state_19329__$1;
(statearr_19385_19482[(2)] = inst_19163);

(statearr_19385_19482[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (3))){
var inst_19327 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19329__$1,inst_19327);
} else {
if((state_val_19330 === (12))){
var inst_19109 = (state_19329[(22)]);
var inst_19113 = (state_19329[(2)]);
var inst_19114 = fluree.db.util.async.throw_err.call(null,inst_19113);
var inst_19115 = [inst_19114,r];
var inst_19116 = (new cljs.core.PersistentVector(null,2,(5),inst_19109,inst_19115,null));
var state_19329__$1 = state_19329;
var statearr_19386_19483 = state_19329__$1;
(statearr_19386_19483[(2)] = inst_19116);

(statearr_19386_19483[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (2))){
var _ = (function (){var statearr_19387 = state_19329;
(statearr_19387[(4)] = cljs.core.cons.call(null,(5),(state_19329[(4)])));

return statearr_19387;
})();
var inst_19099 = cljs.core.map_QMARK_.call(null,clause);
var state_19329__$1 = state_19329;
if(inst_19099){
var statearr_19388_19484 = state_19329__$1;
(statearr_19388_19484[(1)] = (6));

} else {
var statearr_19389_19485 = state_19329__$1;
(statearr_19389_19485[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (66))){
var state_19329__$1 = state_19329;
var statearr_19390_19486 = state_19329__$1;
(statearr_19390_19486[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (23))){
var inst_19139 = (state_19329[(11)]);
var inst_19148 = (state_19329[(19)]);
var inst_19131 = inst_19139;
var inst_19132 = inst_19148;
var state_19329__$1 = (function (){var statearr_19392 = state_19329;
(statearr_19392[(15)] = inst_19132);

(statearr_19392[(17)] = inst_19131);

return statearr_19392;
})();
var statearr_19393_19487 = state_19329__$1;
(statearr_19393_19487[(2)] = null);

(statearr_19393_19487[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (47))){
var inst_19231 = (state_19329[(21)]);
var inst_19234 = (state_19329[(2)]);
var inst_19235 = fluree.db.util.async.throw_err.call(null,inst_19234);
var inst_19236 = [inst_19235,r];
var inst_19237 = (new cljs.core.PersistentVector(null,2,(5),inst_19231,inst_19236,null));
var state_19329__$1 = state_19329;
var statearr_19394_19488 = state_19329__$1;
(statearr_19394_19488[(2)] = inst_19237);

(statearr_19394_19488[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (35))){
var inst_19212 = (state_19329[(23)]);
var inst_19211 = cljs.core.count.call(null,clause);
var inst_19212__$1 = cljs.core._EQ_.call(null,(3),inst_19211);
var state_19329__$1 = (function (){var statearr_19395 = state_19329;
(statearr_19395[(23)] = inst_19212__$1);

return statearr_19395;
})();
if(inst_19212__$1){
var statearr_19396_19489 = state_19329__$1;
(statearr_19396_19489[(1)] = (37));

} else {
var statearr_19397_19490 = state_19329__$1;
(statearr_19397_19490[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (19))){
var inst_19132 = (state_19329[(15)]);
var inst_19157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19158 = [inst_19132,r];
var inst_19159 = (new cljs.core.PersistentVector(null,2,(5),inst_19157,inst_19158,null));
var state_19329__$1 = state_19329;
var statearr_19398_19491 = state_19329__$1;
(statearr_19398_19491[(2)] = inst_19159);

(statearr_19398_19491[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (57))){
var inst_19274 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_19329__$1 = state_19329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19329__$1,(60),inst_19274);
} else {
if((state_val_19330 === (68))){
var inst_19279 = (state_19329[(7)]);
var inst_19278 = (state_19329[(8)]);
var inst_19296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19297 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_19278,res,inst_19279,fuel,max_fuel);
var state_19329__$1 = (function (){var statearr_19399 = state_19329;
(statearr_19399[(24)] = inst_19296);

return statearr_19399;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19329__$1,(71),inst_19297);
} else {
if((state_val_19330 === (11))){
var inst_19195 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19401_19492 = state_19329__$1;
(statearr_19401_19492[(2)] = inst_19195);

(statearr_19401_19492[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (9))){
var inst_19109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19110 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_19111 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_19110,res,fuel,max_fuel,opts);
var state_19329__$1 = (function (){var statearr_19402 = state_19329;
(statearr_19402[(22)] = inst_19109);

return statearr_19402;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19329__$1,(12),inst_19111);
} else {
if((state_val_19330 === (5))){
var _ = (function (){var statearr_19403 = state_19329;
(statearr_19403[(4)] = cljs.core.rest.call(null,(state_19329[(4)])));

return statearr_19403;
})();
var state_19329__$1 = state_19329;
var ex19400 = (state_19329__$1[(2)]);
var statearr_19404_19493 = state_19329__$1;
(statearr_19404_19493[(5)] = ex19400);


if((ex19400 instanceof Error)){
var statearr_19405_19494 = state_19329__$1;
(statearr_19405_19494[(1)] = (4));

(statearr_19405_19494[(5)] = null);

} else {
throw ex19400;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (14))){
var inst_19102 = (state_19329[(13)]);
var inst_19106 = (state_19329[(18)]);
var inst_19165 = inst_19106.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_19102);
var state_19329__$1 = state_19329;
if(cljs.core.truth_(inst_19165)){
var statearr_19406_19495 = state_19329__$1;
(statearr_19406_19495[(1)] = (25));

} else {
var statearr_19407_19496 = state_19329__$1;
(statearr_19407_19496[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (45))){
var inst_19239 = cljs.core.count.call(null,clause);
var inst_19240 = cljs.core._EQ_.call(null,(2),inst_19239);
var state_19329__$1 = state_19329;
if(inst_19240){
var statearr_19408_19497 = state_19329__$1;
(statearr_19408_19497[(1)] = (48));

} else {
var statearr_19409_19498 = state_19329__$1;
(statearr_19409_19498[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (53))){
var inst_19314 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19410_19499 = state_19329__$1;
(statearr_19410_19499[(2)] = inst_19314);

(statearr_19410_19499[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (26))){
var inst_19102 = (state_19329[(13)]);
var inst_19106 = (state_19329[(18)]);
var inst_19177 = inst_19106.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_19102);
var state_19329__$1 = state_19329;
if(cljs.core.truth_(inst_19177)){
var statearr_19411_19500 = state_19329__$1;
(statearr_19411_19500[(1)] = (28));

} else {
var statearr_19412_19501 = state_19329__$1;
(statearr_19412_19501[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (16))){
var inst_19138 = (state_19329[(14)]);
var inst_19131 = (state_19329[(17)]);
var inst_19137 = cljs.core.seq.call(null,inst_19131);
var inst_19138__$1 = cljs.core.first.call(null,inst_19137);
var inst_19139 = cljs.core.next.call(null,inst_19137);
var state_19329__$1 = (function (){var statearr_19413 = state_19329;
(statearr_19413[(11)] = inst_19139);

(statearr_19413[(14)] = inst_19138__$1);

return statearr_19413;
})();
if(cljs.core.truth_(inst_19138__$1)){
var statearr_19414_19502 = state_19329__$1;
(statearr_19414_19502[(1)] = (18));

} else {
var statearr_19415_19503 = state_19329__$1;
(statearr_19415_19503[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (38))){
var inst_19212 = (state_19329[(23)]);
var state_19329__$1 = state_19329;
var statearr_19416_19504 = state_19329__$1;
(statearr_19416_19504[(2)] = inst_19212);

(statearr_19416_19504[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (30))){
var inst_19189 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19417_19505 = state_19329__$1;
(statearr_19417_19505[(2)] = inst_19189);

(statearr_19417_19505[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (10))){
var inst_19102 = (state_19329[(13)]);
var inst_19106 = (state_19329[(18)]);
var inst_19118 = inst_19106.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_19102);
var state_19329__$1 = state_19329;
if(cljs.core.truth_(inst_19118)){
var statearr_19418_19506 = state_19329__$1;
(statearr_19418_19506[(1)] = (13));

} else {
var statearr_19419_19507 = state_19329__$1;
(statearr_19419_19507[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (18))){
var inst_19138 = (state_19329[(14)]);
var inst_19141 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_19138,q_map,vars,fuel,max_fuel,opts);
var state_19329__$1 = state_19329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19329__$1,(21),inst_19141);
} else {
if((state_val_19330 === (52))){
var state_19329__$1 = state_19329;
var statearr_19420_19508 = state_19329__$1;
(statearr_19420_19508[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (67))){
var inst_19307 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19422_19509 = state_19329__$1;
(statearr_19422_19509[(2)] = inst_19307);

(statearr_19422_19509[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (71))){
var inst_19296 = (state_19329[(24)]);
var inst_19299 = (state_19329[(2)]);
var inst_19300 = fluree.db.util.async.throw_err.call(null,inst_19299);
var inst_19301 = [inst_19300,r];
var inst_19302 = (new cljs.core.PersistentVector(null,2,(5),inst_19296,inst_19301,null));
var state_19329__$1 = state_19329;
var statearr_19423_19510 = state_19329__$1;
(statearr_19423_19510[(2)] = inst_19302);

(statearr_19423_19510[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (42))){
var inst_19320 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19424_19511 = state_19329__$1;
(statearr_19424_19511[(2)] = inst_19320);

(statearr_19424_19511[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (37))){
var inst_19214 = cljs.core.second.call(null,clause);
var inst_19215 = cljs.core._EQ_.call(null,inst_19214,"rdf:type");
var state_19329__$1 = state_19329;
var statearr_19425_19512 = state_19329__$1;
(statearr_19425_19512[(2)] = inst_19215);

(statearr_19425_19512[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (63))){
var inst_19309 = (state_19329[(2)]);
var state_19329__$1 = state_19329;
var statearr_19426_19513 = state_19329__$1;
(statearr_19426_19513[(2)] = inst_19309);

(statearr_19426_19513[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (8))){
var inst_19324 = (state_19329[(2)]);
var _ = (function (){var statearr_19427 = state_19329;
(statearr_19427[(4)] = cljs.core.rest.call(null,(state_19329[(4)])));

return statearr_19427;
})();
var state_19329__$1 = state_19329;
var statearr_19428_19514 = state_19329__$1;
(statearr_19428_19514[(2)] = inst_19324);

(statearr_19428_19514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19330 === (49))){
var inst_19248 = cljs.core.count.call(null,clause);
var inst_19249 = cljs.core._EQ_.call(null,(1),inst_19248);
var state_19329__$1 = state_19329;
if(inst_19249){
var statearr_19429_19515 = state_19329__$1;
(statearr_19429_19515[(1)] = (51));

} else {
var statearr_19430_19516 = state_19329__$1;
(statearr_19430_19516[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_19431 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19431[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__);

(statearr_19431[(1)] = (1));

return statearr_19431;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1 = (function (state_19329){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_19329);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19432){var ex__2730__auto__ = e19432;
var statearr_19433_19517 = state_19329;
(statearr_19433_19517[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_19329[(4)]))){
var statearr_19434_19518 = state_19329;
(statearr_19434_19518[(1)] = cljs.core.first.call(null,(state_19329[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19519 = state_19329;
state_19329 = G__19519;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__ = function(state_19329){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1.call(this,state_19329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19435 = f__2750__auto__.call(null);
(statearr_19435[(6)] = c__2749__auto__);

return statearr_19435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__19521 = arguments.length;
switch (G__19521) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19601){
var state_val_19602 = (state_19601[(1)]);
if((state_val_19602 === (7))){
var inst_19596 = (state_19601[(2)]);
var _ = (function (){var statearr_19603 = state_19601;
(statearr_19603[(4)] = cljs.core.rest.call(null,(state_19601[(4)])));

return statearr_19603;
})();
var state_19601__$1 = state_19601;
var statearr_19604_19652 = state_19601__$1;
(statearr_19604_19652[(2)] = inst_19596);

(statearr_19604_19652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (20))){
var inst_19561 = (state_19601[(7)]);
var inst_19573 = (state_19601[(2)]);
var inst_19543 = inst_19561;
var inst_19544 = inst_19573;
var state_19601__$1 = (function (){var statearr_19605 = state_19601;
(statearr_19605[(8)] = inst_19544);

(statearr_19605[(9)] = inst_19543);

return statearr_19605;
})();
var statearr_19606_19653 = state_19601__$1;
(statearr_19606_19653[(2)] = null);

(statearr_19606_19653[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (1))){
var state_19601__$1 = state_19601;
var statearr_19607_19654 = state_19601__$1;
(statearr_19607_19654[(2)] = null);

(statearr_19607_19654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (24))){
var inst_19561 = (state_19601[(7)]);
var inst_19544 = (state_19601[(8)]);
var inst_19560 = (state_19601[(10)]);
var inst_19581 = fluree.db.query.analytical.inner_join.call(null,inst_19544,inst_19560);
var inst_19543 = inst_19561;
var inst_19544__$1 = inst_19581;
var state_19601__$1 = (function (){var statearr_19608 = state_19601;
(statearr_19608[(8)] = inst_19544__$1);

(statearr_19608[(9)] = inst_19543);

return statearr_19608;
})();
var statearr_19609_19655 = state_19601__$1;
(statearr_19609_19655[(2)] = null);

(statearr_19609_19655[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (4))){
var inst_19522 = (state_19601[(2)]);
var state_19601__$1 = state_19601;
var statearr_19611_19656 = state_19601__$1;
(statearr_19611_19656[(2)] = inst_19522);

(statearr_19611_19656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (15))){
var inst_19560 = (state_19601[(10)]);
var state_19601__$1 = state_19601;
if(cljs.core.truth_(inst_19560)){
var statearr_19612_19657 = state_19601__$1;
(statearr_19612_19657[(1)] = (18));

} else {
var statearr_19613_19658 = state_19601__$1;
(statearr_19613_19658[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (21))){
var inst_19561 = (state_19601[(7)]);
var inst_19544 = (state_19601[(8)]);
var tmp19610 = inst_19544;
var inst_19543 = inst_19561;
var inst_19544__$1 = tmp19610;
var state_19601__$1 = (function (){var statearr_19614 = state_19601;
(statearr_19614[(8)] = inst_19544__$1);

(statearr_19614[(9)] = inst_19543);

return statearr_19614;
})();
var statearr_19615_19659 = state_19601__$1;
(statearr_19615_19659[(2)] = null);

(statearr_19615_19659[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (13))){
var inst_19544 = (state_19601[(8)]);
var inst_19567 = cljs.core.dissoc.call(null,inst_19544,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_19568 = cljs.core.empty_QMARK_.call(null,inst_19567);
var state_19601__$1 = state_19601;
if(inst_19568){
var statearr_19616_19660 = state_19601__$1;
(statearr_19616_19660[(1)] = (15));

} else {
var statearr_19617_19661 = state_19601__$1;
(statearr_19617_19661[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (22))){
var state_19601__$1 = state_19601;
var statearr_19618_19662 = state_19601__$1;
(statearr_19618_19662[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (6))){
var inst_19543 = (state_19601[(9)]);
var inst_19550 = (state_19601[(11)]);
var inst_19549 = cljs.core.seq.call(null,inst_19543);
var inst_19550__$1 = cljs.core.first.call(null,inst_19549);
var inst_19551 = cljs.core.next.call(null,inst_19549);
var state_19601__$1 = (function (){var statearr_19620 = state_19601;
(statearr_19620[(12)] = inst_19551);

(statearr_19620[(11)] = inst_19550__$1);

return statearr_19620;
})();
if(cljs.core.truth_(inst_19550__$1)){
var statearr_19621_19663 = state_19601__$1;
(statearr_19621_19663[(1)] = (8));

} else {
var statearr_19622_19664 = state_19601__$1;
(statearr_19622_19664[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (25))){
var state_19601__$1 = state_19601;
var statearr_19623_19665 = state_19601__$1;
(statearr_19623_19665[(2)] = null);

(statearr_19623_19665[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (17))){
var inst_19589 = (state_19601[(2)]);
var state_19601__$1 = state_19601;
var statearr_19624_19666 = state_19601__$1;
(statearr_19624_19666[(2)] = inst_19589);

(statearr_19624_19666[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (3))){
var inst_19599 = (state_19601[(2)]);
var state_19601__$1 = state_19601;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19601__$1,inst_19599);
} else {
if((state_val_19602 === (12))){
var inst_19561 = (state_19601[(7)]);
var inst_19560 = (state_19601[(10)]);
var inst_19543 = inst_19561;
var inst_19544 = inst_19560;
var state_19601__$1 = (function (){var statearr_19625 = state_19601;
(statearr_19625[(8)] = inst_19544);

(statearr_19625[(9)] = inst_19543);

return statearr_19625;
})();
var statearr_19626_19667 = state_19601__$1;
(statearr_19626_19667[(2)] = null);

(statearr_19626_19667[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (2))){
var _ = (function (){var statearr_19627 = state_19601;
(statearr_19627[(4)] = cljs.core.cons.call(null,(5),(state_19601[(4)])));

return statearr_19627;
})();
var inst_19535 = where;
var inst_19536 = cljs.core.seq.call(null,inst_19535);
var inst_19537 = cljs.core.first.call(null,inst_19536);
var inst_19538 = cljs.core.next.call(null,inst_19536);
var inst_19539 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_19540 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_19541 = [inst_19540];
var inst_19542 = cljs.core.PersistentHashMap.fromArrays(inst_19539,inst_19541);
var inst_19543 = inst_19535;
var inst_19544 = inst_19542;
var state_19601__$1 = (function (){var statearr_19628 = state_19601;
(statearr_19628[(8)] = inst_19544);

(statearr_19628[(13)] = inst_19537);

(statearr_19628[(9)] = inst_19543);

(statearr_19628[(14)] = inst_19538);

return statearr_19628;
})();
var statearr_19629_19668 = state_19601__$1;
(statearr_19629_19668[(2)] = null);

(statearr_19629_19668[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (23))){
var inst_19587 = (state_19601[(2)]);
var state_19601__$1 = state_19601;
var statearr_19630_19669 = state_19601__$1;
(statearr_19630_19669[(2)] = inst_19587);

(statearr_19630_19669[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (19))){
var inst_19544 = (state_19601[(8)]);
var state_19601__$1 = state_19601;
var statearr_19631_19670 = state_19601__$1;
(statearr_19631_19670[(2)] = inst_19544);

(statearr_19631_19670[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (11))){
var inst_19550 = (state_19601[(11)]);
var inst_19558 = (state_19601[(2)]);
var inst_19559 = fluree.db.util.async.throw_err.call(null,inst_19558);
var inst_19560 = cljs.core.nth.call(null,inst_19559,(0),null);
var inst_19561 = cljs.core.nth.call(null,inst_19559,(1),null);
var inst_19562 = cljs.core.count.call(null,inst_19550);
var inst_19563 = cljs.core._EQ_.call(null,(2),inst_19562);
var state_19601__$1 = (function (){var statearr_19633 = state_19601;
(statearr_19633[(7)] = inst_19561);

(statearr_19633[(10)] = inst_19560);

return statearr_19633;
})();
if(inst_19563){
var statearr_19634_19671 = state_19601__$1;
(statearr_19634_19671[(1)] = (12));

} else {
var statearr_19635_19672 = state_19601__$1;
(statearr_19635_19672[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (9))){
var inst_19544 = (state_19601[(8)]);
var state_19601__$1 = state_19601;
var statearr_19636_19673 = state_19601__$1;
(statearr_19636_19673[(2)] = inst_19544);

(statearr_19636_19673[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (5))){
var _ = (function (){var statearr_19637 = state_19601;
(statearr_19637[(4)] = cljs.core.rest.call(null,(state_19601[(4)])));

return statearr_19637;
})();
var state_19601__$1 = state_19601;
var ex19632 = (state_19601__$1[(2)]);
var statearr_19638_19674 = state_19601__$1;
(statearr_19638_19674[(5)] = ex19632);


if((ex19632 instanceof Error)){
var statearr_19639_19675 = state_19601__$1;
(statearr_19639_19675[(1)] = (4));

(statearr_19639_19675[(5)] = null);

} else {
throw ex19632;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (14))){
var inst_19591 = (state_19601[(2)]);
var state_19601__$1 = state_19601;
var statearr_19640_19676 = state_19601__$1;
(statearr_19640_19676[(2)] = inst_19591);

(statearr_19640_19676[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (26))){
var inst_19585 = (state_19601[(2)]);
var state_19601__$1 = state_19601;
var statearr_19641_19677 = state_19601__$1;
(statearr_19641_19677[(2)] = inst_19585);

(statearr_19641_19677[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (16))){
var inst_19560 = (state_19601[(10)]);
var inst_19576 = (inst_19560 == null);
var state_19601__$1 = state_19601;
if(cljs.core.truth_(inst_19576)){
var statearr_19642_19678 = state_19601__$1;
(statearr_19642_19678[(1)] = (21));

} else {
var statearr_19643_19679 = state_19601__$1;
(statearr_19643_19679[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (10))){
var inst_19594 = (state_19601[(2)]);
var state_19601__$1 = state_19601;
var statearr_19644_19680 = state_19601__$1;
(statearr_19644_19680[(2)] = inst_19594);

(statearr_19644_19680[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (18))){
var inst_19560 = (state_19601[(10)]);
var state_19601__$1 = state_19601;
var statearr_19645_19681 = state_19601__$1;
(statearr_19645_19681[(2)] = inst_19560);

(statearr_19645_19681[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19602 === (8))){
var inst_19544 = (state_19601[(8)]);
var inst_19551 = (state_19601[(12)]);
var inst_19550 = (state_19601[(11)]);
var inst_19556 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_19544,inst_19550,inst_19551,false,fuel,max_fuel,opts);
var state_19601__$1 = state_19601;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19601__$1,(11),inst_19556);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2727__auto__ = null;
var fluree$db$query$analytical$state_machine__2727__auto____0 = (function (){
var statearr_19646 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19646[(0)] = fluree$db$query$analytical$state_machine__2727__auto__);

(statearr_19646[(1)] = (1));

return statearr_19646;
});
var fluree$db$query$analytical$state_machine__2727__auto____1 = (function (state_19601){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_19601);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19647){var ex__2730__auto__ = e19647;
var statearr_19648_19682 = state_19601;
(statearr_19648_19682[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_19601[(4)]))){
var statearr_19649_19683 = state_19601;
(statearr_19649_19683[(1)] = cljs.core.first.call(null,(state_19601[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19684 = state_19601;
state_19601 = G__19684;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2727__auto__ = function(state_19601){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2727__auto____1.call(this,state_19601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2727__auto____0;
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2727__auto____1;
return fluree$db$query$analytical$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19650 = f__2750__auto__.call(null);
(statearr_19650[(6)] = c__2749__auto__);

return statearr_19650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19719){
var state_val_19720 = (state_19719[(1)]);
if((state_val_19720 === (7))){
var inst_19701 = (state_19719[(7)]);
var inst_19696 = (state_19719[(8)]);
var inst_19703 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_19696,inst_19701,fuel,max_fuel,opts);
var state_19719__$1 = state_19719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19719__$1,(10),inst_19703);
} else {
if((state_val_19720 === (1))){
var state_19719__$1 = state_19719;
var statearr_19721_19746 = state_19719__$1;
(statearr_19721_19746[(2)] = null);

(statearr_19721_19746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (4))){
var inst_19685 = (state_19719[(2)]);
var state_19719__$1 = state_19719;
var statearr_19722_19747 = state_19719__$1;
(statearr_19722_19747[(2)] = inst_19685);

(statearr_19722_19747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (13))){
var inst_19714 = (state_19719[(2)]);
var _ = (function (){var statearr_19723 = state_19719;
(statearr_19723[(4)] = cljs.core.rest.call(null,(state_19719[(4)])));

return statearr_19723;
})();
var state_19719__$1 = state_19719;
var statearr_19724_19748 = state_19719__$1;
(statearr_19724_19748[(2)] = inst_19714);

(statearr_19724_19748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (6))){
var inst_19696 = (state_19719[(8)]);
var inst_19700 = (state_19719[(2)]);
var inst_19701 = fluree.db.util.async.throw_err.call(null,inst_19700);
var state_19719__$1 = (function (){var statearr_19725 = state_19719;
(statearr_19725[(7)] = inst_19701);

return statearr_19725;
})();
if(cljs.core.truth_(inst_19696)){
var statearr_19726_19749 = state_19719__$1;
(statearr_19726_19749[(1)] = (7));

} else {
var statearr_19727_19750 = state_19719__$1;
(statearr_19727_19750[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (3))){
var inst_19717 = (state_19719[(2)]);
var state_19719__$1 = state_19719;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19719__$1,inst_19717);
} else {
if((state_val_19720 === (12))){
var inst_19709 = (state_19719[(9)]);
var state_19719__$1 = state_19719;
var statearr_19728_19751 = state_19719__$1;
(statearr_19728_19751[(2)] = inst_19709);

(statearr_19728_19751[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (2))){
var _ = (function (){var statearr_19729 = state_19719;
(statearr_19729[(4)] = cljs.core.cons.call(null,(5),(state_19719[(4)])));

return statearr_19729;
})();
var inst_19692 = q_map;
var inst_19693 = cljs.core.__destructure_map.call(null,inst_19692);
var inst_19694 = cljs.core.get.call(null,inst_19693,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_19695 = cljs.core.get.call(null,inst_19693,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_19696 = cljs.core.get.call(null,inst_19693,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_19697 = cljs.core.get.call(null,inst_19693,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_19698 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_19695,q_map,inst_19694,fuel,max_fuel,opts);
var state_19719__$1 = (function (){var statearr_19730 = state_19719;
(statearr_19730[(10)] = inst_19697);

(statearr_19730[(8)] = inst_19696);

return statearr_19730;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19719__$1,(6),inst_19698);
} else {
if((state_val_19720 === (11))){
var inst_19697 = (state_19719[(10)]);
var inst_19709 = (state_19719[(9)]);
var inst_19711 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_19709,inst_19697,null);
var state_19719__$1 = state_19719;
var statearr_19732_19752 = state_19719__$1;
(statearr_19732_19752[(2)] = inst_19711);

(statearr_19732_19752[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (9))){
var inst_19697 = (state_19719[(10)]);
var inst_19709 = (state_19719[(2)]);
var state_19719__$1 = (function (){var statearr_19733 = state_19719;
(statearr_19733[(9)] = inst_19709);

return statearr_19733;
})();
if(cljs.core.truth_(inst_19697)){
var statearr_19734_19753 = state_19719__$1;
(statearr_19734_19753[(1)] = (11));

} else {
var statearr_19735_19754 = state_19719__$1;
(statearr_19735_19754[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (5))){
var _ = (function (){var statearr_19736 = state_19719;
(statearr_19736[(4)] = cljs.core.rest.call(null,(state_19719[(4)])));

return statearr_19736;
})();
var state_19719__$1 = state_19719;
var ex19731 = (state_19719__$1[(2)]);
var statearr_19737_19755 = state_19719__$1;
(statearr_19737_19755[(5)] = ex19731);


if((ex19731 instanceof Error)){
var statearr_19738_19756 = state_19719__$1;
(statearr_19738_19756[(1)] = (4));

(statearr_19738_19756[(5)] = null);

} else {
throw ex19731;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (10))){
var inst_19705 = (state_19719[(2)]);
var inst_19706 = fluree.db.util.async.throw_err.call(null,inst_19705);
var state_19719__$1 = state_19719;
var statearr_19739_19757 = state_19719__$1;
(statearr_19739_19757[(2)] = inst_19706);

(statearr_19739_19757[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19720 === (8))){
var inst_19701 = (state_19719[(7)]);
var state_19719__$1 = state_19719;
var statearr_19740_19758 = state_19719__$1;
(statearr_19740_19758[(2)] = inst_19701);

(statearr_19740_19758[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2727__auto____0 = (function (){
var statearr_19741 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19741[(0)] = fluree$db$query$analytical$q_$_state_machine__2727__auto__);

(statearr_19741[(1)] = (1));

return statearr_19741;
});
var fluree$db$query$analytical$q_$_state_machine__2727__auto____1 = (function (state_19719){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_19719);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19742){var ex__2730__auto__ = e19742;
var statearr_19743_19759 = state_19719;
(statearr_19743_19759[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_19719[(4)]))){
var statearr_19744_19760 = state_19719;
(statearr_19744_19760[(1)] = cljs.core.first.call(null,(state_19719[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19761 = state_19719;
state_19719 = G__19761;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2727__auto__ = function(state_19719){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2727__auto____1.call(this,state_19719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2727__auto____0;
fluree$db$query$analytical$q_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19745 = f__2750__auto__.call(null);
(statearr_19745[(6)] = c__2749__auto__);

return statearr_19745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
