// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.range');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27016 = arguments.length;
var i__4865__auto___27017 = (0);
while(true){
if((i__4865__auto___27017 < len__4864__auto___27016)){
args__4870__auto__.push((arguments[i__4865__auto___27017]));

var G__27018 = (i__4865__auto___27017 + (1));
i__4865__auto___27017 = G__27018;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,(function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq27013){
var G__27014 = cljs.core.first.call(null,seq27013);
var seq27013__$1 = cljs.core.next.call(null,seq27013);
var G__27015 = cljs.core.first.call(null,seq27013__$1);
var seq27013__$2 = cljs.core.next.call(null,seq27013__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27014,G__27015,seq27013__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e27019){var e = e27019;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e27020){var e = e27020;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e27021){var e = e27021;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e27022){var e = e27022;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e27023){var e = e27023;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27026 = arguments.length;
var i__4865__auto___27027 = (0);
while(true){
if((i__4865__auto___27027 < len__4864__auto___27026)){
args__4870__auto__.push((arguments[i__4865__auto___27027]));

var G__27028 = (i__4865__auto___27027 + (1));
i__4865__auto___27027 = G__27028;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e27025){var e = e27025;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq27024){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27024));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27031 = arguments.length;
var i__4865__auto___27032 = (0);
while(true){
if((i__4865__auto___27032 < len__4864__auto___27031)){
args__4870__auto__.push((arguments[i__4865__auto___27032]));

var G__27033 = (i__4865__auto___27032 + (1));
i__4865__auto___27032 = G__27033;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e27030){var e = e27030;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq27029){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27029));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e27034){var e = e27034;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27037 = arguments.length;
var i__4865__auto___27038 = (0);
while(true){
if((i__4865__auto___27038 < len__4864__auto___27037)){
args__4870__auto__.push((arguments[i__4865__auto___27038]));

var G__27039 = (i__4865__auto___27038 + (1));
i__4865__auto___27038 = G__27039;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e27036){var e = e27036;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq27035){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27035));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27042 = arguments.length;
var i__4865__auto___27043 = (0);
while(true){
if((i__4865__auto___27043 < len__4864__auto___27042)){
args__4870__auto__.push((arguments[i__4865__auto___27043]));

var G__27044 = (i__4865__auto___27043 + (1));
i__4865__auto___27043 = G__27044;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e27041){var e = e27041;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq27040){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27040));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e27045){var e = e27045;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e27046){var e = e27046;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27049 = arguments.length;
var i__4865__auto___27050 = (0);
while(true){
if((i__4865__auto___27050 < len__4864__auto___27049)){
args__4870__auto__.push((arguments[i__4865__auto___27050]));

var G__27051 = (i__4865__auto___27050 + (1));
i__4865__auto___27050 = G__27051;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e27048){var e = e27048;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq27047){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27047));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27054 = arguments.length;
var i__4865__auto___27055 = (0);
while(true){
if((i__4865__auto___27055 < len__4864__auto___27054)){
args__4870__auto__.push((arguments[i__4865__auto___27055]));

var G__27056 = (i__4865__auto___27055 + (1));
i__4865__auto___27055 = G__27056;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e27053){var e = e27053;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq27052){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27052));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27059 = arguments.length;
var i__4865__auto___27060 = (0);
while(true){
if((i__4865__auto___27060 < len__4864__auto___27059)){
args__4870__auto__.push((arguments[i__4865__auto___27060]));

var G__27061 = (i__4865__auto___27060 + (1));
i__4865__auto___27060 = G__27061;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e27058){var e = e27058;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq27057){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27057));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27064 = arguments.length;
var i__4865__auto___27065 = (0);
while(true){
if((i__4865__auto___27065 < len__4864__auto___27064)){
args__4870__auto__.push((arguments[i__4865__auto___27065]));

var G__27066 = (i__4865__auto___27065 + (1));
i__4865__auto___27065 = G__27066;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e27063){var e = e27063;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq27062){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27062));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27069 = arguments.length;
var i__4865__auto___27070 = (0);
while(true){
if((i__4865__auto___27070 < len__4864__auto___27069)){
args__4870__auto__.push((arguments[i__4865__auto___27070]));

var G__27071 = (i__4865__auto___27070 + (1));
i__4865__auto___27070 = G__27071;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e27068){var e = e27068;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq27067){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27067));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27074 = arguments.length;
var i__4865__auto___27075 = (0);
while(true){
if((i__4865__auto___27075 < len__4864__auto___27074)){
args__4870__auto__.push((arguments[i__4865__auto___27075]));

var G__27076 = (i__4865__auto___27075 + (1));
i__4865__auto___27075 = G__27076;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e27073){var e = e27073;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq27072){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27072));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27079 = arguments.length;
var i__4865__auto___27080 = (0);
while(true){
if((i__4865__auto___27080 < len__4864__auto___27079)){
args__4870__auto__.push((arguments[i__4865__auto___27080]));

var G__27081 = (i__4865__auto___27080 + (1));
i__4865__auto___27080 = G__27081;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e27078){var e = e27078;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq27077){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27077));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__27083 = arguments.length;
switch (G__27083) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27111){
var state_val_27112 = (state_27111[(1)]);
if((state_val_27112 === (7))){
var inst_27096 = (state_27111[(7)]);
var inst_27099 = fluree.db.dbfunctions.internal.function_error.call(null,inst_27096,"query",query_map);
var state_27111__$1 = state_27111;
var statearr_27113_27199 = state_27111__$1;
(statearr_27113_27199[(2)] = inst_27099);

(statearr_27113_27199[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27112 === (1))){
var state_27111__$1 = state_27111;
var statearr_27114_27200 = state_27111__$1;
(statearr_27114_27200[(2)] = null);

(statearr_27114_27200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27112 === (4))){
var inst_27084 = (state_27111[(2)]);
var state_27111__$1 = state_27111;
var statearr_27115_27201 = state_27111__$1;
(statearr_27115_27201[(2)] = inst_27084);

(statearr_27115_27201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27112 === (6))){
var inst_27096 = (state_27111[(7)]);
var inst_27096__$1 = (state_27111[(2)]);
var inst_27097 = fluree.db.util.core.exception_QMARK_.call(null,inst_27096__$1);
var state_27111__$1 = (function (){var statearr_27116 = state_27111;
(statearr_27116[(7)] = inst_27096__$1);

return statearr_27116;
})();
if(inst_27097){
var statearr_27117_27202 = state_27111__$1;
(statearr_27117_27202[(1)] = (7));

} else {
var statearr_27118_27203 = state_27111__$1;
(statearr_27118_27203[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27112 === (3))){
var inst_27109 = (state_27111[(2)]);
var state_27111__$1 = state_27111;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27111__$1,inst_27109);
} else {
if((state_val_27112 === (2))){
var inst_27090 = (state_27111[(8)]);
var _ = (function (){var statearr_27120 = state_27111;
(statearr_27120[(4)] = cljs.core.cons.call(null,(5),(state_27111[(4)])));

return statearr_27120;
})();
var inst_27090__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_27091 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_27092 = cljs.core.assoc.call(null,inst_27091,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_27090__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_27093 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_27092);
var inst_27094 = fluree.db.query.fql.query.call(null,db,inst_27093);
var state_27111__$1 = (function (){var statearr_27121 = state_27111;
(statearr_27121[(8)] = inst_27090__$1);

return statearr_27121;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27111__$1,(6),inst_27094);
} else {
if((state_val_27112 === (9))){
var inst_27106 = (state_27111[(2)]);
var _ = (function (){var statearr_27122 = state_27111;
(statearr_27122[(4)] = cljs.core.rest.call(null,(state_27111[(4)])));

return statearr_27122;
})();
var state_27111__$1 = state_27111;
var statearr_27123_27204 = state_27111__$1;
(statearr_27123_27204[(2)] = inst_27106);

(statearr_27123_27204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27112 === (5))){
var _ = (function (){var statearr_27124 = state_27111;
(statearr_27124[(4)] = cljs.core.rest.call(null,(state_27111[(4)])));

return statearr_27124;
})();
var state_27111__$1 = state_27111;
var ex27119 = (state_27111__$1[(2)]);
var statearr_27125_27205 = state_27111__$1;
(statearr_27125_27205[(5)] = ex27119);


if((ex27119 instanceof Error)){
var statearr_27126_27206 = state_27111__$1;
(statearr_27126_27206[(1)] = (4));

(statearr_27126_27206[(5)] = null);

} else {
throw ex27119;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27112 === (8))){
var inst_27096 = (state_27111[(7)]);
var inst_27090 = (state_27111[(8)]);
var inst_27101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27102 = cljs.core.deref.call(null,inst_27090);
var inst_27103 = [inst_27096,inst_27102];
var inst_27104 = (new cljs.core.PersistentVector(null,2,(5),inst_27101,inst_27103,null));
var state_27111__$1 = state_27111;
var statearr_27127_27207 = state_27111__$1;
(statearr_27127_27207[(2)] = inst_27104);

(statearr_27127_27207[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_27128 = [null,null,null,null,null,null,null,null,null];
(statearr_27128[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_27128[(1)] = (1));

return statearr_27128;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_27111){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_27111);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27129){var ex__2730__auto__ = e27129;
var statearr_27130_27208 = state_27111;
(statearr_27130_27208[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_27111[(4)]))){
var statearr_27131_27209 = state_27111;
(statearr_27131_27209[(1)] = cljs.core.first.call(null,(state_27111[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27210 = state_27111;
state_27111 = G__27210;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_27111){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_27111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27132 = f__2750__auto__.call(null);
(statearr_27132[(6)] = c__2749__auto__);

return statearr_27132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27177){
var state_val_27178 = (state_27177[(1)]);
if((state_val_27178 === (7))){
var inst_27163 = (state_27177[(2)]);
var inst_27164 = fluree.db.query.fql.query.call(null,db,inst_27163);
var state_27177__$1 = state_27177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27177__$1,(8),inst_27164);
} else {
if((state_val_27178 === (1))){
var inst_27133 = typeof select === 'string';
var state_27177__$1 = state_27177;
if(cljs.core.truth_(inst_27133)){
var statearr_27179_27211 = state_27177__$1;
(statearr_27179_27211[(1)] = (2));

} else {
var statearr_27180_27212 = state_27177__$1;
(statearr_27180_27212[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (4))){
var inst_27146 = (state_27177[(7)]);
var inst_27139 = (state_27177[(8)]);
var inst_27138 = (state_27177[(2)]);
var inst_27139__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_27140 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_27141 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_27142 = [inst_27139__$1,(100000)];
var inst_27143 = cljs.core.PersistentHashMap.fromArrays(inst_27141,inst_27142);
var inst_27144 = [inst_27138,from,where,block,limit,inst_27143];
var inst_27145 = cljs.core.PersistentHashMap.fromArrays(inst_27140,inst_27144);
var inst_27146__$1 = fluree.db.util.core.without_nils.call(null,inst_27145);
var inst_27147 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_27146__$1);
var inst_27148 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_27146__$1);
var inst_27149 = cljs.core.first.call(null,inst_27148);
var inst_27150 = fluree.db.dbfunctions.internal.str.call(null,inst_27149);
var inst_27151 = cljs.core._EQ_.call(null,"[",inst_27150);
var inst_27152 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_27146__$1);
var inst_27153 = cljs.core.last.call(null,inst_27152);
var inst_27154 = fluree.db.dbfunctions.internal.str.call(null,inst_27153);
var inst_27155 = cljs.core._EQ_.call(null,"]",inst_27154);
var inst_27156 = fluree.db.dbfunctions.internal.and.call(null,inst_27147,inst_27151,inst_27155);
var state_27177__$1 = (function (){var statearr_27181 = state_27177;
(statearr_27181[(7)] = inst_27146__$1);

(statearr_27181[(8)] = inst_27139__$1);

return statearr_27181;
})();
if(cljs.core.truth_(inst_27156)){
var statearr_27182_27213 = state_27177__$1;
(statearr_27182_27213[(1)] = (5));

} else {
var statearr_27183_27214 = state_27177__$1;
(statearr_27183_27214[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (6))){
var inst_27146 = (state_27177[(7)]);
var state_27177__$1 = state_27177;
var statearr_27184_27215 = state_27177__$1;
(statearr_27184_27215[(2)] = inst_27146);

(statearr_27184_27215[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (3))){
var state_27177__$1 = state_27177;
var statearr_27185_27216 = state_27177__$1;
(statearr_27185_27216[(2)] = select);

(statearr_27185_27216[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (2))){
var inst_27135 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_27177__$1 = state_27177;
var statearr_27186_27217 = state_27177__$1;
(statearr_27186_27217[(2)] = inst_27135);

(statearr_27186_27217[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (11))){
var inst_27175 = (state_27177[(2)]);
var state_27177__$1 = state_27177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27177__$1,inst_27175);
} else {
if((state_val_27178 === (9))){
var inst_27166 = (state_27177[(9)]);
var state_27177__$1 = state_27177;
var statearr_27187_27218 = state_27177__$1;
(statearr_27187_27218[(2)] = inst_27166);

(statearr_27187_27218[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (5))){
var inst_27146 = (state_27177[(7)]);
var inst_27158 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_27146);
var inst_27159 = cljs.reader.read_string.call(null,inst_27158);
var inst_27160 = cljs.core.assoc.call(null,inst_27146,new cljs.core.Keyword(null,"where","where",-2044795965),inst_27159);
var state_27177__$1 = state_27177;
var statearr_27188_27219 = state_27177__$1;
(statearr_27188_27219[(2)] = inst_27160);

(statearr_27188_27219[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (10))){
var inst_27139 = (state_27177[(8)]);
var inst_27166 = (state_27177[(9)]);
var inst_27170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27171 = cljs.core.deref.call(null,inst_27139);
var inst_27172 = [inst_27166,inst_27171];
var inst_27173 = (new cljs.core.PersistentVector(null,2,(5),inst_27170,inst_27172,null));
var state_27177__$1 = state_27177;
var statearr_27189_27220 = state_27177__$1;
(statearr_27189_27220[(2)] = inst_27173);

(statearr_27189_27220[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (8))){
var inst_27166 = (state_27177[(9)]);
var inst_27166__$1 = (state_27177[(2)]);
var inst_27167 = fluree.db.util.core.exception_QMARK_.call(null,inst_27166__$1);
var state_27177__$1 = (function (){var statearr_27190 = state_27177;
(statearr_27190[(9)] = inst_27166__$1);

return statearr_27190;
})();
if(inst_27167){
var statearr_27191_27221 = state_27177__$1;
(statearr_27191_27221[(1)] = (9));

} else {
var statearr_27192_27222 = state_27177__$1;
(statearr_27192_27222[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_27193 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27193[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_27193[(1)] = (1));

return statearr_27193;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_27177){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_27177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27194){var ex__2730__auto__ = e27194;
var statearr_27195_27223 = state_27177;
(statearr_27195_27223[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_27177[(4)]))){
var statearr_27196_27224 = state_27177;
(statearr_27196_27224[(1)] = cljs.core.first.call(null,(state_27177[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27225 = state_27177;
state_27177 = G__27225;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_27177){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_27177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27197 = f__2750__auto__.call(null);
(statearr_27197[(6)] = c__2749__auto__);

return statearr_27197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__27229 = path;
var vec__27230 = G__27229;
var seq__27231 = cljs.core.seq.call(null,vec__27230);
var first__27232 = cljs.core.first.call(null,seq__27231);
var seq__27231__$1 = cljs.core.next.call(null,seq__27231);
var var$ = first__27232;
var r = seq__27231__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__27229__$1 = G__27229;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__27236 = G__27229__$1;
var seq__27237 = cljs.core.seq.call(null,vec__27236);
var first__27238 = cljs.core.first.call(null,seq__27237);
var seq__27237__$1 = cljs.core.next.call(null,seq__27237);
var var$__$1 = first__27238;
var r__$1 = seq__27237__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__27239 = r__$1;
var G__27240 = n__$2;
var G__27241 = next_clauses;
G__27229__$1 = G__27239;
n__$1 = G__27240;
where_clauses__$1 = G__27241;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__27242 = r__$1;
var G__27243 = next_n;
var G__27244 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__27229__$1 = G__27242;
n__$1 = G__27243;
where_clauses__$1 = G__27244;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27281){
var state_val_27282 = (state_27281[(1)]);
if((state_val_27282 === (7))){
var inst_27254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27255 = [path];
var inst_27256 = (new cljs.core.PersistentVector(null,1,(5),inst_27254,inst_27255,null));
var state_27281__$1 = state_27281;
var statearr_27283_27311 = state_27281__$1;
(statearr_27283_27311[(2)] = inst_27256);

(statearr_27283_27311[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (1))){
var state_27281__$1 = state_27281;
var statearr_27284_27312 = state_27281__$1;
(statearr_27284_27312[(2)] = null);

(statearr_27284_27312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (4))){
var inst_27245 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
var statearr_27285_27313 = state_27281__$1;
(statearr_27285_27313[(2)] = inst_27245);

(statearr_27285_27313[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (13))){
var inst_27272 = (state_27281[(2)]);
var inst_27273 = fluree.db.util.async.throw_err.call(null,inst_27272);
var _ = (function (){var statearr_27286 = state_27281;
(statearr_27286[(4)] = cljs.core.rest.call(null,(state_27281[(4)])));

return statearr_27286;
})();
var state_27281__$1 = state_27281;
var statearr_27287_27314 = state_27281__$1;
(statearr_27287_27314[(2)] = inst_27273);

(statearr_27287_27314[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (6))){
var state_27281__$1 = state_27281;
var statearr_27289_27315 = state_27281__$1;
(statearr_27289_27315[(2)] = path);

(statearr_27289_27315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (3))){
var inst_27279 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27281__$1,inst_27279);
} else {
if((state_val_27282 === (12))){
var _ = (function (){var statearr_27290 = state_27281;
(statearr_27290[(4)] = cljs.core.rest.call(null,(state_27281[(4)])));

return statearr_27290;
})();
var state_27281__$1 = state_27281;
var ex27288 = (state_27281__$1[(2)]);
var statearr_27291_27316 = state_27281__$1;
(statearr_27291_27316[(5)] = ex27288);


var statearr_27292_27317 = state_27281__$1;
(statearr_27292_27317[(1)] = (11));

(statearr_27292_27317[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (2))){
var _ = (function (){var statearr_27293 = state_27281;
(statearr_27293[(4)] = cljs.core.cons.call(null,(5),(state_27281[(4)])));

return statearr_27293;
})();
var inst_27251 = cljs.core.vector_QMARK_.call(null,path);
var state_27281__$1 = state_27281;
if(inst_27251){
var statearr_27294_27318 = state_27281__$1;
(statearr_27294_27318[(1)] = (6));

} else {
var statearr_27295_27319 = state_27281__$1;
(statearr_27295_27319[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (11))){
var inst_27258 = (state_27281[(7)]);
var inst_27263 = (state_27281[(2)]);
var inst_27264 = fluree.db.dbfunctions.internal.function_error.call(null,inst_27263,"relationship?",startSubject,inst_27258,endSubject);
var state_27281__$1 = state_27281;
var statearr_27297_27320 = state_27281__$1;
(statearr_27297_27320[(2)] = inst_27264);

(statearr_27297_27320[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (9))){
var inst_27262 = (state_27281[(8)]);
var _ = (function (){var statearr_27298 = state_27281;
(statearr_27298[(4)] = cljs.core.cons.call(null,(12),(state_27281[(4)])));

return statearr_27298;
})();
var inst_27270 = fluree.db.dbfunctions.internal.query.call(null,db,inst_27262);
var state_27281__$1 = state_27281;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27281__$1,(13),inst_27270);
} else {
if((state_val_27282 === (5))){
var _ = (function (){var statearr_27299 = state_27281;
(statearr_27299[(4)] = cljs.core.rest.call(null,(state_27281[(4)])));

return statearr_27299;
})();
var state_27281__$1 = state_27281;
var ex27296 = (state_27281__$1[(2)]);
var statearr_27300_27321 = state_27281__$1;
(statearr_27300_27321[(5)] = ex27296);


if((ex27296 instanceof Error)){
var statearr_27301_27322 = state_27281__$1;
(statearr_27301_27322[(1)] = (4));

(statearr_27301_27322[(5)] = null);

} else {
throw ex27296;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (10))){
var inst_27276 = (state_27281[(2)]);
var _ = (function (){var statearr_27302 = state_27281;
(statearr_27302[(4)] = cljs.core.rest.call(null,(state_27281[(4)])));

return statearr_27302;
})();
var state_27281__$1 = state_27281;
var statearr_27303_27323 = state_27281__$1;
(statearr_27303_27323[(2)] = inst_27276);

(statearr_27303_27323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (8))){
var inst_27258 = (state_27281[(7)]);
var inst_27258__$1 = (state_27281[(2)]);
var inst_27259 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_27258__$1,endSubject);
var inst_27260 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_27261 = ["?var1",inst_27259];
var inst_27262 = cljs.core.PersistentHashMap.fromArrays(inst_27260,inst_27261);
var state_27281__$1 = (function (){var statearr_27304 = state_27281;
(statearr_27304[(7)] = inst_27258__$1);

(statearr_27304[(8)] = inst_27262);

return statearr_27304;
})();
var statearr_27305_27324 = state_27281__$1;
(statearr_27305_27324[(2)] = null);

(statearr_27305_27324[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_27306 = [null,null,null,null,null,null,null,null,null];
(statearr_27306[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_27306[(1)] = (1));

return statearr_27306;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_27281){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_27281);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27307){var ex__2730__auto__ = e27307;
var statearr_27308_27325 = state_27281;
(statearr_27308_27325[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_27281[(4)]))){
var statearr_27309_27326 = state_27281;
(statearr_27309_27326[(1)] = cljs.core.first.call(null,(state_27281[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27327 = state_27281;
state_27281 = G__27327;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__ = function(state_27281){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_27281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27310 = f__2750__auto__.call(null);
(statearr_27310[(6)] = c__2749__auto__);

return statearr_27310;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e27328){var e = e27328;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e27329){var e = e27329;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4253__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e27330){var e = e27330;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Retrieve's a subject's predicate value by doing a lookup.
 *   If multi returns a vector, else a single value.
 */
fluree.db.dbfunctions.internal.get_subj_pred = (function fluree$db$dbfunctions$internal$get_subj_pred(db,sid,pred){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27384){
var state_val_27385 = (state_27384[(1)]);
if((state_val_27385 === (7))){
var state_27384__$1 = state_27384;
var statearr_27386_27424 = state_27384__$1;
(statearr_27386_27424[(2)] = pred);

(statearr_27386_27424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (20))){
var inst_27367 = (state_27384[(7)]);
var inst_27363 = (state_27384[(8)]);
var inst_27371 = cljs.core.mapv.call(null,inst_27367,inst_27363);
var state_27384__$1 = state_27384;
var statearr_27387_27425 = state_27384__$1;
(statearr_27387_27425[(2)] = inst_27371);

(statearr_27387_27425[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (1))){
var state_27384__$1 = state_27384;
var statearr_27388_27426 = state_27384__$1;
(statearr_27388_27426[(2)] = null);

(statearr_27388_27426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (4))){
var inst_27331 = (state_27384[(2)]);
var state_27384__$1 = state_27384;
var statearr_27389_27427 = state_27384__$1;
(statearr_27389_27427[(2)] = inst_27331);

(statearr_27389_27427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (15))){
var state_27384__$1 = state_27384;
var statearr_27390_27428 = state_27384__$1;
(statearr_27390_27428[(2)] = fluree.db.flake.o);

(statearr_27390_27428[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (21))){
var inst_27367 = (state_27384[(7)]);
var inst_27363 = (state_27384[(8)]);
var inst_27373 = cljs.core.first.call(null,inst_27363);
var inst_27374 = inst_27367.call(null,inst_27373);
var state_27384__$1 = state_27384;
var statearr_27391_27429 = state_27384__$1;
(statearr_27391_27429[(2)] = inst_27374);

(statearr_27391_27429[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (13))){
var inst_27360 = (state_27384[(2)]);
var inst_27361 = fluree.db.util.async.throw_err.call(null,inst_27360);
var state_27384__$1 = state_27384;
var statearr_27392_27430 = state_27384__$1;
(statearr_27392_27430[(2)] = inst_27361);

(statearr_27392_27430[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (22))){
var inst_27376 = (state_27384[(2)]);
var state_27384__$1 = state_27384;
var statearr_27393_27431 = state_27384__$1;
(statearr_27393_27431[(2)] = inst_27376);

(statearr_27393_27431[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (6))){
var inst_27341 = clojure.string.replace.call(null,pred,"/_","/");
var state_27384__$1 = state_27384;
var statearr_27394_27432 = state_27384__$1;
(statearr_27394_27432[(2)] = inst_27341);

(statearr_27394_27432[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (17))){
var inst_27345 = (state_27384[(9)]);
var state_27384__$1 = state_27384;
if(cljs.core.truth_(inst_27345)){
var statearr_27395_27433 = state_27384__$1;
(statearr_27395_27433[(1)] = (20));

} else {
var statearr_27396_27434 = state_27384__$1;
(statearr_27396_27434[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (3))){
var inst_27382 = (state_27384[(2)]);
var state_27384__$1 = state_27384;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27384__$1,inst_27382);
} else {
if((state_val_27385 === (12))){
var inst_27352 = (state_27384[(2)]);
var inst_27353 = fluree.db.util.async.throw_err.call(null,inst_27352);
var state_27384__$1 = state_27384;
var statearr_27397_27435 = state_27384__$1;
(statearr_27397_27435[(2)] = inst_27353);

(statearr_27397_27435[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (2))){
var inst_27339 = (state_27384[(10)]);
var _ = (function (){var statearr_27398 = state_27384;
(statearr_27398[(4)] = cljs.core.cons.call(null,(5),(state_27384[(4)])));

return statearr_27398;
})();
var inst_27337 = typeof pred === 'string';
var inst_27338 = cljs.core.re_matches.call(null,/.+\/_.+/,pred);
var inst_27339__$1 = fluree.db.dbfunctions.internal.and.call(null,inst_27337,inst_27338);
var state_27384__$1 = (function (){var statearr_27399 = state_27384;
(statearr_27399[(10)] = inst_27339__$1);

return statearr_27399;
})();
if(cljs.core.truth_(inst_27339__$1)){
var statearr_27400_27436 = state_27384__$1;
(statearr_27400_27436[(1)] = (6));

} else {
var statearr_27401_27437 = state_27384__$1;
(statearr_27401_27437[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (19))){
var inst_27379 = (state_27384[(2)]);
var _ = (function (){var statearr_27402 = state_27384;
(statearr_27402[(4)] = cljs.core.rest.call(null,(state_27384[(4)])));

return statearr_27402;
})();
var state_27384__$1 = state_27384;
var statearr_27403_27438 = state_27384__$1;
(statearr_27403_27438[(2)] = inst_27379);

(statearr_27403_27438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (11))){
var inst_27339 = (state_27384[(10)]);
var inst_27363 = (state_27384[(2)]);
var state_27384__$1 = (function (){var statearr_27405 = state_27384;
(statearr_27405[(8)] = inst_27363);

return statearr_27405;
})();
if(cljs.core.truth_(inst_27339)){
var statearr_27406_27439 = state_27384__$1;
(statearr_27406_27439[(1)] = (14));

} else {
var statearr_27407_27440 = state_27384__$1;
(statearr_27407_27440[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (9))){
var inst_27344 = (state_27384[(11)]);
var inst_27347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27348 = [sid,inst_27344];
var inst_27349 = (new cljs.core.PersistentVector(null,2,(5),inst_27347,inst_27348,null));
var inst_27350 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_27349);
var state_27384__$1 = state_27384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27384__$1,(12),inst_27350);
} else {
if((state_val_27385 === (5))){
var _ = (function (){var statearr_27408 = state_27384;
(statearr_27408[(4)] = cljs.core.rest.call(null,(state_27384[(4)])));

return statearr_27408;
})();
var state_27384__$1 = state_27384;
var ex27404 = (state_27384__$1[(2)]);
var statearr_27409_27441 = state_27384__$1;
(statearr_27409_27441[(5)] = ex27404);


if((ex27404 instanceof Error)){
var statearr_27410_27442 = state_27384__$1;
(statearr_27410_27442[(1)] = (4));

(statearr_27410_27442[(5)] = null);

} else {
throw ex27404;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (14))){
var state_27384__$1 = state_27384;
var statearr_27411_27443 = state_27384__$1;
(statearr_27411_27443[(2)] = fluree.db.flake.s);

(statearr_27411_27443[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (16))){
var inst_27363 = (state_27384[(8)]);
var inst_27367 = (state_27384[(2)]);
var inst_27368 = cljs.core.seq.call(null,inst_27363);
var state_27384__$1 = (function (){var statearr_27412 = state_27384;
(statearr_27412[(7)] = inst_27367);

return statearr_27412;
})();
if(inst_27368){
var statearr_27413_27444 = state_27384__$1;
(statearr_27413_27444[(1)] = (17));

} else {
var statearr_27414_27445 = state_27384__$1;
(statearr_27414_27445[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (10))){
var inst_27344 = (state_27384[(11)]);
var inst_27355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27356 = [sid,inst_27344];
var inst_27357 = (new cljs.core.PersistentVector(null,2,(5),inst_27355,inst_27356,null));
var inst_27358 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27357);
var state_27384__$1 = state_27384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27384__$1,(13),inst_27358);
} else {
if((state_val_27385 === (18))){
var state_27384__$1 = state_27384;
var statearr_27415_27446 = state_27384__$1;
(statearr_27415_27446[(2)] = null);

(statearr_27415_27446[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27385 === (8))){
var inst_27344 = (state_27384[(11)]);
var inst_27339 = (state_27384[(10)]);
var inst_27344__$1 = (state_27384[(2)]);
var inst_27345 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_27344__$1);
var state_27384__$1 = (function (){var statearr_27416 = state_27384;
(statearr_27416[(9)] = inst_27345);

(statearr_27416[(11)] = inst_27344__$1);

return statearr_27416;
})();
if(cljs.core.truth_(inst_27339)){
var statearr_27417_27447 = state_27384__$1;
(statearr_27417_27447[(1)] = (9));

} else {
var statearr_27418_27448 = state_27384__$1;
(statearr_27418_27448[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0 = (function (){
var statearr_27419 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27419[(0)] = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__);

(statearr_27419[(1)] = (1));

return statearr_27419;
});
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1 = (function (state_27384){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_27384);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27420){var ex__2730__auto__ = e27420;
var statearr_27421_27449 = state_27384;
(statearr_27421_27449[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_27384[(4)]))){
var statearr_27422_27450 = state_27384;
(statearr_27422_27450[(1)] = cljs.core.first.call(null,(state_27384[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27451 = state_27384;
state_27384 = G__27451;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__ = function(state_27384){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1.call(this,state_27384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27423 = f__2750__auto__.call(null);
(statearr_27423[(6)] = c__2749__auto__);

return statearr_27423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e27452){var e = e27452;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27455 = arguments.length;
var i__4865__auto___27456 = (0);
while(true){
if((i__4865__auto___27456 < len__4864__auto___27455)){
args__4870__auto__.push((arguments[i__4865__auto___27456]));

var G__27457 = (i__4865__auto___27456 + (1));
i__4865__auto___27456 = G__27457;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e27454){var e = e27454;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq27453){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27453));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27460 = arguments.length;
var i__4865__auto___27461 = (0);
while(true){
if((i__4865__auto___27461 < len__4864__auto___27460)){
args__4870__auto__.push((arguments[i__4865__auto___27461]));

var G__27462 = (i__4865__auto___27461 + (1));
i__4865__auto___27461 = G__27462;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e27459){var e = e27459;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq27458){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27458));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27465 = arguments.length;
var i__4865__auto___27466 = (0);
while(true){
if((i__4865__auto___27466 < len__4864__auto___27465)){
args__4870__auto__.push((arguments[i__4865__auto___27466]));

var G__27467 = (i__4865__auto___27466 + (1));
i__4865__auto___27466 = G__27467;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4253__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e27464){var e = e27464;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq27463){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27463));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27470 = arguments.length;
var i__4865__auto___27471 = (0);
while(true){
if((i__4865__auto___27471 < len__4864__auto___27470)){
args__4870__auto__.push((arguments[i__4865__auto___27471]));

var G__27472 = (i__4865__auto___27471 + (1));
i__4865__auto___27471 = G__27472;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e27469){var e = e27469;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq27468){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27468));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e27473){var e = e27473;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e27474){var e = e27474;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e27475){var e = e27475;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e27476){var e = e27476;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e27477){var e = e27477;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows a result set down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__27483 = path;
var vec__27484 = G__27483;
var seq__27485 = cljs.core.seq.call(null,vec__27484);
var first__27486 = cljs.core.first.call(null,seq__27485);
var seq__27485__$1 = cljs.core.next.call(null,seq__27485);
var pred = first__27486;
var r = seq__27485__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__27483__$1 = G__27483;
var subjects__$1 = subjects;
while(true){
var vec__27490 = G__27483__$1;
var seq__27491 = cljs.core.seq.call(null,vec__27490);
var first__27492 = cljs.core.first.call(null,seq__27491);
var seq__27491__$1 = cljs.core.next.call(null,seq__27491);
var pred__$1 = first__27492;
var r__$1 = seq__27491__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__27483__$1,subjects__$1,vec__27490,seq__27491,first__27492,seq__27491__$1,pred__$1,r__$1,subjects__$2,G__27483,vec__27484,seq__27485,first__27486,seq__27485__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__27483__$1,subjects__$1,vec__27490,seq__27491,first__27492,seq__27491__$1,pred__$1,r__$1,subjects__$2,G__27483,vec__27484,seq__27485,first__27486,seq__27485__$1,pred,r,subjects){
return (function (p1__27478_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__27478_SHARP_,pred__$1);
});})(G__27483__$1,subjects__$1,vec__27490,seq__27491,first__27492,seq__27491__$1,pred__$1,r__$1,subjects__$2,G__27483,vec__27484,seq__27485,first__27486,seq__27485__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__27483__$1,subjects__$1,vec__27490,seq__27491,first__27492,seq__27491__$1,pred__$1,r__$1,subjects__$2,G__27483,vec__27484,seq__27485,first__27486,seq__27485__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4251__auto__ = r__$1;
if(and__4251__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__4251__auto__;
}
})())){
var G__27493 = r__$1;
var G__27494 = next_subjects;
G__27483__$1 = G__27493;
subjects__$1 = G__27494;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e27479){var e = e27479;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Takes a path in a vector format and returns a select statement to crawl those vars.
 *   e.g. convert: ['_user/_auth', 'groupMembership/_user', 'group/_admins']
 *          to: {'_user/_auth' [{'groupMembership/_user' ['group/_admins']}]}
 */
fluree.db.dbfunctions.internal.select_from_path = (function fluree$db$dbfunctions$internal$select_from_path(path){
if(cljs.core._EQ_.call(null,(1),fluree.db.dbfunctions.internal.count.call(null,path))){
return path;
} else {
var r_path = cljs.core.reverse.call(null,path);
return cljs.core.reduce.call(null,(function (acc,p){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc], null)]);
}),cljs.core.first.call(null,r_path),cljs.core.rest.call(null,r_path));
}
});
/**
 * Follows a subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.follow_subject = (function fluree$db$dbfunctions$internal$follow_subject(_QMARK_ctx,sid,path){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27534){
var state_val_27535 = (state_27534[(1)]);
if((state_val_27535 === (7))){
var state_27534__$1 = state_27534;
var statearr_27536_27555 = state_27534__$1;
(statearr_27536_27555[(2)] = path);

(statearr_27536_27555[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27535 === (1))){
var state_27534__$1 = state_27534;
var statearr_27537_27556 = state_27534__$1;
(statearr_27537_27556[(2)] = null);

(statearr_27537_27556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27535 === (4))){
var inst_27495 = (state_27534[(2)]);
var inst_27496 = fluree.db.dbfunctions.internal.function_error.call(null,inst_27495,"get-all",sid,path);
var state_27534__$1 = state_27534;
var statearr_27538_27557 = state_27534__$1;
(statearr_27538_27557[(2)] = inst_27496);

(statearr_27538_27557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27535 === (6))){
var inst_27513 = (state_27534[(2)]);
var inst_27514 = fluree.db.util.async.throw_err.call(null,inst_27513);
var inst_27515 = cljs.core.nth.call(null,inst_27514,(0),null);
var inst_27516 = cljs.core.nth.call(null,inst_27514,(1),null);
var inst_27517 = cljs.core.last.call(null,path);
var inst_27518 = cljs.core._EQ_.call(null,"_id",inst_27517);
var state_27534__$1 = (function (){var statearr_27539 = state_27534;
(statearr_27539[(7)] = inst_27515);

(statearr_27539[(8)] = inst_27516);

return statearr_27539;
})();
if(inst_27518){
var statearr_27540_27558 = state_27534__$1;
(statearr_27540_27558[(1)] = (7));

} else {
var statearr_27541_27559 = state_27534__$1;
(statearr_27541_27559[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27535 === (3))){
var inst_27532 = (state_27534[(2)]);
var state_27534__$1 = state_27534;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27534__$1,inst_27532);
} else {
if((state_val_27535 === (2))){
var _ = (function (){var statearr_27543 = state_27534;
(statearr_27543[(4)] = cljs.core.cons.call(null,(5),(state_27534[(4)])));

return statearr_27543;
})();
var inst_27505 = fluree.db.dbfunctions.internal.select_from_path.call(null,path);
var inst_27506 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_27507 = cljs.core.PersistentHashMap.EMPTY;
var inst_27508 = [inst_27505,sid,inst_27507];
var inst_27509 = cljs.core.PersistentHashMap.fromArrays(inst_27506,inst_27508);
var inst_27510 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_27511 = fluree.db.dbfunctions.internal.query.call(null,inst_27510,inst_27509);
var state_27534__$1 = state_27534;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27534__$1,(6),inst_27511);
} else {
if((state_val_27535 === (9))){
var inst_27515 = (state_27534[(7)]);
var inst_27516 = (state_27534[(8)]);
var inst_27523 = (state_27534[(2)]);
var inst_27524 = fluree.db.dbfunctions.internal.get_all.call(null,inst_27515,inst_27523);
var inst_27525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27526 = fluree.db.dbfunctions.internal.count.call(null,path);
var inst_27527 = fluree.db.dbfunctions.internal._PLUS_.call(null,inst_27516,inst_27526,(9));
var inst_27528 = [inst_27524,inst_27527];
var inst_27529 = (new cljs.core.PersistentVector(null,2,(5),inst_27525,inst_27528,null));
var _ = (function (){var statearr_27544 = state_27534;
(statearr_27544[(4)] = cljs.core.rest.call(null,(state_27534[(4)])));

return statearr_27544;
})();
var state_27534__$1 = state_27534;
var statearr_27545_27560 = state_27534__$1;
(statearr_27545_27560[(2)] = inst_27529);

(statearr_27545_27560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27535 === (5))){
var _ = (function (){var statearr_27546 = state_27534;
(statearr_27546[(4)] = cljs.core.rest.call(null,(state_27534[(4)])));

return statearr_27546;
})();
var state_27534__$1 = state_27534;
var ex27542 = (state_27534__$1[(2)]);
var statearr_27547_27561 = state_27534__$1;
(statearr_27547_27561[(5)] = ex27542);


var statearr_27548_27562 = state_27534__$1;
(statearr_27548_27562[(1)] = (4));

(statearr_27548_27562[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27535 === (8))){
var inst_27521 = cljs.core.conj.call(null,path,"_id");
var state_27534__$1 = state_27534;
var statearr_27549_27563 = state_27534__$1;
(statearr_27549_27563[(2)] = inst_27521);

(statearr_27549_27563[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0 = (function (){
var statearr_27550 = [null,null,null,null,null,null,null,null,null];
(statearr_27550[(0)] = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__);

(statearr_27550[(1)] = (1));

return statearr_27550;
});
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1 = (function (state_27534){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_27534);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27551){var ex__2730__auto__ = e27551;
var statearr_27552_27564 = state_27534;
(statearr_27552_27564[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_27534[(4)]))){
var statearr_27553_27565 = state_27534;
(statearr_27553_27565[(1)] = cljs.core.first.call(null,(state_27534[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27566 = state_27534;
state_27534 = G__27566;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__ = function(state_27534){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1.call(this,state_27534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27554 = f__2750__auto__.call(null);
(statearr_27554[(6)] = c__2749__auto__);

return statearr_27554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e27567){var e = e27567;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{if(cljs.core.sequential_QMARK_.call(null,key)){
return cljs.core.some.call(null,(function (p1__27568_SHARP_){
return fluree.db.dbfunctions.internal.contains_QMARK_.call(null,coll,p1__27568_SHARP_);
}),key);
} else {
return cljs.core.contains_QMARK_.call(null,coll,key);
}
}catch (e27569){var e = e27569;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27572 = arguments.length;
var i__4865__auto___27573 = (0);
while(true){
if((i__4865__auto___27573 < len__4864__auto___27572)){
args__4870__auto__.push((arguments[i__4865__auto___27573]));

var G__27574 = (i__4865__auto___27573 + (1));
i__4865__auto___27573 = G__27574;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e27571){var e = e27571;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq27570){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27570));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e27575){var e = e27575;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27578 = arguments.length;
var i__4865__auto___27579 = (0);
while(true){
if((i__4865__auto___27579 < len__4864__auto___27578)){
args__4870__auto__.push((arguments[i__4865__auto___27579]));

var G__27580 = (i__4865__auto___27579 + (1));
i__4865__auto___27579 = G__27580;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e27577){var e = e27577;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq27576){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27576));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e27581){var e = e27581;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27638){
var state_val_27639 = (state_27638[(1)]);
if((state_val_27639 === (7))){
var inst_27584 = (state_27638[(2)]);
var state_27638__$1 = state_27638;
var statearr_27640_27674 = state_27638__$1;
(statearr_27640_27674[(2)] = inst_27584);

(statearr_27640_27674[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27639 === (1))){
var state_27638__$1 = state_27638;
var statearr_27641_27675 = state_27638__$1;
(statearr_27641_27675[(2)] = null);

(statearr_27641_27675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27639 === (4))){
var inst_27583 = (state_27638[(2)]);
var state_27638__$1 = (function (){var statearr_27642 = state_27638;
(statearr_27642[(7)] = inst_27583);

return statearr_27642;
})();
var statearr_27643_27676 = state_27638__$1;
(statearr_27643_27676[(2)] = null);

(statearr_27643_27676[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27639 === (15))){
var inst_27608 = (state_27638[(8)]);
var inst_27609 = (state_27638[(9)]);
var inst_27619 = (state_27638[(10)]);
var inst_27606 = (state_27638[(11)]);
var inst_27621 = (state_27638[(12)]);
var inst_27618 = (state_27638[(13)]);
var inst_27625 = (function (){var db = inst_27606;
var prevT = inst_27608;
var db_SINGLEQUOTE_ = inst_27609;
var prev_vals = inst_27618;
var fuel = inst_27619;
var G__27620 = inst_27621;
return (function (p1__27582_SHARP_){
var f = p1__27582_SHARP_;
return fluree.db.flake.o.call(null,f);
});
})();
var inst_27626 = inst_27625.call(null,inst_27621);
var state_27638__$1 = state_27638;
var statearr_27644_27677 = state_27638__$1;
(statearr_27644_27677[(2)] = inst_27626);

(statearr_27644_27677[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27639 === (13))){
var inst_27621 = (state_27638[(12)]);
var inst_27618 = (state_27638[(13)]);
var inst_27617 = (state_27638[(2)]);
var inst_27618__$1 = fluree.db.util.async.throw_err.call(null,inst_27617);
var inst_27619 = fluree.db.dbfunctions.internal.count.call(null,inst_27618__$1);
var inst_27621__$1 = cljs.core.first.call(null,inst_27618__$1);
var inst_27622 = (inst_27621__$1 == null);
var state_27638__$1 = (function (){var statearr_27645 = state_27638;
(statearr_27645[(10)] = inst_27619);

(statearr_27645[(12)] = inst_27621__$1);

(statearr_27645[(13)] = inst_27618__$1);

return statearr_27645;
})();
if(cljs.core.truth_(inst_27622)){
var statearr_27646_27678 = state_27638__$1;
(statearr_27646_27678[(1)] = (14));

} else {
var statearr_27647_27679 = state_27638__$1;
(statearr_27647_27679[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27639 === (6))){
var inst_27593 = (state_27638[(2)]);
var state_27638__$1 = state_27638;
var statearr_27648_27680 = state_27638__$1;
(statearr_27648_27680[(2)] = inst_27593);

(statearr_27648_27680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27639 === (3))){
var inst_27636 = (state_27638[(2)]);
var state_27638__$1 = state_27638;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27638__$1,inst_27636);
} else {
if((state_val_27639 === (12))){
var inst_27633 = (state_27638[(2)]);
var _ = (function (){var statearr_27649 = state_27638;
(statearr_27649[(4)] = cljs.core.rest.call(null,(state_27638[(4)])));

return statearr_27649;
})();
var state_27638__$1 = state_27638;
var statearr_27650_27681 = state_27638__$1;
(statearr_27650_27681[(2)] = inst_27633);

(statearr_27650_27681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27639 === (2))){
var _ = (function (){var statearr_27652 = state_27638;
(statearr_27652[(4)] = cljs.core.cons.call(null,(9),(state_27638[(4)])));

return statearr_27652;
})();
var inst_27599 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_27600 = typeof inst_27599 === 'string';
var state_27638__$1 = state_27638;
if(cljs.core.truth_(inst_27600)){
var statearr_27653_27682 = state_27638__$1;
(statearr_27653_27682[(1)] = (10));

} else {
var statearr_27654_27683 = state_27638__$1;
(statearr_27654_27683[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27639 === (11))){
var inst_27608 = (state_27638[(8)]);
var inst_27609 = (state_27638[(9)]);
var inst_27606 = (state_27638[(11)]);
var inst_27606__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_27607 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_27606__$1);
var inst_27608__$1 = fluree.db.dbfunctions.internal.inc.call(null,inst_27607);
var inst_27609__$1 = cljs.core.assoc.call(null,inst_27606__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27608__$1);
var inst_27610 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27611 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_27612 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_27613 = [inst_27611,inst_27612];
var inst_27614 = (new cljs.core.PersistentVector(null,2,(5),inst_27610,inst_27613,null));
var inst_27615 = fluree.db.dbproto._search.call(null,inst_27609__$1,inst_27614);
var state_27638__$1 = (function (){var statearr_27655 = state_27638;
(statearr_27655[(8)] = inst_27608__$1);

(statearr_27655[(9)] = inst_27609__$1);

(statearr_27655[(11)] = inst_27606__$1);

return statearr_27655;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27638__$1,(13),inst_27615);
} else {
if((state_val_27639 === (9))){
var _ = (function (){var statearr_27656 = state_27638;
(statearr_27656[(4)] = cljs.core.rest.call(null,(state_27638[(4)])));

return statearr_27656;
})();
var state_27638__$1 = state_27638;
var ex27651 = (state_27638__$1[(2)]);
var statearr_27657_27684 = state_27638__$1;
(statearr_27657_27684[(5)] = ex27651);


var statearr_27658_27685 = state_27638__$1;
(statearr_27658_27685[(1)] = (4));

(statearr_27658_27685[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27639 === (5))){
var inst_27583 = (state_27638[(7)]);
var _ = (function (){var statearr_27659 = state_27638;
(statearr_27659[(4)] = cljs.core.cons.call(null,(8),(state_27638[(4)])));

return statearr_27659;
})();
var inst_27590 = fluree.db.dbfunctions.internal.function_error.call(null,inst_27583,"?pO","Context Object");
var ___$1 = (function (){var statearr_27660 = state_27638;
(statearr_27660[(4)] = cljs.core.rest.call(null,(state_27638[(4)])));

return statearr_27660;
})();
var state_27638__$1 = state_27638;
var statearr_27661_27686 = state_27638__$1;
(statearr_27661_27686[(2)] = inst_27590);

(statearr_27661_27686[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27639 === (14))){
var state_27638__$1 = state_27638;
var statearr_27662_27687 = state_27638__$1;
(statearr_27662_27687[(2)] = null);

(statearr_27662_27687[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27639 === (16))){
var inst_27619 = (state_27638[(10)]);
var inst_27628 = (state_27638[(2)]);
var inst_27629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27630 = [inst_27628,inst_27619];
var inst_27631 = (new cljs.core.PersistentVector(null,2,(5),inst_27629,inst_27630,null));
var state_27638__$1 = state_27638;
var statearr_27664_27688 = state_27638__$1;
(statearr_27664_27688[(2)] = inst_27631);

(statearr_27664_27688[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27639 === (10))){
var inst_27602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27603 = [null,(0)];
var inst_27604 = (new cljs.core.PersistentVector(null,2,(5),inst_27602,inst_27603,null));
var state_27638__$1 = state_27638;
var statearr_27665_27689 = state_27638__$1;
(statearr_27665_27689[(2)] = inst_27604);

(statearr_27665_27689[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27639 === (8))){
var _ = (function (){var statearr_27666 = state_27638;
(statearr_27666[(4)] = cljs.core.rest.call(null,(state_27638[(4)])));

return statearr_27666;
})();
var state_27638__$1 = state_27638;
var ex27663 = (state_27638__$1[(2)]);
var statearr_27667_27690 = state_27638__$1;
(statearr_27667_27690[(5)] = ex27663);


var statearr_27668_27691 = state_27638__$1;
(statearr_27668_27691[(1)] = (7));

(statearr_27668_27691[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_27669 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27669[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_27669[(1)] = (1));

return statearr_27669;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_27638){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_27638);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27670){var ex__2730__auto__ = e27670;
var statearr_27671_27692 = state_27638;
(statearr_27671_27692[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_27638[(4)]))){
var statearr_27672_27693 = state_27638;
(statearr_27672_27693[(1)] = cljs.core.first.call(null,(state_27638[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27694 = state_27638;
state_27638 = G__27694;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__ = function(state_27638){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_27638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27673 = f__2750__auto__.call(null);
(statearr_27673[(6)] = c__2749__auto__);

return statearr_27673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27746){
var state_val_27747 = (state_27746[(1)]);
if((state_val_27747 === (7))){
var inst_27696 = (state_27746[(2)]);
var state_27746__$1 = state_27746;
var statearr_27748_27777 = state_27746__$1;
(statearr_27748_27777[(2)] = inst_27696);

(statearr_27748_27777[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27747 === (1))){
var state_27746__$1 = state_27746;
var statearr_27749_27778 = state_27746__$1;
(statearr_27749_27778[(2)] = null);

(statearr_27749_27778[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27747 === (4))){
var inst_27695 = (state_27746[(2)]);
var state_27746__$1 = (function (){var statearr_27750 = state_27746;
(statearr_27750[(7)] = inst_27695);

return statearr_27750;
})();
var statearr_27751_27779 = state_27746__$1;
(statearr_27751_27779[(2)] = null);

(statearr_27751_27779[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27747 === (13))){
var inst_27741 = (state_27746[(2)]);
var _ = (function (){var statearr_27752 = state_27746;
(statearr_27752[(4)] = cljs.core.rest.call(null,(state_27746[(4)])));

return statearr_27752;
})();
var state_27746__$1 = state_27746;
var statearr_27753_27780 = state_27746__$1;
(statearr_27753_27780[(2)] = inst_27741);

(statearr_27753_27780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27747 === (6))){
var inst_27705 = (state_27746[(2)]);
var state_27746__$1 = state_27746;
var statearr_27754_27781 = state_27746__$1;
(statearr_27754_27781[(2)] = inst_27705);

(statearr_27754_27781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27747 === (3))){
var inst_27744 = (state_27746[(2)]);
var state_27746__$1 = state_27746;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27746__$1,inst_27744);
} else {
if((state_val_27747 === (12))){
var inst_27728 = (state_27746[(8)]);
var inst_27737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27738 = [null,inst_27728];
var inst_27739 = (new cljs.core.PersistentVector(null,2,(5),inst_27737,inst_27738,null));
var state_27746__$1 = state_27746;
var statearr_27755_27782 = state_27746__$1;
(statearr_27755_27782[(2)] = inst_27739);

(statearr_27755_27782[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27747 === (2))){
var _ = (function (){var statearr_27757 = state_27746;
(statearr_27757[(4)] = cljs.core.cons.call(null,(9),(state_27746[(4)])));

return statearr_27757;
})();
var inst_27714 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_27715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27717 = [null,pred_name,"?o"];
var inst_27718 = (new cljs.core.PersistentVector(null,3,(5),inst_27716,inst_27717,null));
var inst_27719 = [inst_27718];
var inst_27720 = (new cljs.core.PersistentVector(null,1,(5),inst_27715,inst_27719,null));
var inst_27721 = ["?o",inst_27720,opts];
var inst_27722 = cljs.core.PersistentHashMap.fromArrays(inst_27714,inst_27721);
var inst_27723 = fluree.db.dbfunctions.internal.query.call(null,db,inst_27722);
var state_27746__$1 = state_27746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27746__$1,(10),inst_27723);
} else {
if((state_val_27747 === (11))){
var inst_27727 = (state_27746[(9)]);
var inst_27728 = (state_27746[(8)]);
var inst_27732 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27733 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_27727);
var inst_27734 = [inst_27733,inst_27728];
var inst_27735 = (new cljs.core.PersistentVector(null,2,(5),inst_27732,inst_27734,null));
var state_27746__$1 = state_27746;
var statearr_27758_27783 = state_27746__$1;
(statearr_27758_27783[(2)] = inst_27735);

(statearr_27758_27783[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27747 === (9))){
var _ = (function (){var statearr_27759 = state_27746;
(statearr_27759[(4)] = cljs.core.rest.call(null,(state_27746[(4)])));

return statearr_27759;
})();
var state_27746__$1 = state_27746;
var ex27756 = (state_27746__$1[(2)]);
var statearr_27760_27784 = state_27746__$1;
(statearr_27760_27784[(5)] = ex27756);


var statearr_27761_27785 = state_27746__$1;
(statearr_27761_27785[(1)] = (4));

(statearr_27761_27785[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27747 === (5))){
var inst_27695 = (state_27746[(7)]);
var _ = (function (){var statearr_27763 = state_27746;
(statearr_27763[(4)] = cljs.core.cons.call(null,(8),(state_27746[(4)])));

return statearr_27763;
})();
var inst_27702 = fluree.db.dbfunctions.internal.function_error.call(null,inst_27695,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_27764 = state_27746;
(statearr_27764[(4)] = cljs.core.rest.call(null,(state_27746[(4)])));

return statearr_27764;
})();
var state_27746__$1 = state_27746;
var statearr_27765_27786 = state_27746__$1;
(statearr_27765_27786[(2)] = inst_27702);

(statearr_27765_27786[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27747 === (10))){
var inst_27727 = (state_27746[(9)]);
var inst_27725 = (state_27746[(2)]);
var inst_27726 = fluree.db.util.async.throw_err.call(null,inst_27725);
var inst_27727__$1 = cljs.core.nth.call(null,inst_27726,(0),null);
var inst_27728 = cljs.core.nth.call(null,inst_27726,(1),null);
var inst_27729 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_27727__$1);
var inst_27730 = cljs.core.not.call(null,inst_27729);
var state_27746__$1 = (function (){var statearr_27766 = state_27746;
(statearr_27766[(9)] = inst_27727__$1);

(statearr_27766[(8)] = inst_27728);

return statearr_27766;
})();
if(inst_27730){
var statearr_27767_27787 = state_27746__$1;
(statearr_27767_27787[(1)] = (11));

} else {
var statearr_27768_27788 = state_27746__$1;
(statearr_27768_27788[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27747 === (8))){
var _ = (function (){var statearr_27769 = state_27746;
(statearr_27769[(4)] = cljs.core.rest.call(null,(state_27746[(4)])));

return statearr_27769;
})();
var state_27746__$1 = state_27746;
var ex27762 = (state_27746__$1[(2)]);
var statearr_27770_27789 = state_27746__$1;
(statearr_27770_27789[(5)] = ex27762);


var statearr_27771_27790 = state_27746__$1;
(statearr_27771_27790[(1)] = (7));

(statearr_27771_27790[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_27772 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27772[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__);

(statearr_27772[(1)] = (1));

return statearr_27772;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1 = (function (state_27746){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_27746);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27773){var ex__2730__auto__ = e27773;
var statearr_27774_27791 = state_27746;
(statearr_27774_27791[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_27746[(4)]))){
var statearr_27775_27792 = state_27746;
(statearr_27775_27792[(1)] = cljs.core.first.call(null,(state_27746[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27793 = state_27746;
state_27746 = G__27793;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__ = function(state_27746){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1.call(this,state_27746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27776 = f__2750__auto__.call(null);
(statearr_27776[(6)] = c__2749__auto__);

return statearr_27776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,(function (){var and__4251__auto__ = typeof email === 'string';
if(and__4251__auto__){
return cljs.core.re_matches.call(null,pattern,email);
} else {
return and__4251__auto__;
}
})());
}catch (e27794){var e = e27794;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__27796 = arguments.length;
switch (G__27796) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27866){
var state_val_27867 = (state_27866[(1)]);
if((state_val_27867 === (7))){
var inst_27798 = (state_27866[(2)]);
var state_27866__$1 = state_27866;
var statearr_27868_27912 = state_27866__$1;
(statearr_27868_27912[(2)] = inst_27798);

(statearr_27868_27912[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (20))){
var inst_27842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27843 = ["*"];
var inst_27844 = (new cljs.core.PersistentVector(null,1,(5),inst_27842,inst_27843,null));
var state_27866__$1 = state_27866;
var statearr_27869_27913 = state_27866__$1;
(statearr_27869_27913[(2)] = inst_27844);

(statearr_27869_27913[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (1))){
var state_27866__$1 = state_27866;
var statearr_27870_27914 = state_27866__$1;
(statearr_27870_27914[(2)] = null);

(statearr_27870_27914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (4))){
var inst_27797 = (state_27866[(2)]);
var state_27866__$1 = (function (){var statearr_27871 = state_27866;
(statearr_27871[(7)] = inst_27797);

return statearr_27871;
})();
var statearr_27872_27915 = state_27866__$1;
(statearr_27872_27915[(2)] = null);

(statearr_27872_27915[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (15))){
var inst_27861 = (state_27866[(2)]);
var _ = (function (){var statearr_27873 = state_27866;
(statearr_27873[(4)] = cljs.core.rest.call(null,(state_27866[(4)])));

return statearr_27873;
})();
var state_27866__$1 = state_27866;
var statearr_27874_27916 = state_27866__$1;
(statearr_27874_27916[(2)] = inst_27861);

(statearr_27874_27916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (21))){
var inst_27825 = (state_27866[(8)]);
var inst_27832 = (state_27866[(9)]);
var inst_27846 = (state_27866[(2)]);
var inst_27847 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_27848 = cljs.core.PersistentHashMap.EMPTY;
var inst_27849 = [inst_27846,inst_27832,inst_27848];
var inst_27850 = cljs.core.PersistentHashMap.fromArrays(inst_27847,inst_27849);
var inst_27851 = fluree.db.dbfunctions.internal.query.call(null,inst_27825,inst_27850);
var state_27866__$1 = state_27866;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27866__$1,(22),inst_27851);
} else {
if((state_val_27867 === (13))){
var inst_27820 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_27866__$1 = state_27866;
var statearr_27875_27917 = state_27866__$1;
(statearr_27875_27917[(2)] = inst_27820);

(statearr_27875_27917[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (22))){
var inst_27853 = (state_27866[(2)]);
var inst_27854 = fluree.db.util.async.throw_err.call(null,inst_27853);
var inst_27855 = cljs.core.nth.call(null,inst_27854,(0),null);
var inst_27856 = cljs.core.nth.call(null,inst_27854,(1),null);
var inst_27857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27858 = [inst_27855,inst_27856];
var inst_27859 = (new cljs.core.PersistentVector(null,2,(5),inst_27857,inst_27858,null));
var state_27866__$1 = state_27866;
var statearr_27876_27918 = state_27866__$1;
(statearr_27876_27918[(2)] = inst_27859);

(statearr_27876_27918[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (6))){
var inst_27807 = (state_27866[(2)]);
var state_27866__$1 = state_27866;
var statearr_27877_27919 = state_27866__$1;
(statearr_27877_27919[(2)] = inst_27807);

(statearr_27877_27919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (17))){
var inst_27829 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_27830 = fluree.db.dbfunctions.internal.get.call(null,inst_27829,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_27866__$1 = state_27866;
var statearr_27878_27920 = state_27866__$1;
(statearr_27878_27920[(2)] = inst_27830);

(statearr_27878_27920[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (3))){
var inst_27864 = (state_27866[(2)]);
var state_27866__$1 = state_27866;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27866__$1,inst_27864);
} else {
if((state_val_27867 === (12))){
var inst_27818 = (state_27866[(2)]);
var state_27866__$1 = state_27866;
if(cljs.core.truth_(inst_27818)){
var statearr_27879_27921 = state_27866__$1;
(statearr_27879_27921[(1)] = (13));

} else {
var statearr_27880_27922 = state_27866__$1;
(statearr_27880_27922[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (2))){
var inst_27813 = (state_27866[(10)]);
var _ = (function (){var statearr_27881 = state_27866;
(statearr_27881[(4)] = cljs.core.cons.call(null,(9),(state_27866[(4)])));

return statearr_27881;
})();
var inst_27813__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_27866__$1 = (function (){var statearr_27882 = state_27866;
(statearr_27882[(10)] = inst_27813__$1);

return statearr_27882;
})();
if(cljs.core.truth_(inst_27813__$1)){
var statearr_27883_27923 = state_27866__$1;
(statearr_27883_27923[(1)] = (10));

} else {
var statearr_27884_27924 = state_27866__$1;
(statearr_27884_27924[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (19))){
var inst_27834 = cljs.core.PersistentVector.EMPTY;
var inst_27835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27836 = ["*"];
var inst_27837 = (new cljs.core.PersistentVector(null,1,(5),inst_27835,inst_27836,null));
var inst_27838 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_27839 = cljs.core.concat.call(null,inst_27837,inst_27838);
var inst_27840 = cljs.core.into.call(null,inst_27834,inst_27839);
var state_27866__$1 = state_27866;
var statearr_27886_27925 = state_27866__$1;
(statearr_27886_27925[(2)] = inst_27840);

(statearr_27886_27925[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (11))){
var inst_27813 = (state_27866[(10)]);
var state_27866__$1 = state_27866;
var statearr_27887_27926 = state_27866__$1;
(statearr_27887_27926[(2)] = inst_27813);

(statearr_27887_27926[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (9))){
var _ = (function (){var statearr_27888 = state_27866;
(statearr_27888[(4)] = cljs.core.rest.call(null,(state_27866[(4)])));

return statearr_27888;
})();
var state_27866__$1 = state_27866;
var ex27885 = (state_27866__$1[(2)]);
var statearr_27889_27927 = state_27866__$1;
(statearr_27889_27927[(5)] = ex27885);


var statearr_27890_27928 = state_27866__$1;
(statearr_27890_27928[(1)] = (4));

(statearr_27890_27928[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (5))){
var inst_27797 = (state_27866[(7)]);
var _ = (function (){var statearr_27891 = state_27866;
(statearr_27891[(4)] = cljs.core.cons.call(null,(8),(state_27866[(4)])));

return statearr_27891;
})();
var inst_27804 = fluree.db.dbfunctions.internal.function_error.call(null,inst_27797,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_27892 = state_27866;
(statearr_27892[(4)] = cljs.core.rest.call(null,(state_27866[(4)])));

return statearr_27892;
})();
var state_27866__$1 = state_27866;
var statearr_27893_27929 = state_27866__$1;
(statearr_27893_27929[(2)] = inst_27804);

(statearr_27893_27929[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (14))){
var inst_27826 = (state_27866[(11)]);
var inst_27825 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_27826__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_27866__$1 = (function (){var statearr_27894 = state_27866;
(statearr_27894[(11)] = inst_27826__$1);

(statearr_27894[(8)] = inst_27825);

return statearr_27894;
})();
if(cljs.core.truth_(inst_27826__$1)){
var statearr_27895_27930 = state_27866__$1;
(statearr_27895_27930[(1)] = (16));

} else {
var statearr_27896_27931 = state_27866__$1;
(statearr_27896_27931[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (16))){
var inst_27826 = (state_27866[(11)]);
var state_27866__$1 = state_27866;
var statearr_27897_27932 = state_27866__$1;
(statearr_27897_27932[(2)] = inst_27826);

(statearr_27897_27932[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (10))){
var inst_27815 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_27866__$1 = state_27866;
var statearr_27899_27933 = state_27866__$1;
(statearr_27899_27933[(2)] = inst_27815);

(statearr_27899_27933[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (18))){
var inst_27832 = (state_27866[(2)]);
var state_27866__$1 = (function (){var statearr_27900 = state_27866;
(statearr_27900[(9)] = inst_27832);

return statearr_27900;
})();
if(cljs.core.truth_(additional_params)){
var statearr_27901_27934 = state_27866__$1;
(statearr_27901_27934[(1)] = (19));

} else {
var statearr_27902_27935 = state_27866__$1;
(statearr_27902_27935[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27867 === (8))){
var _ = (function (){var statearr_27903 = state_27866;
(statearr_27903[(4)] = cljs.core.rest.call(null,(state_27866[(4)])));

return statearr_27903;
})();
var state_27866__$1 = state_27866;
var ex27898 = (state_27866__$1[(2)]);
var statearr_27904_27936 = state_27866__$1;
(statearr_27904_27936[(5)] = ex27898);


var statearr_27905_27937 = state_27866__$1;
(statearr_27905_27937[(1)] = (7));

(statearr_27905_27937[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_27906 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27906[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_27906[(1)] = (1));

return statearr_27906;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_27866){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_27866);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27907){var ex__2730__auto__ = e27907;
var statearr_27908_27938 = state_27866;
(statearr_27908_27938[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_27866[(4)]))){
var statearr_27909_27939 = state_27866;
(statearr_27909_27939[(1)] = cljs.core.first.call(null,(state_27866[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27940 = state_27866;
state_27866 = G__27940;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_27866){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_27866);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27910 = f__2750__auto__.call(null);
(statearr_27910[(6)] = c__2749__auto__);

return statearr_27910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__27942 = arguments.length;
switch (G__27942) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27986){
var state_val_27987 = (state_27986[(1)]);
if((state_val_27987 === (7))){
var inst_27964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27965 = ["*"];
var inst_27966 = (new cljs.core.PersistentVector(null,1,(5),inst_27964,inst_27965,null));
var state_27986__$1 = state_27986;
var statearr_27988_28008 = state_27986__$1;
(statearr_27988_28008[(2)] = inst_27966);

(statearr_27988_28008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27987 === (1))){
var state_27986__$1 = state_27986;
var statearr_27989_28009 = state_27986__$1;
(statearr_27989_28009[(2)] = null);

(statearr_27989_28009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27987 === (4))){
var inst_27943 = (state_27986[(2)]);
var inst_27944 = fluree.db.dbfunctions.internal.function_error.call(null,inst_27943,"?p","Context Object",additional_params);
var state_27986__$1 = state_27986;
var statearr_27990_28010 = state_27986__$1;
(statearr_27990_28010[(2)] = inst_27944);

(statearr_27990_28010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27987 === (6))){
var inst_27956 = cljs.core.PersistentVector.EMPTY;
var inst_27957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27958 = ["*"];
var inst_27959 = (new cljs.core.PersistentVector(null,1,(5),inst_27957,inst_27958,null));
var inst_27960 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_27961 = cljs.core.concat.call(null,inst_27959,inst_27960);
var inst_27962 = cljs.core.into.call(null,inst_27956,inst_27961);
var state_27986__$1 = state_27986;
var statearr_27991_28011 = state_27986__$1;
(statearr_27991_28011[(2)] = inst_27962);

(statearr_27991_28011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27987 === (3))){
var inst_27984 = (state_27986[(2)]);
var state_27986__$1 = state_27986;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27986__$1,inst_27984);
} else {
if((state_val_27987 === (2))){
var _ = (function (){var statearr_27993 = state_27986;
(statearr_27993[(4)] = cljs.core.cons.call(null,(5),(state_27986[(4)])));

return statearr_27993;
})();
var inst_27953 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_27954 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_27986__$1 = (function (){var statearr_27994 = state_27986;
(statearr_27994[(7)] = inst_27954);

(statearr_27994[(8)] = inst_27953);

return statearr_27994;
})();
if(cljs.core.truth_(additional_params)){
var statearr_27995_28012 = state_27986__$1;
(statearr_27995_28012[(1)] = (6));

} else {
var statearr_27996_28013 = state_27986__$1;
(statearr_27996_28013[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27987 === (9))){
var inst_27975 = (state_27986[(2)]);
var inst_27976 = fluree.db.util.async.throw_err.call(null,inst_27975);
var inst_27977 = cljs.core.nth.call(null,inst_27976,(0),null);
var inst_27978 = cljs.core.nth.call(null,inst_27976,(1),null);
var inst_27979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27980 = [inst_27977,inst_27978];
var inst_27981 = (new cljs.core.PersistentVector(null,2,(5),inst_27979,inst_27980,null));
var _ = (function (){var statearr_27997 = state_27986;
(statearr_27997[(4)] = cljs.core.rest.call(null,(state_27986[(4)])));

return statearr_27997;
})();
var state_27986__$1 = state_27986;
var statearr_27998_28014 = state_27986__$1;
(statearr_27998_28014[(2)] = inst_27981);

(statearr_27998_28014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27987 === (5))){
var _ = (function (){var statearr_27999 = state_27986;
(statearr_27999[(4)] = cljs.core.rest.call(null,(state_27986[(4)])));

return statearr_27999;
})();
var state_27986__$1 = state_27986;
var ex27992 = (state_27986__$1[(2)]);
var statearr_28000_28015 = state_27986__$1;
(statearr_28000_28015[(5)] = ex27992);


var statearr_28001_28016 = state_27986__$1;
(statearr_28001_28016[(1)] = (4));

(statearr_28001_28016[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27987 === (8))){
var inst_27954 = (state_27986[(7)]);
var inst_27953 = (state_27986[(8)]);
var inst_27968 = (state_27986[(2)]);
var inst_27969 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_27970 = cljs.core.PersistentHashMap.EMPTY;
var inst_27971 = [inst_27968,inst_27954,inst_27970];
var inst_27972 = cljs.core.PersistentHashMap.fromArrays(inst_27969,inst_27971);
var inst_27973 = fluree.db.dbfunctions.internal.query.call(null,inst_27953,inst_27972);
var state_27986__$1 = state_27986;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27986__$1,(9),inst_27973);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_28002 = [null,null,null,null,null,null,null,null,null];
(statearr_28002[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_28002[(1)] = (1));

return statearr_28002;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_27986){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_27986);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28003){var ex__2730__auto__ = e28003;
var statearr_28004_28017 = state_27986;
(statearr_28004_28017[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_27986[(4)]))){
var statearr_28005_28018 = state_27986;
(statearr_28005_28018[(1)] = cljs.core.first.call(null,(state_27986[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28019 = state_27986;
state_27986 = G__28019;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_27986){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_27986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28006 = f__2750__auto__.call(null);
(statearr_28006[(6)] = c__2749__auto__);

return statearr_28006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28063){
var state_val_28064 = (state_28063[(1)]);
if((state_val_28064 === (1))){
var state_28063__$1 = state_28063;
var statearr_28065_28079 = state_28063__$1;
(statearr_28065_28079[(2)] = null);

(statearr_28065_28079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28064 === (2))){
var _ = (function (){var statearr_28066 = state_28063;
(statearr_28066[(4)] = cljs.core.cons.call(null,(5),(state_28063[(4)])));

return statearr_28066;
})();
var inst_28030 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28031 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28032 = ["_user/_auth"];
var inst_28033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28034 = ["*"];
var inst_28035 = (new cljs.core.PersistentVector(null,1,(5),inst_28033,inst_28034,null));
var inst_28036 = [inst_28035];
var inst_28037 = cljs.core.PersistentHashMap.fromArrays(inst_28032,inst_28036);
var inst_28038 = [inst_28037];
var inst_28039 = (new cljs.core.PersistentVector(null,1,(5),inst_28031,inst_28038,null));
var inst_28040 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28041 = cljs.core.PersistentHashMap.EMPTY;
var inst_28042 = [inst_28039,inst_28040,inst_28041];
var inst_28043 = cljs.core.PersistentHashMap.fromArrays(inst_28030,inst_28042);
var inst_28044 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28045 = fluree.db.dbfunctions.internal.query.call(null,inst_28044,inst_28043);
var state_28063__$1 = state_28063;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28063__$1,(6),inst_28045);
} else {
if((state_val_28064 === (3))){
var inst_28061 = (state_28063[(2)]);
var state_28063__$1 = state_28063;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28063__$1,inst_28061);
} else {
if((state_val_28064 === (4))){
var inst_28020 = (state_28063[(2)]);
var inst_28021 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28020,"?user_id-from-auth","Context Object");
var state_28063__$1 = state_28063;
var statearr_28068_28080 = state_28063__$1;
(statearr_28068_28080[(2)] = inst_28021);

(statearr_28068_28080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28064 === (5))){
var _ = (function (){var statearr_28069 = state_28063;
(statearr_28069[(4)] = cljs.core.rest.call(null,(state_28063[(4)])));

return statearr_28069;
})();
var state_28063__$1 = state_28063;
var ex28067 = (state_28063__$1[(2)]);
var statearr_28070_28081 = state_28063__$1;
(statearr_28070_28081[(5)] = ex28067);


var statearr_28071_28082 = state_28063__$1;
(statearr_28071_28082[(1)] = (4));

(statearr_28071_28082[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28064 === (6))){
var inst_28047 = (state_28063[(2)]);
var inst_28048 = fluree.db.util.async.throw_err.call(null,inst_28047);
var inst_28049 = cljs.core.nth.call(null,inst_28048,(0),null);
var inst_28050 = cljs.core.nth.call(null,inst_28048,(1),null);
var inst_28051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28052 = ["_user/_auth","_id"];
var inst_28053 = (new cljs.core.PersistentVector(null,2,(5),inst_28051,inst_28052,null));
var inst_28054 = fluree.db.dbfunctions.internal.get_in.call(null,inst_28049,inst_28053);
var inst_28055 = cljs.core.first.call(null,inst_28054);
var inst_28056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28057 = [inst_28055,inst_28050];
var inst_28058 = (new cljs.core.PersistentVector(null,2,(5),inst_28056,inst_28057,null));
var _ = (function (){var statearr_28072 = state_28063;
(statearr_28072[(4)] = cljs.core.rest.call(null,(state_28063[(4)])));

return statearr_28072;
})();
var state_28063__$1 = state_28063;
var statearr_28073_28083 = state_28063__$1;
(statearr_28073_28083[(2)] = inst_28058);

(statearr_28073_28083[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0 = (function (){
var statearr_28074 = [null,null,null,null,null,null,null];
(statearr_28074[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__);

(statearr_28074[(1)] = (1));

return statearr_28074;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1 = (function (state_28063){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_28063);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28075){var ex__2730__auto__ = e28075;
var statearr_28076_28084 = state_28063;
(statearr_28076_28084[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_28063[(4)]))){
var statearr_28077_28085 = state_28063;
(statearr_28077_28085[(1)] = cljs.core.first.call(null,(state_28063[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28086 = state_28063;
state_28063 = G__28086;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__ = function(state_28063){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1.call(this,state_28063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28078 = f__2750__auto__.call(null);
(statearr_28078[(6)] = c__2749__auto__);

return statearr_28078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28108){
var state_val_28109 = (state_28108[(1)]);
if((state_val_28109 === (7))){
var inst_28093 = (state_28108[(7)]);
var inst_28097 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28098 = fluree.db.dbproto._subid.call(null,inst_28097,inst_28093);
var state_28108__$1 = state_28108;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28108__$1,(9),inst_28098);
} else {
if((state_val_28109 === (1))){
var state_28108__$1 = state_28108;
var statearr_28110_28129 = state_28108__$1;
(statearr_28110_28129[(2)] = null);

(statearr_28110_28129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28109 === (4))){
var inst_28087 = (state_28108[(2)]);
var state_28108__$1 = state_28108;
var statearr_28111_28130 = state_28108__$1;
(statearr_28111_28130[(2)] = inst_28087);

(statearr_28111_28130[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28109 === (6))){
var inst_28093 = (state_28108[(7)]);
var state_28108__$1 = state_28108;
var statearr_28112_28131 = state_28108__$1;
(statearr_28112_28131[(2)] = inst_28093);

(statearr_28112_28131[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28109 === (3))){
var inst_28106 = (state_28108[(2)]);
var state_28108__$1 = state_28108;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28108__$1,inst_28106);
} else {
if((state_val_28109 === (2))){
var inst_28093 = (state_28108[(7)]);
var _ = (function (){var statearr_28114 = state_28108;
(statearr_28114[(4)] = cljs.core.cons.call(null,(5),(state_28108[(4)])));

return statearr_28114;
})();
var inst_28093__$1 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28094 = typeof inst_28093__$1 === 'number';
var state_28108__$1 = (function (){var statearr_28115 = state_28108;
(statearr_28115[(7)] = inst_28093__$1);

return statearr_28115;
})();
if(cljs.core.truth_(inst_28094)){
var statearr_28116_28132 = state_28108__$1;
(statearr_28116_28132[(1)] = (6));

} else {
var statearr_28117_28133 = state_28108__$1;
(statearr_28117_28133[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28109 === (9))){
var inst_28100 = (state_28108[(2)]);
var inst_28101 = fluree.db.util.async.throw_err.call(null,inst_28100);
var state_28108__$1 = state_28108;
var statearr_28118_28134 = state_28108__$1;
(statearr_28118_28134[(2)] = inst_28101);

(statearr_28118_28134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28109 === (5))){
var _ = (function (){var statearr_28119 = state_28108;
(statearr_28119[(4)] = cljs.core.rest.call(null,(state_28108[(4)])));

return statearr_28119;
})();
var state_28108__$1 = state_28108;
var ex28113 = (state_28108__$1[(2)]);
var statearr_28120_28135 = state_28108__$1;
(statearr_28120_28135[(5)] = ex28113);


if((ex28113 instanceof Error)){
var statearr_28121_28136 = state_28108__$1;
(statearr_28121_28136[(1)] = (4));

(statearr_28121_28136[(5)] = null);

} else {
throw ex28113;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28109 === (8))){
var inst_28103 = (state_28108[(2)]);
var _ = (function (){var statearr_28122 = state_28108;
(statearr_28122[(4)] = cljs.core.rest.call(null,(state_28108[(4)])));

return statearr_28122;
})();
var state_28108__$1 = state_28108;
var statearr_28123_28137 = state_28108__$1;
(statearr_28123_28137[(2)] = inst_28103);

(statearr_28123_28137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_28124 = [null,null,null,null,null,null,null,null];
(statearr_28124[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_28124[(1)] = (1));

return statearr_28124;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_28108){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_28108);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28125){var ex__2730__auto__ = e28125;
var statearr_28126_28138 = state_28108;
(statearr_28126_28138[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_28108[(4)]))){
var statearr_28127_28139 = state_28108;
(statearr_28127_28139[(1)] = cljs.core.first.call(null,(state_28108[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28140 = state_28108;
state_28108 = G__28140;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_28108){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_28108);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28128 = f__2750__auto__.call(null);
(statearr_28128[(6)] = c__2749__auto__);

return statearr_28128;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__28141_SHARP_){
return fluree.db.flake.op.call(null,p1__28141_SHARP_) === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__28142_SHARP_){
return fluree.db.flake.o.call(null,p1__28142_SHARP_);
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e28143){var e = e28143;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__28144_SHARP_){
return fluree.db.flake.op.call(null,p1__28144_SHARP_) === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__28145_SHARP_){
return fluree.db.flake.o.call(null,p1__28145_SHARP_);
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e28146){var e = e28146;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e28147){var e = e28147;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28227){
var state_val_28228 = (state_28227[(1)]);
if((state_val_28228 === (7))){
var inst_28166 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_28167 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28168 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_28169 = cljs.core.PersistentHashMap.fromArrays(inst_28167,inst_28168);
var inst_28170 = cljs.core.ex_info.call(null,inst_28166,inst_28169);
var inst_28171 = (function(){throw inst_28170})();
var state_28227__$1 = state_28227;
var statearr_28229_28264 = state_28227__$1;
(statearr_28229_28264[(2)] = inst_28171);

(statearr_28229_28264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (1))){
var state_28227__$1 = state_28227;
var statearr_28230_28265 = state_28227__$1;
(statearr_28230_28265[(2)] = null);

(statearr_28230_28265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (4))){
var inst_28148 = (state_28227[(2)]);
var state_28227__$1 = state_28227;
var statearr_28231_28266 = state_28227__$1;
(statearr_28231_28266[(2)] = inst_28148);

(statearr_28231_28266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (15))){
var inst_28211 = (state_28227[(7)]);
var inst_28207 = (state_28227[(2)]);
var inst_28208 = fluree.db.util.async.throw_err.call(null,inst_28207);
var inst_28209 = cljs.core.nth.call(null,inst_28208,(0),null);
var inst_28210 = cljs.core.nth.call(null,inst_28208,(1),null);
var inst_28211__$1 = cljs.core.first.call(null,inst_28209);
var inst_28212 = cljs.core._EQ_.call(null,inst_28211__$1,compare_val);
var state_28227__$1 = (function (){var statearr_28232 = state_28227;
(statearr_28232[(7)] = inst_28211__$1);

(statearr_28232[(8)] = inst_28210);

return statearr_28232;
})();
if(inst_28212){
var statearr_28233_28267 = state_28227__$1;
(statearr_28233_28267[(1)] = (16));

} else {
var statearr_28234_28268 = state_28227__$1;
(statearr_28234_28268[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (13))){
var state_28227__$1 = state_28227;
var statearr_28235_28269 = state_28227__$1;
(statearr_28235_28269[(2)] = null);

(statearr_28235_28269[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (6))){
var state_28227__$1 = state_28227;
var statearr_28236_28270 = state_28227__$1;
(statearr_28236_28270[(2)] = null);

(statearr_28236_28270[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (17))){
var inst_28211 = (state_28227[(7)]);
var inst_28215 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28211)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_28216 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28217 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_28218 = cljs.core.PersistentHashMap.fromArrays(inst_28216,inst_28217);
var inst_28219 = cljs.core.ex_info.call(null,inst_28215,inst_28218);
var inst_28220 = (function(){throw inst_28219})();
var state_28227__$1 = state_28227;
var statearr_28237_28271 = state_28227__$1;
(statearr_28237_28271[(2)] = inst_28220);

(statearr_28237_28271[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (3))){
var inst_28225 = (state_28227[(2)]);
var state_28227__$1 = state_28227;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28227__$1,inst_28225);
} else {
if((state_val_28228 === (12))){
var inst_28163 = (state_28227[(9)]);
var inst_28186 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_28163);
var inst_28187 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28188 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_28189 = cljs.core.PersistentHashMap.fromArrays(inst_28187,inst_28188);
var inst_28190 = cljs.core.ex_info.call(null,inst_28186,inst_28189);
var inst_28191 = (function(){throw inst_28190})();
var state_28227__$1 = state_28227;
var statearr_28238_28272 = state_28227__$1;
(statearr_28238_28272[(2)] = inst_28191);

(statearr_28238_28272[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (2))){
var inst_28162 = (state_28227[(10)]);
var inst_28161 = (state_28227[(11)]);
var inst_28160 = (state_28227[(12)]);
var _ = (function (){var statearr_28239 = state_28227;
(statearr_28239[(4)] = cljs.core.cons.call(null,(5),(state_28227[(4)])));

return statearr_28239;
})();
var inst_28158 = _QMARK_ctx;
var inst_28159 = cljs.core.__destructure_map.call(null,inst_28158);
var inst_28160__$1 = cljs.core.get.call(null,inst_28159,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_28161__$1 = cljs.core.get.call(null,inst_28159,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_28162__$1 = cljs.core.get.call(null,inst_28159,new cljs.core.Keyword(null,"db","db",993250759));
var inst_28163 = fluree.db.dbproto._p_prop.call(null,inst_28162__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_28161__$1);
var state_28227__$1 = (function (){var statearr_28240 = state_28227;
(statearr_28240[(9)] = inst_28163);

(statearr_28240[(10)] = inst_28162__$1);

(statearr_28240[(11)] = inst_28161__$1);

(statearr_28240[(12)] = inst_28160__$1);

return statearr_28240;
})();
if(cljs.core.truth_(inst_28160__$1)){
var statearr_28241_28273 = state_28227__$1;
(statearr_28241_28273[(1)] = (6));

} else {
var statearr_28242_28274 = state_28227__$1;
(statearr_28242_28274[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (11))){
var inst_28162 = (state_28227[(10)]);
var inst_28161 = (state_28227[(11)]);
var inst_28183 = (state_28227[(2)]);
var inst_28184 = fluree.db.dbproto._p_prop.call(null,inst_28162,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_28161);
var state_28227__$1 = (function (){var statearr_28244 = state_28227;
(statearr_28244[(13)] = inst_28183);

return statearr_28244;
})();
if(cljs.core.truth_(inst_28184)){
var statearr_28245_28275 = state_28227__$1;
(statearr_28245_28275[(1)] = (12));

} else {
var statearr_28246_28276 = state_28227__$1;
(statearr_28246_28276[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (9))){
var state_28227__$1 = state_28227;
var statearr_28247_28277 = state_28227__$1;
(statearr_28247_28277[(2)] = null);

(statearr_28247_28277[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (5))){
var _ = (function (){var statearr_28248 = state_28227;
(statearr_28248[(4)] = cljs.core.rest.call(null,(state_28227[(4)])));

return statearr_28248;
})();
var state_28227__$1 = state_28227;
var ex28243 = (state_28227__$1[(2)]);
var statearr_28249_28278 = state_28227__$1;
(statearr_28249_28278[(5)] = ex28243);


if((ex28243 instanceof Error)){
var statearr_28250_28279 = state_28227__$1;
(statearr_28250_28279[(1)] = (4));

(statearr_28250_28279[(5)] = null);

} else {
throw ex28243;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (14))){
var inst_28163 = (state_28227[(9)]);
var inst_28162 = (state_28227[(10)]);
var inst_28160 = (state_28227[(12)]);
var inst_28194 = (state_28227[(2)]);
var inst_28195 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28198 = [inst_28160,inst_28163,"?current-val"];
var inst_28199 = (new cljs.core.PersistentVector(null,3,(5),inst_28197,inst_28198,null));
var inst_28200 = [inst_28199];
var inst_28201 = (new cljs.core.PersistentVector(null,1,(5),inst_28196,inst_28200,null));
var inst_28202 = cljs.core.PersistentHashMap.EMPTY;
var inst_28203 = ["?current-val",inst_28201,inst_28202];
var inst_28204 = cljs.core.PersistentHashMap.fromArrays(inst_28195,inst_28203);
var inst_28205 = fluree.db.dbfunctions.internal.query.call(null,inst_28162,inst_28204);
var state_28227__$1 = (function (){var statearr_28251 = state_28227;
(statearr_28251[(14)] = inst_28194);

return statearr_28251;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28227__$1,(15),inst_28205);
} else {
if((state_val_28228 === (16))){
var state_28227__$1 = state_28227;
var statearr_28252_28280 = state_28227__$1;
(statearr_28252_28280[(2)] = new_val);

(statearr_28252_28280[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (10))){
var inst_28176 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_28177 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28178 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_28179 = cljs.core.PersistentHashMap.fromArrays(inst_28177,inst_28178);
var inst_28180 = cljs.core.ex_info.call(null,inst_28176,inst_28179);
var inst_28181 = (function(){throw inst_28180})();
var state_28227__$1 = state_28227;
var statearr_28253_28281 = state_28227__$1;
(statearr_28253_28281[(2)] = inst_28181);

(statearr_28253_28281[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (18))){
var inst_28222 = (state_28227[(2)]);
var _ = (function (){var statearr_28254 = state_28227;
(statearr_28254[(4)] = cljs.core.rest.call(null,(state_28227[(4)])));

return statearr_28254;
})();
var state_28227__$1 = state_28227;
var statearr_28255_28282 = state_28227__$1;
(statearr_28255_28282[(2)] = inst_28222);

(statearr_28255_28282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28228 === (8))){
var inst_28163 = (state_28227[(9)]);
var inst_28173 = (state_28227[(2)]);
var state_28227__$1 = (function (){var statearr_28256 = state_28227;
(statearr_28256[(15)] = inst_28173);

return statearr_28256;
})();
if(cljs.core.truth_(inst_28163)){
var statearr_28257_28283 = state_28227__$1;
(statearr_28257_28283[(1)] = (9));

} else {
var statearr_28258_28284 = state_28227__$1;
(statearr_28258_28284[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_28259 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28259[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__);

(statearr_28259[(1)] = (1));

return statearr_28259;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1 = (function (state_28227){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_28227);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28260){var ex__2730__auto__ = e28260;
var statearr_28261_28285 = state_28227;
(statearr_28261_28285[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_28227[(4)]))){
var statearr_28262_28286 = state_28227;
(statearr_28262_28286[(1)] = cljs.core.first.call(null,(state_28227[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28287 = state_28227;
state_28227 = G__28287;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__ = function(state_28227){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1.call(this,state_28227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28263 = f__2750__auto__.call(null);
(statearr_28263[(6)] = c__2749__auto__);

return statearr_28263;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
