// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.query.fql_resp');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___72625 = arguments.length;
var i__4865__auto___72626 = (0);
while(true){
if((i__4865__auto___72626 < len__4864__auto___72625)){
args__4870__auto__.push((arguments[i__4865__auto___72626]));

var G__72627 = (i__4865__auto___72626 + (1));
i__4865__auto___72626 = G__72627;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__72554){
var vec__72555 = p__72554;
var opts = cljs.core.nth.call(null,vec__72555,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2749__auto___72628 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72602){
var state_val_72603 = (state_72602[(1)]);
if((state_val_72603 === (7))){
var inst_72579 = (state_72602[(7)]);
var inst_72588 = (state_72602[(8)]);
var inst_72590 = fluree.db.time_travel.as_of_block.call(null,inst_72588,inst_72579);
var state_72602__$1 = state_72602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72602__$1,(10),inst_72590);
} else {
if((state_val_72603 === (1))){
var state_72602__$1 = state_72602;
var statearr_72604_72629 = state_72602__$1;
(statearr_72604_72629[(2)] = null);

(statearr_72604_72629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72603 === (4))){
var inst_72558 = (state_72602[(2)]);
var inst_72559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72560 = [inst_72558];
var inst_72561 = (new cljs.core.PersistentVector(null,1,(5),inst_72559,inst_72560,null));
var inst_72562 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72561);
var inst_72563 = cljs.core.async.put_BANG_.call(null,pc,inst_72558);
var inst_72564 = cljs.core.async.close_BANG_.call(null,pc);
var state_72602__$1 = (function (){var statearr_72605 = state_72602;
(statearr_72605[(9)] = inst_72563);

(statearr_72605[(10)] = inst_72562);

return statearr_72605;
})();
var statearr_72606_72630 = state_72602__$1;
(statearr_72606_72630[(2)] = inst_72564);

(statearr_72606_72630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72603 === (6))){
var inst_72579 = (state_72602[(7)]);
var inst_72582 = (state_72602[(11)]);
var inst_72583 = (state_72602[(12)]);
var inst_72586 = (state_72602[(2)]);
var inst_72587 = fluree.db.util.async.throw_err.call(null,inst_72586);
var inst_72588 = cljs.core.assoc.call(null,inst_72587,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_72582,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_72583);
var state_72602__$1 = (function (){var statearr_72607 = state_72602;
(statearr_72607[(8)] = inst_72588);

return statearr_72607;
})();
if(cljs.core.truth_(inst_72579)){
var statearr_72608_72631 = state_72602__$1;
(statearr_72608_72631[(1)] = (7));

} else {
var statearr_72609_72632 = state_72602__$1;
(statearr_72609_72632[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72603 === (3))){
var inst_72600 = (state_72602[(2)]);
var state_72602__$1 = state_72602;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72602__$1,inst_72600);
} else {
if((state_val_72603 === (2))){
var _ = (function (){var statearr_72611 = state_72602;
(statearr_72611[(4)] = cljs.core.cons.call(null,(5),(state_72602[(4)])));

return statearr_72611;
})();
var inst_72574 = opts;
var inst_72575 = cljs.core.__destructure_map.call(null,inst_72574);
var inst_72576 = cljs.core.get.call(null,inst_72575,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_72577 = cljs.core.get.call(null,inst_72575,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_72578 = cljs.core.get.call(null,inst_72575,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_72579 = cljs.core.get.call(null,inst_72575,new cljs.core.Keyword(null,"block","block",664686210));
var inst_72580 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_72581 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_72582 = cljs.core.nth.call(null,inst_72581,(0),null);
var inst_72583 = cljs.core.nth.call(null,inst_72581,(1),null);
var inst_72584 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_72602__$1 = (function (){var statearr_72612 = state_72602;
(statearr_72612[(7)] = inst_72579);

(statearr_72612[(11)] = inst_72582);

(statearr_72612[(13)] = inst_72576);

(statearr_72612[(14)] = inst_72578);

(statearr_72612[(12)] = inst_72583);

(statearr_72612[(15)] = inst_72577);

(statearr_72612[(16)] = inst_72580);

return statearr_72612;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72602__$1,(6),inst_72584);
} else {
if((state_val_72603 === (9))){
var inst_72596 = (state_72602[(2)]);
var inst_72597 = cljs.core.async.put_BANG_.call(null,pc,inst_72596);
var _ = (function (){var statearr_72613 = state_72602;
(statearr_72613[(4)] = cljs.core.rest.call(null,(state_72602[(4)])));

return statearr_72613;
})();
var state_72602__$1 = state_72602;
var statearr_72614_72633 = state_72602__$1;
(statearr_72614_72633[(2)] = inst_72597);

(statearr_72614_72633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72603 === (5))){
var _ = (function (){var statearr_72615 = state_72602;
(statearr_72615[(4)] = cljs.core.rest.call(null,(state_72602[(4)])));

return statearr_72615;
})();
var state_72602__$1 = state_72602;
var ex72610 = (state_72602__$1[(2)]);
var statearr_72616_72634 = state_72602__$1;
(statearr_72616_72634[(5)] = ex72610);


var statearr_72617_72635 = state_72602__$1;
(statearr_72617_72635[(1)] = (4));

(statearr_72617_72635[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72603 === (10))){
var inst_72592 = (state_72602[(2)]);
var inst_72593 = fluree.db.util.async.throw_err.call(null,inst_72592);
var state_72602__$1 = state_72602;
var statearr_72618_72636 = state_72602__$1;
(statearr_72618_72636[(2)] = inst_72593);

(statearr_72618_72636[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72603 === (8))){
var inst_72588 = (state_72602[(8)]);
var state_72602__$1 = state_72602;
var statearr_72619_72637 = state_72602__$1;
(statearr_72619_72637[(2)] = inst_72588);

(statearr_72619_72637[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_72620 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72620[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_72620[(1)] = (1));

return statearr_72620;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_72602){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_72602);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72621){var ex__2730__auto__ = e72621;
var statearr_72622_72638 = state_72602;
(statearr_72622_72638[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_72602[(4)]))){
var statearr_72623_72639 = state_72602;
(statearr_72623_72639[(1)] = cljs.core.first.call(null,(state_72602[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72640 = state_72602;
state_72602 = G__72640;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_72602){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_72602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72624 = f__2750__auto__.call(null);
(statearr_72624[(6)] = c__2749__auto___72628);

return statearr_72624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq72551){
var G__72552 = cljs.core.first.call(null,seq72551);
var seq72551__$1 = cljs.core.next.call(null,seq72551);
var G__72553 = cljs.core.first.call(null,seq72551__$1);
var seq72551__$2 = cljs.core.next.call(null,seq72551__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72552,G__72553,seq72551__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(ledger_id){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
var and__4251__auto____$1 = open_api;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
return open_api;
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
return auth;
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__72642 = arguments.length;
switch (G__72642) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72771){
var state_val_72772 = (state_72771[(1)]);
if((state_val_72772 === (7))){
var inst_72661 = (state_72771[(7)]);
var inst_72671 = (state_72771[(8)]);
var inst_72673 = fluree.db.time_travel.as_of_block.call(null,inst_72671,inst_72661);
var state_72771__$1 = state_72771;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72771__$1,(10),inst_72673);
} else {
if((state_val_72772 === (20))){
var inst_72665 = (state_72771[(9)]);
var state_72771__$1 = state_72771;
var statearr_72773_72853 = state_72771__$1;
(statearr_72773_72853[(2)] = inst_72665);

(statearr_72773_72853[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (27))){
var inst_72659 = (state_72771[(10)]);
var state_72771__$1 = state_72771;
var statearr_72774_72854 = state_72771__$1;
(statearr_72774_72854[(2)] = inst_72659);

(statearr_72774_72854[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (1))){
var state_72771__$1 = state_72771;
var statearr_72775_72855 = state_72771__$1;
(statearr_72775_72855[(2)] = null);

(statearr_72775_72855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (24))){
var inst_72668 = (state_72771[(11)]);
var state_72771__$1 = state_72771;
if(cljs.core.truth_(inst_72668)){
var statearr_72776_72856 = state_72771__$1;
(statearr_72776_72856[(1)] = (26));

} else {
var statearr_72777_72857 = state_72771__$1;
(statearr_72777_72857[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (39))){
var inst_72733 = (state_72771[(12)]);
var inst_72736 = cljs.core.ex_data.call(null,inst_72733);
var inst_72737 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72738 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_72736);
var inst_72739 = cljs.core.ex_message.call(null,inst_72733);
var inst_72740 = [inst_72738,inst_72739,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72741 = cljs.core.PersistentHashMap.fromArrays(inst_72737,inst_72740);
var state_72771__$1 = state_72771;
var statearr_72778_72858 = state_72771__$1;
(statearr_72778_72858[(2)] = inst_72741);

(statearr_72778_72858[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (46))){
var inst_72733 = (state_72771[(12)]);
var state_72771__$1 = state_72771;
var statearr_72779_72859 = state_72771__$1;
(statearr_72779_72859[(2)] = inst_72733);

(statearr_72779_72859[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (4))){
var inst_72643 = (state_72771[(2)]);
var inst_72644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72645 = [inst_72643];
var inst_72646 = (new cljs.core.PersistentVector(null,1,(5),inst_72644,inst_72645,null));
var inst_72647 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72646);
var inst_72648 = cljs.core.ex_data.call(null,inst_72643);
var inst_72649 = cljs.core.ex_message.call(null,inst_72643);
var inst_72650 = cljs.core.assoc.call(null,inst_72648,new cljs.core.Keyword(null,"message","message",-406056002),inst_72649);
var state_72771__$1 = (function (){var statearr_72780 = state_72771;
(statearr_72780[(13)] = inst_72647);

return statearr_72780;
})();
var statearr_72781_72860 = state_72771__$1;
(statearr_72781_72860[(2)] = inst_72650);

(statearr_72781_72860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (15))){
var state_72771__$1 = state_72771;
var statearr_72782_72861 = state_72771__$1;
(statearr_72782_72861[(2)] = (1000000));

(statearr_72782_72861[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (48))){
var inst_72733 = (state_72771[(12)]);
var state_72771__$1 = state_72771;
var statearr_72783_72862 = state_72771__$1;
(statearr_72783_72862[(2)] = inst_72733);

(statearr_72783_72862[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (50))){
var inst_72760 = (state_72771[(2)]);
var state_72771__$1 = state_72771;
var statearr_72784_72863 = state_72771__$1;
(statearr_72784_72863[(2)] = inst_72760);

(statearr_72784_72863[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (21))){
var inst_72664 = (state_72771[(14)]);
var state_72771__$1 = state_72771;
if(cljs.core.truth_(inst_72664)){
var statearr_72785_72864 = state_72771__$1;
(statearr_72785_72864[(1)] = (23));

} else {
var statearr_72786_72865 = state_72771__$1;
(statearr_72786_72865[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (31))){
var inst_72722 = (state_72771[(2)]);
var inst_72723 = cljs.core.not.call(null,inst_72722);
var state_72771__$1 = state_72771;
if(inst_72723){
var statearr_72787_72866 = state_72771__$1;
(statearr_72787_72866[(1)] = (35));

} else {
var statearr_72788_72867 = state_72771__$1;
(statearr_72788_72867[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (32))){
var inst_72666 = (state_72771[(15)]);
var state_72771__$1 = state_72771;
var statearr_72789_72868 = state_72771__$1;
(statearr_72789_72868[(2)] = inst_72666);

(statearr_72789_72868[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (40))){
var inst_72696 = (state_72771[(16)]);
var state_72771__$1 = state_72771;
if(cljs.core.truth_(inst_72696)){
var statearr_72790_72869 = state_72771__$1;
(statearr_72790_72869[(1)] = (42));

} else {
var statearr_72791_72870 = state_72771__$1;
(statearr_72791_72870[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (33))){
var inst_72662 = (state_72771[(17)]);
var state_72771__$1 = state_72771;
var statearr_72792_72871 = state_72771__$1;
(statearr_72792_72871[(2)] = inst_72662);

(statearr_72792_72871[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (13))){
var inst_72667 = (state_72771[(18)]);
var inst_72691 = (state_72771[(19)]);
var inst_72689 = (state_72771[(2)]);
var inst_72690 = cljs.core.volatile_BANG_.call(null,(0));
var inst_72691__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_72667);
var state_72771__$1 = (function (){var statearr_72793 = state_72771;
(statearr_72793[(19)] = inst_72691__$1);

(statearr_72793[(20)] = inst_72689);

(statearr_72793[(21)] = inst_72690);

return statearr_72793;
})();
if(cljs.core.truth_(inst_72691__$1)){
var statearr_72794_72872 = state_72771__$1;
(statearr_72794_72872[(1)] = (14));

} else {
var statearr_72795_72873 = state_72771__$1;
(statearr_72795_72873[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (22))){
var inst_72712 = (state_72771[(2)]);
var state_72771__$1 = state_72771;
var statearr_72796_72874 = state_72771__$1;
(statearr_72796_72874[(2)] = inst_72712);

(statearr_72796_72874[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (36))){
var inst_72679 = (state_72771[(22)]);
var inst_72698 = (state_72771[(23)]);
var inst_72729 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_72698);
var inst_72730 = fluree.db.query.fql.query.call(null,inst_72679,inst_72729);
var state_72771__$1 = state_72771;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72771__$1,(38),inst_72730);
} else {
if((state_val_72772 === (41))){
var inst_72764 = (state_72771[(2)]);
var state_72771__$1 = state_72771;
var statearr_72797_72875 = state_72771__$1;
(statearr_72797_72875[(2)] = inst_72764);

(statearr_72797_72875[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (43))){
var state_72771__$1 = state_72771;
var statearr_72798_72876 = state_72771__$1;
(statearr_72798_72876[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (29))){
var inst_72666 = (state_72771[(15)]);
var state_72771__$1 = state_72771;
if(cljs.core.truth_(inst_72666)){
var statearr_72800_72877 = state_72771__$1;
(statearr_72800_72877[(1)] = (32));

} else {
var statearr_72801_72878 = state_72771__$1;
(statearr_72801_72878[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (44))){
var inst_72762 = (state_72771[(2)]);
var state_72771__$1 = state_72771;
var statearr_72802_72879 = state_72771__$1;
(statearr_72802_72879[(2)] = inst_72762);

(statearr_72802_72879[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (6))){
var inst_72661 = (state_72771[(7)]);
var inst_72670 = (state_72771[(2)]);
var inst_72671 = fluree.db.util.async.throw_err.call(null,inst_72670);
var state_72771__$1 = (function (){var statearr_72803 = state_72771;
(statearr_72803[(8)] = inst_72671);

return statearr_72803;
})();
if(cljs.core.truth_(inst_72661)){
var statearr_72804_72880 = state_72771__$1;
(statearr_72804_72880[(1)] = (7));

} else {
var statearr_72805_72881 = state_72771__$1;
(statearr_72805_72881[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (28))){
var inst_72708 = (state_72771[(2)]);
var state_72771__$1 = state_72771;
var statearr_72806_72882 = state_72771__$1;
(statearr_72806_72882[(2)] = inst_72708);

(statearr_72806_72882[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (25))){
var inst_72710 = (state_72771[(2)]);
var state_72771__$1 = state_72771;
var statearr_72807_72883 = state_72771__$1;
(statearr_72807_72883[(2)] = inst_72710);

(statearr_72807_72883[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (34))){
var inst_72719 = (state_72771[(2)]);
var state_72771__$1 = state_72771;
var statearr_72808_72884 = state_72771__$1;
(statearr_72808_72884[(2)] = inst_72719);

(statearr_72808_72884[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (17))){
var inst_72660 = (state_72771[(24)]);
var state_72771__$1 = state_72771;
var statearr_72809_72885 = state_72771__$1;
(statearr_72809_72885[(2)] = inst_72660);

(statearr_72809_72885[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (3))){
var inst_72769 = (state_72771[(2)]);
var state_72771__$1 = state_72771;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72771__$1,inst_72769);
} else {
if((state_val_72772 === (12))){
var inst_72687 = cljs.core.PersistentHashMap.EMPTY;
var state_72771__$1 = state_72771;
var statearr_72810_72886 = state_72771__$1;
(statearr_72810_72886[(2)] = inst_72687);

(statearr_72810_72886[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (2))){
var _ = (function (){var statearr_72811 = state_72771;
(statearr_72811[(4)] = cljs.core.cons.call(null,(5),(state_72771[(4)])));

return statearr_72811;
})();
var inst_72657 = query_map;
var inst_72658 = cljs.core.__destructure_map.call(null,inst_72657);
var inst_72659 = cljs.core.get.call(null,inst_72658,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_72660 = cljs.core.get.call(null,inst_72658,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_72661 = cljs.core.get.call(null,inst_72658,new cljs.core.Keyword(null,"block","block",664686210));
var inst_72662 = cljs.core.get.call(null,inst_72658,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_72663 = cljs.core.get.call(null,inst_72658,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_72664 = cljs.core.get.call(null,inst_72658,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_72665 = cljs.core.get.call(null,inst_72658,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_72666 = cljs.core.get.call(null,inst_72658,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_72667 = cljs.core.get.call(null,inst_72658,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_72668 = cljs.core.get.call(null,inst_72658,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_72771__$1 = (function (){var statearr_72812 = state_72771;
(statearr_72812[(25)] = inst_72663);

(statearr_72812[(24)] = inst_72660);

(statearr_72812[(15)] = inst_72666);

(statearr_72812[(10)] = inst_72659);

(statearr_72812[(14)] = inst_72664);

(statearr_72812[(17)] = inst_72662);

(statearr_72812[(18)] = inst_72667);

(statearr_72812[(9)] = inst_72665);

(statearr_72812[(7)] = inst_72661);

(statearr_72812[(11)] = inst_72668);

return statearr_72812;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72771__$1,(6),sources);
} else {
if((state_val_72772 === (23))){
var inst_72664 = (state_72771[(14)]);
var state_72771__$1 = state_72771;
var statearr_72813_72887 = state_72771__$1;
(statearr_72813_72887[(2)] = inst_72664);

(statearr_72813_72887[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (47))){
var inst_72697 = (state_72771[(26)]);
var inst_72744 = (state_72771[(27)]);
var inst_72679 = (state_72771[(22)]);
var inst_72690 = (state_72771[(21)]);
var inst_72750 = (state_72771[(2)]);
var inst_72751 = cljs.core.deref.call(null,inst_72690);
var inst_72752 = fluree.db.util.core.response_time_formatted.call(null,inst_72697);
var inst_72753 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_72679);
var inst_72754 = [(200),inst_72750,inst_72751,inst_72752,inst_72753];
var inst_72755 = cljs.core.PersistentHashMap.fromArrays(inst_72744,inst_72754);
var state_72771__$1 = state_72771;
var statearr_72814_72888 = state_72771__$1;
(statearr_72814_72888[(2)] = inst_72755);

(statearr_72814_72888[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (35))){
var inst_72725 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72726 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72727 = cljs.core.PersistentHashMap.fromArrays(inst_72725,inst_72726);
var state_72771__$1 = state_72771;
var statearr_72815_72889 = state_72771__$1;
(statearr_72815_72889[(2)] = inst_72727);

(statearr_72815_72889[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (19))){
var inst_72714 = (state_72771[(28)]);
var inst_72714__$1 = (state_72771[(2)]);
var state_72771__$1 = (function (){var statearr_72816 = state_72771;
(statearr_72816[(28)] = inst_72714__$1);

return statearr_72816;
})();
if(cljs.core.truth_(inst_72714__$1)){
var statearr_72817_72890 = state_72771__$1;
(statearr_72817_72890[(1)] = (29));

} else {
var statearr_72818_72891 = state_72771__$1;
(statearr_72818_72891[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (11))){
var inst_72663 = (state_72771[(25)]);
var inst_72679 = (state_72771[(22)]);
var inst_72680 = (state_72771[(29)]);
var inst_72682 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_72679);
var inst_72683 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_72680);
var inst_72684 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_72679);
var inst_72685 = fluree.db.api_js.get_sources.call(null,inst_72680,inst_72682,inst_72683,inst_72684,inst_72663,db_fn);
var state_72771__$1 = state_72771;
var statearr_72820_72892 = state_72771__$1;
(statearr_72820_72892[(2)] = inst_72685);

(statearr_72820_72892[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (9))){
var inst_72663 = (state_72771[(25)]);
var inst_72679 = (state_72771[(22)]);
var inst_72679__$1 = (state_72771[(2)]);
var inst_72680 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_72679__$1);
var state_72771__$1 = (function (){var statearr_72821 = state_72771;
(statearr_72821[(22)] = inst_72679__$1);

(statearr_72821[(29)] = inst_72680);

return statearr_72821;
})();
if(cljs.core.truth_(inst_72663)){
var statearr_72822_72893 = state_72771__$1;
(statearr_72822_72893[(1)] = (11));

} else {
var statearr_72823_72894 = state_72771__$1;
(statearr_72823_72894[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (5))){
var _ = (function (){var statearr_72824 = state_72771;
(statearr_72824[(4)] = cljs.core.rest.call(null,(state_72771[(4)])));

return statearr_72824;
})();
var state_72771__$1 = state_72771;
var ex72819 = (state_72771__$1[(2)]);
var statearr_72825_72895 = state_72771__$1;
(statearr_72825_72895[(5)] = ex72819);


var statearr_72826_72896 = state_72771__$1;
(statearr_72826_72896[(1)] = (4));

(statearr_72826_72896[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (14))){
var inst_72691 = (state_72771[(19)]);
var state_72771__$1 = state_72771;
var statearr_72827_72897 = state_72771__$1;
(statearr_72827_72897[(2)] = inst_72691);

(statearr_72827_72897[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (45))){
var inst_72733 = (state_72771[(12)]);
var inst_72747 = cljs.core.doall.call(null,inst_72733);
var state_72771__$1 = state_72771;
var statearr_72828_72898 = state_72771__$1;
(statearr_72828_72898[(2)] = inst_72747);

(statearr_72828_72898[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (26))){
var inst_72668 = (state_72771[(11)]);
var state_72771__$1 = state_72771;
var statearr_72829_72899 = state_72771__$1;
(statearr_72829_72899[(2)] = inst_72668);

(statearr_72829_72899[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (16))){
var inst_72660 = (state_72771[(24)]);
var inst_72667 = (state_72771[(18)]);
var inst_72689 = (state_72771[(20)]);
var inst_72690 = (state_72771[(21)]);
var inst_72695 = (state_72771[(2)]);
var inst_72696 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_72667);
var inst_72697 = fluree.db.util.core.current_time_millis.call(null);
var inst_72698 = cljs.core.assoc.call(null,inst_72667,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_72689,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_72695,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_72690);
var state_72771__$1 = (function (){var statearr_72830 = state_72771;
(statearr_72830[(26)] = inst_72697);

(statearr_72830[(16)] = inst_72696);

(statearr_72830[(23)] = inst_72698);

return statearr_72830;
})();
if(cljs.core.truth_(inst_72660)){
var statearr_72831_72900 = state_72771__$1;
(statearr_72831_72900[(1)] = (17));

} else {
var statearr_72832_72901 = state_72771__$1;
(statearr_72832_72901[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (38))){
var inst_72733 = (state_72771[(12)]);
var inst_72732 = (state_72771[(2)]);
var inst_72733__$1 = fluree.db.util.async.throw_err.call(null,inst_72732);
var inst_72734 = (inst_72733__$1 instanceof cljs.core.ExceptionInfo);
var state_72771__$1 = (function (){var statearr_72833 = state_72771;
(statearr_72833[(12)] = inst_72733__$1);

return statearr_72833;
})();
if(cljs.core.truth_(inst_72734)){
var statearr_72834_72902 = state_72771__$1;
(statearr_72834_72902[(1)] = (39));

} else {
var statearr_72835_72903 = state_72771__$1;
(statearr_72835_72903[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (30))){
var inst_72714 = (state_72771[(28)]);
var state_72771__$1 = state_72771;
var statearr_72836_72904 = state_72771__$1;
(statearr_72836_72904[(2)] = inst_72714);

(statearr_72836_72904[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (10))){
var inst_72675 = (state_72771[(2)]);
var inst_72676 = fluree.db.util.async.throw_err.call(null,inst_72675);
var state_72771__$1 = state_72771;
var statearr_72837_72905 = state_72771__$1;
(statearr_72837_72905[(2)] = inst_72676);

(statearr_72837_72905[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (18))){
var inst_72665 = (state_72771[(9)]);
var state_72771__$1 = state_72771;
if(cljs.core.truth_(inst_72665)){
var statearr_72838_72906 = state_72771__$1;
(statearr_72838_72906[(1)] = (20));

} else {
var statearr_72839_72907 = state_72771__$1;
(statearr_72839_72907[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (42))){
var inst_72733 = (state_72771[(12)]);
var inst_72744 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_72745 = cljs.core.sequential_QMARK_.call(null,inst_72733);
var state_72771__$1 = (function (){var statearr_72840 = state_72771;
(statearr_72840[(27)] = inst_72744);

return statearr_72840;
})();
if(inst_72745){
var statearr_72841_72908 = state_72771__$1;
(statearr_72841_72908[(1)] = (45));

} else {
var statearr_72842_72909 = state_72771__$1;
(statearr_72842_72909[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (37))){
var inst_72766 = (state_72771[(2)]);
var _ = (function (){var statearr_72843 = state_72771;
(statearr_72843[(4)] = cljs.core.rest.call(null,(state_72771[(4)])));

return statearr_72843;
})();
var state_72771__$1 = state_72771;
var statearr_72844_72910 = state_72771__$1;
(statearr_72844_72910[(2)] = inst_72766);

(statearr_72844_72910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (8))){
var inst_72671 = (state_72771[(8)]);
var state_72771__$1 = state_72771;
var statearr_72845_72911 = state_72771__$1;
(statearr_72845_72911[(2)] = inst_72671);

(statearr_72845_72911[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72772 === (49))){
var state_72771__$1 = state_72771;
var statearr_72846_72912 = state_72771__$1;
(statearr_72846_72912[(2)] = null);

(statearr_72846_72912[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_72847 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72847[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_72847[(1)] = (1));

return statearr_72847;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_72771){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_72771);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72848){var ex__2730__auto__ = e72848;
var statearr_72849_72913 = state_72771;
(statearr_72849_72913[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_72771[(4)]))){
var statearr_72850_72914 = state_72771;
(statearr_72850_72914[(1)] = cljs.core.first.call(null,(state_72771[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72915 = state_72771;
state_72771 = G__72915;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_72771){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_72771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72851 = f__2750__auto__.call(null);
(statearr_72851[(6)] = c__2749__auto__);

return statearr_72851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__72916_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__72916_SHARP_);
}));

var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_72938){
var state_val_72939 = (state_72938[(1)]);
if((state_val_72939 === (1))){
var inst_72920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72921 = [resp_chan,timeout_chan];
var inst_72922 = (new cljs.core.PersistentVector(null,2,(5),inst_72920,inst_72921,null));
var state_72938__$1 = state_72938;
return cljs.core.async.ioc_alts_BANG_.call(null,state_72938__$1,(2),inst_72922);
} else {
if((state_val_72939 === (2))){
var inst_72924 = (state_72938[(2)]);
var inst_72925 = cljs.core.nth.call(null,inst_72924,(0),null);
var inst_72926 = cljs.core.nth.call(null,inst_72924,(1),null);
var inst_72927 = cljs.core._EQ_.call(null,timeout_chan,inst_72926);
var state_72938__$1 = (function (){var statearr_72940 = state_72938;
(statearr_72940[(7)] = inst_72925);

return statearr_72940;
})();
if(inst_72927){
var statearr_72941_72951 = state_72938__$1;
(statearr_72941_72951[(1)] = (3));

} else {
var statearr_72942_72952 = state_72938__$1;
(statearr_72942_72952[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72939 === (3))){
var inst_72929 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_72930 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_72931 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_72932 = [tid,(408),inst_72931];
var inst_72933 = cljs.core.PersistentHashMap.fromArrays(inst_72930,inst_72932);
var state_72938__$1 = (function (){var statearr_72943 = state_72938;
(statearr_72943[(8)] = inst_72929);

return statearr_72943;
})();
var statearr_72944_72953 = state_72938__$1;
(statearr_72944_72953[(2)] = inst_72933);

(statearr_72944_72953[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72939 === (4))){
var inst_72925 = (state_72938[(7)]);
var state_72938__$1 = state_72938;
var statearr_72945_72954 = state_72938__$1;
(statearr_72945_72954[(2)] = inst_72925);

(statearr_72945_72954[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72939 === (5))){
var inst_72936 = (state_72938[(2)]);
var state_72938__$1 = state_72938;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72938__$1,inst_72936);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0 = (function (){
var statearr_72946 = [null,null,null,null,null,null,null,null,null];
(statearr_72946[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__);

(statearr_72946[(1)] = (1));

return statearr_72946;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1 = (function (state_72938){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_72938);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e72947){var ex__2730__auto__ = e72947;
var statearr_72948_72955 = state_72938;
(statearr_72948_72955[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_72938[(4)]))){
var statearr_72949_72956 = state_72938;
(statearr_72949_72956[(1)] = cljs.core.first.call(null,(state_72938[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72957 = state_72938;
state_72938 = G__72957;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__ = function(state_72938){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1.call(this,state_72938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_72950 = f__2750__auto__.call(null);
(statearr_72950[(6)] = c__2749__auto__);

return statearr_72950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__72959 = arguments.length;
switch (G__72959) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__72960 = opts;
var map__72960__$1 = cljs.core.__destructure_map.call(null,map__72960);
var auth = cljs.core.get.call(null,map__72960__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__72960__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__72960__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__72960__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__72961 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__72961,(0),null);
var authority = cljs.core.nth.call(null,vec__72961,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e72964){var e = e72964;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__72967 = arguments.length;
switch (G__72967) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73036){
var state_val_73037 = (state_73036[(1)]);
if((state_val_73037 === (7))){
var inst_72990 = (state_73036[(7)]);
var inst_72989 = (state_73036[(8)]);
var inst_72992 = (state_73036[(9)]);
var inst_72987 = (state_73036[(10)]);
var inst_72991 = (state_73036[(11)]);
var inst_73005 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_73006 = [ledger,txn,inst_72987,inst_72989,inst_72990,inst_72991,inst_72992];
var inst_73007 = cljs.core.PersistentHashMap.fromArrays(inst_73005,inst_73006);
var inst_73008 = fluree.db.util.core.without_nils.call(null,inst_73007);
var inst_73009 = fluree.db.operations.transact_async.call(null,conn,inst_73008);
var state_73036__$1 = state_73036;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73036__$1,(13),inst_73009);
} else {
if((state_val_73037 === (20))){
var inst_73027 = (state_73036[(2)]);
var state_73036__$1 = state_73036;
var statearr_73038_73074 = state_73036__$1;
(statearr_73038_73074[(2)] = inst_73027);

(statearr_73038_73074[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (1))){
var state_73036__$1 = state_73036;
var statearr_73039_73075 = state_73036__$1;
(statearr_73039_73075[(2)] = null);

(statearr_73039_73075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (4))){
var inst_72968 = (state_73036[(2)]);
var inst_72969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72970 = [inst_72968];
var inst_72971 = (new cljs.core.PersistentVector(null,1,(5),inst_72969,inst_72970,null));
var inst_72972 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72971);
var inst_72973 = cljs.core.ex_data.call(null,inst_72968);
var inst_72974 = cljs.core.ex_message.call(null,inst_72968);
var inst_72975 = cljs.core.assoc.call(null,inst_72973,new cljs.core.Keyword(null,"message","message",-406056002),inst_72974);
var state_73036__$1 = (function (){var statearr_73040 = state_73036;
(statearr_73040[(12)] = inst_72972);

return statearr_73040;
})();
var statearr_73041_73076 = state_73036__$1;
(statearr_73041_73076[(2)] = inst_72975);

(statearr_73041_73076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (15))){
var inst_72986 = (state_73036[(13)]);
var inst_73011 = (state_73036[(14)]);
var inst_73014 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_73011,inst_72986);
var state_73036__$1 = state_73036;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73036__$1,(17),inst_73014);
} else {
if((state_val_73037 === (13))){
var inst_72985 = (state_73036[(15)]);
var inst_73011 = (state_73036[(2)]);
var state_73036__$1 = (function (){var statearr_73042 = state_73036;
(statearr_73042[(14)] = inst_73011);

return statearr_73042;
})();
if(cljs.core.truth_(inst_72985)){
var statearr_73043_73077 = state_73036__$1;
(statearr_73043_73077[(1)] = (14));

} else {
var statearr_73044_73078 = state_73036__$1;
(statearr_73044_73078[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (6))){
var inst_72985 = (state_73036[(15)]);
var inst_72984 = (state_73036[(16)]);
var inst_72994 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_72984,opts);
var inst_72995 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_72994);
var inst_72996 = fluree.db.operations.command_async.call(null,conn,inst_72994);
var state_73036__$1 = (function (){var statearr_73045 = state_73036;
(statearr_73045[(17)] = inst_72995);

(statearr_73045[(18)] = inst_72996);

return statearr_73045;
})();
if(cljs.core.truth_(inst_72985)){
var statearr_73046_73079 = state_73036__$1;
(statearr_73046_73079[(1)] = (9));

} else {
var statearr_73047_73080 = state_73036__$1;
(statearr_73047_73080[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (17))){
var inst_73016 = (state_73036[(19)]);
var inst_73016__$1 = (state_73036[(2)]);
var inst_73017 = (inst_73016__$1 instanceof cljs.core.ExceptionInfo);
var state_73036__$1 = (function (){var statearr_73048 = state_73036;
(statearr_73048[(19)] = inst_73016__$1);

return statearr_73048;
})();
if(cljs.core.truth_(inst_73017)){
var statearr_73049_73081 = state_73036__$1;
(statearr_73049_73081[(1)] = (18));

} else {
var statearr_73050_73082 = state_73036__$1;
(statearr_73050_73082[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (3))){
var inst_73034 = (state_73036[(2)]);
var state_73036__$1 = state_73036;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73036__$1,inst_73034);
} else {
if((state_val_73037 === (12))){
var inst_73001 = (state_73036[(2)]);
var state_73036__$1 = state_73036;
var statearr_73051_73083 = state_73036__$1;
(statearr_73051_73083[(2)] = inst_73001);

(statearr_73051_73083[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (2))){
var inst_72984 = (state_73036[(16)]);
var _ = (function (){var statearr_73052 = state_73036;
(statearr_73052[(4)] = cljs.core.cons.call(null,(5),(state_73036[(4)])));

return statearr_73052;
})();
var inst_72982 = opts;
var inst_72983 = cljs.core.__destructure_map.call(null,inst_72982);
var inst_72984__$1 = cljs.core.get.call(null,inst_72983,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_72985 = cljs.core.get.call(null,inst_72983,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_72986 = cljs.core.get.call(null,inst_72983,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_72987 = cljs.core.get.call(null,inst_72983,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_72988 = fluree.db.util.core.current_time_millis.call(null);
var inst_72989 = cljs.core.get.call(null,inst_72983,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_72988);
var inst_72990 = cljs.core.get.call(null,inst_72983,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_72991 = cljs.core.get.call(null,inst_72983,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_72992 = cljs.core.get.call(null,inst_72983,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_73036__$1 = (function (){var statearr_73053 = state_73036;
(statearr_73053[(7)] = inst_72990);

(statearr_73053[(8)] = inst_72989);

(statearr_73053[(15)] = inst_72985);

(statearr_73053[(9)] = inst_72992);

(statearr_73053[(13)] = inst_72986);

(statearr_73053[(16)] = inst_72984__$1);

(statearr_73053[(10)] = inst_72987);

(statearr_73053[(11)] = inst_72991);

return statearr_73053;
})();
if(cljs.core.truth_(inst_72984__$1)){
var statearr_73054_73084 = state_73036__$1;
(statearr_73054_73084[(1)] = (6));

} else {
var statearr_73055_73085 = state_73036__$1;
(statearr_73055_73085[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (19))){
var inst_73016 = (state_73036[(19)]);
var state_73036__$1 = state_73036;
var statearr_73056_73086 = state_73036__$1;
(statearr_73056_73086[(2)] = inst_73016);

(statearr_73056_73086[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (11))){
var inst_73003 = (state_73036[(2)]);
var state_73036__$1 = state_73036;
var statearr_73058_73087 = state_73036__$1;
(statearr_73058_73087[(2)] = inst_73003);

(statearr_73058_73087[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (9))){
var inst_72996 = (state_73036[(18)]);
var state_73036__$1 = state_73036;
var statearr_73059_73088 = state_73036__$1;
(statearr_73059_73088[(2)] = inst_72996);

(statearr_73059_73088[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (5))){
var _ = (function (){var statearr_73060 = state_73036;
(statearr_73060[(4)] = cljs.core.rest.call(null,(state_73036[(4)])));

return statearr_73060;
})();
var state_73036__$1 = state_73036;
var ex73057 = (state_73036__$1[(2)]);
var statearr_73061_73089 = state_73036__$1;
(statearr_73061_73089[(5)] = ex73057);


var statearr_73062_73090 = state_73036__$1;
(statearr_73062_73090[(1)] = (4));

(statearr_73062_73090[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (14))){
var inst_73011 = (state_73036[(14)]);
var state_73036__$1 = state_73036;
var statearr_73063_73091 = state_73036__$1;
(statearr_73063_73091[(2)] = inst_73011);

(statearr_73063_73091[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (16))){
var inst_73029 = (state_73036[(2)]);
var state_73036__$1 = state_73036;
var statearr_73064_73092 = state_73036__$1;
(statearr_73064_73092[(2)] = inst_73029);

(statearr_73064_73092[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (10))){
var inst_72995 = (state_73036[(17)]);
var inst_72986 = (state_73036[(13)]);
var inst_72999 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_72995,inst_72986);
var state_73036__$1 = state_73036;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73036__$1,(12),inst_72999);
} else {
if((state_val_73037 === (18))){
var inst_73016 = (state_73036[(19)]);
var inst_73019 = cljs.core.ex_data.call(null,inst_73016);
var inst_73020 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73021 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_73019);
var inst_73022 = cljs.core.ex_message.call(null,inst_73016);
var inst_73023 = [inst_73021,inst_73022,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_73024 = cljs.core.PersistentHashMap.fromArrays(inst_73020,inst_73023);
var state_73036__$1 = state_73036;
var statearr_73065_73093 = state_73036__$1;
(statearr_73065_73093[(2)] = inst_73024);

(statearr_73065_73093[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73037 === (8))){
var inst_73031 = (state_73036[(2)]);
var _ = (function (){var statearr_73066 = state_73036;
(statearr_73066[(4)] = cljs.core.rest.call(null,(state_73036[(4)])));

return statearr_73066;
})();
var state_73036__$1 = state_73036;
var statearr_73067_73094 = state_73036__$1;
(statearr_73067_73094[(2)] = inst_73031);

(statearr_73067_73094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_73068 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73068[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_73068[(1)] = (1));

return statearr_73068;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_73036){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_73036);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73069){var ex__2730__auto__ = e73069;
var statearr_73070_73095 = state_73036;
(statearr_73070_73095[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_73036[(4)]))){
var statearr_73071_73096 = state_73036;
(statearr_73071_73096[(1)] = cljs.core.first.call(null,(state_73036[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73097 = state_73036;
state_73036 = G__73097;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_73036){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_73036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73072 = f__2750__auto__.call(null);
(statearr_73072[(6)] = c__2749__auto__);

return statearr_73072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___73099 = arguments.length;
var i__4865__auto___73100 = (0);
while(true){
if((i__4865__auto___73100 < len__4864__auto___73099)){
args__4870__auto__.push((arguments[i__4865__auto___73100]));

var G__73101 = (i__4865__auto___73100 + (1));
i__4865__auto___73100 = G__73101;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq73098){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq73098));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73132){
var state_val_73133 = (state_73132[(1)]);
if((state_val_73133 === (1))){
var inst_73102 = cljs.core.first.call(null,flakes);
var inst_73103 = cljs.core.rest.call(null,flakes);
var inst_73104 = cljs.core.PersistentVector.EMPTY;
var inst_73105 = inst_73102;
var inst_73106 = inst_73103;
var inst_73107 = inst_73104;
var state_73132__$1 = (function (){var statearr_73134 = state_73132;
(statearr_73134[(7)] = inst_73105);

(statearr_73134[(8)] = inst_73106);

(statearr_73134[(9)] = inst_73107);

return statearr_73134;
})();
var statearr_73135_73148 = state_73132__$1;
(statearr_73135_73148[(2)] = null);

(statearr_73135_73148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73133 === (2))){
var inst_73105 = (state_73132[(7)]);
var inst_73109 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_73110 = cljs.core.PersistentHashMap.EMPTY;
var inst_73111 = [true,inst_73110];
var inst_73112 = cljs.core.PersistentHashMap.fromArrays(inst_73109,inst_73111);
var inst_73113 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_73112,inst_73105);
var state_73132__$1 = state_73132;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73132__$1,(4),inst_73113);
} else {
if((state_val_73133 === (3))){
var inst_73130 = (state_73132[(2)]);
var state_73132__$1 = state_73132;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73132__$1,inst_73130);
} else {
if((state_val_73133 === (4))){
var inst_73106 = (state_73132[(8)]);
var inst_73107 = (state_73132[(9)]);
var inst_73115 = (state_73132[(2)]);
var inst_73116 = fluree.db.util.async.throw_err.call(null,inst_73115);
var inst_73117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73118 = [inst_73116];
var inst_73119 = (new cljs.core.PersistentVector(null,1,(5),inst_73117,inst_73118,null));
var inst_73120 = cljs.core.concat.call(null,inst_73107,inst_73119);
var inst_73121 = cljs.core.first.call(null,inst_73106);
var state_73132__$1 = (function (){var statearr_73136 = state_73132;
(statearr_73136[(10)] = inst_73120);

return statearr_73136;
})();
if(cljs.core.truth_(inst_73121)){
var statearr_73137_73149 = state_73132__$1;
(statearr_73137_73149[(1)] = (5));

} else {
var statearr_73138_73150 = state_73132__$1;
(statearr_73138_73150[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73133 === (5))){
var inst_73106 = (state_73132[(8)]);
var inst_73120 = (state_73132[(10)]);
var inst_73123 = cljs.core.first.call(null,inst_73106);
var inst_73124 = cljs.core.rest.call(null,inst_73106);
var inst_73105 = inst_73123;
var inst_73106__$1 = inst_73124;
var inst_73107 = inst_73120;
var state_73132__$1 = (function (){var statearr_73139 = state_73132;
(statearr_73139[(7)] = inst_73105);

(statearr_73139[(8)] = inst_73106__$1);

(statearr_73139[(9)] = inst_73107);

return statearr_73139;
})();
var statearr_73140_73151 = state_73132__$1;
(statearr_73140_73151[(2)] = null);

(statearr_73140_73151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73133 === (6))){
var inst_73120 = (state_73132[(10)]);
var state_73132__$1 = state_73132;
var statearr_73141_73152 = state_73132__$1;
(statearr_73141_73152[(2)] = inst_73120);

(statearr_73141_73152[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73133 === (7))){
var inst_73128 = (state_73132[(2)]);
var state_73132__$1 = state_73132;
var statearr_73142_73153 = state_73132__$1;
(statearr_73142_73153[(2)] = inst_73128);

(statearr_73142_73153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_73143 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_73143[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__);

(statearr_73143[(1)] = (1));

return statearr_73143;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1 = (function (state_73132){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_73132);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73144){var ex__2730__auto__ = e73144;
var statearr_73145_73154 = state_73132;
(statearr_73145_73154[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_73132[(4)]))){
var statearr_73146_73155 = state_73132;
(statearr_73146_73155[(1)] = cljs.core.first.call(null,(state_73132[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73156 = state_73132;
state_73132 = G__73156;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__ = function(state_73132){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1.call(this,state_73132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73147 = f__2750__auto__.call(null);
(statearr_73147[(6)] = c__2749__auto__);

return statearr_73147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73224){
var state_val_73225 = (state_73224[(1)]);
if((state_val_73225 === (7))){
var inst_73184 = (state_73224[(2)]);
var inst_73185 = fluree.db.util.async.throw_err.call(null,inst_73184);
var state_73224__$1 = state_73224;
var statearr_73226_73252 = state_73224__$1;
(statearr_73226_73252[(2)] = inst_73185);

(statearr_73226_73252[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73225 === (1))){
var inst_73161 = cljs.core.volatile_BANG_.call(null,(0));
var inst_73162 = cljs.core.PersistentHashMap.EMPTY;
var inst_73163 = cljs.core.volatile_BANG_.call(null,inst_73162);
var inst_73164 = cljs.core.first.call(null,resp);
var inst_73165 = cljs.core.rest.call(null,resp);
var inst_73166 = cljs.core.PersistentVector.EMPTY;
var inst_73167 = inst_73161;
var inst_73168 = inst_73163;
var inst_73169 = inst_73164;
var inst_73170 = inst_73165;
var inst_73171 = inst_73166;
var state_73224__$1 = (function (){var statearr_73227 = state_73224;
(statearr_73227[(7)] = inst_73170);

(statearr_73227[(8)] = inst_73169);

(statearr_73227[(9)] = inst_73167);

(statearr_73227[(10)] = inst_73168);

(statearr_73227[(11)] = inst_73171);

return statearr_73227;
})();
var statearr_73228_73253 = state_73224__$1;
(statearr_73228_73253[(2)] = null);

(statearr_73228_73253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73225 === (4))){
var inst_73170 = (state_73224[(7)]);
var inst_73169 = (state_73224[(8)]);
var inst_73167 = (state_73224[(9)]);
var inst_73173 = (state_73224[(12)]);
var inst_73168 = (state_73224[(10)]);
var inst_73171 = (state_73224[(11)]);
var inst_73175 = (state_73224[(13)]);
var inst_73179 = (function (){var fuel = inst_73167;
var cache = inst_73168;
var curr_block = inst_73169;
var rest_blocks = inst_73170;
var acc = inst_73171;
var flakes = inst_73173;
var asserted = inst_73175;
return (function (p1__73158_SHARP_){
return p1__73158_SHARP_.s;
});
})();
var inst_73180 = cljs.core.group_by.call(null,inst_73179,inst_73175);
var inst_73181 = cljs.core.vals.call(null,inst_73180);
var inst_73182 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_73168,inst_73167,inst_73181);
var state_73224__$1 = state_73224;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73224__$1,(7),inst_73182);
} else {
if((state_val_73225 === (13))){
var inst_73212 = (state_73224[(14)]);
var state_73224__$1 = state_73224;
var statearr_73229_73254 = state_73224__$1;
(statearr_73229_73254[(2)] = inst_73212);

(statearr_73229_73254[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73225 === (6))){
var inst_73170 = (state_73224[(7)]);
var inst_73188 = (state_73224[(15)]);
var inst_73169 = (state_73224[(8)]);
var inst_73190 = (state_73224[(16)]);
var inst_73167 = (state_73224[(9)]);
var inst_73173 = (state_73224[(12)]);
var inst_73168 = (state_73224[(10)]);
var inst_73171 = (state_73224[(11)]);
var inst_73175 = (state_73224[(13)]);
var inst_73188__$1 = (state_73224[(2)]);
var inst_73189 = (function (){var fuel = inst_73167;
var cache = inst_73168;
var curr_block = inst_73169;
var rest_blocks = inst_73170;
var acc = inst_73171;
var flakes = inst_73173;
var asserted = inst_73175;
var asserted_SINGLEQUOTE_ = inst_73188__$1;
return (function (p1__73159_SHARP_){
return p1__73159_SHARP_.op === false;
});
})();
var inst_73190__$1 = cljs.core.filter.call(null,inst_73189,inst_73173);
var inst_73191 = cljs.core.empty_QMARK_.call(null,inst_73190__$1);
var inst_73192 = (!(inst_73191));
var state_73224__$1 = (function (){var statearr_73232 = state_73224;
(statearr_73232[(15)] = inst_73188__$1);

(statearr_73232[(16)] = inst_73190__$1);

return statearr_73232;
})();
if(inst_73192){
var statearr_73233_73255 = state_73224__$1;
(statearr_73233_73255[(1)] = (8));

} else {
var statearr_73234_73256 = state_73224__$1;
(statearr_73234_73256[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73225 === (3))){
var inst_73222 = (state_73224[(2)]);
var state_73224__$1 = state_73224;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73224__$1,inst_73222);
} else {
if((state_val_73225 === (12))){
var inst_73170 = (state_73224[(7)]);
var inst_73167 = (state_73224[(9)]);
var inst_73212 = (state_73224[(14)]);
var inst_73168 = (state_73224[(10)]);
var inst_73215 = cljs.core.first.call(null,inst_73170);
var inst_73216 = cljs.core.rest.call(null,inst_73170);
var tmp73230 = inst_73167;
var tmp73231 = inst_73168;
var inst_73167__$1 = tmp73230;
var inst_73168__$1 = tmp73231;
var inst_73169 = inst_73215;
var inst_73170__$1 = inst_73216;
var inst_73171 = inst_73212;
var state_73224__$1 = (function (){var statearr_73235 = state_73224;
(statearr_73235[(7)] = inst_73170__$1);

(statearr_73235[(8)] = inst_73169);

(statearr_73235[(9)] = inst_73167__$1);

(statearr_73235[(10)] = inst_73168__$1);

(statearr_73235[(11)] = inst_73171);

return statearr_73235;
})();
var statearr_73236_73257 = state_73224__$1;
(statearr_73236_73257[(2)] = null);

(statearr_73236_73257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73225 === (2))){
var inst_73170 = (state_73224[(7)]);
var inst_73169 = (state_73224[(8)]);
var inst_73167 = (state_73224[(9)]);
var inst_73173 = (state_73224[(12)]);
var inst_73168 = (state_73224[(10)]);
var inst_73171 = (state_73224[(11)]);
var inst_73175 = (state_73224[(13)]);
var inst_73173__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_73169);
var inst_73174 = (function (){var fuel = inst_73167;
var cache = inst_73168;
var curr_block = inst_73169;
var rest_blocks = inst_73170;
var acc = inst_73171;
var flakes = inst_73173__$1;
return (function (p1__73157_SHARP_){
return p1__73157_SHARP_.op;
});
})();
var inst_73175__$1 = cljs.core.filter.call(null,inst_73174,inst_73173__$1);
var inst_73176 = cljs.core.empty_QMARK_.call(null,inst_73175__$1);
var inst_73177 = (!(inst_73176));
var state_73224__$1 = (function (){var statearr_73237 = state_73224;
(statearr_73237[(12)] = inst_73173__$1);

(statearr_73237[(13)] = inst_73175__$1);

return statearr_73237;
})();
if(inst_73177){
var statearr_73238_73258 = state_73224__$1;
(statearr_73238_73258[(1)] = (4));

} else {
var statearr_73239_73259 = state_73224__$1;
(statearr_73239_73259[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73225 === (11))){
var inst_73200 = (state_73224[(2)]);
var inst_73201 = fluree.db.util.async.throw_err.call(null,inst_73200);
var state_73224__$1 = state_73224;
var statearr_73240_73260 = state_73224__$1;
(statearr_73240_73260[(2)] = inst_73201);

(statearr_73240_73260[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73225 === (9))){
var state_73224__$1 = state_73224;
var statearr_73241_73261 = state_73224__$1;
(statearr_73241_73261[(2)] = null);

(statearr_73241_73261[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73225 === (5))){
var state_73224__$1 = state_73224;
var statearr_73242_73262 = state_73224__$1;
(statearr_73242_73262[(2)] = null);

(statearr_73242_73262[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73225 === (14))){
var inst_73220 = (state_73224[(2)]);
var state_73224__$1 = state_73224;
var statearr_73243_73263 = state_73224__$1;
(statearr_73243_73263[(2)] = inst_73220);

(statearr_73243_73263[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73225 === (10))){
var inst_73170 = (state_73224[(7)]);
var inst_73188 = (state_73224[(15)]);
var inst_73169 = (state_73224[(8)]);
var inst_73171 = (state_73224[(11)]);
var inst_73204 = (state_73224[(2)]);
var inst_73205 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_73206 = [inst_73188,inst_73204];
var inst_73207 = cljs.core.PersistentHashMap.fromArrays(inst_73205,inst_73206);
var inst_73208 = cljs.core.assoc.call(null,inst_73169,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_73207);
var inst_73209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73210 = [inst_73208];
var inst_73211 = (new cljs.core.PersistentVector(null,1,(5),inst_73209,inst_73210,null));
var inst_73212 = cljs.core.concat.call(null,inst_73171,inst_73211);
var inst_73213 = cljs.core.first.call(null,inst_73170);
var state_73224__$1 = (function (){var statearr_73244 = state_73224;
(statearr_73244[(14)] = inst_73212);

return statearr_73244;
})();
if(cljs.core.truth_(inst_73213)){
var statearr_73245_73264 = state_73224__$1;
(statearr_73245_73264[(1)] = (12));

} else {
var statearr_73246_73265 = state_73224__$1;
(statearr_73246_73265[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73225 === (8))){
var inst_73170 = (state_73224[(7)]);
var inst_73188 = (state_73224[(15)]);
var inst_73169 = (state_73224[(8)]);
var inst_73190 = (state_73224[(16)]);
var inst_73167 = (state_73224[(9)]);
var inst_73173 = (state_73224[(12)]);
var inst_73168 = (state_73224[(10)]);
var inst_73171 = (state_73224[(11)]);
var inst_73175 = (state_73224[(13)]);
var inst_73194 = (function (){var flakes = inst_73173;
var rest_blocks = inst_73170;
var curr_block = inst_73169;
var asserted_SINGLEQUOTE_ = inst_73188;
var acc = inst_73171;
var fuel = inst_73167;
var cache = inst_73168;
var retracted = inst_73190;
var asserted = inst_73175;
return (function (p1__73160_SHARP_){
return p1__73160_SHARP_.s;
});
})();
var inst_73195 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_73190);
var inst_73196 = cljs.core.group_by.call(null,inst_73194,inst_73195);
var inst_73197 = cljs.core.vals.call(null,inst_73196);
var inst_73198 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_73168,inst_73167,inst_73197);
var state_73224__$1 = state_73224;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73224__$1,(11),inst_73198);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_73247 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73247[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_73247[(1)] = (1));

return statearr_73247;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_73224){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_73224);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73248){var ex__2730__auto__ = e73248;
var statearr_73249_73266 = state_73224;
(statearr_73249_73266[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_73224[(4)]))){
var statearr_73250_73267 = state_73224;
(statearr_73250_73267[(1)] = cljs.core.first.call(null,(state_73224[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73268 = state_73224;
state_73224 = G__73268;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_73224){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_73224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73251 = f__2750__auto__.call(null);
(statearr_73251[(6)] = c__2749__auto__);

return statearr_73251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73368){
var state_val_73369 = (state_73368[(1)]);
if((state_val_73369 === (7))){
var inst_73333 = (state_73368[(7)]);
var inst_73340 = (state_73368[(8)]);
var inst_73339 = cljs.core.seq.call(null,inst_73333);
var inst_73340__$1 = cljs.core.first.call(null,inst_73339);
var inst_73341 = cljs.core.next.call(null,inst_73339);
var state_73368__$1 = (function (){var statearr_73370 = state_73368;
(statearr_73370[(8)] = inst_73340__$1);

(statearr_73370[(9)] = inst_73341);

return statearr_73370;
})();
if(cljs.core.truth_(inst_73340__$1)){
var statearr_73371_73408 = state_73368__$1;
(statearr_73371_73408[(1)] = (9));

} else {
var statearr_73372_73409 = state_73368__$1;
(statearr_73372_73409[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73369 === (1))){
var state_73368__$1 = state_73368;
var statearr_73373_73410 = state_73368__$1;
(statearr_73373_73410[(2)] = null);

(statearr_73373_73410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73369 === (4))){
var inst_73270 = (state_73368[(2)]);
var state_73368__$1 = state_73368;
var statearr_73374_73411 = state_73368__$1;
(statearr_73374_73411[(2)] = inst_73270);

(statearr_73374_73411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73369 === (6))){
var inst_73319 = (state_73368[(2)]);
var inst_73320 = fluree.db.util.async.throw_err.call(null,inst_73319);
var inst_73328 = resp;
var inst_73329 = cljs.core.seq.call(null,inst_73328);
var inst_73330 = cljs.core.first.call(null,inst_73329);
var inst_73331 = cljs.core.next.call(null,inst_73329);
var inst_73332 = cljs.core.PersistentHashMap.EMPTY;
var inst_73333 = inst_73328;
var inst_73334 = inst_73332;
var state_73368__$1 = (function (){var statearr_73375 = state_73368;
(statearr_73375[(7)] = inst_73333);

(statearr_73375[(10)] = inst_73330);

(statearr_73375[(11)] = inst_73334);

(statearr_73375[(12)] = inst_73331);

(statearr_73375[(13)] = inst_73320);

return statearr_73375;
})();
var statearr_73376_73412 = state_73368__$1;
(statearr_73376_73412[(2)] = null);

(statearr_73376_73412[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73369 === (3))){
var inst_73366 = (state_73368[(2)]);
var state_73368__$1 = state_73368;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73368__$1,inst_73366);
} else {
if((state_val_73369 === (2))){
var _ = (function (){var statearr_73377 = state_73368;
(statearr_73377[(4)] = cljs.core.cons.call(null,(5),(state_73368[(4)])));

return statearr_73377;
})();
var inst_73276 = (function (){return (function (p1__73269_SHARP_){
return p1__73269_SHARP_.t;
});
})();
var inst_73277 = cljs.core.map.call(null,inst_73276,resp);
var inst_73278 = cljs.core.set.call(null,inst_73277);
var inst_73315 = cljs.core.async.chan.call(null,(1));
var inst_73316 = (function (){var ts = inst_73278;
var c__2749__auto____$1 = inst_73315;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73313){
var state_val_73314 = (state_73313[(1)]);
if((state_val_73314 === (1))){
var inst_73286 = ts;
var inst_73287 = cljs.core.seq.call(null,inst_73286);
var inst_73288 = cljs.core.first.call(null,inst_73287);
var inst_73289 = cljs.core.next.call(null,inst_73287);
var inst_73290 = cljs.core.PersistentHashMap.EMPTY;
var inst_73291 = inst_73286;
var inst_73292 = inst_73290;
var state_73313__$1 = (function (){var statearr_73378 = state_73313;
(statearr_73378[(7)] = inst_73289);

(statearr_73378[(8)] = inst_73292);

(statearr_73378[(9)] = inst_73288);

(statearr_73378[(10)] = inst_73291);

return statearr_73378;
})();
var statearr_73379_73413 = state_73313__$1;
(statearr_73379_73413[(2)] = null);

(statearr_73379_73413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (2))){
var inst_73298 = (state_73313[(11)]);
var inst_73291 = (state_73313[(10)]);
var inst_73297 = cljs.core.seq.call(null,inst_73291);
var inst_73298__$1 = cljs.core.first.call(null,inst_73297);
var inst_73299 = cljs.core.next.call(null,inst_73297);
var state_73313__$1 = (function (){var statearr_73380 = state_73313;
(statearr_73380[(12)] = inst_73299);

(statearr_73380[(11)] = inst_73298__$1);

return statearr_73380;
})();
if(cljs.core.truth_(inst_73298__$1)){
var statearr_73381_73414 = state_73313__$1;
(statearr_73381_73414[(1)] = (4));

} else {
var statearr_73382_73415 = state_73313__$1;
(statearr_73382_73415[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (3))){
var inst_73311 = (state_73313[(2)]);
var state_73313__$1 = state_73313;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73313__$1,inst_73311);
} else {
if((state_val_73314 === (4))){
var inst_73298 = (state_73313[(11)]);
var inst_73301 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_73298);
var state_73313__$1 = state_73313;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73313__$1,(7),inst_73301);
} else {
if((state_val_73314 === (5))){
var inst_73292 = (state_73313[(8)]);
var state_73313__$1 = state_73313;
var statearr_73383_73416 = state_73313__$1;
(statearr_73383_73416[(2)] = inst_73292);

(statearr_73383_73416[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (6))){
var inst_73309 = (state_73313[(2)]);
var state_73313__$1 = state_73313;
var statearr_73384_73417 = state_73313__$1;
(statearr_73384_73417[(2)] = inst_73309);

(statearr_73384_73417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73314 === (7))){
var inst_73299 = (state_73313[(12)]);
var inst_73298 = (state_73313[(11)]);
var inst_73292 = (state_73313[(8)]);
var inst_73303 = (state_73313[(2)]);
var inst_73304 = fluree.db.util.async.throw_err.call(null,inst_73303);
var inst_73305 = cljs.core.assoc.call(null,inst_73292,inst_73298,inst_73304);
var inst_73291 = inst_73299;
var inst_73292__$1 = inst_73305;
var state_73313__$1 = (function (){var statearr_73385 = state_73313;
(statearr_73385[(8)] = inst_73292__$1);

(statearr_73385[(10)] = inst_73291);

return statearr_73385;
})();
var statearr_73386_73418 = state_73313__$1;
(statearr_73386_73418[(2)] = null);

(statearr_73386_73418[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_73387 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73387[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__);

(statearr_73387[(1)] = (1));

return statearr_73387;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1 = (function (state_73313){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_73313);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73388){var ex__2730__auto__ = e73388;
var statearr_73389_73419 = state_73313;
(statearr_73389_73419[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_73313[(4)]))){
var statearr_73390_73420 = state_73313;
(statearr_73390_73420[(1)] = cljs.core.first.call(null,(state_73313[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73421 = state_73313;
state_73313 = G__73421;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = function(state_73313){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1.call(this,state_73313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73391 = f__2750__auto__.call(null);
(statearr_73391[(6)] = c__2749__auto____$1);

return statearr_73391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
});
})();
var inst_73317 = cljs.core.async.impl.dispatch.run.call(null,inst_73316);
var state_73368__$1 = (function (){var statearr_73392 = state_73368;
(statearr_73392[(14)] = inst_73317);

return statearr_73392;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73368__$1,(6),inst_73315);
} else {
if((state_val_73369 === (11))){
var inst_73360 = (state_73368[(2)]);
var state_73368__$1 = state_73368;
var statearr_73394_73422 = state_73368__$1;
(statearr_73394_73422[(2)] = inst_73360);

(statearr_73394_73422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73369 === (9))){
var inst_73340 = (state_73368[(8)]);
var inst_73334 = (state_73368[(11)]);
var inst_73320 = (state_73368[(13)]);
var inst_73341 = (state_73368[(9)]);
var inst_73343 = inst_73340.t;
var inst_73344 = cljs.core.get.call(null,inst_73320,inst_73343);
var inst_73345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73346 = [inst_73344,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_73347 = (new cljs.core.PersistentVector(null,2,(5),inst_73345,inst_73346,null));
var inst_73348 = cljs.core.assoc_in.call(null,inst_73334,inst_73347,inst_73344);
var inst_73349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73350 = [inst_73344,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_73351 = (new cljs.core.PersistentVector(null,2,(5),inst_73349,inst_73350,null));
var inst_73352 = cljs.core.update_in.call(null,inst_73348,inst_73351,cljs.core.conj,inst_73340);
var inst_73353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73354 = [inst_73344,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_73355 = (new cljs.core.PersistentVector(null,2,(5),inst_73353,inst_73354,null));
var inst_73356 = cljs.core.update_in.call(null,inst_73352,inst_73355,fluree.db.api_js.min_safe,inst_73343);
var inst_73333 = inst_73341;
var inst_73334__$1 = inst_73356;
var state_73368__$1 = (function (){var statearr_73395 = state_73368;
(statearr_73395[(7)] = inst_73333);

(statearr_73395[(11)] = inst_73334__$1);

return statearr_73395;
})();
var statearr_73396_73423 = state_73368__$1;
(statearr_73396_73423[(2)] = null);

(statearr_73396_73423[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73369 === (5))){
var _ = (function (){var statearr_73397 = state_73368;
(statearr_73397[(4)] = cljs.core.rest.call(null,(state_73368[(4)])));

return statearr_73397;
})();
var state_73368__$1 = state_73368;
var ex73393 = (state_73368__$1[(2)]);
var statearr_73398_73424 = state_73368__$1;
(statearr_73398_73424[(5)] = ex73393);


if((ex73393 instanceof Error)){
var statearr_73399_73425 = state_73368__$1;
(statearr_73399_73425[(1)] = (4));

(statearr_73399_73425[(5)] = null);

} else {
throw ex73393;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73369 === (10))){
var inst_73334 = (state_73368[(11)]);
var state_73368__$1 = state_73368;
var statearr_73400_73426 = state_73368__$1;
(statearr_73400_73426[(2)] = inst_73334);

(statearr_73400_73426[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73369 === (8))){
var inst_73362 = (state_73368[(2)]);
var inst_73363 = cljs.core.vals.call(null,inst_73362);
var _ = (function (){var statearr_73401 = state_73368;
(statearr_73401[(4)] = cljs.core.rest.call(null,(state_73368[(4)])));

return statearr_73401;
})();
var state_73368__$1 = state_73368;
var statearr_73402_73427 = state_73368__$1;
(statearr_73402_73427[(2)] = inst_73363);

(statearr_73402_73427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_73403 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73403[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__);

(statearr_73403[(1)] = (1));

return statearr_73403;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1 = (function (state_73368){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_73368);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73404){var ex__2730__auto__ = e73404;
var statearr_73405_73428 = state_73368;
(statearr_73405_73428[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_73368[(4)]))){
var statearr_73406_73429 = state_73368;
(statearr_73406_73429[(1)] = cljs.core.first.call(null,(state_73368[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73430 = state_73368;
state_73368 = G__73430;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = function(state_73368){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1.call(this,state_73368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73407 = f__2750__auto__.call(null);
(statearr_73407[(6)] = c__2749__auto__);

return statearr_73407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73578){
var state_val_73579 = (state_73578[(1)]);
if((state_val_73579 === (7))){
var inst_73458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73459 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73460 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73461 = [inst_73459,inst_73460];
var inst_73462 = (new cljs.core.PersistentVector(null,2,(5),inst_73458,inst_73461,null));
var state_73578__$1 = state_73578;
var statearr_73580_73651 = state_73578__$1;
(statearr_73580_73651[(2)] = inst_73462);

(statearr_73580_73651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (20))){
var inst_73488 = (state_73578[(7)]);
var state_73578__$1 = state_73578;
var statearr_73581_73652 = state_73578__$1;
(statearr_73581_73652[(2)] = inst_73488);

(statearr_73581_73652[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (27))){
var state_73578__$1 = state_73578;
var statearr_73582_73653 = state_73578__$1;
(statearr_73582_73653[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (1))){
var state_73578__$1 = state_73578;
var statearr_73584_73654 = state_73578__$1;
(statearr_73584_73654[(2)] = null);

(statearr_73584_73654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (24))){
var inst_73487 = (state_73578[(8)]);
var state_73578__$1 = state_73578;
if(cljs.core.truth_(inst_73487)){
var statearr_73585_73655 = state_73578__$1;
(statearr_73585_73655[(1)] = (26));

} else {
var statearr_73586_73656 = state_73578__$1;
(statearr_73586_73656[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (39))){
var inst_73533 = (state_73578[(9)]);
var inst_73534 = (state_73578[(10)]);
var inst_73559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73560 = [inst_73533,inst_73534];
var inst_73561 = (new cljs.core.PersistentVector(null,2,(5),inst_73559,inst_73560,null));
var state_73578__$1 = state_73578;
var statearr_73587_73657 = state_73578__$1;
(statearr_73587_73657[(2)] = inst_73561);

(statearr_73587_73657[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (4))){
var inst_73431 = (state_73578[(2)]);
var inst_73432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73433 = [inst_73431];
var inst_73434 = (new cljs.core.PersistentVector(null,1,(5),inst_73432,inst_73433,null));
var inst_73435 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73434);
var inst_73436 = cljs.core.ex_data.call(null,inst_73431);
var inst_73437 = cljs.core.ex_message.call(null,inst_73431);
var inst_73438 = cljs.core.assoc.call(null,inst_73436,new cljs.core.Keyword(null,"message","message",-406056002),inst_73437);
var state_73578__$1 = (function (){var statearr_73588 = state_73578;
(statearr_73588[(11)] = inst_73435);

return statearr_73588;
})();
var statearr_73589_73658 = state_73578__$1;
(statearr_73589_73658[(2)] = inst_73438);

(statearr_73589_73658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (15))){
var inst_73472 = (state_73578[(12)]);
var inst_73467 = (state_73578[(13)]);
var inst_73481 = (state_73578[(2)]);
var inst_73482 = [inst_73472,inst_73481];
var inst_73483 = (new cljs.core.PersistentVector(null,2,(5),inst_73467,inst_73482,null));
var state_73578__$1 = state_73578;
var statearr_73590_73659 = state_73578__$1;
(statearr_73590_73659[(2)] = inst_73483);

(statearr_73590_73659[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (21))){
var inst_73487 = (state_73578[(8)]);
var state_73578__$1 = state_73578;
var statearr_73591_73660 = state_73578__$1;
(statearr_73591_73660[(2)] = inst_73487);

(statearr_73591_73660[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (31))){
var inst_73528 = (state_73578[(2)]);
var state_73578__$1 = state_73578;
var statearr_73592_73661 = state_73578__$1;
(statearr_73592_73661[(2)] = inst_73528);

(statearr_73592_73661[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (32))){
var inst_73534 = (state_73578[(10)]);
var inst_73537 = cljs.core.pos_int_QMARK_.call(null,inst_73534);
var state_73578__$1 = state_73578;
var statearr_73593_73662 = state_73578__$1;
(statearr_73593_73662[(2)] = inst_73537);

(statearr_73593_73662[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (40))){
var inst_73489 = (state_73578[(14)]);
var inst_73565 = (state_73578[(15)]);
var inst_73563 = (state_73578[(2)]);
var inst_73564 = cljs.core.nth.call(null,inst_73563,(0),null);
var inst_73565__$1 = cljs.core.nth.call(null,inst_73563,(1),null);
var inst_73566 = (inst_73565__$1 > inst_73489);
var state_73578__$1 = (function (){var statearr_73594 = state_73578;
(statearr_73594[(15)] = inst_73565__$1);

(statearr_73594[(16)] = inst_73564);

return statearr_73594;
})();
if(cljs.core.truth_(inst_73566)){
var statearr_73595_73663 = state_73578__$1;
(statearr_73595_73663[(1)] = (41));

} else {
var statearr_73596_73664 = state_73578__$1;
(statearr_73596_73664[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (33))){
var inst_73535 = (state_73578[(17)]);
var state_73578__$1 = state_73578;
var statearr_73597_73665 = state_73578__$1;
(statearr_73597_73665[(2)] = inst_73535);

(statearr_73597_73665[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (13))){
var inst_73473 = (state_73578[(18)]);
var inst_73475 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_73473);
var state_73578__$1 = state_73578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73578__$1,(16),inst_73475);
} else {
if((state_val_73579 === (22))){
var inst_73506 = (state_73578[(2)]);
var state_73578__$1 = state_73578;
if(cljs.core.truth_(inst_73506)){
var statearr_73598_73666 = state_73578__$1;
(statearr_73598_73666[(1)] = (23));

} else {
var statearr_73599_73667 = state_73578__$1;
(statearr_73599_73667[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (36))){
var state_73578__$1 = state_73578;
var statearr_73600_73668 = state_73578__$1;
(statearr_73600_73668[(2)] = null);

(statearr_73600_73668[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (41))){
var inst_73489 = (state_73578[(14)]);
var state_73578__$1 = state_73578;
var statearr_73601_73669 = state_73578__$1;
(statearr_73601_73669[(2)] = inst_73489);

(statearr_73601_73669[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (43))){
var inst_73564 = (state_73578[(16)]);
var inst_73570 = (state_73578[(2)]);
var inst_73571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73572 = [inst_73564,inst_73570];
var inst_73573 = (new cljs.core.PersistentVector(null,2,(5),inst_73571,inst_73572,null));
var _ = (function (){var statearr_73602 = state_73578;
(statearr_73602[(4)] = cljs.core.rest.call(null,(state_73578[(4)])));

return statearr_73602;
})();
var state_73578__$1 = state_73578;
var statearr_73603_73670 = state_73578__$1;
(statearr_73603_73670[(2)] = inst_73573);

(statearr_73603_73670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (29))){
var inst_73464 = (state_73578[(19)]);
var inst_73519 = cljs.core.pr_str.call(null,inst_73464);
var inst_73520 = ["Invalid block range provided: ",inst_73519].join('');
var inst_73521 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73522 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73523 = cljs.core.PersistentHashMap.fromArrays(inst_73521,inst_73522);
var inst_73524 = cljs.core.ex_info.call(null,inst_73520,inst_73523);
var inst_73525 = (function(){throw inst_73524})();
var state_73578__$1 = state_73578;
var statearr_73604_73671 = state_73578__$1;
(statearr_73604_73671[(2)] = inst_73525);

(statearr_73604_73671[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (6))){
var inst_73456 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_73578__$1 = state_73578;
var statearr_73605_73672 = state_73578__$1;
(statearr_73605_73672[(2)] = inst_73456);

(statearr_73605_73672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (28))){
var inst_73530 = (state_73578[(2)]);
var state_73578__$1 = state_73578;
var statearr_73606_73673 = state_73578__$1;
(statearr_73606_73673[(2)] = inst_73530);

(statearr_73606_73673[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (25))){
var inst_73533 = (state_73578[(9)]);
var inst_73535 = (state_73578[(17)]);
var inst_73532 = (state_73578[(2)]);
var inst_73533__$1 = cljs.core.nth.call(null,inst_73532,(0),null);
var inst_73534 = cljs.core.nth.call(null,inst_73532,(1),null);
var inst_73535__$1 = cljs.core.pos_int_QMARK_.call(null,inst_73533__$1);
var state_73578__$1 = (function (){var statearr_73607 = state_73578;
(statearr_73607[(9)] = inst_73533__$1);

(statearr_73607[(10)] = inst_73534);

(statearr_73607[(17)] = inst_73535__$1);

return statearr_73607;
})();
if(inst_73535__$1){
var statearr_73608_73674 = state_73578__$1;
(statearr_73608_73674[(1)] = (32));

} else {
var statearr_73609_73675 = state_73578__$1;
(statearr_73609_73675[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (34))){
var inst_73540 = (state_73578[(2)]);
var inst_73541 = cljs.core.not.call(null,inst_73540);
var state_73578__$1 = state_73578;
if(inst_73541){
var statearr_73610_73676 = state_73578__$1;
(statearr_73610_73676[(1)] = (35));

} else {
var statearr_73611_73677 = state_73578__$1;
(statearr_73611_73677[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (17))){
var inst_73487 = (state_73578[(8)]);
var inst_73489 = (state_73578[(14)]);
var inst_73492 = cljs.core.pr_str.call(null,inst_73487);
var inst_73493 = cljs.core.pr_str.call(null,inst_73489);
var inst_73494 = ["Start block is out of range for this ledger. Start block provided: ",inst_73492,". Database block: ",inst_73493].join('');
var inst_73495 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73496 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73497 = cljs.core.PersistentHashMap.fromArrays(inst_73495,inst_73496);
var inst_73498 = cljs.core.ex_info.call(null,inst_73494,inst_73497);
var inst_73499 = (function(){throw inst_73498})();
var state_73578__$1 = state_73578;
var statearr_73612_73678 = state_73578__$1;
(statearr_73612_73678[(2)] = inst_73499);

(statearr_73612_73678[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (3))){
var inst_73576 = (state_73578[(2)]);
var state_73578__$1 = state_73578;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73578__$1,inst_73576);
} else {
if((state_val_73579 === (12))){
var inst_73473 = (state_73578[(18)]);
var inst_73464 = (state_73578[(19)]);
var inst_73471 = (state_73578[(2)]);
var inst_73472 = fluree.db.util.async.throw_err.call(null,inst_73471);
var inst_73473__$1 = cljs.core.second.call(null,inst_73464);
var state_73578__$1 = (function (){var statearr_73613 = state_73578;
(statearr_73613[(12)] = inst_73472);

(statearr_73613[(18)] = inst_73473__$1);

return statearr_73613;
})();
if(cljs.core.truth_(inst_73473__$1)){
var statearr_73614_73679 = state_73578__$1;
(statearr_73614_73679[(1)] = (13));

} else {
var statearr_73615_73680 = state_73578__$1;
(statearr_73615_73680[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (2))){
var _ = (function (){var statearr_73616 = state_73578;
(statearr_73616[(4)] = cljs.core.cons.call(null,(5),(state_73578[(4)])));

return statearr_73616;
})();
var inst_73453 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73454 = cljs.core.sequential_QMARK_.call(null,inst_73453);
var state_73578__$1 = state_73578;
if(inst_73454){
var statearr_73617_73681 = state_73578__$1;
(statearr_73617_73681[(1)] = (6));

} else {
var statearr_73618_73682 = state_73578__$1;
(statearr_73618_73682[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (23))){
var inst_73487 = (state_73578[(8)]);
var inst_73488 = (state_73578[(7)]);
var inst_73508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73509 = [inst_73487,inst_73488];
var inst_73510 = (new cljs.core.PersistentVector(null,2,(5),inst_73508,inst_73509,null));
var state_73578__$1 = state_73578;
var statearr_73619_73683 = state_73578__$1;
(statearr_73619_73683[(2)] = inst_73510);

(statearr_73619_73683[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (35))){
var inst_73464 = (state_73578[(19)]);
var inst_73543 = cljs.core.pr_str.call(null,inst_73464);
var inst_73544 = ["Invalid block range provided: ",inst_73543].join('');
var inst_73545 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73546 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73547 = cljs.core.PersistentHashMap.fromArrays(inst_73545,inst_73546);
var inst_73548 = cljs.core.ex_info.call(null,inst_73544,inst_73547);
var inst_73549 = (function(){throw inst_73548})();
var state_73578__$1 = state_73578;
var statearr_73620_73684 = state_73578__$1;
(statearr_73620_73684[(2)] = inst_73549);

(statearr_73620_73684[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (19))){
var inst_73487 = (state_73578[(8)]);
var inst_73502 = (state_73578[(2)]);
var state_73578__$1 = (function (){var statearr_73621 = state_73578;
(statearr_73621[(20)] = inst_73502);

return statearr_73621;
})();
if(cljs.core.truth_(inst_73487)){
var statearr_73622_73685 = state_73578__$1;
(statearr_73622_73685[(1)] = (20));

} else {
var statearr_73623_73686 = state_73578__$1;
(statearr_73623_73686[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (11))){
var inst_73487 = (state_73578[(8)]);
var inst_73489 = (state_73578[(14)]);
var inst_73486 = (state_73578[(2)]);
var inst_73487__$1 = cljs.core.nth.call(null,inst_73486,(0),null);
var inst_73488 = cljs.core.nth.call(null,inst_73486,(1),null);
var inst_73489__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_73490 = (inst_73487__$1 > inst_73489__$1);
var state_73578__$1 = (function (){var statearr_73625 = state_73578;
(statearr_73625[(8)] = inst_73487__$1);

(statearr_73625[(14)] = inst_73489__$1);

(statearr_73625[(7)] = inst_73488);

return statearr_73625;
})();
if(cljs.core.truth_(inst_73490)){
var statearr_73626_73687 = state_73578__$1;
(statearr_73626_73687[(1)] = (17));

} else {
var statearr_73627_73688 = state_73578__$1;
(statearr_73627_73688[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (9))){
var inst_73464 = (state_73578[(19)]);
var inst_73467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73468 = cljs.core.first.call(null,inst_73464);
var inst_73469 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_73468);
var state_73578__$1 = (function (){var statearr_73628 = state_73578;
(statearr_73628[(13)] = inst_73467);

return statearr_73628;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73578__$1,(12),inst_73469);
} else {
if((state_val_73579 === (5))){
var _ = (function (){var statearr_73629 = state_73578;
(statearr_73629[(4)] = cljs.core.rest.call(null,(state_73578[(4)])));

return statearr_73629;
})();
var state_73578__$1 = state_73578;
var ex73624 = (state_73578__$1[(2)]);
var statearr_73630_73689 = state_73578__$1;
(statearr_73630_73689[(5)] = ex73624);


var statearr_73631_73690 = state_73578__$1;
(statearr_73631_73690[(1)] = (4));

(statearr_73631_73690[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (14))){
var state_73578__$1 = state_73578;
var statearr_73632_73691 = state_73578__$1;
(statearr_73632_73691[(2)] = null);

(statearr_73632_73691[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (26))){
var inst_73487 = (state_73578[(8)]);
var inst_73513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73514 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_73515 = [inst_73487,inst_73514];
var inst_73516 = (new cljs.core.PersistentVector(null,2,(5),inst_73513,inst_73515,null));
var state_73578__$1 = state_73578;
var statearr_73633_73692 = state_73578__$1;
(statearr_73633_73692[(2)] = inst_73516);

(statearr_73633_73692[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (16))){
var inst_73477 = (state_73578[(2)]);
var inst_73478 = fluree.db.util.async.throw_err.call(null,inst_73477);
var state_73578__$1 = state_73578;
var statearr_73634_73693 = state_73578__$1;
(statearr_73634_73693[(2)] = inst_73478);

(statearr_73634_73693[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (38))){
var inst_73533 = (state_73578[(9)]);
var inst_73534 = (state_73578[(10)]);
var inst_73555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73556 = [inst_73534,inst_73533];
var inst_73557 = (new cljs.core.PersistentVector(null,2,(5),inst_73555,inst_73556,null));
var state_73578__$1 = state_73578;
var statearr_73635_73694 = state_73578__$1;
(statearr_73635_73694[(2)] = inst_73557);

(statearr_73635_73694[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (30))){
var state_73578__$1 = state_73578;
var statearr_73636_73695 = state_73578__$1;
(statearr_73636_73695[(2)] = null);

(statearr_73636_73695[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (10))){
var inst_73464 = (state_73578[(19)]);
var state_73578__$1 = state_73578;
var statearr_73637_73696 = state_73578__$1;
(statearr_73637_73696[(2)] = inst_73464);

(statearr_73637_73696[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (18))){
var state_73578__$1 = state_73578;
var statearr_73638_73697 = state_73578__$1;
(statearr_73638_73697[(2)] = null);

(statearr_73638_73697[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (42))){
var inst_73565 = (state_73578[(15)]);
var state_73578__$1 = state_73578;
var statearr_73639_73698 = state_73578__$1;
(statearr_73639_73698[(2)] = inst_73565);

(statearr_73639_73698[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (37))){
var inst_73533 = (state_73578[(9)]);
var inst_73534 = (state_73578[(10)]);
var inst_73552 = (state_73578[(2)]);
var inst_73553 = (inst_73534 < inst_73533);
var state_73578__$1 = (function (){var statearr_73640 = state_73578;
(statearr_73640[(21)] = inst_73552);

return statearr_73640;
})();
if(cljs.core.truth_(inst_73553)){
var statearr_73641_73699 = state_73578__$1;
(statearr_73641_73699[(1)] = (38));

} else {
var statearr_73642_73700 = state_73578__$1;
(statearr_73642_73700[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73579 === (8))){
var inst_73464 = (state_73578[(19)]);
var inst_73464__$1 = (state_73578[(2)]);
var inst_73465 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_73464__$1);
var state_73578__$1 = (function (){var statearr_73643 = state_73578;
(statearr_73643[(19)] = inst_73464__$1);

return statearr_73643;
})();
if(cljs.core.truth_(inst_73465)){
var statearr_73644_73701 = state_73578__$1;
(statearr_73644_73701[(1)] = (9));

} else {
var statearr_73645_73702 = state_73578__$1;
(statearr_73645_73702[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_73646 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73646[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__);

(statearr_73646[(1)] = (1));

return statearr_73646;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_73578){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_73578);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73647){var ex__2730__auto__ = e73647;
var statearr_73648_73703 = state_73578;
(statearr_73648_73703[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_73578[(4)]))){
var statearr_73649_73704 = state_73578;
(statearr_73649_73704[(1)] = cljs.core.first.call(null,(state_73578[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73705 = state_73578;
state_73578 = G__73705;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__ = function(state_73578){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_73578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73650 = f__2750__auto__.call(null);
(statearr_73650[(6)] = c__2749__auto__);

return statearr_73650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__73707 = arguments.length;
switch (G__73707) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73801){
var state_val_73802 = (state_73801[(1)]);
if((state_val_73802 === (7))){
var inst_73733 = (state_73801[(7)]);
var inst_73736 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_73733);
var state_73801__$1 = state_73801;
var statearr_73803_73854 = state_73801__$1;
(statearr_73803_73854[(2)] = inst_73736);

(statearr_73803_73854[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (20))){
var inst_73772 = (state_73801[(8)]);
var inst_73775 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_73772);
var state_73801__$1 = state_73801;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73801__$1,(23),inst_73775);
} else {
if((state_val_73802 === (27))){
var inst_73781 = (state_73801[(9)]);
var inst_73787 = cljs.core.doall.call(null,inst_73781);
var state_73801__$1 = state_73801;
var statearr_73804_73855 = state_73801__$1;
(statearr_73804_73855[(2)] = inst_73787);

(statearr_73804_73855[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (1))){
var state_73801__$1 = state_73801;
var statearr_73805_73856 = state_73801__$1;
(statearr_73805_73856[(2)] = null);

(statearr_73805_73856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (24))){
var inst_73781 = (state_73801[(9)]);
var inst_73784 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_73785 = cljs.core.sequential_QMARK_.call(null,inst_73781);
var state_73801__$1 = (function (){var statearr_73806 = state_73801;
(statearr_73806[(10)] = inst_73784);

return statearr_73806;
})();
if(inst_73785){
var statearr_73807_73857 = state_73801__$1;
(statearr_73807_73857[(1)] = (27));

} else {
var statearr_73808_73858 = state_73801__$1;
(statearr_73808_73858[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (4))){
var inst_73708 = (state_73801[(2)]);
var inst_73709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73710 = [inst_73708];
var inst_73711 = (new cljs.core.PersistentVector(null,1,(5),inst_73709,inst_73710,null));
var inst_73712 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73711);
var inst_73713 = cljs.core.ex_data.call(null,inst_73708);
var inst_73714 = cljs.core.ex_message.call(null,inst_73708);
var inst_73715 = cljs.core.assoc.call(null,inst_73713,new cljs.core.Keyword(null,"message","message",-406056002),inst_73714);
var state_73801__$1 = (function (){var statearr_73809 = state_73801;
(statearr_73809[(11)] = inst_73712);

return statearr_73809;
})();
var statearr_73810_73859 = state_73801__$1;
(statearr_73810_73859[(2)] = inst_73715);

(statearr_73810_73859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (15))){
var inst_73733 = (state_73801[(7)]);
var inst_73746 = (state_73801[(2)]);
var inst_73747 = cljs.core.ex_info.call(null,inst_73746,inst_73733);
var inst_73748 = (function(){throw inst_73747})();
var state_73801__$1 = state_73801;
var statearr_73811_73860 = state_73801__$1;
(statearr_73811_73860[(2)] = inst_73748);

(statearr_73811_73860[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (21))){
var inst_73772 = (state_73801[(8)]);
var state_73801__$1 = state_73801;
var statearr_73812_73861 = state_73801__$1;
(statearr_73812_73861[(2)] = inst_73772);

(statearr_73812_73861[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (13))){
var inst_73741 = (state_73801[(12)]);
var state_73801__$1 = state_73801;
var statearr_73813_73862 = state_73801__$1;
(statearr_73813_73862[(2)] = inst_73741);

(statearr_73813_73862[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (22))){
var inst_73781 = (state_73801[(2)]);
var inst_73782 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_73801__$1 = (function (){var statearr_73814 = state_73801;
(statearr_73814[(9)] = inst_73781);

return statearr_73814;
})();
if(cljs.core.truth_(inst_73782)){
var statearr_73815_73863 = state_73801__$1;
(statearr_73815_73863[(1)] = (24));

} else {
var statearr_73816_73864 = state_73801__$1;
(statearr_73816_73864[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (29))){
var inst_73784 = (state_73801[(10)]);
var inst_73725 = (state_73801[(13)]);
var inst_73790 = (state_73801[(2)]);
var inst_73791 = fluree.db.util.core.response_time_formatted.call(null,inst_73725);
var inst_73792 = [(200),inst_73790,(100),inst_73791];
var inst_73793 = cljs.core.PersistentHashMap.fromArrays(inst_73784,inst_73792);
var state_73801__$1 = state_73801;
var statearr_73817_73865 = state_73801__$1;
(statearr_73817_73865[(2)] = inst_73793);

(statearr_73817_73865[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (6))){
var inst_73734 = (state_73801[(14)]);
var inst_73733 = (state_73801[(7)]);
var inst_73732 = (state_73801[(2)]);
var inst_73733__$1 = fluree.db.util.async.throw_err.call(null,inst_73732);
var inst_73734__$1 = cljs.core.map_QMARK_.call(null,inst_73733__$1);
var state_73801__$1 = (function (){var statearr_73818 = state_73801;
(statearr_73818[(14)] = inst_73734__$1);

(statearr_73818[(7)] = inst_73733__$1);

return statearr_73818;
})();
if(inst_73734__$1){
var statearr_73819_73866 = state_73801__$1;
(statearr_73819_73866[(1)] = (7));

} else {
var statearr_73820_73867 = state_73801__$1;
(statearr_73820_73867[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (28))){
var inst_73781 = (state_73801[(9)]);
var state_73801__$1 = state_73801;
var statearr_73821_73868 = state_73801__$1;
(statearr_73821_73868[(2)] = inst_73781);

(statearr_73821_73868[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (25))){
var inst_73781 = (state_73801[(9)]);
var state_73801__$1 = state_73801;
var statearr_73822_73869 = state_73801__$1;
(statearr_73822_73869[(2)] = inst_73781);

(statearr_73822_73869[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (17))){
var inst_73764 = cljs.core.pr_str.call(null,query_map);
var inst_73765 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_73764].join('');
var inst_73766 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73767 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73768 = cljs.core.PersistentHashMap.fromArrays(inst_73766,inst_73767);
var inst_73769 = cljs.core.ex_info.call(null,inst_73765,inst_73768);
var inst_73770 = (function(){throw inst_73769})();
var state_73801__$1 = state_73801;
var statearr_73823_73870 = state_73801__$1;
(statearr_73823_73870[(2)] = inst_73770);

(statearr_73823_73870[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (3))){
var inst_73799 = (state_73801[(2)]);
var state_73801__$1 = state_73801;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73801__$1,inst_73799);
} else {
if((state_val_73802 === (12))){
var inst_73733 = (state_73801[(7)]);
var inst_73751 = (state_73801[(2)]);
var inst_73752 = cljs.core.nth.call(null,inst_73733,(0),null);
var inst_73753 = cljs.core.nth.call(null,inst_73733,(1),null);
var inst_73754 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_73755 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_73756 = cljs.core.keys.call(null,inst_73755);
var inst_73757 = cljs.core._EQ_.call(null,inst_73754,inst_73756);
var state_73801__$1 = (function (){var statearr_73824 = state_73801;
(statearr_73824[(15)] = inst_73752);

(statearr_73824[(16)] = inst_73753);

(statearr_73824[(17)] = inst_73751);

return statearr_73824;
})();
if(inst_73757){
var statearr_73825_73871 = state_73801__$1;
(statearr_73825_73871[(1)] = (16));

} else {
var statearr_73826_73872 = state_73801__$1;
(statearr_73826_73872[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (2))){
var _ = (function (){var statearr_73827 = state_73801;
(statearr_73827[(4)] = cljs.core.cons.call(null,(5),(state_73801[(4)])));

return statearr_73827;
})();
var inst_73725 = fluree.db.util.core.current_time_millis.call(null);
var inst_73726 = db;
var inst_73727 = cljs.core.__destructure_map.call(null,inst_73726);
var inst_73728 = cljs.core.get.call(null,inst_73727,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_73729 = cljs.core.get.call(null,inst_73727,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_73730 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_73801__$1 = (function (){var statearr_73828 = state_73801;
(statearr_73828[(18)] = inst_73729);

(statearr_73828[(19)] = inst_73728);

(statearr_73828[(13)] = inst_73725);

return statearr_73828;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73801__$1,(6),inst_73730);
} else {
if((state_val_73802 === (23))){
var inst_73777 = (state_73801[(2)]);
var inst_73778 = fluree.db.util.async.throw_err.call(null,inst_73777);
var state_73801__$1 = state_73801;
var statearr_73829_73873 = state_73801__$1;
(statearr_73829_73873[(2)] = inst_73778);

(statearr_73829_73873[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (19))){
var inst_73761 = (state_73801[(2)]);
var inst_73762 = fluree.db.util.async.throw_err.call(null,inst_73761);
var state_73801__$1 = state_73801;
var statearr_73830_73874 = state_73801__$1;
(statearr_73830_73874[(2)] = inst_73762);

(statearr_73830_73874[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (11))){
var state_73801__$1 = state_73801;
var statearr_73832_73875 = state_73801__$1;
(statearr_73832_73875[(2)] = null);

(statearr_73832_73875[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (9))){
var inst_73739 = (state_73801[(2)]);
var state_73801__$1 = state_73801;
if(cljs.core.truth_(inst_73739)){
var statearr_73833_73876 = state_73801__$1;
(statearr_73833_73876[(1)] = (10));

} else {
var statearr_73834_73877 = state_73801__$1;
(statearr_73834_73877[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (5))){
var _ = (function (){var statearr_73835 = state_73801;
(statearr_73835[(4)] = cljs.core.rest.call(null,(state_73801[(4)])));

return statearr_73835;
})();
var state_73801__$1 = state_73801;
var ex73831 = (state_73801__$1[(2)]);
var statearr_73836_73878 = state_73801__$1;
(statearr_73836_73878[(5)] = ex73831);


var statearr_73837_73879 = state_73801__$1;
(statearr_73837_73879[(1)] = (4));

(statearr_73837_73879[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (14))){
var inst_73729 = (state_73801[(18)]);
var inst_73728 = (state_73801[(19)]);
var inst_73744 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73728),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73729)].join('');
var state_73801__$1 = state_73801;
var statearr_73838_73880 = state_73801__$1;
(statearr_73838_73880[(2)] = inst_73744);

(statearr_73838_73880[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (26))){
var inst_73796 = (state_73801[(2)]);
var _ = (function (){var statearr_73839 = state_73801;
(statearr_73839[(4)] = cljs.core.rest.call(null,(state_73801[(4)])));

return statearr_73839;
})();
var state_73801__$1 = state_73801;
var statearr_73840_73881 = state_73801__$1;
(statearr_73840_73881[(2)] = inst_73796);

(statearr_73840_73881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (16))){
var inst_73752 = (state_73801[(15)]);
var inst_73753 = (state_73801[(16)]);
var inst_73759 = fluree.db.query.block.block_range.call(null,db,inst_73752,inst_73753,opts);
var state_73801__$1 = state_73801;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73801__$1,(19),inst_73759);
} else {
if((state_val_73802 === (10))){
var inst_73741 = (state_73801[(12)]);
var inst_73733 = (state_73801[(7)]);
var inst_73741__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_73733);
var state_73801__$1 = (function (){var statearr_73841 = state_73801;
(statearr_73841[(12)] = inst_73741__$1);

return statearr_73841;
})();
if(cljs.core.truth_(inst_73741__$1)){
var statearr_73842_73882 = state_73801__$1;
(statearr_73842_73882[(1)] = (13));

} else {
var statearr_73843_73883 = state_73801__$1;
(statearr_73843_73883[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (18))){
var inst_73772 = (state_73801[(2)]);
var inst_73773 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_73801__$1 = (function (){var statearr_73844 = state_73801;
(statearr_73844[(8)] = inst_73772);

return statearr_73844;
})();
if(cljs.core.truth_(inst_73773)){
var statearr_73845_73884 = state_73801__$1;
(statearr_73845_73884[(1)] = (20));

} else {
var statearr_73846_73885 = state_73801__$1;
(statearr_73846_73885[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73802 === (8))){
var inst_73734 = (state_73801[(14)]);
var state_73801__$1 = state_73801;
var statearr_73847_73886 = state_73801__$1;
(statearr_73847_73886[(2)] = inst_73734);

(statearr_73847_73886[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_73848 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73848[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_73848[(1)] = (1));

return statearr_73848;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_73801){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_73801);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73849){var ex__2730__auto__ = e73849;
var statearr_73850_73887 = state_73801;
(statearr_73850_73887[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_73801[(4)]))){
var statearr_73851_73888 = state_73801;
(statearr_73851_73888[(1)] = cljs.core.first.call(null,(state_73801[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73889 = state_73801;
state_73801 = G__73889;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_73801){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_73801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73852 = f__2750__auto__.call(null);
(statearr_73852[(6)] = c__2749__auto__);

return statearr_73852;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__73891 = arguments.length;
switch (G__73891) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74086){
var state_val_74087 = (state_74086[(1)]);
if((state_val_74087 === (62))){
var inst_74084 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74086__$1,inst_74084);
} else {
if((state_val_74087 === (7))){
var inst_73912 = (state_74086[(7)]);
var inst_73922 = cljs.core.not_EQ_.call(null,(1),inst_73912);
var state_74086__$1 = state_74086;
var statearr_74088_74179 = state_74086__$1;
(statearr_74088_74179[(2)] = inst_73922);

(statearr_74088_74179[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (59))){
var inst_74072 = (state_74086[(2)]);
var inst_74073 = fluree.db.util.async.throw_err.call(null,inst_74072);
var state_74086__$1 = state_74086;
var statearr_74089_74180 = state_74086__$1;
(statearr_74089_74180[(2)] = inst_74073);

(statearr_74089_74180[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (20))){
var inst_73988 = (state_74086[(8)]);
var inst_73980 = (state_74086[(9)]);
var inst_73980__$1 = (state_74086[(2)]);
var inst_73981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73982 = cljs.core.get.call(null,inst_73980__$1,(0));
var inst_73983 = cljs.core.get.call(null,inst_73980__$1,(1));
var inst_73984 = cljs.core.get.call(null,inst_73980__$1,(2));
var inst_73985 = cljs.core.get.call(null,inst_73980__$1,(3));
var inst_73986 = [inst_73982,inst_73983,inst_73984,inst_73985];
var inst_73987 = (new cljs.core.PersistentVector(null,4,(5),inst_73981,inst_73986,null));
var inst_73988__$1 = cljs.core.nth.call(null,inst_73987,(0),null);
var inst_73989 = cljs.core.nth.call(null,inst_73987,(1),null);
var inst_73990 = cljs.core.nth.call(null,inst_73987,(2),null);
var inst_73991 = cljs.core.nth.call(null,inst_73987,(3),null);
var inst_73992 = (inst_73988__$1 == null);
var inst_73993 = cljs.core.not.call(null,inst_73992);
var state_74086__$1 = (function (){var statearr_74090 = state_74086;
(statearr_74090[(8)] = inst_73988__$1);

(statearr_74090[(9)] = inst_73980__$1);

(statearr_74090[(10)] = inst_73990);

(statearr_74090[(11)] = inst_73991);

(statearr_74090[(12)] = inst_73989);

return statearr_74090;
})();
if(inst_73993){
var statearr_74091_74181 = state_74086__$1;
(statearr_74091_74181[(1)] = (30));

} else {
var statearr_74092_74182 = state_74086__$1;
(statearr_74092_74182[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (58))){
var inst_73920 = (state_74086[(13)]);
var inst_74076 = (state_74086[(2)]);
var state_74086__$1 = (function (){var statearr_74093 = state_74086;
(statearr_74093[(14)] = inst_74076);

return statearr_74093;
})();
if(cljs.core.truth_(inst_73920)){
var statearr_74094_74183 = state_74086__$1;
(statearr_74094_74183[(1)] = (60));

} else {
var statearr_74095_74184 = state_74086__$1;
(statearr_74095_74184[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (60))){
var inst_74064 = (state_74086[(15)]);
var inst_74076 = (state_74086[(14)]);
var inst_74078 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_74079 = cljs.core.count.call(null,inst_74064);
var inst_74080 = [inst_74076,inst_74079,(200)];
var inst_74081 = cljs.core.PersistentHashMap.fromArrays(inst_74078,inst_74080);
var state_74086__$1 = state_74086;
var statearr_74096_74185 = state_74086__$1;
(statearr_74096_74185[(2)] = inst_74081);

(statearr_74096_74185[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (27))){
var inst_73899 = (state_74086[(16)]);
var inst_73968 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73899)].join('');
var inst_73969 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73970 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73971 = cljs.core.PersistentHashMap.fromArrays(inst_73969,inst_73970);
var inst_73972 = cljs.core.ex_info.call(null,inst_73968,inst_73971);
var inst_73973 = (function(){throw inst_73972})();
var state_74086__$1 = state_74086;
var statearr_74097_74186 = state_74086__$1;
(statearr_74097_74186[(2)] = inst_73973);

(statearr_74097_74186[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (1))){
var inst_73896 = query_map;
var inst_73897 = cljs.core.__destructure_map.call(null,inst_73896);
var inst_73898 = cljs.core.get.call(null,inst_73897,new cljs.core.Keyword(null,"block","block",664686210));
var inst_73899 = cljs.core.get.call(null,inst_73897,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_73900 = cljs.core.get.call(null,inst_73897,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_74086__$1 = (function (){var statearr_74098 = state_74086;
(statearr_74098[(16)] = inst_73899);

(statearr_74098[(17)] = inst_73898);

(statearr_74098[(18)] = inst_73900);

return statearr_74098;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74086__$1,(2),sources);
} else {
if((state_val_74087 === (24))){
var inst_73899 = (state_74086[(16)]);
var inst_73957 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73899)].join('');
var inst_73958 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73959 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73960 = cljs.core.PersistentHashMap.fromArrays(inst_73958,inst_73959);
var inst_73961 = cljs.core.ex_info.call(null,inst_73957,inst_73960);
var inst_73962 = (function(){throw inst_73961})();
var state_74086__$1 = state_74086;
var statearr_74099_74187 = state_74086__$1;
(statearr_74099_74187[(2)] = inst_73962);

(statearr_74099_74187[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (55))){
var inst_73900 = (state_74086[(18)]);
var inst_74067 = (state_74086[(2)]);
var inst_74068 = fluree.db.util.async.throw_err.call(null,inst_74067);
var state_74086__$1 = (function (){var statearr_74100 = state_74086;
(statearr_74100[(19)] = inst_74068);

return statearr_74100;
})();
if(cljs.core.truth_(inst_73900)){
var statearr_74101_74188 = state_74086__$1;
(statearr_74101_74188[(1)] = (56));

} else {
var statearr_74102_74189 = state_74086__$1;
(statearr_74102_74189[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (39))){
var inst_73988 = (state_74086[(8)]);
var inst_73990 = (state_74086[(10)]);
var inst_73991 = (state_74086[(11)]);
var inst_73989 = (state_74086[(12)]);
var inst_74012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74014 = [inst_73989,inst_73988,inst_73990,inst_73991];
var inst_74015 = (new cljs.core.PersistentVector(null,4,(5),inst_74013,inst_74014,null));
var inst_74016 = [inst_74015,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_74017 = (new cljs.core.PersistentVector(null,2,(5),inst_74012,inst_74016,null));
var state_74086__$1 = state_74086;
var statearr_74103_74190 = state_74086__$1;
(statearr_74103_74190[(2)] = inst_74017);

(statearr_74103_74190[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (46))){
var inst_74022 = (state_74086[(20)]);
var state_74086__$1 = state_74086;
var statearr_74104_74191 = state_74086__$1;
(statearr_74104_74191[(2)] = inst_74022);

(statearr_74104_74191[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (4))){
var state_74086__$1 = state_74086;
var statearr_74105_74192 = state_74086__$1;
(statearr_74105_74192[(2)] = null);

(statearr_74105_74192[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (54))){
var inst_74064 = (state_74086[(15)]);
var inst_73903 = (state_74086[(21)]);
var inst_74063 = (state_74086[(2)]);
var inst_74064__$1 = fluree.db.util.async.throw_err.call(null,inst_74063);
var inst_74065 = fluree.db.api_js.format_history_resp.call(null,inst_73903,inst_74064__$1);
var state_74086__$1 = (function (){var statearr_74106 = state_74086;
(statearr_74106[(15)] = inst_74064__$1);

return statearr_74106;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74086__$1,(55),inst_74065);
} else {
if((state_val_74087 === (15))){
var inst_73903 = (state_74086[(21)]);
var inst_73944 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_73903);
var state_74086__$1 = state_74086;
var statearr_74107_74193 = state_74086__$1;
(statearr_74107_74193[(2)] = inst_73944);

(statearr_74107_74193[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (48))){
var inst_73988 = (state_74086[(8)]);
var inst_73990 = (state_74086[(10)]);
var inst_73991 = (state_74086[(11)]);
var inst_73989 = (state_74086[(12)]);
var inst_74033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74034 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74035 = [inst_73989,inst_73990,inst_73988,inst_73991];
var inst_74036 = (new cljs.core.PersistentVector(null,4,(5),inst_74034,inst_74035,null));
var inst_74037 = [inst_74036,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_74038 = (new cljs.core.PersistentVector(null,2,(5),inst_74033,inst_74037,null));
var state_74086__$1 = state_74086;
var statearr_74108_74194 = state_74086__$1;
(statearr_74108_74194[(2)] = inst_74038);

(statearr_74108_74194[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (50))){
var inst_74051 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
var statearr_74109_74195 = state_74086__$1;
(statearr_74109_74195[(2)] = inst_74051);

(statearr_74109_74195[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (21))){
var inst_73899 = (state_74086[(16)]);
var inst_73955 = cljs.core.empty_QMARK_.call(null,inst_73899);
var state_74086__$1 = state_74086;
if(inst_73955){
var statearr_74110_74196 = state_74086__$1;
(statearr_74110_74196[(1)] = (24));

} else {
var statearr_74111_74197 = state_74086__$1;
(statearr_74111_74197[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (31))){
var inst_73988 = (state_74086[(8)]);
var inst_73999 = (state_74086[(22)]);
var inst_73999__$1 = (inst_73988 == null);
var state_74086__$1 = (function (){var statearr_74112 = state_74086;
(statearr_74112[(22)] = inst_73999__$1);

return statearr_74112;
})();
if(cljs.core.truth_(inst_73999__$1)){
var statearr_74113_74198 = state_74086__$1;
(statearr_74113_74198[(1)] = (33));

} else {
var statearr_74114_74199 = state_74086__$1;
(statearr_74114_74199[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (32))){
var inst_73936 = (state_74086[(23)]);
var inst_73903 = (state_74086[(21)]);
var inst_73946 = (state_74086[(24)]);
var inst_74055 = (state_74086[(2)]);
var inst_74056 = cljs.core.nth.call(null,inst_74055,(0),null);
var inst_74057 = cljs.core.nth.call(null,inst_74055,(1),null);
var inst_74058 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_74059 = [inst_73936,inst_73946];
var inst_74060 = cljs.core.PersistentHashMap.fromArrays(inst_74058,inst_74059);
var inst_74061 = fluree.db.query.range.time_range.call(null,inst_73903,inst_74057,cljs.core._EQ_,inst_74056,inst_74060);
var state_74086__$1 = state_74086;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74086__$1,(54),inst_74061);
} else {
if((state_val_74087 === (40))){
var inst_73988 = (state_74086[(8)]);
var inst_74019 = (state_74086[(25)]);
var inst_74019__$1 = (inst_73988 == null);
var state_74086__$1 = (function (){var statearr_74115 = state_74086;
(statearr_74115[(25)] = inst_74019__$1);

return statearr_74115;
})();
if(cljs.core.truth_(inst_74019__$1)){
var statearr_74116_74200 = state_74086__$1;
(statearr_74116_74200[(1)] = (42));

} else {
var statearr_74117_74201 = state_74086__$1;
(statearr_74117_74201[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (56))){
var inst_74068 = (state_74086[(19)]);
var inst_73903 = (state_74086[(21)]);
var inst_74070 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_73903,inst_74068);
var state_74086__$1 = state_74086;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74086__$1,(59),inst_74070);
} else {
if((state_val_74087 === (33))){
var inst_73989 = (state_74086[(12)]);
var inst_74002 = (state_74086[(26)]);
var inst_74001 = (inst_73989 == null);
var inst_74002__$1 = cljs.core.not.call(null,inst_74001);
var state_74086__$1 = (function (){var statearr_74118 = state_74086;
(statearr_74118[(26)] = inst_74002__$1);

return statearr_74118;
})();
if(inst_74002__$1){
var statearr_74119_74202 = state_74086__$1;
(statearr_74119_74202[(1)] = (36));

} else {
var statearr_74120_74203 = state_74086__$1;
(statearr_74120_74203[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (13))){
var inst_73930 = (state_74086[(2)]);
var inst_73931 = fluree.db.util.async.throw_err.call(null,inst_73930);
var inst_73932 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_73931);
var inst_73933 = (inst_73932 - (1));
var state_74086__$1 = state_74086;
var statearr_74121_74204 = state_74086__$1;
(statearr_74121_74204[(2)] = inst_73933);

(statearr_74121_74204[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (22))){
var state_74086__$1 = state_74086;
var statearr_74122_74205 = state_74086__$1;
(statearr_74122_74205[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (36))){
var inst_73990 = (state_74086[(10)]);
var inst_74004 = (inst_73990 == null);
var state_74086__$1 = state_74086;
var statearr_74124_74206 = state_74086__$1;
(statearr_74124_74206[(2)] = inst_74004);

(statearr_74124_74206[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (41))){
var inst_74053 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
var statearr_74125_74207 = state_74086__$1;
(statearr_74125_74207[(2)] = inst_74053);

(statearr_74125_74207[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (43))){
var inst_74019 = (state_74086[(25)]);
var state_74086__$1 = state_74086;
var statearr_74126_74208 = state_74086__$1;
(statearr_74126_74208[(2)] = inst_74019);

(statearr_74126_74208[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (61))){
var inst_74076 = (state_74086[(14)]);
var state_74086__$1 = state_74086;
var statearr_74127_74209 = state_74086__$1;
(statearr_74127_74209[(2)] = inst_74076);

(statearr_74127_74209[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (29))){
var inst_73976 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
var statearr_74128_74210 = state_74086__$1;
(statearr_74128_74210[(2)] = inst_73976);

(statearr_74128_74210[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (44))){
var inst_74031 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
if(cljs.core.truth_(inst_74031)){
var statearr_74129_74211 = state_74086__$1;
(statearr_74129_74211[(1)] = (48));

} else {
var statearr_74130_74212 = state_74086__$1;
(statearr_74130_74212[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (6))){
var inst_73907 = (state_74086[(2)]);
var inst_73908 = fluree.db.util.async.throw_err.call(null,inst_73907);
var state_74086__$1 = state_74086;
var statearr_74131_74213 = state_74086__$1;
(statearr_74131_74213[(2)] = inst_73908);

(statearr_74131_74213[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (28))){
var state_74086__$1 = state_74086;
var statearr_74132_74214 = state_74086__$1;
(statearr_74132_74214[(2)] = null);

(statearr_74132_74214[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (51))){
var inst_73899 = (state_74086[(16)]);
var inst_74041 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73899)].join('');
var inst_74042 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74043 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74044 = cljs.core.PersistentHashMap.fromArrays(inst_74042,inst_74043);
var inst_74045 = cljs.core.ex_info.call(null,inst_74041,inst_74044);
var inst_74046 = (function(){throw inst_74045})();
var state_74086__$1 = state_74086;
var statearr_74133_74215 = state_74086__$1;
(statearr_74133_74215[(2)] = inst_74046);

(statearr_74133_74215[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (25))){
var inst_73899 = (state_74086[(16)]);
var state_74086__$1 = state_74086;
var statearr_74134_74216 = state_74086__$1;
(statearr_74134_74216[(2)] = inst_73899);

(statearr_74134_74216[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (34))){
var inst_73999 = (state_74086[(22)]);
var state_74086__$1 = state_74086;
var statearr_74135_74217 = state_74086__$1;
(statearr_74135_74217[(2)] = inst_73999);

(statearr_74135_74217[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (17))){
var inst_73940 = (state_74086[(2)]);
var inst_73941 = fluree.db.util.async.throw_err.call(null,inst_73940);
var inst_73942 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_73941);
var state_74086__$1 = state_74086;
var statearr_74136_74218 = state_74086__$1;
(statearr_74136_74218[(2)] = inst_73942);

(statearr_74136_74218[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (3))){
var inst_73903 = (state_74086[(21)]);
var inst_73905 = fluree.db.api_js.resolve_block_range.call(null,inst_73903,query_map);
var state_74086__$1 = state_74086;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74086__$1,(6),inst_73905);
} else {
if((state_val_74087 === (12))){
var inst_73913 = (state_74086[(27)]);
var inst_73936 = (state_74086[(2)]);
var state_74086__$1 = (function (){var statearr_74137 = state_74086;
(statearr_74137[(23)] = inst_73936);

return statearr_74137;
})();
if(cljs.core.truth_(inst_73913)){
var statearr_74138_74219 = state_74086__$1;
(statearr_74138_74219[(1)] = (14));

} else {
var statearr_74139_74220 = state_74086__$1;
(statearr_74139_74220[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (2))){
var inst_73898 = (state_74086[(17)]);
var inst_73902 = (state_74086[(2)]);
var inst_73903 = fluree.db.util.async.throw_err.call(null,inst_73902);
var state_74086__$1 = (function (){var statearr_74140 = state_74086;
(statearr_74140[(21)] = inst_73903);

return statearr_74140;
})();
if(cljs.core.truth_(inst_73898)){
var statearr_74141_74221 = state_74086__$1;
(statearr_74141_74221[(1)] = (3));

} else {
var statearr_74142_74222 = state_74086__$1;
(statearr_74142_74222[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (23))){
var inst_73978 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
var statearr_74143_74223 = state_74086__$1;
(statearr_74143_74223[(2)] = inst_73978);

(statearr_74143_74223[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (47))){
var inst_74028 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
var statearr_74144_74224 = state_74086__$1;
(statearr_74144_74224[(2)] = inst_74028);

(statearr_74144_74224[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (35))){
var inst_74010 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
if(cljs.core.truth_(inst_74010)){
var statearr_74145_74225 = state_74086__$1;
(statearr_74145_74225[(1)] = (39));

} else {
var statearr_74146_74226 = state_74086__$1;
(statearr_74146_74226[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (19))){
var inst_73899 = (state_74086[(16)]);
var inst_73953 = cljs.core.sequential_QMARK_.call(null,inst_73899);
var state_74086__$1 = state_74086;
if(inst_73953){
var statearr_74147_74227 = state_74086__$1;
(statearr_74147_74227[(1)] = (21));

} else {
var statearr_74148_74228 = state_74086__$1;
(statearr_74148_74228[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (57))){
var inst_74068 = (state_74086[(19)]);
var state_74086__$1 = state_74086;
var statearr_74149_74229 = state_74086__$1;
(statearr_74149_74229[(2)] = inst_74068);

(statearr_74149_74229[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (11))){
var state_74086__$1 = state_74086;
var statearr_74150_74230 = state_74086__$1;
(statearr_74150_74230[(2)] = (-1));

(statearr_74150_74230[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (9))){
var inst_73925 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
if(cljs.core.truth_(inst_73925)){
var statearr_74151_74231 = state_74086__$1;
(statearr_74151_74231[(1)] = (10));

} else {
var statearr_74152_74232 = state_74086__$1;
(statearr_74152_74232[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (5))){
var inst_73912 = (state_74086[(7)]);
var inst_73911 = (state_74086[(2)]);
var inst_73912__$1 = cljs.core.nth.call(null,inst_73911,(0),null);
var inst_73913 = cljs.core.nth.call(null,inst_73911,(1),null);
var inst_73920 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_74086__$1 = (function (){var statearr_74153 = state_74086;
(statearr_74153[(27)] = inst_73913);

(statearr_74153[(13)] = inst_73920);

(statearr_74153[(7)] = inst_73912__$1);

return statearr_74153;
})();
if(cljs.core.truth_(inst_73912__$1)){
var statearr_74154_74233 = state_74086__$1;
(statearr_74154_74233[(1)] = (7));

} else {
var statearr_74155_74234 = state_74086__$1;
(statearr_74155_74234[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (14))){
var inst_73913 = (state_74086[(27)]);
var inst_73903 = (state_74086[(21)]);
var inst_73938 = fluree.db.time_travel.as_of_block.call(null,inst_73903,inst_73913);
var state_74086__$1 = state_74086;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74086__$1,(17),inst_73938);
} else {
if((state_val_74087 === (45))){
var inst_73990 = (state_74086[(10)]);
var inst_74024 = (inst_73990 == null);
var inst_74025 = cljs.core.not.call(null,inst_74024);
var state_74086__$1 = state_74086;
var statearr_74156_74235 = state_74086__$1;
(statearr_74156_74235[(2)] = inst_74025);

(statearr_74156_74235[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (53))){
var inst_74049 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
var statearr_74157_74236 = state_74086__$1;
(statearr_74157_74236[(2)] = inst_74049);

(statearr_74157_74236[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (26))){
var inst_73965 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
var statearr_74158_74237 = state_74086__$1;
(statearr_74158_74237[(2)] = inst_73965);

(statearr_74158_74237[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (16))){
var inst_73899 = (state_74086[(16)]);
var inst_73946 = (state_74086[(2)]);
var inst_73947 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_73899);
var state_74086__$1 = (function (){var statearr_74159 = state_74086;
(statearr_74159[(24)] = inst_73946);

return statearr_74159;
})();
if(inst_73947){
var statearr_74160_74238 = state_74086__$1;
(statearr_74160_74238[(1)] = (18));

} else {
var statearr_74161_74239 = state_74086__$1;
(statearr_74161_74239[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (38))){
var inst_74007 = (state_74086[(2)]);
var state_74086__$1 = state_74086;
var statearr_74162_74240 = state_74086__$1;
(statearr_74162_74240[(2)] = inst_74007);

(statearr_74162_74240[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (30))){
var inst_73980 = (state_74086[(9)]);
var inst_73995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73996 = [inst_73980,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_73997 = (new cljs.core.PersistentVector(null,2,(5),inst_73995,inst_73996,null));
var state_74086__$1 = state_74086;
var statearr_74163_74241 = state_74086__$1;
(statearr_74163_74241[(2)] = inst_73997);

(statearr_74163_74241[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (10))){
var inst_73903 = (state_74086[(21)]);
var inst_73912 = (state_74086[(7)]);
var inst_73927 = (inst_73912 - (1));
var inst_73928 = fluree.db.time_travel.as_of_block.call(null,inst_73903,inst_73927);
var state_74086__$1 = state_74086;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74086__$1,(13),inst_73928);
} else {
if((state_val_74087 === (18))){
var inst_73899 = (state_74086[(16)]);
var inst_73949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73950 = [inst_73899];
var inst_73951 = (new cljs.core.PersistentVector(null,1,(5),inst_73949,inst_73950,null));
var state_74086__$1 = state_74086;
var statearr_74164_74242 = state_74086__$1;
(statearr_74164_74242[(2)] = inst_73951);

(statearr_74164_74242[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (52))){
var state_74086__$1 = state_74086;
var statearr_74165_74243 = state_74086__$1;
(statearr_74165_74243[(2)] = null);

(statearr_74165_74243[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (42))){
var inst_74022 = (state_74086[(20)]);
var inst_73989 = (state_74086[(12)]);
var inst_74021 = (inst_73989 == null);
var inst_74022__$1 = cljs.core.not.call(null,inst_74021);
var state_74086__$1 = (function (){var statearr_74166 = state_74086;
(statearr_74166[(20)] = inst_74022__$1);

return statearr_74166;
})();
if(inst_74022__$1){
var statearr_74167_74244 = state_74086__$1;
(statearr_74167_74244[(1)] = (45));

} else {
var statearr_74168_74245 = state_74086__$1;
(statearr_74168_74245[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (37))){
var inst_74002 = (state_74086[(26)]);
var state_74086__$1 = state_74086;
var statearr_74169_74246 = state_74086__$1;
(statearr_74169_74246[(2)] = inst_74002);

(statearr_74169_74246[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (8))){
var inst_73912 = (state_74086[(7)]);
var state_74086__$1 = state_74086;
var statearr_74170_74247 = state_74086__$1;
(statearr_74170_74247[(2)] = inst_73912);

(statearr_74170_74247[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74087 === (49))){
var state_74086__$1 = state_74086;
var statearr_74171_74248 = state_74086__$1;
(statearr_74171_74248[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74173 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74173[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74173[(1)] = (1));

return statearr_74173;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74086){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_74086);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74174){var ex__2730__auto__ = e74174;
var statearr_74175_74249 = state_74086;
(statearr_74175_74249[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_74086[(4)]))){
var statearr_74176_74250 = state_74086;
(statearr_74176_74250[(1)] = cljs.core.first.call(null,(state_74086[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74251 = state_74086;
state_74086 = G__74251;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74086){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74177 = f__2750__auto__.call(null);
(statearr_74177[(6)] = c__2749__auto__);

return statearr_74177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__74259 = arguments.length;
switch (G__74259) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__74252_SHARP_){
return cljs.core.dissoc.call(null,p1__74252_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74348){
var state_val_74349 = (state_74348[(1)]);
if((state_val_74349 === (7))){
var inst_74302 = (state_74348[(7)]);
var inst_74299 = (state_74348[(8)]);
var inst_74305 = (state_74348[(9)]);
var inst_74309 = (state_74348[(10)]);
var inst_74315 = (function (){var responses = inst_74299;
var responses_STAR_ = inst_74302;
var statuses = inst_74305;
var fuel = inst_74309;
return (function (p1__74255_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__74255_SHARP_);
});
})();
var inst_74316 = cljs.core.some.call(null,inst_74315,inst_74305);
var state_74348__$1 = state_74348;
if(cljs.core.truth_(inst_74316)){
var statearr_74350_74398 = state_74348__$1;
(statearr_74350_74398[(1)] = (9));

} else {
var statearr_74351_74399 = state_74348__$1;
(statearr_74351_74399[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (20))){
var inst_74343 = (state_74348[(2)]);
var state_74348__$1 = state_74348;
var statearr_74352_74400 = state_74348__$1;
(statearr_74352_74400[(2)] = inst_74343);

(statearr_74352_74400[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (1))){
var inst_74294 = cljs.core.async.chan.call(null,(1));
var inst_74295 = (function (){var c__2749__auto____$1 = inst_74294;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74292){
var state_val_74293 = (state_74292[(1)]);
if((state_val_74293 === (1))){
var inst_74260 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_74261 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_74262 = cljs.core.assoc.call(null,inst_74261,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_74263 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_74264 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_74265 = cljs.core.PersistentHashMap.EMPTY;
var inst_74266 = inst_74260;
var inst_74267 = inst_74262;
var inst_74268 = inst_74263;
var inst_74269 = inst_74264;
var inst_74270 = inst_74265;
var state_74292__$1 = (function (){var statearr_74353 = state_74292;
(statearr_74353[(7)] = inst_74268);

(statearr_74353[(8)] = inst_74266);

(statearr_74353[(9)] = inst_74269);

(statearr_74353[(10)] = inst_74267);

(statearr_74353[(11)] = inst_74270);

return statearr_74353;
})();
var statearr_74354_74401 = state_74292__$1;
(statearr_74354_74401[(2)] = null);

(statearr_74354_74401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74293 === (2))){
var inst_74267 = (state_74292[(10)]);
var inst_74272 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_74267);
var inst_74273 = cljs.core.merge.call(null,opts,inst_74272);
var inst_74274 = cljs.core.assoc.call(null,inst_74267,new cljs.core.Keyword(null,"opts","opts",155075701),inst_74273);
var inst_74275 = fluree.db.api_js.query_async.call(null,db,inst_74274,db_fn);
var state_74292__$1 = state_74292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74292__$1,(4),inst_74275);
} else {
if((state_val_74293 === (3))){
var inst_74290 = (state_74292[(2)]);
var state_74292__$1 = state_74292;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74292__$1,inst_74290);
} else {
if((state_val_74293 === (4))){
var inst_74268 = (state_74292[(7)]);
var inst_74266 = (state_74292[(8)]);
var inst_74270 = (state_74292[(11)]);
var inst_74277 = (state_74292[(2)]);
var inst_74278 = cljs.core.assoc.call(null,inst_74270,inst_74266,inst_74277);
var inst_74279 = cljs.core.first.call(null,inst_74268);
var state_74292__$1 = (function (){var statearr_74355 = state_74292;
(statearr_74355[(12)] = inst_74278);

return statearr_74355;
})();
if(cljs.core.truth_(inst_74279)){
var statearr_74356_74402 = state_74292__$1;
(statearr_74356_74402[(1)] = (5));

} else {
var statearr_74357_74403 = state_74292__$1;
(statearr_74357_74403[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74293 === (5))){
var inst_74278 = (state_74292[(12)]);
var inst_74268 = (state_74292[(7)]);
var inst_74269 = (state_74292[(9)]);
var inst_74281 = cljs.core.first.call(null,inst_74268);
var inst_74282 = cljs.core.first.call(null,inst_74269);
var inst_74283 = cljs.core.rest.call(null,inst_74268);
var inst_74284 = cljs.core.rest.call(null,inst_74269);
var inst_74266 = inst_74281;
var inst_74267 = inst_74282;
var inst_74268__$1 = inst_74283;
var inst_74269__$1 = inst_74284;
var inst_74270 = inst_74278;
var state_74292__$1 = (function (){var statearr_74358 = state_74292;
(statearr_74358[(7)] = inst_74268__$1);

(statearr_74358[(8)] = inst_74266);

(statearr_74358[(9)] = inst_74269__$1);

(statearr_74358[(10)] = inst_74267);

(statearr_74358[(11)] = inst_74270);

return statearr_74358;
})();
var statearr_74359_74404 = state_74292__$1;
(statearr_74359_74404[(2)] = null);

(statearr_74359_74404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74293 === (6))){
var inst_74278 = (state_74292[(12)]);
var state_74292__$1 = state_74292;
var statearr_74360_74405 = state_74292__$1;
(statearr_74360_74405[(2)] = inst_74278);

(statearr_74360_74405[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74293 === (7))){
var inst_74288 = (state_74292[(2)]);
var state_74292__$1 = state_74292;
var statearr_74361_74406 = state_74292__$1;
(statearr_74361_74406[(2)] = inst_74288);

(statearr_74361_74406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74362 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74362[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74362[(1)] = (1));

return statearr_74362;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74292){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_74292);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74363){var ex__2730__auto__ = e74363;
var statearr_74364_74407 = state_74292;
(statearr_74364_74407[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_74292[(4)]))){
var statearr_74365_74408 = state_74292;
(statearr_74365_74408[(1)] = cljs.core.first.call(null,(state_74292[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74409 = state_74292;
state_74292 = G__74409;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74292){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74366 = f__2750__auto__.call(null);
(statearr_74366[(6)] = c__2749__auto____$1);

return statearr_74366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
});
})();
var inst_74296 = cljs.core.async.impl.dispatch.run.call(null,inst_74295);
var state_74348__$1 = (function (){var statearr_74367 = state_74348;
(statearr_74367[(11)] = inst_74296);

return statearr_74367;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74348__$1,(2),inst_74294);
} else {
if((state_val_74349 === (4))){
var inst_74299 = (state_74348[(8)]);
var state_74348__$1 = state_74348;
var statearr_74368_74410 = state_74348__$1;
(statearr_74368_74410[(2)] = inst_74299);

(statearr_74368_74410[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (15))){
var state_74348__$1 = state_74348;
var statearr_74369_74411 = state_74348__$1;
(statearr_74369_74411[(2)] = (400));

(statearr_74369_74411[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (13))){
var state_74348__$1 = state_74348;
var statearr_74370_74412 = state_74348__$1;
(statearr_74370_74412[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (6))){
var inst_74305 = (state_74348[(9)]);
var inst_74313 = cljs.core.first.call(null,inst_74305);
var state_74348__$1 = state_74348;
var statearr_74372_74413 = state_74348__$1;
(statearr_74372_74413[(2)] = inst_74313);

(statearr_74372_74413[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (17))){
var inst_74326 = (state_74348[(2)]);
var state_74348__$1 = state_74348;
var statearr_74373_74414 = state_74348__$1;
(statearr_74373_74414[(2)] = inst_74326);

(statearr_74373_74414[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (3))){
var inst_74302 = (state_74348[(7)]);
var inst_74299 = (state_74348[(8)]);
var inst_74305 = (state_74348[(9)]);
var inst_74309 = (state_74348[(10)]);
var inst_74304 = cljs.core.vals.call(null,inst_74299);
var inst_74305__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74304);
var inst_74306 = (function (){var responses = inst_74299;
var responses_STAR_ = inst_74302;
var statuses = inst_74305__$1;
return (function (p1__74253_SHARP_){
var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__74253_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
});
})();
var inst_74307 = cljs.core.vals.call(null,inst_74299);
var inst_74308 = cljs.core.map.call(null,inst_74306,inst_74307);
var inst_74309__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_74308);
var inst_74310 = (function (){var responses = inst_74299;
var responses_STAR_ = inst_74302;
var statuses = inst_74305__$1;
var fuel = inst_74309__$1;
return (function (p1__74254_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__74254_SHARP_);
});
})();
var inst_74311 = cljs.core.every_QMARK_.call(null,inst_74310,inst_74305__$1);
var state_74348__$1 = (function (){var statearr_74374 = state_74348;
(statearr_74374[(9)] = inst_74305__$1);

(statearr_74374[(10)] = inst_74309__$1);

return statearr_74374;
})();
if(inst_74311){
var statearr_74375_74415 = state_74348__$1;
(statearr_74375_74415[(1)] = (6));

} else {
var statearr_74376_74416 = state_74348__$1;
(statearr_74376_74416[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (12))){
var state_74348__$1 = state_74348;
var statearr_74377_74417 = state_74348__$1;
(statearr_74377_74417[(2)] = (500));

(statearr_74377_74417[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (2))){
var inst_74299 = (state_74348[(8)]);
var inst_74298 = (state_74348[(2)]);
var inst_74299__$1 = fluree.db.util.async.throw_err.call(null,inst_74298);
var inst_74300 = (function (){var responses = inst_74299__$1;
return (function (acc,index,response){
var resp = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_74301 = cljs.core.PersistentHashMap.EMPTY;
var inst_74302 = cljs.core.reduce_kv.call(null,inst_74300,inst_74301,inst_74299__$1);
var state_74348__$1 = (function (){var statearr_74378 = state_74348;
(statearr_74378[(7)] = inst_74302);

(statearr_74378[(8)] = inst_74299__$1);

return statearr_74378;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_74379_74418 = state_74348__$1;
(statearr_74379_74418[(1)] = (3));

} else {
var statearr_74380_74419 = state_74348__$1;
(statearr_74380_74419[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (19))){
var inst_74302 = (state_74348[(7)]);
var inst_74332 = (state_74348[(12)]);
var inst_74309 = (state_74348[(10)]);
var inst_74341 = cljs.core.assoc.call(null,inst_74302,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74332,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74309);
var state_74348__$1 = state_74348;
var statearr_74381_74420 = state_74348__$1;
(statearr_74381_74420[(2)] = inst_74341);

(statearr_74381_74420[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (11))){
var inst_74330 = (state_74348[(2)]);
var state_74348__$1 = state_74348;
var statearr_74382_74421 = state_74348__$1;
(statearr_74382_74421[(2)] = inst_74330);

(statearr_74382_74421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (9))){
var state_74348__$1 = state_74348;
var statearr_74383_74422 = state_74348__$1;
(statearr_74383_74422[(2)] = (207));

(statearr_74383_74422[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (5))){
var inst_74346 = (state_74348[(2)]);
var state_74348__$1 = state_74348;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74348__$1,inst_74346);
} else {
if((state_val_74349 === (14))){
var inst_74328 = (state_74348[(2)]);
var state_74348__$1 = state_74348;
var statearr_74384_74423 = state_74348__$1;
(statearr_74384_74423[(2)] = inst_74328);

(statearr_74384_74423[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (16))){
var state_74348__$1 = state_74348;
var statearr_74385_74424 = state_74348__$1;
(statearr_74385_74424[(2)] = null);

(statearr_74385_74424[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (10))){
var inst_74302 = (state_74348[(7)]);
var inst_74299 = (state_74348[(8)]);
var inst_74305 = (state_74348[(9)]);
var inst_74309 = (state_74348[(10)]);
var inst_74319 = (function (){var responses = inst_74299;
var responses_STAR_ = inst_74302;
var statuses = inst_74305;
var fuel = inst_74309;
return (function (p1__74256_SHARP_){
return ((499) < p1__74256_SHARP_);
});
})();
var inst_74320 = cljs.core.some.call(null,inst_74319,inst_74305);
var state_74348__$1 = state_74348;
if(cljs.core.truth_(inst_74320)){
var statearr_74386_74425 = state_74348__$1;
(statearr_74386_74425[(1)] = (12));

} else {
var statearr_74387_74426 = state_74348__$1;
(statearr_74387_74426[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (18))){
var inst_74302 = (state_74348[(7)]);
var inst_74337 = (state_74348[(13)]);
var inst_74332 = (state_74348[(12)]);
var inst_74309 = (state_74348[(10)]);
var inst_74339 = cljs.core.assoc.call(null,inst_74302,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74332,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74309,new cljs.core.Keyword(null,"block","block",664686210),inst_74337);
var state_74348__$1 = state_74348;
var statearr_74388_74427 = state_74348__$1;
(statearr_74388_74427[(2)] = inst_74339);

(statearr_74388_74427[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74349 === (8))){
var inst_74302 = (state_74348[(7)]);
var inst_74299 = (state_74348[(8)]);
var inst_74305 = (state_74348[(9)]);
var inst_74337 = (state_74348[(13)]);
var inst_74332 = (state_74348[(12)]);
var inst_74309 = (state_74348[(10)]);
var inst_74332__$1 = (state_74348[(2)]);
var inst_74333 = (function (){var responses = inst_74299;
var responses_STAR_ = inst_74302;
var statuses = inst_74305;
var fuel = inst_74309;
var status = inst_74332__$1;
return (function (p1__74257_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__74257_SHARP_));
});
})();
var inst_74334 = cljs.core.vals.call(null,inst_74299);
var inst_74335 = cljs.core.filter.call(null,inst_74333,inst_74334);
var inst_74336 = cljs.core.first.call(null,inst_74335);
var inst_74337__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_74336);
var state_74348__$1 = (function (){var statearr_74389 = state_74348;
(statearr_74389[(13)] = inst_74337__$1);

(statearr_74389[(12)] = inst_74332__$1);

return statearr_74389;
})();
if(cljs.core.truth_(inst_74337__$1)){
var statearr_74390_74428 = state_74348__$1;
(statearr_74390_74428[(1)] = (18));

} else {
var statearr_74391_74429 = state_74348__$1;
(statearr_74391_74429[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74392 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74392[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74392[(1)] = (1));

return statearr_74392;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74348){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_74348);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74393){var ex__2730__auto__ = e74393;
var statearr_74394_74430 = state_74348;
(statearr_74394_74430[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_74348[(4)]))){
var statearr_74395_74431 = state_74348;
(statearr_74395_74431[(1)] = cljs.core.first.call(null,(state_74348[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74432 = state_74348;
state_74348 = G__74432;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74348){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74396 = f__2750__auto__.call(null);
(statearr_74396[(6)] = c__2749__auto__);

return statearr_74396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__74434 = arguments.length;
switch (G__74434) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__74435 = opts;
var map__74435__$1 = cljs.core.__destructure_map.call(null,map__74435);
var auth = cljs.core.get.call(null,map__74435__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__74435__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__74435__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__74435__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__74436 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__74436,(0),null);
var authority = cljs.core.nth.call(null,vec__74436,(1),null);
var action__$1 = (function (){var or__4253__auto__ = action;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e74439){var e = e74439;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__74442 = arguments.length;
switch (G__74442) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_74476){
var state_val_74477 = (state_74476[(1)]);
if((state_val_74477 === (7))){
var state_74476__$1 = state_74476;
var statearr_74478_74499 = state_74476__$1;
(statearr_74478_74499[(2)] = opts);

(statearr_74478_74499[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74477 === (1))){
var state_74476__$1 = state_74476;
var statearr_74479_74500 = state_74476__$1;
(statearr_74479_74500[(2)] = null);

(statearr_74479_74500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74477 === (4))){
var inst_74443 = (state_74476[(2)]);
var inst_74444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74445 = [inst_74443];
var inst_74446 = (new cljs.core.PersistentVector(null,1,(5),inst_74444,inst_74445,null));
var inst_74447 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_74446);
var inst_74448 = cljs.core.ex_data.call(null,inst_74443);
var inst_74449 = cljs.core.ex_message.call(null,inst_74443);
var inst_74450 = cljs.core.assoc.call(null,inst_74448,new cljs.core.Keyword(null,"message","message",-406056002),inst_74449);
var state_74476__$1 = (function (){var statearr_74480 = state_74476;
(statearr_74480[(7)] = inst_74447);

return statearr_74480;
})();
var statearr_74481_74501 = state_74476__$1;
(statearr_74481_74501[(2)] = inst_74450);

(statearr_74481_74501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74477 === (6))){
var inst_74460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74461 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_74462 = (new cljs.core.PersistentVector(null,1,(5),inst_74460,inst_74461,null));
var inst_74463 = cljs.core.assoc_in.call(null,opts,inst_74462,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_74476__$1 = state_74476;
var statearr_74482_74502 = state_74476__$1;
(statearr_74482_74502[(2)] = inst_74463);

(statearr_74482_74502[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74477 === (3))){
var inst_74474 = (state_74476[(2)]);
var state_74476__$1 = state_74476;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74476__$1,inst_74474);
} else {
if((state_val_74477 === (2))){
var _ = (function (){var statearr_74484 = state_74476;
(statearr_74484[(4)] = cljs.core.cons.call(null,(5),(state_74476[(4)])));

return statearr_74484;
})();
var inst_74456 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_74457 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_74458 = (inst_74457 == null);
var state_74476__$1 = (function (){var statearr_74485 = state_74476;
(statearr_74485[(8)] = inst_74456);

return statearr_74485;
})();
if(cljs.core.truth_(inst_74458)){
var statearr_74486_74503 = state_74476__$1;
(statearr_74486_74503[(1)] = (6));

} else {
var statearr_74487_74504 = state_74476__$1;
(statearr_74487_74504[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74477 === (9))){
var inst_74470 = (state_74476[(2)]);
var inst_74471 = fluree.db.util.async.throw_err.call(null,inst_74470);
var _ = (function (){var statearr_74488 = state_74476;
(statearr_74488[(4)] = cljs.core.rest.call(null,(state_74476[(4)])));

return statearr_74488;
})();
var state_74476__$1 = state_74476;
var statearr_74489_74505 = state_74476__$1;
(statearr_74489_74505[(2)] = inst_74471);

(statearr_74489_74505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74477 === (5))){
var _ = (function (){var statearr_74490 = state_74476;
(statearr_74490[(4)] = cljs.core.rest.call(null,(state_74476[(4)])));

return statearr_74490;
})();
var state_74476__$1 = state_74476;
var ex74483 = (state_74476__$1[(2)]);
var statearr_74491_74506 = state_74476__$1;
(statearr_74491_74506[(5)] = ex74483);


var statearr_74492_74507 = state_74476__$1;
(statearr_74492_74507[(1)] = (4));

(statearr_74492_74507[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74477 === (8))){
var inst_74456 = (state_74476[(8)]);
var inst_74466 = (state_74476[(2)]);
var inst_74467 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_74456,inst_74466);
var inst_74468 = fluree.db.operations.command_async.call(null,conn,inst_74467);
var state_74476__$1 = state_74476;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74476__$1,(9),inst_74468);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_74493 = [null,null,null,null,null,null,null,null,null];
(statearr_74493[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_74493[(1)] = (1));

return statearr_74493;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_74476){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_74476);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e74494){var ex__2730__auto__ = e74494;
var statearr_74495_74508 = state_74476;
(statearr_74495_74508[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_74476[(4)]))){
var statearr_74496_74509 = state_74476;
(statearr_74496_74509[(1)] = cljs.core.first.call(null,(state_74476[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74510 = state_74476;
state_74476 = G__74510;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_74476){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_74476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_74497 = f__2750__auto__.call(null);
(statearr_74497[(6)] = c__2749__auto__);

return statearr_74497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

