// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__77141 = arguments.length;
switch (G__77141) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__2749__auto___77180 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77162){
var state_val_77163 = (state_77162[(1)]);
if((state_val_77163 === (1))){
var state_77162__$1 = state_77162;
var statearr_77164_77181 = state_77162__$1;
(statearr_77164_77181[(2)] = null);

(statearr_77164_77181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77163 === (2))){
var _ = (function (){var statearr_77165 = state_77162;
(statearr_77165[(4)] = cljs.core.cons.call(null,(5),(state_77162[(4)])));

return statearr_77165;
})();
var inst_77148 = fluree.db.session.db.call(null,conn,ledger,null);
var state_77162__$1 = state_77162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77162__$1,(7),inst_77148);
} else {
if((state_val_77163 === (3))){
var inst_77158 = (state_77162[(2)]);
var inst_77159 = cljs.core.async.put_BANG_.call(null,pc,inst_77158);
var inst_77160 = cljs.core.async.close_BANG_.call(null,pc);
var state_77162__$1 = (function (){var statearr_77167 = state_77162;
(statearr_77167[(7)] = inst_77159);

return statearr_77167;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77162__$1,inst_77160);
} else {
if((state_val_77163 === (4))){
var inst_77142 = (state_77162[(2)]);
var state_77162__$1 = state_77162;
var statearr_77168_77182 = state_77162__$1;
(statearr_77168_77182[(2)] = inst_77142);

(statearr_77168_77182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77163 === (5))){
var _ = (function (){var statearr_77169 = state_77162;
(statearr_77169[(4)] = cljs.core.rest.call(null,(state_77162[(4)])));

return statearr_77169;
})();
var state_77162__$1 = state_77162;
var ex77166 = (state_77162__$1[(2)]);
var statearr_77170_77183 = state_77162__$1;
(statearr_77170_77183[(5)] = ex77166);


var statearr_77171_77184 = state_77162__$1;
(statearr_77171_77184[(1)] = (4));

(statearr_77171_77184[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77163 === (6))){
var inst_77154 = (state_77162[(2)]);
var inst_77155 = fluree.db.util.async.throw_err.call(null,inst_77154);
var _ = (function (){var statearr_77172 = state_77162;
(statearr_77172[(4)] = cljs.core.rest.call(null,(state_77162[(4)])));

return statearr_77172;
})();
var state_77162__$1 = state_77162;
var statearr_77173_77185 = state_77162__$1;
(statearr_77173_77185[(2)] = inst_77155);

(statearr_77173_77185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77163 === (7))){
var inst_77150 = (state_77162[(2)]);
var inst_77151 = fluree.db.util.async.throw_err.call(null,inst_77150);
var inst_77152 = fluree.db.time_travel.as_of_block.call(null,inst_77151,block);
var state_77162__$1 = state_77162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77162__$1,(6),inst_77152);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_77174 = [null,null,null,null,null,null,null,null];
(statearr_77174[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_77174[(1)] = (1));

return statearr_77174;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_77162){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_77162);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77175){var ex__2730__auto__ = e77175;
var statearr_77176_77186 = state_77162;
(statearr_77176_77186[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_77162[(4)]))){
var statearr_77177_77187 = state_77162;
(statearr_77177_77187[(1)] = cljs.core.first.call(null,(state_77162[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77188 = state_77162;
state_77162 = G__77188;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_77162){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_77162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77178 = f__2750__auto__.call(null);
(statearr_77178[(6)] = c__2749__auto___77180);

return statearr_77178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77229){
var state_val_77230 = (state_77229[(1)]);
if((state_val_77230 === (7))){
var inst_77198 = cljs.core._EQ_.call(null,(0),auth);
var state_77229__$1 = state_77229;
if(inst_77198){
var statearr_77231_77262 = state_77229__$1;
(statearr_77231_77262[(1)] = (9));

} else {
var statearr_77232_77263 = state_77229__$1;
(statearr_77232_77263[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (1))){
var state_77229__$1 = state_77229;
var statearr_77233_77264 = state_77229__$1;
(statearr_77233_77264[(2)] = null);

(statearr_77233_77264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (4))){
var inst_77189 = (state_77229[(2)]);
var state_77229__$1 = state_77229;
var statearr_77234_77265 = state_77229__$1;
(statearr_77234_77265[(2)] = inst_77189);

(statearr_77234_77265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (15))){
var inst_77206 = (state_77229[(7)]);
var inst_77205 = (state_77229[(2)]);
var inst_77206__$1 = fluree.db.util.async.throw_err.call(null,inst_77205);
var state_77229__$1 = (function (){var statearr_77235 = state_77229;
(statearr_77235[(7)] = inst_77206__$1);

return statearr_77235;
})();
if(cljs.core.truth_(inst_77206__$1)){
var statearr_77236_77266 = state_77229__$1;
(statearr_77236_77266[(1)] = (16));

} else {
var statearr_77237_77267 = state_77229__$1;
(statearr_77237_77267[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (13))){
var state_77229__$1 = state_77229;
var statearr_77238_77268 = state_77229__$1;
(statearr_77238_77268[(2)] = null);

(statearr_77238_77268[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (6))){
var state_77229__$1 = state_77229;
var statearr_77239_77269 = state_77229__$1;
(statearr_77239_77269[(2)] = db);

(statearr_77239_77269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (17))){
var inst_77210 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_77211 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77212 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_77213 = cljs.core.PersistentHashMap.fromArrays(inst_77211,inst_77212);
var inst_77214 = cljs.core.ex_info.call(null,inst_77210,inst_77213);
var inst_77215 = (function(){throw inst_77214})();
var state_77229__$1 = state_77229;
var statearr_77240_77270 = state_77229__$1;
(statearr_77240_77270[(2)] = inst_77215);

(statearr_77240_77270[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (3))){
var inst_77227 = (state_77229[(2)]);
var state_77229__$1 = state_77229;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77229__$1,inst_77227);
} else {
if((state_val_77230 === (12))){
var inst_77203 = fluree.db.dbproto._subid.call(null,db,auth);
var state_77229__$1 = state_77229;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77229__$1,(15),inst_77203);
} else {
if((state_val_77230 === (2))){
var _ = (function (){var statearr_77241 = state_77229;
(statearr_77241[(4)] = cljs.core.cons.call(null,(5),(state_77229[(4)])));

return statearr_77241;
})();
var inst_77195 = cljs.core.not.call(null,auth);
var state_77229__$1 = state_77229;
if(inst_77195){
var statearr_77242_77271 = state_77229__$1;
(statearr_77242_77271[(1)] = (6));

} else {
var statearr_77243_77272 = state_77229__$1;
(statearr_77243_77272[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (11))){
var inst_77222 = (state_77229[(2)]);
var state_77229__$1 = state_77229;
var statearr_77245_77273 = state_77229__$1;
(statearr_77245_77273[(2)] = inst_77222);

(statearr_77245_77273[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (9))){
var inst_77200 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_77229__$1 = state_77229;
var statearr_77246_77274 = state_77229__$1;
(statearr_77246_77274[(2)] = inst_77200);

(statearr_77246_77274[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (5))){
var _ = (function (){var statearr_77247 = state_77229;
(statearr_77247[(4)] = cljs.core.rest.call(null,(state_77229[(4)])));

return statearr_77247;
})();
var state_77229__$1 = state_77229;
var ex77244 = (state_77229__$1[(2)]);
var statearr_77248_77275 = state_77229__$1;
(statearr_77248_77275[(5)] = ex77244);


if((ex77244 instanceof Error)){
var statearr_77249_77276 = state_77229__$1;
(statearr_77249_77276[(1)] = (4));

(statearr_77249_77276[(5)] = null);

} else {
throw ex77244;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (14))){
var inst_77220 = (state_77229[(2)]);
var state_77229__$1 = state_77229;
var statearr_77250_77277 = state_77229__$1;
(statearr_77250_77277[(2)] = inst_77220);

(statearr_77250_77277[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (16))){
var inst_77206 = (state_77229[(7)]);
var inst_77208 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_77206);
var state_77229__$1 = state_77229;
var statearr_77251_77278 = state_77229__$1;
(statearr_77251_77278[(2)] = inst_77208);

(statearr_77251_77278[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (10))){
var state_77229__$1 = state_77229;
var statearr_77252_77279 = state_77229__$1;
(statearr_77252_77279[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (18))){
var inst_77217 = (state_77229[(2)]);
var state_77229__$1 = state_77229;
var statearr_77254_77280 = state_77229__$1;
(statearr_77254_77280[(2)] = inst_77217);

(statearr_77254_77280[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77230 === (8))){
var inst_77224 = (state_77229[(2)]);
var _ = (function (){var statearr_77255 = state_77229;
(statearr_77255[(4)] = cljs.core.rest.call(null,(state_77229[(4)])));

return statearr_77255;
})();
var state_77229__$1 = state_77229;
var statearr_77256_77281 = state_77229__$1;
(statearr_77256_77281[(2)] = inst_77224);

(statearr_77256_77281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0 = (function (){
var statearr_77257 = [null,null,null,null,null,null,null,null];
(statearr_77257[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__);

(statearr_77257[(1)] = (1));

return statearr_77257;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1 = (function (state_77229){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_77229);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77258){var ex__2730__auto__ = e77258;
var statearr_77259_77282 = state_77229;
(statearr_77259_77282[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_77229[(4)]))){
var statearr_77260_77283 = state_77229;
(statearr_77260_77283[(1)] = cljs.core.first.call(null,(state_77229[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77284 = state_77229;
state_77229 = G__77284;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = function(state_77229){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1.call(this,state_77229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77261 = f__2750__auto__.call(null);
(statearr_77261[(6)] = c__2749__auto__);

return statearr_77261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77356){
var state_val_77357 = (state_77356[(1)]);
if((state_val_77357 === (7))){
var inst_77294 = cljs.core._EQ_.call(null,(0),auth);
var state_77356__$1 = state_77356;
if(inst_77294){
var statearr_77358_77412 = state_77356__$1;
(statearr_77358_77412[(1)] = (9));

} else {
var statearr_77359_77413 = state_77356__$1;
(statearr_77359_77413[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (20))){
var inst_77318 = (state_77356[(7)]);
var state_77356__$1 = state_77356;
if(cljs.core.truth_(inst_77318)){
var statearr_77360_77414 = state_77356__$1;
(statearr_77360_77414[(1)] = (22));

} else {
var statearr_77361_77415 = state_77356__$1;
(statearr_77361_77415[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (27))){
var state_77356__$1 = state_77356;
var statearr_77362_77416 = state_77356__$1;
(statearr_77362_77416[(2)] = null);

(statearr_77362_77416[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (1))){
var state_77356__$1 = state_77356;
var statearr_77363_77417 = state_77356__$1;
(statearr_77363_77417[(2)] = null);

(statearr_77363_77417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (24))){
var inst_77332 = (state_77356[(2)]);
var state_77356__$1 = state_77356;
var statearr_77364_77418 = state_77356__$1;
(statearr_77364_77418[(2)] = inst_77332);

(statearr_77364_77418[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (4))){
var inst_77285 = (state_77356[(2)]);
var state_77356__$1 = state_77356;
var statearr_77365_77419 = state_77356__$1;
(statearr_77365_77419[(2)] = inst_77285);

(statearr_77365_77419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (15))){
var inst_77301 = (state_77356[(8)]);
var inst_77300 = (state_77356[(2)]);
var inst_77301__$1 = fluree.db.util.async.throw_err.call(null,inst_77300);
var state_77356__$1 = (function (){var statearr_77366 = state_77356;
(statearr_77366[(8)] = inst_77301__$1);

return statearr_77366;
})();
if(cljs.core.truth_(inst_77301__$1)){
var statearr_77367_77420 = state_77356__$1;
(statearr_77367_77420[(1)] = (16));

} else {
var statearr_77368_77421 = state_77356__$1;
(statearr_77368_77421[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (21))){
var inst_77334 = (state_77356[(9)]);
var inst_77334__$1 = (state_77356[(2)]);
var state_77356__$1 = (function (){var statearr_77369 = state_77356;
(statearr_77369[(9)] = inst_77334__$1);

return statearr_77369;
})();
if(cljs.core.truth_(inst_77334__$1)){
var statearr_77370_77422 = state_77356__$1;
(statearr_77370_77422[(1)] = (29));

} else {
var statearr_77371_77423 = state_77356__$1;
(statearr_77371_77423[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (31))){
var inst_77334 = (state_77356[(9)]);
var inst_77342 = (state_77356[(2)]);
var state_77356__$1 = (function (){var statearr_77372 = state_77356;
(statearr_77372[(10)] = inst_77342);

return statearr_77372;
})();
if(cljs.core.truth_(inst_77334)){
var statearr_77373_77424 = state_77356__$1;
(statearr_77373_77424[(1)] = (33));

} else {
var statearr_77374_77425 = state_77356__$1;
(statearr_77374_77425[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (32))){
var inst_77338 = (state_77356[(2)]);
var inst_77339 = fluree.db.util.async.throw_err.call(null,inst_77338);
var state_77356__$1 = state_77356;
var statearr_77375_77426 = state_77356__$1;
(statearr_77375_77426[(2)] = inst_77339);

(statearr_77375_77426[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (33))){
var inst_77334 = (state_77356[(9)]);
var inst_77344 = fluree.db.permissions.permission_map.call(null,db,inst_77334,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_77356__$1 = state_77356;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77356__$1,(36),inst_77344);
} else {
if((state_val_77357 === (13))){
var state_77356__$1 = state_77356;
var statearr_77376_77427 = state_77356__$1;
(statearr_77376_77427[(2)] = null);

(statearr_77376_77427[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (22))){
var inst_77318 = (state_77356[(7)]);
var inst_77322 = fluree.db.auth.roles.call(null,db,inst_77318);
var state_77356__$1 = state_77356;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77356__$1,(25),inst_77322);
} else {
if((state_val_77357 === (36))){
var inst_77346 = (state_77356[(2)]);
var inst_77347 = fluree.db.util.async.throw_err.call(null,inst_77346);
var state_77356__$1 = state_77356;
var statearr_77377_77428 = state_77356__$1;
(statearr_77377_77428[(2)] = inst_77347);

(statearr_77377_77428[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (29))){
var inst_77334 = (state_77356[(9)]);
var inst_77318 = (state_77356[(7)]);
var inst_77336 = fluree.db.dbfunctions.ctx.build.call(null,db,inst_77318,inst_77334);
var state_77356__$1 = state_77356;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77356__$1,(32),inst_77336);
} else {
if((state_val_77357 === (6))){
var state_77356__$1 = state_77356;
var statearr_77378_77429 = state_77356__$1;
(statearr_77378_77429[(2)] = null);

(statearr_77378_77429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (28))){
var inst_77330 = (state_77356[(2)]);
var state_77356__$1 = state_77356;
var statearr_77379_77430 = state_77356__$1;
(statearr_77379_77430[(2)] = inst_77330);

(statearr_77379_77430[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (25))){
var inst_77324 = (state_77356[(2)]);
var inst_77325 = fluree.db.util.async.throw_err.call(null,inst_77324);
var state_77356__$1 = state_77356;
var statearr_77380_77431 = state_77356__$1;
(statearr_77380_77431[(2)] = inst_77325);

(statearr_77380_77431[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (34))){
var state_77356__$1 = state_77356;
var statearr_77381_77432 = state_77356__$1;
(statearr_77381_77432[(2)] = null);

(statearr_77381_77432[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (17))){
var inst_77304 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_77305 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77306 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_77307 = cljs.core.PersistentHashMap.fromArrays(inst_77305,inst_77306);
var inst_77308 = cljs.core.ex_info.call(null,inst_77304,inst_77307);
var inst_77309 = (function(){throw inst_77308})();
var state_77356__$1 = state_77356;
var statearr_77382_77433 = state_77356__$1;
(statearr_77382_77433[(2)] = inst_77309);

(statearr_77382_77433[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (3))){
var inst_77354 = (state_77356[(2)]);
var state_77356__$1 = state_77356;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77356__$1,inst_77354);
} else {
if((state_val_77357 === (12))){
var inst_77298 = fluree.db.dbproto._subid.call(null,db,auth);
var state_77356__$1 = state_77356;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77356__$1,(15),inst_77298);
} else {
if((state_val_77357 === (2))){
var _ = (function (){var statearr_77383 = state_77356;
(statearr_77383[(4)] = cljs.core.cons.call(null,(5),(state_77356[(4)])));

return statearr_77383;
})();
var inst_77291 = (auth == null);
var state_77356__$1 = state_77356;
if(cljs.core.truth_(inst_77291)){
var statearr_77384_77434 = state_77356__$1;
(statearr_77384_77434[(1)] = (6));

} else {
var statearr_77385_77435 = state_77356__$1;
(statearr_77385_77435[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (23))){
var state_77356__$1 = state_77356;
var statearr_77386_77436 = state_77356__$1;
(statearr_77386_77436[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (35))){
var inst_77334 = (state_77356[(9)]);
var inst_77342 = (state_77356[(10)]);
var inst_77318 = (state_77356[(7)]);
var inst_77350 = (state_77356[(2)]);
var inst_77351 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_77318,new cljs.core.Keyword(null,"roles","roles",143379530),inst_77334,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_77350,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_77342);
var _ = (function (){var statearr_77388 = state_77356;
(statearr_77388[(4)] = cljs.core.rest.call(null,(state_77356[(4)])));

return statearr_77388;
})();
var state_77356__$1 = state_77356;
var statearr_77389_77437 = state_77356__$1;
(statearr_77389_77437[(2)] = inst_77351);

(statearr_77389_77437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (19))){
var state_77356__$1 = state_77356;
var statearr_77390_77438 = state_77356__$1;
(statearr_77390_77438[(2)] = roles);

(statearr_77390_77438[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (11))){
var inst_77316 = (state_77356[(2)]);
var state_77356__$1 = state_77356;
var statearr_77392_77439 = state_77356__$1;
(statearr_77392_77439[(2)] = inst_77316);

(statearr_77392_77439[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (9))){
var state_77356__$1 = state_77356;
var statearr_77393_77440 = state_77356__$1;
(statearr_77393_77440[(2)] = (0));

(statearr_77393_77440[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (5))){
var _ = (function (){var statearr_77394 = state_77356;
(statearr_77394[(4)] = cljs.core.rest.call(null,(state_77356[(4)])));

return statearr_77394;
})();
var state_77356__$1 = state_77356;
var ex77391 = (state_77356__$1[(2)]);
var statearr_77395_77441 = state_77356__$1;
(statearr_77395_77441[(5)] = ex77391);


if((ex77391 instanceof Error)){
var statearr_77396_77442 = state_77356__$1;
(statearr_77396_77442[(1)] = (4));

(statearr_77396_77442[(5)] = null);

} else {
throw ex77391;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (14))){
var inst_77314 = (state_77356[(2)]);
var state_77356__$1 = state_77356;
var statearr_77397_77443 = state_77356__$1;
(statearr_77397_77443[(2)] = inst_77314);

(statearr_77397_77443[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (26))){
var state_77356__$1 = state_77356;
var statearr_77398_77444 = state_77356__$1;
(statearr_77398_77444[(2)] = null);

(statearr_77398_77444[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (16))){
var inst_77301 = (state_77356[(8)]);
var state_77356__$1 = state_77356;
var statearr_77399_77445 = state_77356__$1;
(statearr_77399_77445[(2)] = inst_77301);

(statearr_77399_77445[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (30))){
var state_77356__$1 = state_77356;
var statearr_77400_77446 = state_77356__$1;
(statearr_77400_77446[(2)] = null);

(statearr_77400_77446[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (10))){
var state_77356__$1 = state_77356;
if(cljs.core.truth_(auth)){
var statearr_77401_77447 = state_77356__$1;
(statearr_77401_77447[(1)] = (12));

} else {
var statearr_77402_77448 = state_77356__$1;
(statearr_77402_77448[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (18))){
var inst_77311 = (state_77356[(2)]);
var state_77356__$1 = state_77356;
var statearr_77403_77449 = state_77356__$1;
(statearr_77403_77449[(2)] = inst_77311);

(statearr_77403_77449[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77357 === (8))){
var inst_77318 = (state_77356[(2)]);
var state_77356__$1 = (function (){var statearr_77404 = state_77356;
(statearr_77404[(7)] = inst_77318);

return statearr_77404;
})();
if(cljs.core.truth_(roles)){
var statearr_77405_77450 = state_77356__$1;
(statearr_77405_77450[(1)] = (19));

} else {
var statearr_77406_77451 = state_77356__$1;
(statearr_77406_77451[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0 = (function (){
var statearr_77407 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_77407[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__);

(statearr_77407[(1)] = (1));

return statearr_77407;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1 = (function (state_77356){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_77356);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77408){var ex__2730__auto__ = e77408;
var statearr_77409_77452 = state_77356;
(statearr_77409_77452[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_77356[(4)]))){
var statearr_77410_77453 = state_77356;
(statearr_77410_77453[(1)] = cljs.core.first.call(null,(state_77356[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77454 = state_77356;
state_77356 = G__77454;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = function(state_77356){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1.call(this,state_77356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77411 = f__2750__auto__.call(null);
(statearr_77411[(6)] = c__2749__auto__);

return statearr_77411;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__77455 = db;
var map__77455__$1 = cljs.core.__destructure_map.call(null,map__77455);
var conn = cljs.core.get.call(null,map__77455__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__77455__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__77455__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,listen_id);

var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77462){
var state_val_77463 = (state_77462[(1)]);
if((state_val_77463 === (1))){
var inst_77456 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_77457 = fluree.db.session.db.call(null,conn,inst_77456,null);
var state_77462__$1 = state_77462;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77462__$1,(2),inst_77457);
} else {
if((state_val_77463 === (2))){
var inst_77459 = (state_77462[(2)]);
var inst_77460 = cljs.core.async.put_BANG_.call(null,resp_port,inst_77459);
var state_77462__$1 = state_77462;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77462__$1,inst_77460);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_77464 = [null,null,null,null,null,null,null];
(statearr_77464[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_77464[(1)] = (1));

return statearr_77464;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_77462){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_77462);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77465){var ex__2730__auto__ = e77465;
var statearr_77466_77493 = state_77462;
(statearr_77466_77493[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_77462[(4)]))){
var statearr_77467_77494 = state_77462;
(statearr_77467_77494[(1)] = cljs.core.first.call(null,(state_77462[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77495 = state_77462;
state_77462 = G__77495;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_77462){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_77462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77468 = f__2750__auto__.call(null);
(statearr_77468[(6)] = c__2749__auto__);

return statearr_77468;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,ledger_id,listen_id,event_fn);

var c__2749__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77481){
var state_val_77482 = (state_77481[(1)]);
if((state_val_77482 === (1))){
var inst_77469 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_77470 = fluree.db.session.db.call(null,conn,inst_77469,null);
var state_77481__$1 = state_77481;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77481__$1,(2),inst_77470);
} else {
if((state_val_77482 === (2))){
var inst_77472 = (state_77481[(7)]);
var inst_77472__$1 = (state_77481[(2)]);
var inst_77473 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_77472__$1);
var inst_77474 = newer_block_QMARK_.call(null,inst_77473);
var state_77481__$1 = (function (){var statearr_77483 = state_77481;
(statearr_77483[(7)] = inst_77472__$1);

return statearr_77483;
})();
if(inst_77474){
var statearr_77484_77496 = state_77481__$1;
(statearr_77484_77496[(1)] = (3));

} else {
var statearr_77485_77497 = state_77481__$1;
(statearr_77485_77497[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77482 === (3))){
var inst_77472 = (state_77481[(7)]);
var inst_77476 = cljs.core.async.put_BANG_.call(null,resp_port,inst_77472);
var state_77481__$1 = state_77481;
var statearr_77486_77498 = state_77481__$1;
(statearr_77486_77498[(2)] = inst_77476);

(statearr_77486_77498[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77482 === (4))){
var state_77481__$1 = state_77481;
var statearr_77487_77499 = state_77481__$1;
(statearr_77487_77499[(2)] = null);

(statearr_77487_77499[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77482 === (5))){
var inst_77479 = (state_77481[(2)]);
var state_77481__$1 = state_77481;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77481__$1,inst_77479);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_77488 = [null,null,null,null,null,null,null,null];
(statearr_77488[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_77488[(1)] = (1));

return statearr_77488;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_77481){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_77481);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77489){var ex__2730__auto__ = e77489;
var statearr_77490_77500 = state_77481;
(statearr_77490_77500[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_77481[(4)]))){
var statearr_77491_77501 = state_77481;
(statearr_77491_77501[(1)] = cljs.core.first.call(null,(state_77481[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77502 = state_77481;
state_77481 = G__77502;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_77481){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_77481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77492 = f__2750__auto__.call(null);
(statearr_77492[(6)] = c__2749__auto__);

return statearr_77492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__77503 = db;
var map__77503__$1 = cljs.core.__destructure_map.call(null,map__77503);
var conn = cljs.core.get.call(null,map__77503__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__77503__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__77503__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__4339__auto__ = syncTimeout;
var y__4340__auto__ = (120000);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__2749__auto___77579 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77553){
var state_val_77554 = (state_77553[(1)]);
if((state_val_77554 === (7))){
var inst_77519 = (state_77553[(7)]);
var inst_77530 = cljs.core._EQ_.call(null,inst_77519,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_77553__$1 = state_77553;
if(inst_77530){
var statearr_77555_77580 = state_77553__$1;
(statearr_77555_77580[(1)] = (9));

} else {
var statearr_77556_77581 = state_77553__$1;
(statearr_77556_77581[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77554 === (1))){
var inst_77504 = (state_77553[(8)]);
var inst_77512 = (state_77553[(9)]);
var inst_77504__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_77512__$1 = res_port;
var inst_77513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77514 = [inst_77504__$1,inst_77512__$1];
var inst_77515 = (new cljs.core.PersistentVector(null,2,(5),inst_77513,inst_77514,null));
var state_77553__$1 = (function (){var statearr_77557 = state_77553;
(statearr_77557[(8)] = inst_77504__$1);

(statearr_77557[(9)] = inst_77512__$1);

return statearr_77557;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_77553__$1,(2),inst_77515);
} else {
if((state_val_77554 === (4))){
var inst_77519 = (state_77553[(7)]);
var inst_77512 = (state_77553[(9)]);
var inst_77523 = cljs.core._EQ_.call(null,inst_77519,inst_77512);
var state_77553__$1 = state_77553;
if(inst_77523){
var statearr_77558_77582 = state_77553__$1;
(statearr_77558_77582[(1)] = (6));

} else {
var statearr_77559_77583 = state_77553__$1;
(statearr_77559_77583[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77554 === (13))){
var inst_77538 = (state_77553[(10)]);
var inst_77549 = cljs.core.async.put_BANG_.call(null,pc,inst_77538);
var state_77553__$1 = state_77553;
var statearr_77560_77584 = state_77553__$1;
(statearr_77560_77584[(2)] = inst_77549);

(statearr_77560_77584[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77554 === (6))){
var inst_77517 = (state_77553[(11)]);
var inst_77528 = cljs.core.nth.call(null,inst_77517,(0),null);
var state_77553__$1 = state_77553;
var statearr_77561_77585 = state_77553__$1;
(statearr_77561_77585[(2)] = inst_77528);

(statearr_77561_77585[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77554 === (3))){
var state_77553__$1 = state_77553;
var statearr_77562_77586 = state_77553__$1;
(statearr_77562_77586[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_77562_77586[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77554 === (12))){
var inst_77542 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_77543 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_77544 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_77545 = cljs.core.PersistentHashMap.fromArrays(inst_77543,inst_77544);
var inst_77546 = cljs.core.ex_info.call(null,inst_77542,inst_77545);
var inst_77547 = cljs.core.async.put_BANG_.call(null,pc,inst_77546);
var state_77553__$1 = state_77553;
var statearr_77563_77587 = state_77553__$1;
(statearr_77563_77587[(2)] = inst_77547);

(statearr_77563_77587[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77554 === (2))){
var inst_77504 = (state_77553[(8)]);
var inst_77517 = (state_77553[(11)]);
var inst_77519 = (state_77553[(7)]);
var inst_77517__$1 = (state_77553[(2)]);
var inst_77518 = cljs.core.nth.call(null,inst_77517__$1,(0),null);
var inst_77519__$1 = cljs.core.nth.call(null,inst_77517__$1,(1),null);
var inst_77520 = cljs.core._EQ_.call(null,inst_77519__$1,inst_77504);
var state_77553__$1 = (function (){var statearr_77564 = state_77553;
(statearr_77564[(11)] = inst_77517__$1);

(statearr_77564[(7)] = inst_77519__$1);

(statearr_77564[(12)] = inst_77518);

return statearr_77564;
})();
if(inst_77520){
var statearr_77565_77588 = state_77553__$1;
(statearr_77565_77588[(1)] = (3));

} else {
var statearr_77566_77589 = state_77553__$1;
(statearr_77566_77589[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77554 === (11))){
var inst_77534 = (state_77553[(2)]);
var state_77553__$1 = state_77553;
var statearr_77567_77590 = state_77553__$1;
(statearr_77567_77590[(2)] = inst_77534);

(statearr_77567_77590[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77554 === (9))){
var inst_77518 = (state_77553[(12)]);
var state_77553__$1 = state_77553;
var statearr_77568_77591 = state_77553__$1;
(statearr_77568_77591[(2)] = inst_77518);

(statearr_77568_77591[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77554 === (5))){
var inst_77538 = (state_77553[(10)]);
var inst_77538__$1 = (state_77553[(2)]);
var inst_77539 = fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,listen_id);
var inst_77540 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_77538__$1);
var state_77553__$1 = (function (){var statearr_77569 = state_77553;
(statearr_77569[(10)] = inst_77538__$1);

(statearr_77569[(13)] = inst_77539);

return statearr_77569;
})();
if(inst_77540){
var statearr_77570_77592 = state_77553__$1;
(statearr_77570_77592[(1)] = (12));

} else {
var statearr_77571_77593 = state_77553__$1;
(statearr_77571_77593[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77554 === (14))){
var inst_77551 = (state_77553[(2)]);
var state_77553__$1 = state_77553;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77553__$1,inst_77551);
} else {
if((state_val_77554 === (10))){
var state_77553__$1 = state_77553;
var statearr_77572_77594 = state_77553__$1;
(statearr_77572_77594[(2)] = null);

(statearr_77572_77594[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77554 === (8))){
var inst_77536 = (state_77553[(2)]);
var state_77553__$1 = state_77553;
var statearr_77573_77595 = state_77553__$1;
(statearr_77573_77595[(2)] = inst_77536);

(statearr_77573_77595[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0 = (function (){
var statearr_77574 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77574[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__);

(statearr_77574[(1)] = (1));

return statearr_77574;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1 = (function (state_77553){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_77553);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77575){var ex__2730__auto__ = e77575;
var statearr_77576_77596 = state_77553;
(statearr_77576_77596[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_77553[(4)]))){
var statearr_77577_77597 = state_77553;
(statearr_77577_77597[(1)] = cljs.core.first.call(null,(state_77553[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77598 = state_77553;
state_77553 = G__77598;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = function(state_77553){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1.call(this,state_77553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77578 = f__2750__auto__.call(null);
(statearr_77578[(6)] = c__2749__auto___77579);

return statearr_77578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__77600 = arguments.length;
switch (G__77600) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__77601){
var map__77602 = p__77601;
var map__77602__$1 = cljs.core.__destructure_map.call(null,map__77602);
var opts = map__77602__$1;
var roles = cljs.core.get.call(null,map__77602__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__77602__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__77602__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__77602__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__77602__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2749__auto___77691 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_77653){
var state_val_77654 = (state_77653[(1)]);
if((state_val_77654 === (7))){
var inst_77615 = (state_77653[(7)]);
var inst_77617 = fluree.db.api.ledger.syncTo_db.call(null,inst_77615,syncTo,syncTimeout);
var state_77653__$1 = state_77653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77653__$1,(10),inst_77617);
} else {
if((state_val_77654 === (20))){
var inst_77639 = (state_77653[(8)]);
var state_77653__$1 = state_77653;
var statearr_77655_77692 = state_77653__$1;
(statearr_77655_77692[(2)] = inst_77639);

(statearr_77655_77692[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (1))){
var state_77653__$1 = state_77653;
var statearr_77656_77693 = state_77653__$1;
(statearr_77656_77693[(2)] = null);

(statearr_77656_77693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (4))){
var inst_77603 = (state_77653[(2)]);
var inst_77604 = cljs.core.async.put_BANG_.call(null,pc,inst_77603);
var inst_77605 = cljs.core.async.close_BANG_.call(null,pc);
var state_77653__$1 = (function (){var statearr_77657 = state_77653;
(statearr_77657[(9)] = inst_77604);

return statearr_77657;
})();
var statearr_77658_77694 = state_77653__$1;
(statearr_77658_77694[(2)] = inst_77605);

(statearr_77658_77694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (15))){
var inst_77631 = (state_77653[(10)]);
var inst_77633 = fluree.db.api.ledger.add_db_permissions.call(null,inst_77631,auth,roles);
var state_77653__$1 = state_77653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77653__$1,(18),inst_77633);
} else {
if((state_val_77654 === (21))){
var inst_77647 = (state_77653[(2)]);
var inst_77648 = cljs.core.async.put_BANG_.call(null,pc,inst_77647);
var _ = (function (){var statearr_77659 = state_77653;
(statearr_77659[(4)] = cljs.core.rest.call(null,(state_77653[(4)])));

return statearr_77659;
})();
var state_77653__$1 = state_77653;
var statearr_77660_77695 = state_77653__$1;
(statearr_77660_77695[(2)] = inst_77648);

(statearr_77660_77695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (13))){
var inst_77631 = (state_77653[(2)]);
var state_77653__$1 = (function (){var statearr_77661 = state_77653;
(statearr_77661[(10)] = inst_77631);

return statearr_77661;
})();
if(cljs.core.truth_(roles)){
var statearr_77662_77696 = state_77653__$1;
(statearr_77662_77696[(1)] = (15));

} else {
var statearr_77663_77697 = state_77653__$1;
(statearr_77663_77697[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (22))){
var inst_77643 = (state_77653[(2)]);
var inst_77644 = fluree.db.util.async.throw_err.call(null,inst_77643);
var state_77653__$1 = state_77653;
var statearr_77664_77698 = state_77653__$1;
(statearr_77664_77698[(2)] = inst_77644);

(statearr_77664_77698[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (6))){
var inst_77614 = (state_77653[(2)]);
var inst_77615 = fluree.db.util.async.throw_err.call(null,inst_77614);
var state_77653__$1 = (function (){var statearr_77665 = state_77653;
(statearr_77665[(7)] = inst_77615);

return statearr_77665;
})();
if(cljs.core.truth_(syncTo)){
var statearr_77666_77699 = state_77653__$1;
(statearr_77666_77699[(1)] = (7));

} else {
var statearr_77667_77700 = state_77653__$1;
(statearr_77667_77700[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (17))){
var inst_77639 = (state_77653[(2)]);
var state_77653__$1 = (function (){var statearr_77668 = state_77653;
(statearr_77668[(8)] = inst_77639);

return statearr_77668;
})();
if(cljs.core.truth_(auth)){
var statearr_77669_77701 = state_77653__$1;
(statearr_77669_77701[(1)] = (19));

} else {
var statearr_77670_77702 = state_77653__$1;
(statearr_77670_77702[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (3))){
var inst_77651 = (state_77653[(2)]);
var state_77653__$1 = state_77653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77653__$1,inst_77651);
} else {
if((state_val_77654 === (12))){
var inst_77623 = (state_77653[(11)]);
var state_77653__$1 = state_77653;
var statearr_77671_77703 = state_77653__$1;
(statearr_77671_77703[(2)] = inst_77623);

(statearr_77671_77703[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (2))){
var _ = (function (){var statearr_77672 = state_77653;
(statearr_77672[(4)] = cljs.core.cons.call(null,(5),(state_77653[(4)])));

return statearr_77672;
})();
var inst_77612 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_77653__$1 = state_77653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77653__$1,(6),inst_77612);
} else {
if((state_val_77654 === (19))){
var inst_77639 = (state_77653[(8)]);
var inst_77641 = fluree.db.api.ledger.add_db_permissions.call(null,inst_77639,auth,roles);
var state_77653__$1 = state_77653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77653__$1,(22),inst_77641);
} else {
if((state_val_77654 === (11))){
var inst_77623 = (state_77653[(11)]);
var inst_77625 = fluree.db.time_travel.as_of_block.call(null,inst_77623,block);
var state_77653__$1 = state_77653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77653__$1,(14),inst_77625);
} else {
if((state_val_77654 === (9))){
var inst_77623 = (state_77653[(2)]);
var state_77653__$1 = (function (){var statearr_77674 = state_77653;
(statearr_77674[(11)] = inst_77623);

return statearr_77674;
})();
if(cljs.core.truth_(block)){
var statearr_77675_77704 = state_77653__$1;
(statearr_77675_77704[(1)] = (11));

} else {
var statearr_77676_77705 = state_77653__$1;
(statearr_77676_77705[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (5))){
var _ = (function (){var statearr_77677 = state_77653;
(statearr_77677[(4)] = cljs.core.rest.call(null,(state_77653[(4)])));

return statearr_77677;
})();
var state_77653__$1 = state_77653;
var ex77673 = (state_77653__$1[(2)]);
var statearr_77678_77706 = state_77653__$1;
(statearr_77678_77706[(5)] = ex77673);


var statearr_77679_77707 = state_77653__$1;
(statearr_77679_77707[(1)] = (4));

(statearr_77679_77707[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (14))){
var inst_77627 = (state_77653[(2)]);
var inst_77628 = fluree.db.util.async.throw_err.call(null,inst_77627);
var state_77653__$1 = state_77653;
var statearr_77680_77708 = state_77653__$1;
(statearr_77680_77708[(2)] = inst_77628);

(statearr_77680_77708[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (16))){
var inst_77631 = (state_77653[(10)]);
var state_77653__$1 = state_77653;
var statearr_77681_77709 = state_77653__$1;
(statearr_77681_77709[(2)] = inst_77631);

(statearr_77681_77709[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (10))){
var inst_77619 = (state_77653[(2)]);
var inst_77620 = fluree.db.util.async.throw_err.call(null,inst_77619);
var state_77653__$1 = state_77653;
var statearr_77682_77710 = state_77653__$1;
(statearr_77682_77710[(2)] = inst_77620);

(statearr_77682_77710[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (18))){
var inst_77635 = (state_77653[(2)]);
var inst_77636 = fluree.db.util.async.throw_err.call(null,inst_77635);
var state_77653__$1 = state_77653;
var statearr_77683_77711 = state_77653__$1;
(statearr_77683_77711[(2)] = inst_77636);

(statearr_77683_77711[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77654 === (8))){
var inst_77615 = (state_77653[(7)]);
var state_77653__$1 = state_77653;
var statearr_77684_77712 = state_77653__$1;
(statearr_77684_77712[(2)] = inst_77615);

(statearr_77684_77712[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_77685 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77685[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_77685[(1)] = (1));

return statearr_77685;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_77653){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__.call(null,state_77653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e77686){var ex__2730__auto__ = e77686;
var statearr_77687_77713 = state_77653;
(statearr_77687_77713[(2)] = ex__2730__auto__);


if(cljs.core.seq.call(null,(state_77653[(4)]))){
var statearr_77688_77714 = state_77653;
(statearr_77688_77714[(1)] = cljs.core.first.call(null,(state_77653[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77715 = state_77653;
state_77653 = G__77715;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_77653){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_77653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_77689 = f__2750__auto__.call(null);
(statearr_77689[(6)] = c__2749__auto___77691);

return statearr_77689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

