// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.mapcat.call(null,(function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.call(null,ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv.call(null,(function (xs,ns,_){
if(cljs.core._EQ_.call(null,needle,cljs.compiler.get_first_ns_segment.call(null,ns))){
return cljs.core.reduced.call(null,needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__6614 = s;
var map__6614__$1 = cljs.core.__destructure_map.call(null,map__6614);
var name = cljs.core.get.call(null,map__6614__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__6614__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__6616 = info;
var map__6617 = G__6616;
var map__6617__$1 = cljs.core.__destructure_map.call(null,map__6617);
var shadow = cljs.core.get.call(null,map__6617__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__6616__$1 = G__6616;
while(true){
var d__$2 = d__$1;
var map__6619 = G__6616__$1;
var map__6619__$1 = cljs.core.__destructure_map.call(null,map__6619);
var shadow__$1 = cljs.core.get.call(null,map__6619__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__6620 = (d__$2 + (1));
var G__6621 = shadow__$1;
d__$1 = G__6620;
G__6616__$1 = G__6621;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__6622){
var map__6623 = p__6622;
var map__6623__$1 = cljs.core.__destructure_map.call(null,map__6623);
var name_var = map__6623__$1;
var name = cljs.core.get.call(null,map__6623__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__6623__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__6624 = info;
var map__6624__$1 = cljs.core.__destructure_map.call(null,map__6624);
var ns = cljs.core.get.call(null,map__6624__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__6624__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.call(null,reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__6626 = arguments.length;
switch (G__6626) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace.call(null,ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split.call(null,ss__$1,/\./));
var ss__$3 = clojure.string.join.call(null,".",ss__$2);
var ms = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11648,11648,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)])).call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__6628 = cp;
switch (G__6628) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.call(null,"0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__6630_6634 = cljs.core.seq.call(null,s);
var chunk__6631_6635 = null;
var count__6632_6636 = (0);
var i__6633_6637 = (0);
while(true){
if((i__6633_6637 < count__6632_6636)){
var c_6638 = cljs.core._nth.call(null,chunk__6631_6635,i__6633_6637);
sb.append(cljs.compiler.escape_char.call(null,c_6638));


var G__6639 = seq__6630_6634;
var G__6640 = chunk__6631_6635;
var G__6641 = count__6632_6636;
var G__6642 = (i__6633_6637 + (1));
seq__6630_6634 = G__6639;
chunk__6631_6635 = G__6640;
count__6632_6636 = G__6641;
i__6633_6637 = G__6642;
continue;
} else {
var temp__5753__auto___6643 = cljs.core.seq.call(null,seq__6630_6634);
if(temp__5753__auto___6643){
var seq__6630_6644__$1 = temp__5753__auto___6643;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6630_6644__$1)){
var c__4679__auto___6645 = cljs.core.chunk_first.call(null,seq__6630_6644__$1);
var G__6646 = cljs.core.chunk_rest.call(null,seq__6630_6644__$1);
var G__6647 = c__4679__auto___6645;
var G__6648 = cljs.core.count.call(null,c__4679__auto___6645);
var G__6649 = (0);
seq__6630_6634 = G__6646;
chunk__6631_6635 = G__6647;
count__6632_6636 = G__6648;
i__6633_6637 = G__6649;
continue;
} else {
var c_6650 = cljs.core.first.call(null,seq__6630_6644__$1);
sb.append(cljs.compiler.escape_char.call(null,c_6650));


var G__6651 = cljs.core.next.call(null,seq__6630_6644__$1);
var G__6652 = null;
var G__6653 = (0);
var G__6654 = (0);
seq__6630_6634 = G__6651;
chunk__6631_6635 = G__6652;
count__6632_6636 = G__6653;
i__6633_6637 = G__6654;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4747__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__6655_6658 = ast;
var map__6655_6659__$1 = cljs.core.__destructure_map.call(null,map__6655_6658);
var env_6660 = cljs.core.get.call(null,map__6655_6659__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_6660))){
var map__6656_6661 = env_6660;
var map__6656_6662__$1 = cljs.core.__destructure_map.call(null,map__6656_6661);
var line_6663 = cljs.core.get.call(null,map__6656_6662__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_6664 = cljs.core.get.call(null,map__6656_6662__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__6657 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast)))){
return cljs.core.assoc.call(null,G__6657,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__6657;
}
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_6663 - (1))], null),cljs.core.fnil.call(null,(function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_6664)?(column_6664 - (1)):(0))], null),cljs.core.fnil.call(null,(function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}));
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__6673 = arguments.length;
switch (G__6673) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4885__auto__ = [];
var len__4864__auto___6680 = arguments.length;
var i__4865__auto___6681 = (0);
while(true){
if((i__4865__auto___6681 < len__4864__auto___6680)){
args_arr__4885__auto__.push((arguments[i__4865__auto___6681]));

var G__6682 = (i__4865__auto___6681 + (1));
i__4865__auto___6681 = G__6682;
continue;
} else {
}
break;
}

var argseq__4886__auto__ = (new cljs.core.IndexedSeq(args_arr__4885__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4886__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,a)){
cljs.compiler.emit.call(null,a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_.call(null,a)){
cljs.core.apply.call(null,cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
a.call(null);
} else {
var s_6683 = (function (){var G__6674 = a;
if((!(typeof a === 'string'))){
return G__6674.toString();
} else {
return G__6674;
}
})();
var temp__5757__auto___6684 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___6684 == null)){
} else {
var sm_data_6685 = temp__5757__auto___6684;
cljs.core.swap_BANG_.call(null,sm_data_6685,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__6665_SHARP_){
return (p1__6665_SHARP_ + s_6683.length);
}));
}

cljs.core.print.call(null,s_6683);

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

return cljs.compiler.emits.call(null,b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler.emits.call(null,c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler.emits.call(null,d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler.emits.call(null,e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__6675 = cljs.core.seq.call(null,xs);
var chunk__6676 = null;
var count__6677 = (0);
var i__6678 = (0);
while(true){
if((i__6678 < count__6677)){
var x = cljs.core._nth.call(null,chunk__6676,i__6678);
cljs.compiler.emits.call(null,x);


var G__6686 = seq__6675;
var G__6687 = chunk__6676;
var G__6688 = count__6677;
var G__6689 = (i__6678 + (1));
seq__6675 = G__6686;
chunk__6676 = G__6687;
count__6677 = G__6688;
i__6678 = G__6689;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__6675);
if(temp__5753__auto__){
var seq__6675__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6675__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__6675__$1);
var G__6690 = cljs.core.chunk_rest.call(null,seq__6675__$1);
var G__6691 = c__4679__auto__;
var G__6692 = cljs.core.count.call(null,c__4679__auto__);
var G__6693 = (0);
seq__6675 = G__6690;
chunk__6676 = G__6691;
count__6677 = G__6692;
i__6678 = G__6693;
continue;
} else {
var x = cljs.core.first.call(null,seq__6675__$1);
cljs.compiler.emits.call(null,x);


var G__6694 = cljs.core.next.call(null,seq__6675__$1);
var G__6695 = null;
var G__6696 = (0);
var G__6697 = (0);
seq__6675 = G__6694;
chunk__6676 = G__6695;
count__6677 = G__6696;
i__6678 = G__6697;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq6667){
var G__6668 = cljs.core.first.call(null,seq6667);
var seq6667__$1 = cljs.core.next.call(null,seq6667);
var G__6669 = cljs.core.first.call(null,seq6667__$1);
var seq6667__$2 = cljs.core.next.call(null,seq6667__$1);
var G__6670 = cljs.core.first.call(null,seq6667__$2);
var seq6667__$3 = cljs.core.next.call(null,seq6667__$2);
var G__6671 = cljs.core.first.call(null,seq6667__$3);
var seq6667__$4 = cljs.core.next.call(null,seq6667__$3);
var G__6672 = cljs.core.first.call(null,seq6667__$4);
var seq6667__$5 = cljs.core.next.call(null,seq6667__$4);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6668,G__6669,G__6670,G__6671,G__6672,seq6667__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.call(null);

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__6698){
var map__6699 = p__6698;
var map__6699__$1 = cljs.core.__destructure_map.call(null,map__6699);
var m = map__6699__$1;
var gen_line = cljs.core.get.call(null,map__6699__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__6707 = arguments.length;
switch (G__6707) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4885__auto__ = [];
var len__4864__auto___6713 = arguments.length;
var i__4865__auto___6714 = (0);
while(true){
if((i__4865__auto___6714 < len__4864__auto___6713)){
args_arr__4885__auto__.push((arguments[i__4865__auto___6714]));

var G__6715 = (i__4865__auto___6714 + (1));
i__4865__auto___6714 = G__6715;
continue;
} else {
}
break;
}

var argseq__4886__auto__ = (new cljs.core.IndexedSeq(args_arr__4885__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4886__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.call(null,a);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__6708_6716 = cljs.core.seq.call(null,xs);
var chunk__6709_6717 = null;
var count__6710_6718 = (0);
var i__6711_6719 = (0);
while(true){
if((i__6711_6719 < count__6710_6718)){
var x_6720 = cljs.core._nth.call(null,chunk__6709_6717,i__6711_6719);
cljs.compiler.emits.call(null,x_6720);


var G__6721 = seq__6708_6716;
var G__6722 = chunk__6709_6717;
var G__6723 = count__6710_6718;
var G__6724 = (i__6711_6719 + (1));
seq__6708_6716 = G__6721;
chunk__6709_6717 = G__6722;
count__6710_6718 = G__6723;
i__6711_6719 = G__6724;
continue;
} else {
var temp__5753__auto___6725 = cljs.core.seq.call(null,seq__6708_6716);
if(temp__5753__auto___6725){
var seq__6708_6726__$1 = temp__5753__auto___6725;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6708_6726__$1)){
var c__4679__auto___6727 = cljs.core.chunk_first.call(null,seq__6708_6726__$1);
var G__6728 = cljs.core.chunk_rest.call(null,seq__6708_6726__$1);
var G__6729 = c__4679__auto___6727;
var G__6730 = cljs.core.count.call(null,c__4679__auto___6727);
var G__6731 = (0);
seq__6708_6716 = G__6728;
chunk__6709_6717 = G__6729;
count__6710_6718 = G__6730;
i__6711_6719 = G__6731;
continue;
} else {
var x_6732 = cljs.core.first.call(null,seq__6708_6726__$1);
cljs.compiler.emits.call(null,x_6732);


var G__6733 = cljs.core.next.call(null,seq__6708_6726__$1);
var G__6734 = null;
var G__6735 = (0);
var G__6736 = (0);
seq__6708_6716 = G__6733;
chunk__6709_6717 = G__6734;
count__6710_6718 = G__6735;
i__6711_6719 = G__6736;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln.call(null);
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq6701){
var G__6702 = cljs.core.first.call(null,seq6701);
var seq6701__$1 = cljs.core.next.call(null,seq6701);
var G__6703 = cljs.core.first.call(null,seq6701__$1);
var seq6701__$2 = cljs.core.next.call(null,seq6701__$1);
var G__6704 = cljs.core.first.call(null,seq6701__$2);
var seq6701__$3 = cljs.core.next.call(null,seq6701__$2);
var G__6705 = cljs.core.first.call(null,seq6701__$3);
var seq6701__$4 = cljs.core.next.call(null,seq6701__$3);
var G__6706 = cljs.core.first.call(null,seq6701__$4);
var seq6701__$5 = cljs.core.next.call(null,seq6701__$4);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6702,G__6703,G__6704,G__6705,G__6706,seq6701__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4795__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__6737_6741 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__6738_6742 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__6739_6743 = true;
var _STAR_print_fn_STAR__temp_val__6740_6744 = (function (x__4796__auto__){
return sb__4795__auto__.append(x__4796__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__6739_6743);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__6740_6744);

try{cljs.compiler.emit.call(null,expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__6738_6742);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__6737_6741);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4795__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4747__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.call(null,cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_.call(null,x)){
return cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.core.record_QMARK_.call(null,x)){
var vec__6745 = cljs.analyzer.record_ns_PLUS_name.call(null,x);
var ns = cljs.core.nth.call(null,vec__6745,(0),null);
var name = cljs.core.nth.call(null,vec__6745,(1),null);
return cljs.compiler.emit_record_value.call(null,ns,name,(function (){
return cljs.compiler.emit_constant.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,x));
}));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_.call(null,x)){
return cljs.compiler.emit_map.call(null,cljs.core.keys.call(null,x),cljs.core.vals.call(null,x),cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_.call(null,x)){
return cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_.call(null,x)){
return cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
return cljs.compiler.emit_constant_STAR_.call(null,x);

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta.call(null,cljs.core.meta.call(null,v));
if((!((cljs.core.seq.call(null,m) == null)))){
return cljs.compiler.emit_with_meta.call(null,(function (){
return cljs.compiler.emit_constant_no_meta.call(null,v);
}),(function (){
return cljs.compiler.emit_constant_no_meta.call(null,m);
}));
} else {
return cljs.compiler.emit_constant_no_meta.call(null,v);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.call(null,["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.call(null,cljs.core.type.call(null,x))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.call(null,"NaN");
} else {
if(cljs.core.not.call(null,isFinite(x))){
return cljs.compiler.emits.call(null,(((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.call(null,"(",x,")");

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__6748 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.call(null,vec__6748,(0),null);
var flags = cljs.core.nth.call(null,vec__6748,(1),null);
var pattern = cljs.core.nth.call(null,vec__6748,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4251__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4251__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.call(null,cljs.core.map_indexed.call(null,(function (i,m){
if(cljs.core.even_QMARK_.call(null,i)){
return cljs.compiler.emit_constant.call(null,m);
} else {
return cljs.compiler.emits.call(null,m);
}
}),cljs.compiler.comma_sep.call(null,cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.call(null,"new Date(",inst_ms,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Date,(function (date){
return cljs.compiler.emit_inst.call(null,date.getTime());
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_.call(null,items)){
return cljs.compiler.emit_js_object.call(null,items,(function (p1__6751_SHARP_){
return (function (){
return cljs.compiler.emit_constant.call(null,p1__6751_SHARP_);
});
}));
} else {
return cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__6753){
var map__6754 = p__6753;
var map__6754__$1 = cljs.core.__destructure_map.call(null,map__6754);
var ast = map__6754__$1;
var info = cljs.core.get.call(null,map__6754__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__6754__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__6754__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5751__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit.call(null,cljs.core.assoc.call(null,const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__6755 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__6755__$1 = cljs.core.__destructure_map.call(null,map__6755);
var cenv = map__6755__$1;
var options = cljs.core.get.call(null,map__6755__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4253__auto__ = js_module_name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,ast));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__6756 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.compiler.es5_GT__EQ_.call(null,new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options));
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.namespace.call(null,var_name) == null)));
} else {
return and__4251__auto__;
}
})())){
return clojure.set.difference.call(null,G__6756,cljs.analyzer.es5_allowed);
} else {
return G__6756;
}
})();
var js_module = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4253__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})()], null));
var info__$2 = (function (){var G__6757 = info__$1;
if(cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.call(null,G__6757,reserved);
} else {
return G__6757;
}
})();
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var G__6758_6759 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__6758_6760__$1 = (((G__6758_6759 instanceof cljs.core.Keyword))?G__6758_6759.fqn:null);
switch (G__6758_6760__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace.call(null,var_name))){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"].",cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved));
} else {
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.call(null,"default",cljs.core.name.call(null,var_name));
} else {
return and__4251__auto__;
}
})())){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.call(null,info__$2);
}

break;
default:
cljs.compiler.emits.call(null,info__$2);

}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__6762){
var map__6763 = p__6762;
var map__6763__$1 = cljs.core.__destructure_map.call(null,map__6763);
var arg = map__6763__$1;
var env = cljs.core.get.call(null,map__6763__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__6763__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__6763__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__6763__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__6764 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__6764__$1 = cljs.core.__destructure_map.call(null,map__6764);
var name = cljs.core.get.call(null,map__6764__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__6765){
var map__6766 = p__6765;
var map__6766__$1 = cljs.core.__destructure_map.call(null,map__6766);
var expr = cljs.core.get.call(null,map__6766__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__6766__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__6766__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_with_meta.call(null,expr,meta);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_.call(null,(function (p1__6767_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6767_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count.call(null,keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count.call(null,keys) === (0))){
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(distinct_keys_QMARK_.call(null,keys))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.createAsIfByAssoc([",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"])");
}
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",comma_sep.call(null,keys),"],[",comma_sep.call(null,vals),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__6768){
var map__6769 = p__6768;
var map__6769__$1 = cljs.core.__destructure_map.call(null,map__6769);
var env = cljs.core.get.call(null,map__6769__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__6769__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__6769__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_map.call(null,keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.call(null,"cljs.core.list(",comma_sep.call(null,items),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count.call(null,items);
if((cnt < (32))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",comma_sep.call(null,items),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",comma_sep.call(null,items),"], true)");
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__6770){
var map__6771 = p__6770;
var map__6771__$1 = cljs.core.__destructure_map.call(null,map__6771);
var items = cljs.core.get.call(null,map__6771__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6771__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_vector.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_.call(null,(function (p1__6772_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6772_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count.call(null,items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(distinct_constants_QMARK_.call(null,items))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.createAsIfByAssoc([",comma_sep.call(null,items),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__6773){
var map__6774 = p__6773;
var map__6774__$1 = cljs.core.__destructure_map.call(null,map__6774);
var items = cljs.core.get.call(null,map__6774__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6774__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_set.call(null,items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.call(null,"({");

var temp__5753__auto___6797 = cljs.core.seq.call(null,items);
if(temp__5753__auto___6797){
var items_6798__$1 = temp__5753__auto___6797;
var vec__6775_6799 = items_6798__$1;
var seq__6776_6800 = cljs.core.seq.call(null,vec__6775_6799);
var first__6777_6801 = cljs.core.first.call(null,seq__6776_6800);
var seq__6776_6802__$1 = cljs.core.next.call(null,seq__6776_6800);
var vec__6778_6803 = first__6777_6801;
var k_6804 = cljs.core.nth.call(null,vec__6778_6803,(0),null);
var v_6805 = cljs.core.nth.call(null,vec__6778_6803,(1),null);
var r_6806 = seq__6776_6802__$1;
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_6804),"\": ",emit_js_object_val.call(null,v_6805));

var seq__6781_6807 = cljs.core.seq.call(null,r_6806);
var chunk__6782_6808 = null;
var count__6783_6809 = (0);
var i__6784_6810 = (0);
while(true){
if((i__6784_6810 < count__6783_6809)){
var vec__6791_6811 = cljs.core._nth.call(null,chunk__6782_6808,i__6784_6810);
var k_6812__$1 = cljs.core.nth.call(null,vec__6791_6811,(0),null);
var v_6813__$1 = cljs.core.nth.call(null,vec__6791_6811,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_6812__$1),"\": ",emit_js_object_val.call(null,v_6813__$1));


var G__6814 = seq__6781_6807;
var G__6815 = chunk__6782_6808;
var G__6816 = count__6783_6809;
var G__6817 = (i__6784_6810 + (1));
seq__6781_6807 = G__6814;
chunk__6782_6808 = G__6815;
count__6783_6809 = G__6816;
i__6784_6810 = G__6817;
continue;
} else {
var temp__5753__auto___6818__$1 = cljs.core.seq.call(null,seq__6781_6807);
if(temp__5753__auto___6818__$1){
var seq__6781_6819__$1 = temp__5753__auto___6818__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6781_6819__$1)){
var c__4679__auto___6820 = cljs.core.chunk_first.call(null,seq__6781_6819__$1);
var G__6821 = cljs.core.chunk_rest.call(null,seq__6781_6819__$1);
var G__6822 = c__4679__auto___6820;
var G__6823 = cljs.core.count.call(null,c__4679__auto___6820);
var G__6824 = (0);
seq__6781_6807 = G__6821;
chunk__6782_6808 = G__6822;
count__6783_6809 = G__6823;
i__6784_6810 = G__6824;
continue;
} else {
var vec__6794_6825 = cljs.core.first.call(null,seq__6781_6819__$1);
var k_6826__$1 = cljs.core.nth.call(null,vec__6794_6825,(0),null);
var v_6827__$1 = cljs.core.nth.call(null,vec__6794_6825,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_6826__$1),"\": ",emit_js_object_val.call(null,v_6827__$1));


var G__6828 = cljs.core.next.call(null,seq__6781_6819__$1);
var G__6829 = null;
var G__6830 = (0);
var G__6831 = (0);
seq__6781_6807 = G__6828;
chunk__6782_6808 = G__6829;
count__6783_6809 = G__6830;
i__6784_6810 = G__6831;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.call(null,"[",comma_sep.call(null,items),"]");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__6832){
var map__6833 = p__6832;
var map__6833__$1 = cljs.core.__destructure_map.call(null,map__6833);
var keys = cljs.core.get.call(null,map__6833__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__6833__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.call(null,map__6833__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_object.call(null,cljs.core.map.call(null,cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__6834){
var map__6835 = p__6834;
var map__6835__$1 = cljs.core.__destructure_map.call(null,map__6835);
var items = cljs.core.get.call(null,map__6835__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6835__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_array.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.call(null,ns,".map__GT_",name,"(",items,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__6836){
var map__6837 = p__6836;
var map__6837__$1 = cljs.core.__destructure_map.call(null,map__6837);
var expr = cljs.core.get.call(null,map__6837__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__6838){
var map__6839 = p__6838;
var map__6839__$1 = cljs.core.__destructure_map.call(null,map__6839);
var form = cljs.core.get.call(null,map__6839__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__6839__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__6840 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__6840__$1 = cljs.core.__destructure_map.call(null,map__6840);
var op = cljs.core.get.call(null,map__6840__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__6840__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__6840__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4253__auto__ = (function (){var and__4251__auto__ = cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__4251__auto__){
var and__4251__auto____$1 = form;
if(cljs.core.truth_(and__4251__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.call(null,form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto__ = (!((const_expr == null)));
if(and__4251__auto__){
return cljs.compiler.truthy_constant_QMARK_.call(null,const_expr);
} else {
return and__4251__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__6841 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__6841__$1 = cljs.core.__destructure_map.call(null,map__6841);
var op = cljs.core.get.call(null,map__6841__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__6841__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__6841__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4253__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4253__auto__){
return or__4253__auto__;
} else {
var and__4251__auto__ = (!((const_expr == null)));
if(and__4251__auto__){
return cljs.compiler.falsey_constant_QMARK_.call(null,const_expr);
} else {
return and__4251__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__4253__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__6842){
var map__6843 = p__6842;
var map__6843__$1 = cljs.core.__destructure_map.call(null,map__6843);
var test = cljs.core.get.call(null,map__6843__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__6843__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__6843__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__6843__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__6843__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__4253__auto__ = unchecked;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__6844){
var map__6845 = p__6844;
var map__6845__$1 = cljs.core.__destructure_map.call(null,map__6845);
var v = cljs.core.get.call(null,map__6845__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.call(null,map__6845__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.call(null,map__6845__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__6845__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__6846_6874 = cljs.core.seq.call(null,nodes);
var chunk__6847_6875 = null;
var count__6848_6876 = (0);
var i__6849_6877 = (0);
while(true){
if((i__6849_6877 < count__6848_6876)){
var map__6862_6878 = cljs.core._nth.call(null,chunk__6847_6875,i__6849_6877);
var map__6862_6879__$1 = cljs.core.__destructure_map.call(null,map__6862_6878);
var ts_6880 = cljs.core.get.call(null,map__6862_6879__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__6863_6881 = cljs.core.get.call(null,map__6862_6879__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__6863_6882__$1 = cljs.core.__destructure_map.call(null,map__6863_6881);
var then_6883 = cljs.core.get.call(null,map__6863_6882__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__6864_6884 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_6880));
var chunk__6865_6885 = null;
var count__6866_6886 = (0);
var i__6867_6887 = (0);
while(true){
if((i__6867_6887 < count__6866_6886)){
var test_6888 = cljs.core._nth.call(null,chunk__6865_6885,i__6867_6887);
cljs.compiler.emitln.call(null,"case ",test_6888,":");


var G__6889 = seq__6864_6884;
var G__6890 = chunk__6865_6885;
var G__6891 = count__6866_6886;
var G__6892 = (i__6867_6887 + (1));
seq__6864_6884 = G__6889;
chunk__6865_6885 = G__6890;
count__6866_6886 = G__6891;
i__6867_6887 = G__6892;
continue;
} else {
var temp__5753__auto___6893 = cljs.core.seq.call(null,seq__6864_6884);
if(temp__5753__auto___6893){
var seq__6864_6894__$1 = temp__5753__auto___6893;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6864_6894__$1)){
var c__4679__auto___6895 = cljs.core.chunk_first.call(null,seq__6864_6894__$1);
var G__6896 = cljs.core.chunk_rest.call(null,seq__6864_6894__$1);
var G__6897 = c__4679__auto___6895;
var G__6898 = cljs.core.count.call(null,c__4679__auto___6895);
var G__6899 = (0);
seq__6864_6884 = G__6896;
chunk__6865_6885 = G__6897;
count__6866_6886 = G__6898;
i__6867_6887 = G__6899;
continue;
} else {
var test_6900 = cljs.core.first.call(null,seq__6864_6894__$1);
cljs.compiler.emitln.call(null,"case ",test_6900,":");


var G__6901 = cljs.core.next.call(null,seq__6864_6894__$1);
var G__6902 = null;
var G__6903 = (0);
var G__6904 = (0);
seq__6864_6884 = G__6901;
chunk__6865_6885 = G__6902;
count__6866_6886 = G__6903;
i__6867_6887 = G__6904;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_6883);
} else {
cljs.compiler.emitln.call(null,then_6883);
}

cljs.compiler.emitln.call(null,"break;");


var G__6905 = seq__6846_6874;
var G__6906 = chunk__6847_6875;
var G__6907 = count__6848_6876;
var G__6908 = (i__6849_6877 + (1));
seq__6846_6874 = G__6905;
chunk__6847_6875 = G__6906;
count__6848_6876 = G__6907;
i__6849_6877 = G__6908;
continue;
} else {
var temp__5753__auto___6909 = cljs.core.seq.call(null,seq__6846_6874);
if(temp__5753__auto___6909){
var seq__6846_6910__$1 = temp__5753__auto___6909;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6846_6910__$1)){
var c__4679__auto___6911 = cljs.core.chunk_first.call(null,seq__6846_6910__$1);
var G__6912 = cljs.core.chunk_rest.call(null,seq__6846_6910__$1);
var G__6913 = c__4679__auto___6911;
var G__6914 = cljs.core.count.call(null,c__4679__auto___6911);
var G__6915 = (0);
seq__6846_6874 = G__6912;
chunk__6847_6875 = G__6913;
count__6848_6876 = G__6914;
i__6849_6877 = G__6915;
continue;
} else {
var map__6868_6916 = cljs.core.first.call(null,seq__6846_6910__$1);
var map__6868_6917__$1 = cljs.core.__destructure_map.call(null,map__6868_6916);
var ts_6918 = cljs.core.get.call(null,map__6868_6917__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__6869_6919 = cljs.core.get.call(null,map__6868_6917__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__6869_6920__$1 = cljs.core.__destructure_map.call(null,map__6869_6919);
var then_6921 = cljs.core.get.call(null,map__6869_6920__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__6870_6922 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_6918));
var chunk__6871_6923 = null;
var count__6872_6924 = (0);
var i__6873_6925 = (0);
while(true){
if((i__6873_6925 < count__6872_6924)){
var test_6926 = cljs.core._nth.call(null,chunk__6871_6923,i__6873_6925);
cljs.compiler.emitln.call(null,"case ",test_6926,":");


var G__6927 = seq__6870_6922;
var G__6928 = chunk__6871_6923;
var G__6929 = count__6872_6924;
var G__6930 = (i__6873_6925 + (1));
seq__6870_6922 = G__6927;
chunk__6871_6923 = G__6928;
count__6872_6924 = G__6929;
i__6873_6925 = G__6930;
continue;
} else {
var temp__5753__auto___6931__$1 = cljs.core.seq.call(null,seq__6870_6922);
if(temp__5753__auto___6931__$1){
var seq__6870_6932__$1 = temp__5753__auto___6931__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6870_6932__$1)){
var c__4679__auto___6933 = cljs.core.chunk_first.call(null,seq__6870_6932__$1);
var G__6934 = cljs.core.chunk_rest.call(null,seq__6870_6932__$1);
var G__6935 = c__4679__auto___6933;
var G__6936 = cljs.core.count.call(null,c__4679__auto___6933);
var G__6937 = (0);
seq__6870_6922 = G__6934;
chunk__6871_6923 = G__6935;
count__6872_6924 = G__6936;
i__6873_6925 = G__6937;
continue;
} else {
var test_6938 = cljs.core.first.call(null,seq__6870_6932__$1);
cljs.compiler.emitln.call(null,"case ",test_6938,":");


var G__6939 = cljs.core.next.call(null,seq__6870_6932__$1);
var G__6940 = null;
var G__6941 = (0);
var G__6942 = (0);
seq__6870_6922 = G__6939;
chunk__6871_6923 = G__6940;
count__6872_6924 = G__6941;
i__6873_6925 = G__6942;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_6921);
} else {
cljs.compiler.emitln.call(null,then_6921);
}

cljs.compiler.emitln.call(null,"break;");


var G__6943 = cljs.core.next.call(null,seq__6846_6910__$1);
var G__6944 = null;
var G__6945 = (0);
var G__6946 = (0);
seq__6846_6874 = G__6943;
chunk__6847_6875 = G__6944;
count__6848_6876 = G__6945;
i__6849_6877 = G__6946;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__6947){
var map__6948 = p__6947;
var map__6948__$1 = cljs.core.__destructure_map.call(null,map__6948);
var throw$ = cljs.core.get.call(null,map__6948__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.call(null,map__6948__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__6950 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__6950,(0),null);
var rstr = cljs.core.nth.call(null,vec__6950,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs.compiler.resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_.call(null,axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,(function (p1__6949_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__6949_SHARP_);
}),clojure.string.trim),clojure.string.split.call(null,axstr,/,/)));
var G__6953 = ["function(",clojure.string.join.call(null,",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__6953,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__6953;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),"="].join('');
} else {
return cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim.call(null,ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split.call(null,ts__$1,/\|/);
return ["{",clojure.string.join.call(null,"|",cljs.core.map.call(null,(function (p1__6954_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__6954_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__6955 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__6956 = cljs.core.seq.call(null,vec__6955);
var first__6957 = cljs.core.first.call(null,seq__6956);
var seq__6956__$1 = cljs.core.next.call(null,seq__6956);
var p = first__6957;
var first__6957__$1 = cljs.core.first.call(null,seq__6956__$1);
var seq__6956__$2 = cljs.core.next.call(null,seq__6956__$1);
var ts = first__6957__$1;
var first__6957__$2 = cljs.core.first.call(null,seq__6956__$2);
var seq__6956__$3 = cljs.core.next.call(null,seq__6956__$2);
var n = first__6957__$2;
var xs = seq__6956__$3;
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.call(null,"@param",p);
if(and__4251__auto__){
var and__4251__auto____$1 = ts;
if(cljs.core.truth_(and__4251__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__6958 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__6959 = cljs.core.seq.call(null,vec__6958);
var first__6960 = cljs.core.first.call(null,seq__6959);
var seq__6959__$1 = cljs.core.next.call(null,seq__6959);
var p = first__6960;
var first__6960__$1 = cljs.core.first.call(null,seq__6959__$1);
var seq__6959__$2 = cljs.core.next.call(null,seq__6959__$1);
var ts = first__6960__$1;
var xs = seq__6959__$2;
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.call(null,"@return",p);
if(and__4251__auto__){
var and__4251__auto____$1 = ts;
if(cljs.core.truth_(and__4251__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__6963 = arguments.length;
switch (G__6963) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__6971 = cljs.core.map.call(null,(function (p1__6961_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__6961_SHARP_);
} else {
return p1__6961_SHARP_;
}
}),clojure.string.split_lines.call(null,e));
var seq__6972 = cljs.core.seq.call(null,vec__6971);
var first__6973 = cljs.core.first.call(null,seq__6972);
var seq__6972__$1 = cljs.core.next.call(null,seq__6972);
var x = first__6973;
var ys = seq__6972__$1;
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,x,"*/","* /"));

var seq__6974 = cljs.core.seq.call(null,ys);
var chunk__6975 = null;
var count__6976 = (0);
var i__6977 = (0);
while(true){
if((i__6977 < count__6976)){
var next_line = cljs.core._nth.call(null,chunk__6975,i__6977);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__6983 = seq__6974;
var G__6984 = chunk__6975;
var G__6985 = count__6976;
var G__6986 = (i__6977 + (1));
seq__6974 = G__6983;
chunk__6975 = G__6984;
count__6976 = G__6985;
i__6977 = G__6986;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__6974);
if(temp__5753__auto__){
var seq__6974__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6974__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__6974__$1);
var G__6987 = cljs.core.chunk_rest.call(null,seq__6974__$1);
var G__6988 = c__4679__auto__;
var G__6989 = cljs.core.count.call(null,c__4679__auto__);
var G__6990 = (0);
seq__6974 = G__6987;
chunk__6975 = G__6988;
count__6976 = G__6989;
i__6977 = G__6990;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__6974__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__6991 = cljs.core.next.call(null,seq__6974__$1);
var G__6992 = null;
var G__6993 = (0);
var G__6994 = (0);
seq__6974 = G__6991;
chunk__6975 = G__6992;
count__6976 = G__6993;
i__6977 = G__6994;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__6978_6995 = cljs.core.seq.call(null,docs__$2);
var chunk__6979_6996 = null;
var count__6980_6997 = (0);
var i__6981_6998 = (0);
while(true){
if((i__6981_6998 < count__6980_6997)){
var e_6999 = cljs.core._nth.call(null,chunk__6979_6996,i__6981_6998);
if(cljs.core.truth_(e_6999)){
print_comment_lines.call(null,e_6999);
} else {
}


var G__7000 = seq__6978_6995;
var G__7001 = chunk__6979_6996;
var G__7002 = count__6980_6997;
var G__7003 = (i__6981_6998 + (1));
seq__6978_6995 = G__7000;
chunk__6979_6996 = G__7001;
count__6980_6997 = G__7002;
i__6981_6998 = G__7003;
continue;
} else {
var temp__5753__auto___7004 = cljs.core.seq.call(null,seq__6978_6995);
if(temp__5753__auto___7004){
var seq__6978_7005__$1 = temp__5753__auto___7004;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6978_7005__$1)){
var c__4679__auto___7006 = cljs.core.chunk_first.call(null,seq__6978_7005__$1);
var G__7007 = cljs.core.chunk_rest.call(null,seq__6978_7005__$1);
var G__7008 = c__4679__auto___7006;
var G__7009 = cljs.core.count.call(null,c__4679__auto___7006);
var G__7010 = (0);
seq__6978_6995 = G__7007;
chunk__6979_6996 = G__7008;
count__6980_6997 = G__7009;
i__6981_6998 = G__7010;
continue;
} else {
var e_7011 = cljs.core.first.call(null,seq__6978_7005__$1);
if(cljs.core.truth_(e_7011)){
print_comment_lines.call(null,e_7011);
} else {
}


var G__7012 = cljs.core.next.call(null,seq__6978_7005__$1);
var G__7013 = null;
var G__7014 = (0);
var G__7015 = (0);
seq__6978_6995 = G__7012;
chunk__6979_6996 = G__7013;
count__6980_6997 = G__7014;
i__6981_6998 = G__7015;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4251__auto__ = cljs.core.some.call(null,(function (p1__7017_SHARP_){
return goog.string.startsWith(p1__7017_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = opts;
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__4251__auto____$2){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_.call(null,define)){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__7018){
var map__7019 = p__7018;
var map__7019__$1 = cljs.core.__destructure_map.call(null,map__7019);
var doc = cljs.core.get.call(null,map__7019__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__7019__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.call(null,map__7019__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.call(null,map__7019__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.call(null,map__7019__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.call(null,map__7019__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__7019__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.call(null,map__7019__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.call(null,map__7019__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.call(null,map__7019__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4253__auto__ = init;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,(cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
return test;
} else {
return and__4251__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__7020){
var map__7021 = p__7020;
var map__7021__$1 = cljs.core.__destructure_map.call(null,map__7021);
var name = cljs.core.get.call(null,map__7021__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__7021__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__7021__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,name)),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__7022_7046 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__7023_7047 = null;
var count__7024_7048 = (0);
var i__7025_7049 = (0);
while(true){
if((i__7025_7049 < count__7024_7048)){
var vec__7032_7050 = cljs.core._nth.call(null,chunk__7023_7047,i__7025_7049);
var i_7051 = cljs.core.nth.call(null,vec__7032_7050,(0),null);
var param_7052 = cljs.core.nth.call(null,vec__7032_7050,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_7052);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__7053 = seq__7022_7046;
var G__7054 = chunk__7023_7047;
var G__7055 = count__7024_7048;
var G__7056 = (i__7025_7049 + (1));
seq__7022_7046 = G__7053;
chunk__7023_7047 = G__7054;
count__7024_7048 = G__7055;
i__7025_7049 = G__7056;
continue;
} else {
var temp__5753__auto___7057 = cljs.core.seq.call(null,seq__7022_7046);
if(temp__5753__auto___7057){
var seq__7022_7058__$1 = temp__5753__auto___7057;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7022_7058__$1)){
var c__4679__auto___7059 = cljs.core.chunk_first.call(null,seq__7022_7058__$1);
var G__7060 = cljs.core.chunk_rest.call(null,seq__7022_7058__$1);
var G__7061 = c__4679__auto___7059;
var G__7062 = cljs.core.count.call(null,c__4679__auto___7059);
var G__7063 = (0);
seq__7022_7046 = G__7060;
chunk__7023_7047 = G__7061;
count__7024_7048 = G__7062;
i__7025_7049 = G__7063;
continue;
} else {
var vec__7035_7064 = cljs.core.first.call(null,seq__7022_7058__$1);
var i_7065 = cljs.core.nth.call(null,vec__7035_7064,(0),null);
var param_7066 = cljs.core.nth.call(null,vec__7035_7064,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_7066);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__7067 = cljs.core.next.call(null,seq__7022_7058__$1);
var G__7068 = null;
var G__7069 = (0);
var G__7070 = (0);
seq__7022_7046 = G__7067;
chunk__7023_7047 = G__7068;
count__7024_7048 = G__7069;
i__7025_7049 = G__7070;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__7038_7071 = cljs.core.seq.call(null,params);
var chunk__7039_7072 = null;
var count__7040_7073 = (0);
var i__7041_7074 = (0);
while(true){
if((i__7041_7074 < count__7040_7073)){
var param_7075 = cljs.core._nth.call(null,chunk__7039_7072,i__7041_7074);
cljs.compiler.emit.call(null,param_7075);

if(cljs.core._EQ_.call(null,param_7075,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7076 = seq__7038_7071;
var G__7077 = chunk__7039_7072;
var G__7078 = count__7040_7073;
var G__7079 = (i__7041_7074 + (1));
seq__7038_7071 = G__7076;
chunk__7039_7072 = G__7077;
count__7040_7073 = G__7078;
i__7041_7074 = G__7079;
continue;
} else {
var temp__5753__auto___7080 = cljs.core.seq.call(null,seq__7038_7071);
if(temp__5753__auto___7080){
var seq__7038_7081__$1 = temp__5753__auto___7080;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7038_7081__$1)){
var c__4679__auto___7082 = cljs.core.chunk_first.call(null,seq__7038_7081__$1);
var G__7083 = cljs.core.chunk_rest.call(null,seq__7038_7081__$1);
var G__7084 = c__4679__auto___7082;
var G__7085 = cljs.core.count.call(null,c__4679__auto___7082);
var G__7086 = (0);
seq__7038_7071 = G__7083;
chunk__7039_7072 = G__7084;
count__7040_7073 = G__7085;
i__7041_7074 = G__7086;
continue;
} else {
var param_7087 = cljs.core.first.call(null,seq__7038_7081__$1);
cljs.compiler.emit.call(null,param_7087);

if(cljs.core._EQ_.call(null,param_7087,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7088 = cljs.core.next.call(null,seq__7038_7081__$1);
var G__7089 = null;
var G__7090 = (0);
var G__7091 = (0);
seq__7038_7071 = G__7088;
chunk__7039_7072 = G__7089;
count__7040_7073 = G__7090;
i__7041_7074 = G__7091;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__7042_7092 = cljs.core.seq.call(null,params);
var chunk__7043_7093 = null;
var count__7044_7094 = (0);
var i__7045_7095 = (0);
while(true){
if((i__7045_7095 < count__7044_7094)){
var param_7096 = cljs.core._nth.call(null,chunk__7043_7093,i__7045_7095);
cljs.compiler.emit.call(null,param_7096);

if(cljs.core._EQ_.call(null,param_7096,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7097 = seq__7042_7092;
var G__7098 = chunk__7043_7093;
var G__7099 = count__7044_7094;
var G__7100 = (i__7045_7095 + (1));
seq__7042_7092 = G__7097;
chunk__7043_7093 = G__7098;
count__7044_7094 = G__7099;
i__7045_7095 = G__7100;
continue;
} else {
var temp__5753__auto___7101 = cljs.core.seq.call(null,seq__7042_7092);
if(temp__5753__auto___7101){
var seq__7042_7102__$1 = temp__5753__auto___7101;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7042_7102__$1)){
var c__4679__auto___7103 = cljs.core.chunk_first.call(null,seq__7042_7102__$1);
var G__7104 = cljs.core.chunk_rest.call(null,seq__7042_7102__$1);
var G__7105 = c__4679__auto___7103;
var G__7106 = cljs.core.count.call(null,c__4679__auto___7103);
var G__7107 = (0);
seq__7042_7092 = G__7104;
chunk__7043_7093 = G__7105;
count__7044_7094 = G__7106;
i__7045_7095 = G__7107;
continue;
} else {
var param_7108 = cljs.core.first.call(null,seq__7042_7102__$1);
cljs.compiler.emit.call(null,param_7108);

if(cljs.core._EQ_.call(null,param_7108,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7109 = cljs.core.next.call(null,seq__7042_7102__$1);
var G__7110 = null;
var G__7111 = (0);
var G__7112 = (0);
seq__7042_7092 = G__7109;
chunk__7043_7093 = G__7110;
count__7044_7094 = G__7111;
i__7045_7095 = G__7112;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__7113 = cljs.core.seq.call(null,params);
var chunk__7114 = null;
var count__7115 = (0);
var i__7116 = (0);
while(true){
if((i__7116 < count__7115)){
var param = cljs.core._nth.call(null,chunk__7114,i__7116);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7117 = seq__7113;
var G__7118 = chunk__7114;
var G__7119 = count__7115;
var G__7120 = (i__7116 + (1));
seq__7113 = G__7117;
chunk__7114 = G__7118;
count__7115 = G__7119;
i__7116 = G__7120;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__7113);
if(temp__5753__auto__){
var seq__7113__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7113__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__7113__$1);
var G__7121 = cljs.core.chunk_rest.call(null,seq__7113__$1);
var G__7122 = c__4679__auto__;
var G__7123 = cljs.core.count.call(null,c__4679__auto__);
var G__7124 = (0);
seq__7113 = G__7121;
chunk__7114 = G__7122;
count__7115 = G__7123;
i__7116 = G__7124;
continue;
} else {
var param = cljs.core.first.call(null,seq__7113__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7125 = cljs.core.next.call(null,seq__7113__$1);
var G__7126 = null;
var G__7127 = (0);
var G__7128 = (0);
seq__7113 = G__7125;
chunk__7114 = G__7126;
count__7115 = G__7127;
i__7116 = G__7128;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__7129){
var map__7130 = p__7129;
var map__7130__$1 = cljs.core.__destructure_map.call(null,map__7130);
var expr = cljs.core.get.call(null,map__7130__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.call(null,map__7130__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__7130__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__7130__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__7130__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__7130__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__7131){
var map__7132 = p__7131;
var map__7132__$1 = cljs.core.__destructure_map.call(null,map__7132);
var f = map__7132__$1;
var expr = cljs.core.get.call(null,map__7132__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.call(null,map__7132__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.call(null,map__7132__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.call(null,map__7132__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__7132__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__7132__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__7132__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__7132__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_7141__$1 = (function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_7142 = cljs.compiler.munge.call(null,name_7141__$1);
var delegate_name_7143 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7142),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_7143," = function (");

var seq__7133_7144 = cljs.core.seq.call(null,params);
var chunk__7134_7145 = null;
var count__7135_7146 = (0);
var i__7136_7147 = (0);
while(true){
if((i__7136_7147 < count__7135_7146)){
var param_7148 = cljs.core._nth.call(null,chunk__7134_7145,i__7136_7147);
cljs.compiler.emit.call(null,param_7148);

if(cljs.core._EQ_.call(null,param_7148,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7149 = seq__7133_7144;
var G__7150 = chunk__7134_7145;
var G__7151 = count__7135_7146;
var G__7152 = (i__7136_7147 + (1));
seq__7133_7144 = G__7149;
chunk__7134_7145 = G__7150;
count__7135_7146 = G__7151;
i__7136_7147 = G__7152;
continue;
} else {
var temp__5753__auto___7153 = cljs.core.seq.call(null,seq__7133_7144);
if(temp__5753__auto___7153){
var seq__7133_7154__$1 = temp__5753__auto___7153;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7133_7154__$1)){
var c__4679__auto___7155 = cljs.core.chunk_first.call(null,seq__7133_7154__$1);
var G__7156 = cljs.core.chunk_rest.call(null,seq__7133_7154__$1);
var G__7157 = c__4679__auto___7155;
var G__7158 = cljs.core.count.call(null,c__4679__auto___7155);
var G__7159 = (0);
seq__7133_7144 = G__7156;
chunk__7134_7145 = G__7157;
count__7135_7146 = G__7158;
i__7136_7147 = G__7159;
continue;
} else {
var param_7160 = cljs.core.first.call(null,seq__7133_7154__$1);
cljs.compiler.emit.call(null,param_7160);

if(cljs.core._EQ_.call(null,param_7160,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7161 = cljs.core.next.call(null,seq__7133_7154__$1);
var G__7162 = null;
var G__7163 = (0);
var G__7164 = (0);
seq__7133_7144 = G__7161;
chunk__7134_7145 = G__7162;
count__7135_7146 = G__7163;
i__7136_7147 = G__7164;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_7142," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_7165 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_7165,",0,null);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_7143,".call(this,");

var seq__7137_7166 = cljs.core.seq.call(null,params);
var chunk__7138_7167 = null;
var count__7139_7168 = (0);
var i__7140_7169 = (0);
while(true){
if((i__7140_7169 < count__7139_7168)){
var param_7170 = cljs.core._nth.call(null,chunk__7138_7167,i__7140_7169);
cljs.compiler.emit.call(null,param_7170);

if(cljs.core._EQ_.call(null,param_7170,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7171 = seq__7137_7166;
var G__7172 = chunk__7138_7167;
var G__7173 = count__7139_7168;
var G__7174 = (i__7140_7169 + (1));
seq__7137_7166 = G__7171;
chunk__7138_7167 = G__7172;
count__7139_7168 = G__7173;
i__7140_7169 = G__7174;
continue;
} else {
var temp__5753__auto___7175 = cljs.core.seq.call(null,seq__7137_7166);
if(temp__5753__auto___7175){
var seq__7137_7176__$1 = temp__5753__auto___7175;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7137_7176__$1)){
var c__4679__auto___7177 = cljs.core.chunk_first.call(null,seq__7137_7176__$1);
var G__7178 = cljs.core.chunk_rest.call(null,seq__7137_7176__$1);
var G__7179 = c__4679__auto___7177;
var G__7180 = cljs.core.count.call(null,c__4679__auto___7177);
var G__7181 = (0);
seq__7137_7166 = G__7178;
chunk__7138_7167 = G__7179;
count__7139_7168 = G__7180;
i__7140_7169 = G__7181;
continue;
} else {
var param_7182 = cljs.core.first.call(null,seq__7137_7176__$1);
cljs.compiler.emit.call(null,param_7182);

if(cljs.core._EQ_.call(null,param_7182,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__7183 = cljs.core.next.call(null,seq__7137_7176__$1);
var G__7184 = null;
var G__7185 = (0);
var G__7186 = (0);
seq__7137_7166 = G__7183;
chunk__7138_7167 = G__7184;
count__7139_7168 = G__7185;
i__7140_7169 = G__7186;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_7142,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_7142,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_7141__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_7142,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_7143,";");

cljs.compiler.emitln.call(null,"return ",mname_7142,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__7190){
var map__7191 = p__7190;
var map__7191__$1 = cljs.core.__destructure_map.call(null,map__7191);
var variadic = cljs.core.get.call(null,map__7191__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.call(null,map__7191__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__7191__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__7191__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__7191__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.call(null,map__7191__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.call(null,map__7191__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.call(null,map__7191__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,(function (p1__7187_SHARP_){
var and__4251__auto__ = p1__7187_SHARP_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__7187_SHARP_));
} else {
return and__4251__auto__;
}
}),recur_frames));
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,recur_params,(cljs.core.truth_((function (){var or__4253__auto__ = in_loop;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.seq.call(null,recur_params);
}
})())?cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets):null))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_7243__$1 = (function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_7244 = cljs.compiler.munge.call(null,name_7243__$1);
var maxparams_7245 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_7246 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7244),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_7247 = cljs.core.sort_by.call(null,(function (p1__7188_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__7188_SHARP_)));
}),cljs.core.seq.call(null,mmap_7246));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_7244," = null;");

var seq__7192_7248 = cljs.core.seq.call(null,ms_7247);
var chunk__7193_7249 = null;
var count__7194_7250 = (0);
var i__7195_7251 = (0);
while(true){
if((i__7195_7251 < count__7194_7250)){
var vec__7202_7252 = cljs.core._nth.call(null,chunk__7193_7249,i__7195_7251);
var n_7253 = cljs.core.nth.call(null,vec__7202_7252,(0),null);
var meth_7254 = cljs.core.nth.call(null,vec__7202_7252,(1),null);
cljs.compiler.emits.call(null,"var ",n_7253," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7254))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_7254);
} else {
cljs.compiler.emit_fn_method.call(null,meth_7254);
}

cljs.compiler.emitln.call(null,";");


var G__7255 = seq__7192_7248;
var G__7256 = chunk__7193_7249;
var G__7257 = count__7194_7250;
var G__7258 = (i__7195_7251 + (1));
seq__7192_7248 = G__7255;
chunk__7193_7249 = G__7256;
count__7194_7250 = G__7257;
i__7195_7251 = G__7258;
continue;
} else {
var temp__5753__auto___7259 = cljs.core.seq.call(null,seq__7192_7248);
if(temp__5753__auto___7259){
var seq__7192_7260__$1 = temp__5753__auto___7259;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7192_7260__$1)){
var c__4679__auto___7261 = cljs.core.chunk_first.call(null,seq__7192_7260__$1);
var G__7262 = cljs.core.chunk_rest.call(null,seq__7192_7260__$1);
var G__7263 = c__4679__auto___7261;
var G__7264 = cljs.core.count.call(null,c__4679__auto___7261);
var G__7265 = (0);
seq__7192_7248 = G__7262;
chunk__7193_7249 = G__7263;
count__7194_7250 = G__7264;
i__7195_7251 = G__7265;
continue;
} else {
var vec__7205_7266 = cljs.core.first.call(null,seq__7192_7260__$1);
var n_7267 = cljs.core.nth.call(null,vec__7205_7266,(0),null);
var meth_7268 = cljs.core.nth.call(null,vec__7205_7266,(1),null);
cljs.compiler.emits.call(null,"var ",n_7267," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7268))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_7268);
} else {
cljs.compiler.emit_fn_method.call(null,meth_7268);
}

cljs.compiler.emitln.call(null,";");


var G__7269 = cljs.core.next.call(null,seq__7192_7260__$1);
var G__7270 = null;
var G__7271 = (0);
var G__7272 = (0);
seq__7192_7248 = G__7269;
chunk__7193_7249 = G__7270;
count__7194_7250 = G__7271;
i__7195_7251 = G__7272;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_7244," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_7245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_7245)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_7245));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__7208_7273 = cljs.core.seq.call(null,ms_7247);
var chunk__7209_7274 = null;
var count__7210_7275 = (0);
var i__7211_7276 = (0);
while(true){
if((i__7211_7276 < count__7210_7275)){
var vec__7218_7277 = cljs.core._nth.call(null,chunk__7209_7274,i__7211_7276);
var n_7278 = cljs.core.nth.call(null,vec__7218_7277,(0),null);
var meth_7279 = cljs.core.nth.call(null,vec__7218_7277,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7279))){
cljs.compiler.emitln.call(null,"default:");

var restarg_7280 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_7280," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_7281 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_7280," = new cljs.core.IndexedSeq(",a_7281,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_7278,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_7245)),(((cljs.core.count.call(null,maxparams_7245) > (1)))?", ":null),restarg_7280,");");
} else {
var pcnt_7282 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7279));
cljs.compiler.emitln.call(null,"case ",pcnt_7282,":");

cljs.compiler.emitln.call(null,"return ",n_7278,".call(this",(((pcnt_7282 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_7282,maxparams_7245)),null,(1),null)),(2),null))),");");
}


var G__7283 = seq__7208_7273;
var G__7284 = chunk__7209_7274;
var G__7285 = count__7210_7275;
var G__7286 = (i__7211_7276 + (1));
seq__7208_7273 = G__7283;
chunk__7209_7274 = G__7284;
count__7210_7275 = G__7285;
i__7211_7276 = G__7286;
continue;
} else {
var temp__5753__auto___7287 = cljs.core.seq.call(null,seq__7208_7273);
if(temp__5753__auto___7287){
var seq__7208_7288__$1 = temp__5753__auto___7287;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7208_7288__$1)){
var c__4679__auto___7289 = cljs.core.chunk_first.call(null,seq__7208_7288__$1);
var G__7290 = cljs.core.chunk_rest.call(null,seq__7208_7288__$1);
var G__7291 = c__4679__auto___7289;
var G__7292 = cljs.core.count.call(null,c__4679__auto___7289);
var G__7293 = (0);
seq__7208_7273 = G__7290;
chunk__7209_7274 = G__7291;
count__7210_7275 = G__7292;
i__7211_7276 = G__7293;
continue;
} else {
var vec__7221_7294 = cljs.core.first.call(null,seq__7208_7288__$1);
var n_7295 = cljs.core.nth.call(null,vec__7221_7294,(0),null);
var meth_7296 = cljs.core.nth.call(null,vec__7221_7294,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7296))){
cljs.compiler.emitln.call(null,"default:");

var restarg_7297 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_7297," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_7298 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_7297," = new cljs.core.IndexedSeq(",a_7298,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_7295,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_7245)),(((cljs.core.count.call(null,maxparams_7245) > (1)))?", ":null),restarg_7297,");");
} else {
var pcnt_7299 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7296));
cljs.compiler.emitln.call(null,"case ",pcnt_7299,":");

cljs.compiler.emitln.call(null,"return ",n_7295,".call(this",(((pcnt_7299 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_7299,maxparams_7245)),null,(1),null)),(2),null))),");");
}


var G__7300 = cljs.core.next.call(null,seq__7208_7288__$1);
var G__7301 = null;
var G__7302 = (0);
var G__7303 = (0);
seq__7208_7273 = G__7300;
chunk__7209_7274 = G__7301;
count__7210_7275 = G__7302;
i__7211_7276 = G__7303;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

var arg_count_js_7304 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,cljs.core.first.call(null,ms_7247)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + ",arg_count_js_7304,"));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_7244,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_7244,".cljs$lang$applyTo = ",cljs.core.some.call(null,(function (p1__7189_SHARP_){
var vec__7224 = p1__7189_SHARP_;
var n = cljs.core.nth.call(null,vec__7224,(0),null);
var m = cljs.core.nth.call(null,vec__7224,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_7247),".cljs$lang$applyTo;");
} else {
}

var seq__7227_7305 = cljs.core.seq.call(null,ms_7247);
var chunk__7228_7306 = null;
var count__7229_7307 = (0);
var i__7230_7308 = (0);
while(true){
if((i__7230_7308 < count__7229_7307)){
var vec__7237_7309 = cljs.core._nth.call(null,chunk__7228_7306,i__7230_7308);
var n_7310 = cljs.core.nth.call(null,vec__7237_7309,(0),null);
var meth_7311 = cljs.core.nth.call(null,vec__7237_7309,(1),null);
var c_7312 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7311));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7311))){
cljs.compiler.emitln.call(null,mname_7244,".cljs$core$IFn$_invoke$arity$variadic = ",n_7310,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_7244,".cljs$core$IFn$_invoke$arity$",c_7312," = ",n_7310,";");
}


var G__7313 = seq__7227_7305;
var G__7314 = chunk__7228_7306;
var G__7315 = count__7229_7307;
var G__7316 = (i__7230_7308 + (1));
seq__7227_7305 = G__7313;
chunk__7228_7306 = G__7314;
count__7229_7307 = G__7315;
i__7230_7308 = G__7316;
continue;
} else {
var temp__5753__auto___7317 = cljs.core.seq.call(null,seq__7227_7305);
if(temp__5753__auto___7317){
var seq__7227_7318__$1 = temp__5753__auto___7317;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7227_7318__$1)){
var c__4679__auto___7319 = cljs.core.chunk_first.call(null,seq__7227_7318__$1);
var G__7320 = cljs.core.chunk_rest.call(null,seq__7227_7318__$1);
var G__7321 = c__4679__auto___7319;
var G__7322 = cljs.core.count.call(null,c__4679__auto___7319);
var G__7323 = (0);
seq__7227_7305 = G__7320;
chunk__7228_7306 = G__7321;
count__7229_7307 = G__7322;
i__7230_7308 = G__7323;
continue;
} else {
var vec__7240_7324 = cljs.core.first.call(null,seq__7227_7318__$1);
var n_7325 = cljs.core.nth.call(null,vec__7240_7324,(0),null);
var meth_7326 = cljs.core.nth.call(null,vec__7240_7324,(1),null);
var c_7327 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7326));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7326))){
cljs.compiler.emitln.call(null,mname_7244,".cljs$core$IFn$_invoke$arity$variadic = ",n_7325,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_7244,".cljs$core$IFn$_invoke$arity$",c_7327," = ",n_7325,";");
}


var G__7328 = cljs.core.next.call(null,seq__7227_7318__$1);
var G__7329 = null;
var G__7330 = (0);
var G__7331 = (0);
seq__7227_7305 = G__7328;
chunk__7228_7306 = G__7329;
count__7229_7307 = G__7330;
i__7230_7308 = G__7331;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_7244,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__7332){
var map__7333 = p__7332;
var map__7333__$1 = cljs.core.__destructure_map.call(null,map__7333);
var statements = cljs.core.get.call(null,map__7333__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__7333__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__7333__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__7334_7338 = cljs.core.seq.call(null,statements);
var chunk__7335_7339 = null;
var count__7336_7340 = (0);
var i__7337_7341 = (0);
while(true){
if((i__7337_7341 < count__7336_7340)){
var s_7342 = cljs.core._nth.call(null,chunk__7335_7339,i__7337_7341);
cljs.compiler.emitln.call(null,s_7342);


var G__7343 = seq__7334_7338;
var G__7344 = chunk__7335_7339;
var G__7345 = count__7336_7340;
var G__7346 = (i__7337_7341 + (1));
seq__7334_7338 = G__7343;
chunk__7335_7339 = G__7344;
count__7336_7340 = G__7345;
i__7337_7341 = G__7346;
continue;
} else {
var temp__5753__auto___7347 = cljs.core.seq.call(null,seq__7334_7338);
if(temp__5753__auto___7347){
var seq__7334_7348__$1 = temp__5753__auto___7347;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7334_7348__$1)){
var c__4679__auto___7349 = cljs.core.chunk_first.call(null,seq__7334_7348__$1);
var G__7350 = cljs.core.chunk_rest.call(null,seq__7334_7348__$1);
var G__7351 = c__4679__auto___7349;
var G__7352 = cljs.core.count.call(null,c__4679__auto___7349);
var G__7353 = (0);
seq__7334_7338 = G__7350;
chunk__7335_7339 = G__7351;
count__7336_7340 = G__7352;
i__7337_7341 = G__7353;
continue;
} else {
var s_7354 = cljs.core.first.call(null,seq__7334_7348__$1);
cljs.compiler.emitln.call(null,s_7354);


var G__7355 = cljs.core.next.call(null,seq__7334_7348__$1);
var G__7356 = null;
var G__7357 = (0);
var G__7358 = (0);
seq__7334_7338 = G__7355;
chunk__7335_7339 = G__7356;
count__7336_7340 = G__7357;
i__7337_7341 = G__7358;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__7359){
var map__7360 = p__7359;
var map__7360__$1 = cljs.core.__destructure_map.call(null,map__7360);
var try$ = cljs.core.get.call(null,map__7360__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.call(null,map__7360__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.call(null,map__7360__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__7360__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__7360__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote.call(null,finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__7361,is_loop){
var map__7362 = p__7361;
var map__7362__$1 = cljs.core.__destructure_map.call(null,map__7362);
var expr = cljs.core.get.call(null,map__7362__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__7362__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__7362__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__7363_7373 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__7364_7374 = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,(function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__7364_7374);

try{var seq__7365_7375 = cljs.core.seq.call(null,bindings);
var chunk__7366_7376 = null;
var count__7367_7377 = (0);
var i__7368_7378 = (0);
while(true){
if((i__7368_7378 < count__7367_7377)){
var map__7371_7379 = cljs.core._nth.call(null,chunk__7366_7376,i__7368_7378);
var map__7371_7380__$1 = cljs.core.__destructure_map.call(null,map__7371_7379);
var binding_7381 = map__7371_7380__$1;
var init_7382 = cljs.core.get.call(null,map__7371_7380__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_7381);

cljs.compiler.emitln.call(null," = ",init_7382,";");


var G__7383 = seq__7365_7375;
var G__7384 = chunk__7366_7376;
var G__7385 = count__7367_7377;
var G__7386 = (i__7368_7378 + (1));
seq__7365_7375 = G__7383;
chunk__7366_7376 = G__7384;
count__7367_7377 = G__7385;
i__7368_7378 = G__7386;
continue;
} else {
var temp__5753__auto___7387 = cljs.core.seq.call(null,seq__7365_7375);
if(temp__5753__auto___7387){
var seq__7365_7388__$1 = temp__5753__auto___7387;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7365_7388__$1)){
var c__4679__auto___7389 = cljs.core.chunk_first.call(null,seq__7365_7388__$1);
var G__7390 = cljs.core.chunk_rest.call(null,seq__7365_7388__$1);
var G__7391 = c__4679__auto___7389;
var G__7392 = cljs.core.count.call(null,c__4679__auto___7389);
var G__7393 = (0);
seq__7365_7375 = G__7390;
chunk__7366_7376 = G__7391;
count__7367_7377 = G__7392;
i__7368_7378 = G__7393;
continue;
} else {
var map__7372_7394 = cljs.core.first.call(null,seq__7365_7388__$1);
var map__7372_7395__$1 = cljs.core.__destructure_map.call(null,map__7372_7394);
var binding_7396 = map__7372_7395__$1;
var init_7397 = cljs.core.get.call(null,map__7372_7395__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_7396);

cljs.compiler.emitln.call(null," = ",init_7397,";");


var G__7398 = cljs.core.next.call(null,seq__7365_7388__$1);
var G__7399 = null;
var G__7400 = (0);
var G__7401 = (0);
seq__7365_7375 = G__7398;
chunk__7366_7376 = G__7399;
count__7367_7377 = G__7400;
i__7368_7378 = G__7401;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__7363_7373);
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__7402){
var map__7403 = p__7402;
var map__7403__$1 = cljs.core.__destructure_map.call(null,map__7403);
var frame = cljs.core.get.call(null,map__7403__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__7403__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__7403__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4741__auto___7404 = cljs.core.count.call(null,exprs);
var i_7405 = (0);
while(true){
if((i_7405 < n__4741__auto___7404)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_7405)," = ",exprs.call(null,i_7405),";");

var G__7406 = (i_7405 + (1));
i_7405 = G__7406;
continue;
} else {
}
break;
}

var n__4741__auto___7407 = cljs.core.count.call(null,exprs);
var i_7408 = (0);
while(true){
if((i_7408 < n__4741__auto___7407)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_7408))," = ",temps.call(null,i_7408),";");

var G__7409 = (i_7408 + (1));
i_7408 = G__7409;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__7410){
var map__7411 = p__7410;
var map__7411__$1 = cljs.core.__destructure_map.call(null,map__7411);
var expr = cljs.core.get.call(null,map__7411__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__7411__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__7411__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__7412_7420 = cljs.core.seq.call(null,bindings);
var chunk__7413_7421 = null;
var count__7414_7422 = (0);
var i__7415_7423 = (0);
while(true){
if((i__7415_7423 < count__7414_7422)){
var map__7418_7424 = cljs.core._nth.call(null,chunk__7413_7421,i__7415_7423);
var map__7418_7425__$1 = cljs.core.__destructure_map.call(null,map__7418_7424);
var binding_7426 = map__7418_7425__$1;
var init_7427 = cljs.core.get.call(null,map__7418_7425__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_7426)," = ",init_7427,";");


var G__7428 = seq__7412_7420;
var G__7429 = chunk__7413_7421;
var G__7430 = count__7414_7422;
var G__7431 = (i__7415_7423 + (1));
seq__7412_7420 = G__7428;
chunk__7413_7421 = G__7429;
count__7414_7422 = G__7430;
i__7415_7423 = G__7431;
continue;
} else {
var temp__5753__auto___7432 = cljs.core.seq.call(null,seq__7412_7420);
if(temp__5753__auto___7432){
var seq__7412_7433__$1 = temp__5753__auto___7432;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7412_7433__$1)){
var c__4679__auto___7434 = cljs.core.chunk_first.call(null,seq__7412_7433__$1);
var G__7435 = cljs.core.chunk_rest.call(null,seq__7412_7433__$1);
var G__7436 = c__4679__auto___7434;
var G__7437 = cljs.core.count.call(null,c__4679__auto___7434);
var G__7438 = (0);
seq__7412_7420 = G__7435;
chunk__7413_7421 = G__7436;
count__7414_7422 = G__7437;
i__7415_7423 = G__7438;
continue;
} else {
var map__7419_7439 = cljs.core.first.call(null,seq__7412_7433__$1);
var map__7419_7440__$1 = cljs.core.__destructure_map.call(null,map__7419_7439);
var binding_7441 = map__7419_7440__$1;
var init_7442 = cljs.core.get.call(null,map__7419_7440__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_7441)," = ",init_7442,";");


var G__7443 = cljs.core.next.call(null,seq__7412_7433__$1);
var G__7444 = null;
var G__7445 = (0);
var G__7446 = (0);
seq__7412_7420 = G__7443;
chunk__7413_7421 = G__7444;
count__7414_7422 = G__7445;
i__7415_7423 = G__7446;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__7449){
var map__7450 = p__7449;
var map__7450__$1 = cljs.core.__destructure_map.call(null,map__7450);
var expr = map__7450__$1;
var f = cljs.core.get.call(null,map__7450__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.call(null,map__7450__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7450__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4251__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__4251__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4251__auto__ = protocol;
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = tag;
if(cljs.core.truth_(and__4251__auto____$1)){
var or__4253__auto__ = (function (){var and__4251__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = protocol;
if(cljs.core.truth_(and__4251__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto____$2 = (function (){var or__4253__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4251__auto____$2)){
var or__4253__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__4253__auto____$1){
return or__4253__auto____$1;
} else {
var and__4251__auto____$3 = (!(cljs.core.set_QMARK_.call(null,tag)));
if(and__4251__auto____$3){
var and__4251__auto____$4 = cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null).call(null,tag));
if(and__4251__auto____$4){
var temp__5753__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,env,cljs.core.vary_meta.call(null,tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
}
} else {
return and__4251__auto____$2;
}
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null).call(null,first_arg_tag))));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag.call(null,env,f);
var js_QMARK_ = (function (){var or__4253__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4253__auto____$1){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4253__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split.call(null,ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4253__auto__ = cljs.core._EQ_.call(null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4253__auto__){
return or__4253__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote.call(null,f);
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__7451 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return (arity > mfa);
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7447_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__7447_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7448_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__7448_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__7451,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__7451,(1),null);
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"(!(",cljs.core.first.call(null,args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.call(null,"((",cljs.core.first.call(null,args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_7454 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_7454,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_7455 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_7455,args)),(((mfa_7455 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_7455,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1));
} else {
return and__4251__auto__;
}
})())){
var fprop_7456 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.call(null,"(",f__$1,fprop_7456," ? ",f__$1,fprop_7456,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,"(",cljs.compiler.comma_sep.call(null,args),"))");
} else {
cljs.compiler.emits.call(null,"(",f__$1,fprop_7456," ? ",f__$1,fprop_7456,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
}
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__7457){
var map__7458 = p__7457;
var map__7458__$1 = cljs.core.__destructure_map.call(null,map__7458);
var ctor = cljs.core.get.call(null,map__7458__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.call(null,map__7458__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7458__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__7459){
var map__7460 = p__7459;
var map__7460__$1 = cljs.core.__destructure_map.call(null,map__7460);
var target = cljs.core.get.call(null,map__7460__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__7460__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__7460__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(",target," = ",val,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.call(null,sublib,/\./);
return cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (p1__7461_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__7461_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__7462 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__7462,(0),null);
var sublib = cljs.core.nth.call(null,vec__7462,(1),null);
return cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib)," = goog.global",cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.call(null,cljs.core.name.call(null,(function (){var or__4253__auto__ = cljs.core.get.call(null,global_exports,cljs.core.symbol.call(null,lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.call(null,global_exports,cljs.core.name.call(null,lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.compiler.sublib_select.call(null,sublib),";");
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__7465 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__7465__$1 = cljs.core.__destructure_map.call(null,map__7465);
var options = cljs.core.get.call(null,map__7465__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.call(null,map__7465__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__7466 = options;
var map__7466__$1 = cljs.core.__destructure_map.call(null,map__7466);
var target = cljs.core.get.call(null,map__7466__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.call(null,map__7466__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.call(null,map__7466__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__7467 = (function (){var libs__$1 = cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.filter.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,libs)),deps));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__7473 = cljs.core.group_by.call(null,cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__7473__$1 = cljs.core.__destructure_map.call(null,map__7473);
var node_libs = cljs.core.get.call(null,map__7473__$1,true);
var libs_to_load = cljs.core.get.call(null,map__7473__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.call(null,vec__7467,(0),null);
var libs_to_load = cljs.core.nth.call(null,vec__7467,(1),null);
var vec__7470 = (function (){var map__7474 = cljs.core.group_by.call(null,cljs.analyzer.goog_module_dep_QMARK_,libs_to_load);
var map__7474__$1 = cljs.core.__destructure_map.call(null,map__7474);
var goog_modules = cljs.core.get.call(null,map__7474__$1,true);
var libs_to_load__$1 = cljs.core.get.call(null,map__7474__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goog_modules,libs_to_load__$1], null);
})();
var goog_modules = cljs.core.nth.call(null,vec__7470,(0),null);
var libs_to_load__$1 = cljs.core.nth.call(null,vec__7470,(1),null);
var global_exports_libs = cljs.core.filter.call(null,cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load__$1);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__7475_7519 = cljs.core.seq.call(null,libs_to_load__$1);
var chunk__7476_7520 = null;
var count__7477_7521 = (0);
var i__7478_7522 = (0);
while(true){
if((i__7478_7522 < count__7477_7521)){
var lib_7523 = cljs.core._nth.call(null,chunk__7476_7520,i__7478_7522);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_7523)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7523),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7523),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7523),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7523),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_7523,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7523),"');");
}

}
}
}


var G__7524 = seq__7475_7519;
var G__7525 = chunk__7476_7520;
var G__7526 = count__7477_7521;
var G__7527 = (i__7478_7522 + (1));
seq__7475_7519 = G__7524;
chunk__7476_7520 = G__7525;
count__7477_7521 = G__7526;
i__7478_7522 = G__7527;
continue;
} else {
var temp__5753__auto___7528 = cljs.core.seq.call(null,seq__7475_7519);
if(temp__5753__auto___7528){
var seq__7475_7529__$1 = temp__5753__auto___7528;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7475_7529__$1)){
var c__4679__auto___7530 = cljs.core.chunk_first.call(null,seq__7475_7529__$1);
var G__7531 = cljs.core.chunk_rest.call(null,seq__7475_7529__$1);
var G__7532 = c__4679__auto___7530;
var G__7533 = cljs.core.count.call(null,c__4679__auto___7530);
var G__7534 = (0);
seq__7475_7519 = G__7531;
chunk__7476_7520 = G__7532;
count__7477_7521 = G__7533;
i__7478_7522 = G__7534;
continue;
} else {
var lib_7535 = cljs.core.first.call(null,seq__7475_7529__$1);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_7535)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7535),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7535),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_7535),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7535),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_7535,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_7535),"');");
}

}
}
}


var G__7536 = cljs.core.next.call(null,seq__7475_7529__$1);
var G__7537 = null;
var G__7538 = (0);
var G__7539 = (0);
seq__7475_7519 = G__7536;
chunk__7476_7520 = G__7537;
count__7477_7521 = G__7538;
i__7478_7522 = G__7539;
continue;
}
} else {
}
}
break;
}

var seq__7479_7540 = cljs.core.seq.call(null,node_libs);
var chunk__7480_7541 = null;
var count__7481_7542 = (0);
var i__7482_7543 = (0);
while(true){
if((i__7482_7543 < count__7481_7542)){
var lib_7544 = cljs.core._nth.call(null,chunk__7480_7541,i__7482_7543);
var vec__7489_7545 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7544);
var lib_SINGLEQUOTE__7546 = cljs.core.nth.call(null,vec__7489_7545,(0),null);
var sublib_7547 = cljs.core.nth.call(null,vec__7489_7545,(1),null);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_7544)," = require('",lib_SINGLEQUOTE__7546,"')",cljs.compiler.sublib_select.call(null,sublib_7547),";");


var G__7548 = seq__7479_7540;
var G__7549 = chunk__7480_7541;
var G__7550 = count__7481_7542;
var G__7551 = (i__7482_7543 + (1));
seq__7479_7540 = G__7548;
chunk__7480_7541 = G__7549;
count__7481_7542 = G__7550;
i__7482_7543 = G__7551;
continue;
} else {
var temp__5753__auto___7552 = cljs.core.seq.call(null,seq__7479_7540);
if(temp__5753__auto___7552){
var seq__7479_7553__$1 = temp__5753__auto___7552;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7479_7553__$1)){
var c__4679__auto___7554 = cljs.core.chunk_first.call(null,seq__7479_7553__$1);
var G__7555 = cljs.core.chunk_rest.call(null,seq__7479_7553__$1);
var G__7556 = c__4679__auto___7554;
var G__7557 = cljs.core.count.call(null,c__4679__auto___7554);
var G__7558 = (0);
seq__7479_7540 = G__7555;
chunk__7480_7541 = G__7556;
count__7481_7542 = G__7557;
i__7482_7543 = G__7558;
continue;
} else {
var lib_7559 = cljs.core.first.call(null,seq__7479_7553__$1);
var vec__7492_7560 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7559);
var lib_SINGLEQUOTE__7561 = cljs.core.nth.call(null,vec__7492_7560,(0),null);
var sublib_7562 = cljs.core.nth.call(null,vec__7492_7560,(1),null);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_7559)," = require('",lib_SINGLEQUOTE__7561,"')",cljs.compiler.sublib_select.call(null,sublib_7562),";");


var G__7563 = cljs.core.next.call(null,seq__7479_7553__$1);
var G__7564 = null;
var G__7565 = (0);
var G__7566 = (0);
seq__7479_7540 = G__7563;
chunk__7480_7541 = G__7564;
count__7481_7542 = G__7565;
i__7482_7543 = G__7566;
continue;
}
} else {
}
}
break;
}

var seq__7495_7567 = cljs.core.seq.call(null,goog_modules);
var chunk__7496_7568 = null;
var count__7497_7569 = (0);
var i__7498_7570 = (0);
while(true){
if((i__7498_7570 < count__7497_7569)){
var lib_7571 = cljs.core._nth.call(null,chunk__7496_7568,i__7498_7570);
var vec__7505_7572 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7571);
var lib_SINGLEQUOTE__7573 = cljs.core.nth.call(null,vec__7505_7572,(0),null);
var sublib_7574 = cljs.core.nth.call(null,vec__7505_7572,(1),null);
cljs.compiler.emitln.call(null,"goog.require('",lib_SINGLEQUOTE__7573,"');");

cljs.compiler.emitln.call(null,"goog.scope(function(){");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_goog_module_lib.call(null,lib_7571)," = goog.module.get('",lib_SINGLEQUOTE__7573,"')",cljs.compiler.sublib_select.call(null,sublib_7574),";");

cljs.compiler.emitln.call(null,"});");


var G__7575 = seq__7495_7567;
var G__7576 = chunk__7496_7568;
var G__7577 = count__7497_7569;
var G__7578 = (i__7498_7570 + (1));
seq__7495_7567 = G__7575;
chunk__7496_7568 = G__7576;
count__7497_7569 = G__7577;
i__7498_7570 = G__7578;
continue;
} else {
var temp__5753__auto___7579 = cljs.core.seq.call(null,seq__7495_7567);
if(temp__5753__auto___7579){
var seq__7495_7580__$1 = temp__5753__auto___7579;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7495_7580__$1)){
var c__4679__auto___7581 = cljs.core.chunk_first.call(null,seq__7495_7580__$1);
var G__7582 = cljs.core.chunk_rest.call(null,seq__7495_7580__$1);
var G__7583 = c__4679__auto___7581;
var G__7584 = cljs.core.count.call(null,c__4679__auto___7581);
var G__7585 = (0);
seq__7495_7567 = G__7582;
chunk__7496_7568 = G__7583;
count__7497_7569 = G__7584;
i__7498_7570 = G__7585;
continue;
} else {
var lib_7586 = cljs.core.first.call(null,seq__7495_7580__$1);
var vec__7508_7587 = cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7586);
var lib_SINGLEQUOTE__7588 = cljs.core.nth.call(null,vec__7508_7587,(0),null);
var sublib_7589 = cljs.core.nth.call(null,vec__7508_7587,(1),null);
cljs.compiler.emitln.call(null,"goog.require('",lib_SINGLEQUOTE__7588,"');");

cljs.compiler.emitln.call(null,"goog.scope(function(){");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_goog_module_lib.call(null,lib_7586)," = goog.module.get('",lib_SINGLEQUOTE__7588,"')",cljs.compiler.sublib_select.call(null,sublib_7589),";");

cljs.compiler.emitln.call(null,"});");


var G__7590 = cljs.core.next.call(null,seq__7495_7580__$1);
var G__7591 = null;
var G__7592 = (0);
var G__7593 = (0);
seq__7495_7567 = G__7590;
chunk__7496_7568 = G__7591;
count__7497_7569 = G__7592;
i__7498_7570 = G__7593;
continue;
}
} else {
}
}
break;
}

var seq__7511_7594 = cljs.core.seq.call(null,global_exports_libs);
var chunk__7512_7595 = null;
var count__7513_7596 = (0);
var i__7514_7597 = (0);
while(true){
if((i__7514_7597 < count__7513_7596)){
var lib_7598 = cljs.core._nth.call(null,chunk__7512_7595,i__7514_7597);
var map__7517_7599 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,cljs.core.first.call(null,cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7598))));
var map__7517_7600__$1 = cljs.core.__destructure_map.call(null,map__7517_7599);
var global_exports_7601 = cljs.core.get.call(null,map__7517_7600__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_7601,lib_7598);


var G__7602 = seq__7511_7594;
var G__7603 = chunk__7512_7595;
var G__7604 = count__7513_7596;
var G__7605 = (i__7514_7597 + (1));
seq__7511_7594 = G__7602;
chunk__7512_7595 = G__7603;
count__7513_7596 = G__7604;
i__7514_7597 = G__7605;
continue;
} else {
var temp__5753__auto___7606 = cljs.core.seq.call(null,seq__7511_7594);
if(temp__5753__auto___7606){
var seq__7511_7607__$1 = temp__5753__auto___7606;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7511_7607__$1)){
var c__4679__auto___7608 = cljs.core.chunk_first.call(null,seq__7511_7607__$1);
var G__7609 = cljs.core.chunk_rest.call(null,seq__7511_7607__$1);
var G__7610 = c__4679__auto___7608;
var G__7611 = cljs.core.count.call(null,c__4679__auto___7608);
var G__7612 = (0);
seq__7511_7594 = G__7609;
chunk__7512_7595 = G__7610;
count__7513_7596 = G__7611;
i__7514_7597 = G__7612;
continue;
} else {
var lib_7613 = cljs.core.first.call(null,seq__7511_7607__$1);
var map__7518_7614 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,cljs.core.first.call(null,cljs.analyzer.lib_AMPERSAND_sublib.call(null,lib_7613))));
var map__7518_7615__$1 = cljs.core.__destructure_map.call(null,map__7518_7614);
var global_exports_7616 = cljs.core.get.call(null,map__7518_7615__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_7616,lib_7613);


var G__7617 = cljs.core.next.call(null,seq__7511_7607__$1);
var G__7618 = null;
var G__7619 = (0);
var G__7620 = (0);
seq__7511_7594 = G__7617;
chunk__7512_7595 = G__7618;
count__7513_7596 = G__7619;
i__7514_7597 = G__7620;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__7621){
var map__7622 = p__7621;
var map__7622__$1 = cljs.core.__destructure_map.call(null,map__7622);
var name = cljs.core.get.call(null,map__7622__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__7622__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__7622__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__7622__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__7622__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__7622__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__7622__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"'nil';");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__7623){
var map__7624 = p__7623;
var map__7624__$1 = cljs.core.__destructure_map.call(null,map__7624);
var name = cljs.core.get.call(null,map__7624__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__7624__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__7624__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__7624__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__7624__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__7624__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__7624__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__7625){
var map__7626 = p__7625;
var map__7626__$1 = cljs.core.__destructure_map.call(null,map__7626);
var t = cljs.core.get.call(null,map__7626__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__7626__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__7626__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__7626__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__7626__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__7627_7651 = cljs.core.seq.call(null,protocols);
var chunk__7628_7652 = null;
var count__7629_7653 = (0);
var i__7630_7654 = (0);
while(true){
if((i__7630_7654 < count__7629_7653)){
var protocol_7655 = cljs.core._nth.call(null,chunk__7628_7652,i__7630_7654);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7655)),"}");


var G__7656 = seq__7627_7651;
var G__7657 = chunk__7628_7652;
var G__7658 = count__7629_7653;
var G__7659 = (i__7630_7654 + (1));
seq__7627_7651 = G__7656;
chunk__7628_7652 = G__7657;
count__7629_7653 = G__7658;
i__7630_7654 = G__7659;
continue;
} else {
var temp__5753__auto___7660 = cljs.core.seq.call(null,seq__7627_7651);
if(temp__5753__auto___7660){
var seq__7627_7661__$1 = temp__5753__auto___7660;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7627_7661__$1)){
var c__4679__auto___7662 = cljs.core.chunk_first.call(null,seq__7627_7661__$1);
var G__7663 = cljs.core.chunk_rest.call(null,seq__7627_7661__$1);
var G__7664 = c__4679__auto___7662;
var G__7665 = cljs.core.count.call(null,c__4679__auto___7662);
var G__7666 = (0);
seq__7627_7651 = G__7663;
chunk__7628_7652 = G__7664;
count__7629_7653 = G__7665;
i__7630_7654 = G__7666;
continue;
} else {
var protocol_7667 = cljs.core.first.call(null,seq__7627_7661__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7667)),"}");


var G__7668 = cljs.core.next.call(null,seq__7627_7661__$1);
var G__7669 = null;
var G__7670 = (0);
var G__7671 = (0);
seq__7627_7651 = G__7668;
chunk__7628_7652 = G__7669;
count__7629_7653 = G__7670;
i__7630_7654 = G__7671;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__7631_7672 = cljs.core.seq.call(null,fields__$1);
var chunk__7632_7673 = null;
var count__7633_7674 = (0);
var i__7634_7675 = (0);
while(true){
if((i__7634_7675 < count__7633_7674)){
var fld_7676 = cljs.core._nth.call(null,chunk__7632_7673,i__7634_7675);
cljs.compiler.emitln.call(null,"this.",fld_7676," = ",fld_7676,";");


var G__7677 = seq__7631_7672;
var G__7678 = chunk__7632_7673;
var G__7679 = count__7633_7674;
var G__7680 = (i__7634_7675 + (1));
seq__7631_7672 = G__7677;
chunk__7632_7673 = G__7678;
count__7633_7674 = G__7679;
i__7634_7675 = G__7680;
continue;
} else {
var temp__5753__auto___7681 = cljs.core.seq.call(null,seq__7631_7672);
if(temp__5753__auto___7681){
var seq__7631_7682__$1 = temp__5753__auto___7681;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7631_7682__$1)){
var c__4679__auto___7683 = cljs.core.chunk_first.call(null,seq__7631_7682__$1);
var G__7684 = cljs.core.chunk_rest.call(null,seq__7631_7682__$1);
var G__7685 = c__4679__auto___7683;
var G__7686 = cljs.core.count.call(null,c__4679__auto___7683);
var G__7687 = (0);
seq__7631_7672 = G__7684;
chunk__7632_7673 = G__7685;
count__7633_7674 = G__7686;
i__7634_7675 = G__7687;
continue;
} else {
var fld_7688 = cljs.core.first.call(null,seq__7631_7682__$1);
cljs.compiler.emitln.call(null,"this.",fld_7688," = ",fld_7688,";");


var G__7689 = cljs.core.next.call(null,seq__7631_7682__$1);
var G__7690 = null;
var G__7691 = (0);
var G__7692 = (0);
seq__7631_7672 = G__7689;
chunk__7632_7673 = G__7690;
count__7633_7674 = G__7691;
i__7634_7675 = G__7692;
continue;
}
} else {
}
}
break;
}

var seq__7635_7693 = cljs.core.seq.call(null,pmasks);
var chunk__7636_7694 = null;
var count__7637_7695 = (0);
var i__7638_7696 = (0);
while(true){
if((i__7638_7696 < count__7637_7695)){
var vec__7645_7697 = cljs.core._nth.call(null,chunk__7636_7694,i__7638_7696);
var pno_7698 = cljs.core.nth.call(null,vec__7645_7697,(0),null);
var pmask_7699 = cljs.core.nth.call(null,vec__7645_7697,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7698,"$ = ",pmask_7699,";");


var G__7700 = seq__7635_7693;
var G__7701 = chunk__7636_7694;
var G__7702 = count__7637_7695;
var G__7703 = (i__7638_7696 + (1));
seq__7635_7693 = G__7700;
chunk__7636_7694 = G__7701;
count__7637_7695 = G__7702;
i__7638_7696 = G__7703;
continue;
} else {
var temp__5753__auto___7704 = cljs.core.seq.call(null,seq__7635_7693);
if(temp__5753__auto___7704){
var seq__7635_7705__$1 = temp__5753__auto___7704;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7635_7705__$1)){
var c__4679__auto___7706 = cljs.core.chunk_first.call(null,seq__7635_7705__$1);
var G__7707 = cljs.core.chunk_rest.call(null,seq__7635_7705__$1);
var G__7708 = c__4679__auto___7706;
var G__7709 = cljs.core.count.call(null,c__4679__auto___7706);
var G__7710 = (0);
seq__7635_7693 = G__7707;
chunk__7636_7694 = G__7708;
count__7637_7695 = G__7709;
i__7638_7696 = G__7710;
continue;
} else {
var vec__7648_7711 = cljs.core.first.call(null,seq__7635_7705__$1);
var pno_7712 = cljs.core.nth.call(null,vec__7648_7711,(0),null);
var pmask_7713 = cljs.core.nth.call(null,vec__7648_7711,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7712,"$ = ",pmask_7713,";");


var G__7714 = cljs.core.next.call(null,seq__7635_7705__$1);
var G__7715 = null;
var G__7716 = (0);
var G__7717 = (0);
seq__7635_7693 = G__7714;
chunk__7636_7694 = G__7715;
count__7637_7695 = G__7716;
i__7638_7696 = G__7717;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__7718){
var map__7719 = p__7718;
var map__7719__$1 = cljs.core.__destructure_map.call(null,map__7719);
var t = cljs.core.get.call(null,map__7719__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__7719__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__7719__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__7719__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__7719__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__7720_7744 = cljs.core.seq.call(null,protocols);
var chunk__7721_7745 = null;
var count__7722_7746 = (0);
var i__7723_7747 = (0);
while(true){
if((i__7723_7747 < count__7722_7746)){
var protocol_7748 = cljs.core._nth.call(null,chunk__7721_7745,i__7723_7747);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7748)),"}");


var G__7749 = seq__7720_7744;
var G__7750 = chunk__7721_7745;
var G__7751 = count__7722_7746;
var G__7752 = (i__7723_7747 + (1));
seq__7720_7744 = G__7749;
chunk__7721_7745 = G__7750;
count__7722_7746 = G__7751;
i__7723_7747 = G__7752;
continue;
} else {
var temp__5753__auto___7753 = cljs.core.seq.call(null,seq__7720_7744);
if(temp__5753__auto___7753){
var seq__7720_7754__$1 = temp__5753__auto___7753;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7720_7754__$1)){
var c__4679__auto___7755 = cljs.core.chunk_first.call(null,seq__7720_7754__$1);
var G__7756 = cljs.core.chunk_rest.call(null,seq__7720_7754__$1);
var G__7757 = c__4679__auto___7755;
var G__7758 = cljs.core.count.call(null,c__4679__auto___7755);
var G__7759 = (0);
seq__7720_7744 = G__7756;
chunk__7721_7745 = G__7757;
count__7722_7746 = G__7758;
i__7723_7747 = G__7759;
continue;
} else {
var protocol_7760 = cljs.core.first.call(null,seq__7720_7754__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7760)),"}");


var G__7761 = cljs.core.next.call(null,seq__7720_7754__$1);
var G__7762 = null;
var G__7763 = (0);
var G__7764 = (0);
seq__7720_7744 = G__7761;
chunk__7721_7745 = G__7762;
count__7722_7746 = G__7763;
i__7723_7747 = G__7764;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__7724_7765 = cljs.core.seq.call(null,fields__$1);
var chunk__7725_7766 = null;
var count__7726_7767 = (0);
var i__7727_7768 = (0);
while(true){
if((i__7727_7768 < count__7726_7767)){
var fld_7769 = cljs.core._nth.call(null,chunk__7725_7766,i__7727_7768);
cljs.compiler.emitln.call(null,"this.",fld_7769," = ",fld_7769,";");


var G__7770 = seq__7724_7765;
var G__7771 = chunk__7725_7766;
var G__7772 = count__7726_7767;
var G__7773 = (i__7727_7768 + (1));
seq__7724_7765 = G__7770;
chunk__7725_7766 = G__7771;
count__7726_7767 = G__7772;
i__7727_7768 = G__7773;
continue;
} else {
var temp__5753__auto___7774 = cljs.core.seq.call(null,seq__7724_7765);
if(temp__5753__auto___7774){
var seq__7724_7775__$1 = temp__5753__auto___7774;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7724_7775__$1)){
var c__4679__auto___7776 = cljs.core.chunk_first.call(null,seq__7724_7775__$1);
var G__7777 = cljs.core.chunk_rest.call(null,seq__7724_7775__$1);
var G__7778 = c__4679__auto___7776;
var G__7779 = cljs.core.count.call(null,c__4679__auto___7776);
var G__7780 = (0);
seq__7724_7765 = G__7777;
chunk__7725_7766 = G__7778;
count__7726_7767 = G__7779;
i__7727_7768 = G__7780;
continue;
} else {
var fld_7781 = cljs.core.first.call(null,seq__7724_7775__$1);
cljs.compiler.emitln.call(null,"this.",fld_7781," = ",fld_7781,";");


var G__7782 = cljs.core.next.call(null,seq__7724_7775__$1);
var G__7783 = null;
var G__7784 = (0);
var G__7785 = (0);
seq__7724_7765 = G__7782;
chunk__7725_7766 = G__7783;
count__7726_7767 = G__7784;
i__7727_7768 = G__7785;
continue;
}
} else {
}
}
break;
}

var seq__7728_7786 = cljs.core.seq.call(null,pmasks);
var chunk__7729_7787 = null;
var count__7730_7788 = (0);
var i__7731_7789 = (0);
while(true){
if((i__7731_7789 < count__7730_7788)){
var vec__7738_7790 = cljs.core._nth.call(null,chunk__7729_7787,i__7731_7789);
var pno_7791 = cljs.core.nth.call(null,vec__7738_7790,(0),null);
var pmask_7792 = cljs.core.nth.call(null,vec__7738_7790,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7791,"$ = ",pmask_7792,";");


var G__7793 = seq__7728_7786;
var G__7794 = chunk__7729_7787;
var G__7795 = count__7730_7788;
var G__7796 = (i__7731_7789 + (1));
seq__7728_7786 = G__7793;
chunk__7729_7787 = G__7794;
count__7730_7788 = G__7795;
i__7731_7789 = G__7796;
continue;
} else {
var temp__5753__auto___7797 = cljs.core.seq.call(null,seq__7728_7786);
if(temp__5753__auto___7797){
var seq__7728_7798__$1 = temp__5753__auto___7797;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7728_7798__$1)){
var c__4679__auto___7799 = cljs.core.chunk_first.call(null,seq__7728_7798__$1);
var G__7800 = cljs.core.chunk_rest.call(null,seq__7728_7798__$1);
var G__7801 = c__4679__auto___7799;
var G__7802 = cljs.core.count.call(null,c__4679__auto___7799);
var G__7803 = (0);
seq__7728_7786 = G__7800;
chunk__7729_7787 = G__7801;
count__7730_7788 = G__7802;
i__7731_7789 = G__7803;
continue;
} else {
var vec__7741_7804 = cljs.core.first.call(null,seq__7728_7798__$1);
var pno_7805 = cljs.core.nth.call(null,vec__7741_7804,(0),null);
var pmask_7806 = cljs.core.nth.call(null,vec__7741_7804,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7805,"$ = ",pmask_7806,";");


var G__7807 = cljs.core.next.call(null,seq__7728_7798__$1);
var G__7808 = null;
var G__7809 = (0);
var G__7810 = (0);
seq__7728_7786 = G__7807;
chunk__7729_7787 = G__7808;
count__7730_7788 = G__7809;
i__7731_7789 = G__7810;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__7811){
var map__7812 = p__7811;
var map__7812__$1 = cljs.core.__destructure_map.call(null,map__7812);
var target = cljs.core.get.call(null,map__7812__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__7812__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__7812__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__7812__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7812__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__7813){
var map__7814 = p__7813;
var map__7814__$1 = cljs.core.__destructure_map.call(null,map__7814);
var op = cljs.core.get.call(null,map__7814__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__7814__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__7814__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__7814__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__7814__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4251__auto__ = code;
if(cljs.core.truth_(and__4251__auto__)){
return goog.string.startsWith(clojure.string.trim.call(null,code),"/*");
} else {
return and__4251__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__6606__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6606__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

var seq__7819 = cljs.core.seq.call(null,table);
var chunk__7820 = null;
var count__7821 = (0);
var i__7822 = (0);
while(true){
if((i__7822 < count__7821)){
var vec__7829 = cljs.core._nth.call(null,chunk__7820,i__7822);
var sym = cljs.core.nth.call(null,vec__7829,(0),null);
var value = cljs.core.nth.call(null,vec__7829,(1),null);
var ns_7835 = cljs.core.namespace.call(null,sym);
var name_7836 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__7837 = seq__7819;
var G__7838 = chunk__7820;
var G__7839 = count__7821;
var G__7840 = (i__7822 + (1));
seq__7819 = G__7837;
chunk__7820 = G__7838;
count__7821 = G__7839;
i__7822 = G__7840;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__7819);
if(temp__5753__auto__){
var seq__7819__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7819__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__7819__$1);
var G__7841 = cljs.core.chunk_rest.call(null,seq__7819__$1);
var G__7842 = c__4679__auto__;
var G__7843 = cljs.core.count.call(null,c__4679__auto__);
var G__7844 = (0);
seq__7819 = G__7841;
chunk__7820 = G__7842;
count__7821 = G__7843;
i__7822 = G__7844;
continue;
} else {
var vec__7832 = cljs.core.first.call(null,seq__7819__$1);
var sym = cljs.core.nth.call(null,vec__7832,(0),null);
var value = cljs.core.nth.call(null,vec__7832,(1),null);
var ns_7845 = cljs.core.namespace.call(null,sym);
var name_7846 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__7847 = cljs.core.next.call(null,seq__7819__$1);
var G__7848 = null;
var G__7849 = (0);
var G__7850 = (0);
seq__7819 = G__7847;
chunk__7820 = G__7848;
count__7821 = G__7849;
i__7822 = G__7850;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__7852 = arguments.length;
switch (G__7852) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.call(null,cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs.call(null):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq.call(null,cljs.core.keys.call(null,externs));
while(true){
if(ks){
var k_7857 = cljs.core.first.call(null,ks);
var vec__7853_7858 = cljs.core.conj.call(null,prefix,k_7857);
var top_7859 = cljs.core.nth.call(null,vec__7853_7858,(0),null);
var prefix_SINGLEQUOTE__7860 = vec__7853_7858;
if(((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_7857)) && ((cljs.core.get_in.call(null,known_externs,prefix_SINGLEQUOTE__7860) == null)))){
if((!(((cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,top_level),top_7859)) || (cljs.core.contains_QMARK_.call(null,known_externs,top_7859)))))){
cljs.compiler.emitln.call(null,"var ",clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__7860)),";");

cljs.core.swap_BANG_.call(null,top_level,cljs.core.conj,top_7859);
} else {
cljs.compiler.emitln.call(null,clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__7860)),";");
}
} else {
}

var m_7861 = cljs.core.get.call(null,externs,k_7857);
if(cljs.core.empty_QMARK_.call(null,m_7861)){
} else {
cljs.compiler.emit_externs.call(null,prefix_SINGLEQUOTE__7860,m_7861,top_level,known_externs);
}

var G__7862 = cljs.core.next.call(null,ks);
ks = G__7862;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

