// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k26518,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__26522 = k26518;
var G__26522__$1 = (((G__26522 instanceof cljs.core.Keyword))?G__26522.fqn:null);
switch (G__26522__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26518,else__4505__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__26523){
var vec__26524 = p__26523;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26524,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26524,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26517){
var self__ = this;
var G__26517__$1 = this;
return (new cljs.core.RecordIter((0),G__26517__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__26527 = (function (coll__4499__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__26527(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26519,other26520){
var self__ = this;
var this26519__$1 = this;
return (((!((other26520 == null)))) && ((((this26519__$1.constructor === other26520.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26519__$1.conn,other26520.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26519__$1.network,other26520.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26519__$1.ledger_id,other26520.ledger_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26519__$1.db_name,other26520.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26519__$1.update_chan,other26520.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26519__$1.transact_chan,other26520.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26519__$1.state,other26520.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26519__$1.schema_cache,other26520.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26519__$1.blank_db,other26520.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26519__$1.close,other26520.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26519__$1.id,other26520.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26519__$1.__extmap,other26520.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k26518){
var self__ = this;
var this__4509__auto____$1 = this;
var G__26528 = k26518;
var G__26528__$1 = (((G__26528 instanceof cljs.core.Keyword))?G__26528.fqn:null);
switch (G__26528__$1) {
case "conn":
case "network":
case "ledger-id":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k26518);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__26517){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__26529 = cljs.core.keyword_identical_QMARK_;
var expr__26530 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__26532 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__26533 = expr__26530;
return (pred__26529.cljs$core$IFn$_invoke$arity$2 ? pred__26529.cljs$core$IFn$_invoke$arity$2(G__26532,G__26533) : pred__26529.call(null,G__26532,G__26533));
})())){
return (new fluree.db.session.DbSession(G__26517,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26534 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__26535 = expr__26530;
return (pred__26529.cljs$core$IFn$_invoke$arity$2 ? pred__26529.cljs$core$IFn$_invoke$arity$2(G__26534,G__26535) : pred__26529.call(null,G__26534,G__26535));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__26517,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26536 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015);
var G__26537 = expr__26530;
return (pred__26529.cljs$core$IFn$_invoke$arity$2 ? pred__26529.cljs$core$IFn$_invoke$arity$2(G__26536,G__26537) : pred__26529.call(null,G__26536,G__26537));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__26517,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26538 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__26539 = expr__26530;
return (pred__26529.cljs$core$IFn$_invoke$arity$2 ? pred__26529.cljs$core$IFn$_invoke$arity$2(G__26538,G__26539) : pred__26529.call(null,G__26538,G__26539));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,G__26517,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26540 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__26541 = expr__26530;
return (pred__26529.cljs$core$IFn$_invoke$arity$2 ? pred__26529.cljs$core$IFn$_invoke$arity$2(G__26540,G__26541) : pred__26529.call(null,G__26540,G__26541));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,G__26517,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26542 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__26543 = expr__26530;
return (pred__26529.cljs$core$IFn$_invoke$arity$2 ? pred__26529.cljs$core$IFn$_invoke$arity$2(G__26542,G__26543) : pred__26529.call(null,G__26542,G__26543));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,G__26517,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26544 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__26545 = expr__26530;
return (pred__26529.cljs$core$IFn$_invoke$arity$2 ? pred__26529.cljs$core$IFn$_invoke$arity$2(G__26544,G__26545) : pred__26529.call(null,G__26544,G__26545));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,G__26517,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26546 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__26547 = expr__26530;
return (pred__26529.cljs$core$IFn$_invoke$arity$2 ? pred__26529.cljs$core$IFn$_invoke$arity$2(G__26546,G__26547) : pred__26529.call(null,G__26546,G__26547));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__26517,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26548 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__26549 = expr__26530;
return (pred__26529.cljs$core$IFn$_invoke$arity$2 ? pred__26529.cljs$core$IFn$_invoke$arity$2(G__26548,G__26549) : pred__26529.call(null,G__26548,G__26549));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__26517,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26550 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__26551 = expr__26530;
return (pred__26529.cljs$core$IFn$_invoke$arity$2 ? pred__26529.cljs$core$IFn$_invoke$arity$2(G__26550,G__26551) : pred__26529.call(null,G__26550,G__26551));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__26517,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26552 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__26553 = expr__26530;
return (pred__26529.cljs$core$IFn$_invoke$arity$2 ? pred__26529.cljs$core$IFn$_invoke$arity$2(G__26552,G__26553) : pred__26529.call(null,G__26552,G__26553));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__26517,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__26517),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__26517){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__26517,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__26521){
var extmap__4542__auto__ = (function (){var G__26554 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__26521,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__26521)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__26554);
} else {
return G__26554;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__26521),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__26521),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__26521),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__26521),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__26521),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__26521),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__26521),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__26521),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__26521),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__26521),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__26521),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__26557 = session;
var map__26557__$1 = cljs.core.__destructure_map(map__26557);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26557__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26557__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,ledger_id){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,ledger_id){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___26708 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26660){
var state_val_26661 = (state_26660[(1)]);
if((state_val_26661 === (7))){
var inst_26578 = (state_26660[(7)]);
var inst_26583 = cljs.core.empty_QMARK_(inst_26578);
var state_26660__$1 = state_26660;
if(inst_26583){
var statearr_26662_26709 = state_26660__$1;
(statearr_26662_26709[(1)] = (10));

} else {
var statearr_26663_26710 = state_26660__$1;
(statearr_26663_26710[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (20))){
var inst_26569 = (state_26660[(8)]);
var inst_26609 = (state_26660[(9)]);
var inst_26571 = (state_26660[(10)]);
var inst_26570 = (state_26660[(11)]);
var inst_26614 = fluree.db.storage.core.read_block(inst_26569,inst_26570,inst_26571,inst_26609);
var state_26660__$1 = state_26660;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26660__$1,(22),inst_26614);
} else {
if((state_val_26661 === (27))){
var inst_26647 = (state_26660[(12)]);
var inst_26649 = (state_26660[(2)]);
var inst_26650 = fluree.db.util.async.throw_err(inst_26649);
var state_26660__$1 = (function (){var statearr_26664 = state_26660;
(statearr_26664[(13)] = inst_26650);

return statearr_26664;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26660__$1,(28),inst_26647);
} else {
if((state_val_26661 === (1))){
var state_26660__$1 = state_26660;
var statearr_26665_26711 = state_26660__$1;
(statearr_26665_26711[(2)] = null);

(statearr_26665_26711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (24))){
var inst_26609 = (state_26660[(9)]);
var inst_26571 = (state_26660[(10)]);
var inst_26570 = (state_26660[(11)]);
var inst_26631 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26609)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26570),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26571),"."].join('');
var inst_26632 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26633 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26634 = cljs.core.PersistentHashMap.fromArrays(inst_26632,inst_26633);
var inst_26635 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26631,inst_26634);
var inst_26636 = (function(){throw inst_26635})();
var state_26660__$1 = state_26660;
var statearr_26666_26712 = state_26660__$1;
(statearr_26666_26712[(2)] = inst_26636);

(statearr_26666_26712[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (4))){
var inst_26558 = (state_26660[(2)]);
var inst_26559 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_26558);
var state_26660__$1 = state_26660;
var statearr_26667_26713 = state_26660__$1;
(statearr_26667_26713[(2)] = inst_26559);

(statearr_26667_26713[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (15))){
var state_26660__$1 = state_26660;
var statearr_26668_26714 = state_26660__$1;
(statearr_26668_26714[(2)] = null);

(statearr_26668_26714[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (21))){
var inst_26640 = (state_26660[(2)]);
var state_26660__$1 = state_26660;
var statearr_26669_26715 = state_26660__$1;
(statearr_26669_26715[(2)] = inst_26640);

(statearr_26669_26715[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (13))){
var inst_26603 = (state_26660[(14)]);
var inst_26578 = (state_26660[(7)]);
var inst_26602 = (state_26660[(2)]);
var inst_26603__$1 = fluree.db.util.async.throw_err(inst_26602);
var inst_26604 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_26578);
var state_26660__$1 = (function (){var statearr_26670 = state_26660;
(statearr_26670[(14)] = inst_26603__$1);

(statearr_26670[(15)] = inst_26604);

return statearr_26670;
})();
if(cljs.core.truth_(inst_26603__$1)){
var statearr_26671_26716 = state_26660__$1;
(statearr_26671_26716[(1)] = (14));

} else {
var statearr_26672_26717 = state_26660__$1;
(statearr_26672_26717[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (22))){
var inst_26617 = (state_26660[(16)]);
var inst_26616 = (state_26660[(2)]);
var inst_26617__$1 = fluree.db.util.async.throw_err(inst_26616);
var state_26660__$1 = (function (){var statearr_26673 = state_26660;
(statearr_26673[(16)] = inst_26617__$1);

return statearr_26673;
})();
if(cljs.core.truth_(inst_26617__$1)){
var statearr_26674_26718 = state_26660__$1;
(statearr_26674_26718[(1)] = (23));

} else {
var statearr_26675_26719 = state_26660__$1;
(statearr_26675_26719[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (6))){
var inst_26578 = (state_26660[(7)]);
var inst_26577 = (state_26660[(2)]);
var inst_26578__$1 = fluree.db.util.async.throw_err(inst_26577);
var inst_26579 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_26578__$1);
var inst_26580 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_26579);
var inst_26581 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),inst_26580);
var state_26660__$1 = (function (){var statearr_26676 = state_26660;
(statearr_26676[(7)] = inst_26578__$1);

return statearr_26676;
})();
if(inst_26581){
var statearr_26677_26720 = state_26660__$1;
(statearr_26677_26720[(1)] = (7));

} else {
var statearr_26678_26721 = state_26660__$1;
(statearr_26678_26721[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (28))){
var inst_26650 = (state_26660[(13)]);
var inst_26645 = (state_26660[(17)]);
var inst_26652 = (state_26660[(2)]);
var inst_26653 = fluree.db.util.async.throw_err(inst_26652);
var inst_26654 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_26645,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26650,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26653], 0));
var inst_26655 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_26654);
var _ = (function (){var statearr_26679 = state_26660;
(statearr_26679[(4)] = cljs.core.rest((state_26660[(4)])));

return statearr_26679;
})();
var state_26660__$1 = state_26660;
var statearr_26680_26722 = state_26660__$1;
(statearr_26680_26722[(2)] = inst_26655);

(statearr_26680_26722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (25))){
var inst_26638 = (state_26660[(2)]);
var state_26660__$1 = state_26660;
var statearr_26681_26723 = state_26660__$1;
(statearr_26681_26723[(2)] = inst_26638);

(statearr_26681_26723[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (17))){
var inst_26609 = (state_26660[(9)]);
var inst_26604 = (state_26660[(15)]);
var inst_26611 = (inst_26609 > inst_26604);
var state_26660__$1 = state_26660;
if(cljs.core.truth_(inst_26611)){
var statearr_26682_26724 = state_26660__$1;
(statearr_26682_26724[(1)] = (19));

} else {
var statearr_26683_26725 = state_26660__$1;
(statearr_26683_26725[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (3))){
var inst_26658 = (state_26660[(2)]);
var state_26660__$1 = state_26660;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26660__$1,inst_26658);
} else {
if((state_val_26661 === (12))){
var inst_26590 = (state_26660[(2)]);
var inst_26591 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26592 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_26593 = cljs.core.PersistentHashMap.fromArrays(inst_26591,inst_26592);
var inst_26594 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26590,inst_26593);
var inst_26595 = (function(){throw inst_26594})();
var state_26660__$1 = state_26660;
var statearr_26684_26726 = state_26660__$1;
(statearr_26684_26726[(2)] = inst_26595);

(statearr_26684_26726[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (2))){
var inst_26569 = (state_26660[(8)]);
var inst_26571 = (state_26660[(10)]);
var inst_26570 = (state_26660[(11)]);
var _ = (function (){var statearr_26685 = state_26660;
(statearr_26685[(4)] = cljs.core.cons((5),(state_26660[(4)])));

return statearr_26685;
})();
var inst_26566 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_26567 = session;
var inst_26568 = cljs.core.__destructure_map(inst_26567);
var inst_26569__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26568,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_26570__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26568,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_26571__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26568,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_26572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26573 = [inst_26570__$1,inst_26571__$1];
var inst_26574 = (new cljs.core.PersistentVector(null,2,(5),inst_26572,inst_26573,null));
var inst_26575 = fluree.db.operations.ledger_info_async(inst_26569__$1,inst_26574);
var state_26660__$1 = (function (){var statearr_26686 = state_26660;
(statearr_26686[(8)] = inst_26569__$1);

(statearr_26686[(18)] = inst_26566);

(statearr_26686[(10)] = inst_26571__$1);

(statearr_26686[(11)] = inst_26570__$1);

return statearr_26686;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26660__$1,(6),inst_26575);
} else {
if((state_val_26661 === (23))){
var inst_26608 = (state_26660[(19)]);
var inst_26617 = (state_26660[(16)]);
var inst_26620 = cljs.core.__destructure_map(inst_26617);
var inst_26621 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26620,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_26622 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26620,new cljs.core.Keyword(null,"block","block",664686210));
var inst_26623 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26620,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_26624 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_26608,inst_26622,inst_26621);
var state_26660__$1 = (function (){var statearr_26687 = state_26660;
(statearr_26687[(20)] = inst_26623);

return statearr_26687;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26660__$1,(26),inst_26624);
} else {
if((state_val_26661 === (19))){
var inst_26608 = (state_26660[(19)]);
var state_26660__$1 = state_26660;
var statearr_26688_26727 = state_26660__$1;
(statearr_26688_26727[(2)] = inst_26608);

(statearr_26688_26727[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (11))){
var inst_26571 = (state_26660[(10)]);
var inst_26578 = (state_26660[(7)]);
var inst_26570 = (state_26660[(11)]);
var inst_26587 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_26578);
var inst_26588 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26570),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26571)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26587),"."].join('');
var state_26660__$1 = state_26660;
var statearr_26690_26728 = state_26660__$1;
(statearr_26690_26728[(2)] = inst_26588);

(statearr_26690_26728[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (9))){
var inst_26569 = (state_26660[(8)]);
var inst_26566 = (state_26660[(18)]);
var inst_26571 = (state_26660[(10)]);
var inst_26578 = (state_26660[(7)]);
var inst_26570 = (state_26660[(11)]);
var inst_26598 = (state_26660[(2)]);
var inst_26599 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_26578);
var inst_26600 = fluree.db.storage.core.reify_db(inst_26569,inst_26570,inst_26571,inst_26566,inst_26599);
var state_26660__$1 = (function (){var statearr_26691 = state_26660;
(statearr_26691[(21)] = inst_26598);

return statearr_26691;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26660__$1,(13),inst_26600);
} else {
if((state_val_26661 === (5))){
var _ = (function (){var statearr_26692 = state_26660;
(statearr_26692[(4)] = cljs.core.rest((state_26660[(4)])));

return statearr_26692;
})();
var state_26660__$1 = state_26660;
var ex26689 = (state_26660__$1[(2)]);
var statearr_26693_26729 = state_26660__$1;
(statearr_26693_26729[(5)] = ex26689);


var statearr_26694_26730 = state_26660__$1;
(statearr_26694_26730[(1)] = (4));

(statearr_26694_26730[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (14))){
var inst_26603 = (state_26660[(14)]);
var inst_26606 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_26603);
var inst_26607 = (inst_26606 + (1));
var inst_26608 = inst_26603;
var inst_26609 = inst_26607;
var state_26660__$1 = (function (){var statearr_26695 = state_26660;
(statearr_26695[(9)] = inst_26609);

(statearr_26695[(19)] = inst_26608);

return statearr_26695;
})();
var statearr_26696_26731 = state_26660__$1;
(statearr_26696_26731[(2)] = null);

(statearr_26696_26731[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (26))){
var inst_26609 = (state_26660[(9)]);
var inst_26626 = (state_26660[(2)]);
var inst_26627 = fluree.db.util.async.throw_err(inst_26626);
var inst_26628 = (inst_26609 + (1));
var inst_26608 = inst_26627;
var inst_26609__$1 = inst_26628;
var state_26660__$1 = (function (){var statearr_26697 = state_26660;
(statearr_26697[(9)] = inst_26609__$1);

(statearr_26697[(19)] = inst_26608);

return statearr_26697;
})();
var statearr_26698_26732 = state_26660__$1;
(statearr_26698_26732[(2)] = null);

(statearr_26698_26732[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (16))){
var inst_26645 = (state_26660[(17)]);
var inst_26645__$1 = (state_26660[(2)]);
var inst_26646 = fluree.db.query.schema.schema_map(inst_26645__$1);
var inst_26647 = fluree.db.query.schema.setting_map(inst_26645__$1);
var state_26660__$1 = (function (){var statearr_26699 = state_26660;
(statearr_26699[(12)] = inst_26647);

(statearr_26699[(17)] = inst_26645__$1);

return statearr_26699;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26660__$1,(27),inst_26646);
} else {
if((state_val_26661 === (10))){
var inst_26571 = (state_26660[(10)]);
var inst_26570 = (state_26660[(11)]);
var inst_26585 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26570),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26571)," is not found on this ledger group."].join('');
var state_26660__$1 = state_26660;
var statearr_26700_26733 = state_26660__$1;
(statearr_26700_26733[(2)] = inst_26585);

(statearr_26700_26733[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (18))){
var inst_26642 = (state_26660[(2)]);
var state_26660__$1 = state_26660;
var statearr_26701_26734 = state_26660__$1;
(statearr_26701_26734[(2)] = inst_26642);

(statearr_26701_26734[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26661 === (8))){
var state_26660__$1 = state_26660;
var statearr_26702_26735 = state_26660__$1;
(statearr_26702_26735[(2)] = null);

(statearr_26702_26735[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2727__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2727__auto____0 = (function (){
var statearr_26703 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26703[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2727__auto__);

(statearr_26703[(1)] = (1));

return statearr_26703;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2727__auto____1 = (function (state_26660){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26660);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26704){var ex__2730__auto__ = e26704;
var statearr_26705_26736 = state_26660;
(statearr_26705_26736[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26660[(4)]))){
var statearr_26706_26737 = state_26660;
(statearr_26706_26737[(1)] = cljs.core.first((state_26660[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26738 = state_26660;
state_26660 = G__26738;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2727__auto__ = function(state_26660){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2727__auto____1.call(this,state_26660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2727__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2727__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26707 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26707[(6)] = c__2749__auto___26708);

return statearr_26707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4253__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var ledger_id = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),ledger_id);

return ledger_id;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__26739 = cljs.core.get_global_hierarchy;
return (fexpr__26739.cljs$core$IFn$_invoke$arity$0 ? fexpr__26739.cljs$core$IFn$_invoke$arity$0() : fexpr__26739.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26741){
var state_val_26742 = (state_26741[(1)]);
if((state_val_26742 === (1))){
var state_26741__$1 = state_26741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26741__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_26743 = [null,null,null,null,null,null,null];
(statearr_26743[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_26743[(1)] = (1));

return statearr_26743;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_26741){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26741);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26744){var ex__2730__auto__ = e26744;
var statearr_26745_26748 = state_26741;
(statearr_26745_26748[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26741[(4)]))){
var statearr_26746_26749 = state_26741;
(statearr_26746_26749[(1)] = cljs.core.first((state_26741[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26750 = state_26741;
state_26741 = G__26750;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_26741){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_26741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26747 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26747[(6)] = c__2749__auto__);

return statearr_26747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__26752){
var map__26753 = p__26752;
var map__26753__$1 = cljs.core.__destructure_map(map__26753);
var data = map__26753__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26753__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26753__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26753__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26812){
var state_val_26813 = (state_26812[(1)]);
if((state_val_26813 === (7))){
var inst_26764 = (state_26812[(7)]);
var inst_26767 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_26768 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_26769 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26767),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26768),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26764),". No-op."].join('');
var inst_26770 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1(inst_26769) : fluree.db.util.log.info.call(null,inst_26769));
var state_26812__$1 = state_26812;
var statearr_26814_26852 = state_26812__$1;
(statearr_26814_26852[(2)] = inst_26770);

(statearr_26814_26852[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (1))){
var state_26812__$1 = state_26812;
var statearr_26815_26853 = state_26812__$1;
(statearr_26815_26853[(2)] = null);

(statearr_26815_26853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (4))){
var inst_26754 = (state_26812[(2)]);
var state_26812__$1 = state_26812;
var statearr_26816_26854 = state_26812__$1;
(statearr_26816_26854[(2)] = inst_26754);

(statearr_26816_26854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (15))){
var inst_26793 = (state_26812[(2)]);
var state_26812__$1 = state_26812;
var statearr_26817_26855 = state_26812__$1;
(statearr_26817_26855[(2)] = inst_26793);

(statearr_26817_26855[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (13))){
var inst_26784 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_26785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26786 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_26787 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_26788 = [inst_26786,inst_26787];
var inst_26789 = (new cljs.core.PersistentVector(null,2,(5),inst_26785,inst_26788,null));
var inst_26790 = (function (){var G__26818 = inst_26784;
var G__26819 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__26820 = inst_26789;
var G__26821 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__26818,G__26819,G__26820,G__26821) : fluree.db.conn_events.process_event.call(null,G__26818,G__26819,G__26820,G__26821));
})();
var state_26812__$1 = state_26812;
var statearr_26822_26856 = state_26812__$1;
(statearr_26822_26856[(2)] = inst_26790);

(statearr_26822_26856[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (6))){
var inst_26763 = (state_26812[(8)]);
var inst_26764 = (state_26812[(7)]);
var inst_26762 = (state_26812[(2)]);
var inst_26763__$1 = fluree.db.util.async.throw_err(inst_26762);
var inst_26764__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_26763__$1);
var inst_26765 = (block <= inst_26764__$1);
var state_26812__$1 = (function (){var statearr_26823 = state_26812;
(statearr_26823[(8)] = inst_26763__$1);

(statearr_26823[(7)] = inst_26764__$1);

return statearr_26823;
})();
if(cljs.core.truth_(inst_26765)){
var statearr_26824_26857 = state_26812__$1;
(statearr_26824_26857[(1)] = (7));

} else {
var statearr_26825_26858 = state_26812__$1;
(statearr_26825_26858[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (17))){
var state_26812__$1 = state_26812;
var statearr_26826_26859 = state_26812__$1;
(statearr_26826_26859[(2)] = null);

(statearr_26826_26859[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (3))){
var inst_26810 = (state_26812[(2)]);
var state_26812__$1 = state_26812;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26812__$1,inst_26810);
} else {
if((state_val_26813 === (12))){
var inst_26805 = (state_26812[(2)]);
var state_26812__$1 = state_26812;
var statearr_26827_26860 = state_26812__$1;
(statearr_26827_26860[(2)] = inst_26805);

(statearr_26827_26860[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (2))){
var inst_26760 = (state_26812[(9)]);
var _ = (function (){var statearr_26828 = state_26812;
(statearr_26828[(4)] = cljs.core.cons((5),(state_26812[(4)])));

return statearr_26828;
})();
var inst_26760__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_26812__$1 = (function (){var statearr_26829 = state_26812;
(statearr_26829[(9)] = inst_26760__$1);

return statearr_26829;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26812__$1,(6),inst_26760__$1);
} else {
if((state_val_26813 === (11))){
var state_26812__$1 = state_26812;
var statearr_26831_26861 = state_26812__$1;
(statearr_26831_26861[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (9))){
var inst_26807 = (state_26812[(2)]);
var _ = (function (){var statearr_26833 = state_26812;
(statearr_26833[(4)] = cljs.core.rest((state_26812[(4)])));

return statearr_26833;
})();
var state_26812__$1 = state_26812;
var statearr_26834_26862 = state_26812__$1;
(statearr_26834_26862[(2)] = inst_26807);

(statearr_26834_26862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (5))){
var _ = (function (){var statearr_26835 = state_26812;
(statearr_26835[(4)] = cljs.core.rest((state_26812[(4)])));

return statearr_26835;
})();
var state_26812__$1 = state_26812;
var ex26830 = (state_26812__$1[(2)]);
var statearr_26836_26863 = state_26812__$1;
(statearr_26836_26863[(5)] = ex26830);


if((ex26830 instanceof Error)){
var statearr_26837_26864 = state_26812__$1;
(statearr_26837_26864[(1)] = (4));

(statearr_26837_26864[(5)] = null);

} else {
throw ex26830;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (14))){
var state_26812__$1 = state_26812;
var statearr_26838_26865 = state_26812__$1;
(statearr_26838_26865[(2)] = null);

(statearr_26838_26865[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (16))){
var inst_26764 = (state_26812[(7)]);
var inst_26796 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_26797 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_26798 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26796),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26797),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26764),". Forcing a db reload."].join('');
var inst_26799 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1(inst_26798) : fluree.db.util.log.info.call(null,inst_26798));
var inst_26800 = fluree.db.session.reload_db_BANG_(session);
var state_26812__$1 = (function (){var statearr_26839 = state_26812;
(statearr_26839[(10)] = inst_26799);

return statearr_26839;
})();
var statearr_26840_26866 = state_26812__$1;
(statearr_26840_26866[(2)] = inst_26800);

(statearr_26840_26866[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (10))){
var inst_26760 = (state_26812[(9)]);
var inst_26763 = (state_26812[(8)]);
var inst_26764 = (state_26812[(7)]);
var inst_26775 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_26776 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_26777 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26775),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26776),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_26778 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$1(inst_26777) : fluree.db.util.log.trace.call(null,inst_26777));
var inst_26779 = (function (){var current_db_ch = inst_26760;
var current_db = inst_26763;
var current_block = inst_26764;
return (function (p1__26751_SHARP_){
if((p1__26751_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__26751_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__26751_SHARP_);
}
});
})();
var inst_26780 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26779,flakes);
var inst_26781 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_26763,block,inst_26780);
var inst_26782 = fluree.db.session.cas_db_BANG_(session,inst_26760,inst_26781);
var state_26812__$1 = (function (){var statearr_26841 = state_26812;
(statearr_26841[(11)] = inst_26778);

return statearr_26841;
})();
if(inst_26782){
var statearr_26842_26867 = state_26812__$1;
(statearr_26842_26867[(1)] = (13));

} else {
var statearr_26843_26868 = state_26812__$1;
(statearr_26843_26868[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (18))){
var inst_26803 = (state_26812[(2)]);
var state_26812__$1 = state_26812;
var statearr_26844_26869 = state_26812__$1;
(statearr_26844_26869[(2)] = inst_26803);

(statearr_26844_26869[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26813 === (8))){
var inst_26764 = (state_26812[(7)]);
var inst_26772 = ((1) + inst_26764);
var inst_26773 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_26772);
var state_26812__$1 = state_26812;
if(inst_26773){
var statearr_26845_26870 = state_26812__$1;
(statearr_26845_26870[(1)] = (10));

} else {
var statearr_26846_26871 = state_26812__$1;
(statearr_26846_26871[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_26847 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26847[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_26847[(1)] = (1));

return statearr_26847;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_26812){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26812);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26848){var ex__2730__auto__ = e26848;
var statearr_26849_26872 = state_26812;
(statearr_26849_26872[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26812[(4)]))){
var statearr_26850_26873 = state_26812;
(statearr_26850_26873[(1)] = cljs.core.first((state_26812[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26874 = state_26812;
state_26812 = G__26874;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_26812){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_26812);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26851 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26851[(6)] = c__2749__auto__);

return statearr_26851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26881){
var state_val_26882 = (state_26881[(1)]);
if((state_val_26882 === (1))){
var inst_26875 = fluree.db.session.clear_db_BANG_(session);
var inst_26876 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_26877 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_26878 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26876),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26877)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26879 = (fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$1(inst_26878) : fluree.db.util.log.debug.call(null,inst_26878));
var state_26881__$1 = (function (){var statearr_26883 = state_26881;
(statearr_26883[(7)] = inst_26875);

(statearr_26883[(8)] = inst_26879);

return statearr_26883;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_26881__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_26884 = [null,null,null,null,null,null,null,null,null];
(statearr_26884[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_26884[(1)] = (1));

return statearr_26884;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_26881){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26881);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26885){var ex__2730__auto__ = e26885;
var statearr_26886_26889 = state_26881;
(statearr_26886_26889[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26881[(4)]))){
var statearr_26887_26890 = state_26881;
(statearr_26887_26890[(1)] = cljs.core.first((state_26881[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26891 = state_26881;
state_26881 = G__26891;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_26881){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_26881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26888 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26888[(6)] = c__2749__auto__);

return statearr_26888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + ledger-id will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__26893 = arguments.length;
switch (G__26893) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
var map__26894 = session;
var map__26894__$1 = cljs.core.__destructure_map(map__26894);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26894__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26894__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26894__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26894__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26894__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26894__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26894__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,ledger_id);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__26895_26898 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__26895_26898.cljs$core$IFn$_invoke$arity$3 ? fexpr__26895_26898.cljs$core$IFn$_invoke$arity$3(network,ledger_id,id) : fexpr__26895_26898.call(null,network,ledger_id,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,ledger_id);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__26896_26899 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__26896_26899.cljs$core$IFn$_invoke$arity$0 ? fexpr__26896_26899.cljs$core$IFn$_invoke$arity$0() : fexpr__26896_26899.call(null));
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,ledger_id){
var temp__5802__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_26951){
var state_val_26952 = (state_26951[(1)]);
if((state_val_26952 === (7))){
var inst_26947 = (state_26951[(2)]);
var state_26951__$1 = state_26951;
var statearr_26953_26984 = state_26951__$1;
(statearr_26953_26984[(2)] = inst_26947);

(statearr_26953_26984[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26952 === (1))){
var state_26951__$1 = state_26951;
var statearr_26954_26985 = state_26951__$1;
(statearr_26954_26985[(2)] = null);

(statearr_26954_26985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26952 === (4))){
var inst_26903 = (state_26951[(7)]);
var inst_26902 = (state_26951[(2)]);
var inst_26903__$1 = fluree.db.util.async.throw_err(inst_26902);
var inst_26904 = fluree.db.session.from_cache(network,ledger_id);
var inst_26905 = (inst_26903__$1 == null);
var state_26951__$1 = (function (){var statearr_26955 = state_26951;
(statearr_26955[(7)] = inst_26903__$1);

(statearr_26955[(8)] = inst_26904);

return statearr_26955;
})();
if(cljs.core.truth_(inst_26905)){
var statearr_26956_26986 = state_26951__$1;
(statearr_26956_26986[(1)] = (5));

} else {
var statearr_26957_26987 = state_26951__$1;
(statearr_26957_26987[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26952 === (15))){
var inst_26939 = (state_26951[(2)]);
var state_26951__$1 = (function (){var statearr_26958 = state_26951;
(statearr_26958[(9)] = inst_26939);

return statearr_26958;
})();
var statearr_26959_26988 = state_26951__$1;
(statearr_26959_26988[(2)] = null);

(statearr_26959_26988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26952 === (13))){
var inst_26943 = (state_26951[(2)]);
var state_26951__$1 = state_26951;
var statearr_26961_26989 = state_26951__$1;
(statearr_26961_26989[(2)] = inst_26943);

(statearr_26961_26989[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26952 === (6))){
var inst_26904 = (state_26951[(8)]);
var inst_26910 = (inst_26904 == null);
var state_26951__$1 = state_26951;
if(cljs.core.truth_(inst_26910)){
var statearr_26962_26990 = state_26951__$1;
(statearr_26962_26990[(1)] = (8));

} else {
var statearr_26963_26991 = state_26951__$1;
(statearr_26963_26991[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26952 === (17))){
var _ = (function (){var statearr_26964 = state_26951;
(statearr_26964[(4)] = cljs.core.rest((state_26951[(4)])));

return statearr_26964;
})();
var state_26951__$1 = state_26951;
var ex26960 = (state_26951__$1[(2)]);
var statearr_26965_26992 = state_26951__$1;
(statearr_26965_26992[(5)] = ex26960);


var statearr_26966_26993 = state_26951__$1;
(statearr_26966_26993[(1)] = (16));

(statearr_26966_26993[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26952 === (3))){
var inst_26949 = (state_26951[(2)]);
var state_26951__$1 = state_26951;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26951__$1,inst_26949);
} else {
if((state_val_26952 === (12))){
var state_26951__$1 = state_26951;
var statearr_26967_26994 = state_26951__$1;
(statearr_26967_26994[(2)] = null);

(statearr_26967_26994[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26952 === (2))){
var state_26951__$1 = state_26951;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26951__$1,(4),update_chan);
} else {
if((state_val_26952 === (11))){
var state_26951__$1 = state_26951;
var statearr_26968_26995 = state_26951__$1;
(statearr_26968_26995[(2)] = null);

(statearr_26968_26995[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26952 === (9))){
var state_26951__$1 = state_26951;
var statearr_26969_26996 = state_26951__$1;
(statearr_26969_26996[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26952 === (5))){
var inst_26907 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_26908 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2("Channel closed for session updates for:",inst_26907) : fluree.db.util.log.info.call(null,"Channel closed for session updates for:",inst_26907));
var state_26951__$1 = state_26951;
var statearr_26971_26997 = state_26951__$1;
(statearr_26971_26997[(2)] = inst_26908);

(statearr_26971_26997[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26952 === (14))){
var inst_26903 = (state_26951[(7)]);
var inst_26904 = (state_26951[(8)]);
var _ = (function (){var statearr_26972 = state_26951;
(statearr_26972[(4)] = cljs.core.cons((17),(state_26951[(4)])));

return statearr_26972;
})();
var inst_26927 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26903,(0),null);
var inst_26928 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26903,(1),null);
var inst_26929 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_26930 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_26903], 0));
var inst_26931 = fluree.db.util.core.trunc(inst_26930,(200));
var inst_26932 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$4("[process-ledger-updates[",inst_26929,"]: ",inst_26931) : fluree.db.util.log.trace.call(null,"[process-ledger-updates[",inst_26929,"]: ",inst_26931));
var inst_26933 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_26904,inst_26927,inst_26928) : fluree.db.session.process_ledger_update.call(null,inst_26904,inst_26927,inst_26928));
var state_26951__$1 = (function (){var statearr_26973 = state_26951;
(statearr_26973[(10)] = inst_26932);

return statearr_26973;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26951__$1,(18),inst_26933);
} else {
if((state_val_26952 === (16))){
var inst_26903 = (state_26951[(7)]);
var inst_26917 = (state_26951[(2)]);
var inst_26918 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_26917,"Exception processing ledger updates for message:",inst_26903) : fluree.db.util.log.error.call(null,inst_26917,"Exception processing ledger updates for message:",inst_26903));
var state_26951__$1 = state_26951;
var statearr_26974_26998 = state_26951__$1;
(statearr_26974_26998[(2)] = inst_26918);

(statearr_26974_26998[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26952 === (10))){
var inst_26945 = (state_26951[(2)]);
var state_26951__$1 = state_26951;
var statearr_26975_26999 = state_26951__$1;
(statearr_26975_26999[(2)] = inst_26945);

(statearr_26975_26999[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26952 === (18))){
var inst_26935 = (state_26951[(2)]);
var inst_26936 = fluree.db.util.async.throw_err(inst_26935);
var _ = (function (){var statearr_26976 = state_26951;
(statearr_26976[(4)] = cljs.core.rest((state_26951[(4)])));

return statearr_26976;
})();
var state_26951__$1 = state_26951;
var statearr_26977_27000 = state_26951__$1;
(statearr_26977_27000[(2)] = inst_26936);

(statearr_26977_27000[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26952 === (8))){
var inst_26903 = (state_26951[(7)]);
var inst_26912 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_26913 = cljs.core.first(inst_26903);
var inst_26914 = (fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4("Ledger update received for session that is no longer open:",inst_26912,"Message: ",inst_26913) : fluree.db.util.log.warn.call(null,"Ledger update received for session that is no longer open:",inst_26912,"Message: ",inst_26913));
var state_26951__$1 = state_26951;
var statearr_26978_27001 = state_26951__$1;
(statearr_26978_27001[(2)] = inst_26914);

(statearr_26978_27001[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0 = (function (){
var statearr_26979 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26979[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__);

(statearr_26979[(1)] = (1));

return statearr_26979;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1 = (function (state_26951){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_26951);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e26980){var ex__2730__auto__ = e26980;
var statearr_26981_27002 = state_26951;
(statearr_26981_27002[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_26951[(4)]))){
var statearr_26982_27003 = state_26951;
(statearr_26982_27003[(1)] = cljs.core.first((state_26951[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27004 = state_26951;
state_26951 = G__27004;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__ = function(state_26951){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1.call(this,state_26951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2727__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_26983 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_26983[(6)] = c__2749__auto__);

return statearr_26983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__27005){
var map__27006 = p__27005;
var map__27006__$1 = cljs.core.__destructure_map(map__27006);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27006__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27006__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27006__$1,new cljs.core.Keyword(null,"db","db",993250759));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27006__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27006__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27006__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27006__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27006__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27006__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","current","db/current",-1088041545),(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[ledger_id,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,ledger_id,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__27010 = block_result;
var map__27010__$1 = cljs.core.__destructure_map(map__27010);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27010__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27010__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27010__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27010__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27010__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__27011 = tx_result;
var map__27011__$1 = cljs.core.__destructure_map(map__27011);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27011__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27011__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__27007_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,fluree.db.flake.t(p1__27007_SHARP_));
}):(function (p1__27008_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__27008_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__27009_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__27009_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__27009_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__27012 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27012,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27012,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27012,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27012,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4253__auto__ = message;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = (function (){var G__27015 = "Create and cache session. Opt keys: ";
var G__27016 = cljs.core.keys(opts);
return (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2(G__27015,G__27016) : fluree.db.util.log.trace.call(null,G__27015,G__27016));
})();
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__27018 = arguments.length;
switch (G__27018) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__27019){
var map__27020 = p__27019;
var map__27020__$1 = cljs.core.__destructure_map(map__27020);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27020__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27020__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27020__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27020__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__27021 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27021,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27021,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27021,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4253__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4253__auto____$1 = state;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__27025_27177 = network;
var G__27026_27178 = ledger_id;
var G__27027_27179 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__27028_27180 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__27029 = cljs.core.seq(tids);
var chunk__27030 = null;
var count__27031 = (0);
var i__27032 = (0);
while(true){
if((i__27032 < count__27031)){
var tid = chunk__27030.cljs$core$IIndexed$_nth$arity$2(null,i__27032);
var temp__5804__auto___27182__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___27182__$1)){
var keyed_callbacks_27183 = temp__5804__auto___27182__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_27184 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__27089_27185 = cljs.core.seq(keyed_callbacks_27183);
var chunk__27090_27186 = null;
var count__27091_27187 = (0);
var i__27092_27188 = (0);
while(true){
if((i__27092_27188 < count__27091_27187)){
var vec__27105_27189 = chunk__27090_27186.cljs$core$IIndexed$_nth$arity$2(null,i__27092_27188);
var k_27190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27105_27189,(0),null);
var f_27191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27105_27189,(1),null);
try{(f_27191.cljs$core$IFn$_invoke$arity$1 ? f_27191.cljs$core$IFn$_invoke$arity$1(tx_response_27184) : f_27191.call(null,tx_response_27184));
}catch (e27108){var e_27192 = e27108;
var G__27109_27193 = e_27192;
var G__27110_27194 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__27109_27193,G__27110_27194) : fluree.db.util.log.error.call(null,G__27109_27193,G__27110_27194));
}

var G__27195 = seq__27089_27185;
var G__27196 = chunk__27090_27186;
var G__27197 = count__27091_27187;
var G__27198 = (i__27092_27188 + (1));
seq__27089_27185 = G__27195;
chunk__27090_27186 = G__27196;
count__27091_27187 = G__27197;
i__27092_27188 = G__27198;
continue;
} else {
var temp__5804__auto___27199__$2 = cljs.core.seq(seq__27089_27185);
if(temp__5804__auto___27199__$2){
var seq__27089_27200__$1 = temp__5804__auto___27199__$2;
if(cljs.core.chunked_seq_QMARK_(seq__27089_27200__$1)){
var c__4679__auto___27201 = cljs.core.chunk_first(seq__27089_27200__$1);
var G__27202 = cljs.core.chunk_rest(seq__27089_27200__$1);
var G__27203 = c__4679__auto___27201;
var G__27204 = cljs.core.count(c__4679__auto___27201);
var G__27205 = (0);
seq__27089_27185 = G__27202;
chunk__27090_27186 = G__27203;
count__27091_27187 = G__27204;
i__27092_27188 = G__27205;
continue;
} else {
var vec__27111_27206 = cljs.core.first(seq__27089_27200__$1);
var k_27207 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27111_27206,(0),null);
var f_27208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27111_27206,(1),null);
try{(f_27208.cljs$core$IFn$_invoke$arity$1 ? f_27208.cljs$core$IFn$_invoke$arity$1(tx_response_27184) : f_27208.call(null,tx_response_27184));
}catch (e27114){var e_27209 = e27114;
var G__27115_27210 = e_27209;
var G__27116_27211 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__27115_27210,G__27116_27211) : fluree.db.util.log.error.call(null,G__27115_27210,G__27116_27211));
}

var G__27212 = cljs.core.next(seq__27089_27200__$1);
var G__27213 = null;
var G__27214 = (0);
var G__27215 = (0);
seq__27089_27185 = G__27212;
chunk__27090_27186 = G__27213;
count__27091_27187 = G__27214;
i__27092_27188 = G__27215;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27216 = seq__27029;
var G__27217 = chunk__27030;
var G__27218 = count__27031;
var G__27219 = (i__27032 + (1));
seq__27029 = G__27216;
chunk__27030 = G__27217;
count__27031 = G__27218;
i__27032 = G__27219;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq(seq__27029);
if(temp__5804__auto____$1){
var seq__27029__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__27029__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__27029__$1);
var G__27220 = cljs.core.chunk_rest(seq__27029__$1);
var G__27221 = c__4679__auto__;
var G__27222 = cljs.core.count(c__4679__auto__);
var G__27223 = (0);
seq__27029 = G__27220;
chunk__27030 = G__27221;
count__27031 = G__27222;
i__27032 = G__27223;
continue;
} else {
var tid = cljs.core.first(seq__27029__$1);
var temp__5804__auto___27224__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5804__auto___27224__$2)){
var keyed_callbacks_27225 = temp__5804__auto___27224__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_27226 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__27117_27227 = cljs.core.seq(keyed_callbacks_27225);
var chunk__27118_27228 = null;
var count__27119_27229 = (0);
var i__27120_27230 = (0);
while(true){
if((i__27120_27230 < count__27119_27229)){
var vec__27133_27231 = chunk__27118_27228.cljs$core$IIndexed$_nth$arity$2(null,i__27120_27230);
var k_27232 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27133_27231,(0),null);
var f_27233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27133_27231,(1),null);
try{(f_27233.cljs$core$IFn$_invoke$arity$1 ? f_27233.cljs$core$IFn$_invoke$arity$1(tx_response_27226) : f_27233.call(null,tx_response_27226));
}catch (e27136){var e_27234 = e27136;
var G__27137_27235 = e_27234;
var G__27138_27236 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__27137_27235,G__27138_27236) : fluree.db.util.log.error.call(null,G__27137_27235,G__27138_27236));
}

var G__27237 = seq__27117_27227;
var G__27238 = chunk__27118_27228;
var G__27239 = count__27119_27229;
var G__27240 = (i__27120_27230 + (1));
seq__27117_27227 = G__27237;
chunk__27118_27228 = G__27238;
count__27119_27229 = G__27239;
i__27120_27230 = G__27240;
continue;
} else {
var temp__5804__auto___27241__$3 = cljs.core.seq(seq__27117_27227);
if(temp__5804__auto___27241__$3){
var seq__27117_27242__$1 = temp__5804__auto___27241__$3;
if(cljs.core.chunked_seq_QMARK_(seq__27117_27242__$1)){
var c__4679__auto___27243 = cljs.core.chunk_first(seq__27117_27242__$1);
var G__27244 = cljs.core.chunk_rest(seq__27117_27242__$1);
var G__27245 = c__4679__auto___27243;
var G__27246 = cljs.core.count(c__4679__auto___27243);
var G__27247 = (0);
seq__27117_27227 = G__27244;
chunk__27118_27228 = G__27245;
count__27119_27229 = G__27246;
i__27120_27230 = G__27247;
continue;
} else {
var vec__27139_27248 = cljs.core.first(seq__27117_27242__$1);
var k_27249 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27139_27248,(0),null);
var f_27250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27139_27248,(1),null);
try{(f_27250.cljs$core$IFn$_invoke$arity$1 ? f_27250.cljs$core$IFn$_invoke$arity$1(tx_response_27226) : f_27250.call(null,tx_response_27226));
}catch (e27142){var e_27251 = e27142;
var G__27143_27252 = e_27251;
var G__27144_27253 = ["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__27143_27252,G__27144_27253) : fluree.db.util.log.error.call(null,G__27143_27252,G__27144_27253));
}

var G__27254 = cljs.core.next(seq__27117_27242__$1);
var G__27255 = null;
var G__27256 = (0);
var G__27257 = (0);
seq__27117_27227 = G__27254;
chunk__27118_27228 = G__27255;
count__27119_27229 = G__27256;
i__27120_27230 = G__27257;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27258 = cljs.core.next(seq__27029__$1);
var G__27259 = null;
var G__27260 = (0);
var G__27261 = (0);
seq__27029 = G__27258;
chunk__27030 = G__27259;
count__27031 = G__27260;
i__27032 = G__27261;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__27024_27181 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__27024_27181.cljs$core$IFn$_invoke$arity$4 ? fexpr__27024_27181.cljs$core$IFn$_invoke$arity$4(G__27025_27177,G__27026_27178,G__27027_27179,G__27028_27180) : fexpr__27024_27181.call(null,G__27025_27177,G__27026_27178,G__27027_27179,G__27028_27180));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_27262 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2749__auto___27263 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27161){
var state_val_27162 = (state_27161[(1)]);
if((state_val_27162 === (1))){
var state_27161__$1 = state_27161;
var statearr_27163_27264 = state_27161__$1;
(statearr_27163_27264[(2)] = null);

(statearr_27163_27264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27162 === (2))){
var inst_27146 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_27161__$1 = state_27161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27161__$1,(4),inst_27146);
} else {
if((state_val_27162 === (3))){
var inst_27159 = (state_27161[(2)]);
var state_27161__$1 = state_27161;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27161__$1,inst_27159);
} else {
if((state_val_27162 === (4))){
var inst_27148 = (state_27161[(7)]);
var inst_27148__$1 = (state_27161[(2)]);
var inst_27149 = (inst_27148__$1 == null);
var state_27161__$1 = (function (){var statearr_27164 = state_27161;
(statearr_27164[(7)] = inst_27148__$1);

return statearr_27164;
})();
if(cljs.core.truth_(inst_27149)){
var statearr_27165_27265 = state_27161__$1;
(statearr_27165_27265[(1)] = (5));

} else {
var statearr_27166_27266 = state_27161__$1;
(statearr_27166_27266[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27162 === (5))){
var inst_27151 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_27152 = (fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2("Transactor session closing for db:",inst_27151) : fluree.db.util.log.info.call(null,"Transactor session closing for db:",inst_27151));
var state_27161__$1 = state_27161;
var statearr_27167_27267 = state_27161__$1;
(statearr_27167_27267[(2)] = inst_27152);

(statearr_27167_27267[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27162 === (6))){
var inst_27148 = (state_27161[(7)]);
var inst_27154 = (transact_handler_27262.cljs$core$IFn$_invoke$arity$2 ? transact_handler_27262.cljs$core$IFn$_invoke$arity$2(conn,inst_27148) : transact_handler_27262.call(null,conn,inst_27148));
var state_27161__$1 = (function (){var statearr_27168 = state_27161;
(statearr_27168[(8)] = inst_27154);

return statearr_27168;
})();
var statearr_27169_27268 = state_27161__$1;
(statearr_27169_27268[(2)] = null);

(statearr_27169_27268[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27162 === (7))){
var inst_27157 = (state_27161[(2)]);
var state_27161__$1 = state_27161;
var statearr_27170_27269 = state_27161__$1;
(statearr_27170_27269[(2)] = inst_27157);

(statearr_27170_27269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2727__auto__ = null;
var fluree$db$session$state_machine__2727__auto____0 = (function (){
var statearr_27171 = [null,null,null,null,null,null,null,null,null];
(statearr_27171[(0)] = fluree$db$session$state_machine__2727__auto__);

(statearr_27171[(1)] = (1));

return statearr_27171;
});
var fluree$db$session$state_machine__2727__auto____1 = (function (state_27161){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27161);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27172){var ex__2730__auto__ = e27172;
var statearr_27173_27270 = state_27161;
(statearr_27173_27270[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27161[(4)]))){
var statearr_27174_27271 = state_27161;
(statearr_27174_27271[(1)] = cljs.core.first((state_27161[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27272 = state_27161;
state_27161 = G__27272;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$session$state_machine__2727__auto__ = function(state_27161){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2727__auto____1.call(this,state_27161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2727__auto____0;
fluree$db$session$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2727__auto____1;
return fluree$db$session$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27175 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27175[(6)] = c__2749__auto___27263);

return statearr_27175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(p__27274){
var map__27275 = p__27274;
var map__27275__$1 = cljs.core.__destructure_map(map__27275);
var session = map__27275__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27275__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p1__27273_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__27273_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__27273_SHARP_) + (1))], 0));
}));

var or__4253__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var _ = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (st){
if(cljs.core.truth_(new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(st))){
return st;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(st,new cljs.core.Keyword("db","current","db/current",-1088041545),fluree.db.session.full_load_existing_db(session));
}
}));
return new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(new_state);
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__27278 = arguments.length;
switch (G__27278) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__27279 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__27276_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__27276_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__27279);
} else {
return G__27279;
}
})();
var seq__27280 = cljs.core.seq(sessions);
var chunk__27281 = null;
var count__27282 = (0);
var i__27283 = (0);
while(true){
if((i__27283 < count__27282)){
var session = chunk__27281.cljs$core$IIndexed$_nth$arity$2(null,i__27283);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__27285 = seq__27280;
var G__27286 = chunk__27281;
var G__27287 = count__27282;
var G__27288 = (i__27283 + (1));
seq__27280 = G__27285;
chunk__27281 = G__27286;
count__27282 = G__27287;
i__27283 = G__27288;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__27280);
if(temp__5804__auto__){
var seq__27280__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__27280__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__27280__$1);
var G__27289 = cljs.core.chunk_rest(seq__27280__$1);
var G__27290 = c__4679__auto__;
var G__27291 = cljs.core.count(c__4679__auto__);
var G__27292 = (0);
seq__27280 = G__27289;
chunk__27281 = G__27290;
count__27282 = G__27291;
i__27283 = G__27292;
continue;
} else {
var session = cljs.core.first(seq__27280__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__27293 = cljs.core.next(seq__27280__$1);
var G__27294 = null;
var G__27295 = (0);
var G__27296 = (0);
seq__27280 = G__27293;
chunk__27281 = G__27294;
count__27282 = G__27295;
i__27283 = G__27296;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
