// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17906_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17906_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__17910 = coll;
var vec__17911 = G__17910;
var seq__17912 = cljs.core.seq(vec__17911);
var first__17913 = cljs.core.first(seq__17912);
var seq__17912__$1 = cljs.core.next(seq__17912);
var clause = first__17913;
var r = seq__17912__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__17910__$1 = G__17910;
var res__$1 = res;
while(true){
var vec__17917 = G__17910__$1;
var seq__17918 = cljs.core.seq(vec__17917);
var first__17919 = cljs.core.first(seq__17918);
var seq__17918__$1 = cljs.core.next(seq__17918);
var clause__$1 = first__17919;
var r__$1 = seq__17918__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__17920 = r__$1;
var G__17921 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__17910__$1 = G__17920;
res__$1 = G__17921;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__17922){
var map__17923 = p__17922;
var map__17923__$1 = cljs.core.__destructure_map(map__17923);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17923__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__17927 = coll;
var vec__17928 = G__17927;
var seq__17929 = cljs.core.seq(vec__17928);
var first__17930 = cljs.core.first(seq__17929);
var seq__17929__$1 = cljs.core.next(seq__17929);
var clause = first__17930;
var r = seq__17929__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__17927__$1 = G__17927;
var res__$1 = res;
while(true){
var vec__17934 = G__17927__$1;
var seq__17935 = cljs.core.seq(vec__17934);
var first__17936 = cljs.core.first(seq__17935);
var seq__17935__$1 = cljs.core.next(seq__17935);
var clause__$1 = first__17936;
var r__$1 = seq__17935__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__17937 = r__$1;
var G__17938 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__17927__$1 = G__17937;
res__$1 = G__17938;
continue;
} else {
var G__17939 = r__$1;
var G__17940 = res__$2;
G__17927__$1 = G__17939;
res__$1 = G__17940;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__17944 = coll;
var vec__17945 = G__17944;
var seq__17946 = cljs.core.seq(vec__17945);
var first__17947 = cljs.core.first(seq__17946);
var seq__17946__$1 = cljs.core.next(seq__17946);
var clause = first__17947;
var r = seq__17946__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__17944__$1 = G__17944;
var res__$1 = res;
while(true){
var vec__17951 = G__17944__$1;
var seq__17952 = cljs.core.seq(vec__17951);
var first__17953 = cljs.core.first(seq__17952);
var seq__17952__$1 = cljs.core.next(seq__17952);
var clause__$1 = first__17953;
var r__$1 = seq__17952__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__17954 = r__$1;
var G__17955 = res__$2;
G__17944__$1 = G__17954;
res__$1 = G__17955;
continue;
} else {
var G__17956 = r__$1;
var G__17957 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__17944__$1 = G__17956;
res__$1 = G__17957;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__17960 = clause;
var G__17960__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__17960):G__17960);
var G__17960__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__17960__$1)
;
var G__17960__$3 = (function (){var fexpr__17961 = (function (p1__17958_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17958_SHARP_)," ."].join('');
});
return fexpr__17961(G__17960__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__17962 = (function (p1__17959_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17959_SHARP_),"}"].join('');
});
return fexpr__17962(G__17960__$3);
} else {
return G__17960__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__17966 = opts;
var map__17966__$1 = cljs.core.__destructure_map(map__17966);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17966__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17966__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17966__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17966__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17966__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17963_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17963_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__17964_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__17964_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__17965_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__17965_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = language;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_17980){
var state_val_17981 = (state_17980[(1)]);
if((state_val_17981 === (1))){
var inst_17967 = fluree.db.util.core.url_encode(query);
var inst_17968 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17967)].join('');
var inst_17969 = ["User-Agent","Accept"];
var inst_17970 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_17971 = cljs.core.PersistentHashMap.fromArrays(inst_17969,inst_17970);
var inst_17972 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_17973 = [inst_17971,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_17974 = cljs.core.PersistentHashMap.fromArrays(inst_17972,inst_17973);
var inst_17975 = fluree.db.util.xhttp.get(inst_17968,inst_17974);
var state_17980__$1 = state_17980;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17980__$1,(2),inst_17975);
} else {
if((state_val_17981 === (2))){
var inst_17977 = (state_17980[(2)]);
var inst_17978 = fluree.db.util.async.throw_err(inst_17977);
var state_17980__$1 = state_17980;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17980__$1,inst_17978);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0 = (function (){
var statearr_17982 = [null,null,null,null,null,null,null];
(statearr_17982[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__);

(statearr_17982[(1)] = (1));

return statearr_17982;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1 = (function (state_17980){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_17980);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e17983){var ex__2730__auto__ = e17983;
var statearr_17984_17987 = state_17980;
(statearr_17984_17987[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_17980[(4)]))){
var statearr_17985_17988 = state_17980;
(statearr_17985_17988[(1)] = cljs.core.first((state_17980[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17989 = state_17980;
state_17980 = G__17989;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__ = function(state_17980){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1.call(this,state_17980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_17986 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_17986[(6)] = c__2749__auto__);

return statearr_17986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18007){
var state_val_18008 = (state_18007[(1)]);
if((state_val_18008 === (1))){
var inst_17990 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_18007__$1 = state_18007;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18007__$1,(2),inst_17990);
} else {
if((state_val_18008 === (2))){
var inst_17993 = (state_18007[(7)]);
var inst_17992 = (state_18007[(2)]);
var inst_17993__$1 = fluree.db.util.async.throw_err(inst_17992);
var inst_17994 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_17993__$1);
var inst_17995 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_17994);
var state_18007__$1 = (function (){var statearr_18009 = state_18007;
(statearr_18009[(7)] = inst_17993__$1);

return statearr_18009;
})();
if(inst_17995){
var statearr_18010_18019 = state_18007__$1;
(statearr_18010_18019[(1)] = (3));

} else {
var statearr_18011_18020 = state_18007__$1;
(statearr_18011_18020[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18008 === (3))){
var inst_17993 = (state_18007[(7)]);
var state_18007__$1 = state_18007;
var statearr_18012_18021 = state_18007__$1;
(statearr_18012_18021[(2)] = inst_17993);

(statearr_18012_18021[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18008 === (4))){
var inst_17993 = (state_18007[(7)]);
var inst_17998 = (function (){var body = inst_17993;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_17999 = cljs.core.second(inst_17993);
var inst_18000 = cljs.core.second(inst_17999);
var inst_18001 = cljs.core.first(inst_18000);
var inst_18002 = cljs.core.second(inst_18001);
var inst_18003 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_17998,inst_18002);
var state_18007__$1 = state_18007;
var statearr_18013_18022 = state_18007__$1;
(statearr_18013_18022[(2)] = inst_18003);

(statearr_18013_18022[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18008 === (5))){
var inst_18005 = (state_18007[(2)]);
var state_18007__$1 = state_18007;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18007__$1,inst_18005);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0 = (function (){
var statearr_18014 = [null,null,null,null,null,null,null,null];
(statearr_18014[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__);

(statearr_18014[(1)] = (1));

return statearr_18014;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1 = (function (state_18007){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18007);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18015){var ex__2730__auto__ = e18015;
var statearr_18016_18023 = state_18007;
(statearr_18016_18023[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18007[(4)]))){
var statearr_18017_18024 = state_18007;
(statearr_18017_18024[(1)] = cljs.core.first((state_18007[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18025 = state_18007;
state_18007 = G__18025;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__ = function(state_18007){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1.call(this,state_18007);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18018 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18018[(6)] = c__2749__auto__);

return statearr_18018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18026_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__18026_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18027_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__18027_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18028_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__18028_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18028_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__18028_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18074){
var state_val_18075 = (state_18074[(1)]);
if((state_val_18075 === (7))){
var inst_18039 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_18074__$1 = state_18074;
var statearr_18076_18104 = state_18074__$1;
(statearr_18076_18104[(2)] = inst_18039);

(statearr_18076_18104[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18075 === (1))){
var state_18074__$1 = state_18074;
var statearr_18077_18105 = state_18074__$1;
(statearr_18077_18105[(2)] = null);

(statearr_18077_18105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18075 === (4))){
var inst_18029 = (state_18074[(2)]);
var state_18074__$1 = state_18074;
var statearr_18078_18106 = state_18074__$1;
(statearr_18078_18106[(2)] = inst_18029);

(statearr_18078_18106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18075 === (15))){
var inst_18047 = (state_18074[(7)]);
var inst_18053 = (state_18074[(8)]);
var inst_18048 = (state_18074[(9)]);
var inst_18058 = (state_18074[(2)]);
var inst_18059 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_18053,(0),inst_18058);
var inst_18060 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18061 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_18047);
var inst_18062 = [inst_18048,inst_18061];
var inst_18063 = cljs.core.PersistentHashMap.fromArrays(inst_18060,inst_18062);
var inst_18064 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18059,inst_18063);
var inst_18065 = (function(){throw inst_18064})();
var state_18074__$1 = state_18074;
var statearr_18079_18107 = state_18074__$1;
(statearr_18079_18107[(2)] = inst_18065);

(statearr_18079_18107[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18075 === (13))){
var inst_18052 = (state_18074[(10)]);
var state_18074__$1 = state_18074;
var statearr_18080_18108 = state_18074__$1;
(statearr_18080_18108[(2)] = inst_18052);

(statearr_18080_18108[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18075 === (6))){
var state_18074__$1 = state_18074;
var statearr_18081_18109 = state_18074__$1;
(statearr_18081_18109[(2)] = null);

(statearr_18081_18109[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18075 === (3))){
var inst_18072 = (state_18074[(2)]);
var state_18074__$1 = state_18074;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18074__$1,inst_18072);
} else {
if((state_val_18075 === (12))){
var inst_18069 = (state_18074[(2)]);
var _ = (function (){var statearr_18082 = state_18074;
(statearr_18082[(4)] = cljs.core.rest((state_18074[(4)])));

return statearr_18082;
})();
var state_18074__$1 = state_18074;
var statearr_18083_18110 = state_18074__$1;
(statearr_18083_18110[(2)] = inst_18069);

(statearr_18083_18110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18075 === (2))){
var _ = (function (){var statearr_18084 = state_18074;
(statearr_18084[(4)] = cljs.core.cons((5),(state_18074[(4)])));

return statearr_18084;
})();
var inst_18036 = cljs.core.empty_QMARK_(matching_vars);
var state_18074__$1 = state_18074;
if(inst_18036){
var statearr_18085_18111 = state_18074__$1;
(statearr_18085_18111[(1)] = (6));

} else {
var statearr_18086_18112 = state_18074__$1;
(statearr_18086_18112[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18075 === (11))){
var inst_18047 = (state_18074[(7)]);
var inst_18067 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_18047,all_vars);
var state_18074__$1 = state_18074;
var statearr_18088_18113 = state_18074__$1;
(statearr_18088_18113[(2)] = inst_18067);

(statearr_18088_18113[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18075 === (9))){
var inst_18047 = (state_18074[(7)]);
var inst_18048 = (state_18074[(9)]);
var inst_18045 = (state_18074[(2)]);
var inst_18046 = fluree.db.util.async.throw_err(inst_18045);
var inst_18047__$1 = cljs.core.__destructure_map(inst_18046);
var inst_18048__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18047__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_18049 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18047__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_18050 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_18048__$1);
var state_18074__$1 = (function (){var statearr_18089 = state_18074;
(statearr_18089[(7)] = inst_18047__$1);

(statearr_18089[(9)] = inst_18048__$1);

(statearr_18089[(11)] = inst_18049);

return statearr_18089;
})();
if(inst_18050){
var statearr_18090_18114 = state_18074__$1;
(statearr_18090_18114[(1)] = (10));

} else {
var statearr_18091_18115 = state_18074__$1;
(statearr_18091_18115[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18075 === (5))){
var _ = (function (){var statearr_18092 = state_18074;
(statearr_18092[(4)] = cljs.core.rest((state_18074[(4)])));

return statearr_18092;
})();
var state_18074__$1 = state_18074;
var ex18087 = (state_18074__$1[(2)]);
var statearr_18093_18116 = state_18074__$1;
(statearr_18093_18116[(5)] = ex18087);


if((ex18087 instanceof Error)){
var statearr_18094_18117 = state_18074__$1;
(statearr_18094_18117[(1)] = (4));

(statearr_18094_18117[(5)] = null);

} else {
throw ex18087;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18075 === (14))){
var state_18074__$1 = state_18074;
var statearr_18095_18118 = state_18074__$1;
(statearr_18095_18118[(2)] = (1000));

(statearr_18095_18118[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18075 === (10))){
var inst_18047 = (state_18074[(7)]);
var inst_18052 = (state_18074[(10)]);
var inst_18049 = (state_18074[(11)]);
var inst_18052__$1 = cljs.core.count(inst_18049);
var inst_18053 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_18047);
var inst_18054 = (inst_18052__$1 < (1000));
var state_18074__$1 = (function (){var statearr_18096 = state_18074;
(statearr_18096[(8)] = inst_18053);

(statearr_18096[(10)] = inst_18052__$1);

return statearr_18096;
})();
if(cljs.core.truth_(inst_18054)){
var statearr_18097_18119 = state_18074__$1;
(statearr_18097_18119[(1)] = (13));

} else {
var statearr_18098_18120 = state_18074__$1;
(statearr_18098_18120[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18075 === (8))){
var inst_18041 = (state_18074[(2)]);
var inst_18042 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_18041,optional_clauses);
var inst_18043 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_18042);
var state_18074__$1 = state_18074;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18074__$1,(9),inst_18043);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_18099 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18099[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__);

(statearr_18099[(1)] = (1));

return statearr_18099;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1 = (function (state_18074){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18074);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18100){var ex__2730__auto__ = e18100;
var statearr_18101_18121 = state_18074;
(statearr_18101_18121[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18074[(4)]))){
var statearr_18102_18122 = state_18074;
(statearr_18102_18122[(1)] = cljs.core.first((state_18074[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18123 = state_18074;
state_18074 = G__18123;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__ = function(state_18074){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1.call(this,state_18074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18103 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18103[(6)] = c__2749__auto__);

return statearr_18103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
