// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__68965 = arguments.length;
switch (G__68965) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___69113 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69052){
var state_val_69053 = (state_69052[(1)]);
if((state_val_69053 === (7))){
var inst_68983 = (state_69052[(7)]);
var inst_68986 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_68983);
var state_69052__$1 = state_69052;
var statearr_69054_69114 = state_69052__$1;
(statearr_69054_69114[(2)] = inst_68986);

(statearr_69054_69114[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (20))){
var inst_68978 = (state_69052[(8)]);
var inst_69007 = (state_69052[(9)]);
var inst_69011 = fluree.db.auth.roles(inst_68978,inst_69007);
var state_69052__$1 = state_69052;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69052__$1,(23),inst_69011);
} else {
if((state_val_69053 === (27))){
var inst_68978 = (state_69052[(8)]);
var inst_69026 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_69027 = fluree.db.time_travel.as_of_block(inst_68978,inst_69026);
var state_69052__$1 = state_69052;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69052__$1,(30),inst_69027);
} else {
if((state_val_69053 === (1))){
var state_69052__$1 = state_69052;
var statearr_69055_69115 = state_69052__$1;
(statearr_69055_69115[(2)] = null);

(statearr_69055_69115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (24))){
var inst_68978 = (state_69052[(8)]);
var inst_69019 = (state_69052[(10)]);
var inst_69021 = fluree.db.permissions.permission_map(inst_68978,inst_69019,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_69052__$1 = state_69052;
var statearr_69056_69116 = state_69052__$1;
(statearr_69056_69116[(2)] = inst_69021);

(statearr_69056_69116[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (4))){
var inst_68966 = (state_69052[(2)]);
var inst_68967 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_68966);
var inst_68968 = cljs.core.async.close_BANG_(pc);
var state_69052__$1 = (function (){var statearr_69057 = state_69052;
(statearr_69057[(11)] = inst_68967);

return statearr_69057;
})();
var statearr_69058_69117 = state_69052__$1;
(statearr_69058_69117[(2)] = inst_68968);

(statearr_69058_69117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (15))){
var inst_68983 = (state_69052[(7)]);
var inst_68997 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68983)," unknown."].join('');
var inst_68998 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68999 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_69000 = cljs.core.PersistentHashMap.fromArrays(inst_68998,inst_68999);
var inst_69001 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_68997,inst_69000);
var inst_69002 = (function(){throw inst_69001})();
var state_69052__$1 = state_69052;
var statearr_69059_69118 = state_69052__$1;
(statearr_69059_69118[(2)] = inst_69002);

(statearr_69059_69118[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (21))){
var state_69052__$1 = state_69052;
var statearr_69060_69119 = state_69052__$1;
(statearr_69060_69119[(2)] = null);

(statearr_69060_69119[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (31))){
var inst_68983 = (state_69052[(7)]);
var inst_69033 = (state_69052[(12)]);
var inst_69035 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_69033,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_68983);
var state_69052__$1 = state_69052;
var statearr_69061_69120 = state_69052__$1;
(statearr_69061_69120[(2)] = inst_69035);

(statearr_69061_69120[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (32))){
var inst_69033 = (state_69052[(12)]);
var state_69052__$1 = state_69052;
var statearr_69062_69121 = state_69052__$1;
(statearr_69062_69121[(2)] = inst_69033);

(statearr_69062_69121[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (33))){
var inst_69019 = (state_69052[(10)]);
var inst_69038 = (state_69052[(2)]);
var state_69052__$1 = (function (){var statearr_69063 = state_69052;
(statearr_69063[(13)] = inst_69038);

return statearr_69063;
})();
if(cljs.core.truth_(inst_69019)){
var statearr_69064_69122 = state_69052__$1;
(statearr_69064_69122[(1)] = (34));

} else {
var statearr_69065_69123 = state_69052__$1;
(statearr_69065_69123[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (13))){
var inst_68994 = (state_69052[(14)]);
var inst_68993 = (state_69052[(2)]);
var inst_68994__$1 = fluree.db.util.async.throw_err(inst_68993);
var state_69052__$1 = (function (){var statearr_69066 = state_69052;
(statearr_69066[(14)] = inst_68994__$1);

return statearr_69066;
})();
if(cljs.core.truth_(inst_68994__$1)){
var statearr_69067_69124 = state_69052__$1;
(statearr_69067_69124[(1)] = (14));

} else {
var statearr_69068_69125 = state_69052__$1;
(statearr_69068_69125[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (22))){
var inst_69017 = (state_69052[(2)]);
var state_69052__$1 = state_69052;
var statearr_69069_69126 = state_69052__$1;
(statearr_69069_69126[(2)] = inst_69017);

(statearr_69069_69126[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (36))){
var inst_69046 = (state_69052[(2)]);
var inst_69047 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69046);
var _ = (function (){var statearr_69070 = state_69052;
(statearr_69070[(4)] = cljs.core.rest((state_69052[(4)])));

return statearr_69070;
})();
var state_69052__$1 = state_69052;
var statearr_69071_69127 = state_69052__$1;
(statearr_69071_69127[(2)] = inst_69047);

(statearr_69071_69127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (29))){
var inst_68983 = (state_69052[(7)]);
var inst_69033 = (state_69052[(2)]);
var state_69052__$1 = (function (){var statearr_69072 = state_69052;
(statearr_69072[(12)] = inst_69033);

return statearr_69072;
})();
if(cljs.core.truth_(inst_68983)){
var statearr_69073_69128 = state_69052__$1;
(statearr_69073_69128[(1)] = (31));

} else {
var statearr_69074_69129 = state_69052__$1;
(statearr_69074_69129[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (6))){
var inst_68983 = (state_69052[(7)]);
var inst_68977 = (state_69052[(2)]);
var inst_68978 = fluree.db.util.async.throw_err(inst_68977);
var inst_68979 = opts;
var inst_68980 = cljs.core.__destructure_map(inst_68979);
var inst_68981 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68980,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_68982 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68980,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_68983__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68980,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_68984 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68980,new cljs.core.Keyword(null,"block","block",664686210));
var state_69052__$1 = (function (){var statearr_69075 = state_69052;
(statearr_69075[(7)] = inst_68983__$1);

(statearr_69075[(15)] = inst_68981);

(statearr_69075[(8)] = inst_68978);

(statearr_69075[(16)] = inst_68984);

(statearr_69075[(17)] = inst_68982);

return statearr_69075;
})();
if(cljs.core.truth_(inst_68983__$1)){
var statearr_69076_69130 = state_69052__$1;
(statearr_69076_69130[(1)] = (7));

} else {
var statearr_69077_69131 = state_69052__$1;
(statearr_69077_69131[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (28))){
var inst_68978 = (state_69052[(8)]);
var state_69052__$1 = state_69052;
var statearr_69078_69132 = state_69052__$1;
(statearr_69078_69132[(2)] = inst_68978);

(statearr_69078_69132[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (25))){
var state_69052__$1 = state_69052;
var statearr_69079_69133 = state_69052__$1;
(statearr_69079_69133[(2)] = null);

(statearr_69079_69133[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (34))){
var inst_69024 = (state_69052[(18)]);
var state_69052__$1 = state_69052;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69052__$1,(37),inst_69024);
} else {
if((state_val_69053 === (17))){
var inst_68981 = (state_69052[(15)]);
var state_69052__$1 = state_69052;
var statearr_69080_69134 = state_69052__$1;
(statearr_69080_69134[(2)] = inst_68981);

(statearr_69080_69134[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (3))){
var inst_69050 = (state_69052[(2)]);
var state_69052__$1 = state_69052;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69052__$1,inst_69050);
} else {
if((state_val_69053 === (12))){
var inst_68981 = (state_69052[(15)]);
var inst_69007 = (state_69052[(2)]);
var state_69052__$1 = (function (){var statearr_69081 = state_69052;
(statearr_69081[(9)] = inst_69007);

return statearr_69081;
})();
if(cljs.core.truth_(inst_68981)){
var statearr_69082_69135 = state_69052__$1;
(statearr_69082_69135[(1)] = (17));

} else {
var statearr_69083_69136 = state_69052__$1;
(statearr_69083_69136[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (2))){
var _ = (function (){var statearr_69084 = state_69052;
(statearr_69084[(4)] = cljs.core.cons((5),(state_69052[(4)])));

return statearr_69084;
})();
var inst_68975 = fluree.db.session.db(conn,ledger,null);
var state_69052__$1 = state_69052;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69052__$1,(6),inst_68975);
} else {
if((state_val_69053 === (23))){
var inst_69013 = (state_69052[(2)]);
var inst_69014 = fluree.db.util.async.throw_err(inst_69013);
var state_69052__$1 = state_69052;
var statearr_69085_69137 = state_69052__$1;
(statearr_69085_69137[(2)] = inst_69014);

(statearr_69085_69137[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (35))){
var inst_69038 = (state_69052[(13)]);
var state_69052__$1 = state_69052;
var statearr_69086_69138 = state_69052__$1;
(statearr_69086_69138[(2)] = inst_69038);

(statearr_69086_69138[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (19))){
var inst_69019 = (state_69052[(10)]);
var inst_69019__$1 = (state_69052[(2)]);
var state_69052__$1 = (function (){var statearr_69087 = state_69052;
(statearr_69087[(10)] = inst_69019__$1);

return statearr_69087;
})();
if(cljs.core.truth_(inst_69019__$1)){
var statearr_69088_69139 = state_69052__$1;
(statearr_69088_69139[(1)] = (24));

} else {
var statearr_69089_69140 = state_69052__$1;
(statearr_69089_69140[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (11))){
var state_69052__$1 = state_69052;
var statearr_69091_69141 = state_69052__$1;
(statearr_69091_69141[(2)] = null);

(statearr_69091_69141[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (9))){
var inst_68989 = (state_69052[(2)]);
var state_69052__$1 = state_69052;
if(cljs.core.truth_(inst_68989)){
var statearr_69092_69142 = state_69052__$1;
(statearr_69092_69142[(1)] = (10));

} else {
var statearr_69093_69143 = state_69052__$1;
(statearr_69093_69143[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (5))){
var _ = (function (){var statearr_69094 = state_69052;
(statearr_69094[(4)] = cljs.core.rest((state_69052[(4)])));

return statearr_69094;
})();
var state_69052__$1 = state_69052;
var ex69090 = (state_69052__$1[(2)]);
var statearr_69095_69144 = state_69052__$1;
(statearr_69095_69144[(5)] = ex69090);


var statearr_69096_69145 = state_69052__$1;
(statearr_69096_69145[(1)] = (4));

(statearr_69096_69145[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (14))){
var inst_68994 = (state_69052[(14)]);
var state_69052__$1 = state_69052;
var statearr_69097_69146 = state_69052__$1;
(statearr_69097_69146[(2)] = inst_68994);

(statearr_69097_69146[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (26))){
var inst_68984 = (state_69052[(16)]);
var inst_69024 = (state_69052[(2)]);
var state_69052__$1 = (function (){var statearr_69098 = state_69052;
(statearr_69098[(18)] = inst_69024);

return statearr_69098;
})();
if(cljs.core.truth_(inst_68984)){
var statearr_69099_69147 = state_69052__$1;
(statearr_69099_69147[(1)] = (27));

} else {
var statearr_69100_69148 = state_69052__$1;
(statearr_69100_69148[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (16))){
var inst_69004 = (state_69052[(2)]);
var state_69052__$1 = state_69052;
var statearr_69101_69149 = state_69052__$1;
(statearr_69101_69149[(2)] = inst_69004);

(statearr_69101_69149[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (30))){
var inst_69029 = (state_69052[(2)]);
var inst_69030 = fluree.db.util.async.throw_err(inst_69029);
var state_69052__$1 = state_69052;
var statearr_69102_69150 = state_69052__$1;
(statearr_69102_69150[(2)] = inst_69030);

(statearr_69102_69150[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (10))){
var inst_68983 = (state_69052[(7)]);
var inst_68978 = (state_69052[(8)]);
var inst_68991 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_68978,inst_68983);
var state_69052__$1 = state_69052;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69052__$1,(13),inst_68991);
} else {
if((state_val_69053 === (18))){
var inst_69007 = (state_69052[(9)]);
var state_69052__$1 = state_69052;
if(cljs.core.truth_(inst_69007)){
var statearr_69103_69151 = state_69052__$1;
(statearr_69103_69151[(1)] = (20));

} else {
var statearr_69104_69152 = state_69052__$1;
(statearr_69104_69152[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (37))){
var inst_69038 = (state_69052[(13)]);
var inst_69041 = (state_69052[(2)]);
var inst_69042 = fluree.db.util.async.throw_err(inst_69041);
var inst_69043 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_69038,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_69042);
var state_69052__$1 = state_69052;
var statearr_69105_69153 = state_69052__$1;
(statearr_69105_69153[(2)] = inst_69043);

(statearr_69105_69153[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69053 === (8))){
var inst_68983 = (state_69052[(7)]);
var state_69052__$1 = state_69052;
var statearr_69106_69154 = state_69052__$1;
(statearr_69106_69154[(2)] = inst_68983);

(statearr_69106_69154[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2727__auto__ = null;
var fluree$db$api$query$state_machine__2727__auto____0 = (function (){
var statearr_69107 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69107[(0)] = fluree$db$api$query$state_machine__2727__auto__);

(statearr_69107[(1)] = (1));

return statearr_69107;
});
var fluree$db$api$query$state_machine__2727__auto____1 = (function (state_69052){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69052);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69108){var ex__2730__auto__ = e69108;
var statearr_69109_69155 = state_69052;
(statearr_69109_69155[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69052[(4)]))){
var statearr_69110_69156 = state_69052;
(statearr_69110_69156[(1)] = cljs.core.first((state_69052[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69157 = state_69052;
state_69052 = G__69157;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2727__auto__ = function(state_69052){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2727__auto____1.call(this,state_69052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2727__auto____0;
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2727__auto____1;
return fluree$db$api$query$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69111 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69111[(6)] = c__2749__auto___69113);

return statearr_69111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69298){
var state_val_69299 = (state_69298[(1)]);
if((state_val_69299 === (7))){
var inst_69178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69179 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69180 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69181 = [inst_69179,inst_69180];
var inst_69182 = (new cljs.core.PersistentVector(null,2,(5),inst_69178,inst_69181,null));
var state_69298__$1 = state_69298;
var statearr_69300_69370 = state_69298__$1;
(statearr_69300_69370[(2)] = inst_69182);

(statearr_69300_69370[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (20))){
var inst_69208 = (state_69298[(7)]);
var state_69298__$1 = state_69298;
var statearr_69301_69371 = state_69298__$1;
(statearr_69301_69371[(2)] = inst_69208);

(statearr_69301_69371[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (27))){
var state_69298__$1 = state_69298;
var statearr_69302_69372 = state_69298__$1;
(statearr_69302_69372[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (1))){
var state_69298__$1 = state_69298;
var statearr_69304_69373 = state_69298__$1;
(statearr_69304_69373[(2)] = null);

(statearr_69304_69373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (24))){
var inst_69207 = (state_69298[(8)]);
var state_69298__$1 = state_69298;
if(cljs.core.truth_(inst_69207)){
var statearr_69305_69374 = state_69298__$1;
(statearr_69305_69374[(1)] = (26));

} else {
var statearr_69306_69375 = state_69298__$1;
(statearr_69306_69375[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (39))){
var inst_69253 = (state_69298[(9)]);
var inst_69254 = (state_69298[(10)]);
var inst_69279 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69280 = [inst_69253,inst_69254];
var inst_69281 = (new cljs.core.PersistentVector(null,2,(5),inst_69279,inst_69280,null));
var state_69298__$1 = state_69298;
var statearr_69307_69376 = state_69298__$1;
(statearr_69307_69376[(2)] = inst_69281);

(statearr_69307_69376[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (4))){
var inst_69158 = (state_69298[(2)]);
var state_69298__$1 = state_69298;
var statearr_69308_69377 = state_69298__$1;
(statearr_69308_69377[(2)] = inst_69158);

(statearr_69308_69377[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (15))){
var inst_69187 = (state_69298[(11)]);
var inst_69192 = (state_69298[(12)]);
var inst_69201 = (state_69298[(2)]);
var inst_69202 = [inst_69192,inst_69201];
var inst_69203 = (new cljs.core.PersistentVector(null,2,(5),inst_69187,inst_69202,null));
var state_69298__$1 = state_69298;
var statearr_69309_69378 = state_69298__$1;
(statearr_69309_69378[(2)] = inst_69203);

(statearr_69309_69378[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (21))){
var inst_69207 = (state_69298[(8)]);
var state_69298__$1 = state_69298;
var statearr_69310_69379 = state_69298__$1;
(statearr_69310_69379[(2)] = inst_69207);

(statearr_69310_69379[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (31))){
var inst_69248 = (state_69298[(2)]);
var state_69298__$1 = state_69298;
var statearr_69311_69380 = state_69298__$1;
(statearr_69311_69380[(2)] = inst_69248);

(statearr_69311_69380[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (32))){
var inst_69254 = (state_69298[(10)]);
var inst_69257 = cljs.core.pos_int_QMARK_(inst_69254);
var state_69298__$1 = state_69298;
var statearr_69312_69381 = state_69298__$1;
(statearr_69312_69381[(2)] = inst_69257);

(statearr_69312_69381[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (40))){
var inst_69285 = (state_69298[(13)]);
var inst_69209 = (state_69298[(14)]);
var inst_69283 = (state_69298[(2)]);
var inst_69284 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69283,(0),null);
var inst_69285__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69283,(1),null);
var inst_69286 = (inst_69285__$1 > inst_69209);
var state_69298__$1 = (function (){var statearr_69313 = state_69298;
(statearr_69313[(15)] = inst_69284);

(statearr_69313[(13)] = inst_69285__$1);

return statearr_69313;
})();
if(cljs.core.truth_(inst_69286)){
var statearr_69314_69382 = state_69298__$1;
(statearr_69314_69382[(1)] = (41));

} else {
var statearr_69315_69383 = state_69298__$1;
(statearr_69315_69383[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (33))){
var inst_69255 = (state_69298[(16)]);
var state_69298__$1 = state_69298;
var statearr_69316_69384 = state_69298__$1;
(statearr_69316_69384[(2)] = inst_69255);

(statearr_69316_69384[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (13))){
var inst_69193 = (state_69298[(17)]);
var inst_69195 = fluree.db.time_travel.block_to_int_format(db,inst_69193);
var state_69298__$1 = state_69298;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69298__$1,(16),inst_69195);
} else {
if((state_val_69299 === (22))){
var inst_69226 = (state_69298[(2)]);
var state_69298__$1 = state_69298;
if(cljs.core.truth_(inst_69226)){
var statearr_69317_69385 = state_69298__$1;
(statearr_69317_69385[(1)] = (23));

} else {
var statearr_69318_69386 = state_69298__$1;
(statearr_69318_69386[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (36))){
var state_69298__$1 = state_69298;
var statearr_69319_69387 = state_69298__$1;
(statearr_69319_69387[(2)] = null);

(statearr_69319_69387[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (41))){
var inst_69209 = (state_69298[(14)]);
var state_69298__$1 = state_69298;
var statearr_69320_69388 = state_69298__$1;
(statearr_69320_69388[(2)] = inst_69209);

(statearr_69320_69388[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (43))){
var inst_69284 = (state_69298[(15)]);
var inst_69290 = (state_69298[(2)]);
var inst_69291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69292 = [inst_69284,inst_69290];
var inst_69293 = (new cljs.core.PersistentVector(null,2,(5),inst_69291,inst_69292,null));
var _ = (function (){var statearr_69321 = state_69298;
(statearr_69321[(4)] = cljs.core.rest((state_69298[(4)])));

return statearr_69321;
})();
var state_69298__$1 = state_69298;
var statearr_69322_69389 = state_69298__$1;
(statearr_69322_69389[(2)] = inst_69293);

(statearr_69322_69389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (29))){
var inst_69184 = (state_69298[(18)]);
var inst_69239 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69184], 0));
var inst_69240 = ["Invalid block range provided: ",inst_69239].join('');
var inst_69241 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69242 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69243 = cljs.core.PersistentHashMap.fromArrays(inst_69241,inst_69242);
var inst_69244 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69240,inst_69243);
var inst_69245 = (function(){throw inst_69244})();
var state_69298__$1 = state_69298;
var statearr_69323_69390 = state_69298__$1;
(statearr_69323_69390[(2)] = inst_69245);

(statearr_69323_69390[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (6))){
var inst_69176 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_69298__$1 = state_69298;
var statearr_69324_69391 = state_69298__$1;
(statearr_69324_69391[(2)] = inst_69176);

(statearr_69324_69391[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (28))){
var inst_69250 = (state_69298[(2)]);
var state_69298__$1 = state_69298;
var statearr_69325_69392 = state_69298__$1;
(statearr_69325_69392[(2)] = inst_69250);

(statearr_69325_69392[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (25))){
var inst_69253 = (state_69298[(9)]);
var inst_69255 = (state_69298[(16)]);
var inst_69252 = (state_69298[(2)]);
var inst_69253__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69252,(0),null);
var inst_69254 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69252,(1),null);
var inst_69255__$1 = cljs.core.pos_int_QMARK_(inst_69253__$1);
var state_69298__$1 = (function (){var statearr_69326 = state_69298;
(statearr_69326[(9)] = inst_69253__$1);

(statearr_69326[(10)] = inst_69254);

(statearr_69326[(16)] = inst_69255__$1);

return statearr_69326;
})();
if(inst_69255__$1){
var statearr_69327_69393 = state_69298__$1;
(statearr_69327_69393[(1)] = (32));

} else {
var statearr_69328_69394 = state_69298__$1;
(statearr_69328_69394[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (34))){
var inst_69260 = (state_69298[(2)]);
var inst_69261 = cljs.core.not(inst_69260);
var state_69298__$1 = state_69298;
if(inst_69261){
var statearr_69329_69395 = state_69298__$1;
(statearr_69329_69395[(1)] = (35));

} else {
var statearr_69330_69396 = state_69298__$1;
(statearr_69330_69396[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (17))){
var inst_69207 = (state_69298[(8)]);
var inst_69209 = (state_69298[(14)]);
var inst_69212 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69207], 0));
var inst_69213 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69209], 0));
var inst_69214 = ["Start block is out of range for this ledger. Start block provided: ",inst_69212,". Database block: ",inst_69213].join('');
var inst_69215 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69216 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69217 = cljs.core.PersistentHashMap.fromArrays(inst_69215,inst_69216);
var inst_69218 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69214,inst_69217);
var inst_69219 = (function(){throw inst_69218})();
var state_69298__$1 = state_69298;
var statearr_69331_69397 = state_69298__$1;
(statearr_69331_69397[(2)] = inst_69219);

(statearr_69331_69397[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (3))){
var inst_69296 = (state_69298[(2)]);
var state_69298__$1 = state_69298;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69298__$1,inst_69296);
} else {
if((state_val_69299 === (12))){
var inst_69184 = (state_69298[(18)]);
var inst_69193 = (state_69298[(17)]);
var inst_69191 = (state_69298[(2)]);
var inst_69192 = fluree.db.util.async.throw_err(inst_69191);
var inst_69193__$1 = cljs.core.second(inst_69184);
var state_69298__$1 = (function (){var statearr_69332 = state_69298;
(statearr_69332[(12)] = inst_69192);

(statearr_69332[(17)] = inst_69193__$1);

return statearr_69332;
})();
if(cljs.core.truth_(inst_69193__$1)){
var statearr_69333_69398 = state_69298__$1;
(statearr_69333_69398[(1)] = (13));

} else {
var statearr_69334_69399 = state_69298__$1;
(statearr_69334_69399[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (2))){
var _ = (function (){var statearr_69335 = state_69298;
(statearr_69335[(4)] = cljs.core.cons((5),(state_69298[(4)])));

return statearr_69335;
})();
var inst_69173 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_69174 = cljs.core.sequential_QMARK_(inst_69173);
var state_69298__$1 = state_69298;
if(inst_69174){
var statearr_69336_69400 = state_69298__$1;
(statearr_69336_69400[(1)] = (6));

} else {
var statearr_69337_69401 = state_69298__$1;
(statearr_69337_69401[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (23))){
var inst_69207 = (state_69298[(8)]);
var inst_69208 = (state_69298[(7)]);
var inst_69228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69229 = [inst_69207,inst_69208];
var inst_69230 = (new cljs.core.PersistentVector(null,2,(5),inst_69228,inst_69229,null));
var state_69298__$1 = state_69298;
var statearr_69338_69402 = state_69298__$1;
(statearr_69338_69402[(2)] = inst_69230);

(statearr_69338_69402[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (35))){
var inst_69184 = (state_69298[(18)]);
var inst_69263 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69184], 0));
var inst_69264 = ["Invalid block range provided: ",inst_69263].join('');
var inst_69265 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69266 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69267 = cljs.core.PersistentHashMap.fromArrays(inst_69265,inst_69266);
var inst_69268 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69264,inst_69267);
var inst_69269 = (function(){throw inst_69268})();
var state_69298__$1 = state_69298;
var statearr_69339_69403 = state_69298__$1;
(statearr_69339_69403[(2)] = inst_69269);

(statearr_69339_69403[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (19))){
var inst_69207 = (state_69298[(8)]);
var inst_69222 = (state_69298[(2)]);
var state_69298__$1 = (function (){var statearr_69340 = state_69298;
(statearr_69340[(19)] = inst_69222);

return statearr_69340;
})();
if(cljs.core.truth_(inst_69207)){
var statearr_69341_69404 = state_69298__$1;
(statearr_69341_69404[(1)] = (20));

} else {
var statearr_69342_69405 = state_69298__$1;
(statearr_69342_69405[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (11))){
var inst_69207 = (state_69298[(8)]);
var inst_69209 = (state_69298[(14)]);
var inst_69206 = (state_69298[(2)]);
var inst_69207__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69206,(0),null);
var inst_69208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69206,(1),null);
var inst_69209__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_69210 = (inst_69207__$1 > inst_69209__$1);
var state_69298__$1 = (function (){var statearr_69344 = state_69298;
(statearr_69344[(8)] = inst_69207__$1);

(statearr_69344[(7)] = inst_69208);

(statearr_69344[(14)] = inst_69209__$1);

return statearr_69344;
})();
if(cljs.core.truth_(inst_69210)){
var statearr_69345_69406 = state_69298__$1;
(statearr_69345_69406[(1)] = (17));

} else {
var statearr_69346_69407 = state_69298__$1;
(statearr_69346_69407[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (9))){
var inst_69184 = (state_69298[(18)]);
var inst_69187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69188 = cljs.core.first(inst_69184);
var inst_69189 = fluree.db.time_travel.block_to_int_format(db,inst_69188);
var state_69298__$1 = (function (){var statearr_69347 = state_69298;
(statearr_69347[(11)] = inst_69187);

return statearr_69347;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69298__$1,(12),inst_69189);
} else {
if((state_val_69299 === (5))){
var _ = (function (){var statearr_69348 = state_69298;
(statearr_69348[(4)] = cljs.core.rest((state_69298[(4)])));

return statearr_69348;
})();
var state_69298__$1 = state_69298;
var ex69343 = (state_69298__$1[(2)]);
var statearr_69349_69408 = state_69298__$1;
(statearr_69349_69408[(5)] = ex69343);


if((ex69343 instanceof Error)){
var statearr_69350_69409 = state_69298__$1;
(statearr_69350_69409[(1)] = (4));

(statearr_69350_69409[(5)] = null);

} else {
throw ex69343;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (14))){
var state_69298__$1 = state_69298;
var statearr_69351_69410 = state_69298__$1;
(statearr_69351_69410[(2)] = null);

(statearr_69351_69410[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (26))){
var inst_69207 = (state_69298[(8)]);
var inst_69233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69234 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_69235 = [inst_69207,inst_69234];
var inst_69236 = (new cljs.core.PersistentVector(null,2,(5),inst_69233,inst_69235,null));
var state_69298__$1 = state_69298;
var statearr_69352_69411 = state_69298__$1;
(statearr_69352_69411[(2)] = inst_69236);

(statearr_69352_69411[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (16))){
var inst_69197 = (state_69298[(2)]);
var inst_69198 = fluree.db.util.async.throw_err(inst_69197);
var state_69298__$1 = state_69298;
var statearr_69353_69412 = state_69298__$1;
(statearr_69353_69412[(2)] = inst_69198);

(statearr_69353_69412[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (38))){
var inst_69253 = (state_69298[(9)]);
var inst_69254 = (state_69298[(10)]);
var inst_69275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69276 = [inst_69254,inst_69253];
var inst_69277 = (new cljs.core.PersistentVector(null,2,(5),inst_69275,inst_69276,null));
var state_69298__$1 = state_69298;
var statearr_69354_69413 = state_69298__$1;
(statearr_69354_69413[(2)] = inst_69277);

(statearr_69354_69413[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (30))){
var state_69298__$1 = state_69298;
var statearr_69355_69414 = state_69298__$1;
(statearr_69355_69414[(2)] = null);

(statearr_69355_69414[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (10))){
var inst_69184 = (state_69298[(18)]);
var state_69298__$1 = state_69298;
var statearr_69356_69415 = state_69298__$1;
(statearr_69356_69415[(2)] = inst_69184);

(statearr_69356_69415[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (18))){
var state_69298__$1 = state_69298;
var statearr_69357_69416 = state_69298__$1;
(statearr_69357_69416[(2)] = null);

(statearr_69357_69416[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (42))){
var inst_69285 = (state_69298[(13)]);
var state_69298__$1 = state_69298;
var statearr_69358_69417 = state_69298__$1;
(statearr_69358_69417[(2)] = inst_69285);

(statearr_69358_69417[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (37))){
var inst_69253 = (state_69298[(9)]);
var inst_69254 = (state_69298[(10)]);
var inst_69272 = (state_69298[(2)]);
var inst_69273 = (inst_69254 < inst_69253);
var state_69298__$1 = (function (){var statearr_69359 = state_69298;
(statearr_69359[(20)] = inst_69272);

return statearr_69359;
})();
if(cljs.core.truth_(inst_69273)){
var statearr_69360_69418 = state_69298__$1;
(statearr_69360_69418[(1)] = (38));

} else {
var statearr_69361_69419 = state_69298__$1;
(statearr_69361_69419[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69299 === (8))){
var inst_69184 = (state_69298[(18)]);
var inst_69184__$1 = (state_69298[(2)]);
var inst_69185 = cljs.core.some(cljs.core.string_QMARK_,inst_69184__$1);
var state_69298__$1 = (function (){var statearr_69362 = state_69298;
(statearr_69362[(18)] = inst_69184__$1);

return statearr_69362;
})();
if(cljs.core.truth_(inst_69185)){
var statearr_69363_69420 = state_69298__$1;
(statearr_69363_69420[(1)] = (9));

} else {
var statearr_69364_69421 = state_69298__$1;
(statearr_69364_69421[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_69365 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69365[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__);

(statearr_69365[(1)] = (1));

return statearr_69365;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_69298){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69298);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69366){var ex__2730__auto__ = e69366;
var statearr_69367_69422 = state_69298;
(statearr_69367_69422[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69298[(4)]))){
var statearr_69368_69423 = state_69298;
(statearr_69368_69423[(1)] = cljs.core.first((state_69298[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69424 = state_69298;
state_69298 = G__69424;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = function(state_69298){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_69298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69369 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69369[(6)] = c__2749__auto__);

return statearr_69369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69574){
var state_val_69575 = (state_69574[(1)]);
if((state_val_69575 === (7))){
var inst_69486 = (state_69574[(2)]);
var inst_69487 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69486,(0),null);
var inst_69488 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69486,(1),null);
var inst_69496 = cljs.core.vals(inst_69488);
var inst_69497 = cljs.core.seq(inst_69496);
var inst_69498 = cljs.core.first(inst_69497);
var inst_69499 = cljs.core.next(inst_69497);
var inst_69500 = cljs.core.PersistentVector.EMPTY;
var inst_69501 = inst_69496;
var inst_69502 = inst_69500;
var state_69574__$1 = (function (){var statearr_69576 = state_69574;
(statearr_69576[(7)] = inst_69487);

(statearr_69576[(8)] = inst_69498);

(statearr_69576[(9)] = inst_69499);

(statearr_69576[(10)] = inst_69502);

(statearr_69576[(11)] = inst_69501);

return statearr_69576;
})();
var statearr_69577_69630 = state_69574__$1;
(statearr_69577_69630[(2)] = null);

(statearr_69577_69630[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (20))){
var inst_69508 = (state_69574[(12)]);
var inst_69513 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_69514 = cljs.core.PersistentHashMap.EMPTY;
var inst_69515 = [true,inst_69514];
var inst_69516 = cljs.core.PersistentHashMap.fromArrays(inst_69513,inst_69515);
var inst_69517 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_69516,inst_69508);
var state_69574__$1 = state_69574;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69574__$1,(22),inst_69517);
} else {
if((state_val_69575 === (27))){
var inst_69562 = (state_69574[(2)]);
var state_69574__$1 = state_69574;
var statearr_69578_69631 = state_69574__$1;
(statearr_69578_69631[(2)] = inst_69562);

(statearr_69578_69631[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (1))){
var state_69574__$1 = state_69574;
var statearr_69579_69632 = state_69574__$1;
(statearr_69579_69632[(2)] = null);

(statearr_69579_69632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (24))){
var inst_69526 = (state_69574[(13)]);
var inst_69564 = (state_69574[(2)]);
var inst_69565 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_69566 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69567 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69568 = [inst_69566,inst_69567,inst_69526,inst_69564];
var inst_69569 = cljs.core.PersistentHashMap.fromArrays(inst_69565,inst_69568);
var _ = (function (){var statearr_69581 = state_69574;
(statearr_69581[(4)] = cljs.core.rest((state_69574[(4)])));

return statearr_69581;
})();
var state_69574__$1 = state_69574;
var statearr_69582_69633 = state_69574__$1;
(statearr_69582_69633[(2)] = inst_69569);

(statearr_69582_69633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (4))){
var inst_69427 = (state_69574[(2)]);
var state_69574__$1 = state_69574;
var statearr_69583_69634 = state_69574__$1;
(statearr_69583_69634[(2)] = inst_69427);

(statearr_69583_69634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (15))){
var inst_69467 = (state_69574[(14)]);
var inst_69445 = (state_69574[(15)]);
var inst_69472 = (state_69574[(16)]);
var inst_69443 = (state_69574[(17)]);
var inst_69457 = (state_69574[(18)]);
var inst_69458 = (state_69574[(19)]);
var inst_69450 = (state_69574[(20)]);
var inst_69449 = (state_69574[(21)]);
var inst_69451 = (state_69574[(22)]);
var inst_69446 = (state_69574[(23)]);
var inst_69465 = (state_69574[(24)]);
var inst_69478 = (function (){var vec__69453 = inst_69449;
var subject = inst_69465;
var flake = inst_69457;
var vec__69440 = inst_69443;
var seq__69454 = inst_69458;
var r = inst_69458;
var first__69442 = inst_69445;
var asserted_subjects = inst_69450;
var seq__69441 = inst_69446;
var flake_SINGLEQUOTE_ = inst_69472;
var retracted_subjects = inst_69451;
var G__69439 = inst_69449;
var asserted_QMARK_ = inst_69467;
var first__69455 = inst_69457;
return (function (p1__69426_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__69426_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_69479 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_69451,inst_69465,inst_69478);
var tmp69580 = inst_69450;
var inst_69449__$1 = inst_69458;
var inst_69450__$1 = tmp69580;
var inst_69451__$1 = inst_69479;
var state_69574__$1 = (function (){var statearr_69584 = state_69574;
(statearr_69584[(20)] = inst_69450__$1);

(statearr_69584[(21)] = inst_69449__$1);

(statearr_69584[(22)] = inst_69451__$1);

return statearr_69584;
})();
var statearr_69585_69635 = state_69574__$1;
(statearr_69585_69635[(2)] = null);

(statearr_69585_69635[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (21))){
var inst_69524 = (state_69574[(2)]);
var state_69574__$1 = state_69574;
var statearr_69586_69636 = state_69574__$1;
(statearr_69586_69636[(2)] = inst_69524);

(statearr_69586_69636[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (13))){
var inst_69467 = (state_69574[(14)]);
var inst_69472 = (state_69574[(2)]);
var state_69574__$1 = (function (){var statearr_69587 = state_69574;
(statearr_69587[(16)] = inst_69472);

return statearr_69587;
})();
if(cljs.core.truth_(inst_69467)){
var statearr_69588_69637 = state_69574__$1;
(statearr_69588_69637[(1)] = (14));

} else {
var statearr_69589_69638 = state_69574__$1;
(statearr_69589_69638[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (22))){
var inst_69509 = (state_69574[(25)]);
var inst_69502 = (state_69574[(10)]);
var inst_69519 = (state_69574[(2)]);
var inst_69520 = fluree.db.util.async.throw_err(inst_69519);
var inst_69521 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_69502,inst_69520);
var inst_69501 = inst_69509;
var inst_69502__$1 = inst_69521;
var state_69574__$1 = (function (){var statearr_69590 = state_69574;
(statearr_69590[(10)] = inst_69502__$1);

(statearr_69590[(11)] = inst_69501);

return statearr_69590;
})();
var statearr_69591_69639 = state_69574__$1;
(statearr_69591_69639[(2)] = null);

(statearr_69591_69639[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (6))){
var inst_69457 = (state_69574[(18)]);
var inst_69449 = (state_69574[(21)]);
var inst_69456 = cljs.core.seq(inst_69449);
var inst_69457__$1 = cljs.core.first(inst_69456);
var inst_69458 = cljs.core.next(inst_69456);
var inst_69459 = cljs.core.not(inst_69457__$1);
var state_69574__$1 = (function (){var statearr_69592 = state_69574;
(statearr_69592[(18)] = inst_69457__$1);

(statearr_69592[(19)] = inst_69458);

return statearr_69592;
})();
if(inst_69459){
var statearr_69593_69640 = state_69574__$1;
(statearr_69593_69640[(1)] = (8));

} else {
var statearr_69594_69641 = state_69574__$1;
(statearr_69594_69641[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (28))){
var inst_69547 = (state_69574[(26)]);
var inst_69540 = (state_69574[(27)]);
var inst_69557 = (state_69574[(2)]);
var inst_69558 = fluree.db.util.async.throw_err(inst_69557);
var inst_69559 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_69540,inst_69558);
var inst_69539 = inst_69547;
var inst_69540__$1 = inst_69559;
var state_69574__$1 = (function (){var statearr_69595 = state_69574;
(statearr_69595[(27)] = inst_69540__$1);

(statearr_69595[(28)] = inst_69539);

return statearr_69595;
})();
var statearr_69596_69642 = state_69574__$1;
(statearr_69596_69642[(2)] = null);

(statearr_69596_69642[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (25))){
var inst_69540 = (state_69574[(27)]);
var state_69574__$1 = state_69574;
var statearr_69597_69643 = state_69574__$1;
(statearr_69597_69643[(2)] = inst_69540);

(statearr_69597_69643[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (17))){
var inst_69501 = (state_69574[(11)]);
var inst_69508 = (state_69574[(12)]);
var inst_69507 = cljs.core.seq(inst_69501);
var inst_69508__$1 = cljs.core.first(inst_69507);
var inst_69509 = cljs.core.next(inst_69507);
var inst_69510 = cljs.core.not(inst_69508__$1);
var state_69574__$1 = (function (){var statearr_69598 = state_69574;
(statearr_69598[(25)] = inst_69509);

(statearr_69598[(12)] = inst_69508__$1);

return statearr_69598;
})();
if(inst_69510){
var statearr_69599_69644 = state_69574__$1;
(statearr_69599_69644[(1)] = (19));

} else {
var statearr_69600_69645 = state_69574__$1;
(statearr_69600_69645[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (3))){
var inst_69572 = (state_69574[(2)]);
var state_69574__$1 = state_69574;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69574__$1,inst_69572);
} else {
if((state_val_69575 === (12))){
var inst_69457 = (state_69574[(18)]);
var inst_69470 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_69457);
var state_69574__$1 = state_69574;
var statearr_69601_69646 = state_69574__$1;
(statearr_69601_69646[(2)] = inst_69470);

(statearr_69601_69646[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (2))){
var inst_69443 = (state_69574[(17)]);
var _ = (function (){var statearr_69602 = state_69574;
(statearr_69602[(4)] = cljs.core.cons((5),(state_69574[(4)])));

return statearr_69602;
})();
var inst_69443__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_69444 = cljs.core.seq(inst_69443__$1);
var inst_69445 = cljs.core.first(inst_69444);
var inst_69446 = cljs.core.next(inst_69444);
var inst_69447 = cljs.core.PersistentHashMap.EMPTY;
var inst_69448 = cljs.core.PersistentHashMap.EMPTY;
var inst_69449 = inst_69443__$1;
var inst_69450 = inst_69447;
var inst_69451 = inst_69448;
var state_69574__$1 = (function (){var statearr_69603 = state_69574;
(statearr_69603[(15)] = inst_69445);

(statearr_69603[(17)] = inst_69443__$1);

(statearr_69603[(20)] = inst_69450);

(statearr_69603[(21)] = inst_69449);

(statearr_69603[(22)] = inst_69451);

(statearr_69603[(23)] = inst_69446);

return statearr_69603;
})();
var statearr_69604_69647 = state_69574__$1;
(statearr_69604_69647[(2)] = null);

(statearr_69604_69647[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (23))){
var inst_69546 = (state_69574[(29)]);
var inst_69539 = (state_69574[(28)]);
var inst_69545 = cljs.core.seq(inst_69539);
var inst_69546__$1 = cljs.core.first(inst_69545);
var inst_69547 = cljs.core.next(inst_69545);
var inst_69548 = cljs.core.not(inst_69546__$1);
var state_69574__$1 = (function (){var statearr_69605 = state_69574;
(statearr_69605[(26)] = inst_69547);

(statearr_69605[(29)] = inst_69546__$1);

return statearr_69605;
})();
if(inst_69548){
var statearr_69606_69648 = state_69574__$1;
(statearr_69606_69648[(1)] = (25));

} else {
var statearr_69607_69649 = state_69574__$1;
(statearr_69607_69649[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (19))){
var inst_69502 = (state_69574[(10)]);
var state_69574__$1 = state_69574;
var statearr_69608_69650 = state_69574__$1;
(statearr_69608_69650[(2)] = inst_69502);

(statearr_69608_69650[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (11))){
var inst_69457 = (state_69574[(18)]);
var state_69574__$1 = state_69574;
var statearr_69610_69651 = state_69574__$1;
(statearr_69610_69651[(2)] = inst_69457);

(statearr_69610_69651[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (9))){
var inst_69467 = (state_69574[(14)]);
var inst_69457 = (state_69574[(18)]);
var inst_69465 = fluree.db.flake.s(inst_69457);
var inst_69466 = fluree.db.flake.op(inst_69457);
var inst_69467__$1 = inst_69466 === true;
var state_69574__$1 = (function (){var statearr_69612 = state_69574;
(statearr_69612[(14)] = inst_69467__$1);

(statearr_69612[(24)] = inst_69465);

return statearr_69612;
})();
if(cljs.core.truth_(inst_69467__$1)){
var statearr_69613_69652 = state_69574__$1;
(statearr_69613_69652[(1)] = (11));

} else {
var statearr_69614_69653 = state_69574__$1;
(statearr_69614_69653[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (5))){
var _ = (function (){var statearr_69615 = state_69574;
(statearr_69615[(4)] = cljs.core.rest((state_69574[(4)])));

return statearr_69615;
})();
var state_69574__$1 = state_69574;
var ex69609 = (state_69574__$1[(2)]);
var statearr_69616_69654 = state_69574__$1;
(statearr_69616_69654[(5)] = ex69609);


if((ex69609 instanceof Error)){
var statearr_69617_69655 = state_69574__$1;
(statearr_69617_69655[(1)] = (4));

(statearr_69617_69655[(5)] = null);

} else {
throw ex69609;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (14))){
var inst_69467 = (state_69574[(14)]);
var inst_69445 = (state_69574[(15)]);
var inst_69472 = (state_69574[(16)]);
var inst_69443 = (state_69574[(17)]);
var inst_69457 = (state_69574[(18)]);
var inst_69458 = (state_69574[(19)]);
var inst_69450 = (state_69574[(20)]);
var inst_69449 = (state_69574[(21)]);
var inst_69451 = (state_69574[(22)]);
var inst_69446 = (state_69574[(23)]);
var inst_69465 = (state_69574[(24)]);
var inst_69474 = (function (){var vec__69453 = inst_69449;
var subject = inst_69465;
var flake = inst_69457;
var vec__69440 = inst_69443;
var seq__69454 = inst_69458;
var r = inst_69458;
var first__69442 = inst_69445;
var asserted_subjects = inst_69450;
var seq__69441 = inst_69446;
var flake_SINGLEQUOTE_ = inst_69472;
var retracted_subjects = inst_69451;
var G__69439 = inst_69449;
var asserted_QMARK_ = inst_69467;
var first__69455 = inst_69457;
return (function (p1__69425_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__69425_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_69475 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_69450,inst_69465,inst_69474);
var tmp69611 = inst_69451;
var inst_69449__$1 = inst_69458;
var inst_69450__$1 = inst_69475;
var inst_69451__$1 = tmp69611;
var state_69574__$1 = (function (){var statearr_69618 = state_69574;
(statearr_69618[(20)] = inst_69450__$1);

(statearr_69618[(21)] = inst_69449__$1);

(statearr_69618[(22)] = inst_69451__$1);

return statearr_69618;
})();
var statearr_69619_69656 = state_69574__$1;
(statearr_69619_69656[(2)] = null);

(statearr_69619_69656[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (26))){
var inst_69546 = (state_69574[(29)]);
var inst_69551 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_69552 = cljs.core.PersistentHashMap.EMPTY;
var inst_69553 = [true,inst_69552];
var inst_69554 = cljs.core.PersistentHashMap.fromArrays(inst_69551,inst_69553);
var inst_69555 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_69554,inst_69546);
var state_69574__$1 = state_69574;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69574__$1,(28),inst_69555);
} else {
if((state_val_69575 === (16))){
var inst_69482 = (state_69574[(2)]);
var state_69574__$1 = state_69574;
var statearr_69620_69657 = state_69574__$1;
(statearr_69620_69657[(2)] = inst_69482);

(statearr_69620_69657[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (10))){
var inst_69484 = (state_69574[(2)]);
var state_69574__$1 = state_69574;
var statearr_69621_69658 = state_69574__$1;
(statearr_69621_69658[(2)] = inst_69484);

(statearr_69621_69658[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (18))){
var inst_69487 = (state_69574[(7)]);
var inst_69526 = (state_69574[(2)]);
var inst_69534 = cljs.core.vals(inst_69487);
var inst_69535 = cljs.core.seq(inst_69534);
var inst_69536 = cljs.core.first(inst_69535);
var inst_69537 = cljs.core.next(inst_69535);
var inst_69538 = cljs.core.PersistentVector.EMPTY;
var inst_69539 = inst_69534;
var inst_69540 = inst_69538;
var state_69574__$1 = (function (){var statearr_69622 = state_69574;
(statearr_69622[(30)] = inst_69536);

(statearr_69622[(13)] = inst_69526);

(statearr_69622[(31)] = inst_69537);

(statearr_69622[(27)] = inst_69540);

(statearr_69622[(28)] = inst_69539);

return statearr_69622;
})();
var statearr_69623_69659 = state_69574__$1;
(statearr_69623_69659[(2)] = null);

(statearr_69623_69659[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69575 === (8))){
var inst_69450 = (state_69574[(20)]);
var inst_69451 = (state_69574[(22)]);
var inst_69461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69462 = [inst_69450,inst_69451];
var inst_69463 = (new cljs.core.PersistentVector(null,2,(5),inst_69461,inst_69462,null));
var state_69574__$1 = state_69574;
var statearr_69624_69660 = state_69574__$1;
(statearr_69624_69660[(2)] = inst_69463);

(statearr_69624_69660[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_69625 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69625[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_69625[(1)] = (1));

return statearr_69625;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_69574){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69574);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69626){var ex__2730__auto__ = e69626;
var statearr_69627_69661 = state_69574;
(statearr_69627_69661[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69574[(4)]))){
var statearr_69628_69662 = state_69574;
(statearr_69628_69662[(1)] = cljs.core.first((state_69574[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69663 = state_69574;
state_69574 = G__69663;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_69574){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_69574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69629 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69629[(6)] = c__2749__auto__);

return statearr_69629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69695){
var state_val_69696 = (state_69695[(1)]);
if((state_val_69696 === (1))){
var inst_69664 = cljs.core.volatile_BANG_((0));
var inst_69665 = cljs.core.PersistentHashMap.EMPTY;
var inst_69666 = cljs.core.volatile_BANG_(inst_69665);
var inst_69667 = cljs.core.first(resp);
var inst_69668 = cljs.core.rest(resp);
var inst_69669 = cljs.core.PersistentVector.EMPTY;
var inst_69670 = inst_69664;
var inst_69671 = inst_69666;
var inst_69672 = inst_69667;
var inst_69673 = inst_69668;
var inst_69674 = inst_69669;
var state_69695__$1 = (function (){var statearr_69697 = state_69695;
(statearr_69697[(7)] = inst_69670);

(statearr_69697[(8)] = inst_69674);

(statearr_69697[(9)] = inst_69673);

(statearr_69697[(10)] = inst_69672);

(statearr_69697[(11)] = inst_69671);

return statearr_69697;
})();
var statearr_69698_69713 = state_69695__$1;
(statearr_69698_69713[(2)] = null);

(statearr_69698_69713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69696 === (2))){
var inst_69670 = (state_69695[(7)]);
var inst_69672 = (state_69695[(10)]);
var inst_69671 = (state_69695[(11)]);
var inst_69676 = fluree.db.api.query.format_block_resp_pretty(db,inst_69672,inst_69671,inst_69670);
var state_69695__$1 = state_69695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69695__$1,(4),inst_69676);
} else {
if((state_val_69696 === (3))){
var inst_69693 = (state_69695[(2)]);
var state_69695__$1 = state_69695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69695__$1,inst_69693);
} else {
if((state_val_69696 === (4))){
var inst_69674 = (state_69695[(8)]);
var inst_69673 = (state_69695[(9)]);
var inst_69678 = (state_69695[(2)]);
var inst_69679 = fluree.db.util.async.throw_err(inst_69678);
var inst_69680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69681 = [inst_69679];
var inst_69682 = (new cljs.core.PersistentVector(null,1,(5),inst_69680,inst_69681,null));
var inst_69683 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_69674,inst_69682);
var inst_69684 = cljs.core.first(inst_69673);
var state_69695__$1 = (function (){var statearr_69701 = state_69695;
(statearr_69701[(12)] = inst_69683);

return statearr_69701;
})();
if(cljs.core.truth_(inst_69684)){
var statearr_69702_69714 = state_69695__$1;
(statearr_69702_69714[(1)] = (5));

} else {
var statearr_69703_69715 = state_69695__$1;
(statearr_69703_69715[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69696 === (5))){
var inst_69670 = (state_69695[(7)]);
var inst_69673 = (state_69695[(9)]);
var inst_69671 = (state_69695[(11)]);
var inst_69683 = (state_69695[(12)]);
var inst_69686 = cljs.core.first(inst_69673);
var inst_69687 = cljs.core.rest(inst_69673);
var tmp69699 = inst_69670;
var tmp69700 = inst_69671;
var inst_69670__$1 = tmp69699;
var inst_69671__$1 = tmp69700;
var inst_69672 = inst_69686;
var inst_69673__$1 = inst_69687;
var inst_69674 = inst_69683;
var state_69695__$1 = (function (){var statearr_69704 = state_69695;
(statearr_69704[(7)] = inst_69670__$1);

(statearr_69704[(8)] = inst_69674);

(statearr_69704[(9)] = inst_69673__$1);

(statearr_69704[(10)] = inst_69672);

(statearr_69704[(11)] = inst_69671__$1);

return statearr_69704;
})();
var statearr_69705_69716 = state_69695__$1;
(statearr_69705_69716[(2)] = null);

(statearr_69705_69716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69696 === (6))){
var inst_69683 = (state_69695[(12)]);
var state_69695__$1 = state_69695;
var statearr_69706_69717 = state_69695__$1;
(statearr_69706_69717[(2)] = inst_69683);

(statearr_69706_69717[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69696 === (7))){
var inst_69691 = (state_69695[(2)]);
var state_69695__$1 = state_69695;
var statearr_69707_69718 = state_69695__$1;
(statearr_69707_69718[(2)] = inst_69691);

(statearr_69707_69718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_69708 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69708[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__);

(statearr_69708[(1)] = (1));

return statearr_69708;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1 = (function (state_69695){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69695);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69709){var ex__2730__auto__ = e69709;
var statearr_69710_69719 = state_69695;
(statearr_69710_69719[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69695[(4)]))){
var statearr_69711_69720 = state_69695;
(statearr_69711_69720[(1)] = cljs.core.first((state_69695[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69721 = state_69695;
state_69695 = G__69721;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = function(state_69695){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1.call(this,state_69695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69712 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69712[(6)] = c__2749__auto__);

return statearr_69712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__69723 = arguments.length;
switch (G__69723) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__69725){
var map__69726 = p__69725;
var map__69726__$1 = cljs.core.__destructure_map(map__69726);
var query = map__69726__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69726__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69811){
var state_val_69812 = (state_69811[(1)]);
if((state_val_69812 === (7))){
var inst_69737 = (state_69811[(7)]);
var inst_69741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69742 = ["_auth/id",inst_69737];
var inst_69743 = (new cljs.core.PersistentVector(null,2,(5),inst_69741,inst_69742,null));
var state_69811__$1 = state_69811;
var statearr_69813_69857 = state_69811__$1;
(statearr_69813_69857[(2)] = inst_69743);

(statearr_69813_69857[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (20))){
var inst_69791 = (state_69811[(2)]);
var inst_69792 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_69811__$1 = (function (){var statearr_69814 = state_69811;
(statearr_69814[(8)] = inst_69791);

return statearr_69814;
})();
if(cljs.core.truth_(inst_69792)){
var statearr_69815_69858 = state_69811__$1;
(statearr_69815_69858[(1)] = (22));

} else {
var statearr_69816_69859 = state_69811__$1;
(statearr_69816_69859[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (27))){
var inst_69738 = (state_69811[(9)]);
var inst_69794 = (state_69811[(10)]);
var inst_69800 = (state_69811[(2)]);
var inst_69801 = fluree.db.util.core.response_time_formatted(inst_69738);
var inst_69802 = [(200),inst_69800,(100),inst_69801];
var inst_69803 = cljs.core.PersistentHashMap.fromArrays(inst_69794,inst_69802);
var state_69811__$1 = state_69811;
var statearr_69817_69860 = state_69811__$1;
(statearr_69817_69860[(2)] = inst_69803);

(statearr_69817_69860[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (1))){
var state_69811__$1 = state_69811;
var statearr_69818_69861 = state_69811__$1;
(statearr_69818_69861[(2)] = null);

(statearr_69818_69861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (24))){
var inst_69806 = (state_69811[(2)]);
var _ = (function (){var statearr_69819 = state_69811;
(statearr_69819[(4)] = cljs.core.rest((state_69811[(4)])));

return statearr_69819;
})();
var state_69811__$1 = state_69811;
var statearr_69820_69862 = state_69811__$1;
(statearr_69820_69862[(2)] = inst_69806);

(statearr_69820_69862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (4))){
var inst_69727 = (state_69811[(2)]);
var state_69811__$1 = state_69811;
var statearr_69821_69863 = state_69811__$1;
(statearr_69821_69863[(2)] = inst_69727);

(statearr_69821_69863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (15))){
var inst_69778 = (state_69811[(11)]);
var state_69811__$1 = state_69811;
var statearr_69822_69864 = state_69811__$1;
(statearr_69822_69864[(2)] = inst_69778);

(statearr_69822_69864[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (21))){
var inst_69787 = (state_69811[(2)]);
var inst_69788 = fluree.db.util.async.throw_err(inst_69787);
var state_69811__$1 = state_69811;
var statearr_69823_69865 = state_69811__$1;
(statearr_69823_69865[(2)] = inst_69788);

(statearr_69823_69865[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (13))){
var inst_69778 = (state_69811[(11)]);
var inst_69736 = (state_69811[(12)]);
var inst_69777 = (state_69811[(2)]);
var inst_69778__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_69736);
var state_69811__$1 = (function (){var statearr_69824 = state_69811;
(statearr_69824[(11)] = inst_69778__$1);

(statearr_69824[(13)] = inst_69777);

return statearr_69824;
})();
if(cljs.core.truth_(inst_69778__$1)){
var statearr_69825_69866 = state_69811__$1;
(statearr_69825_69866[(1)] = (15));

} else {
var statearr_69826_69867 = state_69811__$1;
(statearr_69826_69867[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (22))){
var inst_69791 = (state_69811[(8)]);
var inst_69794 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_69795 = cljs.core.sequential_QMARK_(inst_69791);
var state_69811__$1 = (function (){var statearr_69827 = state_69811;
(statearr_69827[(10)] = inst_69794);

return statearr_69827;
})();
if(inst_69795){
var statearr_69828_69868 = state_69811__$1;
(statearr_69828_69868[(1)] = (25));

} else {
var statearr_69829_69869 = state_69811__$1;
(statearr_69829_69869[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (6))){
var inst_69752 = (state_69811[(14)]);
var inst_69736 = (state_69811[(12)]);
var inst_69751 = (state_69811[(2)]);
var inst_69752__$1 = fluree.db.util.async.throw_err(inst_69751);
var inst_69753 = fluree.db.api.query.resolve_block_range(inst_69752__$1,inst_69736);
var state_69811__$1 = (function (){var statearr_69830 = state_69811;
(statearr_69830[(14)] = inst_69752__$1);

return statearr_69830;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69811__$1,(10),inst_69753);
} else {
if((state_val_69812 === (25))){
var inst_69791 = (state_69811[(8)]);
var inst_69797 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_69791);
var state_69811__$1 = state_69811;
var statearr_69831_69870 = state_69811__$1;
(statearr_69831_69870[(2)] = inst_69797);

(statearr_69831_69870[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (17))){
var inst_69783 = (state_69811[(2)]);
var state_69811__$1 = state_69811;
if(cljs.core.truth_(inst_69783)){
var statearr_69832_69871 = state_69811__$1;
(statearr_69832_69871[(1)] = (18));

} else {
var statearr_69833_69872 = state_69811__$1;
(statearr_69833_69872[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (3))){
var inst_69809 = (state_69811[(2)]);
var state_69811__$1 = state_69811;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69811__$1,inst_69809);
} else {
if((state_val_69812 === (12))){
var inst_69736 = (state_69811[(12)]);
var inst_69769 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69736], 0));
var inst_69770 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_69769].join('');
var inst_69771 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69772 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69773 = cljs.core.PersistentHashMap.fromArrays(inst_69771,inst_69772);
var inst_69774 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69770,inst_69773);
var inst_69775 = (function(){throw inst_69774})();
var state_69811__$1 = state_69811;
var statearr_69834_69873 = state_69811__$1;
(statearr_69834_69873[(2)] = inst_69775);

(statearr_69834_69873[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (2))){
var inst_69737 = (state_69811[(7)]);
var _ = (function (){var statearr_69835 = state_69811;
(statearr_69835[(4)] = cljs.core.cons((5),(state_69811[(4)])));

return statearr_69835;
})();
var inst_69736 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_69737__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_69738 = fluree.db.util.core.current_time_millis();
var inst_69739 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_69811__$1 = (function (){var statearr_69836 = state_69811;
(statearr_69836[(12)] = inst_69736);

(statearr_69836[(15)] = inst_69739);

(statearr_69836[(9)] = inst_69738);

(statearr_69836[(7)] = inst_69737__$1);

return statearr_69836;
})();
if(cljs.core.truth_(inst_69737__$1)){
var statearr_69837_69874 = state_69811__$1;
(statearr_69837_69874[(1)] = (7));

} else {
var statearr_69838_69875 = state_69811__$1;
(statearr_69838_69875[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (23))){
var inst_69791 = (state_69811[(8)]);
var state_69811__$1 = state_69811;
var statearr_69839_69876 = state_69811__$1;
(statearr_69839_69876[(2)] = inst_69791);

(statearr_69839_69876[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (19))){
var inst_69777 = (state_69811[(13)]);
var state_69811__$1 = state_69811;
var statearr_69840_69877 = state_69811__$1;
(statearr_69840_69877[(2)] = inst_69777);

(statearr_69840_69877[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (11))){
var inst_69752 = (state_69811[(14)]);
var inst_69758 = (state_69811[(16)]);
var inst_69757 = (state_69811[(17)]);
var inst_69764 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_69752,inst_69757,inst_69758,opts);
var state_69811__$1 = state_69811;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69811__$1,(14),inst_69764);
} else {
if((state_val_69812 === (9))){
var inst_69739 = (state_69811[(15)]);
var inst_69746 = (state_69811[(2)]);
var inst_69747 = [inst_69746];
var inst_69748 = cljs.core.PersistentHashMap.fromArrays(inst_69739,inst_69747);
var inst_69749 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_69748);
var state_69811__$1 = state_69811;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69811__$1,(6),inst_69749);
} else {
if((state_val_69812 === (5))){
var _ = (function (){var statearr_69842 = state_69811;
(statearr_69842[(4)] = cljs.core.rest((state_69811[(4)])));

return statearr_69842;
})();
var state_69811__$1 = state_69811;
var ex69841 = (state_69811__$1[(2)]);
var statearr_69843_69878 = state_69811__$1;
(statearr_69843_69878[(5)] = ex69841);


if((ex69841 instanceof Error)){
var statearr_69844_69879 = state_69811__$1;
(statearr_69844_69879[(1)] = (4));

(statearr_69844_69879[(5)] = null);

} else {
throw ex69841;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (14))){
var inst_69766 = (state_69811[(2)]);
var inst_69767 = fluree.db.util.async.throw_err(inst_69766);
var state_69811__$1 = state_69811;
var statearr_69845_69880 = state_69811__$1;
(statearr_69845_69880[(2)] = inst_69767);

(statearr_69845_69880[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (26))){
var inst_69791 = (state_69811[(8)]);
var state_69811__$1 = state_69811;
var statearr_69846_69881 = state_69811__$1;
(statearr_69846_69881[(2)] = inst_69791);

(statearr_69846_69881[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (16))){
var inst_69736 = (state_69811[(12)]);
var inst_69781 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_69736);
var state_69811__$1 = state_69811;
var statearr_69847_69882 = state_69811__$1;
(statearr_69847_69882[(2)] = inst_69781);

(statearr_69847_69882[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (10))){
var inst_69736 = (state_69811[(12)]);
var inst_69755 = (state_69811[(2)]);
var inst_69756 = fluree.db.util.async.throw_err(inst_69755);
var inst_69757 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69756,(0),null);
var inst_69758 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69756,(1),null);
var inst_69759 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_69760 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_69736,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_69761 = cljs.core.keys(inst_69760);
var inst_69762 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_69759,inst_69761);
var state_69811__$1 = (function (){var statearr_69848 = state_69811;
(statearr_69848[(16)] = inst_69758);

(statearr_69848[(17)] = inst_69757);

return statearr_69848;
})();
if(inst_69762){
var statearr_69849_69883 = state_69811__$1;
(statearr_69849_69883[(1)] = (11));

} else {
var statearr_69850_69884 = state_69811__$1;
(statearr_69850_69884[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69812 === (18))){
var inst_69752 = (state_69811[(14)]);
var inst_69777 = (state_69811[(13)]);
var inst_69785 = fluree.db.api.query.format_blocks_resp_pretty(inst_69752,inst_69777);
var state_69811__$1 = state_69811;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69811__$1,(21),inst_69785);
} else {
if((state_val_69812 === (8))){
var state_69811__$1 = state_69811;
var statearr_69851_69885 = state_69811__$1;
(statearr_69851_69885[(2)] = null);

(statearr_69851_69885[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_69852 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69852[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2727__auto__);

(statearr_69852[(1)] = (1));

return statearr_69852;
});
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1 = (function (state_69811){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69811);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e69853){var ex__2730__auto__ = e69853;
var statearr_69854_69886 = state_69811;
(statearr_69854_69886[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69811[(4)]))){
var statearr_69855_69887 = state_69811;
(statearr_69855_69887[(1)] = cljs.core.first((state_69811[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69888 = state_69811;
state_69811 = G__69888;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = function(state_69811){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1.call(this,state_69811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_69856 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_69856[(6)] = c__2749__auto__);

return statearr_69856;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__69889 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69889,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69889,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69889,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69889,(3),null);
var vec__69892 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69892,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69892,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__69895 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t(flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69895,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69895,(1),null);
var or__4253__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69899 = arguments.length;
var i__4865__auto___69900 = (0);
while(true){
if((i__4865__auto___69900 < len__4864__auto___69899)){
args__4870__auto__.push((arguments[i__4865__auto___69900]));

var G__69901 = (i__4865__auto___69900 + (1));
i__4865__auto___69900 = G__69901;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq69898){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69898));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70097){
var state_val_70098 = (state_70097[(1)]);
if((state_val_70098 === (7))){
var inst_70024 = (state_70097[(7)]);
var inst_70017 = (state_70097[(8)]);
var inst_70023 = cljs.core.seq(inst_70017);
var inst_70024__$1 = cljs.core.first(inst_70023);
var inst_70025 = cljs.core.next(inst_70023);
var state_70097__$1 = (function (){var statearr_70099 = state_70097;
(statearr_70099[(7)] = inst_70024__$1);

(statearr_70099[(9)] = inst_70025);

return statearr_70099;
})();
if(cljs.core.truth_(inst_70024__$1)){
var statearr_70100_70200 = state_70097__$1;
(statearr_70100_70200[(1)] = (9));

} else {
var statearr_70101_70201 = state_70097__$1;
(statearr_70101_70201[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (20))){
var inst_70087 = (state_70097[(2)]);
var state_70097__$1 = state_70097;
var statearr_70102_70202 = state_70097__$1;
(statearr_70102_70202[(2)] = inst_70087);

(statearr_70102_70202[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (27))){
var inst_70063 = (state_70097[(10)]);
var inst_70045 = (state_70097[(11)]);
var inst_70042 = (state_70097[(12)]);
var inst_70065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70066 = [inst_70045,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_70067 = (new cljs.core.PersistentVector(null,2,(5),inst_70065,inst_70066,null));
var inst_70068 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_70063,inst_70067,fluree.db.api.query.min_safe,inst_70042);
var state_70097__$1 = state_70097;
var statearr_70103_70203 = state_70097__$1;
(statearr_70103_70203[(2)] = inst_70068);

(statearr_70103_70203[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (1))){
var state_70097__$1 = state_70097;
var statearr_70104_70204 = state_70097__$1;
(statearr_70104_70204[(2)] = null);

(statearr_70104_70204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (24))){
var inst_70024 = (state_70097[(7)]);
var inst_70045 = (state_70097[(11)]);
var inst_70055 = (state_70097[(13)]);
var inst_70057 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70058 = [inst_70045,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_70059 = (new cljs.core.PersistentVector(null,2,(5),inst_70057,inst_70058,null));
var inst_70060 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_70055,inst_70059,cljs.core.conj,inst_70024);
var state_70097__$1 = state_70097;
var statearr_70106_70205 = state_70097__$1;
(statearr_70106_70205[(2)] = inst_70060);

(statearr_70106_70205[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (4))){
var inst_69903 = (state_70097[(2)]);
var state_70097__$1 = state_70097;
var statearr_70107_70206 = state_70097__$1;
(statearr_70107_70206[(2)] = inst_69903);

(statearr_70107_70206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (15))){
var inst_70018 = (state_70097[(14)]);
var inst_70025 = (state_70097[(9)]);
var tmp70105 = inst_70018;
var inst_70017 = inst_70025;
var inst_70018__$1 = tmp70105;
var state_70097__$1 = (function (){var statearr_70108 = state_70097;
(statearr_70108[(8)] = inst_70017);

(statearr_70108[(14)] = inst_70018__$1);

return statearr_70108;
})();
var statearr_70109_70207 = state_70097__$1;
(statearr_70109_70207[(2)] = null);

(statearr_70109_70207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (21))){
var inst_70045 = (state_70097[(11)]);
var inst_70018 = (state_70097[(14)]);
var inst_70049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70050 = [inst_70045,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70051 = (new cljs.core.PersistentVector(null,2,(5),inst_70049,inst_70050,null));
var inst_70052 = cljs.core.assoc_in(inst_70018,inst_70051,inst_70045);
var state_70097__$1 = state_70097;
var statearr_70110_70208 = state_70097__$1;
(statearr_70110_70208[(2)] = inst_70052);

(statearr_70110_70208[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (31))){
var inst_70071 = (state_70097[(15)]);
var state_70097__$1 = state_70097;
var statearr_70111_70209 = state_70097__$1;
(statearr_70111_70209[(2)] = inst_70071);

(statearr_70111_70209[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (32))){
var inst_70025 = (state_70097[(9)]);
var inst_70079 = (state_70097[(2)]);
var inst_70017 = inst_70025;
var inst_70018 = inst_70079;
var state_70097__$1 = (function (){var statearr_70112 = state_70097;
(statearr_70112[(8)] = inst_70017);

(statearr_70112[(14)] = inst_70018);

return statearr_70112;
})();
var statearr_70113_70210 = state_70097__$1;
(statearr_70113_70210[(2)] = null);

(statearr_70113_70210[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (33))){
var inst_70018 = (state_70097[(14)]);
var state_70097__$1 = state_70097;
var statearr_70114_70211 = state_70097__$1;
(statearr_70114_70211[(2)] = inst_70018);

(statearr_70114_70211[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (13))){
var inst_70027 = (state_70097[(16)]);
var state_70097__$1 = state_70097;
var statearr_70115_70212 = state_70097__$1;
(statearr_70115_70212[(2)] = inst_70027);

(statearr_70115_70212[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (22))){
var inst_70018 = (state_70097[(14)]);
var state_70097__$1 = state_70097;
var statearr_70116_70213 = state_70097__$1;
(statearr_70116_70213[(2)] = inst_70018);

(statearr_70116_70213[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (29))){
var inst_70071 = (state_70097[(2)]);
var state_70097__$1 = (function (){var statearr_70117 = state_70097;
(statearr_70117[(15)] = inst_70071);

return statearr_70117;
})();
if(cljs.core.truth_(show_auth)){
var statearr_70118_70214 = state_70097__$1;
(statearr_70118_70214[(1)] = (30));

} else {
var statearr_70119_70215 = state_70097__$1;
(statearr_70119_70215[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (6))){
var inst_70003 = (state_70097[(2)]);
var inst_70004 = fluree.db.util.async.throw_err(inst_70003);
var inst_70012 = resp;
var inst_70013 = cljs.core.seq(inst_70012);
var inst_70014 = cljs.core.first(inst_70013);
var inst_70015 = cljs.core.next(inst_70013);
var inst_70016 = cljs.core.PersistentHashMap.EMPTY;
var inst_70017 = inst_70012;
var inst_70018 = inst_70016;
var state_70097__$1 = (function (){var statearr_70120 = state_70097;
(statearr_70120[(8)] = inst_70017);

(statearr_70120[(14)] = inst_70018);

(statearr_70120[(17)] = inst_70015);

(statearr_70120[(18)] = inst_70004);

(statearr_70120[(19)] = inst_70014);

return statearr_70120;
})();
var statearr_70121_70216 = state_70097__$1;
(statearr_70121_70216[(2)] = null);

(statearr_70121_70216[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (28))){
var inst_70063 = (state_70097[(10)]);
var state_70097__$1 = state_70097;
var statearr_70122_70217 = state_70097__$1;
(statearr_70122_70217[(2)] = inst_70063);

(statearr_70122_70217[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (25))){
var inst_70055 = (state_70097[(13)]);
var state_70097__$1 = state_70097;
var statearr_70123_70218 = state_70097__$1;
(statearr_70123_70218[(2)] = inst_70055);

(statearr_70123_70218[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (34))){
var state_70097__$1 = state_70097;
var statearr_70124_70219 = state_70097__$1;
(statearr_70124_70219[(2)] = null);

(statearr_70124_70219[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (17))){
var inst_70089 = (state_70097[(2)]);
var state_70097__$1 = state_70097;
var statearr_70125_70220 = state_70097__$1;
(statearr_70125_70220[(2)] = inst_70089);

(statearr_70125_70220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (3))){
var inst_70095 = (state_70097[(2)]);
var state_70097__$1 = state_70097;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70097__$1,inst_70095);
} else {
if((state_val_70098 === (12))){
var inst_70024 = (state_70097[(7)]);
var inst_70004 = (state_70097[(18)]);
var inst_70029 = fluree.db.api.query.auth_match(auth,inst_70004,inst_70024);
var inst_70030 = cljs.core.not(inst_70029);
var state_70097__$1 = state_70097;
var statearr_70126_70221 = state_70097__$1;
(statearr_70126_70221[(2)] = inst_70030);

(statearr_70126_70221[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (2))){
var _ = (function (){var statearr_70127 = state_70097;
(statearr_70127[(4)] = cljs.core.cons((5),(state_70097[(4)])));

return statearr_70127;
})();
var inst_69909 = (function (){return (function (p1__69902_SHARP_){
return fluree.db.flake.t(p1__69902_SHARP_);
});
})();
var inst_69910 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_69909,resp);
var inst_69911 = cljs.core.set(inst_69910);
var inst_69999 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_70000 = (function (){var ts = inst_69911;
var c__2749__auto____$1 = inst_69999;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69997){
var state_val_69998 = (state_69997[(1)]);
if((state_val_69998 === (7))){
var inst_69925 = (state_69997[(7)]);
var inst_69937 = (state_69997[(8)]);
var inst_69943 = (state_69997[(9)]);
var inst_69931 = (state_69997[(10)]);
var inst_69936 = (state_69997[(2)]);
var inst_69937__$1 = fluree.db.util.async.throw_err(inst_69936);
var inst_69939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69940 = [inst_69931,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_69941 = (new cljs.core.PersistentVector(null,2,(5),inst_69939,inst_69940,null));
var inst_69942 = cljs.core.assoc_in(inst_69925,inst_69941,inst_69937__$1);
var inst_69943__$1 = auth;
var state_69997__$1 = (function (){var statearr_70128 = state_69997;
(statearr_70128[(8)] = inst_69937__$1);

(statearr_70128[(9)] = inst_69943__$1);

(statearr_70128[(11)] = inst_69942);

return statearr_70128;
})();
if(cljs.core.truth_(inst_69943__$1)){
var statearr_70129_70222 = state_69997__$1;
(statearr_70129_70222[(1)] = (8));

} else {
var statearr_70130_70223 = state_69997__$1;
(statearr_70130_70223[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69998 === (1))){
var inst_69919 = (state_69997[(12)]);
var inst_69919__$1 = ts;
var inst_69920 = cljs.core.seq(inst_69919__$1);
var inst_69921 = cljs.core.first(inst_69920);
var inst_69922 = cljs.core.next(inst_69920);
var inst_69923 = cljs.core.PersistentHashMap.EMPTY;
var inst_69924 = inst_69919__$1;
var inst_69925 = inst_69923;
var state_69997__$1 = (function (){var statearr_70131 = state_69997;
(statearr_70131[(7)] = inst_69925);

(statearr_70131[(12)] = inst_69919__$1);

(statearr_70131[(13)] = inst_69922);

(statearr_70131[(14)] = inst_69924);

(statearr_70131[(15)] = inst_69921);

return statearr_70131;
})();
var statearr_70132_70224 = state_69997__$1;
(statearr_70132_70224[(2)] = null);

(statearr_70132_70224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69998 === (4))){
var inst_69931 = (state_69997[(10)]);
var inst_69934 = fluree.db.time_travel.non_border_t_to_block(db,inst_69931);
var state_69997__$1 = state_69997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69997__$1,(7),inst_69934);
} else {
if((state_val_69998 === (13))){
var inst_69932 = (state_69997[(16)]);
var inst_69989 = (state_69997[(2)]);
var inst_69924 = inst_69932;
var inst_69925 = inst_69989;
var state_69997__$1 = (function (){var statearr_70133 = state_69997;
(statearr_70133[(7)] = inst_69925);

(statearr_70133[(14)] = inst_69924);

return statearr_70133;
})();
var statearr_70134_70225 = state_69997__$1;
(statearr_70134_70225[(2)] = null);

(statearr_70134_70225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69998 === (6))){
var inst_69993 = (state_69997[(2)]);
var state_69997__$1 = state_69997;
var statearr_70135_70226 = state_69997__$1;
(statearr_70135_70226[(2)] = inst_69993);

(statearr_70135_70226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69998 === (3))){
var inst_69995 = (state_69997[(2)]);
var state_69997__$1 = state_69997;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69997__$1,inst_69995);
} else {
if((state_val_69998 === (12))){
var inst_69942 = (state_69997[(11)]);
var state_69997__$1 = state_69997;
var statearr_70136_70227 = state_69997__$1;
(statearr_70136_70227[(2)] = inst_69942);

(statearr_70136_70227[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69998 === (2))){
var inst_69924 = (state_69997[(14)]);
var inst_69931 = (state_69997[(10)]);
var inst_69930 = cljs.core.seq(inst_69924);
var inst_69931__$1 = cljs.core.first(inst_69930);
var inst_69932 = cljs.core.next(inst_69930);
var state_69997__$1 = (function (){var statearr_70137 = state_69997;
(statearr_70137[(16)] = inst_69932);

(statearr_70137[(10)] = inst_69931__$1);

return statearr_70137;
})();
if(cljs.core.truth_(inst_69931__$1)){
var statearr_70138_70228 = state_69997__$1;
(statearr_70138_70228[(1)] = (4));

} else {
var statearr_70139_70229 = state_69997__$1;
(statearr_70139_70229[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69998 === (11))){
var inst_69925 = (state_69997[(7)]);
var inst_69932 = (state_69997[(16)]);
var inst_69919 = (state_69997[(12)]);
var inst_69937 = (state_69997[(8)]);
var inst_69922 = (state_69997[(13)]);
var inst_69942 = (state_69997[(11)]);
var inst_69924 = (state_69997[(14)]);
var inst_69921 = (state_69997[(15)]);
var inst_69931 = (state_69997[(10)]);
var inst_69949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69950 = [inst_69931,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_69951 = (new cljs.core.PersistentVector(null,2,(5),inst_69949,inst_69950,null));
var inst_69964 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_69965 = (function (){var t = inst_69931;
var c__2749__auto____$2 = inst_69964;
var vec__69927 = inst_69924;
var block = inst_69937;
var r = inst_69932;
var first__69929 = inst_69931;
var G__69915 = inst_69924;
var first__69918 = inst_69921;
var acc = inst_69925;
var G__69938 = inst_69942;
var seq__69917 = inst_69922;
var seq__69928 = inst_69932;
var vec__69916 = inst_69919;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_69962){
var state_val_69963 = (state_69962[(1)]);
if((state_val_69963 === (1))){
var state_69962__$1 = state_69962;
var statearr_70140_70230 = state_69962__$1;
(statearr_70140_70230[(2)] = null);

(statearr_70140_70230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69963 === (2))){
var ___$1 = (function (){var statearr_70141 = state_69962;
(statearr_70141[(4)] = cljs.core.cons((5),(state_69962[(4)])));

return statearr_70141;
})();
var ___$2 = (function (){var statearr_70142 = state_69962;
(statearr_70142[(4)] = cljs.core.rest((state_69962[(4)])));

return statearr_70142;
})();
var state_69962__$1 = state_69962;
var statearr_70143_70231 = state_69962__$1;
(statearr_70143_70231[(2)] = db);

(statearr_70143_70231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69963 === (3))){
var inst_69960 = (state_69962[(2)]);
var state_69962__$1 = state_69962;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69962__$1,inst_69960);
} else {
if((state_val_69963 === (4))){
var inst_69952 = (state_69962[(2)]);
var state_69962__$1 = state_69962;
var statearr_70145_70232 = state_69962__$1;
(statearr_70145_70232[(2)] = inst_69952);

(statearr_70145_70232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69963 === (5))){
var ___$1 = (function (){var statearr_70146 = state_69962;
(statearr_70146[(4)] = cljs.core.rest((state_69962[(4)])));

return statearr_70146;
})();
var state_69962__$1 = state_69962;
var ex70144 = (state_69962__$1[(2)]);
var statearr_70147_70233 = state_69962__$1;
(statearr_70147_70233[(5)] = ex70144);


if((ex70144 instanceof Error)){
var statearr_70148_70234 = state_69962__$1;
(statearr_70148_70234[(1)] = (4));

(statearr_70148_70234[(5)] = null);

} else {
throw ex70144;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_70149 = [null,null,null,null,null,null,null];
(statearr_70149[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_70149[(1)] = (1));

return statearr_70149;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_69962){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69962);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70150){var ex__2730__auto__ = e70150;
var statearr_70151_70235 = state_69962;
(statearr_70151_70235[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69962[(4)]))){
var statearr_70152_70236 = state_69962;
(statearr_70152_70236[(1)] = cljs.core.first((state_69962[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70237 = state_69962;
state_69962 = G__70237;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_69962){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_69962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70153 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70153[(6)] = c__2749__auto____$2);

return statearr_70153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_69966 = cljs.core.async.impl.dispatch.run(inst_69965);
var inst_69967 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_69968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69969 = ["?auth","?id"];
var inst_69970 = (new cljs.core.PersistentVector(null,2,(5),inst_69968,inst_69969,null));
var inst_69971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69973 = [inst_69931,"_tx/auth","?auth"];
var inst_69974 = (new cljs.core.PersistentVector(null,3,(5),inst_69972,inst_69973,null));
var inst_69975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69976 = ["?auth","_auth/id","?id"];
var inst_69977 = (new cljs.core.PersistentVector(null,3,(5),inst_69975,inst_69976,null));
var inst_69978 = [inst_69974,inst_69977];
var inst_69979 = (new cljs.core.PersistentVector(null,2,(5),inst_69971,inst_69978,null));
var inst_69980 = [inst_69970,inst_69979];
var inst_69981 = cljs.core.PersistentHashMap.fromArrays(inst_69967,inst_69980);
var inst_69982 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_69964,inst_69981) : fluree.db.api.query.query_async.call(null,inst_69964,inst_69981));
var state_69997__$1 = (function (){var statearr_70154 = state_69997;
(statearr_70154[(17)] = inst_69966);

(statearr_70154[(18)] = inst_69951);

return statearr_70154;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69997__$1,(14),inst_69982);
} else {
if((state_val_69998 === (9))){
var state_69997__$1 = state_69997;
var statearr_70155_70238 = state_69997__$1;
(statearr_70155_70238[(2)] = show_auth);

(statearr_70155_70238[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69998 === (5))){
var inst_69925 = (state_69997[(7)]);
var state_69997__$1 = state_69997;
var statearr_70156_70239 = state_69997__$1;
(statearr_70156_70239[(2)] = inst_69925);

(statearr_70156_70239[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69998 === (14))){
var inst_69942 = (state_69997[(11)]);
var inst_69951 = (state_69997[(18)]);
var inst_69984 = (state_69997[(2)]);
var inst_69985 = fluree.db.util.async.throw_err(inst_69984);
var inst_69986 = cljs.core.assoc_in(inst_69942,inst_69951,inst_69985);
var state_69997__$1 = state_69997;
var statearr_70157_70240 = state_69997__$1;
(statearr_70157_70240[(2)] = inst_69986);

(statearr_70157_70240[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69998 === (10))){
var inst_69947 = (state_69997[(2)]);
var state_69997__$1 = state_69997;
if(cljs.core.truth_(inst_69947)){
var statearr_70158_70241 = state_69997__$1;
(statearr_70158_70241[(1)] = (11));

} else {
var statearr_70159_70242 = state_69997__$1;
(statearr_70159_70242[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69998 === (8))){
var inst_69943 = (state_69997[(9)]);
var state_69997__$1 = state_69997;
var statearr_70160_70243 = state_69997__$1;
(statearr_70160_70243[(2)] = inst_69943);

(statearr_70160_70243[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_70161 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70161[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_70161[(1)] = (1));

return statearr_70161;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_69997){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_69997);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70162){var ex__2730__auto__ = e70162;
var statearr_70163_70244 = state_69997;
(statearr_70163_70244[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_69997[(4)]))){
var statearr_70164_70245 = state_69997;
(statearr_70164_70245[(1)] = cljs.core.first((state_69997[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70246 = state_69997;
state_69997 = G__70246;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_69997){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_69997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70165 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70165[(6)] = c__2749__auto____$1);

return statearr_70165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_70001 = cljs.core.async.impl.dispatch.run(inst_70000);
var state_70097__$1 = (function (){var statearr_70166 = state_70097;
(statearr_70166[(20)] = inst_70001);

return statearr_70166;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70097__$1,(6),inst_69999);
} else {
if((state_val_70098 === (23))){
var inst_70055 = (state_70097[(2)]);
var state_70097__$1 = (function (){var statearr_70167 = state_70097;
(statearr_70167[(13)] = inst_70055);

return statearr_70167;
})();
var statearr_70168_70247 = state_70097__$1;
(statearr_70168_70247[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (35))){
var inst_70085 = (state_70097[(2)]);
var state_70097__$1 = state_70097;
var statearr_70170_70248 = state_70097__$1;
(statearr_70170_70248[(2)] = inst_70085);

(statearr_70170_70248[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (19))){
var state_70097__$1 = state_70097;
var statearr_70171_70249 = state_70097__$1;
(statearr_70171_70249[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (11))){
var inst_70036 = (state_70097[(2)]);
var state_70097__$1 = state_70097;
if(cljs.core.truth_(inst_70036)){
var statearr_70174_70250 = state_70097__$1;
(statearr_70174_70250[(1)] = (15));

} else {
var statearr_70175_70251 = state_70097__$1;
(statearr_70175_70251[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (9))){
var inst_70027 = (state_70097[(16)]);
var inst_70027__$1 = auth;
var state_70097__$1 = (function (){var statearr_70176 = state_70097;
(statearr_70176[(16)] = inst_70027__$1);

return statearr_70176;
})();
if(cljs.core.truth_(inst_70027__$1)){
var statearr_70177_70252 = state_70097__$1;
(statearr_70177_70252[(1)] = (12));

} else {
var statearr_70178_70253 = state_70097__$1;
(statearr_70178_70253[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (5))){
var _ = (function (){var statearr_70179 = state_70097;
(statearr_70179[(4)] = cljs.core.rest((state_70097[(4)])));

return statearr_70179;
})();
var state_70097__$1 = state_70097;
var ex70173 = (state_70097__$1[(2)]);
var statearr_70180_70254 = state_70097__$1;
(statearr_70180_70254[(5)] = ex70173);


if((ex70173 instanceof Error)){
var statearr_70181_70255 = state_70097__$1;
(statearr_70181_70255[(1)] = (4));

(statearr_70181_70255[(5)] = null);

} else {
throw ex70173;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (14))){
var inst_70033 = (state_70097[(2)]);
var state_70097__$1 = state_70097;
var statearr_70182_70256 = state_70097__$1;
(statearr_70182_70256[(2)] = inst_70033);

(statearr_70182_70256[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (26))){
var inst_70063 = (state_70097[(2)]);
var state_70097__$1 = (function (){var statearr_70183 = state_70097;
(statearr_70183[(10)] = inst_70063);

return statearr_70183;
})();
var statearr_70184_70257 = state_70097__$1;
(statearr_70184_70257[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (16))){
var inst_70024 = (state_70097[(7)]);
var state_70097__$1 = state_70097;
if(cljs.core.truth_(inst_70024)){
var statearr_70186_70258 = state_70097__$1;
(statearr_70186_70258[(1)] = (18));

} else {
var statearr_70187_70259 = state_70097__$1;
(statearr_70187_70259[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (30))){
var inst_70045 = (state_70097[(11)]);
var inst_70071 = (state_70097[(15)]);
var inst_70046 = (state_70097[(21)]);
var inst_70073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70074 = [inst_70045,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_70075 = (new cljs.core.PersistentVector(null,2,(5),inst_70073,inst_70074,null));
var inst_70076 = cljs.core.assoc_in(inst_70071,inst_70075,inst_70046);
var state_70097__$1 = state_70097;
var statearr_70188_70260 = state_70097__$1;
(statearr_70188_70260[(2)] = inst_70076);

(statearr_70188_70260[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (10))){
var inst_70024 = (state_70097[(7)]);
var state_70097__$1 = state_70097;
var statearr_70189_70261 = state_70097__$1;
(statearr_70189_70261[(2)] = inst_70024);

(statearr_70189_70261[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (18))){
var inst_70024 = (state_70097[(7)]);
var inst_70004 = (state_70097[(18)]);
var inst_70042 = (state_70097[(12)]);
var inst_70042__$1 = fluree.db.flake.t(inst_70024);
var inst_70043 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70004,inst_70042__$1);
var inst_70044 = cljs.core.__destructure_map(inst_70043);
var inst_70045 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70044,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70046 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70044,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_70097__$1 = (function (){var statearr_70190 = state_70097;
(statearr_70190[(11)] = inst_70045);

(statearr_70190[(21)] = inst_70046);

(statearr_70190[(12)] = inst_70042__$1);

return statearr_70190;
})();
var statearr_70191_70262 = state_70097__$1;
(statearr_70191_70262[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70098 === (8))){
var inst_70091 = (state_70097[(2)]);
var inst_70092 = cljs.core.vals(inst_70091);
var _ = (function (){var statearr_70193 = state_70097;
(statearr_70193[(4)] = cljs.core.rest((state_70097[(4)])));

return statearr_70193;
})();
var state_70097__$1 = state_70097;
var statearr_70194_70263 = state_70097__$1;
(statearr_70194_70263[(2)] = inst_70092);

(statearr_70194_70263[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_70195 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70195[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_70195[(1)] = (1));

return statearr_70195;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_70097){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70097);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70196){var ex__2730__auto__ = e70196;
var statearr_70197_70264 = state_70097;
(statearr_70197_70264[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70097[(4)]))){
var statearr_70198_70265 = state_70097;
(statearr_70198_70265[(1)] = cljs.core.first((state_70097[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70266 = state_70097;
state_70097 = G__70266;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_70097){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_70097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70199 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70199[(6)] = c__2749__auto__);

return statearr_70199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70390){
var state_val_70391 = (state_70390[(1)]);
if((state_val_70391 === (7))){
var inst_70289 = (state_70390[(7)]);
var inst_70291 = fluree.db.api.query.resolve_block_range(inst_70289,query_map);
var state_70390__$1 = state_70390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70390__$1,(10),inst_70291);
} else {
if((state_val_70391 === (20))){
var inst_70315 = (state_70390[(2)]);
var inst_70316 = fluree.db.util.async.throw_err(inst_70315);
var inst_70317 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70316);
var inst_70318 = (inst_70317 - (1));
var state_70390__$1 = state_70390;
var statearr_70392_70455 = state_70390__$1;
(statearr_70392_70455[(2)] = inst_70318);

(statearr_70392_70455[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (27))){
var state_70390__$1 = state_70390;
var statearr_70393_70456 = state_70390__$1;
(statearr_70393_70456[(2)] = null);

(statearr_70393_70456[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (1))){
var state_70390__$1 = state_70390;
var statearr_70394_70457 = state_70390__$1;
(statearr_70394_70457[(2)] = null);

(statearr_70394_70457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (24))){
var inst_70325 = (state_70390[(2)]);
var inst_70326 = fluree.db.util.async.throw_err(inst_70325);
var inst_70327 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70326);
var state_70390__$1 = state_70390;
var statearr_70395_70458 = state_70390__$1;
(statearr_70395_70458[(2)] = inst_70327);

(statearr_70395_70458[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (39))){
var inst_70362 = (state_70390[(2)]);
var inst_70363 = fluree.db.util.async.throw_err(inst_70362);
var state_70390__$1 = state_70390;
var statearr_70396_70459 = state_70390__$1;
(statearr_70396_70459[(2)] = inst_70363);

(statearr_70396_70459[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (4))){
var inst_70267 = (state_70390[(2)]);
var state_70390__$1 = state_70390;
var statearr_70397_70460 = state_70390__$1;
(statearr_70397_70460[(2)] = inst_70267);

(statearr_70397_70460[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (15))){
var inst_70298 = (state_70390[(8)]);
var state_70390__$1 = state_70390;
var statearr_70398_70461 = state_70390__$1;
(statearr_70398_70461[(2)] = inst_70298);

(statearr_70398_70461[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (21))){
var inst_70289 = (state_70390[(7)]);
var inst_70299 = (state_70390[(9)]);
var inst_70323 = fluree.db.time_travel.as_of_block(inst_70289,inst_70299);
var state_70390__$1 = state_70390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70390__$1,(24),inst_70323);
} else {
if((state_val_70391 === (31))){
var inst_70283 = (state_70390[(10)]);
var state_70390__$1 = state_70390;
var statearr_70399_70462 = state_70390__$1;
(statearr_70399_70462[(2)] = inst_70283);

(statearr_70399_70462[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (32))){
var inst_70341 = (state_70390[(11)]);
var inst_70289 = (state_70390[(7)]);
var inst_70346 = (state_70390[(12)]);
var inst_70350 = (state_70390[(2)]);
var inst_70351 = fluree.db.api.query.format_history_resp(inst_70289,inst_70341,inst_70346,inst_70350);
var state_70390__$1 = state_70390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70390__$1,(29),inst_70351);
} else {
if((state_val_70391 === (40))){
var inst_70341 = (state_70390[(11)]);
var inst_70367 = (state_70390[(13)]);
var inst_70369 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_70370 = cljs.core.count(inst_70341);
var inst_70371 = [inst_70367,inst_70370,(200)];
var inst_70372 = cljs.core.PersistentHashMap.fromArrays(inst_70369,inst_70371);
var state_70390__$1 = state_70390;
var statearr_70400_70463 = state_70390__$1;
(statearr_70400_70463[(2)] = inst_70372);

(statearr_70400_70463[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (33))){
var inst_70282 = (state_70390[(14)]);
var state_70390__$1 = state_70390;
var statearr_70401_70464 = state_70390__$1;
(statearr_70401_70464[(2)] = inst_70282);

(statearr_70401_70464[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (13))){
var inst_70385 = (state_70390[(2)]);
var _ = (function (){var statearr_70402 = state_70390;
(statearr_70402[(4)] = cljs.core.rest((state_70390[(4)])));

return statearr_70402;
})();
var state_70390__$1 = state_70390;
var statearr_70403_70465 = state_70390__$1;
(statearr_70403_70465[(2)] = inst_70385);

(statearr_70403_70465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (22))){
var inst_70289 = (state_70390[(7)]);
var inst_70329 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70289);
var state_70390__$1 = state_70390;
var statearr_70404_70466 = state_70390__$1;
(statearr_70404_70466[(2)] = inst_70329);

(statearr_70404_70466[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (36))){
var inst_70289 = (state_70390[(7)]);
var inst_70354 = (state_70390[(15)]);
var inst_70360 = fluree.db.api.query.format_blocks_resp_pretty(inst_70289,inst_70354);
var state_70390__$1 = state_70390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70390__$1,(39),inst_70360);
} else {
if((state_val_70391 === (41))){
var inst_70367 = (state_70390[(13)]);
var state_70390__$1 = state_70390;
var statearr_70405_70467 = state_70390__$1;
(statearr_70405_70467[(2)] = inst_70367);

(statearr_70405_70467[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (29))){
var inst_70282 = (state_70390[(14)]);
var inst_70353 = (state_70390[(2)]);
var inst_70354 = fluree.db.util.async.throw_err(inst_70353);
var state_70390__$1 = (function (){var statearr_70406 = state_70390;
(statearr_70406[(15)] = inst_70354);

return statearr_70406;
})();
if(cljs.core.truth_(inst_70282)){
var statearr_70407_70468 = state_70390__$1;
(statearr_70407_70468[(1)] = (33));

} else {
var statearr_70408_70469 = state_70390__$1;
(statearr_70408_70469[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (6))){
var inst_70279 = (state_70390[(16)]);
var inst_70288 = (state_70390[(2)]);
var inst_70289 = fluree.db.util.async.throw_err(inst_70288);
var state_70390__$1 = (function (){var statearr_70409 = state_70390;
(statearr_70409[(7)] = inst_70289);

return statearr_70409;
})();
if(cljs.core.truth_(inst_70279)){
var statearr_70410_70470 = state_70390__$1;
(statearr_70410_70470[(1)] = (7));

} else {
var statearr_70411_70471 = state_70390__$1;
(statearr_70411_70471[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (28))){
var inst_70284 = (state_70390[(17)]);
var inst_70346 = (state_70390[(2)]);
var state_70390__$1 = (function (){var statearr_70412 = state_70390;
(statearr_70412[(12)] = inst_70346);

return statearr_70412;
})();
if(cljs.core.truth_(inst_70284)){
var statearr_70413_70472 = state_70390__$1;
(statearr_70413_70472[(1)] = (30));

} else {
var statearr_70414_70473 = state_70390__$1;
(statearr_70414_70473[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (25))){
var inst_70285 = (state_70390[(18)]);
var inst_70340 = (state_70390[(2)]);
var inst_70341 = fluree.db.util.async.throw_err(inst_70340);
var state_70390__$1 = (function (){var statearr_70415 = state_70390;
(statearr_70415[(11)] = inst_70341);

return statearr_70415;
})();
if(cljs.core.truth_(inst_70285)){
var statearr_70416_70474 = state_70390__$1;
(statearr_70416_70474[(1)] = (26));

} else {
var statearr_70417_70475 = state_70390__$1;
(statearr_70417_70475[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (34))){
var inst_70281 = (state_70390[(19)]);
var state_70390__$1 = state_70390;
var statearr_70418_70476 = state_70390__$1;
(statearr_70418_70476[(2)] = inst_70281);

(statearr_70418_70476[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (17))){
var inst_70298 = (state_70390[(8)]);
var inst_70289 = (state_70390[(7)]);
var inst_70312 = (inst_70298 - (1));
var inst_70313 = fluree.db.time_travel.as_of_block(inst_70289,inst_70312);
var state_70390__$1 = state_70390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70390__$1,(20),inst_70313);
} else {
if((state_val_70391 === (3))){
var inst_70388 = (state_70390[(2)]);
var state_70390__$1 = state_70390;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70390__$1,inst_70388);
} else {
if((state_val_70391 === (12))){
var inst_70377 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_70378 = ["History query not properly formatted. Provided ",inst_70377].join('');
var inst_70379 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70380 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70381 = cljs.core.PersistentHashMap.fromArrays(inst_70379,inst_70380);
var inst_70382 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70378,inst_70381);
var inst_70383 = (function(){throw inst_70382})();
var state_70390__$1 = state_70390;
var statearr_70419_70477 = state_70390__$1;
(statearr_70419_70477[(2)] = inst_70383);

(statearr_70419_70477[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (2))){
var _ = (function (){var statearr_70420 = state_70390;
(statearr_70420[(4)] = cljs.core.cons((5),(state_70390[(4)])));

return statearr_70420;
})();
var inst_70277 = query_map;
var inst_70278 = cljs.core.__destructure_map(inst_70277);
var inst_70279 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70278,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70280 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70278,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_70281 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70278,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_70282 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70278,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_70283 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70278,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_70284 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70278,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_70285 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70278,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_70286 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70278,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_70390__$1 = (function (){var statearr_70421 = state_70390;
(statearr_70421[(10)] = inst_70283);

(statearr_70421[(14)] = inst_70282);

(statearr_70421[(16)] = inst_70279);

(statearr_70421[(20)] = inst_70280);

(statearr_70421[(19)] = inst_70281);

(statearr_70421[(18)] = inst_70285);

(statearr_70421[(21)] = inst_70286);

(statearr_70421[(17)] = inst_70284);

return statearr_70421;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70390__$1,(6),sources);
} else {
if((state_val_70391 === (23))){
var inst_70289 = (state_70390[(7)]);
var inst_70321 = (state_70390[(22)]);
var inst_70280 = (state_70390[(20)]);
var inst_70331 = (state_70390[(2)]);
var inst_70332 = fluree.db.api.query.get_history_pattern(inst_70280);
var inst_70333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70332,(0),null);
var inst_70334 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70332,(1),null);
var inst_70335 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_70336 = [inst_70321,inst_70331];
var inst_70337 = cljs.core.PersistentHashMap.fromArrays(inst_70335,inst_70336);
var inst_70338 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_70289,inst_70334,cljs.core._EQ_,inst_70333,inst_70337);
var state_70390__$1 = state_70390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70390__$1,(25),inst_70338);
} else {
if((state_val_70391 === (35))){
var inst_70358 = (state_70390[(2)]);
var state_70390__$1 = state_70390;
if(cljs.core.truth_(inst_70358)){
var statearr_70422_70478 = state_70390__$1;
(statearr_70422_70478[(1)] = (36));

} else {
var statearr_70423_70479 = state_70390__$1;
(statearr_70423_70479[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (19))){
var inst_70299 = (state_70390[(9)]);
var inst_70321 = (state_70390[(2)]);
var state_70390__$1 = (function (){var statearr_70424 = state_70390;
(statearr_70424[(22)] = inst_70321);

return statearr_70424;
})();
if(cljs.core.truth_(inst_70299)){
var statearr_70425_70480 = state_70390__$1;
(statearr_70425_70480[(1)] = (21));

} else {
var statearr_70426_70481 = state_70390__$1;
(statearr_70426_70481[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (11))){
var inst_70298 = (state_70390[(8)]);
var inst_70286 = (state_70390[(21)]);
var inst_70305 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_70286);
var state_70390__$1 = (function (){var statearr_70428 = state_70390;
(statearr_70428[(23)] = inst_70305);

return statearr_70428;
})();
if(cljs.core.truth_(inst_70298)){
var statearr_70429_70482 = state_70390__$1;
(statearr_70429_70482[(1)] = (14));

} else {
var statearr_70430_70483 = state_70390__$1;
(statearr_70430_70483[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (9))){
var inst_70297 = (state_70390[(2)]);
var inst_70298 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70297,(0),null);
var inst_70299 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70297,(1),null);
var inst_70300 = cljs.core.contains_QMARK_(query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_70390__$1 = (function (){var statearr_70431 = state_70390;
(statearr_70431[(8)] = inst_70298);

(statearr_70431[(9)] = inst_70299);

return statearr_70431;
})();
if(inst_70300){
var statearr_70432_70484 = state_70390__$1;
(statearr_70432_70484[(1)] = (11));

} else {
var statearr_70433_70485 = state_70390__$1;
(statearr_70433_70485[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (5))){
var _ = (function (){var statearr_70434 = state_70390;
(statearr_70434[(4)] = cljs.core.rest((state_70390[(4)])));

return statearr_70434;
})();
var state_70390__$1 = state_70390;
var ex70427 = (state_70390__$1[(2)]);
var statearr_70435_70486 = state_70390__$1;
(statearr_70435_70486[(5)] = ex70427);


if((ex70427 instanceof Error)){
var statearr_70436_70487 = state_70390__$1;
(statearr_70436_70487[(1)] = (4));

(statearr_70436_70487[(5)] = null);

} else {
throw ex70427;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (14))){
var inst_70298 = (state_70390[(8)]);
var inst_70307 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_70298);
var state_70390__$1 = state_70390;
var statearr_70437_70488 = state_70390__$1;
(statearr_70437_70488[(2)] = inst_70307);

(statearr_70437_70488[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (26))){
var inst_70285 = (state_70390[(18)]);
var inst_70343 = cljs.core.set(inst_70285);
var state_70390__$1 = state_70390;
var statearr_70438_70489 = state_70390__$1;
(statearr_70438_70489[(2)] = inst_70343);

(statearr_70438_70489[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (16))){
var inst_70310 = (state_70390[(2)]);
var state_70390__$1 = state_70390;
if(cljs.core.truth_(inst_70310)){
var statearr_70439_70490 = state_70390__$1;
(statearr_70439_70490[(1)] = (17));

} else {
var statearr_70440_70491 = state_70390__$1;
(statearr_70440_70491[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (38))){
var inst_70305 = (state_70390[(23)]);
var inst_70367 = (state_70390[(2)]);
var state_70390__$1 = (function (){var statearr_70441 = state_70390;
(statearr_70441[(13)] = inst_70367);

return statearr_70441;
})();
if(cljs.core.truth_(inst_70305)){
var statearr_70442_70492 = state_70390__$1;
(statearr_70442_70492[(1)] = (40));

} else {
var statearr_70443_70493 = state_70390__$1;
(statearr_70443_70493[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (30))){
var inst_70284 = (state_70390[(17)]);
var state_70390__$1 = state_70390;
var statearr_70444_70494 = state_70390__$1;
(statearr_70444_70494[(2)] = inst_70284);

(statearr_70444_70494[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (10))){
var inst_70293 = (state_70390[(2)]);
var inst_70294 = fluree.db.util.async.throw_err(inst_70293);
var state_70390__$1 = state_70390;
var statearr_70445_70495 = state_70390__$1;
(statearr_70445_70495[(2)] = inst_70294);

(statearr_70445_70495[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (18))){
var state_70390__$1 = state_70390;
var statearr_70446_70496 = state_70390__$1;
(statearr_70446_70496[(2)] = (-1));

(statearr_70446_70496[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (42))){
var inst_70375 = (state_70390[(2)]);
var state_70390__$1 = state_70390;
var statearr_70447_70497 = state_70390__$1;
(statearr_70447_70497[(2)] = inst_70375);

(statearr_70447_70497[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (37))){
var inst_70354 = (state_70390[(15)]);
var inst_70365 = fluree.db.api.query.block_Flakes__GT_vector(inst_70354);
var state_70390__$1 = state_70390;
var statearr_70448_70498 = state_70390__$1;
(statearr_70448_70498[(2)] = inst_70365);

(statearr_70448_70498[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70391 === (8))){
var state_70390__$1 = state_70390;
var statearr_70449_70499 = state_70390__$1;
(statearr_70449_70499[(2)] = null);

(statearr_70449_70499[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_70450 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70450[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2727__auto__);

(statearr_70450[(1)] = (1));

return statearr_70450;
});
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1 = (function (state_70390){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70390);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70451){var ex__2730__auto__ = e70451;
var statearr_70452_70500 = state_70390;
(statearr_70452_70500[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70390[(4)]))){
var statearr_70453_70501 = state_70390;
(statearr_70453_70501[(1)] = cljs.core.first((state_70390[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70502 = state_70390;
state_70390 = G__70502;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = function(state_70390){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1.call(this,state_70390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70454 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70454[(6)] = c__2749__auto__);

return statearr_70454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70635){
var state_val_70636 = (state_70635[(1)]);
if((state_val_70636 === (7))){
var inst_70532 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_70533 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_70532].join('');
var inst_70534 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70535 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70536 = cljs.core.PersistentHashMap.fromArrays(inst_70534,inst_70535);
var inst_70537 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70533,inst_70536);
var inst_70538 = (function(){throw inst_70537})();
var state_70635__$1 = state_70635;
var statearr_70637_70716 = state_70635__$1;
(statearr_70637_70716[(2)] = inst_70538);

(statearr_70637_70716[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (20))){
var inst_70570 = (state_70635[(2)]);
var state_70635__$1 = state_70635;
if(cljs.core.truth_(inst_70570)){
var statearr_70638_70717 = state_70635__$1;
(statearr_70638_70717[(1)] = (21));

} else {
var statearr_70639_70718 = state_70635__$1;
(statearr_70639_70718[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (27))){
var inst_70514 = (state_70635[(7)]);
var state_70635__$1 = state_70635;
var statearr_70640_70719 = state_70635__$1;
(statearr_70640_70719[(2)] = inst_70514);

(statearr_70640_70719[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (1))){
var state_70635__$1 = state_70635;
var statearr_70641_70720 = state_70635__$1;
(statearr_70641_70720[(2)] = null);

(statearr_70641_70720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (24))){
var inst_70576 = (state_70635[(8)]);
var state_70635__$1 = state_70635;
var statearr_70642_70721 = state_70635__$1;
(statearr_70642_70721[(2)] = inst_70576);

(statearr_70642_70721[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (39))){
var inst_70520 = (state_70635[(9)]);
var state_70635__$1 = state_70635;
if(cljs.core.truth_(inst_70520)){
var statearr_70643_70722 = state_70635__$1;
(statearr_70643_70722[(1)] = (42));

} else {
var statearr_70644_70723 = state_70635__$1;
(statearr_70644_70723[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (46))){
var inst_70608 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70609 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70610 = cljs.core.PersistentHashMap.fromArrays(inst_70608,inst_70609);
var inst_70611 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_70610);
var inst_70612 = (function(){throw inst_70611})();
var state_70635__$1 = state_70635;
var statearr_70645_70724 = state_70635__$1;
(statearr_70645_70724[(2)] = inst_70612);

(statearr_70645_70724[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (4))){
var inst_70504 = (state_70635[(2)]);
var state_70635__$1 = state_70635;
var statearr_70646_70725 = state_70635__$1;
(statearr_70646_70725[(2)] = inst_70504);

(statearr_70646_70725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (15))){
var inst_70517 = (state_70635[(10)]);
var inst_70555 = (state_70635[(11)]);
var inst_70557 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_70555);
var inst_70558 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_70555);
var inst_70559 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_70555);
var inst_70560 = fluree.db.api.query.get_sources(inst_70557,inst_70558,inst_70559,inst_70517);
var state_70635__$1 = state_70635;
var statearr_70647_70726 = state_70635__$1;
(statearr_70647_70726[(2)] = inst_70560);

(statearr_70647_70726[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (48))){
var inst_70565 = (state_70635[(12)]);
var inst_70619 = (state_70635[(2)]);
var inst_70620 = fluree.db.util.async.throw_err(inst_70619);
var state_70635__$1 = (function (){var statearr_70648 = state_70635;
(statearr_70648[(13)] = inst_70620);

return statearr_70648;
})();
if(cljs.core.truth_(inst_70565)){
var statearr_70649_70727 = state_70635__$1;
(statearr_70649_70727[(1)] = (49));

} else {
var statearr_70650_70728 = state_70635__$1;
(statearr_70650_70728[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (50))){
var inst_70620 = (state_70635[(13)]);
var state_70635__$1 = state_70635;
var statearr_70651_70729 = state_70635__$1;
(statearr_70651_70729[(2)] = inst_70620);

(statearr_70651_70729[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (21))){
var inst_70572 = cljs.core.volatile_BANG_((0));
var state_70635__$1 = state_70635;
var statearr_70652_70730 = state_70635__$1;
(statearr_70652_70730[(2)] = inst_70572);

(statearr_70652_70730[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (31))){
var inst_70518 = (state_70635[(14)]);
var state_70635__$1 = state_70635;
if(cljs.core.truth_(inst_70518)){
var statearr_70653_70731 = state_70635__$1;
(statearr_70653_70731[(1)] = (33));

} else {
var statearr_70654_70732 = state_70635__$1;
(statearr_70654_70732[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (32))){
var inst_70595 = (state_70635[(2)]);
var state_70635__$1 = state_70635;
var statearr_70655_70733 = state_70635__$1;
(statearr_70655_70733[(2)] = inst_70595);

(statearr_70655_70733[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (40))){
var inst_70597 = (state_70635[(15)]);
var state_70635__$1 = state_70635;
var statearr_70656_70734 = state_70635__$1;
(statearr_70656_70734[(2)] = inst_70597);

(statearr_70656_70734[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (33))){
var inst_70518 = (state_70635[(14)]);
var state_70635__$1 = state_70635;
var statearr_70657_70735 = state_70635__$1;
(statearr_70657_70735[(2)] = inst_70518);

(statearr_70657_70735[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (13))){
var inst_70515 = (state_70635[(16)]);
var inst_70544 = (state_70635[(2)]);
var inst_70545 = fluree.db.util.async.throw_err(inst_70544);
var inst_70546 = fluree.db.time_travel.as_of_block(inst_70545,inst_70515);
var state_70635__$1 = state_70635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70635__$1,(12),inst_70546);
} else {
if((state_val_70636 === (22))){
var state_70635__$1 = state_70635;
var statearr_70658_70736 = state_70635__$1;
(statearr_70658_70736[(2)] = null);

(statearr_70658_70736[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (36))){
var inst_70522 = (state_70635[(17)]);
var state_70635__$1 = state_70635;
var statearr_70659_70737 = state_70635__$1;
(statearr_70659_70737[(2)] = inst_70522);

(statearr_70659_70737[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (41))){
var inst_70605 = (state_70635[(2)]);
var state_70635__$1 = state_70635;
if(cljs.core.truth_(inst_70605)){
var statearr_70660_70738 = state_70635__$1;
(statearr_70660_70738[(1)] = (45));

} else {
var statearr_70661_70739 = state_70635__$1;
(statearr_70661_70739[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (43))){
var inst_70516 = (state_70635[(18)]);
var state_70635__$1 = state_70635;
var statearr_70662_70740 = state_70635__$1;
(statearr_70662_70740[(2)] = inst_70516);

(statearr_70662_70740[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (29))){
var inst_70597 = (state_70635[(15)]);
var inst_70597__$1 = (state_70635[(2)]);
var state_70635__$1 = (function (){var statearr_70663 = state_70635;
(statearr_70663[(15)] = inst_70597__$1);

return statearr_70663;
})();
if(cljs.core.truth_(inst_70597__$1)){
var statearr_70664_70741 = state_70635__$1;
(statearr_70664_70741[(1)] = (39));

} else {
var statearr_70665_70742 = state_70635__$1;
(statearr_70665_70742[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (44))){
var inst_70602 = (state_70635[(2)]);
var state_70635__$1 = state_70635;
var statearr_70666_70743 = state_70635__$1;
(statearr_70666_70743[(2)] = inst_70602);

(statearr_70666_70743[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (6))){
var state_70635__$1 = state_70635;
var statearr_70667_70744 = state_70635__$1;
(statearr_70667_70744[(2)] = null);

(statearr_70667_70744[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (28))){
var inst_70519 = (state_70635[(19)]);
var state_70635__$1 = state_70635;
if(cljs.core.truth_(inst_70519)){
var statearr_70668_70745 = state_70635__$1;
(statearr_70668_70745[(1)] = (30));

} else {
var statearr_70669_70746 = state_70635__$1;
(statearr_70669_70746[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (51))){
var inst_70630 = (state_70635[(2)]);
var _ = (function (){var statearr_70670 = state_70635;
(statearr_70670[(4)] = cljs.core.rest((state_70635[(4)])));

return statearr_70670;
})();
var state_70635__$1 = state_70635;
var statearr_70671_70747 = state_70635__$1;
(statearr_70671_70747[(2)] = inst_70630);

(statearr_70671_70747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (25))){
var state_70635__$1 = state_70635;
var statearr_70672_70748 = state_70635__$1;
(statearr_70672_70748[(2)] = (1000000));

(statearr_70672_70748[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (34))){
var inst_70522 = (state_70635[(17)]);
var state_70635__$1 = state_70635;
if(cljs.core.truth_(inst_70522)){
var statearr_70673_70749 = state_70635__$1;
(statearr_70673_70749[(1)] = (36));

} else {
var statearr_70674_70750 = state_70635__$1;
(statearr_70674_70750[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (17))){
var inst_70566 = (state_70635[(20)]);
var inst_70521 = (state_70635[(21)]);
var inst_70564 = (state_70635[(2)]);
var inst_70565 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_70521);
var inst_70566__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_70521);
var state_70635__$1 = (function (){var statearr_70675 = state_70635;
(statearr_70675[(22)] = inst_70564);

(statearr_70675[(12)] = inst_70565);

(statearr_70675[(20)] = inst_70566__$1);

return statearr_70675;
})();
if(cljs.core.truth_(inst_70566__$1)){
var statearr_70676_70751 = state_70635__$1;
(statearr_70676_70751[(1)] = (18));

} else {
var statearr_70677_70752 = state_70635__$1;
(statearr_70677_70752[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (3))){
var inst_70633 = (state_70635[(2)]);
var state_70635__$1 = state_70635;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70635__$1,inst_70633);
} else {
if((state_val_70636 === (12))){
var inst_70548 = (state_70635[(2)]);
var inst_70549 = fluree.db.util.async.throw_err(inst_70548);
var state_70635__$1 = state_70635;
var statearr_70678_70753 = state_70635__$1;
(statearr_70678_70753[(2)] = inst_70549);

(statearr_70678_70753[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (2))){
var inst_70522 = (state_70635[(17)]);
var inst_70515 = (state_70635[(16)]);
var inst_70513 = (state_70635[(23)]);
var inst_70518 = (state_70635[(14)]);
var inst_70521 = (state_70635[(21)]);
var inst_70517 = (state_70635[(10)]);
var inst_70520 = (state_70635[(9)]);
var inst_70519 = (state_70635[(19)]);
var inst_70516 = (state_70635[(18)]);
var inst_70514 = (state_70635[(7)]);
var _ = (function (){var statearr_70679 = state_70635;
(statearr_70679[(4)] = cljs.core.cons((5),(state_70635[(4)])));

return statearr_70679;
})();
var inst_70511 = flureeQL;
var inst_70512 = cljs.core.__destructure_map(inst_70511);
var inst_70513__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70512,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_70514__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70512,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_70515__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70512,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70516__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70512,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_70517__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70512,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_70518__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70512,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_70519__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70512,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_70520__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70512,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_70521__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70512,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_70522__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70512,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_70523 = (function (){var construct = inst_70513__$1;
var select = inst_70514__$1;
var map__70510 = inst_70512;
var block = inst_70515__$1;
var where = inst_70516__$1;
var prefixes = inst_70517__$1;
var selectDistinct = inst_70518__$1;
var selectOne = inst_70519__$1;
var from = inst_70520__$1;
var opts = inst_70521__$1;
var selectReduced = inst_70522__$1;
return (function (p1__70503_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__70503_SHARP_);
});
})();
var inst_70524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70525 = [inst_70514__$1,inst_70519__$1,inst_70518__$1,inst_70522__$1];
var inst_70526 = (new cljs.core.PersistentVector(null,4,(5),inst_70524,inst_70525,null));
var inst_70527 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_70526);
var inst_70528 = cljs.core.count(inst_70527);
var inst_70529 = (inst_70523.cljs$core$IFn$_invoke$arity$1 ? inst_70523.cljs$core$IFn$_invoke$arity$1(inst_70528) : inst_70523.call(null,inst_70528));
var state_70635__$1 = (function (){var statearr_70680 = state_70635;
(statearr_70680[(17)] = inst_70522__$1);

(statearr_70680[(16)] = inst_70515__$1);

(statearr_70680[(23)] = inst_70513__$1);

(statearr_70680[(14)] = inst_70518__$1);

(statearr_70680[(21)] = inst_70521__$1);

(statearr_70680[(10)] = inst_70517__$1);

(statearr_70680[(9)] = inst_70520__$1);

(statearr_70680[(19)] = inst_70519__$1);

(statearr_70680[(18)] = inst_70516__$1);

(statearr_70680[(7)] = inst_70514__$1);

return statearr_70680;
})();
if(cljs.core.truth_(inst_70529)){
var statearr_70681_70754 = state_70635__$1;
(statearr_70681_70754[(1)] = (6));

} else {
var statearr_70682_70755 = state_70635__$1;
(statearr_70682_70755[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (23))){
var inst_70521 = (state_70635[(21)]);
var inst_70576 = (state_70635[(8)]);
var inst_70575 = (state_70635[(2)]);
var inst_70576__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_70521);
var state_70635__$1 = (function (){var statearr_70683 = state_70635;
(statearr_70683[(24)] = inst_70575);

(statearr_70683[(8)] = inst_70576__$1);

return statearr_70683;
})();
if(cljs.core.truth_(inst_70576__$1)){
var statearr_70684_70756 = state_70635__$1;
(statearr_70684_70756[(1)] = (24));

} else {
var statearr_70685_70757 = state_70635__$1;
(statearr_70685_70757[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (47))){
var inst_70581 = (state_70635[(25)]);
var inst_70555 = (state_70635[(11)]);
var inst_70614 = (state_70635[(2)]);
var inst_70615 = fluree.db.util.core.current_time_millis();
var inst_70616 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_70581);
var inst_70617 = fluree.db.query.fql.query(inst_70555,inst_70616);
var state_70635__$1 = (function (){var statearr_70686 = state_70635;
(statearr_70686[(26)] = inst_70614);

(statearr_70686[(27)] = inst_70615);

return statearr_70686;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70635__$1,(48),inst_70617);
} else {
if((state_val_70636 === (35))){
var inst_70593 = (state_70635[(2)]);
var state_70635__$1 = state_70635;
var statearr_70687_70758 = state_70635__$1;
(statearr_70687_70758[(2)] = inst_70593);

(statearr_70687_70758[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (19))){
var inst_70565 = (state_70635[(12)]);
var state_70635__$1 = state_70635;
var statearr_70688_70759 = state_70635__$1;
(statearr_70688_70759[(2)] = inst_70565);

(statearr_70688_70759[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (11))){
var inst_70517 = (state_70635[(10)]);
var inst_70555 = (state_70635[(2)]);
var state_70635__$1 = (function (){var statearr_70690 = state_70635;
(statearr_70690[(11)] = inst_70555);

return statearr_70690;
})();
if(cljs.core.truth_(inst_70517)){
var statearr_70691_70760 = state_70635__$1;
(statearr_70691_70760[(1)] = (15));

} else {
var statearr_70692_70761 = state_70635__$1;
(statearr_70692_70761[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (9))){
var inst_70541 = (state_70635[(28)]);
var state_70635__$1 = state_70635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70635__$1,(13),inst_70541);
} else {
if((state_val_70636 === (5))){
var _ = (function (){var statearr_70693 = state_70635;
(statearr_70693[(4)] = cljs.core.rest((state_70635[(4)])));

return statearr_70693;
})();
var state_70635__$1 = state_70635;
var ex70689 = (state_70635__$1[(2)]);
var statearr_70694_70762 = state_70635__$1;
(statearr_70694_70762[(5)] = ex70689);


if((ex70689 instanceof Error)){
var statearr_70695_70763 = state_70635__$1;
(statearr_70695_70763[(1)] = (4));

(statearr_70695_70763[(5)] = null);

} else {
throw ex70689;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (14))){
var inst_70552 = (state_70635[(2)]);
var inst_70553 = fluree.db.util.async.throw_err(inst_70552);
var state_70635__$1 = state_70635;
var statearr_70696_70764 = state_70635__$1;
(statearr_70696_70764[(2)] = inst_70553);

(statearr_70696_70764[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (45))){
var state_70635__$1 = state_70635;
var statearr_70697_70765 = state_70635__$1;
(statearr_70697_70765[(2)] = null);

(statearr_70697_70765[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (26))){
var inst_70564 = (state_70635[(22)]);
var inst_70521 = (state_70635[(21)]);
var inst_70575 = (state_70635[(24)]);
var inst_70514 = (state_70635[(7)]);
var inst_70580 = (state_70635[(2)]);
var inst_70581 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_70521,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_70564,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_70580,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_70575], 0));
var state_70635__$1 = (function (){var statearr_70698 = state_70635;
(statearr_70698[(25)] = inst_70581);

return statearr_70698;
})();
if(cljs.core.truth_(inst_70514)){
var statearr_70699_70766 = state_70635__$1;
(statearr_70699_70766[(1)] = (27));

} else {
var statearr_70700_70767 = state_70635__$1;
(statearr_70700_70767[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (16))){
var inst_70562 = cljs.core.PersistentHashMap.EMPTY;
var state_70635__$1 = state_70635;
var statearr_70701_70768 = state_70635__$1;
(statearr_70701_70768[(2)] = inst_70562);

(statearr_70701_70768[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (38))){
var inst_70591 = (state_70635[(2)]);
var state_70635__$1 = state_70635;
var statearr_70702_70769 = state_70635__$1;
(statearr_70702_70769[(2)] = inst_70591);

(statearr_70702_70769[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (30))){
var inst_70519 = (state_70635[(19)]);
var state_70635__$1 = state_70635;
var statearr_70703_70770 = state_70635__$1;
(statearr_70703_70770[(2)] = inst_70519);

(statearr_70703_70770[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (10))){
var inst_70541 = (state_70635[(28)]);
var state_70635__$1 = state_70635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70635__$1,(14),inst_70541);
} else {
if((state_val_70636 === (18))){
var inst_70566 = (state_70635[(20)]);
var state_70635__$1 = state_70635;
var statearr_70704_70771 = state_70635__$1;
(statearr_70704_70771[(2)] = inst_70566);

(statearr_70704_70771[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (42))){
var inst_70520 = (state_70635[(9)]);
var state_70635__$1 = state_70635;
var statearr_70705_70772 = state_70635__$1;
(statearr_70705_70772[(2)] = inst_70520);

(statearr_70705_70772[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (37))){
var inst_70513 = (state_70635[(23)]);
var state_70635__$1 = state_70635;
var statearr_70706_70773 = state_70635__$1;
(statearr_70706_70773[(2)] = inst_70513);

(statearr_70706_70773[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (8))){
var inst_70515 = (state_70635[(16)]);
var inst_70540 = (state_70635[(2)]);
var inst_70541 = sources;
var state_70635__$1 = (function (){var statearr_70707 = state_70635;
(statearr_70707[(29)] = inst_70540);

(statearr_70707[(28)] = inst_70541);

return statearr_70707;
})();
if(cljs.core.truth_(inst_70515)){
var statearr_70708_70774 = state_70635__$1;
(statearr_70708_70774[(1)] = (9));

} else {
var statearr_70709_70775 = state_70635__$1;
(statearr_70709_70775[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70636 === (49))){
var inst_70620 = (state_70635[(13)]);
var inst_70615 = (state_70635[(27)]);
var inst_70575 = (state_70635[(24)]);
var inst_70555 = (state_70635[(11)]);
var inst_70622 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70623 = cljs.core.deref(inst_70575);
var inst_70624 = fluree.db.util.core.response_time_formatted(inst_70615);
var inst_70625 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_70555);
var inst_70626 = [(200),inst_70620,inst_70623,inst_70624,inst_70625];
var inst_70627 = cljs.core.PersistentHashMap.fromArrays(inst_70622,inst_70626);
var state_70635__$1 = state_70635;
var statearr_70710_70776 = state_70635__$1;
(statearr_70710_70776[(2)] = inst_70627);

(statearr_70710_70776[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_70711 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70711[(0)] = fluree$db$api$query$query_async_$_state_machine__2727__auto__);

(statearr_70711[(1)] = (1));

return statearr_70711;
});
var fluree$db$api$query$query_async_$_state_machine__2727__auto____1 = (function (state_70635){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70635);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70712){var ex__2730__auto__ = e70712;
var statearr_70713_70777 = state_70635;
(statearr_70713_70777[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70635[(4)]))){
var statearr_70714_70778 = state_70635;
(statearr_70714_70778[(1)] = cljs.core.first((state_70635[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70779 = state_70635;
state_70635 = G__70779;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2727__auto__ = function(state_70635){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____1.call(this,state_70635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70715 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70715[(6)] = c__2749__auto__);

return statearr_70715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_70920){
var state_val_70921 = (state_70920[(1)]);
if((state_val_70921 === (7))){
var inst_70915 = (state_70920[(2)]);
var _ = (function (){var statearr_70922 = state_70920;
(statearr_70922[(4)] = cljs.core.rest((state_70920[(4)])));

return statearr_70922;
})();
var state_70920__$1 = state_70920;
var statearr_70923_70999 = state_70920__$1;
(statearr_70923_70999[(2)] = inst_70915);

(statearr_70923_70999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (20))){
var inst_70887 = (state_70920[(2)]);
var state_70920__$1 = state_70920;
var statearr_70924_71000 = state_70920__$1;
(statearr_70924_71000[(2)] = inst_70887);

(statearr_70924_71000[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (27))){
var inst_70867 = (state_70920[(7)]);
var state_70920__$1 = state_70920;
var statearr_70925_71001 = state_70920__$1;
(statearr_70925_71001[(2)] = inst_70867);

(statearr_70925_71001[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (1))){
var state_70920__$1 = state_70920;
var statearr_70926_71002 = state_70920__$1;
(statearr_70926_71002[(2)] = null);

(statearr_70926_71002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (24))){
var inst_70864 = (state_70920[(8)]);
var state_70920__$1 = state_70920;
var statearr_70927_71003 = state_70920__$1;
(statearr_70927_71003[(2)] = inst_70864);

(statearr_70927_71003[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (39))){
var inst_70821 = (state_70920[(9)]);
var inst_70854 = (state_70920[(10)]);
var inst_70832 = (state_70920[(11)]);
var inst_70898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70899 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_70832];
var inst_70900 = (new cljs.core.PersistentVector(null,2,(5),inst_70898,inst_70899,null));
var inst_70901 = cljs.core.assoc_in(inst_70821,inst_70900,inst_70854);
var state_70920__$1 = state_70920;
var statearr_70928_71004 = state_70920__$1;
(statearr_70928_71004[(2)] = inst_70901);

(statearr_70928_71004[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (4))){
var inst_70780 = (state_70920[(2)]);
var state_70920__$1 = state_70920;
var statearr_70929_71005 = state_70920__$1;
(statearr_70929_71005[(2)] = inst_70780);

(statearr_70929_71005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (15))){
var inst_70819 = (state_70920[(12)]);
var inst_70854 = (state_70920[(10)]);
var inst_70857 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_70854);
var inst_70858 = (inst_70819 == null);
var state_70920__$1 = (function (){var statearr_70930 = state_70920;
(statearr_70930[(13)] = inst_70857);

return statearr_70930;
})();
if(cljs.core.truth_(inst_70858)){
var statearr_70931_71006 = state_70920__$1;
(statearr_70931_71006[(1)] = (18));

} else {
var statearr_70932_71007 = state_70920__$1;
(statearr_70932_71007[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (21))){
var inst_70857 = (state_70920[(13)]);
var state_70920__$1 = state_70920;
var statearr_70933_71008 = state_70920__$1;
(statearr_70933_71008[(2)] = inst_70857);

(statearr_70933_71008[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (31))){
var state_70920__$1 = state_70920;
var statearr_70934_71009 = state_70920__$1;
(statearr_70934_71009[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (32))){
var inst_70883 = (state_70920[(2)]);
var state_70920__$1 = state_70920;
var statearr_70936_71010 = state_70920__$1;
(statearr_70936_71010[(2)] = inst_70883);

(statearr_70936_71010[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (40))){
var inst_70852 = (state_70920[(14)]);
var state_70920__$1 = state_70920;
if(cljs.core.truth_(inst_70852)){
var statearr_70937_71011 = state_70920__$1;
(statearr_70937_71011[(1)] = (42));

} else {
var statearr_70938_71012 = state_70920__$1;
(statearr_70938_71012[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (33))){
var inst_70819 = (state_70920[(12)]);
var inst_70857 = (state_70920[(13)]);
var inst_70878 = ((inst_70857 > inst_70819) ? inst_70857 : inst_70819);
var state_70920__$1 = state_70920;
var statearr_70939_71013 = state_70920__$1;
(statearr_70939_71013[(2)] = inst_70878);

(statearr_70939_71013[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (13))){
var inst_70843 = (state_70920[(2)]);
var state_70920__$1 = state_70920;
var statearr_70940_71014 = state_70920__$1;
(statearr_70940_71014[(2)] = inst_70843);

(statearr_70940_71014[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (22))){
var inst_70864 = (state_70920[(8)]);
var inst_70857 = (state_70920[(13)]);
var inst_70864__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_70857);
var state_70920__$1 = (function (){var statearr_70941 = state_70920;
(statearr_70941[(8)] = inst_70864__$1);

return statearr_70941;
})();
if(inst_70864__$1){
var statearr_70942_71015 = state_70920__$1;
(statearr_70942_71015[(1)] = (24));

} else {
var statearr_70943_71016 = state_70920__$1;
(statearr_70943_71016[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (36))){
var inst_70820 = (state_70920[(15)]);
var inst_70854 = (state_70920[(10)]);
var inst_70892 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_70854,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_70893 = (inst_70820 + inst_70892);
var state_70920__$1 = state_70920;
var statearr_70944_71017 = state_70920__$1;
(statearr_70944_71017[(2)] = inst_70893);

(statearr_70944_71017[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (41))){
var inst_70831 = (state_70920[(16)]);
var inst_70896 = (state_70920[(17)]);
var inst_70890 = (state_70920[(18)]);
var inst_70910 = (state_70920[(2)]);
var inst_70818 = inst_70831;
var inst_70819 = inst_70890;
var inst_70820 = inst_70896;
var inst_70821 = inst_70910;
var state_70920__$1 = (function (){var statearr_70945 = state_70920;
(statearr_70945[(12)] = inst_70819);

(statearr_70945[(9)] = inst_70821);

(statearr_70945[(15)] = inst_70820);

(statearr_70945[(19)] = inst_70818);

return statearr_70945;
})();
var statearr_70946_71018 = state_70920__$1;
(statearr_70946_71018[(2)] = null);

(statearr_70946_71018[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (43))){
var inst_70854 = (state_70920[(10)]);
var state_70920__$1 = state_70920;
var statearr_70947_71019 = state_70920__$1;
(statearr_70947_71019[(2)] = inst_70854);

(statearr_70947_71019[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (29))){
var inst_70872 = (state_70920[(2)]);
var state_70920__$1 = state_70920;
var statearr_70948_71020 = state_70920__$1;
(statearr_70948_71020[(2)] = inst_70872);

(statearr_70948_71020[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (44))){
var inst_70821 = (state_70920[(9)]);
var inst_70832 = (state_70920[(11)]);
var inst_70907 = (state_70920[(2)]);
var inst_70908 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_70821,inst_70832,inst_70907);
var state_70920__$1 = state_70920;
var statearr_70949_71021 = state_70920__$1;
(statearr_70949_71021[(2)] = inst_70908);

(statearr_70949_71021[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (6))){
var inst_70833 = (state_70920[(20)]);
var inst_70818 = (state_70920[(19)]);
var inst_70829 = cljs.core.seq(inst_70818);
var inst_70830 = cljs.core.first(inst_70829);
var inst_70831 = cljs.core.next(inst_70829);
var inst_70832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70830,(0),null);
var inst_70833__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70830,(1),null);
var inst_70834 = (inst_70833__$1 == null);
var state_70920__$1 = (function (){var statearr_70950 = state_70920;
(statearr_70950[(16)] = inst_70831);

(statearr_70950[(20)] = inst_70833__$1);

(statearr_70950[(11)] = inst_70832);

return statearr_70950;
})();
if(cljs.core.truth_(inst_70834)){
var statearr_70951_71022 = state_70920__$1;
(statearr_70951_71022[(1)] = (8));

} else {
var statearr_70952_71023 = state_70920__$1;
(statearr_70952_71023[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (28))){
var inst_70819 = (state_70920[(12)]);
var inst_70870 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_70819);
var state_70920__$1 = state_70920;
var statearr_70953_71024 = state_70920__$1;
(statearr_70953_71024[(2)] = inst_70870);

(statearr_70953_71024[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (25))){
var inst_70819 = (state_70920[(12)]);
var inst_70867 = (state_70920[(7)]);
var inst_70867__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_70819);
var state_70920__$1 = (function (){var statearr_70954 = state_70920;
(statearr_70954[(7)] = inst_70867__$1);

return statearr_70954;
})();
if(inst_70867__$1){
var statearr_70955_71025 = state_70920__$1;
(statearr_70955_71025[(1)] = (27));

} else {
var statearr_70956_71026 = state_70920__$1;
(statearr_70956_71026[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (34))){
var state_70920__$1 = state_70920;
var statearr_70957_71027 = state_70920__$1;
(statearr_70957_71027[(2)] = null);

(statearr_70957_71027[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (17))){
var inst_70851 = (state_70920[(21)]);
var inst_70890 = (state_70920[(2)]);
var state_70920__$1 = (function (){var statearr_70958 = state_70920;
(statearr_70958[(18)] = inst_70890);

return statearr_70958;
})();
if(cljs.core.truth_(inst_70851)){
var statearr_70959_71028 = state_70920__$1;
(statearr_70959_71028[(1)] = (36));

} else {
var statearr_70960_71029 = state_70920__$1;
(statearr_70960_71029[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (3))){
var inst_70918 = (state_70920[(2)]);
var state_70920__$1 = state_70920;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70920__$1,inst_70918);
} else {
if((state_val_70921 === (12))){
var inst_70821 = (state_70920[(9)]);
var state_70920__$1 = state_70920;
var statearr_70961_71030 = state_70920__$1;
(statearr_70961_71030[(2)] = inst_70821);

(statearr_70961_71030[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (2))){
var inst_70790 = (state_70920[(22)]);
var inst_70795 = (state_70920[(23)]);
var inst_70794 = (state_70920[(24)]);
var _ = (function (){var statearr_70962 = state_70920;
(statearr_70962[(4)] = cljs.core.cons((5),(state_70920[(4)])));

return statearr_70962;
})();
var inst_70786 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_70787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70788 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_70789 = (new cljs.core.PersistentVector(null,2,(5),inst_70787,inst_70788,null));
var inst_70790__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_70789);
var inst_70791 = (function (){var global_block = inst_70786;
var global_meta_QMARK_ = inst_70790__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4253__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4251__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__4251__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_70792 = cljs.core.PersistentHashMap.EMPTY;
var inst_70793 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_70794__$1 = cljs.core.reduce_kv(inst_70791,inst_70792,inst_70793);
var inst_70795__$1 = fluree.db.util.core.current_time_millis();
var inst_70797 = (function (){var global_block = inst_70786;
var global_meta_QMARK_ = inst_70790__$1;
var queries = inst_70794__$1;
var start_time = inst_70795__$1;
return (function (p__70796){
var vec__70963 = p__70796;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70963,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70963,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_70798 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_70797,inst_70794__$1);
var inst_70812 = cljs.core.seq(inst_70798);
var inst_70813 = cljs.core.first(inst_70812);
var inst_70814 = cljs.core.next(inst_70812);
var inst_70815 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70813,(0),null);
var inst_70816 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70813,(1),null);
var inst_70817 = cljs.core.PersistentHashMap.EMPTY;
var inst_70818 = inst_70798;
var inst_70819 = null;
var inst_70820 = (0);
var inst_70821 = inst_70817;
var state_70920__$1 = (function (){var statearr_70966 = state_70920;
(statearr_70966[(22)] = inst_70790__$1);

(statearr_70966[(12)] = inst_70819);

(statearr_70966[(25)] = inst_70816);

(statearr_70966[(9)] = inst_70821);

(statearr_70966[(26)] = inst_70814);

(statearr_70966[(15)] = inst_70820);

(statearr_70966[(23)] = inst_70795__$1);

(statearr_70966[(24)] = inst_70794__$1);

(statearr_70966[(19)] = inst_70818);

(statearr_70966[(27)] = inst_70815);

return statearr_70966;
})();
var statearr_70967_71031 = state_70920__$1;
(statearr_70967_71031[(2)] = null);

(statearr_70967_71031[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (23))){
var inst_70885 = (state_70920[(2)]);
var state_70920__$1 = state_70920;
var statearr_70968_71032 = state_70920__$1;
(statearr_70968_71032[(2)] = inst_70885);

(statearr_70968_71032[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (35))){
var inst_70881 = (state_70920[(2)]);
var state_70920__$1 = state_70920;
var statearr_70969_71033 = state_70920__$1;
(statearr_70969_71033[(2)] = inst_70881);

(statearr_70969_71033[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (19))){
var inst_70819 = (state_70920[(12)]);
var inst_70857 = (state_70920[(13)]);
var inst_70861 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_70819,inst_70857);
var state_70920__$1 = state_70920;
if(inst_70861){
var statearr_70970_71034 = state_70920__$1;
(statearr_70970_71034[(1)] = (21));

} else {
var statearr_70971_71035 = state_70920__$1;
(statearr_70971_71035[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (11))){
var inst_70819 = (state_70920[(12)]);
var inst_70821 = (state_70920[(9)]);
var inst_70820 = (state_70920[(15)]);
var inst_70795 = (state_70920[(23)]);
var inst_70837 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_70838 = fluree.db.util.core.response_time_formatted(inst_70795);
var inst_70839 = [inst_70821,inst_70820,inst_70819,inst_70838];
var inst_70840 = cljs.core.PersistentHashMap.fromArrays(inst_70837,inst_70839);
var state_70920__$1 = state_70920;
var statearr_70973_71036 = state_70920__$1;
(statearr_70973_71036[(2)] = inst_70840);

(statearr_70973_71036[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (9))){
var inst_70833 = (state_70920[(20)]);
var inst_70794 = (state_70920[(24)]);
var inst_70832 = (state_70920[(11)]);
var inst_70846 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70847 = [inst_70832,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_70848 = (new cljs.core.PersistentVector(null,2,(5),inst_70846,inst_70847,null));
var inst_70849 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_70794,inst_70848);
var inst_70850 = cljs.core.__destructure_map(inst_70849);
var inst_70851 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70850,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_70852 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70850,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_70920__$1 = (function (){var statearr_70974 = state_70920;
(statearr_70974[(21)] = inst_70851);

(statearr_70974[(14)] = inst_70852);

return statearr_70974;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70920__$1,(14),inst_70833);
} else {
if((state_val_70921 === (5))){
var _ = (function (){var statearr_70975 = state_70920;
(statearr_70975[(4)] = cljs.core.rest((state_70920[(4)])));

return statearr_70975;
})();
var state_70920__$1 = state_70920;
var ex70972 = (state_70920__$1[(2)]);
var statearr_70976_71037 = state_70920__$1;
(statearr_70976_71037[(5)] = ex70972);


var statearr_70977_71038 = state_70920__$1;
(statearr_70977_71038[(1)] = (4));

(statearr_70977_71038[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (14))){
var inst_70851 = (state_70920[(21)]);
var inst_70854 = (state_70920[(10)]);
var inst_70854__$1 = (state_70920[(2)]);
var inst_70855 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_70854__$1);
var state_70920__$1 = (function (){var statearr_70978 = state_70920;
(statearr_70978[(28)] = inst_70855);

(statearr_70978[(10)] = inst_70854__$1);

return statearr_70978;
})();
if(cljs.core.truth_(inst_70851)){
var statearr_70979_71039 = state_70920__$1;
(statearr_70979_71039[(1)] = (15));

} else {
var statearr_70980_71040 = state_70920__$1;
(statearr_70980_71040[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (26))){
var inst_70874 = (state_70920[(2)]);
var state_70920__$1 = state_70920;
if(cljs.core.truth_(inst_70874)){
var statearr_70981_71041 = state_70920__$1;
(statearr_70981_71041[(1)] = (30));

} else {
var statearr_70982_71042 = state_70920__$1;
(statearr_70982_71042[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (16))){
var state_70920__$1 = state_70920;
var statearr_70983_71043 = state_70920__$1;
(statearr_70983_71043[(2)] = null);

(statearr_70983_71043[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (38))){
var inst_70855 = (state_70920[(28)]);
var inst_70896 = (state_70920[(2)]);
var state_70920__$1 = (function (){var statearr_70984 = state_70920;
(statearr_70984[(17)] = inst_70896);

return statearr_70984;
})();
if(cljs.core.truth_(inst_70855)){
var statearr_70985_71044 = state_70920__$1;
(statearr_70985_71044[(1)] = (39));

} else {
var statearr_70986_71045 = state_70920__$1;
(statearr_70986_71045[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (30))){
var state_70920__$1 = state_70920;
var statearr_70987_71046 = state_70920__$1;
(statearr_70987_71046[(2)] = (207));

(statearr_70987_71046[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (10))){
var inst_70913 = (state_70920[(2)]);
var state_70920__$1 = state_70920;
var statearr_70988_71047 = state_70920__$1;
(statearr_70988_71047[(2)] = inst_70913);

(statearr_70988_71047[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (18))){
var inst_70857 = (state_70920[(13)]);
var state_70920__$1 = state_70920;
var statearr_70989_71048 = state_70920__$1;
(statearr_70989_71048[(2)] = inst_70857);

(statearr_70989_71048[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (42))){
var inst_70854 = (state_70920[(10)]);
var inst_70904 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_70854);
var state_70920__$1 = state_70920;
var statearr_70990_71049 = state_70920__$1;
(statearr_70990_71049[(2)] = inst_70904);

(statearr_70990_71049[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (37))){
var state_70920__$1 = state_70920;
var statearr_70991_71050 = state_70920__$1;
(statearr_70991_71050[(2)] = null);

(statearr_70991_71050[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70921 === (8))){
var inst_70790 = (state_70920[(22)]);
var state_70920__$1 = state_70920;
if(cljs.core.truth_(inst_70790)){
var statearr_70992_71051 = state_70920__$1;
(statearr_70992_71051[(1)] = (11));

} else {
var statearr_70993_71052 = state_70920__$1;
(statearr_70993_71052[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_70994 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70994[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__);

(statearr_70994[(1)] = (1));

return statearr_70994;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1 = (function (state_70920){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_70920);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e70995){var ex__2730__auto__ = e70995;
var statearr_70996_71053 = state_70920;
(statearr_70996_71053[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_70920[(4)]))){
var statearr_70997_71054 = state_70920;
(statearr_70997_71054[(1)] = cljs.core.first((state_70920[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71055 = state_70920;
state_70920 = G__71055;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = function(state_70920){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1.call(this,state_70920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_70998 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_70998[(6)] = c__2749__auto__);

return statearr_70998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__71056 = query_type;
var G__71056__$1 = (((G__71056 instanceof cljs.core.Keyword))?G__71056.fqn:null);
switch (G__71056__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__71056__$1)].join('')));

}
});
