// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__75277 = arguments.length;
switch (G__75277) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___75316 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75298){
var state_val_75299 = (state_75298[(1)]);
if((state_val_75299 === (1))){
var state_75298__$1 = state_75298;
var statearr_75300_75317 = state_75298__$1;
(statearr_75300_75317[(2)] = null);

(statearr_75300_75317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75299 === (2))){
var _ = (function (){var statearr_75301 = state_75298;
(statearr_75301[(4)] = cljs.core.cons((5),(state_75298[(4)])));

return statearr_75301;
})();
var inst_75284 = fluree.db.session.db(conn,ledger,null);
var state_75298__$1 = state_75298;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75298__$1,(7),inst_75284);
} else {
if((state_val_75299 === (3))){
var inst_75294 = (state_75298[(2)]);
var inst_75295 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_75294);
var inst_75296 = cljs.core.async.close_BANG_(pc);
var state_75298__$1 = (function (){var statearr_75303 = state_75298;
(statearr_75303[(7)] = inst_75295);

return statearr_75303;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_75298__$1,inst_75296);
} else {
if((state_val_75299 === (4))){
var inst_75278 = (state_75298[(2)]);
var state_75298__$1 = state_75298;
var statearr_75304_75318 = state_75298__$1;
(statearr_75304_75318[(2)] = inst_75278);

(statearr_75304_75318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75299 === (5))){
var _ = (function (){var statearr_75305 = state_75298;
(statearr_75305[(4)] = cljs.core.rest((state_75298[(4)])));

return statearr_75305;
})();
var state_75298__$1 = state_75298;
var ex75302 = (state_75298__$1[(2)]);
var statearr_75306_75319 = state_75298__$1;
(statearr_75306_75319[(5)] = ex75302);


var statearr_75307_75320 = state_75298__$1;
(statearr_75307_75320[(1)] = (4));

(statearr_75307_75320[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75299 === (6))){
var inst_75290 = (state_75298[(2)]);
var inst_75291 = fluree.db.util.async.throw_err(inst_75290);
var _ = (function (){var statearr_75308 = state_75298;
(statearr_75308[(4)] = cljs.core.rest((state_75298[(4)])));

return statearr_75308;
})();
var state_75298__$1 = state_75298;
var statearr_75309_75321 = state_75298__$1;
(statearr_75309_75321[(2)] = inst_75291);

(statearr_75309_75321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75299 === (7))){
var inst_75286 = (state_75298[(2)]);
var inst_75287 = fluree.db.util.async.throw_err(inst_75286);
var inst_75288 = fluree.db.time_travel.as_of_block(inst_75287,block);
var state_75298__$1 = state_75298;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75298__$1,(6),inst_75288);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_75310 = [null,null,null,null,null,null,null,null];
(statearr_75310[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_75310[(1)] = (1));

return statearr_75310;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_75298){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75298);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75311){var ex__2730__auto__ = e75311;
var statearr_75312_75322 = state_75298;
(statearr_75312_75322[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75298[(4)]))){
var statearr_75313_75323 = state_75298;
(statearr_75313_75323[(1)] = cljs.core.first((state_75298[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75324 = state_75298;
state_75298 = G__75324;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_75298){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_75298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75314 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75314[(6)] = c__2749__auto___75316);

return statearr_75314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75365){
var state_val_75366 = (state_75365[(1)]);
if((state_val_75366 === (7))){
var inst_75334 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_75365__$1 = state_75365;
if(inst_75334){
var statearr_75367_75398 = state_75365__$1;
(statearr_75367_75398[(1)] = (9));

} else {
var statearr_75368_75399 = state_75365__$1;
(statearr_75368_75399[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (1))){
var state_75365__$1 = state_75365;
var statearr_75369_75400 = state_75365__$1;
(statearr_75369_75400[(2)] = null);

(statearr_75369_75400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (4))){
var inst_75325 = (state_75365[(2)]);
var state_75365__$1 = state_75365;
var statearr_75370_75401 = state_75365__$1;
(statearr_75370_75401[(2)] = inst_75325);

(statearr_75370_75401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (15))){
var inst_75342 = (state_75365[(7)]);
var inst_75341 = (state_75365[(2)]);
var inst_75342__$1 = fluree.db.util.async.throw_err(inst_75341);
var state_75365__$1 = (function (){var statearr_75371 = state_75365;
(statearr_75371[(7)] = inst_75342__$1);

return statearr_75371;
})();
if(cljs.core.truth_(inst_75342__$1)){
var statearr_75372_75402 = state_75365__$1;
(statearr_75372_75402[(1)] = (16));

} else {
var statearr_75373_75403 = state_75365__$1;
(statearr_75373_75403[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (13))){
var state_75365__$1 = state_75365;
var statearr_75374_75404 = state_75365__$1;
(statearr_75374_75404[(2)] = null);

(statearr_75374_75404[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (6))){
var state_75365__$1 = state_75365;
var statearr_75375_75405 = state_75365__$1;
(statearr_75375_75405[(2)] = db);

(statearr_75375_75405[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (17))){
var inst_75346 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_75347 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75348 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_75349 = cljs.core.PersistentHashMap.fromArrays(inst_75347,inst_75348);
var inst_75350 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75346,inst_75349);
var inst_75351 = (function(){throw inst_75350})();
var state_75365__$1 = state_75365;
var statearr_75376_75406 = state_75365__$1;
(statearr_75376_75406[(2)] = inst_75351);

(statearr_75376_75406[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (3))){
var inst_75363 = (state_75365[(2)]);
var state_75365__$1 = state_75365;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75365__$1,inst_75363);
} else {
if((state_val_75366 === (12))){
var inst_75339 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_75365__$1 = state_75365;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75365__$1,(15),inst_75339);
} else {
if((state_val_75366 === (2))){
var _ = (function (){var statearr_75377 = state_75365;
(statearr_75377[(4)] = cljs.core.cons((5),(state_75365[(4)])));

return statearr_75377;
})();
var inst_75331 = cljs.core.not(auth);
var state_75365__$1 = state_75365;
if(inst_75331){
var statearr_75378_75407 = state_75365__$1;
(statearr_75378_75407[(1)] = (6));

} else {
var statearr_75379_75408 = state_75365__$1;
(statearr_75379_75408[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (11))){
var inst_75358 = (state_75365[(2)]);
var state_75365__$1 = state_75365;
var statearr_75381_75409 = state_75365__$1;
(statearr_75381_75409[(2)] = inst_75358);

(statearr_75381_75409[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (9))){
var inst_75336 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_75365__$1 = state_75365;
var statearr_75382_75410 = state_75365__$1;
(statearr_75382_75410[(2)] = inst_75336);

(statearr_75382_75410[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (5))){
var _ = (function (){var statearr_75383 = state_75365;
(statearr_75383[(4)] = cljs.core.rest((state_75365[(4)])));

return statearr_75383;
})();
var state_75365__$1 = state_75365;
var ex75380 = (state_75365__$1[(2)]);
var statearr_75384_75411 = state_75365__$1;
(statearr_75384_75411[(5)] = ex75380);


if((ex75380 instanceof Error)){
var statearr_75385_75412 = state_75365__$1;
(statearr_75385_75412[(1)] = (4));

(statearr_75385_75412[(5)] = null);

} else {
throw ex75380;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (14))){
var inst_75356 = (state_75365[(2)]);
var state_75365__$1 = state_75365;
var statearr_75386_75413 = state_75365__$1;
(statearr_75386_75413[(2)] = inst_75356);

(statearr_75386_75413[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (16))){
var inst_75342 = (state_75365[(7)]);
var inst_75344 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_75342);
var state_75365__$1 = state_75365;
var statearr_75387_75414 = state_75365__$1;
(statearr_75387_75414[(2)] = inst_75344);

(statearr_75387_75414[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (10))){
var state_75365__$1 = state_75365;
var statearr_75388_75415 = state_75365__$1;
(statearr_75388_75415[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (18))){
var inst_75353 = (state_75365[(2)]);
var state_75365__$1 = state_75365;
var statearr_75390_75416 = state_75365__$1;
(statearr_75390_75416[(2)] = inst_75353);

(statearr_75390_75416[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75366 === (8))){
var inst_75360 = (state_75365[(2)]);
var _ = (function (){var statearr_75391 = state_75365;
(statearr_75391[(4)] = cljs.core.rest((state_75365[(4)])));

return statearr_75391;
})();
var state_75365__$1 = state_75365;
var statearr_75392_75417 = state_75365__$1;
(statearr_75392_75417[(2)] = inst_75360);

(statearr_75392_75417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0 = (function (){
var statearr_75393 = [null,null,null,null,null,null,null,null];
(statearr_75393[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__);

(statearr_75393[(1)] = (1));

return statearr_75393;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1 = (function (state_75365){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75365);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75394){var ex__2730__auto__ = e75394;
var statearr_75395_75418 = state_75365;
(statearr_75395_75418[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75365[(4)]))){
var statearr_75396_75419 = state_75365;
(statearr_75396_75419[(1)] = cljs.core.first((state_75365[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75420 = state_75365;
state_75365 = G__75420;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = function(state_75365){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1.call(this,state_75365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75397 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75397[(6)] = c__2749__auto__);

return statearr_75397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75492){
var state_val_75493 = (state_75492[(1)]);
if((state_val_75493 === (7))){
var inst_75430 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_75492__$1 = state_75492;
if(inst_75430){
var statearr_75494_75548 = state_75492__$1;
(statearr_75494_75548[(1)] = (9));

} else {
var statearr_75495_75549 = state_75492__$1;
(statearr_75495_75549[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (20))){
var inst_75454 = (state_75492[(7)]);
var state_75492__$1 = state_75492;
if(cljs.core.truth_(inst_75454)){
var statearr_75496_75550 = state_75492__$1;
(statearr_75496_75550[(1)] = (22));

} else {
var statearr_75497_75551 = state_75492__$1;
(statearr_75497_75551[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (27))){
var state_75492__$1 = state_75492;
var statearr_75498_75552 = state_75492__$1;
(statearr_75498_75552[(2)] = null);

(statearr_75498_75552[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (1))){
var state_75492__$1 = state_75492;
var statearr_75499_75553 = state_75492__$1;
(statearr_75499_75553[(2)] = null);

(statearr_75499_75553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (24))){
var inst_75468 = (state_75492[(2)]);
var state_75492__$1 = state_75492;
var statearr_75500_75554 = state_75492__$1;
(statearr_75500_75554[(2)] = inst_75468);

(statearr_75500_75554[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (4))){
var inst_75421 = (state_75492[(2)]);
var state_75492__$1 = state_75492;
var statearr_75501_75555 = state_75492__$1;
(statearr_75501_75555[(2)] = inst_75421);

(statearr_75501_75555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (15))){
var inst_75437 = (state_75492[(8)]);
var inst_75436 = (state_75492[(2)]);
var inst_75437__$1 = fluree.db.util.async.throw_err(inst_75436);
var state_75492__$1 = (function (){var statearr_75502 = state_75492;
(statearr_75502[(8)] = inst_75437__$1);

return statearr_75502;
})();
if(cljs.core.truth_(inst_75437__$1)){
var statearr_75503_75556 = state_75492__$1;
(statearr_75503_75556[(1)] = (16));

} else {
var statearr_75504_75557 = state_75492__$1;
(statearr_75504_75557[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (21))){
var inst_75470 = (state_75492[(9)]);
var inst_75470__$1 = (state_75492[(2)]);
var state_75492__$1 = (function (){var statearr_75505 = state_75492;
(statearr_75505[(9)] = inst_75470__$1);

return statearr_75505;
})();
if(cljs.core.truth_(inst_75470__$1)){
var statearr_75506_75558 = state_75492__$1;
(statearr_75506_75558[(1)] = (29));

} else {
var statearr_75507_75559 = state_75492__$1;
(statearr_75507_75559[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (31))){
var inst_75470 = (state_75492[(9)]);
var inst_75478 = (state_75492[(2)]);
var state_75492__$1 = (function (){var statearr_75508 = state_75492;
(statearr_75508[(10)] = inst_75478);

return statearr_75508;
})();
if(cljs.core.truth_(inst_75470)){
var statearr_75509_75560 = state_75492__$1;
(statearr_75509_75560[(1)] = (33));

} else {
var statearr_75510_75561 = state_75492__$1;
(statearr_75510_75561[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (32))){
var inst_75474 = (state_75492[(2)]);
var inst_75475 = fluree.db.util.async.throw_err(inst_75474);
var state_75492__$1 = state_75492;
var statearr_75511_75562 = state_75492__$1;
(statearr_75511_75562[(2)] = inst_75475);

(statearr_75511_75562[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (33))){
var inst_75470 = (state_75492[(9)]);
var inst_75480 = fluree.db.permissions.permission_map(db,inst_75470,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_75492__$1 = state_75492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75492__$1,(36),inst_75480);
} else {
if((state_val_75493 === (13))){
var state_75492__$1 = state_75492;
var statearr_75512_75563 = state_75492__$1;
(statearr_75512_75563[(2)] = null);

(statearr_75512_75563[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (22))){
var inst_75454 = (state_75492[(7)]);
var inst_75458 = fluree.db.auth.roles(db,inst_75454);
var state_75492__$1 = state_75492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75492__$1,(25),inst_75458);
} else {
if((state_val_75493 === (36))){
var inst_75482 = (state_75492[(2)]);
var inst_75483 = fluree.db.util.async.throw_err(inst_75482);
var state_75492__$1 = state_75492;
var statearr_75513_75564 = state_75492__$1;
(statearr_75513_75564[(2)] = inst_75483);

(statearr_75513_75564[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (29))){
var inst_75470 = (state_75492[(9)]);
var inst_75454 = (state_75492[(7)]);
var inst_75472 = fluree.db.dbfunctions.ctx.build(db,inst_75454,inst_75470);
var state_75492__$1 = state_75492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75492__$1,(32),inst_75472);
} else {
if((state_val_75493 === (6))){
var state_75492__$1 = state_75492;
var statearr_75514_75565 = state_75492__$1;
(statearr_75514_75565[(2)] = null);

(statearr_75514_75565[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (28))){
var inst_75466 = (state_75492[(2)]);
var state_75492__$1 = state_75492;
var statearr_75515_75566 = state_75492__$1;
(statearr_75515_75566[(2)] = inst_75466);

(statearr_75515_75566[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (25))){
var inst_75460 = (state_75492[(2)]);
var inst_75461 = fluree.db.util.async.throw_err(inst_75460);
var state_75492__$1 = state_75492;
var statearr_75516_75567 = state_75492__$1;
(statearr_75516_75567[(2)] = inst_75461);

(statearr_75516_75567[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (34))){
var state_75492__$1 = state_75492;
var statearr_75517_75568 = state_75492__$1;
(statearr_75517_75568[(2)] = null);

(statearr_75517_75568[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (17))){
var inst_75440 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_75441 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75442 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_75443 = cljs.core.PersistentHashMap.fromArrays(inst_75441,inst_75442);
var inst_75444 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75440,inst_75443);
var inst_75445 = (function(){throw inst_75444})();
var state_75492__$1 = state_75492;
var statearr_75518_75569 = state_75492__$1;
(statearr_75518_75569[(2)] = inst_75445);

(statearr_75518_75569[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (3))){
var inst_75490 = (state_75492[(2)]);
var state_75492__$1 = state_75492;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75492__$1,inst_75490);
} else {
if((state_val_75493 === (12))){
var inst_75434 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_75492__$1 = state_75492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75492__$1,(15),inst_75434);
} else {
if((state_val_75493 === (2))){
var _ = (function (){var statearr_75519 = state_75492;
(statearr_75519[(4)] = cljs.core.cons((5),(state_75492[(4)])));

return statearr_75519;
})();
var inst_75427 = (auth == null);
var state_75492__$1 = state_75492;
if(cljs.core.truth_(inst_75427)){
var statearr_75520_75570 = state_75492__$1;
(statearr_75520_75570[(1)] = (6));

} else {
var statearr_75521_75571 = state_75492__$1;
(statearr_75521_75571[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (23))){
var state_75492__$1 = state_75492;
var statearr_75522_75572 = state_75492__$1;
(statearr_75522_75572[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (35))){
var inst_75478 = (state_75492[(10)]);
var inst_75470 = (state_75492[(9)]);
var inst_75454 = (state_75492[(7)]);
var inst_75486 = (state_75492[(2)]);
var inst_75487 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_75454,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_75470,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_75486,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_75478], 0));
var _ = (function (){var statearr_75524 = state_75492;
(statearr_75524[(4)] = cljs.core.rest((state_75492[(4)])));

return statearr_75524;
})();
var state_75492__$1 = state_75492;
var statearr_75525_75573 = state_75492__$1;
(statearr_75525_75573[(2)] = inst_75487);

(statearr_75525_75573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (19))){
var state_75492__$1 = state_75492;
var statearr_75526_75574 = state_75492__$1;
(statearr_75526_75574[(2)] = roles);

(statearr_75526_75574[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (11))){
var inst_75452 = (state_75492[(2)]);
var state_75492__$1 = state_75492;
var statearr_75528_75575 = state_75492__$1;
(statearr_75528_75575[(2)] = inst_75452);

(statearr_75528_75575[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (9))){
var state_75492__$1 = state_75492;
var statearr_75529_75576 = state_75492__$1;
(statearr_75529_75576[(2)] = (0));

(statearr_75529_75576[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (5))){
var _ = (function (){var statearr_75530 = state_75492;
(statearr_75530[(4)] = cljs.core.rest((state_75492[(4)])));

return statearr_75530;
})();
var state_75492__$1 = state_75492;
var ex75527 = (state_75492__$1[(2)]);
var statearr_75531_75577 = state_75492__$1;
(statearr_75531_75577[(5)] = ex75527);


if((ex75527 instanceof Error)){
var statearr_75532_75578 = state_75492__$1;
(statearr_75532_75578[(1)] = (4));

(statearr_75532_75578[(5)] = null);

} else {
throw ex75527;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (14))){
var inst_75450 = (state_75492[(2)]);
var state_75492__$1 = state_75492;
var statearr_75533_75579 = state_75492__$1;
(statearr_75533_75579[(2)] = inst_75450);

(statearr_75533_75579[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (26))){
var state_75492__$1 = state_75492;
var statearr_75534_75580 = state_75492__$1;
(statearr_75534_75580[(2)] = null);

(statearr_75534_75580[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (16))){
var inst_75437 = (state_75492[(8)]);
var state_75492__$1 = state_75492;
var statearr_75535_75581 = state_75492__$1;
(statearr_75535_75581[(2)] = inst_75437);

(statearr_75535_75581[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (30))){
var state_75492__$1 = state_75492;
var statearr_75536_75582 = state_75492__$1;
(statearr_75536_75582[(2)] = null);

(statearr_75536_75582[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (10))){
var state_75492__$1 = state_75492;
if(cljs.core.truth_(auth)){
var statearr_75537_75583 = state_75492__$1;
(statearr_75537_75583[(1)] = (12));

} else {
var statearr_75538_75584 = state_75492__$1;
(statearr_75538_75584[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (18))){
var inst_75447 = (state_75492[(2)]);
var state_75492__$1 = state_75492;
var statearr_75539_75585 = state_75492__$1;
(statearr_75539_75585[(2)] = inst_75447);

(statearr_75539_75585[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75493 === (8))){
var inst_75454 = (state_75492[(2)]);
var state_75492__$1 = (function (){var statearr_75540 = state_75492;
(statearr_75540[(7)] = inst_75454);

return statearr_75540;
})();
if(cljs.core.truth_(roles)){
var statearr_75541_75586 = state_75492__$1;
(statearr_75541_75586[(1)] = (19));

} else {
var statearr_75542_75587 = state_75492__$1;
(statearr_75542_75587[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0 = (function (){
var statearr_75543 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_75543[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__);

(statearr_75543[(1)] = (1));

return statearr_75543;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1 = (function (state_75492){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75492);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75544){var ex__2730__auto__ = e75544;
var statearr_75545_75588 = state_75492;
(statearr_75545_75588[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75492[(4)]))){
var statearr_75546_75589 = state_75492;
(statearr_75546_75589[(1)] = cljs.core.first((state_75492[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75590 = state_75492;
state_75492 = G__75590;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = function(state_75492){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1.call(this,state_75492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75547 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75547[(6)] = c__2749__auto__);

return statearr_75547;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__75591 = db;
var map__75591__$1 = cljs.core.__destructure_map(map__75591);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75591__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75591__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75591__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75598){
var state_val_75599 = (state_75598[(1)]);
if((state_val_75599 === (1))){
var inst_75592 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_75593 = fluree.db.session.db(conn,inst_75592,null);
var state_75598__$1 = state_75598;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75598__$1,(2),inst_75593);
} else {
if((state_val_75599 === (2))){
var inst_75595 = (state_75598[(2)]);
var inst_75596 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_75595);
var state_75598__$1 = state_75598;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75598__$1,inst_75596);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_75600 = [null,null,null,null,null,null,null];
(statearr_75600[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_75600[(1)] = (1));

return statearr_75600;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_75598){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75598);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75601){var ex__2730__auto__ = e75601;
var statearr_75602_75629 = state_75598;
(statearr_75602_75629[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75598[(4)]))){
var statearr_75603_75630 = state_75598;
(statearr_75603_75630[(1)] = cljs.core.first((state_75598[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75631 = state_75598;
state_75598 = G__75631;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_75598){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_75598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75604 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75604[(6)] = c__2749__auto__);

return statearr_75604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,ledger_id,listen_id,event_fn);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75617){
var state_val_75618 = (state_75617[(1)]);
if((state_val_75618 === (1))){
var inst_75605 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_75606 = fluree.db.session.db(conn,inst_75605,null);
var state_75617__$1 = state_75617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75617__$1,(2),inst_75606);
} else {
if((state_val_75618 === (2))){
var inst_75608 = (state_75617[(7)]);
var inst_75608__$1 = (state_75617[(2)]);
var inst_75609 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_75608__$1);
var inst_75610 = newer_block_QMARK_(inst_75609);
var state_75617__$1 = (function (){var statearr_75619 = state_75617;
(statearr_75619[(7)] = inst_75608__$1);

return statearr_75619;
})();
if(inst_75610){
var statearr_75620_75632 = state_75617__$1;
(statearr_75620_75632[(1)] = (3));

} else {
var statearr_75621_75633 = state_75617__$1;
(statearr_75621_75633[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75618 === (3))){
var inst_75608 = (state_75617[(7)]);
var inst_75612 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_75608);
var state_75617__$1 = state_75617;
var statearr_75622_75634 = state_75617__$1;
(statearr_75622_75634[(2)] = inst_75612);

(statearr_75622_75634[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75618 === (4))){
var state_75617__$1 = state_75617;
var statearr_75623_75635 = state_75617__$1;
(statearr_75623_75635[(2)] = null);

(statearr_75623_75635[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75618 === (5))){
var inst_75615 = (state_75617[(2)]);
var state_75617__$1 = state_75617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75617__$1,inst_75615);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_75624 = [null,null,null,null,null,null,null,null];
(statearr_75624[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_75624[(1)] = (1));

return statearr_75624;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_75617){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75617);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75625){var ex__2730__auto__ = e75625;
var statearr_75626_75636 = state_75617;
(statearr_75626_75636[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75617[(4)]))){
var statearr_75627_75637 = state_75617;
(statearr_75627_75637[(1)] = cljs.core.first((state_75617[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75638 = state_75617;
state_75617 = G__75638;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_75617){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_75617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75628 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75628[(6)] = c__2749__auto__);

return statearr_75628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__75639 = db;
var map__75639__$1 = cljs.core.__destructure_map(map__75639);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75639__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75639__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75639__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4339__auto__ = syncTimeout;
var y__4340__auto__ = (120000);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2749__auto___75715 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75689){
var state_val_75690 = (state_75689[(1)]);
if((state_val_75690 === (7))){
var inst_75655 = (state_75689[(7)]);
var inst_75666 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75655,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_75689__$1 = state_75689;
if(inst_75666){
var statearr_75691_75716 = state_75689__$1;
(statearr_75691_75716[(1)] = (9));

} else {
var statearr_75692_75717 = state_75689__$1;
(statearr_75692_75717[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75690 === (1))){
var inst_75640 = (state_75689[(8)]);
var inst_75648 = (state_75689[(9)]);
var inst_75640__$1 = cljs.core.async.timeout(timeout);
var inst_75648__$1 = res_port;
var inst_75649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75650 = [inst_75640__$1,inst_75648__$1];
var inst_75651 = (new cljs.core.PersistentVector(null,2,(5),inst_75649,inst_75650,null));
var state_75689__$1 = (function (){var statearr_75693 = state_75689;
(statearr_75693[(8)] = inst_75640__$1);

(statearr_75693[(9)] = inst_75648__$1);

return statearr_75693;
})();
return cljs.core.async.ioc_alts_BANG_(state_75689__$1,(2),inst_75651);
} else {
if((state_val_75690 === (4))){
var inst_75648 = (state_75689[(9)]);
var inst_75655 = (state_75689[(7)]);
var inst_75659 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75655,inst_75648);
var state_75689__$1 = state_75689;
if(inst_75659){
var statearr_75694_75718 = state_75689__$1;
(statearr_75694_75718[(1)] = (6));

} else {
var statearr_75695_75719 = state_75689__$1;
(statearr_75695_75719[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75690 === (13))){
var inst_75674 = (state_75689[(10)]);
var inst_75685 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_75674);
var state_75689__$1 = state_75689;
var statearr_75696_75720 = state_75689__$1;
(statearr_75696_75720[(2)] = inst_75685);

(statearr_75696_75720[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75690 === (6))){
var inst_75653 = (state_75689[(11)]);
var inst_75664 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75653,(0),null);
var state_75689__$1 = state_75689;
var statearr_75697_75721 = state_75689__$1;
(statearr_75697_75721[(2)] = inst_75664);

(statearr_75697_75721[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75690 === (3))){
var state_75689__$1 = state_75689;
var statearr_75698_75722 = state_75689__$1;
(statearr_75698_75722[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_75698_75722[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75690 === (12))){
var inst_75678 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_75679 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75680 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_75681 = cljs.core.PersistentHashMap.fromArrays(inst_75679,inst_75680);
var inst_75682 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75678,inst_75681);
var inst_75683 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_75682);
var state_75689__$1 = state_75689;
var statearr_75699_75723 = state_75689__$1;
(statearr_75699_75723[(2)] = inst_75683);

(statearr_75699_75723[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75690 === (2))){
var inst_75640 = (state_75689[(8)]);
var inst_75653 = (state_75689[(11)]);
var inst_75655 = (state_75689[(7)]);
var inst_75653__$1 = (state_75689[(2)]);
var inst_75654 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75653__$1,(0),null);
var inst_75655__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75653__$1,(1),null);
var inst_75656 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75655__$1,inst_75640);
var state_75689__$1 = (function (){var statearr_75700 = state_75689;
(statearr_75700[(11)] = inst_75653__$1);

(statearr_75700[(12)] = inst_75654);

(statearr_75700[(7)] = inst_75655__$1);

return statearr_75700;
})();
if(inst_75656){
var statearr_75701_75724 = state_75689__$1;
(statearr_75701_75724[(1)] = (3));

} else {
var statearr_75702_75725 = state_75689__$1;
(statearr_75702_75725[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75690 === (11))){
var inst_75670 = (state_75689[(2)]);
var state_75689__$1 = state_75689;
var statearr_75703_75726 = state_75689__$1;
(statearr_75703_75726[(2)] = inst_75670);

(statearr_75703_75726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75690 === (9))){
var inst_75654 = (state_75689[(12)]);
var state_75689__$1 = state_75689;
var statearr_75704_75727 = state_75689__$1;
(statearr_75704_75727[(2)] = inst_75654);

(statearr_75704_75727[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75690 === (5))){
var inst_75674 = (state_75689[(10)]);
var inst_75674__$1 = (state_75689[(2)]);
var inst_75675 = fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);
var inst_75676 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_75674__$1);
var state_75689__$1 = (function (){var statearr_75705 = state_75689;
(statearr_75705[(10)] = inst_75674__$1);

(statearr_75705[(13)] = inst_75675);

return statearr_75705;
})();
if(inst_75676){
var statearr_75706_75728 = state_75689__$1;
(statearr_75706_75728[(1)] = (12));

} else {
var statearr_75707_75729 = state_75689__$1;
(statearr_75707_75729[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75690 === (14))){
var inst_75687 = (state_75689[(2)]);
var state_75689__$1 = state_75689;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75689__$1,inst_75687);
} else {
if((state_val_75690 === (10))){
var state_75689__$1 = state_75689;
var statearr_75708_75730 = state_75689__$1;
(statearr_75708_75730[(2)] = null);

(statearr_75708_75730[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75690 === (8))){
var inst_75672 = (state_75689[(2)]);
var state_75689__$1 = state_75689;
var statearr_75709_75731 = state_75689__$1;
(statearr_75709_75731[(2)] = inst_75672);

(statearr_75709_75731[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0 = (function (){
var statearr_75710 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75710[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__);

(statearr_75710[(1)] = (1));

return statearr_75710;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1 = (function (state_75689){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75689);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75711){var ex__2730__auto__ = e75711;
var statearr_75712_75732 = state_75689;
(statearr_75712_75732[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75689[(4)]))){
var statearr_75713_75733 = state_75689;
(statearr_75713_75733[(1)] = cljs.core.first((state_75689[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75734 = state_75689;
state_75689 = G__75734;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = function(state_75689){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1.call(this,state_75689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75714 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75714[(6)] = c__2749__auto___75715);

return statearr_75714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__75736 = arguments.length;
switch (G__75736) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__75737){
var map__75738 = p__75737;
var map__75738__$1 = cljs.core.__destructure_map(map__75738);
var opts = map__75738__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75738__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75738__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75738__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75738__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75738__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2749__auto___75827 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75789){
var state_val_75790 = (state_75789[(1)]);
if((state_val_75790 === (7))){
var inst_75751 = (state_75789[(7)]);
var inst_75753 = fluree.db.api.ledger.syncTo_db(inst_75751,syncTo,syncTimeout);
var state_75789__$1 = state_75789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75789__$1,(10),inst_75753);
} else {
if((state_val_75790 === (20))){
var inst_75775 = (state_75789[(8)]);
var state_75789__$1 = state_75789;
var statearr_75791_75828 = state_75789__$1;
(statearr_75791_75828[(2)] = inst_75775);

(statearr_75791_75828[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (1))){
var state_75789__$1 = state_75789;
var statearr_75792_75829 = state_75789__$1;
(statearr_75792_75829[(2)] = null);

(statearr_75792_75829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (4))){
var inst_75739 = (state_75789[(2)]);
var inst_75740 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_75739);
var inst_75741 = cljs.core.async.close_BANG_(pc);
var state_75789__$1 = (function (){var statearr_75793 = state_75789;
(statearr_75793[(9)] = inst_75740);

return statearr_75793;
})();
var statearr_75794_75830 = state_75789__$1;
(statearr_75794_75830[(2)] = inst_75741);

(statearr_75794_75830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (15))){
var inst_75767 = (state_75789[(10)]);
var inst_75769 = fluree.db.api.ledger.add_db_permissions(inst_75767,auth,roles);
var state_75789__$1 = state_75789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75789__$1,(18),inst_75769);
} else {
if((state_val_75790 === (21))){
var inst_75783 = (state_75789[(2)]);
var inst_75784 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_75783);
var _ = (function (){var statearr_75795 = state_75789;
(statearr_75795[(4)] = cljs.core.rest((state_75789[(4)])));

return statearr_75795;
})();
var state_75789__$1 = state_75789;
var statearr_75796_75831 = state_75789__$1;
(statearr_75796_75831[(2)] = inst_75784);

(statearr_75796_75831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (13))){
var inst_75767 = (state_75789[(2)]);
var state_75789__$1 = (function (){var statearr_75797 = state_75789;
(statearr_75797[(10)] = inst_75767);

return statearr_75797;
})();
if(cljs.core.truth_(roles)){
var statearr_75798_75832 = state_75789__$1;
(statearr_75798_75832[(1)] = (15));

} else {
var statearr_75799_75833 = state_75789__$1;
(statearr_75799_75833[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (22))){
var inst_75779 = (state_75789[(2)]);
var inst_75780 = fluree.db.util.async.throw_err(inst_75779);
var state_75789__$1 = state_75789;
var statearr_75800_75834 = state_75789__$1;
(statearr_75800_75834[(2)] = inst_75780);

(statearr_75800_75834[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (6))){
var inst_75750 = (state_75789[(2)]);
var inst_75751 = fluree.db.util.async.throw_err(inst_75750);
var state_75789__$1 = (function (){var statearr_75801 = state_75789;
(statearr_75801[(7)] = inst_75751);

return statearr_75801;
})();
if(cljs.core.truth_(syncTo)){
var statearr_75802_75835 = state_75789__$1;
(statearr_75802_75835[(1)] = (7));

} else {
var statearr_75803_75836 = state_75789__$1;
(statearr_75803_75836[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (17))){
var inst_75775 = (state_75789[(2)]);
var state_75789__$1 = (function (){var statearr_75804 = state_75789;
(statearr_75804[(8)] = inst_75775);

return statearr_75804;
})();
if(cljs.core.truth_(auth)){
var statearr_75805_75837 = state_75789__$1;
(statearr_75805_75837[(1)] = (19));

} else {
var statearr_75806_75838 = state_75789__$1;
(statearr_75806_75838[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (3))){
var inst_75787 = (state_75789[(2)]);
var state_75789__$1 = state_75789;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75789__$1,inst_75787);
} else {
if((state_val_75790 === (12))){
var inst_75759 = (state_75789[(11)]);
var state_75789__$1 = state_75789;
var statearr_75807_75839 = state_75789__$1;
(statearr_75807_75839[(2)] = inst_75759);

(statearr_75807_75839[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (2))){
var _ = (function (){var statearr_75808 = state_75789;
(statearr_75808[(4)] = cljs.core.cons((5),(state_75789[(4)])));

return statearr_75808;
})();
var inst_75748 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_75789__$1 = state_75789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75789__$1,(6),inst_75748);
} else {
if((state_val_75790 === (19))){
var inst_75775 = (state_75789[(8)]);
var inst_75777 = fluree.db.api.ledger.add_db_permissions(inst_75775,auth,roles);
var state_75789__$1 = state_75789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75789__$1,(22),inst_75777);
} else {
if((state_val_75790 === (11))){
var inst_75759 = (state_75789[(11)]);
var inst_75761 = fluree.db.time_travel.as_of_block(inst_75759,block);
var state_75789__$1 = state_75789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75789__$1,(14),inst_75761);
} else {
if((state_val_75790 === (9))){
var inst_75759 = (state_75789[(2)]);
var state_75789__$1 = (function (){var statearr_75810 = state_75789;
(statearr_75810[(11)] = inst_75759);

return statearr_75810;
})();
if(cljs.core.truth_(block)){
var statearr_75811_75840 = state_75789__$1;
(statearr_75811_75840[(1)] = (11));

} else {
var statearr_75812_75841 = state_75789__$1;
(statearr_75812_75841[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (5))){
var _ = (function (){var statearr_75813 = state_75789;
(statearr_75813[(4)] = cljs.core.rest((state_75789[(4)])));

return statearr_75813;
})();
var state_75789__$1 = state_75789;
var ex75809 = (state_75789__$1[(2)]);
var statearr_75814_75842 = state_75789__$1;
(statearr_75814_75842[(5)] = ex75809);


var statearr_75815_75843 = state_75789__$1;
(statearr_75815_75843[(1)] = (4));

(statearr_75815_75843[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (14))){
var inst_75763 = (state_75789[(2)]);
var inst_75764 = fluree.db.util.async.throw_err(inst_75763);
var state_75789__$1 = state_75789;
var statearr_75816_75844 = state_75789__$1;
(statearr_75816_75844[(2)] = inst_75764);

(statearr_75816_75844[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (16))){
var inst_75767 = (state_75789[(10)]);
var state_75789__$1 = state_75789;
var statearr_75817_75845 = state_75789__$1;
(statearr_75817_75845[(2)] = inst_75767);

(statearr_75817_75845[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (10))){
var inst_75755 = (state_75789[(2)]);
var inst_75756 = fluree.db.util.async.throw_err(inst_75755);
var state_75789__$1 = state_75789;
var statearr_75818_75846 = state_75789__$1;
(statearr_75818_75846[(2)] = inst_75756);

(statearr_75818_75846[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (18))){
var inst_75771 = (state_75789[(2)]);
var inst_75772 = fluree.db.util.async.throw_err(inst_75771);
var state_75789__$1 = state_75789;
var statearr_75819_75847 = state_75789__$1;
(statearr_75819_75847[(2)] = inst_75772);

(statearr_75819_75847[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75790 === (8))){
var inst_75751 = (state_75789[(7)]);
var state_75789__$1 = state_75789;
var statearr_75820_75848 = state_75789__$1;
(statearr_75820_75848[(2)] = inst_75751);

(statearr_75820_75848[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_75821 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75821[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_75821[(1)] = (1));

return statearr_75821;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_75789){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75789);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75822){var ex__2730__auto__ = e75822;
var statearr_75823_75849 = state_75789;
(statearr_75823_75849[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75789[(4)]))){
var statearr_75824_75850 = state_75789;
(statearr_75824_75850[(1)] = cljs.core.first((state_75789[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75851 = state_75789;
state_75789 = G__75851;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_75789){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_75789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75825 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75825[(6)] = c__2749__auto___75827);

return statearr_75825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

