// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.crypto.asn1');
goog.require('cljs.core');
fluree.crypto.asn1.node$module$_CIRCA_fluree$sjcl = require('@fluree/sjcl');
fluree.crypto.asn1.encode_asn1_length_hex = (function fluree$crypto$asn1$encode_asn1_length_hex(len){
return len.toString((16));
});
fluree.crypto.asn1.decode_asn1_length = (function fluree$crypto$asn1$decode_asn1_length(asn1){
var len = parseInt(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(asn1,(0),(2)),(16));
if(((len & (128)) === (0))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Lengths greater than 0x80 not supported",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"length","length",588987862),len,new cljs.core.Keyword(null,"asn1","asn1",1199738698),asn1], null));
}

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"length","length",588987862),len,new cljs.core.Keyword(null,"remaining","remaining",-138926777),cljs.core.subs.cljs$core$IFn$_invoke$arity$2(asn1,(2))], null);
});
/**
 * Formats a hexadecimal encoding an unsigned integer, dropping left zeros and
 *   padding with a left zero if necessary to avoid being confused for a two's complement
 */
fluree.crypto.asn1.format_asn1_unsigned_integer_hex = (function fluree$crypto$asn1$format_asn1_unsigned_integer_hex(n){
var bytes = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(cljs.core.zero_QMARK_,(function (){var G__86617 = (fluree.crypto.asn1.node$module$_CIRCA_fluree$sjcl.codec.hex.toBits.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.asn1.node$module$_CIRCA_fluree$sjcl.codec.hex.toBits.cljs$core$IFn$_invoke$arity$1(n) : fluree.crypto.asn1.node$module$_CIRCA_fluree$sjcl.codec.hex.toBits.call(null,n));
return (fluree.crypto.asn1.node$module$_CIRCA_fluree$sjcl.codec.bytes.fromBits.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.asn1.node$module$_CIRCA_fluree$sjcl.codec.bytes.fromBits.cljs$core$IFn$_invoke$arity$1(G__86617) : fluree.crypto.asn1.node$module$_CIRCA_fluree$sjcl.codec.bytes.fromBits.call(null,G__86617));
})());
var bytes_STAR_ = cljs.core.clj__GT_js((((!(((cljs.core.first(bytes) & (128)) === (0)))))?cljs.core.cons((0),bytes):bytes));
var G__86618 = (fluree.crypto.asn1.node$module$_CIRCA_fluree$sjcl.codec.bytes.toBits.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.asn1.node$module$_CIRCA_fluree$sjcl.codec.bytes.toBits.cljs$core$IFn$_invoke$arity$1(bytes_STAR_) : fluree.crypto.asn1.node$module$_CIRCA_fluree$sjcl.codec.bytes.toBits.call(null,bytes_STAR_));
return (fluree.crypto.asn1.node$module$_CIRCA_fluree$sjcl.codec.hex.fromBits.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.asn1.node$module$_CIRCA_fluree$sjcl.codec.hex.fromBits.cljs$core$IFn$_invoke$arity$1(G__86618) : fluree.crypto.asn1.node$module$_CIRCA_fluree$sjcl.codec.hex.fromBits.call(null,G__86618));
});
/**
 * Formats a byte encoded unsigned integer, dropping left zeros and
 *   padding with a left zero if necessary to avoid being confused for a two's complement
 */
fluree.crypto.asn1.format_asn1_unsigned_integer = (function fluree$crypto$asn1$format_asn1_unsigned_integer(ba){
var bytes = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(cljs.core.zero_QMARK_,ba);
if((!(((cljs.core.first(bytes) & (128)) === (0))))){
return cljs.core.clj__GT_js(cljs.core.cons((0),bytes));
} else {
return bytes;
}
});
/**
 * Formats a hexadecimal as an unsigned integer, padding and prepending a length
 */
fluree.crypto.asn1.encode_asn1_unsigned_integer_hex = (function fluree$crypto$asn1$encode_asn1_unsigned_integer_hex(n){
var formatted_n = fluree.crypto.asn1.format_asn1_unsigned_integer_hex(n);
var len = fluree.crypto.asn1.encode_asn1_length_hex((cljs.core.count(formatted_n) / (2)));
return ["02",cljs.core.str.cljs$core$IFn$_invoke$arity$1(len),cljs.core.str.cljs$core$IFn$_invoke$arity$1(formatted_n)].join('');
});
/**
 * Formats a byte array as an unsigned integer, padding and prepending a length
 */
fluree.crypto.asn1.encode_asn1_unsigned_integer = (function fluree$crypto$asn1$encode_asn1_unsigned_integer(ba){
var formatted_n = fluree.crypto.asn1.format_asn1_unsigned_integer(ba);
var size = cljs.core.count(formatted_n);
return cljs.core.clj__GT_js(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),size], null),formatted_n));
});
/**
 * Decodes an int from the top of an ASN.1 encoded string
 */
fluree.crypto.asn1.decode_asn1_integer = (function fluree$crypto$asn1$decode_asn1_integer(asn1){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(asn1,(0),(2)),"02")){
} else {
throw (new Error(["Assert failed: ","ASN.1 must have a 02 tag for an integer","\n","(= (subs asn1 0 2) \"02\")"].join('')));
}

var map__86619 = fluree.crypto.asn1.decode_asn1_length(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(asn1,(2)));
var map__86619__$1 = cljs.core.__destructure_map(map__86619);
var length = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__86619__$1,new cljs.core.Keyword(null,"length","length",588987862));
var remaining = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__86619__$1,new cljs.core.Keyword(null,"remaining","remaining",-138926777));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"integer","integer",-604721710),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(remaining,(0),((2) * length)),new cljs.core.Keyword(null,"remaining","remaining",-138926777),cljs.core.subs.cljs$core$IFn$_invoke$arity$2(remaining,((2) * length))], null);
});
