// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.common');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.query.fql_resp');
/**
 * Transducing function to extract matching subjects from initial where clause.
 */
fluree.db.query.subject_crawl.common.where_subj_xf = (function fluree$db$query$subject_crawl$common$where_subj_xf(p__22835){
var map__22836 = p__22835;
var map__22836__$1 = cljs.core.__destructure_map(map__22836);
var start_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22836__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22836__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22836__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22836__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var xf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22836__$1,new cljs.core.Keyword(null,"xf","xf",401902988));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,(function (){var G__22837 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$5(flakes,start_test,start_flake,end_test,end_flake);
}))], null);
if(cljs.core.truth_(xf)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__22837,xf);
} else {
return G__22837;
}
})());
});
fluree.db.query.subject_crawl.common.result_af = (function fluree$db$query$subject_crawl$common$result_af(p__22838){
var map__22839 = p__22838;
var map__22839__$1 = cljs.core.__destructure_map(map__22839);
var _opts = map__22839__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22839__$1,new cljs.core.Keyword(null,"db","db",993250759));
var cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22839__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var fuel_vol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22839__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22839__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var select_spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22839__$1,new cljs.core.Keyword(null,"select-spec","select-spec",55073283));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22839__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
return (function (flakes,port){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22870){
var state_val_22871 = (state_22870[(1)]);
if((state_val_22871 === (7))){
var state_22870__$1 = state_22870;
var statearr_22872_22898 = state_22870__$1;
(statearr_22872_22898[(2)] = null);

(statearr_22872_22898[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22871 === (1))){
var state_22870__$1 = state_22870;
var statearr_22873_22899 = state_22870__$1;
(statearr_22873_22899[(2)] = null);

(statearr_22873_22899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22871 === (4))){
var inst_22840 = (state_22870[(2)]);
var inst_22841 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_22840);
var inst_22842 = cljs.core.async.close_BANG_(port);
var state_22870__$1 = (function (){var statearr_22874 = state_22870;
(statearr_22874[(7)] = inst_22842);

(statearr_22874[(8)] = inst_22841);

return statearr_22874;
})();
var statearr_22875_22900 = state_22870__$1;
(statearr_22875_22900[(2)] = null);

(statearr_22875_22900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22871 === (6))){
var inst_22852 = (state_22870[(9)]);
var inst_22851 = (state_22870[(2)]);
var inst_22852__$1 = fluree.db.util.async.throw_err(inst_22851);
var inst_22853 = (inst_22852__$1 == null);
var state_22870__$1 = (function (){var statearr_22876 = state_22870;
(statearr_22876[(9)] = inst_22852__$1);

return statearr_22876;
})();
if(cljs.core.truth_(inst_22853)){
var statearr_22877_22901 = state_22870__$1;
(statearr_22877_22901[(1)] = (7));

} else {
var statearr_22878_22902 = state_22870__$1;
(statearr_22878_22902[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22871 === (3))){
var inst_22868 = (state_22870[(2)]);
var state_22870__$1 = state_22870;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22870__$1,inst_22868);
} else {
if((state_val_22871 === (12))){
var inst_22864 = (state_22870[(2)]);
var inst_22865 = cljs.core.async.close_BANG_(port);
var _ = (function (){var statearr_22879 = state_22870;
(statearr_22879[(4)] = cljs.core.rest((state_22870[(4)])));

return statearr_22879;
})();
var state_22870__$1 = (function (){var statearr_22880 = state_22870;
(statearr_22880[(10)] = inst_22864);

return statearr_22880;
})();
var statearr_22881_22903 = state_22870__$1;
(statearr_22881_22903[(2)] = inst_22865);

(statearr_22881_22903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22871 === (2))){
var _ = (function (){var statearr_22882 = state_22870;
(statearr_22882[(4)] = cljs.core.cons((5),(state_22870[(4)])));

return statearr_22882;
})();
var inst_22849 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel_vol,max_fuel,select_spec,flakes);
var state_22870__$1 = state_22870;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22870__$1,(6),inst_22849);
} else {
if((state_val_22871 === (11))){
var inst_22858 = (state_22870[(11)]);
var inst_22862 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_22858);
var state_22870__$1 = state_22870;
var statearr_22884_22904 = state_22870__$1;
(statearr_22884_22904[(2)] = inst_22862);

(statearr_22884_22904[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22871 === (9))){
var inst_22858 = (state_22870[(11)]);
var inst_22858__$1 = (state_22870[(2)]);
var inst_22859 = (inst_22858__$1 == null);
var state_22870__$1 = (function (){var statearr_22885 = state_22870;
(statearr_22885[(11)] = inst_22858__$1);

return statearr_22885;
})();
if(cljs.core.truth_(inst_22859)){
var statearr_22886_22905 = state_22870__$1;
(statearr_22886_22905[(1)] = (10));

} else {
var statearr_22887_22906 = state_22870__$1;
(statearr_22887_22906[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22871 === (5))){
var _ = (function (){var statearr_22888 = state_22870;
(statearr_22888[(4)] = cljs.core.rest((state_22870[(4)])));

return statearr_22888;
})();
var state_22870__$1 = state_22870;
var ex22883 = (state_22870__$1[(2)]);
var statearr_22889_22907 = state_22870__$1;
(statearr_22889_22907[(5)] = ex22883);


var statearr_22890_22908 = state_22870__$1;
(statearr_22890_22908[(1)] = (4));

(statearr_22890_22908[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22871 === (10))){
var state_22870__$1 = state_22870;
var statearr_22891_22909 = state_22870__$1;
(statearr_22891_22909[(2)] = null);

(statearr_22891_22909[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22871 === (8))){
var inst_22852 = (state_22870[(9)]);
var inst_22856 = cljs.core.not_empty(inst_22852);
var state_22870__$1 = state_22870;
var statearr_22892_22910 = state_22870__$1;
(statearr_22892_22910[(2)] = inst_22856);

(statearr_22892_22910[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0 = (function (){
var statearr_22893 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22893[(0)] = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__);

(statearr_22893[(1)] = (1));

return statearr_22893;
});
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1 = (function (state_22870){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22870);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22894){var ex__2730__auto__ = e22894;
var statearr_22895_22911 = state_22870;
(statearr_22895_22911[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22870[(4)]))){
var statearr_22896_22912 = state_22870;
(statearr_22896_22912[(1)] = cljs.core.first((state_22870[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22913 = state_22870;
state_22870 = G__22913;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__ = function(state_22870){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1.call(this,state_22870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22897 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22897[(6)] = c__2749__auto__);

return statearr_22897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
});
/**
 * Returns a specific filtering function which takes all subject flakes and
 *   returns the flakes allowed, or nil if none are allowed.
 */
fluree.db.query.subject_crawl.common.subj_perm_filter_fn = (function fluree$db$query$subject_crawl$common$subj_perm_filter_fn(p__22914){
var map__22915 = p__22914;
var map__22915__$1 = cljs.core.__destructure_map(map__22915);
var db = map__22915__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22915__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var pred_permissions_QMARK_ = cljs.core.contains_QMARK_(permissions,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
var coll_permissions = new cljs.core.Keyword(null,"collection","collection",-683361892).cljs$core$IFn$_invoke$arity$1(permissions);
var filter_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var default_deny_QMARK_ = ((new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(coll_permissions) === true)?false:true);
var filter_predicates_QMARK_ = (function (cid){
var temp__5806__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(filter_cache),cid);
if((temp__5806__auto__ == null)){
var coll_perm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll_permissions,cid);
var filter_QMARK_ = ((fluree.db.util.schema.is_schema_cid_QMARK_(cid))?false:((pred_permissions_QMARK_)?true:(((coll_perm == null))?default_deny_QMARK_:((((cljs.core.contains_QMARK_(coll_perm,new cljs.core.Keyword(null,"all","all",892129742))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(coll_perm)))))?false:true
))));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(filter_cache,cljs.core.assoc,cid,filter_QMARK_);

return cljs.core.filter;
} else {
var cached = temp__5806__auto__;
return cached;
}
});
return (function (flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22946){
var state_val_22947 = (state_22946[(1)]);
if((state_val_22947 === (7))){
var inst_22922 = (state_22946[(7)]);
var inst_22932 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_22922);
var state_22946__$1 = state_22946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22946__$1,(10),inst_22932);
} else {
if((state_val_22947 === (1))){
var state_22946__$1 = state_22946;
var statearr_22948_22971 = state_22946__$1;
(statearr_22948_22971[(2)] = null);

(statearr_22948_22971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (4))){
var inst_22916 = (state_22946[(2)]);
var state_22946__$1 = state_22946;
var statearr_22949_22972 = state_22946__$1;
(statearr_22949_22972[(2)] = inst_22916);

(statearr_22949_22972[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (13))){
var inst_22939 = (state_22946[(2)]);
var state_22946__$1 = state_22946;
var statearr_22950_22973 = state_22946__$1;
(statearr_22950_22973[(2)] = inst_22939);

(statearr_22950_22973[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (6))){
var inst_22927 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,flakes);
var state_22946__$1 = state_22946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22946__$1,(9),inst_22927);
} else {
if((state_val_22947 === (3))){
var inst_22944 = (state_22946[(2)]);
var state_22946__$1 = state_22946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22946__$1,inst_22944);
} else {
if((state_val_22947 === (12))){
var state_22946__$1 = state_22946;
var statearr_22951_22974 = state_22946__$1;
(statearr_22951_22974[(2)] = null);

(statearr_22951_22974[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (2))){
var inst_22922 = (state_22946[(7)]);
var _ = (function (){var statearr_22952 = state_22946;
(statearr_22952[(4)] = cljs.core.cons((5),(state_22946[(4)])));

return statearr_22952;
})();
var inst_22922__$1 = cljs.core.first(flakes);
var inst_22923 = fluree.db.flake.s(inst_22922__$1);
var inst_22924 = fluree.db.flake.sid__GT_cid(inst_22923);
var inst_22925 = filter_predicates_QMARK_(inst_22924);
var state_22946__$1 = (function (){var statearr_22953 = state_22946;
(statearr_22953[(7)] = inst_22922__$1);

return statearr_22953;
})();
if(cljs.core.truth_(inst_22925)){
var statearr_22954_22975 = state_22946__$1;
(statearr_22954_22975[(1)] = (6));

} else {
var statearr_22955_22976 = state_22946__$1;
(statearr_22955_22976[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (11))){
var state_22946__$1 = state_22946;
var statearr_22957_22977 = state_22946__$1;
(statearr_22957_22977[(2)] = flakes);

(statearr_22957_22977[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (9))){
var inst_22929 = (state_22946[(2)]);
var inst_22930 = fluree.db.util.async.throw_err(inst_22929);
var state_22946__$1 = state_22946;
var statearr_22958_22978 = state_22946__$1;
(statearr_22958_22978[(2)] = inst_22930);

(statearr_22958_22978[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (5))){
var _ = (function (){var statearr_22959 = state_22946;
(statearr_22959[(4)] = cljs.core.rest((state_22946[(4)])));

return statearr_22959;
})();
var state_22946__$1 = state_22946;
var ex22956 = (state_22946__$1[(2)]);
var statearr_22960_22979 = state_22946__$1;
(statearr_22960_22979[(5)] = ex22956);


if((ex22956 instanceof Error)){
var statearr_22961_22980 = state_22946__$1;
(statearr_22961_22980[(1)] = (4));

(statearr_22961_22980[(5)] = null);

} else {
throw ex22956;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (10))){
var inst_22934 = (state_22946[(2)]);
var inst_22935 = fluree.db.util.async.throw_err(inst_22934);
var state_22946__$1 = state_22946;
if(cljs.core.truth_(inst_22935)){
var statearr_22962_22981 = state_22946__$1;
(statearr_22962_22981[(1)] = (11));

} else {
var statearr_22963_22982 = state_22946__$1;
(statearr_22963_22982[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22947 === (8))){
var inst_22941 = (state_22946[(2)]);
var _ = (function (){var statearr_22964 = state_22946;
(statearr_22964[(4)] = cljs.core.rest((state_22946[(4)])));

return statearr_22964;
})();
var state_22946__$1 = state_22946;
var statearr_22965_22983 = state_22946__$1;
(statearr_22965_22983[(2)] = inst_22941);

(statearr_22965_22983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_22966 = [null,null,null,null,null,null,null,null];
(statearr_22966[(0)] = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__);

(statearr_22966[(1)] = (1));

return statearr_22966;
});
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1 = (function (state_22946){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22946);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22967){var ex__2730__auto__ = e22967;
var statearr_22968_22984 = state_22946;
(statearr_22968_22984[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22946[(4)]))){
var statearr_22969_22985 = state_22946;
(statearr_22969_22985[(1)] = cljs.core.first((state_22946[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22986 = state_22946;
state_22946 = G__22986;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__ = function(state_22946){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1.call(this,state_22946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22970 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22970[(6)] = c__2749__auto__);

return statearr_22970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
});
fluree.db.query.subject_crawl.common.passes_filter_QMARK_ = (function fluree$db$query$subject_crawl$common$passes_filter_QMARK_(filter_fn,vars,pred_flakes){
return cljs.core.some((function (p1__22987_SHARP_){
return (filter_fn.cljs$core$IFn$_invoke$arity$2 ? filter_fn.cljs$core$IFn$_invoke$arity$2(p1__22987_SHARP_,vars) : filter_fn.call(null,p1__22987_SHARP_,vars));
}),pred_flakes);
});
/**
 * For a group of predicate flakes (all same .-p value)
 *   and a list of filter-functions, returns true if at least
 *   one of the predicates passes every function, else returns false.
 */
fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_ = (function fluree$db$query$subject_crawl$common$pass_all_filters_QMARK_(filter_fns,vars,pred_flakes){
var G__22991 = filter_fns;
var vec__22992 = G__22991;
var seq__22993 = cljs.core.seq(vec__22992);
var first__22994 = cljs.core.first(seq__22993);
var seq__22993__$1 = cljs.core.next(seq__22993);
var filter_fn = first__22994;
var r_fns = seq__22993__$1;
var G__22991__$1 = G__22991;
while(true){
var vec__22995 = G__22991__$1;
var seq__22996 = cljs.core.seq(vec__22995);
var first__22997 = cljs.core.first(seq__22996);
var seq__22996__$1 = cljs.core.next(seq__22996);
var filter_fn__$1 = first__22997;
var r_fns__$1 = seq__22996__$1;
if(cljs.core.truth_(filter_fn__$1)){
if(cljs.core.truth_(fluree.db.query.subject_crawl.common.passes_filter_QMARK_(filter_fn__$1,vars,pred_flakes))){
var G__22998 = r_fns__$1;
G__22991__$1 = G__22998;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});
/**
 * Filters a set of flakes for a single subject and returns true if
 *   the subject meets the filter map.
 * 
 *   filter-map is a map where pred-ids are keys and values are a list of filtering functions
 *   where each flake of pred-id must return a truthy value if the subject is allowed.
 */
fluree.db.query.subject_crawl.common.filter_subject = (function fluree$db$query$subject_crawl$common$filter_subject(vars,filter_map,flakes){
var G__23002 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p,flakes);
var vec__23003 = G__23002;
var seq__23004 = cljs.core.seq(vec__23003);
var first__23005 = cljs.core.first(seq__23004);
var seq__23004__$1 = cljs.core.next(seq__23004);
var p_flakes = first__23005;
var r = seq__23004__$1;
var required_p = new cljs.core.Keyword(null,"required-p","required-p",-2091946078).cljs$core$IFn$_invoke$arity$1(filter_map);
var G__23002__$1 = G__23002;
var required_p__$1 = required_p;
while(true){
var vec__23009 = G__23002__$1;
var seq__23010 = cljs.core.seq(vec__23009);
var first__23011 = cljs.core.first(seq__23010);
var seq__23010__$1 = cljs.core.next(seq__23010);
var p_flakes__$1 = first__23011;
var r__$1 = seq__23010__$1;
var required_p__$2 = required_p__$1;
if(cljs.core.truth_(p_flakes__$1)){
var p = fluree.db.flake.p(cljs.core.first(p_flakes__$1));
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(filter_map,p);
if(cljs.core.truth_(temp__5802__auto__)){
var filter_fns = temp__5802__auto__;
if(fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_(filter_fns,vars,p_flakes__$1)){
var G__23012 = r__$1;
var G__23013 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(required_p__$2,p);
G__23002__$1 = G__23012;
required_p__$1 = G__23013;
continue;
} else {
return null;
}
} else {
var G__23014 = r__$1;
var G__23015 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(required_p__$2,p);
G__23002__$1 = G__23014;
required_p__$1 = G__23015;
continue;
}
} else {
if(cljs.core.empty_QMARK_(required_p__$2)){
return flakes;
} else {
return null;
}
}
break;
}
});
/**
 * If order-by exists in query, orders final results.
 *   order-by is defined by a map with keys (see analytical-parse for code):
 *   - :type - :variable or :predicate
 *   - :order - :asc or :desc
 *   - :predicate - if type = :predicate, contains predicate pid or name
 *   - :variable - if type = :variable, contains variable name (not supported for simple subject crawl)
 */
fluree.db.query.subject_crawl.common.order_results = (function fluree$db$query$subject_crawl$common$order_results(results,p__23016){
var map__23017 = p__23016;
var map__23017__$1 = cljs.core.__destructure_map(map__23017);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23017__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var order = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23017__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var predicate = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23017__$1,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"variable","variable",-281346492),type)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Ordering by a variable not supported in this type of query.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var G__23018 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (result){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(result,predicate);
}),results);
var G__23018__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"desc","desc",2093485764),order))?cljs.core.reverse(G__23018):G__23018);
return cljs.core.vec(G__23018__$1);

}
});
