// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.index');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4253__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * If a predicate is provided as a string value, coerce to pid
 */
fluree.db.query.range.coerce_predicate = (function fluree$db$query$range$coerce_predicate(db,pred){
if(typeof pred === 'string'){
var or__4253__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),pred);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",pred].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return pred;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14258 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14258,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14258,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14258,(2),null);
var p4 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14258,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14258,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14258,(5),null);
var G__14261 = idx;
var G__14261__$1 = (((G__14261 instanceof cljs.core.Keyword))?G__14261.fqn:null);
switch (G__14261__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.query.range.coerce_predicate(db,p2),p3,p4,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate(db,p1),p3,p4,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate(db,p1),p2,p4,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.query.range.coerce_predicate(db,p2),p1,p4,op,m], null);

break;
case "tspo":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.query.range.coerce_predicate(db,p3),p4,p1,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14261__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(9007199254740991)], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
fluree.db.query.range.txn_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null);
fluree.db.query.range.txn_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14263 = idx;
var G__14263__$1 = (((G__14263 instanceof cljs.core.Keyword))?G__14263.fqn:null);
switch (G__14263__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
case "tspo":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14263__$1)].join('')));

}
});
/**
 * Biggest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14265 = idx;
var G__14265__$1 = (((G__14265 instanceof cljs.core.Keyword))?G__14265.fqn:null);
switch (G__14265__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
case "tspo":
return fluree.db.query.range.txn_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14265__$1)].join('')));

}
});
fluree.db.query.range.resolve_subid = (function fluree$db$query$range$resolve_subid(db,id){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if(cljs.core.not(id)){
cljs.core.async.close_BANG_(out);
} else {
if(fluree.db.util.core.pred_ident_QMARK_(id)){
cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,id),out);
} else {
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,id);
}
}

return out;
});
fluree.db.query.range.resolve_match_flake = (function fluree$db$query$range$resolve_match_flake(db,test,parts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14305){
var state_val_14306 = (state_14305[(1)]);
if((state_val_14306 === (7))){
var inst_14282 = (state_14305[(7)]);
var inst_14289 = (state_14305[(2)]);
var inst_14290 = fluree.db.util.async.throw_err(inst_14289);
var state_14305__$1 = (function (){var statearr_14307 = state_14305;
(statearr_14307[(8)] = inst_14290);

return statearr_14307;
})();
if(cljs.core.truth_(inst_14282)){
var statearr_14308_14332 = state_14305__$1;
(statearr_14308_14332[(1)] = (8));

} else {
var statearr_14309_14333 = state_14305__$1;
(statearr_14309_14333[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (1))){
var state_14305__$1 = state_14305;
var statearr_14310_14334 = state_14305__$1;
(statearr_14310_14334[(2)] = null);

(statearr_14310_14334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (4))){
var inst_14267 = (state_14305[(2)]);
var state_14305__$1 = state_14305;
var statearr_14311_14335 = state_14305__$1;
(statearr_14311_14335[(2)] = inst_14267);

(statearr_14311_14335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (13))){
var inst_14297 = (state_14305[(2)]);
var state_14305__$1 = state_14305;
var statearr_14312_14336 = state_14305__$1;
(statearr_14312_14336[(2)] = inst_14297);

(statearr_14312_14336[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (6))){
var inst_14279 = (state_14305[(9)]);
var inst_14285 = (state_14305[(2)]);
var inst_14286 = fluree.db.util.async.throw_err(inst_14285);
var inst_14287 = fluree.db.query.range.resolve_subid(db,inst_14279);
var state_14305__$1 = (function (){var statearr_14313 = state_14305;
(statearr_14313[(10)] = inst_14286);

return statearr_14313;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14305__$1,(7),inst_14287);
} else {
if((state_val_14306 === (3))){
var inst_14303 = (state_14305[(2)]);
var state_14305__$1 = state_14305;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14305__$1,inst_14303);
} else {
if((state_val_14306 === (12))){
var state_14305__$1 = state_14305;
var statearr_14314_14337 = state_14305__$1;
(statearr_14314_14337[(2)] = (2147483647));

(statearr_14314_14337[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (2))){
var _ = (function (){var statearr_14315 = state_14305;
(statearr_14315[(4)] = cljs.core.cons((5),(state_14305[(4)])));

return statearr_14315;
})();
var inst_14276 = parts;
var inst_14277 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14276,(0),null);
var inst_14278 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14276,(1),null);
var inst_14279 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14276,(2),null);
var inst_14280 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14276,(3),null);
var inst_14281 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14276,(4),null);
var inst_14282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14276,(5),null);
var inst_14283 = fluree.db.query.range.resolve_subid(db,inst_14277);
var state_14305__$1 = (function (){var statearr_14316 = state_14305;
(statearr_14316[(7)] = inst_14282);

(statearr_14316[(11)] = inst_14278);

(statearr_14316[(9)] = inst_14279);

(statearr_14316[(12)] = inst_14281);

(statearr_14316[(13)] = inst_14280);

return statearr_14316;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14305__$1,(6),inst_14283);
} else {
if((state_val_14306 === (11))){
var state_14305__$1 = state_14305;
var statearr_14318_14338 = state_14305__$1;
(statearr_14318_14338[(2)] = (-2147483647));

(statearr_14318_14338[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (9))){
var inst_14293 = (cljs.core._GT__EQ_ === test);
var state_14305__$1 = state_14305;
if(cljs.core.truth_(inst_14293)){
var statearr_14319_14339 = state_14305__$1;
(statearr_14319_14339[(1)] = (11));

} else {
var statearr_14320_14340 = state_14305__$1;
(statearr_14320_14340[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (5))){
var _ = (function (){var statearr_14321 = state_14305;
(statearr_14321[(4)] = cljs.core.rest((state_14305[(4)])));

return statearr_14321;
})();
var state_14305__$1 = state_14305;
var ex14317 = (state_14305__$1[(2)]);
var statearr_14322_14341 = state_14305__$1;
(statearr_14322_14341[(5)] = ex14317);


if((ex14317 instanceof Error)){
var statearr_14323_14342 = state_14305__$1;
(statearr_14323_14342[(1)] = (4));

(statearr_14323_14342[(5)] = null);

} else {
throw ex14317;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (10))){
var inst_14278 = (state_14305[(11)]);
var inst_14286 = (state_14305[(10)]);
var inst_14281 = (state_14305[(12)]);
var inst_14290 = (state_14305[(8)]);
var inst_14280 = (state_14305[(13)]);
var inst_14299 = (state_14305[(2)]);
var inst_14300 = fluree.db.flake.__GT_Flake(inst_14286,inst_14278,inst_14290,inst_14280,inst_14281,inst_14299);
var _ = (function (){var statearr_14324 = state_14305;
(statearr_14324[(4)] = cljs.core.rest((state_14305[(4)])));

return statearr_14324;
})();
var state_14305__$1 = state_14305;
var statearr_14325_14343 = state_14305__$1;
(statearr_14325_14343[(2)] = inst_14300);

(statearr_14325_14343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14306 === (8))){
var inst_14282 = (state_14305[(7)]);
var state_14305__$1 = state_14305;
var statearr_14326_14344 = state_14305__$1;
(statearr_14326_14344[(2)] = inst_14282);

(statearr_14326_14344[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0 = (function (){
var statearr_14327 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14327[(0)] = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__);

(statearr_14327[(1)] = (1));

return statearr_14327;
});
var fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1 = (function (state_14305){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14305);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14328){var ex__2730__auto__ = e14328;
var statearr_14329_14345 = state_14305;
(statearr_14329_14345[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14305[(4)]))){
var statearr_14330_14346 = state_14305;
(statearr_14330_14346[(1)] = cljs.core.first((state_14305[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14347 = state_14305;
state_14305 = G__14347;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__ = function(state_14305){
switch(arguments.length){
case 0:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1.call(this,state_14305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____0;
fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto____1;
return fluree$db$query$range$resolve_match_flake_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14331 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14331[(6)] = c__2749__auto__);

return statearr_14331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.range.resolved_leaf_QMARK_ = (function fluree$db$query$range$resolved_leaf_QMARK_(node){
var and__4251__auto__ = fluree.db.index.leaf_QMARK_(node);
if(and__4251__auto__){
return fluree.db.index.resolved_QMARK_(node);
} else {
return and__4251__auto__;
}
});
/**
 * Returns true if the supplied `node` contains flakes between the `lower` and
 *   `upper` flakes, according to the `node`'s comparator.
 */
fluree.db.query.range.intersects_range_QMARK_ = (function fluree$db$query$range$intersects_range_QMARK_(node,range_set){
return cljs.core.not((function (){var or__4253__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node);
if(cljs.core.truth_(and__4251__auto__)){
return fluree.db.flake.lower_than_all_QMARK_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(node),range_set);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return ((cljs.core.not(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(node))) && (fluree.db.flake.higher_than_all_QMARK_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(node),range_set)));
}
})());
});
/**
 * Returns a transducer to filter flakes according to the boolean function values
 *   of the `:subject-fn`, `:predicate-fn`, and `:object-fn` keys from the supplied
 *   options map. All three functions are optional, and each supplied function will
 *   be applied to its corresponding flake component, and only flakes where each
 *   function evaluates to a truthy value will be included.
 */
fluree.db.query.range.query_filter = (function fluree$db$query$range$query_filter(p__14348){
var map__14349 = p__14348;
var map__14349__$1 = cljs.core.__destructure_map(map__14349);
var subject_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14349__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var predicate_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14349__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14349__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var filter_xfs = (function (){var G__14350 = cljs.core.PersistentVector.EMPTY;
var G__14350__$1 = (cljs.core.truth_(subject_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14350,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__14351 = fluree.db.flake.s(f);
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__14351) : subject_fn.call(null,G__14351));
}))):G__14350);
var G__14350__$2 = (cljs.core.truth_(predicate_fn)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14350__$1,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__14352 = fluree.db.flake.p(f);
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__14352) : predicate_fn.call(null,G__14352));
}))):G__14350__$1);
if(cljs.core.truth_(object_fn)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14350__$2,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (f){
var G__14353 = fluree.db.flake.o(f);
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__14353) : object_fn.call(null,G__14353));
})));
} else {
return G__14350__$2;
}
})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,filter_xfs);
});
/**
 * Returns a transducer to extract flakes from each leaf from a stream of index
 *   leaf nodes that satisfy the bounds specified in the supplied query options
 *   map. The result of the transformation will be a stream of collections of
 *   flakes from the leaf nodes in the input stream, with one flake collection for
 *   each input leaf.
 */
fluree.db.query.range.extract_query_flakes = (function fluree$db$query$range$extract_query_flakes(p__14354){
var map__14355 = p__14354;
var map__14355__$1 = cljs.core.__destructure_map(map__14355);
var opts = map__14355__$1;
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14355__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var start_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14355__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14355__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var end_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14355__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$5(flakes,start_test,start_flake,end_test,end_flake);
})),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,fluree.db.query.range.query_filter(opts),flakes);
})));
});
/**
 * Returns a channel that will contain a stream of chunked flake collections that
 *   contain the flakes between `start-flake` and `end-flake` and are within the
 *   transaction range starting at `from-t` and ending at `to-t`.
 */
fluree.db.query.range.resolve_flake_slices = (function fluree$db$query$range$resolve_flake_slices(p__14356,root,novelty,error_ch,p__14357){
var map__14358 = p__14356;
var map__14358__$1 = cljs.core.__destructure_map(map__14358);
var conn = map__14358__$1;
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14358__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var map__14359 = p__14357;
var map__14359__$1 = cljs.core.__destructure_map(map__14359);
var opts = map__14359__$1;
var from_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14359__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525));
var to_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14359__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14359__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14359__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var resolver = fluree.db.index.__GT_CachedTRangeResolver(conn,novelty,from_t,to_t,async_cache);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(root);
var range_set = fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_flake,end_flake], 0));
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_(node,range_set);
});
var query_xf = fluree.db.query.range.extract_query_flakes(opts);
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(resolver,root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
});
fluree.db.query.range.unauthorized_QMARK_ = (function fluree$db$query$range$unauthorized_QMARK_(f){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));
});
fluree.db.query.range.authorize_flake = (function fluree$db$query$range$authorize_flake(db,error_ch,flake){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14390){
var state_val_14391 = (state_14390[(1)]);
if((state_val_14391 === (7))){
var inst_14373 = (state_14390[(7)]);
var state_14390__$1 = state_14390;
var statearr_14392_14416 = state_14390__$1;
(statearr_14392_14416[(2)] = inst_14373);

(statearr_14392_14416[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14391 === (1))){
var state_14390__$1 = state_14390;
var statearr_14393_14417 = state_14390__$1;
(statearr_14393_14417[(2)] = null);

(statearr_14393_14417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14391 === (4))){
var inst_14360 = (state_14390[(2)]);
var inst_14361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14362 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_14363 = (new cljs.core.PersistentVector(null,3,(5),inst_14361,inst_14362,null));
var inst_14364 = cljs.core.select_keys(db,inst_14363);
var inst_14365 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_14360,"Error authorizing flake in ledger",inst_14364) : fluree.db.util.log.error.call(null,inst_14360,"Error authorizing flake in ledger",inst_14364));
var state_14390__$1 = (function (){var statearr_14395 = state_14390;
(statearr_14395[(8)] = inst_14365);

return statearr_14395;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14390__$1,(5),error_ch,inst_14360);
} else {
if((state_val_14391 === (13))){
var inst_14385 = (state_14390[(2)]);
var _ = (function (){var statearr_14396 = state_14390;
(statearr_14396[(4)] = cljs.core.rest((state_14390[(4)])));

return statearr_14396;
})();
var state_14390__$1 = state_14390;
var statearr_14397_14418 = state_14390__$1;
(statearr_14397_14418[(2)] = inst_14385);

(statearr_14397_14418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14391 === (6))){
var _ = (function (){var statearr_14398 = state_14390;
(statearr_14398[(4)] = cljs.core.rest((state_14390[(4)])));

return statearr_14398;
})();
var state_14390__$1 = state_14390;
var ex14394 = (state_14390__$1[(2)]);
var statearr_14399_14419 = state_14390__$1;
(statearr_14399_14419[(5)] = ex14394);


var statearr_14400_14420 = state_14390__$1;
(statearr_14400_14420[(1)] = (4));

(statearr_14400_14420[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14391 === (3))){
var inst_14388 = (state_14390[(2)]);
var state_14390__$1 = state_14390;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14390__$1,inst_14388);
} else {
if((state_val_14391 === (12))){
var state_14390__$1 = state_14390;
var statearr_14401_14421 = state_14390__$1;
(statearr_14401_14421[(2)] = new cljs.core.Keyword("fluree.db.query.range","unauthorized","fluree.db.query.range/unauthorized",527238548));

(statearr_14401_14421[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14391 === (2))){
var inst_14373 = (state_14390[(7)]);
var _ = (function (){var statearr_14402 = state_14390;
(statearr_14402[(4)] = cljs.core.cons((6),(state_14390[(4)])));

return statearr_14402;
})();
var inst_14373__$1 = fluree.db.util.schema.is_schema_flake_QMARK_(flake);
var state_14390__$1 = (function (){var statearr_14403 = state_14390;
(statearr_14403[(7)] = inst_14373__$1);

return statearr_14403;
})();
if(inst_14373__$1){
var statearr_14404_14422 = state_14390__$1;
(statearr_14404_14422[(1)] = (7));

} else {
var statearr_14405_14423 = state_14390__$1;
(statearr_14405_14423[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14391 === (11))){
var state_14390__$1 = state_14390;
var statearr_14406_14424 = state_14390__$1;
(statearr_14406_14424[(2)] = flake);

(statearr_14406_14424[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14391 === (9))){
var inst_14381 = (state_14390[(2)]);
var state_14390__$1 = state_14390;
if(cljs.core.truth_(inst_14381)){
var statearr_14407_14425 = state_14390__$1;
(statearr_14407_14425[(1)] = (11));

} else {
var statearr_14408_14426 = state_14390__$1;
(statearr_14408_14426[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14391 === (5))){
var inst_14367 = (state_14390[(2)]);
var state_14390__$1 = state_14390;
var statearr_14409_14427 = state_14390__$1;
(statearr_14409_14427[(2)] = inst_14367);

(statearr_14409_14427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14391 === (10))){
var inst_14378 = (state_14390[(2)]);
var inst_14379 = fluree.db.util.async.throw_err(inst_14378);
var state_14390__$1 = state_14390;
var statearr_14410_14428 = state_14390__$1;
(statearr_14410_14428[(2)] = inst_14379);

(statearr_14410_14428[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14391 === (8))){
var inst_14376 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,flake);
var state_14390__$1 = state_14390;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14390__$1,(10),inst_14376);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0 = (function (){
var statearr_14411 = [null,null,null,null,null,null,null,null,null];
(statearr_14411[(0)] = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__);

(statearr_14411[(1)] = (1));

return statearr_14411;
});
var fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1 = (function (state_14390){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14390);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14412){var ex__2730__auto__ = e14412;
var statearr_14413_14429 = state_14390;
(statearr_14413_14429[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14390[(4)]))){
var statearr_14414_14430 = state_14390;
(statearr_14414_14430[(1)] = cljs.core.first((state_14390[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14431 = state_14390;
state_14390 = G__14431;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__ = function(state_14390){
switch(arguments.length){
case 0:
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1.call(this,state_14390);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____0;
fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$authorize_flake_$_state_machine__2727__auto____1;
return fluree$db$query$range$authorize_flake_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14415 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14415[(6)] = c__2749__auto__);

return statearr_14415;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Authorize each flake in the supplied `flakes` collection asynchronously,
 *   returning a collection containing only allowed flakes according to the
 *   permissions of the supplied `db`.
 */
fluree.db.query.range.authorize_flakes = (function fluree$db$query$range$authorize_flakes(db,error_ch,flakes){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function() { 
var G__14432__delegate = function (fs){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$1(fluree.db.query.range.unauthorized_QMARK_),fs);
};
var G__14432 = function (var_args){
var fs = null;
if (arguments.length > 0) {
var G__14433__i = 0, G__14433__a = new Array(arguments.length -  0);
while (G__14433__i < G__14433__a.length) {G__14433__a[G__14433__i] = arguments[G__14433__i + 0]; ++G__14433__i;}
  fs = new cljs.core.IndexedSeq(G__14433__a,0,null);
} 
return G__14432__delegate.call(this,fs);};
G__14432.cljs$lang$maxFixedArity = 0;
G__14432.cljs$lang$applyTo = (function (arglist__14434){
var fs = cljs.core.seq(arglist__14434);
return G__14432__delegate(fs);
});
G__14432.cljs$core$IFn$_invoke$arity$variadic = G__14432__delegate;
return G__14432;
})()
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.range.authorize_flake,db,error_ch),flakes));
});
/**
 * Returns a channel that will eventually return a stream of flake slices
 *   containing only the schema flakes and the flakes validated by
 *   fluree.db.permissions-validate/allow-flake? function for the database `db`
 *   from the `flake-slices` channel
 */
fluree.db.query.range.filter_authorized = (function fluree$db$query$range$filter_authorized(p__14435,start,end,error_ch,flake_slices){
var map__14436 = p__14435;
var map__14436__$1 = cljs.core.__destructure_map(map__14436);
var db = map__14436__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14436__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
return flake_slices;
});
/**
 * Returns a transducer to filter a stream of flakes to only contain flakes from
 *   at most `limit` subjects, skipping the flakes from the first `offset`
 *   subjects.
 */
fluree.db.query.range.filter_subject_page = (function fluree$db$query$range$filter_subject_page(limit,offset){
var subject_page_xfs = (function (){var G__14437 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.flake.s)], null);
var G__14437__$1 = (cljs.core.truth_(offset)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14437,cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset)):G__14437);
var G__14437__$2 = (cljs.core.truth_(limit)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14437__$1,cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit)):G__14437__$1);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14437__$2,cljs.core.cat);

})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,subject_page_xfs);
});
/**
 * Collects flakes from the stream of flake collections in the `flake-slices`
 *   channel into a sorted vector according to the `limit`, `offset`, and
 *   `flake-limit` parameters. The result will have flakes from at most `limit`
 *   subjects, not including flakes from the first `offset` subjects, and having at
 *   most `flake-limit` flakes in total.
 */
fluree.db.query.range.into_page = (function fluree$db$query$range$into_page(limit,offset,flake_limit,flake_slices){
var page_xfs = (function (){var G__14438 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cat], null);
var G__14438__$1 = (cljs.core.truth_((function (){var or__4253__auto__ = limit;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return offset;
}
})())?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14438,fluree.db.query.range.filter_subject_page(limit,offset)):G__14438);
if(cljs.core.truth_(flake_limit)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__14438__$1,cljs.core.take.cljs$core$IFn$_invoke$arity$1(flake_limit));
} else {
return G__14438__$1;
}
})();
var page_xf = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,page_xfs);
return cljs.core.async.transduce(page_xf,cljs.core.conj,cljs.core.PersistentVector.EMPTY,flake_slices);
});
/**
 * Return a channel that will eventually hold a sorted vector of the range of
 *   flakes from `db` that meet the criteria specified in the `opts` map.
 */
fluree.db.query.range.index_range_STAR_ = (function fluree$db$query$range$index_range_STAR_(p__14439,error_ch,p__14440){
var map__14441 = p__14439;
var map__14441__$1 = cljs.core.__destructure_map(map__14441);
var db = map__14441__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14441__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__14442 = p__14440;
var map__14442__$1 = cljs.core.__destructure_map(map__14442);
var opts = map__14442__$1;
var idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14442__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14442__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14442__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14442__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14442__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var flake_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14442__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961));
var idx_root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var idx_cmp = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var novelty = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx], null));
return fluree.db.query.range.into_page(limit,offset,flake_limit,fluree.db.query.range.filter_authorized(db,start_flake,end_flake,error_ch,fluree.db.query.range.resolve_flake_slices(conn,idx_root,novelty,error_ch,opts)));
});
/**
 * Finds the full index or time range interval including the maximum and minimum
 *   tests when only one test is provided
 */
fluree.db.query.range.expand_range_interval = (function fluree$db$query$range$expand_range_interval(idx,test,match){
var pred__14443 = cljs.core.identical_QMARK_;
var expr__14444 = test;
if(cljs.core.truth_((pred__14443.cljs$core$IFn$_invoke$arity$2 ? pred__14443.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__14444) : pred__14443.call(null,cljs.core._EQ_,expr__14444)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14443.cljs$core$IFn$_invoke$arity$2 ? pred__14443.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__14444) : pred__14443.call(null,cljs.core._LT_,expr__14444)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__14443.cljs$core$IFn$_invoke$arity$2 ? pred__14443.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__14444) : pred__14443.call(null,cljs.core._LT__EQ_,expr__14444)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14443.cljs$core$IFn$_invoke$arity$2 ? pred__14443.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__14444) : pred__14443.call(null,cljs.core._GT_,expr__14444)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__14443.cljs$core$IFn$_invoke$arity$2 ? pred__14443.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__14444) : pred__14443.call(null,cljs.core._GT__EQ_,expr__14444)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14444)].join('')));
}
}
}
}
}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we
 *   don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will return in
 *   reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number
 *          is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used
 *         when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__14447 = arguments.length;
switch (G__14447) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14448 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14448,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14448,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14448,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14448,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (p__14451,idx,start_test,start_match,end_test,end_match,opts){
var map__14452 = p__14451;
var map__14452__$1 = cljs.core.__destructure_map(map__14452);
var db = map__14452__$1;
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14452__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__14453 = opts;
var map__14453__$1 = cljs.core.__destructure_map(map__14453);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14453__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var from_t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__14453__$1,new cljs.core.Keyword(null,"from-t","from-t",1730913525),t);
var to_t = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__14453__$1,new cljs.core.Keyword(null,"to-t","to-t",569467359),t);
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var start_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var end_parts = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14515){
var state_val_14516 = (state_14515[(1)]);
if((state_val_14516 === (7))){
var inst_14472 = (state_14515[(7)]);
var inst_14463 = (state_14515[(8)]);
var inst_14468 = (state_14515[(9)]);
var inst_14466 = (state_14515[(2)]);
var inst_14467 = fluree.db.util.async.throw_err(inst_14466);
var inst_14468__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_14469 = [new cljs.core.Keyword(null,"idx","idx",1053688473),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"start-test","start-test",-952983565),new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),new cljs.core.Keyword(null,"end-test","end-test",481973727),new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961)];
var inst_14470 = [idx,from_t,to_t,start_test,inst_14463,end_test,inst_14467,limit];
var inst_14471 = cljs.core.PersistentHashMap.fromArrays(inst_14469,inst_14470);
var inst_14472__$1 = fluree.db.query.range.index_range_STAR_(db,inst_14468__$1,inst_14471);
var inst_14480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14481 = [inst_14468__$1,inst_14472__$1];
var inst_14482 = (new cljs.core.PersistentVector(null,2,(5),inst_14480,inst_14481,null));
var state_14515__$1 = (function (){var statearr_14517 = state_14515;
(statearr_14517[(7)] = inst_14472__$1);

(statearr_14517[(9)] = inst_14468__$1);

return statearr_14517;
})();
return cljs.core.async.ioc_alts_BANG_(state_14515__$1,(8),inst_14482);
} else {
if((state_val_14516 === (1))){
var state_14515__$1 = state_14515;
var statearr_14518_14547 = state_14515__$1;
(statearr_14518_14547[(2)] = null);

(statearr_14518_14547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14516 === (4))){
var inst_14454 = (state_14515[(2)]);
var state_14515__$1 = state_14515;
var statearr_14519_14548 = state_14515__$1;
(statearr_14519_14548[(2)] = inst_14454);

(statearr_14519_14548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14516 === (15))){
var inst_14485 = (state_14515[(10)]);
var state_14515__$1 = state_14515;
var statearr_14520_14549 = state_14515__$1;
(statearr_14520_14549[(2)] = inst_14485);

(statearr_14520_14549[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14516 === (13))){
var inst_14486 = (state_14515[(11)]);
var inst_14502 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14486,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_14515__$1 = state_14515;
if(inst_14502){
var statearr_14521_14550 = state_14515__$1;
(statearr_14521_14550[(1)] = (15));

} else {
var statearr_14522_14551 = state_14515__$1;
(statearr_14522_14551[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14516 === (6))){
var inst_14462 = (state_14515[(2)]);
var inst_14463 = fluree.db.util.async.throw_err(inst_14462);
var inst_14464 = fluree.db.query.range.resolve_match_flake(db,end_test,end_parts);
var state_14515__$1 = (function (){var statearr_14523 = state_14515;
(statearr_14523[(8)] = inst_14463);

return statearr_14523;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14515__$1,(7),inst_14464);
} else {
if((state_val_14516 === (17))){
var inst_14506 = (state_14515[(2)]);
var state_14515__$1 = state_14515;
var statearr_14524_14552 = state_14515__$1;
(statearr_14524_14552[(2)] = inst_14506);

(statearr_14524_14552[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14516 === (3))){
var inst_14513 = (state_14515[(2)]);
var state_14515__$1 = state_14515;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14515__$1,inst_14513);
} else {
if((state_val_14516 === (12))){
var inst_14484 = (state_14515[(12)]);
var inst_14500 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14484,(0),null);
var state_14515__$1 = state_14515;
var statearr_14525_14553 = state_14515__$1;
(statearr_14525_14553[(2)] = inst_14500);

(statearr_14525_14553[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14516 === (2))){
var _ = (function (){var statearr_14526 = state_14515;
(statearr_14526[(4)] = cljs.core.cons((5),(state_14515[(4)])));

return statearr_14526;
})();
var inst_14460 = fluree.db.query.range.resolve_match_flake(db,start_test,start_parts);
var state_14515__$1 = state_14515;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14515__$1,(6),inst_14460);
} else {
if((state_val_14516 === (11))){
var inst_14510 = (state_14515[(2)]);
var _ = (function (){var statearr_14528 = state_14515;
(statearr_14528[(4)] = cljs.core.rest((state_14515[(4)])));

return statearr_14528;
})();
var state_14515__$1 = state_14515;
var statearr_14529_14554 = state_14515__$1;
(statearr_14529_14554[(2)] = inst_14510);

(statearr_14529_14554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14516 === (9))){
var inst_14484 = (state_14515[(12)]);
var inst_14492 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14484,(0),null);
var inst_14493 = (function(){throw inst_14492})();
var state_14515__$1 = state_14515;
var statearr_14530_14555 = state_14515__$1;
(statearr_14530_14555[(2)] = inst_14493);

(statearr_14530_14555[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14516 === (5))){
var _ = (function (){var statearr_14531 = state_14515;
(statearr_14531[(4)] = cljs.core.rest((state_14515[(4)])));

return statearr_14531;
})();
var state_14515__$1 = state_14515;
var ex14527 = (state_14515__$1[(2)]);
var statearr_14532_14556 = state_14515__$1;
(statearr_14532_14556[(5)] = ex14527);


if((ex14527 instanceof Error)){
var statearr_14533_14557 = state_14515__$1;
(statearr_14533_14557[(1)] = (4));

(statearr_14533_14557[(5)] = null);

} else {
throw ex14527;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14516 === (14))){
var inst_14508 = (state_14515[(2)]);
var state_14515__$1 = state_14515;
var statearr_14534_14558 = state_14515__$1;
(statearr_14534_14558[(2)] = inst_14508);

(statearr_14534_14558[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14516 === (16))){
var state_14515__$1 = state_14515;
var statearr_14535_14559 = state_14515__$1;
(statearr_14535_14559[(2)] = null);

(statearr_14535_14559[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14516 === (10))){
var inst_14472 = (state_14515[(7)]);
var inst_14486 = (state_14515[(11)]);
var inst_14495 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14486,inst_14472);
var state_14515__$1 = state_14515;
if(inst_14495){
var statearr_14536_14560 = state_14515__$1;
(statearr_14536_14560[(1)] = (12));

} else {
var statearr_14537_14561 = state_14515__$1;
(statearr_14537_14561[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14516 === (8))){
var inst_14484 = (state_14515[(12)]);
var inst_14486 = (state_14515[(11)]);
var inst_14468 = (state_14515[(9)]);
var inst_14484__$1 = (state_14515[(2)]);
var inst_14485 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14484__$1,(0),null);
var inst_14486__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14484__$1,(1),null);
var inst_14487 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14486__$1,inst_14468);
var state_14515__$1 = (function (){var statearr_14538 = state_14515;
(statearr_14538[(12)] = inst_14484__$1);

(statearr_14538[(11)] = inst_14486__$1);

(statearr_14538[(10)] = inst_14485);

return statearr_14538;
})();
if(inst_14487){
var statearr_14539_14562 = state_14515__$1;
(statearr_14539_14562[(1)] = (9));

} else {
var statearr_14540_14563 = state_14515__$1;
(statearr_14540_14563[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_14541 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14541[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_14541[(1)] = (1));

return statearr_14541;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_14515){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14515);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14542){var ex__2730__auto__ = e14542;
var statearr_14543_14564 = state_14515;
(statearr_14543_14564[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14515[(4)]))){
var statearr_14544_14565 = state_14515;
(statearr_14544_14565[(1)] = cljs.core.first((state_14515[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14566 = state_14515;
state_14515 = G__14566;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_14515){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_14515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14545 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14545[(6)] = c__2749__auto__);

return statearr_14545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__14568 = arguments.length;
switch (G__14568) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14569 = fluree.db.query.range.expand_range_interval(idx,test,match);
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14569,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14569,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14569,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14569,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (p__14572,idx,start_test,start_match,end_test,end_match,p__14573){
var map__14574 = p__14572;
var map__14574__$1 = cljs.core.__destructure_map(map__14574);
var db = map__14574__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14574__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14574__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__14575 = p__14573;
var map__14575__$1 = cljs.core.__destructure_map(map__14575);
var opts = map__14575__$1;
var object_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14575__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var idx_compare = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"comparators","comparators",-1325611955),idx], null));
var vec__14576 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var s1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14576,(0),null);
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14576,(1),null);
var o1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14576,(2),null);
var t1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14576,(3),null);
var op1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14576,(4),null);
var m1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14576,(5),null);
var vec__14579 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var s2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14579,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14579,(1),null);
var o2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14579,(2),null);
var t2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14579,(3),null);
var op2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14579,(4),null);
var m2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14579,(5),null);
var vec__14582 = (function (){var temp__5806__auto__ = ((cljs.core.boolean_QMARK_(o1))?o1:((cljs.core.boolean_QMARK_(o2))?o2:null
));
if((temp__5806__auto__ == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [o1,o2], null),object_fn], null);
} else {
var bool = temp__5806__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null),(function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
})], null);
}
})();
var vec__14585 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14582,(0),null);
var o1__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14585,(0),null);
var o2__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14585,(1),null);
var object_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14582,(1),null);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14653){
var state_val_14654 = (state_14653[(1)]);
if((state_val_14654 === (7))){
var inst_14610 = (state_14653[(7)]);
var inst_14608 = (state_14653[(8)]);
var inst_14600 = (state_14653[(9)]);
var inst_14606 = (state_14653[(2)]);
var inst_14607 = fluree.db.util.async.throw_err(inst_14606);
var inst_14608__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_14609 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"idx","idx",1053688473),idx,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"from-t","from-t",1730913525),t,new cljs.core.Keyword(null,"to-t","to-t",569467359),t,new cljs.core.Keyword(null,"start-test","start-test",-952983565),start_test,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),inst_14600,new cljs.core.Keyword(null,"end-test","end-test",481973727),end_test,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),inst_14607,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),object_fn__$1], 0));
var inst_14610__$1 = fluree.db.query.range.index_range_STAR_(db,inst_14608__$1,inst_14609);
var inst_14618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14619 = [inst_14608__$1,inst_14610__$1];
var inst_14620 = (new cljs.core.PersistentVector(null,2,(5),inst_14618,inst_14619,null));
var state_14653__$1 = (function (){var statearr_14655 = state_14653;
(statearr_14655[(7)] = inst_14610__$1);

(statearr_14655[(8)] = inst_14608__$1);

return statearr_14655;
})();
return cljs.core.async.ioc_alts_BANG_(state_14653__$1,(8),inst_14620);
} else {
if((state_val_14654 === (1))){
var state_14653__$1 = state_14653;
var statearr_14656_14685 = state_14653__$1;
(statearr_14656_14685[(2)] = null);

(statearr_14656_14685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14654 === (4))){
var inst_14588 = (state_14653[(2)]);
var state_14653__$1 = state_14653;
var statearr_14657_14686 = state_14653__$1;
(statearr_14657_14686[(2)] = inst_14588);

(statearr_14657_14686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14654 === (15))){
var inst_14623 = (state_14653[(10)]);
var state_14653__$1 = state_14653;
var statearr_14658_14687 = state_14653__$1;
(statearr_14658_14687[(2)] = inst_14623);

(statearr_14658_14687[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14654 === (13))){
var inst_14624 = (state_14653[(11)]);
var inst_14640 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14624,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_14653__$1 = state_14653;
if(inst_14640){
var statearr_14659_14688 = state_14653__$1;
(statearr_14659_14688[(1)] = (15));

} else {
var statearr_14660_14689 = state_14653__$1;
(statearr_14660_14689[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14654 === (6))){
var inst_14599 = (state_14653[(2)]);
var inst_14600 = fluree.db.util.async.throw_err(inst_14599);
var inst_14601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14602 = [s2,p2,o2__$1,t2,op2,m2];
var inst_14603 = (new cljs.core.PersistentVector(null,6,(5),inst_14601,inst_14602,null));
var inst_14604 = fluree.db.query.range.resolve_match_flake(db,end_test,inst_14603);
var state_14653__$1 = (function (){var statearr_14661 = state_14653;
(statearr_14661[(9)] = inst_14600);

return statearr_14661;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14653__$1,(7),inst_14604);
} else {
if((state_val_14654 === (17))){
var inst_14644 = (state_14653[(2)]);
var state_14653__$1 = state_14653;
var statearr_14662_14690 = state_14653__$1;
(statearr_14662_14690[(2)] = inst_14644);

(statearr_14662_14690[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14654 === (3))){
var inst_14651 = (state_14653[(2)]);
var state_14653__$1 = state_14653;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14653__$1,inst_14651);
} else {
if((state_val_14654 === (12))){
var inst_14622 = (state_14653[(12)]);
var inst_14638 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14622,(0),null);
var state_14653__$1 = state_14653;
var statearr_14663_14691 = state_14653__$1;
(statearr_14663_14691[(2)] = inst_14638);

(statearr_14663_14691[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14654 === (2))){
var _ = (function (){var statearr_14664 = state_14653;
(statearr_14664[(4)] = cljs.core.cons((5),(state_14653[(4)])));

return statearr_14664;
})();
var inst_14594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14595 = [s1,p1,o1__$1,t1,op1,m1];
var inst_14596 = (new cljs.core.PersistentVector(null,6,(5),inst_14594,inst_14595,null));
var inst_14597 = fluree.db.query.range.resolve_match_flake(db,start_test,inst_14596);
var state_14653__$1 = state_14653;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14653__$1,(6),inst_14597);
} else {
if((state_val_14654 === (11))){
var inst_14648 = (state_14653[(2)]);
var _ = (function (){var statearr_14666 = state_14653;
(statearr_14666[(4)] = cljs.core.rest((state_14653[(4)])));

return statearr_14666;
})();
var state_14653__$1 = state_14653;
var statearr_14667_14692 = state_14653__$1;
(statearr_14667_14692[(2)] = inst_14648);

(statearr_14667_14692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14654 === (9))){
var inst_14622 = (state_14653[(12)]);
var inst_14630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14622,(0),null);
var inst_14631 = (function(){throw inst_14630})();
var state_14653__$1 = state_14653;
var statearr_14668_14693 = state_14653__$1;
(statearr_14668_14693[(2)] = inst_14631);

(statearr_14668_14693[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14654 === (5))){
var _ = (function (){var statearr_14669 = state_14653;
(statearr_14669[(4)] = cljs.core.rest((state_14653[(4)])));

return statearr_14669;
})();
var state_14653__$1 = state_14653;
var ex14665 = (state_14653__$1[(2)]);
var statearr_14670_14694 = state_14653__$1;
(statearr_14670_14694[(5)] = ex14665);


if((ex14665 instanceof Error)){
var statearr_14671_14695 = state_14653__$1;
(statearr_14671_14695[(1)] = (4));

(statearr_14671_14695[(5)] = null);

} else {
throw ex14665;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14654 === (14))){
var inst_14646 = (state_14653[(2)]);
var state_14653__$1 = state_14653;
var statearr_14672_14696 = state_14653__$1;
(statearr_14672_14696[(2)] = inst_14646);

(statearr_14672_14696[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14654 === (16))){
var state_14653__$1 = state_14653;
var statearr_14673_14697 = state_14653__$1;
(statearr_14673_14697[(2)] = null);

(statearr_14673_14697[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14654 === (10))){
var inst_14624 = (state_14653[(11)]);
var inst_14610 = (state_14653[(7)]);
var inst_14633 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14624,inst_14610);
var state_14653__$1 = state_14653;
if(inst_14633){
var statearr_14674_14698 = state_14653__$1;
(statearr_14674_14698[(1)] = (12));

} else {
var statearr_14675_14699 = state_14653__$1;
(statearr_14675_14699[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14654 === (8))){
var inst_14624 = (state_14653[(11)]);
var inst_14622 = (state_14653[(12)]);
var inst_14608 = (state_14653[(8)]);
var inst_14622__$1 = (state_14653[(2)]);
var inst_14623 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14622__$1,(0),null);
var inst_14624__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14622__$1,(1),null);
var inst_14625 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14624__$1,inst_14608);
var state_14653__$1 = (function (){var statearr_14676 = state_14653;
(statearr_14676[(11)] = inst_14624__$1);

(statearr_14676[(12)] = inst_14622__$1);

(statearr_14676[(10)] = inst_14623);

return statearr_14676;
})();
if(inst_14625){
var statearr_14677_14700 = state_14653__$1;
(statearr_14677_14700[(1)] = (9));

} else {
var statearr_14678_14701 = state_14653__$1;
(statearr_14678_14701[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_14679 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14679[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_14679[(1)] = (1));

return statearr_14679;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_14653){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14653);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14680){var ex__2730__auto__ = e14680;
var statearr_14681_14702 = state_14653;
(statearr_14681_14702[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14653[(4)]))){
var statearr_14682_14703 = state_14653;
(statearr_14682_14703[(1)] = cljs.core.first((state_14653[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14704 = state_14653;
state_14653 = G__14704;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_14653){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_14653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14683 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14683[(6)] = c__2749__auto__);

return statearr_14683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= fluree.db.flake.o(f))) && ((fluree.db.flake.o(f) <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14760){
var state_val_14761 = (state_14760[(1)]);
if((state_val_14761 === (7))){
var inst_14724 = (state_14760[(7)]);
var inst_14734 = (state_14760[(8)]);
var inst_14732 = fluree.db.flake.Flake__GT_parts(inst_14724);
var inst_14733 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14732,(0),null);
var inst_14734__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14732,(1),null);
var inst_14735 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14732,(2),null);
var inst_14736 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14732,(3),null);
var inst_14737 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14732,(4),null);
var inst_14738 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14732,(5),null);
var inst_14739 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_14735,inst_14734__$1);
var state_14760__$1 = (function (){var statearr_14762 = state_14760;
(statearr_14762[(9)] = inst_14736);

(statearr_14762[(10)] = inst_14733);

(statearr_14762[(11)] = inst_14738);

(statearr_14762[(8)] = inst_14734__$1);

(statearr_14762[(12)] = inst_14737);

return statearr_14762;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14760__$1,(10),inst_14739);
} else {
if((state_val_14761 === (1))){
var inst_14712 = flakes;
var inst_14713 = cljs.core.seq(inst_14712);
var inst_14714 = cljs.core.first(inst_14713);
var inst_14715 = cljs.core.next(inst_14713);
var inst_14716 = cljs.core.PersistentVector.EMPTY;
var inst_14717 = inst_14712;
var inst_14718 = inst_14716;
var state_14760__$1 = (function (){var statearr_14763 = state_14760;
(statearr_14763[(13)] = inst_14715);

(statearr_14763[(14)] = inst_14717);

(statearr_14763[(15)] = inst_14718);

(statearr_14763[(16)] = inst_14714);

return statearr_14763;
})();
var statearr_14764_14782 = state_14760__$1;
(statearr_14764_14782[(2)] = null);

(statearr_14764_14782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14761 === (4))){
var inst_14724 = (state_14760[(7)]);
var inst_14727 = fluree.db.query.range.is_tag_flake_QMARK_(inst_14724);
var state_14760__$1 = state_14760;
if(inst_14727){
var statearr_14765_14783 = state_14760__$1;
(statearr_14765_14783[(1)] = (7));

} else {
var statearr_14766_14784 = state_14760__$1;
(statearr_14766_14784[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14761 === (6))){
var inst_14756 = (state_14760[(2)]);
var state_14760__$1 = state_14760;
var statearr_14767_14785 = state_14760__$1;
(statearr_14767_14785[(2)] = inst_14756);

(statearr_14767_14785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14761 === (3))){
var inst_14758 = (state_14760[(2)]);
var state_14760__$1 = state_14760;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14760__$1,inst_14758);
} else {
if((state_val_14761 === (2))){
var inst_14724 = (state_14760[(7)]);
var inst_14717 = (state_14760[(14)]);
var inst_14723 = cljs.core.seq(inst_14717);
var inst_14724__$1 = cljs.core.first(inst_14723);
var inst_14725 = cljs.core.next(inst_14723);
var state_14760__$1 = (function (){var statearr_14768 = state_14760;
(statearr_14768[(17)] = inst_14725);

(statearr_14768[(7)] = inst_14724__$1);

return statearr_14768;
})();
if(cljs.core.truth_(inst_14724__$1)){
var statearr_14769_14786 = state_14760__$1;
(statearr_14769_14786[(1)] = (4));

} else {
var statearr_14770_14787 = state_14760__$1;
(statearr_14770_14787[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14761 === (9))){
var inst_14753 = (state_14760[(2)]);
var state_14760__$1 = state_14760;
var statearr_14771_14788 = state_14760__$1;
(statearr_14771_14788[(2)] = inst_14753);

(statearr_14771_14788[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14761 === (5))){
var inst_14718 = (state_14760[(15)]);
var state_14760__$1 = state_14760;
var statearr_14772_14789 = state_14760__$1;
(statearr_14772_14789[(2)] = inst_14718);

(statearr_14772_14789[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14761 === (10))){
var inst_14725 = (state_14760[(17)]);
var inst_14736 = (state_14760[(9)]);
var inst_14733 = (state_14760[(10)]);
var inst_14718 = (state_14760[(15)]);
var inst_14738 = (state_14760[(11)]);
var inst_14734 = (state_14760[(8)]);
var inst_14737 = (state_14760[(12)]);
var inst_14741 = (state_14760[(2)]);
var inst_14742 = fluree.db.util.async.throw_err(inst_14741);
var inst_14743 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14744 = [inst_14733,inst_14734,inst_14742,inst_14736,inst_14737,inst_14738];
var inst_14745 = (new cljs.core.PersistentVector(null,6,(5),inst_14743,inst_14744,null));
var inst_14746 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_14745);
var inst_14747 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_14718,inst_14746);
var inst_14717 = inst_14725;
var inst_14718__$1 = inst_14747;
var state_14760__$1 = (function (){var statearr_14773 = state_14760;
(statearr_14773[(14)] = inst_14717);

(statearr_14773[(15)] = inst_14718__$1);

return statearr_14773;
})();
var statearr_14774_14790 = state_14760__$1;
(statearr_14774_14790[(2)] = null);

(statearr_14774_14790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14761 === (8))){
var inst_14725 = (state_14760[(17)]);
var inst_14724 = (state_14760[(7)]);
var inst_14718 = (state_14760[(15)]);
var inst_14750 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_14718,inst_14724);
var inst_14717 = inst_14725;
var inst_14718__$1 = inst_14750;
var state_14760__$1 = (function (){var statearr_14775 = state_14760;
(statearr_14775[(14)] = inst_14717);

(statearr_14775[(15)] = inst_14718__$1);

return statearr_14775;
})();
var statearr_14776_14791 = state_14760__$1;
(statearr_14776_14791[(2)] = null);

(statearr_14776_14791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0 = (function (){
var statearr_14777 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14777[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__);

(statearr_14777[(1)] = (1));

return statearr_14777;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1 = (function (state_14760){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14760);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14778){var ex__2730__auto__ = e14778;
var statearr_14779_14792 = state_14760;
(statearr_14779_14792[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14760[(4)]))){
var statearr_14780_14793 = state_14760;
(statearr_14780_14793[(1)] = cljs.core.first((state_14760[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14794 = state_14760;
state_14760 = G__14794;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__ = function(state_14760){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1.call(this,state_14760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14781 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14781[(6)] = c__2749__auto__);

return statearr_14781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__14796 = arguments.length;
switch (G__14796) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14978){
var state_val_14979 = (state_14978[(1)]);
if((state_val_14979 === (65))){
var inst_14847 = (state_14978[(7)]);
var state_14978__$1 = state_14978;
if(cljs.core.truth_(inst_14847)){
var statearr_14980_15084 = state_14978__$1;
(statearr_14980_15084[(1)] = (68));

} else {
var statearr_14981_15085 = state_14978__$1;
(statearr_14981_15085[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (70))){
var inst_14957 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
var statearr_14982_15086 = state_14978__$1;
(statearr_14982_15086[(2)] = inst_14957);

(statearr_14982_15086[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (62))){
var inst_14923 = (state_14978[(2)]);
var inst_14924 = fluree.db.util.async.throw_err(inst_14923);
var inst_14925 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_14924);
var state_14978__$1 = state_14978;
var statearr_14983_15087 = state_14978__$1;
(statearr_14983_15087[(2)] = inst_14925);

(statearr_14983_15087[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (74))){
var inst_14973 = (state_14978[(2)]);
var _ = (function (){var statearr_14984 = state_14978;
(statearr_14984[(4)] = cljs.core.rest((state_14978[(4)])));

return statearr_14984;
})();
var state_14978__$1 = state_14978;
var statearr_14985_15088 = state_14978__$1;
(statearr_14985_15088[(2)] = inst_14973);

(statearr_14985_15088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (7))){
var state_14978__$1 = state_14978;
var statearr_14986_15089 = state_14978__$1;
(statearr_14986_15089[(2)] = false);

(statearr_14986_15089[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (59))){
var inst_14847 = (state_14978[(7)]);
var inst_14917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14918 = [inst_14847];
var inst_14919 = (new cljs.core.PersistentVector(null,1,(5),inst_14917,inst_14918,null));
var inst_14920 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_14921 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14919,inst_14920);
var state_14978__$1 = state_14978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14978__$1,(62),inst_14921);
} else {
if((state_val_14979 === (20))){
var state_14978__$1 = state_14978;
var statearr_14987_15090 = state_14978__$1;
(statearr_14987_15090[(2)] = null);

(statearr_14987_15090[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (72))){
var inst_14965 = (state_14978[(8)]);
var inst_14967 = fluree.db.query.range.coerce_tag_flakes(db,inst_14965);
var state_14978__$1 = state_14978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14978__$1,(75),inst_14967);
} else {
if((state_val_14979 === (58))){
var inst_14915 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
if(cljs.core.truth_(inst_14915)){
var statearr_14988_15091 = state_14978__$1;
(statearr_14988_15091[(1)] = (59));

} else {
var statearr_14989_15092 = state_14978__$1;
(statearr_14989_15092[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (60))){
var inst_14808 = (state_14978[(9)]);
var inst_14810 = (state_14978[(10)]);
var inst_14807 = (state_14978[(11)]);
var inst_14909 = (state_14978[(12)]);
var inst_14927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14928 = [inst_14808,inst_14807,null,inst_14810];
var inst_14929 = (new cljs.core.PersistentVector(null,4,(5),inst_14927,inst_14928,null));
var inst_14930 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_14909);
var inst_14931 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14929,inst_14930);
var state_14978__$1 = state_14978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14978__$1,(63),inst_14931);
} else {
if((state_val_14979 === (27))){
var inst_14847 = (state_14978[(7)]);
var inst_14808 = (state_14978[(9)]);
var inst_14810 = (state_14978[(10)]);
var inst_14807 = (state_14978[(11)]);
var inst_14859 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14860 = [inst_14807,inst_14808,inst_14847,inst_14810];
var inst_14861 = (new cljs.core.PersistentVector(null,4,(5),inst_14859,inst_14860,null));
var inst_14862 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14861,opts);
var state_14978__$1 = state_14978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14978__$1,(30),inst_14862);
} else {
if((state_val_14979 === (1))){
var state_14978__$1 = state_14978;
var statearr_14990_15093 = state_14978__$1;
(statearr_14990_15093[(2)] = null);

(statearr_14990_15093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (69))){
var state_14978__$1 = state_14978;
var statearr_14991_15094 = state_14978__$1;
(statearr_14991_15094[(2)] = null);

(statearr_14991_15094[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (24))){
var inst_14808 = (state_14978[(9)]);
var state_14978__$1 = state_14978;
if(cljs.core.truth_(inst_14808)){
var statearr_14992_15095 = state_14978__$1;
(statearr_14992_15095[(1)] = (31));

} else {
var statearr_14993_15096 = state_14978__$1;
(statearr_14993_15096[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (55))){
var inst_14808 = (state_14978[(9)]);
var inst_14910 = (state_14978[(13)]);
var inst_14909 = (state_14978[(2)]);
var inst_14910__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_14808);
var state_14978__$1 = (function (){var statearr_14994 = state_14978;
(statearr_14994[(13)] = inst_14910__$1);

(statearr_14994[(12)] = inst_14909);

return statearr_14994;
})();
if(inst_14910__$1){
var statearr_14995_15097 = state_14978__$1;
(statearr_14995_15097[(1)] = (56));

} else {
var statearr_14996_15098 = state_14978__$1;
(statearr_14996_15098[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (39))){
var inst_14877 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
var statearr_14997_15099 = state_14978__$1;
(statearr_14997_15099[(2)] = inst_14877);

(statearr_14997_15099[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (46))){
var inst_14901 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
if(cljs.core.truth_(inst_14901)){
var statearr_14998_15100 = state_14978__$1;
(statearr_14998_15100[(1)] = (50));

} else {
var statearr_14999_15101 = state_14978__$1;
(statearr_14999_15101[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (4))){
var inst_14797 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
var statearr_15000_15102 = state_14978__$1;
(statearr_15000_15102[(2)] = inst_14797);

(statearr_15000_15102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (54))){
var inst_14847 = (state_14978[(7)]);
var inst_14903 = (state_14978[(14)]);
var inst_14808 = (state_14978[(9)]);
var inst_14810 = (state_14978[(10)]);
var inst_14817 = (state_14978[(15)]);
var inst_14811 = (state_14978[(16)]);
var inst_14822 = (state_14978[(17)]);
var inst_14806 = (state_14978[(18)]);
var inst_14807 = (state_14978[(11)]);
var inst_14907 = (function (){var t = inst_14810;
var temp__5802__auto__ = inst_14903;
var p = inst_14808;
var idx_predicate_QMARK_ = inst_14811;
var o = inst_14847;
var vec__14803 = inst_14806;
var tag_predicate_QMARK_ = inst_14817;
var s = inst_14807;
var o_coerce_QMARK_ = inst_14822;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_14978__$1 = state_14978;
var statearr_15001_15103 = state_14978__$1;
(statearr_15001_15103[(2)] = inst_14907);

(statearr_15001_15103[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (15))){
var inst_14809 = (state_14978[(19)]);
var inst_14828 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_14809);
var state_14978__$1 = state_14978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14978__$1,(18),inst_14828);
} else {
if((state_val_14979 === (48))){
var inst_14894 = (state_14978[(20)]);
var state_14978__$1 = state_14978;
var statearr_15002_15104 = state_14978__$1;
(statearr_15002_15104[(2)] = inst_14894);

(statearr_15002_15104[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (50))){
var inst_14903 = (state_14978[(14)]);
var inst_14903__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_14978__$1 = (function (){var statearr_15003 = state_14978;
(statearr_15003[(14)] = inst_14903__$1);

return statearr_15003;
})();
if(cljs.core.truth_(inst_14903__$1)){
var statearr_15004_15105 = state_14978__$1;
(statearr_15004_15105[(1)] = (53));

} else {
var statearr_15005_15106 = state_14978__$1;
(statearr_15005_15106[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (75))){
var inst_14969 = (state_14978[(2)]);
var inst_14970 = fluree.db.util.async.throw_err(inst_14969);
var state_14978__$1 = state_14978;
var statearr_15006_15107 = state_14978__$1;
(statearr_15006_15107[(2)] = inst_14970);

(statearr_15006_15107[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (21))){
var inst_14843 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
var statearr_15007_15108 = state_14978__$1;
(statearr_15007_15108[(2)] = inst_14843);

(statearr_15007_15108[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (31))){
var inst_14847 = (state_14978[(7)]);
var inst_14870 = (state_14978[(21)]);
var inst_14870__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_14847);
var state_14978__$1 = (function (){var statearr_15008 = state_14978;
(statearr_15008[(21)] = inst_14870__$1);

return statearr_15008;
})();
if(inst_14870__$1){
var statearr_15009_15109 = state_14978__$1;
(statearr_15009_15109[(1)] = (34));

} else {
var statearr_15010_15110 = state_14978__$1;
(statearr_15010_15110[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (32))){
var inst_14808 = (state_14978[(9)]);
var state_14978__$1 = state_14978;
var statearr_15011_15111 = state_14978__$1;
(statearr_15011_15111[(2)] = inst_14808);

(statearr_15011_15111[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (40))){
var inst_14847 = (state_14978[(7)]);
var inst_14808 = (state_14978[(9)]);
var inst_14810 = (state_14978[(10)]);
var inst_14807 = (state_14978[(11)]);
var inst_14885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14886 = [inst_14808,inst_14847,inst_14807,inst_14810];
var inst_14887 = (new cljs.core.PersistentVector(null,4,(5),inst_14885,inst_14886,null));
var inst_14888 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_14887,opts);
var state_14978__$1 = state_14978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14978__$1,(43),inst_14888);
} else {
if((state_val_14979 === (56))){
var inst_14847 = (state_14978[(7)]);
var inst_14912 = cljs.core.int_QMARK_(inst_14847);
var state_14978__$1 = state_14978;
var statearr_15012_15112 = state_14978__$1;
(statearr_15012_15112[(2)] = inst_14912);

(statearr_15012_15112[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (33))){
var inst_14883 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
if(cljs.core.truth_(inst_14883)){
var statearr_15013_15113 = state_14978__$1;
(statearr_15013_15113[(1)] = (40));

} else {
var statearr_15014_15114 = state_14978__$1;
(statearr_15014_15114[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (13))){
var inst_14809 = (state_14978[(19)]);
var inst_14826 = fluree.db.query.range.tag_string_QMARK_(inst_14809);
var state_14978__$1 = state_14978;
if(cljs.core.truth_(inst_14826)){
var statearr_15015_15115 = state_14978__$1;
(statearr_15015_15115[(1)] = (15));

} else {
var statearr_15016_15116 = state_14978__$1;
(statearr_15016_15116[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (22))){
var inst_14839 = (state_14978[(2)]);
var inst_14840 = fluree.db.util.async.throw_err(inst_14839);
var state_14978__$1 = state_14978;
var statearr_15017_15117 = state_14978__$1;
(statearr_15017_15117[(2)] = inst_14840);

(statearr_15017_15117[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (36))){
var inst_14880 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
var statearr_15018_15118 = state_14978__$1;
(statearr_15018_15118[(2)] = inst_14880);

(statearr_15018_15118[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (41))){
var inst_14808 = (state_14978[(9)]);
var state_14978__$1 = state_14978;
if(cljs.core.truth_(inst_14808)){
var statearr_15019_15119 = state_14978__$1;
(statearr_15019_15119[(1)] = (44));

} else {
var statearr_15020_15120 = state_14978__$1;
(statearr_15020_15120[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (43))){
var inst_14890 = (state_14978[(2)]);
var inst_14891 = fluree.db.util.async.throw_err(inst_14890);
var state_14978__$1 = state_14978;
var statearr_15021_15121 = state_14978__$1;
(statearr_15021_15121[(2)] = inst_14891);

(statearr_15021_15121[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (61))){
var inst_14936 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
var statearr_15022_15122 = state_14978__$1;
(statearr_15022_15122[(2)] = inst_14936);

(statearr_15022_15122[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (29))){
var inst_14856 = (state_14978[(2)]);
var inst_14857 = fluree.db.util.async.throw_err(inst_14856);
var state_14978__$1 = state_14978;
var statearr_15023_15123 = state_14978__$1;
(statearr_15023_15123[(2)] = inst_14857);

(statearr_15023_15123[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (44))){
var inst_14811 = (state_14978[(16)]);
var inst_14894 = (state_14978[(20)]);
var inst_14894__$1 = cljs.core.not(inst_14811);
var state_14978__$1 = (function (){var statearr_15024 = state_14978;
(statearr_15024[(20)] = inst_14894__$1);

return statearr_15024;
})();
if(inst_14894__$1){
var statearr_15025_15124 = state_14978__$1;
(statearr_15025_15124[(1)] = (47));

} else {
var statearr_15026_15125 = state_14978__$1;
(statearr_15026_15125[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (6))){
var inst_14808 = (state_14978[(9)]);
var inst_14813 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_14808);
var inst_14814 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_14813);
var state_14978__$1 = state_14978;
var statearr_15027_15126 = state_14978__$1;
(statearr_15027_15126[(2)] = inst_14814);

(statearr_15027_15126[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (28))){
var inst_14867 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
var statearr_15028_15127 = state_14978__$1;
(statearr_15028_15127[(2)] = inst_14867);

(statearr_15028_15127[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (64))){
var inst_14847 = (state_14978[(7)]);
var inst_14808 = (state_14978[(9)]);
var inst_14810 = (state_14978[(10)]);
var inst_14807 = (state_14978[(11)]);
var inst_14939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14940 = [inst_14808,inst_14807,inst_14847,inst_14810];
var inst_14941 = (new cljs.core.PersistentVector(null,4,(5),inst_14939,inst_14940,null));
var inst_14942 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_14941,opts);
var state_14978__$1 = state_14978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14978__$1,(67),inst_14942);
} else {
if((state_val_14979 === (51))){
var inst_14808 = (state_14978[(9)]);
var state_14978__$1 = state_14978;
if(cljs.core.truth_(inst_14808)){
var statearr_15029_15128 = state_14978__$1;
(statearr_15029_15128[(1)] = (64));

} else {
var statearr_15030_15129 = state_14978__$1;
(statearr_15030_15129[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (25))){
var inst_14817 = (state_14978[(15)]);
var inst_14965 = (state_14978[(2)]);
var state_14978__$1 = (function (){var statearr_15031 = state_14978;
(statearr_15031[(8)] = inst_14965);

return statearr_15031;
})();
if(cljs.core.truth_(inst_14817)){
var statearr_15032_15130 = state_14978__$1;
(statearr_15032_15130[(1)] = (72));

} else {
var statearr_15033_15131 = state_14978__$1;
(statearr_15033_15131[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (34))){
var inst_14811 = (state_14978[(16)]);
var state_14978__$1 = state_14978;
if(cljs.core.truth_(inst_14811)){
var statearr_15034_15132 = state_14978__$1;
(statearr_15034_15132[(1)] = (37));

} else {
var statearr_15035_15133 = state_14978__$1;
(statearr_15035_15133[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (17))){
var inst_14845 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
var statearr_15036_15134 = state_14978__$1;
(statearr_15036_15134[(2)] = inst_14845);

(statearr_15036_15134[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (3))){
var inst_14976 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14978__$1,inst_14976);
} else {
if((state_val_14979 === (12))){
var inst_14809 = (state_14978[(19)]);
var state_14978__$1 = state_14978;
var statearr_15037_15135 = state_14978__$1;
(statearr_15037_15135[(2)] = inst_14809);

(statearr_15037_15135[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (2))){
var inst_14808 = (state_14978[(9)]);
var inst_14806 = (state_14978[(18)]);
var _ = (function (){var statearr_15038 = state_14978;
(statearr_15038[(4)] = cljs.core.cons((5),(state_14978[(4)])));

return statearr_15038;
})();
var inst_14806__$1 = fparts;
var inst_14807 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14806__$1,(0),null);
var inst_14808__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14806__$1,(1),null);
var inst_14809 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14806__$1,(2),null);
var inst_14810 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14806__$1,(3),null);
var inst_14811 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_14808__$1);
var state_14978__$1 = (function (){var statearr_15039 = state_14978;
(statearr_15039[(19)] = inst_14809);

(statearr_15039[(9)] = inst_14808__$1);

(statearr_15039[(10)] = inst_14810);

(statearr_15039[(16)] = inst_14811);

(statearr_15039[(18)] = inst_14806__$1);

(statearr_15039[(11)] = inst_14807);

return statearr_15039;
})();
if(cljs.core.truth_(inst_14808__$1)){
var statearr_15040_15136 = state_14978__$1;
(statearr_15040_15136[(1)] = (6));

} else {
var statearr_15041_15137 = state_14978__$1;
(statearr_15041_15137[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (66))){
var inst_14959 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
var statearr_15042_15138 = state_14978__$1;
(statearr_15042_15138[(2)] = inst_14959);

(statearr_15042_15138[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (23))){
var inst_14808 = (state_14978[(9)]);
var inst_14849 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_14808);
var state_14978__$1 = state_14978;
if(inst_14849){
var statearr_15043_15139 = state_14978__$1;
(statearr_15043_15139[(1)] = (26));

} else {
var statearr_15044_15140 = state_14978__$1;
(statearr_15044_15140[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (47))){
var inst_14847 = (state_14978[(7)]);
var state_14978__$1 = state_14978;
var statearr_15045_15141 = state_14978__$1;
(statearr_15045_15141[(2)] = inst_14847);

(statearr_15045_15141[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (35))){
var inst_14870 = (state_14978[(21)]);
var state_14978__$1 = state_14978;
var statearr_15046_15142 = state_14978__$1;
(statearr_15046_15142[(2)] = inst_14870);

(statearr_15046_15142[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (19))){
var inst_14809 = (state_14978[(19)]);
var inst_14808 = (state_14978[(9)]);
var inst_14835 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_14808);
var inst_14836 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14835),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_14809)].join('');
var inst_14837 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_14836);
var state_14978__$1 = state_14978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14978__$1,(22),inst_14837);
} else {
if((state_val_14979 === (57))){
var inst_14910 = (state_14978[(13)]);
var state_14978__$1 = state_14978;
var statearr_15047_15143 = state_14978__$1;
(statearr_15047_15143[(2)] = inst_14910);

(statearr_15047_15143[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (68))){
var inst_14847 = (state_14978[(7)]);
var inst_14808 = (state_14978[(9)]);
var inst_14810 = (state_14978[(10)]);
var inst_14807 = (state_14978[(11)]);
var inst_14948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14949 = [inst_14847,inst_14808,inst_14807,inst_14810];
var inst_14950 = (new cljs.core.PersistentVector(null,4,(5),inst_14948,inst_14949,null));
var inst_14951 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_14950,opts);
var state_14978__$1 = state_14978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14978__$1,(71),inst_14951);
} else {
if((state_val_14979 === (11))){
var inst_14822 = (state_14978[(17)]);
var inst_14822__$1 = (state_14978[(2)]);
var inst_14823 = cljs.core.not(inst_14822__$1);
var state_14978__$1 = (function (){var statearr_15049 = state_14978;
(statearr_15049[(17)] = inst_14822__$1);

return statearr_15049;
})();
if(inst_14823){
var statearr_15050_15144 = state_14978__$1;
(statearr_15050_15144[(1)] = (12));

} else {
var statearr_15051_15145 = state_14978__$1;
(statearr_15051_15145[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (9))){
var inst_14809 = (state_14978[(19)]);
var inst_14819 = typeof inst_14809 === 'string';
var state_14978__$1 = state_14978;
var statearr_15052_15146 = state_14978__$1;
(statearr_15052_15146[(2)] = inst_14819);

(statearr_15052_15146[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (5))){
var _ = (function (){var statearr_15053 = state_14978;
(statearr_15053[(4)] = cljs.core.rest((state_14978[(4)])));

return statearr_15053;
})();
var state_14978__$1 = state_14978;
var ex15048 = (state_14978__$1[(2)]);
var statearr_15054_15147 = state_14978__$1;
(statearr_15054_15147[(5)] = ex15048);


if((ex15048 instanceof Error)){
var statearr_15055_15148 = state_14978__$1;
(statearr_15055_15148[(1)] = (4));

(statearr_15055_15148[(5)] = null);

} else {
throw ex15048;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (14))){
var inst_14807 = (state_14978[(11)]);
var inst_14847 = (state_14978[(2)]);
var state_14978__$1 = (function (){var statearr_15056 = state_14978;
(statearr_15056[(7)] = inst_14847);

return statearr_15056;
})();
if(cljs.core.truth_(inst_14807)){
var statearr_15057_15149 = state_14978__$1;
(statearr_15057_15149[(1)] = (23));

} else {
var statearr_15058_15150 = state_14978__$1;
(statearr_15058_15150[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (45))){
var inst_14808 = (state_14978[(9)]);
var state_14978__$1 = state_14978;
var statearr_15059_15151 = state_14978__$1;
(statearr_15059_15151[(2)] = inst_14808);

(statearr_15059_15151[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (53))){
var inst_14847 = (state_14978[(7)]);
var inst_14903 = (state_14978[(14)]);
var inst_14808 = (state_14978[(9)]);
var inst_14810 = (state_14978[(10)]);
var inst_14817 = (state_14978[(15)]);
var inst_14811 = (state_14978[(16)]);
var inst_14822 = (state_14978[(17)]);
var inst_14806 = (state_14978[(18)]);
var inst_14807 = (state_14978[(11)]);
var inst_14905 = (function (){var obj_fn = inst_14903;
var t = inst_14810;
var temp__5802__auto__ = inst_14903;
var p = inst_14808;
var idx_predicate_QMARK_ = inst_14811;
var o = inst_14847;
var vec__14803 = inst_14806;
var tag_predicate_QMARK_ = inst_14817;
var s = inst_14807;
var o_coerce_QMARK_ = inst_14822;
return (function (x){
var and__4251__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4251__auto__;
}
});
})();
var state_14978__$1 = state_14978;
var statearr_15060_15152 = state_14978__$1;
(statearr_15060_15152[(2)] = inst_14905);

(statearr_15060_15152[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (26))){
var inst_14810 = (state_14978[(10)]);
var inst_14807 = (state_14978[(11)]);
var inst_14851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14852 = [inst_14807,null,null,inst_14810];
var inst_14853 = (new cljs.core.PersistentVector(null,4,(5),inst_14851,inst_14852,null));
var inst_14854 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_14853,opts);
var state_14978__$1 = state_14978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14978__$1,(29),inst_14854);
} else {
if((state_val_14979 === (16))){
var inst_14809 = (state_14978[(19)]);
var inst_14833 = typeof inst_14809 === 'string';
var state_14978__$1 = state_14978;
if(cljs.core.truth_(inst_14833)){
var statearr_15061_15153 = state_14978__$1;
(statearr_15061_15153[(1)] = (19));

} else {
var statearr_15062_15154 = state_14978__$1;
(statearr_15062_15154[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (38))){
var inst_14811 = (state_14978[(16)]);
var state_14978__$1 = state_14978;
var statearr_15063_15155 = state_14978__$1;
(statearr_15063_15155[(2)] = inst_14811);

(statearr_15063_15155[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (30))){
var inst_14864 = (state_14978[(2)]);
var inst_14865 = fluree.db.util.async.throw_err(inst_14864);
var state_14978__$1 = state_14978;
var statearr_15064_15156 = state_14978__$1;
(statearr_15064_15156[(2)] = inst_14865);

(statearr_15064_15156[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (73))){
var inst_14965 = (state_14978[(8)]);
var state_14978__$1 = state_14978;
var statearr_15065_15157 = state_14978__$1;
(statearr_15065_15157[(2)] = inst_14965);

(statearr_15065_15157[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (10))){
var inst_14817 = (state_14978[(15)]);
var state_14978__$1 = state_14978;
var statearr_15066_15158 = state_14978__$1;
(statearr_15066_15158[(2)] = inst_14817);

(statearr_15066_15158[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (18))){
var inst_14830 = (state_14978[(2)]);
var inst_14831 = fluree.db.util.async.throw_err(inst_14830);
var state_14978__$1 = state_14978;
var statearr_15067_15159 = state_14978__$1;
(statearr_15067_15159[(2)] = inst_14831);

(statearr_15067_15159[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (52))){
var inst_14961 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
var statearr_15068_15160 = state_14978__$1;
(statearr_15068_15160[(2)] = inst_14961);

(statearr_15068_15160[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (67))){
var inst_14944 = (state_14978[(2)]);
var inst_14945 = fluree.db.util.async.throw_err(inst_14944);
var state_14978__$1 = state_14978;
var statearr_15069_15161 = state_14978__$1;
(statearr_15069_15161[(2)] = inst_14945);

(statearr_15069_15161[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (71))){
var inst_14953 = (state_14978[(2)]);
var inst_14954 = fluree.db.util.async.throw_err(inst_14953);
var state_14978__$1 = state_14978;
var statearr_15070_15162 = state_14978__$1;
(statearr_15070_15162[(2)] = inst_14954);

(statearr_15070_15162[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (42))){
var inst_14963 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
var statearr_15071_15163 = state_14978__$1;
(statearr_15071_15163[(2)] = inst_14963);

(statearr_15071_15163[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (37))){
var inst_14847 = (state_14978[(7)]);
var inst_14873 = cljs.core.fn_QMARK_(inst_14847);
var inst_14874 = (!(inst_14873));
var state_14978__$1 = state_14978;
var statearr_15072_15164 = state_14978__$1;
(statearr_15072_15164[(2)] = inst_14874);

(statearr_15072_15164[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (63))){
var inst_14933 = (state_14978[(2)]);
var inst_14934 = fluree.db.util.async.throw_err(inst_14933);
var state_14978__$1 = state_14978;
var statearr_15073_15165 = state_14978__$1;
(statearr_15073_15165[(2)] = inst_14934);

(statearr_15073_15165[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (8))){
var inst_14817 = (state_14978[(15)]);
var inst_14817__$1 = (state_14978[(2)]);
var state_14978__$1 = (function (){var statearr_15074 = state_14978;
(statearr_15074[(15)] = inst_14817__$1);

return statearr_15074;
})();
if(cljs.core.truth_(inst_14817__$1)){
var statearr_15075_15166 = state_14978__$1;
(statearr_15075_15166[(1)] = (9));

} else {
var statearr_15076_15167 = state_14978__$1;
(statearr_15076_15167[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14979 === (49))){
var inst_14898 = (state_14978[(2)]);
var state_14978__$1 = state_14978;
var statearr_15077_15168 = state_14978__$1;
(statearr_15077_15168[(2)] = inst_14898);

(statearr_15077_15168[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15078 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15078[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15078[(1)] = (1));

return statearr_15078;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_14978){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14978);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15079){var ex__2730__auto__ = e15079;
var statearr_15080_15169 = state_14978;
(statearr_15080_15169[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14978[(4)]))){
var statearr_15081_15170 = state_14978;
(statearr_15081_15170[(1)] = cljs.core.first((state_14978[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15171 = state_14978;
state_14978 = G__15171;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_14978){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_14978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15082 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15082[(6)] = c__2749__auto__);

return statearr_15082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15173 = arguments.length;
switch (G__15173) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_15208){
var state_val_15209 = (state_15208[(1)]);
if((state_val_15209 === (7))){
var inst_15195 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_15196 = ["Invalid collection name: ",inst_15195].join('');
var inst_15197 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15198 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15199 = cljs.core.PersistentHashMap.fromArrays(inst_15197,inst_15198);
var inst_15200 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15196,inst_15199);
var inst_15201 = (function(){throw inst_15200})();
var state_15208__$1 = state_15208;
var statearr_15210_15230 = state_15208__$1;
(statearr_15210_15230[(2)] = inst_15201);

(statearr_15210_15230[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15209 === (1))){
var state_15208__$1 = state_15208;
var statearr_15211_15231 = state_15208__$1;
(statearr_15211_15231[(2)] = null);

(statearr_15211_15231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15209 === (4))){
var inst_15174 = (state_15208[(2)]);
var state_15208__$1 = state_15208;
var statearr_15212_15232 = state_15208__$1;
(statearr_15212_15232[(2)] = inst_15174);

(statearr_15212_15232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15209 === (6))){
var inst_15180 = (state_15208[(7)]);
var inst_15182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15183 = fluree.db.flake.max_subject_id(inst_15180);
var inst_15184 = [inst_15183];
var inst_15185 = (new cljs.core.PersistentVector(null,1,(5),inst_15182,inst_15184,null));
var inst_15186 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15187 = fluree.db.flake.min_subject_id(inst_15180);
var inst_15188 = [inst_15187];
var inst_15189 = (new cljs.core.PersistentVector(null,1,(5),inst_15186,inst_15188,null));
var inst_15190 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15185,cljs.core._LT__EQ_,inst_15189,opts);
var state_15208__$1 = state_15208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15208__$1,(9),inst_15190);
} else {
if((state_val_15209 === (3))){
var inst_15206 = (state_15208[(2)]);
var state_15208__$1 = state_15208;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15208__$1,inst_15206);
} else {
if((state_val_15209 === (2))){
var inst_15180 = (state_15208[(7)]);
var _ = (function (){var statearr_15214 = state_15208;
(statearr_15214[(4)] = cljs.core.cons((5),(state_15208[(4)])));

return statearr_15214;
})();
var inst_15180__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15208__$1 = (function (){var statearr_15215 = state_15208;
(statearr_15215[(7)] = inst_15180__$1);

return statearr_15215;
})();
if(cljs.core.truth_(inst_15180__$1)){
var statearr_15216_15233 = state_15208__$1;
(statearr_15216_15233[(1)] = (6));

} else {
var statearr_15217_15234 = state_15208__$1;
(statearr_15217_15234[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15209 === (9))){
var inst_15192 = (state_15208[(2)]);
var inst_15193 = fluree.db.util.async.throw_err(inst_15192);
var state_15208__$1 = state_15208;
var statearr_15218_15235 = state_15208__$1;
(statearr_15218_15235[(2)] = inst_15193);

(statearr_15218_15235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15209 === (5))){
var _ = (function (){var statearr_15219 = state_15208;
(statearr_15219[(4)] = cljs.core.rest((state_15208[(4)])));

return statearr_15219;
})();
var state_15208__$1 = state_15208;
var ex15213 = (state_15208__$1[(2)]);
var statearr_15220_15236 = state_15208__$1;
(statearr_15220_15236[(5)] = ex15213);


var statearr_15221_15237 = state_15208__$1;
(statearr_15221_15237[(1)] = (4));

(statearr_15221_15237[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15209 === (8))){
var inst_15203 = (state_15208[(2)]);
var _ = (function (){var statearr_15222 = state_15208;
(statearr_15222[(4)] = cljs.core.rest((state_15208[(4)])));

return statearr_15222;
})();
var state_15208__$1 = state_15208;
var statearr_15223_15238 = state_15208__$1;
(statearr_15223_15238[(2)] = inst_15203);

(statearr_15223_15238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2727__auto__ = null;
var fluree$db$query$range$state_machine__2727__auto____0 = (function (){
var statearr_15224 = [null,null,null,null,null,null,null,null];
(statearr_15224[(0)] = fluree$db$query$range$state_machine__2727__auto__);

(statearr_15224[(1)] = (1));

return statearr_15224;
});
var fluree$db$query$range$state_machine__2727__auto____1 = (function (state_15208){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_15208);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e15225){var ex__2730__auto__ = e15225;
var statearr_15226_15239 = state_15208;
(statearr_15226_15239[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_15208[(4)]))){
var statearr_15227_15240 = state_15208;
(statearr_15227_15240[(1)] = cljs.core.first((state_15208[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15241 = state_15208;
state_15208 = G__15241;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2727__auto__ = function(state_15208){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2727__auto____1.call(this,state_15208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2727__auto____0;
fluree$db$query$range$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2727__auto____1;
return fluree$db$query$range$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_15228 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_15228[(6)] = c__2749__auto__);

return statearr_15228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-9007199254740991)], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15245 = flakes;
var vec__15246 = G__15245;
var seq__15247 = cljs.core.seq(vec__15246);
var first__15248 = cljs.core.first(seq__15247);
var seq__15247__$1 = cljs.core.next(seq__15247);
var flake_SINGLEQUOTE_ = first__15248;
var r = seq__15247__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15245__$1 = G__15245;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15254 = G__15245__$1;
var seq__15255 = cljs.core.seq(vec__15254);
var first__15256 = cljs.core.first(seq__15255);
var seq__15255__$1 = cljs.core.next(seq__15255);
var flake_SINGLEQUOTE___$1 = first__15256;
var r__$1 = seq__15255__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = fluree.db.flake.o(flake_SINGLEQUOTE___$1);
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e15258){var e = e15258;
return null;
}})();
var map__15257 = cmd_map;
var map__15257__$1 = cljs.core.__destructure_map(map__15257);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15257__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15257__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15257__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15257__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15257__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15257__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15259 = r__$1;
var G__15260 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15245__$1 = G__15259;
result_STAR___$1 = G__15260;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15269 = blocks;
var vec__15270 = G__15269;
var seq__15271 = cljs.core.seq(vec__15270);
var first__15272 = cljs.core.first(seq__15271);
var seq__15271__$1 = cljs.core.next(seq__15271);
var block_SINGLEQUOTE_ = first__15272;
var r = seq__15271__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15269__$1 = G__15269;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15277 = G__15269__$1;
var seq__15278 = cljs.core.seq(vec__15277);
var first__15279 = cljs.core.first(seq__15278);
var seq__15278__$1 = cljs.core.next(seq__15278);
var block_SINGLEQUOTE___$1 = first__15279;
var r__$1 = seq__15278__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15280 = block_SINGLEQUOTE___$1;
var map__15280__$1 = cljs.core.__destructure_map(map__15280);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15280__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15280__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15280__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__15269__$1,result_STAR___$1,map__15280,map__15280__$1,block,t,flakes,vec__15277,seq__15278,first__15279,seq__15278__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15269,vec__15270,seq__15271,first__15272,seq__15271__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15261_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15261_SHARP_),(2))){
return fluree.db.flake.o(p1__15261_SHARP_);
} else {
return null;
}
});})(G__15269__$1,result_STAR___$1,map__15280,map__15280__$1,block,t,flakes,vec__15277,seq__15278,first__15279,seq__15278__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15269,vec__15270,seq__15271,first__15272,seq__15271__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__15269__$1,result_STAR___$1,map__15280,map__15280__$1,block,t,flakes,prev_hash,vec__15277,seq__15278,first__15279,seq__15278__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15269,vec__15270,seq__15271,first__15272,seq__15271__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15262_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15262_SHARP_),(1))){
return fluree.db.flake.o(p1__15262_SHARP_);
} else {
return null;
}
});})(G__15269__$1,result_STAR___$1,map__15280,map__15280__$1,block,t,flakes,prev_hash,vec__15277,seq__15278,first__15279,seq__15278__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15269,vec__15270,seq__15271,first__15272,seq__15271__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__15269__$1,result_STAR___$1,map__15280,map__15280__$1,block,t,flakes,prev_hash,hash,vec__15277,seq__15278,first__15279,seq__15278__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15269,vec__15270,seq__15271,first__15272,seq__15271__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15263_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15263_SHARP_),(5))){
return fluree.db.flake.o(p1__15263_SHARP_);
} else {
return null;
}
});})(G__15269__$1,result_STAR___$1,map__15280,map__15280__$1,block,t,flakes,prev_hash,hash,vec__15277,seq__15278,first__15279,seq__15278__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15269,vec__15270,seq__15271,first__15272,seq__15271__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__15269__$1,result_STAR___$1,map__15280,map__15280__$1,block,t,flakes,prev_hash,hash,instant,vec__15277,seq__15278,first__15279,seq__15278__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15269,vec__15270,seq__15271,first__15272,seq__15271__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15264_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15264_SHARP_),(7))){
return fluree.db.flake.o(p1__15264_SHARP_);
} else {
return null;
}
});})(G__15269__$1,result_STAR___$1,map__15280,map__15280__$1,block,t,flakes,prev_hash,hash,instant,vec__15277,seq__15278,first__15279,seq__15278__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15269,vec__15270,seq__15271,first__15272,seq__15271__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__15269__$1,result_STAR___$1,map__15280,map__15280__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15277,seq__15278,first__15279,seq__15278__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15269,vec__15270,seq__15271,first__15272,seq__15271__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15265_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p(p1__15265_SHARP_),(106));
});})(G__15269__$1,result_STAR___$1,map__15280,map__15280__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15277,seq__15278,first__15279,seq__15278__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15269,vec__15270,seq__15271,first__15272,seq__15271__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__15281 = r__$1;
var G__15282 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15269__$1 = G__15281;
result_STAR___$1 = G__15282;
continue;
}
break;
}
});
