// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql_resp');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql_resp.vswap_BANG_ = (function fluree$db$query$fql_resp$vswap_BANG_(var_args){
var G__21118 = arguments.length;
switch (G__21118) {
case 2:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__21119 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__21119) : f.call(null,G__21119));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__21120 = cljs.core._deref(vol);
var G__21121 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__21120,G__21121) : f.call(null,G__21120,G__21121));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__21122 = cljs.core._deref(vol);
var G__21123 = arg1;
var G__21124 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__21122,G__21123,G__21124) : f.call(null,G__21122,G__21123,G__21124));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__21125 = cljs.core._deref(vol);
var G__21126 = arg1;
var G__21127 = arg2;
var G__21128 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__21125,G__21126,G__21127,G__21128) : f.call(null,G__21125,G__21126,G__21127,G__21128));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql_resp.has_ns_lookups_QMARK_ = (function fluree$db$query$fql_resp$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql_resp.full_select_spec = (function fluree$db$query$fql_resp$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql_resp$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql_resp.add_fuel = (function fluree$db$query$fql_resp$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql_resp.resolve_reverse_refs = (function fluree$db$query$fql_resp$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21289){
var state_val_21290 = (state_21289[(1)]);
if((state_val_21290 === (7))){
var inst_21284 = (state_21289[(2)]);
var _ = (function (){var statearr_21291 = state_21289;
(statearr_21291[(4)] = cljs.core.rest((state_21289[(4)])));

return statearr_21291;
})();
var state_21289__$1 = state_21289;
var statearr_21292_21374 = state_21289__$1;
(statearr_21292_21374[(2)] = inst_21284);

(statearr_21292_21374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (20))){
var inst_21211 = (state_21289[(7)]);
var state_21289__$1 = state_21289;
var statearr_21293_21375 = state_21289__$1;
(statearr_21293_21375[(2)] = inst_21211);

(statearr_21293_21375[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (27))){
var inst_21166 = (state_21289[(8)]);
var state_21289__$1 = state_21289;
if(cljs.core.truth_(inst_21166)){
var statearr_21294_21376 = state_21289__$1;
(statearr_21294_21376[(1)] = (29));

} else {
var statearr_21295_21377 = state_21289__$1;
(statearr_21295_21377[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (1))){
var state_21289__$1 = state_21289;
var statearr_21296_21378 = state_21289__$1;
(statearr_21296_21378[(2)] = null);

(statearr_21296_21378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (24))){
var inst_21167 = (state_21289[(9)]);
var state_21289__$1 = state_21289;
var statearr_21297_21379 = state_21289__$1;
(statearr_21297_21379[(2)] = inst_21167);

(statearr_21297_21379[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (39))){
var inst_21203 = (state_21289[(10)]);
var state_21289__$1 = state_21289;
var statearr_21298_21380 = state_21289__$1;
(statearr_21298_21380[(2)] = inst_21203);

(statearr_21298_21380[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (46))){
var inst_21168 = (state_21289[(11)]);
var state_21289__$1 = state_21289;
var statearr_21299_21381 = state_21289__$1;
(statearr_21299_21381[(2)] = inst_21168);

(statearr_21299_21381[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (4))){
var inst_21130 = (state_21289[(2)]);
var state_21289__$1 = state_21289;
var statearr_21300_21382 = state_21289__$1;
(statearr_21300_21382[(2)] = inst_21130);

(statearr_21300_21382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (15))){
var inst_21179 = (state_21289[(12)]);
var inst_21185 = cljs.core.count(inst_21179);
var inst_21186 = fluree.db.query.fql_resp.add_fuel(fuel,inst_21185,max_fuel);
var state_21289__$1 = state_21289;
var statearr_21301_21383 = state_21289__$1;
(statearr_21301_21383[(2)] = inst_21186);

(statearr_21301_21383[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (48))){
var inst_21270 = (state_21289[(13)]);
var inst_21148 = (state_21289[(14)]);
var inst_21155 = (state_21289[(15)]);
var inst_21278 = (state_21289[(2)]);
var inst_21279 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21148,inst_21278,inst_21270);
var inst_21147 = inst_21155;
var inst_21148__$1 = inst_21279;
var state_21289__$1 = (function (){var statearr_21302 = state_21289;
(statearr_21302[(14)] = inst_21148__$1);

(statearr_21302[(16)] = inst_21147);

return statearr_21302;
})();
var statearr_21303_21384 = state_21289__$1;
(statearr_21303_21384[(2)] = null);

(statearr_21303_21384[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (50))){
var inst_21170 = (state_21289[(17)]);
var state_21289__$1 = state_21289;
var statearr_21304_21385 = state_21289__$1;
(statearr_21304_21385[(2)] = inst_21170);

(statearr_21304_21385[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (21))){
var inst_21167 = (state_21289[(9)]);
var state_21289__$1 = state_21289;
if(cljs.core.truth_(inst_21167)){
var statearr_21306_21386 = state_21289__$1;
(statearr_21306_21386[(1)] = (23));

} else {
var statearr_21307_21387 = state_21289__$1;
(statearr_21307_21387[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (31))){
var inst_21227 = (state_21289[(2)]);
var state_21289__$1 = state_21289;
if(cljs.core.truth_(inst_21227)){
var statearr_21308_21388 = state_21289__$1;
(statearr_21308_21388[(1)] = (32));

} else {
var statearr_21309_21389 = state_21289__$1;
(statearr_21309_21389[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (32))){
var inst_21203 = (state_21289[(10)]);
var inst_21202 = (state_21289[(18)]);
var inst_21210 = (state_21289[(19)]);
var inst_21229 = (inst_21202 + (1));
var tmp21305 = inst_21203;
var inst_21201 = inst_21210;
var inst_21202__$1 = inst_21229;
var inst_21203__$1 = tmp21305;
var state_21289__$1 = (function (){var statearr_21310 = state_21289;
(statearr_21310[(10)] = inst_21203__$1);

(statearr_21310[(20)] = inst_21201);

(statearr_21310[(18)] = inst_21202__$1);

return statearr_21310;
})();
var statearr_21311_21390 = state_21289__$1;
(statearr_21311_21390[(2)] = null);

(statearr_21311_21390[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (40))){
var state_21289__$1 = state_21289;
if(cljs.core.truth_(fuel)){
var statearr_21312_21391 = state_21289__$1;
(statearr_21312_21391[(1)] = (42));

} else {
var statearr_21313_21392 = state_21289__$1;
(statearr_21313_21392[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (33))){
var state_21289__$1 = state_21289;
var statearr_21314_21393 = state_21289__$1;
(statearr_21314_21393[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (13))){
var inst_21179 = (state_21289[(12)]);
var state_21289__$1 = state_21289;
var statearr_21316_21394 = state_21289__$1;
(statearr_21316_21394[(2)] = inst_21179);

(statearr_21316_21394[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (22))){
var inst_21220 = (state_21289[(2)]);
var state_21289__$1 = state_21289;
if(cljs.core.truth_(inst_21220)){
var statearr_21317_21395 = state_21289__$1;
(statearr_21317_21395[(1)] = (26));

} else {
var statearr_21318_21396 = state_21289__$1;
(statearr_21318_21396[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (36))){
var state_21289__$1 = state_21289;
var statearr_21319_21397 = state_21289__$1;
(statearr_21319_21397[(2)] = null);

(statearr_21319_21397[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (41))){
var inst_21202 = (state_21289[(18)]);
var inst_21210 = (state_21289[(19)]);
var inst_21259 = (state_21289[(2)]);
var inst_21260 = (inst_21202 + (1));
var inst_21201 = inst_21210;
var inst_21202__$1 = inst_21260;
var inst_21203 = inst_21259;
var state_21289__$1 = (function (){var statearr_21320 = state_21289;
(statearr_21320[(10)] = inst_21203);

(statearr_21320[(20)] = inst_21201);

(statearr_21320[(18)] = inst_21202__$1);

return statearr_21320;
})();
var statearr_21321_21398 = state_21289__$1;
(statearr_21321_21398[(2)] = null);

(statearr_21321_21398[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (43))){
var state_21289__$1 = state_21289;
var statearr_21322_21399 = state_21289__$1;
(statearr_21322_21399[(2)] = null);

(statearr_21322_21399[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (29))){
var inst_21166 = (state_21289[(8)]);
var inst_21202 = (state_21289[(18)]);
var inst_21224 = (inst_21202 < inst_21166);
var state_21289__$1 = state_21289;
var statearr_21323_21400 = state_21289__$1;
(statearr_21323_21400[(2)] = inst_21224);

(statearr_21323_21400[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (44))){
var inst_21243 = (state_21289[(21)]);
var inst_21239 = (state_21289[(22)]);
var inst_21252 = (state_21289[(2)]);
var inst_21253 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_21243,inst_21239) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_21243,inst_21239));
var state_21289__$1 = (function (){var statearr_21324 = state_21289;
(statearr_21324[(23)] = inst_21252);

return statearr_21324;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21289__$1,(45),inst_21253);
} else {
if((state_val_21290 === (6))){
var inst_21154 = (state_21289[(24)]);
var inst_21147 = (state_21289[(16)]);
var inst_21153 = cljs.core.seq(inst_21147);
var inst_21154__$1 = cljs.core.first(inst_21153);
var inst_21155 = cljs.core.next(inst_21153);
var inst_21156 = cljs.core.not(inst_21154__$1);
var state_21289__$1 = (function (){var statearr_21325 = state_21289;
(statearr_21325[(24)] = inst_21154__$1);

(statearr_21325[(15)] = inst_21155);

return statearr_21325;
})();
if(inst_21156){
var statearr_21326_21401 = state_21289__$1;
(statearr_21326_21401[(1)] = (8));

} else {
var statearr_21327_21402 = state_21289__$1;
(statearr_21327_21402[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (28))){
var inst_21268 = (state_21289[(2)]);
var state_21289__$1 = state_21289;
var statearr_21328_21403 = state_21289__$1;
(statearr_21328_21403[(2)] = inst_21268);

(statearr_21328_21403[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (51))){
var inst_21276 = (state_21289[(2)]);
var state_21289__$1 = state_21289;
var statearr_21329_21404 = state_21289__$1;
(statearr_21329_21404[(2)] = inst_21276);

(statearr_21329_21404[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (25))){
var inst_21218 = (state_21289[(2)]);
var state_21289__$1 = state_21289;
var statearr_21330_21405 = state_21289__$1;
(statearr_21330_21405[(2)] = inst_21218);

(statearr_21330_21405[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (34))){
var inst_21266 = (state_21289[(2)]);
var state_21289__$1 = state_21289;
var statearr_21331_21406 = state_21289__$1;
(statearr_21331_21406[(2)] = inst_21266);

(statearr_21331_21406[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (17))){
var inst_21179 = (state_21289[(12)]);
var inst_21189 = (state_21289[(2)]);
var inst_21197 = cljs.core.seq(inst_21179);
var inst_21198 = cljs.core.first(inst_21197);
var inst_21199 = cljs.core.next(inst_21197);
var inst_21200 = cljs.core.PersistentVector.EMPTY;
var inst_21201 = inst_21179;
var inst_21202 = (0);
var inst_21203 = inst_21200;
var state_21289__$1 = (function (){var statearr_21332 = state_21289;
(statearr_21332[(10)] = inst_21203);

(statearr_21332[(20)] = inst_21201);

(statearr_21332[(25)] = inst_21198);

(statearr_21332[(18)] = inst_21202);

(statearr_21332[(26)] = inst_21199);

(statearr_21332[(27)] = inst_21189);

return statearr_21332;
})();
var statearr_21333_21407 = state_21289__$1;
(statearr_21333_21407[(2)] = null);

(statearr_21333_21407[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (3))){
var inst_21287 = (state_21289[(2)]);
var state_21289__$1 = state_21289;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21289__$1,inst_21287);
} else {
if((state_val_21290 === (12))){
var state_21289__$1 = state_21289;
var statearr_21334_21408 = state_21289__$1;
(statearr_21334_21408[(2)] = fuel);

(statearr_21334_21408[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (2))){
var _ = (function (){var statearr_21335 = state_21289;
(statearr_21335[(4)] = cljs.core.cons((5),(state_21289[(4)])));

return statearr_21335;
})();
var inst_21143 = reverse_refs_specs;
var inst_21144 = cljs.core.seq(inst_21143);
var inst_21145 = cljs.core.first(inst_21144);
var inst_21146 = cljs.core.next(inst_21144);
var inst_21147 = inst_21143;
var inst_21148 = null;
var state_21289__$1 = (function (){var statearr_21336 = state_21289;
(statearr_21336[(28)] = inst_21145);

(statearr_21336[(29)] = inst_21146);

(statearr_21336[(14)] = inst_21148);

(statearr_21336[(16)] = inst_21147);

return statearr_21336;
})();
var statearr_21337_21409 = state_21289__$1;
(statearr_21337_21409[(2)] = null);

(statearr_21337_21409[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (23))){
var inst_21167 = (state_21289[(9)]);
var inst_21202 = (state_21289[(18)]);
var inst_21215 = (inst_21202 >= inst_21167);
var state_21289__$1 = state_21289;
var statearr_21338_21410 = state_21289__$1;
(statearr_21338_21410[(2)] = inst_21215);

(statearr_21338_21410[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (47))){
var inst_21169 = (state_21289[(30)]);
var state_21289__$1 = state_21289;
if(cljs.core.truth_(inst_21169)){
var statearr_21339_21411 = state_21289__$1;
(statearr_21339_21411[(1)] = (49));

} else {
var statearr_21340_21412 = state_21289__$1;
(statearr_21340_21412[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (35))){
var inst_21209 = (state_21289[(31)]);
var inst_21233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21234 = [inst_21209];
var inst_21235 = (new cljs.core.PersistentVector(null,1,(5),inst_21233,inst_21234,null));
var inst_21236 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21235);
var state_21289__$1 = state_21289;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21289__$1,(38),inst_21236);
} else {
if((state_val_21290 === (19))){
var inst_21168 = (state_21289[(11)]);
var inst_21270 = (state_21289[(2)]);
var state_21289__$1 = (function (){var statearr_21341 = state_21289;
(statearr_21341[(13)] = inst_21270);

return statearr_21341;
})();
if(cljs.core.truth_(inst_21168)){
var statearr_21342_21413 = state_21289__$1;
(statearr_21342_21413[(1)] = (46));

} else {
var statearr_21343_21414 = state_21289__$1;
(statearr_21343_21414[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (11))){
var inst_21179 = (state_21289[(12)]);
var inst_21176 = (state_21289[(2)]);
var inst_21177 = fluree.db.util.async.throw_err(inst_21176);
var inst_21178 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.s,inst_21177);
var inst_21179__$1 = cljs.core.not_empty(inst_21178);
var state_21289__$1 = (function (){var statearr_21345 = state_21289;
(statearr_21345[(12)] = inst_21179__$1);

return statearr_21345;
})();
if(cljs.core.truth_(inst_21179__$1)){
var statearr_21346_21415 = state_21289__$1;
(statearr_21346_21415[(1)] = (12));

} else {
var statearr_21347_21416 = state_21289__$1;
(statearr_21347_21416[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (9))){
var inst_21164 = (state_21289[(32)]);
var inst_21154 = (state_21289[(24)]);
var inst_21163 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21154,(0),null);
var inst_21164__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21154,(1),null);
var inst_21165 = cljs.core.__destructure_map(inst_21164__$1);
var inst_21166 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21165,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21167 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21165,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21168 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21165,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_21169 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21165,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_21170 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21165,new cljs.core.Keyword(null,"p","p",151049309));
var inst_21171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21172 = [subject_id,inst_21163];
var inst_21173 = (new cljs.core.PersistentVector(null,2,(5),inst_21171,inst_21172,null));
var inst_21174 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_21173);
var state_21289__$1 = (function (){var statearr_21348 = state_21289;
(statearr_21348[(9)] = inst_21167);

(statearr_21348[(8)] = inst_21166);

(statearr_21348[(32)] = inst_21164__$1);

(statearr_21348[(11)] = inst_21168);

(statearr_21348[(30)] = inst_21169);

(statearr_21348[(17)] = inst_21170);

return statearr_21348;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21289__$1,(11),inst_21174);
} else {
if((state_val_21290 === (5))){
var _ = (function (){var statearr_21349 = state_21289;
(statearr_21349[(4)] = cljs.core.rest((state_21289[(4)])));

return statearr_21349;
})();
var state_21289__$1 = state_21289;
var ex21344 = (state_21289__$1[(2)]);
var statearr_21350_21417 = state_21289__$1;
(statearr_21350_21417[(5)] = ex21344);


if((ex21344 instanceof Error)){
var statearr_21351_21418 = state_21289__$1;
(statearr_21351_21418[(1)] = (4));

(statearr_21351_21418[(5)] = null);

} else {
throw ex21344;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (14))){
var inst_21183 = (state_21289[(2)]);
var state_21289__$1 = state_21289;
if(cljs.core.truth_(inst_21183)){
var statearr_21352_21419 = state_21289__$1;
(statearr_21352_21419[(1)] = (15));

} else {
var statearr_21353_21420 = state_21289__$1;
(statearr_21353_21420[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (45))){
var inst_21203 = (state_21289[(10)]);
var inst_21255 = (state_21289[(2)]);
var inst_21256 = fluree.db.util.async.throw_err(inst_21255);
var inst_21257 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21203,inst_21256);
var state_21289__$1 = state_21289;
var statearr_21354_21421 = state_21289__$1;
(statearr_21354_21421[(2)] = inst_21257);

(statearr_21354_21421[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (26))){
var inst_21203 = (state_21289[(10)]);
var state_21289__$1 = state_21289;
var statearr_21355_21422 = state_21289__$1;
(statearr_21355_21422[(2)] = inst_21203);

(statearr_21355_21422[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (16))){
var state_21289__$1 = state_21289;
var statearr_21356_21423 = state_21289__$1;
(statearr_21356_21423[(2)] = null);

(statearr_21356_21423[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (38))){
var inst_21164 = (state_21289[(32)]);
var inst_21239 = (state_21289[(22)]);
var inst_21238 = (state_21289[(2)]);
var inst_21239__$1 = fluree.db.util.async.throw_err(inst_21238);
var inst_21240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21241 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_21242 = (new cljs.core.PersistentVector(null,4,(5),inst_21240,inst_21241,null));
var inst_21243 = cljs.core.select_keys(inst_21164,inst_21242);
var inst_21244 = cljs.core.empty_QMARK_(inst_21239__$1);
var state_21289__$1 = (function (){var statearr_21357 = state_21289;
(statearr_21357[(21)] = inst_21243);

(statearr_21357[(22)] = inst_21239__$1);

return statearr_21357;
})();
if(inst_21244){
var statearr_21358_21424 = state_21289__$1;
(statearr_21358_21424[(1)] = (39));

} else {
var statearr_21359_21425 = state_21289__$1;
(statearr_21359_21425[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (30))){
var inst_21166 = (state_21289[(8)]);
var state_21289__$1 = state_21289;
var statearr_21360_21426 = state_21289__$1;
(statearr_21360_21426[(2)] = inst_21166);

(statearr_21360_21426[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (10))){
var inst_21282 = (state_21289[(2)]);
var state_21289__$1 = state_21289;
var statearr_21361_21427 = state_21289__$1;
(statearr_21361_21427[(2)] = inst_21282);

(statearr_21361_21427[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (18))){
var inst_21211 = (state_21289[(7)]);
var inst_21201 = (state_21289[(20)]);
var inst_21209 = (state_21289[(31)]);
var inst_21208 = cljs.core.seq(inst_21201);
var inst_21209__$1 = cljs.core.first(inst_21208);
var inst_21210 = cljs.core.next(inst_21208);
var inst_21211__$1 = cljs.core.not(inst_21209__$1);
var state_21289__$1 = (function (){var statearr_21362 = state_21289;
(statearr_21362[(7)] = inst_21211__$1);

(statearr_21362[(31)] = inst_21209__$1);

(statearr_21362[(19)] = inst_21210);

return statearr_21362;
})();
if(inst_21211__$1){
var statearr_21363_21428 = state_21289__$1;
(statearr_21363_21428[(1)] = (20));

} else {
var statearr_21364_21429 = state_21289__$1;
(statearr_21364_21429[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (42))){
var inst_21239 = (state_21289[(22)]);
var inst_21248 = cljs.core.count(inst_21239);
var inst_21249 = fluree.db.query.fql_resp.add_fuel(fuel,inst_21248,max_fuel);
var state_21289__$1 = state_21289;
var statearr_21365_21430 = state_21289__$1;
(statearr_21365_21430[(2)] = inst_21249);

(statearr_21365_21430[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (37))){
var inst_21264 = (state_21289[(2)]);
var state_21289__$1 = state_21289;
var statearr_21366_21431 = state_21289__$1;
(statearr_21366_21431[(2)] = inst_21264);

(statearr_21366_21431[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (8))){
var inst_21148 = (state_21289[(14)]);
var state_21289__$1 = state_21289;
var statearr_21367_21432 = state_21289__$1;
(statearr_21367_21432[(2)] = inst_21148);

(statearr_21367_21432[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21290 === (49))){
var inst_21169 = (state_21289[(30)]);
var state_21289__$1 = state_21289;
var statearr_21368_21433 = state_21289__$1;
(statearr_21368_21433[(2)] = inst_21169);

(statearr_21368_21433[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0 = (function (){
var statearr_21369 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21369[(0)] = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__);

(statearr_21369[(1)] = (1));

return statearr_21369;
});
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1 = (function (state_21289){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21289);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21370){var ex__2730__auto__ = e21370;
var statearr_21371_21434 = state_21289;
(statearr_21371_21434[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21289[(4)]))){
var statearr_21372_21435 = state_21289;
(statearr_21372_21435[(1)] = cljs.core.first((state_21289[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21436 = state_21289;
state_21289 = G__21436;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__ = function(state_21289){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1.call(this,state_21289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21373 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21373[(6)] = c__2749__auto__);

return statearr_21373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.fql_resp.component_follow_QMARK_ = (function fluree$db$query$fql_resp$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql_resp.fuel_flake_transducer = (function fluree$db$query$fql_resp$fuel_flake_transducer(var_args){
var G__21438 = arguments.length;
switch (G__21438) {
case 2:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__21440 = null;
var G__21440__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__21440__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__21440__2 = (function (result,flake){
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__21440 = function(result,flake){
switch(arguments.length){
case 0:
return G__21440__0.call(this);
case 1:
return G__21440__1.call(this,result);
case 2:
return G__21440__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21440.cljs$core$IFn$_invoke$arity$0 = G__21440__0;
G__21440.cljs$core$IFn$_invoke$arity$1 = G__21440__1;
G__21440.cljs$core$IFn$_invoke$arity$2 = G__21440__2;
return G__21440;
})()
});
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql_resp.recur_select_spec = (function fluree$db$query$fql_resp$recur_select_spec(select_spec,flake){
var recur_subject = fluree.db.flake.o(flake);
var recur_pred = fluree.db.flake.p(flake);
var map__21441 = select_spec;
var map__21441__$1 = cljs.core.__destructure_map(map__21441);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21441__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21441__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.flake__GT_recur = (function fluree$db$query$fql_resp$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21555){
var state_val_21556 = (state_21555[(1)]);
if((state_val_21556 === (7))){
var inst_21467 = flakes;
var inst_21468 = cljs.core.seq(inst_21467);
var inst_21469 = cljs.core.first(inst_21468);
var inst_21470 = cljs.core.next(inst_21468);
var inst_21471 = cljs.core.PersistentVector.EMPTY;
var inst_21472 = inst_21467;
var inst_21473 = (0);
var inst_21474 = inst_21471;
var state_21555__$1 = (function (){var statearr_21557 = state_21555;
(statearr_21557[(7)] = inst_21473);

(statearr_21557[(8)] = inst_21469);

(statearr_21557[(9)] = inst_21470);

(statearr_21557[(10)] = inst_21474);

(statearr_21557[(11)] = inst_21472);

return statearr_21557;
})();
var statearr_21558_21624 = state_21555__$1;
(statearr_21558_21624[(2)] = null);

(statearr_21558_21624[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (20))){
var state_21555__$1 = state_21555;
var statearr_21559_21625 = state_21555__$1;
(statearr_21559_21625[(2)] = results);

(statearr_21559_21625[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (27))){
var state_21555__$1 = state_21555;
var statearr_21560_21626 = state_21555__$1;
(statearr_21560_21626[(2)] = null);

(statearr_21560_21626[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (1))){
var state_21555__$1 = state_21555;
var statearr_21561_21627 = state_21555__$1;
(statearr_21561_21627[(2)] = null);

(statearr_21561_21627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (24))){
var state_21555__$1 = state_21555;
var statearr_21562_21628 = state_21555__$1;
(statearr_21562_21628[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (39))){
var inst_21481 = (state_21555[(12)]);
var inst_21536 = (state_21555[(13)]);
var inst_21474 = (state_21555[(10)]);
var inst_21539 = (state_21555[(2)]);
var inst_21540 = fluree.db.util.async.throw_err(inst_21539);
var inst_21541 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21474,inst_21540);
var inst_21472 = inst_21481;
var inst_21473 = inst_21536;
var inst_21474__$1 = inst_21541;
var state_21555__$1 = (function (){var statearr_21564 = state_21555;
(statearr_21564[(7)] = inst_21473);

(statearr_21564[(10)] = inst_21474__$1);

(statearr_21564[(11)] = inst_21472);

return statearr_21564;
})();
var statearr_21565_21629 = state_21555__$1;
(statearr_21565_21629[(2)] = null);

(statearr_21565_21629[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (4))){
var inst_21442 = (state_21555[(2)]);
var state_21555__$1 = state_21555;
var statearr_21566_21630 = state_21555__$1;
(statearr_21566_21630[(2)] = inst_21442);

(statearr_21566_21630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (15))){
var inst_21455 = (state_21555[(14)]);
var state_21555__$1 = state_21555;
var statearr_21567_21631 = state_21555__$1;
(statearr_21567_21631[(2)] = inst_21455);

(statearr_21567_21631[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (21))){
var inst_21451 = (state_21555[(15)]);
var state_21555__$1 = state_21555;
if(cljs.core.truth_(inst_21451)){
var statearr_21568_21632 = state_21555__$1;
(statearr_21568_21632[(1)] = (23));

} else {
var statearr_21569_21633 = state_21555__$1;
(statearr_21569_21633[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (31))){
var inst_21519 = (state_21555[(16)]);
var state_21555__$1 = state_21555;
var statearr_21570_21634 = state_21555__$1;
(statearr_21570_21634[(2)] = inst_21519);

(statearr_21570_21634[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (32))){
var inst_21511 = (state_21555[(17)]);
var inst_21525 = (state_21555[(2)]);
var state_21555__$1 = (function (){var statearr_21571 = state_21555;
(statearr_21571[(18)] = inst_21525);

return statearr_21571;
})();
if(cljs.core.truth_(inst_21511)){
var statearr_21572_21635 = state_21555__$1;
(statearr_21572_21635[(1)] = (33));

} else {
var statearr_21573_21636 = state_21555__$1;
(statearr_21573_21636[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (33))){
var inst_21511 = (state_21555[(17)]);
var state_21555__$1 = state_21555;
var statearr_21574_21637 = state_21555__$1;
(statearr_21574_21637[(2)] = inst_21511);

(statearr_21574_21637[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (13))){
var inst_21491 = (state_21555[(2)]);
var state_21555__$1 = state_21555;
if(cljs.core.truth_(inst_21491)){
var statearr_21576_21638 = state_21555__$1;
(statearr_21576_21638[(1)] = (17));

} else {
var statearr_21577_21639 = state_21555__$1;
(statearr_21577_21639[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (22))){
var inst_21508 = (state_21555[(2)]);
var state_21555__$1 = state_21555;
var statearr_21578_21640 = state_21555__$1;
(statearr_21578_21640[(2)] = inst_21508);

(statearr_21578_21640[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (36))){
var inst_21473 = (state_21555[(7)]);
var inst_21481 = (state_21555[(12)]);
var inst_21474 = (state_21555[(10)]);
var inst_21533 = (inst_21473 + (1));
var tmp21575 = inst_21474;
var inst_21472 = inst_21481;
var inst_21473__$1 = inst_21533;
var inst_21474__$1 = tmp21575;
var state_21555__$1 = (function (){var statearr_21579 = state_21555;
(statearr_21579[(7)] = inst_21473__$1);

(statearr_21579[(10)] = inst_21474__$1);

(statearr_21579[(11)] = inst_21472);

return statearr_21579;
})();
var statearr_21580_21641 = state_21555__$1;
(statearr_21580_21641[(2)] = null);

(statearr_21580_21641[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (29))){
var inst_21518 = (state_21555[(2)]);
var inst_21519 = fluree.db.util.async.throw_err(inst_21518);
var state_21555__$1 = (function (){var statearr_21581 = state_21555;
(statearr_21581[(16)] = inst_21519);

return statearr_21581;
})();
if(cljs.core.truth_(fuel)){
var statearr_21582_21642 = state_21555__$1;
(statearr_21582_21642[(1)] = (30));

} else {
var statearr_21583_21643 = state_21555__$1;
(statearr_21583_21643[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (6))){
var state_21555__$1 = state_21555;
var statearr_21584_21644 = state_21555__$1;
(statearr_21584_21644[(2)] = results);

(statearr_21584_21644[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (28))){
var inst_21504 = (state_21555[(2)]);
var state_21555__$1 = state_21555;
var statearr_21585_21645 = state_21555__$1;
(statearr_21585_21645[(2)] = inst_21504);

(statearr_21585_21645[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (25))){
var inst_21506 = (state_21555[(2)]);
var state_21555__$1 = state_21555;
var statearr_21586_21646 = state_21555__$1;
(statearr_21586_21646[(2)] = inst_21506);

(statearr_21586_21646[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (34))){
var inst_21525 = (state_21555[(18)]);
var inst_21528 = cljs.core.empty_QMARK_(inst_21525);
var state_21555__$1 = state_21555;
var statearr_21587_21647 = state_21555__$1;
(statearr_21587_21647[(2)] = inst_21528);

(statearr_21587_21647[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (17))){
var inst_21474 = (state_21555[(10)]);
var inst_21493 = cljs.core.empty_QMARK_(inst_21474);
var state_21555__$1 = state_21555;
if(inst_21493){
var statearr_21588_21648 = state_21555__$1;
(statearr_21588_21648[(1)] = (20));

} else {
var statearr_21589_21649 = state_21555__$1;
(statearr_21589_21649[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (3))){
var inst_21553 = (state_21555[(2)]);
var state_21555__$1 = state_21555;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21555__$1,inst_21553);
} else {
if((state_val_21556 === (12))){
var inst_21455 = (state_21555[(14)]);
var state_21555__$1 = state_21555;
if(cljs.core.truth_(inst_21455)){
var statearr_21590_21650 = state_21555__$1;
(statearr_21590_21650[(1)] = (14));

} else {
var statearr_21591_21651 = state_21555__$1;
(statearr_21591_21651[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (2))){
var _ = (function (){var statearr_21592 = state_21555;
(statearr_21592[(4)] = cljs.core.cons((5),(state_21555[(4)])));

return statearr_21592;
})();
var inst_21449 = select_spec;
var inst_21450 = cljs.core.__destructure_map(inst_21449);
var inst_21451 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21450,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_21452 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21450,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_21453 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21450,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_21454 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21450,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_21455 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21450,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21456 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_21457 = (inst_21454 > inst_21456);
var state_21555__$1 = (function (){var statearr_21593 = state_21555;
(statearr_21593[(19)] = inst_21453);

(statearr_21593[(14)] = inst_21455);

(statearr_21593[(15)] = inst_21451);

(statearr_21593[(20)] = inst_21452);

return statearr_21593;
})();
if(cljs.core.truth_(inst_21457)){
var statearr_21594_21652 = state_21555__$1;
(statearr_21594_21652[(1)] = (6));

} else {
var statearr_21595_21653 = state_21555__$1;
(statearr_21595_21653[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (23))){
var inst_21474 = (state_21555[(10)]);
var inst_21452 = (state_21555[(20)]);
var inst_21497 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_21452,inst_21474);
var state_21555__$1 = state_21555;
var statearr_21596_21654 = state_21555__$1;
(statearr_21596_21654[(2)] = inst_21497);

(statearr_21596_21654[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (35))){
var inst_21480 = (state_21555[(21)]);
var inst_21530 = (state_21555[(2)]);
var inst_21531 = fluree.db.query.fql_resp.recur_select_spec(select_spec,inst_21480);
var state_21555__$1 = (function (){var statearr_21597 = state_21555;
(statearr_21597[(22)] = inst_21531);

return statearr_21597;
})();
if(cljs.core.truth_(inst_21530)){
var statearr_21598_21655 = state_21555__$1;
(statearr_21598_21655[(1)] = (36));

} else {
var statearr_21599_21656 = state_21555__$1;
(statearr_21599_21656[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (19))){
var inst_21546 = (state_21555[(2)]);
var state_21555__$1 = state_21555;
var statearr_21600_21657 = state_21555__$1;
(statearr_21600_21657[(2)] = inst_21546);

(statearr_21600_21657[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (11))){
var inst_21482 = (state_21555[(23)]);
var state_21555__$1 = state_21555;
var statearr_21602_21658 = state_21555__$1;
(statearr_21602_21658[(2)] = inst_21482);

(statearr_21602_21658[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (9))){
var inst_21480 = (state_21555[(21)]);
var inst_21472 = (state_21555[(11)]);
var inst_21482 = (state_21555[(23)]);
var inst_21479 = cljs.core.seq(inst_21472);
var inst_21480__$1 = cljs.core.first(inst_21479);
var inst_21481 = cljs.core.next(inst_21479);
var inst_21482__$1 = cljs.core.not(inst_21480__$1);
var state_21555__$1 = (function (){var statearr_21603 = state_21555;
(statearr_21603[(12)] = inst_21481);

(statearr_21603[(21)] = inst_21480__$1);

(statearr_21603[(23)] = inst_21482__$1);

return statearr_21603;
})();
if(inst_21482__$1){
var statearr_21604_21659 = state_21555__$1;
(statearr_21604_21659[(1)] = (11));

} else {
var statearr_21605_21660 = state_21555__$1;
(statearr_21605_21660[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (5))){
var _ = (function (){var statearr_21606 = state_21555;
(statearr_21606[(4)] = cljs.core.rest((state_21555[(4)])));

return statearr_21606;
})();
var state_21555__$1 = state_21555;
var ex21601 = (state_21555__$1[(2)]);
var statearr_21607_21661 = state_21555__$1;
(statearr_21607_21661[(5)] = ex21601);


if((ex21601 instanceof Error)){
var statearr_21608_21662 = state_21555__$1;
(statearr_21608_21662[(1)] = (4));

(statearr_21608_21662[(5)] = null);

} else {
throw ex21601;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (14))){
var inst_21473 = (state_21555[(7)]);
var inst_21455 = (state_21555[(14)]);
var inst_21486 = (inst_21473 < inst_21455);
var state_21555__$1 = state_21555;
var statearr_21609_21663 = state_21555__$1;
(statearr_21609_21663[(2)] = inst_21486);

(statearr_21609_21663[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (26))){
var inst_21474 = (state_21555[(10)]);
var inst_21452 = (state_21555[(20)]);
var inst_21500 = cljs.core.first(inst_21474);
var inst_21501 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_21452,inst_21500);
var state_21555__$1 = state_21555;
var statearr_21610_21664 = state_21555__$1;
(statearr_21610_21664[(2)] = inst_21501);

(statearr_21610_21664[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (16))){
var inst_21489 = (state_21555[(2)]);
var state_21555__$1 = state_21555;
var statearr_21611_21665 = state_21555__$1;
(statearr_21611_21665[(2)] = inst_21489);

(statearr_21611_21665[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (38))){
var inst_21544 = (state_21555[(2)]);
var state_21555__$1 = state_21555;
var statearr_21612_21666 = state_21555__$1;
(statearr_21612_21666[(2)] = inst_21544);

(statearr_21612_21666[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (30))){
var inst_21519 = (state_21555[(16)]);
var inst_21521 = fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_21522 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_21521,inst_21519);
var state_21555__$1 = state_21555;
var statearr_21613_21667 = state_21555__$1;
(statearr_21613_21667[(2)] = inst_21522);

(statearr_21613_21667[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (10))){
var inst_21548 = (state_21555[(2)]);
var state_21555__$1 = state_21555;
var statearr_21614_21668 = state_21555__$1;
(statearr_21614_21668[(2)] = inst_21548);

(statearr_21614_21668[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21556 === (18))){
var inst_21480 = (state_21555[(21)]);
var inst_21453 = (state_21555[(19)]);
var inst_21510 = fluree.db.flake.o(inst_21480);
var inst_21511 = cljs.core.contains_QMARK_(inst_21453,inst_21510);
var inst_21513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21514 = [inst_21510];
var inst_21515 = (new cljs.core.PersistentVector(null,1,(5),inst_21513,inst_21514,null));
var inst_21516 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21515);
var state_21555__$1 = (function (){var statearr_21615 = state_21555;
(statearr_21615[(17)] = inst_21511);

return statearr_21615;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21555__$1,(29),inst_21516);
} else {
if((state_val_21556 === (37))){
var inst_21531 = (state_21555[(22)]);
var inst_21473 = (state_21555[(7)]);
var inst_21525 = (state_21555[(18)]);
var inst_21536 = (inst_21473 + (1));
var inst_21537 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_21531,inst_21525) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_21531,inst_21525));
var state_21555__$1 = (function (){var statearr_21616 = state_21555;
(statearr_21616[(13)] = inst_21536);

return statearr_21616;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21555__$1,(39),inst_21537);
} else {
if((state_val_21556 === (8))){
var inst_21550 = (state_21555[(2)]);
var _ = (function (){var statearr_21617 = state_21555;
(statearr_21617[(4)] = cljs.core.rest((state_21555[(4)])));

return statearr_21617;
})();
var state_21555__$1 = state_21555;
var statearr_21618_21669 = state_21555__$1;
(statearr_21618_21669[(2)] = inst_21550);

(statearr_21618_21669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0 = (function (){
var statearr_21619 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21619[(0)] = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__);

(statearr_21619[(1)] = (1));

return statearr_21619;
});
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1 = (function (state_21555){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21555);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21620){var ex__2730__auto__ = e21620;
var statearr_21621_21670 = state_21555;
(statearr_21621_21670[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21555[(4)]))){
var statearr_21622_21671 = state_21555;
(statearr_21622_21671[(1)] = cljs.core.first((state_21555[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21672 = state_21555;
state_21555 = G__21672;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__ = function(state_21555){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1.call(this,state_21555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21623 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21623[(6)] = c__2749__auto__);

return statearr_21623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql_resp.wildcard_pred_spec = (function fluree$db$query$fql_resp$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4253__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.add_pred = (function fluree$db$query$fql_resp$add_pred(var_args){
var G__21676 = arguments.length;
switch (G__21676) {
case 9:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22115){
var state_val_22116 = (state_22115[(1)]);
if((state_val_22116 === (121))){
var inst_22038 = (state_22115[(2)]);
var inst_22039 = fluree.db.util.async.throw_err(inst_22038);
var inst_22040 = cljs.core.seq(inst_22039);
var state_22115__$1 = state_22115;
if(inst_22040){
var statearr_22117_22331 = state_22115__$1;
(statearr_22117_22331[(1)] = (122));

} else {
var statearr_22118_22332 = state_22115__$1;
(statearr_22118_22332[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (65))){
var inst_21831 = (state_22115[(7)]);
var inst_21830 = (state_22115[(2)]);
var inst_21831__$1 = fluree.db.util.async.throw_err(inst_21830);
var inst_21832 = cljs.core.seq(inst_21831__$1);
var state_22115__$1 = (function (){var statearr_22119 = state_22115;
(statearr_22119[(7)] = inst_21831__$1);

return statearr_22119;
})();
if(inst_21832){
var statearr_22120_22333 = state_22115__$1;
(statearr_22120_22333[(1)] = (66));

} else {
var statearr_22121_22334 = state_22115__$1;
(statearr_22121_22334[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (70))){
var inst_21831 = (state_22115[(7)]);
var inst_21842 = cljs.core.count(inst_21831);
var inst_21843 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_21842);
var state_22115__$1 = state_22115;
var statearr_22122_22335 = state_22115__$1;
(statearr_22122_22335[(2)] = inst_21843);

(statearr_22122_22335[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (62))){
var inst_21821 = (state_22115[(8)]);
var inst_21824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21825 = fluree.db.flake.o(inst_21821);
var inst_21826 = [inst_21825];
var inst_21827 = (new cljs.core.PersistentVector(null,1,(5),inst_21824,inst_21826,null));
var inst_21828 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21827);
var state_22115__$1 = state_22115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22115__$1,(65),inst_21828);
} else {
if((state_val_22116 === (74))){
var inst_21815 = (state_22115[(9)]);
var state_22115__$1 = state_22115;
var statearr_22123_22336 = state_22115__$1;
(statearr_22123_22336[(2)] = inst_21815);

(statearr_22123_22336[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (110))){
var inst_22000 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_22001 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_22000);
var inst_22002 = inst_22001 === true;
var state_22115__$1 = state_22115;
if(cljs.core.truth_(inst_22002)){
var statearr_22124_22337 = state_22115__$1;
(statearr_22124_22337[(1)] = (113));

} else {
var statearr_22125_22338 = state_22115__$1;
(statearr_22125_22338[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (130))){
var inst_22110 = (state_22115[(2)]);
var _ = (function (){var statearr_22126 = state_22115;
(statearr_22126[(4)] = cljs.core.rest((state_22115[(4)])));

return statearr_22126;
})();
var state_22115__$1 = state_22115;
var statearr_22127_22339 = state_22115__$1;
(statearr_22127_22339[(2)] = inst_22110);

(statearr_22127_22339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (128))){
var inst_22085 = (state_22115[(10)]);
var inst_22088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22089 = [acc,inst_22085];
var inst_22090 = (new cljs.core.PersistentVector(null,2,(5),inst_22088,inst_22089,null));
var state_22115__$1 = state_22115;
var statearr_22128_22340 = state_22115__$1;
(statearr_22128_22340[(2)] = inst_22090);

(statearr_22128_22340[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (7))){
var inst_21688 = (state_22115[(11)]);
var state_22115__$1 = state_22115;
var statearr_22129_22341 = state_22115__$1;
(statearr_22129_22341[(2)] = inst_21688);

(statearr_22129_22341[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (59))){
var inst_22079 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22130_22342 = state_22115__$1;
(statearr_22130_22342[(2)] = inst_22079);

(statearr_22130_22342[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (86))){
var inst_21909 = (state_22115[(12)]);
var inst_21909__$1 = (state_22115[(2)]);
var state_22115__$1 = (function (){var statearr_22131 = state_22115;
(statearr_22131[(12)] = inst_21909__$1);

return statearr_22131;
})();
if(cljs.core.truth_(inst_21909__$1)){
var statearr_22132_22343 = state_22115__$1;
(statearr_22132_22343[(1)] = (88));

} else {
var statearr_22133_22344 = state_22115__$1;
(statearr_22133_22344[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (20))){
var inst_21717 = (state_22115[(13)]);
var inst_21730 = (state_22115[(14)]);
var inst_21729 = (state_22115[(15)]);
var inst_21728 = (state_22115[(2)]);
var inst_21729__$1 = cljs.core.__destructure_map(inst_21717);
var inst_21730__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21729__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_21731 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21729__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_21732 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21729__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21733 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21729__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_21734 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21729__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21729__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22115__$1 = (function (){var statearr_22134 = state_22115;
(statearr_22134[(14)] = inst_21730__$1);

(statearr_22134[(16)] = inst_21731);

(statearr_22134[(17)] = inst_21733);

(statearr_22134[(15)] = inst_21729__$1);

(statearr_22134[(18)] = inst_21728);

(statearr_22134[(19)] = inst_21735);

(statearr_22134[(20)] = inst_21732);

(statearr_22134[(21)] = inst_21734);

return statearr_22134;
})();
if(cljs.core.truth_(inst_21730__$1)){
var statearr_22135_22345 = state_22115__$1;
(statearr_22135_22345[(1)] = (24));

} else {
var statearr_22136_22346 = state_22115__$1;
(statearr_22136_22346[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (72))){
var inst_21840 = (state_22115[(22)]);
var inst_21846 = (state_22115[(2)]);
var inst_21847 = cljs.core.seq(inst_21840);
var state_22115__$1 = (function (){var statearr_22137 = state_22115;
(statearr_22137[(23)] = inst_21846);

return statearr_22137;
})();
if(inst_21847){
var statearr_22138_22347 = state_22115__$1;
(statearr_22138_22347[(1)] = (73));

} else {
var statearr_22139_22348 = state_22115__$1;
(statearr_22139_22348[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (58))){
var inst_21717 = (state_22115[(13)]);
var inst_21862 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_21717);
var state_22115__$1 = state_22115;
if(cljs.core.truth_(inst_21862)){
var statearr_22140_22349 = state_22115__$1;
(statearr_22140_22349[(1)] = (76));

} else {
var statearr_22141_22350 = state_22115__$1;
(statearr_22141_22350[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (60))){
var inst_21814 = (state_22115[(24)]);
var inst_21821 = (state_22115[(8)]);
var inst_21820 = cljs.core.seq(inst_21814);
var inst_21821__$1 = cljs.core.first(inst_21820);
var inst_21822 = cljs.core.next(inst_21820);
var state_22115__$1 = (function (){var statearr_22142 = state_22115;
(statearr_22142[(25)] = inst_21822);

(statearr_22142[(8)] = inst_21821__$1);

return statearr_22142;
})();
if(cljs.core.truth_(inst_21821__$1)){
var statearr_22143_22351 = state_22115__$1;
(statearr_22143_22351[(1)] = (62));

} else {
var statearr_22144_22352 = state_22115__$1;
(statearr_22144_22352[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (27))){
var inst_21734 = (state_22115[(21)]);
var inst_21738 = (state_22115[(26)]);
var inst_21738__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_21734);
var state_22115__$1 = (function (){var statearr_22145 = state_22115;
(statearr_22145[(26)] = inst_21738__$1);

return statearr_22145;
})();
if(inst_21738__$1){
var statearr_22146_22353 = state_22115__$1;
(statearr_22146_22353[(1)] = (30));

} else {
var statearr_22147_22354 = state_22115__$1;
(statearr_22147_22354[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (1))){
var state_22115__$1 = state_22115;
var statearr_22148_22355 = state_22115__$1;
(statearr_22148_22355[(2)] = null);

(statearr_22148_22355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (69))){
var inst_21836 = (state_22115[(2)]);
var inst_21837 = fluree.db.util.async.throw_err(inst_21836);
var state_22115__$1 = state_22115;
var statearr_22149_22356 = state_22115__$1;
(statearr_22149_22356[(2)] = inst_21837);

(statearr_22149_22356[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (101))){
var inst_21993 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22150_22357 = state_22115__$1;
(statearr_22150_22357[(2)] = inst_21993);

(statearr_22150_22357[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (24))){
var inst_21734 = (state_22115[(21)]);
var state_22115__$1 = state_22115;
if(cljs.core.truth_(inst_21734)){
var statearr_22151_22358 = state_22115__$1;
(statearr_22151_22358[(1)] = (27));

} else {
var statearr_22152_22359 = state_22115__$1;
(statearr_22152_22359[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (102))){
var inst_21965 = (state_22115[(27)]);
var inst_21964 = (state_22115[(2)]);
var inst_21965__$1 = fluree.db.util.async.throw_err(inst_21964);
var inst_21966 = cljs.core.empty_QMARK_(inst_21965__$1);
var state_22115__$1 = (function (){var statearr_22153 = state_22115;
(statearr_22153[(27)] = inst_21965__$1);

return statearr_22153;
})();
if(inst_21966){
var statearr_22154_22360 = state_22115__$1;
(statearr_22154_22360[(1)] = (103));

} else {
var statearr_22155_22361 = state_22115__$1;
(statearr_22155_22361[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (135))){
var state_22115__$1 = state_22115;
var statearr_22156_22362 = state_22115__$1;
(statearr_22156_22362[(2)] = null);

(statearr_22156_22362[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (55))){
var inst_21717 = (state_22115[(13)]);
var inst_21790 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_21717);
var state_22115__$1 = state_22115;
var statearr_22157_22363 = state_22115__$1;
(statearr_22157_22363[(2)] = inst_21790);

(statearr_22157_22363[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (85))){
var inst_21717 = (state_22115[(13)]);
var inst_21884 = (state_22115[(28)]);
var inst_21896 = fluree.db.flake.o(inst_21884);
var inst_21897 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21717);
var inst_21898 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_21896,inst_21897);
var state_22115__$1 = state_22115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22115__$1,(87),inst_21898);
} else {
if((state_val_22116 === (39))){
var inst_21733 = (state_22115[(17)]);
var inst_21765 = (state_22115[(29)]);
var inst_21765__$1 = cljs.core.not(inst_21733);
var state_22115__$1 = (function (){var statearr_22158 = state_22115;
(statearr_22158[(29)] = inst_21765__$1);

return statearr_22158;
})();
if(inst_21765__$1){
var statearr_22159_22364 = state_22115__$1;
(statearr_22159_22364[(1)] = (42));

} else {
var statearr_22160_22365 = state_22115__$1;
(statearr_22160_22365[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (88))){
var inst_21909 = (state_22115[(12)]);
var inst_21878 = (state_22115[(30)]);
var inst_21911 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21878,inst_21909);
var state_22115__$1 = state_22115;
var statearr_22161_22366 = state_22115__$1;
(statearr_22161_22366[(2)] = inst_21911);

(statearr_22161_22366[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (46))){
var inst_21732 = (state_22115[(20)]);
var state_22115__$1 = state_22115;
var statearr_22162_22367 = state_22115__$1;
(statearr_22162_22367[(2)] = inst_21732);

(statearr_22162_22367[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (4))){
var inst_21677 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22163_22368 = state_22115__$1;
(statearr_22163_22368[(2)] = inst_21677);

(statearr_22163_22368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (77))){
var inst_21924 = (state_22115[(31)]);
var inst_21924__$1 = componentFollow_QMARK_;
var state_22115__$1 = (function (){var statearr_22164 = state_22115;
(statearr_22164[(31)] = inst_21924__$1);

return statearr_22164;
})();
if(cljs.core.truth_(inst_21924__$1)){
var statearr_22165_22369 = state_22115__$1;
(statearr_22165_22369[(1)] = (91));

} else {
var statearr_22166_22370 = state_22115__$1;
(statearr_22166_22370[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (106))){
var inst_21945 = (state_22115[(32)]);
var inst_21979 = (state_22115[(2)]);
var inst_21980 = fluree.db.util.async.throw_err(inst_21979);
var inst_21981 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21945,inst_21980);
var state_22115__$1 = state_22115;
var statearr_22167_22371 = state_22115__$1;
(statearr_22167_22371[(2)] = inst_21981);

(statearr_22167_22371[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (119))){
var inst_22023 = (state_22115[(33)]);
var inst_22053 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22054 = [inst_22023,offset_map];
var inst_22055 = (new cljs.core.PersistentVector(null,2,(5),inst_22053,inst_22054,null));
var state_22115__$1 = state_22115;
var statearr_22168_22372 = state_22115__$1;
(statearr_22168_22372[(2)] = inst_22055);

(statearr_22168_22372[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (95))){
var inst_21731 = (state_22115[(16)]);
var state_22115__$1 = state_22115;
if(cljs.core.truth_(inst_21731)){
var statearr_22169_22373 = state_22115__$1;
(statearr_22169_22373[(1)] = (110));

} else {
var statearr_22170_22374 = state_22115__$1;
(statearr_22170_22374[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (54))){
var inst_21787 = (state_22115[(34)]);
var state_22115__$1 = state_22115;
var statearr_22171_22375 = state_22115__$1;
(statearr_22171_22375[(2)] = inst_21787);

(statearr_22171_22375[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (92))){
var inst_21924 = (state_22115[(31)]);
var state_22115__$1 = state_22115;
var statearr_22172_22376 = state_22115__$1;
(statearr_22172_22376[(2)] = inst_21924);

(statearr_22172_22376[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (104))){
var inst_21687 = (state_22115[(35)]);
var inst_21965 = (state_22115[(27)]);
var inst_21974 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_21975 = [true,inst_21687];
var inst_21976 = cljs.core.PersistentHashMap.fromArrays(inst_21974,inst_21975);
var inst_21977 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_21976,inst_21965) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_21976,inst_21965));
var state_22115__$1 = state_22115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22115__$1,(106),inst_21977);
} else {
if((state_val_22116 === (15))){
var inst_21687 = (state_22115[(35)]);
var inst_21710 = (state_22115[(36)]);
var inst_21714 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21710,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_21687);
var state_22115__$1 = state_22115;
var statearr_22173_22377 = state_22115__$1;
(statearr_22173_22377[(2)] = inst_21714);

(statearr_22173_22377[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (48))){
var inst_21781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21782 = [null,offset_map];
var inst_21783 = (new cljs.core.PersistentVector(null,2,(5),inst_21781,inst_21782,null));
var state_22115__$1 = state_22115;
var statearr_22174_22378 = state_22115__$1;
(statearr_22174_22378[(2)] = inst_21783);

(statearr_22174_22378[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (50))){
var inst_22081 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22175_22379 = state_22115__$1;
(statearr_22175_22379[(2)] = inst_22081);

(statearr_22175_22379[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (116))){
var inst_22022 = (state_22115[(37)]);
var inst_22029 = (state_22115[(38)]);
var inst_22028 = cljs.core.seq(inst_22022);
var inst_22029__$1 = cljs.core.first(inst_22028);
var inst_22030 = cljs.core.next(inst_22028);
var state_22115__$1 = (function (){var statearr_22176 = state_22115;
(statearr_22176[(39)] = inst_22030);

(statearr_22176[(38)] = inst_22029__$1);

return statearr_22176;
})();
if(cljs.core.truth_(inst_22029__$1)){
var statearr_22177_22380 = state_22115__$1;
(statearr_22177_22380[(1)] = (118));

} else {
var statearr_22178_22381 = state_22115__$1;
(statearr_22178_22381[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (75))){
var inst_21822 = (state_22115[(25)]);
var inst_21852 = (state_22115[(2)]);
var inst_21814 = inst_21822;
var inst_21815 = inst_21852;
var state_22115__$1 = (function (){var statearr_22179 = state_22115;
(statearr_22179[(9)] = inst_21815);

(statearr_22179[(24)] = inst_21814);

return statearr_22179;
})();
var statearr_22180_22382 = state_22115__$1;
(statearr_22180_22382[(2)] = null);

(statearr_22180_22382[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (99))){
var inst_21717 = (state_22115[(13)]);
var inst_21951 = (state_22115[(40)]);
var inst_21954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21955 = fluree.db.flake.o(inst_21951);
var inst_21956 = [inst_21955];
var inst_21957 = (new cljs.core.PersistentVector(null,1,(5),inst_21954,inst_21956,null));
var inst_21958 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_21959 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_21717);
var inst_21960 = [inst_21959];
var inst_21961 = cljs.core.PersistentHashMap.fromArrays(inst_21958,inst_21960);
var inst_21962 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21957,inst_21961);
var state_22115__$1 = state_22115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22115__$1,(102),inst_21962);
} else {
if((state_val_22116 === (21))){
var inst_21721 = (state_22115[(41)]);
var state_22115__$1 = state_22115;
var statearr_22181_22383 = state_22115__$1;
(statearr_22181_22383[(2)] = inst_21721);

(statearr_22181_22383[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (31))){
var inst_21738 = (state_22115[(26)]);
var state_22115__$1 = state_22115;
var statearr_22182_22384 = state_22115__$1;
(statearr_22182_22384[(2)] = inst_21738);

(statearr_22182_22384[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (113))){
var inst_21717 = (state_22115[(13)]);
var inst_21730 = (state_22115[(14)]);
var inst_21687 = (state_22115[(35)]);
var inst_21702 = (state_22115[(42)]);
var inst_21731 = (state_22115[(16)]);
var inst_21733 = (state_22115[(17)]);
var inst_21729 = (state_22115[(15)]);
var inst_21728 = (state_22115[(18)]);
var inst_21735 = (state_22115[(19)]);
var inst_21732 = (state_22115[(20)]);
var inst_21734 = (state_22115[(21)]);
var inst_22004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22005 = (function (){var map__21683 = inst_21729;
var p = inst_21735;
var pred_spec__$1 = inst_21702;
var orderBy = inst_21733;
var multi_QMARK_ = inst_21730;
var limit = inst_21732;
var offset = inst_21734;
var k = inst_21728;
var compact_QMARK_ = inst_21687;
var pred_spec_SINGLEQUOTE_ = inst_21717;
var ref_QMARK_ = inst_21731;
return (function (p1__21673_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[fluree.db.flake.o(p1__21673_SHARP_)]);
});
})();
var inst_22006 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22005,flakes);
var inst_22007 = [inst_22006,offset_map];
var inst_22008 = (new cljs.core.PersistentVector(null,2,(5),inst_22004,inst_22007,null));
var state_22115__$1 = state_22115;
var statearr_22183_22385 = state_22115__$1;
(statearr_22183_22385[(2)] = inst_22008);

(statearr_22183_22385[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (32))){
var inst_21744 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22184_22386 = state_22115__$1;
(statearr_22184_22386[(2)] = inst_21744);

(statearr_22184_22386[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (136))){
var inst_22106 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22185_22387 = state_22115__$1;
(statearr_22185_22387[(2)] = inst_22106);

(statearr_22185_22387[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (40))){
var inst_21730 = (state_22115[(14)]);
var state_22115__$1 = state_22115;
var statearr_22186_22388 = state_22115__$1;
(statearr_22186_22388[(2)] = inst_21730);

(statearr_22186_22388[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (129))){
var inst_21730 = (state_22115[(14)]);
var state_22115__$1 = state_22115;
if(cljs.core.truth_(inst_21730)){
var statearr_22187_22389 = state_22115__$1;
(statearr_22187_22389[(1)] = (131));

} else {
var statearr_22188_22390 = state_22115__$1;
(statearr_22188_22390[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (91))){
var inst_21717 = (state_22115[(13)]);
var inst_21926 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_21717);
var state_22115__$1 = state_22115;
var statearr_22189_22391 = state_22115__$1;
(statearr_22189_22391[(2)] = inst_21926);

(statearr_22189_22391[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (117))){
var inst_22059 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22190_22392 = state_22115__$1;
(statearr_22190_22392[(2)] = inst_22059);

(statearr_22190_22392[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (108))){
var state_22115__$1 = state_22115;
var statearr_22191_22393 = state_22115__$1;
(statearr_22191_22393[(2)] = null);

(statearr_22191_22393[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (56))){
var inst_21792 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22192_22394 = state_22115__$1;
(statearr_22192_22394[(2)] = inst_21792);

(statearr_22192_22394[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (33))){
var inst_21735 = (state_22115[(19)]);
var inst_21752 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21753 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_21735);
var state_22115__$1 = (function (){var statearr_22193 = state_22115;
(statearr_22193[(43)] = inst_21752);

return statearr_22193;
})();
if(cljs.core.truth_(inst_21753)){
var statearr_22194_22395 = state_22115__$1;
(statearr_22194_22395[(1)] = (36));

} else {
var statearr_22195_22396 = state_22115__$1;
(statearr_22195_22396[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (13))){
var inst_21702 = (state_22115[(42)]);
var state_22115__$1 = state_22115;
var statearr_22196_22397 = state_22115__$1;
(statearr_22196_22397[(2)] = inst_21702);

(statearr_22196_22397[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (22))){
var inst_21717 = (state_22115[(13)]);
var inst_21724 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_21717);
var state_22115__$1 = state_22115;
var statearr_22197_22398 = state_22115__$1;
(statearr_22197_22398[(2)] = inst_21724);

(statearr_22197_22398[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (90))){
var inst_21885 = (state_22115[(44)]);
var inst_21914 = (state_22115[(2)]);
var inst_21877 = inst_21885;
var inst_21878 = inst_21914;
var state_22115__$1 = (function (){var statearr_22198 = state_22115;
(statearr_22198[(45)] = inst_21877);

(statearr_22198[(30)] = inst_21878);

return statearr_22198;
})();
var statearr_22199_22399 = state_22115__$1;
(statearr_22199_22399[(2)] = null);

(statearr_22199_22399[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (109))){
var inst_21952 = (state_22115[(46)]);
var inst_21983 = (state_22115[(47)]);
var inst_21989 = (state_22115[(2)]);
var inst_21944 = inst_21952;
var inst_21945 = inst_21983;
var state_22115__$1 = (function (){var statearr_22200 = state_22115;
(statearr_22200[(48)] = inst_21989);

(statearr_22200[(32)] = inst_21945);

(statearr_22200[(49)] = inst_21944);

return statearr_22200;
})();
var statearr_22201_22400 = state_22115__$1;
(statearr_22201_22400[(2)] = null);

(statearr_22201_22400[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (36))){
var inst_21735 = (state_22115[(19)]);
var inst_21755 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_21735,cljs.core.dec);
var state_22115__$1 = state_22115;
var statearr_22202_22401 = state_22115__$1;
(statearr_22202_22401[(2)] = inst_21755);

(statearr_22202_22401[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (41))){
var inst_21779 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
if(cljs.core.truth_(inst_21779)){
var statearr_22203_22402 = state_22115__$1;
(statearr_22203_22402[(1)] = (48));

} else {
var statearr_22204_22403 = state_22115__$1;
(statearr_22204_22403[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (118))){
var inst_22029 = (state_22115[(38)]);
var inst_22032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22033 = fluree.db.flake.o(inst_22029);
var inst_22034 = [inst_22033];
var inst_22035 = (new cljs.core.PersistentVector(null,1,(5),inst_22032,inst_22034,null));
var inst_22036 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22035);
var state_22115__$1 = state_22115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22115__$1,(121),inst_22036);
} else {
if((state_val_22116 === (89))){
var inst_21878 = (state_22115[(30)]);
var state_22115__$1 = state_22115;
var statearr_22205_22404 = state_22115__$1;
(statearr_22205_22404[(2)] = inst_21878);

(statearr_22205_22404[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (100))){
var inst_21945 = (state_22115[(32)]);
var state_22115__$1 = state_22115;
var statearr_22206_22405 = state_22115__$1;
(statearr_22206_22405[(2)] = inst_21945);

(statearr_22206_22405[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (131))){
var inst_22085 = (state_22115[(10)]);
var inst_21728 = (state_22115[(18)]);
var inst_22084 = (state_22115[(50)]);
var inst_22093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22094 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_21728,inst_22084);
var inst_22095 = [inst_22094,inst_22085];
var inst_22096 = (new cljs.core.PersistentVector(null,2,(5),inst_22093,inst_22095,null));
var state_22115__$1 = state_22115;
var statearr_22207_22406 = state_22115__$1;
(statearr_22207_22406[(2)] = inst_22096);

(statearr_22207_22406[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (122))){
var inst_22023 = (state_22115[(33)]);
var inst_22030 = (state_22115[(39)]);
var inst_22029 = (state_22115[(38)]);
var inst_22042 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22043 = fluree.db.flake.o(inst_22029);
var inst_22044 = [inst_22043];
var inst_22045 = cljs.core.PersistentHashMap.fromArrays(inst_22042,inst_22044);
var inst_22046 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22023,inst_22045);
var inst_22022 = inst_22030;
var inst_22023__$1 = inst_22046;
var state_22115__$1 = (function (){var statearr_22208 = state_22115;
(statearr_22208[(33)] = inst_22023__$1);

(statearr_22208[(37)] = inst_22022);

return statearr_22208;
})();
var statearr_22209_22407 = state_22115__$1;
(statearr_22209_22407[(2)] = null);

(statearr_22209_22407[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (43))){
var inst_21765 = (state_22115[(29)]);
var state_22115__$1 = state_22115;
var statearr_22210_22408 = state_22115__$1;
(statearr_22210_22408[(2)] = inst_21765);

(statearr_22210_22408[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (61))){
var inst_21801 = (state_22115[(51)]);
var inst_21858 = (state_22115[(2)]);
var inst_21859 = [inst_21858,offset_map];
var inst_21860 = (new cljs.core.PersistentVector(null,2,(5),inst_21801,inst_21859,null));
var state_22115__$1 = state_22115;
var statearr_22211_22409 = state_22115__$1;
(statearr_22211_22409[(2)] = inst_21860);

(statearr_22211_22409[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (29))){
var inst_21747 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22212_22410 = state_22115__$1;
(statearr_22212_22410[(2)] = inst_21747);

(statearr_22212_22410[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (44))){
var inst_21776 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22213_22411 = state_22115__$1;
(statearr_22213_22411[(2)] = inst_21776);

(statearr_22213_22411[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (93))){
var inst_21929 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
if(cljs.core.truth_(inst_21929)){
var statearr_22214_22412 = state_22115__$1;
(statearr_22214_22412[(1)] = (94));

} else {
var statearr_22215_22413 = state_22115__$1;
(statearr_22215_22413[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (6))){
var inst_21690 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_21691 = (inst_21690 == null);
var state_22115__$1 = state_22115;
var statearr_22216_22414 = state_22115__$1;
(statearr_22216_22414[(2)] = inst_21691);

(statearr_22216_22414[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (111))){
var state_22115__$1 = state_22115;
var statearr_22217_22415 = state_22115__$1;
(statearr_22217_22415[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (28))){
var inst_21734 = (state_22115[(21)]);
var state_22115__$1 = state_22115;
var statearr_22219_22416 = state_22115__$1;
(statearr_22219_22416[(2)] = inst_21734);

(statearr_22219_22416[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (134))){
var inst_22085 = (state_22115[(10)]);
var inst_21728 = (state_22115[(18)]);
var inst_22084 = (state_22115[(50)]);
var inst_22099 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22100 = cljs.core.first(inst_22084);
var inst_22101 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_21728,inst_22100);
var inst_22102 = [inst_22101,inst_22085];
var inst_22103 = (new cljs.core.PersistentVector(null,2,(5),inst_22099,inst_22102,null));
var state_22115__$1 = state_22115;
var statearr_22220_22417 = state_22115__$1;
(statearr_22220_22417[(2)] = inst_22103);

(statearr_22220_22417[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (64))){
var inst_21856 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22221_22418 = state_22115__$1;
(statearr_22221_22418[(2)] = inst_21856);

(statearr_22221_22418[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (103))){
var inst_21945 = (state_22115[(32)]);
var inst_21951 = (state_22115[(40)]);
var inst_21968 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_21969 = fluree.db.flake.o(inst_21951);
var inst_21970 = [inst_21969];
var inst_21971 = cljs.core.PersistentHashMap.fromArrays(inst_21968,inst_21970);
var inst_21972 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21945,inst_21971);
var state_22115__$1 = state_22115;
var statearr_22222_22419 = state_22115__$1;
(statearr_22222_22419[(2)] = inst_21972);

(statearr_22222_22419[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (51))){
var inst_21717 = (state_22115[(13)]);
var inst_21787 = (state_22115[(34)]);
var inst_21787__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_21717);
var state_22115__$1 = (function (){var statearr_22223 = state_22115;
(statearr_22223[(34)] = inst_21787__$1);

return statearr_22223;
})();
if(cljs.core.truth_(inst_21787__$1)){
var statearr_22224_22420 = state_22115__$1;
(statearr_22224_22420[(1)] = (54));

} else {
var statearr_22225_22421 = state_22115__$1;
(statearr_22225_22421[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (25))){
var inst_21730 = (state_22115[(14)]);
var state_22115__$1 = state_22115;
var statearr_22226_22422 = state_22115__$1;
(statearr_22226_22422[(2)] = inst_21730);

(statearr_22226_22422[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (34))){
var inst_21730 = (state_22115[(14)]);
var state_22115__$1 = state_22115;
if(cljs.core.truth_(inst_21730)){
var statearr_22227_22423 = state_22115__$1;
(statearr_22227_22423[(1)] = (39));

} else {
var statearr_22228_22424 = state_22115__$1;
(statearr_22228_22424[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (125))){
var inst_21717 = (state_22115[(13)]);
var inst_21730 = (state_22115[(14)]);
var inst_21687 = (state_22115[(35)]);
var inst_21702 = (state_22115[(42)]);
var inst_21731 = (state_22115[(16)]);
var inst_21733 = (state_22115[(17)]);
var inst_21729 = (state_22115[(15)]);
var inst_21728 = (state_22115[(18)]);
var inst_21735 = (state_22115[(19)]);
var inst_21732 = (state_22115[(20)]);
var inst_21734 = (state_22115[(21)]);
var inst_22064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22065 = (function (){var map__21683 = inst_21729;
var p = inst_21735;
var pred_spec__$1 = inst_21702;
var orderBy = inst_21733;
var multi_QMARK_ = inst_21730;
var limit = inst_21732;
var offset = inst_21734;
var k = inst_21728;
var compact_QMARK_ = inst_21687;
var pred_spec_SINGLEQUOTE_ = inst_21717;
var ref_QMARK_ = inst_21731;
return (function (p1__21674_SHARP_){
return fluree.db.flake.o(p1__21674_SHARP_);
});
})();
var inst_22066 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22065,flakes);
var inst_22067 = [inst_22066,offset_map];
var inst_22068 = (new cljs.core.PersistentVector(null,2,(5),inst_22064,inst_22067,null));
var state_22115__$1 = state_22115;
var statearr_22229_22425 = state_22115__$1;
(statearr_22229_22425[(2)] = inst_22068);

(statearr_22229_22425[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (17))){
var inst_21717 = (state_22115[(13)]);
var inst_21718 = (state_22115[(52)]);
var inst_21717__$1 = (state_22115[(2)]);
var inst_21718__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_21717__$1);
var state_22115__$1 = (function (){var statearr_22230 = state_22115;
(statearr_22230[(13)] = inst_21717__$1);

(statearr_22230[(52)] = inst_21718__$1);

return statearr_22230;
})();
if(cljs.core.truth_(inst_21718__$1)){
var statearr_22231_22426 = state_22115__$1;
(statearr_22231_22426[(1)] = (18));

} else {
var statearr_22232_22427 = state_22115__$1;
(statearr_22232_22427[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (3))){
var inst_22113 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22115__$1,inst_22113);
} else {
if((state_val_22116 === (12))){
var inst_21702 = (state_22115[(42)]);
var inst_21707 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21702,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22115__$1 = state_22115;
var statearr_22233_22428 = state_22115__$1;
(statearr_22233_22428[(2)] = inst_21707);

(statearr_22233_22428[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (2))){
var inst_21688 = (state_22115[(11)]);
var _ = (function (){var statearr_22234 = state_22115;
(statearr_22234[(4)] = cljs.core.cons((5),(state_22115[(4)])));

return statearr_22234;
})();
var inst_21687 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_21688__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22115__$1 = (function (){var statearr_22235 = state_22115;
(statearr_22235[(35)] = inst_21687);

(statearr_22235[(11)] = inst_21688__$1);

return statearr_22235;
})();
if(cljs.core.truth_(inst_21688__$1)){
var statearr_22236_22429 = state_22115__$1;
(statearr_22236_22429[(1)] = (6));

} else {
var statearr_22237_22430 = state_22115__$1;
(statearr_22237_22430[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (66))){
var inst_21831 = (state_22115[(7)]);
var inst_21800 = (state_22115[(53)]);
var inst_21834 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_21800,inst_21831) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_21800,inst_21831));
var state_22115__$1 = state_22115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22115__$1,(69),inst_21834);
} else {
if((state_val_22116 === (107))){
var inst_21965 = (state_22115[(27)]);
var inst_21985 = cljs.core.count(inst_21965);
var inst_21986 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_21985);
var state_22115__$1 = state_22115;
var statearr_22238_22431 = state_22115__$1;
(statearr_22238_22431[(2)] = inst_21986);

(statearr_22238_22431[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (23))){
var inst_21726 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22239_22432 = state_22115__$1;
(statearr_22239_22432[(2)] = inst_21726);

(statearr_22239_22432[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (47))){
var inst_21773 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22240_22433 = state_22115__$1;
(statearr_22240_22433[(2)] = inst_21773);

(statearr_22240_22433[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (35))){
var inst_22084 = (state_22115[(50)]);
var inst_22083 = (state_22115[(2)]);
var inst_22084__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22083,(0),null);
var inst_22085 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22083,(1),null);
var inst_22086 = cljs.core.empty_QMARK_(inst_22084__$1);
var state_22115__$1 = (function (){var statearr_22241 = state_22115;
(statearr_22241[(10)] = inst_22085);

(statearr_22241[(50)] = inst_22084__$1);

return statearr_22241;
})();
if(inst_22086){
var statearr_22242_22434 = state_22115__$1;
(statearr_22242_22434[(1)] = (128));

} else {
var statearr_22243_22435 = state_22115__$1;
(statearr_22243_22435[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (127))){
var inst_22071 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22244_22436 = state_22115__$1;
(statearr_22244_22436[(2)] = inst_22071);

(statearr_22244_22436[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (82))){
var inst_21878 = (state_22115[(30)]);
var state_22115__$1 = state_22115;
var statearr_22245_22437 = state_22115__$1;
(statearr_22245_22437[(2)] = inst_21878);

(statearr_22245_22437[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (76))){
var inst_21864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21872 = flakes;
var inst_21873 = cljs.core.seq(inst_21872);
var inst_21874 = cljs.core.first(inst_21873);
var inst_21875 = cljs.core.next(inst_21873);
var inst_21876 = cljs.core.PersistentVector.EMPTY;
var inst_21877 = inst_21872;
var inst_21878 = inst_21876;
var state_22115__$1 = (function (){var statearr_22246 = state_22115;
(statearr_22246[(45)] = inst_21877);

(statearr_22246[(54)] = inst_21875);

(statearr_22246[(55)] = inst_21864);

(statearr_22246[(30)] = inst_21878);

(statearr_22246[(56)] = inst_21874);

return statearr_22246;
})();
var statearr_22247_22438 = state_22115__$1;
(statearr_22247_22438[(2)] = null);

(statearr_22247_22438[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (97))){
var inst_21944 = (state_22115[(49)]);
var inst_21951 = (state_22115[(40)]);
var inst_21950 = cljs.core.seq(inst_21944);
var inst_21951__$1 = cljs.core.first(inst_21950);
var inst_21952 = cljs.core.next(inst_21950);
var state_22115__$1 = (function (){var statearr_22248 = state_22115;
(statearr_22248[(46)] = inst_21952);

(statearr_22248[(40)] = inst_21951__$1);

return statearr_22248;
})();
if(cljs.core.truth_(inst_21951__$1)){
var statearr_22249_22439 = state_22115__$1;
(statearr_22249_22439[(1)] = (99));

} else {
var statearr_22250_22440 = state_22115__$1;
(statearr_22250_22440[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (19))){
var inst_21717 = (state_22115[(13)]);
var inst_21721 = (state_22115[(41)]);
var inst_21721__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21717);
var state_22115__$1 = (function (){var statearr_22251 = state_22115;
(statearr_22251[(41)] = inst_21721__$1);

return statearr_22251;
})();
if(cljs.core.truth_(inst_21721__$1)){
var statearr_22252_22441 = state_22115__$1;
(statearr_22252_22441[(1)] = (21));

} else {
var statearr_22253_22442 = state_22115__$1;
(statearr_22253_22442[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (57))){
var inst_21717 = (state_22115[(13)]);
var inst_21797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21798 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_21799 = (new cljs.core.PersistentVector(null,3,(5),inst_21797,inst_21798,null));
var inst_21800 = cljs.core.select_keys(inst_21717,inst_21799);
var inst_21801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21809 = flakes;
var inst_21810 = cljs.core.seq(inst_21809);
var inst_21811 = cljs.core.first(inst_21810);
var inst_21812 = cljs.core.next(inst_21810);
var inst_21813 = cljs.core.PersistentVector.EMPTY;
var inst_21814 = inst_21809;
var inst_21815 = inst_21813;
var state_22115__$1 = (function (){var statearr_22254 = state_22115;
(statearr_22254[(57)] = inst_21812);

(statearr_22254[(9)] = inst_21815);

(statearr_22254[(53)] = inst_21800);

(statearr_22254[(58)] = inst_21811);

(statearr_22254[(24)] = inst_21814);

(statearr_22254[(51)] = inst_21801);

return statearr_22254;
})();
var statearr_22255_22443 = state_22115__$1;
(statearr_22255_22443[(2)] = null);

(statearr_22255_22443[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (68))){
var inst_21840 = (state_22115[(2)]);
var state_22115__$1 = (function (){var statearr_22256 = state_22115;
(statearr_22256[(22)] = inst_21840);

return statearr_22256;
})();
if(cljs.core.truth_(fuel)){
var statearr_22257_22444 = state_22115__$1;
(statearr_22257_22444[(1)] = (70));

} else {
var statearr_22258_22445 = state_22115__$1;
(statearr_22258_22445[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (11))){
var inst_21702 = (state_22115[(42)]);
var inst_21702__$1 = (state_22115[(2)]);
var inst_21704 = cljs.core.contains_QMARK_(inst_21702__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_21705 = (!(inst_21704));
var state_22115__$1 = (function (){var statearr_22259 = state_22115;
(statearr_22259[(42)] = inst_21702__$1);

return statearr_22259;
})();
if(inst_21705){
var statearr_22260_22446 = state_22115__$1;
(statearr_22260_22446[(1)] = (12));

} else {
var statearr_22261_22447 = state_22115__$1;
(statearr_22261_22447[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (115))){
var inst_22061 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22263_22448 = state_22115__$1;
(statearr_22263_22448[(2)] = inst_22061);

(statearr_22263_22448[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (9))){
var inst_21696 = cljs.core.first(flakes);
var inst_21697 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_21696);
var inst_21698 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_21699 = fluree.db.query.fql_resp.wildcard_pred_spec(db,cache,inst_21697,inst_21698);
var state_22115__$1 = state_22115;
var statearr_22264_22449 = state_22115__$1;
(statearr_22264_22449[(2)] = inst_21699);

(statearr_22264_22449[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (5))){
var _ = (function (){var statearr_22265 = state_22115;
(statearr_22265[(4)] = cljs.core.rest((state_22115[(4)])));

return statearr_22265;
})();
var state_22115__$1 = state_22115;
var ex22262 = (state_22115__$1[(2)]);
var statearr_22266_22450 = state_22115__$1;
(statearr_22266_22450[(5)] = ex22262);


if((ex22262 instanceof Error)){
var statearr_22267_22451 = state_22115__$1;
(statearr_22267_22451[(1)] = (4));

(statearr_22267_22451[(5)] = null);

} else {
throw ex22262;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (112))){
var inst_22073 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22268_22452 = state_22115__$1;
(statearr_22268_22452[(2)] = inst_22073);

(statearr_22268_22452[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (83))){
var inst_21918 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22269_22453 = state_22115__$1;
(statearr_22269_22453[(2)] = inst_21918);

(statearr_22269_22453[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (14))){
var inst_21702 = (state_22115[(42)]);
var inst_21710 = (state_22115[(2)]);
var inst_21711 = cljs.core.contains_QMARK_(inst_21702,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_21712 = (!(inst_21711));
var state_22115__$1 = (function (){var statearr_22270 = state_22115;
(statearr_22270[(36)] = inst_21710);

return statearr_22270;
})();
if(inst_21712){
var statearr_22271_22454 = state_22115__$1;
(statearr_22271_22454[(1)] = (15));

} else {
var statearr_22272_22455 = state_22115__$1;
(statearr_22272_22455[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (45))){
var inst_21728 = (state_22115[(18)]);
var inst_21732 = (state_22115[(20)]);
var inst_21768 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_21728);
var inst_21769 = cljs.core.count(inst_21768);
var inst_21770 = (inst_21769 >= inst_21732);
var state_22115__$1 = state_22115;
var statearr_22273_22456 = state_22115__$1;
(statearr_22273_22456[(2)] = inst_21770);

(statearr_22273_22456[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (53))){
var inst_21795 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
if(cljs.core.truth_(inst_21795)){
var statearr_22274_22457 = state_22115__$1;
(statearr_22274_22457[(1)] = (57));

} else {
var statearr_22275_22458 = state_22115__$1;
(statearr_22275_22458[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (78))){
var inst_22077 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22276_22459 = state_22115__$1;
(statearr_22276_22459[(2)] = inst_22077);

(statearr_22276_22459[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (132))){
var state_22115__$1 = state_22115;
var statearr_22278_22460 = state_22115__$1;
(statearr_22278_22460[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (26))){
var inst_21750 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
if(cljs.core.truth_(inst_21750)){
var statearr_22280_22461 = state_22115__$1;
(statearr_22280_22461[(1)] = (33));

} else {
var statearr_22281_22462 = state_22115__$1;
(statearr_22281_22462[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (123))){
var inst_22023 = (state_22115[(33)]);
var inst_22030 = (state_22115[(39)]);
var tmp22277 = inst_22023;
var inst_22022 = inst_22030;
var inst_22023__$1 = tmp22277;
var state_22115__$1 = (function (){var statearr_22282 = state_22115;
(statearr_22282[(33)] = inst_22023__$1);

(statearr_22282[(37)] = inst_22022);

return statearr_22282;
})();
var statearr_22283_22463 = state_22115__$1;
(statearr_22283_22463[(2)] = null);

(statearr_22283_22463[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (16))){
var inst_21710 = (state_22115[(36)]);
var state_22115__$1 = state_22115;
var statearr_22284_22464 = state_22115__$1;
(statearr_22284_22464[(2)] = inst_21710);

(statearr_22284_22464[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (133))){
var inst_22108 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22285_22465 = state_22115__$1;
(statearr_22285_22465[(2)] = inst_22108);

(statearr_22285_22465[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (81))){
var inst_21717 = (state_22115[(13)]);
var inst_21893 = (state_22115[(59)]);
var inst_21884 = (state_22115[(28)]);
var inst_21887 = cljs.core.deref(cache);
var inst_21888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21889 = fluree.db.flake.o(inst_21884);
var inst_21890 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21717);
var inst_21891 = [inst_21889,inst_21890];
var inst_21892 = (new cljs.core.PersistentVector(null,2,(5),inst_21888,inst_21891,null));
var inst_21893__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21887,inst_21892);
var state_22115__$1 = (function (){var statearr_22286 = state_22115;
(statearr_22286[(59)] = inst_21893__$1);

return statearr_22286;
})();
if(cljs.core.truth_(inst_21893__$1)){
var statearr_22287_22466 = state_22115__$1;
(statearr_22287_22466[(1)] = (84));

} else {
var statearr_22288_22467 = state_22115__$1;
(statearr_22288_22467[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (120))){
var inst_22057 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22289_22468 = state_22115__$1;
(statearr_22289_22468[(2)] = inst_22057);

(statearr_22289_22468[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (79))){
var inst_21877 = (state_22115[(45)]);
var inst_21884 = (state_22115[(28)]);
var inst_21883 = cljs.core.seq(inst_21877);
var inst_21884__$1 = cljs.core.first(inst_21883);
var inst_21885 = cljs.core.next(inst_21883);
var state_22115__$1 = (function (){var statearr_22290 = state_22115;
(statearr_22290[(44)] = inst_21885);

(statearr_22290[(28)] = inst_21884__$1);

return statearr_22290;
})();
if(cljs.core.truth_(inst_21884__$1)){
var statearr_22291_22469 = state_22115__$1;
(statearr_22291_22469[(1)] = (81));

} else {
var statearr_22292_22470 = state_22115__$1;
(statearr_22292_22470[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (38))){
var inst_21752 = (state_22115[(43)]);
var inst_21760 = (state_22115[(2)]);
var inst_21761 = [null,inst_21760];
var inst_21762 = (new cljs.core.PersistentVector(null,2,(5),inst_21752,inst_21761,null));
var state_22115__$1 = state_22115;
var statearr_22293_22471 = state_22115__$1;
(statearr_22293_22471[(2)] = inst_21762);

(statearr_22293_22471[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (126))){
var state_22115__$1 = state_22115;
var statearr_22294_22472 = state_22115__$1;
(statearr_22294_22472[(2)] = null);

(statearr_22294_22472[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (98))){
var inst_21931 = (state_22115[(60)]);
var inst_21995 = (state_22115[(2)]);
var inst_21996 = [inst_21995,offset_map];
var inst_21997 = (new cljs.core.PersistentVector(null,2,(5),inst_21931,inst_21996,null));
var state_22115__$1 = state_22115;
var statearr_22295_22473 = state_22115__$1;
(statearr_22295_22473[(2)] = inst_21997);

(statearr_22295_22473[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (124))){
var inst_22051 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22296_22474 = state_22115__$1;
(statearr_22296_22474[(2)] = inst_22051);

(statearr_22296_22474[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (87))){
var inst_21717 = (state_22115[(13)]);
var inst_21884 = (state_22115[(28)]);
var inst_21900 = (state_22115[(2)]);
var inst_21901 = fluree.db.util.async.throw_err(inst_21900);
var inst_21902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21903 = fluree.db.flake.o(inst_21884);
var inst_21904 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21717);
var inst_21905 = [inst_21903,inst_21904];
var inst_21906 = (new cljs.core.PersistentVector(null,2,(5),inst_21902,inst_21905,null));
var inst_21907 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_21906,inst_21901);
var state_22115__$1 = (function (){var statearr_22297 = state_22115;
(statearr_22297[(61)] = inst_21907);

return statearr_22297;
})();
var statearr_22298_22475 = state_22115__$1;
(statearr_22298_22475[(2)] = inst_21901);

(statearr_22298_22475[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (30))){
var inst_21735 = (state_22115[(19)]);
var inst_21740 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_21735);
var inst_21741 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_21740);
var state_22115__$1 = state_22115;
var statearr_22299_22476 = state_22115__$1;
(statearr_22299_22476[(2)] = inst_21741);

(statearr_22299_22476[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (73))){
var inst_21840 = (state_22115[(22)]);
var inst_21815 = (state_22115[(9)]);
var inst_21849 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21815,inst_21840);
var state_22115__$1 = state_22115;
var statearr_22300_22477 = state_22115__$1;
(statearr_22300_22477[(2)] = inst_21849);

(statearr_22300_22477[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (96))){
var inst_22075 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
var statearr_22301_22478 = state_22115__$1;
(statearr_22301_22478[(2)] = inst_22075);

(statearr_22301_22478[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (10))){
var state_22115__$1 = state_22115;
var statearr_22302_22479 = state_22115__$1;
(statearr_22302_22479[(2)] = pred_spec);

(statearr_22302_22479[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (18))){
var inst_21718 = (state_22115[(52)]);
var state_22115__$1 = state_22115;
var statearr_22303_22480 = state_22115__$1;
(statearr_22303_22480[(2)] = inst_21718);

(statearr_22303_22480[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (105))){
var inst_21983 = (state_22115[(2)]);
var state_22115__$1 = (function (){var statearr_22304 = state_22115;
(statearr_22304[(47)] = inst_21983);

return statearr_22304;
})();
if(cljs.core.truth_(fuel)){
var statearr_22305_22481 = state_22115__$1;
(statearr_22305_22481[(1)] = (107));

} else {
var statearr_22306_22482 = state_22115__$1;
(statearr_22306_22482[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (52))){
var inst_21785 = (state_22115[(62)]);
var state_22115__$1 = state_22115;
var statearr_22307_22483 = state_22115__$1;
(statearr_22307_22483[(2)] = inst_21785);

(statearr_22307_22483[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (114))){
var inst_22017 = flakes;
var inst_22018 = cljs.core.seq(inst_22017);
var inst_22019 = cljs.core.first(inst_22018);
var inst_22020 = cljs.core.next(inst_22018);
var inst_22021 = cljs.core.PersistentVector.EMPTY;
var inst_22022 = inst_22017;
var inst_22023 = inst_22021;
var state_22115__$1 = (function (){var statearr_22308 = state_22115;
(statearr_22308[(63)] = inst_22019);

(statearr_22308[(33)] = inst_22023);

(statearr_22308[(37)] = inst_22022);

(statearr_22308[(64)] = inst_22020);

return statearr_22308;
})();
var statearr_22309_22484 = state_22115__$1;
(statearr_22309_22484[(2)] = null);

(statearr_22309_22484[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (67))){
var state_22115__$1 = state_22115;
var statearr_22310_22485 = state_22115__$1;
(statearr_22310_22485[(2)] = null);

(statearr_22310_22485[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (71))){
var state_22115__$1 = state_22115;
var statearr_22311_22486 = state_22115__$1;
(statearr_22311_22486[(2)] = null);

(statearr_22311_22486[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (42))){
var inst_21732 = (state_22115[(20)]);
var state_22115__$1 = state_22115;
if(cljs.core.truth_(inst_21732)){
var statearr_22312_22487 = state_22115__$1;
(statearr_22312_22487[(1)] = (45));

} else {
var statearr_22313_22488 = state_22115__$1;
(statearr_22313_22488[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (80))){
var inst_21864 = (state_22115[(55)]);
var inst_21920 = (state_22115[(2)]);
var inst_21921 = [inst_21920,offset_map];
var inst_21922 = (new cljs.core.PersistentVector(null,2,(5),inst_21864,inst_21921,null));
var state_22115__$1 = state_22115;
var statearr_22314_22489 = state_22115__$1;
(statearr_22314_22489[(2)] = inst_21922);

(statearr_22314_22489[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (37))){
var inst_21735 = (state_22115[(19)]);
var inst_21734 = (state_22115[(21)]);
var inst_21757 = (inst_21734 - (1));
var inst_21758 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_21735,inst_21757);
var state_22115__$1 = state_22115;
var statearr_22315_22490 = state_22115__$1;
(statearr_22315_22490[(2)] = inst_21758);

(statearr_22315_22490[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (63))){
var inst_21815 = (state_22115[(9)]);
var state_22115__$1 = state_22115;
var statearr_22316_22491 = state_22115__$1;
(statearr_22316_22491[(2)] = inst_21815);

(statearr_22316_22491[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (94))){
var inst_21931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21939 = flakes;
var inst_21940 = cljs.core.seq(inst_21939);
var inst_21941 = cljs.core.first(inst_21940);
var inst_21942 = cljs.core.next(inst_21940);
var inst_21943 = cljs.core.PersistentVector.EMPTY;
var inst_21944 = inst_21939;
var inst_21945 = inst_21943;
var state_22115__$1 = (function (){var statearr_22317 = state_22115;
(statearr_22317[(32)] = inst_21945);

(statearr_22317[(65)] = inst_21941);

(statearr_22317[(49)] = inst_21944);

(statearr_22317[(60)] = inst_21931);

(statearr_22317[(66)] = inst_21942);

return statearr_22317;
})();
var statearr_22318_22492 = state_22115__$1;
(statearr_22318_22492[(2)] = null);

(statearr_22318_22492[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (8))){
var inst_21694 = (state_22115[(2)]);
var state_22115__$1 = state_22115;
if(cljs.core.truth_(inst_21694)){
var statearr_22319_22493 = state_22115__$1;
(statearr_22319_22493[(1)] = (9));

} else {
var statearr_22320_22494 = state_22115__$1;
(statearr_22320_22494[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (49))){
var inst_21785 = (state_22115[(62)]);
var inst_21785__$1 = cljs.core.not(recur_QMARK_);
var state_22115__$1 = (function (){var statearr_22321 = state_22115;
(statearr_22321[(62)] = inst_21785__$1);

return statearr_22321;
})();
if(inst_21785__$1){
var statearr_22322_22495 = state_22115__$1;
(statearr_22322_22495[(1)] = (51));

} else {
var statearr_22323_22496 = state_22115__$1;
(statearr_22323_22496[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22116 === (84))){
var inst_21893 = (state_22115[(59)]);
var state_22115__$1 = state_22115;
var statearr_22324_22497 = state_22115__$1;
(statearr_22324_22497[(2)] = inst_21893);

(statearr_22324_22497[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$state_machine__2727__auto____0 = (function (){
var statearr_22325 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22325[(0)] = fluree$db$query$fql_resp$state_machine__2727__auto__);

(statearr_22325[(1)] = (1));

return statearr_22325;
});
var fluree$db$query$fql_resp$state_machine__2727__auto____1 = (function (state_22115){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22115);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22326){var ex__2730__auto__ = e22326;
var statearr_22327_22498 = state_22115;
(statearr_22327_22498[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22115[(4)]))){
var statearr_22328_22499 = state_22115;
(statearr_22328_22499[(1)] = cljs.core.first((state_22115[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22500 = state_22115;
state_22115 = G__22500;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$state_machine__2727__auto__ = function(state_22115){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$state_machine__2727__auto____1.call(this,state_22115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$state_machine__2727__auto____0;
fluree$db$query$fql_resp$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$state_machine__2727__auto____1;
return fluree$db$query$fql_resp$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22329 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22329[(6)] = c__2749__auto__);

return statearr_22329;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql_resp.add_pred.cljs$lang$maxFixedArity = 10);

fluree.db.query.fql_resp.compare_fn = (function fluree$db$query$fql_resp$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql_resp.sort_offset_and_limit_res = (function fluree$db$query$fql_resp$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__22502 = res;
var G__22502__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__22501_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__22501_SHARP_,sortPred);
}),fluree.db.query.fql_resp.compare_fn,G__22502):G__22502);
var G__22502__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__22502__$1):G__22502__$1);
var G__22502__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__22502__$2):G__22502__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__22502__$3);
} else {
return G__22502__$3;
}
} else {
return res;
}
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql_resp.flakes__GT_res = (function fluree$db$query$fql_resp$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22683){
var state_val_22684 = (state_22683[(1)]);
if((state_val_22684 === (7))){
var state_22683__$1 = state_22683;
var statearr_22685_22771 = state_22683__$1;
(statearr_22685_22771[(2)] = null);

(statearr_22685_22771[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (20))){
var inst_22541 = cljs.core.PersistentHashMap.EMPTY;
var state_22683__$1 = state_22683;
var statearr_22686_22772 = state_22683__$1;
(statearr_22686_22772[(2)] = inst_22541);

(statearr_22686_22772[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (27))){
var inst_22523 = (state_22683[(7)]);
var inst_22529 = (state_22683[(8)]);
var inst_22559 = (state_22683[(9)]);
var inst_22543 = (state_22683[(10)]);
var inst_22662 = (state_22683[(2)]);
var inst_22663 = (function (){var top_level_subject = inst_22523;
var select_spec = inst_22529;
var base_acc = inst_22543;
var acc_PLUS_refs = inst_22559;
var result = inst_22662;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4253__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_22664 = cljs.core.PersistentVector.EMPTY;
var inst_22665 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22529);
var inst_22666 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_22665);
var inst_22667 = cljs.core.vals(inst_22666);
var inst_22668 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22529);
var inst_22669 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_22668);
var inst_22670 = cljs.core.vals(inst_22669);
var inst_22671 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_22667,inst_22670);
var inst_22672 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_22663,inst_22664,inst_22671);
var inst_22674 = (function (){var top_level_subject = inst_22523;
var select_spec = inst_22529;
var base_acc = inst_22543;
var acc_PLUS_refs = inst_22559;
var result = inst_22662;
var sort_preds = inst_22672;
return (function (acc,p__22673){
var vec__22687 = p__22673;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22687,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22687,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22687,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22687,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql_resp.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_22675 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_22674,inst_22662,inst_22672);
var state_22683__$1 = state_22683;
var statearr_22690_22773 = state_22683__$1;
(statearr_22690_22773[(2)] = inst_22675);

(statearr_22690_22773[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (1))){
var state_22683__$1 = state_22683;
var statearr_22691_22774 = state_22683__$1;
(statearr_22691_22774[(2)] = null);

(statearr_22691_22774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (24))){
var inst_22559 = (state_22683[(9)]);
var inst_22559__$1 = (state_22683[(2)]);
var inst_22560 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_22561 = cljs.core.PersistentHashMap.EMPTY;
var inst_22562 = inst_22560;
var inst_22563 = inst_22559__$1;
var inst_22564 = inst_22561;
var state_22683__$1 = (function (){var statearr_22692 = state_22683;
(statearr_22692[(11)] = inst_22563);

(statearr_22692[(9)] = inst_22559__$1);

(statearr_22692[(12)] = inst_22564);

(statearr_22692[(13)] = inst_22562);

return statearr_22692;
})();
var statearr_22693_22775 = state_22683__$1;
(statearr_22693_22775[(2)] = null);

(statearr_22693_22775[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (39))){
var inst_22563 = (state_22683[(11)]);
var inst_22529 = (state_22683[(8)]);
var inst_22579 = (state_22683[(14)]);
var inst_22572 = (state_22683[(15)]);
var inst_22608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22609 = fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_22563,inst_22529,inst_22572,inst_22579,false);
var state_22683__$1 = (function (){var statearr_22694 = state_22683;
(statearr_22694[(16)] = inst_22608);

return statearr_22694;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22683__$1,(42),inst_22609);
} else {
if((state_val_22684 === (46))){
var inst_22564 = (state_22683[(12)]);
var inst_22572 = (state_22683[(15)]);
var inst_22562 = (state_22683[(13)]);
var inst_22626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22627 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22628 = cljs.core.first(inst_22572);
var inst_22629 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_22628);
var inst_22630 = [inst_22629];
var inst_22631 = cljs.core.PersistentHashMap.fromArrays(inst_22627,inst_22630);
var inst_22632 = cljs.core.rest(inst_22562);
var inst_22633 = [inst_22631,inst_22632,inst_22564];
var inst_22634 = (new cljs.core.PersistentVector(null,3,(5),inst_22626,inst_22633,null));
var state_22683__$1 = state_22683;
var statearr_22695_22776 = state_22683__$1;
(statearr_22695_22776[(2)] = inst_22634);

(statearr_22695_22776[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (4))){
var inst_22503 = (state_22683[(2)]);
var state_22683__$1 = state_22683;
var statearr_22696_22777 = state_22683__$1;
(statearr_22696_22777[(2)] = inst_22503);

(statearr_22696_22777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (15))){
var inst_22529 = (state_22683[(8)]);
var inst_22530 = (state_22683[(17)]);
var inst_22529__$1 = (state_22683[(2)]);
var inst_22530__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22529__$1);
var state_22683__$1 = (function (){var statearr_22697 = state_22683;
(statearr_22697[(8)] = inst_22529__$1);

(statearr_22697[(17)] = inst_22530__$1);

return statearr_22697;
})();
if(cljs.core.truth_(inst_22530__$1)){
var statearr_22698_22778 = state_22683__$1;
(statearr_22698_22778[(1)] = (16));

} else {
var statearr_22699_22779 = state_22683__$1;
(statearr_22699_22779[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (48))){
var inst_22645 = (state_22683[(2)]);
var state_22683__$1 = state_22683;
var statearr_22700_22780 = state_22683__$1;
(statearr_22700_22780[(2)] = inst_22645);

(statearr_22700_22780[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (50))){
var state_22683__$1 = state_22683;
var statearr_22701_22781 = state_22683__$1;
(statearr_22701_22781[(2)] = null);

(statearr_22701_22781[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (21))){
var inst_22529 = (state_22683[(8)]);
var inst_22543 = (state_22683[(2)]);
var inst_22544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22545 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_22546 = (new cljs.core.PersistentVector(null,2,(5),inst_22544,inst_22545,null));
var inst_22547 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_22529,inst_22546);
var state_22683__$1 = (function (){var statearr_22702 = state_22683;
(statearr_22702[(10)] = inst_22543);

return statearr_22702;
})();
if(cljs.core.truth_(inst_22547)){
var statearr_22703_22782 = state_22683__$1;
(statearr_22703_22782[(1)] = (22));

} else {
var statearr_22704_22783 = state_22683__$1;
(statearr_22704_22783[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (31))){
var inst_22578 = (state_22683[(18)]);
var inst_22563 = (state_22683[(11)]);
var inst_22572 = (state_22683[(15)]);
var inst_22582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22583 = fluree.db.query.fql_resp.flake__GT_recur(db,inst_22572,inst_22578,inst_22563,fuel,max_fuel,cache);
var state_22683__$1 = (function (){var statearr_22705 = state_22683;
(statearr_22705[(19)] = inst_22582);

return statearr_22705;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22683__$1,(34),inst_22583);
} else {
if((state_val_22684 === (32))){
var inst_22578 = (state_22683[(18)]);
var state_22683__$1 = state_22683;
if(cljs.core.truth_(inst_22578)){
var statearr_22706_22784 = state_22683__$1;
(statearr_22706_22784[(1)] = (35));

} else {
var statearr_22707_22785 = state_22683__$1;
(statearr_22707_22785[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (40))){
var inst_22529 = (state_22683[(8)]);
var inst_22619 = (state_22683[(20)]);
var inst_22618 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22529);
var inst_22619__$1 = cljs.core.empty_QMARK_(inst_22618);
var state_22683__$1 = (function (){var statearr_22708 = state_22683;
(statearr_22708[(20)] = inst_22619__$1);

return statearr_22708;
})();
if(inst_22619__$1){
var statearr_22709_22786 = state_22683__$1;
(statearr_22709_22786[(1)] = (43));

} else {
var statearr_22710_22787 = state_22683__$1;
(statearr_22710_22787[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (33))){
var inst_22572 = (state_22683[(15)]);
var inst_22651 = (state_22683[(2)]);
var inst_22652 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22651,(0),null);
var inst_22653 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22651,(1),null);
var inst_22654 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22651,(2),null);
var inst_22655 = cljs.core.first(inst_22572);
var inst_22656 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_22655);
var inst_22657 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22652,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_22656);
var inst_22562 = inst_22653;
var inst_22563 = inst_22657;
var inst_22564 = inst_22654;
var state_22683__$1 = (function (){var statearr_22711 = state_22683;
(statearr_22711[(11)] = inst_22563);

(statearr_22711[(12)] = inst_22564);

(statearr_22711[(13)] = inst_22562);

return statearr_22711;
})();
var statearr_22712_22788 = state_22683__$1;
(statearr_22712_22788[(2)] = null);

(statearr_22712_22788[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (13))){
var inst_22523 = (state_22683[(7)]);
var inst_22526 = fluree.db.query.fql_resp.full_select_spec(db,cache,base_select_spec,inst_22523);
var state_22683__$1 = state_22683;
var statearr_22713_22789 = state_22683__$1;
(statearr_22713_22789[(2)] = inst_22526);

(statearr_22713_22789[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (22))){
var inst_22529 = (state_22683[(8)]);
var inst_22549 = cljs.core.first(flakes);
var inst_22550 = fluree.db.flake.s(inst_22549);
var inst_22551 = fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs(inst_22529);
var inst_22552 = fluree.db.query.fql_resp.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_22550,inst_22551);
var state_22683__$1 = state_22683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22683__$1,(25),inst_22552);
} else {
if((state_val_22684 === (36))){
var inst_22529 = (state_22683[(8)]);
var inst_22606 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22529);
var state_22683__$1 = state_22683;
if(cljs.core.truth_(inst_22606)){
var statearr_22714_22790 = state_22683__$1;
(statearr_22714_22790[(1)] = (39));

} else {
var statearr_22715_22791 = state_22683__$1;
(statearr_22715_22791[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (41))){
var inst_22647 = (state_22683[(2)]);
var state_22683__$1 = state_22683;
var statearr_22716_22792 = state_22683__$1;
(statearr_22716_22792[(2)] = inst_22647);

(statearr_22716_22792[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (43))){
var inst_22529 = (state_22683[(8)]);
var inst_22621 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_22529);
var state_22683__$1 = state_22683;
var statearr_22717_22793 = state_22683__$1;
(statearr_22717_22793[(2)] = inst_22621);

(statearr_22717_22793[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (29))){
var inst_22578 = (state_22683[(18)]);
var inst_22529 = (state_22683[(8)]);
var inst_22572 = (state_22683[(15)]);
var inst_22562 = (state_22683[(13)]);
var inst_22572__$1 = cljs.core.first(inst_22562);
var inst_22573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22574 = cljs.core.first(inst_22572__$1);
var inst_22575 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22574);
var inst_22576 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_22575];
var inst_22577 = (new cljs.core.PersistentVector(null,3,(5),inst_22573,inst_22576,null));
var inst_22578__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_22529,inst_22577);
var inst_22579 = fluree.db.query.fql_resp.component_follow_QMARK_(inst_22578__$1,inst_22529);
var inst_22580 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_22578__$1);
var state_22683__$1 = (function (){var statearr_22718 = state_22683;
(statearr_22718[(18)] = inst_22578__$1);

(statearr_22718[(14)] = inst_22579);

(statearr_22718[(15)] = inst_22572__$1);

return statearr_22718;
})();
if(cljs.core.truth_(inst_22580)){
var statearr_22719_22794 = state_22683__$1;
(statearr_22719_22794[(1)] = (31));

} else {
var statearr_22720_22795 = state_22683__$1;
(statearr_22720_22795[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (44))){
var inst_22619 = (state_22683[(20)]);
var state_22683__$1 = state_22683;
var statearr_22721_22796 = state_22683__$1;
(statearr_22721_22796[(2)] = inst_22619);

(statearr_22721_22796[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (6))){
var state_22683__$1 = state_22683;
var statearr_22722_22797 = state_22683__$1;
(statearr_22722_22797[(2)] = null);

(statearr_22722_22797[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (28))){
var inst_22563 = (state_22683[(11)]);
var state_22683__$1 = state_22683;
var statearr_22723_22798 = state_22683__$1;
(statearr_22723_22798[(2)] = inst_22563);

(statearr_22723_22798[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (51))){
var inst_22643 = (state_22683[(2)]);
var state_22683__$1 = state_22683;
var statearr_22724_22799 = state_22683__$1;
(statearr_22724_22799[(2)] = inst_22643);

(statearr_22724_22799[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (25))){
var inst_22543 = (state_22683[(10)]);
var inst_22554 = (state_22683[(2)]);
var inst_22555 = fluree.db.util.async.throw_err(inst_22554);
var inst_22556 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_22543,inst_22555], 0));
var state_22683__$1 = state_22683;
var statearr_22725_22800 = state_22683__$1;
(statearr_22725_22800[(2)] = inst_22556);

(statearr_22725_22800[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (34))){
var inst_22582 = (state_22683[(19)]);
var inst_22564 = (state_22683[(12)]);
var inst_22562 = (state_22683[(13)]);
var inst_22585 = (state_22683[(2)]);
var inst_22586 = fluree.db.util.async.throw_err(inst_22585);
var inst_22587 = cljs.core.rest(inst_22562);
var inst_22588 = [inst_22586,inst_22587,inst_22564];
var inst_22589 = (new cljs.core.PersistentVector(null,3,(5),inst_22582,inst_22588,null));
var state_22683__$1 = state_22683;
var statearr_22726_22801 = state_22683__$1;
(statearr_22726_22801[(2)] = inst_22589);

(statearr_22726_22801[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (17))){
var inst_22529 = (state_22683[(8)]);
var inst_22533 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_22529);
var state_22683__$1 = state_22683;
var statearr_22728_22802 = state_22683__$1;
(statearr_22728_22802[(2)] = inst_22533);

(statearr_22728_22802[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (3))){
var inst_22681 = (state_22683[(2)]);
var state_22683__$1 = state_22683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22683__$1,inst_22681);
} else {
if((state_val_22684 === (12))){
var _ = (function (){var statearr_22729 = state_22683;
(statearr_22729[(4)] = cljs.core.rest((state_22683[(4)])));

return statearr_22729;
})();
var state_22683__$1 = state_22683;
var ex22727 = (state_22683__$1[(2)]);
var statearr_22730_22803 = state_22683__$1;
(statearr_22730_22803[(5)] = ex22727);


var statearr_22731_22804 = state_22683__$1;
(statearr_22731_22804[(1)] = (11));

(statearr_22731_22804[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (2))){
var _ = (function (){var statearr_22732 = state_22683;
(statearr_22732[(4)] = cljs.core.cons((5),(state_22683[(4)])));

return statearr_22732;
})();
var inst_22509 = cljs.core.not_empty(flakes);
var state_22683__$1 = state_22683;
if(cljs.core.truth_(inst_22509)){
var statearr_22733_22805 = state_22683__$1;
(statearr_22733_22805[(1)] = (6));

} else {
var statearr_22734_22806 = state_22683__$1;
(statearr_22734_22806[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (23))){
var inst_22543 = (state_22683[(10)]);
var state_22683__$1 = state_22683;
var statearr_22735_22807 = state_22683__$1;
(statearr_22735_22807[(2)] = inst_22543);

(statearr_22735_22807[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (47))){
var state_22683__$1 = state_22683;
var statearr_22736_22808 = state_22683__$1;
(statearr_22736_22808[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (35))){
var inst_22578 = (state_22683[(18)]);
var inst_22563 = (state_22683[(11)]);
var inst_22579 = (state_22683[(14)]);
var inst_22564 = (state_22683[(12)]);
var inst_22572 = (state_22683[(15)]);
var inst_22595 = fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_22563,inst_22578,inst_22572,inst_22579,false,inst_22564);
var state_22683__$1 = state_22683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22683__$1,(38),inst_22595);
} else {
if((state_val_22684 === (19))){
var inst_22523 = (state_22683[(7)]);
var inst_22537 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22538 = [inst_22523];
var inst_22539 = cljs.core.PersistentHashMap.fromArrays(inst_22537,inst_22538);
var state_22683__$1 = state_22683;
var statearr_22738_22809 = state_22683__$1;
(statearr_22738_22809[(2)] = inst_22539);

(statearr_22738_22809[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (11))){
var inst_22511 = (state_22683[(2)]);
var inst_22512 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1(inst_22511) : fluree.db.util.log.error.call(null,inst_22511));
var inst_22513 = (function(){throw inst_22511})();
var state_22683__$1 = (function (){var statearr_22740 = state_22683;
(statearr_22740[(21)] = inst_22512);

return statearr_22740;
})();
var statearr_22741_22810 = state_22683__$1;
(statearr_22741_22810[(2)] = inst_22513);

(statearr_22741_22810[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (9))){
var _ = (function (){var statearr_22742 = state_22683;
(statearr_22742[(4)] = cljs.core.cons((12),(state_22683[(4)])));

return statearr_22742;
})();
var inst_22519 = cljs.core.first(flakes);
var inst_22520 = fluree.db.flake.s(inst_22519);
var ___$1 = (function (){var statearr_22743 = state_22683;
(statearr_22743[(4)] = cljs.core.rest((state_22683[(4)])));

return statearr_22743;
})();
var state_22683__$1 = state_22683;
var statearr_22744_22811 = state_22683__$1;
(statearr_22744_22811[(2)] = inst_22520);

(statearr_22744_22811[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (5))){
var _ = (function (){var statearr_22745 = state_22683;
(statearr_22745[(4)] = cljs.core.rest((state_22683[(4)])));

return statearr_22745;
})();
var state_22683__$1 = state_22683;
var ex22739 = (state_22683__$1[(2)]);
var statearr_22746_22812 = state_22683__$1;
(statearr_22746_22812[(5)] = ex22739);


if((ex22739 instanceof Error)){
var statearr_22747_22813 = state_22683__$1;
(statearr_22747_22813[(1)] = (4));

(statearr_22747_22813[(5)] = null);

} else {
throw ex22739;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (14))){
var state_22683__$1 = state_22683;
var statearr_22748_22814 = state_22683__$1;
(statearr_22748_22814[(2)] = base_select_spec);

(statearr_22748_22814[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (45))){
var inst_22624 = (state_22683[(2)]);
var state_22683__$1 = state_22683;
if(cljs.core.truth_(inst_22624)){
var statearr_22749_22815 = state_22683__$1;
(statearr_22749_22815[(1)] = (46));

} else {
var statearr_22750_22816 = state_22683__$1;
(statearr_22750_22816[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (26))){
var inst_22562 = (state_22683[(13)]);
var inst_22566 = cljs.core.empty_QMARK_(inst_22562);
var state_22683__$1 = state_22683;
if(inst_22566){
var statearr_22751_22817 = state_22683__$1;
(statearr_22751_22817[(1)] = (28));

} else {
var statearr_22752_22818 = state_22683__$1;
(statearr_22752_22818[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (16))){
var inst_22530 = (state_22683[(17)]);
var state_22683__$1 = state_22683;
var statearr_22753_22819 = state_22683__$1;
(statearr_22753_22819[(2)] = inst_22530);

(statearr_22753_22819[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (38))){
var inst_22562 = (state_22683[(13)]);
var inst_22597 = (state_22683[(2)]);
var inst_22598 = fluree.db.util.async.throw_err(inst_22597);
var inst_22599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22598,(0),null);
var inst_22600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22598,(1),null);
var inst_22601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22602 = cljs.core.rest(inst_22562);
var inst_22603 = [inst_22599,inst_22602,inst_22600];
var inst_22604 = (new cljs.core.PersistentVector(null,3,(5),inst_22601,inst_22603,null));
var state_22683__$1 = state_22683;
var statearr_22754_22820 = state_22683__$1;
(statearr_22754_22820[(2)] = inst_22604);

(statearr_22754_22820[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (30))){
var inst_22660 = (state_22683[(2)]);
var state_22683__$1 = state_22683;
var statearr_22755_22821 = state_22683__$1;
(statearr_22755_22821[(2)] = inst_22660);

(statearr_22755_22821[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (10))){
var inst_22523 = (state_22683[(2)]);
var inst_22524 = fluree.db.query.fql_resp.has_ns_lookups_QMARK_(base_select_spec);
var state_22683__$1 = (function (){var statearr_22756 = state_22683;
(statearr_22756[(7)] = inst_22523);

return statearr_22756;
})();
if(cljs.core.truth_(inst_22524)){
var statearr_22757_22822 = state_22683__$1;
(statearr_22757_22822[(1)] = (13));

} else {
var statearr_22758_22823 = state_22683__$1;
(statearr_22758_22823[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (18))){
var inst_22535 = (state_22683[(2)]);
var state_22683__$1 = state_22683;
if(cljs.core.truth_(inst_22535)){
var statearr_22759_22824 = state_22683__$1;
(statearr_22759_22824[(1)] = (19));

} else {
var statearr_22760_22825 = state_22683__$1;
(statearr_22760_22825[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (42))){
var inst_22608 = (state_22683[(16)]);
var inst_22564 = (state_22683[(12)]);
var inst_22562 = (state_22683[(13)]);
var inst_22611 = (state_22683[(2)]);
var inst_22612 = fluree.db.util.async.throw_err(inst_22611);
var inst_22613 = cljs.core.first(inst_22612);
var inst_22614 = cljs.core.rest(inst_22562);
var inst_22615 = [inst_22613,inst_22614,inst_22564];
var inst_22616 = (new cljs.core.PersistentVector(null,3,(5),inst_22608,inst_22615,null));
var state_22683__$1 = state_22683;
var statearr_22761_22826 = state_22683__$1;
(statearr_22761_22826[(2)] = inst_22616);

(statearr_22761_22826[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (37))){
var inst_22649 = (state_22683[(2)]);
var state_22683__$1 = state_22683;
var statearr_22762_22827 = state_22683__$1;
(statearr_22762_22827[(2)] = inst_22649);

(statearr_22762_22827[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (8))){
var inst_22678 = (state_22683[(2)]);
var _ = (function (){var statearr_22763 = state_22683;
(statearr_22763[(4)] = cljs.core.rest((state_22683[(4)])));

return statearr_22763;
})();
var state_22683__$1 = state_22683;
var statearr_22764_22828 = state_22683__$1;
(statearr_22764_22828[(2)] = inst_22678);

(statearr_22764_22828[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22684 === (49))){
var inst_22563 = (state_22683[(11)]);
var inst_22564 = (state_22683[(12)]);
var inst_22562 = (state_22683[(13)]);
var inst_22637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22638 = cljs.core.rest(inst_22562);
var inst_22639 = [inst_22563,inst_22638,inst_22564];
var inst_22640 = (new cljs.core.PersistentVector(null,3,(5),inst_22637,inst_22639,null));
var state_22683__$1 = state_22683;
var statearr_22765_22829 = state_22683__$1;
(statearr_22765_22829[(2)] = inst_22640);

(statearr_22765_22829[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0 = (function (){
var statearr_22766 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22766[(0)] = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__);

(statearr_22766[(1)] = (1));

return statearr_22766;
});
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1 = (function (state_22683){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22683);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22767){var ex__2730__auto__ = e22767;
var statearr_22768_22830 = state_22683;
(statearr_22768_22830[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22683[(4)]))){
var statearr_22769_22831 = state_22683;
(statearr_22769_22831[(1)] = cljs.core.first((state_22683[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22832 = state_22683;
state_22683 = G__22832;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__ = function(state_22683){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1.call(this,state_22683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22770 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22770[(6)] = c__2749__auto__);

return statearr_22770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
