// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19129_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19129_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19133 = coll;
var vec__19134 = G__19133;
var seq__19135 = cljs.core.seq(vec__19134);
var first__19136 = cljs.core.first(seq__19135);
var seq__19135__$1 = cljs.core.next(seq__19135);
var clause = first__19136;
var r = seq__19135__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19133__$1 = G__19133;
var res__$1 = res;
while(true){
var vec__19140 = G__19133__$1;
var seq__19141 = cljs.core.seq(vec__19140);
var first__19142 = cljs.core.first(seq__19141);
var seq__19141__$1 = cljs.core.next(seq__19141);
var clause__$1 = first__19142;
var r__$1 = seq__19141__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19143 = r__$1;
var G__19144 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__19133__$1 = G__19143;
res__$1 = G__19144;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__19145){
var map__19146 = p__19145;
var map__19146__$1 = cljs.core.__destructure_map(map__19146);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19146__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__19150 = coll;
var vec__19151 = G__19150;
var seq__19152 = cljs.core.seq(vec__19151);
var first__19153 = cljs.core.first(seq__19152);
var seq__19152__$1 = cljs.core.next(seq__19152);
var clause = first__19153;
var r = seq__19152__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19150__$1 = G__19150;
var res__$1 = res;
while(true){
var vec__19157 = G__19150__$1;
var seq__19158 = cljs.core.seq(vec__19157);
var first__19159 = cljs.core.first(seq__19158);
var seq__19158__$1 = cljs.core.next(seq__19158);
var clause__$1 = first__19159;
var r__$1 = seq__19158__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19160 = r__$1;
var G__19161 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__19150__$1 = G__19160;
res__$1 = G__19161;
continue;
} else {
var G__19162 = r__$1;
var G__19163 = res__$2;
G__19150__$1 = G__19162;
res__$1 = G__19163;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__19167 = coll;
var vec__19168 = G__19167;
var seq__19169 = cljs.core.seq(vec__19168);
var first__19170 = cljs.core.first(seq__19169);
var seq__19169__$1 = cljs.core.next(seq__19169);
var clause = first__19170;
var r = seq__19169__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19167__$1 = G__19167;
var res__$1 = res;
while(true){
var vec__19174 = G__19167__$1;
var seq__19175 = cljs.core.seq(vec__19174);
var first__19176 = cljs.core.first(seq__19175);
var seq__19175__$1 = cljs.core.next(seq__19175);
var clause__$1 = first__19176;
var r__$1 = seq__19175__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19177 = r__$1;
var G__19178 = res__$2;
G__19167__$1 = G__19177;
res__$1 = G__19178;
continue;
} else {
var G__19179 = r__$1;
var G__19180 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__19167__$1 = G__19179;
res__$1 = G__19180;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__19183 = clause;
var G__19183__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__19183):G__19183);
var G__19183__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__19183__$1)
;
var G__19183__$3 = (function (){var fexpr__19184 = (function (p1__19181_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19181_SHARP_)," ."].join('');
});
return fexpr__19184(G__19183__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__19185 = (function (p1__19182_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19182_SHARP_),"}"].join('');
});
return fexpr__19185(G__19183__$3);
} else {
return G__19183__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__19189 = opts;
var map__19189__$1 = cljs.core.__destructure_map(map__19189);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19189__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19189__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19189__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19189__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19189__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19186_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19186_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__19187_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__19187_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__19188_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__19188_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4253__auto__ = language;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19203){
var state_val_19204 = (state_19203[(1)]);
if((state_val_19204 === (1))){
var inst_19190 = fluree.db.util.core.url_encode(query);
var inst_19191 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19190)].join('');
var inst_19192 = ["User-Agent","Accept"];
var inst_19193 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_19194 = cljs.core.PersistentHashMap.fromArrays(inst_19192,inst_19193);
var inst_19195 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_19196 = [inst_19194,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_19197 = cljs.core.PersistentHashMap.fromArrays(inst_19195,inst_19196);
var inst_19198 = fluree.db.util.xhttp.get(inst_19191,inst_19197);
var state_19203__$1 = state_19203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19203__$1,(2),inst_19198);
} else {
if((state_val_19204 === (2))){
var inst_19200 = (state_19203[(2)]);
var inst_19201 = fluree.db.util.async.throw_err(inst_19200);
var state_19203__$1 = state_19203;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19203__$1,inst_19201);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0 = (function (){
var statearr_19205 = [null,null,null,null,null,null,null];
(statearr_19205[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__);

(statearr_19205[(1)] = (1));

return statearr_19205;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1 = (function (state_19203){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19203);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19206){var ex__2730__auto__ = e19206;
var statearr_19207_19210 = state_19203;
(statearr_19207_19210[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19203[(4)]))){
var statearr_19208_19211 = state_19203;
(statearr_19208_19211[(1)] = cljs.core.first((state_19203[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19212 = state_19203;
state_19203 = G__19212;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__ = function(state_19203){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1.call(this,state_19203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19209 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19209[(6)] = c__2749__auto__);

return statearr_19209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19230){
var state_val_19231 = (state_19230[(1)]);
if((state_val_19231 === (1))){
var inst_19213 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_19230__$1 = state_19230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19230__$1,(2),inst_19213);
} else {
if((state_val_19231 === (2))){
var inst_19216 = (state_19230[(7)]);
var inst_19215 = (state_19230[(2)]);
var inst_19216__$1 = fluree.db.util.async.throw_err(inst_19215);
var inst_19217 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_19216__$1);
var inst_19218 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_19217);
var state_19230__$1 = (function (){var statearr_19232 = state_19230;
(statearr_19232[(7)] = inst_19216__$1);

return statearr_19232;
})();
if(inst_19218){
var statearr_19233_19242 = state_19230__$1;
(statearr_19233_19242[(1)] = (3));

} else {
var statearr_19234_19243 = state_19230__$1;
(statearr_19234_19243[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (3))){
var inst_19216 = (state_19230[(7)]);
var state_19230__$1 = state_19230;
var statearr_19235_19244 = state_19230__$1;
(statearr_19235_19244[(2)] = inst_19216);

(statearr_19235_19244[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (4))){
var inst_19216 = (state_19230[(7)]);
var inst_19221 = (function (){var body = inst_19216;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_19222 = cljs.core.second(inst_19216);
var inst_19223 = cljs.core.second(inst_19222);
var inst_19224 = cljs.core.first(inst_19223);
var inst_19225 = cljs.core.second(inst_19224);
var inst_19226 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_19221,inst_19225);
var state_19230__$1 = state_19230;
var statearr_19236_19245 = state_19230__$1;
(statearr_19236_19245[(2)] = inst_19226);

(statearr_19236_19245[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19231 === (5))){
var inst_19228 = (state_19230[(2)]);
var state_19230__$1 = state_19230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19230__$1,inst_19228);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0 = (function (){
var statearr_19237 = [null,null,null,null,null,null,null,null];
(statearr_19237[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__);

(statearr_19237[(1)] = (1));

return statearr_19237;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1 = (function (state_19230){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19230);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19238){var ex__2730__auto__ = e19238;
var statearr_19239_19246 = state_19230;
(statearr_19239_19246[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19230[(4)]))){
var statearr_19240_19247 = state_19230;
(statearr_19240_19247[(1)] = cljs.core.first((state_19230[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19248 = state_19230;
state_19230 = G__19248;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__ = function(state_19230){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1.call(this,state_19230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19241 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19241[(6)] = c__2749__auto__);

return statearr_19241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19249_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19249_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19250_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19250_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19251_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__19251_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__19251_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__19251_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19297){
var state_val_19298 = (state_19297[(1)]);
if((state_val_19298 === (7))){
var inst_19262 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_19297__$1 = state_19297;
var statearr_19299_19327 = state_19297__$1;
(statearr_19299_19327[(2)] = inst_19262);

(statearr_19299_19327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19298 === (1))){
var state_19297__$1 = state_19297;
var statearr_19300_19328 = state_19297__$1;
(statearr_19300_19328[(2)] = null);

(statearr_19300_19328[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19298 === (4))){
var inst_19252 = (state_19297[(2)]);
var state_19297__$1 = state_19297;
var statearr_19301_19329 = state_19297__$1;
(statearr_19301_19329[(2)] = inst_19252);

(statearr_19301_19329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19298 === (15))){
var inst_19276 = (state_19297[(7)]);
var inst_19271 = (state_19297[(8)]);
var inst_19270 = (state_19297[(9)]);
var inst_19281 = (state_19297[(2)]);
var inst_19282 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_19276,(0),inst_19281);
var inst_19283 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19284 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_19270);
var inst_19285 = [inst_19271,inst_19284];
var inst_19286 = cljs.core.PersistentHashMap.fromArrays(inst_19283,inst_19285);
var inst_19287 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19282,inst_19286);
var inst_19288 = (function(){throw inst_19287})();
var state_19297__$1 = state_19297;
var statearr_19302_19330 = state_19297__$1;
(statearr_19302_19330[(2)] = inst_19288);

(statearr_19302_19330[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19298 === (13))){
var inst_19275 = (state_19297[(10)]);
var state_19297__$1 = state_19297;
var statearr_19303_19331 = state_19297__$1;
(statearr_19303_19331[(2)] = inst_19275);

(statearr_19303_19331[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19298 === (6))){
var state_19297__$1 = state_19297;
var statearr_19304_19332 = state_19297__$1;
(statearr_19304_19332[(2)] = null);

(statearr_19304_19332[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19298 === (3))){
var inst_19295 = (state_19297[(2)]);
var state_19297__$1 = state_19297;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19297__$1,inst_19295);
} else {
if((state_val_19298 === (12))){
var inst_19292 = (state_19297[(2)]);
var _ = (function (){var statearr_19305 = state_19297;
(statearr_19305[(4)] = cljs.core.rest((state_19297[(4)])));

return statearr_19305;
})();
var state_19297__$1 = state_19297;
var statearr_19306_19333 = state_19297__$1;
(statearr_19306_19333[(2)] = inst_19292);

(statearr_19306_19333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19298 === (2))){
var _ = (function (){var statearr_19307 = state_19297;
(statearr_19307[(4)] = cljs.core.cons((5),(state_19297[(4)])));

return statearr_19307;
})();
var inst_19259 = cljs.core.empty_QMARK_(matching_vars);
var state_19297__$1 = state_19297;
if(inst_19259){
var statearr_19308_19334 = state_19297__$1;
(statearr_19308_19334[(1)] = (6));

} else {
var statearr_19309_19335 = state_19297__$1;
(statearr_19309_19335[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19298 === (11))){
var inst_19270 = (state_19297[(9)]);
var inst_19290 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_19270,all_vars);
var state_19297__$1 = state_19297;
var statearr_19311_19336 = state_19297__$1;
(statearr_19311_19336[(2)] = inst_19290);

(statearr_19311_19336[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19298 === (9))){
var inst_19271 = (state_19297[(8)]);
var inst_19270 = (state_19297[(9)]);
var inst_19268 = (state_19297[(2)]);
var inst_19269 = fluree.db.util.async.throw_err(inst_19268);
var inst_19270__$1 = cljs.core.__destructure_map(inst_19269);
var inst_19271__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19270__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_19272 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19270__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_19273 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_19271__$1);
var state_19297__$1 = (function (){var statearr_19312 = state_19297;
(statearr_19312[(8)] = inst_19271__$1);

(statearr_19312[(9)] = inst_19270__$1);

(statearr_19312[(11)] = inst_19272);

return statearr_19312;
})();
if(inst_19273){
var statearr_19313_19337 = state_19297__$1;
(statearr_19313_19337[(1)] = (10));

} else {
var statearr_19314_19338 = state_19297__$1;
(statearr_19314_19338[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19298 === (5))){
var _ = (function (){var statearr_19315 = state_19297;
(statearr_19315[(4)] = cljs.core.rest((state_19297[(4)])));

return statearr_19315;
})();
var state_19297__$1 = state_19297;
var ex19310 = (state_19297__$1[(2)]);
var statearr_19316_19339 = state_19297__$1;
(statearr_19316_19339[(5)] = ex19310);


if((ex19310 instanceof Error)){
var statearr_19317_19340 = state_19297__$1;
(statearr_19317_19340[(1)] = (4));

(statearr_19317_19340[(5)] = null);

} else {
throw ex19310;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19298 === (14))){
var state_19297__$1 = state_19297;
var statearr_19318_19341 = state_19297__$1;
(statearr_19318_19341[(2)] = (1000));

(statearr_19318_19341[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19298 === (10))){
var inst_19275 = (state_19297[(10)]);
var inst_19270 = (state_19297[(9)]);
var inst_19272 = (state_19297[(11)]);
var inst_19275__$1 = cljs.core.count(inst_19272);
var inst_19276 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_19270);
var inst_19277 = (inst_19275__$1 < (1000));
var state_19297__$1 = (function (){var statearr_19319 = state_19297;
(statearr_19319[(7)] = inst_19276);

(statearr_19319[(10)] = inst_19275__$1);

return statearr_19319;
})();
if(cljs.core.truth_(inst_19277)){
var statearr_19320_19342 = state_19297__$1;
(statearr_19320_19342[(1)] = (13));

} else {
var statearr_19321_19343 = state_19297__$1;
(statearr_19321_19343[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19298 === (8))){
var inst_19264 = (state_19297[(2)]);
var inst_19265 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_19264,optional_clauses);
var inst_19266 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_19265);
var state_19297__$1 = state_19297;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19297__$1,(9),inst_19266);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_19322 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19322[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__);

(statearr_19322[(1)] = (1));

return statearr_19322;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1 = (function (state_19297){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19297);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19323){var ex__2730__auto__ = e19323;
var statearr_19324_19344 = state_19297;
(statearr_19324_19344[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19297[(4)]))){
var statearr_19325_19345 = state_19297;
(statearr_19325_19345[(1)] = cljs.core.first((state_19297[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19346 = state_19297;
state_19297 = G__19346;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__ = function(state_19297){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1.call(this,state_19297);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19326 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19326[(6)] = c__2749__auto__);

return statearr_19326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
