// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
/**
 * Map of default index comparators for the five index types
 */
fluree.db.index.default_comparators = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"post","post",269697687),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"tspo","tspo",-440144953),fluree.db.flake.cmp_flakes_block], null);
/**
 * The five possible index orderings based on the subject, predicate, object,
 *   and transaction flake attributes
 */
fluree.db.index.types = cljs.core.set(cljs.core.keys(fluree.db.index.default_comparators));
/**
 * Returns `true` if `node` is a map for a leaf node
 */
fluree.db.index.leaf_QMARK_ = (function fluree$db$index$leaf_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === true;
});
/**
 * Returns `true` if `node` is a map for branch node
 */
fluree.db.index.branch_QMARK_ = (function fluree$db$index$branch_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === false;
});

/**
 * @interface
 */
fluree.db.index.Resolver = function(){};

var fluree$db$index$Resolver$resolve$dyn_13903 = (function (r,node){
var x__4550__auto__ = (((r == null))?null:r);
var m__4551__auto__ = (fluree.db.index.resolve[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(r,node) : m__4551__auto__.call(null,r,node));
} else {
var m__4549__auto__ = (fluree.db.index.resolve["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(r,node) : m__4549__auto__.call(null,r,node));
} else {
throw cljs.core.missing_protocol("Resolver.resolve",r);
}
}
});
/**
 * Populate index branch and leaf node maps with either their child node
 *   attributes or the flakes the store, respectively.
 */
fluree.db.index.resolve = (function fluree$db$index$resolve(r,node){
if((((!((r == null)))) && ((!((r.fluree$db$index$Resolver$resolve$arity$2 == null)))))){
return r.fluree$db$index$Resolver$resolve$arity$2(r,node);
} else {
return fluree$db$index$Resolver$resolve$dyn_13903(r,node);
}
});

fluree.db.index.try_resolve = (function fluree$db$index$try_resolve(r,error_ch,node){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_13925){
var state_val_13926 = (state_13925[(1)]);
if((state_val_13926 === (1))){
var state_13925__$1 = state_13925;
var statearr_13927_13942 = state_13925__$1;
(statearr_13927_13942[(2)] = null);

(statearr_13927_13942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13926 === (2))){
var _ = (function (){var statearr_13928 = state_13925;
(statearr_13928[(4)] = cljs.core.cons((6),(state_13925[(4)])));

return statearr_13928;
})();
var inst_13917 = fluree.db.index.resolve(r,node);
var state_13925__$1 = state_13925;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13925__$1,(7),inst_13917);
} else {
if((state_val_13926 === (3))){
var inst_13923 = (state_13925[(2)]);
var state_13925__$1 = state_13925;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13925__$1,inst_13923);
} else {
if((state_val_13926 === (4))){
var inst_13904 = (state_13925[(2)]);
var inst_13905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13906 = [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015)];
var inst_13907 = (new cljs.core.PersistentVector(null,3,(5),inst_13905,inst_13906,null));
var inst_13908 = cljs.core.select_keys(node,inst_13907);
var inst_13909 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_13904,"Error resolving index node:",inst_13908) : fluree.db.util.log.error.call(null,inst_13904,"Error resolving index node:",inst_13908));
var state_13925__$1 = (function (){var statearr_13930 = state_13925;
(statearr_13930[(7)] = inst_13909);

return statearr_13930;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13925__$1,(5),error_ch,inst_13904);
} else {
if((state_val_13926 === (5))){
var inst_13911 = (state_13925[(2)]);
var state_13925__$1 = state_13925;
var statearr_13931_13943 = state_13925__$1;
(statearr_13931_13943[(2)] = inst_13911);

(statearr_13931_13943[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13926 === (6))){
var _ = (function (){var statearr_13932 = state_13925;
(statearr_13932[(4)] = cljs.core.rest((state_13925[(4)])));

return statearr_13932;
})();
var state_13925__$1 = state_13925;
var ex13929 = (state_13925__$1[(2)]);
var statearr_13933_13944 = state_13925__$1;
(statearr_13933_13944[(5)] = ex13929);


var statearr_13934_13945 = state_13925__$1;
(statearr_13934_13945[(1)] = (4));

(statearr_13934_13945[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13926 === (7))){
var inst_13919 = (state_13925[(2)]);
var inst_13920 = fluree.db.util.async.throw_err(inst_13919);
var _ = (function (){var statearr_13935 = state_13925;
(statearr_13935[(4)] = cljs.core.rest((state_13925[(4)])));

return statearr_13935;
})();
var state_13925__$1 = state_13925;
var statearr_13936_13946 = state_13925__$1;
(statearr_13936_13946[(2)] = inst_13920);

(statearr_13936_13946[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$try_resolve_$_state_machine__2727__auto__ = null;
var fluree$db$index$try_resolve_$_state_machine__2727__auto____0 = (function (){
var statearr_13937 = [null,null,null,null,null,null,null,null];
(statearr_13937[(0)] = fluree$db$index$try_resolve_$_state_machine__2727__auto__);

(statearr_13937[(1)] = (1));

return statearr_13937;
});
var fluree$db$index$try_resolve_$_state_machine__2727__auto____1 = (function (state_13925){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_13925);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e13938){var ex__2730__auto__ = e13938;
var statearr_13939_13947 = state_13925;
(statearr_13939_13947[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_13925[(4)]))){
var statearr_13940_13948 = state_13925;
(statearr_13940_13948[(1)] = cljs.core.first((state_13925[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13949 = state_13925;
state_13925 = G__13949;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$try_resolve_$_state_machine__2727__auto__ = function(state_13925){
switch(arguments.length){
case 0:
return fluree$db$index$try_resolve_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$try_resolve_$_state_machine__2727__auto____1.call(this,state_13925);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$try_resolve_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$try_resolve_$_state_machine__2727__auto____0;
fluree$db$index$try_resolve_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$try_resolve_$_state_machine__2727__auto____1;
return fluree$db$index$try_resolve_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_13941 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_13941[(6)] = c__2749__auto__);

return statearr_13941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns `true` if the data associated with the index node map `node` is fully
 *   resolved from storage
 */
fluree.db.index.resolved_QMARK_ = (function fluree$db$index$resolved_QMARK_(node){
if(fluree.db.index.leaf_QMARK_(node)){
return (!((new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
if(fluree.db.index.branch_QMARK_(node)){
return (!((new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
return null;
}
}
});
fluree.db.index.lookup = (function fluree$db$index$lookup(branch,flake){
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.index.branch_QMARK_(branch);
if(and__4251__auto__){
return fluree.db.index.resolved_QMARK_(branch);
} else {
return and__4251__auto__;
}
})())){
var map__13950 = branch;
var map__13950__$1 = cljs.core.__destructure_map(map__13950);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13950__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.val((function (){var or__4253__auto__ = clojure.data.avl.nearest(children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.first(children);
}
})());
} else {
return null;
}
});
fluree.db.index.lookup_leaf = (function fluree$db$index$lookup_leaf(r,branch,flake){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_13986){
var state_val_13987 = (state_13986[(1)]);
if((state_val_13987 === (7))){
var inst_13957 = (state_13986[(7)]);
var state_13986__$1 = state_13986;
var statearr_13988_14019 = state_13986__$1;
(statearr_13988_14019[(2)] = inst_13957);

(statearr_13988_14019[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13987 === (1))){
var state_13986__$1 = state_13986;
var statearr_13989_14020 = state_13986__$1;
(statearr_13989_14020[(2)] = null);

(statearr_13989_14020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13987 === (4))){
var inst_13951 = (state_13986[(2)]);
var state_13986__$1 = state_13986;
var statearr_13990_14021 = state_13986__$1;
(statearr_13990_14021[(2)] = inst_13951);

(statearr_13990_14021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13987 === (15))){
var inst_13965 = (state_13986[(8)]);
var inst_13970 = fluree.db.index.resolve(r,inst_13965);
var state_13986__$1 = state_13986;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13986__$1,(17),inst_13970);
} else {
if((state_val_13987 === (13))){
var inst_13978 = (state_13986[(2)]);
var state_13986__$1 = state_13986;
var statearr_13991_14022 = state_13986__$1;
(statearr_13991_14022[(2)] = inst_13978);

(statearr_13991_14022[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13987 === (6))){
var inst_13959 = fluree.db.index.resolved_QMARK_(branch);
var state_13986__$1 = state_13986;
var statearr_13992_14023 = state_13986__$1;
(statearr_13992_14023[(2)] = inst_13959);

(statearr_13992_14023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13987 === (17))){
var inst_13972 = (state_13986[(2)]);
var inst_13973 = fluree.db.util.async.throw_err(inst_13972);
var inst_13965 = inst_13973;
var state_13986__$1 = (function (){var statearr_13993 = state_13986;
(statearr_13993[(8)] = inst_13965);

return statearr_13993;
})();
var statearr_13994_14024 = state_13986__$1;
(statearr_13994_14024[(2)] = null);

(statearr_13994_14024[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13987 === (3))){
var inst_13984 = (state_13986[(2)]);
var state_13986__$1 = state_13986;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13986__$1,inst_13984);
} else {
if((state_val_13987 === (12))){
var inst_13965 = (state_13986[(8)]);
var inst_13967 = fluree.db.index.leaf_QMARK_(inst_13965);
var state_13986__$1 = state_13986;
if(inst_13967){
var statearr_13995_14025 = state_13986__$1;
(statearr_13995_14025[(1)] = (14));

} else {
var statearr_13996_14026 = state_13986__$1;
(statearr_13996_14026[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13987 === (2))){
var inst_13957 = (state_13986[(7)]);
var _ = (function (){var statearr_13997 = state_13986;
(statearr_13997[(4)] = cljs.core.cons((5),(state_13986[(4)])));

return statearr_13997;
})();
var inst_13957__$1 = fluree.db.index.branch_QMARK_(branch);
var state_13986__$1 = (function (){var statearr_13998 = state_13986;
(statearr_13998[(7)] = inst_13957__$1);

return statearr_13998;
})();
if(inst_13957__$1){
var statearr_13999_14027 = state_13986__$1;
(statearr_13999_14027[(1)] = (6));

} else {
var statearr_14000_14028 = state_13986__$1;
(statearr_14000_14028[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13987 === (11))){
var inst_13981 = (state_13986[(2)]);
var _ = (function (){var statearr_14002 = state_13986;
(statearr_14002[(4)] = cljs.core.rest((state_13986[(4)])));

return statearr_14002;
})();
var state_13986__$1 = state_13986;
var statearr_14003_14029 = state_13986__$1;
(statearr_14003_14029[(2)] = inst_13981);

(statearr_14003_14029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13987 === (9))){
var inst_13964 = fluree.db.index.lookup(branch,flake);
var inst_13965 = inst_13964;
var state_13986__$1 = (function (){var statearr_14004 = state_13986;
(statearr_14004[(8)] = inst_13965);

return statearr_14004;
})();
var statearr_14005_14030 = state_13986__$1;
(statearr_14005_14030[(2)] = null);

(statearr_14005_14030[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13987 === (5))){
var _ = (function (){var statearr_14006 = state_13986;
(statearr_14006[(4)] = cljs.core.rest((state_13986[(4)])));

return statearr_14006;
})();
var state_13986__$1 = state_13986;
var ex14001 = (state_13986__$1[(2)]);
var statearr_14007_14031 = state_13986__$1;
(statearr_14007_14031[(5)] = ex14001);


if((ex14001 instanceof Error)){
var statearr_14008_14032 = state_13986__$1;
(statearr_14008_14032[(1)] = (4));

(statearr_14008_14032[(5)] = null);

} else {
throw ex14001;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13987 === (14))){
var inst_13965 = (state_13986[(8)]);
var state_13986__$1 = state_13986;
var statearr_14009_14033 = state_13986__$1;
(statearr_14009_14033[(2)] = inst_13965);

(statearr_14009_14033[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13987 === (16))){
var inst_13976 = (state_13986[(2)]);
var state_13986__$1 = state_13986;
var statearr_14010_14034 = state_13986__$1;
(statearr_14010_14034[(2)] = inst_13976);

(statearr_14010_14034[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13987 === (10))){
var state_13986__$1 = state_13986;
var statearr_14011_14035 = state_13986__$1;
(statearr_14011_14035[(2)] = null);

(statearr_14011_14035[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13987 === (8))){
var inst_13962 = (state_13986[(2)]);
var state_13986__$1 = state_13986;
if(cljs.core.truth_(inst_13962)){
var statearr_14012_14036 = state_13986__$1;
(statearr_14012_14036[(1)] = (9));

} else {
var statearr_14013_14037 = state_13986__$1;
(statearr_14013_14037[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_14014 = [null,null,null,null,null,null,null,null,null];
(statearr_14014[(0)] = fluree$db$index$lookup_leaf_$_state_machine__2727__auto__);

(statearr_14014[(1)] = (1));

return statearr_14014;
});
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1 = (function (state_13986){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_13986);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14015){var ex__2730__auto__ = e14015;
var statearr_14016_14038 = state_13986;
(statearr_14016_14038[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_13986[(4)]))){
var statearr_14017_14039 = state_13986;
(statearr_14017_14039[(1)] = cljs.core.first((state_13986[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14040 = state_13986;
state_13986 = G__14040;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__ = function(state_13986){
switch(arguments.length){
case 0:
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1.call(this,state_13986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0;
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1;
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14018 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14018[(6)] = c__2749__auto__);

return statearr_14018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.index.add_flakes = (function fluree$db$index$add_flakes(leaf,flakes){
var new_leaf = cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$4(leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.conj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__4253__auto__ = (function (){var G__14041 = new_leaf;
var G__14041__$1 = (((G__14041 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14041));
if((G__14041__$1 == null)){
return null;
} else {
return cljs.core.first(G__14041__$1);
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
fluree.db.index.rem_flakes = (function fluree$db$index$rem_flakes(leaf,flakes){
var new_leaf = cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$4(leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.disj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__4253__auto__ = (function (){var G__14042 = new_leaf;
var G__14042__$1 = (((G__14042 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14042));
if((G__14042__$1 == null)){
return null;
} else {
return cljs.core.first(G__14042__$1);
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
/**
 * Returns a blank leaf node map for the provided `network`, `ledger-id`, and index
 *   comparator `cmp`.
 */
fluree.db.index.empty_leaf = (function fluree$db$index$empty_leaf(network,ledger_id,cmp){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[(0),ledger_id,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.new_leaf = (function fluree$db$index$new_leaf(network,ledger_id,cmp,flakes){
var empty_set = fluree.db.flake.sorted_set_by(cmp);
return fluree.db.index.add_flakes(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(fluree.db.index.empty_leaf(network,ledger_id,cmp),new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set),flakes);
});
/**
 * Checks if the `node` passed in the second argument is a descendant of the
 *   `branch` passed in the first argument
 */
fluree.db.index.descendant_QMARK_ = (function fluree$db$index$descendant_QMARK_(p__14043,p__14044){
var map__14045 = p__14043;
var map__14045__$1 = cljs.core.__destructure_map(map__14045);
var branch = map__14045__$1;
var cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14045__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var first_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14045__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14045__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14045__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var map__14046 = p__14044;
var map__14046__$1 = cljs.core.__destructure_map(map__14046);
var node = map__14046__$1;
var node_first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14046__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var node_rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14046__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
if((!(fluree.db.index.branch_QMARK_(branch)))){
return false;
} else {
var and__4251__auto__ = (function (){var or__4253__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (!(((cmp.cljs$core$IFn$_invoke$arity$2 ? cmp.cljs$core$IFn$_invoke$arity$2(first_flake,node_first) : cmp.call(null,first_flake,node_first)) > (0))));
}
})();
if(cljs.core.truth_(and__4251__auto__)){
return (((rhs == null)) || ((((!((node_rhs == null)))) && ((!(((cmp.cljs$core$IFn$_invoke$arity$2 ? cmp.cljs$core$IFn$_invoke$arity$2(node_rhs,rhs) : cmp.call(null,node_rhs,rhs)) > (0))))))));
} else {
return and__4251__auto__;
}
}
});
fluree.db.index.child_entry = (function fluree$db$index$child_entry(p__14047){
var map__14048 = p__14047;
var map__14048__$1 = cljs.core.__destructure_map(map__14048);
var node = map__14048__$1;
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14048__$1,new cljs.core.Keyword(null,"first","first",-644103046));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [first,node], null);
});
/**
 * Returns avl sorted map whose keys are the first flakes of the index node
 *   sequence `child-nodes`, and whose values are the corresponding nodes from
 *   `child-nodes`.
 */
fluree.db.index.child_map = (function fluree$db$index$child_map(var_args){
var args__4870__auto__ = [];
var len__4864__auto___14051 = arguments.length;
var i__4865__auto___14052 = (0);
while(true){
if((i__4865__auto___14052 < len__4864__auto___14051)){
args__4870__auto__.push((arguments[i__4865__auto___14052]));

var G__14053 = (i__4865__auto___14052 + (1));
i__4865__auto___14052 = G__14053;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic = (function (cmp,child_nodes){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_map_by,cmp,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(fluree.db.index.child_entry,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([child_nodes], 0)));
}));

(fluree.db.index.child_map.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.index.child_map.cljs$lang$applyTo = (function (seq14049){
var G__14050 = cljs.core.first(seq14049);
var seq14049__$1 = cljs.core.next(seq14049);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14050,seq14049__$1);
}));

/**
 * Returns a blank branch node which contains a single empty leaf node for the
 *   provided `network`, `ledger-id`, and index comparator `cmp`.
 */
fluree.db.index.empty_branch = (function fluree$db$index$empty_branch(network,ledger_id,cmp){
var child_node = fluree.db.index.empty_leaf(network,ledger_id,cmp);
var children = fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([child_node], 0));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[children,(0),ledger_id,false,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.reset_children = (function fluree$db$index$reset_children(p__14054,new_child_nodes){
var map__14055 = p__14054;
var map__14055__$1 = cljs.core.__destructure_map(map__14055);
var branch = map__14055__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14055__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14055__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var new_kids = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.index.child_map,comparator,new_child_nodes);
var new_first = (function (){var or__4253__auto__ = (function (){var G__14056 = new_kids;
var G__14056__$1 = (((G__14056 == null))?null:cljs.core.first(G__14056));
if((G__14056__$1 == null)){
return null;
} else {
return cljs.core.key(G__14056__$1);
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
var new_size = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"size","size",1098693007),new_child_nodes));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(branch,new cljs.core.Keyword(null,"first","first",-644103046),new_first,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"size","size",1098693007),new_size,new cljs.core.Keyword(null,"children","children",-940561982),new_kids], 0));
});
fluree.db.index.new_branch = (function fluree$db$index$new_branch(network,ledger_id,cmp,child_nodes){
return fluree.db.index.reset_children(fluree.db.index.empty_branch(network,ledger_id,cmp),child_nodes);
});
/**
 * Returns `true` if `flake` has a transaction value after the provided `t`
 */
fluree.db.index.after_t_QMARK_ = (function fluree$db$index$after_t_QMARK_(t,flake){
return (fluree.db.flake.t(flake) < t);
});
/**
 * Returns a sequence containing only flakes from the flake set `flakes` with
 *   transaction values after the provided `t`.
 */
fluree.db.index.filter_after = (function fluree$db$index$filter_after(t,flakes){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.index.after_t_QMARK_,t),flakes);
});
/**
 * Returns an avl-subset of the avl-set `flakes` with transaction values on or
 *   before the provided `t`.
 */
fluree.db.index.flakes_through = (function fluree$db$index$flakes_through(t,flakes){
return fluree.db.flake.disj_all(flakes,fluree.db.index.filter_after(t,flakes));
});
fluree.db.index.novelty_subrange = (function fluree$db$index$novelty_subrange(p__14057,through_t,novelty){
var map__14058 = p__14057;
var map__14058__$1 = cljs.core.__destructure_map(map__14058);
var node = map__14058__$1;
var first_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14058__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14058__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14058__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var subrange = (cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4251__auto__ = (rhs == null);
if(and__4251__auto__){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?novelty:null))));
return fluree.db.index.flakes_through(through_t,subrange);
});
/**
 * Returns a sequence of flakes from the sorted set `flakes` that are out of date
 *   by the transaction `t` because `flakes` contains another flake with the same
 *   subject and predicate and a transaction value later than that flake but on or
 *   before `t`.
 */
fluree.db.index.stale_by = (function fluree$db$index$stale_by(t,flakes){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (flakes__$1){
var last_flake = cljs.core.last(flakes__$1);
if(cljs.core.truth_(fluree.db.flake.op(last_flake))){
return cljs.core.butlast(flakes__$1);
} else {
return flakes__$1;
}
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.s,fluree.db.flake.p,fluree.db.flake.o),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.index.after_t_QMARK_,t)),flakes))], 0));
});
/**
 * Returns a sorted set of flakes that are not out of date between the
 *   transactions `from-t` and `to-t`.
 */
fluree.db.index.t_range = (function fluree$db$index$t_range(p__14059,novelty,from_t,to_t){
var map__14060 = p__14059;
var map__14060__$1 = cljs.core.__destructure_map(map__14060);
var leaf = map__14060__$1;
var leaf_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14060__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14060__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var latest = (function (){var G__14061 = flakes;
if((leaf_t > to_t)){
return fluree.db.flake.conj_all(G__14061,fluree.db.index.novelty_subrange(leaf,to_t,novelty));
} else {
return G__14061;
}
})();
var stale_flakes = fluree.db.index.stale_by(from_t,latest);
var subsequent = fluree.db.index.filter_after(to_t,latest);
var out_of_range = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(stale_flakes,subsequent);
return fluree.db.flake.disj_all(latest,out_of_range);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.CachedTRangeResolver = (function (node_resolver,novelty,from_t,to_t,async_cache,__meta,__extmap,__hash){
this.node_resolver = node_resolver;
this.novelty = novelty;
this.from_t = from_t;
this.to_t = to_t;
this.async_cache = async_cache;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (_,p__14067){
var self__ = this;
var map__14068 = p__14067;
var map__14068__$1 = cljs.core.__destructure_map(map__14068);
var node = map__14068__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14068__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14068__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var tt_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14068__$1,new cljs.core.Keyword(null,"tt-id","tt-id",725587484));
var ___$1 = this;
if(fluree.db.index.branch_QMARK_(node)){
return fluree.db.index.resolve(self__.node_resolver,node);
} else {
var G__14069 = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.index","t-range","fluree.db.index/t-range",437950593),id,tempid,tt_id,self__.from_t,self__.to_t], null);
var G__14070 = (function (___$2){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14088){
var state_val_14089 = (state_14088[(1)]);
if((state_val_14089 === (1))){
var state_14088__$1 = state_14088;
var statearr_14090_14125 = state_14088__$1;
(statearr_14090_14125[(2)] = null);

(statearr_14090_14125[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14089 === (2))){
var ___$3 = (function (){var statearr_14091 = state_14088;
(statearr_14091[(4)] = cljs.core.cons((5),(state_14088[(4)])));

return statearr_14091;
})();
var inst_14077 = fluree.db.index.resolve(self__.node_resolver,node);
var state_14088__$1 = state_14088;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14088__$1,(6),inst_14077);
} else {
if((state_val_14089 === (3))){
var inst_14086 = (state_14088[(2)]);
var state_14088__$1 = state_14088;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14088__$1,inst_14086);
} else {
if((state_val_14089 === (4))){
var inst_14071 = (state_14088[(2)]);
var state_14088__$1 = state_14088;
var statearr_14093_14126 = state_14088__$1;
(statearr_14093_14126[(2)] = inst_14071);

(statearr_14093_14126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14089 === (5))){
var ___$3 = (function (){var statearr_14094 = state_14088;
(statearr_14094[(4)] = cljs.core.rest((state_14088[(4)])));

return statearr_14094;
})();
var state_14088__$1 = state_14088;
var ex14092 = (state_14088__$1[(2)]);
var statearr_14095_14127 = state_14088__$1;
(statearr_14095_14127[(5)] = ex14092);


if((ex14092 instanceof Error)){
var statearr_14096_14128 = state_14088__$1;
(statearr_14096_14128[(1)] = (4));

(statearr_14096_14128[(5)] = null);

} else {
throw ex14092;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14089 === (6))){
var inst_14079 = (state_14088[(2)]);
var inst_14080 = fluree.db.util.async.throw_err(inst_14079);
var inst_14081 = fluree.db.index.t_range(inst_14080,self__.novelty,self__.from_t,self__.to_t);
var inst_14082 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_14080,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_14083 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_14082,new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_14081], 0));
var ___$3 = (function (){var statearr_14097 = state_14088;
(statearr_14097[(4)] = cljs.core.rest((state_14088[(4)])));

return statearr_14097;
})();
var state_14088__$1 = state_14088;
var statearr_14098_14129 = state_14088__$1;
(statearr_14098_14129[(2)] = inst_14083);

(statearr_14098_14129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2727__auto__ = null;
var fluree$db$index$state_machine__2727__auto____0 = (function (){
var statearr_14099 = [null,null,null,null,null,null,null];
(statearr_14099[(0)] = fluree$db$index$state_machine__2727__auto__);

(statearr_14099[(1)] = (1));

return statearr_14099;
});
var fluree$db$index$state_machine__2727__auto____1 = (function (state_14088){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14088);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14100){var ex__2730__auto__ = e14100;
var statearr_14101_14130 = state_14088;
(statearr_14101_14130[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14088[(4)]))){
var statearr_14102_14131 = state_14088;
(statearr_14102_14131[(1)] = cljs.core.first((state_14088[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14132 = state_14088;
state_14088 = G__14132;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$state_machine__2727__auto__ = function(state_14088){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2727__auto____1.call(this,state_14088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2727__auto____0;
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2727__auto____1;
return fluree$db$index$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14103 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14103[(6)] = c__2749__auto__);

return statearr_14103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__14069,G__14070) : self__.async_cache.call(null,G__14069,G__14070));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k14063,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__14104 = k14063;
var G__14104__$1 = (((G__14104 instanceof cljs.core.Keyword))?G__14104.fqn:null);
switch (G__14104__$1) {
case "node-resolver":
return self__.node_resolver;

break;
case "novelty":
return self__.novelty;

break;
case "from-t":
return self__.from_t;

break;
case "to-t":
return self__.to_t;

break;
case "async-cache":
return self__.async_cache;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k14063,else__4505__auto__);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__14105){
var vec__14106 = p__14105;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14106,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14106,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.index.CachedTRangeResolver{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14062){
var self__ = this;
var G__14062__$1 = this;
return (new cljs.core.RecordIter((0),G__14062__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__14109 = (function (coll__4499__auto__){
return (361103374 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__14109(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14064,other14065){
var self__ = this;
var this14064__$1 = this;
return (((!((other14065 == null)))) && ((((this14064__$1.constructor === other14065.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14064__$1.node_resolver,other14065.node_resolver)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14064__$1.novelty,other14065.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14064__$1.from_t,other14065.from_t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14064__$1.to_t,other14065.to_t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14064__$1.async_cache,other14065.async_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14064__$1.__extmap,other14065.__extmap)))))))))))))));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),null,new cljs.core.Keyword(null,"from-t","from-t",1730913525),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"to-t","to-t",569467359),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k14063){
var self__ = this;
var this__4509__auto____$1 = this;
var G__14110 = k14063;
var G__14110__$1 = (((G__14110 instanceof cljs.core.Keyword))?G__14110.fqn:null);
switch (G__14110__$1) {
case "node-resolver":
case "novelty":
case "from-t":
case "to-t":
case "async-cache":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k14063);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__14062){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__14111 = cljs.core.keyword_identical_QMARK_;
var expr__14112 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__14114 = new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078);
var G__14115 = expr__14112;
return (pred__14111.cljs$core$IFn$_invoke$arity$2 ? pred__14111.cljs$core$IFn$_invoke$arity$2(G__14114,G__14115) : pred__14111.call(null,G__14114,G__14115));
})())){
return (new fluree.db.index.CachedTRangeResolver(G__14062,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14116 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__14117 = expr__14112;
return (pred__14111.cljs$core$IFn$_invoke$arity$2 ? pred__14111.cljs$core$IFn$_invoke$arity$2(G__14116,G__14117) : pred__14111.call(null,G__14116,G__14117));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,G__14062,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14118 = new cljs.core.Keyword(null,"from-t","from-t",1730913525);
var G__14119 = expr__14112;
return (pred__14111.cljs$core$IFn$_invoke$arity$2 ? pred__14111.cljs$core$IFn$_invoke$arity$2(G__14118,G__14119) : pred__14111.call(null,G__14118,G__14119));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,G__14062,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14120 = new cljs.core.Keyword(null,"to-t","to-t",569467359);
var G__14121 = expr__14112;
return (pred__14111.cljs$core$IFn$_invoke$arity$2 ? pred__14111.cljs$core$IFn$_invoke$arity$2(G__14120,G__14121) : pred__14111.call(null,G__14120,G__14121));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,G__14062,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14122 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__14123 = expr__14112;
return (pred__14111.cljs$core$IFn$_invoke$arity$2 ? pred__14111.cljs$core$IFn$_invoke$arity$2(G__14122,G__14123) : pred__14111.call(null,G__14122,G__14123));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,G__14062,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__14062),null));
}
}
}
}
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__14062){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,G__14062,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.index.CachedTRangeResolver.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node-resolver","node-resolver",-1971835691,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"from-t","from-t",-923522244,null),new cljs.core.Symbol(null,"to-t","to-t",-2084968410,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null)], null);
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$type = true);

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.index/CachedTRangeResolver",null,(1),null));
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.index/CachedTRangeResolver");
}));

/**
 * Positional factory function for fluree.db.index/CachedTRangeResolver.
 */
fluree.db.index.__GT_CachedTRangeResolver = (function fluree$db$index$__GT_CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache){
return (new fluree.db.index.CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache,null,null,null));
});

/**
 * Factory function for fluree.db.index/CachedTRangeResolver, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_CachedTRangeResolver = (function fluree$db$index$map__GT_CachedTRangeResolver(G__14066){
var extmap__4542__auto__ = (function (){var G__14124 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__14066,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], 0));
if(cljs.core.record_QMARK_(G__14066)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__14124);
} else {
return G__14124;
}
})();
return (new fluree.db.index.CachedTRangeResolver(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078).cljs$core$IFn$_invoke$arity$1(G__14066),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__14066),new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(G__14066),new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(G__14066),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__14066),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

/**
 * Find the value of `leaf` at transaction `t` by adding new flakes from
 *   `idx-novelty` to `leaf` if `t` is newer than `leaf`, or removing flakes later
 *   than `t` from `leaf` if `t` is older than `leaf`.
 */
fluree.db.index.at_t = (function fluree$db$index$at_t(p__14135,t,idx_novelty){
var map__14136 = p__14135;
var map__14136__$1 = cljs.core.__destructure_map(map__14136);
var leaf = map__14136__$1;
var leaf_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14136__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14136__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14136__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14136__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(leaf_t,t)){
return leaf;
} else {
var G__14137 = leaf;
var G__14137__$1 = (((leaf_t > t))?fluree.db.index.add_flakes(G__14137,fluree.db.index.novelty_subrange(leaf,t,idx_novelty)):G__14137);
var G__14137__$2 = (((leaf_t < t))?fluree.db.index.rem_flakes(G__14137__$1,fluree.db.index.filter_after(t,flakes)):G__14137__$1);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__14137__$2,new cljs.core.Keyword(null,"t","t",-1397832519),t);

}
});
fluree.db.index.mark_expanded = (function fluree$db$index$mark_expanded(node){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179),true);
});
fluree.db.index.unmark_expanded = (function fluree$db$index$unmark_expanded(node){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179));
});
fluree.db.index.expanded_QMARK_ = (function fluree$db$index$expanded_QMARK_(node){
return new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179).cljs$core$IFn$_invoke$arity$1(node) === true;
});
fluree.db.index.resolve_when = (function fluree$db$index$resolve_when(r,resolve_QMARK_,error_ch,node){
if(cljs.core.truth_((resolve_QMARK_.cljs$core$IFn$_invoke$arity$1 ? resolve_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : resolve_QMARK_.call(null,node)))){
return fluree.db.index.try_resolve(r,error_ch,node);
} else {
var G__14138 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(G__14138,node);

return G__14138;
}
});
fluree.db.index.resolve_children_when = (function fluree$db$index$resolve_children_when(r,resolve_QMARK_,error_ch,branch){
if(cljs.core.truth_(fluree.db.index.resolved_QMARK_(branch))){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14139){
var vec__14140 = p__14139;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14140,(0),null);
var child = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14140,(1),null);
return fluree.db.index.resolve_when(r,resolve_QMARK_,error_ch,child);
}),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(branch)));
} else {
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14145){
var state_val_14146 = (state_14145[(1)]);
if((state_val_14146 === (1))){
var inst_14143 = cljs.core.PersistentVector.EMPTY;
var state_14145__$1 = state_14145;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14145__$1,inst_14143);
} else {
return null;
}
});
return (function() {
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto__ = null;
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0 = (function (){
var statearr_14147 = [null,null,null,null,null,null,null];
(statearr_14147[(0)] = fluree$db$index$resolve_children_when_$_state_machine__2727__auto__);

(statearr_14147[(1)] = (1));

return statearr_14147;
});
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1 = (function (state_14145){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14145);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14148){var ex__2730__auto__ = e14148;
var statearr_14149_14152 = state_14145;
(statearr_14149_14152[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14145[(4)]))){
var statearr_14150_14153 = state_14145;
(statearr_14150_14153[(1)] = cljs.core.first((state_14145[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14154 = state_14145;
state_14145 = G__14154;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__ = function(state_14145){
switch(arguments.length){
case 0:
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1.call(this,state_14145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0;
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1;
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14151 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14151[(6)] = c__2749__auto__);

return statearr_14151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}
});
/**
 * Returns a channel that will eventually contain the stream of index nodes
 *   descended from `root` in depth-first order. `resolve?` is a boolean function
 *   that will be applied to each node to determine whether or not the data
 *   associated with that node will be resolved from disk using the supplied
 *   `Resolver` `r`. `include?` is a boolean function that will be applied to each
 *   node to determine if it will be included in the final output node stream, `n`
 *   is an optional parameter specifying the number of nodes to load concurrently,
 *   and `xf` is an optional transducer that will transform the output stream if
 *   supplied.
 */
fluree.db.index.tree_chan = (function fluree$db$index$tree_chan(var_args){
var G__14156 = arguments.length;
switch (G__14156) {
case 5:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 7:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5 = (function (r,root,resolve_QMARK_,include_QMARK_,error_ch){
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(r,root,resolve_QMARK_,include_QMARK_,(1),cljs.core.identity,error_ch);
}));

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7 = (function (r,root,resolve_QMARK_,include_QMARK_,n,xf,error_ch){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(n,xf);
var c__2749__auto___14234 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14202){
var state_val_14203 = (state_14202[(1)]);
if((state_val_14203 === (7))){
var inst_14197 = (state_14202[(2)]);
var state_14202__$1 = state_14202;
var statearr_14204_14235 = state_14202__$1;
(statearr_14204_14235[(2)] = inst_14197);

(statearr_14204_14235[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14203 === (1))){
var inst_14157 = fluree.db.index.resolve_when(r,resolve_QMARK_,error_ch,root);
var state_14202__$1 = state_14202;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14202__$1,(2),inst_14157);
} else {
if((state_val_14203 === (4))){
var inst_14199 = (state_14202[(2)]);
var inst_14200 = cljs.core.async.close_BANG_(out);
var state_14202__$1 = (function (){var statearr_14205 = state_14202;
(statearr_14205[(7)] = inst_14199);

return statearr_14205;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14202__$1,inst_14200);
} else {
if((state_val_14203 === (15))){
var state_14202__$1 = state_14202;
var statearr_14206_14236 = state_14202__$1;
(statearr_14206_14236[(2)] = null);

(statearr_14206_14236[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14203 === (13))){
var inst_14194 = (state_14202[(2)]);
var state_14202__$1 = state_14202;
var statearr_14207_14237 = state_14202__$1;
(statearr_14207_14237[(2)] = inst_14194);

(statearr_14207_14237[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14203 === (6))){
var state_14202__$1 = state_14202;
var statearr_14208_14238 = state_14202__$1;
(statearr_14208_14238[(2)] = null);

(statearr_14208_14238[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14203 === (17))){
var inst_14179 = (state_14202[(2)]);
var state_14202__$1 = state_14202;
var statearr_14209_14239 = state_14202__$1;
(statearr_14209_14239[(2)] = inst_14179);

(statearr_14209_14239[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14203 === (3))){
var inst_14163 = (state_14202[(8)]);
var inst_14165 = (state_14202[(9)]);
var inst_14165__$1 = cljs.core.peek(inst_14163);
var state_14202__$1 = (function (){var statearr_14210 = state_14202;
(statearr_14210[(9)] = inst_14165__$1);

return statearr_14210;
})();
if(cljs.core.truth_(inst_14165__$1)){
var statearr_14211_14240 = state_14202__$1;
(statearr_14211_14240[(1)] = (5));

} else {
var statearr_14212_14241 = state_14202__$1;
(statearr_14212_14241[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14203 === (12))){
var inst_14165 = (state_14202[(9)]);
var inst_14185 = fluree.db.index.resolve_children_when(r,resolve_QMARK_,error_ch,inst_14165);
var state_14202__$1 = state_14202;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14202__$1,(18),inst_14185);
} else {
if((state_val_14203 === (2))){
var inst_14159 = (state_14202[(2)]);
var inst_14160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14161 = [inst_14159];
var inst_14162 = (new cljs.core.PersistentVector(null,1,(5),inst_14160,inst_14161,null));
var inst_14163 = inst_14162;
var state_14202__$1 = (function (){var statearr_14213 = state_14202;
(statearr_14213[(8)] = inst_14163);

return statearr_14213;
})();
var statearr_14214_14242 = state_14202__$1;
(statearr_14214_14242[(2)] = null);

(statearr_14214_14242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14203 === (11))){
var inst_14165 = (state_14202[(9)]);
var inst_14175 = (include_QMARK_.cljs$core$IFn$_invoke$arity$1 ? include_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_14165) : include_QMARK_.call(null,inst_14165));
var state_14202__$1 = state_14202;
if(cljs.core.truth_(inst_14175)){
var statearr_14215_14243 = state_14202__$1;
(statearr_14215_14243[(1)] = (14));

} else {
var statearr_14216_14244 = state_14202__$1;
(statearr_14216_14244[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14203 === (9))){
var inst_14165 = (state_14202[(9)]);
var inst_14171 = fluree.db.index.expanded_QMARK_(inst_14165);
var state_14202__$1 = state_14202;
var statearr_14217_14245 = state_14202__$1;
(statearr_14217_14245[(2)] = inst_14171);

(statearr_14217_14245[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14203 === (5))){
var inst_14168 = (state_14202[(10)]);
var inst_14163 = (state_14202[(8)]);
var inst_14165 = (state_14202[(9)]);
var inst_14167 = cljs.core.pop(inst_14163);
var inst_14168__$1 = fluree.db.index.leaf_QMARK_(inst_14165);
var state_14202__$1 = (function (){var statearr_14218 = state_14202;
(statearr_14218[(11)] = inst_14167);

(statearr_14218[(10)] = inst_14168__$1);

return statearr_14218;
})();
if(inst_14168__$1){
var statearr_14219_14246 = state_14202__$1;
(statearr_14219_14246[(1)] = (8));

} else {
var statearr_14220_14247 = state_14202__$1;
(statearr_14220_14247[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14203 === (14))){
var inst_14165 = (state_14202[(9)]);
var inst_14177 = fluree.db.index.unmark_expanded(inst_14165);
var state_14202__$1 = state_14202;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14202__$1,(17),out,inst_14177);
} else {
if((state_val_14203 === (16))){
var inst_14167 = (state_14202[(11)]);
var inst_14182 = (state_14202[(2)]);
var inst_14163 = inst_14167;
var state_14202__$1 = (function (){var statearr_14221 = state_14202;
(statearr_14221[(8)] = inst_14163);

(statearr_14221[(12)] = inst_14182);

return statearr_14221;
})();
var statearr_14222_14248 = state_14202__$1;
(statearr_14222_14248[(2)] = null);

(statearr_14222_14248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14203 === (10))){
var inst_14173 = (state_14202[(2)]);
var state_14202__$1 = state_14202;
if(cljs.core.truth_(inst_14173)){
var statearr_14223_14249 = state_14202__$1;
(statearr_14223_14249[(1)] = (11));

} else {
var statearr_14224_14250 = state_14202__$1;
(statearr_14224_14250[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14203 === (18))){
var inst_14167 = (state_14202[(11)]);
var inst_14165 = (state_14202[(9)]);
var inst_14187 = (state_14202[(2)]);
var inst_14188 = fluree.db.index.mark_expanded(inst_14165);
var inst_14189 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_14167,inst_14188);
var inst_14190 = cljs.core.rseq(inst_14187);
var inst_14191 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14189,inst_14190);
var inst_14163 = inst_14191;
var state_14202__$1 = (function (){var statearr_14225 = state_14202;
(statearr_14225[(8)] = inst_14163);

return statearr_14225;
})();
var statearr_14226_14251 = state_14202__$1;
(statearr_14226_14251[(2)] = null);

(statearr_14226_14251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14203 === (8))){
var inst_14168 = (state_14202[(10)]);
var state_14202__$1 = state_14202;
var statearr_14227_14252 = state_14202__$1;
(statearr_14227_14252[(2)] = inst_14168);

(statearr_14227_14252[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2727__auto__ = null;
var fluree$db$index$state_machine__2727__auto____0 = (function (){
var statearr_14228 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14228[(0)] = fluree$db$index$state_machine__2727__auto__);

(statearr_14228[(1)] = (1));

return statearr_14228;
});
var fluree$db$index$state_machine__2727__auto____1 = (function (state_14202){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14202);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14229){var ex__2730__auto__ = e14229;
var statearr_14230_14253 = state_14202;
(statearr_14230_14253[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14202[(4)]))){
var statearr_14231_14254 = state_14202;
(statearr_14231_14254[(1)] = cljs.core.first((state_14202[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14255 = state_14202;
state_14202 = G__14255;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$state_machine__2727__auto__ = function(state_14202){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2727__auto____1.call(this,state_14202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2727__auto____0;
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2727__auto____1;
return fluree$db$index$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14232 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14232[(6)] = c__2749__auto___14234);

return statearr_14232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return out;
}));

(fluree.db.index.tree_chan.cljs$lang$maxFixedArity = 7);

