// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__73217 = arguments.length;
switch (G__73217) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___73256 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73238){
var state_val_73239 = (state_73238[(1)]);
if((state_val_73239 === (1))){
var state_73238__$1 = state_73238;
var statearr_73240_73257 = state_73238__$1;
(statearr_73240_73257[(2)] = null);

(statearr_73240_73257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73239 === (2))){
var _ = (function (){var statearr_73241 = state_73238;
(statearr_73241[(4)] = cljs.core.cons((5),(state_73238[(4)])));

return statearr_73241;
})();
var inst_73224 = fluree.db.session.db(conn,ledger,null);
var state_73238__$1 = state_73238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73238__$1,(7),inst_73224);
} else {
if((state_val_73239 === (3))){
var inst_73234 = (state_73238[(2)]);
var inst_73235 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73234);
var inst_73236 = cljs.core.async.close_BANG_(pc);
var state_73238__$1 = (function (){var statearr_73243 = state_73238;
(statearr_73243[(7)] = inst_73235);

return statearr_73243;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_73238__$1,inst_73236);
} else {
if((state_val_73239 === (4))){
var inst_73218 = (state_73238[(2)]);
var state_73238__$1 = state_73238;
var statearr_73244_73258 = state_73238__$1;
(statearr_73244_73258[(2)] = inst_73218);

(statearr_73244_73258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73239 === (5))){
var _ = (function (){var statearr_73245 = state_73238;
(statearr_73245[(4)] = cljs.core.rest((state_73238[(4)])));

return statearr_73245;
})();
var state_73238__$1 = state_73238;
var ex73242 = (state_73238__$1[(2)]);
var statearr_73246_73259 = state_73238__$1;
(statearr_73246_73259[(5)] = ex73242);


var statearr_73247_73260 = state_73238__$1;
(statearr_73247_73260[(1)] = (4));

(statearr_73247_73260[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73239 === (6))){
var inst_73230 = (state_73238[(2)]);
var inst_73231 = fluree.db.util.async.throw_err(inst_73230);
var _ = (function (){var statearr_73248 = state_73238;
(statearr_73248[(4)] = cljs.core.rest((state_73238[(4)])));

return statearr_73248;
})();
var state_73238__$1 = state_73238;
var statearr_73249_73261 = state_73238__$1;
(statearr_73249_73261[(2)] = inst_73231);

(statearr_73249_73261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73239 === (7))){
var inst_73226 = (state_73238[(2)]);
var inst_73227 = fluree.db.util.async.throw_err(inst_73226);
var inst_73228 = fluree.db.time_travel.as_of_block(inst_73227,block);
var state_73238__$1 = state_73238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73238__$1,(6),inst_73228);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_73250 = [null,null,null,null,null,null,null,null];
(statearr_73250[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_73250[(1)] = (1));

return statearr_73250;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_73238){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73238);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73251){var ex__2730__auto__ = e73251;
var statearr_73252_73262 = state_73238;
(statearr_73252_73262[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73238[(4)]))){
var statearr_73253_73263 = state_73238;
(statearr_73253_73263[(1)] = cljs.core.first((state_73238[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73264 = state_73238;
state_73238 = G__73264;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_73238){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_73238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73254 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73254[(6)] = c__2749__auto___73256);

return statearr_73254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73305){
var state_val_73306 = (state_73305[(1)]);
if((state_val_73306 === (7))){
var inst_73274 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_73305__$1 = state_73305;
if(inst_73274){
var statearr_73307_73338 = state_73305__$1;
(statearr_73307_73338[(1)] = (9));

} else {
var statearr_73308_73339 = state_73305__$1;
(statearr_73308_73339[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (1))){
var state_73305__$1 = state_73305;
var statearr_73309_73340 = state_73305__$1;
(statearr_73309_73340[(2)] = null);

(statearr_73309_73340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (4))){
var inst_73265 = (state_73305[(2)]);
var state_73305__$1 = state_73305;
var statearr_73310_73341 = state_73305__$1;
(statearr_73310_73341[(2)] = inst_73265);

(statearr_73310_73341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (15))){
var inst_73282 = (state_73305[(7)]);
var inst_73281 = (state_73305[(2)]);
var inst_73282__$1 = fluree.db.util.async.throw_err(inst_73281);
var state_73305__$1 = (function (){var statearr_73311 = state_73305;
(statearr_73311[(7)] = inst_73282__$1);

return statearr_73311;
})();
if(cljs.core.truth_(inst_73282__$1)){
var statearr_73312_73342 = state_73305__$1;
(statearr_73312_73342[(1)] = (16));

} else {
var statearr_73313_73343 = state_73305__$1;
(statearr_73313_73343[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (13))){
var state_73305__$1 = state_73305;
var statearr_73314_73344 = state_73305__$1;
(statearr_73314_73344[(2)] = null);

(statearr_73314_73344[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (6))){
var state_73305__$1 = state_73305;
var statearr_73315_73345 = state_73305__$1;
(statearr_73315_73345[(2)] = db);

(statearr_73315_73345[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (17))){
var inst_73286 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_73287 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73288 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_73289 = cljs.core.PersistentHashMap.fromArrays(inst_73287,inst_73288);
var inst_73290 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73286,inst_73289);
var inst_73291 = (function(){throw inst_73290})();
var state_73305__$1 = state_73305;
var statearr_73316_73346 = state_73305__$1;
(statearr_73316_73346[(2)] = inst_73291);

(statearr_73316_73346[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (3))){
var inst_73303 = (state_73305[(2)]);
var state_73305__$1 = state_73305;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73305__$1,inst_73303);
} else {
if((state_val_73306 === (12))){
var inst_73279 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_73305__$1 = state_73305;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73305__$1,(15),inst_73279);
} else {
if((state_val_73306 === (2))){
var _ = (function (){var statearr_73317 = state_73305;
(statearr_73317[(4)] = cljs.core.cons((5),(state_73305[(4)])));

return statearr_73317;
})();
var inst_73271 = cljs.core.not(auth);
var state_73305__$1 = state_73305;
if(inst_73271){
var statearr_73318_73347 = state_73305__$1;
(statearr_73318_73347[(1)] = (6));

} else {
var statearr_73319_73348 = state_73305__$1;
(statearr_73319_73348[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (11))){
var inst_73298 = (state_73305[(2)]);
var state_73305__$1 = state_73305;
var statearr_73321_73349 = state_73305__$1;
(statearr_73321_73349[(2)] = inst_73298);

(statearr_73321_73349[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (9))){
var inst_73276 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_73305__$1 = state_73305;
var statearr_73322_73350 = state_73305__$1;
(statearr_73322_73350[(2)] = inst_73276);

(statearr_73322_73350[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (5))){
var _ = (function (){var statearr_73323 = state_73305;
(statearr_73323[(4)] = cljs.core.rest((state_73305[(4)])));

return statearr_73323;
})();
var state_73305__$1 = state_73305;
var ex73320 = (state_73305__$1[(2)]);
var statearr_73324_73351 = state_73305__$1;
(statearr_73324_73351[(5)] = ex73320);


if((ex73320 instanceof Error)){
var statearr_73325_73352 = state_73305__$1;
(statearr_73325_73352[(1)] = (4));

(statearr_73325_73352[(5)] = null);

} else {
throw ex73320;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (14))){
var inst_73296 = (state_73305[(2)]);
var state_73305__$1 = state_73305;
var statearr_73326_73353 = state_73305__$1;
(statearr_73326_73353[(2)] = inst_73296);

(statearr_73326_73353[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (16))){
var inst_73282 = (state_73305[(7)]);
var inst_73284 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_73282);
var state_73305__$1 = state_73305;
var statearr_73327_73354 = state_73305__$1;
(statearr_73327_73354[(2)] = inst_73284);

(statearr_73327_73354[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (10))){
var state_73305__$1 = state_73305;
var statearr_73328_73355 = state_73305__$1;
(statearr_73328_73355[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (18))){
var inst_73293 = (state_73305[(2)]);
var state_73305__$1 = state_73305;
var statearr_73330_73356 = state_73305__$1;
(statearr_73330_73356[(2)] = inst_73293);

(statearr_73330_73356[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73306 === (8))){
var inst_73300 = (state_73305[(2)]);
var _ = (function (){var statearr_73331 = state_73305;
(statearr_73331[(4)] = cljs.core.rest((state_73305[(4)])));

return statearr_73331;
})();
var state_73305__$1 = state_73305;
var statearr_73332_73357 = state_73305__$1;
(statearr_73332_73357[(2)] = inst_73300);

(statearr_73332_73357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0 = (function (){
var statearr_73333 = [null,null,null,null,null,null,null,null];
(statearr_73333[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__);

(statearr_73333[(1)] = (1));

return statearr_73333;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1 = (function (state_73305){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73305);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73334){var ex__2730__auto__ = e73334;
var statearr_73335_73358 = state_73305;
(statearr_73335_73358[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73305[(4)]))){
var statearr_73336_73359 = state_73305;
(statearr_73336_73359[(1)] = cljs.core.first((state_73305[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73360 = state_73305;
state_73305 = G__73360;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = function(state_73305){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1.call(this,state_73305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73337 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73337[(6)] = c__2749__auto__);

return statearr_73337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73432){
var state_val_73433 = (state_73432[(1)]);
if((state_val_73433 === (7))){
var inst_73370 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_73432__$1 = state_73432;
if(inst_73370){
var statearr_73434_73488 = state_73432__$1;
(statearr_73434_73488[(1)] = (9));

} else {
var statearr_73435_73489 = state_73432__$1;
(statearr_73435_73489[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (20))){
var inst_73394 = (state_73432[(7)]);
var state_73432__$1 = state_73432;
if(cljs.core.truth_(inst_73394)){
var statearr_73436_73490 = state_73432__$1;
(statearr_73436_73490[(1)] = (22));

} else {
var statearr_73437_73491 = state_73432__$1;
(statearr_73437_73491[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (27))){
var state_73432__$1 = state_73432;
var statearr_73438_73492 = state_73432__$1;
(statearr_73438_73492[(2)] = null);

(statearr_73438_73492[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (1))){
var state_73432__$1 = state_73432;
var statearr_73439_73493 = state_73432__$1;
(statearr_73439_73493[(2)] = null);

(statearr_73439_73493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (24))){
var inst_73408 = (state_73432[(2)]);
var state_73432__$1 = state_73432;
var statearr_73440_73494 = state_73432__$1;
(statearr_73440_73494[(2)] = inst_73408);

(statearr_73440_73494[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (4))){
var inst_73361 = (state_73432[(2)]);
var state_73432__$1 = state_73432;
var statearr_73441_73495 = state_73432__$1;
(statearr_73441_73495[(2)] = inst_73361);

(statearr_73441_73495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (15))){
var inst_73377 = (state_73432[(8)]);
var inst_73376 = (state_73432[(2)]);
var inst_73377__$1 = fluree.db.util.async.throw_err(inst_73376);
var state_73432__$1 = (function (){var statearr_73442 = state_73432;
(statearr_73442[(8)] = inst_73377__$1);

return statearr_73442;
})();
if(cljs.core.truth_(inst_73377__$1)){
var statearr_73443_73496 = state_73432__$1;
(statearr_73443_73496[(1)] = (16));

} else {
var statearr_73444_73497 = state_73432__$1;
(statearr_73444_73497[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (21))){
var inst_73410 = (state_73432[(9)]);
var inst_73410__$1 = (state_73432[(2)]);
var state_73432__$1 = (function (){var statearr_73445 = state_73432;
(statearr_73445[(9)] = inst_73410__$1);

return statearr_73445;
})();
if(cljs.core.truth_(inst_73410__$1)){
var statearr_73446_73498 = state_73432__$1;
(statearr_73446_73498[(1)] = (29));

} else {
var statearr_73447_73499 = state_73432__$1;
(statearr_73447_73499[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (31))){
var inst_73410 = (state_73432[(9)]);
var inst_73418 = (state_73432[(2)]);
var state_73432__$1 = (function (){var statearr_73448 = state_73432;
(statearr_73448[(10)] = inst_73418);

return statearr_73448;
})();
if(cljs.core.truth_(inst_73410)){
var statearr_73449_73500 = state_73432__$1;
(statearr_73449_73500[(1)] = (33));

} else {
var statearr_73450_73501 = state_73432__$1;
(statearr_73450_73501[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (32))){
var inst_73414 = (state_73432[(2)]);
var inst_73415 = fluree.db.util.async.throw_err(inst_73414);
var state_73432__$1 = state_73432;
var statearr_73451_73502 = state_73432__$1;
(statearr_73451_73502[(2)] = inst_73415);

(statearr_73451_73502[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (33))){
var inst_73410 = (state_73432[(9)]);
var inst_73420 = fluree.db.permissions.permission_map(db,inst_73410,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_73432__$1 = state_73432;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73432__$1,(36),inst_73420);
} else {
if((state_val_73433 === (13))){
var state_73432__$1 = state_73432;
var statearr_73452_73503 = state_73432__$1;
(statearr_73452_73503[(2)] = null);

(statearr_73452_73503[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (22))){
var inst_73394 = (state_73432[(7)]);
var inst_73398 = fluree.db.auth.roles(db,inst_73394);
var state_73432__$1 = state_73432;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73432__$1,(25),inst_73398);
} else {
if((state_val_73433 === (36))){
var inst_73422 = (state_73432[(2)]);
var inst_73423 = fluree.db.util.async.throw_err(inst_73422);
var state_73432__$1 = state_73432;
var statearr_73453_73504 = state_73432__$1;
(statearr_73453_73504[(2)] = inst_73423);

(statearr_73453_73504[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (29))){
var inst_73394 = (state_73432[(7)]);
var inst_73410 = (state_73432[(9)]);
var inst_73412 = fluree.db.dbfunctions.ctx.build(db,inst_73394,inst_73410);
var state_73432__$1 = state_73432;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73432__$1,(32),inst_73412);
} else {
if((state_val_73433 === (6))){
var state_73432__$1 = state_73432;
var statearr_73454_73505 = state_73432__$1;
(statearr_73454_73505[(2)] = null);

(statearr_73454_73505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (28))){
var inst_73406 = (state_73432[(2)]);
var state_73432__$1 = state_73432;
var statearr_73455_73506 = state_73432__$1;
(statearr_73455_73506[(2)] = inst_73406);

(statearr_73455_73506[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (25))){
var inst_73400 = (state_73432[(2)]);
var inst_73401 = fluree.db.util.async.throw_err(inst_73400);
var state_73432__$1 = state_73432;
var statearr_73456_73507 = state_73432__$1;
(statearr_73456_73507[(2)] = inst_73401);

(statearr_73456_73507[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (34))){
var state_73432__$1 = state_73432;
var statearr_73457_73508 = state_73432__$1;
(statearr_73457_73508[(2)] = null);

(statearr_73457_73508[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (17))){
var inst_73380 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_73381 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73382 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_73383 = cljs.core.PersistentHashMap.fromArrays(inst_73381,inst_73382);
var inst_73384 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73380,inst_73383);
var inst_73385 = (function(){throw inst_73384})();
var state_73432__$1 = state_73432;
var statearr_73458_73509 = state_73432__$1;
(statearr_73458_73509[(2)] = inst_73385);

(statearr_73458_73509[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (3))){
var inst_73430 = (state_73432[(2)]);
var state_73432__$1 = state_73432;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73432__$1,inst_73430);
} else {
if((state_val_73433 === (12))){
var inst_73374 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_73432__$1 = state_73432;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73432__$1,(15),inst_73374);
} else {
if((state_val_73433 === (2))){
var _ = (function (){var statearr_73459 = state_73432;
(statearr_73459[(4)] = cljs.core.cons((5),(state_73432[(4)])));

return statearr_73459;
})();
var inst_73367 = (auth == null);
var state_73432__$1 = state_73432;
if(cljs.core.truth_(inst_73367)){
var statearr_73460_73510 = state_73432__$1;
(statearr_73460_73510[(1)] = (6));

} else {
var statearr_73461_73511 = state_73432__$1;
(statearr_73461_73511[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (23))){
var state_73432__$1 = state_73432;
var statearr_73462_73512 = state_73432__$1;
(statearr_73462_73512[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (35))){
var inst_73394 = (state_73432[(7)]);
var inst_73410 = (state_73432[(9)]);
var inst_73418 = (state_73432[(10)]);
var inst_73426 = (state_73432[(2)]);
var inst_73427 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_73394,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_73410,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_73426,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_73418], 0));
var _ = (function (){var statearr_73464 = state_73432;
(statearr_73464[(4)] = cljs.core.rest((state_73432[(4)])));

return statearr_73464;
})();
var state_73432__$1 = state_73432;
var statearr_73465_73513 = state_73432__$1;
(statearr_73465_73513[(2)] = inst_73427);

(statearr_73465_73513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (19))){
var state_73432__$1 = state_73432;
var statearr_73466_73514 = state_73432__$1;
(statearr_73466_73514[(2)] = roles);

(statearr_73466_73514[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (11))){
var inst_73392 = (state_73432[(2)]);
var state_73432__$1 = state_73432;
var statearr_73468_73515 = state_73432__$1;
(statearr_73468_73515[(2)] = inst_73392);

(statearr_73468_73515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (9))){
var state_73432__$1 = state_73432;
var statearr_73469_73516 = state_73432__$1;
(statearr_73469_73516[(2)] = (0));

(statearr_73469_73516[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (5))){
var _ = (function (){var statearr_73470 = state_73432;
(statearr_73470[(4)] = cljs.core.rest((state_73432[(4)])));

return statearr_73470;
})();
var state_73432__$1 = state_73432;
var ex73467 = (state_73432__$1[(2)]);
var statearr_73471_73517 = state_73432__$1;
(statearr_73471_73517[(5)] = ex73467);


if((ex73467 instanceof Error)){
var statearr_73472_73518 = state_73432__$1;
(statearr_73472_73518[(1)] = (4));

(statearr_73472_73518[(5)] = null);

} else {
throw ex73467;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (14))){
var inst_73390 = (state_73432[(2)]);
var state_73432__$1 = state_73432;
var statearr_73473_73519 = state_73432__$1;
(statearr_73473_73519[(2)] = inst_73390);

(statearr_73473_73519[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (26))){
var state_73432__$1 = state_73432;
var statearr_73474_73520 = state_73432__$1;
(statearr_73474_73520[(2)] = null);

(statearr_73474_73520[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (16))){
var inst_73377 = (state_73432[(8)]);
var state_73432__$1 = state_73432;
var statearr_73475_73521 = state_73432__$1;
(statearr_73475_73521[(2)] = inst_73377);

(statearr_73475_73521[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (30))){
var state_73432__$1 = state_73432;
var statearr_73476_73522 = state_73432__$1;
(statearr_73476_73522[(2)] = null);

(statearr_73476_73522[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (10))){
var state_73432__$1 = state_73432;
if(cljs.core.truth_(auth)){
var statearr_73477_73523 = state_73432__$1;
(statearr_73477_73523[(1)] = (12));

} else {
var statearr_73478_73524 = state_73432__$1;
(statearr_73478_73524[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (18))){
var inst_73387 = (state_73432[(2)]);
var state_73432__$1 = state_73432;
var statearr_73479_73525 = state_73432__$1;
(statearr_73479_73525[(2)] = inst_73387);

(statearr_73479_73525[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73433 === (8))){
var inst_73394 = (state_73432[(2)]);
var state_73432__$1 = (function (){var statearr_73480 = state_73432;
(statearr_73480[(7)] = inst_73394);

return statearr_73480;
})();
if(cljs.core.truth_(roles)){
var statearr_73481_73526 = state_73432__$1;
(statearr_73481_73526[(1)] = (19));

} else {
var statearr_73482_73527 = state_73432__$1;
(statearr_73482_73527[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0 = (function (){
var statearr_73483 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_73483[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__);

(statearr_73483[(1)] = (1));

return statearr_73483;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1 = (function (state_73432){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73432);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73484){var ex__2730__auto__ = e73484;
var statearr_73485_73528 = state_73432;
(statearr_73485_73528[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73432[(4)]))){
var statearr_73486_73529 = state_73432;
(statearr_73486_73529[(1)] = cljs.core.first((state_73432[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73530 = state_73432;
state_73432 = G__73530;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = function(state_73432){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1.call(this,state_73432);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73487 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73487[(6)] = c__2749__auto__);

return statearr_73487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__73531 = db;
var map__73531__$1 = cljs.core.__destructure_map(map__73531);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73531__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73531__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73531__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73538){
var state_val_73539 = (state_73538[(1)]);
if((state_val_73539 === (1))){
var inst_73532 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_73533 = fluree.db.session.db(conn,inst_73532,null);
var state_73538__$1 = state_73538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73538__$1,(2),inst_73533);
} else {
if((state_val_73539 === (2))){
var inst_73535 = (state_73538[(2)]);
var inst_73536 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_73535);
var state_73538__$1 = state_73538;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73538__$1,inst_73536);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_73540 = [null,null,null,null,null,null,null];
(statearr_73540[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_73540[(1)] = (1));

return statearr_73540;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_73538){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73538);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73541){var ex__2730__auto__ = e73541;
var statearr_73542_73569 = state_73538;
(statearr_73542_73569[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73538[(4)]))){
var statearr_73543_73570 = state_73538;
(statearr_73543_73570[(1)] = cljs.core.first((state_73538[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73571 = state_73538;
state_73538 = G__73571;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_73538){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_73538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73544 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73544[(6)] = c__2749__auto__);

return statearr_73544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,ledger_id,listen_id,event_fn);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73557){
var state_val_73558 = (state_73557[(1)]);
if((state_val_73558 === (1))){
var inst_73545 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_73546 = fluree.db.session.db(conn,inst_73545,null);
var state_73557__$1 = state_73557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73557__$1,(2),inst_73546);
} else {
if((state_val_73558 === (2))){
var inst_73548 = (state_73557[(7)]);
var inst_73548__$1 = (state_73557[(2)]);
var inst_73549 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_73548__$1);
var inst_73550 = newer_block_QMARK_(inst_73549);
var state_73557__$1 = (function (){var statearr_73559 = state_73557;
(statearr_73559[(7)] = inst_73548__$1);

return statearr_73559;
})();
if(inst_73550){
var statearr_73560_73572 = state_73557__$1;
(statearr_73560_73572[(1)] = (3));

} else {
var statearr_73561_73573 = state_73557__$1;
(statearr_73561_73573[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73558 === (3))){
var inst_73548 = (state_73557[(7)]);
var inst_73552 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_73548);
var state_73557__$1 = state_73557;
var statearr_73562_73574 = state_73557__$1;
(statearr_73562_73574[(2)] = inst_73552);

(statearr_73562_73574[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73558 === (4))){
var state_73557__$1 = state_73557;
var statearr_73563_73575 = state_73557__$1;
(statearr_73563_73575[(2)] = null);

(statearr_73563_73575[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73558 === (5))){
var inst_73555 = (state_73557[(2)]);
var state_73557__$1 = state_73557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73557__$1,inst_73555);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_73564 = [null,null,null,null,null,null,null,null];
(statearr_73564[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_73564[(1)] = (1));

return statearr_73564;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_73557){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73557);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73565){var ex__2730__auto__ = e73565;
var statearr_73566_73576 = state_73557;
(statearr_73566_73576[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73557[(4)]))){
var statearr_73567_73577 = state_73557;
(statearr_73567_73577[(1)] = cljs.core.first((state_73557[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73578 = state_73557;
state_73557 = G__73578;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_73557){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_73557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73568 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73568[(6)] = c__2749__auto__);

return statearr_73568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__73579 = db;
var map__73579__$1 = cljs.core.__destructure_map(map__73579);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73579__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73579__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73579__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4339__auto__ = syncTimeout;
var y__4340__auto__ = (120000);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2749__auto___73655 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73629){
var state_val_73630 = (state_73629[(1)]);
if((state_val_73630 === (7))){
var inst_73595 = (state_73629[(7)]);
var inst_73606 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73595,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_73629__$1 = state_73629;
if(inst_73606){
var statearr_73631_73656 = state_73629__$1;
(statearr_73631_73656[(1)] = (9));

} else {
var statearr_73632_73657 = state_73629__$1;
(statearr_73632_73657[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73630 === (1))){
var inst_73588 = (state_73629[(8)]);
var inst_73580 = (state_73629[(9)]);
var inst_73580__$1 = cljs.core.async.timeout(timeout);
var inst_73588__$1 = res_port;
var inst_73589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73590 = [inst_73580__$1,inst_73588__$1];
var inst_73591 = (new cljs.core.PersistentVector(null,2,(5),inst_73589,inst_73590,null));
var state_73629__$1 = (function (){var statearr_73633 = state_73629;
(statearr_73633[(8)] = inst_73588__$1);

(statearr_73633[(9)] = inst_73580__$1);

return statearr_73633;
})();
return cljs.core.async.ioc_alts_BANG_(state_73629__$1,(2),inst_73591);
} else {
if((state_val_73630 === (4))){
var inst_73595 = (state_73629[(7)]);
var inst_73588 = (state_73629[(8)]);
var inst_73599 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73595,inst_73588);
var state_73629__$1 = state_73629;
if(inst_73599){
var statearr_73634_73658 = state_73629__$1;
(statearr_73634_73658[(1)] = (6));

} else {
var statearr_73635_73659 = state_73629__$1;
(statearr_73635_73659[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73630 === (13))){
var inst_73614 = (state_73629[(10)]);
var inst_73625 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73614);
var state_73629__$1 = state_73629;
var statearr_73636_73660 = state_73629__$1;
(statearr_73636_73660[(2)] = inst_73625);

(statearr_73636_73660[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73630 === (6))){
var inst_73593 = (state_73629[(11)]);
var inst_73604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73593,(0),null);
var state_73629__$1 = state_73629;
var statearr_73637_73661 = state_73629__$1;
(statearr_73637_73661[(2)] = inst_73604);

(statearr_73637_73661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73630 === (3))){
var state_73629__$1 = state_73629;
var statearr_73638_73662 = state_73629__$1;
(statearr_73638_73662[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_73638_73662[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73630 === (12))){
var inst_73618 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_73619 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73620 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_73621 = cljs.core.PersistentHashMap.fromArrays(inst_73619,inst_73620);
var inst_73622 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73618,inst_73621);
var inst_73623 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73622);
var state_73629__$1 = state_73629;
var statearr_73639_73663 = state_73629__$1;
(statearr_73639_73663[(2)] = inst_73623);

(statearr_73639_73663[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73630 === (2))){
var inst_73595 = (state_73629[(7)]);
var inst_73580 = (state_73629[(9)]);
var inst_73593 = (state_73629[(11)]);
var inst_73593__$1 = (state_73629[(2)]);
var inst_73594 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73593__$1,(0),null);
var inst_73595__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73593__$1,(1),null);
var inst_73596 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73595__$1,inst_73580);
var state_73629__$1 = (function (){var statearr_73640 = state_73629;
(statearr_73640[(7)] = inst_73595__$1);

(statearr_73640[(12)] = inst_73594);

(statearr_73640[(11)] = inst_73593__$1);

return statearr_73640;
})();
if(inst_73596){
var statearr_73641_73664 = state_73629__$1;
(statearr_73641_73664[(1)] = (3));

} else {
var statearr_73642_73665 = state_73629__$1;
(statearr_73642_73665[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73630 === (11))){
var inst_73610 = (state_73629[(2)]);
var state_73629__$1 = state_73629;
var statearr_73643_73666 = state_73629__$1;
(statearr_73643_73666[(2)] = inst_73610);

(statearr_73643_73666[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73630 === (9))){
var inst_73594 = (state_73629[(12)]);
var state_73629__$1 = state_73629;
var statearr_73644_73667 = state_73629__$1;
(statearr_73644_73667[(2)] = inst_73594);

(statearr_73644_73667[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73630 === (5))){
var inst_73614 = (state_73629[(10)]);
var inst_73614__$1 = (state_73629[(2)]);
var inst_73615 = fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);
var inst_73616 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_73614__$1);
var state_73629__$1 = (function (){var statearr_73645 = state_73629;
(statearr_73645[(10)] = inst_73614__$1);

(statearr_73645[(13)] = inst_73615);

return statearr_73645;
})();
if(inst_73616){
var statearr_73646_73668 = state_73629__$1;
(statearr_73646_73668[(1)] = (12));

} else {
var statearr_73647_73669 = state_73629__$1;
(statearr_73647_73669[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73630 === (14))){
var inst_73627 = (state_73629[(2)]);
var state_73629__$1 = state_73629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73629__$1,inst_73627);
} else {
if((state_val_73630 === (10))){
var state_73629__$1 = state_73629;
var statearr_73648_73670 = state_73629__$1;
(statearr_73648_73670[(2)] = null);

(statearr_73648_73670[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73630 === (8))){
var inst_73612 = (state_73629[(2)]);
var state_73629__$1 = state_73629;
var statearr_73649_73671 = state_73629__$1;
(statearr_73649_73671[(2)] = inst_73612);

(statearr_73649_73671[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0 = (function (){
var statearr_73650 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73650[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__);

(statearr_73650[(1)] = (1));

return statearr_73650;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1 = (function (state_73629){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73629);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73651){var ex__2730__auto__ = e73651;
var statearr_73652_73672 = state_73629;
(statearr_73652_73672[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73629[(4)]))){
var statearr_73653_73673 = state_73629;
(statearr_73653_73673[(1)] = cljs.core.first((state_73629[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73674 = state_73629;
state_73629 = G__73674;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = function(state_73629){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1.call(this,state_73629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73654 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73654[(6)] = c__2749__auto___73655);

return statearr_73654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__73676 = arguments.length;
switch (G__73676) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__73677){
var map__73678 = p__73677;
var map__73678__$1 = cljs.core.__destructure_map(map__73678);
var opts = map__73678__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73678__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73678__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73678__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73678__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73678__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2749__auto___73767 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_73729){
var state_val_73730 = (state_73729[(1)]);
if((state_val_73730 === (7))){
var inst_73691 = (state_73729[(7)]);
var inst_73693 = fluree.db.api.ledger.syncTo_db(inst_73691,syncTo,syncTimeout);
var state_73729__$1 = state_73729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73729__$1,(10),inst_73693);
} else {
if((state_val_73730 === (20))){
var inst_73715 = (state_73729[(8)]);
var state_73729__$1 = state_73729;
var statearr_73731_73768 = state_73729__$1;
(statearr_73731_73768[(2)] = inst_73715);

(statearr_73731_73768[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (1))){
var state_73729__$1 = state_73729;
var statearr_73732_73769 = state_73729__$1;
(statearr_73732_73769[(2)] = null);

(statearr_73732_73769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (4))){
var inst_73679 = (state_73729[(2)]);
var inst_73680 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73679);
var inst_73681 = cljs.core.async.close_BANG_(pc);
var state_73729__$1 = (function (){var statearr_73733 = state_73729;
(statearr_73733[(9)] = inst_73680);

return statearr_73733;
})();
var statearr_73734_73770 = state_73729__$1;
(statearr_73734_73770[(2)] = inst_73681);

(statearr_73734_73770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (15))){
var inst_73707 = (state_73729[(10)]);
var inst_73709 = fluree.db.api.ledger.add_db_permissions(inst_73707,auth,roles);
var state_73729__$1 = state_73729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73729__$1,(18),inst_73709);
} else {
if((state_val_73730 === (21))){
var inst_73723 = (state_73729[(2)]);
var inst_73724 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_73723);
var _ = (function (){var statearr_73735 = state_73729;
(statearr_73735[(4)] = cljs.core.rest((state_73729[(4)])));

return statearr_73735;
})();
var state_73729__$1 = state_73729;
var statearr_73736_73771 = state_73729__$1;
(statearr_73736_73771[(2)] = inst_73724);

(statearr_73736_73771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (13))){
var inst_73707 = (state_73729[(2)]);
var state_73729__$1 = (function (){var statearr_73737 = state_73729;
(statearr_73737[(10)] = inst_73707);

return statearr_73737;
})();
if(cljs.core.truth_(roles)){
var statearr_73738_73772 = state_73729__$1;
(statearr_73738_73772[(1)] = (15));

} else {
var statearr_73739_73773 = state_73729__$1;
(statearr_73739_73773[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (22))){
var inst_73719 = (state_73729[(2)]);
var inst_73720 = fluree.db.util.async.throw_err(inst_73719);
var state_73729__$1 = state_73729;
var statearr_73740_73774 = state_73729__$1;
(statearr_73740_73774[(2)] = inst_73720);

(statearr_73740_73774[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (6))){
var inst_73690 = (state_73729[(2)]);
var inst_73691 = fluree.db.util.async.throw_err(inst_73690);
var state_73729__$1 = (function (){var statearr_73741 = state_73729;
(statearr_73741[(7)] = inst_73691);

return statearr_73741;
})();
if(cljs.core.truth_(syncTo)){
var statearr_73742_73775 = state_73729__$1;
(statearr_73742_73775[(1)] = (7));

} else {
var statearr_73743_73776 = state_73729__$1;
(statearr_73743_73776[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (17))){
var inst_73715 = (state_73729[(2)]);
var state_73729__$1 = (function (){var statearr_73744 = state_73729;
(statearr_73744[(8)] = inst_73715);

return statearr_73744;
})();
if(cljs.core.truth_(auth)){
var statearr_73745_73777 = state_73729__$1;
(statearr_73745_73777[(1)] = (19));

} else {
var statearr_73746_73778 = state_73729__$1;
(statearr_73746_73778[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (3))){
var inst_73727 = (state_73729[(2)]);
var state_73729__$1 = state_73729;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73729__$1,inst_73727);
} else {
if((state_val_73730 === (12))){
var inst_73699 = (state_73729[(11)]);
var state_73729__$1 = state_73729;
var statearr_73747_73779 = state_73729__$1;
(statearr_73747_73779[(2)] = inst_73699);

(statearr_73747_73779[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (2))){
var _ = (function (){var statearr_73748 = state_73729;
(statearr_73748[(4)] = cljs.core.cons((5),(state_73729[(4)])));

return statearr_73748;
})();
var inst_73688 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_73729__$1 = state_73729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73729__$1,(6),inst_73688);
} else {
if((state_val_73730 === (19))){
var inst_73715 = (state_73729[(8)]);
var inst_73717 = fluree.db.api.ledger.add_db_permissions(inst_73715,auth,roles);
var state_73729__$1 = state_73729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73729__$1,(22),inst_73717);
} else {
if((state_val_73730 === (11))){
var inst_73699 = (state_73729[(11)]);
var inst_73701 = fluree.db.time_travel.as_of_block(inst_73699,block);
var state_73729__$1 = state_73729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73729__$1,(14),inst_73701);
} else {
if((state_val_73730 === (9))){
var inst_73699 = (state_73729[(2)]);
var state_73729__$1 = (function (){var statearr_73750 = state_73729;
(statearr_73750[(11)] = inst_73699);

return statearr_73750;
})();
if(cljs.core.truth_(block)){
var statearr_73751_73780 = state_73729__$1;
(statearr_73751_73780[(1)] = (11));

} else {
var statearr_73752_73781 = state_73729__$1;
(statearr_73752_73781[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (5))){
var _ = (function (){var statearr_73753 = state_73729;
(statearr_73753[(4)] = cljs.core.rest((state_73729[(4)])));

return statearr_73753;
})();
var state_73729__$1 = state_73729;
var ex73749 = (state_73729__$1[(2)]);
var statearr_73754_73782 = state_73729__$1;
(statearr_73754_73782[(5)] = ex73749);


var statearr_73755_73783 = state_73729__$1;
(statearr_73755_73783[(1)] = (4));

(statearr_73755_73783[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (14))){
var inst_73703 = (state_73729[(2)]);
var inst_73704 = fluree.db.util.async.throw_err(inst_73703);
var state_73729__$1 = state_73729;
var statearr_73756_73784 = state_73729__$1;
(statearr_73756_73784[(2)] = inst_73704);

(statearr_73756_73784[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (16))){
var inst_73707 = (state_73729[(10)]);
var state_73729__$1 = state_73729;
var statearr_73757_73785 = state_73729__$1;
(statearr_73757_73785[(2)] = inst_73707);

(statearr_73757_73785[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (10))){
var inst_73695 = (state_73729[(2)]);
var inst_73696 = fluree.db.util.async.throw_err(inst_73695);
var state_73729__$1 = state_73729;
var statearr_73758_73786 = state_73729__$1;
(statearr_73758_73786[(2)] = inst_73696);

(statearr_73758_73786[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (18))){
var inst_73711 = (state_73729[(2)]);
var inst_73712 = fluree.db.util.async.throw_err(inst_73711);
var state_73729__$1 = state_73729;
var statearr_73759_73787 = state_73729__$1;
(statearr_73759_73787[(2)] = inst_73712);

(statearr_73759_73787[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73730 === (8))){
var inst_73691 = (state_73729[(7)]);
var state_73729__$1 = state_73729;
var statearr_73760_73788 = state_73729__$1;
(statearr_73760_73788[(2)] = inst_73691);

(statearr_73760_73788[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_73761 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73761[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_73761[(1)] = (1));

return statearr_73761;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_73729){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_73729);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e73762){var ex__2730__auto__ = e73762;
var statearr_73763_73789 = state_73729;
(statearr_73763_73789[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_73729[(4)]))){
var statearr_73764_73790 = state_73729;
(statearr_73764_73790[(1)] = cljs.core.first((state_73729[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73791 = state_73729;
state_73729 = G__73791;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_73729){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_73729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_73765 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_73765[(6)] = c__2749__auto___73767);

return statearr_73765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

