// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('alphabase.base64');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('goog.crypt.base64');
alphabase.base64.base64_chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
alphabase.base64.base64_set = cljs.core.set("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=");
/**
 * Converts a byte array into a base58-check string.
 */
alphabase.base64.encode = (function alphabase$base64$encode(data){
return goog.crypt.base64.encodeByteArray(data);
});
/**
 * Decodes a base58-check string into a byte array.
 */
alphabase.base64.decode = (function alphabase$base64$decode(tokens){
return goog.crypt.base64.decodeStringToByteArray(tokens);
});
/**
 * Test if a string is base64
 */
alphabase.base64.base64_QMARK_ = (function alphabase$base64$base64_QMARK_(x){
return ((typeof x === 'string') && (clojure.set.subset_QMARK_(cljs.core.set(x),alphabase.base64.base64_set)));
});
