// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('sci.impl.evaluator');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('sci.impl.interop');
goog.require('sci.impl.macros');
goog.require('sci.impl.records');
goog.require('sci.impl.types');
goog.require('sci.impl.utils');
goog.require('sci.impl.vars');
sci.impl.evaluator.macros = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Symbol(null,"fn","fn",465265323,null),"null",new cljs.core.Symbol(null,"do","do",1686842252,null),"null",new cljs.core.Symbol(null,"defn","defn",-126010802,null),"null",new cljs.core.Symbol(null,"syntax-quote","syntax-quote",407366680,null),"null",new cljs.core.Symbol(null,"def","def",597100991,null),"null"], null), null);
/**
 * The and macro from clojure.core. Note: and is unrolled in the analyzer, this is a fallback.
 */
sci.impl.evaluator.eval_and = (function sci$impl$evaluator$eval_and(ctx,bindings,args){
var args__$1 = cljs.core.seq.call(null,args);
var args__$2 = args__$1;
while(true){
if(args__$2){
var x = cljs.core.first.call(null,args__$2);
var v = sci.impl.types.eval.call(null,x,ctx,bindings);
if(cljs.core.truth_(v)){
var xs = cljs.core.next.call(null,args__$2);
if(xs){
var G__35618 = xs;
args__$2 = G__35618;
continue;
} else {
return v;
}
} else {
return v;
}
} else {
return true;
}
break;
}
});
/**
 * The or macro from clojure.core. Note: or is unrolled in the analyzer, this is a fallback.
 */
sci.impl.evaluator.eval_or = (function sci$impl$evaluator$eval_or(ctx,bindings,args){
var args__$1 = cljs.core.seq.call(null,args);
var args__$2 = args__$1;
while(true){
if(args__$2){
var x = cljs.core.first.call(null,args__$2);
var v = sci.impl.types.eval.call(null,x,ctx,bindings);
if(cljs.core.truth_(v)){
return v;
} else {
var xs = cljs.core.next.call(null,args__$2);
if(xs){
var G__35619 = xs;
args__$2 = G__35619;
continue;
} else {
return v;
}
}
} else {
return null;
}
break;
}
});
/**
 * The let macro from clojure.core
 */
sci.impl.evaluator.eval_let = (function sci$impl$evaluator$eval_let(ctx,bindings,let_bindings,exprs,idxs){
var vec__35620 = (function (){var ctx__$1 = ctx;
var bindings__$1 = bindings;
var let_bindings__$1 = let_bindings;
var idx = (0);
while(true){
var let_name = cljs.core.first.call(null,let_bindings__$1);
if(cljs.core.truth_(let_name)){
var let_bindings__$2 = cljs.core.rest.call(null,let_bindings__$1);
var let_val = cljs.core.first.call(null,let_bindings__$2);
var rest_let_bindings = cljs.core.next.call(null,let_bindings__$2);
var v = sci.impl.types.eval.call(null,let_val,ctx__$1,bindings__$1);
(bindings__$1[cljs.core.nth.call(null,idxs,idx)] = v);

var G__35623 = ctx__$1;
var G__35624 = bindings__$1;
var G__35625 = rest_let_bindings;
var G__35626 = (idx + (1));
ctx__$1 = G__35623;
bindings__$1 = G__35624;
let_bindings__$1 = G__35625;
idx = G__35626;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ctx__$1,bindings__$1], null);
}
break;
}
})();
var ctx__$1 = cljs.core.nth.call(null,vec__35620,(0),null);
var bindings__$1 = cljs.core.nth.call(null,vec__35620,(1),null);
return sci.impl.types.eval.call(null,exprs,ctx__$1,bindings__$1);
});
sci.impl.evaluator.eval_def = (function sci$impl$evaluator$eval_def(ctx,bindings,var_name,init,m){
var init__$1 = sci.impl.types.eval.call(null,init,ctx,bindings);
var m__$1 = sci.impl.types.eval.call(null,m,ctx,bindings);
var cnn = sci.impl.vars.getName.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m__$1));
var assoc_in_env = (function (env){
var the_current_ns = cljs.core.get.call(null,cljs.core.get.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469)),cnn);
var prev = cljs.core.get.call(null,the_current_ns,var_name);
var prev__$1 = (((!(sci.impl.vars.var_QMARK_.call(null,prev))))?sci.impl.vars.__GT_SciVar.call(null,prev,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnn),cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_name)),cljs.core.meta.call(null,prev),false):prev);
var v = (((sci.impl.utils.var_unbound === init__$1))?(function (){var G__35627 = prev__$1;
cljs.core.alter_meta_BANG_.call(null,G__35627,cljs.core.merge,m__$1);

return G__35627;
})():(function (){
sci.impl.vars.bindRoot.call(null,prev__$1,init__$1);

cljs.core.alter_meta_BANG_.call(null,prev__$1,cljs.core.merge,m__$1);

return prev__$1;
})()
);
var the_current_ns__$1 = cljs.core.assoc.call(null,the_current_ns,var_name,v);
return cljs.core.assoc_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),the_current_ns__$1);
});
var env = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),assoc_in_env);
return cljs.core.get.call(null,cljs.core.get.call(null,cljs.core.get.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469)),cnn),var_name);
});
var ret__4913__auto___35628 = sci.impl.evaluator.resolve_symbol = (function sci$impl$evaluator$resolve_symbol(_AMPERSAND_form,_AMPERSAND_env,bindings,sym){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,".get",".get",1446963300,null),null,(1),null)),(new cljs.core.List(null,cljs.core.with_meta.call(null,bindings,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"java.util.Map","java.util.Map",981564201,null)], null)),null,(1),null)),(new cljs.core.List(null,sym,null,(1),null)))));
});
(sci.impl.evaluator.resolve_symbol.cljs$lang$macro = true);

sci.impl.evaluator.eval_case = (function sci$impl$evaluator$eval_case(var_args){
var G__35630 = arguments.length;
switch (G__35630) {
case 4:
return sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$4 = (function (ctx,bindings,case_map,case_val){
var v = sci.impl.types.eval.call(null,case_val,ctx,bindings);
var temp__5802__auto__ = cljs.core.find.call(null,case_map,v);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__35631 = temp__5802__auto__;
var _ = cljs.core.nth.call(null,vec__35631,(0),null);
var found = cljs.core.nth.call(null,vec__35631,(1),null);
return sci.impl.types.eval.call(null,found,ctx,bindings);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')));
}
}));

(sci.impl.evaluator.eval_case.cljs$core$IFn$_invoke$arity$5 = (function (ctx,bindings,case_map,case_val,case_default){
var v = sci.impl.types.eval.call(null,case_val,ctx,bindings);
var temp__5802__auto__ = cljs.core.find.call(null,case_map,v);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__35634 = temp__5802__auto__;
var _ = cljs.core.nth.call(null,vec__35634,(0),null);
var found = cljs.core.nth.call(null,vec__35634,(1),null);
return sci.impl.types.eval.call(null,found,ctx,bindings);
} else {
return sci.impl.types.eval.call(null,case_default,ctx,bindings);
}
}));

(sci.impl.evaluator.eval_case.cljs$lang$maxFixedArity = 5);

sci.impl.evaluator.eval_try = (function sci$impl$evaluator$eval_try(ctx,bindings,body,catches,finally$){
try{var _STAR_in_try_STAR__orig_val__35642 = sci.impl.utils._STAR_in_try_STAR_;
var _STAR_in_try_STAR__temp_val__35643 = true;
(sci.impl.utils._STAR_in_try_STAR_ = _STAR_in_try_STAR__temp_val__35643);

try{return sci.impl.types.eval.call(null,body,ctx,bindings);
}finally {(sci.impl.utils._STAR_in_try_STAR_ = _STAR_in_try_STAR__orig_val__35642);
}}catch (e35638){var e = e35638;
var temp__5802__auto__ = cljs.core.reduce.call(null,(function (_,c){
var clazz = new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(c);
if(cljs.core.truth_((function (){var or__4253__auto__ = cljs.core.keyword_identical_QMARK_.call(null,new cljs.core.Keyword(null,"default","default",-1987822328),clazz);
if(or__4253__auto__){
return or__4253__auto__;
} else {
if((clazz instanceof sci.impl.types.NodeR)){
var c__4284__auto__ = sci.impl.types.eval.call(null,clazz,ctx,bindings);
var x__4285__auto__ = e;
return (x__4285__auto__ instanceof c__4284__auto__);
} else {
return (e instanceof clazz);
}
}
})())){
return cljs.core.reduced.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("sci.impl.evaluator","try-result","sci.impl.evaluator/try-result",-1394897780),(function (){
(bindings[new cljs.core.Keyword(null,"ex-idx","ex-idx",795118805).cljs$core$IFn$_invoke$arity$1(c)] = e);

return sci.impl.types.eval.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(c),ctx,bindings);
})()
], null));
} else {
return null;
}
}),null,catches);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__35639 = temp__5802__auto__;
var _ = cljs.core.nth.call(null,vec__35639,(0),null);
var r = cljs.core.nth.call(null,vec__35639,(1),null);
return r;
} else {
return sci.impl.utils.rethrow_with_location_of_node.call(null,ctx,bindings,e,body);
}
}finally {sci.impl.types.eval.call(null,finally$,ctx,bindings);
}});
sci.impl.evaluator.eval_static_method_invocation = (function sci$impl$evaluator$eval_static_method_invocation(ctx,bindings,expr){
return sci.impl.interop.invoke_static_method.call(null,cljs.core.first.call(null,expr),cljs.core.map.call(null,(function (p1__35644_SHARP_){
return sci.impl.types.eval.call(null,p1__35644_SHARP_,ctx,bindings);
}),cljs.core.rest.call(null,expr)));
});
sci.impl.evaluator.eval_instance_method_invocation = (function sci$impl$evaluator$eval_instance_method_invocation(ctx,bindings,instance_expr,method_str,field_access,args,allowed){
var instance_meta = cljs.core.meta.call(null,instance_expr);
var tag_class = new cljs.core.Keyword(null,"tag-class","tag-class",714967874).cljs$core$IFn$_invoke$arity$1(instance_meta);
var instance_expr_STAR_ = sci.impl.types.eval.call(null,instance_expr,ctx,bindings);
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core.map_QMARK_.call(null,instance_expr_STAR_);
if(and__4251__auto__){
return new cljs.core.Keyword("sci.impl","record","sci.impl/record",-1939193950).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,instance_expr_STAR_));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.get.call(null,instance_expr_STAR_,cljs.core.keyword.call(null,method_str));
} else {
var instance_class = (function (){var or__4253__auto__ = tag_class;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.type.call(null,instance_expr_STAR_);
}
})();
var class__GT_opts = new cljs.core.Keyword(null,"class->opts","class->opts",2061906477).cljs$core$IFn$_invoke$arity$1(ctx);
var allowed_QMARK_ = (function (){var or__4253__auto__ = allowed;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core.get.call(null,class__GT_opts,new cljs.core.Keyword(null,"allow","allow",-1857325745));
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = (function (){var instance_class_name = instance_class.name;
var instance_class_symbol = cljs.core.symbol.call(null,instance_class_name);
return cljs.core.get.call(null,class__GT_opts,instance_class_symbol);
})();
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
return console.log(cljs.core.str.cljs$core$IFn$_invoke$arity$1(method_str));
}
}
}
})();
var target_class = (cljs.core.truth_(allowed_QMARK_)?instance_class:(function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"public-class","public-class",1127293019).cljs$core$IFn$_invoke$arity$1(ctx);
if(cljs.core.truth_(temp__5804__auto__)){
var f = temp__5804__auto__;
return f.call(null,instance_expr_STAR_);
} else {
return null;
}
})());
if(cljs.core.truth_(allowed_QMARK_)){
} else {
sci.impl.utils.throw_error_with_location.call(null,["Method ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(method_str)," on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(instance_class)," not allowed!"].join(''),instance_expr);
}

if(cljs.core.truth_(field_access)){
return sci.impl.interop.invoke_instance_field.call(null,instance_expr_STAR_,target_class,method_str);
} else {
var args__$1 = cljs.core.map.call(null,(function (p1__35646_SHARP_){
return sci.impl.types.eval.call(null,p1__35646_SHARP_,ctx,bindings);
}),args);
return sci.impl.interop.invoke_instance_method.call(null,instance_expr_STAR_,target_class,method_str,args__$1);
}
}
});
sci.impl.evaluator.eval_resolve = (function sci$impl$evaluator$eval_resolve(var_args){
var G__35648 = arguments.length;
switch (G__35648) {
case 3:
return sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$3 = (function (ctx,bindings,sym){
return sci.impl.evaluator.eval_resolve.call(null,ctx,bindings,null,sym);
}));

(sci.impl.evaluator.eval_resolve.cljs$core$IFn$_invoke$arity$4 = (function (ctx,bindings,env,sym){
if(((cljs.core.not.call(null,env)) || ((!(cljs.core.contains_QMARK_.call(null,env,sym)))))){
var sym__$1 = sci.impl.types.eval.call(null,sym,ctx,bindings);
var res = cljs.core.second.call(null,cljs.core.deref.call(null,sci.impl.utils.lookup).call(null,ctx,sym__$1,false));
if((res instanceof sci.impl.types.NodeR)){
return null;
} else {
return res;
}
} else {
return null;
}
}));

(sci.impl.evaluator.eval_resolve.cljs$lang$maxFixedArity = 4);

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_resolve_state,sci.impl.evaluator.eval_resolve);
sci.impl.evaluator.eval_import = (function sci$impl$evaluator$eval_import(var_args){
var args__4870__auto__ = [];
var len__4864__auto___35656 = arguments.length;
var i__4865__auto___35657 = (0);
while(true){
if((i__4865__auto___35657 < len__4864__auto___35656)){
args__4870__auto__.push((arguments[i__4865__auto___35657]));

var G__35658 = (i__4865__auto___35657 + (1));
i__4865__auto___35657 = G__35658;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return sci.impl.evaluator.eval_import.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(sci.impl.evaluator.eval_import.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,import_symbols_or_lists){
var specs = cljs.core.map.call(null,(function (p1__35650_SHARP_){
if(((cljs.core.seq_QMARK_.call(null,p1__35650_SHARP_)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,p1__35650_SHARP_))))){
return cljs.core.second.call(null,p1__35650_SHARP_);
} else {
return p1__35650_SHARP_;
}
}),import_symbols_or_lists);
var env = new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx);
return cljs.core.reduce.call(null,(function (_,spec){
var vec__35653 = (((spec instanceof cljs.core.Symbol))?(function (){var s = cljs.core.str.cljs$core$IFn$_invoke$arity$1(spec);
var last_dot = clojure.string.last_index_of.call(null,s,".");
var package_PLUS_class_name = (cljs.core.truth_(last_dot)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,cljs.core.subs.call(null,s,(0),last_dot)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,cljs.core.subs.call(null,s,(last_dot + (1)),((s).length)))], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec], null)], null));
return package_PLUS_class_name;
})():(function (){var p = cljs.core.first.call(null,spec);
var cs = cljs.core.rest.call(null,spec);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cs], null);
})());
var package$ = cljs.core.nth.call(null,vec__35653,(0),null);
var classes = cljs.core.nth.call(null,vec__35653,(1),null);
return cljs.core.reduce.call(null,(function (___$1,class$){
var fq_class_name = cljs.core.symbol.call(null,(cljs.core.truth_(package$)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(package$),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)].join(''):class$));
var temp__5802__auto__ = sci.impl.interop.resolve_class.call(null,ctx,fq_class_name);
if(cljs.core.truth_(temp__5802__auto__)){
var clazz = temp__5802__auto__;
var cnn = sci.impl.vars.current_ns_name.call(null);
cljs.core.swap_BANG_.call(null,env,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,new cljs.core.Keyword(null,"imports","imports",-1249933394),class$], null),fq_class_name);

return clazz;
} else {
var temp__5802__auto____$1 = sci.impl.records.resolve_record_or_protocol_class.call(null,ctx,package$,class$);
if(cljs.core.truth_(temp__5802__auto____$1)){
var rec = temp__5802__auto____$1;
var cnn = sci.impl.vars.current_ns_name.call(null);
cljs.core.swap_BANG_.call(null,env,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,class$], null),rec);

return rec;
} else {
throw (new Error(["Unable to resolve classname: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fq_class_name)].join('')));
}
}
}),null,classes);
}),null,specs);
}));

(sci.impl.evaluator.eval_import.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.evaluator.eval_import.cljs$lang$applyTo = (function (seq35651){
var G__35652 = cljs.core.first.call(null,seq35651);
var seq35651__$1 = cljs.core.next.call(null,seq35651);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35652,seq35651__$1);
}));

/**
 * Note: various arities of do have already been unrolled in the analyzer.
 */
sci.impl.evaluator.eval_do = (function sci$impl$evaluator$eval_do(ctx,bindings,exprs){
var exprs__$1 = cljs.core.seq.call(null,exprs);
var exprs__$2 = exprs__$1;
while(true){
if(exprs__$2){
var ret = sci.impl.types.eval.call(null,cljs.core.first.call(null,exprs__$2),ctx,bindings);
var temp__5802__auto__ = cljs.core.next.call(null,exprs__$2);
if(temp__5802__auto__){
var exprs__$3 = temp__5802__auto__;
var G__35659 = exprs__$3;
exprs__$2 = G__35659;
continue;
} else {
return ret;
}
} else {
return null;
}
break;
}
});
cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_do_STAR_,sci.impl.evaluator.eval_do);
sci.impl.evaluator.fn_call = (function sci$impl$evaluator$fn_call(ctx,bindings,f,args){
var G__35854 = cljs.core.count.call(null,args);
switch (G__35854) {
case (0):
return f.call(null);

break;
case (1):
var arg35664 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
return f.call(null,arg35664);

break;
case (2):
var arg35665 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35666 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
return f.call(null,arg35665,arg35666);

break;
case (3):
var arg35667 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35668 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35669 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
return f.call(null,arg35667,arg35668,arg35669);

break;
case (4):
var arg35670 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35671 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35672 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35673 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
return f.call(null,arg35670,arg35671,arg35672,arg35673);

break;
case (5):
var arg35674 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35675 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35676 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35677 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35678 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
return f.call(null,arg35674,arg35675,arg35676,arg35677,arg35678);

break;
case (6):
var arg35679 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35680 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35681 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35682 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35683 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg35684 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
return f.call(null,arg35679,arg35680,arg35681,arg35682,arg35683,arg35684);

break;
case (7):
var arg35685 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35686 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35687 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35688 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35689 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg35690 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg35691 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
return f.call(null,arg35685,arg35686,arg35687,arg35688,arg35689,arg35690,arg35691);

break;
case (8):
var arg35692 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35693 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35694 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35695 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35696 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg35697 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg35698 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg35699 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
return f.call(null,arg35692,arg35693,arg35694,arg35695,arg35696,arg35697,arg35698,arg35699);

break;
case (9):
var arg35700 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35701 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35702 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35703 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35704 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg35705 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg35706 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg35707 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg35708 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
return f.call(null,arg35700,arg35701,arg35702,arg35703,arg35704,arg35705,arg35706,arg35707,arg35708);

break;
case (10):
var arg35709 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35710 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35711 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35712 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35713 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg35714 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg35715 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg35716 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg35717 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg35718 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
return f.call(null,arg35709,arg35710,arg35711,arg35712,arg35713,arg35714,arg35715,arg35716,arg35717,arg35718);

break;
case (11):
var arg35719 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35720 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35721 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35722 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35723 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg35724 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg35725 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg35726 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg35727 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg35728 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg35729 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
return f.call(null,arg35719,arg35720,arg35721,arg35722,arg35723,arg35724,arg35725,arg35726,arg35727,arg35728,arg35729);

break;
case (12):
var arg35730 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35731 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35732 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35733 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35734 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg35735 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg35736 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg35737 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg35738 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg35739 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg35740 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg35741 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
return f.call(null,arg35730,arg35731,arg35732,arg35733,arg35734,arg35735,arg35736,arg35737,arg35738,arg35739,arg35740,arg35741);

break;
case (13):
var arg35742 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35743 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35744 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35745 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35746 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg35747 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg35748 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg35749 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg35750 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg35751 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg35752 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg35753 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg35754 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
return f.call(null,arg35742,arg35743,arg35744,arg35745,arg35746,arg35747,arg35748,arg35749,arg35750,arg35751,arg35752,arg35753,arg35754);

break;
case (14):
var arg35755 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35756 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35757 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35758 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35759 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg35760 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg35761 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg35762 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg35763 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg35764 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg35765 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg35766 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg35767 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg35768 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
return f.call(null,arg35755,arg35756,arg35757,arg35758,arg35759,arg35760,arg35761,arg35762,arg35763,arg35764,arg35765,arg35766,arg35767,arg35768);

break;
case (15):
var arg35769 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35770 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35771 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35772 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35773 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg35774 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg35775 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg35776 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg35777 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg35778 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg35779 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg35780 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg35781 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg35782 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg35783 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
return f.call(null,arg35769,arg35770,arg35771,arg35772,arg35773,arg35774,arg35775,arg35776,arg35777,arg35778,arg35779,arg35780,arg35781,arg35782,arg35783);

break;
case (16):
var arg35784 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35785 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35786 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35787 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35788 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg35789 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg35790 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg35791 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg35792 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg35793 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg35794 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg35795 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg35796 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg35797 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg35798 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg35799 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
return f.call(null,arg35784,arg35785,arg35786,arg35787,arg35788,arg35789,arg35790,arg35791,arg35792,arg35793,arg35794,arg35795,arg35796,arg35797,arg35798,arg35799);

break;
case (17):
var arg35800 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35801 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35802 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35803 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35804 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg35805 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg35806 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg35807 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg35808 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg35809 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg35810 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg35811 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg35812 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg35813 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg35814 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg35815 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
var arg35816 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$16),ctx,bindings);
var args__$17 = cljs.core.rest.call(null,args__$16);
return f.call(null,arg35800,arg35801,arg35802,arg35803,arg35804,arg35805,arg35806,arg35807,arg35808,arg35809,arg35810,arg35811,arg35812,arg35813,arg35814,arg35815,arg35816);

break;
case (18):
var arg35817 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35818 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35819 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35820 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35821 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg35822 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg35823 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg35824 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg35825 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg35826 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg35827 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg35828 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg35829 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg35830 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg35831 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg35832 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
var arg35833 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$16),ctx,bindings);
var args__$17 = cljs.core.rest.call(null,args__$16);
var arg35834 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$17),ctx,bindings);
var args__$18 = cljs.core.rest.call(null,args__$17);
return f.call(null,arg35817,arg35818,arg35819,arg35820,arg35821,arg35822,arg35823,arg35824,arg35825,arg35826,arg35827,arg35828,arg35829,arg35830,arg35831,arg35832,arg35833,arg35834);

break;
case (19):
var arg35835 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args),ctx,bindings);
var args__$1 = cljs.core.rest.call(null,args);
var arg35836 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$1),ctx,bindings);
var args__$2 = cljs.core.rest.call(null,args__$1);
var arg35837 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$2),ctx,bindings);
var args__$3 = cljs.core.rest.call(null,args__$2);
var arg35838 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$3),ctx,bindings);
var args__$4 = cljs.core.rest.call(null,args__$3);
var arg35839 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$4),ctx,bindings);
var args__$5 = cljs.core.rest.call(null,args__$4);
var arg35840 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$5),ctx,bindings);
var args__$6 = cljs.core.rest.call(null,args__$5);
var arg35841 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$6),ctx,bindings);
var args__$7 = cljs.core.rest.call(null,args__$6);
var arg35842 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$7),ctx,bindings);
var args__$8 = cljs.core.rest.call(null,args__$7);
var arg35843 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$8),ctx,bindings);
var args__$9 = cljs.core.rest.call(null,args__$8);
var arg35844 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$9),ctx,bindings);
var args__$10 = cljs.core.rest.call(null,args__$9);
var arg35845 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$10),ctx,bindings);
var args__$11 = cljs.core.rest.call(null,args__$10);
var arg35846 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$11),ctx,bindings);
var args__$12 = cljs.core.rest.call(null,args__$11);
var arg35847 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$12),ctx,bindings);
var args__$13 = cljs.core.rest.call(null,args__$12);
var arg35848 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$13),ctx,bindings);
var args__$14 = cljs.core.rest.call(null,args__$13);
var arg35849 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$14),ctx,bindings);
var args__$15 = cljs.core.rest.call(null,args__$14);
var arg35850 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$15),ctx,bindings);
var args__$16 = cljs.core.rest.call(null,args__$15);
var arg35851 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$16),ctx,bindings);
var args__$17 = cljs.core.rest.call(null,args__$16);
var arg35852 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$17),ctx,bindings);
var args__$18 = cljs.core.rest.call(null,args__$17);
var arg35853 = sci.impl.types.eval.call(null,cljs.core.first.call(null,args__$18),ctx,bindings);
var args__$19 = cljs.core.rest.call(null,args__$18);
return f.call(null,arg35835,arg35836,arg35837,arg35838,arg35839,arg35840,arg35841,arg35842,arg35843,arg35844,arg35845,arg35846,arg35847,arg35848,arg35849,arg35850,arg35851,arg35852,arg35853);

break;
default:
var args__$1 = cljs.core.mapv.call(null,(function (p1__35374_SHARP_){
return sci.impl.types.eval.call(null,p1__35374_SHARP_,ctx,bindings);
}),args);
return cljs.core.apply.call(null,f,args__$1);

}
});
