// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5804__auto__ = e.response;
if(cljs.core.truth_(temp__5804__auto__)){
var resp = temp__5804__auto__;
var temp__5804__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5804__auto____$1)){
var st = temp__5804__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_.call(null,e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status >= (500));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.call(null,"XHTTP Request Error:",e.request);

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status > (0));
} else {
return and__4251__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__18896 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__18896,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__18896;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__18897 = opts;
var map__18897__$1 = cljs.core.__destructure_map.call(null,map__18897);
var request_timeout = cljs.core.get.call(null,map__18897__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__18897__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__18897__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__18898 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__18898__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__18898,headers):G__18898);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__18898__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__18898__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.call(null,response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true)));
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json, :edn or :binary (default :text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__18899 = opts;
var map__18899__$1 = cljs.core.__destructure_map.call(null,map__18899);
var request_timeout = cljs.core.get.call(null,map__18899__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__18899__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__18899__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__18899__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__18899__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__18900 = cljs.core.PersistentArrayMap.EMPTY;
var G__18900__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__18900,headers):G__18900);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__18900__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__18900__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__18901 = output_format;
var G__18901__$1 = (((G__18901 instanceof cljs.core.Keyword))?G__18901.fqn:null);
switch (G__18901__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify.call(null,data);

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__18903 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__18903,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__18903;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18935){
var state_val_18936 = (state_18935[(1)]);
if((state_val_18936 === (7))){
var inst_18931 = (state_18935[(2)]);
var state_18935__$1 = state_18935;
var statearr_18937_18962 = state_18935__$1;
(statearr_18937_18962[(2)] = inst_18931);

(statearr_18937_18962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18936 === (1))){
var state_18935__$1 = state_18935;
var statearr_18938_18963 = state_18935__$1;
(statearr_18938_18963[(2)] = null);

(statearr_18938_18963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18936 === (4))){
var inst_18906 = (state_18935[(7)]);
var inst_18906__$1 = (state_18935[(2)]);
var inst_18907 = (inst_18906__$1 == null);
var state_18935__$1 = (function (){var statearr_18939 = state_18935;
(statearr_18939[(7)] = inst_18906__$1);

return statearr_18939;
})();
if(cljs.core.truth_(inst_18907)){
var statearr_18940_18964 = state_18935__$1;
(statearr_18940_18964[(1)] = (5));

} else {
var statearr_18941_18965 = state_18935__$1;
(statearr_18941_18965[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18936 === (6))){
var inst_18906 = (state_18935[(7)]);
var inst_18914 = cljs.core.nth.call(null,inst_18906,(0),null);
var inst_18915 = cljs.core.nth.call(null,inst_18906,(1),null);
var state_18935__$1 = (function (){var statearr_18942 = state_18935;
(statearr_18942[(8)] = inst_18915);

(statearr_18942[(9)] = inst_18914);

return statearr_18942;
})();
var statearr_18943_18966 = state_18935__$1;
(statearr_18943_18966[(2)] = null);

(statearr_18943_18966[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18936 === (3))){
var inst_18933 = (state_18935[(2)]);
var state_18935__$1 = state_18935;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18935__$1,inst_18933);
} else {
if((state_val_18936 === (2))){
var state_18935__$1 = state_18935;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18935__$1,(4),pub_chan);
} else {
if((state_val_18936 === (11))){
var _ = (function (){var statearr_18945 = state_18935;
(statearr_18945[(4)] = cljs.core.rest.call(null,(state_18935[(4)])));

return statearr_18945;
})();
var state_18935__$1 = state_18935;
var ex18944 = (state_18935__$1[(2)]);
var statearr_18946_18967 = state_18935__$1;
(statearr_18946_18967[(5)] = ex18944);


var statearr_18947_18968 = state_18935__$1;
(statearr_18947_18968[(1)] = (10));

(statearr_18947_18968[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18936 === (9))){
var inst_18928 = (state_18935[(2)]);
var state_18935__$1 = (function (){var statearr_18948 = state_18935;
(statearr_18948[(10)] = inst_18928);

return statearr_18948;
})();
var statearr_18949_18969 = state_18935__$1;
(statearr_18949_18969[(2)] = null);

(statearr_18949_18969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18936 === (5))){
var inst_18909 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_18935__$1 = state_18935;
var statearr_18950_18970 = state_18935__$1;
(statearr_18950_18970[(2)] = inst_18909);

(statearr_18950_18970[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18936 === (10))){
var inst_18915 = (state_18935[(8)]);
var inst_18914 = (state_18935[(9)]);
var inst_18916 = (state_18935[(2)]);
var inst_18917 = fluree.db.util.log.error.call(null,inst_18916,"Error sending websocket message:",inst_18914);
var inst_18918 = cljs.core.async.put_BANG_.call(null,inst_18915,false);
var state_18935__$1 = (function (){var statearr_18951 = state_18935;
(statearr_18951[(11)] = inst_18917);

return statearr_18951;
})();
var statearr_18952_18971 = state_18935__$1;
(statearr_18952_18971[(2)] = inst_18918);

(statearr_18952_18971[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18936 === (8))){
var inst_18915 = (state_18935[(8)]);
var inst_18914 = (state_18935[(9)]);
var _ = (function (){var statearr_18953 = state_18935;
(statearr_18953[(4)] = cljs.core.cons.call(null,(11),(state_18935[(4)])));

return statearr_18953;
})();
var inst_18924 = ws.send(inst_18914);
var inst_18925 = cljs.core.async.put_BANG_.call(null,inst_18915,true);
var ___$1 = (function (){var statearr_18954 = state_18935;
(statearr_18954[(4)] = cljs.core.rest.call(null,(state_18935[(4)])));

return statearr_18954;
})();
var state_18935__$1 = (function (){var statearr_18955 = state_18935;
(statearr_18955[(12)] = inst_18924);

return statearr_18955;
})();
var statearr_18956_18972 = state_18935__$1;
(statearr_18956_18972[(2)] = inst_18925);

(statearr_18956_18972[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto____0 = (function (){
var statearr_18957 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18957[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto__);

(statearr_18957[(1)] = (1));

return statearr_18957;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto____1 = (function (state_18935){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18935);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18958){var ex__2749__auto__ = e18958;
var statearr_18959_18973 = state_18935;
(statearr_18959_18973[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18935[(4)]))){
var statearr_18960_18974 = state_18935;
(statearr_18960_18974[(1)] = cljs.core.first.call(null,(state_18935[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18975 = state_18935;
state_18935 = G__18975;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto__ = function(state_18935){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto____1.call(this,state_18935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18961 = f__2769__auto__.call(null);
(statearr_18961[(6)] = c__2768__auto__);

return statearr_18961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__2768__auto___19013 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19000){
var state_val_19001 = (state_19000[(1)]);
if((state_val_19001 === (1))){
var inst_18979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18980 = [open_QMARK_,timeout_chan];
var inst_18981 = (new cljs.core.PersistentVector(null,2,(5),inst_18979,inst_18980,null));
var state_19000__$1 = state_19000;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19000__$1,(2),inst_18981,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_19001 === (2))){
var inst_18983 = (state_19000[(2)]);
var inst_18984 = cljs.core.nth.call(null,inst_18983,(0),null);
var inst_18985 = cljs.core.nth.call(null,inst_18983,(1),null);
var inst_18986 = cljs.core._EQ_.call(null,inst_18985,timeout_chan);
var state_19000__$1 = (function (){var statearr_19002 = state_19000;
(statearr_19002[(7)] = inst_18984);

return statearr_19002;
})();
if(inst_18986){
var statearr_19003_19014 = state_19000__$1;
(statearr_19003_19014[(1)] = (3));

} else {
var statearr_19004_19015 = state_19000__$1;
(statearr_19004_19015[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19001 === (3))){
var inst_18988 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_18989 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18990 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_18991 = cljs.core.PersistentHashMap.fromArrays(inst_18989,inst_18990);
var inst_18992 = cljs.core.ex_info.call(null,inst_18988,inst_18991);
var inst_18993 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_18992);
var inst_18994 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_19000__$1 = (function (){var statearr_19005 = state_19000;
(statearr_19005[(8)] = inst_18993);

return statearr_19005;
})();
var statearr_19006_19016 = state_19000__$1;
(statearr_19006_19016[(2)] = inst_18994);

(statearr_19006_19016[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19001 === (4))){
var inst_18996 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_19000__$1 = state_19000;
var statearr_19007_19017 = state_19000__$1;
(statearr_19007_19017[(2)] = inst_18996);

(statearr_19007_19017[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19001 === (5))){
var inst_18998 = (state_19000[(2)]);
var state_19000__$1 = state_19000;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19000__$1,inst_18998);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_19008 = [null,null,null,null,null,null,null,null,null];
(statearr_19008[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto__);

(statearr_19008[(1)] = (1));

return statearr_19008;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto____1 = (function (state_19000){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19000);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19009){var ex__2749__auto__ = e19009;
var statearr_19010_19018 = state_19000;
(statearr_19010_19018[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19000[(4)]))){
var statearr_19011_19019 = state_19000;
(statearr_19011_19019[(1)] = cljs.core.first.call(null,(state_19000[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19020 = state_19000;
state_19000 = G__19020;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto__ = function(state_19000){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto____1.call(this,state_19000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19012 = f__2769__auto__.call(null);
(statearr_19012[(6)] = c__2768__auto___19013);

return statearr_19012;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
