// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4253__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_11566){
var state_val_11567 = (state_11566[(1)]);
if((state_val_11567 === (7))){
var inst_11561 = (state_11566[(2)]);
var _ = (function (){var statearr_11568 = state_11566;
(statearr_11568[(4)] = cljs.core.rest.call(null,(state_11566[(4)])));

return statearr_11568;
})();
var state_11566__$1 = state_11566;
var statearr_11569_11591 = state_11566__$1;
(statearr_11569_11591[(2)] = inst_11561);

(statearr_11569_11591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11567 === (1))){
var state_11566__$1 = state_11566;
var statearr_11570_11592 = state_11566__$1;
(statearr_11570_11592[(2)] = null);

(statearr_11570_11592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11567 === (4))){
var inst_11523 = (state_11566[(2)]);
var state_11566__$1 = state_11566;
var statearr_11571_11593 = state_11566__$1;
(statearr_11571_11593[(2)] = inst_11523);

(statearr_11571_11593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11567 === (6))){
var inst_11548 = (state_11566[(7)]);
var inst_11541 = (state_11566[(8)]);
var inst_11547 = cljs.core.seq.call(null,inst_11541);
var inst_11548__$1 = cljs.core.first.call(null,inst_11547);
var inst_11549 = cljs.core.next.call(null,inst_11547);
var inst_11550 = cljs.core.not.call(null,inst_11548__$1);
var state_11566__$1 = (function (){var statearr_11572 = state_11566;
(statearr_11572[(9)] = inst_11549);

(statearr_11572[(7)] = inst_11548__$1);

return statearr_11572;
})();
if(inst_11550){
var statearr_11573_11594 = state_11566__$1;
(statearr_11573_11594[(1)] = (8));

} else {
var statearr_11574_11595 = state_11566__$1;
(statearr_11574_11595[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11567 === (3))){
var inst_11564 = (state_11566[(2)]);
var state_11566__$1 = state_11566;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11566__$1,inst_11564);
} else {
if((state_val_11567 === (2))){
var _ = (function (){var statearr_11575 = state_11566;
(statearr_11575[(4)] = cljs.core.cons.call(null,(5),(state_11566[(4)])));

return statearr_11575;
})();
var inst_11536 = chs;
var inst_11537 = cljs.core.seq.call(null,inst_11536);
var inst_11538 = cljs.core.first.call(null,inst_11537);
var inst_11539 = cljs.core.next.call(null,inst_11537);
var inst_11540 = coll;
var inst_11541 = inst_11536;
var inst_11542 = inst_11540;
var state_11566__$1 = (function (){var statearr_11576 = state_11566;
(statearr_11576[(10)] = inst_11538);

(statearr_11576[(11)] = inst_11539);

(statearr_11576[(8)] = inst_11541);

(statearr_11576[(12)] = inst_11542);

return statearr_11576;
})();
var statearr_11577_11596 = state_11566__$1;
(statearr_11577_11596[(2)] = null);

(statearr_11577_11596[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11567 === (11))){
var inst_11549 = (state_11566[(9)]);
var inst_11542 = (state_11566[(12)]);
var inst_11554 = (state_11566[(2)]);
var inst_11555 = fluree.db.util.async.throw_err.call(null,inst_11554);
var inst_11556 = cljs.core.conj.call(null,inst_11542,inst_11555);
var inst_11541 = inst_11549;
var inst_11542__$1 = inst_11556;
var state_11566__$1 = (function (){var statearr_11579 = state_11566;
(statearr_11579[(8)] = inst_11541);

(statearr_11579[(12)] = inst_11542__$1);

return statearr_11579;
})();
var statearr_11580_11597 = state_11566__$1;
(statearr_11580_11597[(2)] = null);

(statearr_11580_11597[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11567 === (9))){
var inst_11548 = (state_11566[(7)]);
var state_11566__$1 = state_11566;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11566__$1,(11),inst_11548);
} else {
if((state_val_11567 === (5))){
var _ = (function (){var statearr_11581 = state_11566;
(statearr_11581[(4)] = cljs.core.rest.call(null,(state_11566[(4)])));

return statearr_11581;
})();
var state_11566__$1 = state_11566;
var ex11578 = (state_11566__$1[(2)]);
var statearr_11582_11598 = state_11566__$1;
(statearr_11582_11598[(5)] = ex11578);


var statearr_11583_11599 = state_11566__$1;
(statearr_11583_11599[(1)] = (4));

(statearr_11583_11599[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11567 === (10))){
var inst_11559 = (state_11566[(2)]);
var state_11566__$1 = state_11566;
var statearr_11584_11600 = state_11566__$1;
(statearr_11584_11600[(2)] = inst_11559);

(statearr_11584_11600[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11567 === (8))){
var inst_11542 = (state_11566[(12)]);
var state_11566__$1 = state_11566;
var statearr_11585_11601 = state_11566__$1;
(statearr_11585_11601[(2)] = inst_11542);

(statearr_11585_11601[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_11586 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11586[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__);

(statearr_11586[(1)] = (1));

return statearr_11586;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1 = (function (state_11566){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_11566);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e11587){var ex__2749__auto__ = e11587;
var statearr_11588_11602 = state_11566;
(statearr_11588_11602[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_11566[(4)]))){
var statearr_11589_11603 = state_11566;
(statearr_11589_11603[(1)] = cljs.core.first.call(null,(state_11566[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11604 = state_11566;
state_11566 = G__11604;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__ = function(state_11566){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1.call(this,state_11566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_11590 = f__2769__auto__.call(null);
(statearr_11590[(6)] = c__2768__auto__);

return statearr_11590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_11630){
var state_val_11631 = (state_11630[(1)]);
if((state_val_11631 === (7))){
var inst_11625 = (state_11630[(2)]);
var _ = (function (){var statearr_11632 = state_11630;
(statearr_11632[(4)] = cljs.core.rest.call(null,(state_11630[(4)])));

return statearr_11632;
})();
var state_11630__$1 = state_11630;
var statearr_11633_11655 = state_11630__$1;
(statearr_11633_11655[(2)] = inst_11625);

(statearr_11633_11655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11631 === (1))){
var state_11630__$1 = state_11630;
var statearr_11634_11656 = state_11630__$1;
(statearr_11634_11656[(2)] = null);

(statearr_11634_11656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11631 === (4))){
var inst_11605 = (state_11630[(2)]);
var state_11630__$1 = state_11630;
var statearr_11635_11657 = state_11630__$1;
(statearr_11635_11657[(2)] = inst_11605);

(statearr_11635_11657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11631 === (6))){
var state_11630__$1 = state_11630;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11630__$1,(8),chan);
} else {
if((state_val_11631 === (3))){
var inst_11628 = (state_11630[(2)]);
var state_11630__$1 = state_11630;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11630__$1,inst_11628);
} else {
if((state_val_11631 === (2))){
var _ = (function (){var statearr_11636 = state_11630;
(statearr_11636[(4)] = cljs.core.cons.call(null,(5),(state_11630[(4)])));

return statearr_11636;
})();
var inst_11611 = coll;
var inst_11612 = inst_11611;
var state_11630__$1 = (function (){var statearr_11637 = state_11630;
(statearr_11637[(7)] = inst_11612);

return statearr_11637;
})();
var statearr_11638_11658 = state_11630__$1;
(statearr_11638_11658[(2)] = null);

(statearr_11638_11658[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11631 === (11))){
var inst_11623 = (state_11630[(2)]);
var state_11630__$1 = state_11630;
var statearr_11640_11659 = state_11630__$1;
(statearr_11640_11659[(2)] = inst_11623);

(statearr_11640_11659[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11631 === (9))){
var inst_11612 = (state_11630[(7)]);
var state_11630__$1 = state_11630;
var statearr_11641_11660 = state_11630__$1;
(statearr_11641_11660[(2)] = inst_11612);

(statearr_11641_11660[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11631 === (5))){
var _ = (function (){var statearr_11642 = state_11630;
(statearr_11642[(4)] = cljs.core.rest.call(null,(state_11630[(4)])));

return statearr_11642;
})();
var state_11630__$1 = state_11630;
var ex11639 = (state_11630__$1[(2)]);
var statearr_11643_11661 = state_11630__$1;
(statearr_11643_11661[(5)] = ex11639);


var statearr_11644_11662 = state_11630__$1;
(statearr_11644_11662[(1)] = (4));

(statearr_11644_11662[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11631 === (10))){
var inst_11616 = (state_11630[(8)]);
var inst_11612 = (state_11630[(7)]);
var inst_11620 = cljs.core.conj.call(null,inst_11612,inst_11616);
var inst_11612__$1 = inst_11620;
var state_11630__$1 = (function (){var statearr_11645 = state_11630;
(statearr_11645[(7)] = inst_11612__$1);

return statearr_11645;
})();
var statearr_11646_11663 = state_11630__$1;
(statearr_11646_11663[(2)] = null);

(statearr_11646_11663[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11631 === (8))){
var inst_11616 = (state_11630[(8)]);
var inst_11615 = (state_11630[(2)]);
var inst_11616__$1 = fluree.db.util.async.throw_err.call(null,inst_11615);
var inst_11617 = (inst_11616__$1 == null);
var state_11630__$1 = (function (){var statearr_11647 = state_11630;
(statearr_11647[(8)] = inst_11616__$1);

return statearr_11647;
})();
if(cljs.core.truth_(inst_11617)){
var statearr_11648_11664 = state_11630__$1;
(statearr_11648_11664[(1)] = (9));

} else {
var statearr_11649_11665 = state_11630__$1;
(statearr_11649_11665[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_11650 = [null,null,null,null,null,null,null,null,null];
(statearr_11650[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__);

(statearr_11650[(1)] = (1));

return statearr_11650;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1 = (function (state_11630){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_11630);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e11651){var ex__2749__auto__ = e11651;
var statearr_11652_11666 = state_11630;
(statearr_11652_11666[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_11630[(4)]))){
var statearr_11653_11667 = state_11630;
(statearr_11653_11667[(1)] = cljs.core.first.call(null,(state_11630[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11668 = state_11630;
state_11630 = G__11668;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__ = function(state_11630){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1.call(this,state_11630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_11654 = f__2769__auto__.call(null);
(statearr_11654[(6)] = c__2768__auto__);

return statearr_11654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
