// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.common');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.query.fql_resp');
/**
 * Transducing function to extract matching subjects from initial where clause.
 */
fluree.db.query.subject_crawl.common.where_subj_xf = (function fluree$db$query$subject_crawl$common$where_subj_xf(p__22697){
var map__22698 = p__22697;
var map__22698__$1 = cljs.core.__destructure_map.call(null,map__22698);
var start_test = cljs.core.get.call(null,map__22698__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var start_flake = cljs.core.get.call(null,map__22698__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_test = cljs.core.get.call(null,map__22698__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
var end_flake = cljs.core.get.call(null,map__22698__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var xf = cljs.core.get.call(null,map__22698__$1,new cljs.core.Keyword(null,"xf","xf",401902988));
return cljs.core.apply.call(null,cljs.core.comp,(function (){var G__22699 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.call(null,(function (flakes){
return fluree.db.flake.subrange.call(null,flakes,start_test,start_flake,end_test,end_flake);
}))], null);
if(cljs.core.truth_(xf)){
return cljs.core.conj.call(null,G__22699,xf);
} else {
return G__22699;
}
})());
});
fluree.db.query.subject_crawl.common.result_af = (function fluree$db$query$subject_crawl$common$result_af(p__22700){
var map__22701 = p__22700;
var map__22701__$1 = cljs.core.__destructure_map.call(null,map__22701);
var _opts = map__22701__$1;
var db = cljs.core.get.call(null,map__22701__$1,new cljs.core.Keyword(null,"db","db",993250759));
var cache = cljs.core.get.call(null,map__22701__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var fuel_vol = cljs.core.get.call(null,map__22701__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.call(null,map__22701__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var select_spec = cljs.core.get.call(null,map__22701__$1,new cljs.core.Keyword(null,"select-spec","select-spec",55073283));
var error_ch = cljs.core.get.call(null,map__22701__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
return (function (flakes,port){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22732){
var state_val_22733 = (state_22732[(1)]);
if((state_val_22733 === (7))){
var state_22732__$1 = state_22732;
var statearr_22734_22760 = state_22732__$1;
(statearr_22734_22760[(2)] = null);

(statearr_22734_22760[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22733 === (1))){
var state_22732__$1 = state_22732;
var statearr_22735_22761 = state_22732__$1;
(statearr_22735_22761[(2)] = null);

(statearr_22735_22761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22733 === (4))){
var inst_22702 = (state_22732[(2)]);
var inst_22703 = cljs.core.async.put_BANG_.call(null,error_ch,inst_22702);
var inst_22704 = cljs.core.async.close_BANG_.call(null,port);
var state_22732__$1 = (function (){var statearr_22736 = state_22732;
(statearr_22736[(7)] = inst_22704);

(statearr_22736[(8)] = inst_22703);

return statearr_22736;
})();
var statearr_22737_22762 = state_22732__$1;
(statearr_22737_22762[(2)] = null);

(statearr_22737_22762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22733 === (6))){
var inst_22714 = (state_22732[(9)]);
var inst_22713 = (state_22732[(2)]);
var inst_22714__$1 = fluree.db.util.async.throw_err.call(null,inst_22713);
var inst_22715 = (inst_22714__$1 == null);
var state_22732__$1 = (function (){var statearr_22738 = state_22732;
(statearr_22738[(9)] = inst_22714__$1);

return statearr_22738;
})();
if(cljs.core.truth_(inst_22715)){
var statearr_22739_22763 = state_22732__$1;
(statearr_22739_22763[(1)] = (7));

} else {
var statearr_22740_22764 = state_22732__$1;
(statearr_22740_22764[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22733 === (3))){
var inst_22730 = (state_22732[(2)]);
var state_22732__$1 = state_22732;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22732__$1,inst_22730);
} else {
if((state_val_22733 === (12))){
var inst_22726 = (state_22732[(2)]);
var inst_22727 = cljs.core.async.close_BANG_.call(null,port);
var _ = (function (){var statearr_22741 = state_22732;
(statearr_22741[(4)] = cljs.core.rest.call(null,(state_22732[(4)])));

return statearr_22741;
})();
var state_22732__$1 = (function (){var statearr_22742 = state_22732;
(statearr_22742[(10)] = inst_22726);

return statearr_22742;
})();
var statearr_22743_22765 = state_22732__$1;
(statearr_22743_22765[(2)] = inst_22727);

(statearr_22743_22765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22733 === (2))){
var _ = (function (){var statearr_22744 = state_22732;
(statearr_22744[(4)] = cljs.core.cons.call(null,(5),(state_22732[(4)])));

return statearr_22744;
})();
var inst_22711 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel_vol,max_fuel,select_spec,flakes);
var state_22732__$1 = state_22732;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22732__$1,(6),inst_22711);
} else {
if((state_val_22733 === (11))){
var inst_22720 = (state_22732[(11)]);
var inst_22724 = cljs.core.async.put_BANG_.call(null,port,inst_22720);
var state_22732__$1 = state_22732;
var statearr_22746_22766 = state_22732__$1;
(statearr_22746_22766[(2)] = inst_22724);

(statearr_22746_22766[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22733 === (9))){
var inst_22720 = (state_22732[(11)]);
var inst_22720__$1 = (state_22732[(2)]);
var inst_22721 = (inst_22720__$1 == null);
var state_22732__$1 = (function (){var statearr_22747 = state_22732;
(statearr_22747[(11)] = inst_22720__$1);

return statearr_22747;
})();
if(cljs.core.truth_(inst_22721)){
var statearr_22748_22767 = state_22732__$1;
(statearr_22748_22767[(1)] = (10));

} else {
var statearr_22749_22768 = state_22732__$1;
(statearr_22749_22768[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22733 === (5))){
var _ = (function (){var statearr_22750 = state_22732;
(statearr_22750[(4)] = cljs.core.rest.call(null,(state_22732[(4)])));

return statearr_22750;
})();
var state_22732__$1 = state_22732;
var ex22745 = (state_22732__$1[(2)]);
var statearr_22751_22769 = state_22732__$1;
(statearr_22751_22769[(5)] = ex22745);


var statearr_22752_22770 = state_22732__$1;
(statearr_22752_22770[(1)] = (4));

(statearr_22752_22770[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22733 === (10))){
var state_22732__$1 = state_22732;
var statearr_22753_22771 = state_22732__$1;
(statearr_22753_22771[(2)] = null);

(statearr_22753_22771[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22733 === (8))){
var inst_22714 = (state_22732[(9)]);
var inst_22718 = cljs.core.not_empty.call(null,inst_22714);
var state_22732__$1 = state_22732;
var statearr_22754_22772 = state_22732__$1;
(statearr_22754_22772[(2)] = inst_22718);

(statearr_22754_22772[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0 = (function (){
var statearr_22755 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22755[(0)] = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__);

(statearr_22755[(1)] = (1));

return statearr_22755;
});
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1 = (function (state_22732){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22732);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22756){var ex__2749__auto__ = e22756;
var statearr_22757_22773 = state_22732;
(statearr_22757_22773[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22732[(4)]))){
var statearr_22758_22774 = state_22732;
(statearr_22758_22774[(1)] = cljs.core.first.call(null,(state_22732[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22775 = state_22732;
state_22732 = G__22775;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__ = function(state_22732){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1.call(this,state_22732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22759 = f__2769__auto__.call(null);
(statearr_22759[(6)] = c__2768__auto__);

return statearr_22759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
/**
 * Returns a specific filtering function which takes all subject flakes and
 *   returns the flakes allowed, or nil if none are allowed.
 */
fluree.db.query.subject_crawl.common.subj_perm_filter_fn = (function fluree$db$query$subject_crawl$common$subj_perm_filter_fn(p__22776){
var map__22777 = p__22776;
var map__22777__$1 = cljs.core.__destructure_map.call(null,map__22777);
var db = map__22777__$1;
var permissions = cljs.core.get.call(null,map__22777__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var pred_permissions_QMARK_ = cljs.core.contains_QMARK_.call(null,permissions,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
var coll_permissions = new cljs.core.Keyword(null,"collection","collection",-683361892).cljs$core$IFn$_invoke$arity$1(permissions);
var filter_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var default_deny_QMARK_ = ((new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(coll_permissions) === true)?false:true);
var filter_predicates_QMARK_ = (function (cid){
var temp__5806__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,filter_cache),cid);
if((temp__5806__auto__ == null)){
var coll_perm = cljs.core.get.call(null,coll_permissions,cid);
var filter_QMARK_ = ((fluree.db.util.schema.is_schema_cid_QMARK_.call(null,cid))?false:((pred_permissions_QMARK_)?true:(((coll_perm == null))?default_deny_QMARK_:((((cljs.core.contains_QMARK_.call(null,coll_perm,new cljs.core.Keyword(null,"all","all",892129742))) && (cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,coll_perm)))))?false:true
))));
cljs.core.swap_BANG_.call(null,filter_cache,cljs.core.assoc,cid,filter_QMARK_);

return cljs.core.filter;
} else {
var cached = temp__5806__auto__;
return cached;
}
});
return (function (flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22808){
var state_val_22809 = (state_22808[(1)]);
if((state_val_22809 === (7))){
var inst_22784 = (state_22808[(7)]);
var inst_22794 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_22784);
var state_22808__$1 = state_22808;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22808__$1,(10),inst_22794);
} else {
if((state_val_22809 === (1))){
var state_22808__$1 = state_22808;
var statearr_22810_22833 = state_22808__$1;
(statearr_22810_22833[(2)] = null);

(statearr_22810_22833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22809 === (4))){
var inst_22778 = (state_22808[(2)]);
var state_22808__$1 = state_22808;
var statearr_22811_22834 = state_22808__$1;
(statearr_22811_22834[(2)] = inst_22778);

(statearr_22811_22834[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22809 === (13))){
var inst_22801 = (state_22808[(2)]);
var state_22808__$1 = state_22808;
var statearr_22812_22835 = state_22808__$1;
(statearr_22812_22835[(2)] = inst_22801);

(statearr_22812_22835[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22809 === (6))){
var inst_22789 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,flakes);
var state_22808__$1 = state_22808;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22808__$1,(9),inst_22789);
} else {
if((state_val_22809 === (3))){
var inst_22806 = (state_22808[(2)]);
var state_22808__$1 = state_22808;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22808__$1,inst_22806);
} else {
if((state_val_22809 === (12))){
var state_22808__$1 = state_22808;
var statearr_22813_22836 = state_22808__$1;
(statearr_22813_22836[(2)] = null);

(statearr_22813_22836[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22809 === (2))){
var inst_22784 = (state_22808[(7)]);
var _ = (function (){var statearr_22814 = state_22808;
(statearr_22814[(4)] = cljs.core.cons.call(null,(5),(state_22808[(4)])));

return statearr_22814;
})();
var inst_22784__$1 = cljs.core.first.call(null,flakes);
var inst_22785 = fluree.db.flake.s.call(null,inst_22784__$1);
var inst_22786 = fluree.db.flake.sid__GT_cid.call(null,inst_22785);
var inst_22787 = filter_predicates_QMARK_.call(null,inst_22786);
var state_22808__$1 = (function (){var statearr_22815 = state_22808;
(statearr_22815[(7)] = inst_22784__$1);

return statearr_22815;
})();
if(cljs.core.truth_(inst_22787)){
var statearr_22816_22837 = state_22808__$1;
(statearr_22816_22837[(1)] = (6));

} else {
var statearr_22817_22838 = state_22808__$1;
(statearr_22817_22838[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22809 === (11))){
var state_22808__$1 = state_22808;
var statearr_22819_22839 = state_22808__$1;
(statearr_22819_22839[(2)] = flakes);

(statearr_22819_22839[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22809 === (9))){
var inst_22791 = (state_22808[(2)]);
var inst_22792 = fluree.db.util.async.throw_err.call(null,inst_22791);
var state_22808__$1 = state_22808;
var statearr_22820_22840 = state_22808__$1;
(statearr_22820_22840[(2)] = inst_22792);

(statearr_22820_22840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22809 === (5))){
var _ = (function (){var statearr_22821 = state_22808;
(statearr_22821[(4)] = cljs.core.rest.call(null,(state_22808[(4)])));

return statearr_22821;
})();
var state_22808__$1 = state_22808;
var ex22818 = (state_22808__$1[(2)]);
var statearr_22822_22841 = state_22808__$1;
(statearr_22822_22841[(5)] = ex22818);


if((ex22818 instanceof Error)){
var statearr_22823_22842 = state_22808__$1;
(statearr_22823_22842[(1)] = (4));

(statearr_22823_22842[(5)] = null);

} else {
throw ex22818;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22809 === (10))){
var inst_22796 = (state_22808[(2)]);
var inst_22797 = fluree.db.util.async.throw_err.call(null,inst_22796);
var state_22808__$1 = state_22808;
if(cljs.core.truth_(inst_22797)){
var statearr_22824_22843 = state_22808__$1;
(statearr_22824_22843[(1)] = (11));

} else {
var statearr_22825_22844 = state_22808__$1;
(statearr_22825_22844[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22809 === (8))){
var inst_22803 = (state_22808[(2)]);
var _ = (function (){var statearr_22826 = state_22808;
(statearr_22826[(4)] = cljs.core.rest.call(null,(state_22808[(4)])));

return statearr_22826;
})();
var state_22808__$1 = state_22808;
var statearr_22827_22845 = state_22808__$1;
(statearr_22827_22845[(2)] = inst_22803);

(statearr_22827_22845[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_22828 = [null,null,null,null,null,null,null,null];
(statearr_22828[(0)] = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__);

(statearr_22828[(1)] = (1));

return statearr_22828;
});
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1 = (function (state_22808){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22808);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22829){var ex__2749__auto__ = e22829;
var statearr_22830_22846 = state_22808;
(statearr_22830_22846[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22808[(4)]))){
var statearr_22831_22847 = state_22808;
(statearr_22831_22847[(1)] = cljs.core.first.call(null,(state_22808[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22848 = state_22808;
state_22808 = G__22848;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__ = function(state_22808){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1.call(this,state_22808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22832 = f__2769__auto__.call(null);
(statearr_22832[(6)] = c__2768__auto__);

return statearr_22832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
fluree.db.query.subject_crawl.common.passes_filter_QMARK_ = (function fluree$db$query$subject_crawl$common$passes_filter_QMARK_(filter_fn,vars,pred_flakes){
return cljs.core.some.call(null,(function (p1__22849_SHARP_){
return filter_fn.call(null,p1__22849_SHARP_,vars);
}),pred_flakes);
});
/**
 * For a group of predicate flakes (all same .-p value)
 *   and a list of filter-functions, returns true if at least
 *   one of the predicates passes every function, else returns false.
 */
fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_ = (function fluree$db$query$subject_crawl$common$pass_all_filters_QMARK_(filter_fns,vars,pred_flakes){
var G__22853 = filter_fns;
var vec__22854 = G__22853;
var seq__22855 = cljs.core.seq.call(null,vec__22854);
var first__22856 = cljs.core.first.call(null,seq__22855);
var seq__22855__$1 = cljs.core.next.call(null,seq__22855);
var filter_fn = first__22856;
var r_fns = seq__22855__$1;
var G__22853__$1 = G__22853;
while(true){
var vec__22857 = G__22853__$1;
var seq__22858 = cljs.core.seq.call(null,vec__22857);
var first__22859 = cljs.core.first.call(null,seq__22858);
var seq__22858__$1 = cljs.core.next.call(null,seq__22858);
var filter_fn__$1 = first__22859;
var r_fns__$1 = seq__22858__$1;
if(cljs.core.truth_(filter_fn__$1)){
if(cljs.core.truth_(fluree.db.query.subject_crawl.common.passes_filter_QMARK_.call(null,filter_fn__$1,vars,pred_flakes))){
var G__22860 = r_fns__$1;
G__22853__$1 = G__22860;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});
/**
 * Filters a set of flakes for a single subject and returns true if
 *   the subject meets the filter map.
 * 
 *   filter-map is a map where pred-ids are keys and values are a list of filtering functions
 *   where each flake of pred-id must return a truthy value if the subject is allowed.
 */
fluree.db.query.subject_crawl.common.filter_subject = (function fluree$db$query$subject_crawl$common$filter_subject(vars,filter_map,flakes){
var G__22864 = cljs.core.partition_by.call(null,fluree.db.flake.p,flakes);
var vec__22865 = G__22864;
var seq__22866 = cljs.core.seq.call(null,vec__22865);
var first__22867 = cljs.core.first.call(null,seq__22866);
var seq__22866__$1 = cljs.core.next.call(null,seq__22866);
var p_flakes = first__22867;
var r = seq__22866__$1;
var required_p = new cljs.core.Keyword(null,"required-p","required-p",-2091946078).cljs$core$IFn$_invoke$arity$1(filter_map);
var G__22864__$1 = G__22864;
var required_p__$1 = required_p;
while(true){
var vec__22871 = G__22864__$1;
var seq__22872 = cljs.core.seq.call(null,vec__22871);
var first__22873 = cljs.core.first.call(null,seq__22872);
var seq__22872__$1 = cljs.core.next.call(null,seq__22872);
var p_flakes__$1 = first__22873;
var r__$1 = seq__22872__$1;
var required_p__$2 = required_p__$1;
if(cljs.core.truth_(p_flakes__$1)){
var p = fluree.db.flake.p.call(null,cljs.core.first.call(null,p_flakes__$1));
var temp__5802__auto__ = cljs.core.get.call(null,filter_map,p);
if(cljs.core.truth_(temp__5802__auto__)){
var filter_fns = temp__5802__auto__;
if(fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_.call(null,filter_fns,vars,p_flakes__$1)){
var G__22874 = r__$1;
var G__22875 = cljs.core.disj.call(null,required_p__$2,p);
G__22864__$1 = G__22874;
required_p__$1 = G__22875;
continue;
} else {
return null;
}
} else {
var G__22876 = r__$1;
var G__22877 = cljs.core.disj.call(null,required_p__$2,p);
G__22864__$1 = G__22876;
required_p__$1 = G__22877;
continue;
}
} else {
if(cljs.core.empty_QMARK_.call(null,required_p__$2)){
return flakes;
} else {
return null;
}
}
break;
}
});
/**
 * If order-by exists in query, orders final results.
 *   order-by is defined by a map with keys (see analytical-parse for code):
 *   - :type - :variable or :predicate
 *   - :order - :asc or :desc
 *   - :predicate - if type = :predicate, contains predicate pid or name
 *   - :variable - if type = :variable, contains variable name (not supported for simple subject crawl)
 */
fluree.db.query.subject_crawl.common.order_results = (function fluree$db$query$subject_crawl$common$order_results(results,p__22878){
var map__22879 = p__22878;
var map__22879__$1 = cljs.core.__destructure_map.call(null,map__22879);
var type = cljs.core.get.call(null,map__22879__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var order = cljs.core.get.call(null,map__22879__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var predicate = cljs.core.get.call(null,map__22879__$1,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"variable","variable",-281346492),type)){
throw cljs.core.ex_info.call(null,"Ordering by a variable not supported in this type of query.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var G__22880 = cljs.core.sort_by.call(null,(function (result){
return cljs.core.get.call(null,result,predicate);
}),results);
var G__22880__$1 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"desc","desc",2093485764),order))?cljs.core.reverse.call(null,G__22880):G__22880);
return cljs.core.vec.call(null,G__22880__$1);

}
});
