// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15255){
var state_val_15256 = (state_15255[(1)]);
if((state_val_15256 === (1))){
var state_15255__$1 = state_15255;
var statearr_15257_15271 = state_15255__$1;
(statearr_15257_15271[(2)] = null);

(statearr_15257_15271[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15256 === (2))){
var _ = (function (){var statearr_15258 = state_15255;
(statearr_15258[(4)] = cljs.core.cons.call(null,(5),(state_15255[(4)])));

return statearr_15258;
})();
var inst_15246 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_15255__$1 = state_15255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15255__$1,(6),inst_15246);
} else {
if((state_val_15256 === (3))){
var inst_15253 = (state_15255[(2)]);
var state_15255__$1 = state_15255;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15255__$1,inst_15253);
} else {
if((state_val_15256 === (4))){
var inst_15240 = (state_15255[(2)]);
var state_15255__$1 = state_15255;
var statearr_15260_15272 = state_15255__$1;
(statearr_15260_15272[(2)] = inst_15240);

(statearr_15260_15272[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15256 === (5))){
var _ = (function (){var statearr_15261 = state_15255;
(statearr_15261[(4)] = cljs.core.rest.call(null,(state_15255[(4)])));

return statearr_15261;
})();
var state_15255__$1 = state_15255;
var ex15259 = (state_15255__$1[(2)]);
var statearr_15262_15273 = state_15255__$1;
(statearr_15262_15273[(5)] = ex15259);


if((ex15259 instanceof Error)){
var statearr_15263_15274 = state_15255__$1;
(statearr_15263_15274[(1)] = (4));

(statearr_15263_15274[(5)] = null);

} else {
throw ex15259;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15256 === (6))){
var inst_15248 = (state_15255[(2)]);
var inst_15249 = fluree.db.util.async.throw_err.call(null,inst_15248);
var inst_15250 = cljs.core.keyword.call(null,inst_15249);
var _ = (function (){var statearr_15264 = state_15255;
(statearr_15264[(4)] = cljs.core.rest.call(null,(state_15255[(4)])));

return statearr_15264;
})();
var state_15255__$1 = state_15255;
var statearr_15265_15275 = state_15255__$1;
(statearr_15265_15275[(2)] = inst_15250);

(statearr_15265_15275[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0 = (function (){
var statearr_15266 = [null,null,null,null,null,null,null];
(statearr_15266[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__);

(statearr_15266[(1)] = (1));

return statearr_15266;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1 = (function (state_15255){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15255);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15267){var ex__2749__auto__ = e15267;
var statearr_15268_15276 = state_15255;
(statearr_15268_15276[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15255[(4)]))){
var statearr_15269_15277 = state_15255;
(statearr_15269_15277[(1)] = cljs.core.first.call(null,(state_15255[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15278 = state_15255;
state_15255 = G__15278;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__ = function(state_15255){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1.call(this,state_15255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15270 = f__2769__auto__.call(null);
(statearr_15270[(6)] = c__2768__auto__);

return statearr_15270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15310){
var state_val_15311 = (state_15310[(1)]);
if((state_val_15311 === (7))){
var inst_15294 = (state_15310[(7)]);
var inst_15296 = cljs.core.empty_QMARK_.call(null,inst_15294);
var inst_15297 = (!(inst_15296));
var state_15310__$1 = state_15310;
var statearr_15312_15336 = state_15310__$1;
(statearr_15312_15336[(2)] = inst_15297);

(statearr_15312_15336[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15311 === (1))){
var state_15310__$1 = state_15310;
var statearr_15313_15337 = state_15310__$1;
(statearr_15313_15337[(2)] = null);

(statearr_15313_15337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15311 === (4))){
var inst_15280 = (state_15310[(2)]);
var state_15310__$1 = state_15310;
var statearr_15314_15338 = state_15310__$1;
(statearr_15314_15338[(2)] = inst_15280);

(statearr_15314_15338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15311 === (6))){
var inst_15286 = (state_15310[(8)]);
var inst_15294 = (state_15310[(7)]);
var inst_15292 = (state_15310[(2)]);
var inst_15293 = fluree.db.util.async.throw_err.call(null,inst_15292);
var inst_15294__$1 = cljs.core.map.call(null,inst_15286,inst_15293);
var state_15310__$1 = (function (){var statearr_15315 = state_15310;
(statearr_15315[(7)] = inst_15294__$1);

return statearr_15315;
})();
if(cljs.core.truth_(inst_15294__$1)){
var statearr_15316_15339 = state_15310__$1;
(statearr_15316_15339[(1)] = (7));

} else {
var statearr_15317_15340 = state_15310__$1;
(statearr_15317_15340[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15311 === (3))){
var inst_15308 = (state_15310[(2)]);
var state_15310__$1 = state_15310;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15310__$1,inst_15308);
} else {
if((state_val_15311 === (12))){
var inst_15305 = (state_15310[(2)]);
var _ = (function (){var statearr_15318 = state_15310;
(statearr_15318[(4)] = cljs.core.rest.call(null,(state_15310[(4)])));

return statearr_15318;
})();
var state_15310__$1 = state_15310;
var statearr_15319_15341 = state_15310__$1;
(statearr_15319_15341[(2)] = inst_15305);

(statearr_15319_15341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15311 === (2))){
var _ = (function (){var statearr_15320 = state_15310;
(statearr_15320[(4)] = cljs.core.cons.call(null,(5),(state_15310[(4)])));

return statearr_15320;
})();
var inst_15286 = (function (){return (function (p1__15279_SHARP_){
return fluree.db.flake.o.call(null,p1__15279_SHARP_);
});
})();
var inst_15287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15288 = [pred_id];
var inst_15289 = (new cljs.core.PersistentVector(null,1,(5),inst_15287,inst_15288,null));
var inst_15290 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15289);
var state_15310__$1 = (function (){var statearr_15321 = state_15310;
(statearr_15321[(8)] = inst_15286);

return statearr_15321;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15310__$1,(6),inst_15290);
} else {
if((state_val_15311 === (11))){
var state_15310__$1 = state_15310;
var statearr_15323_15342 = state_15310__$1;
(statearr_15323_15342[(2)] = true);

(statearr_15323_15342[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15311 === (9))){
var inst_15300 = (state_15310[(2)]);
var state_15310__$1 = state_15310;
if(cljs.core.truth_(inst_15300)){
var statearr_15324_15343 = state_15310__$1;
(statearr_15324_15343[(1)] = (10));

} else {
var statearr_15325_15344 = state_15310__$1;
(statearr_15325_15344[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15311 === (5))){
var _ = (function (){var statearr_15326 = state_15310;
(statearr_15326[(4)] = cljs.core.rest.call(null,(state_15310[(4)])));

return statearr_15326;
})();
var state_15310__$1 = state_15310;
var ex15322 = (state_15310__$1[(2)]);
var statearr_15327_15345 = state_15310__$1;
(statearr_15327_15345[(5)] = ex15322);


if((ex15322 instanceof Error)){
var statearr_15328_15346 = state_15310__$1;
(statearr_15328_15346[(1)] = (4));

(statearr_15328_15346[(5)] = null);

} else {
throw ex15322;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15311 === (10))){
var inst_15294 = (state_15310[(7)]);
var inst_15302 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_15294);
var state_15310__$1 = state_15310;
var statearr_15329_15347 = state_15310__$1;
(statearr_15329_15347[(2)] = inst_15302);

(statearr_15329_15347[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15311 === (8))){
var inst_15294 = (state_15310[(7)]);
var state_15310__$1 = state_15310;
var statearr_15330_15348 = state_15310__$1;
(statearr_15330_15348[(2)] = inst_15294);

(statearr_15330_15348[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_15331 = [null,null,null,null,null,null,null,null,null];
(statearr_15331[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__);

(statearr_15331[(1)] = (1));

return statearr_15331;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1 = (function (state_15310){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15310);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15332){var ex__2749__auto__ = e15332;
var statearr_15333_15349 = state_15310;
(statearr_15333_15349[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15310[(4)]))){
var statearr_15334_15350 = state_15310;
(statearr_15334_15350[(1)] = cljs.core.first.call(null,(state_15310[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15351 = state_15310;
state_15310 = G__15351;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__ = function(state_15310){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1.call(this,state_15310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15335 = f__2769__auto__.call(null);
(statearr_15335[(6)] = c__2768__auto__);

return statearr_15335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15432){
var state_val_15433 = (state_15432[(1)]);
if((state_val_15433 === (7))){
var state_15432__$1 = state_15432;
var statearr_15434_15471 = state_15432__$1;
(statearr_15434_15471[(2)] = flakes);

(statearr_15434_15471[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (20))){
var inst_15389 = (state_15432[(7)]);
var inst_15422 = (state_15432[(2)]);
var inst_15381 = inst_15389;
var inst_15382 = inst_15422;
var state_15432__$1 = (function (){var statearr_15435 = state_15432;
(statearr_15435[(8)] = inst_15381);

(statearr_15435[(9)] = inst_15382);

return statearr_15435;
})();
var statearr_15436_15472 = state_15432__$1;
(statearr_15436_15472[(2)] = null);

(statearr_15436_15472[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (1))){
var state_15432__$1 = state_15432;
var statearr_15437_15473 = state_15432__$1;
(statearr_15437_15473[(2)] = null);

(statearr_15437_15473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (4))){
var inst_15354 = (state_15432[(2)]);
var state_15432__$1 = state_15432;
var statearr_15438_15474 = state_15432__$1;
(statearr_15438_15474[(2)] = inst_15354);

(statearr_15438_15474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (15))){
var inst_15388 = (state_15432[(10)]);
var inst_15406 = fluree.db.flake.o.call(null,inst_15388);
var state_15432__$1 = state_15432;
var statearr_15439_15475 = state_15432__$1;
(statearr_15439_15475[(2)] = inst_15406);

(statearr_15439_15475[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (13))){
var inst_15425 = (state_15432[(2)]);
var state_15432__$1 = state_15432;
var statearr_15440_15476 = state_15432__$1;
(statearr_15440_15476[(2)] = inst_15425);

(statearr_15440_15476[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (6))){
var inst_15361 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_15432__$1 = state_15432;
var statearr_15441_15477 = state_15432__$1;
(statearr_15441_15477[(2)] = inst_15361);

(statearr_15441_15477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (17))){
var inst_15403 = (state_15432[(2)]);
var inst_15404 = fluree.db.util.async.throw_err.call(null,inst_15403);
var state_15432__$1 = state_15432;
var statearr_15442_15478 = state_15432__$1;
(statearr_15442_15478[(2)] = inst_15404);

(statearr_15442_15478[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (3))){
var inst_15430 = (state_15432[(2)]);
var state_15432__$1 = state_15432;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15432__$1,inst_15430);
} else {
if((state_val_15433 === (12))){
var inst_15388 = (state_15432[(10)]);
var inst_15395 = (state_15432[(11)]);
var inst_15393 = fluree.db.flake.p.call(null,inst_15388);
var inst_15394 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15393);
var inst_15395__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_15394);
var inst_15396 = fluree.db.flake.op.call(null,inst_15388);
var inst_15397 = inst_15396 === false;
var inst_15398 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_15395__$1);
var state_15432__$1 = (function (){var statearr_15443 = state_15432;
(statearr_15443[(11)] = inst_15395__$1);

(statearr_15443[(12)] = inst_15397);

return statearr_15443;
})();
if(inst_15398){
var statearr_15444_15479 = state_15432__$1;
(statearr_15444_15479[(1)] = (14));

} else {
var statearr_15445_15480 = state_15432__$1;
(statearr_15445_15480[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (2))){
var _ = (function (){var statearr_15446 = state_15432;
(statearr_15446[(4)] = cljs.core.cons.call(null,(5),(state_15432[(4)])));

return statearr_15446;
})();
var state_15432__$1 = state_15432;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_15447_15481 = state_15432__$1;
(statearr_15447_15481[(1)] = (6));

} else {
var statearr_15448_15482 = state_15432__$1;
(statearr_15448_15482[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (19))){
var inst_15408 = (state_15432[(13)]);
var inst_15388 = (state_15432[(10)]);
var inst_15395 = (state_15432[(11)]);
var inst_15382 = (state_15432[(9)]);
var inst_15416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15417 = fluree.db.flake.s.call(null,inst_15388);
var inst_15418 = [inst_15417,inst_15395,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_15419 = (new cljs.core.PersistentVector(null,3,(5),inst_15416,inst_15418,null));
var inst_15420 = cljs.core.assoc_in.call(null,inst_15382,inst_15419,inst_15408);
var state_15432__$1 = state_15432;
var statearr_15449_15483 = state_15432__$1;
(statearr_15449_15483[(2)] = inst_15420);

(statearr_15449_15483[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (11))){
var inst_15382 = (state_15432[(9)]);
var state_15432__$1 = state_15432;
var statearr_15451_15484 = state_15432__$1;
(statearr_15451_15484[(2)] = inst_15382);

(statearr_15451_15484[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (9))){
var inst_15388 = (state_15432[(10)]);
var inst_15381 = (state_15432[(8)]);
var inst_15387 = cljs.core.seq.call(null,inst_15381);
var inst_15388__$1 = cljs.core.first.call(null,inst_15387);
var inst_15389 = cljs.core.next.call(null,inst_15387);
var inst_15390 = cljs.core.not.call(null,inst_15388__$1);
var state_15432__$1 = (function (){var statearr_15452 = state_15432;
(statearr_15452[(10)] = inst_15388__$1);

(statearr_15452[(7)] = inst_15389);

return statearr_15452;
})();
if(inst_15390){
var statearr_15453_15485 = state_15432__$1;
(statearr_15453_15485[(1)] = (11));

} else {
var statearr_15454_15486 = state_15432__$1;
(statearr_15454_15486[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (5))){
var _ = (function (){var statearr_15455 = state_15432;
(statearr_15455[(4)] = cljs.core.rest.call(null,(state_15432[(4)])));

return statearr_15455;
})();
var state_15432__$1 = state_15432;
var ex15450 = (state_15432__$1[(2)]);
var statearr_15456_15487 = state_15432__$1;
(statearr_15456_15487[(5)] = ex15450);


if((ex15450 instanceof Error)){
var statearr_15457_15488 = state_15432__$1;
(statearr_15457_15488[(1)] = (4));

(statearr_15457_15488[(5)] = null);

} else {
throw ex15450;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (14))){
var inst_15388 = (state_15432[(10)]);
var inst_15400 = fluree.db.flake.o.call(null,inst_15388);
var inst_15401 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_15400,db);
var state_15432__$1 = state_15432;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15432__$1,(17),inst_15401);
} else {
if((state_val_15433 === (16))){
var inst_15397 = (state_15432[(12)]);
var inst_15408 = (state_15432[(2)]);
var state_15432__$1 = (function (){var statearr_15458 = state_15432;
(statearr_15458[(13)] = inst_15408);

return statearr_15458;
})();
if(cljs.core.truth_(inst_15397)){
var statearr_15459_15489 = state_15432__$1;
(statearr_15459_15489[(1)] = (18));

} else {
var statearr_15460_15490 = state_15432__$1;
(statearr_15460_15490[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (10))){
var inst_15427 = (state_15432[(2)]);
var _ = (function (){var statearr_15461 = state_15432;
(statearr_15461[(4)] = cljs.core.rest.call(null,(state_15432[(4)])));

return statearr_15461;
})();
var state_15432__$1 = state_15432;
var statearr_15462_15491 = state_15432__$1;
(statearr_15462_15491[(2)] = inst_15427);

(statearr_15462_15491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (18))){
var inst_15408 = (state_15432[(13)]);
var inst_15388 = (state_15432[(10)]);
var inst_15395 = (state_15432[(11)]);
var inst_15382 = (state_15432[(9)]);
var inst_15410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15411 = fluree.db.flake.s.call(null,inst_15388);
var inst_15412 = [inst_15411,inst_15395,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_15413 = (new cljs.core.PersistentVector(null,3,(5),inst_15410,inst_15412,null));
var inst_15414 = cljs.core.assoc_in.call(null,inst_15382,inst_15413,inst_15408);
var state_15432__$1 = state_15432;
var statearr_15463_15492 = state_15432__$1;
(statearr_15463_15492[(2)] = inst_15414);

(statearr_15463_15492[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15433 === (8))){
var inst_15364 = (state_15432[(2)]);
var inst_15365 = cljs.core.PersistentHashSet.EMPTY;
var inst_15366 = cljs.core.vals.call(null,tempids);
var inst_15367 = cljs.core.into.call(null,inst_15365,inst_15366);
var inst_15368 = (function (){var pred_flakes = inst_15364;
var is_new_QMARK_ = inst_15367;
return (function (p1__15353_SHARP_,p2__15352_SHARP_){
var f = p2__15352_SHARP_;
return cljs.core.assoc_in.call(null,p1__15353_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.s.call(null,f),new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,fluree.db.flake.s.call(null,f))));
});
})();
var inst_15369 = cljs.core.PersistentHashMap.EMPTY;
var inst_15370 = cljs.core.reduce.call(null,inst_15368,inst_15369,inst_15364);
var inst_15378 = cljs.core.seq.call(null,inst_15364);
var inst_15379 = cljs.core.first.call(null,inst_15378);
var inst_15380 = cljs.core.next.call(null,inst_15378);
var inst_15381 = inst_15364;
var inst_15382 = inst_15370;
var state_15432__$1 = (function (){var statearr_15464 = state_15432;
(statearr_15464[(14)] = inst_15379);

(statearr_15464[(15)] = inst_15380);

(statearr_15464[(8)] = inst_15381);

(statearr_15464[(9)] = inst_15382);

return statearr_15464;
})();
var statearr_15465_15493 = state_15432__$1;
(statearr_15465_15493[(2)] = null);

(statearr_15465_15493[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0 = (function (){
var statearr_15466 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15466[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__);

(statearr_15466[(1)] = (1));

return statearr_15466;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1 = (function (state_15432){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15432);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e15467){var ex__2749__auto__ = e15467;
var statearr_15468_15494 = state_15432;
(statearr_15468_15494[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15432[(4)]))){
var statearr_15469_15495 = state_15432;
(statearr_15469_15495[(1)] = cljs.core.first.call(null,(state_15432[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15496 = state_15432;
state_15432 = G__15496;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__ = function(state_15432){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1.call(this,state_15432);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_15470 = f__2769__auto__.call(null);
(statearr_15470[(6)] = c__2768__auto__);

return statearr_15470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__15498 = arguments.length;
switch (G__15498) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__15501 = arguments.length;
switch (G__15501) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_15813){
var state_val_15814 = (state_15813[(1)]);
if((state_val_15814 === (121))){
var inst_15768 = (state_15813[(7)]);
var state_15813__$1 = state_15813;
var statearr_15815_16008 = state_15813__$1;
(statearr_15815_16008[(2)] = inst_15768);

(statearr_15815_16008[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (65))){
var inst_15667 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
if(cljs.core.truth_(inst_15667)){
var statearr_15816_16009 = state_15813__$1;
(statearr_15816_16009[(1)] = (66));

} else {
var statearr_15817_16010 = state_15813__$1;
(statearr_15817_16010[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (70))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15677 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_15678 = inst_15673.call(null,cljs.core.PersistentArrayMap,null,3,inst_15677,null);
var inst_15679 = inst_15673.call(null,cljs.core.PersistentHashSet,null,inst_15678,null);
var inst_15680 = inst_15679.call(null,inst_15672);
var state_15813__$1 = state_15813;
if(cljs.core.truth_(inst_15680)){
var statearr_15818_16011 = state_15813__$1;
(statearr_15818_16011[(1)] = (72));

} else {
var statearr_15819_16012 = state_15813__$1;
(statearr_15819_16012[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (62))){
var inst_15657 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15820_16013 = state_15813__$1;
(statearr_15820_16013[(2)] = inst_15657);

(statearr_15820_16013[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (74))){
var inst_15763 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15821_16014 = state_15813__$1;
(statearr_15821_16014[(2)] = inst_15763);

(statearr_15821_16014[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (110))){
var inst_15790 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
if(cljs.core.truth_(inst_15790)){
var statearr_15822_16015 = state_15813__$1;
(statearr_15822_16015[(1)] = (117));

} else {
var statearr_15823_16016 = state_15813__$1;
(statearr_15823_16016[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (7))){
var inst_15808 = (state_15813[(2)]);
var _ = (function (){var statearr_15824 = state_15813;
(statearr_15824[(4)] = cljs.core.rest.call(null,(state_15813[(4)])));

return statearr_15824;
})();
var state_15813__$1 = state_15813;
var statearr_15825_16017 = state_15813__$1;
(statearr_15825_16017[(2)] = inst_15808);

(statearr_15825_16017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (59))){
var inst_15541 = (state_15813[(10)]);
var inst_15661 = (state_15813[(11)]);
var inst_15660 = (state_15813[(2)]);
var inst_15661__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15541);
var state_15813__$1 = (function (){var statearr_15826 = state_15813;
(statearr_15826[(12)] = inst_15660);

(statearr_15826[(11)] = inst_15661__$1);

return statearr_15826;
})();
if(cljs.core.truth_(inst_15661__$1)){
var statearr_15827_16018 = state_15813__$1;
(statearr_15827_16018[(1)] = (63));

} else {
var statearr_15828_16019 = state_15813__$1;
(statearr_15828_16019[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (86))){
var inst_15703 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15829_16020 = state_15813__$1;
(statearr_15829_16020[(2)] = inst_15703);

(statearr_15829_16020[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (20))){
var inst_15567 = (state_15813[(13)]);
var inst_15541 = (state_15813[(10)]);
var inst_15567__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15541);
var state_15813__$1 = (function (){var statearr_15830 = state_15813;
(statearr_15830[(13)] = inst_15567__$1);

return statearr_15830;
})();
if(cljs.core.truth_(inst_15567__$1)){
var statearr_15831_16021 = state_15813__$1;
(statearr_15831_16021[(1)] = (23));

} else {
var statearr_15832_16022 = state_15813__$1;
(statearr_15832_16022[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (72))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15682 = fluree.db.query.schema.type_error.call(null,inst_15672,inst_15673,throw_QMARK_);
var state_15813__$1 = state_15813;
var statearr_15833_16023 = state_15813__$1;
(statearr_15833_16023[(2)] = inst_15682);

(statearr_15833_16023[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (58))){
var inst_15622 = (state_15813[(14)]);
var state_15813__$1 = state_15813;
var statearr_15834_16024 = state_15813__$1;
(statearr_15834_16024[(2)] = inst_15622);

(statearr_15834_16024[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (60))){
var inst_15529 = (state_15813[(15)]);
var inst_15540 = (state_15813[(16)]);
var inst_15648 = fluree.db.dbproto._p_prop.call(null,inst_15529,new cljs.core.Keyword(null,"name","name",1843675177),inst_15540);
var inst_15649 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15648)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_15650 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15651 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15652 = cljs.core.PersistentHashMap.fromArrays(inst_15650,inst_15651);
var inst_15653 = cljs.core.ex_info.call(null,inst_15649,inst_15652);
var inst_15654 = (function(){throw inst_15653})();
var state_15813__$1 = state_15813;
var statearr_15835_16025 = state_15813__$1;
(statearr_15835_16025[(2)] = inst_15654);

(statearr_15835_16025[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (27))){
var inst_15570 = (state_15813[(17)]);
var state_15813__$1 = state_15813;
var statearr_15836_16026 = state_15813__$1;
(statearr_15836_16026[(2)] = inst_15570);

(statearr_15836_16026[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (1))){
var state_15813__$1 = state_15813;
var statearr_15837_16027 = state_15813__$1;
(statearr_15837_16027[(2)] = null);

(statearr_15837_16027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (69))){
var inst_15660 = (state_15813[(12)]);
var state_15813__$1 = state_15813;
var statearr_15838_16028 = state_15813__$1;
(statearr_15838_16028[(2)] = inst_15660);

(statearr_15838_16028[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (101))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15741 = fluree.db.query.schema.type_error.call(null,inst_15672,inst_15673,throw_QMARK_);
var state_15813__$1 = state_15813;
var statearr_15839_16029 = state_15813__$1;
(statearr_15839_16029[(2)] = inst_15741);

(statearr_15839_16029[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (24))){
var inst_15567 = (state_15813[(13)]);
var state_15813__$1 = state_15813;
var statearr_15840_16030 = state_15813__$1;
(statearr_15840_16030[(2)] = inst_15567);

(statearr_15840_16030[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (102))){
var inst_15743 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15841_16031 = state_15813__$1;
(statearr_15841_16031[(2)] = inst_15743);

(statearr_15841_16031[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (55))){
var inst_15639 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15842_16032 = state_15813__$1;
(statearr_15842_16032[(2)] = inst_15639);

(statearr_15842_16032[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (85))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15701 = fluree.db.query.schema.type_error.call(null,inst_15672,inst_15673,throw_QMARK_);
var state_15813__$1 = state_15813;
var statearr_15843_16033 = state_15813__$1;
(statearr_15843_16033[(2)] = inst_15701);

(statearr_15843_16033[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (39))){
var inst_15604 = (state_15813[(18)]);
var state_15813__$1 = state_15813;
var statearr_15844_16034 = state_15813__$1;
(statearr_15844_16034[(2)] = inst_15604);

(statearr_15844_16034[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (88))){
var inst_15660 = (state_15813[(12)]);
var state_15813__$1 = state_15813;
var statearr_15845_16035 = state_15813__$1;
(statearr_15845_16035[(2)] = inst_15660);

(statearr_15845_16035[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (46))){
var inst_15623 = (state_15813[(19)]);
var inst_15541 = (state_15813[(10)]);
var inst_15622 = (state_15813[(2)]);
var inst_15623__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15541);
var state_15813__$1 = (function (){var statearr_15846 = state_15813;
(statearr_15846[(19)] = inst_15623__$1);

(statearr_15846[(14)] = inst_15622);

return statearr_15846;
})();
if(cljs.core.truth_(inst_15623__$1)){
var statearr_15847_16036 = state_15813__$1;
(statearr_15847_16036[(1)] = (47));

} else {
var statearr_15848_16037 = state_15813__$1;
(statearr_15848_16037[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (4))){
var inst_15502 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15849_16038 = state_15813__$1;
(statearr_15849_16038[(2)] = inst_15502);

(statearr_15849_16038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (77))){
var inst_15761 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15850_16039 = state_15813__$1;
(statearr_15850_16039[(2)] = inst_15761);

(statearr_15850_16039[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (106))){
var inst_15753 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15851_16040 = state_15813__$1;
(statearr_15851_16040[(2)] = inst_15753);

(statearr_15851_16040[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (119))){
var inst_15539 = (state_15813[(20)]);
var inst_15803 = (state_15813[(2)]);
var inst_15528 = inst_15539;
var inst_15529 = inst_15803;
var state_15813__$1 = (function (){var statearr_15852 = state_15813;
(statearr_15852[(21)] = inst_15528);

(statearr_15852[(15)] = inst_15529);

return statearr_15852;
})();
var statearr_15853_16041 = state_15813__$1;
(statearr_15853_16041[(2)] = null);

(statearr_15853_16041[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (95))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15725 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15726 = inst_15673.call(null,cljs.core.PersistentArrayMap,null,5,inst_15725,null);
var inst_15727 = inst_15673.call(null,cljs.core.PersistentHashSet,null,inst_15726,null);
var inst_15728 = inst_15727.call(null,inst_15672);
var state_15813__$1 = state_15813;
if(cljs.core.truth_(inst_15728)){
var statearr_15854_16042 = state_15813__$1;
(statearr_15854_16042[(1)] = (96));

} else {
var statearr_15855_16043 = state_15813__$1;
(statearr_15855_16043[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (54))){
var inst_15630 = (state_15813[(22)]);
var state_15813__$1 = state_15813;
var statearr_15856_16044 = state_15813__$1;
(statearr_15856_16044[(2)] = inst_15630);

(statearr_15856_16044[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (92))){
var inst_15660 = (state_15813[(12)]);
var state_15813__$1 = state_15813;
var statearr_15857_16045 = state_15813__$1;
(statearr_15857_16045[(2)] = inst_15660);

(statearr_15857_16045[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (104))){
var inst_15660 = (state_15813[(12)]);
var state_15813__$1 = state_15813;
var statearr_15858_16046 = state_15813__$1;
(statearr_15858_16046[(2)] = inst_15660);

(statearr_15858_16046[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (15))){
var inst_15549 = (state_15813[(23)]);
var state_15813__$1 = state_15813;
var statearr_15859_16047 = state_15813__$1;
(statearr_15859_16047[(2)] = inst_15549);

(statearr_15859_16047[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (48))){
var inst_15623 = (state_15813[(19)]);
var state_15813__$1 = state_15813;
var statearr_15860_16048 = state_15813__$1;
(statearr_15860_16048[(2)] = inst_15623);

(statearr_15860_16048[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (50))){
var inst_15630 = (state_15813[(22)]);
var inst_15541 = (state_15813[(10)]);
var inst_15628 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15541);
var inst_15629 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15628);
var inst_15630__$1 = inst_15629 === true;
var state_15813__$1 = (function (){var statearr_15861 = state_15813;
(statearr_15861[(22)] = inst_15630__$1);

return statearr_15861;
})();
if(cljs.core.truth_(inst_15630__$1)){
var statearr_15862_16049 = state_15813__$1;
(statearr_15862_16049[(1)] = (53));

} else {
var statearr_15863_16050 = state_15813__$1;
(statearr_15863_16050[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (116))){
var inst_15784 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15864_16051 = state_15813__$1;
(statearr_15864_16051[(2)] = inst_15784);

(statearr_15864_16051[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (75))){
var inst_15673 = (state_15813[(8)]);
var state_15813__$1 = state_15813;
var G__15865_16052 = inst_15673;
var G__15865_16053__$1 = (((G__15865_16052 instanceof cljs.core.Keyword))?G__15865_16052.fqn:null);
switch (G__15865_16053__$1) {
case "long":
var statearr_15866_16055 = state_15813__$1;
(statearr_15866_16055[(1)] = (79));


break;
case "bigint":
var statearr_15867_16056 = state_15813__$1;
(statearr_15867_16056[(1)] = (83));


break;
case "double":
var statearr_15868_16057 = state_15813__$1;
(statearr_15868_16057[(1)] = (87));


break;
case "float":
var statearr_15869_16058 = state_15813__$1;
(statearr_15869_16058[(1)] = (91));


break;
case "bigdec":
var statearr_15870_16059 = state_15813__$1;
(statearr_15870_16059[(1)] = (95));


break;
case "string":
var statearr_15871_16060 = state_15813__$1;
(statearr_15871_16060[(1)] = (99));


break;
case "instant":
var statearr_15872_16061 = state_15813__$1;
(statearr_15872_16061[(1)] = (103));


break;
default:
var statearr_15873_16062 = state_15813__$1;
(statearr_15873_16062[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (99))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15735 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_15736 = inst_15673.call(null,cljs.core.PersistentArrayMap,null,5,inst_15735,null);
var inst_15737 = inst_15673.call(null,cljs.core.PersistentHashSet,null,inst_15736,null);
var inst_15738 = inst_15737.call(null,inst_15672);
var state_15813__$1 = state_15813;
if(cljs.core.truth_(inst_15738)){
var statearr_15874_16063 = state_15813__$1;
(statearr_15874_16063[(1)] = (100));

} else {
var statearr_15875_16064 = state_15813__$1;
(statearr_15875_16064[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (21))){
var inst_15565 = (state_15813[(24)]);
var state_15813__$1 = state_15813;
var statearr_15876_16065 = state_15813__$1;
(statearr_15876_16065[(2)] = inst_15565);

(statearr_15876_16065[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (31))){
var inst_15581 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15877_16066 = state_15813__$1;
(statearr_15877_16066[(2)] = inst_15581);

(statearr_15877_16066[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (113))){
var inst_15787 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15878_16067 = state_15813__$1;
(statearr_15878_16067[(2)] = inst_15787);

(statearr_15878_16067[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (32))){
var state_15813__$1 = state_15813;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15879_16068 = state_15813__$1;
(statearr_15879_16068[(1)] = (35));

} else {
var statearr_15880_16069 = state_15813__$1;
(statearr_15880_16069[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (40))){
var inst_15617 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
if(cljs.core.truth_(inst_15617)){
var statearr_15881_16070 = state_15813__$1;
(statearr_15881_16070[(1)] = (44));

} else {
var statearr_15882_16071 = state_15813__$1;
(statearr_15882_16071[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (91))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15715 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15716 = inst_15673.call(null,cljs.core.PersistentArrayMap,null,3,inst_15715,null);
var inst_15717 = inst_15673.call(null,cljs.core.PersistentHashSet,null,inst_15716,null);
var inst_15718 = inst_15717.call(null,inst_15672);
var state_15813__$1 = state_15813;
if(cljs.core.truth_(inst_15718)){
var statearr_15883_16072 = state_15813__$1;
(statearr_15883_16072[(1)] = (92));

} else {
var statearr_15884_16073 = state_15813__$1;
(statearr_15884_16073[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (117))){
var state_15813__$1 = state_15813;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15885_16074 = state_15813__$1;
(statearr_15885_16074[(1)] = (120));

} else {
var statearr_15886_16075 = state_15813__$1;
(statearr_15886_16075[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (108))){
var inst_15772 = (state_15813[(25)]);
var inst_15541 = (state_15813[(10)]);
var inst_15772__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15541);
var state_15813__$1 = (function (){var statearr_15887 = state_15813;
(statearr_15887[(25)] = inst_15772__$1);

return statearr_15887;
})();
if(cljs.core.truth_(inst_15772__$1)){
var statearr_15888_16076 = state_15813__$1;
(statearr_15888_16076[(1)] = (111));

} else {
var statearr_15889_16077 = state_15813__$1;
(statearr_15889_16077[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (56))){
var inst_15634 = (state_15813[(2)]);
var inst_15635 = fluree.db.util.async.throw_err.call(null,inst_15634);
var inst_15636 = cljs.core.not.call(null,inst_15635);
var state_15813__$1 = state_15813;
var statearr_15890_16078 = state_15813__$1;
(statearr_15890_16078[(2)] = inst_15636);

(statearr_15890_16078[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (33))){
var inst_15564 = (state_15813[(26)]);
var state_15813__$1 = state_15813;
var statearr_15891_16079 = state_15813__$1;
(statearr_15891_16079[(2)] = inst_15564);

(statearr_15891_16079[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (13))){
var inst_15559 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
if(cljs.core.truth_(inst_15559)){
var statearr_15892_16080 = state_15813__$1;
(statearr_15892_16080[(1)] = (17));

} else {
var statearr_15893_16081 = state_15813__$1;
(statearr_15893_16081[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (22))){
var inst_15590 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
if(cljs.core.truth_(inst_15590)){
var statearr_15894_16082 = state_15813__$1;
(statearr_15894_16082[(1)] = (32));

} else {
var statearr_15895_16083 = state_15813__$1;
(statearr_15895_16083[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (90))){
var inst_15713 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15896_16084 = state_15813__$1;
(statearr_15896_16084[(2)] = inst_15713);

(statearr_15896_16084[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (109))){
var inst_15770 = (state_15813[(27)]);
var state_15813__$1 = state_15813;
var statearr_15897_16085 = state_15813__$1;
(statearr_15897_16085[(2)] = inst_15770);

(statearr_15897_16085[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (36))){
var inst_15564 = (state_15813[(26)]);
var state_15813__$1 = state_15813;
var statearr_15898_16086 = state_15813__$1;
(statearr_15898_16086[(2)] = inst_15564);

(statearr_15898_16086[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (41))){
var inst_15541 = (state_15813[(10)]);
var inst_15609 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15541);
var inst_15610 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15609);
var inst_15611 = inst_15610 === true;
var state_15813__$1 = state_15813;
var statearr_15899_16087 = state_15813__$1;
(statearr_15899_16087[(2)] = inst_15611);

(statearr_15899_16087[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (118))){
var inst_15768 = (state_15813[(7)]);
var state_15813__$1 = state_15813;
var statearr_15900_16088 = state_15813__$1;
(statearr_15900_16088[(2)] = inst_15768);

(statearr_15900_16088[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (89))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15711 = fluree.db.query.schema.type_error.call(null,inst_15672,inst_15673,throw_QMARK_);
var state_15813__$1 = state_15813;
var statearr_15901_16089 = state_15813__$1;
(statearr_15901_16089[(2)] = inst_15711);

(statearr_15901_16089[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (100))){
var inst_15660 = (state_15813[(12)]);
var state_15813__$1 = state_15813;
var statearr_15902_16090 = state_15813__$1;
(statearr_15902_16090[(2)] = inst_15660);

(statearr_15902_16090[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (122))){
var inst_15800 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15903_16091 = state_15813__$1;
(statearr_15903_16091[(2)] = inst_15800);

(statearr_15903_16091[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (43))){
var inst_15614 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15904_16092 = state_15813__$1;
(statearr_15904_16092[(2)] = inst_15614);

(statearr_15904_16092[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (61))){
var inst_15622 = (state_15813[(14)]);
var state_15813__$1 = state_15813;
var statearr_15905_16093 = state_15813__$1;
(statearr_15905_16093[(2)] = inst_15622);

(statearr_15905_16093[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (29))){
var inst_15541 = (state_15813[(10)]);
var inst_15576 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15541);
var inst_15577 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15576);
var inst_15578 = inst_15577 === true;
var state_15813__$1 = state_15813;
var statearr_15906_16094 = state_15813__$1;
(statearr_15906_16094[(2)] = inst_15578);

(statearr_15906_16094[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (44))){
var inst_15603 = (state_15813[(28)]);
var inst_15619 = fluree.db.query.schema.type_error.call(null,inst_15603,"a component","a non-component",throw_QMARK_);
var state_15813__$1 = state_15813;
var statearr_15907_16095 = state_15813__$1;
(statearr_15907_16095[(2)] = inst_15619);

(statearr_15907_16095[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (93))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15721 = fluree.db.query.schema.type_error.call(null,inst_15672,inst_15673,throw_QMARK_);
var state_15813__$1 = state_15813;
var statearr_15908_16096 = state_15813__$1;
(statearr_15908_16096[(2)] = inst_15721);

(statearr_15908_16096[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (6))){
var inst_15528 = (state_15813[(21)]);
var inst_15540 = (state_15813[(16)]);
var inst_15537 = cljs.core.seq.call(null,inst_15528);
var inst_15538 = cljs.core.first.call(null,inst_15537);
var inst_15539 = cljs.core.next.call(null,inst_15537);
var inst_15540__$1 = cljs.core.nth.call(null,inst_15538,(0),null);
var inst_15541 = cljs.core.nth.call(null,inst_15538,(1),null);
var inst_15542 = cljs.core.not.call(null,inst_15540__$1);
var state_15813__$1 = (function (){var statearr_15909 = state_15813;
(statearr_15909[(10)] = inst_15541);

(statearr_15909[(16)] = inst_15540__$1);

(statearr_15909[(20)] = inst_15539);

return statearr_15909;
})();
if(inst_15542){
var statearr_15910_16097 = state_15813__$1;
(statearr_15910_16097[(1)] = (8));

} else {
var statearr_15911_16098 = state_15813__$1;
(statearr_15911_16098[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (111))){
var inst_15541 = (state_15813[(10)]);
var inst_15776 = (state_15813[(29)]);
var inst_15774 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15541);
var inst_15775 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15774);
var inst_15776__$1 = inst_15775 === true;
var state_15813__$1 = (function (){var statearr_15912 = state_15813;
(statearr_15912[(29)] = inst_15776__$1);

return statearr_15912;
})();
if(cljs.core.truth_(inst_15776__$1)){
var statearr_15913_16099 = state_15813__$1;
(statearr_15913_16099[(1)] = (114));

} else {
var statearr_15914_16100 = state_15813__$1;
(statearr_15914_16100[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (28))){
var inst_15584 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15915_16101 = state_15813__$1;
(statearr_15915_16101[(2)] = inst_15584);

(statearr_15915_16101[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (64))){
var inst_15661 = (state_15813[(11)]);
var state_15813__$1 = state_15813;
var statearr_15916_16102 = state_15813__$1;
(statearr_15916_16102[(2)] = inst_15661);

(statearr_15916_16102[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (103))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15745 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15746 = inst_15673.call(null,cljs.core.PersistentArrayMap,null,2,inst_15745,null);
var inst_15747 = inst_15673.call(null,cljs.core.PersistentHashSet,null,inst_15746,null);
var inst_15748 = inst_15747.call(null,inst_15672);
var state_15813__$1 = state_15813;
if(cljs.core.truth_(inst_15748)){
var statearr_15917_16103 = state_15813__$1;
(statearr_15917_16103[(1)] = (104));

} else {
var statearr_15918_16104 = state_15813__$1;
(statearr_15918_16104[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (51))){
var inst_15626 = (state_15813[(30)]);
var state_15813__$1 = state_15813;
var statearr_15919_16105 = state_15813__$1;
(statearr_15919_16105[(2)] = inst_15626);

(statearr_15919_16105[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (25))){
var inst_15587 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15920_16106 = state_15813__$1;
(statearr_15920_16106[(2)] = inst_15587);

(statearr_15920_16106[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (34))){
var inst_15541 = (state_15813[(10)]);
var inst_15604 = (state_15813[(18)]);
var inst_15603 = (state_15813[(2)]);
var inst_15604__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_15541);
var state_15813__$1 = (function (){var statearr_15921 = state_15813;
(statearr_15921[(18)] = inst_15604__$1);

(statearr_15921[(28)] = inst_15603);

return statearr_15921;
})();
if(cljs.core.truth_(inst_15604__$1)){
var statearr_15922_16107 = state_15813__$1;
(statearr_15922_16107[(1)] = (38));

} else {
var statearr_15923_16108 = state_15813__$1;
(statearr_15923_16108[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (17))){
var inst_15529 = (state_15813[(15)]);
var inst_15561 = fluree.db.query.schema.type_error.call(null,inst_15529,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_15813__$1 = state_15813;
var statearr_15924_16109 = state_15813__$1;
(statearr_15924_16109[(2)] = inst_15561);

(statearr_15924_16109[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (3))){
var inst_15811 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15813__$1,inst_15811);
} else {
if((state_val_15814 === (12))){
var inst_15545 = (state_15813[(31)]);
var state_15813__$1 = state_15813;
var statearr_15925_16110 = state_15813__$1;
(statearr_15925_16110[(2)] = inst_15545);

(statearr_15925_16110[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (2))){
var _ = (function (){var statearr_15926 = state_15813;
(statearr_15926[(4)] = cljs.core.cons.call(null,(5),(state_15813[(4)])));

return statearr_15926;
})();
var inst_15521 = pred_changes;
var inst_15522 = cljs.core.seq.call(null,inst_15521);
var inst_15523 = cljs.core.first.call(null,inst_15522);
var inst_15524 = cljs.core.next.call(null,inst_15522);
var inst_15525 = cljs.core.nth.call(null,inst_15523,(0),null);
var inst_15526 = cljs.core.nth.call(null,inst_15523,(1),null);
var inst_15527 = db;
var inst_15528 = inst_15521;
var inst_15529 = inst_15527;
var state_15813__$1 = (function (){var statearr_15927 = state_15813;
(statearr_15927[(21)] = inst_15528);

(statearr_15927[(32)] = inst_15524);

(statearr_15927[(15)] = inst_15529);

(statearr_15927[(33)] = inst_15525);

(statearr_15927[(34)] = inst_15526);

return statearr_15927;
})();
var statearr_15928_16111 = state_15813__$1;
(statearr_15928_16111[(2)] = null);

(statearr_15928_16111[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (66))){
var inst_15673 = (state_15813[(8)]);
var inst_15541 = (state_15813[(10)]);
var inst_15672 = (state_15813[(9)]);
var inst_15670 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15541);
var inst_15671 = cljs.core.__destructure_map.call(null,inst_15670);
var inst_15672__$1 = cljs.core.get.call(null,inst_15671,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_15673__$1 = cljs.core.get.call(null,inst_15671,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_15674 = cljs.core._EQ_.call(null,inst_15673__$1,inst_15672__$1);
var state_15813__$1 = (function (){var statearr_15929 = state_15813;
(statearr_15929[(8)] = inst_15673__$1);

(statearr_15929[(9)] = inst_15672__$1);

return statearr_15929;
})();
if(inst_15674){
var statearr_15930_16112 = state_15813__$1;
(statearr_15930_16112[(1)] = (69));

} else {
var statearr_15931_16113 = state_15813__$1;
(statearr_15931_16113[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (107))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15755 = fluree.db.query.schema.type_error.call(null,inst_15672,inst_15673,throw_QMARK_);
var state_15813__$1 = state_15813;
var statearr_15932_16114 = state_15813__$1;
(statearr_15932_16114[(2)] = inst_15755);

(statearr_15932_16114[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (23))){
var inst_15541 = (state_15813[(10)]);
var inst_15570 = (state_15813[(17)]);
var inst_15569 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15541);
var inst_15570__$1 = inst_15569 === true;
var state_15813__$1 = (function (){var statearr_15933 = state_15813;
(statearr_15933[(17)] = inst_15570__$1);

return statearr_15933;
})();
if(cljs.core.truth_(inst_15570__$1)){
var statearr_15934_16115 = state_15813__$1;
(statearr_15934_16115[(1)] = (26));

} else {
var statearr_15935_16116 = state_15813__$1;
(statearr_15935_16116[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (47))){
var inst_15541 = (state_15813[(10)]);
var inst_15626 = (state_15813[(30)]);
var inst_15625 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15541);
var inst_15626__$1 = cljs.core.not.call(null,inst_15625);
var state_15813__$1 = (function (){var statearr_15936 = state_15813;
(statearr_15936[(30)] = inst_15626__$1);

return statearr_15936;
})();
if(inst_15626__$1){
var statearr_15937_16117 = state_15813__$1;
(statearr_15937_16117[(1)] = (50));

} else {
var statearr_15938_16118 = state_15813__$1;
(statearr_15938_16118[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (35))){
var inst_15593 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15594 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15595 = cljs.core.PersistentHashMap.fromArrays(inst_15593,inst_15594);
var inst_15596 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_15595);
var inst_15597 = (function(){throw inst_15596})();
var state_15813__$1 = state_15813;
var statearr_15939_16119 = state_15813__$1;
(statearr_15939_16119[(2)] = inst_15597);

(statearr_15939_16119[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (82))){
var inst_15693 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15940_16120 = state_15813__$1;
(statearr_15940_16120[(2)] = inst_15693);

(statearr_15940_16120[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (76))){
var state_15813__$1 = state_15813;
var statearr_15941_16121 = state_15813__$1;
(statearr_15941_16121[(2)] = null);

(statearr_15941_16121[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (97))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15731 = fluree.db.query.schema.type_error.call(null,inst_15672,inst_15673,throw_QMARK_);
var state_15813__$1 = state_15813;
var statearr_15942_16122 = state_15813__$1;
(statearr_15942_16122[(2)] = inst_15731);

(statearr_15942_16122[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (19))){
var inst_15565 = (state_15813[(24)]);
var inst_15541 = (state_15813[(10)]);
var inst_15564 = (state_15813[(2)]);
var inst_15565__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_15541);
var state_15813__$1 = (function (){var statearr_15943 = state_15813;
(statearr_15943[(24)] = inst_15565__$1);

(statearr_15943[(26)] = inst_15564);

return statearr_15943;
})();
if(cljs.core.truth_(inst_15565__$1)){
var statearr_15944_16123 = state_15813__$1;
(statearr_15944_16123[(1)] = (20));

} else {
var statearr_15945_16124 = state_15813__$1;
(statearr_15945_16124[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (57))){
var state_15813__$1 = state_15813;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_15946_16125 = state_15813__$1;
(statearr_15946_16125[(1)] = (60));

} else {
var statearr_15947_16126 = state_15813__$1;
(statearr_15947_16126[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (68))){
var inst_15541 = (state_15813[(10)]);
var inst_15770 = (state_15813[(27)]);
var inst_15768 = (state_15813[(2)]);
var inst_15769 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15541);
var inst_15770__$1 = inst_15769 === true;
var state_15813__$1 = (function (){var statearr_15948 = state_15813;
(statearr_15948[(7)] = inst_15768);

(statearr_15948[(27)] = inst_15770__$1);

return statearr_15948;
})();
if(cljs.core.truth_(inst_15770__$1)){
var statearr_15949_16127 = state_15813__$1;
(statearr_15949_16127[(1)] = (108));

} else {
var statearr_15950_16128 = state_15813__$1;
(statearr_15950_16128[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (11))){
var inst_15541 = (state_15813[(10)]);
var inst_15549 = (state_15813[(23)]);
var inst_15547 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15541);
var inst_15548 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15547);
var inst_15549__$1 = inst_15548 === false;
var state_15813__$1 = (function (){var statearr_15951 = state_15813;
(statearr_15951[(23)] = inst_15549__$1);

return statearr_15951;
})();
if(cljs.core.truth_(inst_15549__$1)){
var statearr_15952_16129 = state_15813__$1;
(statearr_15952_16129[(1)] = (14));

} else {
var statearr_15953_16130 = state_15813__$1;
(statearr_15953_16130[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (115))){
var inst_15776 = (state_15813[(29)]);
var state_15813__$1 = state_15813;
var statearr_15955_16131 = state_15813__$1;
(statearr_15955_16131[(2)] = inst_15776);

(statearr_15955_16131[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (9))){
var inst_15545 = (state_15813[(31)]);
var inst_15541 = (state_15813[(10)]);
var inst_15545__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15541);
var state_15813__$1 = (function (){var statearr_15956 = state_15813;
(statearr_15956[(31)] = inst_15545__$1);

return statearr_15956;
})();
if(cljs.core.truth_(inst_15545__$1)){
var statearr_15957_16132 = state_15813__$1;
(statearr_15957_16132[(1)] = (11));

} else {
var statearr_15958_16133 = state_15813__$1;
(statearr_15958_16133[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (5))){
var _ = (function (){var statearr_15959 = state_15813;
(statearr_15959[(4)] = cljs.core.rest.call(null,(state_15813[(4)])));

return statearr_15959;
})();
var state_15813__$1 = state_15813;
var ex15954 = (state_15813__$1[(2)]);
var statearr_15960_16134 = state_15813__$1;
(statearr_15960_16134[(5)] = ex15954);


if((ex15954 instanceof Error)){
var statearr_15961_16135 = state_15813__$1;
(statearr_15961_16135[(1)] = (4));

(statearr_15961_16135[(5)] = null);

} else {
throw ex15954;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (112))){
var inst_15772 = (state_15813[(25)]);
var state_15813__$1 = state_15813;
var statearr_15962_16136 = state_15813__$1;
(statearr_15962_16136[(2)] = inst_15772);

(statearr_15962_16136[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (83))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15695 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15696 = inst_15673.call(null,cljs.core.PersistentArrayMap,null,3,inst_15695,null);
var inst_15697 = inst_15673.call(null,cljs.core.PersistentHashSet,null,inst_15696,null);
var inst_15698 = inst_15697.call(null,inst_15672);
var state_15813__$1 = state_15813;
if(cljs.core.truth_(inst_15698)){
var statearr_15963_16137 = state_15813__$1;
(statearr_15963_16137[(1)] = (84));

} else {
var statearr_15964_16138 = state_15813__$1;
(statearr_15964_16138[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (14))){
var inst_15541 = (state_15813[(10)]);
var inst_15551 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_15541);
var inst_15552 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_15551);
var inst_15553 = inst_15552 === true;
var state_15813__$1 = state_15813;
var statearr_15965_16139 = state_15813__$1;
(statearr_15965_16139[(2)] = inst_15553);

(statearr_15965_16139[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (45))){
var inst_15603 = (state_15813[(28)]);
var state_15813__$1 = state_15813;
var statearr_15966_16140 = state_15813__$1;
(statearr_15966_16140[(2)] = inst_15603);

(statearr_15966_16140[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (53))){
var inst_15529 = (state_15813[(15)]);
var inst_15540 = (state_15813[(16)]);
var inst_15632 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_15529,inst_15540);
var state_15813__$1 = state_15813;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15813__$1,(56),inst_15632);
} else {
if((state_val_15814 === (78))){
var inst_15758 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15967_16141 = state_15813__$1;
(statearr_15967_16141[(2)] = inst_15758);

(statearr_15967_16141[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (26))){
var inst_15541 = (state_15813[(10)]);
var inst_15574 = (state_15813[(35)]);
var inst_15572 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15541);
var inst_15573 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15572);
var inst_15574__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_15573);
var state_15813__$1 = (function (){var statearr_15968 = state_15813;
(statearr_15968[(35)] = inst_15574__$1);

return statearr_15968;
})();
if(inst_15574__$1){
var statearr_15969_16142 = state_15813__$1;
(statearr_15969_16142[(1)] = (29));

} else {
var statearr_15970_16143 = state_15813__$1;
(statearr_15970_16143[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (16))){
var inst_15556 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15971_16144 = state_15813__$1;
(statearr_15971_16144[(2)] = inst_15556);

(statearr_15971_16144[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (81))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15691 = fluree.db.query.schema.type_error.call(null,inst_15672,inst_15673,throw_QMARK_);
var state_15813__$1 = state_15813;
var statearr_15972_16145 = state_15813__$1;
(statearr_15972_16145[(2)] = inst_15691);

(statearr_15972_16145[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (120))){
var inst_15793 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15794 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_15795 = cljs.core.PersistentHashMap.fromArrays(inst_15793,inst_15794);
var inst_15796 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_15795);
var inst_15797 = (function(){throw inst_15796})();
var state_15813__$1 = state_15813;
var statearr_15973_16146 = state_15813__$1;
(statearr_15973_16146[(2)] = inst_15797);

(statearr_15973_16146[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (79))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15685 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_15686 = inst_15673.call(null,cljs.core.PersistentArrayMap,null,2,inst_15685,null);
var inst_15687 = inst_15673.call(null,cljs.core.PersistentHashSet,null,inst_15686,null);
var inst_15688 = inst_15687.call(null,inst_15672);
var state_15813__$1 = state_15813;
if(cljs.core.truth_(inst_15688)){
var statearr_15974_16147 = state_15813__$1;
(statearr_15974_16147[(1)] = (80));

} else {
var statearr_15975_16148 = state_15813__$1;
(statearr_15975_16148[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (38))){
var inst_15541 = (state_15813[(10)]);
var inst_15607 = (state_15813[(36)]);
var inst_15606 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_15541);
var inst_15607__$1 = cljs.core.not.call(null,inst_15606);
var state_15813__$1 = (function (){var statearr_15976 = state_15813;
(statearr_15976[(36)] = inst_15607__$1);

return statearr_15976;
})();
if(inst_15607__$1){
var statearr_15977_16149 = state_15813__$1;
(statearr_15977_16149[(1)] = (41));

} else {
var statearr_15978_16150 = state_15813__$1;
(statearr_15978_16150[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (98))){
var inst_15733 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15979_16151 = state_15813__$1;
(statearr_15979_16151[(2)] = inst_15733);

(statearr_15979_16151[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (87))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15705 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_15706 = inst_15673.call(null,cljs.core.PersistentArrayMap,null,3,inst_15705,null);
var inst_15707 = inst_15673.call(null,cljs.core.PersistentHashSet,null,inst_15706,null);
var inst_15708 = inst_15707.call(null,inst_15672);
var state_15813__$1 = state_15813;
if(cljs.core.truth_(inst_15708)){
var statearr_15980_16152 = state_15813__$1;
(statearr_15980_16152[(1)] = (88));

} else {
var statearr_15981_16153 = state_15813__$1;
(statearr_15981_16153[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (30))){
var inst_15574 = (state_15813[(35)]);
var state_15813__$1 = state_15813;
var statearr_15982_16154 = state_15813__$1;
(statearr_15982_16154[(2)] = inst_15574);

(statearr_15982_16154[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (73))){
var state_15813__$1 = state_15813;
var statearr_15983_16155 = state_15813__$1;
(statearr_15983_16155[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (96))){
var inst_15660 = (state_15813[(12)]);
var state_15813__$1 = state_15813;
var statearr_15985_16156 = state_15813__$1;
(statearr_15985_16156[(2)] = inst_15660);

(statearr_15985_16156[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (10))){
var inst_15806 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15986_16157 = state_15813__$1;
(statearr_15986_16157[(2)] = inst_15806);

(statearr_15986_16157[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (18))){
var inst_15529 = (state_15813[(15)]);
var state_15813__$1 = state_15813;
var statearr_15987_16158 = state_15813__$1;
(statearr_15987_16158[(2)] = inst_15529);

(statearr_15987_16158[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (105))){
var inst_15673 = (state_15813[(8)]);
var inst_15672 = (state_15813[(9)]);
var inst_15751 = fluree.db.query.schema.type_error.call(null,inst_15672,inst_15673,throw_QMARK_);
var state_15813__$1 = state_15813;
var statearr_15988_16159 = state_15813__$1;
(statearr_15988_16159[(2)] = inst_15751);

(statearr_15988_16159[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (52))){
var inst_15642 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15989_16160 = state_15813__$1;
(statearr_15989_16160[(2)] = inst_15642);

(statearr_15989_16160[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (114))){
var inst_15541 = (state_15813[(10)]);
var inst_15778 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15541);
var inst_15779 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_15778);
var inst_15780 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_15779);
var inst_15781 = (!(inst_15780));
var state_15813__$1 = state_15813;
var statearr_15990_16161 = state_15813__$1;
(statearr_15990_16161[(2)] = inst_15781);

(statearr_15990_16161[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (67))){
var inst_15660 = (state_15813[(12)]);
var state_15813__$1 = state_15813;
var statearr_15991_16162 = state_15813__$1;
(statearr_15991_16162[(2)] = inst_15660);

(statearr_15991_16162[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (71))){
var inst_15765 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15992_16163 = state_15813__$1;
(statearr_15992_16163[(2)] = inst_15765);

(statearr_15992_16163[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (42))){
var inst_15607 = (state_15813[(36)]);
var state_15813__$1 = state_15813;
var statearr_15993_16164 = state_15813__$1;
(statearr_15993_16164[(2)] = inst_15607);

(statearr_15993_16164[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (80))){
var inst_15660 = (state_15813[(12)]);
var state_15813__$1 = state_15813;
var statearr_15994_16165 = state_15813__$1;
(statearr_15994_16165[(2)] = inst_15660);

(statearr_15994_16165[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (37))){
var inst_15600 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15995_16166 = state_15813__$1;
(statearr_15995_16166[(2)] = inst_15600);

(statearr_15995_16166[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (63))){
var inst_15541 = (state_15813[(10)]);
var inst_15663 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_15541);
var inst_15664 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_15663);
var state_15813__$1 = state_15813;
var statearr_15996_16167 = state_15813__$1;
(statearr_15996_16167[(2)] = inst_15664);

(statearr_15996_16167[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (94))){
var inst_15723 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
var statearr_15997_16168 = state_15813__$1;
(statearr_15997_16168[(2)] = inst_15723);

(statearr_15997_16168[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (8))){
var inst_15529 = (state_15813[(15)]);
var state_15813__$1 = state_15813;
var statearr_15998_16169 = state_15813__$1;
(statearr_15998_16169[(2)] = inst_15529);

(statearr_15998_16169[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (49))){
var inst_15645 = (state_15813[(2)]);
var state_15813__$1 = state_15813;
if(cljs.core.truth_(inst_15645)){
var statearr_15999_16170 = state_15813__$1;
(statearr_15999_16170[(1)] = (57));

} else {
var statearr_16000_16171 = state_15813__$1;
(statearr_16000_16171[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15814 === (84))){
var inst_15660 = (state_15813[(12)]);
var state_15813__$1 = state_15813;
var statearr_16001_16172 = state_15813__$1;
(statearr_16001_16172[(2)] = inst_15660);

(statearr_16001_16172[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2746__auto__ = null;
var fluree$db$query$schema$state_machine__2746__auto____0 = (function (){
var statearr_16002 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16002[(0)] = fluree$db$query$schema$state_machine__2746__auto__);

(statearr_16002[(1)] = (1));

return statearr_16002;
});
var fluree$db$query$schema$state_machine__2746__auto____1 = (function (state_15813){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_15813);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16003){var ex__2749__auto__ = e16003;
var statearr_16004_16173 = state_15813;
(statearr_16004_16173[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_15813[(4)]))){
var statearr_16005_16174 = state_15813;
(statearr_16005_16174[(1)] = cljs.core.first.call(null,(state_15813[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16175 = state_15813;
state_15813 = G__16175;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2746__auto__ = function(state_15813){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2746__auto____1.call(this,state_15813);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2746__auto____0;
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2746__auto____1;
return fluree$db$query$schema$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16006 = f__2769__auto__.call(null);
(statearr_16006[(6)] = c__2768__auto__);

return statearr_16006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16177 = arguments.length;
switch (G__16177) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.call(null,db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16201){
var state_val_16202 = (state_16201[(1)]);
if((state_val_16202 === (7))){
var state_16201__$1 = state_16201;
var statearr_16203_16223 = state_16201__$1;
(statearr_16203_16223[(2)] = db);

(statearr_16203_16223[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16202 === (1))){
var state_16201__$1 = state_16201;
var statearr_16204_16224 = state_16201__$1;
(statearr_16204_16224[(2)] = null);

(statearr_16204_16224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16202 === (4))){
var inst_16178 = (state_16201[(2)]);
var state_16201__$1 = state_16201;
var statearr_16205_16225 = state_16201__$1;
(statearr_16205_16225[(2)] = inst_16178);

(statearr_16205_16225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16202 === (6))){
var inst_16187 = (state_16201[(7)]);
var inst_16186 = (state_16201[(2)]);
var inst_16187__$1 = fluree.db.util.async.throw_err.call(null,inst_16186);
var inst_16188 = cljs.core.empty_QMARK_.call(null,inst_16187__$1);
var state_16201__$1 = (function (){var statearr_16206 = state_16201;
(statearr_16206[(7)] = inst_16187__$1);

return statearr_16206;
})();
if(inst_16188){
var statearr_16207_16226 = state_16201__$1;
(statearr_16207_16226[(1)] = (7));

} else {
var statearr_16208_16227 = state_16201__$1;
(statearr_16208_16227[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16202 === (3))){
var inst_16199 = (state_16201[(2)]);
var state_16201__$1 = state_16201;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16201__$1,inst_16199);
} else {
if((state_val_16202 === (2))){
var _ = (function (){var statearr_16210 = state_16201;
(statearr_16210[(4)] = cljs.core.cons.call(null,(5),(state_16201[(4)])));

return statearr_16210;
})();
var inst_16184 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes,filter_QMARK_);
var state_16201__$1 = state_16201;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16201__$1,(6),inst_16184);
} else {
if((state_val_16202 === (9))){
var inst_16196 = (state_16201[(2)]);
var _ = (function (){var statearr_16211 = state_16201;
(statearr_16211[(4)] = cljs.core.rest.call(null,(state_16201[(4)])));

return statearr_16211;
})();
var state_16201__$1 = state_16201;
var statearr_16212_16228 = state_16201__$1;
(statearr_16212_16228[(2)] = inst_16196);

(statearr_16212_16228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16202 === (5))){
var _ = (function (){var statearr_16213 = state_16201;
(statearr_16213[(4)] = cljs.core.rest.call(null,(state_16201[(4)])));

return statearr_16213;
})();
var state_16201__$1 = state_16201;
var ex16209 = (state_16201__$1[(2)]);
var statearr_16214_16229 = state_16201__$1;
(statearr_16214_16229[(5)] = ex16209);


if((ex16209 instanceof Error)){
var statearr_16215_16230 = state_16201__$1;
(statearr_16215_16230[(1)] = (4));

(statearr_16215_16230[(5)] = null);

} else {
throw ex16209;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16202 === (10))){
var inst_16193 = (state_16201[(2)]);
var inst_16194 = fluree.db.util.async.throw_err.call(null,inst_16193);
var state_16201__$1 = state_16201;
var statearr_16216_16231 = state_16201__$1;
(statearr_16216_16231[(2)] = inst_16194);

(statearr_16216_16231[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16202 === (8))){
var inst_16187 = (state_16201[(7)]);
var inst_16191 = fluree.db.query.schema.predicate_change_error.call(null,inst_16187,db,true);
var state_16201__$1 = state_16201;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16201__$1,(10),inst_16191);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2746__auto__ = null;
var fluree$db$query$schema$state_machine__2746__auto____0 = (function (){
var statearr_16217 = [null,null,null,null,null,null,null,null];
(statearr_16217[(0)] = fluree$db$query$schema$state_machine__2746__auto__);

(statearr_16217[(1)] = (1));

return statearr_16217;
});
var fluree$db$query$schema$state_machine__2746__auto____1 = (function (state_16201){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16201);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16218){var ex__2749__auto__ = e16218;
var statearr_16219_16232 = state_16201;
(statearr_16219_16232[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16201[(4)]))){
var statearr_16220_16233 = state_16201;
(statearr_16220_16233[(1)] = cljs.core.first.call(null,(state_16201[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16234 = state_16201;
state_16201 = G__16234;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2746__auto__ = function(state_16201){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2746__auto____1.call(this,state_16201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2746__auto____0;
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2746__auto____1;
return fluree$db$query$schema$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16221 = f__2769__auto__.call(null);
(statearr_16221[(6)] = c__2768__auto__);

return statearr_16221;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16236 = arguments.length;
switch (G__16236) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16238 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__16238,(0),null);
var ns = cljs.core.nth.call(null,vec__16238,(1),null);
var name = cljs.core.nth.call(null,vec__16238,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = fluree.db.flake.p.call(null,flake);
var o = fluree.db.flake.o.call(null,flake);
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__4251__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__4251__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__16241_SHARP_,p2__16242_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16241_SHARP_,p2__16242_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec.call(null,cljs.core.keep.call(null,(function (p1__16243_SHARP_){
var f = p1__16243_SHARP_;
if(cljs.core._EQ_.call(null,spec_pid,fluree.db.flake.p.call(null,f))){
return fluree.db.flake.o.call(null,f);
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16309){
var state_val_16310 = (state_16309[(1)]);
if((state_val_16310 === (1))){
var state_16309__$1 = state_16309;
var statearr_16311_16328 = state_16309__$1;
(statearr_16311_16328[(2)] = null);

(statearr_16311_16328[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16310 === (2))){
var _ = (function (){var statearr_16312 = state_16309;
(statearr_16312[(4)] = cljs.core.cons.call(null,(5),(state_16309[(4)])));

return statearr_16312;
})();
var inst_16261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16262 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_16263 = [inst_16262];
var inst_16264 = (new cljs.core.PersistentVector(null,1,(5),inst_16261,inst_16263,null));
var inst_16265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16266 = [(0)];
var inst_16267 = (new cljs.core.PersistentVector(null,1,(5),inst_16265,inst_16266,null));
var inst_16268 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16264,cljs.core._LT__EQ_,inst_16267);
var state_16309__$1 = state_16309;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16309__$1,(6),inst_16268);
} else {
if((state_val_16310 === (3))){
var inst_16307 = (state_16309[(2)]);
var state_16309__$1 = state_16309;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16309__$1,inst_16307);
} else {
if((state_val_16310 === (4))){
var inst_16249 = (state_16309[(2)]);
var state_16309__$1 = state_16309;
var statearr_16314_16329 = state_16309__$1;
(statearr_16314_16329[(2)] = inst_16249);

(statearr_16314_16329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16310 === (5))){
var _ = (function (){var statearr_16315 = state_16309;
(statearr_16315[(4)] = cljs.core.rest.call(null,(state_16309[(4)])));

return statearr_16315;
})();
var state_16309__$1 = state_16309;
var ex16313 = (state_16309__$1[(2)]);
var statearr_16316_16330 = state_16309__$1;
(statearr_16316_16330[(5)] = ex16313);


if((ex16313 instanceof Error)){
var statearr_16317_16331 = state_16309__$1;
(statearr_16317_16331[(1)] = (4));

(statearr_16317_16331[(5)] = null);

} else {
throw ex16313;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16310 === (6))){
var inst_16270 = (state_16309[(2)]);
var inst_16271 = fluree.db.util.async.throw_err.call(null,inst_16270);
var inst_16272 = (function (){var schema_flakes = inst_16271;
return (function (p1__16244_SHARP_){
return (fluree.db.flake.s.call(null,p1__16244_SHARP_) <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_16273 = cljs.core.partition_by.call(null,inst_16272,inst_16271);
var inst_16274 = cljs.core.nth.call(null,inst_16273,(0),null);
var inst_16275 = cljs.core.nth.call(null,inst_16273,(1),null);
var inst_16276 = (function (){var schema_flakes = inst_16271;
var vec__16255 = inst_16273;
var collection_flakes = inst_16274;
var predicate_flakes = inst_16275;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first.call(null,coll_flakes);
var sid = fluree.db.flake.s.call(null,first_flake);
var p__GT_v = cljs.core.reduce.call(null,(function (p1__16247_SHARP_,p2__16246_SHARP_){
var f = p2__16246_SHARP_;
return cljs.core.assoc.call(null,p1__16247_SHARP_,fluree.db.flake.p.call(null,f),fluree.db.flake.o.call(null,f));
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4253__auto__ = cljs.core.get.call(null,p__GT_v,(47));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.sid__GT_i.call(null,sid);
}
})();
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids.call(null,(43),coll_flakes):null);
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.call(null,acc,partition,c_props,c_name,c_props);
});
})();
var inst_16277 = [(-1),"_tx"];
var inst_16278 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16279 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16280 = cljs.core.PersistentHashMap.fromArrays(inst_16278,inst_16279);
var inst_16281 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16282 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16283 = cljs.core.PersistentHashMap.fromArrays(inst_16281,inst_16282);
var inst_16284 = [inst_16280,inst_16283];
var inst_16285 = cljs.core.PersistentHashMap.fromArrays(inst_16277,inst_16284);
var inst_16286 = (function (){var schema_flakes = inst_16271;
var vec__16255 = inst_16273;
var collection_flakes = inst_16274;
var predicate_flakes = inst_16275;
return (function (p1__16245_SHARP_){
return fluree.db.flake.s.call(null,p1__16245_SHARP_);
});
})();
var inst_16287 = cljs.core.partition_by.call(null,inst_16286,inst_16274);
var inst_16288 = cljs.core.reduce.call(null,inst_16276,inst_16285,inst_16287);
var inst_16290 = (function (){var schema_flakes = inst_16271;
var vec__16255 = inst_16273;
var collection_flakes = inst_16274;
var predicate_flakes = inst_16275;
var coll = inst_16288;
return (function (p__16289,pred_flakes){
var vec__16318 = p__16289;
var pred = cljs.core.nth.call(null,vec__16318,(0),null);
var fullText = cljs.core.nth.call(null,vec__16318,(1),null);
var first_flake = cljs.core.first.call(null,pred_flakes);
var id = fluree.db.flake.s.call(null,first_flake);
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__4253__auto__ = ref_QMARK_;
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids.call(null,(24),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids.call(null,(20),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(29))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_16291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16292 = cljs.core.PersistentHashMap.EMPTY;
var inst_16293 = cljs.core.PersistentHashSet.EMPTY;
var inst_16294 = [inst_16292,inst_16293];
var inst_16295 = (new cljs.core.PersistentVector(null,2,(5),inst_16291,inst_16294,null));
var inst_16296 = (function (){var schema_flakes = inst_16271;
var vec__16255 = inst_16273;
var collection_flakes = inst_16274;
var predicate_flakes = inst_16275;
var coll = inst_16288;
return (function (p1__16248_SHARP_){
return fluree.db.flake.s.call(null,p1__16248_SHARP_);
});
})();
var inst_16297 = cljs.core.partition_by.call(null,inst_16296,inst_16275);
var inst_16298 = cljs.core.reduce.call(null,inst_16290,inst_16295,inst_16297);
var inst_16299 = cljs.core.nth.call(null,inst_16298,(0),null);
var inst_16300 = cljs.core.nth.call(null,inst_16298,(1),null);
var inst_16301 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_16302 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_16303 = [inst_16302,inst_16288,inst_16299,inst_16300];
var inst_16304 = cljs.core.PersistentHashMap.fromArrays(inst_16301,inst_16303);
var _ = (function (){var statearr_16321 = state_16309;
(statearr_16321[(4)] = cljs.core.rest.call(null,(state_16309[(4)])));

return statearr_16321;
})();
var state_16309__$1 = state_16309;
var statearr_16322_16332 = state_16309__$1;
(statearr_16322_16332[(2)] = inst_16304);

(statearr_16322_16332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0 = (function (){
var statearr_16323 = [null,null,null,null,null,null,null];
(statearr_16323[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2746__auto__);

(statearr_16323[(1)] = (1));

return statearr_16323;
});
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1 = (function (state_16309){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16309);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16324){var ex__2749__auto__ = e16324;
var statearr_16325_16333 = state_16309;
(statearr_16325_16333[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16309[(4)]))){
var statearr_16326_16334 = state_16309;
(statearr_16326_16334[(1)] = cljs.core.first.call(null,(state_16309[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16335 = state_16309;
state_16309 = G__16335;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__ = function(state_16309){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1.call(this,state_16309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16327 = f__2769__auto__.call(null);
(statearr_16327[(6)] = c__2768__auto__);

return statearr_16327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16377){
var state_val_16378 = (state_16377[(1)]);
if((state_val_16378 === (7))){
var inst_16360 = (state_16377[(2)]);
var inst_16361 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_16360);
var inst_16362 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_16363 = cljs.core.get.call(null,inst_16361,(114));
var inst_16364 = cljs.core.boolean$.call(null,inst_16363);
var inst_16365 = cljs.core.get.call(null,inst_16361,(110));
var inst_16366 = cljs.core.get.call(null,inst_16361,(117));
var inst_16367 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_16366);
var inst_16368 = cljs.core.get.call(null,inst_16361,(111));
var inst_16369 = cljs.core.get.call(null,inst_16361,(115));
var inst_16370 = cljs.core.get.call(null,inst_16361,(112));
var inst_16371 = [inst_16364,inst_16365,inst_16367,inst_16368,inst_16369,inst_16370];
var inst_16372 = cljs.core.PersistentHashMap.fromArrays(inst_16362,inst_16371);
var _ = (function (){var statearr_16379 = state_16377;
(statearr_16379[(4)] = cljs.core.rest.call(null,(state_16377[(4)])));

return statearr_16379;
})();
var state_16377__$1 = state_16377;
var statearr_16380_16403 = state_16377__$1;
(statearr_16380_16403[(2)] = inst_16372);

(statearr_16380_16403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16378 === (1))){
var state_16377__$1 = state_16377;
var statearr_16381_16404 = state_16377__$1;
(statearr_16381_16404[(2)] = null);

(statearr_16381_16404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16378 === (4))){
var inst_16336 = (state_16377[(2)]);
var state_16377__$1 = state_16377;
var statearr_16382_16405 = state_16377__$1;
(statearr_16382_16405[(2)] = inst_16336);

(statearr_16382_16405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16378 === (6))){
var _ = (function (){var statearr_16383 = state_16377;
(statearr_16383[(4)] = cljs.core.cons.call(null,(9),(state_16377[(4)])));

return statearr_16383;
})();
var inst_16348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16350 = ["_setting/id","root"];
var inst_16351 = (new cljs.core.PersistentVector(null,2,(5),inst_16349,inst_16350,null));
var inst_16352 = [inst_16351];
var inst_16353 = (new cljs.core.PersistentVector(null,1,(5),inst_16348,inst_16352,null));
var inst_16354 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16353);
var state_16377__$1 = state_16377;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16377__$1,(10),inst_16354);
} else {
if((state_val_16378 === (3))){
var inst_16375 = (state_16377[(2)]);
var state_16377__$1 = state_16377;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16377__$1,inst_16375);
} else {
if((state_val_16378 === (2))){
var _ = (function (){var statearr_16386 = state_16377;
(statearr_16386[(4)] = cljs.core.cons.call(null,(5),(state_16377[(4)])));

return statearr_16386;
})();
var state_16377__$1 = state_16377;
var statearr_16387_16406 = state_16377__$1;
(statearr_16387_16406[(2)] = null);

(statearr_16387_16406[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16378 === (9))){
var _ = (function (){var statearr_16388 = state_16377;
(statearr_16388[(4)] = cljs.core.rest.call(null,(state_16377[(4)])));

return statearr_16388;
})();
var state_16377__$1 = state_16377;
var ex16384 = (state_16377__$1[(2)]);
var statearr_16389_16407 = state_16377__$1;
(statearr_16389_16407[(5)] = ex16384);


var statearr_16390_16408 = state_16377__$1;
(statearr_16390_16408[(1)] = (8));

(statearr_16390_16408[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16378 === (5))){
var _ = (function (){var statearr_16391 = state_16377;
(statearr_16391[(4)] = cljs.core.rest.call(null,(state_16377[(4)])));

return statearr_16391;
})();
var state_16377__$1 = state_16377;
var ex16385 = (state_16377__$1[(2)]);
var statearr_16392_16409 = state_16377__$1;
(statearr_16392_16409[(5)] = ex16385);


if((ex16385 instanceof Error)){
var statearr_16393_16410 = state_16377__$1;
(statearr_16393_16410[(1)] = (4));

(statearr_16393_16410[(5)] = null);

} else {
throw ex16385;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16378 === (10))){
var inst_16356 = (state_16377[(2)]);
var inst_16357 = fluree.db.util.async.throw_err.call(null,inst_16356);
var _ = (function (){var statearr_16394 = state_16377;
(statearr_16394[(4)] = cljs.core.rest.call(null,(state_16377[(4)])));

return statearr_16394;
})();
var state_16377__$1 = state_16377;
var statearr_16395_16411 = state_16377__$1;
(statearr_16395_16411[(2)] = inst_16357);

(statearr_16395_16411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16378 === (8))){
var inst_16342 = (state_16377[(2)]);
var state_16377__$1 = (function (){var statearr_16396 = state_16377;
(statearr_16396[(7)] = inst_16342);

return statearr_16396;
})();
var statearr_16397_16412 = state_16377__$1;
(statearr_16397_16412[(2)] = null);

(statearr_16397_16412[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0 = (function (){
var statearr_16398 = [null,null,null,null,null,null,null,null];
(statearr_16398[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2746__auto__);

(statearr_16398[(1)] = (1));

return statearr_16398;
});
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1 = (function (state_16377){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16377);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16399){var ex__2749__auto__ = e16399;
var statearr_16400_16413 = state_16377;
(statearr_16400_16413[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16377[(4)]))){
var statearr_16401_16414 = state_16377;
(statearr_16401_16414[(1)] = cljs.core.first.call(null,(state_16377[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16415 = state_16377;
state_16377 = G__16415;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__ = function(state_16377){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1.call(this,state_16377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16402 = f__2769__auto__.call(null);
(statearr_16402[(6)] = c__2768__auto__);

return statearr_16402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
