// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql_resp');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql_resp.vswap_BANG_ = (function fluree$db$query$fql_resp$vswap_BANG_(var_args){
var G__20990 = arguments.length;
switch (G__20990) {
case 2:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql_resp.has_ns_lookups_QMARK_ = (function fluree$db$query$fql_resp$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql_resp.full_select_spec = (function fluree$db$query$fql_resp$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__4253__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql_resp$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql_resp.add_fuel = (function fluree$db$query$fql_resp$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql_resp.resolve_reverse_refs = (function fluree$db$query$fql_resp$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21151){
var state_val_21152 = (state_21151[(1)]);
if((state_val_21152 === (7))){
var inst_21146 = (state_21151[(2)]);
var _ = (function (){var statearr_21153 = state_21151;
(statearr_21153[(4)] = cljs.core.rest.call(null,(state_21151[(4)])));

return statearr_21153;
})();
var state_21151__$1 = state_21151;
var statearr_21154_21236 = state_21151__$1;
(statearr_21154_21236[(2)] = inst_21146);

(statearr_21154_21236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (20))){
var inst_21073 = (state_21151[(7)]);
var state_21151__$1 = state_21151;
var statearr_21155_21237 = state_21151__$1;
(statearr_21155_21237[(2)] = inst_21073);

(statearr_21155_21237[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (27))){
var inst_21028 = (state_21151[(8)]);
var state_21151__$1 = state_21151;
if(cljs.core.truth_(inst_21028)){
var statearr_21156_21238 = state_21151__$1;
(statearr_21156_21238[(1)] = (29));

} else {
var statearr_21157_21239 = state_21151__$1;
(statearr_21157_21239[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (1))){
var state_21151__$1 = state_21151;
var statearr_21158_21240 = state_21151__$1;
(statearr_21158_21240[(2)] = null);

(statearr_21158_21240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (24))){
var inst_21029 = (state_21151[(9)]);
var state_21151__$1 = state_21151;
var statearr_21159_21241 = state_21151__$1;
(statearr_21159_21241[(2)] = inst_21029);

(statearr_21159_21241[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (39))){
var inst_21065 = (state_21151[(10)]);
var state_21151__$1 = state_21151;
var statearr_21160_21242 = state_21151__$1;
(statearr_21160_21242[(2)] = inst_21065);

(statearr_21160_21242[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (46))){
var inst_21030 = (state_21151[(11)]);
var state_21151__$1 = state_21151;
var statearr_21161_21243 = state_21151__$1;
(statearr_21161_21243[(2)] = inst_21030);

(statearr_21161_21243[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (4))){
var inst_20992 = (state_21151[(2)]);
var state_21151__$1 = state_21151;
var statearr_21162_21244 = state_21151__$1;
(statearr_21162_21244[(2)] = inst_20992);

(statearr_21162_21244[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (15))){
var inst_21041 = (state_21151[(12)]);
var inst_21047 = cljs.core.count.call(null,inst_21041);
var inst_21048 = fluree.db.query.fql_resp.add_fuel.call(null,fuel,inst_21047,max_fuel);
var state_21151__$1 = state_21151;
var statearr_21163_21245 = state_21151__$1;
(statearr_21163_21245[(2)] = inst_21048);

(statearr_21163_21245[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (48))){
var inst_21132 = (state_21151[(13)]);
var inst_21017 = (state_21151[(14)]);
var inst_21010 = (state_21151[(15)]);
var inst_21140 = (state_21151[(2)]);
var inst_21141 = cljs.core.assoc.call(null,inst_21010,inst_21140,inst_21132);
var inst_21009 = inst_21017;
var inst_21010__$1 = inst_21141;
var state_21151__$1 = (function (){var statearr_21164 = state_21151;
(statearr_21164[(16)] = inst_21009);

(statearr_21164[(15)] = inst_21010__$1);

return statearr_21164;
})();
var statearr_21165_21246 = state_21151__$1;
(statearr_21165_21246[(2)] = null);

(statearr_21165_21246[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (50))){
var inst_21032 = (state_21151[(17)]);
var state_21151__$1 = state_21151;
var statearr_21166_21247 = state_21151__$1;
(statearr_21166_21247[(2)] = inst_21032);

(statearr_21166_21247[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (21))){
var inst_21029 = (state_21151[(9)]);
var state_21151__$1 = state_21151;
if(cljs.core.truth_(inst_21029)){
var statearr_21168_21248 = state_21151__$1;
(statearr_21168_21248[(1)] = (23));

} else {
var statearr_21169_21249 = state_21151__$1;
(statearr_21169_21249[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (31))){
var inst_21089 = (state_21151[(2)]);
var state_21151__$1 = state_21151;
if(cljs.core.truth_(inst_21089)){
var statearr_21170_21250 = state_21151__$1;
(statearr_21170_21250[(1)] = (32));

} else {
var statearr_21171_21251 = state_21151__$1;
(statearr_21171_21251[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (32))){
var inst_21064 = (state_21151[(18)]);
var inst_21065 = (state_21151[(10)]);
var inst_21072 = (state_21151[(19)]);
var inst_21091 = (inst_21064 + (1));
var tmp21167 = inst_21065;
var inst_21063 = inst_21072;
var inst_21064__$1 = inst_21091;
var inst_21065__$1 = tmp21167;
var state_21151__$1 = (function (){var statearr_21172 = state_21151;
(statearr_21172[(18)] = inst_21064__$1);

(statearr_21172[(20)] = inst_21063);

(statearr_21172[(10)] = inst_21065__$1);

return statearr_21172;
})();
var statearr_21173_21252 = state_21151__$1;
(statearr_21173_21252[(2)] = null);

(statearr_21173_21252[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (40))){
var state_21151__$1 = state_21151;
if(cljs.core.truth_(fuel)){
var statearr_21174_21253 = state_21151__$1;
(statearr_21174_21253[(1)] = (42));

} else {
var statearr_21175_21254 = state_21151__$1;
(statearr_21175_21254[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (33))){
var state_21151__$1 = state_21151;
var statearr_21176_21255 = state_21151__$1;
(statearr_21176_21255[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (13))){
var inst_21041 = (state_21151[(12)]);
var state_21151__$1 = state_21151;
var statearr_21178_21256 = state_21151__$1;
(statearr_21178_21256[(2)] = inst_21041);

(statearr_21178_21256[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (22))){
var inst_21082 = (state_21151[(2)]);
var state_21151__$1 = state_21151;
if(cljs.core.truth_(inst_21082)){
var statearr_21179_21257 = state_21151__$1;
(statearr_21179_21257[(1)] = (26));

} else {
var statearr_21180_21258 = state_21151__$1;
(statearr_21180_21258[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (36))){
var state_21151__$1 = state_21151;
var statearr_21181_21259 = state_21151__$1;
(statearr_21181_21259[(2)] = null);

(statearr_21181_21259[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (41))){
var inst_21064 = (state_21151[(18)]);
var inst_21072 = (state_21151[(19)]);
var inst_21121 = (state_21151[(2)]);
var inst_21122 = (inst_21064 + (1));
var inst_21063 = inst_21072;
var inst_21064__$1 = inst_21122;
var inst_21065 = inst_21121;
var state_21151__$1 = (function (){var statearr_21182 = state_21151;
(statearr_21182[(18)] = inst_21064__$1);

(statearr_21182[(20)] = inst_21063);

(statearr_21182[(10)] = inst_21065);

return statearr_21182;
})();
var statearr_21183_21260 = state_21151__$1;
(statearr_21183_21260[(2)] = null);

(statearr_21183_21260[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (43))){
var state_21151__$1 = state_21151;
var statearr_21184_21261 = state_21151__$1;
(statearr_21184_21261[(2)] = null);

(statearr_21184_21261[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (29))){
var inst_21028 = (state_21151[(8)]);
var inst_21064 = (state_21151[(18)]);
var inst_21086 = (inst_21064 < inst_21028);
var state_21151__$1 = state_21151;
var statearr_21185_21262 = state_21151__$1;
(statearr_21185_21262[(2)] = inst_21086);

(statearr_21185_21262[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (44))){
var inst_21101 = (state_21151[(21)]);
var inst_21105 = (state_21151[(22)]);
var inst_21114 = (state_21151[(2)]);
var inst_21115 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_21105,inst_21101);
var state_21151__$1 = (function (){var statearr_21186 = state_21151;
(statearr_21186[(23)] = inst_21114);

return statearr_21186;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21151__$1,(45),inst_21115);
} else {
if((state_val_21152 === (6))){
var inst_21009 = (state_21151[(16)]);
var inst_21016 = (state_21151[(24)]);
var inst_21015 = cljs.core.seq.call(null,inst_21009);
var inst_21016__$1 = cljs.core.first.call(null,inst_21015);
var inst_21017 = cljs.core.next.call(null,inst_21015);
var inst_21018 = cljs.core.not.call(null,inst_21016__$1);
var state_21151__$1 = (function (){var statearr_21187 = state_21151;
(statearr_21187[(14)] = inst_21017);

(statearr_21187[(24)] = inst_21016__$1);

return statearr_21187;
})();
if(inst_21018){
var statearr_21188_21263 = state_21151__$1;
(statearr_21188_21263[(1)] = (8));

} else {
var statearr_21189_21264 = state_21151__$1;
(statearr_21189_21264[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (28))){
var inst_21130 = (state_21151[(2)]);
var state_21151__$1 = state_21151;
var statearr_21190_21265 = state_21151__$1;
(statearr_21190_21265[(2)] = inst_21130);

(statearr_21190_21265[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (51))){
var inst_21138 = (state_21151[(2)]);
var state_21151__$1 = state_21151;
var statearr_21191_21266 = state_21151__$1;
(statearr_21191_21266[(2)] = inst_21138);

(statearr_21191_21266[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (25))){
var inst_21080 = (state_21151[(2)]);
var state_21151__$1 = state_21151;
var statearr_21192_21267 = state_21151__$1;
(statearr_21192_21267[(2)] = inst_21080);

(statearr_21192_21267[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (34))){
var inst_21128 = (state_21151[(2)]);
var state_21151__$1 = state_21151;
var statearr_21193_21268 = state_21151__$1;
(statearr_21193_21268[(2)] = inst_21128);

(statearr_21193_21268[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (17))){
var inst_21041 = (state_21151[(12)]);
var inst_21051 = (state_21151[(2)]);
var inst_21059 = cljs.core.seq.call(null,inst_21041);
var inst_21060 = cljs.core.first.call(null,inst_21059);
var inst_21061 = cljs.core.next.call(null,inst_21059);
var inst_21062 = cljs.core.PersistentVector.EMPTY;
var inst_21063 = inst_21041;
var inst_21064 = (0);
var inst_21065 = inst_21062;
var state_21151__$1 = (function (){var statearr_21194 = state_21151;
(statearr_21194[(18)] = inst_21064);

(statearr_21194[(25)] = inst_21061);

(statearr_21194[(20)] = inst_21063);

(statearr_21194[(10)] = inst_21065);

(statearr_21194[(26)] = inst_21060);

(statearr_21194[(27)] = inst_21051);

return statearr_21194;
})();
var statearr_21195_21269 = state_21151__$1;
(statearr_21195_21269[(2)] = null);

(statearr_21195_21269[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (3))){
var inst_21149 = (state_21151[(2)]);
var state_21151__$1 = state_21151;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21151__$1,inst_21149);
} else {
if((state_val_21152 === (12))){
var state_21151__$1 = state_21151;
var statearr_21196_21270 = state_21151__$1;
(statearr_21196_21270[(2)] = fuel);

(statearr_21196_21270[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (2))){
var _ = (function (){var statearr_21197 = state_21151;
(statearr_21197[(4)] = cljs.core.cons.call(null,(5),(state_21151[(4)])));

return statearr_21197;
})();
var inst_21005 = reverse_refs_specs;
var inst_21006 = cljs.core.seq.call(null,inst_21005);
var inst_21007 = cljs.core.first.call(null,inst_21006);
var inst_21008 = cljs.core.next.call(null,inst_21006);
var inst_21009 = inst_21005;
var inst_21010 = null;
var state_21151__$1 = (function (){var statearr_21198 = state_21151;
(statearr_21198[(16)] = inst_21009);

(statearr_21198[(28)] = inst_21008);

(statearr_21198[(29)] = inst_21007);

(statearr_21198[(15)] = inst_21010);

return statearr_21198;
})();
var statearr_21199_21271 = state_21151__$1;
(statearr_21199_21271[(2)] = null);

(statearr_21199_21271[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (23))){
var inst_21064 = (state_21151[(18)]);
var inst_21029 = (state_21151[(9)]);
var inst_21077 = (inst_21064 >= inst_21029);
var state_21151__$1 = state_21151;
var statearr_21200_21272 = state_21151__$1;
(statearr_21200_21272[(2)] = inst_21077);

(statearr_21200_21272[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (47))){
var inst_21031 = (state_21151[(30)]);
var state_21151__$1 = state_21151;
if(cljs.core.truth_(inst_21031)){
var statearr_21201_21273 = state_21151__$1;
(statearr_21201_21273[(1)] = (49));

} else {
var statearr_21202_21274 = state_21151__$1;
(statearr_21202_21274[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (35))){
var inst_21071 = (state_21151[(31)]);
var inst_21095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21096 = [inst_21071];
var inst_21097 = (new cljs.core.PersistentVector(null,1,(5),inst_21095,inst_21096,null));
var inst_21098 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21097);
var state_21151__$1 = state_21151;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21151__$1,(38),inst_21098);
} else {
if((state_val_21152 === (19))){
var inst_21030 = (state_21151[(11)]);
var inst_21132 = (state_21151[(2)]);
var state_21151__$1 = (function (){var statearr_21203 = state_21151;
(statearr_21203[(13)] = inst_21132);

return statearr_21203;
})();
if(cljs.core.truth_(inst_21030)){
var statearr_21204_21275 = state_21151__$1;
(statearr_21204_21275[(1)] = (46));

} else {
var statearr_21205_21276 = state_21151__$1;
(statearr_21205_21276[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (11))){
var inst_21041 = (state_21151[(12)]);
var inst_21038 = (state_21151[(2)]);
var inst_21039 = fluree.db.util.async.throw_err.call(null,inst_21038);
var inst_21040 = cljs.core.map.call(null,fluree.db.flake.s,inst_21039);
var inst_21041__$1 = cljs.core.not_empty.call(null,inst_21040);
var state_21151__$1 = (function (){var statearr_21207 = state_21151;
(statearr_21207[(12)] = inst_21041__$1);

return statearr_21207;
})();
if(cljs.core.truth_(inst_21041__$1)){
var statearr_21208_21277 = state_21151__$1;
(statearr_21208_21277[(1)] = (12));

} else {
var statearr_21209_21278 = state_21151__$1;
(statearr_21209_21278[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (9))){
var inst_21026 = (state_21151[(32)]);
var inst_21016 = (state_21151[(24)]);
var inst_21025 = cljs.core.nth.call(null,inst_21016,(0),null);
var inst_21026__$1 = cljs.core.nth.call(null,inst_21016,(1),null);
var inst_21027 = cljs.core.__destructure_map.call(null,inst_21026__$1);
var inst_21028 = cljs.core.get.call(null,inst_21027,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21029 = cljs.core.get.call(null,inst_21027,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21030 = cljs.core.get.call(null,inst_21027,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_21031 = cljs.core.get.call(null,inst_21027,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_21032 = cljs.core.get.call(null,inst_21027,new cljs.core.Keyword(null,"p","p",151049309));
var inst_21033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21034 = [subject_id,inst_21025];
var inst_21035 = (new cljs.core.PersistentVector(null,2,(5),inst_21033,inst_21034,null));
var inst_21036 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_21035);
var state_21151__$1 = (function (){var statearr_21210 = state_21151;
(statearr_21210[(8)] = inst_21028);

(statearr_21210[(30)] = inst_21031);

(statearr_21210[(11)] = inst_21030);

(statearr_21210[(17)] = inst_21032);

(statearr_21210[(32)] = inst_21026__$1);

(statearr_21210[(9)] = inst_21029);

return statearr_21210;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21151__$1,(11),inst_21036);
} else {
if((state_val_21152 === (5))){
var _ = (function (){var statearr_21211 = state_21151;
(statearr_21211[(4)] = cljs.core.rest.call(null,(state_21151[(4)])));

return statearr_21211;
})();
var state_21151__$1 = state_21151;
var ex21206 = (state_21151__$1[(2)]);
var statearr_21212_21279 = state_21151__$1;
(statearr_21212_21279[(5)] = ex21206);


if((ex21206 instanceof Error)){
var statearr_21213_21280 = state_21151__$1;
(statearr_21213_21280[(1)] = (4));

(statearr_21213_21280[(5)] = null);

} else {
throw ex21206;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (14))){
var inst_21045 = (state_21151[(2)]);
var state_21151__$1 = state_21151;
if(cljs.core.truth_(inst_21045)){
var statearr_21214_21281 = state_21151__$1;
(statearr_21214_21281[(1)] = (15));

} else {
var statearr_21215_21282 = state_21151__$1;
(statearr_21215_21282[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (45))){
var inst_21065 = (state_21151[(10)]);
var inst_21117 = (state_21151[(2)]);
var inst_21118 = fluree.db.util.async.throw_err.call(null,inst_21117);
var inst_21119 = cljs.core.conj.call(null,inst_21065,inst_21118);
var state_21151__$1 = state_21151;
var statearr_21216_21283 = state_21151__$1;
(statearr_21216_21283[(2)] = inst_21119);

(statearr_21216_21283[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (26))){
var inst_21065 = (state_21151[(10)]);
var state_21151__$1 = state_21151;
var statearr_21217_21284 = state_21151__$1;
(statearr_21217_21284[(2)] = inst_21065);

(statearr_21217_21284[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (16))){
var state_21151__$1 = state_21151;
var statearr_21218_21285 = state_21151__$1;
(statearr_21218_21285[(2)] = null);

(statearr_21218_21285[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (38))){
var inst_21101 = (state_21151[(21)]);
var inst_21026 = (state_21151[(32)]);
var inst_21100 = (state_21151[(2)]);
var inst_21101__$1 = fluree.db.util.async.throw_err.call(null,inst_21100);
var inst_21102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21103 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_21104 = (new cljs.core.PersistentVector(null,4,(5),inst_21102,inst_21103,null));
var inst_21105 = cljs.core.select_keys.call(null,inst_21026,inst_21104);
var inst_21106 = cljs.core.empty_QMARK_.call(null,inst_21101__$1);
var state_21151__$1 = (function (){var statearr_21219 = state_21151;
(statearr_21219[(21)] = inst_21101__$1);

(statearr_21219[(22)] = inst_21105);

return statearr_21219;
})();
if(inst_21106){
var statearr_21220_21286 = state_21151__$1;
(statearr_21220_21286[(1)] = (39));

} else {
var statearr_21221_21287 = state_21151__$1;
(statearr_21221_21287[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (30))){
var inst_21028 = (state_21151[(8)]);
var state_21151__$1 = state_21151;
var statearr_21222_21288 = state_21151__$1;
(statearr_21222_21288[(2)] = inst_21028);

(statearr_21222_21288[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (10))){
var inst_21144 = (state_21151[(2)]);
var state_21151__$1 = state_21151;
var statearr_21223_21289 = state_21151__$1;
(statearr_21223_21289[(2)] = inst_21144);

(statearr_21223_21289[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (18))){
var inst_21073 = (state_21151[(7)]);
var inst_21063 = (state_21151[(20)]);
var inst_21071 = (state_21151[(31)]);
var inst_21070 = cljs.core.seq.call(null,inst_21063);
var inst_21071__$1 = cljs.core.first.call(null,inst_21070);
var inst_21072 = cljs.core.next.call(null,inst_21070);
var inst_21073__$1 = cljs.core.not.call(null,inst_21071__$1);
var state_21151__$1 = (function (){var statearr_21224 = state_21151;
(statearr_21224[(7)] = inst_21073__$1);

(statearr_21224[(19)] = inst_21072);

(statearr_21224[(31)] = inst_21071__$1);

return statearr_21224;
})();
if(inst_21073__$1){
var statearr_21225_21290 = state_21151__$1;
(statearr_21225_21290[(1)] = (20));

} else {
var statearr_21226_21291 = state_21151__$1;
(statearr_21226_21291[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (42))){
var inst_21101 = (state_21151[(21)]);
var inst_21110 = cljs.core.count.call(null,inst_21101);
var inst_21111 = fluree.db.query.fql_resp.add_fuel.call(null,fuel,inst_21110,max_fuel);
var state_21151__$1 = state_21151;
var statearr_21227_21292 = state_21151__$1;
(statearr_21227_21292[(2)] = inst_21111);

(statearr_21227_21292[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (37))){
var inst_21126 = (state_21151[(2)]);
var state_21151__$1 = state_21151;
var statearr_21228_21293 = state_21151__$1;
(statearr_21228_21293[(2)] = inst_21126);

(statearr_21228_21293[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (8))){
var inst_21010 = (state_21151[(15)]);
var state_21151__$1 = state_21151;
var statearr_21229_21294 = state_21151__$1;
(statearr_21229_21294[(2)] = inst_21010);

(statearr_21229_21294[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21152 === (49))){
var inst_21031 = (state_21151[(30)]);
var state_21151__$1 = state_21151;
var statearr_21230_21295 = state_21151__$1;
(statearr_21230_21295[(2)] = inst_21031);

(statearr_21230_21295[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0 = (function (){
var statearr_21231 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21231[(0)] = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__);

(statearr_21231[(1)] = (1));

return statearr_21231;
});
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1 = (function (state_21151){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21151);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21232){var ex__2749__auto__ = e21232;
var statearr_21233_21296 = state_21151;
(statearr_21233_21296[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21151[(4)]))){
var statearr_21234_21297 = state_21151;
(statearr_21234_21297[(1)] = cljs.core.first.call(null,(state_21151[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21298 = state_21151;
state_21151 = G__21298;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__ = function(state_21151){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1.call(this,state_21151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21235 = f__2769__auto__.call(null);
(statearr_21235[(6)] = c__2768__auto__);

return statearr_21235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql_resp.component_follow_QMARK_ = (function fluree$db$query$fql_resp$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql_resp.fuel_flake_transducer = (function fluree$db$query$fql_resp$fuel_flake_transducer(var_args){
var G__21300 = arguments.length;
switch (G__21300) {
case 2:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql_resp.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__21302 = null;
var G__21302__0 = (function (){
return xf.call(null);
});
var G__21302__1 = (function (result){
return xf.call(null,result);
});
var G__21302__2 = (function (result,flake){
fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__21302 = function(result,flake){
switch(arguments.length){
case 0:
return G__21302__0.call(this);
case 1:
return G__21302__1.call(this,result);
case 2:
return G__21302__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21302.cljs$core$IFn$_invoke$arity$0 = G__21302__0;
G__21302.cljs$core$IFn$_invoke$arity$1 = G__21302__1;
G__21302.cljs$core$IFn$_invoke$arity$2 = G__21302__2;
return G__21302;
})()
});
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql_resp.recur_select_spec = (function fluree$db$query$fql_resp$recur_select_spec(select_spec,flake){
var recur_subject = fluree.db.flake.o.call(null,flake);
var recur_pred = fluree.db.flake.p.call(null,flake);
var map__21303 = select_spec;
var map__21303__$1 = cljs.core.__destructure_map.call(null,map__21303);
var recur_seen = cljs.core.get.call(null,map__21303__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__21303__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.flake__GT_recur = (function fluree$db$query$fql_resp$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21417){
var state_val_21418 = (state_21417[(1)]);
if((state_val_21418 === (7))){
var inst_21329 = flakes;
var inst_21330 = cljs.core.seq.call(null,inst_21329);
var inst_21331 = cljs.core.first.call(null,inst_21330);
var inst_21332 = cljs.core.next.call(null,inst_21330);
var inst_21333 = cljs.core.PersistentVector.EMPTY;
var inst_21334 = inst_21329;
var inst_21335 = (0);
var inst_21336 = inst_21333;
var state_21417__$1 = (function (){var statearr_21419 = state_21417;
(statearr_21419[(7)] = inst_21336);

(statearr_21419[(8)] = inst_21334);

(statearr_21419[(9)] = inst_21335);

(statearr_21419[(10)] = inst_21331);

(statearr_21419[(11)] = inst_21332);

return statearr_21419;
})();
var statearr_21420_21486 = state_21417__$1;
(statearr_21420_21486[(2)] = null);

(statearr_21420_21486[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (20))){
var state_21417__$1 = state_21417;
var statearr_21421_21487 = state_21417__$1;
(statearr_21421_21487[(2)] = results);

(statearr_21421_21487[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (27))){
var state_21417__$1 = state_21417;
var statearr_21422_21488 = state_21417__$1;
(statearr_21422_21488[(2)] = null);

(statearr_21422_21488[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (1))){
var state_21417__$1 = state_21417;
var statearr_21423_21489 = state_21417__$1;
(statearr_21423_21489[(2)] = null);

(statearr_21423_21489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (24))){
var state_21417__$1 = state_21417;
var statearr_21424_21490 = state_21417__$1;
(statearr_21424_21490[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (39))){
var inst_21398 = (state_21417[(12)]);
var inst_21343 = (state_21417[(13)]);
var inst_21336 = (state_21417[(7)]);
var inst_21401 = (state_21417[(2)]);
var inst_21402 = fluree.db.util.async.throw_err.call(null,inst_21401);
var inst_21403 = cljs.core.conj.call(null,inst_21336,inst_21402);
var inst_21334 = inst_21343;
var inst_21335 = inst_21398;
var inst_21336__$1 = inst_21403;
var state_21417__$1 = (function (){var statearr_21426 = state_21417;
(statearr_21426[(7)] = inst_21336__$1);

(statearr_21426[(8)] = inst_21334);

(statearr_21426[(9)] = inst_21335);

return statearr_21426;
})();
var statearr_21427_21491 = state_21417__$1;
(statearr_21427_21491[(2)] = null);

(statearr_21427_21491[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (4))){
var inst_21304 = (state_21417[(2)]);
var state_21417__$1 = state_21417;
var statearr_21428_21492 = state_21417__$1;
(statearr_21428_21492[(2)] = inst_21304);

(statearr_21428_21492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (15))){
var inst_21317 = (state_21417[(14)]);
var state_21417__$1 = state_21417;
var statearr_21429_21493 = state_21417__$1;
(statearr_21429_21493[(2)] = inst_21317);

(statearr_21429_21493[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (21))){
var inst_21313 = (state_21417[(15)]);
var state_21417__$1 = state_21417;
if(cljs.core.truth_(inst_21313)){
var statearr_21430_21494 = state_21417__$1;
(statearr_21430_21494[(1)] = (23));

} else {
var statearr_21431_21495 = state_21417__$1;
(statearr_21431_21495[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (31))){
var inst_21381 = (state_21417[(16)]);
var state_21417__$1 = state_21417;
var statearr_21432_21496 = state_21417__$1;
(statearr_21432_21496[(2)] = inst_21381);

(statearr_21432_21496[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (32))){
var inst_21373 = (state_21417[(17)]);
var inst_21387 = (state_21417[(2)]);
var state_21417__$1 = (function (){var statearr_21433 = state_21417;
(statearr_21433[(18)] = inst_21387);

return statearr_21433;
})();
if(cljs.core.truth_(inst_21373)){
var statearr_21434_21497 = state_21417__$1;
(statearr_21434_21497[(1)] = (33));

} else {
var statearr_21435_21498 = state_21417__$1;
(statearr_21435_21498[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (33))){
var inst_21373 = (state_21417[(17)]);
var state_21417__$1 = state_21417;
var statearr_21436_21499 = state_21417__$1;
(statearr_21436_21499[(2)] = inst_21373);

(statearr_21436_21499[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (13))){
var inst_21353 = (state_21417[(2)]);
var state_21417__$1 = state_21417;
if(cljs.core.truth_(inst_21353)){
var statearr_21438_21500 = state_21417__$1;
(statearr_21438_21500[(1)] = (17));

} else {
var statearr_21439_21501 = state_21417__$1;
(statearr_21439_21501[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (22))){
var inst_21370 = (state_21417[(2)]);
var state_21417__$1 = state_21417;
var statearr_21440_21502 = state_21417__$1;
(statearr_21440_21502[(2)] = inst_21370);

(statearr_21440_21502[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (36))){
var inst_21343 = (state_21417[(13)]);
var inst_21336 = (state_21417[(7)]);
var inst_21335 = (state_21417[(9)]);
var inst_21395 = (inst_21335 + (1));
var tmp21437 = inst_21336;
var inst_21334 = inst_21343;
var inst_21335__$1 = inst_21395;
var inst_21336__$1 = tmp21437;
var state_21417__$1 = (function (){var statearr_21441 = state_21417;
(statearr_21441[(7)] = inst_21336__$1);

(statearr_21441[(8)] = inst_21334);

(statearr_21441[(9)] = inst_21335__$1);

return statearr_21441;
})();
var statearr_21442_21503 = state_21417__$1;
(statearr_21442_21503[(2)] = null);

(statearr_21442_21503[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (29))){
var inst_21380 = (state_21417[(2)]);
var inst_21381 = fluree.db.util.async.throw_err.call(null,inst_21380);
var state_21417__$1 = (function (){var statearr_21443 = state_21417;
(statearr_21443[(16)] = inst_21381);

return statearr_21443;
})();
if(cljs.core.truth_(fuel)){
var statearr_21444_21504 = state_21417__$1;
(statearr_21444_21504[(1)] = (30));

} else {
var statearr_21445_21505 = state_21417__$1;
(statearr_21445_21505[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (6))){
var state_21417__$1 = state_21417;
var statearr_21446_21506 = state_21417__$1;
(statearr_21446_21506[(2)] = results);

(statearr_21446_21506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (28))){
var inst_21366 = (state_21417[(2)]);
var state_21417__$1 = state_21417;
var statearr_21447_21507 = state_21417__$1;
(statearr_21447_21507[(2)] = inst_21366);

(statearr_21447_21507[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (25))){
var inst_21368 = (state_21417[(2)]);
var state_21417__$1 = state_21417;
var statearr_21448_21508 = state_21417__$1;
(statearr_21448_21508[(2)] = inst_21368);

(statearr_21448_21508[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (34))){
var inst_21387 = (state_21417[(18)]);
var inst_21390 = cljs.core.empty_QMARK_.call(null,inst_21387);
var state_21417__$1 = state_21417;
var statearr_21449_21509 = state_21417__$1;
(statearr_21449_21509[(2)] = inst_21390);

(statearr_21449_21509[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (17))){
var inst_21336 = (state_21417[(7)]);
var inst_21355 = cljs.core.empty_QMARK_.call(null,inst_21336);
var state_21417__$1 = state_21417;
if(inst_21355){
var statearr_21450_21510 = state_21417__$1;
(statearr_21450_21510[(1)] = (20));

} else {
var statearr_21451_21511 = state_21417__$1;
(statearr_21451_21511[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (3))){
var inst_21415 = (state_21417[(2)]);
var state_21417__$1 = state_21417;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21417__$1,inst_21415);
} else {
if((state_val_21418 === (12))){
var inst_21317 = (state_21417[(14)]);
var state_21417__$1 = state_21417;
if(cljs.core.truth_(inst_21317)){
var statearr_21452_21512 = state_21417__$1;
(statearr_21452_21512[(1)] = (14));

} else {
var statearr_21453_21513 = state_21417__$1;
(statearr_21453_21513[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (2))){
var _ = (function (){var statearr_21454 = state_21417;
(statearr_21454[(4)] = cljs.core.cons.call(null,(5),(state_21417[(4)])));

return statearr_21454;
})();
var inst_21311 = select_spec;
var inst_21312 = cljs.core.__destructure_map.call(null,inst_21311);
var inst_21313 = cljs.core.get.call(null,inst_21312,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_21314 = cljs.core.get.call(null,inst_21312,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_21315 = cljs.core.get.call(null,inst_21312,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_21316 = cljs.core.get.call(null,inst_21312,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_21317 = cljs.core.get.call(null,inst_21312,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21318 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_21319 = (inst_21316 > inst_21318);
var state_21417__$1 = (function (){var statearr_21455 = state_21417;
(statearr_21455[(19)] = inst_21315);

(statearr_21455[(15)] = inst_21313);

(statearr_21455[(20)] = inst_21314);

(statearr_21455[(14)] = inst_21317);

return statearr_21455;
})();
if(cljs.core.truth_(inst_21319)){
var statearr_21456_21514 = state_21417__$1;
(statearr_21456_21514[(1)] = (6));

} else {
var statearr_21457_21515 = state_21417__$1;
(statearr_21457_21515[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (23))){
var inst_21314 = (state_21417[(20)]);
var inst_21336 = (state_21417[(7)]);
var inst_21359 = cljs.core.assoc.call(null,results,inst_21314,inst_21336);
var state_21417__$1 = state_21417;
var statearr_21458_21516 = state_21417__$1;
(statearr_21458_21516[(2)] = inst_21359);

(statearr_21458_21516[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (35))){
var inst_21342 = (state_21417[(21)]);
var inst_21392 = (state_21417[(2)]);
var inst_21393 = fluree.db.query.fql_resp.recur_select_spec.call(null,select_spec,inst_21342);
var state_21417__$1 = (function (){var statearr_21459 = state_21417;
(statearr_21459[(22)] = inst_21393);

return statearr_21459;
})();
if(cljs.core.truth_(inst_21392)){
var statearr_21460_21517 = state_21417__$1;
(statearr_21460_21517[(1)] = (36));

} else {
var statearr_21461_21518 = state_21417__$1;
(statearr_21461_21518[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (19))){
var inst_21408 = (state_21417[(2)]);
var state_21417__$1 = state_21417;
var statearr_21462_21519 = state_21417__$1;
(statearr_21462_21519[(2)] = inst_21408);

(statearr_21462_21519[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (11))){
var inst_21344 = (state_21417[(23)]);
var state_21417__$1 = state_21417;
var statearr_21464_21520 = state_21417__$1;
(statearr_21464_21520[(2)] = inst_21344);

(statearr_21464_21520[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (9))){
var inst_21334 = (state_21417[(8)]);
var inst_21342 = (state_21417[(21)]);
var inst_21344 = (state_21417[(23)]);
var inst_21341 = cljs.core.seq.call(null,inst_21334);
var inst_21342__$1 = cljs.core.first.call(null,inst_21341);
var inst_21343 = cljs.core.next.call(null,inst_21341);
var inst_21344__$1 = cljs.core.not.call(null,inst_21342__$1);
var state_21417__$1 = (function (){var statearr_21465 = state_21417;
(statearr_21465[(13)] = inst_21343);

(statearr_21465[(21)] = inst_21342__$1);

(statearr_21465[(23)] = inst_21344__$1);

return statearr_21465;
})();
if(inst_21344__$1){
var statearr_21466_21521 = state_21417__$1;
(statearr_21466_21521[(1)] = (11));

} else {
var statearr_21467_21522 = state_21417__$1;
(statearr_21467_21522[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (5))){
var _ = (function (){var statearr_21468 = state_21417;
(statearr_21468[(4)] = cljs.core.rest.call(null,(state_21417[(4)])));

return statearr_21468;
})();
var state_21417__$1 = state_21417;
var ex21463 = (state_21417__$1[(2)]);
var statearr_21469_21523 = state_21417__$1;
(statearr_21469_21523[(5)] = ex21463);


if((ex21463 instanceof Error)){
var statearr_21470_21524 = state_21417__$1;
(statearr_21470_21524[(1)] = (4));

(statearr_21470_21524[(5)] = null);

} else {
throw ex21463;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (14))){
var inst_21317 = (state_21417[(14)]);
var inst_21335 = (state_21417[(9)]);
var inst_21348 = (inst_21335 < inst_21317);
var state_21417__$1 = state_21417;
var statearr_21471_21525 = state_21417__$1;
(statearr_21471_21525[(2)] = inst_21348);

(statearr_21471_21525[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (26))){
var inst_21314 = (state_21417[(20)]);
var inst_21336 = (state_21417[(7)]);
var inst_21362 = cljs.core.first.call(null,inst_21336);
var inst_21363 = cljs.core.assoc.call(null,results,inst_21314,inst_21362);
var state_21417__$1 = state_21417;
var statearr_21472_21526 = state_21417__$1;
(statearr_21472_21526[(2)] = inst_21363);

(statearr_21472_21526[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (16))){
var inst_21351 = (state_21417[(2)]);
var state_21417__$1 = state_21417;
var statearr_21473_21527 = state_21417__$1;
(statearr_21473_21527[(2)] = inst_21351);

(statearr_21473_21527[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (38))){
var inst_21406 = (state_21417[(2)]);
var state_21417__$1 = state_21417;
var statearr_21474_21528 = state_21417__$1;
(statearr_21474_21528[(2)] = inst_21406);

(statearr_21474_21528[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (30))){
var inst_21381 = (state_21417[(16)]);
var inst_21383 = fluree.db.query.fql_resp.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_21384 = cljs.core.sequence.call(null,inst_21383,inst_21381);
var state_21417__$1 = state_21417;
var statearr_21475_21529 = state_21417__$1;
(statearr_21475_21529[(2)] = inst_21384);

(statearr_21475_21529[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (10))){
var inst_21410 = (state_21417[(2)]);
var state_21417__$1 = state_21417;
var statearr_21476_21530 = state_21417__$1;
(statearr_21476_21530[(2)] = inst_21410);

(statearr_21476_21530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21418 === (18))){
var inst_21315 = (state_21417[(19)]);
var inst_21342 = (state_21417[(21)]);
var inst_21372 = fluree.db.flake.o.call(null,inst_21342);
var inst_21373 = cljs.core.contains_QMARK_.call(null,inst_21315,inst_21372);
var inst_21375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21376 = [inst_21372];
var inst_21377 = (new cljs.core.PersistentVector(null,1,(5),inst_21375,inst_21376,null));
var inst_21378 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21377);
var state_21417__$1 = (function (){var statearr_21477 = state_21417;
(statearr_21477[(17)] = inst_21373);

return statearr_21477;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21417__$1,(29),inst_21378);
} else {
if((state_val_21418 === (37))){
var inst_21335 = (state_21417[(9)]);
var inst_21393 = (state_21417[(22)]);
var inst_21387 = (state_21417[(18)]);
var inst_21398 = (inst_21335 + (1));
var inst_21399 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_21393,inst_21387);
var state_21417__$1 = (function (){var statearr_21478 = state_21417;
(statearr_21478[(12)] = inst_21398);

return statearr_21478;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21417__$1,(39),inst_21399);
} else {
if((state_val_21418 === (8))){
var inst_21412 = (state_21417[(2)]);
var _ = (function (){var statearr_21479 = state_21417;
(statearr_21479[(4)] = cljs.core.rest.call(null,(state_21417[(4)])));

return statearr_21479;
})();
var state_21417__$1 = state_21417;
var statearr_21480_21531 = state_21417__$1;
(statearr_21480_21531[(2)] = inst_21412);

(statearr_21480_21531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0 = (function (){
var statearr_21481 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21481[(0)] = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__);

(statearr_21481[(1)] = (1));

return statearr_21481;
});
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1 = (function (state_21417){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21482){var ex__2749__auto__ = e21482;
var statearr_21483_21532 = state_21417;
(statearr_21483_21532[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21417[(4)]))){
var statearr_21484_21533 = state_21417;
(statearr_21484_21533[(1)] = cljs.core.first.call(null,(state_21417[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21534 = state_21417;
state_21417 = G__21534;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__ = function(state_21417){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1.call(this,state_21417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21485 = f__2769__auto__.call(null);
(statearr_21485[(6)] = c__2768__auto__);

return statearr_21485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql_resp.wildcard_pred_spec = (function fluree$db$query$fql_resp$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4253__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.add_pred = (function fluree$db$query$fql_resp$add_pred(var_args){
var G__21538 = arguments.length;
switch (G__21538) {
case 9:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21977){
var state_val_21978 = (state_21977[(1)]);
if((state_val_21978 === (121))){
var inst_21900 = (state_21977[(2)]);
var inst_21901 = fluree.db.util.async.throw_err.call(null,inst_21900);
var inst_21902 = cljs.core.seq.call(null,inst_21901);
var state_21977__$1 = state_21977;
if(inst_21902){
var statearr_21979_22193 = state_21977__$1;
(statearr_21979_22193[(1)] = (122));

} else {
var statearr_21980_22194 = state_21977__$1;
(statearr_21980_22194[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (65))){
var inst_21693 = (state_21977[(7)]);
var inst_21692 = (state_21977[(2)]);
var inst_21693__$1 = fluree.db.util.async.throw_err.call(null,inst_21692);
var inst_21694 = cljs.core.seq.call(null,inst_21693__$1);
var state_21977__$1 = (function (){var statearr_21981 = state_21977;
(statearr_21981[(7)] = inst_21693__$1);

return statearr_21981;
})();
if(inst_21694){
var statearr_21982_22195 = state_21977__$1;
(statearr_21982_22195[(1)] = (66));

} else {
var statearr_21983_22196 = state_21977__$1;
(statearr_21983_22196[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (70))){
var inst_21693 = (state_21977[(7)]);
var inst_21704 = cljs.core.count.call(null,inst_21693);
var inst_21705 = fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_21704);
var state_21977__$1 = state_21977;
var statearr_21984_22197 = state_21977__$1;
(statearr_21984_22197[(2)] = inst_21705);

(statearr_21984_22197[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (62))){
var inst_21683 = (state_21977[(8)]);
var inst_21686 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21687 = fluree.db.flake.o.call(null,inst_21683);
var inst_21688 = [inst_21687];
var inst_21689 = (new cljs.core.PersistentVector(null,1,(5),inst_21686,inst_21688,null));
var inst_21690 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21689);
var state_21977__$1 = state_21977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21977__$1,(65),inst_21690);
} else {
if((state_val_21978 === (74))){
var inst_21677 = (state_21977[(9)]);
var state_21977__$1 = state_21977;
var statearr_21985_22198 = state_21977__$1;
(statearr_21985_22198[(2)] = inst_21677);

(statearr_21985_22198[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (110))){
var inst_21862 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_21863 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_21862);
var inst_21864 = inst_21863 === true;
var state_21977__$1 = state_21977;
if(cljs.core.truth_(inst_21864)){
var statearr_21986_22199 = state_21977__$1;
(statearr_21986_22199[(1)] = (113));

} else {
var statearr_21987_22200 = state_21977__$1;
(statearr_21987_22200[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (130))){
var inst_21972 = (state_21977[(2)]);
var _ = (function (){var statearr_21988 = state_21977;
(statearr_21988[(4)] = cljs.core.rest.call(null,(state_21977[(4)])));

return statearr_21988;
})();
var state_21977__$1 = state_21977;
var statearr_21989_22201 = state_21977__$1;
(statearr_21989_22201[(2)] = inst_21972);

(statearr_21989_22201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (128))){
var inst_21947 = (state_21977[(10)]);
var inst_21950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21951 = [acc,inst_21947];
var inst_21952 = (new cljs.core.PersistentVector(null,2,(5),inst_21950,inst_21951,null));
var state_21977__$1 = state_21977;
var statearr_21990_22202 = state_21977__$1;
(statearr_21990_22202[(2)] = inst_21952);

(statearr_21990_22202[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (7))){
var inst_21550 = (state_21977[(11)]);
var state_21977__$1 = state_21977;
var statearr_21991_22203 = state_21977__$1;
(statearr_21991_22203[(2)] = inst_21550);

(statearr_21991_22203[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (59))){
var inst_21941 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_21992_22204 = state_21977__$1;
(statearr_21992_22204[(2)] = inst_21941);

(statearr_21992_22204[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (86))){
var inst_21771 = (state_21977[(12)]);
var inst_21771__$1 = (state_21977[(2)]);
var state_21977__$1 = (function (){var statearr_21993 = state_21977;
(statearr_21993[(12)] = inst_21771__$1);

return statearr_21993;
})();
if(cljs.core.truth_(inst_21771__$1)){
var statearr_21994_22205 = state_21977__$1;
(statearr_21994_22205[(1)] = (88));

} else {
var statearr_21995_22206 = state_21977__$1;
(statearr_21995_22206[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (20))){
var inst_21592 = (state_21977[(13)]);
var inst_21579 = (state_21977[(14)]);
var inst_21591 = (state_21977[(15)]);
var inst_21590 = (state_21977[(2)]);
var inst_21591__$1 = cljs.core.__destructure_map.call(null,inst_21579);
var inst_21592__$1 = cljs.core.get.call(null,inst_21591__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_21593 = cljs.core.get.call(null,inst_21591__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_21594 = cljs.core.get.call(null,inst_21591__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21595 = cljs.core.get.call(null,inst_21591__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_21596 = cljs.core.get.call(null,inst_21591__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21597 = cljs.core.get.call(null,inst_21591__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_21977__$1 = (function (){var statearr_21996 = state_21977;
(statearr_21996[(16)] = inst_21590);

(statearr_21996[(17)] = inst_21597);

(statearr_21996[(13)] = inst_21592__$1);

(statearr_21996[(18)] = inst_21596);

(statearr_21996[(19)] = inst_21595);

(statearr_21996[(20)] = inst_21593);

(statearr_21996[(21)] = inst_21594);

(statearr_21996[(15)] = inst_21591__$1);

return statearr_21996;
})();
if(cljs.core.truth_(inst_21592__$1)){
var statearr_21997_22207 = state_21977__$1;
(statearr_21997_22207[(1)] = (24));

} else {
var statearr_21998_22208 = state_21977__$1;
(statearr_21998_22208[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (72))){
var inst_21702 = (state_21977[(22)]);
var inst_21708 = (state_21977[(2)]);
var inst_21709 = cljs.core.seq.call(null,inst_21702);
var state_21977__$1 = (function (){var statearr_21999 = state_21977;
(statearr_21999[(23)] = inst_21708);

return statearr_21999;
})();
if(inst_21709){
var statearr_22000_22209 = state_21977__$1;
(statearr_22000_22209[(1)] = (73));

} else {
var statearr_22001_22210 = state_21977__$1;
(statearr_22001_22210[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (58))){
var inst_21579 = (state_21977[(14)]);
var inst_21724 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_21579);
var state_21977__$1 = state_21977;
if(cljs.core.truth_(inst_21724)){
var statearr_22002_22211 = state_21977__$1;
(statearr_22002_22211[(1)] = (76));

} else {
var statearr_22003_22212 = state_21977__$1;
(statearr_22003_22212[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (60))){
var inst_21683 = (state_21977[(8)]);
var inst_21676 = (state_21977[(24)]);
var inst_21682 = cljs.core.seq.call(null,inst_21676);
var inst_21683__$1 = cljs.core.first.call(null,inst_21682);
var inst_21684 = cljs.core.next.call(null,inst_21682);
var state_21977__$1 = (function (){var statearr_22004 = state_21977;
(statearr_22004[(8)] = inst_21683__$1);

(statearr_22004[(25)] = inst_21684);

return statearr_22004;
})();
if(cljs.core.truth_(inst_21683__$1)){
var statearr_22005_22213 = state_21977__$1;
(statearr_22005_22213[(1)] = (62));

} else {
var statearr_22006_22214 = state_21977__$1;
(statearr_22006_22214[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (27))){
var inst_21600 = (state_21977[(26)]);
var inst_21596 = (state_21977[(18)]);
var inst_21600__$1 = cljs.core.not_EQ_.call(null,(0),inst_21596);
var state_21977__$1 = (function (){var statearr_22007 = state_21977;
(statearr_22007[(26)] = inst_21600__$1);

return statearr_22007;
})();
if(inst_21600__$1){
var statearr_22008_22215 = state_21977__$1;
(statearr_22008_22215[(1)] = (30));

} else {
var statearr_22009_22216 = state_21977__$1;
(statearr_22009_22216[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (1))){
var state_21977__$1 = state_21977;
var statearr_22010_22217 = state_21977__$1;
(statearr_22010_22217[(2)] = null);

(statearr_22010_22217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (69))){
var inst_21698 = (state_21977[(2)]);
var inst_21699 = fluree.db.util.async.throw_err.call(null,inst_21698);
var state_21977__$1 = state_21977;
var statearr_22011_22218 = state_21977__$1;
(statearr_22011_22218[(2)] = inst_21699);

(statearr_22011_22218[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (101))){
var inst_21855 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22012_22219 = state_21977__$1;
(statearr_22012_22219[(2)] = inst_21855);

(statearr_22012_22219[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (24))){
var inst_21596 = (state_21977[(18)]);
var state_21977__$1 = state_21977;
if(cljs.core.truth_(inst_21596)){
var statearr_22013_22220 = state_21977__$1;
(statearr_22013_22220[(1)] = (27));

} else {
var statearr_22014_22221 = state_21977__$1;
(statearr_22014_22221[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (102))){
var inst_21827 = (state_21977[(27)]);
var inst_21826 = (state_21977[(2)]);
var inst_21827__$1 = fluree.db.util.async.throw_err.call(null,inst_21826);
var inst_21828 = cljs.core.empty_QMARK_.call(null,inst_21827__$1);
var state_21977__$1 = (function (){var statearr_22015 = state_21977;
(statearr_22015[(27)] = inst_21827__$1);

return statearr_22015;
})();
if(inst_21828){
var statearr_22016_22222 = state_21977__$1;
(statearr_22016_22222[(1)] = (103));

} else {
var statearr_22017_22223 = state_21977__$1;
(statearr_22017_22223[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (135))){
var state_21977__$1 = state_21977;
var statearr_22018_22224 = state_21977__$1;
(statearr_22018_22224[(2)] = null);

(statearr_22018_22224[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (55))){
var inst_21579 = (state_21977[(14)]);
var inst_21652 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_21579);
var state_21977__$1 = state_21977;
var statearr_22019_22225 = state_21977__$1;
(statearr_22019_22225[(2)] = inst_21652);

(statearr_22019_22225[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (85))){
var inst_21746 = (state_21977[(28)]);
var inst_21579 = (state_21977[(14)]);
var inst_21758 = fluree.db.flake.o.call(null,inst_21746);
var inst_21759 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21579);
var inst_21760 = fluree.db.dbproto._tag.call(null,db,inst_21758,inst_21759);
var state_21977__$1 = state_21977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21977__$1,(87),inst_21760);
} else {
if((state_val_21978 === (39))){
var inst_21627 = (state_21977[(29)]);
var inst_21595 = (state_21977[(19)]);
var inst_21627__$1 = cljs.core.not.call(null,inst_21595);
var state_21977__$1 = (function (){var statearr_22020 = state_21977;
(statearr_22020[(29)] = inst_21627__$1);

return statearr_22020;
})();
if(inst_21627__$1){
var statearr_22021_22226 = state_21977__$1;
(statearr_22021_22226[(1)] = (42));

} else {
var statearr_22022_22227 = state_21977__$1;
(statearr_22022_22227[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (88))){
var inst_21771 = (state_21977[(12)]);
var inst_21740 = (state_21977[(30)]);
var inst_21773 = cljs.core.conj.call(null,inst_21740,inst_21771);
var state_21977__$1 = state_21977;
var statearr_22023_22228 = state_21977__$1;
(statearr_22023_22228[(2)] = inst_21773);

(statearr_22023_22228[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (46))){
var inst_21594 = (state_21977[(21)]);
var state_21977__$1 = state_21977;
var statearr_22024_22229 = state_21977__$1;
(statearr_22024_22229[(2)] = inst_21594);

(statearr_22024_22229[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (4))){
var inst_21539 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22025_22230 = state_21977__$1;
(statearr_22025_22230[(2)] = inst_21539);

(statearr_22025_22230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (77))){
var inst_21786 = (state_21977[(31)]);
var inst_21786__$1 = componentFollow_QMARK_;
var state_21977__$1 = (function (){var statearr_22026 = state_21977;
(statearr_22026[(31)] = inst_21786__$1);

return statearr_22026;
})();
if(cljs.core.truth_(inst_21786__$1)){
var statearr_22027_22231 = state_21977__$1;
(statearr_22027_22231[(1)] = (91));

} else {
var statearr_22028_22232 = state_21977__$1;
(statearr_22028_22232[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (106))){
var inst_21807 = (state_21977[(32)]);
var inst_21841 = (state_21977[(2)]);
var inst_21842 = fluree.db.util.async.throw_err.call(null,inst_21841);
var inst_21843 = cljs.core.conj.call(null,inst_21807,inst_21842);
var state_21977__$1 = state_21977;
var statearr_22029_22233 = state_21977__$1;
(statearr_22029_22233[(2)] = inst_21843);

(statearr_22029_22233[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (119))){
var inst_21885 = (state_21977[(33)]);
var inst_21915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21916 = [inst_21885,offset_map];
var inst_21917 = (new cljs.core.PersistentVector(null,2,(5),inst_21915,inst_21916,null));
var state_21977__$1 = state_21977;
var statearr_22030_22234 = state_21977__$1;
(statearr_22030_22234[(2)] = inst_21917);

(statearr_22030_22234[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (95))){
var inst_21593 = (state_21977[(20)]);
var state_21977__$1 = state_21977;
if(cljs.core.truth_(inst_21593)){
var statearr_22031_22235 = state_21977__$1;
(statearr_22031_22235[(1)] = (110));

} else {
var statearr_22032_22236 = state_21977__$1;
(statearr_22032_22236[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (54))){
var inst_21649 = (state_21977[(34)]);
var state_21977__$1 = state_21977;
var statearr_22033_22237 = state_21977__$1;
(statearr_22033_22237[(2)] = inst_21649);

(statearr_22033_22237[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (92))){
var inst_21786 = (state_21977[(31)]);
var state_21977__$1 = state_21977;
var statearr_22034_22238 = state_21977__$1;
(statearr_22034_22238[(2)] = inst_21786);

(statearr_22034_22238[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (104))){
var inst_21827 = (state_21977[(27)]);
var inst_21549 = (state_21977[(35)]);
var inst_21836 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_21837 = [true,inst_21549];
var inst_21838 = cljs.core.PersistentHashMap.fromArrays(inst_21836,inst_21837);
var inst_21839 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_21838,inst_21827);
var state_21977__$1 = state_21977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21977__$1,(106),inst_21839);
} else {
if((state_val_21978 === (15))){
var inst_21572 = (state_21977[(36)]);
var inst_21549 = (state_21977[(35)]);
var inst_21576 = cljs.core.assoc.call(null,inst_21572,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_21549);
var state_21977__$1 = state_21977;
var statearr_22035_22239 = state_21977__$1;
(statearr_22035_22239[(2)] = inst_21576);

(statearr_22035_22239[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (48))){
var inst_21643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21644 = [null,offset_map];
var inst_21645 = (new cljs.core.PersistentVector(null,2,(5),inst_21643,inst_21644,null));
var state_21977__$1 = state_21977;
var statearr_22036_22240 = state_21977__$1;
(statearr_22036_22240[(2)] = inst_21645);

(statearr_22036_22240[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (50))){
var inst_21943 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22037_22241 = state_21977__$1;
(statearr_22037_22241[(2)] = inst_21943);

(statearr_22037_22241[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (116))){
var inst_21891 = (state_21977[(37)]);
var inst_21884 = (state_21977[(38)]);
var inst_21890 = cljs.core.seq.call(null,inst_21884);
var inst_21891__$1 = cljs.core.first.call(null,inst_21890);
var inst_21892 = cljs.core.next.call(null,inst_21890);
var state_21977__$1 = (function (){var statearr_22038 = state_21977;
(statearr_22038[(37)] = inst_21891__$1);

(statearr_22038[(39)] = inst_21892);

return statearr_22038;
})();
if(cljs.core.truth_(inst_21891__$1)){
var statearr_22039_22242 = state_21977__$1;
(statearr_22039_22242[(1)] = (118));

} else {
var statearr_22040_22243 = state_21977__$1;
(statearr_22040_22243[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (75))){
var inst_21684 = (state_21977[(25)]);
var inst_21714 = (state_21977[(2)]);
var inst_21676 = inst_21684;
var inst_21677 = inst_21714;
var state_21977__$1 = (function (){var statearr_22041 = state_21977;
(statearr_22041[(24)] = inst_21676);

(statearr_22041[(9)] = inst_21677);

return statearr_22041;
})();
var statearr_22042_22244 = state_21977__$1;
(statearr_22042_22244[(2)] = null);

(statearr_22042_22244[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (99))){
var inst_21813 = (state_21977[(40)]);
var inst_21579 = (state_21977[(14)]);
var inst_21816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21817 = fluree.db.flake.o.call(null,inst_21813);
var inst_21818 = [inst_21817];
var inst_21819 = (new cljs.core.PersistentVector(null,1,(5),inst_21816,inst_21818,null));
var inst_21820 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_21821 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_21579);
var inst_21822 = [inst_21821];
var inst_21823 = cljs.core.PersistentHashMap.fromArrays(inst_21820,inst_21822);
var inst_21824 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21819,inst_21823);
var state_21977__$1 = state_21977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21977__$1,(102),inst_21824);
} else {
if((state_val_21978 === (21))){
var inst_21583 = (state_21977[(41)]);
var state_21977__$1 = state_21977;
var statearr_22043_22245 = state_21977__$1;
(statearr_22043_22245[(2)] = inst_21583);

(statearr_22043_22245[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (31))){
var inst_21600 = (state_21977[(26)]);
var state_21977__$1 = state_21977;
var statearr_22044_22246 = state_21977__$1;
(statearr_22044_22246[(2)] = inst_21600);

(statearr_22044_22246[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (113))){
var inst_21590 = (state_21977[(16)]);
var inst_21597 = (state_21977[(17)]);
var inst_21592 = (state_21977[(13)]);
var inst_21596 = (state_21977[(18)]);
var inst_21595 = (state_21977[(19)]);
var inst_21564 = (state_21977[(42)]);
var inst_21593 = (state_21977[(20)]);
var inst_21579 = (state_21977[(14)]);
var inst_21594 = (state_21977[(21)]);
var inst_21591 = (state_21977[(15)]);
var inst_21549 = (state_21977[(35)]);
var inst_21866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21867 = (function (){var p = inst_21597;
var pred_spec__$1 = inst_21564;
var orderBy = inst_21595;
var multi_QMARK_ = inst_21592;
var limit = inst_21594;
var offset = inst_21596;
var k = inst_21590;
var compact_QMARK_ = inst_21549;
var pred_spec_SINGLEQUOTE_ = inst_21579;
var map__21545 = inst_21591;
var ref_QMARK_ = inst_21593;
return (function (p1__21535_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[fluree.db.flake.o.call(null,p1__21535_SHARP_)]);
});
})();
var inst_21868 = cljs.core.mapv.call(null,inst_21867,flakes);
var inst_21869 = [inst_21868,offset_map];
var inst_21870 = (new cljs.core.PersistentVector(null,2,(5),inst_21866,inst_21869,null));
var state_21977__$1 = state_21977;
var statearr_22045_22247 = state_21977__$1;
(statearr_22045_22247[(2)] = inst_21870);

(statearr_22045_22247[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (32))){
var inst_21606 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22046_22248 = state_21977__$1;
(statearr_22046_22248[(2)] = inst_21606);

(statearr_22046_22248[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (136))){
var inst_21968 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22047_22249 = state_21977__$1;
(statearr_22047_22249[(2)] = inst_21968);

(statearr_22047_22249[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (40))){
var inst_21592 = (state_21977[(13)]);
var state_21977__$1 = state_21977;
var statearr_22048_22250 = state_21977__$1;
(statearr_22048_22250[(2)] = inst_21592);

(statearr_22048_22250[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (129))){
var inst_21592 = (state_21977[(13)]);
var state_21977__$1 = state_21977;
if(cljs.core.truth_(inst_21592)){
var statearr_22049_22251 = state_21977__$1;
(statearr_22049_22251[(1)] = (131));

} else {
var statearr_22050_22252 = state_21977__$1;
(statearr_22050_22252[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (91))){
var inst_21579 = (state_21977[(14)]);
var inst_21788 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_21579);
var state_21977__$1 = state_21977;
var statearr_22051_22253 = state_21977__$1;
(statearr_22051_22253[(2)] = inst_21788);

(statearr_22051_22253[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (117))){
var inst_21921 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22052_22254 = state_21977__$1;
(statearr_22052_22254[(2)] = inst_21921);

(statearr_22052_22254[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (108))){
var state_21977__$1 = state_21977;
var statearr_22053_22255 = state_21977__$1;
(statearr_22053_22255[(2)] = null);

(statearr_22053_22255[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (56))){
var inst_21654 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22054_22256 = state_21977__$1;
(statearr_22054_22256[(2)] = inst_21654);

(statearr_22054_22256[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (33))){
var inst_21597 = (state_21977[(17)]);
var inst_21614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21615 = cljs.core.get.call(null,offset_map,inst_21597);
var state_21977__$1 = (function (){var statearr_22055 = state_21977;
(statearr_22055[(43)] = inst_21614);

return statearr_22055;
})();
if(cljs.core.truth_(inst_21615)){
var statearr_22056_22257 = state_21977__$1;
(statearr_22056_22257[(1)] = (36));

} else {
var statearr_22057_22258 = state_21977__$1;
(statearr_22057_22258[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (13))){
var inst_21564 = (state_21977[(42)]);
var state_21977__$1 = state_21977;
var statearr_22058_22259 = state_21977__$1;
(statearr_22058_22259[(2)] = inst_21564);

(statearr_22058_22259[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (22))){
var inst_21579 = (state_21977[(14)]);
var inst_21586 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_21579);
var state_21977__$1 = state_21977;
var statearr_22059_22260 = state_21977__$1;
(statearr_22059_22260[(2)] = inst_21586);

(statearr_22059_22260[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (90))){
var inst_21747 = (state_21977[(44)]);
var inst_21776 = (state_21977[(2)]);
var inst_21739 = inst_21747;
var inst_21740 = inst_21776;
var state_21977__$1 = (function (){var statearr_22060 = state_21977;
(statearr_22060[(45)] = inst_21739);

(statearr_22060[(30)] = inst_21740);

return statearr_22060;
})();
var statearr_22061_22261 = state_21977__$1;
(statearr_22061_22261[(2)] = null);

(statearr_22061_22261[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (109))){
var inst_21845 = (state_21977[(46)]);
var inst_21814 = (state_21977[(47)]);
var inst_21851 = (state_21977[(2)]);
var inst_21806 = inst_21814;
var inst_21807 = inst_21845;
var state_21977__$1 = (function (){var statearr_22062 = state_21977;
(statearr_22062[(32)] = inst_21807);

(statearr_22062[(48)] = inst_21851);

(statearr_22062[(49)] = inst_21806);

return statearr_22062;
})();
var statearr_22063_22262 = state_21977__$1;
(statearr_22063_22262[(2)] = null);

(statearr_22063_22262[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (36))){
var inst_21597 = (state_21977[(17)]);
var inst_21617 = cljs.core.update.call(null,offset_map,inst_21597,cljs.core.dec);
var state_21977__$1 = state_21977;
var statearr_22064_22263 = state_21977__$1;
(statearr_22064_22263[(2)] = inst_21617);

(statearr_22064_22263[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (41))){
var inst_21641 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
if(cljs.core.truth_(inst_21641)){
var statearr_22065_22264 = state_21977__$1;
(statearr_22065_22264[(1)] = (48));

} else {
var statearr_22066_22265 = state_21977__$1;
(statearr_22066_22265[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (118))){
var inst_21891 = (state_21977[(37)]);
var inst_21894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21895 = fluree.db.flake.o.call(null,inst_21891);
var inst_21896 = [inst_21895];
var inst_21897 = (new cljs.core.PersistentVector(null,1,(5),inst_21894,inst_21896,null));
var inst_21898 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21897);
var state_21977__$1 = state_21977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21977__$1,(121),inst_21898);
} else {
if((state_val_21978 === (89))){
var inst_21740 = (state_21977[(30)]);
var state_21977__$1 = state_21977;
var statearr_22067_22266 = state_21977__$1;
(statearr_22067_22266[(2)] = inst_21740);

(statearr_22067_22266[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (100))){
var inst_21807 = (state_21977[(32)]);
var state_21977__$1 = state_21977;
var statearr_22068_22267 = state_21977__$1;
(statearr_22068_22267[(2)] = inst_21807);

(statearr_22068_22267[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (131))){
var inst_21590 = (state_21977[(16)]);
var inst_21946 = (state_21977[(50)]);
var inst_21947 = (state_21977[(10)]);
var inst_21955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21956 = cljs.core.assoc.call(null,acc,inst_21590,inst_21946);
var inst_21957 = [inst_21956,inst_21947];
var inst_21958 = (new cljs.core.PersistentVector(null,2,(5),inst_21955,inst_21957,null));
var state_21977__$1 = state_21977;
var statearr_22069_22268 = state_21977__$1;
(statearr_22069_22268[(2)] = inst_21958);

(statearr_22069_22268[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (122))){
var inst_21891 = (state_21977[(37)]);
var inst_21885 = (state_21977[(33)]);
var inst_21892 = (state_21977[(39)]);
var inst_21904 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_21905 = fluree.db.flake.o.call(null,inst_21891);
var inst_21906 = [inst_21905];
var inst_21907 = cljs.core.PersistentHashMap.fromArrays(inst_21904,inst_21906);
var inst_21908 = cljs.core.conj.call(null,inst_21885,inst_21907);
var inst_21884 = inst_21892;
var inst_21885__$1 = inst_21908;
var state_21977__$1 = (function (){var statearr_22070 = state_21977;
(statearr_22070[(33)] = inst_21885__$1);

(statearr_22070[(38)] = inst_21884);

return statearr_22070;
})();
var statearr_22071_22269 = state_21977__$1;
(statearr_22071_22269[(2)] = null);

(statearr_22071_22269[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (43))){
var inst_21627 = (state_21977[(29)]);
var state_21977__$1 = state_21977;
var statearr_22072_22270 = state_21977__$1;
(statearr_22072_22270[(2)] = inst_21627);

(statearr_22072_22270[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (61))){
var inst_21663 = (state_21977[(51)]);
var inst_21720 = (state_21977[(2)]);
var inst_21721 = [inst_21720,offset_map];
var inst_21722 = (new cljs.core.PersistentVector(null,2,(5),inst_21663,inst_21721,null));
var state_21977__$1 = state_21977;
var statearr_22073_22271 = state_21977__$1;
(statearr_22073_22271[(2)] = inst_21722);

(statearr_22073_22271[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (29))){
var inst_21609 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22074_22272 = state_21977__$1;
(statearr_22074_22272[(2)] = inst_21609);

(statearr_22074_22272[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (44))){
var inst_21638 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22075_22273 = state_21977__$1;
(statearr_22075_22273[(2)] = inst_21638);

(statearr_22075_22273[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (93))){
var inst_21791 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
if(cljs.core.truth_(inst_21791)){
var statearr_22076_22274 = state_21977__$1;
(statearr_22076_22274[(1)] = (94));

} else {
var statearr_22077_22275 = state_21977__$1;
(statearr_22077_22275[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (6))){
var inst_21552 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_21553 = (inst_21552 == null);
var state_21977__$1 = state_21977;
var statearr_22078_22276 = state_21977__$1;
(statearr_22078_22276[(2)] = inst_21553);

(statearr_22078_22276[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (111))){
var state_21977__$1 = state_21977;
var statearr_22079_22277 = state_21977__$1;
(statearr_22079_22277[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (28))){
var inst_21596 = (state_21977[(18)]);
var state_21977__$1 = state_21977;
var statearr_22081_22278 = state_21977__$1;
(statearr_22081_22278[(2)] = inst_21596);

(statearr_22081_22278[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (134))){
var inst_21590 = (state_21977[(16)]);
var inst_21946 = (state_21977[(50)]);
var inst_21947 = (state_21977[(10)]);
var inst_21961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21962 = cljs.core.first.call(null,inst_21946);
var inst_21963 = cljs.core.assoc.call(null,acc,inst_21590,inst_21962);
var inst_21964 = [inst_21963,inst_21947];
var inst_21965 = (new cljs.core.PersistentVector(null,2,(5),inst_21961,inst_21964,null));
var state_21977__$1 = state_21977;
var statearr_22082_22279 = state_21977__$1;
(statearr_22082_22279[(2)] = inst_21965);

(statearr_22082_22279[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (64))){
var inst_21718 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22083_22280 = state_21977__$1;
(statearr_22083_22280[(2)] = inst_21718);

(statearr_22083_22280[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (103))){
var inst_21807 = (state_21977[(32)]);
var inst_21813 = (state_21977[(40)]);
var inst_21830 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_21831 = fluree.db.flake.o.call(null,inst_21813);
var inst_21832 = [inst_21831];
var inst_21833 = cljs.core.PersistentHashMap.fromArrays(inst_21830,inst_21832);
var inst_21834 = cljs.core.conj.call(null,inst_21807,inst_21833);
var state_21977__$1 = state_21977;
var statearr_22084_22281 = state_21977__$1;
(statearr_22084_22281[(2)] = inst_21834);

(statearr_22084_22281[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (51))){
var inst_21649 = (state_21977[(34)]);
var inst_21579 = (state_21977[(14)]);
var inst_21649__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_21579);
var state_21977__$1 = (function (){var statearr_22085 = state_21977;
(statearr_22085[(34)] = inst_21649__$1);

return statearr_22085;
})();
if(cljs.core.truth_(inst_21649__$1)){
var statearr_22086_22282 = state_21977__$1;
(statearr_22086_22282[(1)] = (54));

} else {
var statearr_22087_22283 = state_21977__$1;
(statearr_22087_22283[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (25))){
var inst_21592 = (state_21977[(13)]);
var state_21977__$1 = state_21977;
var statearr_22088_22284 = state_21977__$1;
(statearr_22088_22284[(2)] = inst_21592);

(statearr_22088_22284[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (34))){
var inst_21592 = (state_21977[(13)]);
var state_21977__$1 = state_21977;
if(cljs.core.truth_(inst_21592)){
var statearr_22089_22285 = state_21977__$1;
(statearr_22089_22285[(1)] = (39));

} else {
var statearr_22090_22286 = state_21977__$1;
(statearr_22090_22286[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (125))){
var inst_21590 = (state_21977[(16)]);
var inst_21597 = (state_21977[(17)]);
var inst_21592 = (state_21977[(13)]);
var inst_21596 = (state_21977[(18)]);
var inst_21595 = (state_21977[(19)]);
var inst_21564 = (state_21977[(42)]);
var inst_21593 = (state_21977[(20)]);
var inst_21579 = (state_21977[(14)]);
var inst_21594 = (state_21977[(21)]);
var inst_21591 = (state_21977[(15)]);
var inst_21549 = (state_21977[(35)]);
var inst_21926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21927 = (function (){var p = inst_21597;
var pred_spec__$1 = inst_21564;
var orderBy = inst_21595;
var multi_QMARK_ = inst_21592;
var limit = inst_21594;
var offset = inst_21596;
var k = inst_21590;
var compact_QMARK_ = inst_21549;
var pred_spec_SINGLEQUOTE_ = inst_21579;
var map__21545 = inst_21591;
var ref_QMARK_ = inst_21593;
return (function (p1__21536_SHARP_){
return fluree.db.flake.o.call(null,p1__21536_SHARP_);
});
})();
var inst_21928 = cljs.core.mapv.call(null,inst_21927,flakes);
var inst_21929 = [inst_21928,offset_map];
var inst_21930 = (new cljs.core.PersistentVector(null,2,(5),inst_21926,inst_21929,null));
var state_21977__$1 = state_21977;
var statearr_22091_22287 = state_21977__$1;
(statearr_22091_22287[(2)] = inst_21930);

(statearr_22091_22287[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (17))){
var inst_21579 = (state_21977[(14)]);
var inst_21580 = (state_21977[(52)]);
var inst_21579__$1 = (state_21977[(2)]);
var inst_21580__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_21579__$1);
var state_21977__$1 = (function (){var statearr_22092 = state_21977;
(statearr_22092[(14)] = inst_21579__$1);

(statearr_22092[(52)] = inst_21580__$1);

return statearr_22092;
})();
if(cljs.core.truth_(inst_21580__$1)){
var statearr_22093_22288 = state_21977__$1;
(statearr_22093_22288[(1)] = (18));

} else {
var statearr_22094_22289 = state_21977__$1;
(statearr_22094_22289[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (3))){
var inst_21975 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21977__$1,inst_21975);
} else {
if((state_val_21978 === (12))){
var inst_21564 = (state_21977[(42)]);
var inst_21569 = cljs.core.assoc.call(null,inst_21564,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_21977__$1 = state_21977;
var statearr_22095_22290 = state_21977__$1;
(statearr_22095_22290[(2)] = inst_21569);

(statearr_22095_22290[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (2))){
var inst_21550 = (state_21977[(11)]);
var _ = (function (){var statearr_22096 = state_21977;
(statearr_22096[(4)] = cljs.core.cons.call(null,(5),(state_21977[(4)])));

return statearr_22096;
})();
var inst_21549 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_21550__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_21977__$1 = (function (){var statearr_22097 = state_21977;
(statearr_22097[(11)] = inst_21550__$1);

(statearr_22097[(35)] = inst_21549);

return statearr_22097;
})();
if(cljs.core.truth_(inst_21550__$1)){
var statearr_22098_22291 = state_21977__$1;
(statearr_22098_22291[(1)] = (6));

} else {
var statearr_22099_22292 = state_21977__$1;
(statearr_22099_22292[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (66))){
var inst_21693 = (state_21977[(7)]);
var inst_21662 = (state_21977[(53)]);
var inst_21696 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_21662,inst_21693);
var state_21977__$1 = state_21977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21977__$1,(69),inst_21696);
} else {
if((state_val_21978 === (107))){
var inst_21827 = (state_21977[(27)]);
var inst_21847 = cljs.core.count.call(null,inst_21827);
var inst_21848 = fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_21847);
var state_21977__$1 = state_21977;
var statearr_22100_22293 = state_21977__$1;
(statearr_22100_22293[(2)] = inst_21848);

(statearr_22100_22293[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (23))){
var inst_21588 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22101_22294 = state_21977__$1;
(statearr_22101_22294[(2)] = inst_21588);

(statearr_22101_22294[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (47))){
var inst_21635 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22102_22295 = state_21977__$1;
(statearr_22102_22295[(2)] = inst_21635);

(statearr_22102_22295[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (35))){
var inst_21946 = (state_21977[(50)]);
var inst_21945 = (state_21977[(2)]);
var inst_21946__$1 = cljs.core.nth.call(null,inst_21945,(0),null);
var inst_21947 = cljs.core.nth.call(null,inst_21945,(1),null);
var inst_21948 = cljs.core.empty_QMARK_.call(null,inst_21946__$1);
var state_21977__$1 = (function (){var statearr_22103 = state_21977;
(statearr_22103[(50)] = inst_21946__$1);

(statearr_22103[(10)] = inst_21947);

return statearr_22103;
})();
if(inst_21948){
var statearr_22104_22296 = state_21977__$1;
(statearr_22104_22296[(1)] = (128));

} else {
var statearr_22105_22297 = state_21977__$1;
(statearr_22105_22297[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (127))){
var inst_21933 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22106_22298 = state_21977__$1;
(statearr_22106_22298[(2)] = inst_21933);

(statearr_22106_22298[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (82))){
var inst_21740 = (state_21977[(30)]);
var state_21977__$1 = state_21977;
var statearr_22107_22299 = state_21977__$1;
(statearr_22107_22299[(2)] = inst_21740);

(statearr_22107_22299[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (76))){
var inst_21726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21734 = flakes;
var inst_21735 = cljs.core.seq.call(null,inst_21734);
var inst_21736 = cljs.core.first.call(null,inst_21735);
var inst_21737 = cljs.core.next.call(null,inst_21735);
var inst_21738 = cljs.core.PersistentVector.EMPTY;
var inst_21739 = inst_21734;
var inst_21740 = inst_21738;
var state_21977__$1 = (function (){var statearr_22108 = state_21977;
(statearr_22108[(54)] = inst_21726);

(statearr_22108[(45)] = inst_21739);

(statearr_22108[(55)] = inst_21736);

(statearr_22108[(56)] = inst_21737);

(statearr_22108[(30)] = inst_21740);

return statearr_22108;
})();
var statearr_22109_22300 = state_21977__$1;
(statearr_22109_22300[(2)] = null);

(statearr_22109_22300[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (97))){
var inst_21813 = (state_21977[(40)]);
var inst_21806 = (state_21977[(49)]);
var inst_21812 = cljs.core.seq.call(null,inst_21806);
var inst_21813__$1 = cljs.core.first.call(null,inst_21812);
var inst_21814 = cljs.core.next.call(null,inst_21812);
var state_21977__$1 = (function (){var statearr_22110 = state_21977;
(statearr_22110[(40)] = inst_21813__$1);

(statearr_22110[(47)] = inst_21814);

return statearr_22110;
})();
if(cljs.core.truth_(inst_21813__$1)){
var statearr_22111_22301 = state_21977__$1;
(statearr_22111_22301[(1)] = (99));

} else {
var statearr_22112_22302 = state_21977__$1;
(statearr_22112_22302[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (19))){
var inst_21583 = (state_21977[(41)]);
var inst_21579 = (state_21977[(14)]);
var inst_21583__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21579);
var state_21977__$1 = (function (){var statearr_22113 = state_21977;
(statearr_22113[(41)] = inst_21583__$1);

return statearr_22113;
})();
if(cljs.core.truth_(inst_21583__$1)){
var statearr_22114_22303 = state_21977__$1;
(statearr_22114_22303[(1)] = (21));

} else {
var statearr_22115_22304 = state_21977__$1;
(statearr_22115_22304[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (57))){
var inst_21579 = (state_21977[(14)]);
var inst_21659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21660 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_21661 = (new cljs.core.PersistentVector(null,3,(5),inst_21659,inst_21660,null));
var inst_21662 = cljs.core.select_keys.call(null,inst_21579,inst_21661);
var inst_21663 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21671 = flakes;
var inst_21672 = cljs.core.seq.call(null,inst_21671);
var inst_21673 = cljs.core.first.call(null,inst_21672);
var inst_21674 = cljs.core.next.call(null,inst_21672);
var inst_21675 = cljs.core.PersistentVector.EMPTY;
var inst_21676 = inst_21671;
var inst_21677 = inst_21675;
var state_21977__$1 = (function (){var statearr_22116 = state_21977;
(statearr_22116[(24)] = inst_21676);

(statearr_22116[(53)] = inst_21662);

(statearr_22116[(51)] = inst_21663);

(statearr_22116[(57)] = inst_21674);

(statearr_22116[(9)] = inst_21677);

(statearr_22116[(58)] = inst_21673);

return statearr_22116;
})();
var statearr_22117_22305 = state_21977__$1;
(statearr_22117_22305[(2)] = null);

(statearr_22117_22305[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (68))){
var inst_21702 = (state_21977[(2)]);
var state_21977__$1 = (function (){var statearr_22118 = state_21977;
(statearr_22118[(22)] = inst_21702);

return statearr_22118;
})();
if(cljs.core.truth_(fuel)){
var statearr_22119_22306 = state_21977__$1;
(statearr_22119_22306[(1)] = (70));

} else {
var statearr_22120_22307 = state_21977__$1;
(statearr_22120_22307[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (11))){
var inst_21564 = (state_21977[(42)]);
var inst_21564__$1 = (state_21977[(2)]);
var inst_21566 = cljs.core.contains_QMARK_.call(null,inst_21564__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_21567 = (!(inst_21566));
var state_21977__$1 = (function (){var statearr_22121 = state_21977;
(statearr_22121[(42)] = inst_21564__$1);

return statearr_22121;
})();
if(inst_21567){
var statearr_22122_22308 = state_21977__$1;
(statearr_22122_22308[(1)] = (12));

} else {
var statearr_22123_22309 = state_21977__$1;
(statearr_22123_22309[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (115))){
var inst_21923 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22125_22310 = state_21977__$1;
(statearr_22125_22310[(2)] = inst_21923);

(statearr_22125_22310[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (9))){
var inst_21558 = cljs.core.first.call(null,flakes);
var inst_21559 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_21558);
var inst_21560 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_21561 = fluree.db.query.fql_resp.wildcard_pred_spec.call(null,db,cache,inst_21559,inst_21560);
var state_21977__$1 = state_21977;
var statearr_22126_22311 = state_21977__$1;
(statearr_22126_22311[(2)] = inst_21561);

(statearr_22126_22311[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (5))){
var _ = (function (){var statearr_22127 = state_21977;
(statearr_22127[(4)] = cljs.core.rest.call(null,(state_21977[(4)])));

return statearr_22127;
})();
var state_21977__$1 = state_21977;
var ex22124 = (state_21977__$1[(2)]);
var statearr_22128_22312 = state_21977__$1;
(statearr_22128_22312[(5)] = ex22124);


if((ex22124 instanceof Error)){
var statearr_22129_22313 = state_21977__$1;
(statearr_22129_22313[(1)] = (4));

(statearr_22129_22313[(5)] = null);

} else {
throw ex22124;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (112))){
var inst_21935 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22130_22314 = state_21977__$1;
(statearr_22130_22314[(2)] = inst_21935);

(statearr_22130_22314[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (83))){
var inst_21780 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22131_22315 = state_21977__$1;
(statearr_22131_22315[(2)] = inst_21780);

(statearr_22131_22315[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (14))){
var inst_21564 = (state_21977[(42)]);
var inst_21572 = (state_21977[(2)]);
var inst_21573 = cljs.core.contains_QMARK_.call(null,inst_21564,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_21574 = (!(inst_21573));
var state_21977__$1 = (function (){var statearr_22132 = state_21977;
(statearr_22132[(36)] = inst_21572);

return statearr_22132;
})();
if(inst_21574){
var statearr_22133_22316 = state_21977__$1;
(statearr_22133_22316[(1)] = (15));

} else {
var statearr_22134_22317 = state_21977__$1;
(statearr_22134_22317[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (45))){
var inst_21590 = (state_21977[(16)]);
var inst_21594 = (state_21977[(21)]);
var inst_21630 = cljs.core.get.call(null,acc,inst_21590);
var inst_21631 = cljs.core.count.call(null,inst_21630);
var inst_21632 = (inst_21631 >= inst_21594);
var state_21977__$1 = state_21977;
var statearr_22135_22318 = state_21977__$1;
(statearr_22135_22318[(2)] = inst_21632);

(statearr_22135_22318[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (53))){
var inst_21657 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
if(cljs.core.truth_(inst_21657)){
var statearr_22136_22319 = state_21977__$1;
(statearr_22136_22319[(1)] = (57));

} else {
var statearr_22137_22320 = state_21977__$1;
(statearr_22137_22320[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (78))){
var inst_21939 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22138_22321 = state_21977__$1;
(statearr_22138_22321[(2)] = inst_21939);

(statearr_22138_22321[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (132))){
var state_21977__$1 = state_21977;
var statearr_22140_22322 = state_21977__$1;
(statearr_22140_22322[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (26))){
var inst_21612 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
if(cljs.core.truth_(inst_21612)){
var statearr_22142_22323 = state_21977__$1;
(statearr_22142_22323[(1)] = (33));

} else {
var statearr_22143_22324 = state_21977__$1;
(statearr_22143_22324[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (123))){
var inst_21885 = (state_21977[(33)]);
var inst_21892 = (state_21977[(39)]);
var tmp22139 = inst_21885;
var inst_21884 = inst_21892;
var inst_21885__$1 = tmp22139;
var state_21977__$1 = (function (){var statearr_22144 = state_21977;
(statearr_22144[(33)] = inst_21885__$1);

(statearr_22144[(38)] = inst_21884);

return statearr_22144;
})();
var statearr_22145_22325 = state_21977__$1;
(statearr_22145_22325[(2)] = null);

(statearr_22145_22325[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (16))){
var inst_21572 = (state_21977[(36)]);
var state_21977__$1 = state_21977;
var statearr_22146_22326 = state_21977__$1;
(statearr_22146_22326[(2)] = inst_21572);

(statearr_22146_22326[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (133))){
var inst_21970 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22147_22327 = state_21977__$1;
(statearr_22147_22327[(2)] = inst_21970);

(statearr_22147_22327[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (81))){
var inst_21746 = (state_21977[(28)]);
var inst_21755 = (state_21977[(59)]);
var inst_21579 = (state_21977[(14)]);
var inst_21749 = cljs.core.deref.call(null,cache);
var inst_21750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21751 = fluree.db.flake.o.call(null,inst_21746);
var inst_21752 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21579);
var inst_21753 = [inst_21751,inst_21752];
var inst_21754 = (new cljs.core.PersistentVector(null,2,(5),inst_21750,inst_21753,null));
var inst_21755__$1 = cljs.core.get.call(null,inst_21749,inst_21754);
var state_21977__$1 = (function (){var statearr_22148 = state_21977;
(statearr_22148[(59)] = inst_21755__$1);

return statearr_22148;
})();
if(cljs.core.truth_(inst_21755__$1)){
var statearr_22149_22328 = state_21977__$1;
(statearr_22149_22328[(1)] = (84));

} else {
var statearr_22150_22329 = state_21977__$1;
(statearr_22150_22329[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (120))){
var inst_21919 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22151_22330 = state_21977__$1;
(statearr_22151_22330[(2)] = inst_21919);

(statearr_22151_22330[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (79))){
var inst_21746 = (state_21977[(28)]);
var inst_21739 = (state_21977[(45)]);
var inst_21745 = cljs.core.seq.call(null,inst_21739);
var inst_21746__$1 = cljs.core.first.call(null,inst_21745);
var inst_21747 = cljs.core.next.call(null,inst_21745);
var state_21977__$1 = (function (){var statearr_22152 = state_21977;
(statearr_22152[(28)] = inst_21746__$1);

(statearr_22152[(44)] = inst_21747);

return statearr_22152;
})();
if(cljs.core.truth_(inst_21746__$1)){
var statearr_22153_22331 = state_21977__$1;
(statearr_22153_22331[(1)] = (81));

} else {
var statearr_22154_22332 = state_21977__$1;
(statearr_22154_22332[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (38))){
var inst_21614 = (state_21977[(43)]);
var inst_21622 = (state_21977[(2)]);
var inst_21623 = [null,inst_21622];
var inst_21624 = (new cljs.core.PersistentVector(null,2,(5),inst_21614,inst_21623,null));
var state_21977__$1 = state_21977;
var statearr_22155_22333 = state_21977__$1;
(statearr_22155_22333[(2)] = inst_21624);

(statearr_22155_22333[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (126))){
var state_21977__$1 = state_21977;
var statearr_22156_22334 = state_21977__$1;
(statearr_22156_22334[(2)] = null);

(statearr_22156_22334[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (98))){
var inst_21793 = (state_21977[(60)]);
var inst_21857 = (state_21977[(2)]);
var inst_21858 = [inst_21857,offset_map];
var inst_21859 = (new cljs.core.PersistentVector(null,2,(5),inst_21793,inst_21858,null));
var state_21977__$1 = state_21977;
var statearr_22157_22335 = state_21977__$1;
(statearr_22157_22335[(2)] = inst_21859);

(statearr_22157_22335[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (124))){
var inst_21913 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22158_22336 = state_21977__$1;
(statearr_22158_22336[(2)] = inst_21913);

(statearr_22158_22336[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (87))){
var inst_21746 = (state_21977[(28)]);
var inst_21579 = (state_21977[(14)]);
var inst_21762 = (state_21977[(2)]);
var inst_21763 = fluree.db.util.async.throw_err.call(null,inst_21762);
var inst_21764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21765 = fluree.db.flake.o.call(null,inst_21746);
var inst_21766 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_21579);
var inst_21767 = [inst_21765,inst_21766];
var inst_21768 = (new cljs.core.PersistentVector(null,2,(5),inst_21764,inst_21767,null));
var inst_21769 = fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc,inst_21768,inst_21763);
var state_21977__$1 = (function (){var statearr_22159 = state_21977;
(statearr_22159[(61)] = inst_21769);

return statearr_22159;
})();
var statearr_22160_22337 = state_21977__$1;
(statearr_22160_22337[(2)] = inst_21763);

(statearr_22160_22337[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (30))){
var inst_21597 = (state_21977[(17)]);
var inst_21602 = cljs.core.get.call(null,offset_map,inst_21597);
var inst_21603 = cljs.core.not_EQ_.call(null,(0),inst_21602);
var state_21977__$1 = state_21977;
var statearr_22161_22338 = state_21977__$1;
(statearr_22161_22338[(2)] = inst_21603);

(statearr_22161_22338[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (73))){
var inst_21702 = (state_21977[(22)]);
var inst_21677 = (state_21977[(9)]);
var inst_21711 = cljs.core.conj.call(null,inst_21677,inst_21702);
var state_21977__$1 = state_21977;
var statearr_22162_22339 = state_21977__$1;
(statearr_22162_22339[(2)] = inst_21711);

(statearr_22162_22339[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (96))){
var inst_21937 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
var statearr_22163_22340 = state_21977__$1;
(statearr_22163_22340[(2)] = inst_21937);

(statearr_22163_22340[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (10))){
var state_21977__$1 = state_21977;
var statearr_22164_22341 = state_21977__$1;
(statearr_22164_22341[(2)] = pred_spec);

(statearr_22164_22341[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (18))){
var inst_21580 = (state_21977[(52)]);
var state_21977__$1 = state_21977;
var statearr_22165_22342 = state_21977__$1;
(statearr_22165_22342[(2)] = inst_21580);

(statearr_22165_22342[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (105))){
var inst_21845 = (state_21977[(2)]);
var state_21977__$1 = (function (){var statearr_22166 = state_21977;
(statearr_22166[(46)] = inst_21845);

return statearr_22166;
})();
if(cljs.core.truth_(fuel)){
var statearr_22167_22343 = state_21977__$1;
(statearr_22167_22343[(1)] = (107));

} else {
var statearr_22168_22344 = state_21977__$1;
(statearr_22168_22344[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (52))){
var inst_21647 = (state_21977[(62)]);
var state_21977__$1 = state_21977;
var statearr_22169_22345 = state_21977__$1;
(statearr_22169_22345[(2)] = inst_21647);

(statearr_22169_22345[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (114))){
var inst_21879 = flakes;
var inst_21880 = cljs.core.seq.call(null,inst_21879);
var inst_21881 = cljs.core.first.call(null,inst_21880);
var inst_21882 = cljs.core.next.call(null,inst_21880);
var inst_21883 = cljs.core.PersistentVector.EMPTY;
var inst_21884 = inst_21879;
var inst_21885 = inst_21883;
var state_21977__$1 = (function (){var statearr_22170 = state_21977;
(statearr_22170[(63)] = inst_21882);

(statearr_22170[(33)] = inst_21885);

(statearr_22170[(64)] = inst_21881);

(statearr_22170[(38)] = inst_21884);

return statearr_22170;
})();
var statearr_22171_22346 = state_21977__$1;
(statearr_22171_22346[(2)] = null);

(statearr_22171_22346[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (67))){
var state_21977__$1 = state_21977;
var statearr_22172_22347 = state_21977__$1;
(statearr_22172_22347[(2)] = null);

(statearr_22172_22347[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (71))){
var state_21977__$1 = state_21977;
var statearr_22173_22348 = state_21977__$1;
(statearr_22173_22348[(2)] = null);

(statearr_22173_22348[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (42))){
var inst_21594 = (state_21977[(21)]);
var state_21977__$1 = state_21977;
if(cljs.core.truth_(inst_21594)){
var statearr_22174_22349 = state_21977__$1;
(statearr_22174_22349[(1)] = (45));

} else {
var statearr_22175_22350 = state_21977__$1;
(statearr_22175_22350[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (80))){
var inst_21726 = (state_21977[(54)]);
var inst_21782 = (state_21977[(2)]);
var inst_21783 = [inst_21782,offset_map];
var inst_21784 = (new cljs.core.PersistentVector(null,2,(5),inst_21726,inst_21783,null));
var state_21977__$1 = state_21977;
var statearr_22176_22351 = state_21977__$1;
(statearr_22176_22351[(2)] = inst_21784);

(statearr_22176_22351[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (37))){
var inst_21597 = (state_21977[(17)]);
var inst_21596 = (state_21977[(18)]);
var inst_21619 = (inst_21596 - (1));
var inst_21620 = cljs.core.assoc.call(null,offset_map,inst_21597,inst_21619);
var state_21977__$1 = state_21977;
var statearr_22177_22352 = state_21977__$1;
(statearr_22177_22352[(2)] = inst_21620);

(statearr_22177_22352[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (63))){
var inst_21677 = (state_21977[(9)]);
var state_21977__$1 = state_21977;
var statearr_22178_22353 = state_21977__$1;
(statearr_22178_22353[(2)] = inst_21677);

(statearr_22178_22353[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (94))){
var inst_21793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21801 = flakes;
var inst_21802 = cljs.core.seq.call(null,inst_21801);
var inst_21803 = cljs.core.first.call(null,inst_21802);
var inst_21804 = cljs.core.next.call(null,inst_21802);
var inst_21805 = cljs.core.PersistentVector.EMPTY;
var inst_21806 = inst_21801;
var inst_21807 = inst_21805;
var state_21977__$1 = (function (){var statearr_22179 = state_21977;
(statearr_22179[(32)] = inst_21807);

(statearr_22179[(60)] = inst_21793);

(statearr_22179[(65)] = inst_21803);

(statearr_22179[(49)] = inst_21806);

(statearr_22179[(66)] = inst_21804);

return statearr_22179;
})();
var statearr_22180_22354 = state_21977__$1;
(statearr_22180_22354[(2)] = null);

(statearr_22180_22354[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (8))){
var inst_21556 = (state_21977[(2)]);
var state_21977__$1 = state_21977;
if(cljs.core.truth_(inst_21556)){
var statearr_22181_22355 = state_21977__$1;
(statearr_22181_22355[(1)] = (9));

} else {
var statearr_22182_22356 = state_21977__$1;
(statearr_22182_22356[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (49))){
var inst_21647 = (state_21977[(62)]);
var inst_21647__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_21977__$1 = (function (){var statearr_22183 = state_21977;
(statearr_22183[(62)] = inst_21647__$1);

return statearr_22183;
})();
if(inst_21647__$1){
var statearr_22184_22357 = state_21977__$1;
(statearr_22184_22357[(1)] = (51));

} else {
var statearr_22185_22358 = state_21977__$1;
(statearr_22185_22358[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21978 === (84))){
var inst_21755 = (state_21977[(59)]);
var state_21977__$1 = state_21977;
var statearr_22186_22359 = state_21977__$1;
(statearr_22186_22359[(2)] = inst_21755);

(statearr_22186_22359[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$state_machine__2746__auto____0 = (function (){
var statearr_22187 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22187[(0)] = fluree$db$query$fql_resp$state_machine__2746__auto__);

(statearr_22187[(1)] = (1));

return statearr_22187;
});
var fluree$db$query$fql_resp$state_machine__2746__auto____1 = (function (state_21977){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21977);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22188){var ex__2749__auto__ = e22188;
var statearr_22189_22360 = state_21977;
(statearr_22189_22360[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21977[(4)]))){
var statearr_22190_22361 = state_21977;
(statearr_22190_22361[(1)] = cljs.core.first.call(null,(state_21977[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22362 = state_21977;
state_21977 = G__22362;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$state_machine__2746__auto__ = function(state_21977){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$state_machine__2746__auto____1.call(this,state_21977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$state_machine__2746__auto____0;
fluree$db$query$fql_resp$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$state_machine__2746__auto____1;
return fluree$db$query$fql_resp$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22191 = f__2769__auto__.call(null);
(statearr_22191[(6)] = c__2768__auto__);

return statearr_22191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql_resp.add_pred.cljs$lang$maxFixedArity = 10);

fluree.db.query.fql_resp.compare_fn = (function fluree$db$query$fql_resp$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql_resp.sort_offset_and_limit_res = (function fluree$db$query$fql_resp$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__22364 = res;
var G__22364__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__22363_SHARP_){
return cljs.core.get.call(null,p1__22363_SHARP_,sortPred);
}),fluree.db.query.fql_resp.compare_fn,G__22364):G__22364);
var G__22364__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__22364__$1):G__22364__$1);
var G__22364__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__22364__$2):G__22364__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__22364__$3);
} else {
return G__22364__$3;
}
} else {
return res;
}
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql_resp.flakes__GT_res = (function fluree$db$query$fql_resp$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22545){
var state_val_22546 = (state_22545[(1)]);
if((state_val_22546 === (7))){
var state_22545__$1 = state_22545;
var statearr_22547_22633 = state_22545__$1;
(statearr_22547_22633[(2)] = null);

(statearr_22547_22633[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (20))){
var inst_22403 = cljs.core.PersistentHashMap.EMPTY;
var state_22545__$1 = state_22545;
var statearr_22548_22634 = state_22545__$1;
(statearr_22548_22634[(2)] = inst_22403);

(statearr_22548_22634[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (27))){
var inst_22421 = (state_22545[(7)]);
var inst_22391 = (state_22545[(8)]);
var inst_22405 = (state_22545[(9)]);
var inst_22385 = (state_22545[(10)]);
var inst_22524 = (state_22545[(2)]);
var inst_22525 = (function (){var top_level_subject = inst_22385;
var select_spec = inst_22391;
var base_acc = inst_22405;
var acc_PLUS_refs = inst_22421;
var result = inst_22524;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4253__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_22526 = cljs.core.PersistentVector.EMPTY;
var inst_22527 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22391);
var inst_22528 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_22527);
var inst_22529 = cljs.core.vals.call(null,inst_22528);
var inst_22530 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22391);
var inst_22531 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_22530);
var inst_22532 = cljs.core.vals.call(null,inst_22531);
var inst_22533 = cljs.core.concat.call(null,inst_22529,inst_22532);
var inst_22534 = cljs.core.reduce.call(null,inst_22525,inst_22526,inst_22533);
var inst_22536 = (function (){var top_level_subject = inst_22385;
var select_spec = inst_22391;
var base_acc = inst_22405;
var acc_PLUS_refs = inst_22421;
var result = inst_22524;
var sort_preds = inst_22534;
return (function (acc,p__22535){
var vec__22549 = p__22535;
var selectPred = cljs.core.nth.call(null,vec__22549,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__22549,(1),null);
var sortPred = cljs.core.nth.call(null,vec__22549,(2),null);
var limit = cljs.core.nth.call(null,vec__22549,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql_resp.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_22537 = cljs.core.reduce.call(null,inst_22536,inst_22524,inst_22534);
var state_22545__$1 = state_22545;
var statearr_22552_22635 = state_22545__$1;
(statearr_22552_22635[(2)] = inst_22537);

(statearr_22552_22635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (1))){
var state_22545__$1 = state_22545;
var statearr_22553_22636 = state_22545__$1;
(statearr_22553_22636[(2)] = null);

(statearr_22553_22636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (24))){
var inst_22421 = (state_22545[(7)]);
var inst_22421__$1 = (state_22545[(2)]);
var inst_22422 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_22423 = cljs.core.PersistentHashMap.EMPTY;
var inst_22424 = inst_22422;
var inst_22425 = inst_22421__$1;
var inst_22426 = inst_22423;
var state_22545__$1 = (function (){var statearr_22554 = state_22545;
(statearr_22554[(7)] = inst_22421__$1);

(statearr_22554[(11)] = inst_22424);

(statearr_22554[(12)] = inst_22425);

(statearr_22554[(13)] = inst_22426);

return statearr_22554;
})();
var statearr_22555_22637 = state_22545__$1;
(statearr_22555_22637[(2)] = null);

(statearr_22555_22637[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (39))){
var inst_22434 = (state_22545[(14)]);
var inst_22391 = (state_22545[(8)]);
var inst_22441 = (state_22545[(15)]);
var inst_22425 = (state_22545[(12)]);
var inst_22470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22471 = fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,inst_22425,inst_22391,inst_22434,inst_22441,false);
var state_22545__$1 = (function (){var statearr_22556 = state_22545;
(statearr_22556[(16)] = inst_22470);

return statearr_22556;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22545__$1,(42),inst_22471);
} else {
if((state_val_22546 === (46))){
var inst_22434 = (state_22545[(14)]);
var inst_22424 = (state_22545[(11)]);
var inst_22426 = (state_22545[(13)]);
var inst_22488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22489 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22490 = cljs.core.first.call(null,inst_22434);
var inst_22491 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_22490);
var inst_22492 = [inst_22491];
var inst_22493 = cljs.core.PersistentHashMap.fromArrays(inst_22489,inst_22492);
var inst_22494 = cljs.core.rest.call(null,inst_22424);
var inst_22495 = [inst_22493,inst_22494,inst_22426];
var inst_22496 = (new cljs.core.PersistentVector(null,3,(5),inst_22488,inst_22495,null));
var state_22545__$1 = state_22545;
var statearr_22557_22638 = state_22545__$1;
(statearr_22557_22638[(2)] = inst_22496);

(statearr_22557_22638[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (4))){
var inst_22365 = (state_22545[(2)]);
var state_22545__$1 = state_22545;
var statearr_22558_22639 = state_22545__$1;
(statearr_22558_22639[(2)] = inst_22365);

(statearr_22558_22639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (15))){
var inst_22392 = (state_22545[(17)]);
var inst_22391 = (state_22545[(8)]);
var inst_22391__$1 = (state_22545[(2)]);
var inst_22392__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22391__$1);
var state_22545__$1 = (function (){var statearr_22559 = state_22545;
(statearr_22559[(17)] = inst_22392__$1);

(statearr_22559[(8)] = inst_22391__$1);

return statearr_22559;
})();
if(cljs.core.truth_(inst_22392__$1)){
var statearr_22560_22640 = state_22545__$1;
(statearr_22560_22640[(1)] = (16));

} else {
var statearr_22561_22641 = state_22545__$1;
(statearr_22561_22641[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (48))){
var inst_22507 = (state_22545[(2)]);
var state_22545__$1 = state_22545;
var statearr_22562_22642 = state_22545__$1;
(statearr_22562_22642[(2)] = inst_22507);

(statearr_22562_22642[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (50))){
var state_22545__$1 = state_22545;
var statearr_22563_22643 = state_22545__$1;
(statearr_22563_22643[(2)] = null);

(statearr_22563_22643[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (21))){
var inst_22391 = (state_22545[(8)]);
var inst_22405 = (state_22545[(2)]);
var inst_22406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22407 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_22408 = (new cljs.core.PersistentVector(null,2,(5),inst_22406,inst_22407,null));
var inst_22409 = cljs.core.get_in.call(null,inst_22391,inst_22408);
var state_22545__$1 = (function (){var statearr_22564 = state_22545;
(statearr_22564[(9)] = inst_22405);

return statearr_22564;
})();
if(cljs.core.truth_(inst_22409)){
var statearr_22565_22644 = state_22545__$1;
(statearr_22565_22644[(1)] = (22));

} else {
var statearr_22566_22645 = state_22545__$1;
(statearr_22566_22645[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (31))){
var inst_22434 = (state_22545[(14)]);
var inst_22440 = (state_22545[(18)]);
var inst_22425 = (state_22545[(12)]);
var inst_22444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22445 = fluree.db.query.fql_resp.flake__GT_recur.call(null,db,inst_22434,inst_22440,inst_22425,fuel,max_fuel,cache);
var state_22545__$1 = (function (){var statearr_22567 = state_22545;
(statearr_22567[(19)] = inst_22444);

return statearr_22567;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22545__$1,(34),inst_22445);
} else {
if((state_val_22546 === (32))){
var inst_22440 = (state_22545[(18)]);
var state_22545__$1 = state_22545;
if(cljs.core.truth_(inst_22440)){
var statearr_22568_22646 = state_22545__$1;
(statearr_22568_22646[(1)] = (35));

} else {
var statearr_22569_22647 = state_22545__$1;
(statearr_22569_22647[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (40))){
var inst_22481 = (state_22545[(20)]);
var inst_22391 = (state_22545[(8)]);
var inst_22480 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22391);
var inst_22481__$1 = cljs.core.empty_QMARK_.call(null,inst_22480);
var state_22545__$1 = (function (){var statearr_22570 = state_22545;
(statearr_22570[(20)] = inst_22481__$1);

return statearr_22570;
})();
if(inst_22481__$1){
var statearr_22571_22648 = state_22545__$1;
(statearr_22571_22648[(1)] = (43));

} else {
var statearr_22572_22649 = state_22545__$1;
(statearr_22572_22649[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (33))){
var inst_22434 = (state_22545[(14)]);
var inst_22513 = (state_22545[(2)]);
var inst_22514 = cljs.core.nth.call(null,inst_22513,(0),null);
var inst_22515 = cljs.core.nth.call(null,inst_22513,(1),null);
var inst_22516 = cljs.core.nth.call(null,inst_22513,(2),null);
var inst_22517 = cljs.core.first.call(null,inst_22434);
var inst_22518 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_22517);
var inst_22519 = cljs.core.assoc.call(null,inst_22514,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_22518);
var inst_22424 = inst_22515;
var inst_22425 = inst_22519;
var inst_22426 = inst_22516;
var state_22545__$1 = (function (){var statearr_22573 = state_22545;
(statearr_22573[(11)] = inst_22424);

(statearr_22573[(12)] = inst_22425);

(statearr_22573[(13)] = inst_22426);

return statearr_22573;
})();
var statearr_22574_22650 = state_22545__$1;
(statearr_22574_22650[(2)] = null);

(statearr_22574_22650[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (13))){
var inst_22385 = (state_22545[(10)]);
var inst_22388 = fluree.db.query.fql_resp.full_select_spec.call(null,db,cache,base_select_spec,inst_22385);
var state_22545__$1 = state_22545;
var statearr_22575_22651 = state_22545__$1;
(statearr_22575_22651[(2)] = inst_22388);

(statearr_22575_22651[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (22))){
var inst_22391 = (state_22545[(8)]);
var inst_22411 = cljs.core.first.call(null,flakes);
var inst_22412 = fluree.db.flake.s.call(null,inst_22411);
var inst_22413 = fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs.call(null,inst_22391);
var inst_22414 = fluree.db.query.fql_resp.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_22412,inst_22413);
var state_22545__$1 = state_22545;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22545__$1,(25),inst_22414);
} else {
if((state_val_22546 === (36))){
var inst_22391 = (state_22545[(8)]);
var inst_22468 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22391);
var state_22545__$1 = state_22545;
if(cljs.core.truth_(inst_22468)){
var statearr_22576_22652 = state_22545__$1;
(statearr_22576_22652[(1)] = (39));

} else {
var statearr_22577_22653 = state_22545__$1;
(statearr_22577_22653[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (41))){
var inst_22509 = (state_22545[(2)]);
var state_22545__$1 = state_22545;
var statearr_22578_22654 = state_22545__$1;
(statearr_22578_22654[(2)] = inst_22509);

(statearr_22578_22654[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (43))){
var inst_22391 = (state_22545[(8)]);
var inst_22483 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_22391);
var state_22545__$1 = state_22545;
var statearr_22579_22655 = state_22545__$1;
(statearr_22579_22655[(2)] = inst_22483);

(statearr_22579_22655[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (29))){
var inst_22434 = (state_22545[(14)]);
var inst_22424 = (state_22545[(11)]);
var inst_22391 = (state_22545[(8)]);
var inst_22440 = (state_22545[(18)]);
var inst_22434__$1 = cljs.core.first.call(null,inst_22424);
var inst_22435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22436 = cljs.core.first.call(null,inst_22434__$1);
var inst_22437 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22436);
var inst_22438 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_22437];
var inst_22439 = (new cljs.core.PersistentVector(null,3,(5),inst_22435,inst_22438,null));
var inst_22440__$1 = cljs.core.get_in.call(null,inst_22391,inst_22439);
var inst_22441 = fluree.db.query.fql_resp.component_follow_QMARK_.call(null,inst_22440__$1,inst_22391);
var inst_22442 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_22440__$1);
var state_22545__$1 = (function (){var statearr_22580 = state_22545;
(statearr_22580[(14)] = inst_22434__$1);

(statearr_22580[(18)] = inst_22440__$1);

(statearr_22580[(15)] = inst_22441);

return statearr_22580;
})();
if(cljs.core.truth_(inst_22442)){
var statearr_22581_22656 = state_22545__$1;
(statearr_22581_22656[(1)] = (31));

} else {
var statearr_22582_22657 = state_22545__$1;
(statearr_22582_22657[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (44))){
var inst_22481 = (state_22545[(20)]);
var state_22545__$1 = state_22545;
var statearr_22583_22658 = state_22545__$1;
(statearr_22583_22658[(2)] = inst_22481);

(statearr_22583_22658[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (6))){
var state_22545__$1 = state_22545;
var statearr_22584_22659 = state_22545__$1;
(statearr_22584_22659[(2)] = null);

(statearr_22584_22659[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (28))){
var inst_22425 = (state_22545[(12)]);
var state_22545__$1 = state_22545;
var statearr_22585_22660 = state_22545__$1;
(statearr_22585_22660[(2)] = inst_22425);

(statearr_22585_22660[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (51))){
var inst_22505 = (state_22545[(2)]);
var state_22545__$1 = state_22545;
var statearr_22586_22661 = state_22545__$1;
(statearr_22586_22661[(2)] = inst_22505);

(statearr_22586_22661[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (25))){
var inst_22405 = (state_22545[(9)]);
var inst_22416 = (state_22545[(2)]);
var inst_22417 = fluree.db.util.async.throw_err.call(null,inst_22416);
var inst_22418 = cljs.core.merge.call(null,inst_22405,inst_22417);
var state_22545__$1 = state_22545;
var statearr_22587_22662 = state_22545__$1;
(statearr_22587_22662[(2)] = inst_22418);

(statearr_22587_22662[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (34))){
var inst_22444 = (state_22545[(19)]);
var inst_22424 = (state_22545[(11)]);
var inst_22426 = (state_22545[(13)]);
var inst_22447 = (state_22545[(2)]);
var inst_22448 = fluree.db.util.async.throw_err.call(null,inst_22447);
var inst_22449 = cljs.core.rest.call(null,inst_22424);
var inst_22450 = [inst_22448,inst_22449,inst_22426];
var inst_22451 = (new cljs.core.PersistentVector(null,3,(5),inst_22444,inst_22450,null));
var state_22545__$1 = state_22545;
var statearr_22588_22663 = state_22545__$1;
(statearr_22588_22663[(2)] = inst_22451);

(statearr_22588_22663[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (17))){
var inst_22391 = (state_22545[(8)]);
var inst_22395 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_22391);
var state_22545__$1 = state_22545;
var statearr_22590_22664 = state_22545__$1;
(statearr_22590_22664[(2)] = inst_22395);

(statearr_22590_22664[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (3))){
var inst_22543 = (state_22545[(2)]);
var state_22545__$1 = state_22545;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22545__$1,inst_22543);
} else {
if((state_val_22546 === (12))){
var _ = (function (){var statearr_22591 = state_22545;
(statearr_22591[(4)] = cljs.core.rest.call(null,(state_22545[(4)])));

return statearr_22591;
})();
var state_22545__$1 = state_22545;
var ex22589 = (state_22545__$1[(2)]);
var statearr_22592_22665 = state_22545__$1;
(statearr_22592_22665[(5)] = ex22589);


var statearr_22593_22666 = state_22545__$1;
(statearr_22593_22666[(1)] = (11));

(statearr_22593_22666[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (2))){
var _ = (function (){var statearr_22594 = state_22545;
(statearr_22594[(4)] = cljs.core.cons.call(null,(5),(state_22545[(4)])));

return statearr_22594;
})();
var inst_22371 = cljs.core.not_empty.call(null,flakes);
var state_22545__$1 = state_22545;
if(cljs.core.truth_(inst_22371)){
var statearr_22595_22667 = state_22545__$1;
(statearr_22595_22667[(1)] = (6));

} else {
var statearr_22596_22668 = state_22545__$1;
(statearr_22596_22668[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (23))){
var inst_22405 = (state_22545[(9)]);
var state_22545__$1 = state_22545;
var statearr_22597_22669 = state_22545__$1;
(statearr_22597_22669[(2)] = inst_22405);

(statearr_22597_22669[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (47))){
var state_22545__$1 = state_22545;
var statearr_22598_22670 = state_22545__$1;
(statearr_22598_22670[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (35))){
var inst_22434 = (state_22545[(14)]);
var inst_22440 = (state_22545[(18)]);
var inst_22441 = (state_22545[(15)]);
var inst_22425 = (state_22545[(12)]);
var inst_22426 = (state_22545[(13)]);
var inst_22457 = fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,inst_22425,inst_22440,inst_22434,inst_22441,false,inst_22426);
var state_22545__$1 = state_22545;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22545__$1,(38),inst_22457);
} else {
if((state_val_22546 === (19))){
var inst_22385 = (state_22545[(10)]);
var inst_22399 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22400 = [inst_22385];
var inst_22401 = cljs.core.PersistentHashMap.fromArrays(inst_22399,inst_22400);
var state_22545__$1 = state_22545;
var statearr_22600_22671 = state_22545__$1;
(statearr_22600_22671[(2)] = inst_22401);

(statearr_22600_22671[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (11))){
var inst_22373 = (state_22545[(2)]);
var inst_22374 = fluree.db.util.log.error.call(null,inst_22373);
var inst_22375 = (function(){throw inst_22373})();
var state_22545__$1 = (function (){var statearr_22602 = state_22545;
(statearr_22602[(21)] = inst_22374);

return statearr_22602;
})();
var statearr_22603_22672 = state_22545__$1;
(statearr_22603_22672[(2)] = inst_22375);

(statearr_22603_22672[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (9))){
var _ = (function (){var statearr_22604 = state_22545;
(statearr_22604[(4)] = cljs.core.cons.call(null,(12),(state_22545[(4)])));

return statearr_22604;
})();
var inst_22381 = cljs.core.first.call(null,flakes);
var inst_22382 = fluree.db.flake.s.call(null,inst_22381);
var ___$1 = (function (){var statearr_22605 = state_22545;
(statearr_22605[(4)] = cljs.core.rest.call(null,(state_22545[(4)])));

return statearr_22605;
})();
var state_22545__$1 = state_22545;
var statearr_22606_22673 = state_22545__$1;
(statearr_22606_22673[(2)] = inst_22382);

(statearr_22606_22673[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (5))){
var _ = (function (){var statearr_22607 = state_22545;
(statearr_22607[(4)] = cljs.core.rest.call(null,(state_22545[(4)])));

return statearr_22607;
})();
var state_22545__$1 = state_22545;
var ex22601 = (state_22545__$1[(2)]);
var statearr_22608_22674 = state_22545__$1;
(statearr_22608_22674[(5)] = ex22601);


if((ex22601 instanceof Error)){
var statearr_22609_22675 = state_22545__$1;
(statearr_22609_22675[(1)] = (4));

(statearr_22609_22675[(5)] = null);

} else {
throw ex22601;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (14))){
var state_22545__$1 = state_22545;
var statearr_22610_22676 = state_22545__$1;
(statearr_22610_22676[(2)] = base_select_spec);

(statearr_22610_22676[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (45))){
var inst_22486 = (state_22545[(2)]);
var state_22545__$1 = state_22545;
if(cljs.core.truth_(inst_22486)){
var statearr_22611_22677 = state_22545__$1;
(statearr_22611_22677[(1)] = (46));

} else {
var statearr_22612_22678 = state_22545__$1;
(statearr_22612_22678[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (26))){
var inst_22424 = (state_22545[(11)]);
var inst_22428 = cljs.core.empty_QMARK_.call(null,inst_22424);
var state_22545__$1 = state_22545;
if(inst_22428){
var statearr_22613_22679 = state_22545__$1;
(statearr_22613_22679[(1)] = (28));

} else {
var statearr_22614_22680 = state_22545__$1;
(statearr_22614_22680[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (16))){
var inst_22392 = (state_22545[(17)]);
var state_22545__$1 = state_22545;
var statearr_22615_22681 = state_22545__$1;
(statearr_22615_22681[(2)] = inst_22392);

(statearr_22615_22681[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (38))){
var inst_22424 = (state_22545[(11)]);
var inst_22459 = (state_22545[(2)]);
var inst_22460 = fluree.db.util.async.throw_err.call(null,inst_22459);
var inst_22461 = cljs.core.nth.call(null,inst_22460,(0),null);
var inst_22462 = cljs.core.nth.call(null,inst_22460,(1),null);
var inst_22463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22464 = cljs.core.rest.call(null,inst_22424);
var inst_22465 = [inst_22461,inst_22464,inst_22462];
var inst_22466 = (new cljs.core.PersistentVector(null,3,(5),inst_22463,inst_22465,null));
var state_22545__$1 = state_22545;
var statearr_22616_22682 = state_22545__$1;
(statearr_22616_22682[(2)] = inst_22466);

(statearr_22616_22682[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (30))){
var inst_22522 = (state_22545[(2)]);
var state_22545__$1 = state_22545;
var statearr_22617_22683 = state_22545__$1;
(statearr_22617_22683[(2)] = inst_22522);

(statearr_22617_22683[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (10))){
var inst_22385 = (state_22545[(2)]);
var inst_22386 = fluree.db.query.fql_resp.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_22545__$1 = (function (){var statearr_22618 = state_22545;
(statearr_22618[(10)] = inst_22385);

return statearr_22618;
})();
if(cljs.core.truth_(inst_22386)){
var statearr_22619_22684 = state_22545__$1;
(statearr_22619_22684[(1)] = (13));

} else {
var statearr_22620_22685 = state_22545__$1;
(statearr_22620_22685[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (18))){
var inst_22397 = (state_22545[(2)]);
var state_22545__$1 = state_22545;
if(cljs.core.truth_(inst_22397)){
var statearr_22621_22686 = state_22545__$1;
(statearr_22621_22686[(1)] = (19));

} else {
var statearr_22622_22687 = state_22545__$1;
(statearr_22622_22687[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (42))){
var inst_22424 = (state_22545[(11)]);
var inst_22470 = (state_22545[(16)]);
var inst_22426 = (state_22545[(13)]);
var inst_22473 = (state_22545[(2)]);
var inst_22474 = fluree.db.util.async.throw_err.call(null,inst_22473);
var inst_22475 = cljs.core.first.call(null,inst_22474);
var inst_22476 = cljs.core.rest.call(null,inst_22424);
var inst_22477 = [inst_22475,inst_22476,inst_22426];
var inst_22478 = (new cljs.core.PersistentVector(null,3,(5),inst_22470,inst_22477,null));
var state_22545__$1 = state_22545;
var statearr_22623_22688 = state_22545__$1;
(statearr_22623_22688[(2)] = inst_22478);

(statearr_22623_22688[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (37))){
var inst_22511 = (state_22545[(2)]);
var state_22545__$1 = state_22545;
var statearr_22624_22689 = state_22545__$1;
(statearr_22624_22689[(2)] = inst_22511);

(statearr_22624_22689[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (8))){
var inst_22540 = (state_22545[(2)]);
var _ = (function (){var statearr_22625 = state_22545;
(statearr_22625[(4)] = cljs.core.rest.call(null,(state_22545[(4)])));

return statearr_22625;
})();
var state_22545__$1 = state_22545;
var statearr_22626_22690 = state_22545__$1;
(statearr_22626_22690[(2)] = inst_22540);

(statearr_22626_22690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22546 === (49))){
var inst_22424 = (state_22545[(11)]);
var inst_22425 = (state_22545[(12)]);
var inst_22426 = (state_22545[(13)]);
var inst_22499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22500 = cljs.core.rest.call(null,inst_22424);
var inst_22501 = [inst_22425,inst_22500,inst_22426];
var inst_22502 = (new cljs.core.PersistentVector(null,3,(5),inst_22499,inst_22501,null));
var state_22545__$1 = state_22545;
var statearr_22627_22691 = state_22545__$1;
(statearr_22627_22691[(2)] = inst_22502);

(statearr_22627_22691[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0 = (function (){
var statearr_22628 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22628[(0)] = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__);

(statearr_22628[(1)] = (1));

return statearr_22628;
});
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1 = (function (state_22545){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22545);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22629){var ex__2749__auto__ = e22629;
var statearr_22630_22692 = state_22545;
(statearr_22630_22692[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22545[(4)]))){
var statearr_22631_22693 = state_22545;
(statearr_22631_22693[(1)] = cljs.core.first.call(null,(state_22545[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22694 = state_22545;
state_22545 = G__22694;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__ = function(state_22545){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1.call(this,state_22545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22632 = f__2769__auto__.call(null);
(statearr_22632[(6)] = c__2768__auto__);

return statearr_22632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
