// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4913__auto___52846 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_52897){
var state_val_52898 = (state_52897[(1)]);
if((state_val_52898 === (7))){
var inst_52892 = (state_52897[(2)]);
var _ = (function (){var statearr_52899 = state_52897;
(statearr_52899[(4)] = cljs.core.rest.call(null,(state_52897[(4)])));

return statearr_52899;
})();
var state_52897__$1 = state_52897;
var statearr_52900_52927 = state_52897__$1;
(statearr_52900_52927[(2)] = inst_52892);

(statearr_52900_52927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52898 === (1))){
var state_52897__$1 = state_52897;
var statearr_52901_52928 = state_52897__$1;
(statearr_52901_52928[(2)] = null);

(statearr_52901_52928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52898 === (4))){
var inst_52847 = (state_52897[(2)]);
var state_52897__$1 = state_52897;
var statearr_52902_52929 = state_52897__$1;
(statearr_52902_52929[(2)] = inst_52847);

(statearr_52902_52929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52898 === (13))){
var inst_52888 = (state_52897[(2)]);
var state_52897__$1 = state_52897;
var statearr_52903_52930 = state_52897__$1;
(statearr_52903_52930[(2)] = inst_52888);

(statearr_52903_52930[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52898 === (6))){
var inst_52865 = (state_52897[(7)]);
var inst_52872 = (state_52897[(8)]);
var inst_52871 = cljs.core.seq.call(null,inst_52865);
var inst_52872__$1 = cljs.core.first.call(null,inst_52871);
var inst_52873 = cljs.core.next.call(null,inst_52871);
var inst_52874 = cljs.core.not.call(null,inst_52872__$1);
var state_52897__$1 = (function (){var statearr_52904 = state_52897;
(statearr_52904[(8)] = inst_52872__$1);

(statearr_52904[(9)] = inst_52873);

return statearr_52904;
})();
if(inst_52874){
var statearr_52905_52931 = state_52897__$1;
(statearr_52905_52931[(1)] = (8));

} else {
var statearr_52906_52932 = state_52897__$1;
(statearr_52906_52932[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52898 === (3))){
var inst_52895 = (state_52897[(2)]);
var state_52897__$1 = state_52897;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52897__$1,inst_52895);
} else {
if((state_val_52898 === (12))){
var inst_52866 = (state_52897[(10)]);
var inst_52872 = (state_52897[(8)]);
var inst_52873 = (state_52897[(9)]);
var inst_52885 = cljs.core.conj.call(null,inst_52866,inst_52872);
var inst_52865 = inst_52873;
var inst_52866__$1 = inst_52885;
var state_52897__$1 = (function (){var statearr_52907 = state_52897;
(statearr_52907[(7)] = inst_52865);

(statearr_52907[(10)] = inst_52866__$1);

return statearr_52907;
})();
var statearr_52908_52933 = state_52897__$1;
(statearr_52908_52933[(2)] = null);

(statearr_52908_52933[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52898 === (2))){
var _ = (function (){var statearr_52909 = state_52897;
(statearr_52909[(4)] = cljs.core.cons.call(null,(5),(state_52897[(4)])));

return statearr_52909;
})();
var inst_52860 = args;
var inst_52861 = cljs.core.seq.call(null,inst_52860);
var inst_52862 = cljs.core.first.call(null,inst_52861);
var inst_52863 = cljs.core.next.call(null,inst_52861);
var inst_52864 = cljs.core.PersistentVector.EMPTY;
var inst_52865 = inst_52860;
var inst_52866 = inst_52864;
var state_52897__$1 = (function (){var statearr_52910 = state_52897;
(statearr_52910[(7)] = inst_52865);

(statearr_52910[(10)] = inst_52866);

(statearr_52910[(11)] = inst_52863);

(statearr_52910[(12)] = inst_52862);

return statearr_52910;
})();
var statearr_52911_52934 = state_52897__$1;
(statearr_52911_52934[(2)] = null);

(statearr_52911_52934[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52898 === (11))){
var inst_52872 = (state_52897[(8)]);
var state_52897__$1 = state_52897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52897__$1,(14),inst_52872);
} else {
if((state_val_52898 === (9))){
var inst_52872 = (state_52897[(8)]);
var inst_52877 = fluree.db.util.async.channel_QMARK_.call(null,inst_52872);
var state_52897__$1 = state_52897;
if(inst_52877){
var statearr_52913_52935 = state_52897__$1;
(statearr_52913_52935[(1)] = (11));

} else {
var statearr_52914_52936 = state_52897__$1;
(statearr_52914_52936[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52898 === (5))){
var _ = (function (){var statearr_52915 = state_52897;
(statearr_52915[(4)] = cljs.core.rest.call(null,(state_52897[(4)])));

return statearr_52915;
})();
var state_52897__$1 = state_52897;
var ex52912 = (state_52897__$1[(2)]);
var statearr_52916_52937 = state_52897__$1;
(statearr_52916_52937[(5)] = ex52912);


if((ex52912 instanceof Error)){
var statearr_52917_52938 = state_52897__$1;
(statearr_52917_52938[(1)] = (4));

(statearr_52917_52938[(5)] = null);

} else {
throw ex52912;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52898 === (14))){
var inst_52866 = (state_52897[(10)]);
var inst_52873 = (state_52897[(9)]);
var inst_52880 = (state_52897[(2)]);
var inst_52881 = fluree.db.util.async.throw_err.call(null,inst_52880);
var inst_52882 = cljs.core.conj.call(null,inst_52866,inst_52881);
var inst_52865 = inst_52873;
var inst_52866__$1 = inst_52882;
var state_52897__$1 = (function (){var statearr_52918 = state_52897;
(statearr_52918[(7)] = inst_52865);

(statearr_52918[(10)] = inst_52866__$1);

return statearr_52918;
})();
var statearr_52919_52939 = state_52897__$1;
(statearr_52919_52939[(2)] = null);

(statearr_52919_52939[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52898 === (10))){
var inst_52890 = (state_52897[(2)]);
var state_52897__$1 = state_52897;
var statearr_52920_52940 = state_52897__$1;
(statearr_52920_52940[(2)] = inst_52890);

(statearr_52920_52940[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52898 === (8))){
var inst_52866 = (state_52897[(10)]);
var state_52897__$1 = state_52897;
var statearr_52921_52941 = state_52897__$1;
(statearr_52921_52941[(2)] = inst_52866);

(statearr_52921_52941[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0 = (function (){
var statearr_52922 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52922[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__);

(statearr_52922[(1)] = (1));

return statearr_52922;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1 = (function (state_52897){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_52897);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e52923){var ex__2749__auto__ = e52923;
var statearr_52924_52942 = state_52897;
(statearr_52924_52942[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_52897[(4)]))){
var statearr_52925_52943 = state_52897;
(statearr_52925_52943[(1)] = cljs.core.first.call(null,(state_52897[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52944 = state_52897;
state_52897 = G__52944;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__ = function(state_52897){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1.call(this,state_52897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_52926 = f__2769__auto__.call(null);
(statearr_52926[(6)] = c__2768__auto__);

return statearr_52926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__52946 = entry;
var res = cljs.core.nth.call(null,vec__52946,(0),null);
var cost = cljs.core.nth.call(null,vec__52946,(1),null);
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__52945_SHARP_){
return cljs.core.update.call(null,cljs.core.update.call(null,cljs.core.update.call(null,p1__52945_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_52994){
var state_val_52995 = (state_52994[(1)]);
if((state_val_52995 === (7))){
var state_52994__$1 = state_52994;
var statearr_52996_53025 = state_52994__$1;
(statearr_52996_53025[(2)] = coll);

(statearr_52996_53025[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52995 === (1))){
var state_52994__$1 = state_52994;
var statearr_52997_53026 = state_52994__$1;
(statearr_52997_53026[(2)] = null);

(statearr_52997_53026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52995 === (4))){
var inst_52949 = (state_52994[(2)]);
var state_52994__$1 = state_52994;
var statearr_52998_53027 = state_52994__$1;
(statearr_52998_53027[(2)] = inst_52949);

(statearr_52998_53027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52995 === (15))){
var inst_52968 = (state_52994[(7)]);
var inst_52976 = (state_52994[(2)]);
var inst_52977 = fluree.db.dbfunctions.internal.nth.call(null,inst_52968,inst_52976);
var inst_52978 = cljs.core.count.call(null,inst_52968);
var inst_52979 = ((9) + inst_52978);
var inst_52980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52981 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_52982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52983 = [inst_52968,inst_52976];
var inst_52984 = (new cljs.core.PersistentVector(null,2,(5),inst_52982,inst_52983,null));
var inst_52985 = ["nth",inst_52984,inst_52977];
var inst_52986 = cljs.core.PersistentHashMap.fromArrays(inst_52981,inst_52985);
var inst_52987 = [inst_52986,inst_52979];
var inst_52988 = (new cljs.core.PersistentVector(null,2,(5),inst_52980,inst_52987,null));
var inst_52989 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_52988);
var _ = (function (){var statearr_52999 = state_52994;
(statearr_52999[(4)] = cljs.core.rest.call(null,(state_52994[(4)])));

return statearr_52999;
})();
var state_52994__$1 = (function (){var statearr_53000 = state_52994;
(statearr_53000[(8)] = inst_52989);

return statearr_53000;
})();
var statearr_53001_53028 = state_52994__$1;
(statearr_53001_53028[(2)] = inst_52977);

(statearr_53001_53028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52995 === (13))){
var state_52994__$1 = state_52994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52994__$1,(16),key);
} else {
if((state_val_52995 === (6))){
var state_52994__$1 = state_52994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52994__$1,(9),coll);
} else {
if((state_val_52995 === (3))){
var inst_52992 = (state_52994[(2)]);
var state_52994__$1 = state_52994;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52994__$1,inst_52992);
} else {
if((state_val_52995 === (12))){
var inst_52968 = (state_52994[(2)]);
var inst_52969 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_52994__$1 = (function (){var statearr_53002 = state_52994;
(statearr_53002[(7)] = inst_52968);

return statearr_53002;
})();
if(inst_52969){
var statearr_53003_53029 = state_52994__$1;
(statearr_53003_53029[(1)] = (13));

} else {
var statearr_53004_53030 = state_52994__$1;
(statearr_53004_53030[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52995 === (2))){
var _ = (function (){var statearr_53005 = state_52994;
(statearr_53005[(4)] = cljs.core.cons.call(null,(5),(state_52994[(4)])));

return statearr_53005;
})();
var inst_52955 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_52994__$1 = state_52994;
if(inst_52955){
var statearr_53006_53031 = state_52994__$1;
(statearr_53006_53031[(1)] = (6));

} else {
var statearr_53007_53032 = state_52994__$1;
(statearr_53007_53032[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52995 === (11))){
var inst_52962 = (state_52994[(9)]);
var state_52994__$1 = state_52994;
var statearr_53009_53033 = state_52994__$1;
(statearr_53009_53033[(2)] = inst_52962);

(statearr_53009_53033[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52995 === (9))){
var inst_52958 = (state_52994[(2)]);
var inst_52959 = fluree.db.util.async.throw_err.call(null,inst_52958);
var state_52994__$1 = state_52994;
var statearr_53010_53034 = state_52994__$1;
(statearr_53010_53034[(2)] = inst_52959);

(statearr_53010_53034[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52995 === (5))){
var _ = (function (){var statearr_53011 = state_52994;
(statearr_53011[(4)] = cljs.core.rest.call(null,(state_52994[(4)])));

return statearr_53011;
})();
var state_52994__$1 = state_52994;
var ex53008 = (state_52994__$1[(2)]);
var statearr_53012_53035 = state_52994__$1;
(statearr_53012_53035[(5)] = ex53008);


if((ex53008 instanceof Error)){
var statearr_53013_53036 = state_52994__$1;
(statearr_53013_53036[(1)] = (4));

(statearr_53013_53036[(5)] = null);

} else {
throw ex53008;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52995 === (14))){
var state_52994__$1 = state_52994;
var statearr_53014_53037 = state_52994__$1;
(statearr_53014_53037[(2)] = key);

(statearr_53014_53037[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52995 === (16))){
var inst_52972 = (state_52994[(2)]);
var inst_52973 = fluree.db.util.async.throw_err.call(null,inst_52972);
var state_52994__$1 = state_52994;
var statearr_53015_53038 = state_52994__$1;
(statearr_53015_53038[(2)] = inst_52973);

(statearr_53015_53038[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52995 === (10))){
var inst_52962 = (state_52994[(9)]);
var inst_52965 = cljs.core.vec.call(null,inst_52962);
var state_52994__$1 = state_52994;
var statearr_53016_53039 = state_52994__$1;
(statearr_53016_53039[(2)] = inst_52965);

(statearr_53016_53039[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52995 === (8))){
var inst_52962 = (state_52994[(9)]);
var inst_52962__$1 = (state_52994[(2)]);
var inst_52963 = cljs.core.set_QMARK_.call(null,inst_52962__$1);
var state_52994__$1 = (function (){var statearr_53017 = state_52994;
(statearr_53017[(9)] = inst_52962__$1);

return statearr_53017;
})();
if(inst_52963){
var statearr_53018_53040 = state_52994__$1;
(statearr_53018_53040[(1)] = (10));

} else {
var statearr_53019_53041 = state_52994__$1;
(statearr_53019_53041[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0 = (function (){
var statearr_53020 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53020[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__);

(statearr_53020[(1)] = (1));

return statearr_53020;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1 = (function (state_52994){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_52994);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53021){var ex__2749__auto__ = e53021;
var statearr_53022_53042 = state_52994;
(statearr_53022_53042[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_52994[(4)]))){
var statearr_53023_53043 = state_52994;
(statearr_53023_53043[(1)] = cljs.core.first.call(null,(state_52994[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53044 = state_52994;
state_52994 = G__53044;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__ = function(state_52994){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1.call(this,state_52994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53024 = f__2769__auto__.call(null);
(statearr_53024[(6)] = c__2768__auto__);

return statearr_53024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53105){
var state_val_53106 = (state_53105[(1)]);
if((state_val_53106 === (7))){
var state_53105__$1 = state_53105;
var statearr_53107_53141 = state_53105__$1;
(statearr_53107_53141[(2)] = test);

(statearr_53107_53141[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (20))){
var inst_53079 = (state_53105[(2)]);
var inst_53080 = fluree.db.util.async.throw_err.call(null,inst_53079);
var state_53105__$1 = state_53105;
var statearr_53108_53142 = state_53105__$1;
(statearr_53108_53142[(2)] = inst_53080);

(statearr_53108_53142[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (1))){
var state_53105__$1 = state_53105;
var statearr_53109_53143 = state_53105__$1;
(statearr_53109_53143[(2)] = null);

(statearr_53109_53143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (4))){
var inst_53045 = (state_53105[(2)]);
var state_53105__$1 = state_53105;
var statearr_53110_53144 = state_53105__$1;
(statearr_53110_53144[(2)] = inst_53045);

(statearr_53110_53144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (15))){
var inst_53063 = (state_53105[(7)]);
var inst_53071 = (state_53105[(2)]);
var inst_53072 = [inst_53071,f];
var inst_53073 = (new cljs.core.PersistentVector(null,2,(5),inst_53063,inst_53072,null));
var state_53105__$1 = state_53105;
var statearr_53111_53145 = state_53105__$1;
(statearr_53111_53145[(2)] = inst_53073);

(statearr_53111_53145[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (13))){
var state_53105__$1 = state_53105;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53105__$1,(16),t);
} else {
if((state_val_53106 === (6))){
var state_53105__$1 = state_53105;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53105__$1,(9),test);
} else {
if((state_val_53106 === (17))){
var state_53105__$1 = state_53105;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53105__$1,(20),f);
} else {
if((state_val_53106 === (3))){
var inst_53103 = (state_53105[(2)]);
var state_53105__$1 = state_53105;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53105__$1,inst_53103);
} else {
if((state_val_53106 === (12))){
var inst_53061 = (state_53105[(8)]);
var inst_53087 = (state_53105[(2)]);
var inst_53088 = cljs.core.nth.call(null,inst_53087,(0),null);
var inst_53089 = cljs.core.nth.call(null,inst_53087,(1),null);
var inst_53090 = fluree.db.dbfunctions.internal.if_else.call(null,inst_53061,inst_53088,inst_53089);
var inst_53091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53092 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53094 = [inst_53061,inst_53088,inst_53089];
var inst_53095 = (new cljs.core.PersistentVector(null,3,(5),inst_53093,inst_53094,null));
var inst_53096 = ["if-else",inst_53095,inst_53090];
var inst_53097 = cljs.core.PersistentHashMap.fromArrays(inst_53092,inst_53096);
var inst_53098 = [inst_53097,(10)];
var inst_53099 = (new cljs.core.PersistentVector(null,2,(5),inst_53091,inst_53098,null));
var inst_53100 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53099);
var _ = (function (){var statearr_53112 = state_53105;
(statearr_53112[(4)] = cljs.core.rest.call(null,(state_53105[(4)])));

return statearr_53112;
})();
var state_53105__$1 = (function (){var statearr_53113 = state_53105;
(statearr_53113[(9)] = inst_53100);

return statearr_53113;
})();
var statearr_53114_53146 = state_53105__$1;
(statearr_53114_53146[(2)] = inst_53090);

(statearr_53114_53146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (2))){
var _ = (function (){var statearr_53115 = state_53105;
(statearr_53115[(4)] = cljs.core.cons.call(null,(5),(state_53105[(4)])));

return statearr_53115;
})();
var inst_53054 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_53105__$1 = state_53105;
if(inst_53054){
var statearr_53116_53147 = state_53105__$1;
(statearr_53116_53147[(1)] = (6));

} else {
var statearr_53117_53148 = state_53105__$1;
(statearr_53117_53148[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (19))){
var inst_53075 = (state_53105[(10)]);
var inst_53083 = (state_53105[(2)]);
var inst_53084 = [f,inst_53083];
var inst_53085 = (new cljs.core.PersistentVector(null,2,(5),inst_53075,inst_53084,null));
var state_53105__$1 = state_53105;
var statearr_53118_53149 = state_53105__$1;
(statearr_53118_53149[(2)] = inst_53085);

(statearr_53118_53149[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (11))){
var inst_53075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53076 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_53105__$1 = (function (){var statearr_53120 = state_53105;
(statearr_53120[(10)] = inst_53075);

return statearr_53120;
})();
if(inst_53076){
var statearr_53121_53150 = state_53105__$1;
(statearr_53121_53150[(1)] = (17));

} else {
var statearr_53122_53151 = state_53105__$1;
(statearr_53122_53151[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (9))){
var inst_53057 = (state_53105[(2)]);
var inst_53058 = fluree.db.util.async.throw_err.call(null,inst_53057);
var state_53105__$1 = state_53105;
var statearr_53123_53152 = state_53105__$1;
(statearr_53123_53152[(2)] = inst_53058);

(statearr_53123_53152[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (5))){
var _ = (function (){var statearr_53124 = state_53105;
(statearr_53124[(4)] = cljs.core.rest.call(null,(state_53105[(4)])));

return statearr_53124;
})();
var state_53105__$1 = state_53105;
var ex53119 = (state_53105__$1[(2)]);
var statearr_53125_53153 = state_53105__$1;
(statearr_53125_53153[(5)] = ex53119);


if((ex53119 instanceof Error)){
var statearr_53126_53154 = state_53105__$1;
(statearr_53126_53154[(1)] = (4));

(statearr_53126_53154[(5)] = null);

} else {
throw ex53119;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (14))){
var state_53105__$1 = state_53105;
var statearr_53127_53155 = state_53105__$1;
(statearr_53127_53155[(2)] = t);

(statearr_53127_53155[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (16))){
var inst_53067 = (state_53105[(2)]);
var inst_53068 = fluree.db.util.async.throw_err.call(null,inst_53067);
var state_53105__$1 = state_53105;
var statearr_53128_53156 = state_53105__$1;
(statearr_53128_53156[(2)] = inst_53068);

(statearr_53128_53156[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (10))){
var inst_53063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53064 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_53105__$1 = (function (){var statearr_53129 = state_53105;
(statearr_53129[(7)] = inst_53063);

return statearr_53129;
})();
if(inst_53064){
var statearr_53130_53157 = state_53105__$1;
(statearr_53130_53157[(1)] = (13));

} else {
var statearr_53131_53158 = state_53105__$1;
(statearr_53131_53158[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (18))){
var state_53105__$1 = state_53105;
var statearr_53132_53159 = state_53105__$1;
(statearr_53132_53159[(2)] = f);

(statearr_53132_53159[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53106 === (8))){
var inst_53061 = (state_53105[(8)]);
var inst_53061__$1 = (state_53105[(2)]);
var state_53105__$1 = (function (){var statearr_53133 = state_53105;
(statearr_53133[(8)] = inst_53061__$1);

return statearr_53133;
})();
if(cljs.core.truth_(inst_53061__$1)){
var statearr_53134_53160 = state_53105__$1;
(statearr_53134_53160[(1)] = (10));

} else {
var statearr_53135_53161 = state_53105__$1;
(statearr_53135_53161[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0 = (function (){
var statearr_53136 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_53136[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__);

(statearr_53136[(1)] = (1));

return statearr_53136;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1 = (function (state_53105){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53105);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53137){var ex__2749__auto__ = e53137;
var statearr_53138_53162 = state_53105;
(statearr_53138_53162[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53105[(4)]))){
var statearr_53139_53163 = state_53105;
(statearr_53139_53163[(1)] = cljs.core.first.call(null,(state_53105[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53164 = state_53105;
state_53105 = G__53164;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__ = function(state_53105){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1.call(this,state_53105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53140 = f__2769__auto__.call(null);
(statearr_53140[(6)] = c__2768__auto__);

return statearr_53140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53194){
var state_val_53195 = (state_53194[(1)]);
if((state_val_53195 === (7))){
var state_53194__$1 = state_53194;
var statearr_53196_53215 = state_53194__$1;
(statearr_53196_53215[(2)] = arg);

(statearr_53196_53215[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53195 === (1))){
var state_53194__$1 = state_53194;
var statearr_53197_53216 = state_53194__$1;
(statearr_53197_53216[(2)] = null);

(statearr_53197_53216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53195 === (4))){
var inst_53165 = (state_53194[(2)]);
var state_53194__$1 = state_53194;
var statearr_53198_53217 = state_53194__$1;
(statearr_53198_53217[(2)] = inst_53165);

(statearr_53198_53217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53195 === (6))){
var state_53194__$1 = state_53194;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53194__$1,(9),arg);
} else {
if((state_val_53195 === (3))){
var inst_53192 = (state_53194[(2)]);
var state_53194__$1 = state_53194;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53194__$1,inst_53192);
} else {
if((state_val_53195 === (2))){
var _ = (function (){var statearr_53200 = state_53194;
(statearr_53200[(4)] = cljs.core.cons.call(null,(5),(state_53194[(4)])));

return statearr_53200;
})();
var inst_53171 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_53194__$1 = state_53194;
if(inst_53171){
var statearr_53201_53218 = state_53194__$1;
(statearr_53201_53218[(1)] = (6));

} else {
var statearr_53202_53219 = state_53194__$1;
(statearr_53202_53219[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53195 === (9))){
var inst_53174 = (state_53194[(2)]);
var inst_53175 = fluree.db.util.async.throw_err.call(null,inst_53174);
var state_53194__$1 = state_53194;
var statearr_53203_53220 = state_53194__$1;
(statearr_53203_53220[(2)] = inst_53175);

(statearr_53203_53220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53195 === (5))){
var _ = (function (){var statearr_53204 = state_53194;
(statearr_53204[(4)] = cljs.core.rest.call(null,(state_53194[(4)])));

return statearr_53204;
})();
var state_53194__$1 = state_53194;
var ex53199 = (state_53194__$1[(2)]);
var statearr_53205_53221 = state_53194__$1;
(statearr_53205_53221[(5)] = ex53199);


if((ex53199 instanceof Error)){
var statearr_53206_53222 = state_53194__$1;
(statearr_53206_53222[(1)] = (4));

(statearr_53206_53222[(5)] = null);

} else {
throw ex53199;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53195 === (8))){
var inst_53178 = (state_53194[(2)]);
var inst_53179 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_53178);
var inst_53180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53181 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53183 = [inst_53178];
var inst_53184 = (new cljs.core.PersistentVector(null,1,(5),inst_53182,inst_53183,null));
var inst_53185 = ["nil?",inst_53184,inst_53179];
var inst_53186 = cljs.core.PersistentHashMap.fromArrays(inst_53181,inst_53185);
var inst_53187 = [inst_53186,(10)];
var inst_53188 = (new cljs.core.PersistentVector(null,2,(5),inst_53180,inst_53187,null));
var inst_53189 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53188);
var _ = (function (){var statearr_53207 = state_53194;
(statearr_53207[(4)] = cljs.core.rest.call(null,(state_53194[(4)])));

return statearr_53207;
})();
var state_53194__$1 = (function (){var statearr_53208 = state_53194;
(statearr_53208[(7)] = inst_53189);

return statearr_53208;
})();
var statearr_53209_53223 = state_53194__$1;
(statearr_53209_53223[(2)] = inst_53179);

(statearr_53209_53223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_53210 = [null,null,null,null,null,null,null,null];
(statearr_53210[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__);

(statearr_53210[(1)] = (1));

return statearr_53210;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1 = (function (state_53194){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53194);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53211){var ex__2749__auto__ = e53211;
var statearr_53212_53224 = state_53194;
(statearr_53212_53224[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53194[(4)]))){
var statearr_53213_53225 = state_53194;
(statearr_53213_53225[(1)] = cljs.core.first.call(null,(state_53194[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53226 = state_53194;
state_53194 = G__53226;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__ = function(state_53194){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1.call(this,state_53194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53214 = f__2769__auto__.call(null);
(statearr_53214[(6)] = c__2768__auto__);

return statearr_53214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53256){
var state_val_53257 = (state_53256[(1)]);
if((state_val_53257 === (7))){
var state_53256__$1 = state_53256;
var statearr_53258_53277 = state_53256__$1;
(statearr_53258_53277[(2)] = arg);

(statearr_53258_53277[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53257 === (1))){
var state_53256__$1 = state_53256;
var statearr_53259_53278 = state_53256__$1;
(statearr_53259_53278[(2)] = null);

(statearr_53259_53278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53257 === (4))){
var inst_53227 = (state_53256[(2)]);
var state_53256__$1 = state_53256;
var statearr_53260_53279 = state_53256__$1;
(statearr_53260_53279[(2)] = inst_53227);

(statearr_53260_53279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53257 === (6))){
var state_53256__$1 = state_53256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53256__$1,(9),arg);
} else {
if((state_val_53257 === (3))){
var inst_53254 = (state_53256[(2)]);
var state_53256__$1 = state_53256;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53256__$1,inst_53254);
} else {
if((state_val_53257 === (2))){
var _ = (function (){var statearr_53262 = state_53256;
(statearr_53262[(4)] = cljs.core.cons.call(null,(5),(state_53256[(4)])));

return statearr_53262;
})();
var inst_53233 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_53256__$1 = state_53256;
if(inst_53233){
var statearr_53263_53280 = state_53256__$1;
(statearr_53263_53280[(1)] = (6));

} else {
var statearr_53264_53281 = state_53256__$1;
(statearr_53264_53281[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53257 === (9))){
var inst_53236 = (state_53256[(2)]);
var inst_53237 = fluree.db.util.async.throw_err.call(null,inst_53236);
var state_53256__$1 = state_53256;
var statearr_53265_53282 = state_53256__$1;
(statearr_53265_53282[(2)] = inst_53237);

(statearr_53265_53282[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53257 === (5))){
var _ = (function (){var statearr_53266 = state_53256;
(statearr_53266[(4)] = cljs.core.rest.call(null,(state_53256[(4)])));

return statearr_53266;
})();
var state_53256__$1 = state_53256;
var ex53261 = (state_53256__$1[(2)]);
var statearr_53267_53283 = state_53256__$1;
(statearr_53267_53283[(5)] = ex53261);


if((ex53261 instanceof Error)){
var statearr_53268_53284 = state_53256__$1;
(statearr_53268_53284[(1)] = (4));

(statearr_53268_53284[(5)] = null);

} else {
throw ex53261;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53257 === (8))){
var inst_53240 = (state_53256[(2)]);
var inst_53241 = fluree.db.dbfunctions.internal.not.call(null,inst_53240);
var inst_53242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53243 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53245 = [inst_53240];
var inst_53246 = (new cljs.core.PersistentVector(null,1,(5),inst_53244,inst_53245,null));
var inst_53247 = ["not",inst_53246,inst_53241];
var inst_53248 = cljs.core.PersistentHashMap.fromArrays(inst_53243,inst_53247);
var inst_53249 = [inst_53248,(10)];
var inst_53250 = (new cljs.core.PersistentVector(null,2,(5),inst_53242,inst_53249,null));
var inst_53251 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53250);
var _ = (function (){var statearr_53269 = state_53256;
(statearr_53269[(4)] = cljs.core.rest.call(null,(state_53256[(4)])));

return statearr_53269;
})();
var state_53256__$1 = (function (){var statearr_53270 = state_53256;
(statearr_53270[(7)] = inst_53251);

return statearr_53270;
})();
var statearr_53271_53285 = state_53256__$1;
(statearr_53271_53285[(2)] = inst_53241);

(statearr_53271_53285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0 = (function (){
var statearr_53272 = [null,null,null,null,null,null,null,null];
(statearr_53272[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__);

(statearr_53272[(1)] = (1));

return statearr_53272;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1 = (function (state_53256){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53256);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53273){var ex__2749__auto__ = e53273;
var statearr_53274_53286 = state_53256;
(statearr_53274_53286[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53256[(4)]))){
var statearr_53275_53287 = state_53256;
(statearr_53275_53287[(1)] = cljs.core.first.call(null,(state_53256[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53288 = state_53256;
state_53256 = G__53288;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__ = function(state_53256){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1.call(this,state_53256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53276 = f__2769__auto__.call(null);
(statearr_53276[(6)] = c__2768__auto__);

return statearr_53276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53318){
var state_val_53319 = (state_53318[(1)]);
if((state_val_53319 === (7))){
var state_53318__$1 = state_53318;
var statearr_53320_53339 = state_53318__$1;
(statearr_53320_53339[(2)] = arg);

(statearr_53320_53339[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53319 === (1))){
var state_53318__$1 = state_53318;
var statearr_53321_53340 = state_53318__$1;
(statearr_53321_53340[(2)] = null);

(statearr_53321_53340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53319 === (4))){
var inst_53289 = (state_53318[(2)]);
var state_53318__$1 = state_53318;
var statearr_53322_53341 = state_53318__$1;
(statearr_53322_53341[(2)] = inst_53289);

(statearr_53322_53341[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53319 === (6))){
var state_53318__$1 = state_53318;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53318__$1,(9),arg);
} else {
if((state_val_53319 === (3))){
var inst_53316 = (state_53318[(2)]);
var state_53318__$1 = state_53318;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53318__$1,inst_53316);
} else {
if((state_val_53319 === (2))){
var _ = (function (){var statearr_53324 = state_53318;
(statearr_53324[(4)] = cljs.core.cons.call(null,(5),(state_53318[(4)])));

return statearr_53324;
})();
var inst_53295 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_53318__$1 = state_53318;
if(inst_53295){
var statearr_53325_53342 = state_53318__$1;
(statearr_53325_53342[(1)] = (6));

} else {
var statearr_53326_53343 = state_53318__$1;
(statearr_53326_53343[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53319 === (9))){
var inst_53298 = (state_53318[(2)]);
var inst_53299 = fluree.db.util.async.throw_err.call(null,inst_53298);
var state_53318__$1 = state_53318;
var statearr_53327_53344 = state_53318__$1;
(statearr_53327_53344[(2)] = inst_53299);

(statearr_53327_53344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53319 === (5))){
var _ = (function (){var statearr_53328 = state_53318;
(statearr_53328[(4)] = cljs.core.rest.call(null,(state_53318[(4)])));

return statearr_53328;
})();
var state_53318__$1 = state_53318;
var ex53323 = (state_53318__$1[(2)]);
var statearr_53329_53345 = state_53318__$1;
(statearr_53329_53345[(5)] = ex53323);


if((ex53323 instanceof Error)){
var statearr_53330_53346 = state_53318__$1;
(statearr_53330_53346[(1)] = (4));

(statearr_53330_53346[(5)] = null);

} else {
throw ex53323;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53319 === (8))){
var inst_53302 = (state_53318[(2)]);
var inst_53303 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_53302);
var inst_53304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53305 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53307 = [inst_53302];
var inst_53308 = (new cljs.core.PersistentVector(null,1,(5),inst_53306,inst_53307,null));
var inst_53309 = ["empty?",inst_53308,inst_53303];
var inst_53310 = cljs.core.PersistentHashMap.fromArrays(inst_53305,inst_53309);
var inst_53311 = [inst_53310,(10)];
var inst_53312 = (new cljs.core.PersistentVector(null,2,(5),inst_53304,inst_53311,null));
var inst_53313 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53312);
var _ = (function (){var statearr_53331 = state_53318;
(statearr_53331[(4)] = cljs.core.rest.call(null,(state_53318[(4)])));

return statearr_53331;
})();
var state_53318__$1 = (function (){var statearr_53332 = state_53318;
(statearr_53332[(7)] = inst_53313);

return statearr_53332;
})();
var statearr_53333_53347 = state_53318__$1;
(statearr_53333_53347[(2)] = inst_53303);

(statearr_53333_53347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_53334 = [null,null,null,null,null,null,null,null];
(statearr_53334[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__);

(statearr_53334[(1)] = (1));

return statearr_53334;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1 = (function (state_53318){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53318);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53335){var ex__2749__auto__ = e53335;
var statearr_53336_53348 = state_53318;
(statearr_53336_53348[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53318[(4)]))){
var statearr_53337_53349 = state_53318;
(statearr_53337_53349[(1)] = cljs.core.first.call(null,(state_53318[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53350 = state_53318;
state_53318 = G__53350;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__ = function(state_53318){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1.call(this,state_53318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53338 = f__2769__auto__.call(null);
(statearr_53338[(6)] = c__2768__auto__);

return statearr_53338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53395 = arguments.length;
var i__4865__auto___53396 = (0);
while(true){
if((i__4865__auto___53396 < len__4864__auto___53395)){
args__4870__auto__.push((arguments[i__4865__auto___53396]));

var G__53397 = (i__4865__auto___53396 + (1));
i__4865__auto___53396 = G__53397;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53378){
var state_val_53379 = (state_53378[(1)]);
if((state_val_53379 === (1))){
var state_53378__$1 = state_53378;
var statearr_53380_53398 = state_53378__$1;
(statearr_53380_53398[(2)] = null);

(statearr_53380_53398[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53379 === (2))){
var _ = (function (){var statearr_53381 = state_53378;
(statearr_53381[(4)] = cljs.core.cons.call(null,(5),(state_53378[(4)])));

return statearr_53381;
})();
var inst_53359 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53378__$1 = state_53378;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53378__$1,(6),inst_53359);
} else {
if((state_val_53379 === (3))){
var inst_53376 = (state_53378[(2)]);
var state_53378__$1 = state_53378;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53378__$1,inst_53376);
} else {
if((state_val_53379 === (4))){
var inst_53353 = (state_53378[(2)]);
var state_53378__$1 = state_53378;
var statearr_53383_53399 = state_53378__$1;
(statearr_53383_53399[(2)] = inst_53353);

(statearr_53383_53399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53379 === (5))){
var _ = (function (){var statearr_53384 = state_53378;
(statearr_53384[(4)] = cljs.core.rest.call(null,(state_53378[(4)])));

return statearr_53384;
})();
var state_53378__$1 = state_53378;
var ex53382 = (state_53378__$1[(2)]);
var statearr_53385_53400 = state_53378__$1;
(statearr_53385_53400[(5)] = ex53382);


if((ex53382 instanceof Error)){
var statearr_53386_53401 = state_53378__$1;
(statearr_53386_53401[(1)] = (4));

(statearr_53386_53401[(5)] = null);

} else {
throw ex53382;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53379 === (6))){
var inst_53361 = (state_53378[(2)]);
var inst_53362 = fluree.db.util.async.throw_err.call(null,inst_53361);
var inst_53363 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_53362);
var inst_53364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53365 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53367 = [inst_53362];
var inst_53368 = (new cljs.core.PersistentVector(null,1,(5),inst_53366,inst_53367,null));
var inst_53369 = ["str",inst_53368,inst_53363];
var inst_53370 = cljs.core.PersistentHashMap.fromArrays(inst_53365,inst_53369);
var inst_53371 = [inst_53370,(10)];
var inst_53372 = (new cljs.core.PersistentVector(null,2,(5),inst_53364,inst_53371,null));
var inst_53373 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53372);
var _ = (function (){var statearr_53387 = state_53378;
(statearr_53387[(4)] = cljs.core.rest.call(null,(state_53378[(4)])));

return statearr_53387;
})();
var state_53378__$1 = (function (){var statearr_53388 = state_53378;
(statearr_53388[(7)] = inst_53373);

return statearr_53388;
})();
var statearr_53389_53402 = state_53378__$1;
(statearr_53389_53402[(2)] = inst_53363);

(statearr_53389_53402[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_53390 = [null,null,null,null,null,null,null,null];
(statearr_53390[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_53390[(1)] = (1));

return statearr_53390;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_53378){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53378);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53391){var ex__2749__auto__ = e53391;
var statearr_53392_53403 = state_53378;
(statearr_53392_53403[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53378[(4)]))){
var statearr_53393_53404 = state_53378;
(statearr_53393_53404[(1)] = cljs.core.first.call(null,(state_53378[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53405 = state_53378;
state_53378 = G__53405;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_53378){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_53378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53394 = f__2769__auto__.call(null);
(statearr_53394[(6)] = c__2768__auto__);

return statearr_53394;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq53351){
var G__53352 = cljs.core.first.call(null,seq53351);
var seq53351__$1 = cljs.core.next.call(null,seq53351);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53352,seq53351__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53431){
var state_val_53432 = (state_53431[(1)]);
if((state_val_53432 === (1))){
var state_53431__$1 = state_53431;
var statearr_53433_53448 = state_53431__$1;
(statearr_53433_53448[(2)] = null);

(statearr_53433_53448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53432 === (2))){
var _ = (function (){var statearr_53434 = state_53431;
(statearr_53434[(4)] = cljs.core.cons.call(null,(5),(state_53431[(4)])));

return statearr_53434;
})();
var inst_53412 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53431__$1 = state_53431;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53431__$1,(6),inst_53412);
} else {
if((state_val_53432 === (3))){
var inst_53429 = (state_53431[(2)]);
var state_53431__$1 = state_53431;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53431__$1,inst_53429);
} else {
if((state_val_53432 === (4))){
var inst_53406 = (state_53431[(2)]);
var state_53431__$1 = state_53431;
var statearr_53436_53449 = state_53431__$1;
(statearr_53436_53449[(2)] = inst_53406);

(statearr_53436_53449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53432 === (5))){
var _ = (function (){var statearr_53437 = state_53431;
(statearr_53437[(4)] = cljs.core.rest.call(null,(state_53431[(4)])));

return statearr_53437;
})();
var state_53431__$1 = state_53431;
var ex53435 = (state_53431__$1[(2)]);
var statearr_53438_53450 = state_53431__$1;
(statearr_53438_53450[(5)] = ex53435);


if((ex53435 instanceof Error)){
var statearr_53439_53451 = state_53431__$1;
(statearr_53439_53451[(1)] = (4));

(statearr_53439_53451[(5)] = null);

} else {
throw ex53435;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53432 === (6))){
var inst_53414 = (state_53431[(2)]);
var inst_53415 = fluree.db.util.async.throw_err.call(null,inst_53414);
var inst_53416 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_53415);
var inst_53417 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53418 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53420 = [inst_53415];
var inst_53421 = (new cljs.core.PersistentVector(null,1,(5),inst_53419,inst_53420,null));
var inst_53422 = ["subs",inst_53421,inst_53416];
var inst_53423 = cljs.core.PersistentHashMap.fromArrays(inst_53418,inst_53422);
var inst_53424 = [inst_53423,(30)];
var inst_53425 = (new cljs.core.PersistentVector(null,2,(5),inst_53417,inst_53424,null));
var inst_53426 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53425);
var _ = (function (){var statearr_53440 = state_53431;
(statearr_53440[(4)] = cljs.core.rest.call(null,(state_53431[(4)])));

return statearr_53440;
})();
var state_53431__$1 = (function (){var statearr_53441 = state_53431;
(statearr_53441[(7)] = inst_53426);

return statearr_53441;
})();
var statearr_53442_53452 = state_53431__$1;
(statearr_53442_53452[(2)] = inst_53416);

(statearr_53442_53452[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0 = (function (){
var statearr_53443 = [null,null,null,null,null,null,null,null];
(statearr_53443[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__);

(statearr_53443[(1)] = (1));

return statearr_53443;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1 = (function (state_53431){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53431);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53444){var ex__2749__auto__ = e53444;
var statearr_53445_53453 = state_53431;
(statearr_53445_53453[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53431[(4)]))){
var statearr_53446_53454 = state_53431;
(statearr_53446_53454[(1)] = cljs.core.first.call(null,(state_53431[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53455 = state_53431;
state_53431 = G__53455;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__ = function(state_53431){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1.call(this,state_53431);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53447 = f__2769__auto__.call(null);
(statearr_53447[(6)] = c__2768__auto__);

return statearr_53447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53485){
var state_val_53486 = (state_53485[(1)]);
if((state_val_53486 === (7))){
var state_53485__$1 = state_53485;
var statearr_53487_53506 = state_53485__$1;
(statearr_53487_53506[(2)] = str);

(statearr_53487_53506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (1))){
var state_53485__$1 = state_53485;
var statearr_53488_53507 = state_53485__$1;
(statearr_53488_53507[(2)] = null);

(statearr_53488_53507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (4))){
var inst_53456 = (state_53485[(2)]);
var state_53485__$1 = state_53485;
var statearr_53489_53508 = state_53485__$1;
(statearr_53489_53508[(2)] = inst_53456);

(statearr_53489_53508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (6))){
var state_53485__$1 = state_53485;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53485__$1,(9),str);
} else {
if((state_val_53486 === (3))){
var inst_53483 = (state_53485[(2)]);
var state_53485__$1 = state_53485;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53485__$1,inst_53483);
} else {
if((state_val_53486 === (2))){
var _ = (function (){var statearr_53491 = state_53485;
(statearr_53491[(4)] = cljs.core.cons.call(null,(5),(state_53485[(4)])));

return statearr_53491;
})();
var inst_53462 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_53485__$1 = state_53485;
if(inst_53462){
var statearr_53492_53509 = state_53485__$1;
(statearr_53492_53509[(1)] = (6));

} else {
var statearr_53493_53510 = state_53485__$1;
(statearr_53493_53510[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (9))){
var inst_53465 = (state_53485[(2)]);
var inst_53466 = fluree.db.util.async.throw_err.call(null,inst_53465);
var state_53485__$1 = state_53485;
var statearr_53494_53511 = state_53485__$1;
(statearr_53494_53511[(2)] = inst_53466);

(statearr_53494_53511[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (5))){
var _ = (function (){var statearr_53495 = state_53485;
(statearr_53495[(4)] = cljs.core.rest.call(null,(state_53485[(4)])));

return statearr_53495;
})();
var state_53485__$1 = state_53485;
var ex53490 = (state_53485__$1[(2)]);
var statearr_53496_53512 = state_53485__$1;
(statearr_53496_53512[(5)] = ex53490);


if((ex53490 instanceof Error)){
var statearr_53497_53513 = state_53485__$1;
(statearr_53497_53513[(1)] = (4));

(statearr_53497_53513[(5)] = null);

} else {
throw ex53490;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53486 === (8))){
var inst_53469 = (state_53485[(2)]);
var inst_53470 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_53469);
var inst_53471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53472 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53474 = [inst_53469];
var inst_53475 = (new cljs.core.PersistentVector(null,1,(5),inst_53473,inst_53474,null));
var inst_53476 = ["lower-case",inst_53475,inst_53470];
var inst_53477 = cljs.core.PersistentHashMap.fromArrays(inst_53472,inst_53476);
var inst_53478 = [inst_53477,(10)];
var inst_53479 = (new cljs.core.PersistentVector(null,2,(5),inst_53471,inst_53478,null));
var inst_53480 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53479);
var _ = (function (){var statearr_53498 = state_53485;
(statearr_53498[(4)] = cljs.core.rest.call(null,(state_53485[(4)])));

return statearr_53498;
})();
var state_53485__$1 = (function (){var statearr_53499 = state_53485;
(statearr_53499[(7)] = inst_53480);

return statearr_53499;
})();
var statearr_53500_53514 = state_53485__$1;
(statearr_53500_53514[(2)] = inst_53470);

(statearr_53500_53514[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0 = (function (){
var statearr_53501 = [null,null,null,null,null,null,null,null];
(statearr_53501[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__);

(statearr_53501[(1)] = (1));

return statearr_53501;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1 = (function (state_53485){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53485);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53502){var ex__2749__auto__ = e53502;
var statearr_53503_53515 = state_53485;
(statearr_53503_53515[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53485[(4)]))){
var statearr_53504_53516 = state_53485;
(statearr_53504_53516[(1)] = cljs.core.first.call(null,(state_53485[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53517 = state_53485;
state_53485 = G__53517;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__ = function(state_53485){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1.call(this,state_53485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53505 = f__2769__auto__.call(null);
(statearr_53505[(6)] = c__2768__auto__);

return statearr_53505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53547){
var state_val_53548 = (state_53547[(1)]);
if((state_val_53548 === (7))){
var state_53547__$1 = state_53547;
var statearr_53549_53568 = state_53547__$1;
(statearr_53549_53568[(2)] = str);

(statearr_53549_53568[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53548 === (1))){
var state_53547__$1 = state_53547;
var statearr_53550_53569 = state_53547__$1;
(statearr_53550_53569[(2)] = null);

(statearr_53550_53569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53548 === (4))){
var inst_53518 = (state_53547[(2)]);
var state_53547__$1 = state_53547;
var statearr_53551_53570 = state_53547__$1;
(statearr_53551_53570[(2)] = inst_53518);

(statearr_53551_53570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53548 === (6))){
var state_53547__$1 = state_53547;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53547__$1,(9),str);
} else {
if((state_val_53548 === (3))){
var inst_53545 = (state_53547[(2)]);
var state_53547__$1 = state_53547;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53547__$1,inst_53545);
} else {
if((state_val_53548 === (2))){
var _ = (function (){var statearr_53553 = state_53547;
(statearr_53553[(4)] = cljs.core.cons.call(null,(5),(state_53547[(4)])));

return statearr_53553;
})();
var inst_53524 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_53547__$1 = state_53547;
if(inst_53524){
var statearr_53554_53571 = state_53547__$1;
(statearr_53554_53571[(1)] = (6));

} else {
var statearr_53555_53572 = state_53547__$1;
(statearr_53555_53572[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53548 === (9))){
var inst_53527 = (state_53547[(2)]);
var inst_53528 = fluree.db.util.async.throw_err.call(null,inst_53527);
var state_53547__$1 = state_53547;
var statearr_53556_53573 = state_53547__$1;
(statearr_53556_53573[(2)] = inst_53528);

(statearr_53556_53573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53548 === (5))){
var _ = (function (){var statearr_53557 = state_53547;
(statearr_53557[(4)] = cljs.core.rest.call(null,(state_53547[(4)])));

return statearr_53557;
})();
var state_53547__$1 = state_53547;
var ex53552 = (state_53547__$1[(2)]);
var statearr_53558_53574 = state_53547__$1;
(statearr_53558_53574[(5)] = ex53552);


if((ex53552 instanceof Error)){
var statearr_53559_53575 = state_53547__$1;
(statearr_53559_53575[(1)] = (4));

(statearr_53559_53575[(5)] = null);

} else {
throw ex53552;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53548 === (8))){
var inst_53531 = (state_53547[(2)]);
var inst_53532 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_53531);
var inst_53533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53534 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53536 = [inst_53531];
var inst_53537 = (new cljs.core.PersistentVector(null,1,(5),inst_53535,inst_53536,null));
var inst_53538 = ["upper-case",inst_53537,inst_53532];
var inst_53539 = cljs.core.PersistentHashMap.fromArrays(inst_53534,inst_53538);
var inst_53540 = [inst_53539,(10)];
var inst_53541 = (new cljs.core.PersistentVector(null,2,(5),inst_53533,inst_53540,null));
var inst_53542 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53541);
var _ = (function (){var statearr_53560 = state_53547;
(statearr_53560[(4)] = cljs.core.rest.call(null,(state_53547[(4)])));

return statearr_53560;
})();
var state_53547__$1 = (function (){var statearr_53561 = state_53547;
(statearr_53561[(7)] = inst_53542);

return statearr_53561;
})();
var statearr_53562_53576 = state_53547__$1;
(statearr_53562_53576[(2)] = inst_53532);

(statearr_53562_53576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0 = (function (){
var statearr_53563 = [null,null,null,null,null,null,null,null];
(statearr_53563[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__);

(statearr_53563[(1)] = (1));

return statearr_53563;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1 = (function (state_53547){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53547);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53564){var ex__2749__auto__ = e53564;
var statearr_53565_53577 = state_53547;
(statearr_53565_53577[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53547[(4)]))){
var statearr_53566_53578 = state_53547;
(statearr_53566_53578[(1)] = cljs.core.first.call(null,(state_53547[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53579 = state_53547;
state_53547 = G__53579;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__ = function(state_53547){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1.call(this,state_53547);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53567 = f__2769__auto__.call(null);
(statearr_53567[(6)] = c__2768__auto__);

return statearr_53567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4251__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4251__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__53581 = arguments.length;
switch (G__53581) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53609){
var state_val_53610 = (state_53609[(1)]);
if((state_val_53610 === (1))){
var state_53609__$1 = state_53609;
var statearr_53611_53627 = state_53609__$1;
(statearr_53611_53627[(2)] = null);

(statearr_53611_53627[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53610 === (2))){
var _ = (function (){var statearr_53612 = state_53609;
(statearr_53612[(4)] = cljs.core.cons.call(null,(5),(state_53609[(4)])));

return statearr_53612;
})();
var inst_53591 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_53609__$1 = state_53609;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53609__$1,(6),inst_53591);
} else {
if((state_val_53610 === (3))){
var inst_53607 = (state_53609[(2)]);
var state_53609__$1 = state_53609;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53609__$1,inst_53607);
} else {
if((state_val_53610 === (4))){
var inst_53582 = (state_53609[(2)]);
var state_53609__$1 = state_53609;
var statearr_53614_53628 = state_53609__$1;
(statearr_53614_53628[(2)] = inst_53582);

(statearr_53614_53628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53610 === (5))){
var _ = (function (){var statearr_53615 = state_53609;
(statearr_53615[(4)] = cljs.core.rest.call(null,(state_53609[(4)])));

return statearr_53615;
})();
var state_53609__$1 = state_53609;
var ex53613 = (state_53609__$1[(2)]);
var statearr_53616_53629 = state_53609__$1;
(statearr_53616_53629[(5)] = ex53613);


if((ex53613 instanceof Error)){
var statearr_53617_53630 = state_53609__$1;
(statearr_53617_53630[(1)] = (4));

(statearr_53617_53630[(5)] = null);

} else {
throw ex53613;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53610 === (6))){
var inst_53593 = (state_53609[(2)]);
var inst_53594 = fluree.db.util.async.throw_err.call(null,inst_53593);
var inst_53595 = cljs.core.nth.call(null,inst_53594,(0),null);
var inst_53596 = cljs.core.nth.call(null,inst_53594,(1),null);
var inst_53597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53598 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53599 = ["?s","?ctx",inst_53595];
var inst_53600 = cljs.core.PersistentHashMap.fromArrays(inst_53598,inst_53599);
var inst_53601 = ((10) + inst_53596);
var inst_53602 = [inst_53600,inst_53601];
var inst_53603 = (new cljs.core.PersistentVector(null,2,(5),inst_53597,inst_53602,null));
var inst_53604 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53603);
var _ = (function (){var statearr_53618 = state_53609;
(statearr_53618[(4)] = cljs.core.rest.call(null,(state_53609[(4)])));

return statearr_53618;
})();
var state_53609__$1 = (function (){var statearr_53619 = state_53609;
(statearr_53619[(7)] = inst_53604);

return statearr_53619;
})();
var statearr_53620_53631 = state_53609__$1;
(statearr_53620_53631[(2)] = inst_53595);

(statearr_53620_53631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_53621 = [null,null,null,null,null,null,null,null];
(statearr_53621[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_53621[(1)] = (1));

return statearr_53621;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_53609){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53609);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53622){var ex__2749__auto__ = e53622;
var statearr_53623_53632 = state_53609;
(statearr_53623_53632[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53609[(4)]))){
var statearr_53624_53633 = state_53609;
(statearr_53624_53633[(1)] = cljs.core.first.call(null,(state_53609[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53634 = state_53609;
state_53609 = G__53634;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_53609){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_53609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53625 = f__2769__auto__.call(null);
(statearr_53625[(6)] = c__2768__auto__);

return statearr_53625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__53636 = arguments.length;
switch (G__53636) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53674){
var state_val_53675 = (state_53674[(1)]);
if((state_val_53675 === (7))){
var inst_53667 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_53674__$1 = state_53674;
var statearr_53676_53696 = state_53674__$1;
(statearr_53676_53696[(2)] = inst_53667);

(statearr_53676_53696[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53675 === (1))){
var state_53674__$1 = state_53674;
var statearr_53677_53697 = state_53674__$1;
(statearr_53677_53697[(2)] = null);

(statearr_53677_53697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53675 === (4))){
var inst_53637 = (state_53674[(2)]);
var state_53674__$1 = state_53674;
var statearr_53678_53698 = state_53674__$1;
(statearr_53678_53698[(2)] = inst_53637);

(statearr_53678_53698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53675 === (6))){
var inst_53648 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_53674__$1 = state_53674;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53674__$1,(10),inst_53648);
} else {
if((state_val_53675 === (3))){
var inst_53672 = (state_53674[(2)]);
var state_53674__$1 = state_53674;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53674__$1,inst_53672);
} else {
if((state_val_53675 === (2))){
var _ = (function (){var statearr_53680 = state_53674;
(statearr_53680[(4)] = cljs.core.cons.call(null,(5),(state_53674[(4)])));

return statearr_53680;
})();
var inst_53643 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_53674__$1 = state_53674;
if(cljs.core.truth_(inst_53643)){
var statearr_53681_53699 = state_53674__$1;
(statearr_53681_53699[(1)] = (6));

} else {
var statearr_53682_53700 = state_53674__$1;
(statearr_53682_53700[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53675 === (9))){
var inst_53654 = (state_53674[(2)]);
var inst_53655 = fluree.db.util.async.throw_err.call(null,inst_53654);
var inst_53656 = cljs.core.nth.call(null,inst_53655,(0),null);
var inst_53657 = cljs.core.nth.call(null,inst_53655,(1),null);
var inst_53658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53659 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53660 = ["?p","?ctx",inst_53656];
var inst_53661 = cljs.core.PersistentHashMap.fromArrays(inst_53659,inst_53660);
var inst_53662 = ((10) + inst_53657);
var inst_53663 = [inst_53661,inst_53662];
var inst_53664 = (new cljs.core.PersistentVector(null,2,(5),inst_53658,inst_53663,null));
var inst_53665 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53664);
var state_53674__$1 = (function (){var statearr_53683 = state_53674;
(statearr_53683[(7)] = inst_53665);

return statearr_53683;
})();
var statearr_53684_53701 = state_53674__$1;
(statearr_53684_53701[(2)] = inst_53656);

(statearr_53684_53701[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53675 === (5))){
var _ = (function (){var statearr_53685 = state_53674;
(statearr_53685[(4)] = cljs.core.rest.call(null,(state_53674[(4)])));

return statearr_53685;
})();
var state_53674__$1 = state_53674;
var ex53679 = (state_53674__$1[(2)]);
var statearr_53686_53702 = state_53674__$1;
(statearr_53686_53702[(5)] = ex53679);


if((ex53679 instanceof Error)){
var statearr_53687_53703 = state_53674__$1;
(statearr_53687_53703[(1)] = (4));

(statearr_53687_53703[(5)] = null);

} else {
throw ex53679;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53675 === (10))){
var inst_53650 = (state_53674[(2)]);
var inst_53651 = fluree.db.util.async.throw_err.call(null,inst_53650);
var inst_53652 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_53651);
var state_53674__$1 = state_53674;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53674__$1,(9),inst_53652);
} else {
if((state_val_53675 === (8))){
var inst_53669 = (state_53674[(2)]);
var _ = (function (){var statearr_53688 = state_53674;
(statearr_53688[(4)] = cljs.core.rest.call(null,(state_53674[(4)])));

return statearr_53688;
})();
var state_53674__$1 = state_53674;
var statearr_53689_53704 = state_53674__$1;
(statearr_53689_53704[(2)] = inst_53669);

(statearr_53689_53704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_53690 = [null,null,null,null,null,null,null,null];
(statearr_53690[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_53690[(1)] = (1));

return statearr_53690;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_53674){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53674);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53691){var ex__2749__auto__ = e53691;
var statearr_53692_53705 = state_53674;
(statearr_53692_53705[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53674[(4)]))){
var statearr_53693_53706 = state_53674;
(statearr_53693_53706[(1)] = cljs.core.first.call(null,(state_53674[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53707 = state_53674;
state_53674 = G__53707;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_53674){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_53674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53694 = f__2769__auto__.call(null);
(statearr_53694[(6)] = c__2768__auto__);

return statearr_53694;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53756 = arguments.length;
var i__4865__auto___53757 = (0);
while(true){
if((i__4865__auto___53757 < len__4864__auto___53756)){
args__4870__auto__.push((arguments[i__4865__auto___53757]));

var G__53758 = (i__4865__auto___53757 + (1));
i__4865__auto___53757 = G__53758;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53739){
var state_val_53740 = (state_53739[(1)]);
if((state_val_53740 === (1))){
var state_53739__$1 = state_53739;
var statearr_53741_53759 = state_53739__$1;
(statearr_53741_53759[(2)] = null);

(statearr_53741_53759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53740 === (2))){
var _ = (function (){var statearr_53742 = state_53739;
(statearr_53742[(4)] = cljs.core.cons.call(null,(5),(state_53739[(4)])));

return statearr_53742;
})();
var inst_53716 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53739__$1 = state_53739;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53739__$1,(6),inst_53716);
} else {
if((state_val_53740 === (3))){
var inst_53737 = (state_53739[(2)]);
var state_53739__$1 = state_53739;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53739__$1,inst_53737);
} else {
if((state_val_53740 === (4))){
var inst_53710 = (state_53739[(2)]);
var state_53739__$1 = state_53739;
var statearr_53744_53760 = state_53739__$1;
(statearr_53744_53760[(2)] = inst_53710);

(statearr_53744_53760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53740 === (5))){
var _ = (function (){var statearr_53745 = state_53739;
(statearr_53745[(4)] = cljs.core.rest.call(null,(state_53739[(4)])));

return statearr_53745;
})();
var state_53739__$1 = state_53739;
var ex53743 = (state_53739__$1[(2)]);
var statearr_53746_53761 = state_53739__$1;
(statearr_53746_53761[(5)] = ex53743);


if((ex53743 instanceof Error)){
var statearr_53747_53762 = state_53739__$1;
(statearr_53747_53762[(1)] = (4));

(statearr_53747_53762[(5)] = null);

} else {
throw ex53743;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53740 === (6))){
var inst_53718 = (state_53739[(2)]);
var inst_53719 = fluree.db.util.async.throw_err.call(null,inst_53718);
var inst_53720 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_53719);
var inst_53721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53722 = [inst_53719];
var inst_53723 = (new cljs.core.PersistentVector(null,1,(5),inst_53721,inst_53722,null));
var inst_53724 = cljs.core.count.call(null,inst_53723);
var inst_53725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53726 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53728 = [inst_53719];
var inst_53729 = (new cljs.core.PersistentVector(null,1,(5),inst_53727,inst_53728,null));
var inst_53730 = ["and",inst_53729,inst_53720];
var inst_53731 = cljs.core.PersistentHashMap.fromArrays(inst_53726,inst_53730);
var inst_53732 = [inst_53731,inst_53724];
var inst_53733 = (new cljs.core.PersistentVector(null,2,(5),inst_53725,inst_53732,null));
var inst_53734 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53733);
var _ = (function (){var statearr_53748 = state_53739;
(statearr_53748[(4)] = cljs.core.rest.call(null,(state_53739[(4)])));

return statearr_53748;
})();
var state_53739__$1 = (function (){var statearr_53749 = state_53739;
(statearr_53749[(7)] = inst_53734);

return statearr_53749;
})();
var statearr_53750_53763 = state_53739__$1;
(statearr_53750_53763[(2)] = inst_53720);

(statearr_53750_53763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_53751 = [null,null,null,null,null,null,null,null];
(statearr_53751[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_53751[(1)] = (1));

return statearr_53751;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_53739){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53739);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53752){var ex__2749__auto__ = e53752;
var statearr_53753_53764 = state_53739;
(statearr_53753_53764[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53739[(4)]))){
var statearr_53754_53765 = state_53739;
(statearr_53754_53765[(1)] = cljs.core.first.call(null,(state_53739[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53766 = state_53739;
state_53739 = G__53766;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_53739){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_53739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53755 = f__2769__auto__.call(null);
(statearr_53755[(6)] = c__2768__auto__);

return statearr_53755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq53708){
var G__53709 = cljs.core.first.call(null,seq53708);
var seq53708__$1 = cljs.core.next.call(null,seq53708);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53709,seq53708__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53815 = arguments.length;
var i__4865__auto___53816 = (0);
while(true){
if((i__4865__auto___53816 < len__4864__auto___53815)){
args__4870__auto__.push((arguments[i__4865__auto___53816]));

var G__53817 = (i__4865__auto___53816 + (1));
i__4865__auto___53816 = G__53817;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53798){
var state_val_53799 = (state_53798[(1)]);
if((state_val_53799 === (1))){
var state_53798__$1 = state_53798;
var statearr_53800_53818 = state_53798__$1;
(statearr_53800_53818[(2)] = null);

(statearr_53800_53818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53799 === (2))){
var _ = (function (){var statearr_53801 = state_53798;
(statearr_53801[(4)] = cljs.core.cons.call(null,(5),(state_53798[(4)])));

return statearr_53801;
})();
var inst_53775 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53798__$1 = state_53798;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53798__$1,(6),inst_53775);
} else {
if((state_val_53799 === (3))){
var inst_53796 = (state_53798[(2)]);
var state_53798__$1 = state_53798;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53798__$1,inst_53796);
} else {
if((state_val_53799 === (4))){
var inst_53769 = (state_53798[(2)]);
var state_53798__$1 = state_53798;
var statearr_53803_53819 = state_53798__$1;
(statearr_53803_53819[(2)] = inst_53769);

(statearr_53803_53819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53799 === (5))){
var _ = (function (){var statearr_53804 = state_53798;
(statearr_53804[(4)] = cljs.core.rest.call(null,(state_53798[(4)])));

return statearr_53804;
})();
var state_53798__$1 = state_53798;
var ex53802 = (state_53798__$1[(2)]);
var statearr_53805_53820 = state_53798__$1;
(statearr_53805_53820[(5)] = ex53802);


if((ex53802 instanceof Error)){
var statearr_53806_53821 = state_53798__$1;
(statearr_53806_53821[(1)] = (4));

(statearr_53806_53821[(5)] = null);

} else {
throw ex53802;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53799 === (6))){
var inst_53777 = (state_53798[(2)]);
var inst_53778 = fluree.db.util.async.throw_err.call(null,inst_53777);
var inst_53779 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_53778);
var inst_53780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53781 = [inst_53778];
var inst_53782 = (new cljs.core.PersistentVector(null,1,(5),inst_53780,inst_53781,null));
var inst_53783 = cljs.core.count.call(null,inst_53782);
var inst_53784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53785 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53787 = [inst_53778];
var inst_53788 = (new cljs.core.PersistentVector(null,1,(5),inst_53786,inst_53787,null));
var inst_53789 = ["or",inst_53788,inst_53779];
var inst_53790 = cljs.core.PersistentHashMap.fromArrays(inst_53785,inst_53789);
var inst_53791 = [inst_53790,inst_53783];
var inst_53792 = (new cljs.core.PersistentVector(null,2,(5),inst_53784,inst_53791,null));
var inst_53793 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53792);
var _ = (function (){var statearr_53807 = state_53798;
(statearr_53807[(4)] = cljs.core.rest.call(null,(state_53798[(4)])));

return statearr_53807;
})();
var state_53798__$1 = (function (){var statearr_53808 = state_53798;
(statearr_53808[(7)] = inst_53793);

return statearr_53808;
})();
var statearr_53809_53822 = state_53798__$1;
(statearr_53809_53822[(2)] = inst_53779);

(statearr_53809_53822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_53810 = [null,null,null,null,null,null,null,null];
(statearr_53810[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_53810[(1)] = (1));

return statearr_53810;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_53798){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53798);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53811){var ex__2749__auto__ = e53811;
var statearr_53812_53823 = state_53798;
(statearr_53812_53823[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53798[(4)]))){
var statearr_53813_53824 = state_53798;
(statearr_53813_53824[(1)] = cljs.core.first.call(null,(state_53798[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53825 = state_53798;
state_53798 = G__53825;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_53798){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_53798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53814 = f__2769__auto__.call(null);
(statearr_53814[(6)] = c__2768__auto__);

return statearr_53814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq53767){
var G__53768 = cljs.core.first.call(null,seq53767);
var seq53767__$1 = cljs.core.next.call(null,seq53767);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53768,seq53767__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53863){
var state_val_53864 = (state_53863[(1)]);
if((state_val_53864 === (7))){
var inst_53839 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_53863__$1 = state_53863;
if(inst_53839){
var statearr_53865_53888 = state_53863__$1;
(statearr_53865_53888[(1)] = (10));

} else {
var statearr_53866_53889 = state_53863__$1;
(statearr_53866_53889[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53864 === (1))){
var state_53863__$1 = state_53863;
var statearr_53867_53890 = state_53863__$1;
(statearr_53867_53890[(2)] = null);

(statearr_53867_53890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53864 === (4))){
var inst_53826 = (state_53863[(2)]);
var state_53863__$1 = state_53863;
var statearr_53868_53891 = state_53863__$1;
(statearr_53868_53891[(2)] = inst_53826);

(statearr_53868_53891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53864 === (13))){
var inst_53842 = (state_53863[(2)]);
var inst_53843 = fluree.db.util.async.throw_err.call(null,inst_53842);
var state_53863__$1 = state_53863;
var statearr_53869_53892 = state_53863__$1;
(statearr_53869_53892[(2)] = inst_53843);

(statearr_53869_53892[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53864 === (6))){
var inst_53834 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_53863__$1 = state_53863;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53863__$1,(9),inst_53834);
} else {
if((state_val_53864 === (3))){
var inst_53861 = (state_53863[(2)]);
var state_53863__$1 = state_53863;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53863__$1,inst_53861);
} else {
if((state_val_53864 === (12))){
var inst_53846 = (state_53863[(2)]);
var state_53863__$1 = state_53863;
var statearr_53870_53893 = state_53863__$1;
(statearr_53870_53893[(2)] = inst_53846);

(statearr_53870_53893[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53864 === (2))){
var _ = (function (){var statearr_53871 = state_53863;
(statearr_53871[(4)] = cljs.core.cons.call(null,(5),(state_53863[(4)])));

return statearr_53871;
})();
var inst_53832 = cljs.core.vector_QMARK_.call(null,coll);
var state_53863__$1 = state_53863;
if(inst_53832){
var statearr_53872_53894 = state_53863__$1;
(statearr_53872_53894[(1)] = (6));

} else {
var statearr_53873_53895 = state_53863__$1;
(statearr_53873_53895[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53864 === (11))){
var state_53863__$1 = state_53863;
var statearr_53875_53896 = state_53863__$1;
(statearr_53875_53896[(2)] = coll);

(statearr_53875_53896[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53864 === (9))){
var inst_53836 = (state_53863[(2)]);
var inst_53837 = fluree.db.util.async.throw_err.call(null,inst_53836);
var state_53863__$1 = state_53863;
var statearr_53876_53897 = state_53863__$1;
(statearr_53876_53897[(2)] = inst_53837);

(statearr_53876_53897[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53864 === (5))){
var _ = (function (){var statearr_53877 = state_53863;
(statearr_53877[(4)] = cljs.core.rest.call(null,(state_53863[(4)])));

return statearr_53877;
})();
var state_53863__$1 = state_53863;
var ex53874 = (state_53863__$1[(2)]);
var statearr_53878_53898 = state_53863__$1;
(statearr_53878_53898[(5)] = ex53874);


if((ex53874 instanceof Error)){
var statearr_53879_53899 = state_53863__$1;
(statearr_53879_53899[(1)] = (4));

(statearr_53879_53899[(5)] = null);

} else {
throw ex53874;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53864 === (10))){
var state_53863__$1 = state_53863;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53863__$1,(13),coll);
} else {
if((state_val_53864 === (8))){
var inst_53848 = (state_53863[(2)]);
var inst_53849 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_53848);
var inst_53850 = cljs.core.count.call(null,inst_53849);
var inst_53851 = ((9) + inst_53850);
var inst_53852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53853 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53854 = ["count",inst_53848,inst_53850];
var inst_53855 = cljs.core.PersistentHashMap.fromArrays(inst_53853,inst_53854);
var inst_53856 = [inst_53855,inst_53851];
var inst_53857 = (new cljs.core.PersistentVector(null,2,(5),inst_53852,inst_53856,null));
var inst_53858 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53857);
var _ = (function (){var statearr_53880 = state_53863;
(statearr_53880[(4)] = cljs.core.rest.call(null,(state_53863[(4)])));

return statearr_53880;
})();
var state_53863__$1 = (function (){var statearr_53881 = state_53863;
(statearr_53881[(7)] = inst_53858);

return statearr_53881;
})();
var statearr_53882_53900 = state_53863__$1;
(statearr_53882_53900[(2)] = inst_53850);

(statearr_53882_53900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0 = (function (){
var statearr_53883 = [null,null,null,null,null,null,null,null];
(statearr_53883[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__);

(statearr_53883[(1)] = (1));

return statearr_53883;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1 = (function (state_53863){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53863);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e53884){var ex__2749__auto__ = e53884;
var statearr_53885_53901 = state_53863;
(statearr_53885_53901[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53863[(4)]))){
var statearr_53886_53902 = state_53863;
(statearr_53886_53902[(1)] = cljs.core.first.call(null,(state_53863[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53903 = state_53863;
state_53863 = G__53903;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__ = function(state_53863){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1.call(this,state_53863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_53887 = f__2769__auto__.call(null);
(statearr_53887[(6)] = c__2768__auto__);

return statearr_53887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__53904,subject,pred){
var map__53905 = p__53904;
var map__53905__$1 = cljs.core.__destructure_map.call(null,map__53905);
var _QMARK_ctx = map__53905__$1;
var cache = cljs.core.get.call(null,map__53905__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.call(null,map__53905__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_53996){
var state_val_53997 = (state_53996[(1)]);
if((state_val_53997 === (7))){
var state_53996__$1 = state_53996;
var statearr_53998_54054 = state_53996__$1;
(statearr_53998_54054[(2)] = subject);

(statearr_53998_54054[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (20))){
var state_53996__$1 = state_53996;
var statearr_53999_54055 = state_53996__$1;
(statearr_53999_54055[(2)] = cache);

(statearr_53999_54055[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (27))){
var inst_53939 = (state_53996[(7)]);
var inst_53927 = (state_53996[(8)]);
var inst_53953 = fluree.db.dbfunctions.internal.get_subj_pred.call(null,db,inst_53939,inst_53927);
var state_53996__$1 = state_53996;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53996__$1,(29),inst_53953);
} else {
if((state_val_53997 === (1))){
var state_53996__$1 = state_53996;
var statearr_54000_54056 = state_53996__$1;
(statearr_54000_54056[(2)] = null);

(statearr_54000_54056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (24))){
var inst_53939 = (state_53996[(7)]);
var inst_53966 = cljs.core.int_QMARK_.call(null,inst_53939);
var state_53996__$1 = state_53996;
if(inst_53966){
var statearr_54001_54057 = state_53996__$1;
(statearr_54001_54057[(1)] = (30));

} else {
var statearr_54002_54058 = state_53996__$1;
(statearr_54002_54058[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (4))){
var inst_53906 = (state_53996[(2)]);
var state_53996__$1 = state_53996;
var statearr_54003_54059 = state_53996__$1;
(statearr_54003_54059[(2)] = inst_53906);

(statearr_54003_54059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (15))){
var inst_53919 = (state_53996[(9)]);
var state_53996__$1 = state_53996;
var statearr_54004_54060 = state_53996__$1;
(statearr_54004_54060[(2)] = inst_53919);

(statearr_54004_54060[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (21))){
var inst_53940 = (state_53996[(10)]);
var state_53996__$1 = state_53996;
var statearr_54005_54061 = state_53996__$1;
(statearr_54005_54061[(2)] = inst_53940);

(statearr_54005_54061[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (31))){
var state_53996__$1 = state_53996;
var statearr_54006_54062 = state_53996__$1;
(statearr_54006_54062[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (32))){
var inst_53979 = (state_53996[(2)]);
var state_53996__$1 = state_53996;
var statearr_54008_54063 = state_53996__$1;
(statearr_54008_54063[(2)] = inst_53979);

(statearr_54008_54063[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (33))){
var inst_53970 = (state_53996[(2)]);
var inst_53971 = fluree.db.util.async.throw_err.call(null,inst_53970);
var state_53996__$1 = state_53996;
var statearr_54009_54064 = state_53996__$1;
(statearr_54009_54064[(2)] = inst_53971);

(statearr_54009_54064[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (13))){
var inst_53923 = (state_53996[(2)]);
var inst_53924 = fluree.db.util.async.throw_err.call(null,inst_53923);
var state_53996__$1 = state_53996;
var statearr_54010_54065 = state_53996__$1;
(statearr_54010_54065[(2)] = inst_53924);

(statearr_54010_54065[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (22))){
var inst_53944 = (state_53996[(2)]);
var state_53996__$1 = state_53996;
if(cljs.core.truth_(inst_53944)){
var statearr_54011_54066 = state_53996__$1;
(statearr_54011_54066[(1)] = (23));

} else {
var statearr_54012_54067 = state_53996__$1;
(statearr_54012_54067[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (36))){
var inst_53977 = (state_53996[(2)]);
var state_53996__$1 = state_53996;
var statearr_54013_54068 = state_53996__$1;
(statearr_54013_54068[(2)] = inst_53977);

(statearr_54013_54068[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (29))){
var inst_53939 = (state_53996[(7)]);
var inst_53927 = (state_53996[(8)]);
var inst_53955 = (state_53996[(2)]);
var inst_53956 = fluree.db.util.async.throw_err.call(null,inst_53955);
var inst_53957 = cljs.core._deref.call(null,cache);
var inst_53958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53959 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_53939,inst_53927];
var inst_53960 = (new cljs.core.PersistentVector(null,3,(5),inst_53958,inst_53959,null));
var inst_53961 = cljs.core.assoc_in.call(null,inst_53957,inst_53960,inst_53956);
var inst_53962 = cljs.core._vreset_BANG_.call(null,cache,inst_53961);
var state_53996__$1 = (function (){var statearr_54014 = state_53996;
(statearr_54014[(11)] = inst_53962);

return statearr_54014;
})();
var statearr_54015_54069 = state_53996__$1;
(statearr_54015_54069[(2)] = inst_53956);

(statearr_54015_54069[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (6))){
var state_53996__$1 = state_53996;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53996__$1,(9),subject);
} else {
if((state_val_53997 === (28))){
var inst_53964 = (state_53996[(2)]);
var state_53996__$1 = state_53996;
var statearr_54016_54070 = state_53996__$1;
(statearr_54016_54070[(2)] = inst_53964);

(statearr_54016_54070[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (25))){
var inst_53927 = (state_53996[(8)]);
var inst_53919 = (state_53996[(9)]);
var inst_53981 = (state_53996[(2)]);
var inst_53982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53983 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53985 = [inst_53919,inst_53927];
var inst_53986 = (new cljs.core.PersistentVector(null,2,(5),inst_53984,inst_53985,null));
var inst_53987 = ["get",inst_53986,inst_53981];
var inst_53988 = cljs.core.PersistentHashMap.fromArrays(inst_53983,inst_53987);
var inst_53989 = [inst_53988,(10)];
var inst_53990 = (new cljs.core.PersistentVector(null,2,(5),inst_53982,inst_53989,null));
var inst_53991 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53990);
var _ = (function (){var statearr_54017 = state_53996;
(statearr_54017[(4)] = cljs.core.rest.call(null,(state_53996[(4)])));

return statearr_54017;
})();
var state_53996__$1 = (function (){var statearr_54018 = state_53996;
(statearr_54018[(12)] = inst_53991);

return statearr_54018;
})();
var statearr_54019_54071 = state_53996__$1;
(statearr_54019_54071[(2)] = inst_53981);

(statearr_54019_54071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (34))){
var inst_53939 = (state_53996[(7)]);
var inst_53927 = (state_53996[(8)]);
var inst_53974 = fluree.db.dbfunctions.internal.get.call(null,inst_53939,inst_53927);
var state_53996__$1 = state_53996;
var statearr_54020_54072 = state_53996__$1;
(statearr_54020_54072[(2)] = inst_53974);

(statearr_54020_54072[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (17))){
var inst_53919 = (state_53996[(9)]);
var inst_53933 = cljs.core.first.call(null,inst_53919);
var state_53996__$1 = state_53996;
var statearr_54021_54073 = state_53996__$1;
(statearr_54021_54073[(2)] = inst_53933);

(statearr_54021_54073[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (3))){
var inst_53994 = (state_53996[(2)]);
var state_53996__$1 = state_53996;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53996__$1,inst_53994);
} else {
if((state_val_53997 === (12))){
var inst_53919 = (state_53996[(9)]);
var inst_53927 = (state_53996[(2)]);
var inst_53928 = cljs.core.vector_QMARK_.call(null,inst_53919);
var state_53996__$1 = (function (){var statearr_54022 = state_53996;
(statearr_54022[(8)] = inst_53927);

return statearr_54022;
})();
if(inst_53928){
var statearr_54023_54074 = state_53996__$1;
(statearr_54023_54074[(1)] = (14));

} else {
var statearr_54024_54075 = state_53996__$1;
(statearr_54024_54075[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (2))){
var _ = (function (){var statearr_54025 = state_53996;
(statearr_54025[(4)] = cljs.core.cons.call(null,(5),(state_53996[(4)])));

return statearr_54025;
})();
var inst_53912 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_53996__$1 = state_53996;
if(inst_53912){
var statearr_54026_54076 = state_53996__$1;
(statearr_54026_54076[(1)] = (6));

} else {
var statearr_54027_54077 = state_53996__$1;
(statearr_54027_54077[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (23))){
var inst_53939 = (state_53996[(7)]);
var inst_53927 = (state_53996[(8)]);
var inst_53950 = (state_53996[(13)]);
var inst_53946 = cljs.core.deref.call(null,cache);
var inst_53947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53948 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_53939,inst_53927];
var inst_53949 = (new cljs.core.PersistentVector(null,3,(5),inst_53947,inst_53948,null));
var inst_53950__$1 = cljs.core.get_in.call(null,inst_53946,inst_53949);
var state_53996__$1 = (function (){var statearr_54028 = state_53996;
(statearr_54028[(13)] = inst_53950__$1);

return statearr_54028;
})();
if(cljs.core.truth_(inst_53950__$1)){
var statearr_54029_54078 = state_53996__$1;
(statearr_54029_54078[(1)] = (26));

} else {
var statearr_54030_54079 = state_53996__$1;
(statearr_54030_54079[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (35))){
var state_53996__$1 = state_53996;
var statearr_54031_54080 = state_53996__$1;
(statearr_54031_54080[(2)] = null);

(statearr_54031_54080[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (19))){
var inst_53936 = (state_53996[(2)]);
var state_53996__$1 = state_53996;
var statearr_54032_54081 = state_53996__$1;
(statearr_54032_54081[(2)] = inst_53936);

(statearr_54032_54081[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (11))){
var state_53996__$1 = state_53996;
var statearr_54034_54082 = state_53996__$1;
(statearr_54034_54082[(2)] = pred);

(statearr_54034_54082[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (9))){
var inst_53915 = (state_53996[(2)]);
var inst_53916 = fluree.db.util.async.throw_err.call(null,inst_53915);
var state_53996__$1 = state_53996;
var statearr_54035_54083 = state_53996__$1;
(statearr_54035_54083[(2)] = inst_53916);

(statearr_54035_54083[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (5))){
var _ = (function (){var statearr_54036 = state_53996;
(statearr_54036[(4)] = cljs.core.rest.call(null,(state_53996[(4)])));

return statearr_54036;
})();
var state_53996__$1 = state_53996;
var ex54033 = (state_53996__$1[(2)]);
var statearr_54037_54084 = state_53996__$1;
(statearr_54037_54084[(5)] = ex54033);


if((ex54033 instanceof Error)){
var statearr_54038_54085 = state_53996__$1;
(statearr_54038_54085[(1)] = (4));

(statearr_54038_54085[(5)] = null);

} else {
throw ex54033;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (14))){
var inst_53919 = (state_53996[(9)]);
var inst_53930 = cljs.core.count.call(null,inst_53919);
var inst_53931 = cljs.core._EQ_.call(null,(1),inst_53930);
var state_53996__$1 = state_53996;
if(inst_53931){
var statearr_54039_54086 = state_53996__$1;
(statearr_54039_54086[(1)] = (17));

} else {
var statearr_54040_54087 = state_53996__$1;
(statearr_54040_54087[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (26))){
var inst_53950 = (state_53996[(13)]);
var state_53996__$1 = state_53996;
var statearr_54041_54088 = state_53996__$1;
(statearr_54041_54088[(2)] = inst_53950);

(statearr_54041_54088[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (16))){
var inst_53939 = (state_53996[(7)]);
var inst_53940 = (state_53996[(10)]);
var inst_53939__$1 = (state_53996[(2)]);
var inst_53940__$1 = cljs.core.int_QMARK_.call(null,inst_53939__$1);
var state_53996__$1 = (function (){var statearr_54042 = state_53996;
(statearr_54042[(7)] = inst_53939__$1);

(statearr_54042[(10)] = inst_53940__$1);

return statearr_54042;
})();
if(inst_53940__$1){
var statearr_54043_54089 = state_53996__$1;
(statearr_54043_54089[(1)] = (20));

} else {
var statearr_54044_54090 = state_53996__$1;
(statearr_54044_54090[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (30))){
var inst_53939 = (state_53996[(7)]);
var inst_53927 = (state_53996[(8)]);
var inst_53968 = fluree.db.dbfunctions.internal.get_subj_pred.call(null,db,inst_53939,inst_53927);
var state_53996__$1 = state_53996;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53996__$1,(33),inst_53968);
} else {
if((state_val_53997 === (10))){
var state_53996__$1 = state_53996;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53996__$1,(13),pred);
} else {
if((state_val_53997 === (18))){
var inst_53919 = (state_53996[(9)]);
var state_53996__$1 = state_53996;
var statearr_54045_54091 = state_53996__$1;
(statearr_54045_54091[(2)] = inst_53919);

(statearr_54045_54091[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53997 === (8))){
var inst_53919 = (state_53996[(2)]);
var inst_53920 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_53996__$1 = (function (){var statearr_54046 = state_53996;
(statearr_54046[(9)] = inst_53919);

return statearr_54046;
})();
if(inst_53920){
var statearr_54047_54092 = state_53996__$1;
(statearr_54047_54092[(1)] = (10));

} else {
var statearr_54048_54093 = state_53996__$1;
(statearr_54048_54093[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0 = (function (){
var statearr_54049 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54049[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__);

(statearr_54049[(1)] = (1));

return statearr_54049;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1 = (function (state_53996){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_53996);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54050){var ex__2749__auto__ = e54050;
var statearr_54051_54094 = state_53996;
(statearr_54051_54094[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_53996[(4)]))){
var statearr_54052_54095 = state_53996;
(statearr_54052_54095[(1)] = cljs.core.first.call(null,(state_53996[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54096 = state_53996;
state_53996 = G__54096;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__ = function(state_53996){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1.call(this,state_53996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54053 = f__2769__auto__.call(null);
(statearr_54053[(6)] = c__2768__auto__);

return statearr_54053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54135){
var state_val_54136 = (state_54135[(1)]);
if((state_val_54136 === (7))){
var inst_54103 = (state_54135[(7)]);
var state_54135__$1 = state_54135;
var statearr_54137_54161 = state_54135__$1;
(statearr_54137_54161[(2)] = inst_54103);

(statearr_54137_54161[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (1))){
var state_54135__$1 = state_54135;
var statearr_54138_54162 = state_54135__$1;
(statearr_54138_54162[(2)] = null);

(statearr_54138_54162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (4))){
var inst_54097 = (state_54135[(2)]);
var state_54135__$1 = state_54135;
var statearr_54139_54163 = state_54135__$1;
(statearr_54139_54163[(2)] = inst_54097);

(statearr_54139_54163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (6))){
var inst_54105 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54135__$1 = state_54135;
var statearr_54140_54164 = state_54135__$1;
(statearr_54140_54164[(2)] = inst_54105);

(statearr_54140_54164[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (3))){
var inst_54133 = (state_54135[(2)]);
var state_54135__$1 = state_54135;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54135__$1,inst_54133);
} else {
if((state_val_54136 === (12))){
var inst_54115 = (state_54135[(2)]);
var inst_54116 = fluree.db.util.async.throw_err.call(null,inst_54115);
var inst_54117 = cljs.core.nth.call(null,inst_54116,(0),null);
var inst_54118 = cljs.core.nth.call(null,inst_54116,(1),null);
var inst_54119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54120 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54121 = ["?pO","?ctx",inst_54117];
var inst_54122 = cljs.core.PersistentHashMap.fromArrays(inst_54120,inst_54121);
var inst_54123 = ((10) + inst_54118);
var inst_54124 = [inst_54122,inst_54123];
var inst_54125 = (new cljs.core.PersistentVector(null,2,(5),inst_54119,inst_54124,null));
var inst_54126 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54125);
var state_54135__$1 = (function (){var statearr_54141 = state_54135;
(statearr_54141[(8)] = inst_54126);

return statearr_54141;
})();
var statearr_54142_54165 = state_54135__$1;
(statearr_54142_54165[(2)] = inst_54117);

(statearr_54142_54165[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (2))){
var inst_54103 = (state_54135[(7)]);
var _ = (function (){var statearr_54143 = state_54135;
(statearr_54143[(4)] = cljs.core.cons.call(null,(5),(state_54135[(4)])));

return statearr_54143;
})();
var inst_54103__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54135__$1 = (function (){var statearr_54144 = state_54135;
(statearr_54144[(7)] = inst_54103__$1);

return statearr_54144;
})();
if(cljs.core.truth_(inst_54103__$1)){
var statearr_54145_54166 = state_54135__$1;
(statearr_54145_54166[(1)] = (6));

} else {
var statearr_54146_54167 = state_54135__$1;
(statearr_54146_54167[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (11))){
var inst_54130 = (state_54135[(2)]);
var _ = (function (){var statearr_54148 = state_54135;
(statearr_54148[(4)] = cljs.core.rest.call(null,(state_54135[(4)])));

return statearr_54148;
})();
var state_54135__$1 = state_54135;
var statearr_54149_54168 = state_54135__$1;
(statearr_54149_54168[(2)] = inst_54130);

(statearr_54149_54168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (9))){
var inst_54113 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_54135__$1 = state_54135;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54135__$1,(12),inst_54113);
} else {
if((state_val_54136 === (5))){
var _ = (function (){var statearr_54150 = state_54135;
(statearr_54150[(4)] = cljs.core.rest.call(null,(state_54135[(4)])));

return statearr_54150;
})();
var state_54135__$1 = state_54135;
var ex54147 = (state_54135__$1[(2)]);
var statearr_54151_54169 = state_54135__$1;
(statearr_54151_54169[(5)] = ex54147);


if((ex54147 instanceof Error)){
var statearr_54152_54170 = state_54135__$1;
(statearr_54152_54170[(1)] = (4));

(statearr_54152_54170[(5)] = null);

} else {
throw ex54147;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (10))){
var inst_54128 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_54135__$1 = state_54135;
var statearr_54153_54171 = state_54135__$1;
(statearr_54153_54171[(2)] = inst_54128);

(statearr_54153_54171[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54136 === (8))){
var inst_54108 = (state_54135[(2)]);
var state_54135__$1 = state_54135;
if(cljs.core.truth_(inst_54108)){
var statearr_54154_54172 = state_54135__$1;
(statearr_54154_54172[(1)] = (9));

} else {
var statearr_54155_54173 = state_54135__$1;
(statearr_54155_54173[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0 = (function (){
var statearr_54156 = [null,null,null,null,null,null,null,null,null];
(statearr_54156[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__);

(statearr_54156[(1)] = (1));

return statearr_54156;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1 = (function (state_54135){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54135);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54157){var ex__2749__auto__ = e54157;
var statearr_54158_54174 = state_54135;
(statearr_54158_54174[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54135[(4)]))){
var statearr_54159_54175 = state_54135;
(statearr_54159_54175[(1)] = cljs.core.first.call(null,(state_54135[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54176 = state_54135;
state_54135 = G__54176;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__ = function(state_54135){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1.call(this,state_54135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54160 = f__2769__auto__.call(null);
(statearr_54160[(6)] = c__2768__auto__);

return statearr_54160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54245){
var state_val_54246 = (state_54245[(1)]);
if((state_val_54246 === (7))){
var state_54245__$1 = state_54245;
var statearr_54247_54285 = state_54245__$1;
(statearr_54247_54285[(2)] = subject);

(statearr_54247_54285[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (20))){
var inst_54201 = (state_54245[(7)]);
var inst_54213 = (state_54245[(8)]);
var inst_54216 = fluree.db.dbfunctions.internal.follow_subject.call(null,_QMARK_ctx,inst_54213,inst_54201);
var state_54245__$1 = state_54245;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54245__$1,(23),inst_54216);
} else {
if((state_val_54246 === (1))){
var state_54245__$1 = state_54245;
var statearr_54248_54286 = state_54245__$1;
(statearr_54248_54286[(2)] = null);

(statearr_54248_54286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (4))){
var inst_54177 = (state_54245[(2)]);
var state_54245__$1 = state_54245;
var statearr_54249_54287 = state_54245__$1;
(statearr_54249_54287[(2)] = inst_54177);

(statearr_54249_54287[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (15))){
var inst_54193 = (state_54245[(9)]);
var state_54245__$1 = state_54245;
var statearr_54250_54288 = state_54245__$1;
(statearr_54250_54288[(2)] = inst_54193);

(statearr_54250_54288[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (21))){
var inst_54201 = (state_54245[(7)]);
var inst_54213 = (state_54245[(8)]);
var inst_54221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54222 = fluree.db.dbfunctions.internal.get_all.call(null,inst_54213,inst_54201);
var inst_54223 = cljs.core.count.call(null,inst_54201);
var inst_54224 = ((9) + inst_54223);
var inst_54225 = [inst_54222,inst_54224];
var inst_54226 = (new cljs.core.PersistentVector(null,2,(5),inst_54221,inst_54225,null));
var state_54245__$1 = state_54245;
var statearr_54251_54289 = state_54245__$1;
(statearr_54251_54289[(2)] = inst_54226);

(statearr_54251_54289[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (13))){
var inst_54197 = (state_54245[(2)]);
var inst_54198 = fluree.db.util.async.throw_err.call(null,inst_54197);
var state_54245__$1 = state_54245;
var statearr_54252_54290 = state_54245__$1;
(statearr_54252_54290[(2)] = inst_54198);

(statearr_54252_54290[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (22))){
var inst_54193 = (state_54245[(9)]);
var inst_54201 = (state_54245[(7)]);
var inst_54228 = (state_54245[(2)]);
var inst_54229 = cljs.core.nth.call(null,inst_54228,(0),null);
var inst_54230 = cljs.core.nth.call(null,inst_54228,(1),null);
var inst_54231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54232 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54234 = [inst_54193,inst_54201];
var inst_54235 = (new cljs.core.PersistentVector(null,2,(5),inst_54233,inst_54234,null));
var inst_54236 = ["get-all",inst_54235,inst_54229];
var inst_54237 = cljs.core.PersistentHashMap.fromArrays(inst_54232,inst_54236);
var inst_54238 = [inst_54237,inst_54230];
var inst_54239 = (new cljs.core.PersistentVector(null,2,(5),inst_54231,inst_54238,null));
var inst_54240 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54239);
var _ = (function (){var statearr_54253 = state_54245;
(statearr_54253[(4)] = cljs.core.rest.call(null,(state_54245[(4)])));

return statearr_54253;
})();
var state_54245__$1 = (function (){var statearr_54254 = state_54245;
(statearr_54254[(10)] = inst_54240);

return statearr_54254;
})();
var statearr_54255_54291 = state_54245__$1;
(statearr_54255_54291[(2)] = inst_54229);

(statearr_54255_54291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (6))){
var state_54245__$1 = state_54245;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54245__$1,(9),subject);
} else {
if((state_val_54246 === (17))){
var inst_54193 = (state_54245[(9)]);
var inst_54207 = cljs.core.first.call(null,inst_54193);
var state_54245__$1 = state_54245;
var statearr_54256_54292 = state_54245__$1;
(statearr_54256_54292[(2)] = inst_54207);

(statearr_54256_54292[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (3))){
var inst_54243 = (state_54245[(2)]);
var state_54245__$1 = state_54245;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54245__$1,inst_54243);
} else {
if((state_val_54246 === (12))){
var inst_54193 = (state_54245[(9)]);
var inst_54201 = (state_54245[(2)]);
var inst_54202 = cljs.core.vector_QMARK_.call(null,inst_54193);
var state_54245__$1 = (function (){var statearr_54257 = state_54245;
(statearr_54257[(7)] = inst_54201);

return statearr_54257;
})();
if(inst_54202){
var statearr_54258_54293 = state_54245__$1;
(statearr_54258_54293[(1)] = (14));

} else {
var statearr_54259_54294 = state_54245__$1;
(statearr_54259_54294[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (2))){
var _ = (function (){var statearr_54260 = state_54245;
(statearr_54260[(4)] = cljs.core.cons.call(null,(5),(state_54245[(4)])));

return statearr_54260;
})();
var inst_54186 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_54245__$1 = state_54245;
if(inst_54186){
var statearr_54261_54295 = state_54245__$1;
(statearr_54261_54295[(1)] = (6));

} else {
var statearr_54262_54296 = state_54245__$1;
(statearr_54262_54296[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (23))){
var inst_54218 = (state_54245[(2)]);
var inst_54219 = fluree.db.util.async.throw_err.call(null,inst_54218);
var state_54245__$1 = state_54245;
var statearr_54263_54297 = state_54245__$1;
(statearr_54263_54297[(2)] = inst_54219);

(statearr_54263_54297[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (19))){
var inst_54210 = (state_54245[(2)]);
var state_54245__$1 = state_54245;
var statearr_54264_54298 = state_54245__$1;
(statearr_54264_54298[(2)] = inst_54210);

(statearr_54264_54298[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (11))){
var state_54245__$1 = state_54245;
var statearr_54266_54299 = state_54245__$1;
(statearr_54266_54299[(2)] = path);

(statearr_54266_54299[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (9))){
var inst_54189 = (state_54245[(2)]);
var inst_54190 = fluree.db.util.async.throw_err.call(null,inst_54189);
var state_54245__$1 = state_54245;
var statearr_54267_54300 = state_54245__$1;
(statearr_54267_54300[(2)] = inst_54190);

(statearr_54267_54300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (5))){
var _ = (function (){var statearr_54268 = state_54245;
(statearr_54268[(4)] = cljs.core.rest.call(null,(state_54245[(4)])));

return statearr_54268;
})();
var state_54245__$1 = state_54245;
var ex54265 = (state_54245__$1[(2)]);
var statearr_54269_54301 = state_54245__$1;
(statearr_54269_54301[(5)] = ex54265);


if((ex54265 instanceof Error)){
var statearr_54270_54302 = state_54245__$1;
(statearr_54270_54302[(1)] = (4));

(statearr_54270_54302[(5)] = null);

} else {
throw ex54265;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (14))){
var inst_54193 = (state_54245[(9)]);
var inst_54204 = cljs.core.count.call(null,inst_54193);
var inst_54205 = cljs.core._EQ_.call(null,(1),inst_54204);
var state_54245__$1 = state_54245;
if(inst_54205){
var statearr_54271_54303 = state_54245__$1;
(statearr_54271_54303[(1)] = (17));

} else {
var statearr_54272_54304 = state_54245__$1;
(statearr_54272_54304[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (16))){
var inst_54213 = (state_54245[(8)]);
var inst_54213__$1 = (state_54245[(2)]);
var inst_54214 = cljs.core.int_QMARK_.call(null,inst_54213__$1);
var state_54245__$1 = (function (){var statearr_54273 = state_54245;
(statearr_54273[(8)] = inst_54213__$1);

return statearr_54273;
})();
if(inst_54214){
var statearr_54274_54305 = state_54245__$1;
(statearr_54274_54305[(1)] = (20));

} else {
var statearr_54275_54306 = state_54245__$1;
(statearr_54275_54306[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (10))){
var state_54245__$1 = state_54245;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54245__$1,(13),path);
} else {
if((state_val_54246 === (18))){
var inst_54193 = (state_54245[(9)]);
var state_54245__$1 = state_54245;
var statearr_54276_54307 = state_54245__$1;
(statearr_54276_54307[(2)] = inst_54193);

(statearr_54276_54307[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (8))){
var inst_54193 = (state_54245[(2)]);
var inst_54194 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_54245__$1 = (function (){var statearr_54277 = state_54245;
(statearr_54277[(9)] = inst_54193);

return statearr_54277;
})();
if(inst_54194){
var statearr_54278_54308 = state_54245__$1;
(statearr_54278_54308[(1)] = (10));

} else {
var statearr_54279_54309 = state_54245__$1;
(statearr_54279_54309[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0 = (function (){
var statearr_54280 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54280[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__);

(statearr_54280[(1)] = (1));

return statearr_54280;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1 = (function (state_54245){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54245);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54281){var ex__2749__auto__ = e54281;
var statearr_54282_54310 = state_54245;
(statearr_54282_54310[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54245[(4)]))){
var statearr_54283_54311 = state_54245;
(statearr_54283_54311[(1)] = cljs.core.first.call(null,(state_54245[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54312 = state_54245;
state_54245 = G__54312;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__ = function(state_54245){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1.call(this,state_54245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54284 = f__2769__auto__.call(null);
(statearr_54284[(6)] = c__2768__auto__);

return statearr_54284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54351){
var state_val_54352 = (state_54351[(1)]);
if((state_val_54352 === (7))){
var state_54351__$1 = state_54351;
var statearr_54353_54377 = state_54351__$1;
(statearr_54353_54377[(2)] = subject);

(statearr_54353_54377[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54352 === (1))){
var state_54351__$1 = state_54351;
var statearr_54354_54378 = state_54351__$1;
(statearr_54354_54378[(2)] = null);

(statearr_54354_54378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54352 === (4))){
var inst_54313 = (state_54351[(2)]);
var state_54351__$1 = state_54351;
var statearr_54355_54379 = state_54351__$1;
(statearr_54355_54379[(2)] = inst_54313);

(statearr_54355_54379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54352 === (13))){
var inst_54330 = (state_54351[(2)]);
var inst_54331 = fluree.db.util.async.throw_err.call(null,inst_54330);
var state_54351__$1 = state_54351;
var statearr_54356_54380 = state_54351__$1;
(statearr_54356_54380[(2)] = inst_54331);

(statearr_54356_54380[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54352 === (6))){
var state_54351__$1 = state_54351;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54351__$1,(9),subject);
} else {
if((state_val_54352 === (3))){
var inst_54349 = (state_54351[(2)]);
var state_54351__$1 = state_54351;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54351__$1,inst_54349);
} else {
if((state_val_54352 === (12))){
var inst_54326 = (state_54351[(7)]);
var inst_54334 = (state_54351[(2)]);
var inst_54335 = fluree.db.dbfunctions.internal.get_in.call(null,inst_54326,inst_54334);
var inst_54336 = cljs.core.count.call(null,inst_54334);
var inst_54337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54338 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54340 = [inst_54326,inst_54334];
var inst_54341 = (new cljs.core.PersistentVector(null,2,(5),inst_54339,inst_54340,null));
var inst_54342 = ["get-in",inst_54341,inst_54335];
var inst_54343 = cljs.core.PersistentHashMap.fromArrays(inst_54338,inst_54342);
var inst_54344 = [inst_54343,inst_54336];
var inst_54345 = (new cljs.core.PersistentVector(null,2,(5),inst_54337,inst_54344,null));
var inst_54346 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54345);
var _ = (function (){var statearr_54357 = state_54351;
(statearr_54357[(4)] = cljs.core.rest.call(null,(state_54351[(4)])));

return statearr_54357;
})();
var state_54351__$1 = (function (){var statearr_54358 = state_54351;
(statearr_54358[(8)] = inst_54346);

return statearr_54358;
})();
var statearr_54359_54381 = state_54351__$1;
(statearr_54359_54381[(2)] = inst_54335);

(statearr_54359_54381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54352 === (2))){
var _ = (function (){var statearr_54360 = state_54351;
(statearr_54360[(4)] = cljs.core.cons.call(null,(5),(state_54351[(4)])));

return statearr_54360;
})();
var inst_54319 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_54351__$1 = state_54351;
if(inst_54319){
var statearr_54361_54382 = state_54351__$1;
(statearr_54361_54382[(1)] = (6));

} else {
var statearr_54362_54383 = state_54351__$1;
(statearr_54362_54383[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54352 === (11))){
var state_54351__$1 = state_54351;
var statearr_54364_54384 = state_54351__$1;
(statearr_54364_54384[(2)] = path);

(statearr_54364_54384[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54352 === (9))){
var inst_54322 = (state_54351[(2)]);
var inst_54323 = fluree.db.util.async.throw_err.call(null,inst_54322);
var state_54351__$1 = state_54351;
var statearr_54365_54385 = state_54351__$1;
(statearr_54365_54385[(2)] = inst_54323);

(statearr_54365_54385[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54352 === (5))){
var _ = (function (){var statearr_54366 = state_54351;
(statearr_54366[(4)] = cljs.core.rest.call(null,(state_54351[(4)])));

return statearr_54366;
})();
var state_54351__$1 = state_54351;
var ex54363 = (state_54351__$1[(2)]);
var statearr_54367_54386 = state_54351__$1;
(statearr_54367_54386[(5)] = ex54363);


if((ex54363 instanceof Error)){
var statearr_54368_54387 = state_54351__$1;
(statearr_54368_54387[(1)] = (4));

(statearr_54368_54387[(5)] = null);

} else {
throw ex54363;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54352 === (10))){
var state_54351__$1 = state_54351;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54351__$1,(13),path);
} else {
if((state_val_54352 === (8))){
var inst_54326 = (state_54351[(2)]);
var inst_54327 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_54351__$1 = (function (){var statearr_54369 = state_54351;
(statearr_54369[(7)] = inst_54326);

return statearr_54369;
})();
if(inst_54327){
var statearr_54370_54388 = state_54351__$1;
(statearr_54370_54388[(1)] = (10));

} else {
var statearr_54371_54389 = state_54351__$1;
(statearr_54371_54389[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0 = (function (){
var statearr_54372 = [null,null,null,null,null,null,null,null,null];
(statearr_54372[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__);

(statearr_54372[(1)] = (1));

return statearr_54372;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1 = (function (state_54351){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54351);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54373){var ex__2749__auto__ = e54373;
var statearr_54374_54390 = state_54351;
(statearr_54374_54390[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54351[(4)]))){
var statearr_54375_54391 = state_54351;
(statearr_54375_54391[(1)] = cljs.core.first.call(null,(state_54351[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54392 = state_54351;
state_54351 = G__54392;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__ = function(state_54351){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1.call(this,state_54351);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54376 = f__2769__auto__.call(null);
(statearr_54376[(6)] = c__2768__auto__);

return statearr_54376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__54393,key_or_ks){
var map__54394 = p__54393;
var map__54394__$1 = cljs.core.__destructure_map.call(null,map__54394);
var _QMARK_ctx = map__54394__$1;
var db = cljs.core.get.call(null,map__54394__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_.call(null,key_or_ks)){
return cljs.core.get_in.call(null,new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.call(null,new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54439){
var state_val_54440 = (state_54439[(1)]);
if((state_val_54440 === (7))){
var state_54439__$1 = state_54439;
var statearr_54441_54470 = state_54439__$1;
(statearr_54441_54470[(2)] = coll);

(statearr_54441_54470[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54440 === (1))){
var state_54439__$1 = state_54439;
var statearr_54442_54471 = state_54439__$1;
(statearr_54442_54471[(2)] = null);

(statearr_54442_54471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54440 === (4))){
var inst_54395 = (state_54439[(2)]);
var state_54439__$1 = state_54439;
var statearr_54443_54472 = state_54439__$1;
(statearr_54443_54472[(2)] = inst_54395);

(statearr_54443_54472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54440 === (15))){
var inst_54415 = (state_54439[(7)]);
var inst_54423 = (state_54439[(2)]);
var inst_54424 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_54415,inst_54423);
var inst_54425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54426 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54428 = [inst_54415,inst_54423];
var inst_54429 = (new cljs.core.PersistentVector(null,2,(5),inst_54427,inst_54428,null));
var inst_54430 = ["contains?",inst_54429,inst_54424];
var inst_54431 = cljs.core.PersistentHashMap.fromArrays(inst_54426,inst_54430);
var inst_54432 = [inst_54431,(10)];
var inst_54433 = (new cljs.core.PersistentVector(null,2,(5),inst_54425,inst_54432,null));
var inst_54434 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54433);
var _ = (function (){var statearr_54444 = state_54439;
(statearr_54444[(4)] = cljs.core.rest.call(null,(state_54439[(4)])));

return statearr_54444;
})();
var state_54439__$1 = (function (){var statearr_54445 = state_54439;
(statearr_54445[(8)] = inst_54434);

return statearr_54445;
})();
var statearr_54446_54473 = state_54439__$1;
(statearr_54446_54473[(2)] = inst_54424);

(statearr_54446_54473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54440 === (13))){
var state_54439__$1 = state_54439;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54439__$1,(16),key);
} else {
if((state_val_54440 === (6))){
var state_54439__$1 = state_54439;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54439__$1,(9),coll);
} else {
if((state_val_54440 === (3))){
var inst_54437 = (state_54439[(2)]);
var state_54439__$1 = state_54439;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54439__$1,inst_54437);
} else {
if((state_val_54440 === (12))){
var inst_54415 = (state_54439[(2)]);
var inst_54416 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_54439__$1 = (function (){var statearr_54447 = state_54439;
(statearr_54447[(7)] = inst_54415);

return statearr_54447;
})();
if(inst_54416){
var statearr_54448_54474 = state_54439__$1;
(statearr_54448_54474[(1)] = (13));

} else {
var statearr_54449_54475 = state_54439__$1;
(statearr_54449_54475[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54440 === (2))){
var _ = (function (){var statearr_54450 = state_54439;
(statearr_54450[(4)] = cljs.core.cons.call(null,(5),(state_54439[(4)])));

return statearr_54450;
})();
var inst_54401 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_54439__$1 = state_54439;
if(inst_54401){
var statearr_54451_54476 = state_54439__$1;
(statearr_54451_54476[(1)] = (6));

} else {
var statearr_54452_54477 = state_54439__$1;
(statearr_54452_54477[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54440 === (11))){
var inst_54408 = (state_54439[(9)]);
var inst_54412 = cljs.core.flatten.call(null,inst_54408);
var inst_54413 = cljs.core.set.call(null,inst_54412);
var state_54439__$1 = state_54439;
var statearr_54454_54478 = state_54439__$1;
(statearr_54454_54478[(2)] = inst_54413);

(statearr_54454_54478[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54440 === (9))){
var inst_54404 = (state_54439[(2)]);
var inst_54405 = fluree.db.util.async.throw_err.call(null,inst_54404);
var state_54439__$1 = state_54439;
var statearr_54455_54479 = state_54439__$1;
(statearr_54455_54479[(2)] = inst_54405);

(statearr_54455_54479[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54440 === (5))){
var _ = (function (){var statearr_54456 = state_54439;
(statearr_54456[(4)] = cljs.core.rest.call(null,(state_54439[(4)])));

return statearr_54456;
})();
var state_54439__$1 = state_54439;
var ex54453 = (state_54439__$1[(2)]);
var statearr_54457_54480 = state_54439__$1;
(statearr_54457_54480[(5)] = ex54453);


if((ex54453 instanceof Error)){
var statearr_54458_54481 = state_54439__$1;
(statearr_54458_54481[(1)] = (4));

(statearr_54458_54481[(5)] = null);

} else {
throw ex54453;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54440 === (14))){
var state_54439__$1 = state_54439;
var statearr_54459_54482 = state_54439__$1;
(statearr_54459_54482[(2)] = key);

(statearr_54459_54482[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54440 === (16))){
var inst_54419 = (state_54439[(2)]);
var inst_54420 = fluree.db.util.async.throw_err.call(null,inst_54419);
var state_54439__$1 = state_54439;
var statearr_54460_54483 = state_54439__$1;
(statearr_54460_54483[(2)] = inst_54420);

(statearr_54460_54483[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54440 === (10))){
var inst_54408 = (state_54439[(9)]);
var state_54439__$1 = state_54439;
var statearr_54461_54484 = state_54439__$1;
(statearr_54461_54484[(2)] = inst_54408);

(statearr_54461_54484[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54440 === (8))){
var inst_54408 = (state_54439[(9)]);
var inst_54408__$1 = (state_54439[(2)]);
var inst_54409 = cljs.core.set_QMARK_.call(null,inst_54408__$1);
var state_54439__$1 = (function (){var statearr_54462 = state_54439;
(statearr_54462[(9)] = inst_54408__$1);

return statearr_54462;
})();
if(inst_54409){
var statearr_54463_54485 = state_54439__$1;
(statearr_54463_54485[(1)] = (10));

} else {
var statearr_54464_54486 = state_54439__$1;
(statearr_54464_54486[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_54465 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54465[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__);

(statearr_54465[(1)] = (1));

return statearr_54465;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1 = (function (state_54439){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54439);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54466){var ex__2749__auto__ = e54466;
var statearr_54467_54487 = state_54439;
(statearr_54467_54487[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54439[(4)]))){
var statearr_54468_54488 = state_54439;
(statearr_54468_54488[(1)] = cljs.core.first.call(null,(state_54439[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54489 = state_54439;
state_54439 = G__54489;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__ = function(state_54439){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1.call(this,state_54439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54469 = f__2769__auto__.call(null);
(statearr_54469[(6)] = c__2768__auto__);

return statearr_54469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54561 = arguments.length;
var i__4865__auto___54562 = (0);
while(true){
if((i__4865__auto___54562 < len__4864__auto___54561)){
args__4870__auto__.push((arguments[i__4865__auto___54562]));

var G__54563 = (i__4865__auto___54562 + (1));
i__4865__auto___54562 = G__54563;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54535){
var state_val_54536 = (state_54535[(1)]);
if((state_val_54536 === (7))){
var inst_54501 = (state_54535[(7)]);
var inst_54505 = cljs.core.first.call(null,inst_54501);
var inst_54506 = cljs.core.coll_QMARK_.call(null,inst_54505);
var state_54535__$1 = state_54535;
var statearr_54537_54564 = state_54535__$1;
(statearr_54537_54564[(2)] = inst_54506);

(statearr_54537_54564[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54536 === (1))){
var state_54535__$1 = state_54535;
var statearr_54538_54565 = state_54535__$1;
(statearr_54538_54565[(2)] = null);

(statearr_54538_54565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54536 === (4))){
var inst_54492 = (state_54535[(2)]);
var state_54535__$1 = state_54535;
var statearr_54539_54566 = state_54535__$1;
(statearr_54539_54566[(2)] = inst_54492);

(statearr_54539_54566[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54536 === (6))){
var inst_54503 = (state_54535[(8)]);
var inst_54501 = (state_54535[(7)]);
var inst_54500 = (state_54535[(2)]);
var inst_54501__$1 = fluree.db.util.async.throw_err.call(null,inst_54500);
var inst_54502 = cljs.core.count.call(null,inst_54501__$1);
var inst_54503__$1 = cljs.core._EQ_.call(null,(1),inst_54502);
var state_54535__$1 = (function (){var statearr_54540 = state_54535;
(statearr_54540[(8)] = inst_54503__$1);

(statearr_54540[(7)] = inst_54501__$1);

return statearr_54540;
})();
if(inst_54503__$1){
var statearr_54541_54567 = state_54535__$1;
(statearr_54541_54567[(1)] = (7));

} else {
var statearr_54542_54568 = state_54535__$1;
(statearr_54542_54568[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54536 === (3))){
var inst_54533 = (state_54535[(2)]);
var state_54535__$1 = state_54535;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54535__$1,inst_54533);
} else {
if((state_val_54536 === (12))){
var inst_54514 = (state_54535[(2)]);
var inst_54515 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_54514);
var inst_54516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54517 = [inst_54514];
var inst_54518 = (new cljs.core.PersistentVector(null,1,(5),inst_54516,inst_54517,null));
var inst_54519 = cljs.core.count.call(null,inst_54518);
var inst_54520 = ((9) + inst_54519);
var inst_54521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54522 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54523 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54524 = [inst_54514];
var inst_54525 = (new cljs.core.PersistentVector(null,1,(5),inst_54523,inst_54524,null));
var inst_54526 = ["hash-set",inst_54525,inst_54515];
var inst_54527 = cljs.core.PersistentHashMap.fromArrays(inst_54522,inst_54526);
var inst_54528 = [inst_54527,inst_54520];
var inst_54529 = (new cljs.core.PersistentVector(null,2,(5),inst_54521,inst_54528,null));
var inst_54530 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54529);
var _ = (function (){var statearr_54543 = state_54535;
(statearr_54543[(4)] = cljs.core.rest.call(null,(state_54535[(4)])));

return statearr_54543;
})();
var state_54535__$1 = (function (){var statearr_54544 = state_54535;
(statearr_54544[(9)] = inst_54530);

return statearr_54544;
})();
var statearr_54545_54569 = state_54535__$1;
(statearr_54545_54569[(2)] = inst_54515);

(statearr_54545_54569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54536 === (2))){
var _ = (function (){var statearr_54546 = state_54535;
(statearr_54546[(4)] = cljs.core.cons.call(null,(5),(state_54535[(4)])));

return statearr_54546;
})();
var inst_54498 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54535__$1 = state_54535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54535__$1,(6),inst_54498);
} else {
if((state_val_54536 === (11))){
var inst_54501 = (state_54535[(7)]);
var state_54535__$1 = state_54535;
var statearr_54548_54570 = state_54535__$1;
(statearr_54548_54570[(2)] = inst_54501);

(statearr_54548_54570[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54536 === (9))){
var inst_54509 = (state_54535[(2)]);
var state_54535__$1 = state_54535;
if(cljs.core.truth_(inst_54509)){
var statearr_54549_54571 = state_54535__$1;
(statearr_54549_54571[(1)] = (10));

} else {
var statearr_54550_54572 = state_54535__$1;
(statearr_54550_54572[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54536 === (5))){
var _ = (function (){var statearr_54551 = state_54535;
(statearr_54551[(4)] = cljs.core.rest.call(null,(state_54535[(4)])));

return statearr_54551;
})();
var state_54535__$1 = state_54535;
var ex54547 = (state_54535__$1[(2)]);
var statearr_54552_54573 = state_54535__$1;
(statearr_54552_54573[(5)] = ex54547);


if((ex54547 instanceof Error)){
var statearr_54553_54574 = state_54535__$1;
(statearr_54553_54574[(1)] = (4));

(statearr_54553_54574[(5)] = null);

} else {
throw ex54547;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54536 === (10))){
var inst_54501 = (state_54535[(7)]);
var inst_54511 = cljs.core.first.call(null,inst_54501);
var state_54535__$1 = state_54535;
var statearr_54554_54575 = state_54535__$1;
(statearr_54554_54575[(2)] = inst_54511);

(statearr_54554_54575[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54536 === (8))){
var inst_54503 = (state_54535[(8)]);
var state_54535__$1 = state_54535;
var statearr_54555_54576 = state_54535__$1;
(statearr_54555_54576[(2)] = inst_54503);

(statearr_54555_54576[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54556 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54556[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54556[(1)] = (1));

return statearr_54556;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54535){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54535);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54557){var ex__2749__auto__ = e54557;
var statearr_54558_54577 = state_54535;
(statearr_54558_54577[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54535[(4)]))){
var statearr_54559_54578 = state_54535;
(statearr_54559_54578[(1)] = cljs.core.first.call(null,(state_54535[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54579 = state_54535;
state_54535 = G__54579;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54535){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54560 = f__2769__auto__.call(null);
(statearr_54560[(6)] = c__2768__auto__);

return statearr_54560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq54490){
var G__54491 = cljs.core.first.call(null,seq54490);
var seq54490__$1 = cljs.core.next.call(null,seq54490);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54491,seq54490__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54629 = arguments.length;
var i__4865__auto___54630 = (0);
while(true){
if((i__4865__auto___54630 < len__4864__auto___54629)){
args__4870__auto__.push((arguments[i__4865__auto___54630]));

var G__54631 = (i__4865__auto___54630 + (1));
i__4865__auto___54630 = G__54631;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54612){
var state_val_54613 = (state_54612[(1)]);
if((state_val_54613 === (1))){
var state_54612__$1 = state_54612;
var statearr_54614_54632 = state_54612__$1;
(statearr_54614_54632[(2)] = null);

(statearr_54614_54632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54613 === (2))){
var _ = (function (){var statearr_54615 = state_54612;
(statearr_54615[(4)] = cljs.core.cons.call(null,(5),(state_54612[(4)])));

return statearr_54615;
})();
var inst_54588 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54612__$1 = state_54612;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54612__$1,(6),inst_54588);
} else {
if((state_val_54613 === (3))){
var inst_54610 = (state_54612[(2)]);
var state_54612__$1 = state_54612;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54612__$1,inst_54610);
} else {
if((state_val_54613 === (4))){
var inst_54582 = (state_54612[(2)]);
var state_54612__$1 = state_54612;
var statearr_54617_54633 = state_54612__$1;
(statearr_54617_54633[(2)] = inst_54582);

(statearr_54617_54633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54613 === (5))){
var _ = (function (){var statearr_54618 = state_54612;
(statearr_54618[(4)] = cljs.core.rest.call(null,(state_54612[(4)])));

return statearr_54618;
})();
var state_54612__$1 = state_54612;
var ex54616 = (state_54612__$1[(2)]);
var statearr_54619_54634 = state_54612__$1;
(statearr_54619_54634[(5)] = ex54616);


if((ex54616 instanceof Error)){
var statearr_54620_54635 = state_54612__$1;
(statearr_54620_54635[(1)] = (4));

(statearr_54620_54635[(5)] = null);

} else {
throw ex54616;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54613 === (6))){
var inst_54590 = (state_54612[(2)]);
var inst_54591 = fluree.db.util.async.throw_err.call(null,inst_54590);
var inst_54592 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_54591);
var inst_54593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54594 = [inst_54591];
var inst_54595 = (new cljs.core.PersistentVector(null,1,(5),inst_54593,inst_54594,null));
var inst_54596 = cljs.core.count.call(null,inst_54595);
var inst_54597 = ((9) + inst_54596);
var inst_54598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54599 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54601 = [inst_54591];
var inst_54602 = (new cljs.core.PersistentVector(null,1,(5),inst_54600,inst_54601,null));
var inst_54603 = ["==",inst_54602,inst_54592];
var inst_54604 = cljs.core.PersistentHashMap.fromArrays(inst_54599,inst_54603);
var inst_54605 = [inst_54604,inst_54597];
var inst_54606 = (new cljs.core.PersistentVector(null,2,(5),inst_54598,inst_54605,null));
var inst_54607 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54606);
var _ = (function (){var statearr_54621 = state_54612;
(statearr_54621[(4)] = cljs.core.rest.call(null,(state_54612[(4)])));

return statearr_54621;
})();
var state_54612__$1 = (function (){var statearr_54622 = state_54612;
(statearr_54622[(7)] = inst_54607);

return statearr_54622;
})();
var statearr_54623_54636 = state_54612__$1;
(statearr_54623_54636[(2)] = inst_54592);

(statearr_54623_54636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54624 = [null,null,null,null,null,null,null,null];
(statearr_54624[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54624[(1)] = (1));

return statearr_54624;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54612){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54612);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54625){var ex__2749__auto__ = e54625;
var statearr_54626_54637 = state_54612;
(statearr_54626_54637[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54612[(4)]))){
var statearr_54627_54638 = state_54612;
(statearr_54627_54638[(1)] = cljs.core.first.call(null,(state_54612[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54639 = state_54612;
state_54612 = G__54639;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54612){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54628 = f__2769__auto__.call(null);
(statearr_54628[(6)] = c__2768__auto__);

return statearr_54628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq54580){
var G__54581 = cljs.core.first.call(null,seq54580);
var seq54580__$1 = cljs.core.next.call(null,seq54580);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54581,seq54580__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54689 = arguments.length;
var i__4865__auto___54690 = (0);
while(true){
if((i__4865__auto___54690 < len__4864__auto___54689)){
args__4870__auto__.push((arguments[i__4865__auto___54690]));

var G__54691 = (i__4865__auto___54690 + (1));
i__4865__auto___54690 = G__54691;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54672){
var state_val_54673 = (state_54672[(1)]);
if((state_val_54673 === (1))){
var state_54672__$1 = state_54672;
var statearr_54674_54692 = state_54672__$1;
(statearr_54674_54692[(2)] = null);

(statearr_54674_54692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54673 === (2))){
var _ = (function (){var statearr_54675 = state_54672;
(statearr_54675[(4)] = cljs.core.cons.call(null,(5),(state_54672[(4)])));

return statearr_54675;
})();
var inst_54648 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54672__$1 = state_54672;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54672__$1,(6),inst_54648);
} else {
if((state_val_54673 === (3))){
var inst_54670 = (state_54672[(2)]);
var state_54672__$1 = state_54672;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54672__$1,inst_54670);
} else {
if((state_val_54673 === (4))){
var inst_54642 = (state_54672[(2)]);
var state_54672__$1 = state_54672;
var statearr_54677_54693 = state_54672__$1;
(statearr_54677_54693[(2)] = inst_54642);

(statearr_54677_54693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54673 === (5))){
var _ = (function (){var statearr_54678 = state_54672;
(statearr_54678[(4)] = cljs.core.rest.call(null,(state_54672[(4)])));

return statearr_54678;
})();
var state_54672__$1 = state_54672;
var ex54676 = (state_54672__$1[(2)]);
var statearr_54679_54694 = state_54672__$1;
(statearr_54679_54694[(5)] = ex54676);


if((ex54676 instanceof Error)){
var statearr_54680_54695 = state_54672__$1;
(statearr_54680_54695[(1)] = (4));

(statearr_54680_54695[(5)] = null);

} else {
throw ex54676;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54673 === (6))){
var inst_54650 = (state_54672[(2)]);
var inst_54651 = fluree.db.util.async.throw_err.call(null,inst_54650);
var inst_54652 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_54651);
var inst_54653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54654 = [inst_54651];
var inst_54655 = (new cljs.core.PersistentVector(null,1,(5),inst_54653,inst_54654,null));
var inst_54656 = cljs.core.count.call(null,inst_54655);
var inst_54657 = ((9) + inst_54656);
var inst_54658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54659 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54661 = [inst_54651];
var inst_54662 = (new cljs.core.PersistentVector(null,1,(5),inst_54660,inst_54661,null));
var inst_54663 = [">",inst_54662,inst_54652];
var inst_54664 = cljs.core.PersistentHashMap.fromArrays(inst_54659,inst_54663);
var inst_54665 = [inst_54664,inst_54657];
var inst_54666 = (new cljs.core.PersistentVector(null,2,(5),inst_54658,inst_54665,null));
var inst_54667 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54666);
var _ = (function (){var statearr_54681 = state_54672;
(statearr_54681[(4)] = cljs.core.rest.call(null,(state_54672[(4)])));

return statearr_54681;
})();
var state_54672__$1 = (function (){var statearr_54682 = state_54672;
(statearr_54682[(7)] = inst_54667);

return statearr_54682;
})();
var statearr_54683_54696 = state_54672__$1;
(statearr_54683_54696[(2)] = inst_54652);

(statearr_54683_54696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54684 = [null,null,null,null,null,null,null,null];
(statearr_54684[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54684[(1)] = (1));

return statearr_54684;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54672){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54672);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54685){var ex__2749__auto__ = e54685;
var statearr_54686_54697 = state_54672;
(statearr_54686_54697[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54672[(4)]))){
var statearr_54687_54698 = state_54672;
(statearr_54687_54698[(1)] = cljs.core.first.call(null,(state_54672[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54699 = state_54672;
state_54672 = G__54699;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54672){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54688 = f__2769__auto__.call(null);
(statearr_54688[(6)] = c__2768__auto__);

return statearr_54688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq54640){
var G__54641 = cljs.core.first.call(null,seq54640);
var seq54640__$1 = cljs.core.next.call(null,seq54640);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54641,seq54640__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54749 = arguments.length;
var i__4865__auto___54750 = (0);
while(true){
if((i__4865__auto___54750 < len__4864__auto___54749)){
args__4870__auto__.push((arguments[i__4865__auto___54750]));

var G__54751 = (i__4865__auto___54750 + (1));
i__4865__auto___54750 = G__54751;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54732){
var state_val_54733 = (state_54732[(1)]);
if((state_val_54733 === (1))){
var state_54732__$1 = state_54732;
var statearr_54734_54752 = state_54732__$1;
(statearr_54734_54752[(2)] = null);

(statearr_54734_54752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (2))){
var _ = (function (){var statearr_54735 = state_54732;
(statearr_54735[(4)] = cljs.core.cons.call(null,(5),(state_54732[(4)])));

return statearr_54735;
})();
var inst_54708 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54732__$1 = state_54732;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54732__$1,(6),inst_54708);
} else {
if((state_val_54733 === (3))){
var inst_54730 = (state_54732[(2)]);
var state_54732__$1 = state_54732;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54732__$1,inst_54730);
} else {
if((state_val_54733 === (4))){
var inst_54702 = (state_54732[(2)]);
var state_54732__$1 = state_54732;
var statearr_54737_54753 = state_54732__$1;
(statearr_54737_54753[(2)] = inst_54702);

(statearr_54737_54753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (5))){
var _ = (function (){var statearr_54738 = state_54732;
(statearr_54738[(4)] = cljs.core.rest.call(null,(state_54732[(4)])));

return statearr_54738;
})();
var state_54732__$1 = state_54732;
var ex54736 = (state_54732__$1[(2)]);
var statearr_54739_54754 = state_54732__$1;
(statearr_54739_54754[(5)] = ex54736);


if((ex54736 instanceof Error)){
var statearr_54740_54755 = state_54732__$1;
(statearr_54740_54755[(1)] = (4));

(statearr_54740_54755[(5)] = null);

} else {
throw ex54736;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54733 === (6))){
var inst_54710 = (state_54732[(2)]);
var inst_54711 = fluree.db.util.async.throw_err.call(null,inst_54710);
var inst_54712 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_54711);
var inst_54713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54714 = [inst_54711];
var inst_54715 = (new cljs.core.PersistentVector(null,1,(5),inst_54713,inst_54714,null));
var inst_54716 = cljs.core.count.call(null,inst_54715);
var inst_54717 = ((9) + inst_54716);
var inst_54718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54719 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54721 = [inst_54711];
var inst_54722 = (new cljs.core.PersistentVector(null,1,(5),inst_54720,inst_54721,null));
var inst_54723 = ["<",inst_54722,inst_54712];
var inst_54724 = cljs.core.PersistentHashMap.fromArrays(inst_54719,inst_54723);
var inst_54725 = [inst_54724,inst_54717];
var inst_54726 = (new cljs.core.PersistentVector(null,2,(5),inst_54718,inst_54725,null));
var inst_54727 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54726);
var _ = (function (){var statearr_54741 = state_54732;
(statearr_54741[(4)] = cljs.core.rest.call(null,(state_54732[(4)])));

return statearr_54741;
})();
var state_54732__$1 = (function (){var statearr_54742 = state_54732;
(statearr_54742[(7)] = inst_54727);

return statearr_54742;
})();
var statearr_54743_54756 = state_54732__$1;
(statearr_54743_54756[(2)] = inst_54712);

(statearr_54743_54756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54744 = [null,null,null,null,null,null,null,null];
(statearr_54744[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54744[(1)] = (1));

return statearr_54744;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54732){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54732);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54745){var ex__2749__auto__ = e54745;
var statearr_54746_54757 = state_54732;
(statearr_54746_54757[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54732[(4)]))){
var statearr_54747_54758 = state_54732;
(statearr_54747_54758[(1)] = cljs.core.first.call(null,(state_54732[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54759 = state_54732;
state_54732 = G__54759;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54732){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54748 = f__2769__auto__.call(null);
(statearr_54748[(6)] = c__2768__auto__);

return statearr_54748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq54700){
var G__54701 = cljs.core.first.call(null,seq54700);
var seq54700__$1 = cljs.core.next.call(null,seq54700);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54701,seq54700__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54809 = arguments.length;
var i__4865__auto___54810 = (0);
while(true){
if((i__4865__auto___54810 < len__4864__auto___54809)){
args__4870__auto__.push((arguments[i__4865__auto___54810]));

var G__54811 = (i__4865__auto___54810 + (1));
i__4865__auto___54810 = G__54811;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54792){
var state_val_54793 = (state_54792[(1)]);
if((state_val_54793 === (1))){
var state_54792__$1 = state_54792;
var statearr_54794_54812 = state_54792__$1;
(statearr_54794_54812[(2)] = null);

(statearr_54794_54812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54793 === (2))){
var _ = (function (){var statearr_54795 = state_54792;
(statearr_54795[(4)] = cljs.core.cons.call(null,(5),(state_54792[(4)])));

return statearr_54795;
})();
var inst_54768 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54792__$1 = state_54792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54792__$1,(6),inst_54768);
} else {
if((state_val_54793 === (3))){
var inst_54790 = (state_54792[(2)]);
var state_54792__$1 = state_54792;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54792__$1,inst_54790);
} else {
if((state_val_54793 === (4))){
var inst_54762 = (state_54792[(2)]);
var state_54792__$1 = state_54792;
var statearr_54797_54813 = state_54792__$1;
(statearr_54797_54813[(2)] = inst_54762);

(statearr_54797_54813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54793 === (5))){
var _ = (function (){var statearr_54798 = state_54792;
(statearr_54798[(4)] = cljs.core.rest.call(null,(state_54792[(4)])));

return statearr_54798;
})();
var state_54792__$1 = state_54792;
var ex54796 = (state_54792__$1[(2)]);
var statearr_54799_54814 = state_54792__$1;
(statearr_54799_54814[(5)] = ex54796);


if((ex54796 instanceof Error)){
var statearr_54800_54815 = state_54792__$1;
(statearr_54800_54815[(1)] = (4));

(statearr_54800_54815[(5)] = null);

} else {
throw ex54796;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54793 === (6))){
var inst_54770 = (state_54792[(2)]);
var inst_54771 = fluree.db.util.async.throw_err.call(null,inst_54770);
var inst_54772 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_54771);
var inst_54773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54774 = [inst_54771];
var inst_54775 = (new cljs.core.PersistentVector(null,1,(5),inst_54773,inst_54774,null));
var inst_54776 = cljs.core.count.call(null,inst_54775);
var inst_54777 = ((9) + inst_54776);
var inst_54778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54779 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54781 = [inst_54771];
var inst_54782 = (new cljs.core.PersistentVector(null,1,(5),inst_54780,inst_54781,null));
var inst_54783 = ["<=",inst_54782,inst_54772];
var inst_54784 = cljs.core.PersistentHashMap.fromArrays(inst_54779,inst_54783);
var inst_54785 = [inst_54784,inst_54777];
var inst_54786 = (new cljs.core.PersistentVector(null,2,(5),inst_54778,inst_54785,null));
var inst_54787 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54786);
var _ = (function (){var statearr_54801 = state_54792;
(statearr_54801[(4)] = cljs.core.rest.call(null,(state_54792[(4)])));

return statearr_54801;
})();
var state_54792__$1 = (function (){var statearr_54802 = state_54792;
(statearr_54802[(7)] = inst_54787);

return statearr_54802;
})();
var statearr_54803_54816 = state_54792__$1;
(statearr_54803_54816[(2)] = inst_54772);

(statearr_54803_54816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54804 = [null,null,null,null,null,null,null,null];
(statearr_54804[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54804[(1)] = (1));

return statearr_54804;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54792){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54792);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54805){var ex__2749__auto__ = e54805;
var statearr_54806_54817 = state_54792;
(statearr_54806_54817[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54792[(4)]))){
var statearr_54807_54818 = state_54792;
(statearr_54807_54818[(1)] = cljs.core.first.call(null,(state_54792[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54819 = state_54792;
state_54792 = G__54819;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54792){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54808 = f__2769__auto__.call(null);
(statearr_54808[(6)] = c__2768__auto__);

return statearr_54808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq54760){
var G__54761 = cljs.core.first.call(null,seq54760);
var seq54760__$1 = cljs.core.next.call(null,seq54760);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54761,seq54760__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54869 = arguments.length;
var i__4865__auto___54870 = (0);
while(true){
if((i__4865__auto___54870 < len__4864__auto___54869)){
args__4870__auto__.push((arguments[i__4865__auto___54870]));

var G__54871 = (i__4865__auto___54870 + (1));
i__4865__auto___54870 = G__54871;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54852){
var state_val_54853 = (state_54852[(1)]);
if((state_val_54853 === (1))){
var state_54852__$1 = state_54852;
var statearr_54854_54872 = state_54852__$1;
(statearr_54854_54872[(2)] = null);

(statearr_54854_54872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (2))){
var _ = (function (){var statearr_54855 = state_54852;
(statearr_54855[(4)] = cljs.core.cons.call(null,(5),(state_54852[(4)])));

return statearr_54855;
})();
var inst_54828 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54852__$1 = state_54852;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54852__$1,(6),inst_54828);
} else {
if((state_val_54853 === (3))){
var inst_54850 = (state_54852[(2)]);
var state_54852__$1 = state_54852;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54852__$1,inst_54850);
} else {
if((state_val_54853 === (4))){
var inst_54822 = (state_54852[(2)]);
var state_54852__$1 = state_54852;
var statearr_54857_54873 = state_54852__$1;
(statearr_54857_54873[(2)] = inst_54822);

(statearr_54857_54873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (5))){
var _ = (function (){var statearr_54858 = state_54852;
(statearr_54858[(4)] = cljs.core.rest.call(null,(state_54852[(4)])));

return statearr_54858;
})();
var state_54852__$1 = state_54852;
var ex54856 = (state_54852__$1[(2)]);
var statearr_54859_54874 = state_54852__$1;
(statearr_54859_54874[(5)] = ex54856);


if((ex54856 instanceof Error)){
var statearr_54860_54875 = state_54852__$1;
(statearr_54860_54875[(1)] = (4));

(statearr_54860_54875[(5)] = null);

} else {
throw ex54856;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54853 === (6))){
var inst_54830 = (state_54852[(2)]);
var inst_54831 = fluree.db.util.async.throw_err.call(null,inst_54830);
var inst_54832 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_54831);
var inst_54833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54834 = [inst_54831];
var inst_54835 = (new cljs.core.PersistentVector(null,1,(5),inst_54833,inst_54834,null));
var inst_54836 = cljs.core.count.call(null,inst_54835);
var inst_54837 = ((9) + inst_54836);
var inst_54838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54839 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54841 = [inst_54831];
var inst_54842 = (new cljs.core.PersistentVector(null,1,(5),inst_54840,inst_54841,null));
var inst_54843 = [">=",inst_54842,inst_54832];
var inst_54844 = cljs.core.PersistentHashMap.fromArrays(inst_54839,inst_54843);
var inst_54845 = [inst_54844,inst_54837];
var inst_54846 = (new cljs.core.PersistentVector(null,2,(5),inst_54838,inst_54845,null));
var inst_54847 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54846);
var _ = (function (){var statearr_54861 = state_54852;
(statearr_54861[(4)] = cljs.core.rest.call(null,(state_54852[(4)])));

return statearr_54861;
})();
var state_54852__$1 = (function (){var statearr_54862 = state_54852;
(statearr_54862[(7)] = inst_54847);

return statearr_54862;
})();
var statearr_54863_54876 = state_54852__$1;
(statearr_54863_54876[(2)] = inst_54832);

(statearr_54863_54876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54864 = [null,null,null,null,null,null,null,null];
(statearr_54864[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54864[(1)] = (1));

return statearr_54864;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54852){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54852);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54865){var ex__2749__auto__ = e54865;
var statearr_54866_54877 = state_54852;
(statearr_54866_54877[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54852[(4)]))){
var statearr_54867_54878 = state_54852;
(statearr_54867_54878[(1)] = cljs.core.first.call(null,(state_54852[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54879 = state_54852;
state_54852 = G__54879;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54852){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54868 = f__2769__auto__.call(null);
(statearr_54868[(6)] = c__2768__auto__);

return statearr_54868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq54820){
var G__54821 = cljs.core.first.call(null,seq54820);
var seq54820__$1 = cljs.core.next.call(null,seq54820);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54821,seq54820__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54929 = arguments.length;
var i__4865__auto___54930 = (0);
while(true){
if((i__4865__auto___54930 < len__4864__auto___54929)){
args__4870__auto__.push((arguments[i__4865__auto___54930]));

var G__54931 = (i__4865__auto___54930 + (1));
i__4865__auto___54930 = G__54931;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54912){
var state_val_54913 = (state_54912[(1)]);
if((state_val_54913 === (1))){
var state_54912__$1 = state_54912;
var statearr_54914_54932 = state_54912__$1;
(statearr_54914_54932[(2)] = null);

(statearr_54914_54932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54913 === (2))){
var _ = (function (){var statearr_54915 = state_54912;
(statearr_54915[(4)] = cljs.core.cons.call(null,(5),(state_54912[(4)])));

return statearr_54915;
})();
var inst_54888 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54912__$1 = state_54912;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54912__$1,(6),inst_54888);
} else {
if((state_val_54913 === (3))){
var inst_54910 = (state_54912[(2)]);
var state_54912__$1 = state_54912;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54912__$1,inst_54910);
} else {
if((state_val_54913 === (4))){
var inst_54882 = (state_54912[(2)]);
var state_54912__$1 = state_54912;
var statearr_54917_54933 = state_54912__$1;
(statearr_54917_54933[(2)] = inst_54882);

(statearr_54917_54933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54913 === (5))){
var _ = (function (){var statearr_54918 = state_54912;
(statearr_54918[(4)] = cljs.core.rest.call(null,(state_54912[(4)])));

return statearr_54918;
})();
var state_54912__$1 = state_54912;
var ex54916 = (state_54912__$1[(2)]);
var statearr_54919_54934 = state_54912__$1;
(statearr_54919_54934[(5)] = ex54916);


if((ex54916 instanceof Error)){
var statearr_54920_54935 = state_54912__$1;
(statearr_54920_54935[(1)] = (4));

(statearr_54920_54935[(5)] = null);

} else {
throw ex54916;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54913 === (6))){
var inst_54890 = (state_54912[(2)]);
var inst_54891 = fluree.db.util.async.throw_err.call(null,inst_54890);
var inst_54892 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_54891);
var inst_54893 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54894 = [inst_54891];
var inst_54895 = (new cljs.core.PersistentVector(null,1,(5),inst_54893,inst_54894,null));
var inst_54896 = cljs.core.count.call(null,inst_54895);
var inst_54897 = ((9) + inst_54896);
var inst_54898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54899 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54901 = [inst_54891];
var inst_54902 = (new cljs.core.PersistentVector(null,1,(5),inst_54900,inst_54901,null));
var inst_54903 = ["not=",inst_54902,inst_54892];
var inst_54904 = cljs.core.PersistentHashMap.fromArrays(inst_54899,inst_54903);
var inst_54905 = [inst_54904,inst_54897];
var inst_54906 = (new cljs.core.PersistentVector(null,2,(5),inst_54898,inst_54905,null));
var inst_54907 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54906);
var _ = (function (){var statearr_54921 = state_54912;
(statearr_54921[(4)] = cljs.core.rest.call(null,(state_54912[(4)])));

return statearr_54921;
})();
var state_54912__$1 = (function (){var statearr_54922 = state_54912;
(statearr_54922[(7)] = inst_54907);

return statearr_54922;
})();
var statearr_54923_54936 = state_54912__$1;
(statearr_54923_54936[(2)] = inst_54892);

(statearr_54923_54936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54924 = [null,null,null,null,null,null,null,null];
(statearr_54924[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54924[(1)] = (1));

return statearr_54924;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54912){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54912);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54925){var ex__2749__auto__ = e54925;
var statearr_54926_54937 = state_54912;
(statearr_54926_54937[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54912[(4)]))){
var statearr_54927_54938 = state_54912;
(statearr_54927_54938[(1)] = cljs.core.first.call(null,(state_54912[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54939 = state_54912;
state_54912 = G__54939;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54912){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54928 = f__2769__auto__.call(null);
(statearr_54928[(6)] = c__2768__auto__);

return statearr_54928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq54880){
var G__54881 = cljs.core.first.call(null,seq54880);
var seq54880__$1 = cljs.core.next.call(null,seq54880);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54881,seq54880__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54989 = arguments.length;
var i__4865__auto___54990 = (0);
while(true){
if((i__4865__auto___54990 < len__4864__auto___54989)){
args__4870__auto__.push((arguments[i__4865__auto___54990]));

var G__54991 = (i__4865__auto___54990 + (1));
i__4865__auto___54990 = G__54991;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54972){
var state_val_54973 = (state_54972[(1)]);
if((state_val_54973 === (1))){
var state_54972__$1 = state_54972;
var statearr_54974_54992 = state_54972__$1;
(statearr_54974_54992[(2)] = null);

(statearr_54974_54992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54973 === (2))){
var _ = (function (){var statearr_54975 = state_54972;
(statearr_54975[(4)] = cljs.core.cons.call(null,(5),(state_54972[(4)])));

return statearr_54975;
})();
var inst_54948 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54972__$1 = state_54972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54972__$1,(6),inst_54948);
} else {
if((state_val_54973 === (3))){
var inst_54970 = (state_54972[(2)]);
var state_54972__$1 = state_54972;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54972__$1,inst_54970);
} else {
if((state_val_54973 === (4))){
var inst_54942 = (state_54972[(2)]);
var state_54972__$1 = state_54972;
var statearr_54977_54993 = state_54972__$1;
(statearr_54977_54993[(2)] = inst_54942);

(statearr_54977_54993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54973 === (5))){
var _ = (function (){var statearr_54978 = state_54972;
(statearr_54978[(4)] = cljs.core.rest.call(null,(state_54972[(4)])));

return statearr_54978;
})();
var state_54972__$1 = state_54972;
var ex54976 = (state_54972__$1[(2)]);
var statearr_54979_54994 = state_54972__$1;
(statearr_54979_54994[(5)] = ex54976);


if((ex54976 instanceof Error)){
var statearr_54980_54995 = state_54972__$1;
(statearr_54980_54995[(1)] = (4));

(statearr_54980_54995[(5)] = null);

} else {
throw ex54976;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54973 === (6))){
var inst_54950 = (state_54972[(2)]);
var inst_54951 = fluree.db.util.async.throw_err.call(null,inst_54950);
var inst_54952 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_54951);
var inst_54953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54954 = [inst_54951];
var inst_54955 = (new cljs.core.PersistentVector(null,1,(5),inst_54953,inst_54954,null));
var inst_54956 = cljs.core.count.call(null,inst_54955);
var inst_54957 = ((9) + inst_54956);
var inst_54958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54959 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54961 = [inst_54951];
var inst_54962 = (new cljs.core.PersistentVector(null,1,(5),inst_54960,inst_54961,null));
var inst_54963 = ["max",inst_54962,inst_54952];
var inst_54964 = cljs.core.PersistentHashMap.fromArrays(inst_54959,inst_54963);
var inst_54965 = [inst_54964,inst_54957];
var inst_54966 = (new cljs.core.PersistentVector(null,2,(5),inst_54958,inst_54965,null));
var inst_54967 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54966);
var _ = (function (){var statearr_54981 = state_54972;
(statearr_54981[(4)] = cljs.core.rest.call(null,(state_54972[(4)])));

return statearr_54981;
})();
var state_54972__$1 = (function (){var statearr_54982 = state_54972;
(statearr_54982[(7)] = inst_54967);

return statearr_54982;
})();
var statearr_54983_54996 = state_54972__$1;
(statearr_54983_54996[(2)] = inst_54952);

(statearr_54983_54996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54984 = [null,null,null,null,null,null,null,null];
(statearr_54984[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54984[(1)] = (1));

return statearr_54984;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54972){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54972);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54985){var ex__2749__auto__ = e54985;
var statearr_54986_54997 = state_54972;
(statearr_54986_54997[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54972[(4)]))){
var statearr_54987_54998 = state_54972;
(statearr_54987_54998[(1)] = cljs.core.first.call(null,(state_54972[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54999 = state_54972;
state_54972 = G__54999;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54972){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54988 = f__2769__auto__.call(null);
(statearr_54988[(6)] = c__2768__auto__);

return statearr_54988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq54940){
var G__54941 = cljs.core.first.call(null,seq54940);
var seq54940__$1 = cljs.core.next.call(null,seq54940);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54941,seq54940__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55049 = arguments.length;
var i__4865__auto___55050 = (0);
while(true){
if((i__4865__auto___55050 < len__4864__auto___55049)){
args__4870__auto__.push((arguments[i__4865__auto___55050]));

var G__55051 = (i__4865__auto___55050 + (1));
i__4865__auto___55050 = G__55051;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55032){
var state_val_55033 = (state_55032[(1)]);
if((state_val_55033 === (1))){
var state_55032__$1 = state_55032;
var statearr_55034_55052 = state_55032__$1;
(statearr_55034_55052[(2)] = null);

(statearr_55034_55052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55033 === (2))){
var _ = (function (){var statearr_55035 = state_55032;
(statearr_55035[(4)] = cljs.core.cons.call(null,(5),(state_55032[(4)])));

return statearr_55035;
})();
var inst_55008 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55032__$1 = state_55032;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55032__$1,(6),inst_55008);
} else {
if((state_val_55033 === (3))){
var inst_55030 = (state_55032[(2)]);
var state_55032__$1 = state_55032;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55032__$1,inst_55030);
} else {
if((state_val_55033 === (4))){
var inst_55002 = (state_55032[(2)]);
var state_55032__$1 = state_55032;
var statearr_55037_55053 = state_55032__$1;
(statearr_55037_55053[(2)] = inst_55002);

(statearr_55037_55053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55033 === (5))){
var _ = (function (){var statearr_55038 = state_55032;
(statearr_55038[(4)] = cljs.core.rest.call(null,(state_55032[(4)])));

return statearr_55038;
})();
var state_55032__$1 = state_55032;
var ex55036 = (state_55032__$1[(2)]);
var statearr_55039_55054 = state_55032__$1;
(statearr_55039_55054[(5)] = ex55036);


if((ex55036 instanceof Error)){
var statearr_55040_55055 = state_55032__$1;
(statearr_55040_55055[(1)] = (4));

(statearr_55040_55055[(5)] = null);

} else {
throw ex55036;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55033 === (6))){
var inst_55010 = (state_55032[(2)]);
var inst_55011 = fluree.db.util.async.throw_err.call(null,inst_55010);
var inst_55012 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_55011);
var inst_55013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55014 = [inst_55011];
var inst_55015 = (new cljs.core.PersistentVector(null,1,(5),inst_55013,inst_55014,null));
var inst_55016 = cljs.core.count.call(null,inst_55015);
var inst_55017 = ((9) + inst_55016);
var inst_55018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55019 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55020 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55021 = [inst_55011];
var inst_55022 = (new cljs.core.PersistentVector(null,1,(5),inst_55020,inst_55021,null));
var inst_55023 = ["min",inst_55022,inst_55012];
var inst_55024 = cljs.core.PersistentHashMap.fromArrays(inst_55019,inst_55023);
var inst_55025 = [inst_55024,inst_55017];
var inst_55026 = (new cljs.core.PersistentVector(null,2,(5),inst_55018,inst_55025,null));
var inst_55027 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55026);
var _ = (function (){var statearr_55041 = state_55032;
(statearr_55041[(4)] = cljs.core.rest.call(null,(state_55032[(4)])));

return statearr_55041;
})();
var state_55032__$1 = (function (){var statearr_55042 = state_55032;
(statearr_55042[(7)] = inst_55027);

return statearr_55042;
})();
var statearr_55043_55056 = state_55032__$1;
(statearr_55043_55056[(2)] = inst_55012);

(statearr_55043_55056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55044 = [null,null,null,null,null,null,null,null];
(statearr_55044[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55044[(1)] = (1));

return statearr_55044;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55032){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55032);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55045){var ex__2749__auto__ = e55045;
var statearr_55046_55057 = state_55032;
(statearr_55046_55057[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55032[(4)]))){
var statearr_55047_55058 = state_55032;
(statearr_55047_55058[(1)] = cljs.core.first.call(null,(state_55032[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55059 = state_55032;
state_55032 = G__55059;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55032){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55032);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55048 = f__2769__auto__.call(null);
(statearr_55048[(6)] = c__2768__auto__);

return statearr_55048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq55000){
var G__55001 = cljs.core.first.call(null,seq55000);
var seq55000__$1 = cljs.core.next.call(null,seq55000);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55001,seq55000__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__55061 = arguments.length;
switch (G__55061) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55106){
var state_val_55107 = (state_55106[(1)]);
if((state_val_55107 === (7))){
var state_55106__$1 = state_55106;
var statearr_55108_55245 = state_55106__$1;
(statearr_55108_55245[(2)] = query_map);

(statearr_55108_55245[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55107 === (1))){
var state_55106__$1 = state_55106;
var statearr_55109_55246 = state_55106__$1;
(statearr_55109_55246[(2)] = null);

(statearr_55109_55246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55107 === (4))){
var inst_55062 = (state_55106[(2)]);
var state_55106__$1 = state_55106;
var statearr_55110_55247 = state_55106__$1;
(statearr_55110_55247[(2)] = inst_55062);

(statearr_55110_55247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55107 === (13))){
var inst_55084 = (state_55106[(7)]);
var inst_55088 = (state_55106[(2)]);
var inst_55089 = fluree.db.util.async.throw_err.call(null,inst_55088);
var inst_55090 = cljs.core.nth.call(null,inst_55089,(0),null);
var inst_55091 = cljs.core.nth.call(null,inst_55089,(1),null);
var inst_55092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55093 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55095 = [inst_55084];
var inst_55096 = (new cljs.core.PersistentVector(null,1,(5),inst_55094,inst_55095,null));
var inst_55097 = ["query",inst_55096,inst_55090];
var inst_55098 = cljs.core.PersistentHashMap.fromArrays(inst_55093,inst_55097);
var inst_55099 = [inst_55098,inst_55091];
var inst_55100 = (new cljs.core.PersistentVector(null,2,(5),inst_55092,inst_55099,null));
var inst_55101 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55100);
var _ = (function (){var statearr_55111 = state_55106;
(statearr_55111[(4)] = cljs.core.rest.call(null,(state_55106[(4)])));

return statearr_55111;
})();
var state_55106__$1 = (function (){var statearr_55112 = state_55106;
(statearr_55112[(8)] = inst_55101);

return statearr_55112;
})();
var statearr_55113_55248 = state_55106__$1;
(statearr_55113_55248[(2)] = inst_55090);

(statearr_55113_55248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55107 === (6))){
var state_55106__$1 = state_55106;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55106__$1,(9),query_map);
} else {
if((state_val_55107 === (3))){
var inst_55104 = (state_55106[(2)]);
var state_55106__$1 = state_55106;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55106__$1,inst_55104);
} else {
if((state_val_55107 === (12))){
var inst_55084 = (state_55106[(7)]);
var inst_55084__$1 = (state_55106[(2)]);
var inst_55085 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55086 = fluree.db.dbfunctions.internal.query.call(null,inst_55085,inst_55084__$1);
var state_55106__$1 = (function (){var statearr_55114 = state_55106;
(statearr_55114[(7)] = inst_55084__$1);

return statearr_55114;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55106__$1,(13),inst_55086);
} else {
if((state_val_55107 === (2))){
var _ = (function (){var statearr_55115 = state_55106;
(statearr_55115[(4)] = cljs.core.cons.call(null,(5),(state_55106[(4)])));

return statearr_55115;
})();
var inst_55071 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_55106__$1 = state_55106;
if(inst_55071){
var statearr_55116_55249 = state_55106__$1;
(statearr_55116_55249[(1)] = (6));

} else {
var statearr_55117_55250 = state_55106__$1;
(statearr_55117_55250[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55107 === (11))){
var inst_55078 = (state_55106[(9)]);
var state_55106__$1 = state_55106;
var statearr_55119_55251 = state_55106__$1;
(statearr_55119_55251[(2)] = inst_55078);

(statearr_55119_55251[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55107 === (9))){
var inst_55074 = (state_55106[(2)]);
var inst_55075 = fluree.db.util.async.throw_err.call(null,inst_55074);
var state_55106__$1 = state_55106;
var statearr_55120_55252 = state_55106__$1;
(statearr_55120_55252[(2)] = inst_55075);

(statearr_55120_55252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55107 === (5))){
var _ = (function (){var statearr_55121 = state_55106;
(statearr_55121[(4)] = cljs.core.rest.call(null,(state_55106[(4)])));

return statearr_55121;
})();
var state_55106__$1 = state_55106;
var ex55118 = (state_55106__$1[(2)]);
var statearr_55122_55253 = state_55106__$1;
(statearr_55122_55253[(5)] = ex55118);


if((ex55118 instanceof Error)){
var statearr_55123_55254 = state_55106__$1;
(statearr_55123_55254[(1)] = (4));

(statearr_55123_55254[(5)] = null);

} else {
throw ex55118;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55107 === (10))){
var inst_55078 = (state_55106[(9)]);
var inst_55081 = fluree.db.util.json.parse.call(null,inst_55078);
var state_55106__$1 = state_55106;
var statearr_55124_55255 = state_55106__$1;
(statearr_55124_55255[(2)] = inst_55081);

(statearr_55124_55255[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55107 === (8))){
var inst_55078 = (state_55106[(9)]);
var inst_55078__$1 = (state_55106[(2)]);
var inst_55079 = typeof inst_55078__$1 === 'string';
var state_55106__$1 = (function (){var statearr_55125 = state_55106;
(statearr_55125[(9)] = inst_55078__$1);

return statearr_55125;
})();
if(cljs.core.truth_(inst_55079)){
var statearr_55126_55256 = state_55106__$1;
(statearr_55126_55256[(1)] = (10));

} else {
var statearr_55127_55257 = state_55106__$1;
(statearr_55127_55257[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55128 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55128[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55128[(1)] = (1));

return statearr_55128;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55106){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55106);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55129){var ex__2749__auto__ = e55129;
var statearr_55130_55258 = state_55106;
(statearr_55130_55258[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55106[(4)]))){
var statearr_55131_55259 = state_55106;
(statearr_55131_55259[(1)] = cljs.core.first.call(null,(state_55106[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55260 = state_55106;
state_55106 = G__55260;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55106){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55132 = f__2769__auto__.call(null);
(statearr_55132[(6)] = c__2768__auto__);

return statearr_55132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55203){
var state_val_55204 = (state_55203[(1)]);
if((state_val_55204 === (7))){
var state_55203__$1 = state_55203;
var statearr_55205_55261 = state_55203__$1;
(statearr_55205_55261[(2)] = select);

(statearr_55205_55261[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (20))){
var inst_55173 = (state_55203[(2)]);
var inst_55174 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_55203__$1 = (function (){var statearr_55206 = state_55203;
(statearr_55206[(7)] = inst_55173);

return statearr_55206;
})();
if(inst_55174){
var statearr_55207_55262 = state_55203__$1;
(statearr_55207_55262[(1)] = (22));

} else {
var statearr_55208_55263 = state_55203__$1;
(statearr_55208_55263[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (1))){
var state_55203__$1 = state_55203;
var statearr_55209_55264 = state_55203__$1;
(statearr_55209_55264[(2)] = null);

(statearr_55209_55264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (24))){
var inst_55157 = (state_55203[(8)]);
var inst_55149 = (state_55203[(9)]);
var inst_55165 = (state_55203[(10)]);
var inst_55173 = (state_55203[(7)]);
var inst_55181 = (state_55203[(2)]);
var inst_55182 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55183 = fluree.db.dbfunctions.internal.query.call(null,inst_55182,inst_55149,inst_55157,inst_55165,inst_55173,inst_55181);
var state_55203__$1 = state_55203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55203__$1,(26),inst_55183);
} else {
if((state_val_55204 === (4))){
var inst_55133 = (state_55203[(2)]);
var state_55203__$1 = state_55203;
var statearr_55210_55265 = state_55203__$1;
(statearr_55210_55265[(2)] = inst_55133);

(statearr_55210_55265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (15))){
var state_55203__$1 = state_55203;
var statearr_55211_55266 = state_55203__$1;
(statearr_55211_55266[(2)] = where);

(statearr_55211_55266[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (21))){
var inst_55169 = (state_55203[(2)]);
var inst_55170 = fluree.db.util.async.throw_err.call(null,inst_55169);
var state_55203__$1 = state_55203;
var statearr_55212_55267 = state_55203__$1;
(statearr_55212_55267[(2)] = inst_55170);

(statearr_55212_55267[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (13))){
var inst_55153 = (state_55203[(2)]);
var inst_55154 = fluree.db.util.async.throw_err.call(null,inst_55153);
var state_55203__$1 = state_55203;
var statearr_55213_55268 = state_55203__$1;
(statearr_55213_55268[(2)] = inst_55154);

(statearr_55213_55268[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (22))){
var state_55203__$1 = state_55203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55203__$1,(25),limit);
} else {
if((state_val_55204 === (6))){
var state_55203__$1 = state_55203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55203__$1,(9),select);
} else {
if((state_val_55204 === (25))){
var inst_55177 = (state_55203[(2)]);
var inst_55178 = fluree.db.util.async.throw_err.call(null,inst_55177);
var state_55203__$1 = state_55203;
var statearr_55214_55269 = state_55203__$1;
(statearr_55214_55269[(2)] = inst_55178);

(statearr_55214_55269[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (17))){
var inst_55161 = (state_55203[(2)]);
var inst_55162 = fluree.db.util.async.throw_err.call(null,inst_55161);
var state_55203__$1 = state_55203;
var statearr_55215_55270 = state_55203__$1;
(statearr_55215_55270[(2)] = inst_55162);

(statearr_55215_55270[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (3))){
var inst_55201 = (state_55203[(2)]);
var state_55203__$1 = state_55203;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55203__$1,inst_55201);
} else {
if((state_val_55204 === (12))){
var inst_55157 = (state_55203[(2)]);
var inst_55158 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_55203__$1 = (function (){var statearr_55216 = state_55203;
(statearr_55216[(8)] = inst_55157);

return statearr_55216;
})();
if(inst_55158){
var statearr_55217_55271 = state_55203__$1;
(statearr_55217_55271[(1)] = (14));

} else {
var statearr_55218_55272 = state_55203__$1;
(statearr_55218_55272[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (2))){
var _ = (function (){var statearr_55219 = state_55203;
(statearr_55219[(4)] = cljs.core.cons.call(null,(5),(state_55203[(4)])));

return statearr_55219;
})();
var inst_55142 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_55203__$1 = state_55203;
if(inst_55142){
var statearr_55220_55273 = state_55203__$1;
(statearr_55220_55273[(1)] = (6));

} else {
var statearr_55221_55274 = state_55203__$1;
(statearr_55221_55274[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (23))){
var state_55203__$1 = state_55203;
var statearr_55222_55275 = state_55203__$1;
(statearr_55222_55275[(2)] = limit);

(statearr_55222_55275[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (19))){
var state_55203__$1 = state_55203;
var statearr_55223_55276 = state_55203__$1;
(statearr_55223_55276[(2)] = block);

(statearr_55223_55276[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (11))){
var state_55203__$1 = state_55203;
var statearr_55225_55277 = state_55203__$1;
(statearr_55225_55277[(2)] = from);

(statearr_55225_55277[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (9))){
var inst_55145 = (state_55203[(2)]);
var inst_55146 = fluree.db.util.async.throw_err.call(null,inst_55145);
var state_55203__$1 = state_55203;
var statearr_55226_55278 = state_55203__$1;
(statearr_55226_55278[(2)] = inst_55146);

(statearr_55226_55278[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (5))){
var _ = (function (){var statearr_55227 = state_55203;
(statearr_55227[(4)] = cljs.core.rest.call(null,(state_55203[(4)])));

return statearr_55227;
})();
var state_55203__$1 = state_55203;
var ex55224 = (state_55203__$1[(2)]);
var statearr_55228_55279 = state_55203__$1;
(statearr_55228_55279[(5)] = ex55224);


if((ex55224 instanceof Error)){
var statearr_55229_55280 = state_55203__$1;
(statearr_55229_55280[(1)] = (4));

(statearr_55229_55280[(5)] = null);

} else {
throw ex55224;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (14))){
var state_55203__$1 = state_55203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55203__$1,(17),where);
} else {
if((state_val_55204 === (26))){
var inst_55157 = (state_55203[(8)]);
var inst_55149 = (state_55203[(9)]);
var inst_55165 = (state_55203[(10)]);
var inst_55173 = (state_55203[(7)]);
var inst_55185 = (state_55203[(2)]);
var inst_55186 = fluree.db.util.async.throw_err.call(null,inst_55185);
var inst_55187 = cljs.core.nth.call(null,inst_55186,(0),null);
var inst_55188 = cljs.core.nth.call(null,inst_55186,(1),null);
var inst_55189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55190 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55192 = [inst_55149,inst_55157,inst_55165,inst_55173];
var inst_55193 = (new cljs.core.PersistentVector(null,4,(5),inst_55191,inst_55192,null));
var inst_55194 = ["query",inst_55193,inst_55187];
var inst_55195 = cljs.core.PersistentHashMap.fromArrays(inst_55190,inst_55194);
var inst_55196 = [inst_55195,inst_55188];
var inst_55197 = (new cljs.core.PersistentVector(null,2,(5),inst_55189,inst_55196,null));
var inst_55198 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55197);
var _ = (function (){var statearr_55230 = state_55203;
(statearr_55230[(4)] = cljs.core.rest.call(null,(state_55203[(4)])));

return statearr_55230;
})();
var state_55203__$1 = (function (){var statearr_55231 = state_55203;
(statearr_55231[(11)] = inst_55198);

return statearr_55231;
})();
var statearr_55232_55281 = state_55203__$1;
(statearr_55232_55281[(2)] = inst_55187);

(statearr_55232_55281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (16))){
var inst_55165 = (state_55203[(2)]);
var inst_55166 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_55203__$1 = (function (){var statearr_55233 = state_55203;
(statearr_55233[(10)] = inst_55165);

return statearr_55233;
})();
if(inst_55166){
var statearr_55234_55282 = state_55203__$1;
(statearr_55234_55282[(1)] = (18));

} else {
var statearr_55235_55283 = state_55203__$1;
(statearr_55235_55283[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55204 === (10))){
var state_55203__$1 = state_55203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55203__$1,(13),from);
} else {
if((state_val_55204 === (18))){
var state_55203__$1 = state_55203;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55203__$1,(21),block);
} else {
if((state_val_55204 === (8))){
var inst_55149 = (state_55203[(2)]);
var inst_55150 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_55203__$1 = (function (){var statearr_55236 = state_55203;
(statearr_55236[(9)] = inst_55149);

return statearr_55236;
})();
if(inst_55150){
var statearr_55237_55284 = state_55203__$1;
(statearr_55237_55284[(1)] = (10));

} else {
var statearr_55238_55285 = state_55203__$1;
(statearr_55238_55285[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55239 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55239[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55239[(1)] = (1));

return statearr_55239;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55203){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55203);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55240){var ex__2749__auto__ = e55240;
var statearr_55241_55286 = state_55203;
(statearr_55241_55286[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55203[(4)]))){
var statearr_55242_55287 = state_55203;
(statearr_55242_55287[(1)] = cljs.core.first.call(null,(state_55203[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55288 = state_55203;
state_55203 = G__55288;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55203){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55243 = f__2769__auto__.call(null);
(statearr_55243[(6)] = c__2768__auto__);

return statearr_55243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55344){
var state_val_55345 = (state_55344[(1)]);
if((state_val_55345 === (7))){
var state_55344__$1 = state_55344;
var statearr_55346_55377 = state_55344__$1;
(statearr_55346_55377[(2)] = startSubject);

(statearr_55346_55377[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55345 === (1))){
var state_55344__$1 = state_55344;
var statearr_55347_55378 = state_55344__$1;
(statearr_55347_55378[(2)] = null);

(statearr_55347_55378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55345 === (4))){
var inst_55289 = (state_55344[(2)]);
var state_55344__$1 = state_55344;
var statearr_55348_55379 = state_55344__$1;
(statearr_55348_55379[(2)] = inst_55289);

(statearr_55348_55379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55345 === (15))){
var inst_55321 = (state_55344[(2)]);
var inst_55322 = fluree.db.util.async.throw_err.call(null,inst_55321);
var inst_55323 = cljs.core.nth.call(null,inst_55322,(0),null);
var inst_55324 = cljs.core.nth.call(null,inst_55322,(1),null);
var inst_55325 = cljs.core.empty_QMARK_.call(null,inst_55323);
var state_55344__$1 = (function (){var statearr_55349 = state_55344;
(statearr_55349[(7)] = inst_55324);

return statearr_55349;
})();
if(inst_55325){
var statearr_55350_55380 = state_55344__$1;
(statearr_55350_55380[(1)] = (16));

} else {
var statearr_55351_55381 = state_55344__$1;
(statearr_55351_55381[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55345 === (13))){
var inst_55305 = (state_55344[(8)]);
var inst_55317 = (state_55344[(9)]);
var inst_55309 = (state_55344[(10)]);
var inst_55317__$1 = (state_55344[(2)]);
var inst_55318 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55319 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_55318,inst_55305,inst_55309,inst_55317__$1);
var state_55344__$1 = (function (){var statearr_55352 = state_55344;
(statearr_55352[(9)] = inst_55317__$1);

return statearr_55352;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55344__$1,(15),inst_55319);
} else {
if((state_val_55345 === (6))){
var state_55344__$1 = state_55344;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55344__$1,(9),startSubject);
} else {
if((state_val_55345 === (17))){
var state_55344__$1 = state_55344;
var statearr_55353_55382 = state_55344__$1;
(statearr_55353_55382[(2)] = true);

(statearr_55353_55382[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55345 === (3))){
var inst_55342 = (state_55344[(2)]);
var state_55344__$1 = state_55344;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55344__$1,inst_55342);
} else {
if((state_val_55345 === (12))){
var state_55344__$1 = state_55344;
var statearr_55354_55383 = state_55344__$1;
(statearr_55354_55383[(2)] = endSubject);

(statearr_55354_55383[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55345 === (2))){
var _ = (function (){var statearr_55355 = state_55344;
(statearr_55355[(4)] = cljs.core.cons.call(null,(5),(state_55344[(4)])));

return statearr_55355;
})();
var inst_55298 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_55344__$1 = state_55344;
if(inst_55298){
var statearr_55356_55384 = state_55344__$1;
(statearr_55356_55384[(1)] = (6));

} else {
var statearr_55357_55385 = state_55344__$1;
(statearr_55357_55385[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55345 === (11))){
var state_55344__$1 = state_55344;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55344__$1,(14),endSubject);
} else {
if((state_val_55345 === (9))){
var inst_55301 = (state_55344[(2)]);
var inst_55302 = fluree.db.util.async.throw_err.call(null,inst_55301);
var state_55344__$1 = state_55344;
var statearr_55359_55386 = state_55344__$1;
(statearr_55359_55386[(2)] = inst_55302);

(statearr_55359_55386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55345 === (5))){
var _ = (function (){var statearr_55360 = state_55344;
(statearr_55360[(4)] = cljs.core.rest.call(null,(state_55344[(4)])));

return statearr_55360;
})();
var state_55344__$1 = state_55344;
var ex55358 = (state_55344__$1[(2)]);
var statearr_55361_55387 = state_55344__$1;
(statearr_55361_55387[(5)] = ex55358);


if((ex55358 instanceof Error)){
var statearr_55362_55388 = state_55344__$1;
(statearr_55362_55388[(1)] = (4));

(statearr_55362_55388[(5)] = null);

} else {
throw ex55358;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55345 === (14))){
var inst_55313 = (state_55344[(2)]);
var inst_55314 = fluree.db.util.async.throw_err.call(null,inst_55313);
var state_55344__$1 = state_55344;
var statearr_55363_55389 = state_55344__$1;
(statearr_55363_55389[(2)] = inst_55314);

(statearr_55363_55389[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55345 === (16))){
var state_55344__$1 = state_55344;
var statearr_55364_55390 = state_55344__$1;
(statearr_55364_55390[(2)] = false);

(statearr_55364_55390[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55345 === (10))){
var inst_55308 = (state_55344[(2)]);
var inst_55309 = fluree.db.util.async.throw_err.call(null,inst_55308);
var inst_55310 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_55344__$1 = (function (){var statearr_55365 = state_55344;
(statearr_55365[(10)] = inst_55309);

return statearr_55365;
})();
if(inst_55310){
var statearr_55366_55391 = state_55344__$1;
(statearr_55366_55391[(1)] = (11));

} else {
var statearr_55367_55392 = state_55344__$1;
(statearr_55367_55392[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55345 === (18))){
var inst_55324 = (state_55344[(7)]);
var inst_55305 = (state_55344[(8)]);
var inst_55317 = (state_55344[(9)]);
var inst_55309 = (state_55344[(10)]);
var inst_55329 = (state_55344[(2)]);
var inst_55330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55331 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55333 = [inst_55305,inst_55309,inst_55317];
var inst_55334 = (new cljs.core.PersistentVector(null,3,(5),inst_55332,inst_55333,null));
var inst_55335 = ["relationship?",inst_55334,inst_55329];
var inst_55336 = cljs.core.PersistentHashMap.fromArrays(inst_55331,inst_55335);
var inst_55337 = [inst_55336,inst_55324];
var inst_55338 = (new cljs.core.PersistentVector(null,2,(5),inst_55330,inst_55337,null));
var inst_55339 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55338);
var _ = (function (){var statearr_55368 = state_55344;
(statearr_55368[(4)] = cljs.core.rest.call(null,(state_55344[(4)])));

return statearr_55368;
})();
var state_55344__$1 = (function (){var statearr_55369 = state_55344;
(statearr_55369[(11)] = inst_55339);

return statearr_55369;
})();
var statearr_55370_55393 = state_55344__$1;
(statearr_55370_55393[(2)] = inst_55329);

(statearr_55370_55393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55345 === (8))){
var inst_55305 = (state_55344[(2)]);
var inst_55306 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_55344__$1 = (function (){var statearr_55371 = state_55344;
(statearr_55371[(8)] = inst_55305);

return statearr_55371;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55344__$1,(10),inst_55306);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_55372 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55372[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__);

(statearr_55372[(1)] = (1));

return statearr_55372;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1 = (function (state_55344){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55344);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55373){var ex__2749__auto__ = e55373;
var statearr_55374_55394 = state_55344;
(statearr_55374_55394[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55344[(4)]))){
var statearr_55375_55395 = state_55344;
(statearr_55375_55395[(1)] = cljs.core.first.call(null,(state_55344[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55396 = state_55344;
state_55344 = G__55396;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__ = function(state_55344){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1.call(this,state_55344);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55376 = f__2769__auto__.call(null);
(statearr_55376[(6)] = c__2768__auto__);

return statearr_55376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55433){
var state_val_55434 = (state_55433[(1)]);
if((state_val_55434 === (7))){
var state_55433__$1 = state_55433;
var statearr_55435_55455 = state_55433__$1;
(statearr_55435_55455[(2)] = pred_name);

(statearr_55435_55455[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55434 === (1))){
var state_55433__$1 = state_55433;
var statearr_55436_55456 = state_55433__$1;
(statearr_55436_55456[(2)] = null);

(statearr_55436_55456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55434 === (4))){
var inst_55397 = (state_55433[(2)]);
var state_55433__$1 = state_55433;
var statearr_55437_55457 = state_55433__$1;
(statearr_55437_55457[(2)] = inst_55397);

(statearr_55437_55457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55434 === (6))){
var state_55433__$1 = state_55433;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55433__$1,(9),pred_name);
} else {
if((state_val_55434 === (3))){
var inst_55431 = (state_55433[(2)]);
var state_55433__$1 = state_55433;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55433__$1,inst_55431);
} else {
if((state_val_55434 === (2))){
var _ = (function (){var statearr_55439 = state_55433;
(statearr_55439[(4)] = cljs.core.cons.call(null,(5),(state_55433[(4)])));

return statearr_55439;
})();
var inst_55406 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_55433__$1 = state_55433;
if(inst_55406){
var statearr_55440_55458 = state_55433__$1;
(statearr_55440_55458[(1)] = (6));

} else {
var statearr_55441_55459 = state_55433__$1;
(statearr_55441_55459[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55434 === (9))){
var inst_55409 = (state_55433[(2)]);
var inst_55410 = fluree.db.util.async.throw_err.call(null,inst_55409);
var state_55433__$1 = state_55433;
var statearr_55442_55460 = state_55433__$1;
(statearr_55442_55460[(2)] = inst_55410);

(statearr_55442_55460[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55434 === (5))){
var _ = (function (){var statearr_55443 = state_55433;
(statearr_55443[(4)] = cljs.core.rest.call(null,(state_55433[(4)])));

return statearr_55443;
})();
var state_55433__$1 = state_55433;
var ex55438 = (state_55433__$1[(2)]);
var statearr_55444_55461 = state_55433__$1;
(statearr_55444_55461[(5)] = ex55438);


if((ex55438 instanceof Error)){
var statearr_55445_55462 = state_55433__$1;
(statearr_55445_55462[(1)] = (4));

(statearr_55445_55462[(5)] = null);

} else {
throw ex55438;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55434 === (10))){
var inst_55413 = (state_55433[(7)]);
var inst_55417 = (state_55433[(2)]);
var inst_55418 = fluree.db.util.async.throw_err.call(null,inst_55417);
var inst_55419 = cljs.core.nth.call(null,inst_55418,(0),null);
var inst_55420 = cljs.core.nth.call(null,inst_55418,(1),null);
var inst_55421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55422 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55423 = ["max-pred-val",inst_55413,inst_55419];
var inst_55424 = cljs.core.PersistentHashMap.fromArrays(inst_55422,inst_55423);
var inst_55425 = (inst_55420 + (10));
var inst_55426 = [inst_55424,inst_55425];
var inst_55427 = (new cljs.core.PersistentVector(null,2,(5),inst_55421,inst_55426,null));
var inst_55428 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55427);
var _ = (function (){var statearr_55446 = state_55433;
(statearr_55446[(4)] = cljs.core.rest.call(null,(state_55433[(4)])));

return statearr_55446;
})();
var state_55433__$1 = (function (){var statearr_55447 = state_55433;
(statearr_55447[(8)] = inst_55428);

return statearr_55447;
})();
var statearr_55448_55463 = state_55433__$1;
(statearr_55448_55463[(2)] = inst_55419);

(statearr_55448_55463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55434 === (8))){
var inst_55413 = (state_55433[(7)]);
var inst_55413__$1 = (state_55433[(2)]);
var inst_55414 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55415 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_55414,inst_55413__$1,null);
var state_55433__$1 = (function (){var statearr_55449 = state_55433;
(statearr_55449[(7)] = inst_55413__$1);

return statearr_55449;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55433__$1,(10),inst_55415);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0 = (function (){
var statearr_55450 = [null,null,null,null,null,null,null,null,null];
(statearr_55450[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__);

(statearr_55450[(1)] = (1));

return statearr_55450;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1 = (function (state_55433){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55433);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55451){var ex__2749__auto__ = e55451;
var statearr_55452_55464 = state_55433;
(statearr_55452_55464[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55433[(4)]))){
var statearr_55453_55465 = state_55433;
(statearr_55453_55465[(1)] = cljs.core.first.call(null,(state_55433[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55466 = state_55433;
state_55433 = G__55466;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__ = function(state_55433){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1.call(this,state_55433);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55454 = f__2769__auto__.call(null);
(statearr_55454[(6)] = c__2768__auto__);

return statearr_55454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55493){
var state_val_55494 = (state_55493[(1)]);
if((state_val_55494 === (7))){
var state_55493__$1 = state_55493;
var statearr_55495_55514 = state_55493__$1;
(statearr_55495_55514[(2)] = n);

(statearr_55495_55514[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55494 === (1))){
var state_55493__$1 = state_55493;
var statearr_55496_55515 = state_55493__$1;
(statearr_55496_55515[(2)] = null);

(statearr_55496_55515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55494 === (4))){
var inst_55467 = (state_55493[(2)]);
var state_55493__$1 = state_55493;
var statearr_55497_55516 = state_55493__$1;
(statearr_55497_55516[(2)] = inst_55467);

(statearr_55497_55516[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55494 === (6))){
var state_55493__$1 = state_55493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55493__$1,(9),n);
} else {
if((state_val_55494 === (3))){
var inst_55491 = (state_55493[(2)]);
var state_55493__$1 = state_55493;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55493__$1,inst_55491);
} else {
if((state_val_55494 === (2))){
var _ = (function (){var statearr_55499 = state_55493;
(statearr_55499[(4)] = cljs.core.cons.call(null,(5),(state_55493[(4)])));

return statearr_55499;
})();
var inst_55473 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55493__$1 = state_55493;
if(inst_55473){
var statearr_55500_55517 = state_55493__$1;
(statearr_55500_55517[(1)] = (6));

} else {
var statearr_55501_55518 = state_55493__$1;
(statearr_55501_55518[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55494 === (9))){
var inst_55476 = (state_55493[(2)]);
var inst_55477 = fluree.db.util.async.throw_err.call(null,inst_55476);
var state_55493__$1 = state_55493;
var statearr_55502_55519 = state_55493__$1;
(statearr_55502_55519[(2)] = inst_55477);

(statearr_55502_55519[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55494 === (5))){
var _ = (function (){var statearr_55503 = state_55493;
(statearr_55503[(4)] = cljs.core.rest.call(null,(state_55493[(4)])));

return statearr_55503;
})();
var state_55493__$1 = state_55493;
var ex55498 = (state_55493__$1[(2)]);
var statearr_55504_55520 = state_55493__$1;
(statearr_55504_55520[(5)] = ex55498);


if((ex55498 instanceof Error)){
var statearr_55505_55521 = state_55493__$1;
(statearr_55505_55521[(1)] = (4));

(statearr_55505_55521[(5)] = null);

} else {
throw ex55498;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55494 === (8))){
var inst_55480 = (state_55493[(2)]);
var inst_55481 = fluree.db.dbfunctions.internal.inc.call(null,inst_55480);
var inst_55482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55483 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55484 = ["inc",inst_55480,inst_55481];
var inst_55485 = cljs.core.PersistentHashMap.fromArrays(inst_55483,inst_55484);
var inst_55486 = [inst_55485,(10)];
var inst_55487 = (new cljs.core.PersistentVector(null,2,(5),inst_55482,inst_55486,null));
var inst_55488 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55487);
var _ = (function (){var statearr_55506 = state_55493;
(statearr_55506[(4)] = cljs.core.rest.call(null,(state_55493[(4)])));

return statearr_55506;
})();
var state_55493__$1 = (function (){var statearr_55507 = state_55493;
(statearr_55507[(7)] = inst_55488);

return statearr_55507;
})();
var statearr_55508_55522 = state_55493__$1;
(statearr_55508_55522[(2)] = inst_55481);

(statearr_55508_55522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0 = (function (){
var statearr_55509 = [null,null,null,null,null,null,null,null];
(statearr_55509[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__);

(statearr_55509[(1)] = (1));

return statearr_55509;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1 = (function (state_55493){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55493);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55510){var ex__2749__auto__ = e55510;
var statearr_55511_55523 = state_55493;
(statearr_55511_55523[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55493[(4)]))){
var statearr_55512_55524 = state_55493;
(statearr_55512_55524[(1)] = cljs.core.first.call(null,(state_55493[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55525 = state_55493;
state_55493 = G__55525;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__ = function(state_55493){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1.call(this,state_55493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55513 = f__2769__auto__.call(null);
(statearr_55513[(6)] = c__2768__auto__);

return statearr_55513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55552){
var state_val_55553 = (state_55552[(1)]);
if((state_val_55553 === (7))){
var state_55552__$1 = state_55552;
var statearr_55554_55573 = state_55552__$1;
(statearr_55554_55573[(2)] = n);

(statearr_55554_55573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55553 === (1))){
var state_55552__$1 = state_55552;
var statearr_55555_55574 = state_55552__$1;
(statearr_55555_55574[(2)] = null);

(statearr_55555_55574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55553 === (4))){
var inst_55526 = (state_55552[(2)]);
var state_55552__$1 = state_55552;
var statearr_55556_55575 = state_55552__$1;
(statearr_55556_55575[(2)] = inst_55526);

(statearr_55556_55575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55553 === (6))){
var state_55552__$1 = state_55552;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55552__$1,(9),n);
} else {
if((state_val_55553 === (3))){
var inst_55550 = (state_55552[(2)]);
var state_55552__$1 = state_55552;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55552__$1,inst_55550);
} else {
if((state_val_55553 === (2))){
var _ = (function (){var statearr_55558 = state_55552;
(statearr_55558[(4)] = cljs.core.cons.call(null,(5),(state_55552[(4)])));

return statearr_55558;
})();
var inst_55532 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55552__$1 = state_55552;
if(inst_55532){
var statearr_55559_55576 = state_55552__$1;
(statearr_55559_55576[(1)] = (6));

} else {
var statearr_55560_55577 = state_55552__$1;
(statearr_55560_55577[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55553 === (9))){
var inst_55535 = (state_55552[(2)]);
var inst_55536 = fluree.db.util.async.throw_err.call(null,inst_55535);
var state_55552__$1 = state_55552;
var statearr_55561_55578 = state_55552__$1;
(statearr_55561_55578[(2)] = inst_55536);

(statearr_55561_55578[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55553 === (5))){
var _ = (function (){var statearr_55562 = state_55552;
(statearr_55562[(4)] = cljs.core.rest.call(null,(state_55552[(4)])));

return statearr_55562;
})();
var state_55552__$1 = state_55552;
var ex55557 = (state_55552__$1[(2)]);
var statearr_55563_55579 = state_55552__$1;
(statearr_55563_55579[(5)] = ex55557);


if((ex55557 instanceof Error)){
var statearr_55564_55580 = state_55552__$1;
(statearr_55564_55580[(1)] = (4));

(statearr_55564_55580[(5)] = null);

} else {
throw ex55557;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55553 === (8))){
var inst_55539 = (state_55552[(2)]);
var inst_55540 = fluree.db.dbfunctions.internal.dec.call(null,inst_55539);
var inst_55541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55542 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55543 = ["dec",inst_55539,inst_55540];
var inst_55544 = cljs.core.PersistentHashMap.fromArrays(inst_55542,inst_55543);
var inst_55545 = [inst_55544,(10)];
var inst_55546 = (new cljs.core.PersistentVector(null,2,(5),inst_55541,inst_55545,null));
var inst_55547 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55546);
var _ = (function (){var statearr_55565 = state_55552;
(statearr_55565[(4)] = cljs.core.rest.call(null,(state_55552[(4)])));

return statearr_55565;
})();
var state_55552__$1 = (function (){var statearr_55566 = state_55552;
(statearr_55566[(7)] = inst_55547);

return statearr_55566;
})();
var statearr_55567_55581 = state_55552__$1;
(statearr_55567_55581[(2)] = inst_55540);

(statearr_55567_55581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0 = (function (){
var statearr_55568 = [null,null,null,null,null,null,null,null];
(statearr_55568[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__);

(statearr_55568[(1)] = (1));

return statearr_55568;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1 = (function (state_55552){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55552);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55569){var ex__2749__auto__ = e55569;
var statearr_55570_55582 = state_55552;
(statearr_55570_55582[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55552[(4)]))){
var statearr_55571_55583 = state_55552;
(statearr_55571_55583[(1)] = cljs.core.first.call(null,(state_55552[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55584 = state_55552;
state_55552 = G__55584;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__ = function(state_55552){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1.call(this,state_55552);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55572 = f__2769__auto__.call(null);
(statearr_55572[(6)] = c__2768__auto__);

return statearr_55572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55634 = arguments.length;
var i__4865__auto___55635 = (0);
while(true){
if((i__4865__auto___55635 < len__4864__auto___55634)){
args__4870__auto__.push((arguments[i__4865__auto___55635]));

var G__55636 = (i__4865__auto___55635 + (1));
i__4865__auto___55635 = G__55636;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55617){
var state_val_55618 = (state_55617[(1)]);
if((state_val_55618 === (1))){
var state_55617__$1 = state_55617;
var statearr_55619_55637 = state_55617__$1;
(statearr_55619_55637[(2)] = null);

(statearr_55619_55637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55618 === (2))){
var _ = (function (){var statearr_55620 = state_55617;
(statearr_55620[(4)] = cljs.core.cons.call(null,(5),(state_55617[(4)])));

return statearr_55620;
})();
var inst_55593 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55617__$1 = state_55617;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55617__$1,(6),inst_55593);
} else {
if((state_val_55618 === (3))){
var inst_55615 = (state_55617[(2)]);
var state_55617__$1 = state_55617;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55617__$1,inst_55615);
} else {
if((state_val_55618 === (4))){
var inst_55587 = (state_55617[(2)]);
var state_55617__$1 = state_55617;
var statearr_55622_55638 = state_55617__$1;
(statearr_55622_55638[(2)] = inst_55587);

(statearr_55622_55638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55618 === (5))){
var _ = (function (){var statearr_55623 = state_55617;
(statearr_55623[(4)] = cljs.core.rest.call(null,(state_55617[(4)])));

return statearr_55623;
})();
var state_55617__$1 = state_55617;
var ex55621 = (state_55617__$1[(2)]);
var statearr_55624_55639 = state_55617__$1;
(statearr_55624_55639[(5)] = ex55621);


if((ex55621 instanceof Error)){
var statearr_55625_55640 = state_55617__$1;
(statearr_55625_55640[(1)] = (4));

(statearr_55625_55640[(5)] = null);

} else {
throw ex55621;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55618 === (6))){
var inst_55595 = (state_55617[(2)]);
var inst_55596 = fluree.db.util.async.throw_err.call(null,inst_55595);
var inst_55597 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_55596);
var inst_55598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55599 = [inst_55596];
var inst_55600 = (new cljs.core.PersistentVector(null,1,(5),inst_55598,inst_55599,null));
var inst_55601 = cljs.core.count.call(null,inst_55600);
var inst_55602 = ((9) + inst_55601);
var inst_55603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55604 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55606 = [inst_55596];
var inst_55607 = (new cljs.core.PersistentVector(null,1,(5),inst_55605,inst_55606,null));
var inst_55608 = ["+",inst_55607,inst_55597];
var inst_55609 = cljs.core.PersistentHashMap.fromArrays(inst_55604,inst_55608);
var inst_55610 = [inst_55609,inst_55602];
var inst_55611 = (new cljs.core.PersistentVector(null,2,(5),inst_55603,inst_55610,null));
var inst_55612 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55611);
var _ = (function (){var statearr_55626 = state_55617;
(statearr_55626[(4)] = cljs.core.rest.call(null,(state_55617[(4)])));

return statearr_55626;
})();
var state_55617__$1 = (function (){var statearr_55627 = state_55617;
(statearr_55627[(7)] = inst_55612);

return statearr_55627;
})();
var statearr_55628_55641 = state_55617__$1;
(statearr_55628_55641[(2)] = inst_55597);

(statearr_55628_55641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55629 = [null,null,null,null,null,null,null,null];
(statearr_55629[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55629[(1)] = (1));

return statearr_55629;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55617){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55617);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55630){var ex__2749__auto__ = e55630;
var statearr_55631_55642 = state_55617;
(statearr_55631_55642[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55617[(4)]))){
var statearr_55632_55643 = state_55617;
(statearr_55632_55643[(1)] = cljs.core.first.call(null,(state_55617[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55644 = state_55617;
state_55617 = G__55644;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55617){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55633 = f__2769__auto__.call(null);
(statearr_55633[(6)] = c__2768__auto__);

return statearr_55633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq55585){
var G__55586 = cljs.core.first.call(null,seq55585);
var seq55585__$1 = cljs.core.next.call(null,seq55585);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55586,seq55585__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55694 = arguments.length;
var i__4865__auto___55695 = (0);
while(true){
if((i__4865__auto___55695 < len__4864__auto___55694)){
args__4870__auto__.push((arguments[i__4865__auto___55695]));

var G__55696 = (i__4865__auto___55695 + (1));
i__4865__auto___55695 = G__55696;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55677){
var state_val_55678 = (state_55677[(1)]);
if((state_val_55678 === (1))){
var state_55677__$1 = state_55677;
var statearr_55679_55697 = state_55677__$1;
(statearr_55679_55697[(2)] = null);

(statearr_55679_55697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55678 === (2))){
var _ = (function (){var statearr_55680 = state_55677;
(statearr_55680[(4)] = cljs.core.cons.call(null,(5),(state_55677[(4)])));

return statearr_55680;
})();
var inst_55653 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55677__$1 = state_55677;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55677__$1,(6),inst_55653);
} else {
if((state_val_55678 === (3))){
var inst_55675 = (state_55677[(2)]);
var state_55677__$1 = state_55677;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55677__$1,inst_55675);
} else {
if((state_val_55678 === (4))){
var inst_55647 = (state_55677[(2)]);
var state_55677__$1 = state_55677;
var statearr_55682_55698 = state_55677__$1;
(statearr_55682_55698[(2)] = inst_55647);

(statearr_55682_55698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55678 === (5))){
var _ = (function (){var statearr_55683 = state_55677;
(statearr_55683[(4)] = cljs.core.rest.call(null,(state_55677[(4)])));

return statearr_55683;
})();
var state_55677__$1 = state_55677;
var ex55681 = (state_55677__$1[(2)]);
var statearr_55684_55699 = state_55677__$1;
(statearr_55684_55699[(5)] = ex55681);


if((ex55681 instanceof Error)){
var statearr_55685_55700 = state_55677__$1;
(statearr_55685_55700[(1)] = (4));

(statearr_55685_55700[(5)] = null);

} else {
throw ex55681;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55678 === (6))){
var inst_55655 = (state_55677[(2)]);
var inst_55656 = fluree.db.util.async.throw_err.call(null,inst_55655);
var inst_55657 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_55656);
var inst_55658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55659 = [inst_55656];
var inst_55660 = (new cljs.core.PersistentVector(null,1,(5),inst_55658,inst_55659,null));
var inst_55661 = cljs.core.count.call(null,inst_55660);
var inst_55662 = ((9) + inst_55661);
var inst_55663 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55664 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55666 = [inst_55656];
var inst_55667 = (new cljs.core.PersistentVector(null,1,(5),inst_55665,inst_55666,null));
var inst_55668 = ["-",inst_55667,inst_55657];
var inst_55669 = cljs.core.PersistentHashMap.fromArrays(inst_55664,inst_55668);
var inst_55670 = [inst_55669,inst_55662];
var inst_55671 = (new cljs.core.PersistentVector(null,2,(5),inst_55663,inst_55670,null));
var inst_55672 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55671);
var _ = (function (){var statearr_55686 = state_55677;
(statearr_55686[(4)] = cljs.core.rest.call(null,(state_55677[(4)])));

return statearr_55686;
})();
var state_55677__$1 = (function (){var statearr_55687 = state_55677;
(statearr_55687[(7)] = inst_55672);

return statearr_55687;
})();
var statearr_55688_55701 = state_55677__$1;
(statearr_55688_55701[(2)] = inst_55657);

(statearr_55688_55701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55689 = [null,null,null,null,null,null,null,null];
(statearr_55689[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55689[(1)] = (1));

return statearr_55689;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55677){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55677);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55690){var ex__2749__auto__ = e55690;
var statearr_55691_55702 = state_55677;
(statearr_55691_55702[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55677[(4)]))){
var statearr_55692_55703 = state_55677;
(statearr_55692_55703[(1)] = cljs.core.first.call(null,(state_55677[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55704 = state_55677;
state_55677 = G__55704;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55677){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55693 = f__2769__auto__.call(null);
(statearr_55693[(6)] = c__2768__auto__);

return statearr_55693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq55645){
var G__55646 = cljs.core.first.call(null,seq55645);
var seq55645__$1 = cljs.core.next.call(null,seq55645);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55646,seq55645__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55754 = arguments.length;
var i__4865__auto___55755 = (0);
while(true){
if((i__4865__auto___55755 < len__4864__auto___55754)){
args__4870__auto__.push((arguments[i__4865__auto___55755]));

var G__55756 = (i__4865__auto___55755 + (1));
i__4865__auto___55755 = G__55756;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55737){
var state_val_55738 = (state_55737[(1)]);
if((state_val_55738 === (1))){
var state_55737__$1 = state_55737;
var statearr_55739_55757 = state_55737__$1;
(statearr_55739_55757[(2)] = null);

(statearr_55739_55757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55738 === (2))){
var _ = (function (){var statearr_55740 = state_55737;
(statearr_55740[(4)] = cljs.core.cons.call(null,(5),(state_55737[(4)])));

return statearr_55740;
})();
var inst_55713 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55737__$1 = state_55737;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55737__$1,(6),inst_55713);
} else {
if((state_val_55738 === (3))){
var inst_55735 = (state_55737[(2)]);
var state_55737__$1 = state_55737;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55737__$1,inst_55735);
} else {
if((state_val_55738 === (4))){
var inst_55707 = (state_55737[(2)]);
var state_55737__$1 = state_55737;
var statearr_55742_55758 = state_55737__$1;
(statearr_55742_55758[(2)] = inst_55707);

(statearr_55742_55758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55738 === (5))){
var _ = (function (){var statearr_55743 = state_55737;
(statearr_55743[(4)] = cljs.core.rest.call(null,(state_55737[(4)])));

return statearr_55743;
})();
var state_55737__$1 = state_55737;
var ex55741 = (state_55737__$1[(2)]);
var statearr_55744_55759 = state_55737__$1;
(statearr_55744_55759[(5)] = ex55741);


if((ex55741 instanceof Error)){
var statearr_55745_55760 = state_55737__$1;
(statearr_55745_55760[(1)] = (4));

(statearr_55745_55760[(5)] = null);

} else {
throw ex55741;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55738 === (6))){
var inst_55715 = (state_55737[(2)]);
var inst_55716 = fluree.db.util.async.throw_err.call(null,inst_55715);
var inst_55717 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_55716);
var inst_55718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55719 = [inst_55716];
var inst_55720 = (new cljs.core.PersistentVector(null,1,(5),inst_55718,inst_55719,null));
var inst_55721 = cljs.core.count.call(null,inst_55720);
var inst_55722 = ((9) + inst_55721);
var inst_55723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55724 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55726 = [inst_55716];
var inst_55727 = (new cljs.core.PersistentVector(null,1,(5),inst_55725,inst_55726,null));
var inst_55728 = ["*",inst_55727,inst_55717];
var inst_55729 = cljs.core.PersistentHashMap.fromArrays(inst_55724,inst_55728);
var inst_55730 = [inst_55729,inst_55722];
var inst_55731 = (new cljs.core.PersistentVector(null,2,(5),inst_55723,inst_55730,null));
var inst_55732 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55731);
var _ = (function (){var statearr_55746 = state_55737;
(statearr_55746[(4)] = cljs.core.rest.call(null,(state_55737[(4)])));

return statearr_55746;
})();
var state_55737__$1 = (function (){var statearr_55747 = state_55737;
(statearr_55747[(7)] = inst_55732);

return statearr_55747;
})();
var statearr_55748_55761 = state_55737__$1;
(statearr_55748_55761[(2)] = inst_55717);

(statearr_55748_55761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55749 = [null,null,null,null,null,null,null,null];
(statearr_55749[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55749[(1)] = (1));

return statearr_55749;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55737){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55737);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55750){var ex__2749__auto__ = e55750;
var statearr_55751_55762 = state_55737;
(statearr_55751_55762[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55737[(4)]))){
var statearr_55752_55763 = state_55737;
(statearr_55752_55763[(1)] = cljs.core.first.call(null,(state_55737[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55764 = state_55737;
state_55737 = G__55764;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55737){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55753 = f__2769__auto__.call(null);
(statearr_55753[(6)] = c__2768__auto__);

return statearr_55753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq55705){
var G__55706 = cljs.core.first.call(null,seq55705);
var seq55705__$1 = cljs.core.next.call(null,seq55705);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55706,seq55705__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55814 = arguments.length;
var i__4865__auto___55815 = (0);
while(true){
if((i__4865__auto___55815 < len__4864__auto___55814)){
args__4870__auto__.push((arguments[i__4865__auto___55815]));

var G__55816 = (i__4865__auto___55815 + (1));
i__4865__auto___55815 = G__55816;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55797){
var state_val_55798 = (state_55797[(1)]);
if((state_val_55798 === (1))){
var state_55797__$1 = state_55797;
var statearr_55799_55817 = state_55797__$1;
(statearr_55799_55817[(2)] = null);

(statearr_55799_55817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (2))){
var _ = (function (){var statearr_55800 = state_55797;
(statearr_55800[(4)] = cljs.core.cons.call(null,(5),(state_55797[(4)])));

return statearr_55800;
})();
var inst_55773 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55797__$1 = state_55797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55797__$1,(6),inst_55773);
} else {
if((state_val_55798 === (3))){
var inst_55795 = (state_55797[(2)]);
var state_55797__$1 = state_55797;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55797__$1,inst_55795);
} else {
if((state_val_55798 === (4))){
var inst_55767 = (state_55797[(2)]);
var state_55797__$1 = state_55797;
var statearr_55802_55818 = state_55797__$1;
(statearr_55802_55818[(2)] = inst_55767);

(statearr_55802_55818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (5))){
var _ = (function (){var statearr_55803 = state_55797;
(statearr_55803[(4)] = cljs.core.rest.call(null,(state_55797[(4)])));

return statearr_55803;
})();
var state_55797__$1 = state_55797;
var ex55801 = (state_55797__$1[(2)]);
var statearr_55804_55819 = state_55797__$1;
(statearr_55804_55819[(5)] = ex55801);


if((ex55801 instanceof Error)){
var statearr_55805_55820 = state_55797__$1;
(statearr_55805_55820[(1)] = (4));

(statearr_55805_55820[(5)] = null);

} else {
throw ex55801;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (6))){
var inst_55775 = (state_55797[(2)]);
var inst_55776 = fluree.db.util.async.throw_err.call(null,inst_55775);
var inst_55777 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_55776);
var inst_55778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55779 = [inst_55776];
var inst_55780 = (new cljs.core.PersistentVector(null,1,(5),inst_55778,inst_55779,null));
var inst_55781 = cljs.core.count.call(null,inst_55780);
var inst_55782 = ((9) + inst_55781);
var inst_55783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55784 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55786 = [inst_55776];
var inst_55787 = (new cljs.core.PersistentVector(null,1,(5),inst_55785,inst_55786,null));
var inst_55788 = ["/",inst_55787,inst_55777];
var inst_55789 = cljs.core.PersistentHashMap.fromArrays(inst_55784,inst_55788);
var inst_55790 = [inst_55789,inst_55782];
var inst_55791 = (new cljs.core.PersistentVector(null,2,(5),inst_55783,inst_55790,null));
var inst_55792 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55791);
var _ = (function (){var statearr_55806 = state_55797;
(statearr_55806[(4)] = cljs.core.rest.call(null,(state_55797[(4)])));

return statearr_55806;
})();
var state_55797__$1 = (function (){var statearr_55807 = state_55797;
(statearr_55807[(7)] = inst_55792);

return statearr_55807;
})();
var statearr_55808_55821 = state_55797__$1;
(statearr_55808_55821[(2)] = inst_55777);

(statearr_55808_55821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55809 = [null,null,null,null,null,null,null,null];
(statearr_55809[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55809[(1)] = (1));

return statearr_55809;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55797){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55797);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55810){var ex__2749__auto__ = e55810;
var statearr_55811_55822 = state_55797;
(statearr_55811_55822[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55797[(4)]))){
var statearr_55812_55823 = state_55797;
(statearr_55812_55823[(1)] = cljs.core.first.call(null,(state_55797[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55824 = state_55797;
state_55797 = G__55824;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55797){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55813 = f__2769__auto__.call(null);
(statearr_55813[(6)] = c__2768__auto__);

return statearr_55813;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq55765){
var G__55766 = cljs.core.first.call(null,seq55765);
var seq55765__$1 = cljs.core.next.call(null,seq55765);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55766,seq55765__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55862){
var state_val_55863 = (state_55862[(1)]);
if((state_val_55863 === (7))){
var state_55862__$1 = state_55862;
var statearr_55864_55888 = state_55862__$1;
(statearr_55864_55888[(2)] = n);

(statearr_55864_55888[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55863 === (1))){
var state_55862__$1 = state_55862;
var statearr_55865_55889 = state_55862__$1;
(statearr_55865_55889[(2)] = null);

(statearr_55865_55889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55863 === (4))){
var inst_55825 = (state_55862[(2)]);
var state_55862__$1 = state_55862;
var statearr_55866_55890 = state_55862__$1;
(statearr_55866_55890[(2)] = inst_55825);

(statearr_55866_55890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55863 === (13))){
var inst_55842 = (state_55862[(2)]);
var inst_55843 = fluree.db.util.async.throw_err.call(null,inst_55842);
var state_55862__$1 = state_55862;
var statearr_55867_55891 = state_55862__$1;
(statearr_55867_55891[(2)] = inst_55843);

(statearr_55867_55891[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55863 === (6))){
var state_55862__$1 = state_55862;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55862__$1,(9),n);
} else {
if((state_val_55863 === (3))){
var inst_55860 = (state_55862[(2)]);
var state_55862__$1 = state_55862;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55862__$1,inst_55860);
} else {
if((state_val_55863 === (12))){
var inst_55838 = (state_55862[(7)]);
var inst_55846 = (state_55862[(2)]);
var inst_55847 = fluree.db.dbfunctions.internal.quot.call(null,inst_55838,inst_55846);
var inst_55848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55849 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55850 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55851 = [inst_55838,inst_55846];
var inst_55852 = (new cljs.core.PersistentVector(null,2,(5),inst_55850,inst_55851,null));
var inst_55853 = ["quot",inst_55852,inst_55847];
var inst_55854 = cljs.core.PersistentHashMap.fromArrays(inst_55849,inst_55853);
var inst_55855 = [inst_55854,(2)];
var inst_55856 = (new cljs.core.PersistentVector(null,2,(5),inst_55848,inst_55855,null));
var inst_55857 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55856);
var _ = (function (){var statearr_55868 = state_55862;
(statearr_55868[(4)] = cljs.core.rest.call(null,(state_55862[(4)])));

return statearr_55868;
})();
var state_55862__$1 = (function (){var statearr_55869 = state_55862;
(statearr_55869[(8)] = inst_55857);

return statearr_55869;
})();
var statearr_55870_55892 = state_55862__$1;
(statearr_55870_55892[(2)] = inst_55847);

(statearr_55870_55892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55863 === (2))){
var _ = (function (){var statearr_55871 = state_55862;
(statearr_55871[(4)] = cljs.core.cons.call(null,(5),(state_55862[(4)])));

return statearr_55871;
})();
var inst_55831 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55862__$1 = state_55862;
if(inst_55831){
var statearr_55872_55893 = state_55862__$1;
(statearr_55872_55893[(1)] = (6));

} else {
var statearr_55873_55894 = state_55862__$1;
(statearr_55873_55894[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55863 === (11))){
var state_55862__$1 = state_55862;
var statearr_55875_55895 = state_55862__$1;
(statearr_55875_55895[(2)] = d);

(statearr_55875_55895[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55863 === (9))){
var inst_55834 = (state_55862[(2)]);
var inst_55835 = fluree.db.util.async.throw_err.call(null,inst_55834);
var state_55862__$1 = state_55862;
var statearr_55876_55896 = state_55862__$1;
(statearr_55876_55896[(2)] = inst_55835);

(statearr_55876_55896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55863 === (5))){
var _ = (function (){var statearr_55877 = state_55862;
(statearr_55877[(4)] = cljs.core.rest.call(null,(state_55862[(4)])));

return statearr_55877;
})();
var state_55862__$1 = state_55862;
var ex55874 = (state_55862__$1[(2)]);
var statearr_55878_55897 = state_55862__$1;
(statearr_55878_55897[(5)] = ex55874);


if((ex55874 instanceof Error)){
var statearr_55879_55898 = state_55862__$1;
(statearr_55879_55898[(1)] = (4));

(statearr_55879_55898[(5)] = null);

} else {
throw ex55874;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55863 === (10))){
var state_55862__$1 = state_55862;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55862__$1,(13),d);
} else {
if((state_val_55863 === (8))){
var inst_55838 = (state_55862[(2)]);
var inst_55839 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_55862__$1 = (function (){var statearr_55880 = state_55862;
(statearr_55880[(7)] = inst_55838);

return statearr_55880;
})();
if(inst_55839){
var statearr_55881_55899 = state_55862__$1;
(statearr_55881_55899[(1)] = (10));

} else {
var statearr_55882_55900 = state_55862__$1;
(statearr_55882_55900[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0 = (function (){
var statearr_55883 = [null,null,null,null,null,null,null,null,null];
(statearr_55883[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__);

(statearr_55883[(1)] = (1));

return statearr_55883;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1 = (function (state_55862){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55862);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55884){var ex__2749__auto__ = e55884;
var statearr_55885_55901 = state_55862;
(statearr_55885_55901[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55862[(4)]))){
var statearr_55886_55902 = state_55862;
(statearr_55886_55902[(1)] = cljs.core.first.call(null,(state_55862[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55903 = state_55862;
state_55862 = G__55903;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__ = function(state_55862){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1.call(this,state_55862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55887 = f__2769__auto__.call(null);
(statearr_55887[(6)] = c__2768__auto__);

return statearr_55887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55941){
var state_val_55942 = (state_55941[(1)]);
if((state_val_55942 === (7))){
var state_55941__$1 = state_55941;
var statearr_55943_55967 = state_55941__$1;
(statearr_55943_55967[(2)] = n);

(statearr_55943_55967[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55942 === (1))){
var state_55941__$1 = state_55941;
var statearr_55944_55968 = state_55941__$1;
(statearr_55944_55968[(2)] = null);

(statearr_55944_55968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55942 === (4))){
var inst_55904 = (state_55941[(2)]);
var state_55941__$1 = state_55941;
var statearr_55945_55969 = state_55941__$1;
(statearr_55945_55969[(2)] = inst_55904);

(statearr_55945_55969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55942 === (13))){
var inst_55921 = (state_55941[(2)]);
var inst_55922 = fluree.db.util.async.throw_err.call(null,inst_55921);
var state_55941__$1 = state_55941;
var statearr_55946_55970 = state_55941__$1;
(statearr_55946_55970[(2)] = inst_55922);

(statearr_55946_55970[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55942 === (6))){
var state_55941__$1 = state_55941;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55941__$1,(9),n);
} else {
if((state_val_55942 === (3))){
var inst_55939 = (state_55941[(2)]);
var state_55941__$1 = state_55941;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55941__$1,inst_55939);
} else {
if((state_val_55942 === (12))){
var inst_55917 = (state_55941[(7)]);
var inst_55925 = (state_55941[(2)]);
var inst_55926 = fluree.db.dbfunctions.internal.mod.call(null,inst_55917,inst_55925);
var inst_55927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55928 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55930 = [inst_55917,inst_55925];
var inst_55931 = (new cljs.core.PersistentVector(null,2,(5),inst_55929,inst_55930,null));
var inst_55932 = ["mod",inst_55931,inst_55926];
var inst_55933 = cljs.core.PersistentHashMap.fromArrays(inst_55928,inst_55932);
var inst_55934 = [inst_55933,(2)];
var inst_55935 = (new cljs.core.PersistentVector(null,2,(5),inst_55927,inst_55934,null));
var inst_55936 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55935);
var _ = (function (){var statearr_55947 = state_55941;
(statearr_55947[(4)] = cljs.core.rest.call(null,(state_55941[(4)])));

return statearr_55947;
})();
var state_55941__$1 = (function (){var statearr_55948 = state_55941;
(statearr_55948[(8)] = inst_55936);

return statearr_55948;
})();
var statearr_55949_55971 = state_55941__$1;
(statearr_55949_55971[(2)] = inst_55926);

(statearr_55949_55971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55942 === (2))){
var _ = (function (){var statearr_55950 = state_55941;
(statearr_55950[(4)] = cljs.core.cons.call(null,(5),(state_55941[(4)])));

return statearr_55950;
})();
var inst_55910 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55941__$1 = state_55941;
if(inst_55910){
var statearr_55951_55972 = state_55941__$1;
(statearr_55951_55972[(1)] = (6));

} else {
var statearr_55952_55973 = state_55941__$1;
(statearr_55952_55973[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55942 === (11))){
var state_55941__$1 = state_55941;
var statearr_55954_55974 = state_55941__$1;
(statearr_55954_55974[(2)] = d);

(statearr_55954_55974[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55942 === (9))){
var inst_55913 = (state_55941[(2)]);
var inst_55914 = fluree.db.util.async.throw_err.call(null,inst_55913);
var state_55941__$1 = state_55941;
var statearr_55955_55975 = state_55941__$1;
(statearr_55955_55975[(2)] = inst_55914);

(statearr_55955_55975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55942 === (5))){
var _ = (function (){var statearr_55956 = state_55941;
(statearr_55956[(4)] = cljs.core.rest.call(null,(state_55941[(4)])));

return statearr_55956;
})();
var state_55941__$1 = state_55941;
var ex55953 = (state_55941__$1[(2)]);
var statearr_55957_55976 = state_55941__$1;
(statearr_55957_55976[(5)] = ex55953);


if((ex55953 instanceof Error)){
var statearr_55958_55977 = state_55941__$1;
(statearr_55958_55977[(1)] = (4));

(statearr_55958_55977[(5)] = null);

} else {
throw ex55953;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55942 === (10))){
var state_55941__$1 = state_55941;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55941__$1,(13),d);
} else {
if((state_val_55942 === (8))){
var inst_55917 = (state_55941[(2)]);
var inst_55918 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_55941__$1 = (function (){var statearr_55959 = state_55941;
(statearr_55959[(7)] = inst_55917);

return statearr_55959;
})();
if(inst_55918){
var statearr_55960_55978 = state_55941__$1;
(statearr_55960_55978[(1)] = (10));

} else {
var statearr_55961_55979 = state_55941__$1;
(statearr_55961_55979[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0 = (function (){
var statearr_55962 = [null,null,null,null,null,null,null,null,null];
(statearr_55962[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__);

(statearr_55962[(1)] = (1));

return statearr_55962;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1 = (function (state_55941){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55941);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55963){var ex__2749__auto__ = e55963;
var statearr_55964_55980 = state_55941;
(statearr_55964_55980[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55941[(4)]))){
var statearr_55965_55981 = state_55941;
(statearr_55965_55981[(1)] = cljs.core.first.call(null,(state_55941[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55982 = state_55941;
state_55941 = G__55982;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__ = function(state_55941){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1.call(this,state_55941);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55966 = f__2769__auto__.call(null);
(statearr_55966[(6)] = c__2768__auto__);

return statearr_55966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56020){
var state_val_56021 = (state_56020[(1)]);
if((state_val_56021 === (7))){
var state_56020__$1 = state_56020;
var statearr_56022_56046 = state_56020__$1;
(statearr_56022_56046[(2)] = n);

(statearr_56022_56046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (1))){
var state_56020__$1 = state_56020;
var statearr_56023_56047 = state_56020__$1;
(statearr_56023_56047[(2)] = null);

(statearr_56023_56047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (4))){
var inst_55983 = (state_56020[(2)]);
var state_56020__$1 = state_56020;
var statearr_56024_56048 = state_56020__$1;
(statearr_56024_56048[(2)] = inst_55983);

(statearr_56024_56048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (13))){
var inst_56000 = (state_56020[(2)]);
var inst_56001 = fluree.db.util.async.throw_err.call(null,inst_56000);
var state_56020__$1 = state_56020;
var statearr_56025_56049 = state_56020__$1;
(statearr_56025_56049[(2)] = inst_56001);

(statearr_56025_56049[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (6))){
var state_56020__$1 = state_56020;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56020__$1,(9),n);
} else {
if((state_val_56021 === (3))){
var inst_56018 = (state_56020[(2)]);
var state_56020__$1 = state_56020;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56020__$1,inst_56018);
} else {
if((state_val_56021 === (12))){
var inst_55996 = (state_56020[(7)]);
var inst_56004 = (state_56020[(2)]);
var inst_56005 = fluree.db.dbfunctions.internal.rem.call(null,inst_55996,inst_56004);
var inst_56006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56007 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56009 = [inst_55996,inst_56004];
var inst_56010 = (new cljs.core.PersistentVector(null,2,(5),inst_56008,inst_56009,null));
var inst_56011 = ["rem",inst_56010,inst_56005];
var inst_56012 = cljs.core.PersistentHashMap.fromArrays(inst_56007,inst_56011);
var inst_56013 = [inst_56012,(2)];
var inst_56014 = (new cljs.core.PersistentVector(null,2,(5),inst_56006,inst_56013,null));
var inst_56015 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56014);
var _ = (function (){var statearr_56026 = state_56020;
(statearr_56026[(4)] = cljs.core.rest.call(null,(state_56020[(4)])));

return statearr_56026;
})();
var state_56020__$1 = (function (){var statearr_56027 = state_56020;
(statearr_56027[(8)] = inst_56015);

return statearr_56027;
})();
var statearr_56028_56050 = state_56020__$1;
(statearr_56028_56050[(2)] = inst_56005);

(statearr_56028_56050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (2))){
var _ = (function (){var statearr_56029 = state_56020;
(statearr_56029[(4)] = cljs.core.cons.call(null,(5),(state_56020[(4)])));

return statearr_56029;
})();
var inst_55989 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56020__$1 = state_56020;
if(inst_55989){
var statearr_56030_56051 = state_56020__$1;
(statearr_56030_56051[(1)] = (6));

} else {
var statearr_56031_56052 = state_56020__$1;
(statearr_56031_56052[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (11))){
var state_56020__$1 = state_56020;
var statearr_56033_56053 = state_56020__$1;
(statearr_56033_56053[(2)] = d);

(statearr_56033_56053[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (9))){
var inst_55992 = (state_56020[(2)]);
var inst_55993 = fluree.db.util.async.throw_err.call(null,inst_55992);
var state_56020__$1 = state_56020;
var statearr_56034_56054 = state_56020__$1;
(statearr_56034_56054[(2)] = inst_55993);

(statearr_56034_56054[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (5))){
var _ = (function (){var statearr_56035 = state_56020;
(statearr_56035[(4)] = cljs.core.rest.call(null,(state_56020[(4)])));

return statearr_56035;
})();
var state_56020__$1 = state_56020;
var ex56032 = (state_56020__$1[(2)]);
var statearr_56036_56055 = state_56020__$1;
(statearr_56036_56055[(5)] = ex56032);


if((ex56032 instanceof Error)){
var statearr_56037_56056 = state_56020__$1;
(statearr_56037_56056[(1)] = (4));

(statearr_56037_56056[(5)] = null);

} else {
throw ex56032;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56021 === (10))){
var state_56020__$1 = state_56020;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56020__$1,(13),d);
} else {
if((state_val_56021 === (8))){
var inst_55996 = (state_56020[(2)]);
var inst_55997 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_56020__$1 = (function (){var statearr_56038 = state_56020;
(statearr_56038[(7)] = inst_55996);

return statearr_56038;
})();
if(inst_55997){
var statearr_56039_56057 = state_56020__$1;
(statearr_56039_56057[(1)] = (10));

} else {
var statearr_56040_56058 = state_56020__$1;
(statearr_56040_56058[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0 = (function (){
var statearr_56041 = [null,null,null,null,null,null,null,null,null];
(statearr_56041[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__);

(statearr_56041[(1)] = (1));

return statearr_56041;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1 = (function (state_56020){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56020);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56042){var ex__2749__auto__ = e56042;
var statearr_56043_56059 = state_56020;
(statearr_56043_56059[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56020[(4)]))){
var statearr_56044_56060 = state_56020;
(statearr_56044_56060[(1)] = cljs.core.first.call(null,(state_56020[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56061 = state_56020;
state_56020 = G__56061;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__ = function(state_56020){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1.call(this,state_56020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56045 = f__2769__auto__.call(null);
(statearr_56045[(6)] = c__2768__auto__);

return statearr_56045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56088){
var state_val_56089 = (state_56088[(1)]);
if((state_val_56089 === (7))){
var state_56088__$1 = state_56088;
var statearr_56090_56109 = state_56088__$1;
(statearr_56090_56109[(2)] = x);

(statearr_56090_56109[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56089 === (1))){
var state_56088__$1 = state_56088;
var statearr_56091_56110 = state_56088__$1;
(statearr_56091_56110[(2)] = null);

(statearr_56091_56110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56089 === (4))){
var inst_56062 = (state_56088[(2)]);
var state_56088__$1 = state_56088;
var statearr_56092_56111 = state_56088__$1;
(statearr_56092_56111[(2)] = inst_56062);

(statearr_56092_56111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56089 === (6))){
var state_56088__$1 = state_56088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56088__$1,(9),x);
} else {
if((state_val_56089 === (3))){
var inst_56086 = (state_56088[(2)]);
var state_56088__$1 = state_56088;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56088__$1,inst_56086);
} else {
if((state_val_56089 === (2))){
var _ = (function (){var statearr_56094 = state_56088;
(statearr_56094[(4)] = cljs.core.cons.call(null,(5),(state_56088[(4)])));

return statearr_56094;
})();
var inst_56068 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_56088__$1 = state_56088;
if(inst_56068){
var statearr_56095_56112 = state_56088__$1;
(statearr_56095_56112[(1)] = (6));

} else {
var statearr_56096_56113 = state_56088__$1;
(statearr_56096_56113[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56089 === (9))){
var inst_56071 = (state_56088[(2)]);
var inst_56072 = fluree.db.util.async.throw_err.call(null,inst_56071);
var state_56088__$1 = state_56088;
var statearr_56097_56114 = state_56088__$1;
(statearr_56097_56114[(2)] = inst_56072);

(statearr_56097_56114[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56089 === (5))){
var _ = (function (){var statearr_56098 = state_56088;
(statearr_56098[(4)] = cljs.core.rest.call(null,(state_56088[(4)])));

return statearr_56098;
})();
var state_56088__$1 = state_56088;
var ex56093 = (state_56088__$1[(2)]);
var statearr_56099_56115 = state_56088__$1;
(statearr_56099_56115[(5)] = ex56093);


if((ex56093 instanceof Error)){
var statearr_56100_56116 = state_56088__$1;
(statearr_56100_56116[(1)] = (4));

(statearr_56100_56116[(5)] = null);

} else {
throw ex56093;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56089 === (8))){
var inst_56075 = (state_56088[(2)]);
var inst_56076 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_56075);
var inst_56077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56078 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56079 = ["boolean",inst_56075,inst_56076];
var inst_56080 = cljs.core.PersistentHashMap.fromArrays(inst_56078,inst_56079);
var inst_56081 = [inst_56080,(10)];
var inst_56082 = (new cljs.core.PersistentVector(null,2,(5),inst_56077,inst_56081,null));
var inst_56083 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56082);
var _ = (function (){var statearr_56101 = state_56088;
(statearr_56101[(4)] = cljs.core.rest.call(null,(state_56088[(4)])));

return statearr_56101;
})();
var state_56088__$1 = (function (){var statearr_56102 = state_56088;
(statearr_56102[(7)] = inst_56083);

return statearr_56102;
})();
var statearr_56103_56117 = state_56088__$1;
(statearr_56103_56117[(2)] = inst_56076);

(statearr_56103_56117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0 = (function (){
var statearr_56104 = [null,null,null,null,null,null,null,null];
(statearr_56104[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__);

(statearr_56104[(1)] = (1));

return statearr_56104;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1 = (function (state_56088){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56088);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56105){var ex__2749__auto__ = e56105;
var statearr_56106_56118 = state_56088;
(statearr_56106_56118[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56088[(4)]))){
var statearr_56107_56119 = state_56088;
(statearr_56107_56119[(1)] = cljs.core.first.call(null,(state_56088[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56120 = state_56088;
state_56088 = G__56120;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__ = function(state_56088){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1.call(this,state_56088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56108 = f__2769__auto__.call(null);
(statearr_56108[(6)] = c__2768__auto__);

return statearr_56108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56158){
var state_val_56159 = (state_56158[(1)]);
if((state_val_56159 === (7))){
var state_56158__$1 = state_56158;
var statearr_56160_56184 = state_56158__$1;
(statearr_56160_56184[(2)] = pattern);

(statearr_56160_56184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (1))){
var state_56158__$1 = state_56158;
var statearr_56161_56185 = state_56158__$1;
(statearr_56161_56185[(2)] = null);

(statearr_56161_56185[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (4))){
var inst_56121 = (state_56158[(2)]);
var state_56158__$1 = state_56158;
var statearr_56162_56186 = state_56158__$1;
(statearr_56162_56186[(2)] = inst_56121);

(statearr_56162_56186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (13))){
var inst_56138 = (state_56158[(2)]);
var inst_56139 = fluree.db.util.async.throw_err.call(null,inst_56138);
var state_56158__$1 = state_56158;
var statearr_56163_56187 = state_56158__$1;
(statearr_56163_56187[(2)] = inst_56139);

(statearr_56163_56187[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (6))){
var state_56158__$1 = state_56158;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56158__$1,(9),pattern);
} else {
if((state_val_56159 === (3))){
var inst_56156 = (state_56158[(2)]);
var state_56158__$1 = state_56158;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56158__$1,inst_56156);
} else {
if((state_val_56159 === (12))){
var inst_56134 = (state_56158[(7)]);
var inst_56142 = (state_56158[(2)]);
var inst_56143 = fluree.db.dbfunctions.internal.re_find.call(null,inst_56134,inst_56142);
var inst_56144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56145 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56147 = [inst_56134,inst_56142];
var inst_56148 = (new cljs.core.PersistentVector(null,2,(5),inst_56146,inst_56147,null));
var inst_56149 = ["re-find",inst_56148,inst_56143];
var inst_56150 = cljs.core.PersistentHashMap.fromArrays(inst_56145,inst_56149);
var inst_56151 = [inst_56150,(10)];
var inst_56152 = (new cljs.core.PersistentVector(null,2,(5),inst_56144,inst_56151,null));
var inst_56153 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56152);
var _ = (function (){var statearr_56164 = state_56158;
(statearr_56164[(4)] = cljs.core.rest.call(null,(state_56158[(4)])));

return statearr_56164;
})();
var state_56158__$1 = (function (){var statearr_56165 = state_56158;
(statearr_56165[(8)] = inst_56153);

return statearr_56165;
})();
var statearr_56166_56188 = state_56158__$1;
(statearr_56166_56188[(2)] = inst_56143);

(statearr_56166_56188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (2))){
var _ = (function (){var statearr_56167 = state_56158;
(statearr_56167[(4)] = cljs.core.cons.call(null,(5),(state_56158[(4)])));

return statearr_56167;
})();
var inst_56127 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_56158__$1 = state_56158;
if(inst_56127){
var statearr_56168_56189 = state_56158__$1;
(statearr_56168_56189[(1)] = (6));

} else {
var statearr_56169_56190 = state_56158__$1;
(statearr_56169_56190[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (11))){
var state_56158__$1 = state_56158;
var statearr_56171_56191 = state_56158__$1;
(statearr_56171_56191[(2)] = string);

(statearr_56171_56191[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (9))){
var inst_56130 = (state_56158[(2)]);
var inst_56131 = fluree.db.util.async.throw_err.call(null,inst_56130);
var state_56158__$1 = state_56158;
var statearr_56172_56192 = state_56158__$1;
(statearr_56172_56192[(2)] = inst_56131);

(statearr_56172_56192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (5))){
var _ = (function (){var statearr_56173 = state_56158;
(statearr_56173[(4)] = cljs.core.rest.call(null,(state_56158[(4)])));

return statearr_56173;
})();
var state_56158__$1 = state_56158;
var ex56170 = (state_56158__$1[(2)]);
var statearr_56174_56193 = state_56158__$1;
(statearr_56174_56193[(5)] = ex56170);


if((ex56170 instanceof Error)){
var statearr_56175_56194 = state_56158__$1;
(statearr_56175_56194[(1)] = (4));

(statearr_56175_56194[(5)] = null);

} else {
throw ex56170;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56159 === (10))){
var state_56158__$1 = state_56158;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56158__$1,(13),string);
} else {
if((state_val_56159 === (8))){
var inst_56134 = (state_56158[(2)]);
var inst_56135 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_56158__$1 = (function (){var statearr_56176 = state_56158;
(statearr_56176[(7)] = inst_56134);

return statearr_56176;
})();
if(inst_56135){
var statearr_56177_56195 = state_56158__$1;
(statearr_56177_56195[(1)] = (10));

} else {
var statearr_56178_56196 = state_56158__$1;
(statearr_56178_56196[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0 = (function (){
var statearr_56179 = [null,null,null,null,null,null,null,null,null];
(statearr_56179[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__);

(statearr_56179[(1)] = (1));

return statearr_56179;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1 = (function (state_56158){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56158);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56180){var ex__2749__auto__ = e56180;
var statearr_56181_56197 = state_56158;
(statearr_56181_56197[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56158[(4)]))){
var statearr_56182_56198 = state_56158;
(statearr_56182_56198[(1)] = cljs.core.first.call(null,(state_56158[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56199 = state_56158;
state_56158 = G__56199;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__ = function(state_56158){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1.call(this,state_56158);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56183 = f__2769__auto__.call(null);
(statearr_56183[(6)] = c__2768__auto__);

return statearr_56183;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56226){
var state_val_56227 = (state_56226[(1)]);
if((state_val_56227 === (7))){
var state_56226__$1 = state_56226;
var statearr_56228_56247 = state_56226__$1;
(statearr_56228_56247[(2)] = email);

(statearr_56228_56247[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56227 === (1))){
var state_56226__$1 = state_56226;
var statearr_56229_56248 = state_56226__$1;
(statearr_56229_56248[(2)] = null);

(statearr_56229_56248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56227 === (4))){
var inst_56200 = (state_56226[(2)]);
var state_56226__$1 = state_56226;
var statearr_56230_56249 = state_56226__$1;
(statearr_56230_56249[(2)] = inst_56200);

(statearr_56230_56249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56227 === (6))){
var state_56226__$1 = state_56226;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56226__$1,(9),email);
} else {
if((state_val_56227 === (3))){
var inst_56224 = (state_56226[(2)]);
var state_56226__$1 = state_56226;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56226__$1,inst_56224);
} else {
if((state_val_56227 === (2))){
var _ = (function (){var statearr_56232 = state_56226;
(statearr_56232[(4)] = cljs.core.cons.call(null,(5),(state_56226[(4)])));

return statearr_56232;
})();
var inst_56206 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_56226__$1 = state_56226;
if(inst_56206){
var statearr_56233_56250 = state_56226__$1;
(statearr_56233_56250[(1)] = (6));

} else {
var statearr_56234_56251 = state_56226__$1;
(statearr_56234_56251[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56227 === (9))){
var inst_56209 = (state_56226[(2)]);
var inst_56210 = fluree.db.util.async.throw_err.call(null,inst_56209);
var state_56226__$1 = state_56226;
var statearr_56235_56252 = state_56226__$1;
(statearr_56235_56252[(2)] = inst_56210);

(statearr_56235_56252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56227 === (5))){
var _ = (function (){var statearr_56236 = state_56226;
(statearr_56236[(4)] = cljs.core.rest.call(null,(state_56226[(4)])));

return statearr_56236;
})();
var state_56226__$1 = state_56226;
var ex56231 = (state_56226__$1[(2)]);
var statearr_56237_56253 = state_56226__$1;
(statearr_56237_56253[(5)] = ex56231);


if((ex56231 instanceof Error)){
var statearr_56238_56254 = state_56226__$1;
(statearr_56238_56254[(1)] = (4));

(statearr_56238_56254[(5)] = null);

} else {
throw ex56231;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56227 === (8))){
var inst_56213 = (state_56226[(2)]);
var inst_56214 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_56213);
var inst_56215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56216 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56217 = ["re-find",inst_56213,inst_56214];
var inst_56218 = cljs.core.PersistentHashMap.fromArrays(inst_56216,inst_56217);
var inst_56219 = [inst_56218,(10)];
var inst_56220 = (new cljs.core.PersistentVector(null,2,(5),inst_56215,inst_56219,null));
var inst_56221 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56220);
var _ = (function (){var statearr_56239 = state_56226;
(statearr_56239[(4)] = cljs.core.rest.call(null,(state_56226[(4)])));

return statearr_56239;
})();
var state_56226__$1 = (function (){var statearr_56240 = state_56226;
(statearr_56240[(7)] = inst_56221);

return statearr_56240;
})();
var statearr_56241_56255 = state_56226__$1;
(statearr_56241_56255[(2)] = inst_56214);

(statearr_56241_56255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_56242 = [null,null,null,null,null,null,null,null];
(statearr_56242[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__);

(statearr_56242[(1)] = (1));

return statearr_56242;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1 = (function (state_56226){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56226);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56243){var ex__2749__auto__ = e56243;
var statearr_56244_56256 = state_56226;
(statearr_56244_56256[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56226[(4)]))){
var statearr_56245_56257 = state_56226;
(statearr_56245_56257[(1)] = cljs.core.first.call(null,(state_56226[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56258 = state_56226;
state_56226 = G__56258;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__ = function(state_56226){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1.call(this,state_56226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56246 = f__2769__auto__.call(null);
(statearr_56246[(6)] = c__2768__auto__);

return statearr_56246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56305){
var state_val_56306 = (state_56305[(1)]);
if((state_val_56306 === (7))){
var inst_56275 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56305__$1 = state_56305;
if(cljs.core.truth_(inst_56275)){
var statearr_56307_56334 = state_56305__$1;
(statearr_56307_56334[(1)] = (9));

} else {
var statearr_56308_56335 = state_56305__$1;
(statearr_56308_56335[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56306 === (1))){
var state_56305__$1 = state_56305;
var statearr_56309_56336 = state_56305__$1;
(statearr_56309_56336[(2)] = null);

(statearr_56309_56336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56306 === (4))){
var inst_56259 = (state_56305[(2)]);
var state_56305__$1 = state_56305;
var statearr_56310_56337 = state_56305__$1;
(statearr_56310_56337[(2)] = inst_56259);

(statearr_56310_56337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56306 === (15))){
var inst_56286 = (state_56305[(2)]);
var state_56305__$1 = state_56305;
var statearr_56311_56338 = state_56305__$1;
(statearr_56311_56338[(2)] = inst_56286);

(statearr_56311_56338[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56306 === (13))){
var inst_56283 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_56305__$1 = state_56305;
var statearr_56312_56339 = state_56305__$1;
(statearr_56312_56339[(2)] = inst_56283);

(statearr_56312_56339[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56306 === (6))){
var inst_56270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56271 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56272 = [inst_56271,(0)];
var inst_56273 = (new cljs.core.PersistentVector(null,2,(5),inst_56270,inst_56272,null));
var state_56305__$1 = state_56305;
var statearr_56313_56340 = state_56305__$1;
(statearr_56313_56340[(2)] = inst_56273);

(statearr_56313_56340[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56306 === (3))){
var inst_56303 = (state_56305[(2)]);
var state_56305__$1 = state_56305;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56305__$1,inst_56303);
} else {
if((state_val_56306 === (12))){
var inst_56279 = (state_56305[(2)]);
var inst_56280 = fluree.db.util.async.throw_err.call(null,inst_56279);
var state_56305__$1 = state_56305;
var statearr_56314_56341 = state_56305__$1;
(statearr_56314_56341[(2)] = inst_56280);

(statearr_56314_56341[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56306 === (2))){
var _ = (function (){var statearr_56315 = state_56305;
(statearr_56315[(4)] = cljs.core.cons.call(null,(5),(state_56305[(4)])));

return statearr_56315;
})();
var inst_56268 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56305__$1 = state_56305;
if(cljs.core.truth_(inst_56268)){
var statearr_56316_56342 = state_56305__$1;
(statearr_56316_56342[(1)] = (6));

} else {
var statearr_56317_56343 = state_56305__$1;
(statearr_56317_56343[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56306 === (11))){
var inst_56288 = (state_56305[(2)]);
var state_56305__$1 = state_56305;
var statearr_56319_56344 = state_56305__$1;
(statearr_56319_56344[(2)] = inst_56288);

(statearr_56319_56344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56306 === (9))){
var inst_56277 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_56305__$1 = state_56305;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56305__$1,(12),inst_56277);
} else {
if((state_val_56306 === (5))){
var _ = (function (){var statearr_56320 = state_56305;
(statearr_56320[(4)] = cljs.core.rest.call(null,(state_56305[(4)])));

return statearr_56320;
})();
var state_56305__$1 = state_56305;
var ex56318 = (state_56305__$1[(2)]);
var statearr_56321_56345 = state_56305__$1;
(statearr_56321_56345[(5)] = ex56318);


if((ex56318 instanceof Error)){
var statearr_56322_56346 = state_56305__$1;
(statearr_56322_56346[(1)] = (4));

(statearr_56322_56346[(5)] = null);

} else {
throw ex56318;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56306 === (14))){
var state_56305__$1 = state_56305;
var statearr_56323_56347 = state_56305__$1;
(statearr_56323_56347[(2)] = null);

(statearr_56323_56347[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56306 === (10))){
var state_56305__$1 = state_56305;
var statearr_56324_56348 = state_56305__$1;
(statearr_56324_56348[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56306 === (8))){
var inst_56290 = (state_56305[(2)]);
var inst_56291 = cljs.core.nth.call(null,inst_56290,(0),null);
var inst_56292 = cljs.core.nth.call(null,inst_56290,(1),null);
var inst_56293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56294 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56295 = ["?user_id","?ctx",inst_56291];
var inst_56296 = cljs.core.PersistentHashMap.fromArrays(inst_56294,inst_56295);
var inst_56297 = ((10) + inst_56292);
var inst_56298 = [inst_56296,inst_56297];
var inst_56299 = (new cljs.core.PersistentVector(null,2,(5),inst_56293,inst_56298,null));
var inst_56300 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56299);
var _ = (function (){var statearr_56326 = state_56305;
(statearr_56326[(4)] = cljs.core.rest.call(null,(state_56305[(4)])));

return statearr_56326;
})();
var state_56305__$1 = (function (){var statearr_56327 = state_56305;
(statearr_56327[(7)] = inst_56300);

return statearr_56327;
})();
var statearr_56328_56349 = state_56305__$1;
(statearr_56328_56349[(2)] = inst_56291);

(statearr_56328_56349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0 = (function (){
var statearr_56329 = [null,null,null,null,null,null,null,null];
(statearr_56329[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__);

(statearr_56329[(1)] = (1));

return statearr_56329;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1 = (function (state_56305){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56305);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56330){var ex__2749__auto__ = e56330;
var statearr_56331_56350 = state_56305;
(statearr_56331_56350[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56305[(4)]))){
var statearr_56332_56351 = state_56305;
(statearr_56332_56351[(1)] = cljs.core.first.call(null,(state_56305[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56352 = state_56305;
state_56305 = G__56352;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__ = function(state_56305){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1.call(this,state_56305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56333 = f__2769__auto__.call(null);
(statearr_56333[(6)] = c__2768__auto__);

return statearr_56333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56380){
var state_val_56381 = (state_56380[(1)]);
if((state_val_56381 === (7))){
var inst_56373 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_56380__$1 = state_56380;
var statearr_56382_56401 = state_56380__$1;
(statearr_56382_56401[(2)] = inst_56373);

(statearr_56382_56401[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (1))){
var state_56380__$1 = state_56380;
var statearr_56383_56402 = state_56380__$1;
(statearr_56383_56402[(2)] = null);

(statearr_56383_56402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (4))){
var inst_56353 = (state_56380[(2)]);
var state_56380__$1 = state_56380;
var statearr_56384_56403 = state_56380__$1;
(statearr_56384_56403[(2)] = inst_56353);

(statearr_56384_56403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (6))){
var inst_56361 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_56380__$1 = state_56380;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56380__$1,(9),inst_56361);
} else {
if((state_val_56381 === (3))){
var inst_56378 = (state_56380[(2)]);
var state_56380__$1 = state_56380;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56380__$1,inst_56378);
} else {
if((state_val_56381 === (2))){
var _ = (function (){var statearr_56386 = state_56380;
(statearr_56386[(4)] = cljs.core.cons.call(null,(5),(state_56380[(4)])));

return statearr_56386;
})();
var inst_56359 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56380__$1 = state_56380;
if(cljs.core.truth_(inst_56359)){
var statearr_56387_56404 = state_56380__$1;
(statearr_56387_56404[(1)] = (6));

} else {
var statearr_56388_56405 = state_56380__$1;
(statearr_56388_56405[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (9))){
var inst_56363 = (state_56380[(2)]);
var inst_56364 = fluree.db.util.async.throw_err.call(null,inst_56363);
var inst_56365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56366 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56367 = ["?auth_id","?ctx",inst_56364];
var inst_56368 = cljs.core.PersistentHashMap.fromArrays(inst_56366,inst_56367);
var inst_56369 = [inst_56368,(10)];
var inst_56370 = (new cljs.core.PersistentVector(null,2,(5),inst_56365,inst_56369,null));
var inst_56371 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56370);
var state_56380__$1 = (function (){var statearr_56389 = state_56380;
(statearr_56389[(7)] = inst_56371);

return statearr_56389;
})();
var statearr_56390_56406 = state_56380__$1;
(statearr_56390_56406[(2)] = inst_56364);

(statearr_56390_56406[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (5))){
var _ = (function (){var statearr_56391 = state_56380;
(statearr_56391[(4)] = cljs.core.rest.call(null,(state_56380[(4)])));

return statearr_56391;
})();
var state_56380__$1 = state_56380;
var ex56385 = (state_56380__$1[(2)]);
var statearr_56392_56407 = state_56380__$1;
(statearr_56392_56407[(5)] = ex56385);


if((ex56385 instanceof Error)){
var statearr_56393_56408 = state_56380__$1;
(statearr_56393_56408[(1)] = (4));

(statearr_56393_56408[(5)] = null);

} else {
throw ex56385;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56381 === (8))){
var inst_56375 = (state_56380[(2)]);
var _ = (function (){var statearr_56394 = state_56380;
(statearr_56394[(4)] = cljs.core.rest.call(null,(state_56380[(4)])));

return statearr_56394;
})();
var state_56380__$1 = state_56380;
var statearr_56395_56409 = state_56380__$1;
(statearr_56395_56409[(2)] = inst_56375);

(statearr_56395_56409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0 = (function (){
var statearr_56396 = [null,null,null,null,null,null,null,null];
(statearr_56396[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__);

(statearr_56396[(1)] = (1));

return statearr_56396;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1 = (function (state_56380){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56380);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56397){var ex__2749__auto__ = e56397;
var statearr_56398_56410 = state_56380;
(statearr_56398_56410[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56380[(4)]))){
var statearr_56399_56411 = state_56380;
(statearr_56399_56411[(1)] = cljs.core.first.call(null,(state_56380[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56412 = state_56380;
state_56380 = G__56412;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__ = function(state_56380){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1.call(this,state_56380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56400 = f__2769__auto__.call(null);
(statearr_56400[(6)] = c__2768__auto__);

return statearr_56400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__56414 = arguments.length;
switch (G__56414) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56456){
var state_val_56457 = (state_56456[(1)]);
if((state_val_56457 === (7))){
var state_56456__$1 = state_56456;
var statearr_56458_56488 = state_56456__$1;
(statearr_56458_56488[(2)] = seed);

(statearr_56458_56488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56457 === (1))){
var state_56456__$1 = state_56456;
var statearr_56459_56489 = state_56456__$1;
(statearr_56459_56489[(2)] = null);

(statearr_56459_56489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56457 === (4))){
var inst_56415 = (state_56456[(2)]);
var state_56456__$1 = state_56456;
var statearr_56460_56490 = state_56456__$1;
(statearr_56460_56490[(2)] = inst_56415);

(statearr_56460_56490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56457 === (15))){
var state_56456__$1 = state_56456;
var statearr_56461_56491 = state_56456__$1;
(statearr_56461_56491[(2)] = (10));

(statearr_56461_56491[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56457 === (13))){
var inst_56432 = (state_56456[(2)]);
var inst_56433 = fluree.db.util.async.throw_err.call(null,inst_56432);
var state_56456__$1 = state_56456;
var statearr_56462_56492 = state_56456__$1;
(statearr_56462_56492[(2)] = inst_56433);

(statearr_56462_56492[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56457 === (6))){
var state_56456__$1 = state_56456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56456__$1,(9),seed);
} else {
if((state_val_56457 === (3))){
var inst_56454 = (state_56456[(2)]);
var state_56456__$1 = state_56456;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56456__$1,inst_56454);
} else {
if((state_val_56457 === (12))){
var inst_56436 = (state_56456[(7)]);
var inst_56436__$1 = (state_56456[(2)]);
var state_56456__$1 = (function (){var statearr_56463 = state_56456;
(statearr_56463[(7)] = inst_56436__$1);

return statearr_56463;
})();
if(cljs.core.truth_(inst_56436__$1)){
var statearr_56464_56493 = state_56456__$1;
(statearr_56464_56493[(1)] = (14));

} else {
var statearr_56465_56494 = state_56456__$1;
(statearr_56465_56494[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56457 === (2))){
var _ = (function (){var statearr_56466 = state_56456;
(statearr_56466[(4)] = cljs.core.cons.call(null,(5),(state_56456[(4)])));

return statearr_56466;
})();
var inst_56421 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_56456__$1 = state_56456;
if(inst_56421){
var statearr_56467_56495 = state_56456__$1;
(statearr_56467_56495[(1)] = (6));

} else {
var statearr_56468_56496 = state_56456__$1;
(statearr_56468_56496[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56457 === (11))){
var state_56456__$1 = state_56456;
var statearr_56470_56497 = state_56456__$1;
(statearr_56470_56497[(2)] = max);

(statearr_56470_56497[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56457 === (9))){
var inst_56424 = (state_56456[(2)]);
var inst_56425 = fluree.db.util.async.throw_err.call(null,inst_56424);
var state_56456__$1 = state_56456;
var statearr_56471_56498 = state_56456__$1;
(statearr_56471_56498[(2)] = inst_56425);

(statearr_56471_56498[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56457 === (5))){
var _ = (function (){var statearr_56472 = state_56456;
(statearr_56472[(4)] = cljs.core.rest.call(null,(state_56456[(4)])));

return statearr_56472;
})();
var state_56456__$1 = state_56456;
var ex56469 = (state_56456__$1[(2)]);
var statearr_56473_56499 = state_56456__$1;
(statearr_56473_56499[(5)] = ex56469);


if((ex56469 instanceof Error)){
var statearr_56474_56500 = state_56456__$1;
(statearr_56474_56500[(1)] = (4));

(statearr_56474_56500[(5)] = null);

} else {
throw ex56469;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56457 === (14))){
var inst_56436 = (state_56456[(7)]);
var state_56456__$1 = state_56456;
var statearr_56475_56501 = state_56456__$1;
(statearr_56475_56501[(2)] = inst_56436);

(statearr_56475_56501[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56457 === (16))){
var inst_56428 = (state_56456[(8)]);
var inst_56440 = (state_56456[(2)]);
var inst_56441 = fluree.db.dbfunctions.internal.rand.call(null,inst_56428,inst_56440);
var inst_56442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56443 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56445 = [max,seed];
var inst_56446 = (new cljs.core.PersistentVector(null,2,(5),inst_56444,inst_56445,null));
var inst_56447 = ["rand",inst_56446,inst_56441];
var inst_56448 = cljs.core.PersistentHashMap.fromArrays(inst_56443,inst_56447);
var inst_56449 = [inst_56448,(10)];
var inst_56450 = (new cljs.core.PersistentVector(null,2,(5),inst_56442,inst_56449,null));
var inst_56451 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56450);
var _ = (function (){var statearr_56476 = state_56456;
(statearr_56476[(4)] = cljs.core.rest.call(null,(state_56456[(4)])));

return statearr_56476;
})();
var state_56456__$1 = (function (){var statearr_56477 = state_56456;
(statearr_56477[(9)] = inst_56451);

return statearr_56477;
})();
var statearr_56478_56502 = state_56456__$1;
(statearr_56478_56502[(2)] = inst_56441);

(statearr_56478_56502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56457 === (10))){
var state_56456__$1 = state_56456;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56456__$1,(13),max);
} else {
if((state_val_56457 === (8))){
var inst_56428 = (state_56456[(2)]);
var inst_56429 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_56456__$1 = (function (){var statearr_56479 = state_56456;
(statearr_56479[(8)] = inst_56428);

return statearr_56479;
})();
if(inst_56429){
var statearr_56480_56503 = state_56456__$1;
(statearr_56480_56503[(1)] = (10));

} else {
var statearr_56481_56504 = state_56456__$1;
(statearr_56481_56504[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56482 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56482[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56482[(1)] = (1));

return statearr_56482;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56456){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56456);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56483){var ex__2749__auto__ = e56483;
var statearr_56484_56505 = state_56456;
(statearr_56484_56505[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56456[(4)]))){
var statearr_56485_56506 = state_56456;
(statearr_56485_56506[(1)] = cljs.core.first.call(null,(state_56456[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56507 = state_56456;
state_56456 = G__56507;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56456){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56486 = f__2769__auto__.call(null);
(statearr_56486[(6)] = c__2768__auto__);

return statearr_56486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56528){
var state_val_56529 = (state_56528[(1)]);
if((state_val_56529 === (1))){
var state_56528__$1 = state_56528;
var statearr_56530_56545 = state_56528__$1;
(statearr_56530_56545[(2)] = null);

(statearr_56530_56545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56529 === (2))){
var _ = (function (){var statearr_56531 = state_56528;
(statearr_56531[(4)] = cljs.core.cons.call(null,(5),(state_56528[(4)])));

return statearr_56531;
})();
var inst_56514 = cljs.core.random_uuid.call(null);
var inst_56515 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_56514);
var inst_56516 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56517 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56518 = cljs.core.PersistentVector.EMPTY;
var inst_56519 = ["uuid",inst_56518,inst_56515];
var inst_56520 = cljs.core.PersistentHashMap.fromArrays(inst_56517,inst_56519);
var inst_56521 = [inst_56520,(10)];
var inst_56522 = (new cljs.core.PersistentVector(null,2,(5),inst_56516,inst_56521,null));
var inst_56523 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56522);
var ___$1 = (function (){var statearr_56532 = state_56528;
(statearr_56532[(4)] = cljs.core.rest.call(null,(state_56528[(4)])));

return statearr_56532;
})();
var state_56528__$1 = (function (){var statearr_56533 = state_56528;
(statearr_56533[(7)] = inst_56523);

return statearr_56533;
})();
var statearr_56534_56546 = state_56528__$1;
(statearr_56534_56546[(2)] = inst_56515);

(statearr_56534_56546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56529 === (3))){
var inst_56526 = (state_56528[(2)]);
var state_56528__$1 = state_56528;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56528__$1,inst_56526);
} else {
if((state_val_56529 === (4))){
var inst_56508 = (state_56528[(2)]);
var state_56528__$1 = state_56528;
var statearr_56536_56547 = state_56528__$1;
(statearr_56536_56547[(2)] = inst_56508);

(statearr_56536_56547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56529 === (5))){
var _ = (function (){var statearr_56537 = state_56528;
(statearr_56537[(4)] = cljs.core.rest.call(null,(state_56528[(4)])));

return statearr_56537;
})();
var state_56528__$1 = state_56528;
var ex56535 = (state_56528__$1[(2)]);
var statearr_56538_56548 = state_56528__$1;
(statearr_56538_56548[(5)] = ex56535);


if((ex56535 instanceof Error)){
var statearr_56539_56549 = state_56528__$1;
(statearr_56539_56549[(1)] = (4));

(statearr_56539_56549[(5)] = null);

} else {
throw ex56535;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0 = (function (){
var statearr_56540 = [null,null,null,null,null,null,null,null];
(statearr_56540[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__);

(statearr_56540[(1)] = (1));

return statearr_56540;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1 = (function (state_56528){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56528);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56541){var ex__2749__auto__ = e56541;
var statearr_56542_56550 = state_56528;
(statearr_56542_56550[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56528[(4)]))){
var statearr_56543_56551 = state_56528;
(statearr_56543_56551[(1)] = cljs.core.first.call(null,(state_56528[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56552 = state_56528;
state_56528 = G__56552;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__ = function(state_56528){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1.call(this,state_56528);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56544 = f__2769__auto__.call(null);
(statearr_56544[(6)] = c__2768__auto__);

return statearr_56544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56582){
var state_val_56583 = (state_56582[(1)]);
if((state_val_56583 === (7))){
var state_56582__$1 = state_56582;
var statearr_56584_56603 = state_56582__$1;
(statearr_56584_56603[(2)] = num);

(statearr_56584_56603[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56583 === (1))){
var state_56582__$1 = state_56582;
var statearr_56585_56604 = state_56582__$1;
(statearr_56585_56604[(2)] = null);

(statearr_56585_56604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56583 === (4))){
var inst_56553 = (state_56582[(2)]);
var state_56582__$1 = state_56582;
var statearr_56586_56605 = state_56582__$1;
(statearr_56586_56605[(2)] = inst_56553);

(statearr_56586_56605[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56583 === (6))){
var state_56582__$1 = state_56582;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56582__$1,(9),num);
} else {
if((state_val_56583 === (3))){
var inst_56580 = (state_56582[(2)]);
var state_56582__$1 = state_56582;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56582__$1,inst_56580);
} else {
if((state_val_56583 === (2))){
var _ = (function (){var statearr_56588 = state_56582;
(statearr_56588[(4)] = cljs.core.cons.call(null,(5),(state_56582[(4)])));

return statearr_56588;
})();
var inst_56559 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_56582__$1 = state_56582;
if(inst_56559){
var statearr_56589_56606 = state_56582__$1;
(statearr_56589_56606[(1)] = (6));

} else {
var statearr_56590_56607 = state_56582__$1;
(statearr_56590_56607[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56583 === (9))){
var inst_56562 = (state_56582[(2)]);
var inst_56563 = fluree.db.util.async.throw_err.call(null,inst_56562);
var state_56582__$1 = state_56582;
var statearr_56591_56608 = state_56582__$1;
(statearr_56591_56608[(2)] = inst_56563);

(statearr_56591_56608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56583 === (5))){
var _ = (function (){var statearr_56592 = state_56582;
(statearr_56592[(4)] = cljs.core.rest.call(null,(state_56582[(4)])));

return statearr_56592;
})();
var state_56582__$1 = state_56582;
var ex56587 = (state_56582__$1[(2)]);
var statearr_56593_56609 = state_56582__$1;
(statearr_56593_56609[(5)] = ex56587);


if((ex56587 instanceof Error)){
var statearr_56594_56610 = state_56582__$1;
(statearr_56594_56610[(1)] = (4));

(statearr_56594_56610[(5)] = null);

} else {
throw ex56587;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56583 === (8))){
var inst_56566 = (state_56582[(2)]);
var inst_56567 = fluree.db.dbfunctions.internal.ceil.call(null,inst_56566);
var inst_56568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56569 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56571 = [fluree.db.dbfunctions.fns.ceil];
var inst_56572 = (new cljs.core.PersistentVector(null,1,(5),inst_56570,inst_56571,null));
var inst_56573 = ["",inst_56572,inst_56567];
var inst_56574 = cljs.core.PersistentHashMap.fromArrays(inst_56569,inst_56573);
var inst_56575 = [inst_56574,(10)];
var inst_56576 = (new cljs.core.PersistentVector(null,2,(5),inst_56568,inst_56575,null));
var inst_56577 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56576);
var _ = (function (){var statearr_56595 = state_56582;
(statearr_56595[(4)] = cljs.core.rest.call(null,(state_56582[(4)])));

return statearr_56595;
})();
var state_56582__$1 = (function (){var statearr_56596 = state_56582;
(statearr_56596[(7)] = inst_56577);

return statearr_56596;
})();
var statearr_56597_56611 = state_56582__$1;
(statearr_56597_56611[(2)] = inst_56567);

(statearr_56597_56611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0 = (function (){
var statearr_56598 = [null,null,null,null,null,null,null,null];
(statearr_56598[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__);

(statearr_56598[(1)] = (1));

return statearr_56598;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1 = (function (state_56582){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56582);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56599){var ex__2749__auto__ = e56599;
var statearr_56600_56612 = state_56582;
(statearr_56600_56612[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56582[(4)]))){
var statearr_56601_56613 = state_56582;
(statearr_56601_56613[(1)] = cljs.core.first.call(null,(state_56582[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56614 = state_56582;
state_56582 = G__56614;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__ = function(state_56582){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1.call(this,state_56582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56602 = f__2769__auto__.call(null);
(statearr_56602[(6)] = c__2768__auto__);

return statearr_56602;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56644){
var state_val_56645 = (state_56644[(1)]);
if((state_val_56645 === (7))){
var state_56644__$1 = state_56644;
var statearr_56646_56665 = state_56644__$1;
(statearr_56646_56665[(2)] = num);

(statearr_56646_56665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (1))){
var state_56644__$1 = state_56644;
var statearr_56647_56666 = state_56644__$1;
(statearr_56647_56666[(2)] = null);

(statearr_56647_56666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (4))){
var inst_56615 = (state_56644[(2)]);
var state_56644__$1 = state_56644;
var statearr_56648_56667 = state_56644__$1;
(statearr_56648_56667[(2)] = inst_56615);

(statearr_56648_56667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (6))){
var state_56644__$1 = state_56644;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56644__$1,(9),num);
} else {
if((state_val_56645 === (3))){
var inst_56642 = (state_56644[(2)]);
var state_56644__$1 = state_56644;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56644__$1,inst_56642);
} else {
if((state_val_56645 === (2))){
var _ = (function (){var statearr_56650 = state_56644;
(statearr_56650[(4)] = cljs.core.cons.call(null,(5),(state_56644[(4)])));

return statearr_56650;
})();
var inst_56621 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_56644__$1 = state_56644;
if(inst_56621){
var statearr_56651_56668 = state_56644__$1;
(statearr_56651_56668[(1)] = (6));

} else {
var statearr_56652_56669 = state_56644__$1;
(statearr_56652_56669[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (9))){
var inst_56624 = (state_56644[(2)]);
var inst_56625 = fluree.db.util.async.throw_err.call(null,inst_56624);
var state_56644__$1 = state_56644;
var statearr_56653_56670 = state_56644__$1;
(statearr_56653_56670[(2)] = inst_56625);

(statearr_56653_56670[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (5))){
var _ = (function (){var statearr_56654 = state_56644;
(statearr_56654[(4)] = cljs.core.rest.call(null,(state_56644[(4)])));

return statearr_56654;
})();
var state_56644__$1 = state_56644;
var ex56649 = (state_56644__$1[(2)]);
var statearr_56655_56671 = state_56644__$1;
(statearr_56655_56671[(5)] = ex56649);


if((ex56649 instanceof Error)){
var statearr_56656_56672 = state_56644__$1;
(statearr_56656_56672[(1)] = (4));

(statearr_56656_56672[(5)] = null);

} else {
throw ex56649;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56645 === (8))){
var inst_56628 = (state_56644[(2)]);
var inst_56629 = fluree.db.dbfunctions.internal.floor.call(null,inst_56628);
var inst_56630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56631 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56632 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56633 = [fluree.db.dbfunctions.fns.floor];
var inst_56634 = (new cljs.core.PersistentVector(null,1,(5),inst_56632,inst_56633,null));
var inst_56635 = ["",inst_56634,inst_56629];
var inst_56636 = cljs.core.PersistentHashMap.fromArrays(inst_56631,inst_56635);
var inst_56637 = [inst_56636,(10)];
var inst_56638 = (new cljs.core.PersistentVector(null,2,(5),inst_56630,inst_56637,null));
var inst_56639 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56638);
var _ = (function (){var statearr_56657 = state_56644;
(statearr_56657[(4)] = cljs.core.rest.call(null,(state_56644[(4)])));

return statearr_56657;
})();
var state_56644__$1 = (function (){var statearr_56658 = state_56644;
(statearr_56658[(7)] = inst_56639);

return statearr_56658;
})();
var statearr_56659_56673 = state_56644__$1;
(statearr_56659_56673[(2)] = inst_56629);

(statearr_56659_56673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0 = (function (){
var statearr_56660 = [null,null,null,null,null,null,null,null];
(statearr_56660[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__);

(statearr_56660[(1)] = (1));

return statearr_56660;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1 = (function (state_56644){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56644);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56661){var ex__2749__auto__ = e56661;
var statearr_56662_56674 = state_56644;
(statearr_56662_56674[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56644[(4)]))){
var statearr_56663_56675 = state_56644;
(statearr_56663_56675[(1)] = cljs.core.first.call(null,(state_56644[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56676 = state_56644;
state_56644 = G__56676;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__ = function(state_56644){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1.call(this,state_56644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56664 = f__2769__auto__.call(null);
(statearr_56664[(6)] = c__2768__auto__);

return statearr_56664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56701){
var state_val_56702 = (state_56701[(1)]);
if((state_val_56702 === (1))){
var state_56701__$1 = state_56701;
var statearr_56703_56718 = state_56701__$1;
(statearr_56703_56718[(2)] = null);

(statearr_56703_56718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56702 === (2))){
var _ = (function (){var statearr_56704 = state_56701;
(statearr_56704[(4)] = cljs.core.cons.call(null,(5),(state_56701[(4)])));

return statearr_56704;
})();
var inst_56683 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_56701__$1 = state_56701;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56701__$1,(6),inst_56683);
} else {
if((state_val_56702 === (3))){
var inst_56699 = (state_56701[(2)]);
var state_56701__$1 = state_56701;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56701__$1,inst_56699);
} else {
if((state_val_56702 === (4))){
var inst_56677 = (state_56701[(2)]);
var state_56701__$1 = state_56701;
var statearr_56706_56719 = state_56701__$1;
(statearr_56706_56719[(2)] = inst_56677);

(statearr_56706_56719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56702 === (5))){
var _ = (function (){var statearr_56707 = state_56701;
(statearr_56707[(4)] = cljs.core.rest.call(null,(state_56701[(4)])));

return statearr_56707;
})();
var state_56701__$1 = state_56701;
var ex56705 = (state_56701__$1[(2)]);
var statearr_56708_56720 = state_56701__$1;
(statearr_56708_56720[(5)] = ex56705);


if((ex56705 instanceof Error)){
var statearr_56709_56721 = state_56701__$1;
(statearr_56709_56721[(1)] = (4));

(statearr_56709_56721[(5)] = null);

} else {
throw ex56705;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56702 === (6))){
var inst_56685 = (state_56701[(2)]);
var inst_56686 = fluree.db.util.async.throw_err.call(null,inst_56685);
var inst_56687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56688 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56690 = [compare_val,new_val];
var inst_56691 = (new cljs.core.PersistentVector(null,2,(5),inst_56689,inst_56690,null));
var inst_56692 = ["",inst_56691,inst_56686];
var inst_56693 = cljs.core.PersistentHashMap.fromArrays(inst_56688,inst_56692);
var inst_56694 = [inst_56693,(10)];
var inst_56695 = (new cljs.core.PersistentVector(null,2,(5),inst_56687,inst_56694,null));
var inst_56696 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56695);
var _ = (function (){var statearr_56710 = state_56701;
(statearr_56710[(4)] = cljs.core.rest.call(null,(state_56701[(4)])));

return statearr_56710;
})();
var state_56701__$1 = (function (){var statearr_56711 = state_56701;
(statearr_56711[(7)] = inst_56696);

return statearr_56711;
})();
var statearr_56712_56722 = state_56701__$1;
(statearr_56712_56722[(2)] = inst_56686);

(statearr_56712_56722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0 = (function (){
var statearr_56713 = [null,null,null,null,null,null,null,null];
(statearr_56713[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__);

(statearr_56713[(1)] = (1));

return statearr_56713;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1 = (function (state_56701){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56701);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56714){var ex__2749__auto__ = e56714;
var statearr_56715_56723 = state_56701;
(statearr_56715_56723[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56701[(4)]))){
var statearr_56716_56724 = state_56701;
(statearr_56716_56724[(1)] = cljs.core.first.call(null,(state_56701[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56725 = state_56701;
state_56701 = G__56725;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__ = function(state_56701){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1.call(this,state_56701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56717 = f__2769__auto__.call(null);
(statearr_56717[(6)] = c__2768__auto__);

return statearr_56717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
