// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.query.fql_resp');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___72474 = arguments.length;
var i__4865__auto___72475 = (0);
while(true){
if((i__4865__auto___72475 < len__4864__auto___72474)){
args__4870__auto__.push((arguments[i__4865__auto___72475]));

var G__72476 = (i__4865__auto___72475 + (1));
i__4865__auto___72475 = G__72476;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__72403){
var vec__72404 = p__72403;
var opts = cljs.core.nth.call(null,vec__72404,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___72477 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72451){
var state_val_72452 = (state_72451[(1)]);
if((state_val_72452 === (7))){
var inst_72437 = (state_72451[(7)]);
var inst_72428 = (state_72451[(8)]);
var inst_72439 = fluree.db.time_travel.as_of_block.call(null,inst_72437,inst_72428);
var state_72451__$1 = state_72451;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72451__$1,(10),inst_72439);
} else {
if((state_val_72452 === (1))){
var state_72451__$1 = state_72451;
var statearr_72453_72478 = state_72451__$1;
(statearr_72453_72478[(2)] = null);

(statearr_72453_72478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72452 === (4))){
var inst_72407 = (state_72451[(2)]);
var inst_72408 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72409 = [inst_72407];
var inst_72410 = (new cljs.core.PersistentVector(null,1,(5),inst_72408,inst_72409,null));
var inst_72411 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72410);
var inst_72412 = cljs.core.async.put_BANG_.call(null,pc,inst_72407);
var inst_72413 = cljs.core.async.close_BANG_.call(null,pc);
var state_72451__$1 = (function (){var statearr_72454 = state_72451;
(statearr_72454[(9)] = inst_72412);

(statearr_72454[(10)] = inst_72411);

return statearr_72454;
})();
var statearr_72455_72479 = state_72451__$1;
(statearr_72455_72479[(2)] = inst_72413);

(statearr_72455_72479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72452 === (6))){
var inst_72432 = (state_72451[(11)]);
var inst_72428 = (state_72451[(8)]);
var inst_72431 = (state_72451[(12)]);
var inst_72435 = (state_72451[(2)]);
var inst_72436 = fluree.db.util.async.throw_err.call(null,inst_72435);
var inst_72437 = cljs.core.assoc.call(null,inst_72436,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_72431,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_72432);
var state_72451__$1 = (function (){var statearr_72456 = state_72451;
(statearr_72456[(7)] = inst_72437);

return statearr_72456;
})();
if(cljs.core.truth_(inst_72428)){
var statearr_72457_72480 = state_72451__$1;
(statearr_72457_72480[(1)] = (7));

} else {
var statearr_72458_72481 = state_72451__$1;
(statearr_72458_72481[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72452 === (3))){
var inst_72449 = (state_72451[(2)]);
var state_72451__$1 = state_72451;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72451__$1,inst_72449);
} else {
if((state_val_72452 === (2))){
var _ = (function (){var statearr_72460 = state_72451;
(statearr_72460[(4)] = cljs.core.cons.call(null,(5),(state_72451[(4)])));

return statearr_72460;
})();
var inst_72423 = opts;
var inst_72424 = cljs.core.__destructure_map.call(null,inst_72423);
var inst_72425 = cljs.core.get.call(null,inst_72424,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_72426 = cljs.core.get.call(null,inst_72424,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_72427 = cljs.core.get.call(null,inst_72424,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_72428 = cljs.core.get.call(null,inst_72424,new cljs.core.Keyword(null,"block","block",664686210));
var inst_72429 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_72430 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_72431 = cljs.core.nth.call(null,inst_72430,(0),null);
var inst_72432 = cljs.core.nth.call(null,inst_72430,(1),null);
var inst_72433 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_72451__$1 = (function (){var statearr_72461 = state_72451;
(statearr_72461[(11)] = inst_72432);

(statearr_72461[(13)] = inst_72427);

(statearr_72461[(14)] = inst_72426);

(statearr_72461[(15)] = inst_72425);

(statearr_72461[(8)] = inst_72428);

(statearr_72461[(16)] = inst_72429);

(statearr_72461[(12)] = inst_72431);

return statearr_72461;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72451__$1,(6),inst_72433);
} else {
if((state_val_72452 === (9))){
var inst_72445 = (state_72451[(2)]);
var inst_72446 = cljs.core.async.put_BANG_.call(null,pc,inst_72445);
var _ = (function (){var statearr_72462 = state_72451;
(statearr_72462[(4)] = cljs.core.rest.call(null,(state_72451[(4)])));

return statearr_72462;
})();
var state_72451__$1 = state_72451;
var statearr_72463_72482 = state_72451__$1;
(statearr_72463_72482[(2)] = inst_72446);

(statearr_72463_72482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72452 === (5))){
var _ = (function (){var statearr_72464 = state_72451;
(statearr_72464[(4)] = cljs.core.rest.call(null,(state_72451[(4)])));

return statearr_72464;
})();
var state_72451__$1 = state_72451;
var ex72459 = (state_72451__$1[(2)]);
var statearr_72465_72483 = state_72451__$1;
(statearr_72465_72483[(5)] = ex72459);


var statearr_72466_72484 = state_72451__$1;
(statearr_72466_72484[(1)] = (4));

(statearr_72466_72484[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72452 === (10))){
var inst_72441 = (state_72451[(2)]);
var inst_72442 = fluree.db.util.async.throw_err.call(null,inst_72441);
var state_72451__$1 = state_72451;
var statearr_72467_72485 = state_72451__$1;
(statearr_72467_72485[(2)] = inst_72442);

(statearr_72467_72485[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72452 === (8))){
var inst_72437 = (state_72451[(7)]);
var state_72451__$1 = state_72451;
var statearr_72468_72486 = state_72451__$1;
(statearr_72468_72486[(2)] = inst_72437);

(statearr_72468_72486[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_72469 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72469[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_72469[(1)] = (1));

return statearr_72469;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_72451){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72451);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72470){var ex__2749__auto__ = e72470;
var statearr_72471_72487 = state_72451;
(statearr_72471_72487[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72451[(4)]))){
var statearr_72472_72488 = state_72451;
(statearr_72472_72488[(1)] = cljs.core.first.call(null,(state_72451[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72489 = state_72451;
state_72451 = G__72489;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_72451){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_72451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72473 = f__2769__auto__.call(null);
(statearr_72473[(6)] = c__2768__auto___72477);

return statearr_72473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq72400){
var G__72401 = cljs.core.first.call(null,seq72400);
var seq72400__$1 = cljs.core.next.call(null,seq72400);
var G__72402 = cljs.core.first.call(null,seq72400__$1);
var seq72400__$2 = cljs.core.next.call(null,seq72400__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72401,G__72402,seq72400__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(ledger_id){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
var and__4251__auto____$1 = open_api;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
return open_api;
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
return auth;
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__72491 = arguments.length;
switch (G__72491) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72620){
var state_val_72621 = (state_72620[(1)]);
if((state_val_72621 === (7))){
var inst_72520 = (state_72620[(7)]);
var inst_72510 = (state_72620[(8)]);
var inst_72522 = fluree.db.time_travel.as_of_block.call(null,inst_72520,inst_72510);
var state_72620__$1 = state_72620;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72620__$1,(10),inst_72522);
} else {
if((state_val_72621 === (20))){
var inst_72514 = (state_72620[(9)]);
var state_72620__$1 = state_72620;
var statearr_72622_72702 = state_72620__$1;
(statearr_72622_72702[(2)] = inst_72514);

(statearr_72622_72702[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (27))){
var inst_72508 = (state_72620[(10)]);
var state_72620__$1 = state_72620;
var statearr_72623_72703 = state_72620__$1;
(statearr_72623_72703[(2)] = inst_72508);

(statearr_72623_72703[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (1))){
var state_72620__$1 = state_72620;
var statearr_72624_72704 = state_72620__$1;
(statearr_72624_72704[(2)] = null);

(statearr_72624_72704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (24))){
var inst_72517 = (state_72620[(11)]);
var state_72620__$1 = state_72620;
if(cljs.core.truth_(inst_72517)){
var statearr_72625_72705 = state_72620__$1;
(statearr_72625_72705[(1)] = (26));

} else {
var statearr_72626_72706 = state_72620__$1;
(statearr_72626_72706[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (39))){
var inst_72582 = (state_72620[(12)]);
var inst_72585 = cljs.core.ex_data.call(null,inst_72582);
var inst_72586 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72587 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_72585);
var inst_72588 = cljs.core.ex_message.call(null,inst_72582);
var inst_72589 = [inst_72587,inst_72588,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72590 = cljs.core.PersistentHashMap.fromArrays(inst_72586,inst_72589);
var state_72620__$1 = state_72620;
var statearr_72627_72707 = state_72620__$1;
(statearr_72627_72707[(2)] = inst_72590);

(statearr_72627_72707[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (46))){
var inst_72582 = (state_72620[(12)]);
var state_72620__$1 = state_72620;
var statearr_72628_72708 = state_72620__$1;
(statearr_72628_72708[(2)] = inst_72582);

(statearr_72628_72708[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (4))){
var inst_72492 = (state_72620[(2)]);
var inst_72493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72494 = [inst_72492];
var inst_72495 = (new cljs.core.PersistentVector(null,1,(5),inst_72493,inst_72494,null));
var inst_72496 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72495);
var inst_72497 = cljs.core.ex_data.call(null,inst_72492);
var inst_72498 = cljs.core.ex_message.call(null,inst_72492);
var inst_72499 = cljs.core.assoc.call(null,inst_72497,new cljs.core.Keyword(null,"message","message",-406056002),inst_72498);
var state_72620__$1 = (function (){var statearr_72629 = state_72620;
(statearr_72629[(13)] = inst_72496);

return statearr_72629;
})();
var statearr_72630_72709 = state_72620__$1;
(statearr_72630_72709[(2)] = inst_72499);

(statearr_72630_72709[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (15))){
var state_72620__$1 = state_72620;
var statearr_72631_72710 = state_72620__$1;
(statearr_72631_72710[(2)] = (1000000));

(statearr_72631_72710[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (48))){
var inst_72582 = (state_72620[(12)]);
var state_72620__$1 = state_72620;
var statearr_72632_72711 = state_72620__$1;
(statearr_72632_72711[(2)] = inst_72582);

(statearr_72632_72711[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (50))){
var inst_72609 = (state_72620[(2)]);
var state_72620__$1 = state_72620;
var statearr_72633_72712 = state_72620__$1;
(statearr_72633_72712[(2)] = inst_72609);

(statearr_72633_72712[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (21))){
var inst_72513 = (state_72620[(14)]);
var state_72620__$1 = state_72620;
if(cljs.core.truth_(inst_72513)){
var statearr_72634_72713 = state_72620__$1;
(statearr_72634_72713[(1)] = (23));

} else {
var statearr_72635_72714 = state_72620__$1;
(statearr_72635_72714[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (31))){
var inst_72571 = (state_72620[(2)]);
var inst_72572 = cljs.core.not.call(null,inst_72571);
var state_72620__$1 = state_72620;
if(inst_72572){
var statearr_72636_72715 = state_72620__$1;
(statearr_72636_72715[(1)] = (35));

} else {
var statearr_72637_72716 = state_72620__$1;
(statearr_72637_72716[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (32))){
var inst_72515 = (state_72620[(15)]);
var state_72620__$1 = state_72620;
var statearr_72638_72717 = state_72620__$1;
(statearr_72638_72717[(2)] = inst_72515);

(statearr_72638_72717[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (40))){
var inst_72545 = (state_72620[(16)]);
var state_72620__$1 = state_72620;
if(cljs.core.truth_(inst_72545)){
var statearr_72639_72718 = state_72620__$1;
(statearr_72639_72718[(1)] = (42));

} else {
var statearr_72640_72719 = state_72620__$1;
(statearr_72640_72719[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (33))){
var inst_72511 = (state_72620[(17)]);
var state_72620__$1 = state_72620;
var statearr_72641_72720 = state_72620__$1;
(statearr_72641_72720[(2)] = inst_72511);

(statearr_72641_72720[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (13))){
var inst_72516 = (state_72620[(18)]);
var inst_72540 = (state_72620[(19)]);
var inst_72538 = (state_72620[(2)]);
var inst_72539 = cljs.core.volatile_BANG_.call(null,(0));
var inst_72540__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_72516);
var state_72620__$1 = (function (){var statearr_72642 = state_72620;
(statearr_72642[(20)] = inst_72539);

(statearr_72642[(19)] = inst_72540__$1);

(statearr_72642[(21)] = inst_72538);

return statearr_72642;
})();
if(cljs.core.truth_(inst_72540__$1)){
var statearr_72643_72721 = state_72620__$1;
(statearr_72643_72721[(1)] = (14));

} else {
var statearr_72644_72722 = state_72620__$1;
(statearr_72644_72722[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (22))){
var inst_72561 = (state_72620[(2)]);
var state_72620__$1 = state_72620;
var statearr_72645_72723 = state_72620__$1;
(statearr_72645_72723[(2)] = inst_72561);

(statearr_72645_72723[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (36))){
var inst_72528 = (state_72620[(22)]);
var inst_72547 = (state_72620[(23)]);
var inst_72578 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_72547);
var inst_72579 = fluree.db.query.fql.query.call(null,inst_72528,inst_72578);
var state_72620__$1 = state_72620;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72620__$1,(38),inst_72579);
} else {
if((state_val_72621 === (41))){
var inst_72613 = (state_72620[(2)]);
var state_72620__$1 = state_72620;
var statearr_72646_72724 = state_72620__$1;
(statearr_72646_72724[(2)] = inst_72613);

(statearr_72646_72724[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (43))){
var state_72620__$1 = state_72620;
var statearr_72647_72725 = state_72620__$1;
(statearr_72647_72725[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (29))){
var inst_72515 = (state_72620[(15)]);
var state_72620__$1 = state_72620;
if(cljs.core.truth_(inst_72515)){
var statearr_72649_72726 = state_72620__$1;
(statearr_72649_72726[(1)] = (32));

} else {
var statearr_72650_72727 = state_72620__$1;
(statearr_72650_72727[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (44))){
var inst_72611 = (state_72620[(2)]);
var state_72620__$1 = state_72620;
var statearr_72651_72728 = state_72620__$1;
(statearr_72651_72728[(2)] = inst_72611);

(statearr_72651_72728[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (6))){
var inst_72510 = (state_72620[(8)]);
var inst_72519 = (state_72620[(2)]);
var inst_72520 = fluree.db.util.async.throw_err.call(null,inst_72519);
var state_72620__$1 = (function (){var statearr_72652 = state_72620;
(statearr_72652[(7)] = inst_72520);

return statearr_72652;
})();
if(cljs.core.truth_(inst_72510)){
var statearr_72653_72729 = state_72620__$1;
(statearr_72653_72729[(1)] = (7));

} else {
var statearr_72654_72730 = state_72620__$1;
(statearr_72654_72730[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (28))){
var inst_72557 = (state_72620[(2)]);
var state_72620__$1 = state_72620;
var statearr_72655_72731 = state_72620__$1;
(statearr_72655_72731[(2)] = inst_72557);

(statearr_72655_72731[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (25))){
var inst_72559 = (state_72620[(2)]);
var state_72620__$1 = state_72620;
var statearr_72656_72732 = state_72620__$1;
(statearr_72656_72732[(2)] = inst_72559);

(statearr_72656_72732[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (34))){
var inst_72568 = (state_72620[(2)]);
var state_72620__$1 = state_72620;
var statearr_72657_72733 = state_72620__$1;
(statearr_72657_72733[(2)] = inst_72568);

(statearr_72657_72733[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (17))){
var inst_72509 = (state_72620[(24)]);
var state_72620__$1 = state_72620;
var statearr_72658_72734 = state_72620__$1;
(statearr_72658_72734[(2)] = inst_72509);

(statearr_72658_72734[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (3))){
var inst_72618 = (state_72620[(2)]);
var state_72620__$1 = state_72620;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72620__$1,inst_72618);
} else {
if((state_val_72621 === (12))){
var inst_72536 = cljs.core.PersistentHashMap.EMPTY;
var state_72620__$1 = state_72620;
var statearr_72659_72735 = state_72620__$1;
(statearr_72659_72735[(2)] = inst_72536);

(statearr_72659_72735[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (2))){
var _ = (function (){var statearr_72660 = state_72620;
(statearr_72660[(4)] = cljs.core.cons.call(null,(5),(state_72620[(4)])));

return statearr_72660;
})();
var inst_72506 = query_map;
var inst_72507 = cljs.core.__destructure_map.call(null,inst_72506);
var inst_72508 = cljs.core.get.call(null,inst_72507,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_72509 = cljs.core.get.call(null,inst_72507,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_72510 = cljs.core.get.call(null,inst_72507,new cljs.core.Keyword(null,"block","block",664686210));
var inst_72511 = cljs.core.get.call(null,inst_72507,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_72512 = cljs.core.get.call(null,inst_72507,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_72513 = cljs.core.get.call(null,inst_72507,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_72514 = cljs.core.get.call(null,inst_72507,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_72515 = cljs.core.get.call(null,inst_72507,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_72516 = cljs.core.get.call(null,inst_72507,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_72517 = cljs.core.get.call(null,inst_72507,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_72620__$1 = (function (){var statearr_72661 = state_72620;
(statearr_72661[(11)] = inst_72517);

(statearr_72661[(9)] = inst_72514);

(statearr_72661[(17)] = inst_72511);

(statearr_72661[(18)] = inst_72516);

(statearr_72661[(8)] = inst_72510);

(statearr_72661[(24)] = inst_72509);

(statearr_72661[(14)] = inst_72513);

(statearr_72661[(15)] = inst_72515);

(statearr_72661[(25)] = inst_72512);

(statearr_72661[(10)] = inst_72508);

return statearr_72661;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72620__$1,(6),sources);
} else {
if((state_val_72621 === (23))){
var inst_72513 = (state_72620[(14)]);
var state_72620__$1 = state_72620;
var statearr_72662_72736 = state_72620__$1;
(statearr_72662_72736[(2)] = inst_72513);

(statearr_72662_72736[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (47))){
var inst_72528 = (state_72620[(22)]);
var inst_72593 = (state_72620[(26)]);
var inst_72539 = (state_72620[(20)]);
var inst_72546 = (state_72620[(27)]);
var inst_72599 = (state_72620[(2)]);
var inst_72600 = cljs.core.deref.call(null,inst_72539);
var inst_72601 = fluree.db.util.core.response_time_formatted.call(null,inst_72546);
var inst_72602 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_72528);
var inst_72603 = [(200),inst_72599,inst_72600,inst_72601,inst_72602];
var inst_72604 = cljs.core.PersistentHashMap.fromArrays(inst_72593,inst_72603);
var state_72620__$1 = state_72620;
var statearr_72663_72737 = state_72620__$1;
(statearr_72663_72737[(2)] = inst_72604);

(statearr_72663_72737[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (35))){
var inst_72574 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72575 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72576 = cljs.core.PersistentHashMap.fromArrays(inst_72574,inst_72575);
var state_72620__$1 = state_72620;
var statearr_72664_72738 = state_72620__$1;
(statearr_72664_72738[(2)] = inst_72576);

(statearr_72664_72738[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (19))){
var inst_72563 = (state_72620[(28)]);
var inst_72563__$1 = (state_72620[(2)]);
var state_72620__$1 = (function (){var statearr_72665 = state_72620;
(statearr_72665[(28)] = inst_72563__$1);

return statearr_72665;
})();
if(cljs.core.truth_(inst_72563__$1)){
var statearr_72666_72739 = state_72620__$1;
(statearr_72666_72739[(1)] = (29));

} else {
var statearr_72667_72740 = state_72620__$1;
(statearr_72667_72740[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (11))){
var inst_72528 = (state_72620[(22)]);
var inst_72529 = (state_72620[(29)]);
var inst_72512 = (state_72620[(25)]);
var inst_72531 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_72528);
var inst_72532 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_72529);
var inst_72533 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_72528);
var inst_72534 = fluree.db.api_js.get_sources.call(null,inst_72529,inst_72531,inst_72532,inst_72533,inst_72512,db_fn);
var state_72620__$1 = state_72620;
var statearr_72669_72741 = state_72620__$1;
(statearr_72669_72741[(2)] = inst_72534);

(statearr_72669_72741[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (9))){
var inst_72528 = (state_72620[(22)]);
var inst_72512 = (state_72620[(25)]);
var inst_72528__$1 = (state_72620[(2)]);
var inst_72529 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_72528__$1);
var state_72620__$1 = (function (){var statearr_72670 = state_72620;
(statearr_72670[(22)] = inst_72528__$1);

(statearr_72670[(29)] = inst_72529);

return statearr_72670;
})();
if(cljs.core.truth_(inst_72512)){
var statearr_72671_72742 = state_72620__$1;
(statearr_72671_72742[(1)] = (11));

} else {
var statearr_72672_72743 = state_72620__$1;
(statearr_72672_72743[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (5))){
var _ = (function (){var statearr_72673 = state_72620;
(statearr_72673[(4)] = cljs.core.rest.call(null,(state_72620[(4)])));

return statearr_72673;
})();
var state_72620__$1 = state_72620;
var ex72668 = (state_72620__$1[(2)]);
var statearr_72674_72744 = state_72620__$1;
(statearr_72674_72744[(5)] = ex72668);


var statearr_72675_72745 = state_72620__$1;
(statearr_72675_72745[(1)] = (4));

(statearr_72675_72745[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (14))){
var inst_72540 = (state_72620[(19)]);
var state_72620__$1 = state_72620;
var statearr_72676_72746 = state_72620__$1;
(statearr_72676_72746[(2)] = inst_72540);

(statearr_72676_72746[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (45))){
var inst_72582 = (state_72620[(12)]);
var inst_72596 = cljs.core.doall.call(null,inst_72582);
var state_72620__$1 = state_72620;
var statearr_72677_72747 = state_72620__$1;
(statearr_72677_72747[(2)] = inst_72596);

(statearr_72677_72747[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (26))){
var inst_72517 = (state_72620[(11)]);
var state_72620__$1 = state_72620;
var statearr_72678_72748 = state_72620__$1;
(statearr_72678_72748[(2)] = inst_72517);

(statearr_72678_72748[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (16))){
var inst_72516 = (state_72620[(18)]);
var inst_72539 = (state_72620[(20)]);
var inst_72509 = (state_72620[(24)]);
var inst_72538 = (state_72620[(21)]);
var inst_72544 = (state_72620[(2)]);
var inst_72545 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_72516);
var inst_72546 = fluree.db.util.core.current_time_millis.call(null);
var inst_72547 = cljs.core.assoc.call(null,inst_72516,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_72538,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_72544,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_72539);
var state_72620__$1 = (function (){var statearr_72679 = state_72620;
(statearr_72679[(23)] = inst_72547);

(statearr_72679[(27)] = inst_72546);

(statearr_72679[(16)] = inst_72545);

return statearr_72679;
})();
if(cljs.core.truth_(inst_72509)){
var statearr_72680_72749 = state_72620__$1;
(statearr_72680_72749[(1)] = (17));

} else {
var statearr_72681_72750 = state_72620__$1;
(statearr_72681_72750[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (38))){
var inst_72582 = (state_72620[(12)]);
var inst_72581 = (state_72620[(2)]);
var inst_72582__$1 = fluree.db.util.async.throw_err.call(null,inst_72581);
var inst_72583 = (inst_72582__$1 instanceof cljs.core.ExceptionInfo);
var state_72620__$1 = (function (){var statearr_72682 = state_72620;
(statearr_72682[(12)] = inst_72582__$1);

return statearr_72682;
})();
if(cljs.core.truth_(inst_72583)){
var statearr_72683_72751 = state_72620__$1;
(statearr_72683_72751[(1)] = (39));

} else {
var statearr_72684_72752 = state_72620__$1;
(statearr_72684_72752[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (30))){
var inst_72563 = (state_72620[(28)]);
var state_72620__$1 = state_72620;
var statearr_72685_72753 = state_72620__$1;
(statearr_72685_72753[(2)] = inst_72563);

(statearr_72685_72753[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (10))){
var inst_72524 = (state_72620[(2)]);
var inst_72525 = fluree.db.util.async.throw_err.call(null,inst_72524);
var state_72620__$1 = state_72620;
var statearr_72686_72754 = state_72620__$1;
(statearr_72686_72754[(2)] = inst_72525);

(statearr_72686_72754[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (18))){
var inst_72514 = (state_72620[(9)]);
var state_72620__$1 = state_72620;
if(cljs.core.truth_(inst_72514)){
var statearr_72687_72755 = state_72620__$1;
(statearr_72687_72755[(1)] = (20));

} else {
var statearr_72688_72756 = state_72620__$1;
(statearr_72688_72756[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (42))){
var inst_72582 = (state_72620[(12)]);
var inst_72593 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_72594 = cljs.core.sequential_QMARK_.call(null,inst_72582);
var state_72620__$1 = (function (){var statearr_72689 = state_72620;
(statearr_72689[(26)] = inst_72593);

return statearr_72689;
})();
if(inst_72594){
var statearr_72690_72757 = state_72620__$1;
(statearr_72690_72757[(1)] = (45));

} else {
var statearr_72691_72758 = state_72620__$1;
(statearr_72691_72758[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (37))){
var inst_72615 = (state_72620[(2)]);
var _ = (function (){var statearr_72692 = state_72620;
(statearr_72692[(4)] = cljs.core.rest.call(null,(state_72620[(4)])));

return statearr_72692;
})();
var state_72620__$1 = state_72620;
var statearr_72693_72759 = state_72620__$1;
(statearr_72693_72759[(2)] = inst_72615);

(statearr_72693_72759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (8))){
var inst_72520 = (state_72620[(7)]);
var state_72620__$1 = state_72620;
var statearr_72694_72760 = state_72620__$1;
(statearr_72694_72760[(2)] = inst_72520);

(statearr_72694_72760[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72621 === (49))){
var state_72620__$1 = state_72620;
var statearr_72695_72761 = state_72620__$1;
(statearr_72695_72761[(2)] = null);

(statearr_72695_72761[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_72696 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72696[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_72696[(1)] = (1));

return statearr_72696;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_72620){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72620);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72697){var ex__2749__auto__ = e72697;
var statearr_72698_72762 = state_72620;
(statearr_72698_72762[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72620[(4)]))){
var statearr_72699_72763 = state_72620;
(statearr_72699_72763[(1)] = cljs.core.first.call(null,(state_72620[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72764 = state_72620;
state_72620 = G__72764;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_72620){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_72620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72700 = f__2769__auto__.call(null);
(statearr_72700[(6)] = c__2768__auto__);

return statearr_72700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__72765_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__72765_SHARP_);
}));

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72787){
var state_val_72788 = (state_72787[(1)]);
if((state_val_72788 === (1))){
var inst_72769 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72770 = [resp_chan,timeout_chan];
var inst_72771 = (new cljs.core.PersistentVector(null,2,(5),inst_72769,inst_72770,null));
var state_72787__$1 = state_72787;
return cljs.core.async.ioc_alts_BANG_.call(null,state_72787__$1,(2),inst_72771);
} else {
if((state_val_72788 === (2))){
var inst_72773 = (state_72787[(2)]);
var inst_72774 = cljs.core.nth.call(null,inst_72773,(0),null);
var inst_72775 = cljs.core.nth.call(null,inst_72773,(1),null);
var inst_72776 = cljs.core._EQ_.call(null,timeout_chan,inst_72775);
var state_72787__$1 = (function (){var statearr_72789 = state_72787;
(statearr_72789[(7)] = inst_72774);

return statearr_72789;
})();
if(inst_72776){
var statearr_72790_72800 = state_72787__$1;
(statearr_72790_72800[(1)] = (3));

} else {
var statearr_72791_72801 = state_72787__$1;
(statearr_72791_72801[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72788 === (3))){
var inst_72778 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_72779 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_72780 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_72781 = [tid,(408),inst_72780];
var inst_72782 = cljs.core.PersistentHashMap.fromArrays(inst_72779,inst_72781);
var state_72787__$1 = (function (){var statearr_72792 = state_72787;
(statearr_72792[(8)] = inst_72778);

return statearr_72792;
})();
var statearr_72793_72802 = state_72787__$1;
(statearr_72793_72802[(2)] = inst_72782);

(statearr_72793_72802[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72788 === (4))){
var inst_72774 = (state_72787[(7)]);
var state_72787__$1 = state_72787;
var statearr_72794_72803 = state_72787__$1;
(statearr_72794_72803[(2)] = inst_72774);

(statearr_72794_72803[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72788 === (5))){
var inst_72785 = (state_72787[(2)]);
var state_72787__$1 = state_72787;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72787__$1,inst_72785);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0 = (function (){
var statearr_72795 = [null,null,null,null,null,null,null,null,null];
(statearr_72795[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__);

(statearr_72795[(1)] = (1));

return statearr_72795;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1 = (function (state_72787){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72787);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72796){var ex__2749__auto__ = e72796;
var statearr_72797_72804 = state_72787;
(statearr_72797_72804[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72787[(4)]))){
var statearr_72798_72805 = state_72787;
(statearr_72798_72805[(1)] = cljs.core.first.call(null,(state_72787[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72806 = state_72787;
state_72787 = G__72806;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__ = function(state_72787){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1.call(this,state_72787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72799 = f__2769__auto__.call(null);
(statearr_72799[(6)] = c__2768__auto__);

return statearr_72799;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__72808 = arguments.length;
switch (G__72808) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__72809 = opts;
var map__72809__$1 = cljs.core.__destructure_map.call(null,map__72809);
var auth = cljs.core.get.call(null,map__72809__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__72809__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__72809__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__72809__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__72810 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__72810,(0),null);
var authority = cljs.core.nth.call(null,vec__72810,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e72813){var e = e72813;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__72816 = arguments.length;
switch (G__72816) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72885){
var state_val_72886 = (state_72885[(1)]);
if((state_val_72886 === (7))){
var inst_72838 = (state_72885[(7)]);
var inst_72841 = (state_72885[(8)]);
var inst_72840 = (state_72885[(9)]);
var inst_72839 = (state_72885[(10)]);
var inst_72836 = (state_72885[(11)]);
var inst_72854 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_72855 = [ledger,txn,inst_72836,inst_72838,inst_72839,inst_72840,inst_72841];
var inst_72856 = cljs.core.PersistentHashMap.fromArrays(inst_72854,inst_72855);
var inst_72857 = fluree.db.util.core.without_nils.call(null,inst_72856);
var inst_72858 = fluree.db.operations.transact_async.call(null,conn,inst_72857);
var state_72885__$1 = state_72885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72885__$1,(13),inst_72858);
} else {
if((state_val_72886 === (20))){
var inst_72876 = (state_72885[(2)]);
var state_72885__$1 = state_72885;
var statearr_72887_72923 = state_72885__$1;
(statearr_72887_72923[(2)] = inst_72876);

(statearr_72887_72923[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (1))){
var state_72885__$1 = state_72885;
var statearr_72888_72924 = state_72885__$1;
(statearr_72888_72924[(2)] = null);

(statearr_72888_72924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (4))){
var inst_72817 = (state_72885[(2)]);
var inst_72818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72819 = [inst_72817];
var inst_72820 = (new cljs.core.PersistentVector(null,1,(5),inst_72818,inst_72819,null));
var inst_72821 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_72820);
var inst_72822 = cljs.core.ex_data.call(null,inst_72817);
var inst_72823 = cljs.core.ex_message.call(null,inst_72817);
var inst_72824 = cljs.core.assoc.call(null,inst_72822,new cljs.core.Keyword(null,"message","message",-406056002),inst_72823);
var state_72885__$1 = (function (){var statearr_72889 = state_72885;
(statearr_72889[(12)] = inst_72821);

return statearr_72889;
})();
var statearr_72890_72925 = state_72885__$1;
(statearr_72890_72925[(2)] = inst_72824);

(statearr_72890_72925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (15))){
var inst_72835 = (state_72885[(13)]);
var inst_72860 = (state_72885[(14)]);
var inst_72863 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_72860,inst_72835);
var state_72885__$1 = state_72885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72885__$1,(17),inst_72863);
} else {
if((state_val_72886 === (13))){
var inst_72834 = (state_72885[(15)]);
var inst_72860 = (state_72885[(2)]);
var state_72885__$1 = (function (){var statearr_72891 = state_72885;
(statearr_72891[(14)] = inst_72860);

return statearr_72891;
})();
if(cljs.core.truth_(inst_72834)){
var statearr_72892_72926 = state_72885__$1;
(statearr_72892_72926[(1)] = (14));

} else {
var statearr_72893_72927 = state_72885__$1;
(statearr_72893_72927[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (6))){
var inst_72834 = (state_72885[(15)]);
var inst_72833 = (state_72885[(16)]);
var inst_72843 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_72833,opts);
var inst_72844 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_72843);
var inst_72845 = fluree.db.operations.command_async.call(null,conn,inst_72843);
var state_72885__$1 = (function (){var statearr_72894 = state_72885;
(statearr_72894[(17)] = inst_72845);

(statearr_72894[(18)] = inst_72844);

return statearr_72894;
})();
if(cljs.core.truth_(inst_72834)){
var statearr_72895_72928 = state_72885__$1;
(statearr_72895_72928[(1)] = (9));

} else {
var statearr_72896_72929 = state_72885__$1;
(statearr_72896_72929[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (17))){
var inst_72865 = (state_72885[(19)]);
var inst_72865__$1 = (state_72885[(2)]);
var inst_72866 = (inst_72865__$1 instanceof cljs.core.ExceptionInfo);
var state_72885__$1 = (function (){var statearr_72897 = state_72885;
(statearr_72897[(19)] = inst_72865__$1);

return statearr_72897;
})();
if(cljs.core.truth_(inst_72866)){
var statearr_72898_72930 = state_72885__$1;
(statearr_72898_72930[(1)] = (18));

} else {
var statearr_72899_72931 = state_72885__$1;
(statearr_72899_72931[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (3))){
var inst_72883 = (state_72885[(2)]);
var state_72885__$1 = state_72885;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72885__$1,inst_72883);
} else {
if((state_val_72886 === (12))){
var inst_72850 = (state_72885[(2)]);
var state_72885__$1 = state_72885;
var statearr_72900_72932 = state_72885__$1;
(statearr_72900_72932[(2)] = inst_72850);

(statearr_72900_72932[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (2))){
var inst_72833 = (state_72885[(16)]);
var _ = (function (){var statearr_72901 = state_72885;
(statearr_72901[(4)] = cljs.core.cons.call(null,(5),(state_72885[(4)])));

return statearr_72901;
})();
var inst_72831 = opts;
var inst_72832 = cljs.core.__destructure_map.call(null,inst_72831);
var inst_72833__$1 = cljs.core.get.call(null,inst_72832,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_72834 = cljs.core.get.call(null,inst_72832,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_72835 = cljs.core.get.call(null,inst_72832,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_72836 = cljs.core.get.call(null,inst_72832,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_72837 = fluree.db.util.core.current_time_millis.call(null);
var inst_72838 = cljs.core.get.call(null,inst_72832,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_72837);
var inst_72839 = cljs.core.get.call(null,inst_72832,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_72840 = cljs.core.get.call(null,inst_72832,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_72841 = cljs.core.get.call(null,inst_72832,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_72885__$1 = (function (){var statearr_72902 = state_72885;
(statearr_72902[(13)] = inst_72835);

(statearr_72902[(7)] = inst_72838);

(statearr_72902[(15)] = inst_72834);

(statearr_72902[(8)] = inst_72841);

(statearr_72902[(9)] = inst_72840);

(statearr_72902[(10)] = inst_72839);

(statearr_72902[(11)] = inst_72836);

(statearr_72902[(16)] = inst_72833__$1);

return statearr_72902;
})();
if(cljs.core.truth_(inst_72833__$1)){
var statearr_72903_72933 = state_72885__$1;
(statearr_72903_72933[(1)] = (6));

} else {
var statearr_72904_72934 = state_72885__$1;
(statearr_72904_72934[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (19))){
var inst_72865 = (state_72885[(19)]);
var state_72885__$1 = state_72885;
var statearr_72905_72935 = state_72885__$1;
(statearr_72905_72935[(2)] = inst_72865);

(statearr_72905_72935[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (11))){
var inst_72852 = (state_72885[(2)]);
var state_72885__$1 = state_72885;
var statearr_72907_72936 = state_72885__$1;
(statearr_72907_72936[(2)] = inst_72852);

(statearr_72907_72936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (9))){
var inst_72845 = (state_72885[(17)]);
var state_72885__$1 = state_72885;
var statearr_72908_72937 = state_72885__$1;
(statearr_72908_72937[(2)] = inst_72845);

(statearr_72908_72937[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (5))){
var _ = (function (){var statearr_72909 = state_72885;
(statearr_72909[(4)] = cljs.core.rest.call(null,(state_72885[(4)])));

return statearr_72909;
})();
var state_72885__$1 = state_72885;
var ex72906 = (state_72885__$1[(2)]);
var statearr_72910_72938 = state_72885__$1;
(statearr_72910_72938[(5)] = ex72906);


var statearr_72911_72939 = state_72885__$1;
(statearr_72911_72939[(1)] = (4));

(statearr_72911_72939[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (14))){
var inst_72860 = (state_72885[(14)]);
var state_72885__$1 = state_72885;
var statearr_72912_72940 = state_72885__$1;
(statearr_72912_72940[(2)] = inst_72860);

(statearr_72912_72940[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (16))){
var inst_72878 = (state_72885[(2)]);
var state_72885__$1 = state_72885;
var statearr_72913_72941 = state_72885__$1;
(statearr_72913_72941[(2)] = inst_72878);

(statearr_72913_72941[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (10))){
var inst_72835 = (state_72885[(13)]);
var inst_72844 = (state_72885[(18)]);
var inst_72848 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_72844,inst_72835);
var state_72885__$1 = state_72885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72885__$1,(12),inst_72848);
} else {
if((state_val_72886 === (18))){
var inst_72865 = (state_72885[(19)]);
var inst_72868 = cljs.core.ex_data.call(null,inst_72865);
var inst_72869 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72870 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_72868);
var inst_72871 = cljs.core.ex_message.call(null,inst_72865);
var inst_72872 = [inst_72870,inst_72871,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_72873 = cljs.core.PersistentHashMap.fromArrays(inst_72869,inst_72872);
var state_72885__$1 = state_72885;
var statearr_72914_72942 = state_72885__$1;
(statearr_72914_72942[(2)] = inst_72873);

(statearr_72914_72942[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72886 === (8))){
var inst_72880 = (state_72885[(2)]);
var _ = (function (){var statearr_72915 = state_72885;
(statearr_72915[(4)] = cljs.core.rest.call(null,(state_72885[(4)])));

return statearr_72915;
})();
var state_72885__$1 = state_72885;
var statearr_72916_72943 = state_72885__$1;
(statearr_72916_72943[(2)] = inst_72880);

(statearr_72916_72943[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_72917 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72917[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_72917[(1)] = (1));

return statearr_72917;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_72885){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72885);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72918){var ex__2749__auto__ = e72918;
var statearr_72919_72944 = state_72885;
(statearr_72919_72944[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72885[(4)]))){
var statearr_72920_72945 = state_72885;
(statearr_72920_72945[(1)] = cljs.core.first.call(null,(state_72885[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72946 = state_72885;
state_72885 = G__72946;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_72885){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_72885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72921 = f__2769__auto__.call(null);
(statearr_72921[(6)] = c__2768__auto__);

return statearr_72921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___72948 = arguments.length;
var i__4865__auto___72949 = (0);
while(true){
if((i__4865__auto___72949 < len__4864__auto___72948)){
args__4870__auto__.push((arguments[i__4865__auto___72949]));

var G__72950 = (i__4865__auto___72949 + (1));
i__4865__auto___72949 = G__72950;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq72947){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq72947));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_72981){
var state_val_72982 = (state_72981[(1)]);
if((state_val_72982 === (1))){
var inst_72951 = cljs.core.first.call(null,flakes);
var inst_72952 = cljs.core.rest.call(null,flakes);
var inst_72953 = cljs.core.PersistentVector.EMPTY;
var inst_72954 = inst_72951;
var inst_72955 = inst_72952;
var inst_72956 = inst_72953;
var state_72981__$1 = (function (){var statearr_72983 = state_72981;
(statearr_72983[(7)] = inst_72956);

(statearr_72983[(8)] = inst_72955);

(statearr_72983[(9)] = inst_72954);

return statearr_72983;
})();
var statearr_72984_72997 = state_72981__$1;
(statearr_72984_72997[(2)] = null);

(statearr_72984_72997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72982 === (2))){
var inst_72954 = (state_72981[(9)]);
var inst_72958 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_72959 = cljs.core.PersistentHashMap.EMPTY;
var inst_72960 = [true,inst_72959];
var inst_72961 = cljs.core.PersistentHashMap.fromArrays(inst_72958,inst_72960);
var inst_72962 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_72961,inst_72954);
var state_72981__$1 = state_72981;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72981__$1,(4),inst_72962);
} else {
if((state_val_72982 === (3))){
var inst_72979 = (state_72981[(2)]);
var state_72981__$1 = state_72981;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72981__$1,inst_72979);
} else {
if((state_val_72982 === (4))){
var inst_72956 = (state_72981[(7)]);
var inst_72955 = (state_72981[(8)]);
var inst_72964 = (state_72981[(2)]);
var inst_72965 = fluree.db.util.async.throw_err.call(null,inst_72964);
var inst_72966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72967 = [inst_72965];
var inst_72968 = (new cljs.core.PersistentVector(null,1,(5),inst_72966,inst_72967,null));
var inst_72969 = cljs.core.concat.call(null,inst_72956,inst_72968);
var inst_72970 = cljs.core.first.call(null,inst_72955);
var state_72981__$1 = (function (){var statearr_72985 = state_72981;
(statearr_72985[(10)] = inst_72969);

return statearr_72985;
})();
if(cljs.core.truth_(inst_72970)){
var statearr_72986_72998 = state_72981__$1;
(statearr_72986_72998[(1)] = (5));

} else {
var statearr_72987_72999 = state_72981__$1;
(statearr_72987_72999[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72982 === (5))){
var inst_72969 = (state_72981[(10)]);
var inst_72955 = (state_72981[(8)]);
var inst_72972 = cljs.core.first.call(null,inst_72955);
var inst_72973 = cljs.core.rest.call(null,inst_72955);
var inst_72954 = inst_72972;
var inst_72955__$1 = inst_72973;
var inst_72956 = inst_72969;
var state_72981__$1 = (function (){var statearr_72988 = state_72981;
(statearr_72988[(7)] = inst_72956);

(statearr_72988[(8)] = inst_72955__$1);

(statearr_72988[(9)] = inst_72954);

return statearr_72988;
})();
var statearr_72989_73000 = state_72981__$1;
(statearr_72989_73000[(2)] = null);

(statearr_72989_73000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72982 === (6))){
var inst_72969 = (state_72981[(10)]);
var state_72981__$1 = state_72981;
var statearr_72990_73001 = state_72981__$1;
(statearr_72990_73001[(2)] = inst_72969);

(statearr_72990_73001[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72982 === (7))){
var inst_72977 = (state_72981[(2)]);
var state_72981__$1 = state_72981;
var statearr_72991_73002 = state_72981__$1;
(statearr_72991_73002[(2)] = inst_72977);

(statearr_72991_73002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_72992 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_72992[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__);

(statearr_72992[(1)] = (1));

return statearr_72992;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1 = (function (state_72981){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_72981);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e72993){var ex__2749__auto__ = e72993;
var statearr_72994_73003 = state_72981;
(statearr_72994_73003[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_72981[(4)]))){
var statearr_72995_73004 = state_72981;
(statearr_72995_73004[(1)] = cljs.core.first.call(null,(state_72981[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73005 = state_72981;
state_72981 = G__73005;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__ = function(state_72981){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1.call(this,state_72981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_72996 = f__2769__auto__.call(null);
(statearr_72996[(6)] = c__2768__auto__);

return statearr_72996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73073){
var state_val_73074 = (state_73073[(1)]);
if((state_val_73074 === (7))){
var inst_73033 = (state_73073[(2)]);
var inst_73034 = fluree.db.util.async.throw_err.call(null,inst_73033);
var state_73073__$1 = state_73073;
var statearr_73075_73101 = state_73073__$1;
(statearr_73075_73101[(2)] = inst_73034);

(statearr_73075_73101[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73074 === (1))){
var inst_73010 = cljs.core.volatile_BANG_.call(null,(0));
var inst_73011 = cljs.core.PersistentHashMap.EMPTY;
var inst_73012 = cljs.core.volatile_BANG_.call(null,inst_73011);
var inst_73013 = cljs.core.first.call(null,resp);
var inst_73014 = cljs.core.rest.call(null,resp);
var inst_73015 = cljs.core.PersistentVector.EMPTY;
var inst_73016 = inst_73010;
var inst_73017 = inst_73012;
var inst_73018 = inst_73013;
var inst_73019 = inst_73014;
var inst_73020 = inst_73015;
var state_73073__$1 = (function (){var statearr_73076 = state_73073;
(statearr_73076[(7)] = inst_73019);

(statearr_73076[(8)] = inst_73016);

(statearr_73076[(9)] = inst_73020);

(statearr_73076[(10)] = inst_73017);

(statearr_73076[(11)] = inst_73018);

return statearr_73076;
})();
var statearr_73077_73102 = state_73073__$1;
(statearr_73077_73102[(2)] = null);

(statearr_73077_73102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73074 === (4))){
var inst_73019 = (state_73073[(7)]);
var inst_73016 = (state_73073[(8)]);
var inst_73022 = (state_73073[(12)]);
var inst_73024 = (state_73073[(13)]);
var inst_73020 = (state_73073[(9)]);
var inst_73017 = (state_73073[(10)]);
var inst_73018 = (state_73073[(11)]);
var inst_73028 = (function (){var fuel = inst_73016;
var cache = inst_73017;
var curr_block = inst_73018;
var rest_blocks = inst_73019;
var acc = inst_73020;
var flakes = inst_73022;
var asserted = inst_73024;
return (function (p1__73007_SHARP_){
return p1__73007_SHARP_.s;
});
})();
var inst_73029 = cljs.core.group_by.call(null,inst_73028,inst_73024);
var inst_73030 = cljs.core.vals.call(null,inst_73029);
var inst_73031 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_73017,inst_73016,inst_73030);
var state_73073__$1 = state_73073;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73073__$1,(7),inst_73031);
} else {
if((state_val_73074 === (13))){
var inst_73061 = (state_73073[(14)]);
var state_73073__$1 = state_73073;
var statearr_73078_73103 = state_73073__$1;
(statearr_73078_73103[(2)] = inst_73061);

(statearr_73078_73103[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73074 === (6))){
var inst_73019 = (state_73073[(7)]);
var inst_73016 = (state_73073[(8)]);
var inst_73022 = (state_73073[(12)]);
var inst_73024 = (state_73073[(13)]);
var inst_73037 = (state_73073[(15)]);
var inst_73020 = (state_73073[(9)]);
var inst_73017 = (state_73073[(10)]);
var inst_73018 = (state_73073[(11)]);
var inst_73039 = (state_73073[(16)]);
var inst_73037__$1 = (state_73073[(2)]);
var inst_73038 = (function (){var fuel = inst_73016;
var cache = inst_73017;
var curr_block = inst_73018;
var rest_blocks = inst_73019;
var acc = inst_73020;
var flakes = inst_73022;
var asserted = inst_73024;
var asserted_SINGLEQUOTE_ = inst_73037__$1;
return (function (p1__73008_SHARP_){
return p1__73008_SHARP_.op === false;
});
})();
var inst_73039__$1 = cljs.core.filter.call(null,inst_73038,inst_73022);
var inst_73040 = cljs.core.empty_QMARK_.call(null,inst_73039__$1);
var inst_73041 = (!(inst_73040));
var state_73073__$1 = (function (){var statearr_73081 = state_73073;
(statearr_73081[(15)] = inst_73037__$1);

(statearr_73081[(16)] = inst_73039__$1);

return statearr_73081;
})();
if(inst_73041){
var statearr_73082_73104 = state_73073__$1;
(statearr_73082_73104[(1)] = (8));

} else {
var statearr_73083_73105 = state_73073__$1;
(statearr_73083_73105[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73074 === (3))){
var inst_73071 = (state_73073[(2)]);
var state_73073__$1 = state_73073;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73073__$1,inst_73071);
} else {
if((state_val_73074 === (12))){
var inst_73019 = (state_73073[(7)]);
var inst_73016 = (state_73073[(8)]);
var inst_73061 = (state_73073[(14)]);
var inst_73017 = (state_73073[(10)]);
var inst_73064 = cljs.core.first.call(null,inst_73019);
var inst_73065 = cljs.core.rest.call(null,inst_73019);
var tmp73079 = inst_73016;
var tmp73080 = inst_73017;
var inst_73016__$1 = tmp73079;
var inst_73017__$1 = tmp73080;
var inst_73018 = inst_73064;
var inst_73019__$1 = inst_73065;
var inst_73020 = inst_73061;
var state_73073__$1 = (function (){var statearr_73084 = state_73073;
(statearr_73084[(7)] = inst_73019__$1);

(statearr_73084[(8)] = inst_73016__$1);

(statearr_73084[(9)] = inst_73020);

(statearr_73084[(10)] = inst_73017__$1);

(statearr_73084[(11)] = inst_73018);

return statearr_73084;
})();
var statearr_73085_73106 = state_73073__$1;
(statearr_73085_73106[(2)] = null);

(statearr_73085_73106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73074 === (2))){
var inst_73019 = (state_73073[(7)]);
var inst_73016 = (state_73073[(8)]);
var inst_73022 = (state_73073[(12)]);
var inst_73024 = (state_73073[(13)]);
var inst_73020 = (state_73073[(9)]);
var inst_73017 = (state_73073[(10)]);
var inst_73018 = (state_73073[(11)]);
var inst_73022__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_73018);
var inst_73023 = (function (){var fuel = inst_73016;
var cache = inst_73017;
var curr_block = inst_73018;
var rest_blocks = inst_73019;
var acc = inst_73020;
var flakes = inst_73022__$1;
return (function (p1__73006_SHARP_){
return p1__73006_SHARP_.op;
});
})();
var inst_73024__$1 = cljs.core.filter.call(null,inst_73023,inst_73022__$1);
var inst_73025 = cljs.core.empty_QMARK_.call(null,inst_73024__$1);
var inst_73026 = (!(inst_73025));
var state_73073__$1 = (function (){var statearr_73086 = state_73073;
(statearr_73086[(12)] = inst_73022__$1);

(statearr_73086[(13)] = inst_73024__$1);

return statearr_73086;
})();
if(inst_73026){
var statearr_73087_73107 = state_73073__$1;
(statearr_73087_73107[(1)] = (4));

} else {
var statearr_73088_73108 = state_73073__$1;
(statearr_73088_73108[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73074 === (11))){
var inst_73049 = (state_73073[(2)]);
var inst_73050 = fluree.db.util.async.throw_err.call(null,inst_73049);
var state_73073__$1 = state_73073;
var statearr_73089_73109 = state_73073__$1;
(statearr_73089_73109[(2)] = inst_73050);

(statearr_73089_73109[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73074 === (9))){
var state_73073__$1 = state_73073;
var statearr_73090_73110 = state_73073__$1;
(statearr_73090_73110[(2)] = null);

(statearr_73090_73110[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73074 === (5))){
var state_73073__$1 = state_73073;
var statearr_73091_73111 = state_73073__$1;
(statearr_73091_73111[(2)] = null);

(statearr_73091_73111[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73074 === (14))){
var inst_73069 = (state_73073[(2)]);
var state_73073__$1 = state_73073;
var statearr_73092_73112 = state_73073__$1;
(statearr_73092_73112[(2)] = inst_73069);

(statearr_73092_73112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73074 === (10))){
var inst_73019 = (state_73073[(7)]);
var inst_73037 = (state_73073[(15)]);
var inst_73020 = (state_73073[(9)]);
var inst_73018 = (state_73073[(11)]);
var inst_73053 = (state_73073[(2)]);
var inst_73054 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_73055 = [inst_73037,inst_73053];
var inst_73056 = cljs.core.PersistentHashMap.fromArrays(inst_73054,inst_73055);
var inst_73057 = cljs.core.assoc.call(null,inst_73018,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_73056);
var inst_73058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73059 = [inst_73057];
var inst_73060 = (new cljs.core.PersistentVector(null,1,(5),inst_73058,inst_73059,null));
var inst_73061 = cljs.core.concat.call(null,inst_73020,inst_73060);
var inst_73062 = cljs.core.first.call(null,inst_73019);
var state_73073__$1 = (function (){var statearr_73093 = state_73073;
(statearr_73093[(14)] = inst_73061);

return statearr_73093;
})();
if(cljs.core.truth_(inst_73062)){
var statearr_73094_73113 = state_73073__$1;
(statearr_73094_73113[(1)] = (12));

} else {
var statearr_73095_73114 = state_73073__$1;
(statearr_73095_73114[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73074 === (8))){
var inst_73019 = (state_73073[(7)]);
var inst_73016 = (state_73073[(8)]);
var inst_73022 = (state_73073[(12)]);
var inst_73024 = (state_73073[(13)]);
var inst_73037 = (state_73073[(15)]);
var inst_73020 = (state_73073[(9)]);
var inst_73017 = (state_73073[(10)]);
var inst_73018 = (state_73073[(11)]);
var inst_73039 = (state_73073[(16)]);
var inst_73043 = (function (){var flakes = inst_73022;
var rest_blocks = inst_73019;
var curr_block = inst_73018;
var asserted_SINGLEQUOTE_ = inst_73037;
var acc = inst_73020;
var fuel = inst_73016;
var cache = inst_73017;
var retracted = inst_73039;
var asserted = inst_73024;
return (function (p1__73009_SHARP_){
return p1__73009_SHARP_.s;
});
})();
var inst_73044 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_73039);
var inst_73045 = cljs.core.group_by.call(null,inst_73043,inst_73044);
var inst_73046 = cljs.core.vals.call(null,inst_73045);
var inst_73047 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_73017,inst_73016,inst_73046);
var state_73073__$1 = state_73073;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73073__$1,(11),inst_73047);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_73096 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73096[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__);

(statearr_73096[(1)] = (1));

return statearr_73096;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1 = (function (state_73073){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73073);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73097){var ex__2749__auto__ = e73097;
var statearr_73098_73115 = state_73073;
(statearr_73098_73115[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73073[(4)]))){
var statearr_73099_73116 = state_73073;
(statearr_73099_73116[(1)] = cljs.core.first.call(null,(state_73073[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73117 = state_73073;
state_73073 = G__73117;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__ = function(state_73073){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1.call(this,state_73073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73100 = f__2769__auto__.call(null);
(statearr_73100[(6)] = c__2768__auto__);

return statearr_73100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73217){
var state_val_73218 = (state_73217[(1)]);
if((state_val_73218 === (7))){
var inst_73189 = (state_73217[(7)]);
var inst_73182 = (state_73217[(8)]);
var inst_73188 = cljs.core.seq.call(null,inst_73182);
var inst_73189__$1 = cljs.core.first.call(null,inst_73188);
var inst_73190 = cljs.core.next.call(null,inst_73188);
var state_73217__$1 = (function (){var statearr_73219 = state_73217;
(statearr_73219[(7)] = inst_73189__$1);

(statearr_73219[(9)] = inst_73190);

return statearr_73219;
})();
if(cljs.core.truth_(inst_73189__$1)){
var statearr_73220_73257 = state_73217__$1;
(statearr_73220_73257[(1)] = (9));

} else {
var statearr_73221_73258 = state_73217__$1;
(statearr_73221_73258[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73218 === (1))){
var state_73217__$1 = state_73217;
var statearr_73222_73259 = state_73217__$1;
(statearr_73222_73259[(2)] = null);

(statearr_73222_73259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73218 === (4))){
var inst_73119 = (state_73217[(2)]);
var state_73217__$1 = state_73217;
var statearr_73223_73260 = state_73217__$1;
(statearr_73223_73260[(2)] = inst_73119);

(statearr_73223_73260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73218 === (6))){
var inst_73168 = (state_73217[(2)]);
var inst_73169 = fluree.db.util.async.throw_err.call(null,inst_73168);
var inst_73177 = resp;
var inst_73178 = cljs.core.seq.call(null,inst_73177);
var inst_73179 = cljs.core.first.call(null,inst_73178);
var inst_73180 = cljs.core.next.call(null,inst_73178);
var inst_73181 = cljs.core.PersistentHashMap.EMPTY;
var inst_73182 = inst_73177;
var inst_73183 = inst_73181;
var state_73217__$1 = (function (){var statearr_73224 = state_73217;
(statearr_73224[(10)] = inst_73169);

(statearr_73224[(11)] = inst_73179);

(statearr_73224[(12)] = inst_73180);

(statearr_73224[(13)] = inst_73183);

(statearr_73224[(8)] = inst_73182);

return statearr_73224;
})();
var statearr_73225_73261 = state_73217__$1;
(statearr_73225_73261[(2)] = null);

(statearr_73225_73261[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73218 === (3))){
var inst_73215 = (state_73217[(2)]);
var state_73217__$1 = state_73217;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73217__$1,inst_73215);
} else {
if((state_val_73218 === (2))){
var _ = (function (){var statearr_73226 = state_73217;
(statearr_73226[(4)] = cljs.core.cons.call(null,(5),(state_73217[(4)])));

return statearr_73226;
})();
var inst_73125 = (function (){return (function (p1__73118_SHARP_){
return p1__73118_SHARP_.t;
});
})();
var inst_73126 = cljs.core.map.call(null,inst_73125,resp);
var inst_73127 = cljs.core.set.call(null,inst_73126);
var inst_73164 = cljs.core.async.chan.call(null,(1));
var inst_73165 = (function (){var ts = inst_73127;
var c__2768__auto____$1 = inst_73164;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73162){
var state_val_73163 = (state_73162[(1)]);
if((state_val_73163 === (1))){
var inst_73135 = ts;
var inst_73136 = cljs.core.seq.call(null,inst_73135);
var inst_73137 = cljs.core.first.call(null,inst_73136);
var inst_73138 = cljs.core.next.call(null,inst_73136);
var inst_73139 = cljs.core.PersistentHashMap.EMPTY;
var inst_73140 = inst_73135;
var inst_73141 = inst_73139;
var state_73162__$1 = (function (){var statearr_73227 = state_73162;
(statearr_73227[(7)] = inst_73140);

(statearr_73227[(8)] = inst_73138);

(statearr_73227[(9)] = inst_73141);

(statearr_73227[(10)] = inst_73137);

return statearr_73227;
})();
var statearr_73228_73262 = state_73162__$1;
(statearr_73228_73262[(2)] = null);

(statearr_73228_73262[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73163 === (2))){
var inst_73140 = (state_73162[(7)]);
var inst_73147 = (state_73162[(11)]);
var inst_73146 = cljs.core.seq.call(null,inst_73140);
var inst_73147__$1 = cljs.core.first.call(null,inst_73146);
var inst_73148 = cljs.core.next.call(null,inst_73146);
var state_73162__$1 = (function (){var statearr_73229 = state_73162;
(statearr_73229[(12)] = inst_73148);

(statearr_73229[(11)] = inst_73147__$1);

return statearr_73229;
})();
if(cljs.core.truth_(inst_73147__$1)){
var statearr_73230_73263 = state_73162__$1;
(statearr_73230_73263[(1)] = (4));

} else {
var statearr_73231_73264 = state_73162__$1;
(statearr_73231_73264[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73163 === (3))){
var inst_73160 = (state_73162[(2)]);
var state_73162__$1 = state_73162;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73162__$1,inst_73160);
} else {
if((state_val_73163 === (4))){
var inst_73147 = (state_73162[(11)]);
var inst_73150 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_73147);
var state_73162__$1 = state_73162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73162__$1,(7),inst_73150);
} else {
if((state_val_73163 === (5))){
var inst_73141 = (state_73162[(9)]);
var state_73162__$1 = state_73162;
var statearr_73232_73265 = state_73162__$1;
(statearr_73232_73265[(2)] = inst_73141);

(statearr_73232_73265[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73163 === (6))){
var inst_73158 = (state_73162[(2)]);
var state_73162__$1 = state_73162;
var statearr_73233_73266 = state_73162__$1;
(statearr_73233_73266[(2)] = inst_73158);

(statearr_73233_73266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73163 === (7))){
var inst_73148 = (state_73162[(12)]);
var inst_73141 = (state_73162[(9)]);
var inst_73147 = (state_73162[(11)]);
var inst_73152 = (state_73162[(2)]);
var inst_73153 = fluree.db.util.async.throw_err.call(null,inst_73152);
var inst_73154 = cljs.core.assoc.call(null,inst_73141,inst_73147,inst_73153);
var inst_73140 = inst_73148;
var inst_73141__$1 = inst_73154;
var state_73162__$1 = (function (){var statearr_73234 = state_73162;
(statearr_73234[(7)] = inst_73140);

(statearr_73234[(9)] = inst_73141__$1);

return statearr_73234;
})();
var statearr_73235_73267 = state_73162__$1;
(statearr_73235_73267[(2)] = null);

(statearr_73235_73267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_73236 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73236[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__);

(statearr_73236[(1)] = (1));

return statearr_73236;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1 = (function (state_73162){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73162);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73237){var ex__2749__auto__ = e73237;
var statearr_73238_73268 = state_73162;
(statearr_73238_73268[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73162[(4)]))){
var statearr_73239_73269 = state_73162;
(statearr_73239_73269[(1)] = cljs.core.first.call(null,(state_73162[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73270 = state_73162;
state_73162 = G__73270;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = function(state_73162){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1.call(this,state_73162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73240 = f__2769__auto__.call(null);
(statearr_73240[(6)] = c__2768__auto____$1);

return statearr_73240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_73166 = cljs.core.async.impl.dispatch.run.call(null,inst_73165);
var state_73217__$1 = (function (){var statearr_73241 = state_73217;
(statearr_73241[(14)] = inst_73166);

return statearr_73241;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73217__$1,(6),inst_73164);
} else {
if((state_val_73218 === (11))){
var inst_73209 = (state_73217[(2)]);
var state_73217__$1 = state_73217;
var statearr_73243_73271 = state_73217__$1;
(statearr_73243_73271[(2)] = inst_73209);

(statearr_73243_73271[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73218 === (9))){
var inst_73189 = (state_73217[(7)]);
var inst_73169 = (state_73217[(10)]);
var inst_73190 = (state_73217[(9)]);
var inst_73183 = (state_73217[(13)]);
var inst_73192 = inst_73189.t;
var inst_73193 = cljs.core.get.call(null,inst_73169,inst_73192);
var inst_73194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73195 = [inst_73193,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_73196 = (new cljs.core.PersistentVector(null,2,(5),inst_73194,inst_73195,null));
var inst_73197 = cljs.core.assoc_in.call(null,inst_73183,inst_73196,inst_73193);
var inst_73198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73199 = [inst_73193,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_73200 = (new cljs.core.PersistentVector(null,2,(5),inst_73198,inst_73199,null));
var inst_73201 = cljs.core.update_in.call(null,inst_73197,inst_73200,cljs.core.conj,inst_73189);
var inst_73202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73203 = [inst_73193,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_73204 = (new cljs.core.PersistentVector(null,2,(5),inst_73202,inst_73203,null));
var inst_73205 = cljs.core.update_in.call(null,inst_73201,inst_73204,fluree.db.api_js.min_safe,inst_73192);
var inst_73182 = inst_73190;
var inst_73183__$1 = inst_73205;
var state_73217__$1 = (function (){var statearr_73244 = state_73217;
(statearr_73244[(13)] = inst_73183__$1);

(statearr_73244[(8)] = inst_73182);

return statearr_73244;
})();
var statearr_73245_73272 = state_73217__$1;
(statearr_73245_73272[(2)] = null);

(statearr_73245_73272[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73218 === (5))){
var _ = (function (){var statearr_73246 = state_73217;
(statearr_73246[(4)] = cljs.core.rest.call(null,(state_73217[(4)])));

return statearr_73246;
})();
var state_73217__$1 = state_73217;
var ex73242 = (state_73217__$1[(2)]);
var statearr_73247_73273 = state_73217__$1;
(statearr_73247_73273[(5)] = ex73242);


if((ex73242 instanceof Error)){
var statearr_73248_73274 = state_73217__$1;
(statearr_73248_73274[(1)] = (4));

(statearr_73248_73274[(5)] = null);

} else {
throw ex73242;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73218 === (10))){
var inst_73183 = (state_73217[(13)]);
var state_73217__$1 = state_73217;
var statearr_73249_73275 = state_73217__$1;
(statearr_73249_73275[(2)] = inst_73183);

(statearr_73249_73275[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73218 === (8))){
var inst_73211 = (state_73217[(2)]);
var inst_73212 = cljs.core.vals.call(null,inst_73211);
var _ = (function (){var statearr_73250 = state_73217;
(statearr_73250[(4)] = cljs.core.rest.call(null,(state_73217[(4)])));

return statearr_73250;
})();
var state_73217__$1 = state_73217;
var statearr_73251_73276 = state_73217__$1;
(statearr_73251_73276[(2)] = inst_73212);

(statearr_73251_73276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_73252 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73252[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__);

(statearr_73252[(1)] = (1));

return statearr_73252;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1 = (function (state_73217){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73217);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73253){var ex__2749__auto__ = e73253;
var statearr_73254_73277 = state_73217;
(statearr_73254_73277[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73217[(4)]))){
var statearr_73255_73278 = state_73217;
(statearr_73255_73278[(1)] = cljs.core.first.call(null,(state_73217[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73279 = state_73217;
state_73217 = G__73279;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = function(state_73217){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1.call(this,state_73217);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73256 = f__2769__auto__.call(null);
(statearr_73256[(6)] = c__2768__auto__);

return statearr_73256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73427){
var state_val_73428 = (state_73427[(1)]);
if((state_val_73428 === (7))){
var inst_73307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73308 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73309 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73310 = [inst_73308,inst_73309];
var inst_73311 = (new cljs.core.PersistentVector(null,2,(5),inst_73307,inst_73310,null));
var state_73427__$1 = state_73427;
var statearr_73429_73500 = state_73427__$1;
(statearr_73429_73500[(2)] = inst_73311);

(statearr_73429_73500[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (20))){
var inst_73337 = (state_73427[(7)]);
var state_73427__$1 = state_73427;
var statearr_73430_73501 = state_73427__$1;
(statearr_73430_73501[(2)] = inst_73337);

(statearr_73430_73501[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (27))){
var state_73427__$1 = state_73427;
var statearr_73431_73502 = state_73427__$1;
(statearr_73431_73502[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (1))){
var state_73427__$1 = state_73427;
var statearr_73433_73503 = state_73427__$1;
(statearr_73433_73503[(2)] = null);

(statearr_73433_73503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (24))){
var inst_73336 = (state_73427[(8)]);
var state_73427__$1 = state_73427;
if(cljs.core.truth_(inst_73336)){
var statearr_73434_73504 = state_73427__$1;
(statearr_73434_73504[(1)] = (26));

} else {
var statearr_73435_73505 = state_73427__$1;
(statearr_73435_73505[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (39))){
var inst_73383 = (state_73427[(9)]);
var inst_73382 = (state_73427[(10)]);
var inst_73408 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73409 = [inst_73382,inst_73383];
var inst_73410 = (new cljs.core.PersistentVector(null,2,(5),inst_73408,inst_73409,null));
var state_73427__$1 = state_73427;
var statearr_73436_73506 = state_73427__$1;
(statearr_73436_73506[(2)] = inst_73410);

(statearr_73436_73506[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (4))){
var inst_73280 = (state_73427[(2)]);
var inst_73281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73282 = [inst_73280];
var inst_73283 = (new cljs.core.PersistentVector(null,1,(5),inst_73281,inst_73282,null));
var inst_73284 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73283);
var inst_73285 = cljs.core.ex_data.call(null,inst_73280);
var inst_73286 = cljs.core.ex_message.call(null,inst_73280);
var inst_73287 = cljs.core.assoc.call(null,inst_73285,new cljs.core.Keyword(null,"message","message",-406056002),inst_73286);
var state_73427__$1 = (function (){var statearr_73437 = state_73427;
(statearr_73437[(11)] = inst_73284);

return statearr_73437;
})();
var statearr_73438_73507 = state_73427__$1;
(statearr_73438_73507[(2)] = inst_73287);

(statearr_73438_73507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (15))){
var inst_73316 = (state_73427[(12)]);
var inst_73321 = (state_73427[(13)]);
var inst_73330 = (state_73427[(2)]);
var inst_73331 = [inst_73321,inst_73330];
var inst_73332 = (new cljs.core.PersistentVector(null,2,(5),inst_73316,inst_73331,null));
var state_73427__$1 = state_73427;
var statearr_73439_73508 = state_73427__$1;
(statearr_73439_73508[(2)] = inst_73332);

(statearr_73439_73508[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (21))){
var inst_73336 = (state_73427[(8)]);
var state_73427__$1 = state_73427;
var statearr_73440_73509 = state_73427__$1;
(statearr_73440_73509[(2)] = inst_73336);

(statearr_73440_73509[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (31))){
var inst_73377 = (state_73427[(2)]);
var state_73427__$1 = state_73427;
var statearr_73441_73510 = state_73427__$1;
(statearr_73441_73510[(2)] = inst_73377);

(statearr_73441_73510[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (32))){
var inst_73383 = (state_73427[(9)]);
var inst_73386 = cljs.core.pos_int_QMARK_.call(null,inst_73383);
var state_73427__$1 = state_73427;
var statearr_73442_73511 = state_73427__$1;
(statearr_73442_73511[(2)] = inst_73386);

(statearr_73442_73511[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (40))){
var inst_73338 = (state_73427[(14)]);
var inst_73414 = (state_73427[(15)]);
var inst_73412 = (state_73427[(2)]);
var inst_73413 = cljs.core.nth.call(null,inst_73412,(0),null);
var inst_73414__$1 = cljs.core.nth.call(null,inst_73412,(1),null);
var inst_73415 = (inst_73414__$1 > inst_73338);
var state_73427__$1 = (function (){var statearr_73443 = state_73427;
(statearr_73443[(15)] = inst_73414__$1);

(statearr_73443[(16)] = inst_73413);

return statearr_73443;
})();
if(cljs.core.truth_(inst_73415)){
var statearr_73444_73512 = state_73427__$1;
(statearr_73444_73512[(1)] = (41));

} else {
var statearr_73445_73513 = state_73427__$1;
(statearr_73445_73513[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (33))){
var inst_73384 = (state_73427[(17)]);
var state_73427__$1 = state_73427;
var statearr_73446_73514 = state_73427__$1;
(statearr_73446_73514[(2)] = inst_73384);

(statearr_73446_73514[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (13))){
var inst_73322 = (state_73427[(18)]);
var inst_73324 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_73322);
var state_73427__$1 = state_73427;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73427__$1,(16),inst_73324);
} else {
if((state_val_73428 === (22))){
var inst_73355 = (state_73427[(2)]);
var state_73427__$1 = state_73427;
if(cljs.core.truth_(inst_73355)){
var statearr_73447_73515 = state_73427__$1;
(statearr_73447_73515[(1)] = (23));

} else {
var statearr_73448_73516 = state_73427__$1;
(statearr_73448_73516[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (36))){
var state_73427__$1 = state_73427;
var statearr_73449_73517 = state_73427__$1;
(statearr_73449_73517[(2)] = null);

(statearr_73449_73517[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (41))){
var inst_73338 = (state_73427[(14)]);
var state_73427__$1 = state_73427;
var statearr_73450_73518 = state_73427__$1;
(statearr_73450_73518[(2)] = inst_73338);

(statearr_73450_73518[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (43))){
var inst_73413 = (state_73427[(16)]);
var inst_73419 = (state_73427[(2)]);
var inst_73420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73421 = [inst_73413,inst_73419];
var inst_73422 = (new cljs.core.PersistentVector(null,2,(5),inst_73420,inst_73421,null));
var _ = (function (){var statearr_73451 = state_73427;
(statearr_73451[(4)] = cljs.core.rest.call(null,(state_73427[(4)])));

return statearr_73451;
})();
var state_73427__$1 = state_73427;
var statearr_73452_73519 = state_73427__$1;
(statearr_73452_73519[(2)] = inst_73422);

(statearr_73452_73519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (29))){
var inst_73313 = (state_73427[(19)]);
var inst_73368 = cljs.core.pr_str.call(null,inst_73313);
var inst_73369 = ["Invalid block range provided: ",inst_73368].join('');
var inst_73370 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73371 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73372 = cljs.core.PersistentHashMap.fromArrays(inst_73370,inst_73371);
var inst_73373 = cljs.core.ex_info.call(null,inst_73369,inst_73372);
var inst_73374 = (function(){throw inst_73373})();
var state_73427__$1 = state_73427;
var statearr_73453_73520 = state_73427__$1;
(statearr_73453_73520[(2)] = inst_73374);

(statearr_73453_73520[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (6))){
var inst_73305 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_73427__$1 = state_73427;
var statearr_73454_73521 = state_73427__$1;
(statearr_73454_73521[(2)] = inst_73305);

(statearr_73454_73521[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (28))){
var inst_73379 = (state_73427[(2)]);
var state_73427__$1 = state_73427;
var statearr_73455_73522 = state_73427__$1;
(statearr_73455_73522[(2)] = inst_73379);

(statearr_73455_73522[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (25))){
var inst_73382 = (state_73427[(10)]);
var inst_73384 = (state_73427[(17)]);
var inst_73381 = (state_73427[(2)]);
var inst_73382__$1 = cljs.core.nth.call(null,inst_73381,(0),null);
var inst_73383 = cljs.core.nth.call(null,inst_73381,(1),null);
var inst_73384__$1 = cljs.core.pos_int_QMARK_.call(null,inst_73382__$1);
var state_73427__$1 = (function (){var statearr_73456 = state_73427;
(statearr_73456[(9)] = inst_73383);

(statearr_73456[(10)] = inst_73382__$1);

(statearr_73456[(17)] = inst_73384__$1);

return statearr_73456;
})();
if(inst_73384__$1){
var statearr_73457_73523 = state_73427__$1;
(statearr_73457_73523[(1)] = (32));

} else {
var statearr_73458_73524 = state_73427__$1;
(statearr_73458_73524[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (34))){
var inst_73389 = (state_73427[(2)]);
var inst_73390 = cljs.core.not.call(null,inst_73389);
var state_73427__$1 = state_73427;
if(inst_73390){
var statearr_73459_73525 = state_73427__$1;
(statearr_73459_73525[(1)] = (35));

} else {
var statearr_73460_73526 = state_73427__$1;
(statearr_73460_73526[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (17))){
var inst_73338 = (state_73427[(14)]);
var inst_73336 = (state_73427[(8)]);
var inst_73341 = cljs.core.pr_str.call(null,inst_73336);
var inst_73342 = cljs.core.pr_str.call(null,inst_73338);
var inst_73343 = ["Start block is out of range for this ledger. Start block provided: ",inst_73341,". Database block: ",inst_73342].join('');
var inst_73344 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73345 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73346 = cljs.core.PersistentHashMap.fromArrays(inst_73344,inst_73345);
var inst_73347 = cljs.core.ex_info.call(null,inst_73343,inst_73346);
var inst_73348 = (function(){throw inst_73347})();
var state_73427__$1 = state_73427;
var statearr_73461_73527 = state_73427__$1;
(statearr_73461_73527[(2)] = inst_73348);

(statearr_73461_73527[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (3))){
var inst_73425 = (state_73427[(2)]);
var state_73427__$1 = state_73427;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73427__$1,inst_73425);
} else {
if((state_val_73428 === (12))){
var inst_73322 = (state_73427[(18)]);
var inst_73313 = (state_73427[(19)]);
var inst_73320 = (state_73427[(2)]);
var inst_73321 = fluree.db.util.async.throw_err.call(null,inst_73320);
var inst_73322__$1 = cljs.core.second.call(null,inst_73313);
var state_73427__$1 = (function (){var statearr_73462 = state_73427;
(statearr_73462[(18)] = inst_73322__$1);

(statearr_73462[(13)] = inst_73321);

return statearr_73462;
})();
if(cljs.core.truth_(inst_73322__$1)){
var statearr_73463_73528 = state_73427__$1;
(statearr_73463_73528[(1)] = (13));

} else {
var statearr_73464_73529 = state_73427__$1;
(statearr_73464_73529[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (2))){
var _ = (function (){var statearr_73465 = state_73427;
(statearr_73465[(4)] = cljs.core.cons.call(null,(5),(state_73427[(4)])));

return statearr_73465;
})();
var inst_73302 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_73303 = cljs.core.sequential_QMARK_.call(null,inst_73302);
var state_73427__$1 = state_73427;
if(inst_73303){
var statearr_73466_73530 = state_73427__$1;
(statearr_73466_73530[(1)] = (6));

} else {
var statearr_73467_73531 = state_73427__$1;
(statearr_73467_73531[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (23))){
var inst_73337 = (state_73427[(7)]);
var inst_73336 = (state_73427[(8)]);
var inst_73357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73358 = [inst_73336,inst_73337];
var inst_73359 = (new cljs.core.PersistentVector(null,2,(5),inst_73357,inst_73358,null));
var state_73427__$1 = state_73427;
var statearr_73468_73532 = state_73427__$1;
(statearr_73468_73532[(2)] = inst_73359);

(statearr_73468_73532[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (35))){
var inst_73313 = (state_73427[(19)]);
var inst_73392 = cljs.core.pr_str.call(null,inst_73313);
var inst_73393 = ["Invalid block range provided: ",inst_73392].join('');
var inst_73394 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73395 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73396 = cljs.core.PersistentHashMap.fromArrays(inst_73394,inst_73395);
var inst_73397 = cljs.core.ex_info.call(null,inst_73393,inst_73396);
var inst_73398 = (function(){throw inst_73397})();
var state_73427__$1 = state_73427;
var statearr_73469_73533 = state_73427__$1;
(statearr_73469_73533[(2)] = inst_73398);

(statearr_73469_73533[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (19))){
var inst_73336 = (state_73427[(8)]);
var inst_73351 = (state_73427[(2)]);
var state_73427__$1 = (function (){var statearr_73470 = state_73427;
(statearr_73470[(20)] = inst_73351);

return statearr_73470;
})();
if(cljs.core.truth_(inst_73336)){
var statearr_73471_73534 = state_73427__$1;
(statearr_73471_73534[(1)] = (20));

} else {
var statearr_73472_73535 = state_73427__$1;
(statearr_73472_73535[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (11))){
var inst_73338 = (state_73427[(14)]);
var inst_73336 = (state_73427[(8)]);
var inst_73335 = (state_73427[(2)]);
var inst_73336__$1 = cljs.core.nth.call(null,inst_73335,(0),null);
var inst_73337 = cljs.core.nth.call(null,inst_73335,(1),null);
var inst_73338__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_73339 = (inst_73336__$1 > inst_73338__$1);
var state_73427__$1 = (function (){var statearr_73474 = state_73427;
(statearr_73474[(7)] = inst_73337);

(statearr_73474[(14)] = inst_73338__$1);

(statearr_73474[(8)] = inst_73336__$1);

return statearr_73474;
})();
if(cljs.core.truth_(inst_73339)){
var statearr_73475_73536 = state_73427__$1;
(statearr_73475_73536[(1)] = (17));

} else {
var statearr_73476_73537 = state_73427__$1;
(statearr_73476_73537[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (9))){
var inst_73313 = (state_73427[(19)]);
var inst_73316 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73317 = cljs.core.first.call(null,inst_73313);
var inst_73318 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_73317);
var state_73427__$1 = (function (){var statearr_73477 = state_73427;
(statearr_73477[(12)] = inst_73316);

return statearr_73477;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73427__$1,(12),inst_73318);
} else {
if((state_val_73428 === (5))){
var _ = (function (){var statearr_73478 = state_73427;
(statearr_73478[(4)] = cljs.core.rest.call(null,(state_73427[(4)])));

return statearr_73478;
})();
var state_73427__$1 = state_73427;
var ex73473 = (state_73427__$1[(2)]);
var statearr_73479_73538 = state_73427__$1;
(statearr_73479_73538[(5)] = ex73473);


var statearr_73480_73539 = state_73427__$1;
(statearr_73480_73539[(1)] = (4));

(statearr_73480_73539[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (14))){
var state_73427__$1 = state_73427;
var statearr_73481_73540 = state_73427__$1;
(statearr_73481_73540[(2)] = null);

(statearr_73481_73540[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (26))){
var inst_73336 = (state_73427[(8)]);
var inst_73362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73363 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_73364 = [inst_73336,inst_73363];
var inst_73365 = (new cljs.core.PersistentVector(null,2,(5),inst_73362,inst_73364,null));
var state_73427__$1 = state_73427;
var statearr_73482_73541 = state_73427__$1;
(statearr_73482_73541[(2)] = inst_73365);

(statearr_73482_73541[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (16))){
var inst_73326 = (state_73427[(2)]);
var inst_73327 = fluree.db.util.async.throw_err.call(null,inst_73326);
var state_73427__$1 = state_73427;
var statearr_73483_73542 = state_73427__$1;
(statearr_73483_73542[(2)] = inst_73327);

(statearr_73483_73542[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (38))){
var inst_73383 = (state_73427[(9)]);
var inst_73382 = (state_73427[(10)]);
var inst_73404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73405 = [inst_73383,inst_73382];
var inst_73406 = (new cljs.core.PersistentVector(null,2,(5),inst_73404,inst_73405,null));
var state_73427__$1 = state_73427;
var statearr_73484_73543 = state_73427__$1;
(statearr_73484_73543[(2)] = inst_73406);

(statearr_73484_73543[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (30))){
var state_73427__$1 = state_73427;
var statearr_73485_73544 = state_73427__$1;
(statearr_73485_73544[(2)] = null);

(statearr_73485_73544[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (10))){
var inst_73313 = (state_73427[(19)]);
var state_73427__$1 = state_73427;
var statearr_73486_73545 = state_73427__$1;
(statearr_73486_73545[(2)] = inst_73313);

(statearr_73486_73545[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (18))){
var state_73427__$1 = state_73427;
var statearr_73487_73546 = state_73427__$1;
(statearr_73487_73546[(2)] = null);

(statearr_73487_73546[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (42))){
var inst_73414 = (state_73427[(15)]);
var state_73427__$1 = state_73427;
var statearr_73488_73547 = state_73427__$1;
(statearr_73488_73547[(2)] = inst_73414);

(statearr_73488_73547[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (37))){
var inst_73383 = (state_73427[(9)]);
var inst_73382 = (state_73427[(10)]);
var inst_73401 = (state_73427[(2)]);
var inst_73402 = (inst_73383 < inst_73382);
var state_73427__$1 = (function (){var statearr_73489 = state_73427;
(statearr_73489[(21)] = inst_73401);

return statearr_73489;
})();
if(cljs.core.truth_(inst_73402)){
var statearr_73490_73548 = state_73427__$1;
(statearr_73490_73548[(1)] = (38));

} else {
var statearr_73491_73549 = state_73427__$1;
(statearr_73491_73549[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73428 === (8))){
var inst_73313 = (state_73427[(19)]);
var inst_73313__$1 = (state_73427[(2)]);
var inst_73314 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_73313__$1);
var state_73427__$1 = (function (){var statearr_73492 = state_73427;
(statearr_73492[(19)] = inst_73313__$1);

return statearr_73492;
})();
if(cljs.core.truth_(inst_73314)){
var statearr_73493_73550 = state_73427__$1;
(statearr_73493_73550[(1)] = (9));

} else {
var statearr_73494_73551 = state_73427__$1;
(statearr_73494_73551[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0 = (function (){
var statearr_73495 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73495[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__);

(statearr_73495[(1)] = (1));

return statearr_73495;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1 = (function (state_73427){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73427);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73496){var ex__2749__auto__ = e73496;
var statearr_73497_73552 = state_73427;
(statearr_73497_73552[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73427[(4)]))){
var statearr_73498_73553 = state_73427;
(statearr_73498_73553[(1)] = cljs.core.first.call(null,(state_73427[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73554 = state_73427;
state_73427 = G__73554;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__ = function(state_73427){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1.call(this,state_73427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73499 = f__2769__auto__.call(null);
(statearr_73499[(6)] = c__2768__auto__);

return statearr_73499;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__73556 = arguments.length;
switch (G__73556) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73650){
var state_val_73651 = (state_73650[(1)]);
if((state_val_73651 === (7))){
var inst_73582 = (state_73650[(7)]);
var inst_73585 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_73582);
var state_73650__$1 = state_73650;
var statearr_73652_73703 = state_73650__$1;
(statearr_73652_73703[(2)] = inst_73585);

(statearr_73652_73703[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (20))){
var inst_73621 = (state_73650[(8)]);
var inst_73624 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_73621);
var state_73650__$1 = state_73650;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73650__$1,(23),inst_73624);
} else {
if((state_val_73651 === (27))){
var inst_73630 = (state_73650[(9)]);
var inst_73636 = cljs.core.doall.call(null,inst_73630);
var state_73650__$1 = state_73650;
var statearr_73653_73704 = state_73650__$1;
(statearr_73653_73704[(2)] = inst_73636);

(statearr_73653_73704[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (1))){
var state_73650__$1 = state_73650;
var statearr_73654_73705 = state_73650__$1;
(statearr_73654_73705[(2)] = null);

(statearr_73654_73705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (24))){
var inst_73630 = (state_73650[(9)]);
var inst_73633 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_73634 = cljs.core.sequential_QMARK_.call(null,inst_73630);
var state_73650__$1 = (function (){var statearr_73655 = state_73650;
(statearr_73655[(10)] = inst_73633);

return statearr_73655;
})();
if(inst_73634){
var statearr_73656_73706 = state_73650__$1;
(statearr_73656_73706[(1)] = (27));

} else {
var statearr_73657_73707 = state_73650__$1;
(statearr_73657_73707[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (4))){
var inst_73557 = (state_73650[(2)]);
var inst_73558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73559 = [inst_73557];
var inst_73560 = (new cljs.core.PersistentVector(null,1,(5),inst_73558,inst_73559,null));
var inst_73561 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_73560);
var inst_73562 = cljs.core.ex_data.call(null,inst_73557);
var inst_73563 = cljs.core.ex_message.call(null,inst_73557);
var inst_73564 = cljs.core.assoc.call(null,inst_73562,new cljs.core.Keyword(null,"message","message",-406056002),inst_73563);
var state_73650__$1 = (function (){var statearr_73658 = state_73650;
(statearr_73658[(11)] = inst_73561);

return statearr_73658;
})();
var statearr_73659_73708 = state_73650__$1;
(statearr_73659_73708[(2)] = inst_73564);

(statearr_73659_73708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (15))){
var inst_73582 = (state_73650[(7)]);
var inst_73595 = (state_73650[(2)]);
var inst_73596 = cljs.core.ex_info.call(null,inst_73595,inst_73582);
var inst_73597 = (function(){throw inst_73596})();
var state_73650__$1 = state_73650;
var statearr_73660_73709 = state_73650__$1;
(statearr_73660_73709[(2)] = inst_73597);

(statearr_73660_73709[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (21))){
var inst_73621 = (state_73650[(8)]);
var state_73650__$1 = state_73650;
var statearr_73661_73710 = state_73650__$1;
(statearr_73661_73710[(2)] = inst_73621);

(statearr_73661_73710[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (13))){
var inst_73590 = (state_73650[(12)]);
var state_73650__$1 = state_73650;
var statearr_73662_73711 = state_73650__$1;
(statearr_73662_73711[(2)] = inst_73590);

(statearr_73662_73711[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (22))){
var inst_73630 = (state_73650[(2)]);
var inst_73631 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_73650__$1 = (function (){var statearr_73663 = state_73650;
(statearr_73663[(9)] = inst_73630);

return statearr_73663;
})();
if(cljs.core.truth_(inst_73631)){
var statearr_73664_73712 = state_73650__$1;
(statearr_73664_73712[(1)] = (24));

} else {
var statearr_73665_73713 = state_73650__$1;
(statearr_73665_73713[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (29))){
var inst_73574 = (state_73650[(13)]);
var inst_73633 = (state_73650[(10)]);
var inst_73639 = (state_73650[(2)]);
var inst_73640 = fluree.db.util.core.response_time_formatted.call(null,inst_73574);
var inst_73641 = [(200),inst_73639,(100),inst_73640];
var inst_73642 = cljs.core.PersistentHashMap.fromArrays(inst_73633,inst_73641);
var state_73650__$1 = state_73650;
var statearr_73666_73714 = state_73650__$1;
(statearr_73666_73714[(2)] = inst_73642);

(statearr_73666_73714[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (6))){
var inst_73583 = (state_73650[(14)]);
var inst_73582 = (state_73650[(7)]);
var inst_73581 = (state_73650[(2)]);
var inst_73582__$1 = fluree.db.util.async.throw_err.call(null,inst_73581);
var inst_73583__$1 = cljs.core.map_QMARK_.call(null,inst_73582__$1);
var state_73650__$1 = (function (){var statearr_73667 = state_73650;
(statearr_73667[(14)] = inst_73583__$1);

(statearr_73667[(7)] = inst_73582__$1);

return statearr_73667;
})();
if(inst_73583__$1){
var statearr_73668_73715 = state_73650__$1;
(statearr_73668_73715[(1)] = (7));

} else {
var statearr_73669_73716 = state_73650__$1;
(statearr_73669_73716[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (28))){
var inst_73630 = (state_73650[(9)]);
var state_73650__$1 = state_73650;
var statearr_73670_73717 = state_73650__$1;
(statearr_73670_73717[(2)] = inst_73630);

(statearr_73670_73717[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (25))){
var inst_73630 = (state_73650[(9)]);
var state_73650__$1 = state_73650;
var statearr_73671_73718 = state_73650__$1;
(statearr_73671_73718[(2)] = inst_73630);

(statearr_73671_73718[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (17))){
var inst_73613 = cljs.core.pr_str.call(null,query_map);
var inst_73614 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_73613].join('');
var inst_73615 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73616 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73617 = cljs.core.PersistentHashMap.fromArrays(inst_73615,inst_73616);
var inst_73618 = cljs.core.ex_info.call(null,inst_73614,inst_73617);
var inst_73619 = (function(){throw inst_73618})();
var state_73650__$1 = state_73650;
var statearr_73672_73719 = state_73650__$1;
(statearr_73672_73719[(2)] = inst_73619);

(statearr_73672_73719[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (3))){
var inst_73648 = (state_73650[(2)]);
var state_73650__$1 = state_73650;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73650__$1,inst_73648);
} else {
if((state_val_73651 === (12))){
var inst_73582 = (state_73650[(7)]);
var inst_73600 = (state_73650[(2)]);
var inst_73601 = cljs.core.nth.call(null,inst_73582,(0),null);
var inst_73602 = cljs.core.nth.call(null,inst_73582,(1),null);
var inst_73603 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_73604 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_73605 = cljs.core.keys.call(null,inst_73604);
var inst_73606 = cljs.core._EQ_.call(null,inst_73603,inst_73605);
var state_73650__$1 = (function (){var statearr_73673 = state_73650;
(statearr_73673[(15)] = inst_73601);

(statearr_73673[(16)] = inst_73602);

(statearr_73673[(17)] = inst_73600);

return statearr_73673;
})();
if(inst_73606){
var statearr_73674_73720 = state_73650__$1;
(statearr_73674_73720[(1)] = (16));

} else {
var statearr_73675_73721 = state_73650__$1;
(statearr_73675_73721[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (2))){
var _ = (function (){var statearr_73676 = state_73650;
(statearr_73676[(4)] = cljs.core.cons.call(null,(5),(state_73650[(4)])));

return statearr_73676;
})();
var inst_73574 = fluree.db.util.core.current_time_millis.call(null);
var inst_73575 = db;
var inst_73576 = cljs.core.__destructure_map.call(null,inst_73575);
var inst_73577 = cljs.core.get.call(null,inst_73576,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_73578 = cljs.core.get.call(null,inst_73576,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_73579 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_73650__$1 = (function (){var statearr_73677 = state_73650;
(statearr_73677[(18)] = inst_73577);

(statearr_73677[(13)] = inst_73574);

(statearr_73677[(19)] = inst_73578);

return statearr_73677;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73650__$1,(6),inst_73579);
} else {
if((state_val_73651 === (23))){
var inst_73626 = (state_73650[(2)]);
var inst_73627 = fluree.db.util.async.throw_err.call(null,inst_73626);
var state_73650__$1 = state_73650;
var statearr_73678_73722 = state_73650__$1;
(statearr_73678_73722[(2)] = inst_73627);

(statearr_73678_73722[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (19))){
var inst_73610 = (state_73650[(2)]);
var inst_73611 = fluree.db.util.async.throw_err.call(null,inst_73610);
var state_73650__$1 = state_73650;
var statearr_73679_73723 = state_73650__$1;
(statearr_73679_73723[(2)] = inst_73611);

(statearr_73679_73723[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (11))){
var state_73650__$1 = state_73650;
var statearr_73681_73724 = state_73650__$1;
(statearr_73681_73724[(2)] = null);

(statearr_73681_73724[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (9))){
var inst_73588 = (state_73650[(2)]);
var state_73650__$1 = state_73650;
if(cljs.core.truth_(inst_73588)){
var statearr_73682_73725 = state_73650__$1;
(statearr_73682_73725[(1)] = (10));

} else {
var statearr_73683_73726 = state_73650__$1;
(statearr_73683_73726[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (5))){
var _ = (function (){var statearr_73684 = state_73650;
(statearr_73684[(4)] = cljs.core.rest.call(null,(state_73650[(4)])));

return statearr_73684;
})();
var state_73650__$1 = state_73650;
var ex73680 = (state_73650__$1[(2)]);
var statearr_73685_73727 = state_73650__$1;
(statearr_73685_73727[(5)] = ex73680);


var statearr_73686_73728 = state_73650__$1;
(statearr_73686_73728[(1)] = (4));

(statearr_73686_73728[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (14))){
var inst_73577 = (state_73650[(18)]);
var inst_73578 = (state_73650[(19)]);
var inst_73593 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73577),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73578)].join('');
var state_73650__$1 = state_73650;
var statearr_73687_73729 = state_73650__$1;
(statearr_73687_73729[(2)] = inst_73593);

(statearr_73687_73729[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (26))){
var inst_73645 = (state_73650[(2)]);
var _ = (function (){var statearr_73688 = state_73650;
(statearr_73688[(4)] = cljs.core.rest.call(null,(state_73650[(4)])));

return statearr_73688;
})();
var state_73650__$1 = state_73650;
var statearr_73689_73730 = state_73650__$1;
(statearr_73689_73730[(2)] = inst_73645);

(statearr_73689_73730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (16))){
var inst_73601 = (state_73650[(15)]);
var inst_73602 = (state_73650[(16)]);
var inst_73608 = fluree.db.query.block.block_range.call(null,db,inst_73601,inst_73602,opts);
var state_73650__$1 = state_73650;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73650__$1,(19),inst_73608);
} else {
if((state_val_73651 === (10))){
var inst_73590 = (state_73650[(12)]);
var inst_73582 = (state_73650[(7)]);
var inst_73590__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_73582);
var state_73650__$1 = (function (){var statearr_73690 = state_73650;
(statearr_73690[(12)] = inst_73590__$1);

return statearr_73690;
})();
if(cljs.core.truth_(inst_73590__$1)){
var statearr_73691_73731 = state_73650__$1;
(statearr_73691_73731[(1)] = (13));

} else {
var statearr_73692_73732 = state_73650__$1;
(statearr_73692_73732[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (18))){
var inst_73621 = (state_73650[(2)]);
var inst_73622 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_73650__$1 = (function (){var statearr_73693 = state_73650;
(statearr_73693[(8)] = inst_73621);

return statearr_73693;
})();
if(cljs.core.truth_(inst_73622)){
var statearr_73694_73733 = state_73650__$1;
(statearr_73694_73733[(1)] = (20));

} else {
var statearr_73695_73734 = state_73650__$1;
(statearr_73695_73734[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73651 === (8))){
var inst_73583 = (state_73650[(14)]);
var state_73650__$1 = state_73650;
var statearr_73696_73735 = state_73650__$1;
(statearr_73696_73735[(2)] = inst_73583);

(statearr_73696_73735[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_73697 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73697[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_73697[(1)] = (1));

return statearr_73697;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_73650){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73650);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e73698){var ex__2749__auto__ = e73698;
var statearr_73699_73736 = state_73650;
(statearr_73699_73736[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73650[(4)]))){
var statearr_73700_73737 = state_73650;
(statearr_73700_73737[(1)] = cljs.core.first.call(null,(state_73650[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73738 = state_73650;
state_73650 = G__73738;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_73650){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_73650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_73701 = f__2769__auto__.call(null);
(statearr_73701[(6)] = c__2768__auto__);

return statearr_73701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__73740 = arguments.length;
switch (G__73740) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_73935){
var state_val_73936 = (state_73935[(1)]);
if((state_val_73936 === (62))){
var inst_73933 = (state_73935[(2)]);
var state_73935__$1 = state_73935;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73935__$1,inst_73933);
} else {
if((state_val_73936 === (7))){
var inst_73761 = (state_73935[(7)]);
var inst_73771 = cljs.core.not_EQ_.call(null,(1),inst_73761);
var state_73935__$1 = state_73935;
var statearr_73937_74028 = state_73935__$1;
(statearr_73937_74028[(2)] = inst_73771);

(statearr_73937_74028[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (59))){
var inst_73921 = (state_73935[(2)]);
var inst_73922 = fluree.db.util.async.throw_err.call(null,inst_73921);
var state_73935__$1 = state_73935;
var statearr_73938_74029 = state_73935__$1;
(statearr_73938_74029[(2)] = inst_73922);

(statearr_73938_74029[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (20))){
var inst_73837 = (state_73935[(8)]);
var inst_73829 = (state_73935[(9)]);
var inst_73829__$1 = (state_73935[(2)]);
var inst_73830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73831 = cljs.core.get.call(null,inst_73829__$1,(0));
var inst_73832 = cljs.core.get.call(null,inst_73829__$1,(1));
var inst_73833 = cljs.core.get.call(null,inst_73829__$1,(2));
var inst_73834 = cljs.core.get.call(null,inst_73829__$1,(3));
var inst_73835 = [inst_73831,inst_73832,inst_73833,inst_73834];
var inst_73836 = (new cljs.core.PersistentVector(null,4,(5),inst_73830,inst_73835,null));
var inst_73837__$1 = cljs.core.nth.call(null,inst_73836,(0),null);
var inst_73838 = cljs.core.nth.call(null,inst_73836,(1),null);
var inst_73839 = cljs.core.nth.call(null,inst_73836,(2),null);
var inst_73840 = cljs.core.nth.call(null,inst_73836,(3),null);
var inst_73841 = (inst_73837__$1 == null);
var inst_73842 = cljs.core.not.call(null,inst_73841);
var state_73935__$1 = (function (){var statearr_73939 = state_73935;
(statearr_73939[(8)] = inst_73837__$1);

(statearr_73939[(9)] = inst_73829__$1);

(statearr_73939[(10)] = inst_73839);

(statearr_73939[(11)] = inst_73840);

(statearr_73939[(12)] = inst_73838);

return statearr_73939;
})();
if(inst_73842){
var statearr_73940_74030 = state_73935__$1;
(statearr_73940_74030[(1)] = (30));

} else {
var statearr_73941_74031 = state_73935__$1;
(statearr_73941_74031[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (58))){
var inst_73769 = (state_73935[(13)]);
var inst_73925 = (state_73935[(2)]);
var state_73935__$1 = (function (){var statearr_73942 = state_73935;
(statearr_73942[(14)] = inst_73925);

return statearr_73942;
})();
if(cljs.core.truth_(inst_73769)){
var statearr_73943_74032 = state_73935__$1;
(statearr_73943_74032[(1)] = (60));

} else {
var statearr_73944_74033 = state_73935__$1;
(statearr_73944_74033[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (60))){
var inst_73913 = (state_73935[(15)]);
var inst_73925 = (state_73935[(14)]);
var inst_73927 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_73928 = cljs.core.count.call(null,inst_73913);
var inst_73929 = [inst_73925,inst_73928,(200)];
var inst_73930 = cljs.core.PersistentHashMap.fromArrays(inst_73927,inst_73929);
var state_73935__$1 = state_73935;
var statearr_73945_74034 = state_73935__$1;
(statearr_73945_74034[(2)] = inst_73930);

(statearr_73945_74034[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (27))){
var inst_73748 = (state_73935[(16)]);
var inst_73817 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73748)].join('');
var inst_73818 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73819 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73820 = cljs.core.PersistentHashMap.fromArrays(inst_73818,inst_73819);
var inst_73821 = cljs.core.ex_info.call(null,inst_73817,inst_73820);
var inst_73822 = (function(){throw inst_73821})();
var state_73935__$1 = state_73935;
var statearr_73946_74035 = state_73935__$1;
(statearr_73946_74035[(2)] = inst_73822);

(statearr_73946_74035[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (1))){
var inst_73745 = query_map;
var inst_73746 = cljs.core.__destructure_map.call(null,inst_73745);
var inst_73747 = cljs.core.get.call(null,inst_73746,new cljs.core.Keyword(null,"block","block",664686210));
var inst_73748 = cljs.core.get.call(null,inst_73746,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_73749 = cljs.core.get.call(null,inst_73746,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_73935__$1 = (function (){var statearr_73947 = state_73935;
(statearr_73947[(17)] = inst_73749);

(statearr_73947[(16)] = inst_73748);

(statearr_73947[(18)] = inst_73747);

return statearr_73947;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73935__$1,(2),sources);
} else {
if((state_val_73936 === (24))){
var inst_73748 = (state_73935[(16)]);
var inst_73806 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73748)].join('');
var inst_73807 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73808 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73809 = cljs.core.PersistentHashMap.fromArrays(inst_73807,inst_73808);
var inst_73810 = cljs.core.ex_info.call(null,inst_73806,inst_73809);
var inst_73811 = (function(){throw inst_73810})();
var state_73935__$1 = state_73935;
var statearr_73948_74036 = state_73935__$1;
(statearr_73948_74036[(2)] = inst_73811);

(statearr_73948_74036[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (55))){
var inst_73749 = (state_73935[(17)]);
var inst_73916 = (state_73935[(2)]);
var inst_73917 = fluree.db.util.async.throw_err.call(null,inst_73916);
var state_73935__$1 = (function (){var statearr_73949 = state_73935;
(statearr_73949[(19)] = inst_73917);

return statearr_73949;
})();
if(cljs.core.truth_(inst_73749)){
var statearr_73950_74037 = state_73935__$1;
(statearr_73950_74037[(1)] = (56));

} else {
var statearr_73951_74038 = state_73935__$1;
(statearr_73951_74038[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (39))){
var inst_73837 = (state_73935[(8)]);
var inst_73839 = (state_73935[(10)]);
var inst_73840 = (state_73935[(11)]);
var inst_73838 = (state_73935[(12)]);
var inst_73861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73863 = [inst_73838,inst_73837,inst_73839,inst_73840];
var inst_73864 = (new cljs.core.PersistentVector(null,4,(5),inst_73862,inst_73863,null));
var inst_73865 = [inst_73864,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_73866 = (new cljs.core.PersistentVector(null,2,(5),inst_73861,inst_73865,null));
var state_73935__$1 = state_73935;
var statearr_73952_74039 = state_73935__$1;
(statearr_73952_74039[(2)] = inst_73866);

(statearr_73952_74039[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (46))){
var inst_73871 = (state_73935[(20)]);
var state_73935__$1 = state_73935;
var statearr_73953_74040 = state_73935__$1;
(statearr_73953_74040[(2)] = inst_73871);

(statearr_73953_74040[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (4))){
var state_73935__$1 = state_73935;
var statearr_73954_74041 = state_73935__$1;
(statearr_73954_74041[(2)] = null);

(statearr_73954_74041[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (54))){
var inst_73913 = (state_73935[(15)]);
var inst_73752 = (state_73935[(21)]);
var inst_73912 = (state_73935[(2)]);
var inst_73913__$1 = fluree.db.util.async.throw_err.call(null,inst_73912);
var inst_73914 = fluree.db.api_js.format_history_resp.call(null,inst_73752,inst_73913__$1);
var state_73935__$1 = (function (){var statearr_73955 = state_73935;
(statearr_73955[(15)] = inst_73913__$1);

return statearr_73955;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73935__$1,(55),inst_73914);
} else {
if((state_val_73936 === (15))){
var inst_73752 = (state_73935[(21)]);
var inst_73793 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_73752);
var state_73935__$1 = state_73935;
var statearr_73956_74042 = state_73935__$1;
(statearr_73956_74042[(2)] = inst_73793);

(statearr_73956_74042[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (48))){
var inst_73837 = (state_73935[(8)]);
var inst_73839 = (state_73935[(10)]);
var inst_73840 = (state_73935[(11)]);
var inst_73838 = (state_73935[(12)]);
var inst_73882 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73884 = [inst_73838,inst_73839,inst_73837,inst_73840];
var inst_73885 = (new cljs.core.PersistentVector(null,4,(5),inst_73883,inst_73884,null));
var inst_73886 = [inst_73885,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_73887 = (new cljs.core.PersistentVector(null,2,(5),inst_73882,inst_73886,null));
var state_73935__$1 = state_73935;
var statearr_73957_74043 = state_73935__$1;
(statearr_73957_74043[(2)] = inst_73887);

(statearr_73957_74043[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (50))){
var inst_73900 = (state_73935[(2)]);
var state_73935__$1 = state_73935;
var statearr_73958_74044 = state_73935__$1;
(statearr_73958_74044[(2)] = inst_73900);

(statearr_73958_74044[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (21))){
var inst_73748 = (state_73935[(16)]);
var inst_73804 = cljs.core.empty_QMARK_.call(null,inst_73748);
var state_73935__$1 = state_73935;
if(inst_73804){
var statearr_73959_74045 = state_73935__$1;
(statearr_73959_74045[(1)] = (24));

} else {
var statearr_73960_74046 = state_73935__$1;
(statearr_73960_74046[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (31))){
var inst_73837 = (state_73935[(8)]);
var inst_73848 = (state_73935[(22)]);
var inst_73848__$1 = (inst_73837 == null);
var state_73935__$1 = (function (){var statearr_73961 = state_73935;
(statearr_73961[(22)] = inst_73848__$1);

return statearr_73961;
})();
if(cljs.core.truth_(inst_73848__$1)){
var statearr_73962_74047 = state_73935__$1;
(statearr_73962_74047[(1)] = (33));

} else {
var statearr_73963_74048 = state_73935__$1;
(statearr_73963_74048[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (32))){
var inst_73795 = (state_73935[(23)]);
var inst_73752 = (state_73935[(21)]);
var inst_73785 = (state_73935[(24)]);
var inst_73904 = (state_73935[(2)]);
var inst_73905 = cljs.core.nth.call(null,inst_73904,(0),null);
var inst_73906 = cljs.core.nth.call(null,inst_73904,(1),null);
var inst_73907 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_73908 = [inst_73785,inst_73795];
var inst_73909 = cljs.core.PersistentHashMap.fromArrays(inst_73907,inst_73908);
var inst_73910 = fluree.db.query.range.time_range.call(null,inst_73752,inst_73906,cljs.core._EQ_,inst_73905,inst_73909);
var state_73935__$1 = state_73935;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73935__$1,(54),inst_73910);
} else {
if((state_val_73936 === (40))){
var inst_73837 = (state_73935[(8)]);
var inst_73868 = (state_73935[(25)]);
var inst_73868__$1 = (inst_73837 == null);
var state_73935__$1 = (function (){var statearr_73964 = state_73935;
(statearr_73964[(25)] = inst_73868__$1);

return statearr_73964;
})();
if(cljs.core.truth_(inst_73868__$1)){
var statearr_73965_74049 = state_73935__$1;
(statearr_73965_74049[(1)] = (42));

} else {
var statearr_73966_74050 = state_73935__$1;
(statearr_73966_74050[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (56))){
var inst_73752 = (state_73935[(21)]);
var inst_73917 = (state_73935[(19)]);
var inst_73919 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_73752,inst_73917);
var state_73935__$1 = state_73935;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73935__$1,(59),inst_73919);
} else {
if((state_val_73936 === (33))){
var inst_73851 = (state_73935[(26)]);
var inst_73838 = (state_73935[(12)]);
var inst_73850 = (inst_73838 == null);
var inst_73851__$1 = cljs.core.not.call(null,inst_73850);
var state_73935__$1 = (function (){var statearr_73967 = state_73935;
(statearr_73967[(26)] = inst_73851__$1);

return statearr_73967;
})();
if(inst_73851__$1){
var statearr_73968_74051 = state_73935__$1;
(statearr_73968_74051[(1)] = (36));

} else {
var statearr_73969_74052 = state_73935__$1;
(statearr_73969_74052[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (13))){
var inst_73779 = (state_73935[(2)]);
var inst_73780 = fluree.db.util.async.throw_err.call(null,inst_73779);
var inst_73781 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_73780);
var inst_73782 = (inst_73781 - (1));
var state_73935__$1 = state_73935;
var statearr_73970_74053 = state_73935__$1;
(statearr_73970_74053[(2)] = inst_73782);

(statearr_73970_74053[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (22))){
var state_73935__$1 = state_73935;
var statearr_73971_74054 = state_73935__$1;
(statearr_73971_74054[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (36))){
var inst_73839 = (state_73935[(10)]);
var inst_73853 = (inst_73839 == null);
var state_73935__$1 = state_73935;
var statearr_73973_74055 = state_73935__$1;
(statearr_73973_74055[(2)] = inst_73853);

(statearr_73973_74055[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (41))){
var inst_73902 = (state_73935[(2)]);
var state_73935__$1 = state_73935;
var statearr_73974_74056 = state_73935__$1;
(statearr_73974_74056[(2)] = inst_73902);

(statearr_73974_74056[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (43))){
var inst_73868 = (state_73935[(25)]);
var state_73935__$1 = state_73935;
var statearr_73975_74057 = state_73935__$1;
(statearr_73975_74057[(2)] = inst_73868);

(statearr_73975_74057[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (61))){
var inst_73925 = (state_73935[(14)]);
var state_73935__$1 = state_73935;
var statearr_73976_74058 = state_73935__$1;
(statearr_73976_74058[(2)] = inst_73925);

(statearr_73976_74058[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (29))){
var inst_73825 = (state_73935[(2)]);
var state_73935__$1 = state_73935;
var statearr_73977_74059 = state_73935__$1;
(statearr_73977_74059[(2)] = inst_73825);

(statearr_73977_74059[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (44))){
var inst_73880 = (state_73935[(2)]);
var state_73935__$1 = state_73935;
if(cljs.core.truth_(inst_73880)){
var statearr_73978_74060 = state_73935__$1;
(statearr_73978_74060[(1)] = (48));

} else {
var statearr_73979_74061 = state_73935__$1;
(statearr_73979_74061[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (6))){
var inst_73756 = (state_73935[(2)]);
var inst_73757 = fluree.db.util.async.throw_err.call(null,inst_73756);
var state_73935__$1 = state_73935;
var statearr_73980_74062 = state_73935__$1;
(statearr_73980_74062[(2)] = inst_73757);

(statearr_73980_74062[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (28))){
var state_73935__$1 = state_73935;
var statearr_73981_74063 = state_73935__$1;
(statearr_73981_74063[(2)] = null);

(statearr_73981_74063[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (51))){
var inst_73748 = (state_73935[(16)]);
var inst_73890 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73748)].join('');
var inst_73891 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73892 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_73893 = cljs.core.PersistentHashMap.fromArrays(inst_73891,inst_73892);
var inst_73894 = cljs.core.ex_info.call(null,inst_73890,inst_73893);
var inst_73895 = (function(){throw inst_73894})();
var state_73935__$1 = state_73935;
var statearr_73982_74064 = state_73935__$1;
(statearr_73982_74064[(2)] = inst_73895);

(statearr_73982_74064[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (25))){
var inst_73748 = (state_73935[(16)]);
var state_73935__$1 = state_73935;
var statearr_73983_74065 = state_73935__$1;
(statearr_73983_74065[(2)] = inst_73748);

(statearr_73983_74065[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (34))){
var inst_73848 = (state_73935[(22)]);
var state_73935__$1 = state_73935;
var statearr_73984_74066 = state_73935__$1;
(statearr_73984_74066[(2)] = inst_73848);

(statearr_73984_74066[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (17))){
var inst_73789 = (state_73935[(2)]);
var inst_73790 = fluree.db.util.async.throw_err.call(null,inst_73789);
var inst_73791 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_73790);
var state_73935__$1 = state_73935;
var statearr_73985_74067 = state_73935__$1;
(statearr_73985_74067[(2)] = inst_73791);

(statearr_73985_74067[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (3))){
var inst_73752 = (state_73935[(21)]);
var inst_73754 = fluree.db.api_js.resolve_block_range.call(null,inst_73752,query_map);
var state_73935__$1 = state_73935;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73935__$1,(6),inst_73754);
} else {
if((state_val_73936 === (12))){
var inst_73762 = (state_73935[(27)]);
var inst_73785 = (state_73935[(2)]);
var state_73935__$1 = (function (){var statearr_73986 = state_73935;
(statearr_73986[(24)] = inst_73785);

return statearr_73986;
})();
if(cljs.core.truth_(inst_73762)){
var statearr_73987_74068 = state_73935__$1;
(statearr_73987_74068[(1)] = (14));

} else {
var statearr_73988_74069 = state_73935__$1;
(statearr_73988_74069[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (2))){
var inst_73747 = (state_73935[(18)]);
var inst_73751 = (state_73935[(2)]);
var inst_73752 = fluree.db.util.async.throw_err.call(null,inst_73751);
var state_73935__$1 = (function (){var statearr_73989 = state_73935;
(statearr_73989[(21)] = inst_73752);

return statearr_73989;
})();
if(cljs.core.truth_(inst_73747)){
var statearr_73990_74070 = state_73935__$1;
(statearr_73990_74070[(1)] = (3));

} else {
var statearr_73991_74071 = state_73935__$1;
(statearr_73991_74071[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (23))){
var inst_73827 = (state_73935[(2)]);
var state_73935__$1 = state_73935;
var statearr_73992_74072 = state_73935__$1;
(statearr_73992_74072[(2)] = inst_73827);

(statearr_73992_74072[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (47))){
var inst_73877 = (state_73935[(2)]);
var state_73935__$1 = state_73935;
var statearr_73993_74073 = state_73935__$1;
(statearr_73993_74073[(2)] = inst_73877);

(statearr_73993_74073[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (35))){
var inst_73859 = (state_73935[(2)]);
var state_73935__$1 = state_73935;
if(cljs.core.truth_(inst_73859)){
var statearr_73994_74074 = state_73935__$1;
(statearr_73994_74074[(1)] = (39));

} else {
var statearr_73995_74075 = state_73935__$1;
(statearr_73995_74075[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (19))){
var inst_73748 = (state_73935[(16)]);
var inst_73802 = cljs.core.sequential_QMARK_.call(null,inst_73748);
var state_73935__$1 = state_73935;
if(inst_73802){
var statearr_73996_74076 = state_73935__$1;
(statearr_73996_74076[(1)] = (21));

} else {
var statearr_73997_74077 = state_73935__$1;
(statearr_73997_74077[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (57))){
var inst_73917 = (state_73935[(19)]);
var state_73935__$1 = state_73935;
var statearr_73998_74078 = state_73935__$1;
(statearr_73998_74078[(2)] = inst_73917);

(statearr_73998_74078[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (11))){
var state_73935__$1 = state_73935;
var statearr_73999_74079 = state_73935__$1;
(statearr_73999_74079[(2)] = (-1));

(statearr_73999_74079[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (9))){
var inst_73774 = (state_73935[(2)]);
var state_73935__$1 = state_73935;
if(cljs.core.truth_(inst_73774)){
var statearr_74000_74080 = state_73935__$1;
(statearr_74000_74080[(1)] = (10));

} else {
var statearr_74001_74081 = state_73935__$1;
(statearr_74001_74081[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (5))){
var inst_73761 = (state_73935[(7)]);
var inst_73760 = (state_73935[(2)]);
var inst_73761__$1 = cljs.core.nth.call(null,inst_73760,(0),null);
var inst_73762 = cljs.core.nth.call(null,inst_73760,(1),null);
var inst_73769 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_73935__$1 = (function (){var statearr_74002 = state_73935;
(statearr_74002[(7)] = inst_73761__$1);

(statearr_74002[(27)] = inst_73762);

(statearr_74002[(13)] = inst_73769);

return statearr_74002;
})();
if(cljs.core.truth_(inst_73761__$1)){
var statearr_74003_74082 = state_73935__$1;
(statearr_74003_74082[(1)] = (7));

} else {
var statearr_74004_74083 = state_73935__$1;
(statearr_74004_74083[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (14))){
var inst_73762 = (state_73935[(27)]);
var inst_73752 = (state_73935[(21)]);
var inst_73787 = fluree.db.time_travel.as_of_block.call(null,inst_73752,inst_73762);
var state_73935__$1 = state_73935;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73935__$1,(17),inst_73787);
} else {
if((state_val_73936 === (45))){
var inst_73839 = (state_73935[(10)]);
var inst_73873 = (inst_73839 == null);
var inst_73874 = cljs.core.not.call(null,inst_73873);
var state_73935__$1 = state_73935;
var statearr_74005_74084 = state_73935__$1;
(statearr_74005_74084[(2)] = inst_73874);

(statearr_74005_74084[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (53))){
var inst_73898 = (state_73935[(2)]);
var state_73935__$1 = state_73935;
var statearr_74006_74085 = state_73935__$1;
(statearr_74006_74085[(2)] = inst_73898);

(statearr_74006_74085[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (26))){
var inst_73814 = (state_73935[(2)]);
var state_73935__$1 = state_73935;
var statearr_74007_74086 = state_73935__$1;
(statearr_74007_74086[(2)] = inst_73814);

(statearr_74007_74086[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (16))){
var inst_73748 = (state_73935[(16)]);
var inst_73795 = (state_73935[(2)]);
var inst_73796 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_73748);
var state_73935__$1 = (function (){var statearr_74008 = state_73935;
(statearr_74008[(23)] = inst_73795);

return statearr_74008;
})();
if(inst_73796){
var statearr_74009_74087 = state_73935__$1;
(statearr_74009_74087[(1)] = (18));

} else {
var statearr_74010_74088 = state_73935__$1;
(statearr_74010_74088[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (38))){
var inst_73856 = (state_73935[(2)]);
var state_73935__$1 = state_73935;
var statearr_74011_74089 = state_73935__$1;
(statearr_74011_74089[(2)] = inst_73856);

(statearr_74011_74089[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (30))){
var inst_73829 = (state_73935[(9)]);
var inst_73844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73845 = [inst_73829,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_73846 = (new cljs.core.PersistentVector(null,2,(5),inst_73844,inst_73845,null));
var state_73935__$1 = state_73935;
var statearr_74012_74090 = state_73935__$1;
(statearr_74012_74090[(2)] = inst_73846);

(statearr_74012_74090[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (10))){
var inst_73761 = (state_73935[(7)]);
var inst_73752 = (state_73935[(21)]);
var inst_73776 = (inst_73761 - (1));
var inst_73777 = fluree.db.time_travel.as_of_block.call(null,inst_73752,inst_73776);
var state_73935__$1 = state_73935;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73935__$1,(13),inst_73777);
} else {
if((state_val_73936 === (18))){
var inst_73748 = (state_73935[(16)]);
var inst_73798 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73799 = [inst_73748];
var inst_73800 = (new cljs.core.PersistentVector(null,1,(5),inst_73798,inst_73799,null));
var state_73935__$1 = state_73935;
var statearr_74013_74091 = state_73935__$1;
(statearr_74013_74091[(2)] = inst_73800);

(statearr_74013_74091[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (52))){
var state_73935__$1 = state_73935;
var statearr_74014_74092 = state_73935__$1;
(statearr_74014_74092[(2)] = null);

(statearr_74014_74092[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (42))){
var inst_73838 = (state_73935[(12)]);
var inst_73871 = (state_73935[(20)]);
var inst_73870 = (inst_73838 == null);
var inst_73871__$1 = cljs.core.not.call(null,inst_73870);
var state_73935__$1 = (function (){var statearr_74015 = state_73935;
(statearr_74015[(20)] = inst_73871__$1);

return statearr_74015;
})();
if(inst_73871__$1){
var statearr_74016_74093 = state_73935__$1;
(statearr_74016_74093[(1)] = (45));

} else {
var statearr_74017_74094 = state_73935__$1;
(statearr_74017_74094[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (37))){
var inst_73851 = (state_73935[(26)]);
var state_73935__$1 = state_73935;
var statearr_74018_74095 = state_73935__$1;
(statearr_74018_74095[(2)] = inst_73851);

(statearr_74018_74095[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (8))){
var inst_73761 = (state_73935[(7)]);
var state_73935__$1 = state_73935;
var statearr_74019_74096 = state_73935__$1;
(statearr_74019_74096[(2)] = inst_73761);

(statearr_74019_74096[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73936 === (49))){
var state_73935__$1 = state_73935;
var statearr_74020_74097 = state_73935__$1;
(statearr_74020_74097[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_74022 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74022[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_74022[(1)] = (1));

return statearr_74022;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_73935){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_73935);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74023){var ex__2749__auto__ = e74023;
var statearr_74024_74098 = state_73935;
(statearr_74024_74098[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_73935[(4)]))){
var statearr_74025_74099 = state_73935;
(statearr_74025_74099[(1)] = cljs.core.first.call(null,(state_73935[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74100 = state_73935;
state_73935 = G__74100;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_73935){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_73935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74026 = f__2769__auto__.call(null);
(statearr_74026[(6)] = c__2768__auto__);

return statearr_74026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__74108 = arguments.length;
switch (G__74108) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__74101_SHARP_){
return cljs.core.dissoc.call(null,p1__74101_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74197){
var state_val_74198 = (state_74197[(1)]);
if((state_val_74198 === (7))){
var inst_74148 = (state_74197[(7)]);
var inst_74154 = (state_74197[(8)]);
var inst_74151 = (state_74197[(9)]);
var inst_74158 = (state_74197[(10)]);
var inst_74164 = (function (){var responses = inst_74148;
var responses_STAR_ = inst_74151;
var statuses = inst_74154;
var fuel = inst_74158;
return (function (p1__74104_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__74104_SHARP_);
});
})();
var inst_74165 = cljs.core.some.call(null,inst_74164,inst_74154);
var state_74197__$1 = state_74197;
if(cljs.core.truth_(inst_74165)){
var statearr_74199_74247 = state_74197__$1;
(statearr_74199_74247[(1)] = (9));

} else {
var statearr_74200_74248 = state_74197__$1;
(statearr_74200_74248[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (20))){
var inst_74192 = (state_74197[(2)]);
var state_74197__$1 = state_74197;
var statearr_74201_74249 = state_74197__$1;
(statearr_74201_74249[(2)] = inst_74192);

(statearr_74201_74249[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (1))){
var inst_74143 = cljs.core.async.chan.call(null,(1));
var inst_74144 = (function (){var c__2768__auto____$1 = inst_74143;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74141){
var state_val_74142 = (state_74141[(1)]);
if((state_val_74142 === (1))){
var inst_74109 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_74110 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_74111 = cljs.core.assoc.call(null,inst_74110,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_74112 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_74113 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_74114 = cljs.core.PersistentHashMap.EMPTY;
var inst_74115 = inst_74109;
var inst_74116 = inst_74111;
var inst_74117 = inst_74112;
var inst_74118 = inst_74113;
var inst_74119 = inst_74114;
var state_74141__$1 = (function (){var statearr_74202 = state_74141;
(statearr_74202[(7)] = inst_74118);

(statearr_74202[(8)] = inst_74117);

(statearr_74202[(9)] = inst_74116);

(statearr_74202[(10)] = inst_74115);

(statearr_74202[(11)] = inst_74119);

return statearr_74202;
})();
var statearr_74203_74250 = state_74141__$1;
(statearr_74203_74250[(2)] = null);

(statearr_74203_74250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74142 === (2))){
var inst_74116 = (state_74141[(9)]);
var inst_74121 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_74116);
var inst_74122 = cljs.core.merge.call(null,opts,inst_74121);
var inst_74123 = cljs.core.assoc.call(null,inst_74116,new cljs.core.Keyword(null,"opts","opts",155075701),inst_74122);
var inst_74124 = fluree.db.api_js.query_async.call(null,db,inst_74123,db_fn);
var state_74141__$1 = state_74141;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74141__$1,(4),inst_74124);
} else {
if((state_val_74142 === (3))){
var inst_74139 = (state_74141[(2)]);
var state_74141__$1 = state_74141;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74141__$1,inst_74139);
} else {
if((state_val_74142 === (4))){
var inst_74117 = (state_74141[(8)]);
var inst_74115 = (state_74141[(10)]);
var inst_74119 = (state_74141[(11)]);
var inst_74126 = (state_74141[(2)]);
var inst_74127 = cljs.core.assoc.call(null,inst_74119,inst_74115,inst_74126);
var inst_74128 = cljs.core.first.call(null,inst_74117);
var state_74141__$1 = (function (){var statearr_74204 = state_74141;
(statearr_74204[(12)] = inst_74127);

return statearr_74204;
})();
if(cljs.core.truth_(inst_74128)){
var statearr_74205_74251 = state_74141__$1;
(statearr_74205_74251[(1)] = (5));

} else {
var statearr_74206_74252 = state_74141__$1;
(statearr_74206_74252[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74142 === (5))){
var inst_74118 = (state_74141[(7)]);
var inst_74117 = (state_74141[(8)]);
var inst_74127 = (state_74141[(12)]);
var inst_74130 = cljs.core.first.call(null,inst_74117);
var inst_74131 = cljs.core.first.call(null,inst_74118);
var inst_74132 = cljs.core.rest.call(null,inst_74117);
var inst_74133 = cljs.core.rest.call(null,inst_74118);
var inst_74115 = inst_74130;
var inst_74116 = inst_74131;
var inst_74117__$1 = inst_74132;
var inst_74118__$1 = inst_74133;
var inst_74119 = inst_74127;
var state_74141__$1 = (function (){var statearr_74207 = state_74141;
(statearr_74207[(7)] = inst_74118__$1);

(statearr_74207[(8)] = inst_74117__$1);

(statearr_74207[(9)] = inst_74116);

(statearr_74207[(10)] = inst_74115);

(statearr_74207[(11)] = inst_74119);

return statearr_74207;
})();
var statearr_74208_74253 = state_74141__$1;
(statearr_74208_74253[(2)] = null);

(statearr_74208_74253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74142 === (6))){
var inst_74127 = (state_74141[(12)]);
var state_74141__$1 = state_74141;
var statearr_74209_74254 = state_74141__$1;
(statearr_74209_74254[(2)] = inst_74127);

(statearr_74209_74254[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74142 === (7))){
var inst_74137 = (state_74141[(2)]);
var state_74141__$1 = state_74141;
var statearr_74210_74255 = state_74141__$1;
(statearr_74210_74255[(2)] = inst_74137);

(statearr_74210_74255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_74211 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74211[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_74211[(1)] = (1));

return statearr_74211;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_74141){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74141);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74212){var ex__2749__auto__ = e74212;
var statearr_74213_74256 = state_74141;
(statearr_74213_74256[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74141[(4)]))){
var statearr_74214_74257 = state_74141;
(statearr_74214_74257[(1)] = cljs.core.first.call(null,(state_74141[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74258 = state_74141;
state_74141 = G__74258;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_74141){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_74141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74215 = f__2769__auto__.call(null);
(statearr_74215[(6)] = c__2768__auto____$1);

return statearr_74215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_74145 = cljs.core.async.impl.dispatch.run.call(null,inst_74144);
var state_74197__$1 = (function (){var statearr_74216 = state_74197;
(statearr_74216[(11)] = inst_74145);

return statearr_74216;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74197__$1,(2),inst_74143);
} else {
if((state_val_74198 === (4))){
var inst_74148 = (state_74197[(7)]);
var state_74197__$1 = state_74197;
var statearr_74217_74259 = state_74197__$1;
(statearr_74217_74259[(2)] = inst_74148);

(statearr_74217_74259[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (15))){
var state_74197__$1 = state_74197;
var statearr_74218_74260 = state_74197__$1;
(statearr_74218_74260[(2)] = (400));

(statearr_74218_74260[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (13))){
var state_74197__$1 = state_74197;
var statearr_74219_74261 = state_74197__$1;
(statearr_74219_74261[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (6))){
var inst_74154 = (state_74197[(8)]);
var inst_74162 = cljs.core.first.call(null,inst_74154);
var state_74197__$1 = state_74197;
var statearr_74221_74262 = state_74197__$1;
(statearr_74221_74262[(2)] = inst_74162);

(statearr_74221_74262[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (17))){
var inst_74175 = (state_74197[(2)]);
var state_74197__$1 = state_74197;
var statearr_74222_74263 = state_74197__$1;
(statearr_74222_74263[(2)] = inst_74175);

(statearr_74222_74263[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (3))){
var inst_74148 = (state_74197[(7)]);
var inst_74154 = (state_74197[(8)]);
var inst_74151 = (state_74197[(9)]);
var inst_74158 = (state_74197[(10)]);
var inst_74153 = cljs.core.vals.call(null,inst_74148);
var inst_74154__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74153);
var inst_74155 = (function (){var responses = inst_74148;
var responses_STAR_ = inst_74151;
var statuses = inst_74154__$1;
return (function (p1__74102_SHARP_){
var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__74102_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
});
})();
var inst_74156 = cljs.core.vals.call(null,inst_74148);
var inst_74157 = cljs.core.map.call(null,inst_74155,inst_74156);
var inst_74158__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_74157);
var inst_74159 = (function (){var responses = inst_74148;
var responses_STAR_ = inst_74151;
var statuses = inst_74154__$1;
var fuel = inst_74158__$1;
return (function (p1__74103_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__74103_SHARP_);
});
})();
var inst_74160 = cljs.core.every_QMARK_.call(null,inst_74159,inst_74154__$1);
var state_74197__$1 = (function (){var statearr_74223 = state_74197;
(statearr_74223[(8)] = inst_74154__$1);

(statearr_74223[(10)] = inst_74158__$1);

return statearr_74223;
})();
if(inst_74160){
var statearr_74224_74264 = state_74197__$1;
(statearr_74224_74264[(1)] = (6));

} else {
var statearr_74225_74265 = state_74197__$1;
(statearr_74225_74265[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (12))){
var state_74197__$1 = state_74197;
var statearr_74226_74266 = state_74197__$1;
(statearr_74226_74266[(2)] = (500));

(statearr_74226_74266[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (2))){
var inst_74148 = (state_74197[(7)]);
var inst_74147 = (state_74197[(2)]);
var inst_74148__$1 = fluree.db.util.async.throw_err.call(null,inst_74147);
var inst_74149 = (function (){var responses = inst_74148__$1;
return (function (acc,index,response){
var resp = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_74150 = cljs.core.PersistentHashMap.EMPTY;
var inst_74151 = cljs.core.reduce_kv.call(null,inst_74149,inst_74150,inst_74148__$1);
var state_74197__$1 = (function (){var statearr_74227 = state_74197;
(statearr_74227[(7)] = inst_74148__$1);

(statearr_74227[(9)] = inst_74151);

return statearr_74227;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_74228_74267 = state_74197__$1;
(statearr_74228_74267[(1)] = (3));

} else {
var statearr_74229_74268 = state_74197__$1;
(statearr_74229_74268[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (19))){
var inst_74151 = (state_74197[(9)]);
var inst_74158 = (state_74197[(10)]);
var inst_74181 = (state_74197[(12)]);
var inst_74190 = cljs.core.assoc.call(null,inst_74151,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74181,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74158);
var state_74197__$1 = state_74197;
var statearr_74230_74269 = state_74197__$1;
(statearr_74230_74269[(2)] = inst_74190);

(statearr_74230_74269[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (11))){
var inst_74179 = (state_74197[(2)]);
var state_74197__$1 = state_74197;
var statearr_74231_74270 = state_74197__$1;
(statearr_74231_74270[(2)] = inst_74179);

(statearr_74231_74270[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (9))){
var state_74197__$1 = state_74197;
var statearr_74232_74271 = state_74197__$1;
(statearr_74232_74271[(2)] = (207));

(statearr_74232_74271[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (5))){
var inst_74195 = (state_74197[(2)]);
var state_74197__$1 = state_74197;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74197__$1,inst_74195);
} else {
if((state_val_74198 === (14))){
var inst_74177 = (state_74197[(2)]);
var state_74197__$1 = state_74197;
var statearr_74233_74272 = state_74197__$1;
(statearr_74233_74272[(2)] = inst_74177);

(statearr_74233_74272[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (16))){
var state_74197__$1 = state_74197;
var statearr_74234_74273 = state_74197__$1;
(statearr_74234_74273[(2)] = null);

(statearr_74234_74273[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (10))){
var inst_74148 = (state_74197[(7)]);
var inst_74154 = (state_74197[(8)]);
var inst_74151 = (state_74197[(9)]);
var inst_74158 = (state_74197[(10)]);
var inst_74168 = (function (){var responses = inst_74148;
var responses_STAR_ = inst_74151;
var statuses = inst_74154;
var fuel = inst_74158;
return (function (p1__74105_SHARP_){
return ((499) < p1__74105_SHARP_);
});
})();
var inst_74169 = cljs.core.some.call(null,inst_74168,inst_74154);
var state_74197__$1 = state_74197;
if(cljs.core.truth_(inst_74169)){
var statearr_74235_74274 = state_74197__$1;
(statearr_74235_74274[(1)] = (12));

} else {
var statearr_74236_74275 = state_74197__$1;
(statearr_74236_74275[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (18))){
var inst_74186 = (state_74197[(13)]);
var inst_74151 = (state_74197[(9)]);
var inst_74158 = (state_74197[(10)]);
var inst_74181 = (state_74197[(12)]);
var inst_74188 = cljs.core.assoc.call(null,inst_74151,new cljs.core.Keyword(null,"status","status",-1997798413),inst_74181,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74158,new cljs.core.Keyword(null,"block","block",664686210),inst_74186);
var state_74197__$1 = state_74197;
var statearr_74237_74276 = state_74197__$1;
(statearr_74237_74276[(2)] = inst_74188);

(statearr_74237_74276[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74198 === (8))){
var inst_74186 = (state_74197[(13)]);
var inst_74148 = (state_74197[(7)]);
var inst_74154 = (state_74197[(8)]);
var inst_74151 = (state_74197[(9)]);
var inst_74158 = (state_74197[(10)]);
var inst_74181 = (state_74197[(12)]);
var inst_74181__$1 = (state_74197[(2)]);
var inst_74182 = (function (){var responses = inst_74148;
var responses_STAR_ = inst_74151;
var statuses = inst_74154;
var fuel = inst_74158;
var status = inst_74181__$1;
return (function (p1__74106_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__74106_SHARP_));
});
})();
var inst_74183 = cljs.core.vals.call(null,inst_74148);
var inst_74184 = cljs.core.filter.call(null,inst_74182,inst_74183);
var inst_74185 = cljs.core.first.call(null,inst_74184);
var inst_74186__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_74185);
var state_74197__$1 = (function (){var statearr_74238 = state_74197;
(statearr_74238[(13)] = inst_74186__$1);

(statearr_74238[(12)] = inst_74181__$1);

return statearr_74238;
})();
if(cljs.core.truth_(inst_74186__$1)){
var statearr_74239_74277 = state_74197__$1;
(statearr_74239_74277[(1)] = (18));

} else {
var statearr_74240_74278 = state_74197__$1;
(statearr_74240_74278[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_74241 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74241[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_74241[(1)] = (1));

return statearr_74241;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_74197){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74197);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74242){var ex__2749__auto__ = e74242;
var statearr_74243_74279 = state_74197;
(statearr_74243_74279[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74197[(4)]))){
var statearr_74244_74280 = state_74197;
(statearr_74244_74280[(1)] = cljs.core.first.call(null,(state_74197[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74281 = state_74197;
state_74197 = G__74281;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_74197){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_74197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74245 = f__2769__auto__.call(null);
(statearr_74245[(6)] = c__2768__auto__);

return statearr_74245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__74283 = arguments.length;
switch (G__74283) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__74284 = opts;
var map__74284__$1 = cljs.core.__destructure_map.call(null,map__74284);
var auth = cljs.core.get.call(null,map__74284__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__74284__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__74284__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__74284__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__74285 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__74285,(0),null);
var authority = cljs.core.nth.call(null,vec__74285,(1),null);
var action__$1 = (function (){var or__4253__auto__ = action;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e74288){var e = e74288;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__74291 = arguments.length;
switch (G__74291) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_74325){
var state_val_74326 = (state_74325[(1)]);
if((state_val_74326 === (7))){
var state_74325__$1 = state_74325;
var statearr_74327_74348 = state_74325__$1;
(statearr_74327_74348[(2)] = opts);

(statearr_74327_74348[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74326 === (1))){
var state_74325__$1 = state_74325;
var statearr_74328_74349 = state_74325__$1;
(statearr_74328_74349[(2)] = null);

(statearr_74328_74349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74326 === (4))){
var inst_74292 = (state_74325[(2)]);
var inst_74293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74294 = [inst_74292];
var inst_74295 = (new cljs.core.PersistentVector(null,1,(5),inst_74293,inst_74294,null));
var inst_74296 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_74295);
var inst_74297 = cljs.core.ex_data.call(null,inst_74292);
var inst_74298 = cljs.core.ex_message.call(null,inst_74292);
var inst_74299 = cljs.core.assoc.call(null,inst_74297,new cljs.core.Keyword(null,"message","message",-406056002),inst_74298);
var state_74325__$1 = (function (){var statearr_74329 = state_74325;
(statearr_74329[(7)] = inst_74296);

return statearr_74329;
})();
var statearr_74330_74350 = state_74325__$1;
(statearr_74330_74350[(2)] = inst_74299);

(statearr_74330_74350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74326 === (6))){
var inst_74309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74310 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_74311 = (new cljs.core.PersistentVector(null,1,(5),inst_74309,inst_74310,null));
var inst_74312 = cljs.core.assoc_in.call(null,opts,inst_74311,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_74325__$1 = state_74325;
var statearr_74331_74351 = state_74325__$1;
(statearr_74331_74351[(2)] = inst_74312);

(statearr_74331_74351[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74326 === (3))){
var inst_74323 = (state_74325[(2)]);
var state_74325__$1 = state_74325;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74325__$1,inst_74323);
} else {
if((state_val_74326 === (2))){
var _ = (function (){var statearr_74333 = state_74325;
(statearr_74333[(4)] = cljs.core.cons.call(null,(5),(state_74325[(4)])));

return statearr_74333;
})();
var inst_74305 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_74306 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_74307 = (inst_74306 == null);
var state_74325__$1 = (function (){var statearr_74334 = state_74325;
(statearr_74334[(8)] = inst_74305);

return statearr_74334;
})();
if(cljs.core.truth_(inst_74307)){
var statearr_74335_74352 = state_74325__$1;
(statearr_74335_74352[(1)] = (6));

} else {
var statearr_74336_74353 = state_74325__$1;
(statearr_74336_74353[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74326 === (9))){
var inst_74319 = (state_74325[(2)]);
var inst_74320 = fluree.db.util.async.throw_err.call(null,inst_74319);
var _ = (function (){var statearr_74337 = state_74325;
(statearr_74337[(4)] = cljs.core.rest.call(null,(state_74325[(4)])));

return statearr_74337;
})();
var state_74325__$1 = state_74325;
var statearr_74338_74354 = state_74325__$1;
(statearr_74338_74354[(2)] = inst_74320);

(statearr_74338_74354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74326 === (5))){
var _ = (function (){var statearr_74339 = state_74325;
(statearr_74339[(4)] = cljs.core.rest.call(null,(state_74325[(4)])));

return statearr_74339;
})();
var state_74325__$1 = state_74325;
var ex74332 = (state_74325__$1[(2)]);
var statearr_74340_74355 = state_74325__$1;
(statearr_74340_74355[(5)] = ex74332);


var statearr_74341_74356 = state_74325__$1;
(statearr_74341_74356[(1)] = (4));

(statearr_74341_74356[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74326 === (8))){
var inst_74305 = (state_74325[(8)]);
var inst_74315 = (state_74325[(2)]);
var inst_74316 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_74305,inst_74315);
var inst_74317 = fluree.db.operations.command_async.call(null,conn,inst_74316);
var state_74325__$1 = state_74325;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74325__$1,(9),inst_74317);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_74342 = [null,null,null,null,null,null,null,null,null];
(statearr_74342[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_74342[(1)] = (1));

return statearr_74342;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_74325){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_74325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e74343){var ex__2749__auto__ = e74343;
var statearr_74344_74357 = state_74325;
(statearr_74344_74357[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_74325[(4)]))){
var statearr_74345_74358 = state_74325;
(statearr_74345_74358[(1)] = cljs.core.first.call(null,(state_74325[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74359 = state_74325;
state_74325 = G__74359;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_74325){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_74325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_74346 = f__2769__auto__.call(null);
(statearr_74346[(6)] = c__2768__auto__);

return statearr_74346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

