// Compiled by ClojureScript 1.11.4 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('alphabase.bytes');
goog.require('cljs.core');
/**
 * Coerces a number to a byte value.
 */
alphabase.bytes.to_byte = (function alphabase$bytes$to_byte(x){
return x;
});
/**
 * Coerces a byte value to a number.
 */
alphabase.bytes.from_byte = (function alphabase$bytes$from_byte(x){
return x;
});
/**
 * Reads a byte value out of an array and coerces it to a number.
 */
alphabase.bytes.get_byte = (function alphabase$bytes$get_byte(array,i){
return alphabase.bytes.from_byte.call(null,(array[i]));
});
/**
 * Sets a byte value in an array after coercing it from a number.
 */
alphabase.bytes.set_byte = (function alphabase$bytes$set_byte(array,i,x){
return (array[i] = alphabase.bytes.to_byte.call(null,x));
});
/**
 * Return a sequence of the bytes in an array, after coercion.
 */
alphabase.bytes.byte_seq = (function alphabase$bytes$byte_seq(array){
if(cljs.core.truth_(array)){
return cljs.core.map.call(null,(function (p1__27616_SHARP_){
return (array[p1__27616_SHARP_]);
}),cljs.core.range.call(null,array.length));
} else {
return null;
}
});
/**
 * True if the argument is a byte array compatible with this library.
 */
alphabase.bytes.bytes_QMARK_ = (function alphabase$bytes$bytes_QMARK_(x){
return (((x instanceof Uint8Array)) || ((((x instanceof Array)) && (((cljs.core.empty_QMARK_.call(null,x)) || (cljs.core.integer_QMARK_.call(null,cljs.core.first.call(null,x))))))));
});
/**
 * Returns true if two byte sequences are the same length and have the same
 *   byte content.
 */
alphabase.bytes.bytes_EQ_ = (function alphabase$bytes$bytes_EQ_(a,b){
var and__4251__auto__ = alphabase.bytes.bytes_QMARK_.call(null,a);
if(and__4251__auto__){
var and__4251__auto____$1 = alphabase.bytes.bytes_QMARK_.call(null,b);
if(and__4251__auto____$1){
var a__$1 = a;
var b__$1 = b;
var and__4251__auto____$2 = cljs.core._EQ_.call(null,a__$1.length,b__$1.length);
if(and__4251__auto____$2){
var i = (0);
while(true){
if((i < a__$1.length)){
if(cljs.core._EQ_.call(null,alphabase.bytes.get_byte.call(null,a__$1,i),alphabase.bytes.get_byte.call(null,b__$1,i))){
var G__27617 = (i + (1));
i = G__27617;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
});
/**
 * Creates a new array to hold byte data.
 */
alphabase.bytes.byte_array = (function alphabase$bytes$byte_array(length){
return (new Uint8Array((new ArrayBuffer(length))));
});
/**
 * Copies bytes from one array to another.
 * 
 *   - If only a source is given, returns a full copy of the byte array.
 *   - If a source and a destination with offset are given, copies all of the
 *  bytes from the source into the destination at that offset. Returns the
 *  number of bytes copied.
 *   - If all arguments are given, copies `length` bytes from the source at the
 *  given offset to the destination at its offset. Returns the number of bytes
 *  copied.
 */
alphabase.bytes.copy = (function alphabase$bytes$copy(var_args){
var G__27619 = arguments.length;
switch (G__27619) {
case 1:
return alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$1 = (function (src){
var dst = alphabase.bytes.byte_array.call(null,src.length);
alphabase.bytes.copy.call(null,src,dst,(0));

return dst;
}));

(alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$3 = (function (src,dst,dst_offset){
return alphabase.bytes.copy.call(null,src,(0),dst,dst_offset,src.length);
}));

(alphabase.bytes.copy.cljs$core$IFn$_invoke$arity$5 = (function (src,src_offset,dst,dst_offset,length){
var n__4741__auto___27621 = length;
var i_27622 = (0);
while(true){
if((i_27622 < n__4741__auto___27621)){
alphabase.bytes.set_byte.call(null,dst,(i_27622 + dst_offset),alphabase.bytes.get_byte.call(null,src,(i_27622 + src_offset)));

var G__27623 = (i_27622 + (1));
i_27622 = G__27623;
continue;
} else {
}
break;
}

return length;
}));

(alphabase.bytes.copy.cljs$lang$maxFixedArity = 5);

/**
 * Initialize a new array with the given sequence of byte values.
 */
alphabase.bytes.init_bytes = (function alphabase$bytes$init_bytes(values){
var length = cljs.core.count.call(null,values);
var data = alphabase.bytes.byte_array.call(null,length);
var n__4741__auto___27624 = length;
var i_27625 = (0);
while(true){
if((i_27625 < n__4741__auto___27624)){
alphabase.bytes.set_byte.call(null,data,i_27625,cljs.core.nth.call(null,values,i_27625));

var G__27626 = (i_27625 + (1));
i_27625 = G__27626;
continue;
} else {
}
break;
}

return data;
});
/**
 * Returns a byte array `length` bytes long with random content.
 */
alphabase.bytes.random_bytes = (function alphabase$bytes$random_bytes(length){
var data = alphabase.bytes.byte_array.call(null,length);
var n__4741__auto___27627 = length;
var i_27628 = (0);
while(true){
if((i_27628 < n__4741__auto___27627)){
alphabase.bytes.set_byte.call(null,data,i_27628,cljs.core.rand_int.call(null,(256)));

var G__27629 = (i_27628 + (1));
i_27628 = G__27629;
continue;
} else {
}
break;
}

return data;
});
/**
 * Lexicographically compares two byte-arrays for order. Returns a negative
 *   number, zero, or a positive number if `a` is less than, equal to, or greater
 *   than `b`, respectively.
 * 
 *   This ranking compares each byte in the keys in order; the first byte which
 *   differs determines the ordering; if the byte in `a` is less than the byte in
 *   `b`, `a` ranks before `b`, and vice versa.
 * 
 *   If the keys differ in length, and all the bytes in the shorter key match the
 *   longer key, the shorter key ranks first.
 */
alphabase.bytes.compare = (function alphabase$bytes$compare(a,b){
var prefix_len = (function (){var x__4339__auto__ = a.length;
var y__4340__auto__ = b.length;
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})();
var i = (0);
while(true){
if((i < prefix_len)){
var ai = alphabase.bytes.get_byte.call(null,a,i);
var bi = alphabase.bytes.get_byte.call(null,b,i);
if(cljs.core._EQ_.call(null,ai,bi)){
var G__27630 = (i + (1));
i = G__27630;
continue;
} else {
return (ai - bi);
}
} else {
return (a.length - b.length);
}
break;
}
});
/**
 * Copy a slice (defined by offset, length) from a byte array.
 * 
 *   Omitting the slice `len` argument will copy remainder of
 *   `src` array from offset (e.g, `(- (alength src) offset)` bytes).
 */
alphabase.bytes.copy_slice = (function alphabase$bytes$copy_slice(var_args){
var G__27632 = arguments.length;
switch (G__27632) {
case 3:
return alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$3 = (function (src,offset,len){
var dst = alphabase.bytes.byte_array.call(null,len);
alphabase.bytes.copy.call(null,src,offset,dst,(0),len);

return dst;
}));

(alphabase.bytes.copy_slice.cljs$core$IFn$_invoke$arity$2 = (function (src,offset){
return alphabase.bytes.copy_slice.call(null,src,offset,(src.length - offset));
}));

(alphabase.bytes.copy_slice.cljs$lang$maxFixedArity = 3);

/**
 * Concatenate bytes arrays into a single new byte array.
 */
alphabase.bytes.concat = (function alphabase$bytes$concat(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27636 = arguments.length;
var i__4865__auto___27637 = (0);
while(true){
if((i__4865__auto___27637 < len__4864__auto___27636)){
args__4870__auto__.push((arguments[i__4865__auto___27637]));

var G__27638 = (i__4865__auto___27637 + (1));
i__4865__auto___27637 = G__27638;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return alphabase.bytes.concat.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(alphabase.bytes.concat.cljs$core$IFn$_invoke$arity$variadic = (function (arrs){
var arrs__$1 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,arrs);
var total_len = cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map.call(null,(function (p1__27634_SHARP_){
return p1__27634_SHARP_.length;
}),arrs__$1));
var dst = alphabase.bytes.byte_array.call(null,total_len);
var arrs_27639__$2 = arrs__$1;
var offset_27640 = (0);
while(true){
var temp__5753__auto___27641 = cljs.core.first.call(null,arrs_27639__$2);
if(cljs.core.truth_(temp__5753__auto___27641)){
var src_27642 = temp__5753__auto___27641;
alphabase.bytes.copy.call(null,src_27642,(0),dst,offset_27640,src_27642.length);

var G__27643 = cljs.core.rest.call(null,arrs_27639__$2);
var G__27644 = (offset_27640 + src_27642.length);
arrs_27639__$2 = G__27643;
offset_27640 = G__27644;
continue;
} else {
}
break;
}

return dst;
}));

(alphabase.bytes.concat.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(alphabase.bytes.concat.cljs$lang$applyTo = (function (seq27635){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27635));
}));

