// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.subject');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('fluree.db.index');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.common');
goog.require('fluree.db.dbproto');
/**
 * Returns chan of subjects in chunks per index-leaf
 *   that can be pulled as needed based on the selection criteria of a where clause.
 */
fluree.db.query.subject_crawl.subject.subjects_chan = (function fluree$db$query$subject_crawl$subject$subjects_chan(p__23023,error_ch,vars,p__23024){
var map__23025 = p__23023;
var map__23025__$1 = cljs.core.__destructure_map(map__23025);
var db = map__23025__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23025__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var novelty = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23025__$1,new cljs.core.Keyword(null,"novelty","novelty",-1590246024));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23025__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__23026 = p__23024;
var map__23026__$1 = cljs.core.__destructure_map(map__23026);
var _where_clause = map__23026__$1;
var p = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23026__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23026__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23026__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var o_STAR_ = (function (){var temp__5806__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if((temp__5806__auto__ == null)){
var temp__5804__auto__ = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(temp__5804__auto__)){
var variable = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,variable);
} else {
return null;
}
} else {
var v = temp__5806__auto__;
return v;
}
})();
var vec__23027 = (function (){var G__23030 = idx;
var G__23030__$1 = (((G__23030 instanceof cljs.core.Keyword))?G__23030.fqn:null);
switch (G__23030__$1) {
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake(null,p,o_STAR_,null,null,(-2147483647)),fluree.db.flake.__GT_Flake(null,p,o_STAR_,null,null,(2147483647))], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake(null,p,null,null,null,(-2147483647)),fluree.db.flake.__GT_Flake(null,p,null,null,null,(2147483647))], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23030__$1)].join('')));

}
})();
var fflake = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23027,(0),null);
var lflake = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23027,(1),null);
var filter_fn = (cljs.core.truth_((function (){var and__4251__auto__ = o_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"psot","psot",2111653059),idx);
} else {
return and__4251__auto__;
}
})())?(function (p1__23021_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o_STAR_,fluree.db.flake.o(p1__23021_SHARP_));
}):(cljs.core.truth_(new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(o))?(function (){var f = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(o,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"function","function",-2127255473)], null));
return (function (p1__23022_SHARP_){
var G__23031 = fluree.db.flake.o(p1__23022_SHARP_);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23031) : f.call(null,G__23031));
});
})():null));
var idx_root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(idx_root);
var range_set = fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fflake,lflake], 0));
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_(node,range_set);
});
var query_xf = fluree.db.query.subject_crawl.common.where_subj_xf(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"start-test","start-test",-952983565),cljs.core._GT__EQ_,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),fflake,new cljs.core.Keyword(null,"end-test","end-test",481973727),cljs.core._LT__EQ_,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),lflake,new cljs.core.Keyword(null,"xf","xf",401902988),(cljs.core.truth_(filter_fn)?cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(filter_fn,flakes);
})):null)], null));
var resolver = fluree.db.index.__GT_CachedTRangeResolver(conn,cljs.core.get.cljs$core$IFn$_invoke$arity$2(novelty,idx),t,t,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(conn));
var tree_chan = fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(resolver,idx_root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
var return_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((10),cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.flake.s),cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0()));
var c__2749__auto___23101 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23070){
var state_val_23071 = (state_23070[(1)]);
if((state_val_23071 === (7))){
var inst_23066 = (state_23070[(2)]);
var state_23070__$1 = state_23070;
var statearr_23072_23102 = state_23070__$1;
(statearr_23072_23102[(2)] = inst_23066);

(statearr_23072_23102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (1))){
var state_23070__$1 = state_23070;
var statearr_23073_23103 = state_23070__$1;
(statearr_23073_23103[(2)] = null);

(statearr_23073_23103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (4))){
var inst_23034 = (state_23070[(7)]);
var inst_23034__$1 = (state_23070[(2)]);
var inst_23035 = (inst_23034__$1 == null);
var state_23070__$1 = (function (){var statearr_23074 = state_23070;
(statearr_23074[(7)] = inst_23034__$1);

return statearr_23074;
})();
if(cljs.core.truth_(inst_23035)){
var statearr_23075_23104 = state_23070__$1;
(statearr_23075_23104[(1)] = (5));

} else {
var statearr_23076_23105 = state_23070__$1;
(statearr_23076_23105[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (15))){
var state_23070__$1 = state_23070;
var statearr_23077_23106 = state_23070__$1;
(statearr_23077_23106[(2)] = false);

(statearr_23077_23106[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (13))){
var inst_23046 = (state_23070[(2)]);
var state_23070__$1 = state_23070;
if(cljs.core.truth_(inst_23046)){
var statearr_23078_23107 = state_23070__$1;
(statearr_23078_23107[(1)] = (14));

} else {
var statearr_23079_23108 = state_23070__$1;
(statearr_23079_23108[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (6))){
var inst_23034 = (state_23070[(7)]);
var inst_23039 = cljs.core.seq(inst_23034);
var inst_23040 = inst_23039;
var inst_23041 = (0);
var state_23070__$1 = (function (){var statearr_23080 = state_23070;
(statearr_23080[(8)] = inst_23040);

(statearr_23080[(9)] = inst_23041);

return statearr_23080;
})();
var statearr_23081_23109 = state_23070__$1;
(statearr_23081_23109[(2)] = null);

(statearr_23081_23109[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (17))){
var state_23070__$1 = state_23070;
var statearr_23082_23110 = state_23070__$1;
(statearr_23082_23110[(2)] = null);

(statearr_23082_23110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (3))){
var inst_23068 = (state_23070[(2)]);
var state_23070__$1 = state_23070;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23070__$1,inst_23068);
} else {
if((state_val_23071 === (12))){
var inst_23056 = (state_23070[(2)]);
var state_23070__$1 = state_23070;
var statearr_23083_23111 = state_23070__$1;
(statearr_23083_23111[(2)] = inst_23056);

(statearr_23083_23111[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (2))){
var state_23070__$1 = state_23070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23070__$1,(4),tree_chan);
} else {
if((state_val_23071 === (19))){
var inst_23064 = (state_23070[(2)]);
var state_23070__$1 = state_23070;
var statearr_23084_23112 = state_23070__$1;
(statearr_23084_23112[(2)] = inst_23064);

(statearr_23084_23112[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (11))){
var state_23070__$1 = state_23070;
var statearr_23085_23113 = state_23070__$1;
(statearr_23085_23113[(2)] = true);

(statearr_23085_23113[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (9))){
var inst_23058 = (state_23070[(2)]);
var state_23070__$1 = state_23070;
if(cljs.core.truth_(inst_23058)){
var statearr_23086_23114 = state_23070__$1;
(statearr_23086_23114[(1)] = (17));

} else {
var statearr_23087_23115 = state_23070__$1;
(statearr_23087_23115[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (5))){
var inst_23037 = cljs.core.async.close_BANG_(return_chan);
var state_23070__$1 = state_23070;
var statearr_23088_23116 = state_23070__$1;
(statearr_23088_23116[(2)] = inst_23037);

(statearr_23088_23116[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (14))){
var inst_23040 = (state_23070[(8)]);
var inst_23041 = (state_23070[(9)]);
var inst_23048 = cljs.core.next(inst_23040);
var inst_23049 = (inst_23041 + (1));
var inst_23040__$1 = inst_23048;
var inst_23041__$1 = inst_23049;
var state_23070__$1 = (function (){var statearr_23089 = state_23070;
(statearr_23089[(8)] = inst_23040__$1);

(statearr_23089[(9)] = inst_23041__$1);

return statearr_23089;
})();
var statearr_23090_23117 = state_23070__$1;
(statearr_23090_23117[(2)] = null);

(statearr_23090_23117[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (16))){
var inst_23053 = (state_23070[(2)]);
var state_23070__$1 = state_23070;
var statearr_23091_23118 = state_23070__$1;
(statearr_23091_23118[(2)] = inst_23053);

(statearr_23091_23118[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (10))){
var inst_23040 = (state_23070[(8)]);
var inst_23044 = cljs.core.first(inst_23040);
var state_23070__$1 = state_23070;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23070__$1,(13),return_chan,inst_23044);
} else {
if((state_val_23071 === (18))){
var inst_23062 = cljs.core.async.close_BANG_(return_chan);
var state_23070__$1 = state_23070;
var statearr_23092_23119 = state_23070__$1;
(statearr_23092_23119[(2)] = inst_23062);

(statearr_23092_23119[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23071 === (8))){
var inst_23040 = (state_23070[(8)]);
var state_23070__$1 = state_23070;
if(cljs.core.truth_(inst_23040)){
var statearr_23093_23120 = state_23070__$1;
(statearr_23093_23120[(1)] = (10));

} else {
var statearr_23094_23121 = state_23070__$1;
(statearr_23094_23121[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0 = (function (){
var statearr_23095 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23095[(0)] = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__);

(statearr_23095[(1)] = (1));

return statearr_23095;
});
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1 = (function (state_23070){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23070);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23096){var ex__2730__auto__ = e23096;
var statearr_23097_23122 = state_23070;
(statearr_23097_23122[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23070[(4)]))){
var statearr_23098_23123 = state_23070;
(statearr_23098_23123[(1)] = cljs.core.first((state_23070[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23124 = state_23070;
state_23070 = G__23124;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__ = function(state_23070){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1.call(this,state_23070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23099 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23099[(6)] = c__2749__auto___23101);

return statearr_23099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_chan;
});
fluree.db.query.subject_crawl.subject.flakes_xf = (function fluree$db$query$subject_crawl$subject$flakes_xf(p__23125){
var map__23126 = p__23125;
var map__23126__$1 = cljs.core.__destructure_map(map__23126);
var _opts = map__23126__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23126__$1,new cljs.core.Keyword(null,"db","db",993250759));
var fuel_vol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23126__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23126__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23126__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23126__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var filter_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23126__$1,new cljs.core.Keyword(null,"filter-map","filter-map",-314788257));
var permissioned_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23126__$1,new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803));
var permissions = (cljs.core.truth_(permissioned_QMARK_)?fluree.db.query.subject_crawl.common.subj_perm_filter_fn(db):null);
return (function (sid,port){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23171){
var state_val_23172 = (state_23171[(1)]);
if((state_val_23172 === (7))){
var inst_23142 = (state_23171[(7)]);
var inst_23144 = fluree.db.query.subject_crawl.common.filter_subject(vars,filter_map,inst_23142);
var state_23171__$1 = state_23171;
var statearr_23173_23209 = state_23171__$1;
(statearr_23173_23209[(2)] = inst_23144);

(statearr_23173_23209[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (1))){
var state_23171__$1 = state_23171;
var statearr_23174_23210 = state_23171__$1;
(statearr_23174_23210[(2)] = null);

(statearr_23174_23210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (4))){
var inst_23127 = (state_23171[(2)]);
var inst_23128 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_23127);
var inst_23129 = cljs.core.async.close_BANG_(port);
var state_23171__$1 = (function (){var statearr_23175 = state_23171;
(statearr_23175[(8)] = inst_23128);

(statearr_23175[(9)] = inst_23129);

return statearr_23175;
})();
var statearr_23176_23211 = state_23171__$1;
(statearr_23176_23211[(2)] = null);

(statearr_23176_23211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (15))){
var inst_23159 = (state_23171[(10)]);
var inst_23159__$1 = (state_23171[(2)]);
var inst_23160 = cljs.core.seq(inst_23159__$1);
var state_23171__$1 = (function (){var statearr_23177 = state_23171;
(statearr_23177[(10)] = inst_23159__$1);

return statearr_23177;
})();
if(inst_23160){
var statearr_23178_23212 = state_23171__$1;
(statearr_23178_23212[(1)] = (17));

} else {
var statearr_23179_23213 = state_23171__$1;
(statearr_23179_23213[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (13))){
var inst_23152 = (state_23171[(11)]);
var state_23171__$1 = state_23171;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23171__$1,(16),inst_23152);
} else {
if((state_val_23172 === (6))){
var inst_23141 = (state_23171[(2)]);
var inst_23142 = fluree.db.util.async.throw_err(inst_23141);
var state_23171__$1 = (function (){var statearr_23180 = state_23171;
(statearr_23180[(7)] = inst_23142);

return statearr_23180;
})();
if(cljs.core.truth_(filter_map)){
var statearr_23181_23214 = state_23171__$1;
(statearr_23181_23214[(1)] = (7));

} else {
var statearr_23182_23215 = state_23171__$1;
(statearr_23182_23215[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (17))){
var inst_23159 = (state_23171[(10)]);
var inst_23162 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_23159);
var state_23171__$1 = state_23171;
var statearr_23183_23216 = state_23171__$1;
(statearr_23183_23216[(2)] = inst_23162);

(statearr_23183_23216[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (3))){
var inst_23169 = (state_23171[(2)]);
var state_23171__$1 = state_23171;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23171__$1,inst_23169);
} else {
if((state_val_23172 === (12))){
var inst_23152 = (state_23171[(2)]);
var state_23171__$1 = (function (){var statearr_23184 = state_23171;
(statearr_23184[(11)] = inst_23152);

return statearr_23184;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_23185_23217 = state_23171__$1;
(statearr_23185_23217[(1)] = (13));

} else {
var statearr_23186_23218 = state_23171__$1;
(statearr_23186_23218[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (2))){
var _ = (function (){var statearr_23187 = state_23171;
(statearr_23187[(4)] = cljs.core.cons((5),(state_23171[(4)])));

return statearr_23187;
})();
var inst_23136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23137 = [sid];
var inst_23138 = (new cljs.core.PersistentVector(null,1,(5),inst_23136,inst_23137,null));
var inst_23139 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23138);
var state_23171__$1 = state_23171;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23171__$1,(6),inst_23139);
} else {
if((state_val_23172 === (19))){
var inst_23165 = (state_23171[(2)]);
var inst_23166 = cljs.core.async.close_BANG_(port);
var _ = (function (){var statearr_23188 = state_23171;
(statearr_23188[(4)] = cljs.core.rest((state_23171[(4)])));

return statearr_23188;
})();
var state_23171__$1 = (function (){var statearr_23189 = state_23171;
(statearr_23189[(12)] = inst_23165);

return statearr_23189;
})();
var statearr_23190_23219 = state_23171__$1;
(statearr_23190_23219[(2)] = inst_23166);

(statearr_23190_23219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (11))){
var inst_23147 = (state_23171[(13)]);
var state_23171__$1 = state_23171;
var statearr_23192_23220 = state_23171__$1;
(statearr_23192_23220[(2)] = inst_23147);

(statearr_23192_23220[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (9))){
var inst_23147 = (state_23171[(2)]);
var state_23171__$1 = (function (){var statearr_23193 = state_23171;
(statearr_23193[(13)] = inst_23147);

return statearr_23193;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_23194_23221 = state_23171__$1;
(statearr_23194_23221[(1)] = (10));

} else {
var statearr_23195_23222 = state_23171__$1;
(statearr_23195_23222[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (5))){
var _ = (function (){var statearr_23196 = state_23171;
(statearr_23196[(4)] = cljs.core.rest((state_23171[(4)])));

return statearr_23196;
})();
var state_23171__$1 = state_23171;
var ex23191 = (state_23171__$1[(2)]);
var statearr_23197_23223 = state_23171__$1;
(statearr_23197_23223[(5)] = ex23191);


var statearr_23198_23224 = state_23171__$1;
(statearr_23198_23224[(1)] = (4));

(statearr_23198_23224[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (14))){
var inst_23152 = (state_23171[(11)]);
var state_23171__$1 = state_23171;
var statearr_23199_23225 = state_23171__$1;
(statearr_23199_23225[(2)] = inst_23152);

(statearr_23199_23225[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (16))){
var inst_23155 = (state_23171[(2)]);
var inst_23156 = fluree.db.util.async.throw_err(inst_23155);
var state_23171__$1 = state_23171;
var statearr_23200_23226 = state_23171__$1;
(statearr_23200_23226[(2)] = inst_23156);

(statearr_23200_23226[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (10))){
var inst_23147 = (state_23171[(13)]);
var inst_23149 = (permissions.cljs$core$IFn$_invoke$arity$1 ? permissions.cljs$core$IFn$_invoke$arity$1(inst_23147) : permissions.call(null,inst_23147));
var state_23171__$1 = state_23171;
var statearr_23201_23227 = state_23171__$1;
(statearr_23201_23227[(2)] = inst_23149);

(statearr_23201_23227[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (18))){
var state_23171__$1 = state_23171;
var statearr_23202_23228 = state_23171__$1;
(statearr_23202_23228[(2)] = null);

(statearr_23202_23228[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23172 === (8))){
var inst_23142 = (state_23171[(7)]);
var state_23171__$1 = state_23171;
var statearr_23203_23229 = state_23171__$1;
(statearr_23203_23229[(2)] = inst_23142);

(statearr_23203_23229[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0 = (function (){
var statearr_23204 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23204[(0)] = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__);

(statearr_23204[(1)] = (1));

return statearr_23204;
});
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1 = (function (state_23171){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23171);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23205){var ex__2730__auto__ = e23205;
var statearr_23206_23230 = state_23171;
(statearr_23206_23230[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23171[(4)]))){
var statearr_23207_23231 = state_23171;
(statearr_23207_23231[(1)] = cljs.core.first((state_23171[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23232 = state_23171;
state_23171 = G__23232;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__ = function(state_23171){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1.call(this,state_23171);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23208 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23208[(6)] = c__2749__auto__);

return statearr_23208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
});
/**
 * For queries that specify _id as the predicate, we will have a
 *   single subject as a value.
 */
fluree.db.query.subject_crawl.subject.subjects_id_chan = (function fluree$db$query$subject_crawl$subject$subjects_id_chan(db,error_ch,vars,p__23233){
var map__23234 = p__23233;
var map__23234__$1 = cljs.core.__destructure_map(map__23234);
var f_where = map__23234__$1;
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23234__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var return_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var _id_val = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
}
})();
if(cljs.core.truth_(_id_val)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["When using _id as the predicate, a value must be provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f_where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var c__2749__auto___23271 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23254){
var state_val_23255 = (state_23254[(1)]);
if((state_val_23255 === (7))){
var inst_23242 = (state_23254[(7)]);
var inst_23245 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_23242);
var state_23254__$1 = state_23254;
var statearr_23256_23272 = state_23254__$1;
(statearr_23256_23272[(2)] = inst_23245);

(statearr_23256_23272[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23255 === (1))){
var inst_23235 = typeof _id_val === 'number';
var state_23254__$1 = state_23254;
if(cljs.core.truth_(inst_23235)){
var statearr_23257_23273 = state_23254__$1;
(statearr_23257_23273[(1)] = (2));

} else {
var statearr_23258_23274 = state_23254__$1;
(statearr_23258_23274[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23255 === (4))){
var inst_23251 = (state_23254[(2)]);
var inst_23252 = cljs.core.async.close_BANG_(return_ch);
var state_23254__$1 = (function (){var statearr_23259 = state_23254;
(statearr_23259[(8)] = inst_23251);

return statearr_23259;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_23254__$1,inst_23252);
} else {
if((state_val_23255 === (6))){
var inst_23242 = (state_23254[(7)]);
var inst_23242__$1 = (state_23254[(2)]);
var inst_23243 = fluree.db.util.core.exception_QMARK_(inst_23242__$1);
var state_23254__$1 = (function (){var statearr_23260 = state_23254;
(statearr_23260[(7)] = inst_23242__$1);

return statearr_23260;
})();
if(inst_23243){
var statearr_23261_23275 = state_23254__$1;
(statearr_23261_23275[(1)] = (7));

} else {
var statearr_23262_23276 = state_23254__$1;
(statearr_23262_23276[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23255 === (3))){
var inst_23240 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,_id_val);
var state_23254__$1 = state_23254;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23254__$1,(6),inst_23240);
} else {
if((state_val_23255 === (2))){
var state_23254__$1 = state_23254;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23254__$1,(5),return_ch,_id_val);
} else {
if((state_val_23255 === (9))){
var inst_23249 = (state_23254[(2)]);
var state_23254__$1 = state_23254;
var statearr_23263_23277 = state_23254__$1;
(statearr_23263_23277[(2)] = inst_23249);

(statearr_23263_23277[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23255 === (5))){
var inst_23238 = (state_23254[(2)]);
var state_23254__$1 = state_23254;
var statearr_23264_23278 = state_23254__$1;
(statearr_23264_23278[(2)] = inst_23238);

(statearr_23264_23278[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23255 === (8))){
var inst_23242 = (state_23254[(7)]);
var inst_23247 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_23242);
var state_23254__$1 = state_23254;
var statearr_23265_23279 = state_23254__$1;
(statearr_23265_23279[(2)] = inst_23247);

(statearr_23265_23279[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0 = (function (){
var statearr_23266 = [null,null,null,null,null,null,null,null,null];
(statearr_23266[(0)] = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__);

(statearr_23266[(1)] = (1));

return statearr_23266;
});
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1 = (function (state_23254){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23254);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23267){var ex__2730__auto__ = e23267;
var statearr_23268_23280 = state_23254;
(statearr_23268_23280[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23254[(4)]))){
var statearr_23269_23281 = state_23254;
(statearr_23269_23281[(1)] = cljs.core.first((state_23254[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23282 = state_23254;
state_23254 = G__23282;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__ = function(state_23254){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1.call(this,state_23254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23270 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23270[(6)] = c__2749__auto___23271);

return statearr_23270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return return_ch;
});
fluree.db.query.subject_crawl.subject.subj_crawl = (function fluree$db$query$subject_crawl$subject$subj_crawl(p__23283){
var map__23284 = p__23283;
var map__23284__$1 = cljs.core.__destructure_map(map__23284);
var opts = map__23284__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23284__$1,new cljs.core.Keyword(null,"db","db",993250759));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23284__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var f_where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23284__$1,new cljs.core.Keyword(null,"f-where","f-where",-958007776));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23284__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23284__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23284__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23284__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var finish_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23284__$1,new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23351){
var state_val_23352 = (state_23351[(1)]);
if((state_val_23352 === (7))){
var inst_23296 = fluree.db.query.subject_crawl.subject.subjects_chan(db,error_ch,vars,f_where);
var state_23351__$1 = state_23351;
var statearr_23353_23390 = state_23351__$1;
(statearr_23353_23390[(2)] = inst_23296);

(statearr_23353_23390[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (20))){
var inst_23340 = (state_23351[(2)]);
var state_23351__$1 = state_23351;
var statearr_23354_23391 = state_23351__$1;
(statearr_23354_23391[(2)] = inst_23340);

(statearr_23354_23391[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (1))){
var state_23351__$1 = state_23351;
var statearr_23355_23392 = state_23351__$1;
(statearr_23355_23392[(2)] = null);

(statearr_23355_23392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (4))){
var inst_23285 = (state_23351[(2)]);
var state_23351__$1 = state_23351;
var statearr_23356_23393 = state_23351__$1;
(statearr_23356_23393[(2)] = inst_23285);

(statearr_23356_23393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (15))){
var inst_23298 = (state_23351[(7)]);
var inst_23304 = (state_23351[(8)]);
var inst_23309 = (state_23351[(9)]);
var inst_23303 = (state_23351[(10)]);
var inst_23330 = cljs.core.async.close_BANG_(inst_23298);
var inst_23331 = cljs.core.async.close_BANG_(inst_23303);
var inst_23332 = cljs.core.async.close_BANG_(inst_23304);
var inst_23333 = (finish_fn.cljs$core$IFn$_invoke$arity$1 ? finish_fn.cljs$core$IFn$_invoke$arity$1(inst_23309) : finish_fn.call(null,inst_23309));
var state_23351__$1 = (function (){var statearr_23357 = state_23351;
(statearr_23357[(11)] = inst_23330);

(statearr_23357[(12)] = inst_23332);

(statearr_23357[(13)] = inst_23331);

return statearr_23357;
})();
var statearr_23358_23394 = state_23351__$1;
(statearr_23358_23394[(2)] = inst_23333);

(statearr_23358_23394[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (13))){
var inst_23319 = (state_23351[(14)]);
var inst_23328 = (inst_23319 == null);
var state_23351__$1 = state_23351;
if(cljs.core.truth_(inst_23328)){
var statearr_23359_23395 = state_23351__$1;
(statearr_23359_23395[(1)] = (15));

} else {
var statearr_23360_23396 = state_23351__$1;
(statearr_23360_23396[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (6))){
var inst_23294 = fluree.db.query.subject_crawl.subject.subjects_id_chan(db,error_ch,vars,f_where);
var state_23351__$1 = state_23351;
var statearr_23361_23397 = state_23351__$1;
(statearr_23361_23397[(2)] = inst_23294);

(statearr_23361_23397[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (17))){
var inst_23342 = (state_23351[(2)]);
var state_23351__$1 = state_23351;
var statearr_23362_23398 = state_23351__$1;
(statearr_23362_23398[(2)] = inst_23342);

(statearr_23362_23398[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (3))){
var inst_23349 = (state_23351[(2)]);
var state_23351__$1 = state_23351;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23351__$1,inst_23349);
} else {
if((state_val_23352 === (12))){
var inst_23298 = (state_23351[(7)]);
var inst_23304 = (state_23351[(8)]);
var inst_23319 = (state_23351[(14)]);
var inst_23303 = (state_23351[(10)]);
var inst_23323 = cljs.core.async.close_BANG_(inst_23298);
var inst_23324 = cljs.core.async.close_BANG_(inst_23303);
var inst_23325 = cljs.core.async.close_BANG_(inst_23304);
var inst_23326 = (function(){throw inst_23319})();
var state_23351__$1 = (function (){var statearr_23363 = state_23351;
(statearr_23363[(15)] = inst_23324);

(statearr_23363[(16)] = inst_23323);

(statearr_23363[(17)] = inst_23325);

return statearr_23363;
})();
var statearr_23364_23399 = state_23351__$1;
(statearr_23364_23399[(2)] = inst_23326);

(statearr_23364_23399[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (2))){
var _ = (function (){var statearr_23365 = state_23351;
(statearr_23365[(4)] = cljs.core.cons((5),(state_23351[(4)])));

return statearr_23365;
})();
var inst_23291 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where);
var inst_23292 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23291);
var state_23351__$1 = state_23351;
if(inst_23292){
var statearr_23366_23400 = state_23351__$1;
(statearr_23366_23400[(1)] = (6));

} else {
var statearr_23367_23401 = state_23351__$1;
(statearr_23367_23401[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (19))){
var state_23351__$1 = state_23351;
var statearr_23368_23402 = state_23351__$1;
(statearr_23368_23402[(2)] = null);

(statearr_23368_23402[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (11))){
var inst_23318 = (state_23351[(2)]);
var inst_23319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23318,(0),null);
var inst_23320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23318,(1),null);
var inst_23321 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_23320,error_ch);
var state_23351__$1 = (function (){var statearr_23370 = state_23351;
(statearr_23370[(14)] = inst_23319);

return statearr_23370;
})();
if(inst_23321){
var statearr_23371_23403 = state_23351__$1;
(statearr_23371_23403[(1)] = (12));

} else {
var statearr_23372_23404 = state_23351__$1;
(statearr_23372_23404[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (9))){
var inst_23304 = (state_23351[(8)]);
var inst_23314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23315 = [error_ch,inst_23304];
var inst_23316 = (new cljs.core.PersistentVector(null,2,(5),inst_23314,inst_23315,null));
var state_23351__$1 = state_23351;
return cljs.core.async.ioc_alts_BANG_(state_23351__$1,(11),inst_23316);
} else {
if((state_val_23352 === (5))){
var _ = (function (){var statearr_23373 = state_23351;
(statearr_23373[(4)] = cljs.core.rest((state_23351[(4)])));

return statearr_23373;
})();
var state_23351__$1 = state_23351;
var ex23369 = (state_23351__$1[(2)]);
var statearr_23374_23405 = state_23351__$1;
(statearr_23374_23405[(5)] = ex23369);


if((ex23369 instanceof Error)){
var statearr_23375_23406 = state_23351__$1;
(statearr_23375_23406[(1)] = (4));

(statearr_23375_23406[(5)] = null);

} else {
throw ex23369;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (14))){
var inst_23344 = (state_23351[(2)]);
var state_23351__$1 = state_23351;
var statearr_23376_23407 = state_23351__$1;
(statearr_23376_23407[(2)] = inst_23344);

(statearr_23376_23407[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (16))){
var state_23351__$1 = state_23351;
var statearr_23377_23408 = state_23351__$1;
(statearr_23377_23408[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (10))){
var inst_23346 = (state_23351[(2)]);
var _ = (function (){var statearr_23379 = state_23351;
(statearr_23379[(4)] = cljs.core.rest((state_23351[(4)])));

return statearr_23379;
})();
var state_23351__$1 = state_23351;
var statearr_23380_23409 = state_23351__$1;
(statearr_23380_23409[(2)] = inst_23346);

(statearr_23380_23409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (18))){
var inst_23319 = (state_23351[(14)]);
var inst_23309 = (state_23351[(9)]);
var inst_23336 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23309,inst_23319);
var inst_23309__$1 = inst_23336;
var state_23351__$1 = (function (){var statearr_23381 = state_23351;
(statearr_23381[(9)] = inst_23309__$1);

return statearr_23381;
})();
var statearr_23382_23410 = state_23351__$1;
(statearr_23382_23410[(2)] = null);

(statearr_23382_23410[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23352 === (8))){
var inst_23298 = (state_23351[(7)]);
var inst_23304 = (state_23351[(8)]);
var inst_23303 = (state_23351[(10)]);
var inst_23298__$1 = (state_23351[(2)]);
var inst_23299 = fluree.db.query.subject_crawl.subject.flakes_xf(opts);
var inst_23300 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_23301 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_23302 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23300,inst_23301);
var inst_23303__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((32),inst_23302);
var inst_23304__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_23305 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_23303__$1,inst_23299,inst_23298__$1);
var inst_23306 = fluree.db.query.subject_crawl.common.result_af(opts);
var inst_23307 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_23304__$1,inst_23306,inst_23303__$1);
var inst_23308 = cljs.core.PersistentVector.EMPTY;
var inst_23309 = inst_23308;
var state_23351__$1 = (function (){var statearr_23383 = state_23351;
(statearr_23383[(7)] = inst_23298__$1);

(statearr_23383[(18)] = inst_23307);

(statearr_23383[(8)] = inst_23304__$1);

(statearr_23383[(19)] = inst_23305);

(statearr_23383[(9)] = inst_23309);

(statearr_23383[(10)] = inst_23303__$1);

return statearr_23383;
})();
var statearr_23384_23411 = state_23351__$1;
(statearr_23384_23411[(2)] = null);

(statearr_23384_23411[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0 = (function (){
var statearr_23385 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23385[(0)] = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__);

(statearr_23385[(1)] = (1));

return statearr_23385;
});
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1 = (function (state_23351){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23351);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23386){var ex__2730__auto__ = e23386;
var statearr_23387_23412 = state_23351;
(statearr_23387_23412[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23351[(4)]))){
var statearr_23388_23413 = state_23351;
(statearr_23388_23413[(1)] = cljs.core.first((state_23351[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23414 = state_23351;
state_23351 = G__23414;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__ = function(state_23351){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1.call(this,state_23351);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23389 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23389[(6)] = c__2749__auto__);

return statearr_23389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
