// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
goog.require('fluree.db.query.subject_crawl.core');
goog.require('fluree.db.query.fql_resp');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__23824 = arguments.length;
switch (G__23824) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__23825 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__23825) : f.call(null,G__23825));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__23826 = cljs.core._deref(vol);
var G__23827 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__23826,G__23827) : f.call(null,G__23826,G__23827));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__23828 = cljs.core._deref(vol);
var G__23829 = arg1;
var G__23830 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__23828,G__23829,G__23830) : f.call(null,G__23828,G__23829,G__23830));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__23831 = cljs.core._deref(vol);
var G__23832 = arg1;
var G__23833 = arg2;
var G__23834 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__23831,G__23832,G__23833,G__23834) : f.call(null,G__23831,G__23832,G__23833,G__23834));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__23837 = arguments.length;
switch (G__23837) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__23839 = null;
var G__23839__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__23839__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__23839__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__23839 = function(result,flake){
switch(arguments.length){
case 0:
return G__23839__0.call(this);
case 1:
return G__23839__1.call(this,result);
case 2:
return G__23839__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23839.cljs$core$IFn$_invoke$arity$0 = G__23839__0;
G__23839.cljs$core$IFn$_invoke$arity$1 = G__23839__1;
G__23839.cljs$core$IFn$_invoke$arity$2 = G__23839__2;
return G__23839;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__23840_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__23840_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__23844 = vars;
var vec__23845 = G__23844;
var seq__23846 = cljs.core.seq(vec__23845);
var first__23847 = cljs.core.first(seq__23846);
var seq__23846__$1 = cljs.core.next(seq__23846);
var var$ = first__23847;
var r = seq__23846__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__23844__$1 = G__23844;
var all_vars__$1 = all_vars;
while(true){
var vec__23852 = G__23844__$1;
var seq__23853 = cljs.core.seq(vec__23852);
var first__23854 = cljs.core.first(seq__23853);
var seq__23853__$1 = cljs.core.next(seq__23853);
var var$__$1 = first__23854;
var r__$1 = seq__23853__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__23855 = cljs.core.set(all_vars__$2);
return (fexpr__23855.cljs$core$IFn$_invoke$arity$1 ? fexpr__23855.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__23855.call(null,var$__$1));
})())){
var G__23856 = r__$1;
var G__23857 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__23844__$1 = G__23856;
all_vars__$1 = G__23857;
continue;
} else {
var G__23858 = r__$1;
var G__23859 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__23844__$1 = G__23858;
all_vars__$1 = G__23859;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__23860){
var vec__23861 = p__23860;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23861,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23861,(1),null);
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23875){
var state_val_23876 = (state_23875[(1)]);
if((state_val_23876 === (1))){
var inst_23864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23865 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_23866 = [query_map,_id,query_opts];
var inst_23867 = cljs.core.PersistentHashMap.fromArrays(inst_23865,inst_23866);
var inst_23868 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_23867) : fluree.db.query.fql.query.call(null,db,inst_23867));
var state_23875__$1 = (function (){var statearr_23877 = state_23875;
(statearr_23877[(7)] = inst_23864);

return statearr_23877;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23875__$1,(2),inst_23868);
} else {
if((state_val_23876 === (2))){
var inst_23864 = (state_23875[(7)]);
var inst_23870 = (state_23875[(2)]);
var inst_23871 = fluree.db.util.async.throw_err(inst_23870);
var inst_23872 = [tuple_index,inst_23871];
var inst_23873 = (new cljs.core.PersistentVector(null,2,(5),inst_23864,inst_23872,null));
var state_23875__$1 = state_23875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23875__$1,inst_23873);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0 = (function (){
var statearr_23878 = [null,null,null,null,null,null,null,null];
(statearr_23878[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2727__auto__);

(statearr_23878[(1)] = (1));

return statearr_23878;
});
var fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1 = (function (state_23875){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23875);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23879){var ex__2730__auto__ = e23879;
var statearr_23880_23883 = state_23875;
(statearr_23880_23883[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23875[(4)]))){
var statearr_23881_23884 = state_23875;
(statearr_23881_23884[(1)] = cljs.core.first((state_23875[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23885 = state_23875;
state_23875 = G__23885;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__ = function(state_23875){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1.call(this,state_23875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2727__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2727__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23882 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23882[(6)] = c__2749__auto__);

return statearr_23882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__23886 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23886,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23886,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23949){
var state_val_23950 = (state_23949[(1)]);
if((state_val_23950 === (7))){
var inst_23944 = (state_23949[(2)]);
var _ = (function (){var statearr_23951 = state_23949;
(statearr_23951[(4)] = cljs.core.rest((state_23949[(4)])));

return statearr_23951;
})();
var state_23949__$1 = state_23949;
var statearr_23952_24043 = state_23949__$1;
(statearr_23952_24043[(2)] = inst_23944);

(statearr_23952_24043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (20))){
var inst_23935 = (state_23949[(2)]);
var state_23949__$1 = state_23949;
var statearr_23953_24044 = state_23949__$1;
(statearr_23953_24044[(2)] = inst_23935);

(statearr_23953_24044[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (1))){
var state_23949__$1 = state_23949;
var statearr_23954_24045 = state_23949__$1;
(statearr_23954_24045[(2)] = null);

(statearr_23954_24045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (4))){
var inst_23891 = (state_23949[(2)]);
var state_23949__$1 = state_23949;
var statearr_23955_24046 = state_23949__$1;
(statearr_23955_24046[(2)] = inst_23891);

(statearr_23955_24046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (15))){
var inst_23911 = (state_23949[(7)]);
var inst_23920 = cljs.core.second(inst_23911);
var inst_23921 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_23920);
var inst_23922 = (inst_23921 > max_fuel);
var state_23949__$1 = state_23949;
if(cljs.core.truth_(inst_23922)){
var statearr_23956_24047 = state_23949__$1;
(statearr_23956_24047[(1)] = (18));

} else {
var statearr_23957_24048 = state_23949__$1;
(statearr_23957_24048[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (13))){
var state_23949__$1 = state_23949;
var statearr_23958_24049 = state_23949__$1;
(statearr_23958_24049[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (6))){
var inst_23899 = (state_23949[(8)]);
var state_23949__$1 = state_23949;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23949__$1,(8),inst_23899);
} else {
if((state_val_23950 === (17))){
var inst_23938 = (state_23949[(2)]);
var state_23949__$1 = state_23949;
var statearr_23960_24050 = state_23949__$1;
(statearr_23960_24050[(2)] = inst_23938);

(statearr_23960_24050[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (3))){
var inst_23947 = (state_23949[(2)]);
var state_23949__$1 = state_23949;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23949__$1,inst_23947);
} else {
if((state_val_23950 === (12))){
var inst_23911 = (state_23949[(7)]);
var inst_23900 = (state_23949[(9)]);
var inst_23917 = (inst_23900.cljs$core$IFn$_invoke$arity$0 ? inst_23900.cljs$core$IFn$_invoke$arity$0() : inst_23900.call(null));
var state_23949__$1 = (function (){var statearr_23961 = state_23949;
(statearr_23961[(10)] = inst_23917);

return statearr_23961;
})();
var statearr_23962_24051 = state_23949__$1;
(statearr_23962_24051[(2)] = inst_23911);

(statearr_23962_24051[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (2))){
var inst_23899 = (state_23949[(8)]);
var inst_23900 = (state_23949[(9)]);
var _ = (function (){var statearr_23963 = state_23949;
(statearr_23963[(4)] = cljs.core.cons((5),(state_23949[(4)])));

return statearr_23963;
})();
var inst_23897 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_23898 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_23899__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_23900__$1 = (function (){var expandMaps = inst_23897;
var queue_ch = inst_23898;
var res_ch = inst_23899__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_23901 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_23902 = cljs.core.volatile_BANG_((0));
var inst_23903 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23901,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_23902);
var inst_23904 = (function (){var expandMaps = inst_23897;
var queue_ch = inst_23898;
var res_ch = inst_23899__$1;
var stop_BANG_ = inst_23900__$1;
var opts_STAR_ = inst_23903;
return (function (tuple_res,port){
var c__2749__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23996){
var state_val_23997 = (state_23996[(1)]);
if((state_val_23997 === (7))){
var state_23996__$1 = state_23996;
var statearr_23998_24052 = state_23996__$1;
(statearr_23998_24052[(2)] = tuple_res);

(statearr_23998_24052[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23997 === (1))){
var state_23996__$1 = state_23996;
var statearr_23999_24053 = state_23996__$1;
(statearr_23999_24053[(2)] = null);

(statearr_23999_24053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23997 === (4))){
var inst_23964 = (state_23996[(2)]);
var inst_23965 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_23964);
var inst_23966 = cljs.core.async.close_BANG_(port);
var state_23996__$1 = (function (){var statearr_24000 = state_23996;
(statearr_24000[(7)] = inst_23965);

return statearr_24000;
})();
var statearr_24001_24054 = state_23996__$1;
(statearr_24001_24054[(2)] = inst_23966);

(statearr_24001_24054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23997 === (6))){
var inst_23973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23974 = [tuple_res];
var inst_23975 = (new cljs.core.PersistentVector(null,1,(5),inst_23973,inst_23974,null));
var state_23996__$1 = state_23996;
var statearr_24002_24055 = state_23996__$1;
(statearr_24002_24055[(2)] = inst_23975);

(statearr_24002_24055[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23997 === (3))){
var inst_23994 = (state_23996[(2)]);
var state_23996__$1 = state_23996;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23996__$1,inst_23994);
} else {
if((state_val_23997 === (2))){
var ___$1 = (function (){var statearr_24004 = state_23996;
(statearr_24004[(4)] = cljs.core.cons((5),(state_23996[(4)])));

return statearr_24004;
})();
var state_23996__$1 = state_23996;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24005_24056 = state_23996__$1;
(statearr_24005_24056[(1)] = (6));

} else {
var statearr_24006_24057 = state_23996__$1;
(statearr_24006_24057[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23997 === (9))){
var inst_23980 = (state_23996[(8)]);
var inst_23978 = (state_23996[(9)]);
var inst_23987 = (state_23996[(2)]);
var inst_23988 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_23978,inst_23987);
var inst_23989 = (inst_23980.cljs$core$IFn$_invoke$arity$1 ? inst_23980.cljs$core$IFn$_invoke$arity$1(inst_23988) : inst_23980.call(null,inst_23988));
var inst_23990 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_23989);
var inst_23991 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_24007 = state_23996;
(statearr_24007[(4)] = cljs.core.rest((state_23996[(4)])));

return statearr_24007;
})();
var state_23996__$1 = (function (){var statearr_24008 = state_23996;
(statearr_24008[(10)] = inst_23990);

return statearr_24008;
})();
var statearr_24009_24058 = state_23996__$1;
(statearr_24009_24058[(2)] = inst_23991);

(statearr_24009_24058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23997 === (5))){
var ___$1 = (function (){var statearr_24010 = state_23996;
(statearr_24010[(4)] = cljs.core.rest((state_23996[(4)])));

return statearr_24010;
})();
var state_23996__$1 = state_23996;
var ex24003 = (state_23996__$1[(2)]);
var statearr_24011_24059 = state_23996__$1;
(statearr_24011_24059[(5)] = ex24003);


var statearr_24012_24060 = state_23996__$1;
(statearr_24012_24060[(1)] = (4));

(statearr_24012_24060[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23997 === (8))){
var inst_23978 = (state_23996[(9)]);
var inst_23978__$1 = (state_23996[(2)]);
var inst_23979 = cljs.core.volatile_BANG_((0));
var inst_23980 = (function (){var tuple_res_SINGLEQUOTE_ = inst_23978__$1;
var query_fuel = inst_23979;
return (function (p1__23890_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__23890_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__23890_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_23981 = cljs.core.PersistentVector.EMPTY;
var inst_23982 = (function (){var tuple_res_SINGLEQUOTE_ = inst_23978__$1;
var query_fuel = inst_23979;
return (function (p1__23889_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__23889_SHARP_);
});
})();
var inst_23983 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_23982,expandMaps);
var inst_23984 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_23983);
var inst_23985 = cljs.core.async.into(inst_23981,inst_23984);
var state_23996__$1 = (function (){var statearr_24013 = state_23996;
(statearr_24013[(8)] = inst_23980);

(statearr_24013[(9)] = inst_23978__$1);

return statearr_24013;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23996__$1,(9),inst_23985);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0 = (function (){
var statearr_24014 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24014[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__);

(statearr_24014[(1)] = (1));

return statearr_24014;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1 = (function (state_23996){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23996);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24015){var ex__2730__auto__ = e24015;
var statearr_24016_24061 = state_23996;
(statearr_24016_24061[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23996[(4)]))){
var statearr_24017_24062 = state_23996;
(statearr_24017_24062[(1)] = cljs.core.first((state_23996[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24063 = state_23996;
state_23996 = G__24063;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = function(state_23996){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1.call(this,state_23996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24018 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24018[(6)] = c__2749__auto____$1);

return statearr_24018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto____$1;
});
})();
var inst_23905 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_23898,tuples_res);
var inst_23906 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_23899__$1,inst_23904,inst_23898);
var inst_23907 = cljs.core.PersistentVector.EMPTY;
var inst_23908 = inst_23907;
var state_23949__$1 = (function (){var statearr_24019 = state_23949;
(statearr_24019[(8)] = inst_23899__$1);

(statearr_24019[(11)] = inst_23905);

(statearr_24019[(12)] = inst_23906);

(statearr_24019[(9)] = inst_23900__$1);

(statearr_24019[(13)] = inst_23908);

return statearr_24019;
})();
var statearr_24020_24064 = state_23949__$1;
(statearr_24020_24064[(2)] = null);

(statearr_24020_24064[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (19))){
var inst_23911 = (state_23949[(7)]);
var inst_23908 = (state_23949[(13)]);
var inst_23931 = cljs.core.first(inst_23911);
var inst_23932 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23908,inst_23931);
var inst_23908__$1 = inst_23932;
var state_23949__$1 = (function (){var statearr_24021 = state_23949;
(statearr_24021[(13)] = inst_23908__$1);

return statearr_24021;
})();
var statearr_24022_24065 = state_23949__$1;
(statearr_24022_24065[(2)] = null);

(statearr_24022_24065[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (11))){
var inst_23942 = (state_23949[(2)]);
var state_23949__$1 = state_23949;
var statearr_24024_24066 = state_23949__$1;
(statearr_24024_24066[(2)] = inst_23942);

(statearr_24024_24066[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (9))){
var inst_23908 = (state_23949[(13)]);
var state_23949__$1 = state_23949;
var statearr_24025_24067 = state_23949__$1;
(statearr_24025_24067[(2)] = inst_23908);

(statearr_24025_24067[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (5))){
var _ = (function (){var statearr_24026 = state_23949;
(statearr_24026[(4)] = cljs.core.rest((state_23949[(4)])));

return statearr_24026;
})();
var state_23949__$1 = state_23949;
var ex24023 = (state_23949__$1[(2)]);
var statearr_24027_24068 = state_23949__$1;
(statearr_24027_24068[(5)] = ex24023);


if((ex24023 instanceof Error)){
var statearr_24028_24069 = state_23949__$1;
(statearr_24028_24069[(1)] = (4));

(statearr_24028_24069[(5)] = null);

} else {
throw ex24023;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (14))){
var inst_23940 = (state_23949[(2)]);
var state_23949__$1 = state_23949;
var statearr_24029_24070 = state_23949__$1;
(statearr_24029_24070[(2)] = inst_23940);

(statearr_24029_24070[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (16))){
var state_23949__$1 = state_23949;
var statearr_24030_24071 = state_23949__$1;
(statearr_24030_24071[(2)] = null);

(statearr_24030_24071[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (10))){
var inst_23911 = (state_23949[(7)]);
var inst_23915 = fluree.db.util.core.exception_QMARK_(inst_23911);
var state_23949__$1 = state_23949;
if(inst_23915){
var statearr_24031_24072 = state_23949__$1;
(statearr_24031_24072[(1)] = (12));

} else {
var statearr_24032_24073 = state_23949__$1;
(statearr_24032_24073[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (18))){
var inst_23900 = (state_23949[(9)]);
var inst_23924 = (inst_23900.cljs$core$IFn$_invoke$arity$0 ? inst_23900.cljs$core$IFn$_invoke$arity$0() : inst_23900.call(null));
var inst_23925 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_23926 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_23927 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_23928 = cljs.core.PersistentHashMap.fromArrays(inst_23926,inst_23927);
var inst_23929 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_23925,inst_23928);
var state_23949__$1 = (function (){var statearr_24033 = state_23949;
(statearr_24033[(14)] = inst_23924);

return statearr_24033;
})();
var statearr_24034_24074 = state_23949__$1;
(statearr_24034_24074[(2)] = inst_23929);

(statearr_24034_24074[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23950 === (8))){
var inst_23911 = (state_23949[(7)]);
var inst_23911__$1 = (state_23949[(2)]);
var inst_23912 = (inst_23911__$1 == null);
var state_23949__$1 = (function (){var statearr_24035 = state_23949;
(statearr_24035[(7)] = inst_23911__$1);

return statearr_24035;
})();
if(cljs.core.truth_(inst_23912)){
var statearr_24036_24075 = state_23949__$1;
(statearr_24036_24075[(1)] = (9));

} else {
var statearr_24037_24076 = state_23949__$1;
(statearr_24037_24076[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0 = (function (){
var statearr_24038 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24038[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__);

(statearr_24038[(1)] = (1));

return statearr_24038;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1 = (function (state_23949){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23949);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24039){var ex__2730__auto__ = e24039;
var statearr_24040_24077 = state_23949;
(statearr_24040_24077[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23949[(4)]))){
var statearr_24041_24078 = state_23949;
(statearr_24041_24078[(1)] = cljs.core.first((state_23949[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24079 = state_23949;
state_23949 = G__24079;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__ = function(state_23949){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1.call(this,state_23949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24042 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24042[(6)] = c__2749__auto__);

return statearr_24042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__24080 = select;
var map__24080__$1 = cljs.core.__destructure_map(map__24080);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24080__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24080__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24080__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4253__auto__ = as;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__24083 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24083,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24083,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24083,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__24081_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24081_SHARP_,compare_idx));
}):(function (p1__24082_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24082_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24088 = arguments.length;
switch (G__24088) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__24089,p__24090,group_limit,opts){
var map__24091 = p__24089;
var map__24091__$1 = cljs.core.__destructure_map(map__24091);
var res = map__24091__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24091__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24092 = p__24090;
var map__24092__$1 = cljs.core.__destructure_map(map__24092);
var select_spec = map__24092__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24092__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24092__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24092__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24092__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24092__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24092__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24092__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24092__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24092__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24092__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24229){
var state_val_24230 = (state_24229[(1)]);
if((state_val_24230 === (7))){
var inst_24099 = (state_24229[(7)]);
var state_24229__$1 = state_24229;
var statearr_24231_24333 = state_24229__$1;
(statearr_24231_24333[(2)] = inst_24099);

(statearr_24231_24333[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (59))){
var inst_24222 = (state_24229[(2)]);
var state_24229__$1 = state_24229;
var statearr_24232_24334 = state_24229__$1;
(statearr_24232_24334[(2)] = inst_24222);

(statearr_24232_24334[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (20))){
var inst_24138 = (state_24229[(8)]);
var inst_24135 = (state_24229[(9)]);
var inst_24134 = (state_24229[(2)]);
var inst_24135__$1 = cljs.core.__destructure_map(inst_24134);
var inst_24136 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24135__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24137 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24135__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24138__$1 = offset;
var state_24229__$1 = (function (){var statearr_24233 = state_24229;
(statearr_24233[(8)] = inst_24138__$1);

(statearr_24233[(10)] = inst_24137);

(statearr_24233[(9)] = inst_24135__$1);

(statearr_24233[(11)] = inst_24136);

return statearr_24233;
})();
if(cljs.core.truth_(inst_24138__$1)){
var statearr_24234_24335 = state_24229__$1;
(statearr_24234_24335[(1)] = (21));

} else {
var statearr_24235_24336 = state_24229__$1;
(statearr_24235_24336[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (58))){
var inst_24214 = (state_24229[(12)]);
var state_24229__$1 = state_24229;
var statearr_24236_24337 = state_24229__$1;
(statearr_24236_24337[(2)] = inst_24214);

(statearr_24236_24337[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (60))){
var inst_24218 = (state_24229[(2)]);
var inst_24219 = fluree.db.util.async.throw_err(inst_24218);
var state_24229__$1 = state_24229;
var statearr_24237_24338 = state_24229__$1;
(statearr_24237_24338[(2)] = inst_24219);

(statearr_24237_24338[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (27))){
var inst_24150 = cljs.core.not(inVector_QMARK_);
var state_24229__$1 = state_24229;
var statearr_24238_24339 = state_24229__$1;
(statearr_24238_24339[(2)] = inst_24150);

(statearr_24238_24339[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (1))){
var state_24229__$1 = state_24229;
var statearr_24239_24340 = state_24229__$1;
(statearr_24239_24340[(2)] = null);

(statearr_24239_24340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (24))){
var state_24229__$1 = state_24229;
var statearr_24240_24341 = state_24229__$1;
(statearr_24240_24341[(2)] = offset);

(statearr_24240_24341[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (55))){
var inst_24208 = (state_24229[(13)]);
var state_24229__$1 = state_24229;
var statearr_24241_24342 = state_24229__$1;
(statearr_24241_24342[(2)] = inst_24208);

(statearr_24241_24342[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (39))){
var inst_24176 = (state_24229[(14)]);
var inst_24178 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_24179 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24176,inst_24178);
var state_24229__$1 = state_24229;
var statearr_24242_24343 = state_24229__$1;
(statearr_24242_24343[(2)] = inst_24179);

(statearr_24242_24343[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (46))){
var inst_24188 = (state_24229[(15)]);
var state_24229__$1 = state_24229;
var statearr_24243_24344 = state_24229__$1;
(statearr_24243_24344[(2)] = inst_24188);

(statearr_24243_24344[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (4))){
var inst_24093 = (state_24229[(2)]);
var state_24229__$1 = state_24229;
var statearr_24244_24345 = state_24229__$1;
(statearr_24244_24345[(2)] = inst_24093);

(statearr_24244_24345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (54))){
var inst_24208 = (state_24229[(13)]);
var inst_24202 = (state_24229[(16)]);
var inst_24210 = cljs.core.PersistentVector.EMPTY;
var inst_24211 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_24210,inst_24202,inst_24208);
var state_24229__$1 = state_24229;
var statearr_24245_24346 = state_24229__$1;
(statearr_24245_24346[(2)] = inst_24211);

(statearr_24245_24346[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (15))){
var inst_24120 = (state_24229[(17)]);
var inst_24122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24123 = [inst_24120];
var inst_24124 = (new cljs.core.PersistentVector(null,1,(5),inst_24122,inst_24123,null));
var state_24229__$1 = state_24229;
var statearr_24246_24347 = state_24229__$1;
(statearr_24246_24347[(2)] = inst_24124);

(statearr_24246_24347[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (48))){
var inst_24137 = (state_24229[(10)]);
var inst_24135 = (state_24229[(9)]);
var inst_24194 = (state_24229[(18)]);
var inst_24153 = (state_24229[(19)]);
var inst_24147 = (state_24229[(20)]);
var inst_24158 = (state_24229[(21)]);
var inst_24136 = (state_24229[(11)]);
var inst_24196 = (function (){var map__24129 = inst_24135;
var headers = inst_24136;
var tuples = inst_24137;
var offset_SINGLEQUOTE_ = inst_24147;
var single_result_QMARK_ = inst_24153;
var pp_keys = inst_24158;
var G__24159 = inst_24194;
return (function (p1__24086_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__24086_SHARP_);
});
})();
var inst_24197 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_24196);
var inst_24198 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24194,inst_24197);
var state_24229__$1 = state_24229;
var statearr_24247_24348 = state_24229__$1;
(statearr_24247_24348[(2)] = inst_24198);

(statearr_24247_24348[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (50))){
var inst_24201 = (state_24229[(2)]);
var inst_24202 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_24201);
var state_24229__$1 = (function (){var statearr_24248 = state_24229;
(statearr_24248[(16)] = inst_24202);

return statearr_24248;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24249_24349 = state_24229__$1;
(statearr_24249_24349[(1)] = (51));

} else {
var statearr_24250_24350 = state_24229__$1;
(statearr_24250_24350[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (21))){
var inst_24140 = cljs.core.not(groupBy);
var state_24229__$1 = state_24229;
var statearr_24251_24351 = state_24229__$1;
(statearr_24251_24351[(2)] = inst_24140);

(statearr_24251_24351[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (31))){
var state_24229__$1 = state_24229;
var statearr_24252_24352 = state_24229__$1;
(statearr_24252_24352[(2)] = null);

(statearr_24252_24352[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (32))){
var inst_24153 = (state_24229[(19)]);
var inst_24136 = (state_24229[(11)]);
var inst_24158 = (state_24229[(2)]);
var inst_24160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24161 = fluree.db.query.fql.select_tuples_fn(inst_24136,vars,select);
var inst_24162 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_24161);
var inst_24163 = [inst_24162];
var inst_24164 = (new cljs.core.PersistentVector(null,1,(5),inst_24160,inst_24163,null));
var state_24229__$1 = (function (){var statearr_24253 = state_24229;
(statearr_24253[(22)] = inst_24164);

(statearr_24253[(21)] = inst_24158);

return statearr_24253;
})();
if(cljs.core.truth_(inst_24153)){
var statearr_24254_24353 = state_24229__$1;
(statearr_24254_24353[(1)] = (33));

} else {
var statearr_24255_24354 = state_24229__$1;
(statearr_24255_24354[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (40))){
var inst_24176 = (state_24229[(14)]);
var state_24229__$1 = state_24229;
var statearr_24256_24355 = state_24229__$1;
(statearr_24256_24355[(2)] = inst_24176);

(statearr_24256_24355[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (56))){
var inst_24214 = (state_24229[(2)]);
var state_24229__$1 = (function (){var statearr_24257 = state_24229;
(statearr_24257[(12)] = inst_24214);

return statearr_24257;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24258_24356 = state_24229__$1;
(statearr_24258_24356[(1)] = (57));

} else {
var statearr_24259_24357 = state_24229__$1;
(statearr_24259_24357[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (33))){
var inst_24164 = (state_24229[(22)]);
var inst_24166 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_24167 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24164,inst_24166);
var state_24229__$1 = state_24229;
var statearr_24260_24358 = state_24229__$1;
(statearr_24260_24358[(2)] = inst_24167);

(statearr_24260_24358[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (13))){
var inst_24109 = (state_24229[(23)]);
var state_24229__$1 = state_24229;
var statearr_24261_24359 = state_24229__$1;
(statearr_24261_24359[(2)] = inst_24109);

(statearr_24261_24359[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (22))){
var inst_24138 = (state_24229[(8)]);
var state_24229__$1 = state_24229;
var statearr_24262_24360 = state_24229__$1;
(statearr_24262_24360[(2)] = inst_24138);

(statearr_24262_24360[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (36))){
var inst_24170 = (state_24229[(24)]);
var inst_24172 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_24173 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24170,inst_24172);
var state_24229__$1 = state_24229;
var statearr_24263_24361 = state_24229__$1;
(statearr_24263_24361[(2)] = inst_24173);

(statearr_24263_24361[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (41))){
var inst_24147 = (state_24229[(20)]);
var inst_24182 = (state_24229[(2)]);
var state_24229__$1 = (function (){var statearr_24264 = state_24229;
(statearr_24264[(25)] = inst_24182);

return statearr_24264;
})();
if(cljs.core.truth_(inst_24147)){
var statearr_24265_24362 = state_24229__$1;
(statearr_24265_24362[(1)] = (42));

} else {
var statearr_24266_24363 = state_24229__$1;
(statearr_24266_24363[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (43))){
var inst_24182 = (state_24229[(25)]);
var state_24229__$1 = state_24229;
var statearr_24267_24364 = state_24229__$1;
(statearr_24267_24364[(2)] = inst_24182);

(statearr_24267_24364[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (29))){
var inst_24153 = (state_24229[(2)]);
var state_24229__$1 = (function (){var statearr_24268 = state_24229;
(statearr_24268[(19)] = inst_24153);

return statearr_24268;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24269_24365 = state_24229__$1;
(statearr_24269_24365[(1)] = (30));

} else {
var statearr_24270_24366 = state_24229__$1;
(statearr_24270_24366[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (44))){
var inst_24188 = (state_24229[(2)]);
var state_24229__$1 = (function (){var statearr_24271 = state_24229;
(statearr_24271[(15)] = inst_24188);

return statearr_24271;
})();
if(cljs.core.truth_(group_limit)){
var statearr_24272_24367 = state_24229__$1;
(statearr_24272_24367[(1)] = (45));

} else {
var statearr_24273_24368 = state_24229__$1;
(statearr_24273_24368[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (6))){
var inst_24101 = cljs.core.count(select);
var inst_24102 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_24101);
var state_24229__$1 = state_24229;
var statearr_24274_24369 = state_24229__$1;
(statearr_24274_24369[(2)] = inst_24102);

(statearr_24274_24369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (28))){
var inst_24148 = (state_24229[(26)]);
var state_24229__$1 = state_24229;
var statearr_24275_24370 = state_24229__$1;
(statearr_24275_24370[(2)] = inst_24148);

(statearr_24275_24370[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (51))){
var inst_24137 = (state_24229[(10)]);
var inst_24136 = (state_24229[(11)]);
var inst_24205 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_24136,orderBy,inst_24137);
var state_24229__$1 = state_24229;
var statearr_24276_24371 = state_24229__$1;
(statearr_24276_24371[(2)] = inst_24205);

(statearr_24276_24371[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (25))){
var state_24229__$1 = state_24229;
var statearr_24277_24372 = state_24229__$1;
(statearr_24277_24372[(2)] = null);

(statearr_24277_24372[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (34))){
var inst_24164 = (state_24229[(22)]);
var state_24229__$1 = state_24229;
var statearr_24278_24373 = state_24229__$1;
(statearr_24278_24373[(2)] = inst_24164);

(statearr_24278_24373[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (17))){
var inst_24127 = (state_24229[(2)]);
var state_24229__$1 = state_24229;
var statearr_24279_24374 = state_24229__$1;
(statearr_24279_24374[(2)] = inst_24127);

(statearr_24279_24374[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (3))){
var inst_24227 = (state_24229[(2)]);
var state_24229__$1 = state_24229;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24229__$1,inst_24227);
} else {
if((state_val_24230 === (12))){
var inst_24109 = (state_24229[(23)]);
var inst_24111 = cljs.core.first(select);
var inst_24112 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24111);
var inst_24113 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24112);
var inst_24114 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_24113,(1));
var inst_24115 = [inst_24114];
var inst_24116 = [inst_24109];
var inst_24117 = cljs.core.PersistentHashMap.fromArrays(inst_24115,inst_24116);
var state_24229__$1 = state_24229;
var statearr_24280_24375 = state_24229__$1;
(statearr_24280_24375[(2)] = inst_24117);

(statearr_24280_24375[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (2))){
var inst_24099 = (state_24229[(7)]);
var _ = (function (){var statearr_24281 = state_24229;
(statearr_24281[(4)] = cljs.core.cons((5),(state_24229[(4)])));

return statearr_24281;
})();
var inst_24099__$1 = aggregates;
var state_24229__$1 = (function (){var statearr_24282 = state_24229;
(statearr_24282[(7)] = inst_24099__$1);

return statearr_24282;
})();
if(cljs.core.truth_(inst_24099__$1)){
var statearr_24283_24376 = state_24229__$1;
(statearr_24283_24376[(1)] = (6));

} else {
var statearr_24284_24377 = state_24229__$1;
(statearr_24284_24377[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (23))){
var inst_24143 = (state_24229[(2)]);
var state_24229__$1 = state_24229;
if(cljs.core.truth_(inst_24143)){
var statearr_24285_24378 = state_24229__$1;
(statearr_24285_24378[(1)] = (24));

} else {
var statearr_24286_24379 = state_24229__$1;
(statearr_24286_24379[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (47))){
var inst_24194 = (state_24229[(2)]);
var state_24229__$1 = (function (){var statearr_24287 = state_24229;
(statearr_24287[(18)] = inst_24194);

return statearr_24287;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24288_24380 = state_24229__$1;
(statearr_24288_24380[(1)] = (48));

} else {
var statearr_24289_24381 = state_24229__$1;
(statearr_24289_24381[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (35))){
var inst_24170 = (state_24229[(2)]);
var state_24229__$1 = (function (){var statearr_24290 = state_24229;
(statearr_24290[(24)] = inst_24170);

return statearr_24290;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24291_24382 = state_24229__$1;
(statearr_24291_24382[(1)] = (36));

} else {
var statearr_24292_24383 = state_24229__$1;
(statearr_24292_24383[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (19))){
var state_24229__$1 = state_24229;
var statearr_24293_24384 = state_24229__$1;
(statearr_24293_24384[(2)] = res);

(statearr_24293_24384[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (57))){
var inst_24153 = (state_24229[(19)]);
var inst_24158 = (state_24229[(21)]);
var inst_24214 = (state_24229[(12)]);
var inst_24216 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_24158,inst_24153,db,fuel,max_fuel,opts,(8),inst_24214);
var state_24229__$1 = state_24229;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24229__$1,(60),inst_24216);
} else {
if((state_val_24230 === (11))){
var inst_24224 = (state_24229[(2)]);
var _ = (function (){var statearr_24295 = state_24229;
(statearr_24295[(4)] = cljs.core.rest((state_24229[(4)])));

return statearr_24295;
})();
var state_24229__$1 = state_24229;
var statearr_24296_24385 = state_24229__$1;
(statearr_24296_24385[(2)] = inst_24224);

(statearr_24296_24385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (9))){
var inst_24107 = cljs.core.first(aggregates);
var inst_24108 = fluree.db.query.analytical.calculate_aggregate(res,inst_24107);
var inst_24109 = cljs.core.second(inst_24108);
var state_24229__$1 = (function (){var statearr_24297 = state_24229;
(statearr_24297[(23)] = inst_24109);

return statearr_24297;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24298_24386 = state_24229__$1;
(statearr_24298_24386[(1)] = (12));

} else {
var statearr_24299_24387 = state_24229__$1;
(statearr_24299_24387[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (5))){
var _ = (function (){var statearr_24300 = state_24229;
(statearr_24300[(4)] = cljs.core.rest((state_24229[(4)])));

return statearr_24300;
})();
var state_24229__$1 = state_24229;
var ex24294 = (state_24229__$1[(2)]);
var statearr_24301_24388 = state_24229__$1;
(statearr_24301_24388[(5)] = ex24294);


if((ex24294 instanceof Error)){
var statearr_24302_24389 = state_24229__$1;
(statearr_24302_24389[(1)] = (4));

(statearr_24302_24389[(5)] = null);

} else {
throw ex24294;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (14))){
var inst_24120 = (state_24229[(2)]);
var state_24229__$1 = (function (){var statearr_24303 = state_24229;
(statearr_24303[(17)] = inst_24120);

return statearr_24303;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24304_24390 = state_24229__$1;
(statearr_24304_24390[(1)] = (15));

} else {
var statearr_24305_24391 = state_24229__$1;
(statearr_24305_24391[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (45))){
var inst_24188 = (state_24229[(15)]);
var inst_24190 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_24191 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24188,inst_24190);
var state_24229__$1 = state_24229;
var statearr_24306_24392 = state_24229__$1;
(statearr_24306_24392[(2)] = inst_24191);

(statearr_24306_24392[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (53))){
var inst_24208 = (state_24229[(2)]);
var state_24229__$1 = (function (){var statearr_24307 = state_24229;
(statearr_24307[(13)] = inst_24208);

return statearr_24307;
})();
var statearr_24308_24393 = state_24229__$1;
(statearr_24308_24393[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (26))){
var inst_24148 = (state_24229[(26)]);
var inst_24147 = (state_24229[(2)]);
var inst_24148__$1 = cljs.core.not(prettyPrint);
var state_24229__$1 = (function (){var statearr_24310 = state_24229;
(statearr_24310[(20)] = inst_24147);

(statearr_24310[(26)] = inst_24148__$1);

return statearr_24310;
})();
if(inst_24148__$1){
var statearr_24311_24394 = state_24229__$1;
(statearr_24311_24394[(1)] = (27));

} else {
var statearr_24312_24395 = state_24229__$1;
(statearr_24312_24395[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (16))){
var inst_24120 = (state_24229[(17)]);
var state_24229__$1 = state_24229;
var statearr_24313_24396 = state_24229__$1;
(statearr_24313_24396[(2)] = inst_24120);

(statearr_24313_24396[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (38))){
var inst_24176 = (state_24229[(2)]);
var state_24229__$1 = (function (){var statearr_24314 = state_24229;
(statearr_24314[(14)] = inst_24176);

return statearr_24314;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24315_24397 = state_24229__$1;
(statearr_24315_24397[(1)] = (39));

} else {
var statearr_24316_24398 = state_24229__$1;
(statearr_24316_24398[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (30))){
var inst_24155 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_24229__$1 = state_24229;
var statearr_24317_24399 = state_24229__$1;
(statearr_24317_24399[(2)] = inst_24155);

(statearr_24317_24399[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (10))){
var state_24229__$1 = state_24229;
if(cljs.core.truth_(aggregates)){
var statearr_24318_24400 = state_24229__$1;
(statearr_24318_24400[(1)] = (18));

} else {
var statearr_24319_24401 = state_24229__$1;
(statearr_24319_24401[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (18))){
var inst_24131 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_24229__$1 = state_24229;
var statearr_24320_24402 = state_24229__$1;
(statearr_24320_24402[(2)] = inst_24131);

(statearr_24320_24402[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (52))){
var inst_24137 = (state_24229[(10)]);
var state_24229__$1 = state_24229;
var statearr_24321_24403 = state_24229__$1;
(statearr_24321_24403[(2)] = inst_24137);

(statearr_24321_24403[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (42))){
var inst_24182 = (state_24229[(25)]);
var inst_24147 = (state_24229[(20)]);
var inst_24184 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_24147);
var inst_24185 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24182,inst_24184);
var state_24229__$1 = state_24229;
var statearr_24322_24404 = state_24229__$1;
(statearr_24322_24404[(2)] = inst_24185);

(statearr_24322_24404[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (37))){
var inst_24170 = (state_24229[(24)]);
var state_24229__$1 = state_24229;
var statearr_24323_24405 = state_24229__$1;
(statearr_24323_24405[(2)] = inst_24170);

(statearr_24323_24405[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (8))){
var inst_24105 = (state_24229[(2)]);
var state_24229__$1 = state_24229;
if(cljs.core.truth_(inst_24105)){
var statearr_24324_24406 = state_24229__$1;
(statearr_24324_24406[(1)] = (9));

} else {
var statearr_24325_24407 = state_24229__$1;
(statearr_24325_24407[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24230 === (49))){
var inst_24194 = (state_24229[(18)]);
var state_24229__$1 = state_24229;
var statearr_24326_24408 = state_24229__$1;
(statearr_24326_24408[(2)] = inst_24194);

(statearr_24326_24408[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2727__auto__ = null;
var fluree$db$query$fql$state_machine__2727__auto____0 = (function (){
var statearr_24327 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24327[(0)] = fluree$db$query$fql$state_machine__2727__auto__);

(statearr_24327[(1)] = (1));

return statearr_24327;
});
var fluree$db$query$fql$state_machine__2727__auto____1 = (function (state_24229){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24229);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24328){var ex__2730__auto__ = e24328;
var statearr_24329_24409 = state_24229;
(statearr_24329_24409[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24229[(4)]))){
var statearr_24330_24410 = state_24229;
(statearr_24330_24410[(1)] = cljs.core.first((state_24229[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24411 = state_24229;
state_24229 = G__24411;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2727__auto__ = function(state_24229){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2727__auto____1.call(this,state_24229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2727__auto____0;
fluree$db$query$fql$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2727__auto____1;
return fluree$db$query$fql$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24331 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24331[(6)] = c__2749__auto__);

return statearr_24331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__24414,groupBy){
var map__24415 = p__24414;
var map__24415__$1 = cljs.core.__destructure_map(map__24415);
var res = map__24415__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24415__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24415__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__24416 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24416,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24416,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24412_SHARP_){
return fluree.db.util.core.index_of(headers,p1__24412_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24413_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__24413_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__24419 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24419,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24419,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__24422,p__24423,opts){
var map__24424 = p__24422;
var map__24424__$1 = cljs.core.__destructure_map(map__24424);
var res = map__24424__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24424__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24424__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24425 = p__24423;
var map__24425__$1 = cljs.core.__destructure_map(map__24425);
var select_spec = map__24425__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24425__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24425__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24425__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24425__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24425__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24425__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24425__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24667){
var state_val_24668 = (state_24667[(1)]);
if((state_val_24668 === (65))){
var state_24667__$1 = state_24667;
var statearr_24669_24820 = state_24667__$1;
(statearr_24669_24820[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (70))){
var inst_24588 = (state_24667[(7)]);
var state_24667__$1 = state_24667;
var statearr_24671_24821 = state_24667__$1;
(statearr_24671_24821[(2)] = inst_24588);

(statearr_24671_24821[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (62))){
var state_24667__$1 = state_24667;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24672_24822 = state_24667__$1;
(statearr_24672_24822[(1)] = (64));

} else {
var statearr_24673_24823 = state_24667__$1;
(statearr_24673_24823[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (74))){
var inst_24495 = (state_24667[(8)]);
var inst_24504 = (state_24667[(9)]);
var inst_24563 = (state_24667[(10)]);
var inst_24596 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24495,inst_24504,inst_24563);
var state_24667__$1 = state_24667;
var statearr_24674_24824 = state_24667__$1;
(statearr_24674_24824[(2)] = inst_24596);

(statearr_24674_24824[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (7))){
var state_24667__$1 = state_24667;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_24675_24825 = state_24667__$1;
(statearr_24675_24825[(1)] = (82));

} else {
var statearr_24676_24826 = state_24667__$1;
(statearr_24676_24826[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (59))){
var inst_24563 = (state_24667[(10)]);
var inst_24493 = (state_24667[(11)]);
var inst_24567 = cljs.core.count(inst_24563);
var inst_24568 = (inst_24493 - inst_24567);
var state_24667__$1 = state_24667;
var statearr_24677_24827 = state_24667__$1;
(statearr_24677_24827[(2)] = inst_24568);

(statearr_24677_24827[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (86))){
var state_24667__$1 = state_24667;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24678_24828 = state_24667__$1;
(statearr_24678_24828[(1)] = (89));

} else {
var statearr_24679_24829 = state_24667__$1;
(statearr_24679_24829[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (20))){
var state_24667__$1 = state_24667;
var statearr_24680_24830 = state_24667__$1;
(statearr_24680_24830[(2)] = (0));

(statearr_24680_24830[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (72))){
var inst_24593 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
if(cljs.core.truth_(inst_24593)){
var statearr_24681_24831 = state_24667__$1;
(statearr_24681_24831[(1)] = (73));

} else {
var statearr_24682_24832 = state_24667__$1;
(statearr_24682_24832[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (58))){
var state_24667__$1 = state_24667;
var statearr_24683_24833 = state_24667__$1;
(statearr_24683_24833[(2)] = null);

(statearr_24683_24833[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (60))){
var inst_24494 = (state_24667[(12)]);
var inst_24570 = (state_24667[(2)]);
var inst_24571 = (inst_24494 <= (0));
var state_24667__$1 = (function (){var statearr_24684 = state_24667;
(statearr_24684[(13)] = inst_24570);

return statearr_24684;
})();
if(cljs.core.truth_(inst_24571)){
var statearr_24685_24834 = state_24667__$1;
(statearr_24685_24834[(1)] = (61));

} else {
var statearr_24686_24835 = state_24667__$1;
(statearr_24686_24835[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (27))){
var inst_24493 = (state_24667[(11)]);
var inst_24517 = (inst_24493 < (1));
var state_24667__$1 = state_24667;
var statearr_24687_24836 = state_24667__$1;
(statearr_24687_24836[(2)] = inst_24517);

(statearr_24687_24836[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (1))){
var state_24667__$1 = state_24667;
var statearr_24688_24837 = state_24667__$1;
(statearr_24688_24837[(2)] = null);

(statearr_24688_24837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (69))){
var inst_24583 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24689_24838 = state_24667__$1;
(statearr_24689_24838[(2)] = inst_24583);

(statearr_24689_24838[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (24))){
var inst_24495 = (state_24667[(8)]);
var state_24667__$1 = state_24667;
var statearr_24690_24839 = state_24667__$1;
(statearr_24690_24839[(2)] = inst_24495);

(statearr_24690_24839[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (55))){
var inst_24553 = (state_24667[(14)]);
var inst_24493 = (state_24667[(11)]);
var inst_24560 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_24493,inst_24553);
var state_24667__$1 = state_24667;
var statearr_24691_24840 = state_24667__$1;
(statearr_24691_24840[(2)] = inst_24560);

(statearr_24691_24840[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (85))){
var inst_24638 = (state_24667[(15)]);
var inst_24637 = (state_24667[(2)]);
var inst_24638__$1 = fluree.db.util.async.throw_err(inst_24637);
var inst_24639 = cljs.core.coll_QMARK_(inst_24638__$1);
var inst_24640 = (!(inst_24639));
var state_24667__$1 = (function (){var statearr_24692 = state_24667;
(statearr_24692[(15)] = inst_24638__$1);

return statearr_24692;
})();
if(inst_24640){
var statearr_24693_24841 = state_24667__$1;
(statearr_24693_24841[(1)] = (86));

} else {
var statearr_24694_24842 = state_24667__$1;
(statearr_24694_24842[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (39))){
var inst_24512 = (state_24667[(16)]);
var inst_24534 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_24535 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_24536 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_24512,inst_24534,inst_24535);
var state_24667__$1 = state_24667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24667__$1,(42),inst_24536);
} else {
if((state_val_24668 === (88))){
var inst_24660 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24695_24843 = state_24667__$1;
(statearr_24695_24843[(2)] = inst_24660);

(statearr_24695_24843[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (46))){
var inst_24494 = (state_24667[(12)]);
var inst_24548 = ((0) < inst_24494);
var state_24667__$1 = state_24667;
if(cljs.core.truth_(inst_24548)){
var statearr_24696_24844 = state_24667__$1;
(statearr_24696_24844[(1)] = (49));

} else {
var statearr_24697_24845 = state_24667__$1;
(statearr_24697_24845[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (4))){
var inst_24426 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24698_24846 = state_24667__$1;
(statearr_24698_24846[(2)] = inst_24426);

(statearr_24698_24846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (77))){
var inst_24493 = (state_24667[(11)]);
var inst_24604 = (inst_24493 - (1));
var state_24667__$1 = state_24667;
var statearr_24699_24847 = state_24667__$1;
(statearr_24699_24847[(2)] = inst_24604);

(statearr_24699_24847[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (95))){
var inst_24638 = (state_24667[(15)]);
var state_24667__$1 = state_24667;
var statearr_24700_24848 = state_24667__$1;
(statearr_24700_24848[(2)] = inst_24638);

(statearr_24700_24848[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (54))){
var inst_24558 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
if(cljs.core.truth_(inst_24558)){
var statearr_24701_24849 = state_24667__$1;
(statearr_24701_24849[(1)] = (55));

} else {
var statearr_24702_24850 = state_24667__$1;
(statearr_24702_24850[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (92))){
var inst_24638 = (state_24667[(15)]);
var inst_24651 = cljs.core.first(inst_24638);
var state_24667__$1 = state_24667;
var statearr_24703_24851 = state_24667__$1;
(statearr_24703_24851[(2)] = inst_24651);

(statearr_24703_24851[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (15))){
var inst_24444 = (state_24667[(17)]);
var inst_24452 = (state_24667[(2)]);
var inst_24453 = fluree.db.util.async.throw_err(inst_24452);
var inst_24454 = [inst_24444];
var inst_24455 = [inst_24453];
var inst_24456 = cljs.core.PersistentHashMap.fromArrays(inst_24454,inst_24455);
var state_24667__$1 = state_24667;
var statearr_24704_24852 = state_24667__$1;
(statearr_24704_24852[(2)] = inst_24456);

(statearr_24704_24852[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (48))){
var inst_24616 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24705_24853 = state_24667__$1;
(statearr_24705_24853[(2)] = inst_24616);

(statearr_24705_24853[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (50))){
var inst_24539 = (state_24667[(18)]);
var state_24667__$1 = state_24667;
var statearr_24706_24854 = state_24667__$1;
(statearr_24706_24854[(2)] = inst_24539);

(statearr_24706_24854[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (75))){
var inst_24570 = (state_24667[(13)]);
var inst_24587 = (state_24667[(19)]);
var inst_24508 = (state_24667[(20)]);
var inst_24505 = (state_24667[(21)]);
var inst_24598 = (state_24667[(2)]);
var inst_24491 = inst_24505;
var inst_24492 = inst_24508;
var inst_24493 = inst_24570;
var inst_24494 = inst_24587;
var inst_24495 = inst_24598;
var state_24667__$1 = (function (){var statearr_24707 = state_24667;
(statearr_24707[(22)] = inst_24492);

(statearr_24707[(12)] = inst_24494);

(statearr_24707[(8)] = inst_24495);

(statearr_24707[(23)] = inst_24491);

(statearr_24707[(11)] = inst_24493);

return statearr_24707;
})();
var statearr_24708_24855 = state_24667__$1;
(statearr_24708_24855[(2)] = null);

(statearr_24708_24855[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (21))){
var inst_24484 = (state_24667[(24)]);
var inst_24472 = (state_24667[(25)]);
var inst_24476 = (state_24667[(26)]);
var inst_24489 = (state_24667[(2)]);
var inst_24490 = cljs.core.PersistentHashMap.EMPTY;
var inst_24491 = inst_24472;
var inst_24492 = inst_24476;
var inst_24493 = inst_24484;
var inst_24494 = inst_24489;
var inst_24495 = inst_24490;
var state_24667__$1 = (function (){var statearr_24709 = state_24667;
(statearr_24709[(22)] = inst_24492);

(statearr_24709[(12)] = inst_24494);

(statearr_24709[(8)] = inst_24495);

(statearr_24709[(23)] = inst_24491);

(statearr_24709[(11)] = inst_24493);

return statearr_24709;
})();
var statearr_24710_24856 = state_24667__$1;
(statearr_24710_24856[(2)] = null);

(statearr_24710_24856[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (31))){
var inst_24509 = (state_24667[(27)]);
var inst_24494 = (state_24667[(12)]);
var inst_24523 = (inst_24494 >= inst_24509);
var state_24667__$1 = state_24667;
if(cljs.core.truth_(inst_24523)){
var statearr_24711_24857 = state_24667__$1;
(statearr_24711_24857[(1)] = (33));

} else {
var statearr_24712_24858 = state_24667__$1;
(statearr_24712_24858[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (32))){
var inst_24623 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24713_24859 = state_24667__$1;
(statearr_24713_24859[(2)] = inst_24623);

(statearr_24713_24859[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (40))){
var state_24667__$1 = state_24667;
var statearr_24714_24860 = state_24667__$1;
(statearr_24714_24860[(2)] = null);

(statearr_24714_24860[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (91))){
var inst_24648 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24715_24861 = state_24667__$1;
(statearr_24715_24861[(2)] = inst_24648);

(statearr_24715_24861[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (56))){
var inst_24553 = (state_24667[(14)]);
var state_24667__$1 = state_24667;
var statearr_24716_24862 = state_24667__$1;
(statearr_24716_24862[(2)] = inst_24553);

(statearr_24716_24862[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (33))){
var state_24667__$1 = state_24667;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24717_24863 = state_24667__$1;
(statearr_24717_24863[(1)] = (36));

} else {
var statearr_24718_24864 = state_24667__$1;
(statearr_24718_24864[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (13))){
var inst_24441 = (state_24667[(28)]);
var inst_24472 = (state_24667[(25)]);
var inst_24476 = (state_24667[(26)]);
var inst_24472__$1 = cljs.core.keys(inst_24441);
var inst_24473 = cljs.core.seq(inst_24472__$1);
var inst_24474 = cljs.core.first(inst_24473);
var inst_24475 = cljs.core.next(inst_24473);
var inst_24476__$1 = cljs.core.vals(inst_24441);
var inst_24477 = cljs.core.seq(inst_24476__$1);
var inst_24478 = cljs.core.first(inst_24477);
var inst_24479 = cljs.core.next(inst_24477);
var inst_24480 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_24667__$1 = (function (){var statearr_24719 = state_24667;
(statearr_24719[(25)] = inst_24472__$1);

(statearr_24719[(29)] = inst_24474);

(statearr_24719[(30)] = inst_24475);

(statearr_24719[(26)] = inst_24476__$1);

(statearr_24719[(31)] = inst_24478);

(statearr_24719[(32)] = inst_24479);

return statearr_24719;
})();
if(inst_24480){
var statearr_24720_24865 = state_24667__$1;
(statearr_24720_24865[(1)] = (16));

} else {
var statearr_24721_24866 = state_24667__$1;
(statearr_24721_24866[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (22))){
var inst_24492 = (state_24667[(22)]);
var inst_24491 = (state_24667[(23)]);
var inst_24503 = cljs.core.seq(inst_24491);
var inst_24504 = cljs.core.first(inst_24503);
var inst_24505 = cljs.core.next(inst_24503);
var inst_24506 = cljs.core.seq(inst_24492);
var inst_24507 = cljs.core.first(inst_24506);
var inst_24508 = cljs.core.next(inst_24506);
var inst_24509 = cljs.core.count(inst_24507);
var inst_24510 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_24511 = [headers,vars,inst_24507];
var inst_24512 = cljs.core.PersistentHashMap.fromArrays(inst_24510,inst_24511);
var inst_24513 = (inst_24507 == null);
var state_24667__$1 = (function (){var statearr_24722 = state_24667;
(statearr_24722[(16)] = inst_24512);

(statearr_24722[(27)] = inst_24509);

(statearr_24722[(9)] = inst_24504);

(statearr_24722[(20)] = inst_24508);

(statearr_24722[(21)] = inst_24505);

return statearr_24722;
})();
if(cljs.core.truth_(inst_24513)){
var statearr_24723_24867 = state_24667__$1;
(statearr_24723_24867[(1)] = (24));

} else {
var statearr_24724_24868 = state_24667__$1;
(statearr_24724_24868[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (90))){
var inst_24638 = (state_24667[(15)]);
var state_24667__$1 = state_24667;
var statearr_24725_24869 = state_24667__$1;
(statearr_24725_24869[(2)] = inst_24638);

(statearr_24725_24869[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (36))){
var inst_24494 = (state_24667[(12)]);
var inst_24526 = (inst_24494 - (1));
var state_24667__$1 = state_24667;
var statearr_24726_24870 = state_24667__$1;
(statearr_24726_24870[(2)] = inst_24526);

(statearr_24726_24870[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (41))){
var inst_24619 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24727_24871 = state_24667__$1;
(statearr_24727_24871[(2)] = inst_24619);

(statearr_24727_24871[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (89))){
var inst_24638 = (state_24667[(15)]);
var inst_24643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24644 = [inst_24638];
var inst_24645 = (new cljs.core.PersistentVector(null,1,(5),inst_24643,inst_24644,null));
var state_24667__$1 = state_24667;
var statearr_24728_24872 = state_24667__$1;
(statearr_24728_24872[(2)] = inst_24645);

(statearr_24728_24872[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (43))){
var inst_24539 = (state_24667[(18)]);
var inst_24542 = cljs.core.seq(inst_24539);
var state_24667__$1 = state_24667;
var statearr_24729_24873 = state_24667__$1;
(statearr_24729_24873[(2)] = inst_24542);

(statearr_24729_24873[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (61))){
var state_24667__$1 = state_24667;
var statearr_24730_24874 = state_24667__$1;
(statearr_24730_24874[(2)] = (0));

(statearr_24730_24874[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (29))){
var inst_24520 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
if(cljs.core.truth_(inst_24520)){
var statearr_24731_24875 = state_24667__$1;
(statearr_24731_24875[(1)] = (30));

} else {
var statearr_24732_24876 = state_24667__$1;
(statearr_24732_24876[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (44))){
var inst_24540 = (state_24667[(33)]);
var state_24667__$1 = state_24667;
var statearr_24733_24877 = state_24667__$1;
(statearr_24733_24877[(2)] = inst_24540);

(statearr_24733_24877[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (93))){
var state_24667__$1 = state_24667;
var statearr_24734_24878 = state_24667__$1;
(statearr_24734_24878[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (6))){
var inst_24433 = (state_24667[(34)]);
var inst_24433__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_24435 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_24667__$1 = (function (){var statearr_24736 = state_24667;
(statearr_24736[(35)] = inst_24435);

(statearr_24736[(34)] = inst_24433__$1);

return statearr_24736;
})();
if(cljs.core.truth_(inst_24433__$1)){
var statearr_24737_24879 = state_24667__$1;
(statearr_24737_24879[(1)] = (9));

} else {
var statearr_24738_24880 = state_24667__$1;
(statearr_24738_24880[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (28))){
var inst_24493 = (state_24667[(11)]);
var state_24667__$1 = state_24667;
var statearr_24739_24881 = state_24667__$1;
(statearr_24739_24881[(2)] = inst_24493);

(statearr_24739_24881[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (64))){
var inst_24494 = (state_24667[(12)]);
var inst_24575 = (inst_24494 - (1));
var state_24667__$1 = state_24667;
var statearr_24740_24882 = state_24667__$1;
(statearr_24740_24882[(2)] = inst_24575);

(statearr_24740_24882[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (51))){
var inst_24493 = (state_24667[(11)]);
var inst_24553 = (state_24667[(2)]);
var state_24667__$1 = (function (){var statearr_24741 = state_24667;
(statearr_24741[(14)] = inst_24553);

return statearr_24741;
})();
if(cljs.core.truth_(inst_24493)){
var statearr_24742_24883 = state_24667__$1;
(statearr_24742_24883[(1)] = (52));

} else {
var statearr_24743_24884 = state_24667__$1;
(statearr_24743_24884[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (25))){
var inst_24493 = (state_24667[(11)]);
var state_24667__$1 = state_24667;
if(cljs.core.truth_(inst_24493)){
var statearr_24744_24885 = state_24667__$1;
(statearr_24744_24885[(1)] = (27));

} else {
var statearr_24745_24886 = state_24667__$1;
(statearr_24745_24886[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (34))){
var state_24667__$1 = state_24667;
var statearr_24746_24887 = state_24667__$1;
(statearr_24746_24887[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (17))){
var state_24667__$1 = state_24667;
var statearr_24748_24888 = state_24667__$1;
(statearr_24748_24888[(2)] = limit);

(statearr_24748_24888[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (3))){
var inst_24665 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24667__$1,inst_24665);
} else {
if((state_val_24668 === (12))){
var inst_24441 = (state_24667[(28)]);
var inst_24443 = cljs.core.keys(inst_24441);
var inst_24444 = cljs.core.first(inst_24443);
var inst_24445 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_24446 = cljs.core.vals(inst_24441);
var inst_24447 = cljs.core.first(inst_24446);
var inst_24448 = [headers,vars,inst_24447];
var inst_24449 = cljs.core.PersistentHashMap.fromArrays(inst_24445,inst_24448);
var inst_24450 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_24449,select_spec,limit,opts);
var state_24667__$1 = (function (){var statearr_24749 = state_24667;
(statearr_24749[(17)] = inst_24444);

return statearr_24749;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24667__$1,(15),inst_24450);
} else {
if((state_val_24668 === (2))){
var _ = (function (){var statearr_24750 = state_24667;
(statearr_24750[(4)] = cljs.core.cons((5),(state_24667[(4)])));

return statearr_24750;
})();
var state_24667__$1 = state_24667;
if(cljs.core.truth_(groupBy)){
var statearr_24751_24889 = state_24667__$1;
(statearr_24751_24889[(1)] = (6));

} else {
var statearr_24752_24890 = state_24667__$1;
(statearr_24752_24890[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (66))){
var inst_24585 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24753_24891 = state_24667__$1;
(statearr_24753_24891[(2)] = inst_24585);

(statearr_24753_24891[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (23))){
var inst_24627 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24754_24892 = state_24667__$1;
(statearr_24754_24892[(2)] = inst_24627);

(statearr_24754_24892[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (47))){
var inst_24493 = (state_24667[(11)]);
var inst_24601 = (inst_24493 == null);
var state_24667__$1 = state_24667;
if(cljs.core.truth_(inst_24601)){
var statearr_24755_24893 = state_24667__$1;
(statearr_24755_24893[(1)] = (76));

} else {
var statearr_24756_24894 = state_24667__$1;
(statearr_24756_24894[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (35))){
var inst_24621 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24757_24895 = state_24667__$1;
(statearr_24757_24895[(2)] = inst_24621);

(statearr_24757_24895[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (82))){
var state_24667__$1 = state_24667;
var statearr_24758_24896 = state_24667__$1;
(statearr_24758_24896[(2)] = (1));

(statearr_24758_24896[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (76))){
var state_24667__$1 = state_24667;
var statearr_24759_24897 = state_24667__$1;
(statearr_24759_24897[(2)] = null);

(statearr_24759_24897[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (97))){
var inst_24656 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24760_24898 = state_24667__$1;
(statearr_24760_24898[(2)] = inst_24656);

(statearr_24760_24898[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (19))){
var inst_24485 = (state_24667[(36)]);
var state_24667__$1 = state_24667;
var statearr_24761_24899 = state_24667__$1;
(statearr_24761_24899[(2)] = inst_24485);

(statearr_24761_24899[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (57))){
var inst_24493 = (state_24667[(11)]);
var inst_24563 = (state_24667[(2)]);
var inst_24564 = (inst_24493 == null);
var state_24667__$1 = (function (){var statearr_24762 = state_24667;
(statearr_24762[(10)] = inst_24563);

return statearr_24762;
})();
if(cljs.core.truth_(inst_24564)){
var statearr_24763_24900 = state_24667__$1;
(statearr_24763_24900[(1)] = (58));

} else {
var statearr_24764_24901 = state_24667__$1;
(statearr_24764_24901[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (68))){
var state_24667__$1 = state_24667;
var statearr_24765_24902 = state_24667__$1;
(statearr_24765_24902[(2)] = null);

(statearr_24765_24902[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (11))){
var inst_24441 = (state_24667[(2)]);
var state_24667__$1 = (function (){var statearr_24767 = state_24667;
(statearr_24767[(28)] = inst_24441);

return statearr_24767;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_24768_24903 = state_24667__$1;
(statearr_24768_24903[(1)] = (12));

} else {
var statearr_24769_24904 = state_24667__$1;
(statearr_24769_24904[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (9))){
var inst_24435 = (state_24667[(35)]);
var inst_24433 = (state_24667[(34)]);
var inst_24437 = cljs.core.sorted_map_by(inst_24433);
var inst_24438 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24437,inst_24435);
var state_24667__$1 = state_24667;
var statearr_24770_24905 = state_24667__$1;
(statearr_24770_24905[(2)] = inst_24438);

(statearr_24770_24905[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (5))){
var _ = (function (){var statearr_24771 = state_24667;
(statearr_24771[(4)] = cljs.core.rest((state_24667[(4)])));

return statearr_24771;
})();
var state_24667__$1 = state_24667;
var ex24766 = (state_24667__$1[(2)]);
var statearr_24772_24906 = state_24667__$1;
(statearr_24772_24906[(5)] = ex24766);


if((ex24766 instanceof Error)){
var statearr_24773_24907 = state_24667__$1;
(statearr_24773_24907[(1)] = (4));

(statearr_24773_24907[(5)] = null);

} else {
throw ex24766;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (83))){
var state_24667__$1 = state_24667;
var statearr_24774_24908 = state_24667__$1;
(statearr_24774_24908[(2)] = limit);

(statearr_24774_24908[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (14))){
var inst_24629 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24775_24909 = state_24667__$1;
(statearr_24775_24909[(2)] = inst_24629);

(statearr_24775_24909[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (45))){
var inst_24545 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
if(cljs.core.truth_(inst_24545)){
var statearr_24776_24910 = state_24667__$1;
(statearr_24776_24910[(1)] = (46));

} else {
var statearr_24777_24911 = state_24667__$1;
(statearr_24777_24911[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (53))){
var inst_24493 = (state_24667[(11)]);
var state_24667__$1 = state_24667;
var statearr_24778_24912 = state_24667__$1;
(statearr_24778_24912[(2)] = inst_24493);

(statearr_24778_24912[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (78))){
var inst_24494 = (state_24667[(12)]);
var inst_24606 = (state_24667[(2)]);
var inst_24607 = (inst_24494 <= (0));
var state_24667__$1 = (function (){var statearr_24779 = state_24667;
(statearr_24779[(37)] = inst_24606);

return statearr_24779;
})();
if(cljs.core.truth_(inst_24607)){
var statearr_24780_24913 = state_24667__$1;
(statearr_24780_24913[(1)] = (79));

} else {
var statearr_24781_24914 = state_24667__$1;
(statearr_24781_24914[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (26))){
var inst_24625 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24782_24915 = state_24667__$1;
(statearr_24782_24915[(2)] = inst_24625);

(statearr_24782_24915[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (16))){
var state_24667__$1 = state_24667;
var statearr_24783_24916 = state_24667__$1;
(statearr_24783_24916[(2)] = null);

(statearr_24783_24916[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (81))){
var inst_24495 = (state_24667[(8)]);
var inst_24539 = (state_24667[(18)]);
var inst_24504 = (state_24667[(9)]);
var inst_24508 = (state_24667[(20)]);
var inst_24505 = (state_24667[(21)]);
var inst_24606 = (state_24667[(37)]);
var inst_24612 = (state_24667[(2)]);
var inst_24613 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24495,inst_24504,inst_24539);
var inst_24491 = inst_24505;
var inst_24492 = inst_24508;
var inst_24493 = inst_24606;
var inst_24494 = inst_24612;
var inst_24495__$1 = inst_24613;
var state_24667__$1 = (function (){var statearr_24786 = state_24667;
(statearr_24786[(22)] = inst_24492);

(statearr_24786[(12)] = inst_24494);

(statearr_24786[(8)] = inst_24495__$1);

(statearr_24786[(23)] = inst_24491);

(statearr_24786[(11)] = inst_24493);

return statearr_24786;
})();
var statearr_24787_24917 = state_24667__$1;
(statearr_24787_24917[(2)] = null);

(statearr_24787_24917[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (79))){
var state_24667__$1 = state_24667;
var statearr_24788_24918 = state_24667__$1;
(statearr_24788_24918[(2)] = (0));

(statearr_24788_24918[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (38))){
var inst_24495 = (state_24667[(8)]);
var inst_24493 = (state_24667[(11)]);
var inst_24508 = (state_24667[(20)]);
var inst_24505 = (state_24667[(21)]);
var inst_24530 = (state_24667[(2)]);
var tmp24784 = inst_24495;
var tmp24785 = inst_24493;
var inst_24491 = inst_24505;
var inst_24492 = inst_24508;
var inst_24493__$1 = tmp24785;
var inst_24494 = inst_24530;
var inst_24495__$1 = tmp24784;
var state_24667__$1 = (function (){var statearr_24789 = state_24667;
(statearr_24789[(22)] = inst_24492);

(statearr_24789[(12)] = inst_24494);

(statearr_24789[(8)] = inst_24495__$1);

(statearr_24789[(23)] = inst_24491);

(statearr_24789[(11)] = inst_24493__$1);

return statearr_24789;
})();
var statearr_24790_24919 = state_24667__$1;
(statearr_24790_24919[(2)] = null);

(statearr_24790_24919[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (87))){
var state_24667__$1 = state_24667;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_24791_24920 = state_24667__$1;
(statearr_24791_24920[(1)] = (92));

} else {
var statearr_24792_24921 = state_24667__$1;
(statearr_24792_24921[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (30))){
var inst_24495 = (state_24667[(8)]);
var state_24667__$1 = state_24667;
var statearr_24793_24922 = state_24667__$1;
(statearr_24793_24922[(2)] = inst_24495);

(statearr_24793_24922[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (73))){
var inst_24495 = (state_24667[(8)]);
var state_24667__$1 = state_24667;
var statearr_24794_24923 = state_24667__$1;
(statearr_24794_24923[(2)] = inst_24495);

(statearr_24794_24923[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (96))){
var state_24667__$1 = state_24667;
var statearr_24795_24924 = state_24667__$1;
(statearr_24795_24924[(2)] = null);

(statearr_24795_24924[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (10))){
var inst_24435 = (state_24667[(35)]);
var state_24667__$1 = state_24667;
var statearr_24796_24925 = state_24667__$1;
(statearr_24796_24925[(2)] = inst_24435);

(statearr_24796_24925[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (18))){
var inst_24485 = (state_24667[(36)]);
var inst_24484 = (state_24667[(2)]);
var inst_24485__$1 = offset;
var state_24667__$1 = (function (){var statearr_24797 = state_24667;
(statearr_24797[(24)] = inst_24484);

(statearr_24797[(36)] = inst_24485__$1);

return statearr_24797;
})();
if(cljs.core.truth_(inst_24485__$1)){
var statearr_24798_24926 = state_24667__$1;
(statearr_24798_24926[(1)] = (19));

} else {
var statearr_24799_24927 = state_24667__$1;
(statearr_24799_24927[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (52))){
var inst_24493 = (state_24667[(11)]);
var inst_24555 = ((0) < inst_24493);
var state_24667__$1 = state_24667;
var statearr_24800_24928 = state_24667__$1;
(statearr_24800_24928[(2)] = inst_24555);

(statearr_24800_24928[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (67))){
var inst_24509 = (state_24667[(27)]);
var inst_24494 = (state_24667[(12)]);
var inst_24563 = (state_24667[(10)]);
var inst_24578 = cljs.core.count(inst_24563);
var inst_24579 = (inst_24509 - inst_24578);
var inst_24580 = (inst_24494 - inst_24579);
var state_24667__$1 = state_24667;
var statearr_24801_24929 = state_24667__$1;
(statearr_24801_24929[(2)] = inst_24580);

(statearr_24801_24929[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (71))){
var inst_24563 = (state_24667[(10)]);
var inst_24591 = cljs.core.empty_QMARK_(inst_24563);
var state_24667__$1 = state_24667;
var statearr_24802_24930 = state_24667__$1;
(statearr_24802_24930[(2)] = inst_24591);

(statearr_24802_24930[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (42))){
var inst_24540 = (state_24667[(33)]);
var inst_24539 = (state_24667[(18)]);
var inst_24538 = (state_24667[(2)]);
var inst_24539__$1 = fluree.db.util.async.throw_err(inst_24538);
var inst_24540__$1 = cljs.core.coll_QMARK_(inst_24539__$1);
var state_24667__$1 = (function (){var statearr_24803 = state_24667;
(statearr_24803[(33)] = inst_24540__$1);

(statearr_24803[(18)] = inst_24539__$1);

return statearr_24803;
})();
if(inst_24540__$1){
var statearr_24804_24931 = state_24667__$1;
(statearr_24804_24931[(1)] = (43));

} else {
var statearr_24805_24932 = state_24667__$1;
(statearr_24805_24932[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (80))){
var inst_24494 = (state_24667[(12)]);
var inst_24610 = (inst_24494 - (1));
var state_24667__$1 = state_24667;
var statearr_24806_24933 = state_24667__$1;
(statearr_24806_24933[(2)] = inst_24610);

(statearr_24806_24933[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (37))){
var inst_24509 = (state_24667[(27)]);
var inst_24494 = (state_24667[(12)]);
var inst_24528 = (inst_24494 - inst_24509);
var state_24667__$1 = state_24667;
var statearr_24807_24934 = state_24667__$1;
(statearr_24807_24934[(2)] = inst_24528);

(statearr_24807_24934[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (63))){
var inst_24588 = (state_24667[(7)]);
var inst_24563 = (state_24667[(10)]);
var inst_24587 = (state_24667[(2)]);
var inst_24588__$1 = (inst_24563 == null);
var state_24667__$1 = (function (){var statearr_24808 = state_24667;
(statearr_24808[(7)] = inst_24588__$1);

(statearr_24808[(19)] = inst_24587);

return statearr_24808;
})();
if(cljs.core.truth_(inst_24588__$1)){
var statearr_24809_24935 = state_24667__$1;
(statearr_24809_24935[(1)] = (70));

} else {
var statearr_24810_24936 = state_24667__$1;
(statearr_24810_24936[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (94))){
var inst_24658 = (state_24667[(2)]);
var state_24667__$1 = state_24667;
var statearr_24811_24937 = state_24667__$1;
(statearr_24811_24937[(2)] = inst_24658);

(statearr_24811_24937[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (8))){
var inst_24662 = (state_24667[(2)]);
var _ = (function (){var statearr_24812 = state_24667;
(statearr_24812[(4)] = cljs.core.rest((state_24667[(4)])));

return statearr_24812;
})();
var state_24667__$1 = state_24667;
var statearr_24813_24938 = state_24667__$1;
(statearr_24813_24938[(2)] = inst_24662);

(statearr_24813_24938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (49))){
var inst_24494 = (state_24667[(12)]);
var inst_24539 = (state_24667[(18)]);
var inst_24550 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_24494,inst_24539);
var state_24667__$1 = state_24667;
var statearr_24814_24939 = state_24667__$1;
(statearr_24814_24939[(2)] = inst_24550);

(statearr_24814_24939[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24668 === (84))){
var inst_24634 = (state_24667[(2)]);
var inst_24635 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_24634,opts);
var state_24667__$1 = state_24667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24667__$1,(85),inst_24635);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0 = (function (){
var statearr_24815 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24815[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__);

(statearr_24815[(1)] = (1));

return statearr_24815;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1 = (function (state_24667){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24667);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24816){var ex__2730__auto__ = e24816;
var statearr_24817_24940 = state_24667;
(statearr_24817_24940[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24667[(4)]))){
var statearr_24818_24941 = state_24667;
(statearr_24818_24941[(1)] = cljs.core.first((state_24667[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24942 = state_24667;
state_24667 = G__24942;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__ = function(state_24667){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1.call(this,state_24667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24819 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24819[(6)] = c__2749__auto__);

return statearr_24819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Legacy ad-hoc query processor
 */
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,parsed_query,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25003){
var state_val_25004 = (state_25003[(1)]);
if((state_val_25004 === (7))){
var state_25003__$1 = state_25003;
var statearr_25005_25043 = state_25003__$1;
(statearr_25005_25043[(2)] = (0));

(statearr_25005_25043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (20))){
var inst_24987 = (state_25003[(2)]);
var state_25003__$1 = state_25003;
var statearr_25006_25044 = state_25003__$1;
(statearr_25006_25044[(2)] = inst_24987);

(statearr_25006_25044[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (1))){
var state_25003__$1 = state_25003;
var statearr_25007_25045 = state_25003__$1;
(statearr_25007_25045[(2)] = null);

(statearr_25007_25045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (4))){
var inst_24943 = (state_25003[(2)]);
var state_25003__$1 = state_25003;
var statearr_25008_25046 = state_25003__$1;
(statearr_25008_25046[(2)] = inst_24943);

(statearr_25008_25046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (15))){
var inst_24974 = (state_25003[(7)]);
var state_25003__$1 = state_25003;
var statearr_25009_25047 = state_25003__$1;
(statearr_25009_25047[(2)] = inst_24974);

(statearr_25009_25047[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (21))){
var inst_24959 = (state_25003[(8)]);
var inst_24989 = (state_25003[(9)]);
var inst_24974 = (state_25003[(7)]);
var inst_24992 = (state_25003[(2)]);
var inst_24993 = fluree.db.util.async.throw_err(inst_24992);
var inst_24994 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query);
var inst_24995 = fluree.db.query.fql.process_ad_hoc_res(db,inst_24989,inst_24974,inst_24993,inst_24994,inst_24959);
var state_25003__$1 = state_25003;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25003__$1,(22),inst_24995);
} else {
if((state_val_25004 === (13))){
var inst_24974 = (state_25003[(7)]);
var state_25003__$1 = state_25003;
if(cljs.core.truth_(inst_24974)){
var statearr_25010_25048 = state_25003__$1;
(statearr_25010_25048[(1)] = (15));

} else {
var statearr_25011_25049 = state_25003__$1;
(statearr_25011_25049[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (22))){
var inst_24997 = (state_25003[(2)]);
var inst_24998 = fluree.db.util.async.throw_err(inst_24997);
var _ = (function (){var statearr_25012 = state_25003;
(statearr_25012[(4)] = cljs.core.rest((state_25003[(4)])));

return statearr_25012;
})();
var state_25003__$1 = state_25003;
var statearr_25013_25050 = state_25003__$1;
(statearr_25013_25050[(2)] = inst_24998);

(statearr_25013_25050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (6))){
var inst_24954 = (state_25003[(10)]);
var state_25003__$1 = state_25003;
var statearr_25014_25051 = state_25003__$1;
(statearr_25014_25051[(2)] = inst_24954);

(statearr_25014_25051[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (17))){
var inst_24982 = (state_25003[(2)]);
var state_25003__$1 = state_25003;
if(cljs.core.truth_(inst_24982)){
var statearr_25015_25052 = state_25003__$1;
(statearr_25015_25052[(1)] = (18));

} else {
var statearr_25016_25053 = state_25003__$1;
(statearr_25016_25053[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (3))){
var inst_25001 = (state_25003[(2)]);
var state_25003__$1 = state_25003;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25003__$1,inst_25001);
} else {
if((state_val_25004 === (12))){
var inst_24975 = (state_25003[(11)]);
var state_25003__$1 = state_25003;
var statearr_25017_25054 = state_25003__$1;
(statearr_25017_25054[(2)] = inst_24975);

(statearr_25017_25054[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (2))){
var inst_24954 = (state_25003[(10)]);
var _ = (function (){var statearr_25018 = state_25003;
(statearr_25018[(4)] = cljs.core.cons((5),(state_25003[(4)])));

return statearr_25018;
})();
var inst_24950 = query_map;
var inst_24951 = cljs.core.__destructure_map(inst_24950);
var inst_24952 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24951,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_24953 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24951,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_24954__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24951,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_24955 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24951,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_24956 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24951,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_24957 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24951,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_24958 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24951,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_24959 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24951,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_24961 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)];
var state_25003__$1 = (function (){var statearr_25019 = state_25003;
(statearr_25019[(12)] = inst_24957);

(statearr_25019[(13)] = inst_24955);

(statearr_25019[(14)] = inst_24958);

(statearr_25019[(15)] = inst_24961);

(statearr_25019[(8)] = inst_24959);

(statearr_25019[(16)] = inst_24952);

(statearr_25019[(17)] = inst_24953);

(statearr_25019[(10)] = inst_24954__$1);

(statearr_25019[(18)] = inst_24956);

return statearr_25019;
})();
if(cljs.core.truth_(inst_24954__$1)){
var statearr_25020_25055 = state_25003__$1;
(statearr_25020_25055[(1)] = (6));

} else {
var statearr_25021_25056 = state_25003__$1;
(statearr_25021_25056[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (19))){
var state_25003__$1 = state_25003;
var statearr_25022_25057 = state_25003__$1;
(statearr_25022_25057[(2)] = null);

(statearr_25022_25057[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (11))){
var inst_24959 = (state_25003[(8)]);
var inst_24975 = (state_25003[(11)]);
var inst_24973 = (state_25003[(19)]);
var inst_24973__$1 = (state_25003[(2)]);
var inst_24974 = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(inst_24973__$1);
var inst_24975__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_24959);
var state_25003__$1 = (function (){var statearr_25024 = state_25003;
(statearr_25024[(11)] = inst_24975__$1);

(statearr_25024[(19)] = inst_24973__$1);

(statearr_25024[(7)] = inst_24974);

return statearr_25024;
})();
if(cljs.core.truth_(inst_24975__$1)){
var statearr_25025_25058 = state_25003__$1;
(statearr_25025_25058[(1)] = (12));

} else {
var statearr_25026_25059 = state_25003__$1;
(statearr_25026_25059[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (9))){
var inst_24968 = (state_25003[(20)]);
var inst_24970 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24968,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var state_25003__$1 = state_25003;
var statearr_25027_25060 = state_25003__$1;
(statearr_25027_25060[(2)] = inst_24970);

(statearr_25027_25060[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (5))){
var _ = (function (){var statearr_25028 = state_25003;
(statearr_25028[(4)] = cljs.core.rest((state_25003[(4)])));

return statearr_25028;
})();
var state_25003__$1 = state_25003;
var ex25023 = (state_25003__$1[(2)]);
var statearr_25029_25061 = state_25003__$1;
(statearr_25029_25061[(5)] = ex25023);


if((ex25023 instanceof Error)){
var statearr_25030_25062 = state_25003__$1;
(statearr_25030_25062[(1)] = (4));

(statearr_25030_25062[(5)] = null);

} else {
throw ex25023;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (14))){
var inst_24989 = (state_25003[(9)]);
var inst_24973 = (state_25003[(19)]);
var inst_24974 = (state_25003[(7)]);
var inst_24989__$1 = (state_25003[(2)]);
var inst_24990 = fluree.db.query.analytical.q(query_map,inst_24989__$1,inst_24974,db,inst_24973);
var state_25003__$1 = (function (){var statearr_25031 = state_25003;
(statearr_25031[(9)] = inst_24989__$1);

return statearr_25031;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25003__$1,(21),inst_24990);
} else {
if((state_val_25004 === (16))){
var inst_24959 = (state_25003[(8)]);
var inst_24980 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_24959);
var state_25003__$1 = state_25003;
var statearr_25032_25063 = state_25003__$1;
(statearr_25032_25063[(2)] = inst_24980);

(statearr_25032_25063[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (10))){
var inst_24968 = (state_25003[(20)]);
var state_25003__$1 = state_25003;
var statearr_25033_25064 = state_25003__$1;
(statearr_25033_25064[(2)] = inst_24968);

(statearr_25033_25064[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (18))){
var inst_24984 = cljs.core.volatile_BANG_((0));
var state_25003__$1 = state_25003;
var statearr_25034_25065 = state_25003__$1;
(statearr_25034_25065[(2)] = inst_24984);

(statearr_25034_25065[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25004 === (8))){
var inst_24957 = (state_25003[(12)]);
var inst_24955 = (state_25003[(13)]);
var inst_24958 = (state_25003[(14)]);
var inst_24961 = (state_25003[(15)]);
var inst_24959 = (state_25003[(8)]);
var inst_24952 = (state_25003[(16)]);
var inst_24953 = (state_25003[(17)]);
var inst_24956 = (state_25003[(18)]);
var inst_24965 = (state_25003[(2)]);
var inst_24966 = [inst_24953,inst_24965,inst_24955,inst_24956,inst_24957,inst_24958];
var inst_24967 = cljs.core.PersistentHashMap.fromArrays(inst_24961,inst_24966);
var inst_24968 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_24967,inst_24959], 0));
var state_25003__$1 = (function (){var statearr_25035 = state_25003;
(statearr_25035[(20)] = inst_24968);

return statearr_25035;
})();
if(cljs.core.truth_(inst_24952)){
var statearr_25036_25066 = state_25003__$1;
(statearr_25036_25066[(1)] = (9));

} else {
var statearr_25037_25067 = state_25003__$1;
(statearr_25037_25067[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0 = (function (){
var statearr_25038 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25038[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__);

(statearr_25038[(1)] = (1));

return statearr_25038;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1 = (function (state_25003){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25003);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25039){var ex__2730__auto__ = e25039;
var statearr_25040_25068 = state_25003;
(statearr_25040_25068[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25003[(4)]))){
var statearr_25041_25069 = state_25003;
(statearr_25041_25069[(1)] = cljs.core.first((state_25003[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25070 = state_25003;
state_25003 = G__25070;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__ = function(state_25003){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1.call(this,state_25003);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25042 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25042[(6)] = c__2749__auto__);

return statearr_25042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns already cached query from cache if available, else
 *   executes and stores query into cache.
 */
fluree.db.query.fql.cache_query = (function fluree$db$query$fql$cache_query(p__25071,p__25072){
var map__25073 = p__25071;
var map__25073__$1 = cljs.core.__destructure_map(map__25073);
var db = map__25073__$1;
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25073__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25073__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25073__$1,new cljs.core.Keyword(null,"block","block",664686210));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25073__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25073__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__25074 = p__25072;
var map__25074__$1 = cljs.core.__destructure_map(map__25074);
var query_map = map__25074__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25074__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var oc = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
var query_STAR_ = cljs.core.update.cljs$core$IFn$_invoke$arity$5(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.dissoc,new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var cache_key = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510),network,ledger_id,block,auth,query_STAR_], null);
var G__25075 = cache_key;
var G__25076 = (function (_){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___25093 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_25086){
var state_val_25087 = (state_25086[(1)]);
if((state_val_25087 === (1))){
var inst_25077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25078 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"cache","cache",-1237023054)];
var inst_25079 = (new cljs.core.PersistentVector(null,2,(5),inst_25077,inst_25078,null));
var inst_25080 = cljs.core.assoc_in(query_map,inst_25079,false);
var inst_25081 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_25080) : fluree.db.query.fql.query.call(null,db,inst_25080));
var state_25086__$1 = state_25086;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25086__$1,(2),inst_25081);
} else {
if((state_val_25087 === (2))){
var inst_25083 = (state_25086[(2)]);
var inst_25084 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_25083);
var state_25086__$1 = state_25086;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25086__$1,inst_25084);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0 = (function (){
var statearr_25088 = [null,null,null,null,null,null,null];
(statearr_25088[(0)] = fluree$db$query$fql$cache_query_$_state_machine__2727__auto__);

(statearr_25088[(1)] = (1));

return statearr_25088;
});
var fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1 = (function (state_25086){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_25086);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e25089){var ex__2730__auto__ = e25089;
var statearr_25090_25094 = state_25086;
(statearr_25090_25094[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_25086[(4)]))){
var statearr_25091_25095 = state_25086;
(statearr_25091_25095[(1)] = cljs.core.first((state_25086[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25096 = state_25086;
state_25086 = G__25096;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__ = function(state_25086){
switch(arguments.length){
case 0:
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1.call(this,state_25086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$cache_query_$_state_machine__2727__auto____0;
fluree$db$query$fql$cache_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$cache_query_$_state_machine__2727__auto____1;
return fluree$db$query$fql$cache_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_25092 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_25092[(6)] = c__2749__auto___25093);

return statearr_25092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
});
return (oc.cljs$core$IFn$_invoke$arity$2 ? oc.cljs$core$IFn$_invoke$arity$2(G__25075,G__25076) : oc.call(null,G__25075,G__25076));
});
/**
 * Returns true if query was requested to run from the cache.
 */
fluree.db.query.fql.cache_QMARK_ = (function fluree$db$query$fql$cache_QMARK_(p__25097){
var map__25098 = p__25097;
var map__25098__$1 = cljs.core.__destructure_map(map__25098);
var _query_map = map__25098__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25098__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return false;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var G__25099_25101 = "Running query:";
var G__25100_25102 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2(G__25099_25101,G__25100_25102) : fluree.db.util.log.debug.call(null,G__25099_25101,G__25100_25102));

if(fluree.db.query.fql.cache_QMARK_(query_map)){
return fluree.db.query.fql.cache_query(db,query_map);
} else {
var parsed_query = fluree.db.query.analytical_parse.parse(db,query_map);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"ctx-cache","ctx-cache",-391738418),cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044),new cljs.core.Keyword(null,"strategy","strategy",-1471631918).cljs$core$IFn$_invoke$arity$1(parsed_query))){
return fluree.db.query.subject_crawl.core.simple_subject_crawl(db_STAR_,parsed_query);
} else {
return fluree.db.query.fql.ad_hoc_query(db_STAR_,parsed_query,query_map);
}
}
});
