// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_parse');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.subject_crawl.legacy');
goog.require('fluree.db.query.subject_crawl.reparse');
fluree.db.query.analytical_parse.read_str_fn = cljs.reader.read_string;
fluree.db.query.analytical_parse.safe_read_fn = (function fluree$db$query$analytical_parse$safe_read_fn(code_str){
if(typeof code_str === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((code_str.cljs$core$IFn$_invoke$arity$2 ? code_str.cljs$core$IFn$_invoke$arity$2("Invalid function: ",code_str) : code_str.call(null,"Invalid function: ",code_str)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

try{var code_str_STAR_ = ((clojure.string.starts_with_QMARK_(code_str,"#"))?cljs.core.subs.cljs$core$IFn$_invoke$arity$2(code_str,(1)):code_str);
var res = (fluree.db.query.analytical_parse.read_str_fn.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical_parse.read_str_fn.cljs$core$IFn$_invoke$arity$1(code_str_STAR_) : fluree.db.query.analytical_parse.read_str_fn.call(null,code_str_STAR_));
if(cljs.core.list_QMARK_(res)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((code_str.cljs$core$IFn$_invoke$arity$2 ? code_str.cljs$core$IFn$_invoke$arity$2("Invalid function: ",code_str) : code_str.call(null,"Invalid function: ",code_str)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return res;
}catch (e17966){var e = e17966;
var G__17967_17971 = "Invalid query function attempted: ";
var G__17968_17972 = code_str;
var G__17969_17973 = " with error message: ";
var G__17970_17974 = cljs.core.ex_message(e);
(fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$4(G__17967_17971,G__17968_17972,G__17969_17973,G__17970_17974) : fluree.db.util.log.warn.call(null,G__17967_17971,G__17968_17972,G__17969_17973,G__17970_17974));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((code_str.cljs$core$IFn$_invoke$arity$2 ? code_str.cljs$core$IFn$_invoke$arity$2("Invalid query function: ",code_str) : code_str.call(null,"Invalid query function: ",code_str)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}});
fluree.db.query.analytical_parse.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical_parse$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical_parse$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical_parse$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__17981 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__17981 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__17981;
}
});
var variance = (function fluree$db$query$analytical_parse$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4652__auto__ = (function fluree$db$query$analytical_parse$variance_$_iter__17982(s__17983){
return (new cljs.core.LazySeq(null,(function (){
var s__17983__$1 = s__17983;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__17983__$1);
if(temp__5804__auto__){
var s__17983__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__17983__$2)){
var c__4650__auto__ = cljs.core.chunk_first(s__17983__$2);
var size__4651__auto__ = cljs.core.count(c__4650__auto__);
var b__17985 = cljs.core.chunk_buffer(size__4651__auto__);
if((function (){var i__17984 = (0);
while(true){
if((i__17984 < size__4651__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4650__auto__,i__17984);
var delta = (x - mean);
cljs.core.chunk_append(b__17985,(delta * delta));

var G__17987 = (i__17984 + (1));
i__17984 = G__17987;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__17985),fluree$db$query$analytical_parse$variance_$_iter__17982(cljs.core.chunk_rest(s__17983__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__17985),null);
}
} else {
var x = cljs.core.first(s__17983__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical_parse$variance_$_iter__17982(cljs.core.rest(s__17983__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical_parse$stddev(coll){
var G__17986 = variance(coll);
return Math.sqrt(G__17986);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4336__auto__ = n;
var y__4337__auto__ = (- n);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
}),(function() {
var G__17988 = null;
var G__17988__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__17988__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__17988 = function(n,coll){
switch(arguments.length){
case 1:
return G__17988__1.call(this,n);
case 2:
return G__17988__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17988.cljs$core$IFn$_invoke$arity$1 = G__17988__1;
G__17988.cljs$core$IFn$_invoke$arity$2 = G__17988__2;
return G__17988;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__17989 = null;
var G__17989__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__17989__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__17989 = function(n,coll){
switch(arguments.length){
case 1:
return G__17989__1.call(this,n);
case 2:
return G__17989__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17989.cljs$core$IFn$_invoke$arity$1 = G__17989__1;
G__17989.cljs$core$IFn$_invoke$arity$2 = G__17989__2;
return G__17989;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__17990 = null;
var G__17990__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__17990__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__17990 = function(n,coll){
switch(arguments.length){
case 1:
return G__17990__1.call(this,n);
case 2:
return G__17990__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__17990.cljs$core$IFn$_invoke$arity$1 = G__17990__1;
G__17990.cljs$core$IFn$_invoke$arity$2 = G__17990__2;
return G__17990;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
/**
 * Aggregate as positioned in a :select statement
 */
fluree.db.query.analytical_parse.aggregate_QMARK_ = (function fluree$db$query$analytical_parse$aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
/**
 * Query function as positioned in a :where statement
 */
fluree.db.query.analytical_parse.query_fn_QMARK_ = (function fluree$db$query$analytical_parse$query_fn_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
/**
 * Returns a query variable as a symbol, else nil if not a query variable.
 */
fluree.db.query.analytical_parse.q_var__GT_symbol = (function fluree$db$query$analytical_parse$q_var__GT_symbol(x){
if((((x instanceof cljs.core.Keyword)) || (((((typeof x === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("?",cljs.core.first(x))))) || ((((x instanceof cljs.core.Symbol)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("?",cljs.core.first(cljs.core.name(x)))))))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
} else {
return null;
}
});
/**
 * Returns as var symbol if 'as' function is used in an aggregate,
 *   e.g. (as (sum ?nums) ?sum).
 * 
 *   Checks that has 3 elements to the form, and the last element
 *   is a symbol that starts with a '?'. Else will throw.
 */
fluree.db.query.analytical_parse.extract_aggregate_as = (function fluree$db$query$analytical_parse$extract_aggregate_as(as_fn_parsed){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),cljs.core.count(as_fn_parsed))) && ((cljs.core.last(as_fn_parsed) instanceof cljs.core.Symbol)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate function using 'as': ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([as_fn_parsed], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return cljs.core.last(as_fn_parsed);
});
fluree.db.query.analytical_parse.parse_aggregate = (function fluree$db$query$analytical_parse$parse_aggregate(aggregate_fn_str){
var list_agg = fluree.db.query.analytical_parse.safe_read_fn(aggregate_fn_str);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var func_list = ((as_QMARK_)?cljs.core.second(list_agg):list_agg);
var _ = ((cljs.core.coll_QMARK_(func_list))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aggregate_fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var list_count = cljs.core.count(func_list);
var vec__17991 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aggregate_fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aggregate_fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17991,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17991,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17991,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = (fluree.db.query.analytical_parse.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical_parse.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical_parse.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aggregate_fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__17994 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__17997 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__17997) : agg_fn.call(null,G__17997));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17994,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17994,(1),null);
var as = ((as_QMARK_)?fluree.db.query.analytical_parse.extract_aggregate_as(list_agg):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fun)].join('')));
if((((variable instanceof cljs.core.Symbol)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("?",cljs.core.first(cljs.core.name(variable)))))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Variables used in aggregate functions must start with a '?'. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aggregate_fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),aggregate_fn_str,new cljs.core.Keyword(null,"function","function",-2127255473),agg_fn__$1], null);
});
/**
 * Returns true if provided variable exists as a variable
 *   somewhere within the where clause.
 */
fluree.db.query.analytical_parse.variable_in_where_QMARK_ = (function fluree$db$query$analytical_parse$variable_in_where_QMARK_(variable,where){
return cljs.core.some((function (p__17999){
var map__18000 = p__17999;
var map__18000__$1 = cljs.core.__destructure_map(map__18000);
var _where_smt = map__18000__$1;
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18000__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18000__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
var bind = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18000__$1,new cljs.core.Keyword(null,"bind","bind",-113428417));
var union = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18000__$1,new cljs.core.Keyword(null,"union","union",2142937499));
if(cljs.core.truth_(o)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(variable,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
} else {
if(cljs.core.truth_(optional)){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17998_SHARP_){
return (fluree.db.query.analytical_parse.variable_in_where_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.analytical_parse.variable_in_where_QMARK_.cljs$core$IFn$_invoke$arity$2(variable,p1__17998_SHARP_) : fluree.db.query.analytical_parse.variable_in_where_QMARK_.call(null,variable,p1__17998_SHARP_));
}),optional);
} else {
if(cljs.core.truth_(bind)){
return cljs.core.contains_QMARK_(cljs.core.set(cljs.core.keys(bind)),variable);
} else {
if(cljs.core.truth_(union)){
var or__4253__auto__ = (function (){var G__18001 = variable;
var G__18002 = cljs.core.first(union);
return (fluree.db.query.analytical_parse.variable_in_where_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.analytical_parse.variable_in_where_QMARK_.cljs$core$IFn$_invoke$arity$2(G__18001,G__18002) : fluree.db.query.analytical_parse.variable_in_where_QMARK_.call(null,G__18001,G__18002));
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var G__18003 = variable;
var G__18004 = cljs.core.second(union);
return (fluree.db.query.analytical_parse.variable_in_where_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.analytical_parse.variable_in_where_QMARK_.cljs$core$IFn$_invoke$arity$2(G__18003,G__18004) : fluree.db.query.analytical_parse.variable_in_where_QMARK_.call(null,G__18003,G__18004));
}
} else {
return null;
}
}
}
}
}),where);
});
fluree.db.query.analytical_parse.parse_map = (function fluree$db$query$analytical_parse$parse_map(select_map){
var vec__18005 = cljs.core.first(select_map);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18005,(0),null);
var selection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18005,(1),null);
var var_as_symbol = fluree.db.query.analytical_parse.q_var__GT_symbol(var$);
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(select_map))) || ((var_as_symbol == null)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement, maps must have only one key/val. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_map)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),selection], null);
});
fluree.db.query.analytical_parse.parse_select = (function fluree$db$query$analytical_parse$parse_select(select_smt){
var _ = (function (){var or__4253__auto__ = cljs.core.every_QMARK_((function (p1__18008_SHARP_){
return ((typeof p1__18008_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__18008_SHARP_)));
}),select_smt);
if(or__4253__auto__){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = fluree.db.query.analytical_parse.q_var__GT_symbol(select);
if(cljs.core.truth_(var_symbol)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical_parse.aggregate_QMARK_(select))){
return fluree.db.query.analytical_parse.parse_aggregate(select);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.analytical_parse.parse_map(select);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}),select_smt);
});
fluree.db.query.analytical_parse.add_select_spec = (function fluree$db$query$analytical_parse$add_select_spec(p__18011,p__18012){
var map__18013 = p__18011;
var map__18013__$1 = cljs.core.__destructure_map(map__18013);
var parsed_query = map__18013__$1;
var group_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18013__$1,new cljs.core.Keyword(null,"group-by","group-by",-379139802));
var order_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18013__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18013__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18013__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var pretty_print = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18013__$1,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var map__18014 = p__18012;
var map__18014__$1 = cljs.core.__destructure_map(map__18014);
var _query_map_SINGLEQUOTE_ = map__18014__$1;
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18014__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18014__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18014__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18014__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18014__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18014__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18014__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var select_smt = (function (){var or__4253__auto__ = selectOne;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = select;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var selectOne_QMARK_ = cljs.core.boolean$(selectOne);
var limit_STAR_ = ((selectOne_QMARK_)?(1):limit);
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.analytical_parse.parse_select(select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18009_SHARP_){
return cljs.core.contains_QMARK_(p1__18009_SHARP_,new cljs.core.Keyword(null,"function","function",-2127255473));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__18010_SHARP_){
return cljs.core.contains_QMARK_(p1__18010_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var orderBy_STAR_ = (function (){var temp__5804__auto__ = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return orderBy;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var orderBy__$1 = temp__5804__auto__;
if(cljs.core.truth_((function (){var or__4253__auto__ = typeof orderBy__$1 === 'string';
if(or__4253__auto__){
return or__4253__auto__;
} else {
var and__4251__auto__ = cljs.core.vector_QMARK_(orderBy__$1);
if(and__4251__auto__){
var G__18016 = cljs.core.first(orderBy__$1);
var fexpr__18015 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__18015.cljs$core$IFn$_invoke$arity$1 ? fexpr__18015.cljs$core$IFn$_invoke$arity$1(G__18016) : fexpr__18015.call(null,G__18016));
} else {
return and__4251__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy__$1)){
return orderBy__$1;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy__$1], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(parsed_query,new cljs.core.Keyword(null,"limit","limit",-1355822363),limit_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),selectOne_QMARK_,new cljs.core.Keyword(null,"select","select",1147833503),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(opts),limit_STAR_,(function (){var or__4253__auto__ = offset;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),cljs.core.not_empty(aggregates),selectOne_QMARK_,pretty_print,(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return groupBy;
}
})(),cljs.core.boolean$((function (){var or__4253__auto__ = selectDistinct;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy_STAR_,inVector_QMARK_])], 0));
});
/**
 * Turns keys of var maps into symbols
 */
fluree.db.query.analytical_parse.symbolize_var_keys = (function fluree$db$query$analytical_parse$symbolize_var_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Adds a valid filter fn into the respective where statement(s).
 *   If the filter fn uses a var not found in a where statement, throws
 *   an exception
 */
fluree.db.query.analytical_parse.add_filter_where = (function fluree$db$query$analytical_parse$add_filter_where(where,p__18017){
var map__18018 = p__18017;
var map__18018__$1 = cljs.core.__destructure_map(map__18018);
var filter_fn_map = map__18018__$1;
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18018__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var G__18023 = where;
var vec__18024 = G__18023;
var seq__18025 = cljs.core.seq(vec__18024);
var first__18026 = cljs.core.first(seq__18025);
var seq__18025__$1 = cljs.core.next(seq__18025);
var map__18027 = first__18026;
var map__18027__$1 = cljs.core.__destructure_map(map__18027);
var where_smt = map__18027__$1;
var o = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18027__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var r = seq__18025__$1;
var found_var_QMARK_ = false;
var where_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__18023__$1 = G__18023;
var found_var_QMARK___$1 = found_var_QMARK_;
var where_STAR___$1 = where_STAR_;
while(true){
var vec__18032 = G__18023__$1;
var seq__18033 = cljs.core.seq(vec__18032);
var first__18034 = cljs.core.first(seq__18033);
var seq__18033__$1 = cljs.core.next(seq__18033);
var map__18035 = first__18034;
var map__18035__$1 = cljs.core.__destructure_map(map__18035);
var where_smt__$1 = map__18035__$1;
var o__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18035__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var r__$1 = seq__18033__$1;
var found_var_QMARK___$2 = found_var_QMARK___$1;
var where_STAR___$2 = where_STAR___$1;
if(cljs.core.truth_(where_smt__$1)){
var match_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(variable,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o__$1));
if(match_QMARK_){
var G__18036 = r__$1;
var G__18037 = true;
var G__18038 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_STAR___$2,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(where_smt__$1,new cljs.core.Keyword(null,"o","o",-1350007228),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"filter","filter",-948537934),filter_fn_map], null)));
G__18023__$1 = G__18036;
found_var_QMARK___$1 = G__18037;
where_STAR___$1 = G__18038;
continue;
} else {
var G__18039 = r__$1;
var G__18040 = found_var_QMARK___$2;
var G__18041 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_STAR___$2,where_smt__$1);
G__18023__$1 = G__18039;
found_var_QMARK___$1 = G__18040;
where_STAR___$1 = G__18041;
continue;
}
} else {
if(found_var_QMARK___$2){
return where_STAR___$2;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function uses variable: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable)," however that variable is not used in a where statement ","or was already used in another filter function."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}
break;
}
});
/**
 * Returns a set of valid vars.
 */
fluree.db.query.analytical_parse.get_vars = (function fluree$db$query$analytical_parse$get_vars(code){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,code_segment){
if(cljs.core.coll_QMARK_(code_segment)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,(fluree.db.query.analytical_parse.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical_parse.get_vars.cljs$core$IFn$_invoke$arity$1(code_segment) : fluree.db.query.analytical_parse.get_vars.call(null,code_segment)));
} else {
var temp__5802__auto__ = fluree.db.query.analytical_parse.q_var__GT_symbol(code_segment);
if(cljs.core.truth_(temp__5802__auto__)){
var allowed_var = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,allowed_var);
} else {
return acc;
}
}
}),cljs.core.PersistentHashSet.EMPTY,code);
});
/**
 * Returns the var that will represent flake/o when passed in a flake to execute filter fn.
 * 
 *   There can be multiple vars in the filter function which can utilize the original query's 'vars' map,
 *   however there should be exactly one var in the filter fn that isn't in that map - which should be the
 *   var that will receive flake/o.
 */
fluree.db.query.analytical_parse.get_object_var = (function fluree$db$query$analytical_parse$get_object_var(params,supplied_vars){
var non_assigned_vars = cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p1__18042_SHARP_){
return cljs.core.contains_QMARK_(supplied_vars,p1__18042_SHARP_);
}),params);
var G__18043 = cljs.core.count(non_assigned_vars);
switch (G__18043) {
case (1):
return cljs.core.first(non_assigned_vars);

break;
case (0):
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query filter function has no variable assigned to it, all parameters ","exist in the 'vars' map. Filter function params: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(params),". ","Vars assigned in query: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.vec(cljs.core.keys(supplied_vars))),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Vars used in a filter function are not included in the 'vars' map ","or as a binding. Should only be missing one var, but missing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.vec(non_assigned_vars)),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
});
/**
 * Evals, and returns query function.
 */
fluree.db.query.analytical_parse.parse_filter_fn = (function fluree$db$query$analytical_parse$parse_filter_fn(filter_fn,supplied_vars){
var filter_code = fluree.db.query.analytical_parse.safe_read_fn(filter_fn);
var fn_vars = (function (){var or__4253__auto__ = cljs.core.not_empty(fluree.db.query.analytical_parse.get_vars(filter_code));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var params = cljs.core.vec(fn_vars);
var o_var = fluree.db.query.analytical_parse.get_object_var(params,supplied_vars);
var vec__18045 = fluree.db.query.analytical_filter.extract_filter_fn(filter_code,fn_vars);
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18045,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18045,(1),null);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),o_var,new cljs.core.Keyword(null,"params","params",710516235),params,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),["(fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(params)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fun)].join(''),new cljs.core.Keyword(null,"function","function",-2127255473),fluree.db.query.analytical_filter.make_executable(params,fun)], null);
});
fluree.db.query.analytical_parse.add_filter = (function fluree$db$query$analytical_parse$add_filter(p__18048,filter,supplied_vars){
var map__18049 = p__18048;
var map__18049__$1 = cljs.core.__destructure_map(map__18049);
var parsed_query = map__18049__$1;
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18049__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
if((!(cljs.core.sequential_QMARK_(filter)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter clause must be a vector/array, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var G__18053 = filter;
var vec__18054 = G__18053;
var seq__18055 = cljs.core.seq(vec__18054);
var first__18056 = cljs.core.first(seq__18055);
var seq__18055__$1 = cljs.core.next(seq__18055);
var filter_fn = first__18056;
var r = seq__18055__$1;
var parsed_query_STAR_ = parsed_query;
var G__18053__$1 = G__18053;
var parsed_query_STAR___$1 = parsed_query_STAR_;
while(true){
var vec__18060 = G__18053__$1;
var seq__18061 = cljs.core.seq(vec__18060);
var first__18062 = cljs.core.first(seq__18061);
var seq__18061__$1 = cljs.core.next(seq__18061);
var filter_fn__$1 = first__18062;
var r__$1 = seq__18061__$1;
var parsed_query_STAR___$2 = parsed_query_STAR___$1;
if(cljs.core.truth_(filter_fn__$1)){
var parsed = fluree.db.query.analytical_parse.parse_filter_fn(filter_fn__$1,supplied_vars);
var G__18063 = r__$1;
var G__18064 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(parsed_query_STAR___$2,new cljs.core.Keyword(null,"where","where",-2044795965),fluree.db.query.analytical_parse.add_filter_where(where,parsed));
G__18053__$1 = G__18063;
parsed_query_STAR___$1 = G__18064;
continue;
} else {
return parsed_query_STAR___$2;
}
break;
}
}
});
/**
 * Parses binding map. Returns a two-tuple of binding maps
 *   including aggregates and scalars, for bindings that are
 *   aggregate functions vs static scalar values.
 * 
 *   Scalars end up getting hoisted, and essentially merged
 *   with query :vars - this way filter functions that get
 *   merged into their respective where statements will have
 *   the variable available to them.
 */
fluree.db.query.analytical_parse.parse_binding = (function fluree$db$query$analytical_parse$parse_binding(bind_map){
return cljs.core.reduce_kv((function (p__18065,k,v){
var vec__18066 = p__18065;
var aggregates = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18066,(0),null);
var scalars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18066,(1),null);
if(cljs.core.truth_(fluree.db.query.analytical_parse.query_fn_QMARK_(v))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(aggregates,k,fluree.db.query.analytical_parse.parse_aggregate(v)),scalars], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [aggregates,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(scalars,k,v)], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY], null),bind_map);
});
/**
 * When a where clause is a map, parses it into accumulating parsed where.
 *   Note parsed-where is not complete, but only has where clauses parsed that
 *   preceded the map clause.
 * 
 *   Returns a two-tuple of where-map type (i.e. :filter, :bind, :union .. etc.) and
 *   updated where clause. Updates where clause because a filter function may impact
 *   a prior where statement.
 *   
 */
fluree.db.query.analytical_parse.parse_where_map = (function fluree$db$query$analytical_parse$parse_where_map(db,parsed_where,map_clause,supplied_vars){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(map_clause))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Where clause maps can only have one key/val, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(map_clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

var vec__18070 = cljs.core.first(map_clause);
var clause_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18070,(0),null);
var clause_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18070,(1),null);
var G__18073 = clause_type;
var G__18073__$1 = (((G__18073 instanceof cljs.core.Keyword))?G__18073.fqn:null);
switch (G__18073__$1) {
case "filter":
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"filter","filter",-948537934),clause_val], null);

break;
case "optional":
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"optional","optional",2053951509),new cljs.core.Keyword(null,"where","where",-2044795965),(function (){var G__18074 = db;
var G__18075 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"where","where",-2044795965),clause_val], null);
var G__18076 = supplied_vars;
return (fluree.db.query.analytical_parse.parse_where.cljs$core$IFn$_invoke$arity$3 ? fluree.db.query.analytical_parse.parse_where.cljs$core$IFn$_invoke$arity$3(G__18074,G__18075,G__18076) : fluree.db.query.analytical_parse.parse_where.call(null,G__18074,G__18075,G__18076));
})()], null);

break;
case "union":
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),cljs.core.count(clause_val))){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"union","union",2142937499),new cljs.core.Keyword(null,"where","where",-2044795965),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__18069_SHARP_){
var G__18077 = db;
var G__18078 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"where","where",-2044795965),p1__18069_SHARP_], null);
var G__18079 = supplied_vars;
return (fluree.db.query.analytical_parse.parse_where.cljs$core$IFn$_invoke$arity$3 ? fluree.db.query.analytical_parse.parse_where.cljs$core$IFn$_invoke$arity$3(G__18077,G__18078,G__18079) : fluree.db.query.analytical_parse.parse_where.call(null,G__18077,G__18078,G__18079));
}),clause_val)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid where clause, 'union' clause must have exactly two solutions. ","Each solution must be its own 'where' clause wrapped in a vector"].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

break;
case "bind":
if(cljs.core.map_QMARK_(clause_val)){
var bind_map = fluree.db.query.analytical_parse.symbolize_var_keys(clause_val);
var vec__18080 = fluree.db.query.analytical_parse.parse_binding(bind_map);
var aggregates = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18080,(0),null);
var scalars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18080,(1),null);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"bind","bind",-113428417),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),aggregates,new cljs.core.Keyword(null,"scalars","scalars",-350192527),scalars], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid where clause, 'bind' must be a map with binding vars as keys ","and binding scalars, or aggregates, as values."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

break;
case "minus":
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid where clause, Fluree does not yet support the 'minus' operation.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid where clause, unsupported where clause operation: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause_type)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
});
/**
 * Parses a two-tuple variable binding where clause
 */
fluree.db.query.analytical_parse.parse_binding_tuple = (function fluree$db$query$analytical_parse$parse_binding_tuple(binding_var,binding_val){
var var$ = fluree.db.query.analytical_parse.q_var__GT_symbol(binding_var);
var fn_QMARK_ = fluree.db.query.analytical_parse.query_fn_QMARK_(binding_val);
if(cljs.core.truth_(fn_QMARK_)){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword(null,"variable","variable",-281346492),var$,new cljs.core.Keyword(null,"fn","fn",-1175266204),binding_val], null);
} else {
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword(null,"variable","variable",-281346492),var$,new cljs.core.Keyword(null,"value","value",305978217),binding_val], null);
}
});
/**
 * For both 's' and 'o', returns a map with respective value
 *   that indicates the value's type and if needed other information.
 * 
 * 
 *   'o' values have special handling before calling this function as they can
 *   also have 'tag' values or query-functions.
 */
fluree.db.query.analytical_parse.value_type_map = (function fluree$db$query$analytical_parse$value_type_map(value){
if(fluree.db.util.core.pred_ident_QMARK_(value)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ident","ident",-742346),value], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical_parse.q_var__GT_symbol(value))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),fluree.db.query.analytical_parse.q_var__GT_symbol(value)], null);
} else {
if((value == null)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),value], null);

}
}
}
});
/**
 * Parses where clause tuples (not maps)
 */
fluree.db.query.analytical_parse.parse_where_tuple = (function fluree$db$query$analytical_parse$parse_where_tuple(supplied_vars,db,s,p,o){
var fulltext_QMARK_ = clojure.string.starts_with_QMARK_(p,"fullText:");
var rdf_type_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("rdf:type",p)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("a",p)));
var _id_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",p);
var s_STAR_ = fluree.db.query.analytical_parse.value_type_map(s);
var p_STAR_ = ((fulltext_QMARK_)?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text queries not supported in JavaScript currently.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((rdf_type_QMARK_)?new cljs.core.Keyword("rdf","type","rdf/type",1175423232):((_id_QMARK_)?new cljs.core.Keyword(null,"_id","_id",-789960287):(cljs.core.truth_(db)?(function (){var or__4253__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():p)
)));
var p_idx_QMARK_ = (cljs.core.truth_(p_STAR_)?fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p_STAR_):null);
var p_tag_QMARK_ = (cljs.core.truth_(p_STAR_)?cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p)):null);
var o_STAR_ = (cljs.core.truth_(p_tag_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),o], null):(cljs.core.truth_(fluree.db.query.analytical_parse.query_fn_QMARK_(o))?(function (){var parsed_filter_map = fluree.db.query.analytical_parse.parse_filter_fn(o,supplied_vars);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(parsed_filter_map),new cljs.core.Keyword(null,"filter","filter",-948537934),parsed_filter_map], null);
})():fluree.db.query.analytical_parse.value_type_map(o)
));
var idx = ((fulltext_QMARK_)?new cljs.core.Keyword(null,"full-text","full-text",1432444182):((((_id_QMARK_) || (rdf_type_QMARK_)))?new cljs.core.Keyword(null,"spot","spot",-1706962147):(cljs.core.truth_((function (){var and__4251__auto__ = s_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(s_STAR_));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword(null,"spot","spot",-1706962147):(cljs.core.truth_((function (){var and__4251__auto__ = p_idx_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o_STAR_);
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword(null,"post","post",269697687):(cljs.core.truth_(p)?(function (){
if(cljs.core.truth_(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o_STAR_))){
var G__18084_18085 = ["Searching for a property value on unindexed predicate: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),". Consider making property indexed for improved performance ","and lower fuel consumption."].join('');
(fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$1(G__18084_18085) : fluree.db.util.log.info.call(null,G__18084_18085));
} else {
}

return new cljs.core.Keyword(null,"psot","psot",2111653059);
})()
:(cljs.core.truth_(o)?new cljs.core.Keyword(null,"opst","opst",1213963058):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unable to determine query type for where statement: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [s,p,o], null)),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
))))));
return new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"type","type",1174270348),((fulltext_QMARK_)?new cljs.core.Keyword(null,"full-text","full-text",1432444182):((rdf_type_QMARK_)?new cljs.core.Keyword("rdf","type","rdf/type",1175423232):((_id_QMARK_)?new cljs.core.Keyword(null,"_id","_id",-789960287):new cljs.core.Keyword(null,"tuple","tuple",-472667284)
))),new cljs.core.Keyword(null,"idx","idx",1053688473),idx,new cljs.core.Keyword(null,"s","s",1705939918),s_STAR_,new cljs.core.Keyword(null,"p","p",151049309),p_STAR_,new cljs.core.Keyword(null,"o","o",-1350007228),o_STAR_,new cljs.core.Keyword(null,"p-tag?","p-tag?",2131007743),p_tag_QMARK_,new cljs.core.Keyword(null,"p-idx?","p-idx?",977503771),p_idx_QMARK_], null);
});
/**
 * When a specific DB is used (not default) for a where statement.
 *   This is in the form of a 4-tuple where clause.
 */
fluree.db.query.analytical_parse.parse_remote_tuple = (function fluree$db$query$analytical_parse$parse_remote_tuple(supplied_vars,db,s,p,o){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"remote-tuple","remote-tuple",-1236726618),new cljs.core.Keyword(null,"s","s",1705939918),s,new cljs.core.Keyword(null,"p","p",151049309),p,new cljs.core.Keyword(null,"o","o",-1350007228),o], null);
});
/**
 * Parses where clause
 */
fluree.db.query.analytical_parse.parse_where = (function fluree$db$query$analytical_parse$parse_where(db,p__18086,supplied_vars){
var map__18087 = p__18086;
var map__18087__$1 = cljs.core.__destructure_map(map__18087);
var _query_map_SINGLEQUOTE_ = map__18087__$1;
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18087__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
if(cljs.core.sequential_QMARK_(where)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid where clause, must be a vector of tuples and/or maps: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var G__18091 = where;
var vec__18092 = G__18091;
var seq__18093 = cljs.core.seq(vec__18092);
var first__18094 = cljs.core.first(seq__18093);
var seq__18093__$1 = cljs.core.next(seq__18093);
var where_smt = first__18094;
var r = seq__18093__$1;
var filters = cljs.core.PersistentVector.EMPTY;
var hoisted_bind = cljs.core.PersistentArrayMap.EMPTY;
var supplied_vars_STAR_ = supplied_vars;
var where_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__18091__$1 = G__18091;
var filters__$1 = filters;
var hoisted_bind__$1 = hoisted_bind;
var supplied_vars_STAR___$1 = supplied_vars_STAR_;
var where_STAR___$1 = where_STAR_;
while(true){
var vec__18102 = G__18091__$1;
var seq__18103 = cljs.core.seq(vec__18102);
var first__18104 = cljs.core.first(seq__18103);
var seq__18103__$1 = cljs.core.next(seq__18103);
var where_smt__$1 = first__18104;
var r__$1 = seq__18103__$1;
var filters__$2 = filters__$1;
var hoisted_bind__$2 = hoisted_bind__$1;
var supplied_vars_STAR___$2 = supplied_vars_STAR___$1;
var where_STAR___$2 = where_STAR___$1;
if(cljs.core.truth_(where_smt__$1)){
if(cljs.core.map_QMARK_(where_smt__$1)){
var map__18105 = fluree.db.query.analytical_parse.parse_where_map(db,where_STAR___$2,where_smt__$1,supplied_vars_STAR___$2);
var map__18105__$1 = cljs.core.__destructure_map(map__18105);
var where_map = map__18105__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18105__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var G__18106 = type;
var G__18106__$1 = (((G__18106 instanceof cljs.core.Keyword))?G__18106.fqn:null);
switch (G__18106__$1) {
case "bind":
var map__18107 = where_map;
var map__18107__$1 = cljs.core.__destructure_map(map__18107);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18107__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var scalars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18107__$1,new cljs.core.Keyword(null,"scalars","scalars",-350192527));
var G__18110 = r__$1;
var G__18111 = filters__$2;
var G__18112 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([hoisted_bind__$2,scalars], 0));
var G__18113 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([supplied_vars_STAR___$2,aggregates,scalars], 0));
var G__18114 = (cljs.core.truth_(cljs.core.not_empty(aggregates))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_STAR___$2,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"bind","bind",-113428417),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),aggregates], null)):where_STAR___$2);
G__18091__$1 = G__18110;
filters__$1 = G__18111;
hoisted_bind__$1 = G__18112;
supplied_vars_STAR___$1 = G__18113;
where_STAR___$1 = G__18114;
continue;

break;
case "filter":
var G__18115 = r__$1;
var G__18116 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(filters__$2,new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(where_map));
var G__18117 = hoisted_bind__$2;
var G__18118 = supplied_vars_STAR___$2;
var G__18119 = where_STAR___$2;
G__18091__$1 = G__18115;
filters__$1 = G__18116;
hoisted_bind__$1 = G__18117;
supplied_vars_STAR___$1 = G__18118;
where_STAR___$1 = G__18119;
continue;

break;
default:
var G__18120 = r__$1;
var G__18121 = filters__$2;
var G__18122 = hoisted_bind__$2;
var G__18123 = supplied_vars_STAR___$2;
var G__18124 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_STAR___$2,where_map);
G__18091__$1 = G__18120;
filters__$1 = G__18121;
hoisted_bind__$1 = G__18122;
supplied_vars_STAR___$1 = G__18123;
where_STAR___$1 = G__18124;
continue;

}
} else {
if(cljs.core.sequential_QMARK_(where_smt__$1)){
var tuple_count = cljs.core.count(where_smt__$1);
var where_smt_STAR_ = (function (){var G__18108 = tuple_count;
switch (G__18108) {
case (3):
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(fluree.db.query.analytical_parse.parse_where_tuple,supplied_vars_STAR___$2,db,where_smt__$1);

break;
case (4):
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.query.analytical_parse.parse_remote_tuple,supplied_vars_STAR___$2,where_smt__$1);

break;
case (2):
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_parse.parse_binding_tuple,where_smt__$1);

break;
default:
if(cljs.core.sequential_QMARK_(cljs.core.first(where_smt__$1))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid where clause, it should contain 2, 3 or 4 tuples. ","It appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where_smt__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid where clause, it should contain 2, 3 or 4 tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where_smt__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

}
})();
var G__18126 = r__$1;
var G__18127 = filters__$2;
var G__18128 = hoisted_bind__$2;
var G__18129 = supplied_vars_STAR___$2;
var G__18130 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_STAR___$2,where_smt_STAR_);
G__18091__$1 = G__18126;
filters__$1 = G__18127;
hoisted_bind__$1 = G__18128;
supplied_vars_STAR___$1 = G__18129;
where_STAR___$1 = G__18130;
continue;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid where clause, must be a vector of tuples and/or maps: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
} else {
var where_PLUS_filters = ((cljs.core.seq(filters__$2))?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__18091__$1,filters__$1,hoisted_bind__$1,supplied_vars_STAR___$1,where_STAR___$1,vec__18102,seq__18103,first__18104,seq__18103__$1,where_smt__$1,r__$1,filters__$2,hoisted_bind__$2,supplied_vars_STAR___$2,where_STAR___$2,G__18091,vec__18092,seq__18093,first__18094,seq__18093__$1,where_smt,r,filters,hoisted_bind,supplied_vars_STAR_,where_STAR_,map__18087,map__18087__$1,_query_map_SINGLEQUOTE_,where){
return (function (where_SINGLEQUOTE_,filter){
return new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(fluree.db.query.analytical_parse.add_filter(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"where","where",-2044795965),where_SINGLEQUOTE_], null),filter,supplied_vars_STAR___$2));
});})(G__18091__$1,filters__$1,hoisted_bind__$1,supplied_vars_STAR___$1,where_STAR___$1,vec__18102,seq__18103,first__18104,seq__18103__$1,where_smt__$1,r__$1,filters__$2,hoisted_bind__$2,supplied_vars_STAR___$2,where_STAR___$2,G__18091,vec__18092,seq__18093,first__18094,seq__18093__$1,where_smt,r,filters,hoisted_bind,supplied_vars_STAR_,where_STAR_,map__18087,map__18087__$1,_query_map_SINGLEQUOTE_,where))
,where_STAR___$2,filters__$2):where_STAR___$2);
if(cljs.core.truth_(cljs.core.not_empty(hoisted_bind__$2))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"bind","bind",-113428417),new cljs.core.Keyword(null,"scalars","scalars",-350192527),hoisted_bind__$2], null)], null),where_PLUS_filters);
} else {
return where_PLUS_filters;
}
}
break;
}
});
/**
 * Returns query map without vars, to allow more effective caching of parsing.
 */
fluree.db.query.analytical_parse.extract_vars = (function fluree$db$query$analytical_parse$extract_vars(query_map){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"vars","vars",-2046957217));
});
fluree.db.query.analytical_parse.parse_order_by = (function fluree$db$query$analytical_parse$parse_order_by(order_by_clause){
var throw_BANG_ = (function (msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4253__auto__ = msg;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return ["Invalid orderBy clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(order_by_clause)].join('');
}
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
var vec__18131 = ((cljs.core.vector_QMARK_(order_by_clause))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.second(order_by_clause),cljs.core.first(order_by_clause)], null):((typeof order_by_clause === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [order_by_clause,new cljs.core.Keyword(null,"asc","asc",356854569)], null):throw_BANG_(null)
));
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18131,(0),null);
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18131,(1),null);
var order_STAR_ = (function (){var G__18134 = order;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"asc","asc",356854569),G__18134)){
return order;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"desc","desc",2093485764),G__18134)){
return order;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("ASC",G__18134)){
return new cljs.core.Keyword(null,"asc","asc",356854569);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",G__18134)){
return new cljs.core.Keyword(null,"desc","desc",2093485764);
} else {
return throw_BANG_(null);

}
}
}
}
})();
var pred_var = fluree.db.query.analytical_parse.q_var__GT_symbol(pred);
if(cljs.core.truth_(pred_var)){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"variable","variable",-281346492),new cljs.core.Keyword(null,"order","order",-1254677256),order_STAR_,new cljs.core.Keyword(null,"variable","variable",-281346492),pred_var], null);
} else {
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.Keyword(null,"order","order",-1254677256),order_STAR_,new cljs.core.Keyword(null,"predicate","predicate",-1742501860),pred], null);
}
});
/**
 * Parses order-by and returns a map with more details
 *   Map contains keys:
 * :type      - contains :variable or :predicate for type
 * :order     - :asc or :desc
 * :predicate - predicate name, if :predicate type
 * :variable  - variable name, if :variable type
 */
fluree.db.query.analytical_parse.add_order_by = (function fluree$db$query$analytical_parse$add_order_by(p__18135,db,order_by){
var map__18136 = p__18135;
var map__18136__$1 = cljs.core.__destructure_map(map__18136);
var parsed_query = map__18136__$1;
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18136__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var map__18137 = fluree.db.query.analytical_parse.parse_order_by(order_by);
var map__18137__$1 = cljs.core.__destructure_map(map__18137);
var parsed_order_by = map__18137__$1;
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18137__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
if(cljs.core.truth_((function (){var and__4251__auto__ = variable;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(fluree.db.query.analytical_parse.variable_in_where_QMARK_(variable,where));
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Order by specifies a variable, ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable)," that is used in a where statement."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(parsed_query,new cljs.core.Keyword(null,"order-by","order-by",1527318070),parsed_order_by);
});
fluree.db.query.analytical_parse.add_group_by = (function fluree$db$query$analytical_parse$add_group_by(p__18139,group_by){
var map__18140 = p__18139;
var map__18140__$1 = cljs.core.__destructure_map(map__18140);
var parsed_query = map__18140__$1;
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18140__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var group_by_STAR_ = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_parse.q_var__GT_symbol,((cljs.core.sequential_QMARK_(group_by))?group_by:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [group_by], null)));
if(cljs.core.every_QMARK_(cljs.core.symbol_QMARK_,group_by_STAR_)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Group by must only include variable(s), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(group_by)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.every_QMARK_((function (p1__18138_SHARP_){
return fluree.db.query.analytical_parse.variable_in_where_QMARK_(p1__18138_SHARP_,where);
}),group_by_STAR_)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Group by includes variable(s) not specified in the where clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(group_by)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(parsed_query,new cljs.core.Keyword(null,"group-by","group-by",-379139802),group_by_STAR_);
});
/**
 * Extracts limit, if available, and verifies it is a positive integer.
 *   Uses Integer/max as default if not present.
 */
fluree.db.query.analytical_parse.get_limit = (function fluree$db$query$analytical_parse$get_limit(p__18141){
var map__18142 = p__18141;
var map__18142__$1 = cljs.core.__destructure_map(map__18142);
var _query_map_SINGLEQUOTE_ = map__18142__$1;
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18142__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18142__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var limit_STAR_ = (function (){var or__4253__auto__ = limit;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return (2147483647);
}
}
})();
if(cljs.core.pos_int_QMARK_(limit_STAR_)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid query limit specified: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit_STAR_)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return limit_STAR_;
});
/**
 * Extracts offset, if specified, and verifies it is a positive integer.
 *   Uses 0 as default if not present.
 */
fluree.db.query.analytical_parse.get_offset = (function fluree$db$query$analytical_parse$get_offset(p__18143){
var map__18144 = p__18143;
var map__18144__$1 = cljs.core.__destructure_map(map__18144);
var _query_map_SINGLEQUOTE_ = map__18144__$1;
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18144__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18144__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var offset_STAR_ = (function (){var or__4253__auto__ = offset;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return (0);
}
}
})();
if((offset_STAR_ >= (0))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid query offset specified: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset_STAR_)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return offset_STAR_;
});
/**
 * Extracts max-fuel from query if specified, or uses Integer/max a default.
 */
fluree.db.query.analytical_parse.get_max_fuel = (function fluree$db$query$analytical_parse$get_max_fuel(p__18145){
var map__18146 = p__18145;
var map__18146__$1 = cljs.core.__destructure_map(map__18146);
var query_map_SINGLEQUOTE_ = map__18146__$1;
var fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18146__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18146__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
if(cljs.core.truth_(max_fuel)){
(fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$2("Deprecated max-fuel used in query: ",query_map_SINGLEQUOTE_) : fluree.db.util.log.info.call(null,"Deprecated max-fuel used in query: ",query_map_SINGLEQUOTE_));
} else {
}

var max_fuel__$1 = ((typeof max_fuel === 'number')?max_fuel:((typeof fuel === 'number')?fuel:(2147483647)
));
if((max_fuel__$1 > (0))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid query fuel specified: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return max_fuel__$1;
});
/**
 * Expands a relational bindings vars definition where it was not supplied
 *   as a vector of maps, but instead a map with one or more vectors as vals.
 *   e.g.
 *   {?x [1 2 3 4]}
 *   {?x [1 2 3 4]
 * ?y ['a' 'b' 'c' 'd']}
 *   {?x [1 2 3 4]
 * ?y 'some-constant-var'}
 * 
 *   Returns a vector of full vars maps.
 */
fluree.db.query.analytical_parse.expand_var_rel_binding = (function fluree$db$query$analytical_parse$expand_var_rel_binding(supplied_vars){
var ks = cljs.core.keys(supplied_vars);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__18148_SHARP_){
return cljs.core.zipmap(ks,p1__18148_SHARP_);
}),cljs.core.partition.cljs$core$IFn$_invoke$arity$2(cljs.core.count(ks),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__18147_SHARP_){
if(cljs.core.sequential_QMARK_(p1__18147_SHARP_)){
return p1__18147_SHARP_;
} else {
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(p1__18147_SHARP_);
}
}),cljs.core.vals(supplied_vars)))));
});
/**
 * Turns all var keys into symbols.
 *   If multiple vars (relational bindings) then will
 *   return a vector of vars maps.
 */
fluree.db.query.analytical_parse.coerce_vars = (function fluree$db$query$analytical_parse$coerce_vars(supplied_vars){
if(cljs.core.truth_(supplied_vars)){
if(cljs.core.sequential_QMARK_(supplied_vars)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_parse.symbolize_var_keys,supplied_vars);
} else {
var supplied_vars_STAR_ = fluree.db.query.analytical_parse.symbolize_var_keys(supplied_vars);
var rel_binding_QMARK_ = cljs.core.some(cljs.core.sequential_QMARK_,cljs.core.vals(supplied_vars_STAR_));
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.analytical_parse.expand_var_rel_binding(supplied_vars_STAR_);
} else {
return supplied_vars_STAR_;
}
}
} else {
return null;
}
});
/**
 * Returns true if the query is the legacy 'basic query' type.
 *   e.g.:
 * {select [*], from: '_user'}
 * {select [*], from: ['_user/username' 'userid']}
 * {select [*], from: '_user', where: '_user/username = userid'}
 */
fluree.db.query.analytical_parse.basic_query_QMARK_ = (function fluree$db$query$analytical_parse$basic_query_QMARK_(p__18149){
var map__18150 = p__18149;
var map__18150__$1 = cljs.core.__destructure_map(map__18150);
var _query_map = map__18150__$1;
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18150__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
return (!(cljs.core.sequential_QMARK_(where)));
});
fluree.db.query.analytical_parse.parse_STAR_ = (function fluree$db$query$analytical_parse$parse_STAR_(db,p__18151,supplied_vars){
var map__18152 = p__18151;
var map__18152__$1 = cljs.core.__destructure_map(map__18152);
var query_map_SINGLEQUOTE_ = map__18152__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18152__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18152__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var filter = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18152__$1,new cljs.core.Keyword(null,"filter","filter",-948537934));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18152__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18152__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var rel_binding_QMARK_ = cljs.core.sequential_QMARK_(supplied_vars);
var supplied_var_keys = ((rel_binding_QMARK_)?cljs.core.set(cljs.core.keys(cljs.core.first(supplied_vars))):cljs.core.set(cljs.core.keys(supplied_vars)));
var parsed = (function (){var G__18153 = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094),new cljs.core.Keyword(null,"strategy","strategy",-1471631918),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"supplied-vars","supplied-vars",-919438628)],[fluree.db.query.analytical_parse.parse_where(db,query_map_SINGLEQUOTE_,supplied_var_keys),fluree.db.query.analytical_parse.get_limit(query_map_SINGLEQUOTE_),fluree.db.query.analytical_parse.get_offset(query_map_SINGLEQUOTE_),fluree.db.query.analytical_parse.get_max_fuel(query_map_SINGLEQUOTE_),rel_binding_QMARK_,new cljs.core.Keyword(null,"legacy","legacy",1434943289),opts,((cljs.core.boolean_QMARK_(prettyPrint))?prettyPrint:new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts)),supplied_var_keys]);
var G__18153__$1 = (cljs.core.truth_(filter)?fluree.db.query.analytical_parse.add_filter(G__18153,filter,supplied_var_keys):G__18153);
var G__18153__$2 = (cljs.core.truth_(orderBy)?fluree.db.query.analytical_parse.add_order_by(G__18153__$1,db,orderBy):G__18153__$1);
var G__18153__$3 = (cljs.core.truth_(groupBy)?fluree.db.query.analytical_parse.add_group_by(G__18153__$2,groupBy):G__18153__$2);
return fluree.db.query.analytical_parse.add_select_spec(G__18153__$3,query_map_SINGLEQUOTE_);

})();
var or__4253__auto__ = fluree.db.query.subject_crawl.reparse.re_parse_as_simple_subj_crawl(parsed);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return parsed;
}
});
fluree.db.query.analytical_parse.parse = (function fluree$db$query$analytical_parse$parse(db,query_map){
var query_map_STAR_ = ((fluree.db.query.analytical_parse.basic_query_QMARK_(query_map))?fluree.db.query.subject_crawl.legacy.basic_to_analytical_transpiler(query_map):query_map);
var map__18154 = query_map_STAR_;
var map__18154__$1 = cljs.core.__destructure_map(map__18154);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18154__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var vars_STAR_ = fluree.db.query.analytical_parse.coerce_vars(vars);
var parsed_query = fluree.db.query.analytical_parse.parse_STAR_(db,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map_STAR_,new cljs.core.Keyword(null,"vars","vars",-2046957217)),vars_STAR_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(parsed_query,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars_STAR_);
});
