// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.range');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27307 = arguments.length;
var i__4865__auto___27308 = (0);
while(true){
if((i__4865__auto___27308 < len__4864__auto___27307)){
args__4870__auto__.push((arguments[i__4865__auto___27308]));

var G__27309 = (i__4865__auto___27308 + (1));
i__4865__auto___27308 = G__27309;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
var G__27302_27310 = e;
var G__27303_27311 = "Function Error: ";
var G__27304_27312 = function_name;
var G__27305_27313 = "args: ";
var G__27306_27314 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5(G__27302_27310,G__27303_27311,G__27304_27312,G__27305_27313,G__27306_27314) : fluree.db.util.log.error.call(null,G__27302_27310,G__27303_27311,G__27304_27312,G__27305_27313,G__27306_27314));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq27299){
var G__27300 = cljs.core.first(seq27299);
var seq27299__$1 = cljs.core.next(seq27299);
var G__27301 = cljs.core.first(seq27299__$1);
var seq27299__$2 = cljs.core.next(seq27299__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27300,G__27301,seq27299__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e27315){var e = e27315;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e27316){var e = e27316;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e27317){var e = e27317;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e27318){var e = e27318;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e27319){var e = e27319;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27322 = arguments.length;
var i__4865__auto___27323 = (0);
while(true){
if((i__4865__auto___27323 < len__4864__auto___27322)){
args__4870__auto__.push((arguments[i__4865__auto___27323]));

var G__27324 = (i__4865__auto___27323 + (1));
i__4865__auto___27323 = G__27324;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e27321){var e = e27321;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq27320){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27320));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27327 = arguments.length;
var i__4865__auto___27328 = (0);
while(true){
if((i__4865__auto___27328 < len__4864__auto___27327)){
args__4870__auto__.push((arguments[i__4865__auto___27328]));

var G__27329 = (i__4865__auto___27328 + (1));
i__4865__auto___27328 = G__27329;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e27326){var e = e27326;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq27325){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27325));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e27330){var e = e27330;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27333 = arguments.length;
var i__4865__auto___27334 = (0);
while(true){
if((i__4865__auto___27334 < len__4864__auto___27333)){
args__4870__auto__.push((arguments[i__4865__auto___27334]));

var G__27335 = (i__4865__auto___27334 + (1));
i__4865__auto___27334 = G__27335;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e27332){var e = e27332;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq27331){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27331));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27338 = arguments.length;
var i__4865__auto___27339 = (0);
while(true){
if((i__4865__auto___27339 < len__4864__auto___27338)){
args__4870__auto__.push((arguments[i__4865__auto___27339]));

var G__27340 = (i__4865__auto___27339 + (1));
i__4865__auto___27339 = G__27340;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e27337){var e = e27337;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq27336){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27336));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e27341){var e = e27341;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e27342){var e = e27342;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27345 = arguments.length;
var i__4865__auto___27346 = (0);
while(true){
if((i__4865__auto___27346 < len__4864__auto___27345)){
args__4870__auto__.push((arguments[i__4865__auto___27346]));

var G__27347 = (i__4865__auto___27346 + (1));
i__4865__auto___27346 = G__27347;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e27344){var e = e27344;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq27343){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27343));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27350 = arguments.length;
var i__4865__auto___27351 = (0);
while(true){
if((i__4865__auto___27351 < len__4864__auto___27350)){
args__4870__auto__.push((arguments[i__4865__auto___27351]));

var G__27352 = (i__4865__auto___27351 + (1));
i__4865__auto___27351 = G__27352;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e27349){var e = e27349;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq27348){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27348));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27355 = arguments.length;
var i__4865__auto___27356 = (0);
while(true){
if((i__4865__auto___27356 < len__4864__auto___27355)){
args__4870__auto__.push((arguments[i__4865__auto___27356]));

var G__27357 = (i__4865__auto___27356 + (1));
i__4865__auto___27356 = G__27357;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e27354){var e = e27354;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq27353){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27353));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27360 = arguments.length;
var i__4865__auto___27361 = (0);
while(true){
if((i__4865__auto___27361 < len__4864__auto___27360)){
args__4870__auto__.push((arguments[i__4865__auto___27361]));

var G__27362 = (i__4865__auto___27361 + (1));
i__4865__auto___27361 = G__27362;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e27359){var e = e27359;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq27358){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27358));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27365 = arguments.length;
var i__4865__auto___27366 = (0);
while(true){
if((i__4865__auto___27366 < len__4864__auto___27365)){
args__4870__auto__.push((arguments[i__4865__auto___27366]));

var G__27367 = (i__4865__auto___27366 + (1));
i__4865__auto___27366 = G__27367;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e27364){var e = e27364;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq27363){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27363));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27370 = arguments.length;
var i__4865__auto___27371 = (0);
while(true){
if((i__4865__auto___27371 < len__4864__auto___27370)){
args__4870__auto__.push((arguments[i__4865__auto___27371]));

var G__27372 = (i__4865__auto___27371 + (1));
i__4865__auto___27371 = G__27372;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e27369){var e = e27369;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq27368){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27368));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27375 = arguments.length;
var i__4865__auto___27376 = (0);
while(true){
if((i__4865__auto___27376 < len__4864__auto___27375)){
args__4870__auto__.push((arguments[i__4865__auto___27376]));

var G__27377 = (i__4865__auto___27376 + (1));
i__4865__auto___27376 = G__27377;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e27374){var e = e27374;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq27373){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27373));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__27379 = arguments.length;
switch (G__27379) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27407){
var state_val_27408 = (state_27407[(1)]);
if((state_val_27408 === (7))){
var inst_27392 = (state_27407[(7)]);
var inst_27395 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_27392,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_27407__$1 = state_27407;
var statearr_27409_27495 = state_27407__$1;
(statearr_27409_27495[(2)] = inst_27395);

(statearr_27409_27495[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27408 === (1))){
var state_27407__$1 = state_27407;
var statearr_27410_27496 = state_27407__$1;
(statearr_27410_27496[(2)] = null);

(statearr_27410_27496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27408 === (4))){
var inst_27380 = (state_27407[(2)]);
var state_27407__$1 = state_27407;
var statearr_27411_27497 = state_27407__$1;
(statearr_27411_27497[(2)] = inst_27380);

(statearr_27411_27497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27408 === (6))){
var inst_27392 = (state_27407[(7)]);
var inst_27392__$1 = (state_27407[(2)]);
var inst_27393 = fluree.db.util.core.exception_QMARK_(inst_27392__$1);
var state_27407__$1 = (function (){var statearr_27412 = state_27407;
(statearr_27412[(7)] = inst_27392__$1);

return statearr_27412;
})();
if(inst_27393){
var statearr_27413_27498 = state_27407__$1;
(statearr_27413_27498[(1)] = (7));

} else {
var statearr_27414_27499 = state_27407__$1;
(statearr_27414_27499[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27408 === (3))){
var inst_27405 = (state_27407[(2)]);
var state_27407__$1 = state_27407;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27407__$1,inst_27405);
} else {
if((state_val_27408 === (2))){
var inst_27386 = (state_27407[(8)]);
var _ = (function (){var statearr_27416 = state_27407;
(statearr_27416[(4)] = cljs.core.cons((5),(state_27407[(4)])));

return statearr_27416;
})();
var inst_27386__$1 = cljs.core.volatile_BANG_((0));
var inst_27387 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_27388 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_27387,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_27386__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_27389 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_27388);
var inst_27390 = fluree.db.query.fql.query(db,inst_27389);
var state_27407__$1 = (function (){var statearr_27417 = state_27407;
(statearr_27417[(8)] = inst_27386__$1);

return statearr_27417;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27407__$1,(6),inst_27390);
} else {
if((state_val_27408 === (9))){
var inst_27402 = (state_27407[(2)]);
var _ = (function (){var statearr_27418 = state_27407;
(statearr_27418[(4)] = cljs.core.rest((state_27407[(4)])));

return statearr_27418;
})();
var state_27407__$1 = state_27407;
var statearr_27419_27500 = state_27407__$1;
(statearr_27419_27500[(2)] = inst_27402);

(statearr_27419_27500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27408 === (5))){
var _ = (function (){var statearr_27420 = state_27407;
(statearr_27420[(4)] = cljs.core.rest((state_27407[(4)])));

return statearr_27420;
})();
var state_27407__$1 = state_27407;
var ex27415 = (state_27407__$1[(2)]);
var statearr_27421_27501 = state_27407__$1;
(statearr_27421_27501[(5)] = ex27415);


if((ex27415 instanceof Error)){
var statearr_27422_27502 = state_27407__$1;
(statearr_27422_27502[(1)] = (4));

(statearr_27422_27502[(5)] = null);

} else {
throw ex27415;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27408 === (8))){
var inst_27386 = (state_27407[(8)]);
var inst_27392 = (state_27407[(7)]);
var inst_27397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27398 = cljs.core.deref(inst_27386);
var inst_27399 = [inst_27392,inst_27398];
var inst_27400 = (new cljs.core.PersistentVector(null,2,(5),inst_27397,inst_27399,null));
var state_27407__$1 = state_27407;
var statearr_27423_27503 = state_27407__$1;
(statearr_27423_27503[(2)] = inst_27400);

(statearr_27423_27503[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_27424 = [null,null,null,null,null,null,null,null,null];
(statearr_27424[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_27424[(1)] = (1));

return statearr_27424;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_27407){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27407);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27425){var ex__2730__auto__ = e27425;
var statearr_27426_27504 = state_27407;
(statearr_27426_27504[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27407[(4)]))){
var statearr_27427_27505 = state_27407;
(statearr_27427_27505[(1)] = cljs.core.first((state_27407[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27506 = state_27407;
state_27407 = G__27506;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_27407){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_27407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27428 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27428[(6)] = c__2749__auto__);

return statearr_27428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27473){
var state_val_27474 = (state_27473[(1)]);
if((state_val_27474 === (7))){
var inst_27459 = (state_27473[(2)]);
var inst_27460 = fluree.db.query.fql.query(db,inst_27459);
var state_27473__$1 = state_27473;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27473__$1,(8),inst_27460);
} else {
if((state_val_27474 === (1))){
var inst_27429 = typeof select === 'string';
var state_27473__$1 = state_27473;
if(cljs.core.truth_(inst_27429)){
var statearr_27475_27507 = state_27473__$1;
(statearr_27475_27507[(1)] = (2));

} else {
var statearr_27476_27508 = state_27473__$1;
(statearr_27476_27508[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27474 === (4))){
var inst_27442 = (state_27473[(7)]);
var inst_27435 = (state_27473[(8)]);
var inst_27434 = (state_27473[(2)]);
var inst_27435__$1 = cljs.core.volatile_BANG_((0));
var inst_27436 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_27437 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_27438 = [inst_27435__$1,(100000)];
var inst_27439 = cljs.core.PersistentHashMap.fromArrays(inst_27437,inst_27438);
var inst_27440 = [inst_27434,from,where,block,limit,inst_27439];
var inst_27441 = cljs.core.PersistentHashMap.fromArrays(inst_27436,inst_27440);
var inst_27442__$1 = fluree.db.util.core.without_nils(inst_27441);
var inst_27443 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_27442__$1);
var inst_27444 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_27442__$1);
var inst_27445 = cljs.core.first(inst_27444);
var inst_27446 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27445], 0));
var inst_27447 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_27446);
var inst_27448 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_27442__$1);
var inst_27449 = cljs.core.last(inst_27448);
var inst_27450 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27449], 0));
var inst_27451 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_27450);
var inst_27452 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27443,inst_27447,inst_27451], 0));
var state_27473__$1 = (function (){var statearr_27477 = state_27473;
(statearr_27477[(7)] = inst_27442__$1);

(statearr_27477[(8)] = inst_27435__$1);

return statearr_27477;
})();
if(cljs.core.truth_(inst_27452)){
var statearr_27478_27509 = state_27473__$1;
(statearr_27478_27509[(1)] = (5));

} else {
var statearr_27479_27510 = state_27473__$1;
(statearr_27479_27510[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27474 === (6))){
var inst_27442 = (state_27473[(7)]);
var state_27473__$1 = state_27473;
var statearr_27480_27511 = state_27473__$1;
(statearr_27480_27511[(2)] = inst_27442);

(statearr_27480_27511[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27474 === (3))){
var state_27473__$1 = state_27473;
var statearr_27481_27512 = state_27473__$1;
(statearr_27481_27512[(2)] = select);

(statearr_27481_27512[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27474 === (2))){
var inst_27431 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_27473__$1 = state_27473;
var statearr_27482_27513 = state_27473__$1;
(statearr_27482_27513[(2)] = inst_27431);

(statearr_27482_27513[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27474 === (11))){
var inst_27471 = (state_27473[(2)]);
var state_27473__$1 = state_27473;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27473__$1,inst_27471);
} else {
if((state_val_27474 === (9))){
var inst_27462 = (state_27473[(9)]);
var state_27473__$1 = state_27473;
var statearr_27483_27514 = state_27473__$1;
(statearr_27483_27514[(2)] = inst_27462);

(statearr_27483_27514[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27474 === (5))){
var inst_27442 = (state_27473[(7)]);
var inst_27454 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_27442);
var inst_27455 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_27454);
var inst_27456 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27442,new cljs.core.Keyword(null,"where","where",-2044795965),inst_27455);
var state_27473__$1 = state_27473;
var statearr_27484_27515 = state_27473__$1;
(statearr_27484_27515[(2)] = inst_27456);

(statearr_27484_27515[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27474 === (10))){
var inst_27462 = (state_27473[(9)]);
var inst_27435 = (state_27473[(8)]);
var inst_27466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27467 = cljs.core.deref(inst_27435);
var inst_27468 = [inst_27462,inst_27467];
var inst_27469 = (new cljs.core.PersistentVector(null,2,(5),inst_27466,inst_27468,null));
var state_27473__$1 = state_27473;
var statearr_27485_27516 = state_27473__$1;
(statearr_27485_27516[(2)] = inst_27469);

(statearr_27485_27516[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27474 === (8))){
var inst_27462 = (state_27473[(9)]);
var inst_27462__$1 = (state_27473[(2)]);
var inst_27463 = fluree.db.util.core.exception_QMARK_(inst_27462__$1);
var state_27473__$1 = (function (){var statearr_27486 = state_27473;
(statearr_27486[(9)] = inst_27462__$1);

return statearr_27486;
})();
if(inst_27463){
var statearr_27487_27517 = state_27473__$1;
(statearr_27487_27517[(1)] = (9));

} else {
var statearr_27488_27518 = state_27473__$1;
(statearr_27488_27518[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_27489 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27489[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_27489[(1)] = (1));

return statearr_27489;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_27473){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27473);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27490){var ex__2730__auto__ = e27490;
var statearr_27491_27519 = state_27473;
(statearr_27491_27519[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27473[(4)]))){
var statearr_27492_27520 = state_27473;
(statearr_27492_27520[(1)] = cljs.core.first((state_27473[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27521 = state_27473;
state_27473 = G__27521;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_27473){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_27473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27493 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27493[(6)] = c__2749__auto__);

return statearr_27493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__27525 = path;
var vec__27526 = G__27525;
var seq__27527 = cljs.core.seq(vec__27526);
var first__27528 = cljs.core.first(seq__27527);
var seq__27527__$1 = cljs.core.next(seq__27527);
var var$ = first__27528;
var r = seq__27527__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__27525__$1 = G__27525;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__27532 = G__27525__$1;
var seq__27533 = cljs.core.seq(vec__27532);
var first__27534 = cljs.core.first(seq__27533);
var seq__27533__$1 = cljs.core.next(seq__27533);
var var$__$1 = first__27534;
var r__$1 = seq__27533__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__27535 = r__$1;
var G__27536 = n__$2;
var G__27537 = next_clauses;
G__27525__$1 = G__27535;
n__$1 = G__27536;
where_clauses__$1 = G__27537;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__27538 = r__$1;
var G__27539 = next_n;
var G__27540 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__27525__$1 = G__27538;
n__$1 = G__27539;
where_clauses__$1 = G__27540;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27577){
var state_val_27578 = (state_27577[(1)]);
if((state_val_27578 === (7))){
var inst_27550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27551 = [path];
var inst_27552 = (new cljs.core.PersistentVector(null,1,(5),inst_27550,inst_27551,null));
var state_27577__$1 = state_27577;
var statearr_27579_27607 = state_27577__$1;
(statearr_27579_27607[(2)] = inst_27552);

(statearr_27579_27607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27578 === (1))){
var state_27577__$1 = state_27577;
var statearr_27580_27608 = state_27577__$1;
(statearr_27580_27608[(2)] = null);

(statearr_27580_27608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27578 === (4))){
var inst_27541 = (state_27577[(2)]);
var state_27577__$1 = state_27577;
var statearr_27581_27609 = state_27577__$1;
(statearr_27581_27609[(2)] = inst_27541);

(statearr_27581_27609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27578 === (13))){
var inst_27568 = (state_27577[(2)]);
var inst_27569 = fluree.db.util.async.throw_err(inst_27568);
var _ = (function (){var statearr_27582 = state_27577;
(statearr_27582[(4)] = cljs.core.rest((state_27577[(4)])));

return statearr_27582;
})();
var state_27577__$1 = state_27577;
var statearr_27583_27610 = state_27577__$1;
(statearr_27583_27610[(2)] = inst_27569);

(statearr_27583_27610[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27578 === (6))){
var state_27577__$1 = state_27577;
var statearr_27585_27611 = state_27577__$1;
(statearr_27585_27611[(2)] = path);

(statearr_27585_27611[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27578 === (3))){
var inst_27575 = (state_27577[(2)]);
var state_27577__$1 = state_27577;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27577__$1,inst_27575);
} else {
if((state_val_27578 === (12))){
var _ = (function (){var statearr_27586 = state_27577;
(statearr_27586[(4)] = cljs.core.rest((state_27577[(4)])));

return statearr_27586;
})();
var state_27577__$1 = state_27577;
var ex27584 = (state_27577__$1[(2)]);
var statearr_27587_27612 = state_27577__$1;
(statearr_27587_27612[(5)] = ex27584);


var statearr_27588_27613 = state_27577__$1;
(statearr_27588_27613[(1)] = (11));

(statearr_27588_27613[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27578 === (2))){
var _ = (function (){var statearr_27589 = state_27577;
(statearr_27589[(4)] = cljs.core.cons((5),(state_27577[(4)])));

return statearr_27589;
})();
var inst_27547 = cljs.core.vector_QMARK_(path);
var state_27577__$1 = state_27577;
if(inst_27547){
var statearr_27590_27614 = state_27577__$1;
(statearr_27590_27614[(1)] = (6));

} else {
var statearr_27591_27615 = state_27577__$1;
(statearr_27591_27615[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27578 === (11))){
var inst_27554 = (state_27577[(7)]);
var inst_27559 = (state_27577[(2)]);
var inst_27560 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_27559,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_27554,endSubject], 0));
var state_27577__$1 = state_27577;
var statearr_27593_27616 = state_27577__$1;
(statearr_27593_27616[(2)] = inst_27560);

(statearr_27593_27616[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27578 === (9))){
var inst_27558 = (state_27577[(8)]);
var _ = (function (){var statearr_27594 = state_27577;
(statearr_27594[(4)] = cljs.core.cons((12),(state_27577[(4)])));

return statearr_27594;
})();
var inst_27566 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_27558);
var state_27577__$1 = state_27577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27577__$1,(13),inst_27566);
} else {
if((state_val_27578 === (5))){
var _ = (function (){var statearr_27595 = state_27577;
(statearr_27595[(4)] = cljs.core.rest((state_27577[(4)])));

return statearr_27595;
})();
var state_27577__$1 = state_27577;
var ex27592 = (state_27577__$1[(2)]);
var statearr_27596_27617 = state_27577__$1;
(statearr_27596_27617[(5)] = ex27592);


if((ex27592 instanceof Error)){
var statearr_27597_27618 = state_27577__$1;
(statearr_27597_27618[(1)] = (4));

(statearr_27597_27618[(5)] = null);

} else {
throw ex27592;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27578 === (10))){
var inst_27572 = (state_27577[(2)]);
var _ = (function (){var statearr_27598 = state_27577;
(statearr_27598[(4)] = cljs.core.rest((state_27577[(4)])));

return statearr_27598;
})();
var state_27577__$1 = state_27577;
var statearr_27599_27619 = state_27577__$1;
(statearr_27599_27619[(2)] = inst_27572);

(statearr_27599_27619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27578 === (8))){
var inst_27554 = (state_27577[(7)]);
var inst_27554__$1 = (state_27577[(2)]);
var inst_27555 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_27554__$1,endSubject);
var inst_27556 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_27557 = ["?var1",inst_27555];
var inst_27558 = cljs.core.PersistentHashMap.fromArrays(inst_27556,inst_27557);
var state_27577__$1 = (function (){var statearr_27600 = state_27577;
(statearr_27600[(8)] = inst_27558);

(statearr_27600[(7)] = inst_27554__$1);

return statearr_27600;
})();
var statearr_27601_27620 = state_27577__$1;
(statearr_27601_27620[(2)] = null);

(statearr_27601_27620[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_27602 = [null,null,null,null,null,null,null,null,null];
(statearr_27602[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_27602[(1)] = (1));

return statearr_27602;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_27577){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27577);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27603){var ex__2730__auto__ = e27603;
var statearr_27604_27621 = state_27577;
(statearr_27604_27621[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27577[(4)]))){
var statearr_27605_27622 = state_27577;
(statearr_27605_27622[(1)] = cljs.core.first((state_27577[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27623 = state_27577;
state_27577 = G__27623;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__ = function(state_27577){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_27577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27606 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27606[(6)] = c__2749__auto__);

return statearr_27606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e27624){var e = e27624;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e27625){var e = e27625;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e27626){var e = e27626;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Retrieve's a subject's predicate value by doing a lookup.
 *   If multi returns a vector, else a single value.
 */
fluree.db.dbfunctions.internal.get_subj_pred = (function fluree$db$dbfunctions$internal$get_subj_pred(db,sid,pred){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27680){
var state_val_27681 = (state_27680[(1)]);
if((state_val_27681 === (7))){
var state_27680__$1 = state_27680;
var statearr_27682_27720 = state_27680__$1;
(statearr_27682_27720[(2)] = pred);

(statearr_27682_27720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (20))){
var inst_27663 = (state_27680[(7)]);
var inst_27659 = (state_27680[(8)]);
var inst_27667 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_27663,inst_27659);
var state_27680__$1 = state_27680;
var statearr_27683_27721 = state_27680__$1;
(statearr_27683_27721[(2)] = inst_27667);

(statearr_27683_27721[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (1))){
var state_27680__$1 = state_27680;
var statearr_27684_27722 = state_27680__$1;
(statearr_27684_27722[(2)] = null);

(statearr_27684_27722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (4))){
var inst_27627 = (state_27680[(2)]);
var state_27680__$1 = state_27680;
var statearr_27685_27723 = state_27680__$1;
(statearr_27685_27723[(2)] = inst_27627);

(statearr_27685_27723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (15))){
var state_27680__$1 = state_27680;
var statearr_27686_27724 = state_27680__$1;
(statearr_27686_27724[(2)] = fluree.db.flake.o);

(statearr_27686_27724[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (21))){
var inst_27663 = (state_27680[(7)]);
var inst_27659 = (state_27680[(8)]);
var inst_27669 = cljs.core.first(inst_27659);
var inst_27670 = (inst_27663.cljs$core$IFn$_invoke$arity$1 ? inst_27663.cljs$core$IFn$_invoke$arity$1(inst_27669) : inst_27663.call(null,inst_27669));
var state_27680__$1 = state_27680;
var statearr_27687_27725 = state_27680__$1;
(statearr_27687_27725[(2)] = inst_27670);

(statearr_27687_27725[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (13))){
var inst_27656 = (state_27680[(2)]);
var inst_27657 = fluree.db.util.async.throw_err(inst_27656);
var state_27680__$1 = state_27680;
var statearr_27688_27726 = state_27680__$1;
(statearr_27688_27726[(2)] = inst_27657);

(statearr_27688_27726[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (22))){
var inst_27672 = (state_27680[(2)]);
var state_27680__$1 = state_27680;
var statearr_27689_27727 = state_27680__$1;
(statearr_27689_27727[(2)] = inst_27672);

(statearr_27689_27727[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (6))){
var inst_27637 = clojure.string.replace(pred,"/_","/");
var state_27680__$1 = state_27680;
var statearr_27690_27728 = state_27680__$1;
(statearr_27690_27728[(2)] = inst_27637);

(statearr_27690_27728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (17))){
var inst_27641 = (state_27680[(9)]);
var state_27680__$1 = state_27680;
if(cljs.core.truth_(inst_27641)){
var statearr_27691_27729 = state_27680__$1;
(statearr_27691_27729[(1)] = (20));

} else {
var statearr_27692_27730 = state_27680__$1;
(statearr_27692_27730[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (3))){
var inst_27678 = (state_27680[(2)]);
var state_27680__$1 = state_27680;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27680__$1,inst_27678);
} else {
if((state_val_27681 === (12))){
var inst_27648 = (state_27680[(2)]);
var inst_27649 = fluree.db.util.async.throw_err(inst_27648);
var state_27680__$1 = state_27680;
var statearr_27693_27731 = state_27680__$1;
(statearr_27693_27731[(2)] = inst_27649);

(statearr_27693_27731[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (2))){
var inst_27635 = (state_27680[(10)]);
var _ = (function (){var statearr_27694 = state_27680;
(statearr_27694[(4)] = cljs.core.cons((5),(state_27680[(4)])));

return statearr_27694;
})();
var inst_27633 = typeof pred === 'string';
var inst_27634 = cljs.core.re_matches(/.+\/_.+/,pred);
var inst_27635__$1 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27633,inst_27634], 0));
var state_27680__$1 = (function (){var statearr_27695 = state_27680;
(statearr_27695[(10)] = inst_27635__$1);

return statearr_27695;
})();
if(cljs.core.truth_(inst_27635__$1)){
var statearr_27696_27732 = state_27680__$1;
(statearr_27696_27732[(1)] = (6));

} else {
var statearr_27697_27733 = state_27680__$1;
(statearr_27697_27733[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (19))){
var inst_27675 = (state_27680[(2)]);
var _ = (function (){var statearr_27698 = state_27680;
(statearr_27698[(4)] = cljs.core.rest((state_27680[(4)])));

return statearr_27698;
})();
var state_27680__$1 = state_27680;
var statearr_27699_27734 = state_27680__$1;
(statearr_27699_27734[(2)] = inst_27675);

(statearr_27699_27734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (11))){
var inst_27635 = (state_27680[(10)]);
var inst_27659 = (state_27680[(2)]);
var state_27680__$1 = (function (){var statearr_27701 = state_27680;
(statearr_27701[(8)] = inst_27659);

return statearr_27701;
})();
if(cljs.core.truth_(inst_27635)){
var statearr_27702_27735 = state_27680__$1;
(statearr_27702_27735[(1)] = (14));

} else {
var statearr_27703_27736 = state_27680__$1;
(statearr_27703_27736[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (9))){
var inst_27640 = (state_27680[(11)]);
var inst_27643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27644 = [sid,inst_27640];
var inst_27645 = (new cljs.core.PersistentVector(null,2,(5),inst_27643,inst_27644,null));
var inst_27646 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_27645);
var state_27680__$1 = state_27680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27680__$1,(12),inst_27646);
} else {
if((state_val_27681 === (5))){
var _ = (function (){var statearr_27704 = state_27680;
(statearr_27704[(4)] = cljs.core.rest((state_27680[(4)])));

return statearr_27704;
})();
var state_27680__$1 = state_27680;
var ex27700 = (state_27680__$1[(2)]);
var statearr_27705_27737 = state_27680__$1;
(statearr_27705_27737[(5)] = ex27700);


if((ex27700 instanceof Error)){
var statearr_27706_27738 = state_27680__$1;
(statearr_27706_27738[(1)] = (4));

(statearr_27706_27738[(5)] = null);

} else {
throw ex27700;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (14))){
var state_27680__$1 = state_27680;
var statearr_27707_27739 = state_27680__$1;
(statearr_27707_27739[(2)] = fluree.db.flake.s);

(statearr_27707_27739[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (16))){
var inst_27659 = (state_27680[(8)]);
var inst_27663 = (state_27680[(2)]);
var inst_27664 = cljs.core.seq(inst_27659);
var state_27680__$1 = (function (){var statearr_27708 = state_27680;
(statearr_27708[(7)] = inst_27663);

return statearr_27708;
})();
if(inst_27664){
var statearr_27709_27740 = state_27680__$1;
(statearr_27709_27740[(1)] = (17));

} else {
var statearr_27710_27741 = state_27680__$1;
(statearr_27710_27741[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (10))){
var inst_27640 = (state_27680[(11)]);
var inst_27651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27652 = [sid,inst_27640];
var inst_27653 = (new cljs.core.PersistentVector(null,2,(5),inst_27651,inst_27652,null));
var inst_27654 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27653);
var state_27680__$1 = state_27680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27680__$1,(13),inst_27654);
} else {
if((state_val_27681 === (18))){
var state_27680__$1 = state_27680;
var statearr_27711_27742 = state_27680__$1;
(statearr_27711_27742[(2)] = null);

(statearr_27711_27742[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27681 === (8))){
var inst_27635 = (state_27680[(10)]);
var inst_27640 = (state_27680[(11)]);
var inst_27640__$1 = (state_27680[(2)]);
var inst_27641 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_27640__$1);
var state_27680__$1 = (function (){var statearr_27712 = state_27680;
(statearr_27712[(11)] = inst_27640__$1);

(statearr_27712[(9)] = inst_27641);

return statearr_27712;
})();
if(cljs.core.truth_(inst_27635)){
var statearr_27713_27743 = state_27680__$1;
(statearr_27713_27743[(1)] = (9));

} else {
var statearr_27714_27744 = state_27680__$1;
(statearr_27714_27744[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0 = (function (){
var statearr_27715 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27715[(0)] = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__);

(statearr_27715[(1)] = (1));

return statearr_27715;
});
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1 = (function (state_27680){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27680);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27716){var ex__2730__auto__ = e27716;
var statearr_27717_27745 = state_27680;
(statearr_27717_27745[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27680[(4)]))){
var statearr_27718_27746 = state_27680;
(statearr_27718_27746[(1)] = cljs.core.first((state_27680[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27747 = state_27680;
state_27680 = G__27747;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__ = function(state_27680){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1.call(this,state_27680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27719 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27719[(6)] = c__2749__auto__);

return statearr_27719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e27748){var e = e27748;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27751 = arguments.length;
var i__4865__auto___27752 = (0);
while(true){
if((i__4865__auto___27752 < len__4864__auto___27751)){
args__4870__auto__.push((arguments[i__4865__auto___27752]));

var G__27753 = (i__4865__auto___27752 + (1));
i__4865__auto___27752 = G__27753;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e27750){var e = e27750;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq27749){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27749));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27756 = arguments.length;
var i__4865__auto___27757 = (0);
while(true){
if((i__4865__auto___27757 < len__4864__auto___27756)){
args__4870__auto__.push((arguments[i__4865__auto___27757]));

var G__27758 = (i__4865__auto___27757 + (1));
i__4865__auto___27757 = G__27758;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e27755){var e = e27755;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq27754){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27754));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27761 = arguments.length;
var i__4865__auto___27762 = (0);
while(true){
if((i__4865__auto___27762 < len__4864__auto___27761)){
args__4870__auto__.push((arguments[i__4865__auto___27762]));

var G__27763 = (i__4865__auto___27762 + (1));
i__4865__auto___27762 = G__27763;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4253__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e27760){var e = e27760;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq27759){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27759));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27766 = arguments.length;
var i__4865__auto___27767 = (0);
while(true){
if((i__4865__auto___27767 < len__4864__auto___27766)){
args__4870__auto__.push((arguments[i__4865__auto___27767]));

var G__27768 = (i__4865__auto___27767 + (1));
i__4865__auto___27767 = G__27768;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e27765){var e = e27765;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq27764){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27764));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e27769){var e = e27769;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e27770){var e = e27770;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e27771){var e = e27771;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e27772){var e = e27772;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e27773){var e = e27773;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows a result set down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__27779 = path;
var vec__27780 = G__27779;
var seq__27781 = cljs.core.seq(vec__27780);
var first__27782 = cljs.core.first(seq__27781);
var seq__27781__$1 = cljs.core.next(seq__27781);
var pred = first__27782;
var r = seq__27781__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__27779__$1 = G__27779;
var subjects__$1 = subjects;
while(true){
var vec__27786 = G__27779__$1;
var seq__27787 = cljs.core.seq(vec__27786);
var first__27788 = cljs.core.first(seq__27787);
var seq__27787__$1 = cljs.core.next(seq__27787);
var pred__$1 = first__27788;
var r__$1 = seq__27787__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__27779__$1,subjects__$1,vec__27786,seq__27787,first__27788,seq__27787__$1,pred__$1,r__$1,subjects__$2,G__27779,vec__27780,seq__27781,first__27782,seq__27781__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__27779__$1,subjects__$1,vec__27786,seq__27787,first__27788,seq__27787__$1,pred__$1,r__$1,subjects__$2,G__27779,vec__27780,seq__27781,first__27782,seq__27781__$1,pred,r,subjects){
return (function (p1__27774_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__27774_SHARP_,pred__$1);
});})(G__27779__$1,subjects__$1,vec__27786,seq__27787,first__27788,seq__27787__$1,pred__$1,r__$1,subjects__$2,G__27779,vec__27780,seq__27781,first__27782,seq__27781__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__27779__$1,subjects__$1,vec__27786,seq__27787,first__27788,seq__27787__$1,pred__$1,r__$1,subjects__$2,G__27779,vec__27780,seq__27781,first__27782,seq__27781__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4251__auto__ = r__$1;
if(and__4251__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4251__auto__;
}
})())){
var G__27789 = r__$1;
var G__27790 = next_subjects;
G__27779__$1 = G__27789;
subjects__$1 = G__27790;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e27775){var e = e27775;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Takes a path in a vector format and returns a select statement to crawl those vars.
 *   e.g. convert: ['_user/_auth', 'groupMembership/_user', 'group/_admins']
 *          to: {'_user/_auth' [{'groupMembership/_user' ['group/_admins']}]}
 */
fluree.db.dbfunctions.internal.select_from_path = (function fluree$db$dbfunctions$internal$select_from_path(path){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),fluree.db.dbfunctions.internal.count(path))){
return path;
} else {
var r_path = cljs.core.reverse(path);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc], null)]);
}),cljs.core.first(r_path),cljs.core.rest(r_path));
}
});
/**
 * Follows a subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.follow_subject = (function fluree$db$dbfunctions$internal$follow_subject(_QMARK_ctx,sid,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27830){
var state_val_27831 = (state_27830[(1)]);
if((state_val_27831 === (7))){
var state_27830__$1 = state_27830;
var statearr_27832_27851 = state_27830__$1;
(statearr_27832_27851[(2)] = path);

(statearr_27832_27851[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27831 === (1))){
var state_27830__$1 = state_27830;
var statearr_27833_27852 = state_27830__$1;
(statearr_27833_27852[(2)] = null);

(statearr_27833_27852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27831 === (4))){
var inst_27791 = (state_27830[(2)]);
var inst_27792 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_27791,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([sid,path], 0));
var state_27830__$1 = state_27830;
var statearr_27834_27853 = state_27830__$1;
(statearr_27834_27853[(2)] = inst_27792);

(statearr_27834_27853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27831 === (6))){
var inst_27809 = (state_27830[(2)]);
var inst_27810 = fluree.db.util.async.throw_err(inst_27809);
var inst_27811 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27810,(0),null);
var inst_27812 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27810,(1),null);
var inst_27813 = cljs.core.last(path);
var inst_27814 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_27813);
var state_27830__$1 = (function (){var statearr_27835 = state_27830;
(statearr_27835[(7)] = inst_27811);

(statearr_27835[(8)] = inst_27812);

return statearr_27835;
})();
if(inst_27814){
var statearr_27836_27854 = state_27830__$1;
(statearr_27836_27854[(1)] = (7));

} else {
var statearr_27837_27855 = state_27830__$1;
(statearr_27837_27855[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27831 === (3))){
var inst_27828 = (state_27830[(2)]);
var state_27830__$1 = state_27830;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27830__$1,inst_27828);
} else {
if((state_val_27831 === (2))){
var _ = (function (){var statearr_27839 = state_27830;
(statearr_27839[(4)] = cljs.core.cons((5),(state_27830[(4)])));

return statearr_27839;
})();
var inst_27801 = fluree.db.dbfunctions.internal.select_from_path(path);
var inst_27802 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_27803 = cljs.core.PersistentHashMap.EMPTY;
var inst_27804 = [inst_27801,sid,inst_27803];
var inst_27805 = cljs.core.PersistentHashMap.fromArrays(inst_27802,inst_27804);
var inst_27806 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_27807 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_27806,inst_27805);
var state_27830__$1 = state_27830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27830__$1,(6),inst_27807);
} else {
if((state_val_27831 === (9))){
var inst_27811 = (state_27830[(7)]);
var inst_27812 = (state_27830[(8)]);
var inst_27819 = (state_27830[(2)]);
var inst_27820 = fluree.db.dbfunctions.internal.get_all(inst_27811,inst_27819);
var inst_27821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27822 = fluree.db.dbfunctions.internal.count(path);
var inst_27823 = fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27812,inst_27822,(9)], 0));
var inst_27824 = [inst_27820,inst_27823];
var inst_27825 = (new cljs.core.PersistentVector(null,2,(5),inst_27821,inst_27824,null));
var _ = (function (){var statearr_27840 = state_27830;
(statearr_27840[(4)] = cljs.core.rest((state_27830[(4)])));

return statearr_27840;
})();
var state_27830__$1 = state_27830;
var statearr_27841_27856 = state_27830__$1;
(statearr_27841_27856[(2)] = inst_27825);

(statearr_27841_27856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27831 === (5))){
var _ = (function (){var statearr_27842 = state_27830;
(statearr_27842[(4)] = cljs.core.rest((state_27830[(4)])));

return statearr_27842;
})();
var state_27830__$1 = state_27830;
var ex27838 = (state_27830__$1[(2)]);
var statearr_27843_27857 = state_27830__$1;
(statearr_27843_27857[(5)] = ex27838);


var statearr_27844_27858 = state_27830__$1;
(statearr_27844_27858[(1)] = (4));

(statearr_27844_27858[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27831 === (8))){
var inst_27817 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,"_id");
var state_27830__$1 = state_27830;
var statearr_27845_27859 = state_27830__$1;
(statearr_27845_27859[(2)] = inst_27817);

(statearr_27845_27859[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0 = (function (){
var statearr_27846 = [null,null,null,null,null,null,null,null,null];
(statearr_27846[(0)] = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__);

(statearr_27846[(1)] = (1));

return statearr_27846;
});
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1 = (function (state_27830){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27830);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27847){var ex__2730__auto__ = e27847;
var statearr_27848_27860 = state_27830;
(statearr_27848_27860[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27830[(4)]))){
var statearr_27849_27861 = state_27830;
(statearr_27849_27861[(1)] = cljs.core.first((state_27830[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27862 = state_27830;
state_27830 = G__27862;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__ = function(state_27830){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1.call(this,state_27830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27850 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27850[(6)] = c__2749__auto__);

return statearr_27850;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e27863){var e = e27863;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{if(cljs.core.sequential_QMARK_(key)){
return cljs.core.some((function (p1__27864_SHARP_){
return (fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2(coll,p1__27864_SHARP_) : fluree.db.dbfunctions.internal.contains_QMARK_.call(null,coll,p1__27864_SHARP_));
}),key);
} else {
return cljs.core.contains_QMARK_(coll,key);
}
}catch (e27865){var e = e27865;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27868 = arguments.length;
var i__4865__auto___27869 = (0);
while(true){
if((i__4865__auto___27869 < len__4864__auto___27868)){
args__4870__auto__.push((arguments[i__4865__auto___27869]));

var G__27870 = (i__4865__auto___27869 + (1));
i__4865__auto___27869 = G__27870;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e27867){var e = e27867;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq27866){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27866));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e27871){var e = e27871;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___27874 = arguments.length;
var i__4865__auto___27875 = (0);
while(true){
if((i__4865__auto___27875 < len__4864__auto___27874)){
args__4870__auto__.push((arguments[i__4865__auto___27875]));

var G__27876 = (i__4865__auto___27875 + (1));
i__4865__auto___27875 = G__27876;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e27873){var e = e27873;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq27872){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq27872));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e27877){var e = e27877;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_27934){
var state_val_27935 = (state_27934[(1)]);
if((state_val_27935 === (7))){
var inst_27880 = (state_27934[(2)]);
var state_27934__$1 = state_27934;
var statearr_27936_27970 = state_27934__$1;
(statearr_27936_27970[(2)] = inst_27880);

(statearr_27936_27970[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27935 === (1))){
var state_27934__$1 = state_27934;
var statearr_27937_27971 = state_27934__$1;
(statearr_27937_27971[(2)] = null);

(statearr_27937_27971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27935 === (4))){
var inst_27879 = (state_27934[(2)]);
var state_27934__$1 = (function (){var statearr_27938 = state_27934;
(statearr_27938[(7)] = inst_27879);

return statearr_27938;
})();
var statearr_27939_27972 = state_27934__$1;
(statearr_27939_27972[(2)] = null);

(statearr_27939_27972[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27935 === (15))){
var inst_27917 = (state_27934[(8)]);
var inst_27905 = (state_27934[(9)]);
var inst_27914 = (state_27934[(10)]);
var inst_27915 = (state_27934[(11)]);
var inst_27902 = (state_27934[(12)]);
var inst_27904 = (state_27934[(13)]);
var inst_27921 = (function (){var db = inst_27902;
var prevT = inst_27904;
var db_SINGLEQUOTE_ = inst_27905;
var prev_vals = inst_27914;
var fuel = inst_27915;
var G__27916 = inst_27917;
return (function (p1__27878_SHARP_){
var f = p1__27878_SHARP_;
return fluree.db.flake.o(f);
});
})();
var inst_27922 = (inst_27921.cljs$core$IFn$_invoke$arity$1 ? inst_27921.cljs$core$IFn$_invoke$arity$1(inst_27917) : inst_27921.call(null,inst_27917));
var state_27934__$1 = state_27934;
var statearr_27940_27973 = state_27934__$1;
(statearr_27940_27973[(2)] = inst_27922);

(statearr_27940_27973[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27935 === (13))){
var inst_27917 = (state_27934[(8)]);
var inst_27914 = (state_27934[(10)]);
var inst_27913 = (state_27934[(2)]);
var inst_27914__$1 = fluree.db.util.async.throw_err(inst_27913);
var inst_27915 = fluree.db.dbfunctions.internal.count(inst_27914__$1);
var inst_27917__$1 = cljs.core.first(inst_27914__$1);
var inst_27918 = (inst_27917__$1 == null);
var state_27934__$1 = (function (){var statearr_27941 = state_27934;
(statearr_27941[(8)] = inst_27917__$1);

(statearr_27941[(10)] = inst_27914__$1);

(statearr_27941[(11)] = inst_27915);

return statearr_27941;
})();
if(cljs.core.truth_(inst_27918)){
var statearr_27942_27974 = state_27934__$1;
(statearr_27942_27974[(1)] = (14));

} else {
var statearr_27943_27975 = state_27934__$1;
(statearr_27943_27975[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27935 === (6))){
var inst_27889 = (state_27934[(2)]);
var state_27934__$1 = state_27934;
var statearr_27944_27976 = state_27934__$1;
(statearr_27944_27976[(2)] = inst_27889);

(statearr_27944_27976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27935 === (3))){
var inst_27932 = (state_27934[(2)]);
var state_27934__$1 = state_27934;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27934__$1,inst_27932);
} else {
if((state_val_27935 === (12))){
var inst_27929 = (state_27934[(2)]);
var _ = (function (){var statearr_27945 = state_27934;
(statearr_27945[(4)] = cljs.core.rest((state_27934[(4)])));

return statearr_27945;
})();
var state_27934__$1 = state_27934;
var statearr_27946_27977 = state_27934__$1;
(statearr_27946_27977[(2)] = inst_27929);

(statearr_27946_27977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27935 === (2))){
var _ = (function (){var statearr_27948 = state_27934;
(statearr_27948[(4)] = cljs.core.cons((9),(state_27934[(4)])));

return statearr_27948;
})();
var inst_27895 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_27896 = typeof inst_27895 === 'string';
var state_27934__$1 = state_27934;
if(cljs.core.truth_(inst_27896)){
var statearr_27949_27978 = state_27934__$1;
(statearr_27949_27978[(1)] = (10));

} else {
var statearr_27950_27979 = state_27934__$1;
(statearr_27950_27979[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27935 === (11))){
var inst_27905 = (state_27934[(9)]);
var inst_27902 = (state_27934[(12)]);
var inst_27904 = (state_27934[(13)]);
var inst_27902__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_27903 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_27902__$1);
var inst_27904__$1 = fluree.db.dbfunctions.internal.inc(inst_27903);
var inst_27905__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27902__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27904__$1);
var inst_27906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27907 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_27908 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_27909 = [inst_27907,inst_27908];
var inst_27910 = (new cljs.core.PersistentVector(null,2,(5),inst_27906,inst_27909,null));
var inst_27911 = fluree.db.dbproto._search(inst_27905__$1,inst_27910);
var state_27934__$1 = (function (){var statearr_27951 = state_27934;
(statearr_27951[(9)] = inst_27905__$1);

(statearr_27951[(12)] = inst_27902__$1);

(statearr_27951[(13)] = inst_27904__$1);

return statearr_27951;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27934__$1,(13),inst_27911);
} else {
if((state_val_27935 === (9))){
var _ = (function (){var statearr_27952 = state_27934;
(statearr_27952[(4)] = cljs.core.rest((state_27934[(4)])));

return statearr_27952;
})();
var state_27934__$1 = state_27934;
var ex27947 = (state_27934__$1[(2)]);
var statearr_27953_27980 = state_27934__$1;
(statearr_27953_27980[(5)] = ex27947);


var statearr_27954_27981 = state_27934__$1;
(statearr_27954_27981[(1)] = (4));

(statearr_27954_27981[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27935 === (5))){
var inst_27879 = (state_27934[(7)]);
var _ = (function (){var statearr_27955 = state_27934;
(statearr_27955[(4)] = cljs.core.cons((8),(state_27934[(4)])));

return statearr_27955;
})();
var inst_27886 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_27879,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_27956 = state_27934;
(statearr_27956[(4)] = cljs.core.rest((state_27934[(4)])));

return statearr_27956;
})();
var state_27934__$1 = state_27934;
var statearr_27957_27982 = state_27934__$1;
(statearr_27957_27982[(2)] = inst_27886);

(statearr_27957_27982[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27935 === (14))){
var state_27934__$1 = state_27934;
var statearr_27958_27983 = state_27934__$1;
(statearr_27958_27983[(2)] = null);

(statearr_27958_27983[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27935 === (16))){
var inst_27915 = (state_27934[(11)]);
var inst_27924 = (state_27934[(2)]);
var inst_27925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27926 = [inst_27924,inst_27915];
var inst_27927 = (new cljs.core.PersistentVector(null,2,(5),inst_27925,inst_27926,null));
var state_27934__$1 = state_27934;
var statearr_27960_27984 = state_27934__$1;
(statearr_27960_27984[(2)] = inst_27927);

(statearr_27960_27984[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27935 === (10))){
var inst_27898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27899 = [null,(0)];
var inst_27900 = (new cljs.core.PersistentVector(null,2,(5),inst_27898,inst_27899,null));
var state_27934__$1 = state_27934;
var statearr_27961_27985 = state_27934__$1;
(statearr_27961_27985[(2)] = inst_27900);

(statearr_27961_27985[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27935 === (8))){
var _ = (function (){var statearr_27962 = state_27934;
(statearr_27962[(4)] = cljs.core.rest((state_27934[(4)])));

return statearr_27962;
})();
var state_27934__$1 = state_27934;
var ex27959 = (state_27934__$1[(2)]);
var statearr_27963_27986 = state_27934__$1;
(statearr_27963_27986[(5)] = ex27959);


var statearr_27964_27987 = state_27934__$1;
(statearr_27964_27987[(1)] = (7));

(statearr_27964_27987[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_27965 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27965[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_27965[(1)] = (1));

return statearr_27965;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_27934){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_27934);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e27966){var ex__2730__auto__ = e27966;
var statearr_27967_27988 = state_27934;
(statearr_27967_27988[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_27934[(4)]))){
var statearr_27968_27989 = state_27934;
(statearr_27968_27989[(1)] = cljs.core.first((state_27934[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27990 = state_27934;
state_27934 = G__27990;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__ = function(state_27934){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_27934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_27969 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_27969[(6)] = c__2749__auto__);

return statearr_27969;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28042){
var state_val_28043 = (state_28042[(1)]);
if((state_val_28043 === (7))){
var inst_27992 = (state_28042[(2)]);
var state_28042__$1 = state_28042;
var statearr_28044_28073 = state_28042__$1;
(statearr_28044_28073[(2)] = inst_27992);

(statearr_28044_28073[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28043 === (1))){
var state_28042__$1 = state_28042;
var statearr_28045_28074 = state_28042__$1;
(statearr_28045_28074[(2)] = null);

(statearr_28045_28074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28043 === (4))){
var inst_27991 = (state_28042[(2)]);
var state_28042__$1 = (function (){var statearr_28046 = state_28042;
(statearr_28046[(7)] = inst_27991);

return statearr_28046;
})();
var statearr_28047_28075 = state_28042__$1;
(statearr_28047_28075[(2)] = null);

(statearr_28047_28075[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28043 === (13))){
var inst_28037 = (state_28042[(2)]);
var _ = (function (){var statearr_28048 = state_28042;
(statearr_28048[(4)] = cljs.core.rest((state_28042[(4)])));

return statearr_28048;
})();
var state_28042__$1 = state_28042;
var statearr_28049_28076 = state_28042__$1;
(statearr_28049_28076[(2)] = inst_28037);

(statearr_28049_28076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28043 === (6))){
var inst_28001 = (state_28042[(2)]);
var state_28042__$1 = state_28042;
var statearr_28050_28077 = state_28042__$1;
(statearr_28050_28077[(2)] = inst_28001);

(statearr_28050_28077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28043 === (3))){
var inst_28040 = (state_28042[(2)]);
var state_28042__$1 = state_28042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28042__$1,inst_28040);
} else {
if((state_val_28043 === (12))){
var inst_28024 = (state_28042[(8)]);
var inst_28033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28034 = [null,inst_28024];
var inst_28035 = (new cljs.core.PersistentVector(null,2,(5),inst_28033,inst_28034,null));
var state_28042__$1 = state_28042;
var statearr_28051_28078 = state_28042__$1;
(statearr_28051_28078[(2)] = inst_28035);

(statearr_28051_28078[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28043 === (2))){
var _ = (function (){var statearr_28053 = state_28042;
(statearr_28053[(4)] = cljs.core.cons((9),(state_28042[(4)])));

return statearr_28053;
})();
var inst_28010 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28013 = [null,pred_name,"?o"];
var inst_28014 = (new cljs.core.PersistentVector(null,3,(5),inst_28012,inst_28013,null));
var inst_28015 = [inst_28014];
var inst_28016 = (new cljs.core.PersistentVector(null,1,(5),inst_28011,inst_28015,null));
var inst_28017 = ["?o",inst_28016,opts];
var inst_28018 = cljs.core.PersistentHashMap.fromArrays(inst_28010,inst_28017);
var inst_28019 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28018);
var state_28042__$1 = state_28042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28042__$1,(10),inst_28019);
} else {
if((state_val_28043 === (11))){
var inst_28024 = (state_28042[(8)]);
var inst_28023 = (state_28042[(9)]);
var inst_28028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28029 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_28023);
var inst_28030 = [inst_28029,inst_28024];
var inst_28031 = (new cljs.core.PersistentVector(null,2,(5),inst_28028,inst_28030,null));
var state_28042__$1 = state_28042;
var statearr_28054_28079 = state_28042__$1;
(statearr_28054_28079[(2)] = inst_28031);

(statearr_28054_28079[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28043 === (9))){
var _ = (function (){var statearr_28055 = state_28042;
(statearr_28055[(4)] = cljs.core.rest((state_28042[(4)])));

return statearr_28055;
})();
var state_28042__$1 = state_28042;
var ex28052 = (state_28042__$1[(2)]);
var statearr_28056_28080 = state_28042__$1;
(statearr_28056_28080[(5)] = ex28052);


var statearr_28057_28081 = state_28042__$1;
(statearr_28057_28081[(1)] = (4));

(statearr_28057_28081[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28043 === (5))){
var inst_27991 = (state_28042[(7)]);
var _ = (function (){var statearr_28059 = state_28042;
(statearr_28059[(4)] = cljs.core.cons((8),(state_28042[(4)])));

return statearr_28059;
})();
var inst_27998 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_27991,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_28060 = state_28042;
(statearr_28060[(4)] = cljs.core.rest((state_28042[(4)])));

return statearr_28060;
})();
var state_28042__$1 = state_28042;
var statearr_28061_28082 = state_28042__$1;
(statearr_28061_28082[(2)] = inst_27998);

(statearr_28061_28082[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28043 === (10))){
var inst_28023 = (state_28042[(9)]);
var inst_28021 = (state_28042[(2)]);
var inst_28022 = fluree.db.util.async.throw_err(inst_28021);
var inst_28023__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28022,(0),null);
var inst_28024 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28022,(1),null);
var inst_28025 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_28023__$1);
var inst_28026 = cljs.core.not(inst_28025);
var state_28042__$1 = (function (){var statearr_28062 = state_28042;
(statearr_28062[(8)] = inst_28024);

(statearr_28062[(9)] = inst_28023__$1);

return statearr_28062;
})();
if(inst_28026){
var statearr_28063_28083 = state_28042__$1;
(statearr_28063_28083[(1)] = (11));

} else {
var statearr_28064_28084 = state_28042__$1;
(statearr_28064_28084[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28043 === (8))){
var _ = (function (){var statearr_28065 = state_28042;
(statearr_28065[(4)] = cljs.core.rest((state_28042[(4)])));

return statearr_28065;
})();
var state_28042__$1 = state_28042;
var ex28058 = (state_28042__$1[(2)]);
var statearr_28066_28085 = state_28042__$1;
(statearr_28066_28085[(5)] = ex28058);


var statearr_28067_28086 = state_28042__$1;
(statearr_28067_28086[(1)] = (7));

(statearr_28067_28086[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_28068 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28068[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__);

(statearr_28068[(1)] = (1));

return statearr_28068;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1 = (function (state_28042){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28042);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28069){var ex__2730__auto__ = e28069;
var statearr_28070_28087 = state_28042;
(statearr_28070_28087[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28042[(4)]))){
var statearr_28071_28088 = state_28042;
(statearr_28071_28088[(1)] = cljs.core.first((state_28042[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28089 = state_28042;
state_28042 = G__28089;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__ = function(state_28042){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1.call(this,state_28042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28072 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28072[(6)] = c__2749__auto__);

return statearr_28072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4251__auto__ = typeof email === 'string';
if(and__4251__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4251__auto__;
}
})());
}catch (e28090){var e = e28090;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__28092 = arguments.length;
switch (G__28092) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28162){
var state_val_28163 = (state_28162[(1)]);
if((state_val_28163 === (7))){
var inst_28094 = (state_28162[(2)]);
var state_28162__$1 = state_28162;
var statearr_28164_28208 = state_28162__$1;
(statearr_28164_28208[(2)] = inst_28094);

(statearr_28164_28208[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (20))){
var inst_28138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28139 = ["*"];
var inst_28140 = (new cljs.core.PersistentVector(null,1,(5),inst_28138,inst_28139,null));
var state_28162__$1 = state_28162;
var statearr_28165_28209 = state_28162__$1;
(statearr_28165_28209[(2)] = inst_28140);

(statearr_28165_28209[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (1))){
var state_28162__$1 = state_28162;
var statearr_28166_28210 = state_28162__$1;
(statearr_28166_28210[(2)] = null);

(statearr_28166_28210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (4))){
var inst_28093 = (state_28162[(2)]);
var state_28162__$1 = (function (){var statearr_28167 = state_28162;
(statearr_28167[(7)] = inst_28093);

return statearr_28167;
})();
var statearr_28168_28211 = state_28162__$1;
(statearr_28168_28211[(2)] = null);

(statearr_28168_28211[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (15))){
var inst_28157 = (state_28162[(2)]);
var _ = (function (){var statearr_28169 = state_28162;
(statearr_28169[(4)] = cljs.core.rest((state_28162[(4)])));

return statearr_28169;
})();
var state_28162__$1 = state_28162;
var statearr_28170_28212 = state_28162__$1;
(statearr_28170_28212[(2)] = inst_28157);

(statearr_28170_28212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (21))){
var inst_28121 = (state_28162[(8)]);
var inst_28128 = (state_28162[(9)]);
var inst_28142 = (state_28162[(2)]);
var inst_28143 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28144 = cljs.core.PersistentHashMap.EMPTY;
var inst_28145 = [inst_28142,inst_28128,inst_28144];
var inst_28146 = cljs.core.PersistentHashMap.fromArrays(inst_28143,inst_28145);
var inst_28147 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28121,inst_28146);
var state_28162__$1 = state_28162;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28162__$1,(22),inst_28147);
} else {
if((state_val_28163 === (13))){
var inst_28116 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28162__$1 = state_28162;
var statearr_28171_28213 = state_28162__$1;
(statearr_28171_28213[(2)] = inst_28116);

(statearr_28171_28213[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (22))){
var inst_28149 = (state_28162[(2)]);
var inst_28150 = fluree.db.util.async.throw_err(inst_28149);
var inst_28151 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28150,(0),null);
var inst_28152 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28150,(1),null);
var inst_28153 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28154 = [inst_28151,inst_28152];
var inst_28155 = (new cljs.core.PersistentVector(null,2,(5),inst_28153,inst_28154,null));
var state_28162__$1 = state_28162;
var statearr_28172_28214 = state_28162__$1;
(statearr_28172_28214[(2)] = inst_28155);

(statearr_28172_28214[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (6))){
var inst_28103 = (state_28162[(2)]);
var state_28162__$1 = state_28162;
var statearr_28173_28215 = state_28162__$1;
(statearr_28173_28215[(2)] = inst_28103);

(statearr_28173_28215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (17))){
var inst_28125 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28126 = fluree.db.dbfunctions.internal.get(inst_28125,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_28162__$1 = state_28162;
var statearr_28174_28216 = state_28162__$1;
(statearr_28174_28216[(2)] = inst_28126);

(statearr_28174_28216[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (3))){
var inst_28160 = (state_28162[(2)]);
var state_28162__$1 = state_28162;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28162__$1,inst_28160);
} else {
if((state_val_28163 === (12))){
var inst_28114 = (state_28162[(2)]);
var state_28162__$1 = state_28162;
if(cljs.core.truth_(inst_28114)){
var statearr_28175_28217 = state_28162__$1;
(statearr_28175_28217[(1)] = (13));

} else {
var statearr_28176_28218 = state_28162__$1;
(statearr_28176_28218[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (2))){
var inst_28109 = (state_28162[(10)]);
var _ = (function (){var statearr_28177 = state_28162;
(statearr_28177[(4)] = cljs.core.cons((9),(state_28162[(4)])));

return statearr_28177;
})();
var inst_28109__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28162__$1 = (function (){var statearr_28178 = state_28162;
(statearr_28178[(10)] = inst_28109__$1);

return statearr_28178;
})();
if(cljs.core.truth_(inst_28109__$1)){
var statearr_28179_28219 = state_28162__$1;
(statearr_28179_28219[(1)] = (10));

} else {
var statearr_28180_28220 = state_28162__$1;
(statearr_28180_28220[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (19))){
var inst_28130 = cljs.core.PersistentVector.EMPTY;
var inst_28131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28132 = ["*"];
var inst_28133 = (new cljs.core.PersistentVector(null,1,(5),inst_28131,inst_28132,null));
var inst_28134 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_28135 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_28133,inst_28134);
var inst_28136 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28130,inst_28135);
var state_28162__$1 = state_28162;
var statearr_28182_28221 = state_28162__$1;
(statearr_28182_28221[(2)] = inst_28136);

(statearr_28182_28221[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (11))){
var inst_28109 = (state_28162[(10)]);
var state_28162__$1 = state_28162;
var statearr_28183_28222 = state_28162__$1;
(statearr_28183_28222[(2)] = inst_28109);

(statearr_28183_28222[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (9))){
var _ = (function (){var statearr_28184 = state_28162;
(statearr_28184[(4)] = cljs.core.rest((state_28162[(4)])));

return statearr_28184;
})();
var state_28162__$1 = state_28162;
var ex28181 = (state_28162__$1[(2)]);
var statearr_28185_28223 = state_28162__$1;
(statearr_28185_28223[(5)] = ex28181);


var statearr_28186_28224 = state_28162__$1;
(statearr_28186_28224[(1)] = (4));

(statearr_28186_28224[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (5))){
var inst_28093 = (state_28162[(7)]);
var _ = (function (){var statearr_28187 = state_28162;
(statearr_28187[(4)] = cljs.core.cons((8),(state_28162[(4)])));

return statearr_28187;
})();
var inst_28100 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28093,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_28188 = state_28162;
(statearr_28188[(4)] = cljs.core.rest((state_28162[(4)])));

return statearr_28188;
})();
var state_28162__$1 = state_28162;
var statearr_28189_28225 = state_28162__$1;
(statearr_28189_28225[(2)] = inst_28100);

(statearr_28189_28225[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (14))){
var inst_28122 = (state_28162[(11)]);
var inst_28121 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28122__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28162__$1 = (function (){var statearr_28190 = state_28162;
(statearr_28190[(8)] = inst_28121);

(statearr_28190[(11)] = inst_28122__$1);

return statearr_28190;
})();
if(cljs.core.truth_(inst_28122__$1)){
var statearr_28191_28226 = state_28162__$1;
(statearr_28191_28226[(1)] = (16));

} else {
var statearr_28192_28227 = state_28162__$1;
(statearr_28192_28227[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (16))){
var inst_28122 = (state_28162[(11)]);
var state_28162__$1 = state_28162;
var statearr_28193_28228 = state_28162__$1;
(statearr_28193_28228[(2)] = inst_28122);

(statearr_28193_28228[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (10))){
var inst_28111 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_28162__$1 = state_28162;
var statearr_28195_28229 = state_28162__$1;
(statearr_28195_28229[(2)] = inst_28111);

(statearr_28195_28229[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (18))){
var inst_28128 = (state_28162[(2)]);
var state_28162__$1 = (function (){var statearr_28196 = state_28162;
(statearr_28196[(9)] = inst_28128);

return statearr_28196;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28197_28230 = state_28162__$1;
(statearr_28197_28230[(1)] = (19));

} else {
var statearr_28198_28231 = state_28162__$1;
(statearr_28198_28231[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28163 === (8))){
var _ = (function (){var statearr_28199 = state_28162;
(statearr_28199[(4)] = cljs.core.rest((state_28162[(4)])));

return statearr_28199;
})();
var state_28162__$1 = state_28162;
var ex28194 = (state_28162__$1[(2)]);
var statearr_28200_28232 = state_28162__$1;
(statearr_28200_28232[(5)] = ex28194);


var statearr_28201_28233 = state_28162__$1;
(statearr_28201_28233[(1)] = (7));

(statearr_28201_28233[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_28202 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28202[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_28202[(1)] = (1));

return statearr_28202;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_28162){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28162);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28203){var ex__2730__auto__ = e28203;
var statearr_28204_28234 = state_28162;
(statearr_28204_28234[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28162[(4)]))){
var statearr_28205_28235 = state_28162;
(statearr_28205_28235[(1)] = cljs.core.first((state_28162[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28236 = state_28162;
state_28162 = G__28236;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_28162){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_28162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28206 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28206[(6)] = c__2749__auto__);

return statearr_28206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__28238 = arguments.length;
switch (G__28238) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28282){
var state_val_28283 = (state_28282[(1)]);
if((state_val_28283 === (7))){
var inst_28260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28261 = ["*"];
var inst_28262 = (new cljs.core.PersistentVector(null,1,(5),inst_28260,inst_28261,null));
var state_28282__$1 = state_28282;
var statearr_28284_28304 = state_28282__$1;
(statearr_28284_28304[(2)] = inst_28262);

(statearr_28284_28304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (1))){
var state_28282__$1 = state_28282;
var statearr_28285_28305 = state_28282__$1;
(statearr_28285_28305[(2)] = null);

(statearr_28285_28305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (4))){
var inst_28239 = (state_28282[(2)]);
var inst_28240 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28239,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_28282__$1 = state_28282;
var statearr_28286_28306 = state_28282__$1;
(statearr_28286_28306[(2)] = inst_28240);

(statearr_28286_28306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (6))){
var inst_28252 = cljs.core.PersistentVector.EMPTY;
var inst_28253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28254 = ["*"];
var inst_28255 = (new cljs.core.PersistentVector(null,1,(5),inst_28253,inst_28254,null));
var inst_28256 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_28257 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_28255,inst_28256);
var inst_28258 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28252,inst_28257);
var state_28282__$1 = state_28282;
var statearr_28287_28307 = state_28282__$1;
(statearr_28287_28307[(2)] = inst_28258);

(statearr_28287_28307[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (3))){
var inst_28280 = (state_28282[(2)]);
var state_28282__$1 = state_28282;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28282__$1,inst_28280);
} else {
if((state_val_28283 === (2))){
var _ = (function (){var statearr_28289 = state_28282;
(statearr_28289[(4)] = cljs.core.cons((5),(state_28282[(4)])));

return statearr_28289;
})();
var inst_28249 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28250 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28282__$1 = (function (){var statearr_28290 = state_28282;
(statearr_28290[(7)] = inst_28250);

(statearr_28290[(8)] = inst_28249);

return statearr_28290;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28291_28308 = state_28282__$1;
(statearr_28291_28308[(1)] = (6));

} else {
var statearr_28292_28309 = state_28282__$1;
(statearr_28292_28309[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (9))){
var inst_28271 = (state_28282[(2)]);
var inst_28272 = fluree.db.util.async.throw_err(inst_28271);
var inst_28273 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28272,(0),null);
var inst_28274 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28272,(1),null);
var inst_28275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28276 = [inst_28273,inst_28274];
var inst_28277 = (new cljs.core.PersistentVector(null,2,(5),inst_28275,inst_28276,null));
var _ = (function (){var statearr_28293 = state_28282;
(statearr_28293[(4)] = cljs.core.rest((state_28282[(4)])));

return statearr_28293;
})();
var state_28282__$1 = state_28282;
var statearr_28294_28310 = state_28282__$1;
(statearr_28294_28310[(2)] = inst_28277);

(statearr_28294_28310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (5))){
var _ = (function (){var statearr_28295 = state_28282;
(statearr_28295[(4)] = cljs.core.rest((state_28282[(4)])));

return statearr_28295;
})();
var state_28282__$1 = state_28282;
var ex28288 = (state_28282__$1[(2)]);
var statearr_28296_28311 = state_28282__$1;
(statearr_28296_28311[(5)] = ex28288);


var statearr_28297_28312 = state_28282__$1;
(statearr_28297_28312[(1)] = (4));

(statearr_28297_28312[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (8))){
var inst_28250 = (state_28282[(7)]);
var inst_28249 = (state_28282[(8)]);
var inst_28264 = (state_28282[(2)]);
var inst_28265 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28266 = cljs.core.PersistentHashMap.EMPTY;
var inst_28267 = [inst_28264,inst_28250,inst_28266];
var inst_28268 = cljs.core.PersistentHashMap.fromArrays(inst_28265,inst_28267);
var inst_28269 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28249,inst_28268);
var state_28282__$1 = state_28282;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28282__$1,(9),inst_28269);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2727__auto____0 = (function (){
var statearr_28298 = [null,null,null,null,null,null,null,null,null];
(statearr_28298[(0)] = fluree$db$dbfunctions$internal$state_machine__2727__auto__);

(statearr_28298[(1)] = (1));

return statearr_28298;
});
var fluree$db$dbfunctions$internal$state_machine__2727__auto____1 = (function (state_28282){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28282);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28299){var ex__2730__auto__ = e28299;
var statearr_28300_28313 = state_28282;
(statearr_28300_28313[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28282[(4)]))){
var statearr_28301_28314 = state_28282;
(statearr_28301_28314[(1)] = cljs.core.first((state_28282[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28315 = state_28282;
state_28282 = G__28315;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2727__auto__ = function(state_28282){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2727__auto____1.call(this,state_28282);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28302 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28302[(6)] = c__2749__auto__);

return statearr_28302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28359){
var state_val_28360 = (state_28359[(1)]);
if((state_val_28360 === (1))){
var state_28359__$1 = state_28359;
var statearr_28361_28375 = state_28359__$1;
(statearr_28361_28375[(2)] = null);

(statearr_28361_28375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28360 === (2))){
var _ = (function (){var statearr_28362 = state_28359;
(statearr_28362[(4)] = cljs.core.cons((5),(state_28359[(4)])));

return statearr_28362;
})();
var inst_28326 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28328 = ["_user/_auth"];
var inst_28329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28330 = ["*"];
var inst_28331 = (new cljs.core.PersistentVector(null,1,(5),inst_28329,inst_28330,null));
var inst_28332 = [inst_28331];
var inst_28333 = cljs.core.PersistentHashMap.fromArrays(inst_28328,inst_28332);
var inst_28334 = [inst_28333];
var inst_28335 = (new cljs.core.PersistentVector(null,1,(5),inst_28327,inst_28334,null));
var inst_28336 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28337 = cljs.core.PersistentHashMap.EMPTY;
var inst_28338 = [inst_28335,inst_28336,inst_28337];
var inst_28339 = cljs.core.PersistentHashMap.fromArrays(inst_28326,inst_28338);
var inst_28340 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28341 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28340,inst_28339);
var state_28359__$1 = state_28359;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28359__$1,(6),inst_28341);
} else {
if((state_val_28360 === (3))){
var inst_28357 = (state_28359[(2)]);
var state_28359__$1 = state_28359;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28359__$1,inst_28357);
} else {
if((state_val_28360 === (4))){
var inst_28316 = (state_28359[(2)]);
var inst_28317 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28316,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_28359__$1 = state_28359;
var statearr_28364_28376 = state_28359__$1;
(statearr_28364_28376[(2)] = inst_28317);

(statearr_28364_28376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28360 === (5))){
var _ = (function (){var statearr_28365 = state_28359;
(statearr_28365[(4)] = cljs.core.rest((state_28359[(4)])));

return statearr_28365;
})();
var state_28359__$1 = state_28359;
var ex28363 = (state_28359__$1[(2)]);
var statearr_28366_28377 = state_28359__$1;
(statearr_28366_28377[(5)] = ex28363);


var statearr_28367_28378 = state_28359__$1;
(statearr_28367_28378[(1)] = (4));

(statearr_28367_28378[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28360 === (6))){
var inst_28343 = (state_28359[(2)]);
var inst_28344 = fluree.db.util.async.throw_err(inst_28343);
var inst_28345 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28344,(0),null);
var inst_28346 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28344,(1),null);
var inst_28347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28348 = ["_user/_auth","_id"];
var inst_28349 = (new cljs.core.PersistentVector(null,2,(5),inst_28347,inst_28348,null));
var inst_28350 = fluree.db.dbfunctions.internal.get_in(inst_28345,inst_28349);
var inst_28351 = cljs.core.first(inst_28350);
var inst_28352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28353 = [inst_28351,inst_28346];
var inst_28354 = (new cljs.core.PersistentVector(null,2,(5),inst_28352,inst_28353,null));
var _ = (function (){var statearr_28368 = state_28359;
(statearr_28368[(4)] = cljs.core.rest((state_28359[(4)])));

return statearr_28368;
})();
var state_28359__$1 = state_28359;
var statearr_28369_28379 = state_28359__$1;
(statearr_28369_28379[(2)] = inst_28354);

(statearr_28369_28379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0 = (function (){
var statearr_28370 = [null,null,null,null,null,null,null];
(statearr_28370[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__);

(statearr_28370[(1)] = (1));

return statearr_28370;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1 = (function (state_28359){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28359);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28371){var ex__2730__auto__ = e28371;
var statearr_28372_28380 = state_28359;
(statearr_28372_28380[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28359[(4)]))){
var statearr_28373_28381 = state_28359;
(statearr_28373_28381[(1)] = cljs.core.first((state_28359[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28382 = state_28359;
state_28359 = G__28382;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__ = function(state_28359){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1.call(this,state_28359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28374 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28374[(6)] = c__2749__auto__);

return statearr_28374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28404){
var state_val_28405 = (state_28404[(1)]);
if((state_val_28405 === (7))){
var inst_28389 = (state_28404[(7)]);
var inst_28393 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28394 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_28393,inst_28389);
var state_28404__$1 = state_28404;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28404__$1,(9),inst_28394);
} else {
if((state_val_28405 === (1))){
var state_28404__$1 = state_28404;
var statearr_28406_28425 = state_28404__$1;
(statearr_28406_28425[(2)] = null);

(statearr_28406_28425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28405 === (4))){
var inst_28383 = (state_28404[(2)]);
var state_28404__$1 = state_28404;
var statearr_28407_28426 = state_28404__$1;
(statearr_28407_28426[(2)] = inst_28383);

(statearr_28407_28426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28405 === (6))){
var inst_28389 = (state_28404[(7)]);
var state_28404__$1 = state_28404;
var statearr_28408_28427 = state_28404__$1;
(statearr_28408_28427[(2)] = inst_28389);

(statearr_28408_28427[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28405 === (3))){
var inst_28402 = (state_28404[(2)]);
var state_28404__$1 = state_28404;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28404__$1,inst_28402);
} else {
if((state_val_28405 === (2))){
var inst_28389 = (state_28404[(7)]);
var _ = (function (){var statearr_28410 = state_28404;
(statearr_28410[(4)] = cljs.core.cons((5),(state_28404[(4)])));

return statearr_28410;
})();
var inst_28389__$1 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28390 = typeof inst_28389__$1 === 'number';
var state_28404__$1 = (function (){var statearr_28411 = state_28404;
(statearr_28411[(7)] = inst_28389__$1);

return statearr_28411;
})();
if(cljs.core.truth_(inst_28390)){
var statearr_28412_28428 = state_28404__$1;
(statearr_28412_28428[(1)] = (6));

} else {
var statearr_28413_28429 = state_28404__$1;
(statearr_28413_28429[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28405 === (9))){
var inst_28396 = (state_28404[(2)]);
var inst_28397 = fluree.db.util.async.throw_err(inst_28396);
var state_28404__$1 = state_28404;
var statearr_28414_28430 = state_28404__$1;
(statearr_28414_28430[(2)] = inst_28397);

(statearr_28414_28430[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28405 === (5))){
var _ = (function (){var statearr_28415 = state_28404;
(statearr_28415[(4)] = cljs.core.rest((state_28404[(4)])));

return statearr_28415;
})();
var state_28404__$1 = state_28404;
var ex28409 = (state_28404__$1[(2)]);
var statearr_28416_28431 = state_28404__$1;
(statearr_28416_28431[(5)] = ex28409);


if((ex28409 instanceof Error)){
var statearr_28417_28432 = state_28404__$1;
(statearr_28417_28432[(1)] = (4));

(statearr_28417_28432[(5)] = null);

} else {
throw ex28409;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28405 === (8))){
var inst_28399 = (state_28404[(2)]);
var _ = (function (){var statearr_28418 = state_28404;
(statearr_28418[(4)] = cljs.core.rest((state_28404[(4)])));

return statearr_28418;
})();
var state_28404__$1 = state_28404;
var statearr_28419_28433 = state_28404__$1;
(statearr_28419_28433[(2)] = inst_28399);

(statearr_28419_28433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_28420 = [null,null,null,null,null,null,null,null];
(statearr_28420[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_28420[(1)] = (1));

return statearr_28420;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_28404){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28404);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28421){var ex__2730__auto__ = e28421;
var statearr_28422_28434 = state_28404;
(statearr_28422_28434[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28404[(4)]))){
var statearr_28423_28435 = state_28404;
(statearr_28423_28435[(1)] = cljs.core.first((state_28404[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28436 = state_28404;
state_28404 = G__28436;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_28404){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_28404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28424 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28424[(6)] = c__2749__auto__);

return statearr_28424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__28437_SHARP_){
return fluree.db.flake.op(p1__28437_SHARP_) === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__28438_SHARP_){
return fluree.db.flake.o(p1__28438_SHARP_);
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e28439){var e = e28439;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__28440_SHARP_){
return fluree.db.flake.op(p1__28440_SHARP_) === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__28441_SHARP_){
return fluree.db.flake.o(p1__28441_SHARP_);
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e28442){var e = e28442;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__28444 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__28444);
})() | (0));
return num;
}catch (e28443){var e = e28443;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_28524){
var state_val_28525 = (state_28524[(1)]);
if((state_val_28525 === (7))){
var inst_28463 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_28464 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28465 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_28466 = cljs.core.PersistentHashMap.fromArrays(inst_28464,inst_28465);
var inst_28467 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28463,inst_28466);
var inst_28468 = (function(){throw inst_28467})();
var state_28524__$1 = state_28524;
var statearr_28526_28561 = state_28524__$1;
(statearr_28526_28561[(2)] = inst_28468);

(statearr_28526_28561[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (1))){
var state_28524__$1 = state_28524;
var statearr_28527_28562 = state_28524__$1;
(statearr_28527_28562[(2)] = null);

(statearr_28527_28562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (4))){
var inst_28445 = (state_28524[(2)]);
var state_28524__$1 = state_28524;
var statearr_28528_28563 = state_28524__$1;
(statearr_28528_28563[(2)] = inst_28445);

(statearr_28528_28563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (15))){
var inst_28508 = (state_28524[(7)]);
var inst_28504 = (state_28524[(2)]);
var inst_28505 = fluree.db.util.async.throw_err(inst_28504);
var inst_28506 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28505,(0),null);
var inst_28507 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28505,(1),null);
var inst_28508__$1 = cljs.core.first(inst_28506);
var inst_28509 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28508__$1,compare_val);
var state_28524__$1 = (function (){var statearr_28529 = state_28524;
(statearr_28529[(8)] = inst_28507);

(statearr_28529[(7)] = inst_28508__$1);

return statearr_28529;
})();
if(inst_28509){
var statearr_28530_28564 = state_28524__$1;
(statearr_28530_28564[(1)] = (16));

} else {
var statearr_28531_28565 = state_28524__$1;
(statearr_28531_28565[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (13))){
var state_28524__$1 = state_28524;
var statearr_28532_28566 = state_28524__$1;
(statearr_28532_28566[(2)] = null);

(statearr_28532_28566[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (6))){
var state_28524__$1 = state_28524;
var statearr_28533_28567 = state_28524__$1;
(statearr_28533_28567[(2)] = null);

(statearr_28533_28567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (17))){
var inst_28508 = (state_28524[(7)]);
var inst_28512 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28508)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_28513 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28514 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_28515 = cljs.core.PersistentHashMap.fromArrays(inst_28513,inst_28514);
var inst_28516 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28512,inst_28515);
var inst_28517 = (function(){throw inst_28516})();
var state_28524__$1 = state_28524;
var statearr_28534_28568 = state_28524__$1;
(statearr_28534_28568[(2)] = inst_28517);

(statearr_28534_28568[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (3))){
var inst_28522 = (state_28524[(2)]);
var state_28524__$1 = state_28524;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28524__$1,inst_28522);
} else {
if((state_val_28525 === (12))){
var inst_28460 = (state_28524[(9)]);
var inst_28483 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_28460], 0));
var inst_28484 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28485 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_28486 = cljs.core.PersistentHashMap.fromArrays(inst_28484,inst_28485);
var inst_28487 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28483,inst_28486);
var inst_28488 = (function(){throw inst_28487})();
var state_28524__$1 = state_28524;
var statearr_28535_28569 = state_28524__$1;
(statearr_28535_28569[(2)] = inst_28488);

(statearr_28535_28569[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (2))){
var inst_28459 = (state_28524[(10)]);
var inst_28457 = (state_28524[(11)]);
var inst_28458 = (state_28524[(12)]);
var _ = (function (){var statearr_28536 = state_28524;
(statearr_28536[(4)] = cljs.core.cons((5),(state_28524[(4)])));

return statearr_28536;
})();
var inst_28455 = _QMARK_ctx;
var inst_28456 = cljs.core.__destructure_map(inst_28455);
var inst_28457__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28456,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_28458__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28456,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_28459__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28456,new cljs.core.Keyword(null,"db","db",993250759));
var inst_28460 = fluree.db.dbproto._p_prop(inst_28459__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_28458__$1);
var state_28524__$1 = (function (){var statearr_28537 = state_28524;
(statearr_28537[(9)] = inst_28460);

(statearr_28537[(10)] = inst_28459__$1);

(statearr_28537[(11)] = inst_28457__$1);

(statearr_28537[(12)] = inst_28458__$1);

return statearr_28537;
})();
if(cljs.core.truth_(inst_28457__$1)){
var statearr_28538_28570 = state_28524__$1;
(statearr_28538_28570[(1)] = (6));

} else {
var statearr_28539_28571 = state_28524__$1;
(statearr_28539_28571[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (11))){
var inst_28459 = (state_28524[(10)]);
var inst_28458 = (state_28524[(12)]);
var inst_28480 = (state_28524[(2)]);
var inst_28481 = fluree.db.dbproto._p_prop(inst_28459,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_28458);
var state_28524__$1 = (function (){var statearr_28541 = state_28524;
(statearr_28541[(13)] = inst_28480);

return statearr_28541;
})();
if(cljs.core.truth_(inst_28481)){
var statearr_28542_28572 = state_28524__$1;
(statearr_28542_28572[(1)] = (12));

} else {
var statearr_28543_28573 = state_28524__$1;
(statearr_28543_28573[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (9))){
var state_28524__$1 = state_28524;
var statearr_28544_28574 = state_28524__$1;
(statearr_28544_28574[(2)] = null);

(statearr_28544_28574[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (5))){
var _ = (function (){var statearr_28545 = state_28524;
(statearr_28545[(4)] = cljs.core.rest((state_28524[(4)])));

return statearr_28545;
})();
var state_28524__$1 = state_28524;
var ex28540 = (state_28524__$1[(2)]);
var statearr_28546_28575 = state_28524__$1;
(statearr_28546_28575[(5)] = ex28540);


if((ex28540 instanceof Error)){
var statearr_28547_28576 = state_28524__$1;
(statearr_28547_28576[(1)] = (4));

(statearr_28547_28576[(5)] = null);

} else {
throw ex28540;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (14))){
var inst_28460 = (state_28524[(9)]);
var inst_28459 = (state_28524[(10)]);
var inst_28457 = (state_28524[(11)]);
var inst_28491 = (state_28524[(2)]);
var inst_28492 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28494 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28495 = [inst_28457,inst_28460,"?current-val"];
var inst_28496 = (new cljs.core.PersistentVector(null,3,(5),inst_28494,inst_28495,null));
var inst_28497 = [inst_28496];
var inst_28498 = (new cljs.core.PersistentVector(null,1,(5),inst_28493,inst_28497,null));
var inst_28499 = cljs.core.PersistentHashMap.EMPTY;
var inst_28500 = ["?current-val",inst_28498,inst_28499];
var inst_28501 = cljs.core.PersistentHashMap.fromArrays(inst_28492,inst_28500);
var inst_28502 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28459,inst_28501);
var state_28524__$1 = (function (){var statearr_28548 = state_28524;
(statearr_28548[(14)] = inst_28491);

return statearr_28548;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28524__$1,(15),inst_28502);
} else {
if((state_val_28525 === (16))){
var state_28524__$1 = state_28524;
var statearr_28549_28577 = state_28524__$1;
(statearr_28549_28577[(2)] = new_val);

(statearr_28549_28577[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (10))){
var inst_28473 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_28474 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28475 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_28476 = cljs.core.PersistentHashMap.fromArrays(inst_28474,inst_28475);
var inst_28477 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28473,inst_28476);
var inst_28478 = (function(){throw inst_28477})();
var state_28524__$1 = state_28524;
var statearr_28550_28578 = state_28524__$1;
(statearr_28550_28578[(2)] = inst_28478);

(statearr_28550_28578[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (18))){
var inst_28519 = (state_28524[(2)]);
var _ = (function (){var statearr_28551 = state_28524;
(statearr_28551[(4)] = cljs.core.rest((state_28524[(4)])));

return statearr_28551;
})();
var state_28524__$1 = state_28524;
var statearr_28552_28579 = state_28524__$1;
(statearr_28552_28579[(2)] = inst_28519);

(statearr_28552_28579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28525 === (8))){
var inst_28460 = (state_28524[(9)]);
var inst_28470 = (state_28524[(2)]);
var state_28524__$1 = (function (){var statearr_28553 = state_28524;
(statearr_28553[(15)] = inst_28470);

return statearr_28553;
})();
if(cljs.core.truth_(inst_28460)){
var statearr_28554_28580 = state_28524__$1;
(statearr_28554_28580[(1)] = (9));

} else {
var statearr_28555_28581 = state_28524__$1;
(statearr_28555_28581[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_28556 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28556[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__);

(statearr_28556[(1)] = (1));

return statearr_28556;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1 = (function (state_28524){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_28524);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e28557){var ex__2730__auto__ = e28557;
var statearr_28558_28582 = state_28524;
(statearr_28558_28582[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_28524[(4)]))){
var statearr_28559_28583 = state_28524;
(statearr_28559_28583[(1)] = cljs.core.first((state_28524[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28584 = state_28524;
state_28524 = G__28584;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__ = function(state_28524){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1.call(this,state_28524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_28560 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_28560[(6)] = c__2749__auto__);

return statearr_28560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
