// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__75179 = arguments.length;
switch (G__75179) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___75218 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75200){
var state_val_75201 = (state_75200[(1)]);
if((state_val_75201 === (1))){
var state_75200__$1 = state_75200;
var statearr_75202_75219 = state_75200__$1;
(statearr_75202_75219[(2)] = null);

(statearr_75202_75219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75201 === (2))){
var _ = (function (){var statearr_75203 = state_75200;
(statearr_75203[(4)] = cljs.core.cons((5),(state_75200[(4)])));

return statearr_75203;
})();
var inst_75186 = fluree.db.session.db(conn,ledger,null);
var state_75200__$1 = state_75200;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75200__$1,(7),inst_75186);
} else {
if((state_val_75201 === (3))){
var inst_75196 = (state_75200[(2)]);
var inst_75197 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_75196);
var inst_75198 = cljs.core.async.close_BANG_(pc);
var state_75200__$1 = (function (){var statearr_75205 = state_75200;
(statearr_75205[(7)] = inst_75197);

return statearr_75205;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_75200__$1,inst_75198);
} else {
if((state_val_75201 === (4))){
var inst_75180 = (state_75200[(2)]);
var state_75200__$1 = state_75200;
var statearr_75206_75220 = state_75200__$1;
(statearr_75206_75220[(2)] = inst_75180);

(statearr_75206_75220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75201 === (5))){
var _ = (function (){var statearr_75207 = state_75200;
(statearr_75207[(4)] = cljs.core.rest((state_75200[(4)])));

return statearr_75207;
})();
var state_75200__$1 = state_75200;
var ex75204 = (state_75200__$1[(2)]);
var statearr_75208_75221 = state_75200__$1;
(statearr_75208_75221[(5)] = ex75204);


var statearr_75209_75222 = state_75200__$1;
(statearr_75209_75222[(1)] = (4));

(statearr_75209_75222[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75201 === (6))){
var inst_75192 = (state_75200[(2)]);
var inst_75193 = fluree.db.util.async.throw_err(inst_75192);
var _ = (function (){var statearr_75210 = state_75200;
(statearr_75210[(4)] = cljs.core.rest((state_75200[(4)])));

return statearr_75210;
})();
var state_75200__$1 = state_75200;
var statearr_75211_75223 = state_75200__$1;
(statearr_75211_75223[(2)] = inst_75193);

(statearr_75211_75223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75201 === (7))){
var inst_75188 = (state_75200[(2)]);
var inst_75189 = fluree.db.util.async.throw_err(inst_75188);
var inst_75190 = fluree.db.time_travel.as_of_block(inst_75189,block);
var state_75200__$1 = state_75200;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75200__$1,(6),inst_75190);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_75212 = [null,null,null,null,null,null,null,null];
(statearr_75212[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_75212[(1)] = (1));

return statearr_75212;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_75200){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75200);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75213){var ex__2730__auto__ = e75213;
var statearr_75214_75224 = state_75200;
(statearr_75214_75224[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75200[(4)]))){
var statearr_75215_75225 = state_75200;
(statearr_75215_75225[(1)] = cljs.core.first((state_75200[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75226 = state_75200;
state_75200 = G__75226;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_75200){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_75200);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75216 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75216[(6)] = c__2749__auto___75218);

return statearr_75216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75267){
var state_val_75268 = (state_75267[(1)]);
if((state_val_75268 === (7))){
var inst_75236 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_75267__$1 = state_75267;
if(inst_75236){
var statearr_75269_75300 = state_75267__$1;
(statearr_75269_75300[(1)] = (9));

} else {
var statearr_75270_75301 = state_75267__$1;
(statearr_75270_75301[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (1))){
var state_75267__$1 = state_75267;
var statearr_75271_75302 = state_75267__$1;
(statearr_75271_75302[(2)] = null);

(statearr_75271_75302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (4))){
var inst_75227 = (state_75267[(2)]);
var state_75267__$1 = state_75267;
var statearr_75272_75303 = state_75267__$1;
(statearr_75272_75303[(2)] = inst_75227);

(statearr_75272_75303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (15))){
var inst_75244 = (state_75267[(7)]);
var inst_75243 = (state_75267[(2)]);
var inst_75244__$1 = fluree.db.util.async.throw_err(inst_75243);
var state_75267__$1 = (function (){var statearr_75273 = state_75267;
(statearr_75273[(7)] = inst_75244__$1);

return statearr_75273;
})();
if(cljs.core.truth_(inst_75244__$1)){
var statearr_75274_75304 = state_75267__$1;
(statearr_75274_75304[(1)] = (16));

} else {
var statearr_75275_75305 = state_75267__$1;
(statearr_75275_75305[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (13))){
var state_75267__$1 = state_75267;
var statearr_75276_75306 = state_75267__$1;
(statearr_75276_75306[(2)] = null);

(statearr_75276_75306[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (6))){
var state_75267__$1 = state_75267;
var statearr_75277_75307 = state_75267__$1;
(statearr_75277_75307[(2)] = db);

(statearr_75277_75307[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (17))){
var inst_75248 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_75249 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75250 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_75251 = cljs.core.PersistentHashMap.fromArrays(inst_75249,inst_75250);
var inst_75252 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75248,inst_75251);
var inst_75253 = (function(){throw inst_75252})();
var state_75267__$1 = state_75267;
var statearr_75278_75308 = state_75267__$1;
(statearr_75278_75308[(2)] = inst_75253);

(statearr_75278_75308[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (3))){
var inst_75265 = (state_75267[(2)]);
var state_75267__$1 = state_75267;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75267__$1,inst_75265);
} else {
if((state_val_75268 === (12))){
var inst_75241 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_75267__$1 = state_75267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75267__$1,(15),inst_75241);
} else {
if((state_val_75268 === (2))){
var _ = (function (){var statearr_75279 = state_75267;
(statearr_75279[(4)] = cljs.core.cons((5),(state_75267[(4)])));

return statearr_75279;
})();
var inst_75233 = cljs.core.not(auth);
var state_75267__$1 = state_75267;
if(inst_75233){
var statearr_75280_75309 = state_75267__$1;
(statearr_75280_75309[(1)] = (6));

} else {
var statearr_75281_75310 = state_75267__$1;
(statearr_75281_75310[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (11))){
var inst_75260 = (state_75267[(2)]);
var state_75267__$1 = state_75267;
var statearr_75283_75311 = state_75267__$1;
(statearr_75283_75311[(2)] = inst_75260);

(statearr_75283_75311[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (9))){
var inst_75238 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_75267__$1 = state_75267;
var statearr_75284_75312 = state_75267__$1;
(statearr_75284_75312[(2)] = inst_75238);

(statearr_75284_75312[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (5))){
var _ = (function (){var statearr_75285 = state_75267;
(statearr_75285[(4)] = cljs.core.rest((state_75267[(4)])));

return statearr_75285;
})();
var state_75267__$1 = state_75267;
var ex75282 = (state_75267__$1[(2)]);
var statearr_75286_75313 = state_75267__$1;
(statearr_75286_75313[(5)] = ex75282);


if((ex75282 instanceof Error)){
var statearr_75287_75314 = state_75267__$1;
(statearr_75287_75314[(1)] = (4));

(statearr_75287_75314[(5)] = null);

} else {
throw ex75282;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (14))){
var inst_75258 = (state_75267[(2)]);
var state_75267__$1 = state_75267;
var statearr_75288_75315 = state_75267__$1;
(statearr_75288_75315[(2)] = inst_75258);

(statearr_75288_75315[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (16))){
var inst_75244 = (state_75267[(7)]);
var inst_75246 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_75244);
var state_75267__$1 = state_75267;
var statearr_75289_75316 = state_75267__$1;
(statearr_75289_75316[(2)] = inst_75246);

(statearr_75289_75316[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (10))){
var state_75267__$1 = state_75267;
var statearr_75290_75317 = state_75267__$1;
(statearr_75290_75317[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (18))){
var inst_75255 = (state_75267[(2)]);
var state_75267__$1 = state_75267;
var statearr_75292_75318 = state_75267__$1;
(statearr_75292_75318[(2)] = inst_75255);

(statearr_75292_75318[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75268 === (8))){
var inst_75262 = (state_75267[(2)]);
var _ = (function (){var statearr_75293 = state_75267;
(statearr_75293[(4)] = cljs.core.rest((state_75267[(4)])));

return statearr_75293;
})();
var state_75267__$1 = state_75267;
var statearr_75294_75319 = state_75267__$1;
(statearr_75294_75319[(2)] = inst_75262);

(statearr_75294_75319[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0 = (function (){
var statearr_75295 = [null,null,null,null,null,null,null,null];
(statearr_75295[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__);

(statearr_75295[(1)] = (1));

return statearr_75295;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1 = (function (state_75267){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75267);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75296){var ex__2730__auto__ = e75296;
var statearr_75297_75320 = state_75267;
(statearr_75297_75320[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75267[(4)]))){
var statearr_75298_75321 = state_75267;
(statearr_75298_75321[(1)] = cljs.core.first((state_75267[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75322 = state_75267;
state_75267 = G__75322;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = function(state_75267){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1.call(this,state_75267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75299 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75299[(6)] = c__2749__auto__);

return statearr_75299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75394){
var state_val_75395 = (state_75394[(1)]);
if((state_val_75395 === (7))){
var inst_75332 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_75394__$1 = state_75394;
if(inst_75332){
var statearr_75396_75450 = state_75394__$1;
(statearr_75396_75450[(1)] = (9));

} else {
var statearr_75397_75451 = state_75394__$1;
(statearr_75397_75451[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (20))){
var inst_75356 = (state_75394[(7)]);
var state_75394__$1 = state_75394;
if(cljs.core.truth_(inst_75356)){
var statearr_75398_75452 = state_75394__$1;
(statearr_75398_75452[(1)] = (22));

} else {
var statearr_75399_75453 = state_75394__$1;
(statearr_75399_75453[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (27))){
var state_75394__$1 = state_75394;
var statearr_75400_75454 = state_75394__$1;
(statearr_75400_75454[(2)] = null);

(statearr_75400_75454[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (1))){
var state_75394__$1 = state_75394;
var statearr_75401_75455 = state_75394__$1;
(statearr_75401_75455[(2)] = null);

(statearr_75401_75455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (24))){
var inst_75370 = (state_75394[(2)]);
var state_75394__$1 = state_75394;
var statearr_75402_75456 = state_75394__$1;
(statearr_75402_75456[(2)] = inst_75370);

(statearr_75402_75456[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (4))){
var inst_75323 = (state_75394[(2)]);
var state_75394__$1 = state_75394;
var statearr_75403_75457 = state_75394__$1;
(statearr_75403_75457[(2)] = inst_75323);

(statearr_75403_75457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (15))){
var inst_75339 = (state_75394[(8)]);
var inst_75338 = (state_75394[(2)]);
var inst_75339__$1 = fluree.db.util.async.throw_err(inst_75338);
var state_75394__$1 = (function (){var statearr_75404 = state_75394;
(statearr_75404[(8)] = inst_75339__$1);

return statearr_75404;
})();
if(cljs.core.truth_(inst_75339__$1)){
var statearr_75405_75458 = state_75394__$1;
(statearr_75405_75458[(1)] = (16));

} else {
var statearr_75406_75459 = state_75394__$1;
(statearr_75406_75459[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (21))){
var inst_75372 = (state_75394[(9)]);
var inst_75372__$1 = (state_75394[(2)]);
var state_75394__$1 = (function (){var statearr_75407 = state_75394;
(statearr_75407[(9)] = inst_75372__$1);

return statearr_75407;
})();
if(cljs.core.truth_(inst_75372__$1)){
var statearr_75408_75460 = state_75394__$1;
(statearr_75408_75460[(1)] = (29));

} else {
var statearr_75409_75461 = state_75394__$1;
(statearr_75409_75461[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (31))){
var inst_75372 = (state_75394[(9)]);
var inst_75380 = (state_75394[(2)]);
var state_75394__$1 = (function (){var statearr_75410 = state_75394;
(statearr_75410[(10)] = inst_75380);

return statearr_75410;
})();
if(cljs.core.truth_(inst_75372)){
var statearr_75411_75462 = state_75394__$1;
(statearr_75411_75462[(1)] = (33));

} else {
var statearr_75412_75463 = state_75394__$1;
(statearr_75412_75463[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (32))){
var inst_75376 = (state_75394[(2)]);
var inst_75377 = fluree.db.util.async.throw_err(inst_75376);
var state_75394__$1 = state_75394;
var statearr_75413_75464 = state_75394__$1;
(statearr_75413_75464[(2)] = inst_75377);

(statearr_75413_75464[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (33))){
var inst_75372 = (state_75394[(9)]);
var inst_75382 = fluree.db.permissions.permission_map(db,inst_75372,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_75394__$1 = state_75394;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75394__$1,(36),inst_75382);
} else {
if((state_val_75395 === (13))){
var state_75394__$1 = state_75394;
var statearr_75414_75465 = state_75394__$1;
(statearr_75414_75465[(2)] = null);

(statearr_75414_75465[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (22))){
var inst_75356 = (state_75394[(7)]);
var inst_75360 = fluree.db.auth.roles(db,inst_75356);
var state_75394__$1 = state_75394;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75394__$1,(25),inst_75360);
} else {
if((state_val_75395 === (36))){
var inst_75384 = (state_75394[(2)]);
var inst_75385 = fluree.db.util.async.throw_err(inst_75384);
var state_75394__$1 = state_75394;
var statearr_75415_75466 = state_75394__$1;
(statearr_75415_75466[(2)] = inst_75385);

(statearr_75415_75466[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (29))){
var inst_75372 = (state_75394[(9)]);
var inst_75356 = (state_75394[(7)]);
var inst_75374 = fluree.db.dbfunctions.ctx.build(db,inst_75356,inst_75372);
var state_75394__$1 = state_75394;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75394__$1,(32),inst_75374);
} else {
if((state_val_75395 === (6))){
var state_75394__$1 = state_75394;
var statearr_75416_75467 = state_75394__$1;
(statearr_75416_75467[(2)] = null);

(statearr_75416_75467[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (28))){
var inst_75368 = (state_75394[(2)]);
var state_75394__$1 = state_75394;
var statearr_75417_75468 = state_75394__$1;
(statearr_75417_75468[(2)] = inst_75368);

(statearr_75417_75468[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (25))){
var inst_75362 = (state_75394[(2)]);
var inst_75363 = fluree.db.util.async.throw_err(inst_75362);
var state_75394__$1 = state_75394;
var statearr_75418_75469 = state_75394__$1;
(statearr_75418_75469[(2)] = inst_75363);

(statearr_75418_75469[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (34))){
var state_75394__$1 = state_75394;
var statearr_75419_75470 = state_75394__$1;
(statearr_75419_75470[(2)] = null);

(statearr_75419_75470[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (17))){
var inst_75342 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_75343 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75344 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_75345 = cljs.core.PersistentHashMap.fromArrays(inst_75343,inst_75344);
var inst_75346 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75342,inst_75345);
var inst_75347 = (function(){throw inst_75346})();
var state_75394__$1 = state_75394;
var statearr_75420_75471 = state_75394__$1;
(statearr_75420_75471[(2)] = inst_75347);

(statearr_75420_75471[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (3))){
var inst_75392 = (state_75394[(2)]);
var state_75394__$1 = state_75394;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75394__$1,inst_75392);
} else {
if((state_val_75395 === (12))){
var inst_75336 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_75394__$1 = state_75394;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75394__$1,(15),inst_75336);
} else {
if((state_val_75395 === (2))){
var _ = (function (){var statearr_75421 = state_75394;
(statearr_75421[(4)] = cljs.core.cons((5),(state_75394[(4)])));

return statearr_75421;
})();
var inst_75329 = (auth == null);
var state_75394__$1 = state_75394;
if(cljs.core.truth_(inst_75329)){
var statearr_75422_75472 = state_75394__$1;
(statearr_75422_75472[(1)] = (6));

} else {
var statearr_75423_75473 = state_75394__$1;
(statearr_75423_75473[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (23))){
var state_75394__$1 = state_75394;
var statearr_75424_75474 = state_75394__$1;
(statearr_75424_75474[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (35))){
var inst_75372 = (state_75394[(9)]);
var inst_75380 = (state_75394[(10)]);
var inst_75356 = (state_75394[(7)]);
var inst_75388 = (state_75394[(2)]);
var inst_75389 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_75356,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_75372,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_75388,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_75380], 0));
var _ = (function (){var statearr_75426 = state_75394;
(statearr_75426[(4)] = cljs.core.rest((state_75394[(4)])));

return statearr_75426;
})();
var state_75394__$1 = state_75394;
var statearr_75427_75475 = state_75394__$1;
(statearr_75427_75475[(2)] = inst_75389);

(statearr_75427_75475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (19))){
var state_75394__$1 = state_75394;
var statearr_75428_75476 = state_75394__$1;
(statearr_75428_75476[(2)] = roles);

(statearr_75428_75476[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (11))){
var inst_75354 = (state_75394[(2)]);
var state_75394__$1 = state_75394;
var statearr_75430_75477 = state_75394__$1;
(statearr_75430_75477[(2)] = inst_75354);

(statearr_75430_75477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (9))){
var state_75394__$1 = state_75394;
var statearr_75431_75478 = state_75394__$1;
(statearr_75431_75478[(2)] = (0));

(statearr_75431_75478[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (5))){
var _ = (function (){var statearr_75432 = state_75394;
(statearr_75432[(4)] = cljs.core.rest((state_75394[(4)])));

return statearr_75432;
})();
var state_75394__$1 = state_75394;
var ex75429 = (state_75394__$1[(2)]);
var statearr_75433_75479 = state_75394__$1;
(statearr_75433_75479[(5)] = ex75429);


if((ex75429 instanceof Error)){
var statearr_75434_75480 = state_75394__$1;
(statearr_75434_75480[(1)] = (4));

(statearr_75434_75480[(5)] = null);

} else {
throw ex75429;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (14))){
var inst_75352 = (state_75394[(2)]);
var state_75394__$1 = state_75394;
var statearr_75435_75481 = state_75394__$1;
(statearr_75435_75481[(2)] = inst_75352);

(statearr_75435_75481[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (26))){
var state_75394__$1 = state_75394;
var statearr_75436_75482 = state_75394__$1;
(statearr_75436_75482[(2)] = null);

(statearr_75436_75482[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (16))){
var inst_75339 = (state_75394[(8)]);
var state_75394__$1 = state_75394;
var statearr_75437_75483 = state_75394__$1;
(statearr_75437_75483[(2)] = inst_75339);

(statearr_75437_75483[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (30))){
var state_75394__$1 = state_75394;
var statearr_75438_75484 = state_75394__$1;
(statearr_75438_75484[(2)] = null);

(statearr_75438_75484[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (10))){
var state_75394__$1 = state_75394;
if(cljs.core.truth_(auth)){
var statearr_75439_75485 = state_75394__$1;
(statearr_75439_75485[(1)] = (12));

} else {
var statearr_75440_75486 = state_75394__$1;
(statearr_75440_75486[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (18))){
var inst_75349 = (state_75394[(2)]);
var state_75394__$1 = state_75394;
var statearr_75441_75487 = state_75394__$1;
(statearr_75441_75487[(2)] = inst_75349);

(statearr_75441_75487[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75395 === (8))){
var inst_75356 = (state_75394[(2)]);
var state_75394__$1 = (function (){var statearr_75442 = state_75394;
(statearr_75442[(7)] = inst_75356);

return statearr_75442;
})();
if(cljs.core.truth_(roles)){
var statearr_75443_75488 = state_75394__$1;
(statearr_75443_75488[(1)] = (19));

} else {
var statearr_75444_75489 = state_75394__$1;
(statearr_75444_75489[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0 = (function (){
var statearr_75445 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_75445[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__);

(statearr_75445[(1)] = (1));

return statearr_75445;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1 = (function (state_75394){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75394);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75446){var ex__2730__auto__ = e75446;
var statearr_75447_75490 = state_75394;
(statearr_75447_75490[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75394[(4)]))){
var statearr_75448_75491 = state_75394;
(statearr_75448_75491[(1)] = cljs.core.first((state_75394[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75492 = state_75394;
state_75394 = G__75492;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = function(state_75394){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1.call(this,state_75394);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75449 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75449[(6)] = c__2749__auto__);

return statearr_75449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__75493 = db;
var map__75493__$1 = cljs.core.__destructure_map(map__75493);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75493__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75493__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75493__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75500){
var state_val_75501 = (state_75500[(1)]);
if((state_val_75501 === (1))){
var inst_75494 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_75495 = fluree.db.session.db(conn,inst_75494,null);
var state_75500__$1 = state_75500;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75500__$1,(2),inst_75495);
} else {
if((state_val_75501 === (2))){
var inst_75497 = (state_75500[(2)]);
var inst_75498 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_75497);
var state_75500__$1 = state_75500;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75500__$1,inst_75498);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_75502 = [null,null,null,null,null,null,null];
(statearr_75502[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_75502[(1)] = (1));

return statearr_75502;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_75500){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75500);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75503){var ex__2730__auto__ = e75503;
var statearr_75504_75531 = state_75500;
(statearr_75504_75531[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75500[(4)]))){
var statearr_75505_75532 = state_75500;
(statearr_75505_75532[(1)] = cljs.core.first((state_75500[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75533 = state_75500;
state_75500 = G__75533;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_75500){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_75500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75506 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75506[(6)] = c__2749__auto__);

return statearr_75506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,ledger_id,listen_id,event_fn);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75519){
var state_val_75520 = (state_75519[(1)]);
if((state_val_75520 === (1))){
var inst_75507 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_75508 = fluree.db.session.db(conn,inst_75507,null);
var state_75519__$1 = state_75519;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75519__$1,(2),inst_75508);
} else {
if((state_val_75520 === (2))){
var inst_75510 = (state_75519[(7)]);
var inst_75510__$1 = (state_75519[(2)]);
var inst_75511 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_75510__$1);
var inst_75512 = newer_block_QMARK_(inst_75511);
var state_75519__$1 = (function (){var statearr_75521 = state_75519;
(statearr_75521[(7)] = inst_75510__$1);

return statearr_75521;
})();
if(inst_75512){
var statearr_75522_75534 = state_75519__$1;
(statearr_75522_75534[(1)] = (3));

} else {
var statearr_75523_75535 = state_75519__$1;
(statearr_75523_75535[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75520 === (3))){
var inst_75510 = (state_75519[(7)]);
var inst_75514 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_75510);
var state_75519__$1 = state_75519;
var statearr_75524_75536 = state_75519__$1;
(statearr_75524_75536[(2)] = inst_75514);

(statearr_75524_75536[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75520 === (4))){
var state_75519__$1 = state_75519;
var statearr_75525_75537 = state_75519__$1;
(statearr_75525_75537[(2)] = null);

(statearr_75525_75537[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75520 === (5))){
var inst_75517 = (state_75519[(2)]);
var state_75519__$1 = state_75519;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75519__$1,inst_75517);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_75526 = [null,null,null,null,null,null,null,null];
(statearr_75526[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_75526[(1)] = (1));

return statearr_75526;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_75519){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75519);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75527){var ex__2730__auto__ = e75527;
var statearr_75528_75538 = state_75519;
(statearr_75528_75538[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75519[(4)]))){
var statearr_75529_75539 = state_75519;
(statearr_75529_75539[(1)] = cljs.core.first((state_75519[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75540 = state_75519;
state_75519 = G__75540;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_75519){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_75519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75530 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75530[(6)] = c__2749__auto__);

return statearr_75530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__75541 = db;
var map__75541__$1 = cljs.core.__destructure_map(map__75541);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75541__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75541__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75541__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4339__auto__ = syncTimeout;
var y__4340__auto__ = (120000);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2749__auto___75617 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75591){
var state_val_75592 = (state_75591[(1)]);
if((state_val_75592 === (7))){
var inst_75557 = (state_75591[(7)]);
var inst_75568 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75557,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_75591__$1 = state_75591;
if(inst_75568){
var statearr_75593_75618 = state_75591__$1;
(statearr_75593_75618[(1)] = (9));

} else {
var statearr_75594_75619 = state_75591__$1;
(statearr_75594_75619[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (1))){
var inst_75542 = (state_75591[(8)]);
var inst_75550 = (state_75591[(9)]);
var inst_75542__$1 = cljs.core.async.timeout(timeout);
var inst_75550__$1 = res_port;
var inst_75551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75552 = [inst_75542__$1,inst_75550__$1];
var inst_75553 = (new cljs.core.PersistentVector(null,2,(5),inst_75551,inst_75552,null));
var state_75591__$1 = (function (){var statearr_75595 = state_75591;
(statearr_75595[(8)] = inst_75542__$1);

(statearr_75595[(9)] = inst_75550__$1);

return statearr_75595;
})();
return cljs.core.async.ioc_alts_BANG_(state_75591__$1,(2),inst_75553);
} else {
if((state_val_75592 === (4))){
var inst_75557 = (state_75591[(7)]);
var inst_75550 = (state_75591[(9)]);
var inst_75561 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75557,inst_75550);
var state_75591__$1 = state_75591;
if(inst_75561){
var statearr_75596_75620 = state_75591__$1;
(statearr_75596_75620[(1)] = (6));

} else {
var statearr_75597_75621 = state_75591__$1;
(statearr_75597_75621[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (13))){
var inst_75576 = (state_75591[(10)]);
var inst_75587 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_75576);
var state_75591__$1 = state_75591;
var statearr_75598_75622 = state_75591__$1;
(statearr_75598_75622[(2)] = inst_75587);

(statearr_75598_75622[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (6))){
var inst_75555 = (state_75591[(11)]);
var inst_75566 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75555,(0),null);
var state_75591__$1 = state_75591;
var statearr_75599_75623 = state_75591__$1;
(statearr_75599_75623[(2)] = inst_75566);

(statearr_75599_75623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (3))){
var state_75591__$1 = state_75591;
var statearr_75600_75624 = state_75591__$1;
(statearr_75600_75624[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_75600_75624[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (12))){
var inst_75580 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_75581 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75582 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_75583 = cljs.core.PersistentHashMap.fromArrays(inst_75581,inst_75582);
var inst_75584 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75580,inst_75583);
var inst_75585 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_75584);
var state_75591__$1 = state_75591;
var statearr_75601_75625 = state_75591__$1;
(statearr_75601_75625[(2)] = inst_75585);

(statearr_75601_75625[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (2))){
var inst_75557 = (state_75591[(7)]);
var inst_75542 = (state_75591[(8)]);
var inst_75555 = (state_75591[(11)]);
var inst_75555__$1 = (state_75591[(2)]);
var inst_75556 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75555__$1,(0),null);
var inst_75557__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75555__$1,(1),null);
var inst_75558 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75557__$1,inst_75542);
var state_75591__$1 = (function (){var statearr_75602 = state_75591;
(statearr_75602[(7)] = inst_75557__$1);

(statearr_75602[(12)] = inst_75556);

(statearr_75602[(11)] = inst_75555__$1);

return statearr_75602;
})();
if(inst_75558){
var statearr_75603_75626 = state_75591__$1;
(statearr_75603_75626[(1)] = (3));

} else {
var statearr_75604_75627 = state_75591__$1;
(statearr_75604_75627[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (11))){
var inst_75572 = (state_75591[(2)]);
var state_75591__$1 = state_75591;
var statearr_75605_75628 = state_75591__$1;
(statearr_75605_75628[(2)] = inst_75572);

(statearr_75605_75628[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (9))){
var inst_75556 = (state_75591[(12)]);
var state_75591__$1 = state_75591;
var statearr_75606_75629 = state_75591__$1;
(statearr_75606_75629[(2)] = inst_75556);

(statearr_75606_75629[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (5))){
var inst_75576 = (state_75591[(10)]);
var inst_75576__$1 = (state_75591[(2)]);
var inst_75577 = fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);
var inst_75578 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_75576__$1);
var state_75591__$1 = (function (){var statearr_75607 = state_75591;
(statearr_75607[(13)] = inst_75577);

(statearr_75607[(10)] = inst_75576__$1);

return statearr_75607;
})();
if(inst_75578){
var statearr_75608_75630 = state_75591__$1;
(statearr_75608_75630[(1)] = (12));

} else {
var statearr_75609_75631 = state_75591__$1;
(statearr_75609_75631[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (14))){
var inst_75589 = (state_75591[(2)]);
var state_75591__$1 = state_75591;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75591__$1,inst_75589);
} else {
if((state_val_75592 === (10))){
var state_75591__$1 = state_75591;
var statearr_75610_75632 = state_75591__$1;
(statearr_75610_75632[(2)] = null);

(statearr_75610_75632[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75592 === (8))){
var inst_75574 = (state_75591[(2)]);
var state_75591__$1 = state_75591;
var statearr_75611_75633 = state_75591__$1;
(statearr_75611_75633[(2)] = inst_75574);

(statearr_75611_75633[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0 = (function (){
var statearr_75612 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75612[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__);

(statearr_75612[(1)] = (1));

return statearr_75612;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1 = (function (state_75591){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75591);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75613){var ex__2730__auto__ = e75613;
var statearr_75614_75634 = state_75591;
(statearr_75614_75634[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75591[(4)]))){
var statearr_75615_75635 = state_75591;
(statearr_75615_75635[(1)] = cljs.core.first((state_75591[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75636 = state_75591;
state_75591 = G__75636;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = function(state_75591){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1.call(this,state_75591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75616 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75616[(6)] = c__2749__auto___75617);

return statearr_75616;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__75638 = arguments.length;
switch (G__75638) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__75639){
var map__75640 = p__75639;
var map__75640__$1 = cljs.core.__destructure_map(map__75640);
var opts = map__75640__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75640__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75640__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75640__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75640__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75640__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2749__auto___75729 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_75691){
var state_val_75692 = (state_75691[(1)]);
if((state_val_75692 === (7))){
var inst_75653 = (state_75691[(7)]);
var inst_75655 = fluree.db.api.ledger.syncTo_db(inst_75653,syncTo,syncTimeout);
var state_75691__$1 = state_75691;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75691__$1,(10),inst_75655);
} else {
if((state_val_75692 === (20))){
var inst_75677 = (state_75691[(8)]);
var state_75691__$1 = state_75691;
var statearr_75693_75730 = state_75691__$1;
(statearr_75693_75730[(2)] = inst_75677);

(statearr_75693_75730[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (1))){
var state_75691__$1 = state_75691;
var statearr_75694_75731 = state_75691__$1;
(statearr_75694_75731[(2)] = null);

(statearr_75694_75731[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (4))){
var inst_75641 = (state_75691[(2)]);
var inst_75642 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_75641);
var inst_75643 = cljs.core.async.close_BANG_(pc);
var state_75691__$1 = (function (){var statearr_75695 = state_75691;
(statearr_75695[(9)] = inst_75642);

return statearr_75695;
})();
var statearr_75696_75732 = state_75691__$1;
(statearr_75696_75732[(2)] = inst_75643);

(statearr_75696_75732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (15))){
var inst_75669 = (state_75691[(10)]);
var inst_75671 = fluree.db.api.ledger.add_db_permissions(inst_75669,auth,roles);
var state_75691__$1 = state_75691;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75691__$1,(18),inst_75671);
} else {
if((state_val_75692 === (21))){
var inst_75685 = (state_75691[(2)]);
var inst_75686 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_75685);
var _ = (function (){var statearr_75697 = state_75691;
(statearr_75697[(4)] = cljs.core.rest((state_75691[(4)])));

return statearr_75697;
})();
var state_75691__$1 = state_75691;
var statearr_75698_75733 = state_75691__$1;
(statearr_75698_75733[(2)] = inst_75686);

(statearr_75698_75733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (13))){
var inst_75669 = (state_75691[(2)]);
var state_75691__$1 = (function (){var statearr_75699 = state_75691;
(statearr_75699[(10)] = inst_75669);

return statearr_75699;
})();
if(cljs.core.truth_(roles)){
var statearr_75700_75734 = state_75691__$1;
(statearr_75700_75734[(1)] = (15));

} else {
var statearr_75701_75735 = state_75691__$1;
(statearr_75701_75735[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (22))){
var inst_75681 = (state_75691[(2)]);
var inst_75682 = fluree.db.util.async.throw_err(inst_75681);
var state_75691__$1 = state_75691;
var statearr_75702_75736 = state_75691__$1;
(statearr_75702_75736[(2)] = inst_75682);

(statearr_75702_75736[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (6))){
var inst_75652 = (state_75691[(2)]);
var inst_75653 = fluree.db.util.async.throw_err(inst_75652);
var state_75691__$1 = (function (){var statearr_75703 = state_75691;
(statearr_75703[(7)] = inst_75653);

return statearr_75703;
})();
if(cljs.core.truth_(syncTo)){
var statearr_75704_75737 = state_75691__$1;
(statearr_75704_75737[(1)] = (7));

} else {
var statearr_75705_75738 = state_75691__$1;
(statearr_75705_75738[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (17))){
var inst_75677 = (state_75691[(2)]);
var state_75691__$1 = (function (){var statearr_75706 = state_75691;
(statearr_75706[(8)] = inst_75677);

return statearr_75706;
})();
if(cljs.core.truth_(auth)){
var statearr_75707_75739 = state_75691__$1;
(statearr_75707_75739[(1)] = (19));

} else {
var statearr_75708_75740 = state_75691__$1;
(statearr_75708_75740[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (3))){
var inst_75689 = (state_75691[(2)]);
var state_75691__$1 = state_75691;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75691__$1,inst_75689);
} else {
if((state_val_75692 === (12))){
var inst_75661 = (state_75691[(11)]);
var state_75691__$1 = state_75691;
var statearr_75709_75741 = state_75691__$1;
(statearr_75709_75741[(2)] = inst_75661);

(statearr_75709_75741[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (2))){
var _ = (function (){var statearr_75710 = state_75691;
(statearr_75710[(4)] = cljs.core.cons((5),(state_75691[(4)])));

return statearr_75710;
})();
var inst_75650 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_75691__$1 = state_75691;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75691__$1,(6),inst_75650);
} else {
if((state_val_75692 === (19))){
var inst_75677 = (state_75691[(8)]);
var inst_75679 = fluree.db.api.ledger.add_db_permissions(inst_75677,auth,roles);
var state_75691__$1 = state_75691;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75691__$1,(22),inst_75679);
} else {
if((state_val_75692 === (11))){
var inst_75661 = (state_75691[(11)]);
var inst_75663 = fluree.db.time_travel.as_of_block(inst_75661,block);
var state_75691__$1 = state_75691;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75691__$1,(14),inst_75663);
} else {
if((state_val_75692 === (9))){
var inst_75661 = (state_75691[(2)]);
var state_75691__$1 = (function (){var statearr_75712 = state_75691;
(statearr_75712[(11)] = inst_75661);

return statearr_75712;
})();
if(cljs.core.truth_(block)){
var statearr_75713_75742 = state_75691__$1;
(statearr_75713_75742[(1)] = (11));

} else {
var statearr_75714_75743 = state_75691__$1;
(statearr_75714_75743[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (5))){
var _ = (function (){var statearr_75715 = state_75691;
(statearr_75715[(4)] = cljs.core.rest((state_75691[(4)])));

return statearr_75715;
})();
var state_75691__$1 = state_75691;
var ex75711 = (state_75691__$1[(2)]);
var statearr_75716_75744 = state_75691__$1;
(statearr_75716_75744[(5)] = ex75711);


var statearr_75717_75745 = state_75691__$1;
(statearr_75717_75745[(1)] = (4));

(statearr_75717_75745[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (14))){
var inst_75665 = (state_75691[(2)]);
var inst_75666 = fluree.db.util.async.throw_err(inst_75665);
var state_75691__$1 = state_75691;
var statearr_75718_75746 = state_75691__$1;
(statearr_75718_75746[(2)] = inst_75666);

(statearr_75718_75746[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (16))){
var inst_75669 = (state_75691[(10)]);
var state_75691__$1 = state_75691;
var statearr_75719_75747 = state_75691__$1;
(statearr_75719_75747[(2)] = inst_75669);

(statearr_75719_75747[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (10))){
var inst_75657 = (state_75691[(2)]);
var inst_75658 = fluree.db.util.async.throw_err(inst_75657);
var state_75691__$1 = state_75691;
var statearr_75720_75748 = state_75691__$1;
(statearr_75720_75748[(2)] = inst_75658);

(statearr_75720_75748[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (18))){
var inst_75673 = (state_75691[(2)]);
var inst_75674 = fluree.db.util.async.throw_err(inst_75673);
var state_75691__$1 = state_75691;
var statearr_75721_75749 = state_75691__$1;
(statearr_75721_75749[(2)] = inst_75674);

(statearr_75721_75749[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75692 === (8))){
var inst_75653 = (state_75691[(7)]);
var state_75691__$1 = state_75691;
var statearr_75722_75750 = state_75691__$1;
(statearr_75722_75750[(2)] = inst_75653);

(statearr_75722_75750[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_75723 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75723[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_75723[(1)] = (1));

return statearr_75723;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_75691){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_75691);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e75724){var ex__2730__auto__ = e75724;
var statearr_75725_75751 = state_75691;
(statearr_75725_75751[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_75691[(4)]))){
var statearr_75726_75752 = state_75691;
(statearr_75726_75752[(1)] = cljs.core.first((state_75691[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75753 = state_75691;
state_75691 = G__75753;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_75691){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_75691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_75727 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_75727[(6)] = c__2749__auto___75729);

return statearr_75727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

