// Compiled by ClojureScript 1.11.4 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__6872 = s;
var map__6872__$1 = cljs.core.__destructure_map(map__6872);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6872__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6872__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__6874 = info;
var map__6875 = G__6874;
var map__6875__$1 = cljs.core.__destructure_map(map__6875);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6875__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__6874__$1 = G__6874;
while(true){
var d__$2 = d__$1;
var map__6877 = G__6874__$1;
var map__6877__$1 = cljs.core.__destructure_map(map__6877);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6877__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__6878 = (d__$2 + (1));
var G__6879 = shadow__$1;
d__$1 = G__6878;
G__6874__$1 = G__6879;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__6880){
var map__6881 = p__6880;
var map__6881__$1 = cljs.core.__destructure_map(map__6881);
var name_var = map__6881__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6881__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6881__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__6882 = info;
var map__6882__$1 = cljs.core.__destructure_map(map__6882);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6882__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6882__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__6883 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__6883) : cljs.compiler.munge.call(null,G__6883));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__6885 = arguments.length;
switch (G__6885) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__6886 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11648,11648,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__6886.cljs$core$IFn$_invoke$arity$1 ? fexpr__6886.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__6886.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__6888 = cp;
switch (G__6888) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__6890_6894 = cljs.core.seq(s);
var chunk__6891_6895 = null;
var count__6892_6896 = (0);
var i__6893_6897 = (0);
while(true){
if((i__6893_6897 < count__6892_6896)){
var c_6898 = chunk__6891_6895.cljs$core$IIndexed$_nth$arity$2(null,i__6893_6897);
sb.append(cljs.compiler.escape_char(c_6898));


var G__6899 = seq__6890_6894;
var G__6900 = chunk__6891_6895;
var G__6901 = count__6892_6896;
var G__6902 = (i__6893_6897 + (1));
seq__6890_6894 = G__6899;
chunk__6891_6895 = G__6900;
count__6892_6896 = G__6901;
i__6893_6897 = G__6902;
continue;
} else {
var temp__5753__auto___6903 = cljs.core.seq(seq__6890_6894);
if(temp__5753__auto___6903){
var seq__6890_6904__$1 = temp__5753__auto___6903;
if(cljs.core.chunked_seq_QMARK_(seq__6890_6904__$1)){
var c__4679__auto___6905 = cljs.core.chunk_first(seq__6890_6904__$1);
var G__6906 = cljs.core.chunk_rest(seq__6890_6904__$1);
var G__6907 = c__4679__auto___6905;
var G__6908 = cljs.core.count(c__4679__auto___6905);
var G__6909 = (0);
seq__6890_6894 = G__6906;
chunk__6891_6895 = G__6907;
count__6892_6896 = G__6908;
i__6893_6897 = G__6909;
continue;
} else {
var c_6910 = cljs.core.first(seq__6890_6904__$1);
sb.append(cljs.compiler.escape_char(c_6910));


var G__6911 = cljs.core.next(seq__6890_6904__$1);
var G__6912 = null;
var G__6913 = (0);
var G__6914 = (0);
seq__6890_6894 = G__6911;
chunk__6891_6895 = G__6912;
count__6892_6896 = G__6913;
i__6893_6897 = G__6914;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__6915 = cljs.core.get_global_hierarchy;
return (fexpr__6915.cljs$core$IFn$_invoke$arity$0 ? fexpr__6915.cljs$core$IFn$_invoke$arity$0() : fexpr__6915.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__6916_6921 = ast;
var map__6916_6922__$1 = cljs.core.__destructure_map(map__6916_6921);
var env_6923 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6916_6922__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_6923))){
var map__6917_6924 = env_6923;
var map__6917_6925__$1 = cljs.core.__destructure_map(map__6917_6924);
var line_6926 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6917_6925__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_6927 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6917_6925__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__6918 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__6920 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__6919 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__6919.cljs$core$IFn$_invoke$arity$1 ? fexpr__6919.cljs$core$IFn$_invoke$arity$1(G__6920) : fexpr__6919.call(null,G__6920));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__6918,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__6918;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_6926 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_6927)?(column_6927 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__6936 = arguments.length;
switch (G__6936) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4885__auto__ = [];
var len__4864__auto___6943 = arguments.length;
var i__4865__auto___6944 = (0);
while(true){
if((i__4865__auto___6944 < len__4864__auto___6943)){
args_arr__4885__auto__.push((arguments[i__4865__auto___6944]));

var G__6945 = (i__4865__auto___6944 + (1));
i__4865__auto___6944 = G__6945;
continue;
} else {
}
break;
}

var argseq__4886__auto__ = (new cljs.core.IndexedSeq(args_arr__4885__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4886__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_6946 = (function (){var G__6937 = a;
if((!(typeof a === 'string'))){
return G__6937.toString();
} else {
return G__6937;
}
})();
var temp__5757__auto___6947 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___6947 == null)){
} else {
var sm_data_6948 = temp__5757__auto___6947;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_6948,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__6928_SHARP_){
return (p1__6928_SHARP_ + s_6946.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_6946], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__6938 = cljs.core.seq(xs);
var chunk__6939 = null;
var count__6940 = (0);
var i__6941 = (0);
while(true){
if((i__6941 < count__6940)){
var x = chunk__6939.cljs$core$IIndexed$_nth$arity$2(null,i__6941);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__6949 = seq__6938;
var G__6950 = chunk__6939;
var G__6951 = count__6940;
var G__6952 = (i__6941 + (1));
seq__6938 = G__6949;
chunk__6939 = G__6950;
count__6940 = G__6951;
i__6941 = G__6952;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__6938);
if(temp__5753__auto__){
var seq__6938__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__6938__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__6938__$1);
var G__6953 = cljs.core.chunk_rest(seq__6938__$1);
var G__6954 = c__4679__auto__;
var G__6955 = cljs.core.count(c__4679__auto__);
var G__6956 = (0);
seq__6938 = G__6953;
chunk__6939 = G__6954;
count__6940 = G__6955;
i__6941 = G__6956;
continue;
} else {
var x = cljs.core.first(seq__6938__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__6957 = cljs.core.next(seq__6938__$1);
var G__6958 = null;
var G__6959 = (0);
var G__6960 = (0);
seq__6938 = G__6957;
chunk__6939 = G__6958;
count__6940 = G__6959;
i__6941 = G__6960;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq6930){
var G__6931 = cljs.core.first(seq6930);
var seq6930__$1 = cljs.core.next(seq6930);
var G__6932 = cljs.core.first(seq6930__$1);
var seq6930__$2 = cljs.core.next(seq6930__$1);
var G__6933 = cljs.core.first(seq6930__$2);
var seq6930__$3 = cljs.core.next(seq6930__$2);
var G__6934 = cljs.core.first(seq6930__$3);
var seq6930__$4 = cljs.core.next(seq6930__$3);
var G__6935 = cljs.core.first(seq6930__$4);
var seq6930__$5 = cljs.core.next(seq6930__$4);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6931,G__6932,G__6933,G__6934,G__6935,seq6930__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__6961){
var map__6962 = p__6961;
var map__6962__$1 = cljs.core.__destructure_map(map__6962);
var m = map__6962__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6962__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__6970 = arguments.length;
switch (G__6970) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4885__auto__ = [];
var len__4864__auto___6976 = arguments.length;
var i__4865__auto___6977 = (0);
while(true){
if((i__4865__auto___6977 < len__4864__auto___6976)){
args_arr__4885__auto__.push((arguments[i__4865__auto___6977]));

var G__6978 = (i__4865__auto___6977 + (1));
i__4865__auto___6977 = G__6978;
continue;
} else {
}
break;
}

var argseq__4886__auto__ = (new cljs.core.IndexedSeq(args_arr__4885__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4886__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__6971_6979 = cljs.core.seq(xs);
var chunk__6972_6980 = null;
var count__6973_6981 = (0);
var i__6974_6982 = (0);
while(true){
if((i__6974_6982 < count__6973_6981)){
var x_6983 = chunk__6972_6980.cljs$core$IIndexed$_nth$arity$2(null,i__6974_6982);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_6983);


var G__6984 = seq__6971_6979;
var G__6985 = chunk__6972_6980;
var G__6986 = count__6973_6981;
var G__6987 = (i__6974_6982 + (1));
seq__6971_6979 = G__6984;
chunk__6972_6980 = G__6985;
count__6973_6981 = G__6986;
i__6974_6982 = G__6987;
continue;
} else {
var temp__5753__auto___6988 = cljs.core.seq(seq__6971_6979);
if(temp__5753__auto___6988){
var seq__6971_6989__$1 = temp__5753__auto___6988;
if(cljs.core.chunked_seq_QMARK_(seq__6971_6989__$1)){
var c__4679__auto___6990 = cljs.core.chunk_first(seq__6971_6989__$1);
var G__6991 = cljs.core.chunk_rest(seq__6971_6989__$1);
var G__6992 = c__4679__auto___6990;
var G__6993 = cljs.core.count(c__4679__auto___6990);
var G__6994 = (0);
seq__6971_6979 = G__6991;
chunk__6972_6980 = G__6992;
count__6973_6981 = G__6993;
i__6974_6982 = G__6994;
continue;
} else {
var x_6995 = cljs.core.first(seq__6971_6989__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_6995);


var G__6996 = cljs.core.next(seq__6971_6989__$1);
var G__6997 = null;
var G__6998 = (0);
var G__6999 = (0);
seq__6971_6979 = G__6996;
chunk__6972_6980 = G__6997;
count__6973_6981 = G__6998;
i__6974_6982 = G__6999;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq6964){
var G__6965 = cljs.core.first(seq6964);
var seq6964__$1 = cljs.core.next(seq6964);
var G__6966 = cljs.core.first(seq6964__$1);
var seq6964__$2 = cljs.core.next(seq6964__$1);
var G__6967 = cljs.core.first(seq6964__$2);
var seq6964__$3 = cljs.core.next(seq6964__$2);
var G__6968 = cljs.core.first(seq6964__$3);
var seq6964__$4 = cljs.core.next(seq6964__$3);
var G__6969 = cljs.core.first(seq6964__$4);
var seq6964__$5 = cljs.core.next(seq6964__$4);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6965,G__6966,G__6967,G__6968,G__6969,seq6964__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4795__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__7000_7004 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__7001_7005 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__7002_7006 = true;
var _STAR_print_fn_STAR__temp_val__7003_7007 = (function (x__4796__auto__){
return sb__4795__auto__.append(x__4796__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__7002_7006);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__7003_7007);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__7001_7005);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__7000_7004);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4795__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__7008 = cljs.core.get_global_hierarchy;
return (fexpr__7008.cljs$core$IFn$_invoke$arity$0 ? fexpr__7008.cljs$core$IFn$_invoke$arity$0() : fexpr__7008.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__7009 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7009,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7009,(1),null);
var G__7012 = ns;
var G__7013 = name;
var G__7014 = (function (){
var G__7015 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__7015) : cljs.compiler.emit_constant.call(null,G__7015));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__7012,G__7013,G__7014) : cljs.compiler.emit_record_value.call(null,G__7012,G__7013,G__7014));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__7016 = cljs.core.keys(x);
var G__7017 = cljs.core.vals(x);
var G__7018 = cljs.compiler.emit_constants_comma_sep;
var G__7019 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__7016,G__7017,G__7018,G__7019) : cljs.compiler.emit_map.call(null,G__7016,G__7017,G__7018,G__7019));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__7020 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__7021 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__7020,G__7021) : cljs.compiler.emit_with_meta.call(null,G__7020,G__7021));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__7022 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7022,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7022,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7022,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4251__auto__)){
var G__7025 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__7025) : x.call(null,G__7025));
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4251__auto__)){
var G__7026 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__7026) : x.call(null,G__7026));
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__7028 = items;
var G__7029 = (function (p1__7027_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__7027_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__7028,G__7029) : cljs.compiler.emit_js_object.call(null,G__7028,G__7029));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__7031){
var map__7032 = p__7031;
var map__7032__$1 = cljs.core.__destructure_map(map__7032);
var ast = map__7032__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7032__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7032__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7032__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5751__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__7033 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__7033__$1 = cljs.core.__destructure_map(map__7033);
var cenv = map__7033__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7033__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4253__auto__ = js_module_name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__7034 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4251__auto__ = (function (){var G__7035 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__7035) : cljs.compiler.es5_GT__EQ_.call(null,G__7035));
})();
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4251__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__7034,cljs.analyzer.es5_allowed);
} else {
return G__7034;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4253__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__7036 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__7036,reserved);
} else {
return G__7036;
}
})();
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__7037_7038 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__7037_7039__$1 = (((G__7037_7038 instanceof cljs.core.Keyword))?G__7037_7038.fqn:null);
switch (G__7037_7039__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4251__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__7041){
var map__7042 = p__7041;
var map__7042__$1 = cljs.core.__destructure_map(map__7042);
var arg = map__7042__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7042__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7042__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7042__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7042__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__7043 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__7043__$1 = cljs.core.__destructure_map(map__7043);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7043__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__7044){
var map__7045 = p__7044;
var map__7045__$1 = cljs.core.__destructure_map(map__7045);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7045__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7045__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7045__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__7046_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__7046_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__7047 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__7047) : comma_sep.call(null,G__7047));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__7048 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__7048) : comma_sep.call(null,G__7048));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__7049){
var map__7050 = p__7049;
var map__7050__$1 = cljs.core.__destructure_map(map__7050);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7050__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7050__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7050__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__7051){
var map__7052 = p__7051;
var map__7052__$1 = cljs.core.__destructure_map(map__7052);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7052__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7052__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__7053_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__7053_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__7054 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__7054) : comma_sep.call(null,G__7054));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__7055){
var map__7056 = p__7055;
var map__7056__$1 = cljs.core.__destructure_map(map__7056);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7056__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7056__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5753__auto___7079 = cljs.core.seq(items);
if(temp__5753__auto___7079){
var items_7080__$1 = temp__5753__auto___7079;
var vec__7057_7081 = items_7080__$1;
var seq__7058_7082 = cljs.core.seq(vec__7057_7081);
var first__7059_7083 = cljs.core.first(seq__7058_7082);
var seq__7058_7084__$1 = cljs.core.next(seq__7058_7082);
var vec__7060_7085 = first__7059_7083;
var k_7086 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7060_7085,(0),null);
var v_7087 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7060_7085,(1),null);
var r_7088 = seq__7058_7084__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_7086),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_7087) : emit_js_object_val.call(null,v_7087)));

var seq__7063_7089 = cljs.core.seq(r_7088);
var chunk__7064_7090 = null;
var count__7065_7091 = (0);
var i__7066_7092 = (0);
while(true){
if((i__7066_7092 < count__7065_7091)){
var vec__7073_7093 = chunk__7064_7090.cljs$core$IIndexed$_nth$arity$2(null,i__7066_7092);
var k_7094__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7073_7093,(0),null);
var v_7095__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7073_7093,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_7094__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_7095__$1) : emit_js_object_val.call(null,v_7095__$1)));


var G__7096 = seq__7063_7089;
var G__7097 = chunk__7064_7090;
var G__7098 = count__7065_7091;
var G__7099 = (i__7066_7092 + (1));
seq__7063_7089 = G__7096;
chunk__7064_7090 = G__7097;
count__7065_7091 = G__7098;
i__7066_7092 = G__7099;
continue;
} else {
var temp__5753__auto___7100__$1 = cljs.core.seq(seq__7063_7089);
if(temp__5753__auto___7100__$1){
var seq__7063_7101__$1 = temp__5753__auto___7100__$1;
if(cljs.core.chunked_seq_QMARK_(seq__7063_7101__$1)){
var c__4679__auto___7102 = cljs.core.chunk_first(seq__7063_7101__$1);
var G__7103 = cljs.core.chunk_rest(seq__7063_7101__$1);
var G__7104 = c__4679__auto___7102;
var G__7105 = cljs.core.count(c__4679__auto___7102);
var G__7106 = (0);
seq__7063_7089 = G__7103;
chunk__7064_7090 = G__7104;
count__7065_7091 = G__7105;
i__7066_7092 = G__7106;
continue;
} else {
var vec__7076_7107 = cljs.core.first(seq__7063_7101__$1);
var k_7108__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7076_7107,(0),null);
var v_7109__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7076_7107,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_7108__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_7109__$1) : emit_js_object_val.call(null,v_7109__$1)));


var G__7110 = cljs.core.next(seq__7063_7101__$1);
var G__7111 = null;
var G__7112 = (0);
var G__7113 = (0);
seq__7063_7089 = G__7110;
chunk__7064_7090 = G__7111;
count__7065_7091 = G__7112;
i__7066_7092 = G__7113;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__7114){
var map__7115 = p__7114;
var map__7115__$1 = cljs.core.__destructure_map(map__7115);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7115__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7115__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7115__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__7116){
var map__7117 = p__7116;
var map__7117__$1 = cljs.core.__destructure_map(map__7117);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7117__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7117__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__7118){
var map__7119 = p__7118;
var map__7119__$1 = cljs.core.__destructure_map(map__7119);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7119__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__7120){
var map__7121 = p__7120;
var map__7121__$1 = cljs.core.__destructure_map(map__7121);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7121__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7121__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__7122 = cljs.analyzer.unwrap_quote(expr);
var map__7122__$1 = cljs.core.__destructure_map(map__7122);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7122__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7122__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7122__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4253__auto__ = (function (){var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__4251__auto__){
var and__4251__auto____$1 = form;
if(cljs.core.truth_(and__4251__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto__ = (!((const_expr == null)));
if(and__4251__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__4251__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__7123 = cljs.analyzer.unwrap_quote(expr);
var map__7123__$1 = cljs.core.__destructure_map(map__7123);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7123__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7123__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7123__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4253__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4253__auto__){
return or__4253__auto__;
} else {
var and__4251__auto__ = (!((const_expr == null)));
if(and__4251__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__4251__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4253__auto__ = (function (){var fexpr__7124 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__7124.cljs$core$IFn$_invoke$arity$1 ? fexpr__7124.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__7124.call(null,tag));
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__7125){
var map__7126 = p__7125;
var map__7126__$1 = cljs.core.__destructure_map(map__7126);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7126__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7126__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7126__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7126__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7126__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4253__auto__ = unchecked;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__7127){
var map__7128 = p__7127;
var map__7128__$1 = cljs.core.__destructure_map(map__7128);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7128__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7128__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7128__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7128__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__7129_7157 = cljs.core.seq(nodes);
var chunk__7130_7158 = null;
var count__7131_7159 = (0);
var i__7132_7160 = (0);
while(true){
if((i__7132_7160 < count__7131_7159)){
var map__7145_7161 = chunk__7130_7158.cljs$core$IIndexed$_nth$arity$2(null,i__7132_7160);
var map__7145_7162__$1 = cljs.core.__destructure_map(map__7145_7161);
var ts_7163 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7145_7162__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__7146_7164 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7145_7162__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__7146_7165__$1 = cljs.core.__destructure_map(map__7146_7164);
var then_7166 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7146_7165__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__7147_7167 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_7163));
var chunk__7148_7168 = null;
var count__7149_7169 = (0);
var i__7150_7170 = (0);
while(true){
if((i__7150_7170 < count__7149_7169)){
var test_7171 = chunk__7148_7168.cljs$core$IIndexed$_nth$arity$2(null,i__7150_7170);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7171,":");


var G__7172 = seq__7147_7167;
var G__7173 = chunk__7148_7168;
var G__7174 = count__7149_7169;
var G__7175 = (i__7150_7170 + (1));
seq__7147_7167 = G__7172;
chunk__7148_7168 = G__7173;
count__7149_7169 = G__7174;
i__7150_7170 = G__7175;
continue;
} else {
var temp__5753__auto___7176 = cljs.core.seq(seq__7147_7167);
if(temp__5753__auto___7176){
var seq__7147_7177__$1 = temp__5753__auto___7176;
if(cljs.core.chunked_seq_QMARK_(seq__7147_7177__$1)){
var c__4679__auto___7178 = cljs.core.chunk_first(seq__7147_7177__$1);
var G__7179 = cljs.core.chunk_rest(seq__7147_7177__$1);
var G__7180 = c__4679__auto___7178;
var G__7181 = cljs.core.count(c__4679__auto___7178);
var G__7182 = (0);
seq__7147_7167 = G__7179;
chunk__7148_7168 = G__7180;
count__7149_7169 = G__7181;
i__7150_7170 = G__7182;
continue;
} else {
var test_7183 = cljs.core.first(seq__7147_7177__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7183,":");


var G__7184 = cljs.core.next(seq__7147_7177__$1);
var G__7185 = null;
var G__7186 = (0);
var G__7187 = (0);
seq__7147_7167 = G__7184;
chunk__7148_7168 = G__7185;
count__7149_7169 = G__7186;
i__7150_7170 = G__7187;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_7166);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_7166);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__7188 = seq__7129_7157;
var G__7189 = chunk__7130_7158;
var G__7190 = count__7131_7159;
var G__7191 = (i__7132_7160 + (1));
seq__7129_7157 = G__7188;
chunk__7130_7158 = G__7189;
count__7131_7159 = G__7190;
i__7132_7160 = G__7191;
continue;
} else {
var temp__5753__auto___7192 = cljs.core.seq(seq__7129_7157);
if(temp__5753__auto___7192){
var seq__7129_7193__$1 = temp__5753__auto___7192;
if(cljs.core.chunked_seq_QMARK_(seq__7129_7193__$1)){
var c__4679__auto___7194 = cljs.core.chunk_first(seq__7129_7193__$1);
var G__7195 = cljs.core.chunk_rest(seq__7129_7193__$1);
var G__7196 = c__4679__auto___7194;
var G__7197 = cljs.core.count(c__4679__auto___7194);
var G__7198 = (0);
seq__7129_7157 = G__7195;
chunk__7130_7158 = G__7196;
count__7131_7159 = G__7197;
i__7132_7160 = G__7198;
continue;
} else {
var map__7151_7199 = cljs.core.first(seq__7129_7193__$1);
var map__7151_7200__$1 = cljs.core.__destructure_map(map__7151_7199);
var ts_7201 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7151_7200__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__7152_7202 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7151_7200__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__7152_7203__$1 = cljs.core.__destructure_map(map__7152_7202);
var then_7204 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7152_7203__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__7153_7205 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_7201));
var chunk__7154_7206 = null;
var count__7155_7207 = (0);
var i__7156_7208 = (0);
while(true){
if((i__7156_7208 < count__7155_7207)){
var test_7209 = chunk__7154_7206.cljs$core$IIndexed$_nth$arity$2(null,i__7156_7208);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7209,":");


var G__7210 = seq__7153_7205;
var G__7211 = chunk__7154_7206;
var G__7212 = count__7155_7207;
var G__7213 = (i__7156_7208 + (1));
seq__7153_7205 = G__7210;
chunk__7154_7206 = G__7211;
count__7155_7207 = G__7212;
i__7156_7208 = G__7213;
continue;
} else {
var temp__5753__auto___7214__$1 = cljs.core.seq(seq__7153_7205);
if(temp__5753__auto___7214__$1){
var seq__7153_7215__$1 = temp__5753__auto___7214__$1;
if(cljs.core.chunked_seq_QMARK_(seq__7153_7215__$1)){
var c__4679__auto___7216 = cljs.core.chunk_first(seq__7153_7215__$1);
var G__7217 = cljs.core.chunk_rest(seq__7153_7215__$1);
var G__7218 = c__4679__auto___7216;
var G__7219 = cljs.core.count(c__4679__auto___7216);
var G__7220 = (0);
seq__7153_7205 = G__7217;
chunk__7154_7206 = G__7218;
count__7155_7207 = G__7219;
i__7156_7208 = G__7220;
continue;
} else {
var test_7221 = cljs.core.first(seq__7153_7215__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7221,":");


var G__7222 = cljs.core.next(seq__7153_7215__$1);
var G__7223 = null;
var G__7224 = (0);
var G__7225 = (0);
seq__7153_7205 = G__7222;
chunk__7154_7206 = G__7223;
count__7155_7207 = G__7224;
i__7156_7208 = G__7225;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_7204);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_7204);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__7226 = cljs.core.next(seq__7129_7193__$1);
var G__7227 = null;
var G__7228 = (0);
var G__7229 = (0);
seq__7129_7157 = G__7226;
chunk__7130_7158 = G__7227;
count__7131_7159 = G__7228;
i__7132_7160 = G__7229;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__7230){
var map__7231 = p__7230;
var map__7231__$1 = cljs.core.__destructure_map(map__7231);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7231__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7231__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__7235 = env;
var G__7236 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__7235,G__7236) : cljs.compiler.resolve_type.call(null,G__7235,G__7236));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__7237 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7237,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7237,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__7232_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__7232_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__7232_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__7240 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__7240,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__7240;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__7243 = env;
var G__7244 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__7243,G__7244) : cljs.compiler.resolve_type.call(null,G__7243,G__7244));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7245_SHARP_){
return cljs.compiler.resolve_type(env,p1__7245_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__7246 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__7247 = cljs.core.seq(vec__7246);
var first__7248 = cljs.core.first(seq__7247);
var seq__7247__$1 = cljs.core.next(seq__7247);
var p = first__7248;
var first__7248__$1 = cljs.core.first(seq__7247__$1);
var seq__7247__$2 = cljs.core.next(seq__7247__$1);
var ts = first__7248__$1;
var first__7248__$2 = cljs.core.first(seq__7247__$2);
var seq__7247__$3 = cljs.core.next(seq__7247__$2);
var n = first__7248__$2;
var xs = seq__7247__$3;
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__4251__auto__){
var and__4251__auto____$1 = ts;
if(cljs.core.truth_(and__4251__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__7249 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__7250 = cljs.core.seq(vec__7249);
var first__7251 = cljs.core.first(seq__7250);
var seq__7250__$1 = cljs.core.next(seq__7250);
var p = first__7251;
var first__7251__$1 = cljs.core.first(seq__7250__$1);
var seq__7250__$2 = cljs.core.next(seq__7250__$1);
var ts = first__7251__$1;
var xs = seq__7250__$2;
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__4251__auto__){
var and__4251__auto____$1 = ts;
if(cljs.core.truth_(and__4251__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__7253 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__7252 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__7252.cljs$core$IFn$_invoke$arity$1 ? fexpr__7252.cljs$core$IFn$_invoke$arity$1(G__7253) : fexpr__7252.call(null,G__7253));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__7256 = arguments.length;
switch (G__7256) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__7264 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7254_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__7254_SHARP_);
} else {
return p1__7254_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__7265 = cljs.core.seq(vec__7264);
var first__7266 = cljs.core.first(seq__7265);
var seq__7265__$1 = cljs.core.next(seq__7265);
var x = first__7266;
var ys = seq__7265__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__7267 = cljs.core.seq(ys);
var chunk__7268 = null;
var count__7269 = (0);
var i__7270 = (0);
while(true){
if((i__7270 < count__7269)){
var next_line = chunk__7268.cljs$core$IIndexed$_nth$arity$2(null,i__7270);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__7276 = seq__7267;
var G__7277 = chunk__7268;
var G__7278 = count__7269;
var G__7279 = (i__7270 + (1));
seq__7267 = G__7276;
chunk__7268 = G__7277;
count__7269 = G__7278;
i__7270 = G__7279;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__7267);
if(temp__5753__auto__){
var seq__7267__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7267__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__7267__$1);
var G__7280 = cljs.core.chunk_rest(seq__7267__$1);
var G__7281 = c__4679__auto__;
var G__7282 = cljs.core.count(c__4679__auto__);
var G__7283 = (0);
seq__7267 = G__7280;
chunk__7268 = G__7281;
count__7269 = G__7282;
i__7270 = G__7283;
continue;
} else {
var next_line = cljs.core.first(seq__7267__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__7284 = cljs.core.next(seq__7267__$1);
var G__7285 = null;
var G__7286 = (0);
var G__7287 = (0);
seq__7267 = G__7284;
chunk__7268 = G__7285;
count__7269 = G__7286;
i__7270 = G__7287;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__7271_7288 = cljs.core.seq(docs__$2);
var chunk__7272_7289 = null;
var count__7273_7290 = (0);
var i__7274_7291 = (0);
while(true){
if((i__7274_7291 < count__7273_7290)){
var e_7292 = chunk__7272_7289.cljs$core$IIndexed$_nth$arity$2(null,i__7274_7291);
if(cljs.core.truth_(e_7292)){
print_comment_lines(e_7292);
} else {
}


var G__7293 = seq__7271_7288;
var G__7294 = chunk__7272_7289;
var G__7295 = count__7273_7290;
var G__7296 = (i__7274_7291 + (1));
seq__7271_7288 = G__7293;
chunk__7272_7289 = G__7294;
count__7273_7290 = G__7295;
i__7274_7291 = G__7296;
continue;
} else {
var temp__5753__auto___7297 = cljs.core.seq(seq__7271_7288);
if(temp__5753__auto___7297){
var seq__7271_7298__$1 = temp__5753__auto___7297;
if(cljs.core.chunked_seq_QMARK_(seq__7271_7298__$1)){
var c__4679__auto___7299 = cljs.core.chunk_first(seq__7271_7298__$1);
var G__7300 = cljs.core.chunk_rest(seq__7271_7298__$1);
var G__7301 = c__4679__auto___7299;
var G__7302 = cljs.core.count(c__4679__auto___7299);
var G__7303 = (0);
seq__7271_7288 = G__7300;
chunk__7272_7289 = G__7301;
count__7273_7290 = G__7302;
i__7274_7291 = G__7303;
continue;
} else {
var e_7304 = cljs.core.first(seq__7271_7298__$1);
if(cljs.core.truth_(e_7304)){
print_comment_lines(e_7304);
} else {
}


var G__7305 = cljs.core.next(seq__7271_7298__$1);
var G__7306 = null;
var G__7307 = (0);
var G__7308 = (0);
seq__7271_7288 = G__7305;
chunk__7272_7289 = G__7306;
count__7273_7290 = G__7307;
i__7274_7291 = G__7308;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4251__auto__ = cljs.core.some((function (p1__7310_SHARP_){
return goog.string.startsWith(p1__7310_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = opts;
if(cljs.core.truth_(and__4251__auto____$1)){
var and__4251__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__4251__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__4251__auto____$2;
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__7311){
var map__7312 = p__7311;
var map__7312__$1 = cljs.core.__destructure_map(map__7312);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7312__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7312__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7312__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7312__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7312__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7312__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7312__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7312__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7312__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7312__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4253__auto__ = init;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
return test;
} else {
return and__4251__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__7313){
var map__7314 = p__7313;
var map__7314__$1 = cljs.core.__destructure_map(map__7314);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7314__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7314__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7314__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__7315_7339 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__7316_7340 = null;
var count__7317_7341 = (0);
var i__7318_7342 = (0);
while(true){
if((i__7318_7342 < count__7317_7341)){
var vec__7325_7343 = chunk__7316_7340.cljs$core$IIndexed$_nth$arity$2(null,i__7318_7342);
var i_7344 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7325_7343,(0),null);
var param_7345 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7325_7343,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_7345);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__7346 = seq__7315_7339;
var G__7347 = chunk__7316_7340;
var G__7348 = count__7317_7341;
var G__7349 = (i__7318_7342 + (1));
seq__7315_7339 = G__7346;
chunk__7316_7340 = G__7347;
count__7317_7341 = G__7348;
i__7318_7342 = G__7349;
continue;
} else {
var temp__5753__auto___7350 = cljs.core.seq(seq__7315_7339);
if(temp__5753__auto___7350){
var seq__7315_7351__$1 = temp__5753__auto___7350;
if(cljs.core.chunked_seq_QMARK_(seq__7315_7351__$1)){
var c__4679__auto___7352 = cljs.core.chunk_first(seq__7315_7351__$1);
var G__7353 = cljs.core.chunk_rest(seq__7315_7351__$1);
var G__7354 = c__4679__auto___7352;
var G__7355 = cljs.core.count(c__4679__auto___7352);
var G__7356 = (0);
seq__7315_7339 = G__7353;
chunk__7316_7340 = G__7354;
count__7317_7341 = G__7355;
i__7318_7342 = G__7356;
continue;
} else {
var vec__7328_7357 = cljs.core.first(seq__7315_7351__$1);
var i_7358 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7328_7357,(0),null);
var param_7359 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7328_7357,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_7359);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__7360 = cljs.core.next(seq__7315_7351__$1);
var G__7361 = null;
var G__7362 = (0);
var G__7363 = (0);
seq__7315_7339 = G__7360;
chunk__7316_7340 = G__7361;
count__7317_7341 = G__7362;
i__7318_7342 = G__7363;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__7331_7364 = cljs.core.seq(params);
var chunk__7332_7365 = null;
var count__7333_7366 = (0);
var i__7334_7367 = (0);
while(true){
if((i__7334_7367 < count__7333_7366)){
var param_7368 = chunk__7332_7365.cljs$core$IIndexed$_nth$arity$2(null,i__7334_7367);
cljs.compiler.emit(param_7368);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7368,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7369 = seq__7331_7364;
var G__7370 = chunk__7332_7365;
var G__7371 = count__7333_7366;
var G__7372 = (i__7334_7367 + (1));
seq__7331_7364 = G__7369;
chunk__7332_7365 = G__7370;
count__7333_7366 = G__7371;
i__7334_7367 = G__7372;
continue;
} else {
var temp__5753__auto___7373 = cljs.core.seq(seq__7331_7364);
if(temp__5753__auto___7373){
var seq__7331_7374__$1 = temp__5753__auto___7373;
if(cljs.core.chunked_seq_QMARK_(seq__7331_7374__$1)){
var c__4679__auto___7375 = cljs.core.chunk_first(seq__7331_7374__$1);
var G__7376 = cljs.core.chunk_rest(seq__7331_7374__$1);
var G__7377 = c__4679__auto___7375;
var G__7378 = cljs.core.count(c__4679__auto___7375);
var G__7379 = (0);
seq__7331_7364 = G__7376;
chunk__7332_7365 = G__7377;
count__7333_7366 = G__7378;
i__7334_7367 = G__7379;
continue;
} else {
var param_7380 = cljs.core.first(seq__7331_7374__$1);
cljs.compiler.emit(param_7380);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7380,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7381 = cljs.core.next(seq__7331_7374__$1);
var G__7382 = null;
var G__7383 = (0);
var G__7384 = (0);
seq__7331_7364 = G__7381;
chunk__7332_7365 = G__7382;
count__7333_7366 = G__7383;
i__7334_7367 = G__7384;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__7335_7385 = cljs.core.seq(params);
var chunk__7336_7386 = null;
var count__7337_7387 = (0);
var i__7338_7388 = (0);
while(true){
if((i__7338_7388 < count__7337_7387)){
var param_7389 = chunk__7336_7386.cljs$core$IIndexed$_nth$arity$2(null,i__7338_7388);
cljs.compiler.emit(param_7389);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7389,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7390 = seq__7335_7385;
var G__7391 = chunk__7336_7386;
var G__7392 = count__7337_7387;
var G__7393 = (i__7338_7388 + (1));
seq__7335_7385 = G__7390;
chunk__7336_7386 = G__7391;
count__7337_7387 = G__7392;
i__7338_7388 = G__7393;
continue;
} else {
var temp__5753__auto___7394 = cljs.core.seq(seq__7335_7385);
if(temp__5753__auto___7394){
var seq__7335_7395__$1 = temp__5753__auto___7394;
if(cljs.core.chunked_seq_QMARK_(seq__7335_7395__$1)){
var c__4679__auto___7396 = cljs.core.chunk_first(seq__7335_7395__$1);
var G__7397 = cljs.core.chunk_rest(seq__7335_7395__$1);
var G__7398 = c__4679__auto___7396;
var G__7399 = cljs.core.count(c__4679__auto___7396);
var G__7400 = (0);
seq__7335_7385 = G__7397;
chunk__7336_7386 = G__7398;
count__7337_7387 = G__7399;
i__7338_7388 = G__7400;
continue;
} else {
var param_7401 = cljs.core.first(seq__7335_7395__$1);
cljs.compiler.emit(param_7401);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7401,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7402 = cljs.core.next(seq__7335_7395__$1);
var G__7403 = null;
var G__7404 = (0);
var G__7405 = (0);
seq__7335_7385 = G__7402;
chunk__7336_7386 = G__7403;
count__7337_7387 = G__7404;
i__7338_7388 = G__7405;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__7406 = cljs.core.seq(params);
var chunk__7407 = null;
var count__7408 = (0);
var i__7409 = (0);
while(true){
if((i__7409 < count__7408)){
var param = chunk__7407.cljs$core$IIndexed$_nth$arity$2(null,i__7409);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7410 = seq__7406;
var G__7411 = chunk__7407;
var G__7412 = count__7408;
var G__7413 = (i__7409 + (1));
seq__7406 = G__7410;
chunk__7407 = G__7411;
count__7408 = G__7412;
i__7409 = G__7413;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__7406);
if(temp__5753__auto__){
var seq__7406__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7406__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__7406__$1);
var G__7414 = cljs.core.chunk_rest(seq__7406__$1);
var G__7415 = c__4679__auto__;
var G__7416 = cljs.core.count(c__4679__auto__);
var G__7417 = (0);
seq__7406 = G__7414;
chunk__7407 = G__7415;
count__7408 = G__7416;
i__7409 = G__7417;
continue;
} else {
var param = cljs.core.first(seq__7406__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7418 = cljs.core.next(seq__7406__$1);
var G__7419 = null;
var G__7420 = (0);
var G__7421 = (0);
seq__7406 = G__7418;
chunk__7407 = G__7419;
count__7408 = G__7420;
i__7409 = G__7421;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__7422){
var map__7423 = p__7422;
var map__7423__$1 = cljs.core.__destructure_map(map__7423);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7423__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7423__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7423__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7423__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7423__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7423__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__7424){
var map__7425 = p__7424;
var map__7425__$1 = cljs.core.__destructure_map(map__7425);
var f = map__7425__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7425__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7425__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7425__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7425__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7425__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7425__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7425__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7425__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_7434__$1 = (function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_7435 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_7434__$1);
var delegate_name_7436 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7435),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_7436," = function (");

var seq__7426_7437 = cljs.core.seq(params);
var chunk__7427_7438 = null;
var count__7428_7439 = (0);
var i__7429_7440 = (0);
while(true){
if((i__7429_7440 < count__7428_7439)){
var param_7441 = chunk__7427_7438.cljs$core$IIndexed$_nth$arity$2(null,i__7429_7440);
cljs.compiler.emit(param_7441);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7441,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7442 = seq__7426_7437;
var G__7443 = chunk__7427_7438;
var G__7444 = count__7428_7439;
var G__7445 = (i__7429_7440 + (1));
seq__7426_7437 = G__7442;
chunk__7427_7438 = G__7443;
count__7428_7439 = G__7444;
i__7429_7440 = G__7445;
continue;
} else {
var temp__5753__auto___7446 = cljs.core.seq(seq__7426_7437);
if(temp__5753__auto___7446){
var seq__7426_7447__$1 = temp__5753__auto___7446;
if(cljs.core.chunked_seq_QMARK_(seq__7426_7447__$1)){
var c__4679__auto___7448 = cljs.core.chunk_first(seq__7426_7447__$1);
var G__7449 = cljs.core.chunk_rest(seq__7426_7447__$1);
var G__7450 = c__4679__auto___7448;
var G__7451 = cljs.core.count(c__4679__auto___7448);
var G__7452 = (0);
seq__7426_7437 = G__7449;
chunk__7427_7438 = G__7450;
count__7428_7439 = G__7451;
i__7429_7440 = G__7452;
continue;
} else {
var param_7453 = cljs.core.first(seq__7426_7447__$1);
cljs.compiler.emit(param_7453);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7453,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7454 = cljs.core.next(seq__7426_7447__$1);
var G__7455 = null;
var G__7456 = (0);
var G__7457 = (0);
seq__7426_7437 = G__7454;
chunk__7427_7438 = G__7455;
count__7428_7439 = G__7456;
i__7429_7440 = G__7457;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_7435," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_7458 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_7458,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_7436,".call(this,");

var seq__7430_7459 = cljs.core.seq(params);
var chunk__7431_7460 = null;
var count__7432_7461 = (0);
var i__7433_7462 = (0);
while(true){
if((i__7433_7462 < count__7432_7461)){
var param_7463 = chunk__7431_7460.cljs$core$IIndexed$_nth$arity$2(null,i__7433_7462);
cljs.compiler.emit(param_7463);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7463,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7464 = seq__7430_7459;
var G__7465 = chunk__7431_7460;
var G__7466 = count__7432_7461;
var G__7467 = (i__7433_7462 + (1));
seq__7430_7459 = G__7464;
chunk__7431_7460 = G__7465;
count__7432_7461 = G__7466;
i__7433_7462 = G__7467;
continue;
} else {
var temp__5753__auto___7468 = cljs.core.seq(seq__7430_7459);
if(temp__5753__auto___7468){
var seq__7430_7469__$1 = temp__5753__auto___7468;
if(cljs.core.chunked_seq_QMARK_(seq__7430_7469__$1)){
var c__4679__auto___7470 = cljs.core.chunk_first(seq__7430_7469__$1);
var G__7471 = cljs.core.chunk_rest(seq__7430_7469__$1);
var G__7472 = c__4679__auto___7470;
var G__7473 = cljs.core.count(c__4679__auto___7470);
var G__7474 = (0);
seq__7430_7459 = G__7471;
chunk__7431_7460 = G__7472;
count__7432_7461 = G__7473;
i__7433_7462 = G__7474;
continue;
} else {
var param_7475 = cljs.core.first(seq__7430_7469__$1);
cljs.compiler.emit(param_7475);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7475,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7476 = cljs.core.next(seq__7430_7469__$1);
var G__7477 = null;
var G__7478 = (0);
var G__7479 = (0);
seq__7430_7459 = G__7476;
chunk__7431_7460 = G__7477;
count__7432_7461 = G__7478;
i__7433_7462 = G__7479;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7435,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_7435,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_7434__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7435,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_7436,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_7435,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__7483){
var map__7484 = p__7483;
var map__7484__$1 = cljs.core.__destructure_map(map__7484);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7484__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7484__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7484__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7484__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7484__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7484__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7484__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7484__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__7480_SHARP_){
var and__4251__auto__ = p1__7480_SHARP_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__7480_SHARP_));
} else {
return and__4251__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4253__auto__ = in_loop;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_7536__$1 = (function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_7537 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_7536__$1);
var maxparams_7538 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_7539 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7537),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_7540 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__7481_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__7481_SHARP_)));
}),cljs.core.seq(mmap_7539));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_7537," = null;");

var seq__7485_7541 = cljs.core.seq(ms_7540);
var chunk__7486_7542 = null;
var count__7487_7543 = (0);
var i__7488_7544 = (0);
while(true){
if((i__7488_7544 < count__7487_7543)){
var vec__7495_7545 = chunk__7486_7542.cljs$core$IIndexed$_nth$arity$2(null,i__7488_7544);
var n_7546 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7495_7545,(0),null);
var meth_7547 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7495_7545,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_7546," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7547))){
cljs.compiler.emit_variadic_fn_method(meth_7547);
} else {
cljs.compiler.emit_fn_method(meth_7547);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__7548 = seq__7485_7541;
var G__7549 = chunk__7486_7542;
var G__7550 = count__7487_7543;
var G__7551 = (i__7488_7544 + (1));
seq__7485_7541 = G__7548;
chunk__7486_7542 = G__7549;
count__7487_7543 = G__7550;
i__7488_7544 = G__7551;
continue;
} else {
var temp__5753__auto___7552 = cljs.core.seq(seq__7485_7541);
if(temp__5753__auto___7552){
var seq__7485_7553__$1 = temp__5753__auto___7552;
if(cljs.core.chunked_seq_QMARK_(seq__7485_7553__$1)){
var c__4679__auto___7554 = cljs.core.chunk_first(seq__7485_7553__$1);
var G__7555 = cljs.core.chunk_rest(seq__7485_7553__$1);
var G__7556 = c__4679__auto___7554;
var G__7557 = cljs.core.count(c__4679__auto___7554);
var G__7558 = (0);
seq__7485_7541 = G__7555;
chunk__7486_7542 = G__7556;
count__7487_7543 = G__7557;
i__7488_7544 = G__7558;
continue;
} else {
var vec__7498_7559 = cljs.core.first(seq__7485_7553__$1);
var n_7560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7498_7559,(0),null);
var meth_7561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7498_7559,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_7560," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7561))){
cljs.compiler.emit_variadic_fn_method(meth_7561);
} else {
cljs.compiler.emit_fn_method(meth_7561);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__7562 = cljs.core.next(seq__7485_7553__$1);
var G__7563 = null;
var G__7564 = (0);
var G__7565 = (0);
seq__7485_7541 = G__7562;
chunk__7486_7542 = G__7563;
count__7487_7543 = G__7564;
i__7488_7544 = G__7565;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7537," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_7538),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_7538)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_7538));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__7501_7566 = cljs.core.seq(ms_7540);
var chunk__7502_7567 = null;
var count__7503_7568 = (0);
var i__7504_7569 = (0);
while(true){
if((i__7504_7569 < count__7503_7568)){
var vec__7511_7570 = chunk__7502_7567.cljs$core$IIndexed$_nth$arity$2(null,i__7504_7569);
var n_7571 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7511_7570,(0),null);
var meth_7572 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7511_7570,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7572))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_7573 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_7573," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_7574 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_7573," = new cljs.core.IndexedSeq(",a_7574,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_7571,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_7538)),(((cljs.core.count(maxparams_7538) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_7573,");"], 0));
} else {
var pcnt_7575 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7572));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_7575,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_7571,".call(this",(((pcnt_7575 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_7575,maxparams_7538)),null,(1),null)),(2),null))),");");
}


var G__7576 = seq__7501_7566;
var G__7577 = chunk__7502_7567;
var G__7578 = count__7503_7568;
var G__7579 = (i__7504_7569 + (1));
seq__7501_7566 = G__7576;
chunk__7502_7567 = G__7577;
count__7503_7568 = G__7578;
i__7504_7569 = G__7579;
continue;
} else {
var temp__5753__auto___7580 = cljs.core.seq(seq__7501_7566);
if(temp__5753__auto___7580){
var seq__7501_7581__$1 = temp__5753__auto___7580;
if(cljs.core.chunked_seq_QMARK_(seq__7501_7581__$1)){
var c__4679__auto___7582 = cljs.core.chunk_first(seq__7501_7581__$1);
var G__7583 = cljs.core.chunk_rest(seq__7501_7581__$1);
var G__7584 = c__4679__auto___7582;
var G__7585 = cljs.core.count(c__4679__auto___7582);
var G__7586 = (0);
seq__7501_7566 = G__7583;
chunk__7502_7567 = G__7584;
count__7503_7568 = G__7585;
i__7504_7569 = G__7586;
continue;
} else {
var vec__7514_7587 = cljs.core.first(seq__7501_7581__$1);
var n_7588 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7514_7587,(0),null);
var meth_7589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7514_7587,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7589))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_7590 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_7590," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_7591 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_7590," = new cljs.core.IndexedSeq(",a_7591,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_7588,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_7538)),(((cljs.core.count(maxparams_7538) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_7590,");"], 0));
} else {
var pcnt_7592 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7589));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_7592,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_7588,".call(this",(((pcnt_7592 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_7592,maxparams_7538)),null,(1),null)),(2),null))),");");
}


var G__7593 = cljs.core.next(seq__7501_7581__$1);
var G__7594 = null;
var G__7595 = (0);
var G__7596 = (0);
seq__7501_7566 = G__7593;
chunk__7502_7567 = G__7594;
count__7503_7568 = G__7595;
i__7504_7569 = G__7596;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_7597 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_7540)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_7597,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7537,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7537,".cljs$lang$applyTo = ",cljs.core.some((function (p1__7482_SHARP_){
var vec__7517 = p1__7482_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7517,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7517,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_7540),".cljs$lang$applyTo;");
} else {
}

var seq__7520_7598 = cljs.core.seq(ms_7540);
var chunk__7521_7599 = null;
var count__7522_7600 = (0);
var i__7523_7601 = (0);
while(true){
if((i__7523_7601 < count__7522_7600)){
var vec__7530_7602 = chunk__7521_7599.cljs$core$IIndexed$_nth$arity$2(null,i__7523_7601);
var n_7603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7530_7602,(0),null);
var meth_7604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7530_7602,(1),null);
var c_7605 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7604));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7604))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7537,".cljs$core$IFn$_invoke$arity$variadic = ",n_7603,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_7537,".cljs$core$IFn$_invoke$arity$",c_7605," = ",n_7603,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__7606 = seq__7520_7598;
var G__7607 = chunk__7521_7599;
var G__7608 = count__7522_7600;
var G__7609 = (i__7523_7601 + (1));
seq__7520_7598 = G__7606;
chunk__7521_7599 = G__7607;
count__7522_7600 = G__7608;
i__7523_7601 = G__7609;
continue;
} else {
var temp__5753__auto___7610 = cljs.core.seq(seq__7520_7598);
if(temp__5753__auto___7610){
var seq__7520_7611__$1 = temp__5753__auto___7610;
if(cljs.core.chunked_seq_QMARK_(seq__7520_7611__$1)){
var c__4679__auto___7612 = cljs.core.chunk_first(seq__7520_7611__$1);
var G__7613 = cljs.core.chunk_rest(seq__7520_7611__$1);
var G__7614 = c__4679__auto___7612;
var G__7615 = cljs.core.count(c__4679__auto___7612);
var G__7616 = (0);
seq__7520_7598 = G__7613;
chunk__7521_7599 = G__7614;
count__7522_7600 = G__7615;
i__7523_7601 = G__7616;
continue;
} else {
var vec__7533_7617 = cljs.core.first(seq__7520_7611__$1);
var n_7618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7533_7617,(0),null);
var meth_7619 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7533_7617,(1),null);
var c_7620 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7619));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7619))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7537,".cljs$core$IFn$_invoke$arity$variadic = ",n_7618,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_7537,".cljs$core$IFn$_invoke$arity$",c_7620," = ",n_7618,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__7621 = cljs.core.next(seq__7520_7611__$1);
var G__7622 = null;
var G__7623 = (0);
var G__7624 = (0);
seq__7520_7598 = G__7621;
chunk__7521_7599 = G__7622;
count__7522_7600 = G__7623;
i__7523_7601 = G__7624;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_7537,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__7625){
var map__7626 = p__7625;
var map__7626__$1 = cljs.core.__destructure_map(map__7626);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7626__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7626__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7626__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__7627_7631 = cljs.core.seq(statements);
var chunk__7628_7632 = null;
var count__7629_7633 = (0);
var i__7630_7634 = (0);
while(true){
if((i__7630_7634 < count__7629_7633)){
var s_7635 = chunk__7628_7632.cljs$core$IIndexed$_nth$arity$2(null,i__7630_7634);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_7635);


var G__7636 = seq__7627_7631;
var G__7637 = chunk__7628_7632;
var G__7638 = count__7629_7633;
var G__7639 = (i__7630_7634 + (1));
seq__7627_7631 = G__7636;
chunk__7628_7632 = G__7637;
count__7629_7633 = G__7638;
i__7630_7634 = G__7639;
continue;
} else {
var temp__5753__auto___7640 = cljs.core.seq(seq__7627_7631);
if(temp__5753__auto___7640){
var seq__7627_7641__$1 = temp__5753__auto___7640;
if(cljs.core.chunked_seq_QMARK_(seq__7627_7641__$1)){
var c__4679__auto___7642 = cljs.core.chunk_first(seq__7627_7641__$1);
var G__7643 = cljs.core.chunk_rest(seq__7627_7641__$1);
var G__7644 = c__4679__auto___7642;
var G__7645 = cljs.core.count(c__4679__auto___7642);
var G__7646 = (0);
seq__7627_7631 = G__7643;
chunk__7628_7632 = G__7644;
count__7629_7633 = G__7645;
i__7630_7634 = G__7646;
continue;
} else {
var s_7647 = cljs.core.first(seq__7627_7641__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_7647);


var G__7648 = cljs.core.next(seq__7627_7641__$1);
var G__7649 = null;
var G__7650 = (0);
var G__7651 = (0);
seq__7627_7631 = G__7648;
chunk__7628_7632 = G__7649;
count__7629_7633 = G__7650;
i__7630_7634 = G__7651;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__7652){
var map__7653 = p__7652;
var map__7653__$1 = cljs.core.__destructure_map(map__7653);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7653__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7653__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7653__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7653__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7653__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4253__auto__ = name;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__7654,is_loop){
var map__7655 = p__7654;
var map__7655__$1 = cljs.core.__destructure_map(map__7655);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7655__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7655__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7655__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__7656_7666 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__7657_7667 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__7657_7667);

try{var seq__7658_7668 = cljs.core.seq(bindings);
var chunk__7659_7669 = null;
var count__7660_7670 = (0);
var i__7661_7671 = (0);
while(true){
if((i__7661_7671 < count__7660_7670)){
var map__7664_7672 = chunk__7659_7669.cljs$core$IIndexed$_nth$arity$2(null,i__7661_7671);
var map__7664_7673__$1 = cljs.core.__destructure_map(map__7664_7672);
var binding_7674 = map__7664_7673__$1;
var init_7675 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7664_7673__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_7674);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_7675,";");


var G__7676 = seq__7658_7668;
var G__7677 = chunk__7659_7669;
var G__7678 = count__7660_7670;
var G__7679 = (i__7661_7671 + (1));
seq__7658_7668 = G__7676;
chunk__7659_7669 = G__7677;
count__7660_7670 = G__7678;
i__7661_7671 = G__7679;
continue;
} else {
var temp__5753__auto___7680 = cljs.core.seq(seq__7658_7668);
if(temp__5753__auto___7680){
var seq__7658_7681__$1 = temp__5753__auto___7680;
if(cljs.core.chunked_seq_QMARK_(seq__7658_7681__$1)){
var c__4679__auto___7682 = cljs.core.chunk_first(seq__7658_7681__$1);
var G__7683 = cljs.core.chunk_rest(seq__7658_7681__$1);
var G__7684 = c__4679__auto___7682;
var G__7685 = cljs.core.count(c__4679__auto___7682);
var G__7686 = (0);
seq__7658_7668 = G__7683;
chunk__7659_7669 = G__7684;
count__7660_7670 = G__7685;
i__7661_7671 = G__7686;
continue;
} else {
var map__7665_7687 = cljs.core.first(seq__7658_7681__$1);
var map__7665_7688__$1 = cljs.core.__destructure_map(map__7665_7687);
var binding_7689 = map__7665_7688__$1;
var init_7690 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7665_7688__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_7689);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_7690,";");


var G__7691 = cljs.core.next(seq__7658_7681__$1);
var G__7692 = null;
var G__7693 = (0);
var G__7694 = (0);
seq__7658_7668 = G__7691;
chunk__7659_7669 = G__7692;
count__7660_7670 = G__7693;
i__7661_7671 = G__7694;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__7656_7666);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__7695){
var map__7696 = p__7695;
var map__7696__$1 = cljs.core.__destructure_map(map__7696);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7696__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7696__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7696__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4741__auto___7697 = cljs.core.count(exprs);
var i_7698 = (0);
while(true){
if((i_7698 < n__4741__auto___7697)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_7698) : temps.call(null,i_7698))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_7698) : exprs.call(null,i_7698)),";");

var G__7699 = (i_7698 + (1));
i_7698 = G__7699;
continue;
} else {
}
break;
}

var n__4741__auto___7700 = cljs.core.count(exprs);
var i_7701 = (0);
while(true){
if((i_7701 < n__4741__auto___7700)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_7701) : params.call(null,i_7701)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_7701) : temps.call(null,i_7701)),";");

var G__7702 = (i_7701 + (1));
i_7701 = G__7702;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__7703){
var map__7704 = p__7703;
var map__7704__$1 = cljs.core.__destructure_map(map__7704);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7704__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7704__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7704__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__7705_7713 = cljs.core.seq(bindings);
var chunk__7706_7714 = null;
var count__7707_7715 = (0);
var i__7708_7716 = (0);
while(true){
if((i__7708_7716 < count__7707_7715)){
var map__7711_7717 = chunk__7706_7714.cljs$core$IIndexed$_nth$arity$2(null,i__7708_7716);
var map__7711_7718__$1 = cljs.core.__destructure_map(map__7711_7717);
var binding_7719 = map__7711_7718__$1;
var init_7720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7711_7718__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_7719)," = ",init_7720,";");


var G__7721 = seq__7705_7713;
var G__7722 = chunk__7706_7714;
var G__7723 = count__7707_7715;
var G__7724 = (i__7708_7716 + (1));
seq__7705_7713 = G__7721;
chunk__7706_7714 = G__7722;
count__7707_7715 = G__7723;
i__7708_7716 = G__7724;
continue;
} else {
var temp__5753__auto___7725 = cljs.core.seq(seq__7705_7713);
if(temp__5753__auto___7725){
var seq__7705_7726__$1 = temp__5753__auto___7725;
if(cljs.core.chunked_seq_QMARK_(seq__7705_7726__$1)){
var c__4679__auto___7727 = cljs.core.chunk_first(seq__7705_7726__$1);
var G__7728 = cljs.core.chunk_rest(seq__7705_7726__$1);
var G__7729 = c__4679__auto___7727;
var G__7730 = cljs.core.count(c__4679__auto___7727);
var G__7731 = (0);
seq__7705_7713 = G__7728;
chunk__7706_7714 = G__7729;
count__7707_7715 = G__7730;
i__7708_7716 = G__7731;
continue;
} else {
var map__7712_7732 = cljs.core.first(seq__7705_7726__$1);
var map__7712_7733__$1 = cljs.core.__destructure_map(map__7712_7732);
var binding_7734 = map__7712_7733__$1;
var init_7735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7712_7733__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_7734)," = ",init_7735,";");


var G__7736 = cljs.core.next(seq__7705_7726__$1);
var G__7737 = null;
var G__7738 = (0);
var G__7739 = (0);
seq__7705_7713 = G__7736;
chunk__7706_7714 = G__7737;
count__7707_7715 = G__7738;
i__7708_7716 = G__7739;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__7742){
var map__7743 = p__7742;
var map__7743__$1 = cljs.core.__destructure_map(map__7743);
var expr = map__7743__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7743__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7743__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7743__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4251__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__4251__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4251__auto__ = protocol;
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = tag;
if(cljs.core.truth_(and__4251__auto____$1)){
var or__4253__auto__ = (function (){var and__4251__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4251__auto____$2)){
var and__4251__auto____$3 = protocol;
if(cljs.core.truth_(and__4251__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4251__auto____$3;
}
} else {
return and__4251__auto____$2;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto____$2 = (function (){var or__4253__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4251__auto____$2)){
var or__4253__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4253__auto____$1){
return or__4253__auto____$1;
} else {
var and__4251__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__4251__auto____$3){
var and__4251__auto____$4 = cljs.core.not((function (){var fexpr__7747 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__7747.cljs$core$IFn$_invoke$arity$1 ? fexpr__7747.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__7747.call(null,tag));
})());
if(and__4251__auto____$4){
var temp__5753__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__4251__auto____$4;
}
} else {
return and__4251__auto____$3;
}
}
} else {
return and__4251__auto____$2;
}
}
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__7748 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__7748.cljs$core$IFn$_invoke$arity$1 ? fexpr__7748.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__7748.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4253__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4253__auto____$1){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4253__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4253__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4253__auto__){
return or__4253__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__7744 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return (arity > mfa);
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7740_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__7740_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7741_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__7741_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7744,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7744,(1),null);
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_7751 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_7751,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_7752 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_7752,args)),(((mfa_7752 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_7752,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4251__auto__)){
var G__7750 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__7749 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__7749.cljs$core$IFn$_invoke$arity$1 ? fexpr__7749.cljs$core$IFn$_invoke$arity$1(G__7750) : fexpr__7749.call(null,G__7750));
} else {
return and__4251__auto__;
}
})())){
var fprop_7753 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_7753," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_7753,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_7753," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_7753,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__7754){
var map__7755 = p__7754;
var map__7755__$1 = cljs.core.__destructure_map(map__7755);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7755__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7755__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7755__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__7756){
var map__7757 = p__7756;
var map__7757__$1 = cljs.core.__destructure_map(map__7757);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7757__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7757__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7757__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7758_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__7758_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__7759 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7759,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7759,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__7762 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__7762__$1 = cljs.core.__destructure_map(map__7762);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7762__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7762__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__7763 = options;
var map__7763__$1 = cljs.core.__destructure_map(map__7763);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7763__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7763__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7763__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__7764 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__7770 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__7770__$1 = cljs.core.__destructure_map(map__7770);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7770__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7770__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7764,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7764,(1),null);
var vec__7767 = (function (){var map__7771 = cljs.core.group_by(cljs.analyzer.goog_module_dep_QMARK_,libs_to_load);
var map__7771__$1 = cljs.core.__destructure_map(map__7771);
var goog_modules = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7771__$1,true);
var libs_to_load__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7771__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [goog_modules,libs_to_load__$1], null);
})();
var goog_modules = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7767,(0),null);
var libs_to_load__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7767,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load__$1);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__7772_7816 = cljs.core.seq(libs_to_load__$1);
var chunk__7773_7817 = null;
var count__7774_7818 = (0);
var i__7775_7819 = (0);
while(true){
if((i__7775_7819 < count__7774_7818)){
var lib_7820 = chunk__7773_7817.cljs$core$IIndexed$_nth$arity$2(null,i__7775_7819);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_7820)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7820),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7820),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7820),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7820),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_7820,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7820),"');");
}

}
}
}


var G__7821 = seq__7772_7816;
var G__7822 = chunk__7773_7817;
var G__7823 = count__7774_7818;
var G__7824 = (i__7775_7819 + (1));
seq__7772_7816 = G__7821;
chunk__7773_7817 = G__7822;
count__7774_7818 = G__7823;
i__7775_7819 = G__7824;
continue;
} else {
var temp__5753__auto___7825 = cljs.core.seq(seq__7772_7816);
if(temp__5753__auto___7825){
var seq__7772_7826__$1 = temp__5753__auto___7825;
if(cljs.core.chunked_seq_QMARK_(seq__7772_7826__$1)){
var c__4679__auto___7827 = cljs.core.chunk_first(seq__7772_7826__$1);
var G__7828 = cljs.core.chunk_rest(seq__7772_7826__$1);
var G__7829 = c__4679__auto___7827;
var G__7830 = cljs.core.count(c__4679__auto___7827);
var G__7831 = (0);
seq__7772_7816 = G__7828;
chunk__7773_7817 = G__7829;
count__7774_7818 = G__7830;
i__7775_7819 = G__7831;
continue;
} else {
var lib_7832 = cljs.core.first(seq__7772_7826__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_7832)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7832),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7832),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7832),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7832),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_7832,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7832),"');");
}

}
}
}


var G__7833 = cljs.core.next(seq__7772_7826__$1);
var G__7834 = null;
var G__7835 = (0);
var G__7836 = (0);
seq__7772_7816 = G__7833;
chunk__7773_7817 = G__7834;
count__7774_7818 = G__7835;
i__7775_7819 = G__7836;
continue;
}
} else {
}
}
break;
}

var seq__7776_7837 = cljs.core.seq(node_libs);
var chunk__7777_7838 = null;
var count__7778_7839 = (0);
var i__7779_7840 = (0);
while(true){
if((i__7779_7840 < count__7778_7839)){
var lib_7841 = chunk__7777_7838.cljs$core$IIndexed$_nth$arity$2(null,i__7779_7840);
var vec__7786_7842 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7841);
var lib_SINGLEQUOTE__7843 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7786_7842,(0),null);
var sublib_7844 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7786_7842,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_7841)," = require('",lib_SINGLEQUOTE__7843,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7844),";"], 0));


var G__7845 = seq__7776_7837;
var G__7846 = chunk__7777_7838;
var G__7847 = count__7778_7839;
var G__7848 = (i__7779_7840 + (1));
seq__7776_7837 = G__7845;
chunk__7777_7838 = G__7846;
count__7778_7839 = G__7847;
i__7779_7840 = G__7848;
continue;
} else {
var temp__5753__auto___7849 = cljs.core.seq(seq__7776_7837);
if(temp__5753__auto___7849){
var seq__7776_7850__$1 = temp__5753__auto___7849;
if(cljs.core.chunked_seq_QMARK_(seq__7776_7850__$1)){
var c__4679__auto___7851 = cljs.core.chunk_first(seq__7776_7850__$1);
var G__7852 = cljs.core.chunk_rest(seq__7776_7850__$1);
var G__7853 = c__4679__auto___7851;
var G__7854 = cljs.core.count(c__4679__auto___7851);
var G__7855 = (0);
seq__7776_7837 = G__7852;
chunk__7777_7838 = G__7853;
count__7778_7839 = G__7854;
i__7779_7840 = G__7855;
continue;
} else {
var lib_7856 = cljs.core.first(seq__7776_7850__$1);
var vec__7789_7857 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7856);
var lib_SINGLEQUOTE__7858 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7789_7857,(0),null);
var sublib_7859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7789_7857,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_7856)," = require('",lib_SINGLEQUOTE__7858,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7859),";"], 0));


var G__7860 = cljs.core.next(seq__7776_7850__$1);
var G__7861 = null;
var G__7862 = (0);
var G__7863 = (0);
seq__7776_7837 = G__7860;
chunk__7777_7838 = G__7861;
count__7778_7839 = G__7862;
i__7779_7840 = G__7863;
continue;
}
} else {
}
}
break;
}

var seq__7792_7864 = cljs.core.seq(goog_modules);
var chunk__7793_7865 = null;
var count__7794_7866 = (0);
var i__7795_7867 = (0);
while(true){
if((i__7795_7867 < count__7794_7866)){
var lib_7868 = chunk__7793_7865.cljs$core$IIndexed$_nth$arity$2(null,i__7795_7867);
var vec__7802_7869 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7868);
var lib_SINGLEQUOTE__7870 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7802_7869,(0),null);
var sublib_7871 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7802_7869,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",lib_SINGLEQUOTE__7870,"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.scope(function(){");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_goog_module_lib.cljs$core$IFn$_invoke$arity$1(lib_7868)," = goog.module.get('",lib_SINGLEQUOTE__7870,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7871),";"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");


var G__7872 = seq__7792_7864;
var G__7873 = chunk__7793_7865;
var G__7874 = count__7794_7866;
var G__7875 = (i__7795_7867 + (1));
seq__7792_7864 = G__7872;
chunk__7793_7865 = G__7873;
count__7794_7866 = G__7874;
i__7795_7867 = G__7875;
continue;
} else {
var temp__5753__auto___7876 = cljs.core.seq(seq__7792_7864);
if(temp__5753__auto___7876){
var seq__7792_7877__$1 = temp__5753__auto___7876;
if(cljs.core.chunked_seq_QMARK_(seq__7792_7877__$1)){
var c__4679__auto___7878 = cljs.core.chunk_first(seq__7792_7877__$1);
var G__7879 = cljs.core.chunk_rest(seq__7792_7877__$1);
var G__7880 = c__4679__auto___7878;
var G__7881 = cljs.core.count(c__4679__auto___7878);
var G__7882 = (0);
seq__7792_7864 = G__7879;
chunk__7793_7865 = G__7880;
count__7794_7866 = G__7881;
i__7795_7867 = G__7882;
continue;
} else {
var lib_7883 = cljs.core.first(seq__7792_7877__$1);
var vec__7805_7884 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7883);
var lib_SINGLEQUOTE__7885 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7805_7884,(0),null);
var sublib_7886 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7805_7884,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",lib_SINGLEQUOTE__7885,"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.scope(function(){");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_goog_module_lib.cljs$core$IFn$_invoke$arity$1(lib_7883)," = goog.module.get('",lib_SINGLEQUOTE__7885,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7886),";"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");


var G__7887 = cljs.core.next(seq__7792_7877__$1);
var G__7888 = null;
var G__7889 = (0);
var G__7890 = (0);
seq__7792_7864 = G__7887;
chunk__7793_7865 = G__7888;
count__7794_7866 = G__7889;
i__7795_7867 = G__7890;
continue;
}
} else {
}
}
break;
}

var seq__7808_7891 = cljs.core.seq(global_exports_libs);
var chunk__7809_7892 = null;
var count__7810_7893 = (0);
var i__7811_7894 = (0);
while(true){
if((i__7811_7894 < count__7810_7893)){
var lib_7895 = chunk__7809_7892.cljs$core$IIndexed$_nth$arity$2(null,i__7811_7894);
var map__7814_7896 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_7895))));
var map__7814_7897__$1 = cljs.core.__destructure_map(map__7814_7896);
var global_exports_7898 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7814_7897__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_7898,lib_7895);


var G__7899 = seq__7808_7891;
var G__7900 = chunk__7809_7892;
var G__7901 = count__7810_7893;
var G__7902 = (i__7811_7894 + (1));
seq__7808_7891 = G__7899;
chunk__7809_7892 = G__7900;
count__7810_7893 = G__7901;
i__7811_7894 = G__7902;
continue;
} else {
var temp__5753__auto___7903 = cljs.core.seq(seq__7808_7891);
if(temp__5753__auto___7903){
var seq__7808_7904__$1 = temp__5753__auto___7903;
if(cljs.core.chunked_seq_QMARK_(seq__7808_7904__$1)){
var c__4679__auto___7905 = cljs.core.chunk_first(seq__7808_7904__$1);
var G__7906 = cljs.core.chunk_rest(seq__7808_7904__$1);
var G__7907 = c__4679__auto___7905;
var G__7908 = cljs.core.count(c__4679__auto___7905);
var G__7909 = (0);
seq__7808_7891 = G__7906;
chunk__7809_7892 = G__7907;
count__7810_7893 = G__7908;
i__7811_7894 = G__7909;
continue;
} else {
var lib_7910 = cljs.core.first(seq__7808_7904__$1);
var map__7815_7911 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_7910))));
var map__7815_7912__$1 = cljs.core.__destructure_map(map__7815_7911);
var global_exports_7913 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7815_7912__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_7913,lib_7910);


var G__7914 = cljs.core.next(seq__7808_7904__$1);
var G__7915 = null;
var G__7916 = (0);
var G__7917 = (0);
seq__7808_7891 = G__7914;
chunk__7809_7892 = G__7915;
count__7810_7893 = G__7916;
i__7811_7894 = G__7917;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__7918){
var map__7919 = p__7918;
var map__7919__$1 = cljs.core.__destructure_map(map__7919);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7919__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7919__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7919__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7919__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7919__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7919__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7919__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__7920){
var map__7921 = p__7920;
var map__7921__$1 = cljs.core.__destructure_map(map__7921);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7921__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7921__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7921__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7921__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7921__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7921__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7921__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__7922){
var map__7923 = p__7922;
var map__7923__$1 = cljs.core.__destructure_map(map__7923);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7923__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7923__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7923__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7923__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7923__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__7924_7948 = cljs.core.seq(protocols);
var chunk__7925_7949 = null;
var count__7926_7950 = (0);
var i__7927_7951 = (0);
while(true){
if((i__7927_7951 < count__7926_7950)){
var protocol_7952 = chunk__7925_7949.cljs$core$IIndexed$_nth$arity$2(null,i__7927_7951);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7952)),"}");


var G__7953 = seq__7924_7948;
var G__7954 = chunk__7925_7949;
var G__7955 = count__7926_7950;
var G__7956 = (i__7927_7951 + (1));
seq__7924_7948 = G__7953;
chunk__7925_7949 = G__7954;
count__7926_7950 = G__7955;
i__7927_7951 = G__7956;
continue;
} else {
var temp__5753__auto___7957 = cljs.core.seq(seq__7924_7948);
if(temp__5753__auto___7957){
var seq__7924_7958__$1 = temp__5753__auto___7957;
if(cljs.core.chunked_seq_QMARK_(seq__7924_7958__$1)){
var c__4679__auto___7959 = cljs.core.chunk_first(seq__7924_7958__$1);
var G__7960 = cljs.core.chunk_rest(seq__7924_7958__$1);
var G__7961 = c__4679__auto___7959;
var G__7962 = cljs.core.count(c__4679__auto___7959);
var G__7963 = (0);
seq__7924_7948 = G__7960;
chunk__7925_7949 = G__7961;
count__7926_7950 = G__7962;
i__7927_7951 = G__7963;
continue;
} else {
var protocol_7964 = cljs.core.first(seq__7924_7958__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7964)),"}");


var G__7965 = cljs.core.next(seq__7924_7958__$1);
var G__7966 = null;
var G__7967 = (0);
var G__7968 = (0);
seq__7924_7948 = G__7965;
chunk__7925_7949 = G__7966;
count__7926_7950 = G__7967;
i__7927_7951 = G__7968;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__7928_7969 = cljs.core.seq(fields__$1);
var chunk__7929_7970 = null;
var count__7930_7971 = (0);
var i__7931_7972 = (0);
while(true){
if((i__7931_7972 < count__7930_7971)){
var fld_7973 = chunk__7929_7970.cljs$core$IIndexed$_nth$arity$2(null,i__7931_7972);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_7973," = ",fld_7973,";");


var G__7974 = seq__7928_7969;
var G__7975 = chunk__7929_7970;
var G__7976 = count__7930_7971;
var G__7977 = (i__7931_7972 + (1));
seq__7928_7969 = G__7974;
chunk__7929_7970 = G__7975;
count__7930_7971 = G__7976;
i__7931_7972 = G__7977;
continue;
} else {
var temp__5753__auto___7978 = cljs.core.seq(seq__7928_7969);
if(temp__5753__auto___7978){
var seq__7928_7979__$1 = temp__5753__auto___7978;
if(cljs.core.chunked_seq_QMARK_(seq__7928_7979__$1)){
var c__4679__auto___7980 = cljs.core.chunk_first(seq__7928_7979__$1);
var G__7981 = cljs.core.chunk_rest(seq__7928_7979__$1);
var G__7982 = c__4679__auto___7980;
var G__7983 = cljs.core.count(c__4679__auto___7980);
var G__7984 = (0);
seq__7928_7969 = G__7981;
chunk__7929_7970 = G__7982;
count__7930_7971 = G__7983;
i__7931_7972 = G__7984;
continue;
} else {
var fld_7985 = cljs.core.first(seq__7928_7979__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_7985," = ",fld_7985,";");


var G__7986 = cljs.core.next(seq__7928_7979__$1);
var G__7987 = null;
var G__7988 = (0);
var G__7989 = (0);
seq__7928_7969 = G__7986;
chunk__7929_7970 = G__7987;
count__7930_7971 = G__7988;
i__7931_7972 = G__7989;
continue;
}
} else {
}
}
break;
}

var seq__7932_7990 = cljs.core.seq(pmasks);
var chunk__7933_7991 = null;
var count__7934_7992 = (0);
var i__7935_7993 = (0);
while(true){
if((i__7935_7993 < count__7934_7992)){
var vec__7942_7994 = chunk__7933_7991.cljs$core$IIndexed$_nth$arity$2(null,i__7935_7993);
var pno_7995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7942_7994,(0),null);
var pmask_7996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7942_7994,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_7995,"$ = ",pmask_7996,";");


var G__7997 = seq__7932_7990;
var G__7998 = chunk__7933_7991;
var G__7999 = count__7934_7992;
var G__8000 = (i__7935_7993 + (1));
seq__7932_7990 = G__7997;
chunk__7933_7991 = G__7998;
count__7934_7992 = G__7999;
i__7935_7993 = G__8000;
continue;
} else {
var temp__5753__auto___8001 = cljs.core.seq(seq__7932_7990);
if(temp__5753__auto___8001){
var seq__7932_8002__$1 = temp__5753__auto___8001;
if(cljs.core.chunked_seq_QMARK_(seq__7932_8002__$1)){
var c__4679__auto___8003 = cljs.core.chunk_first(seq__7932_8002__$1);
var G__8004 = cljs.core.chunk_rest(seq__7932_8002__$1);
var G__8005 = c__4679__auto___8003;
var G__8006 = cljs.core.count(c__4679__auto___8003);
var G__8007 = (0);
seq__7932_7990 = G__8004;
chunk__7933_7991 = G__8005;
count__7934_7992 = G__8006;
i__7935_7993 = G__8007;
continue;
} else {
var vec__7945_8008 = cljs.core.first(seq__7932_8002__$1);
var pno_8009 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7945_8008,(0),null);
var pmask_8010 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7945_8008,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_8009,"$ = ",pmask_8010,";");


var G__8011 = cljs.core.next(seq__7932_8002__$1);
var G__8012 = null;
var G__8013 = (0);
var G__8014 = (0);
seq__7932_7990 = G__8011;
chunk__7933_7991 = G__8012;
count__7934_7992 = G__8013;
i__7935_7993 = G__8014;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__8015){
var map__8016 = p__8015;
var map__8016__$1 = cljs.core.__destructure_map(map__8016);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8016__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8016__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8016__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8016__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8016__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__8017_8041 = cljs.core.seq(protocols);
var chunk__8018_8042 = null;
var count__8019_8043 = (0);
var i__8020_8044 = (0);
while(true){
if((i__8020_8044 < count__8019_8043)){
var protocol_8045 = chunk__8018_8042.cljs$core$IIndexed$_nth$arity$2(null,i__8020_8044);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_8045)),"}");


var G__8046 = seq__8017_8041;
var G__8047 = chunk__8018_8042;
var G__8048 = count__8019_8043;
var G__8049 = (i__8020_8044 + (1));
seq__8017_8041 = G__8046;
chunk__8018_8042 = G__8047;
count__8019_8043 = G__8048;
i__8020_8044 = G__8049;
continue;
} else {
var temp__5753__auto___8050 = cljs.core.seq(seq__8017_8041);
if(temp__5753__auto___8050){
var seq__8017_8051__$1 = temp__5753__auto___8050;
if(cljs.core.chunked_seq_QMARK_(seq__8017_8051__$1)){
var c__4679__auto___8052 = cljs.core.chunk_first(seq__8017_8051__$1);
var G__8053 = cljs.core.chunk_rest(seq__8017_8051__$1);
var G__8054 = c__4679__auto___8052;
var G__8055 = cljs.core.count(c__4679__auto___8052);
var G__8056 = (0);
seq__8017_8041 = G__8053;
chunk__8018_8042 = G__8054;
count__8019_8043 = G__8055;
i__8020_8044 = G__8056;
continue;
} else {
var protocol_8057 = cljs.core.first(seq__8017_8051__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_8057)),"}");


var G__8058 = cljs.core.next(seq__8017_8051__$1);
var G__8059 = null;
var G__8060 = (0);
var G__8061 = (0);
seq__8017_8041 = G__8058;
chunk__8018_8042 = G__8059;
count__8019_8043 = G__8060;
i__8020_8044 = G__8061;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__8021_8062 = cljs.core.seq(fields__$1);
var chunk__8022_8063 = null;
var count__8023_8064 = (0);
var i__8024_8065 = (0);
while(true){
if((i__8024_8065 < count__8023_8064)){
var fld_8066 = chunk__8022_8063.cljs$core$IIndexed$_nth$arity$2(null,i__8024_8065);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_8066," = ",fld_8066,";");


var G__8067 = seq__8021_8062;
var G__8068 = chunk__8022_8063;
var G__8069 = count__8023_8064;
var G__8070 = (i__8024_8065 + (1));
seq__8021_8062 = G__8067;
chunk__8022_8063 = G__8068;
count__8023_8064 = G__8069;
i__8024_8065 = G__8070;
continue;
} else {
var temp__5753__auto___8071 = cljs.core.seq(seq__8021_8062);
if(temp__5753__auto___8071){
var seq__8021_8072__$1 = temp__5753__auto___8071;
if(cljs.core.chunked_seq_QMARK_(seq__8021_8072__$1)){
var c__4679__auto___8073 = cljs.core.chunk_first(seq__8021_8072__$1);
var G__8074 = cljs.core.chunk_rest(seq__8021_8072__$1);
var G__8075 = c__4679__auto___8073;
var G__8076 = cljs.core.count(c__4679__auto___8073);
var G__8077 = (0);
seq__8021_8062 = G__8074;
chunk__8022_8063 = G__8075;
count__8023_8064 = G__8076;
i__8024_8065 = G__8077;
continue;
} else {
var fld_8078 = cljs.core.first(seq__8021_8072__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_8078," = ",fld_8078,";");


var G__8079 = cljs.core.next(seq__8021_8072__$1);
var G__8080 = null;
var G__8081 = (0);
var G__8082 = (0);
seq__8021_8062 = G__8079;
chunk__8022_8063 = G__8080;
count__8023_8064 = G__8081;
i__8024_8065 = G__8082;
continue;
}
} else {
}
}
break;
}

var seq__8025_8083 = cljs.core.seq(pmasks);
var chunk__8026_8084 = null;
var count__8027_8085 = (0);
var i__8028_8086 = (0);
while(true){
if((i__8028_8086 < count__8027_8085)){
var vec__8035_8087 = chunk__8026_8084.cljs$core$IIndexed$_nth$arity$2(null,i__8028_8086);
var pno_8088 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8035_8087,(0),null);
var pmask_8089 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8035_8087,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_8088,"$ = ",pmask_8089,";");


var G__8090 = seq__8025_8083;
var G__8091 = chunk__8026_8084;
var G__8092 = count__8027_8085;
var G__8093 = (i__8028_8086 + (1));
seq__8025_8083 = G__8090;
chunk__8026_8084 = G__8091;
count__8027_8085 = G__8092;
i__8028_8086 = G__8093;
continue;
} else {
var temp__5753__auto___8094 = cljs.core.seq(seq__8025_8083);
if(temp__5753__auto___8094){
var seq__8025_8095__$1 = temp__5753__auto___8094;
if(cljs.core.chunked_seq_QMARK_(seq__8025_8095__$1)){
var c__4679__auto___8096 = cljs.core.chunk_first(seq__8025_8095__$1);
var G__8097 = cljs.core.chunk_rest(seq__8025_8095__$1);
var G__8098 = c__4679__auto___8096;
var G__8099 = cljs.core.count(c__4679__auto___8096);
var G__8100 = (0);
seq__8025_8083 = G__8097;
chunk__8026_8084 = G__8098;
count__8027_8085 = G__8099;
i__8028_8086 = G__8100;
continue;
} else {
var vec__8038_8101 = cljs.core.first(seq__8025_8095__$1);
var pno_8102 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8038_8101,(0),null);
var pmask_8103 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8038_8101,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_8102,"$ = ",pmask_8103,";");


var G__8104 = cljs.core.next(seq__8025_8095__$1);
var G__8105 = null;
var G__8106 = (0);
var G__8107 = (0);
seq__8025_8083 = G__8104;
chunk__8026_8084 = G__8105;
count__8027_8085 = G__8106;
i__8028_8086 = G__8107;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__8108){
var map__8109 = p__8108;
var map__8109__$1 = cljs.core.__destructure_map(map__8109);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8109__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8109__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8109__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8109__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8109__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__8110){
var map__8111 = p__8110;
var map__8111__$1 = cljs.core.__destructure_map(map__8111);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8111__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8111__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8111__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8111__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8111__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4251__auto__ = code;
if(cljs.core.truth_(and__4251__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4251__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__6864__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6864__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__8116 = cljs.core.seq(table);
var chunk__8117 = null;
var count__8118 = (0);
var i__8119 = (0);
while(true){
if((i__8119 < count__8118)){
var vec__8126 = chunk__8117.cljs$core$IIndexed$_nth$arity$2(null,i__8119);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8126,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8126,(1),null);
var ns_8132 = cljs.core.namespace(sym);
var name_8133 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__8134 = seq__8116;
var G__8135 = chunk__8117;
var G__8136 = count__8118;
var G__8137 = (i__8119 + (1));
seq__8116 = G__8134;
chunk__8117 = G__8135;
count__8118 = G__8136;
i__8119 = G__8137;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__8116);
if(temp__5753__auto__){
var seq__8116__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__8116__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__8116__$1);
var G__8138 = cljs.core.chunk_rest(seq__8116__$1);
var G__8139 = c__4679__auto__;
var G__8140 = cljs.core.count(c__4679__auto__);
var G__8141 = (0);
seq__8116 = G__8138;
chunk__8117 = G__8139;
count__8118 = G__8140;
i__8119 = G__8141;
continue;
} else {
var vec__8129 = cljs.core.first(seq__8116__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8129,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8129,(1),null);
var ns_8142 = cljs.core.namespace(sym);
var name_8143 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__8144 = cljs.core.next(seq__8116__$1);
var G__8145 = null;
var G__8146 = (0);
var G__8147 = (0);
seq__8116 = G__8144;
chunk__8117 = G__8145;
count__8118 = G__8146;
i__8119 = G__8147;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__8149 = arguments.length;
switch (G__8149) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_8154 = cljs.core.first(ks);
var vec__8150_8155 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_8154);
var top_8156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8150_8155,(0),null);
var prefix_SINGLEQUOTE__8157 = vec__8150_8155;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_8154)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__8157) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_8156)) || (cljs.core.contains_QMARK_(known_externs,top_8156)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__8157)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_8156);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__8157)),";");
}
} else {
}

var m_8158 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_8154);
if(cljs.core.empty_QMARK_(m_8158)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__8157,m_8158,top_level,known_externs);
}

var G__8159 = cljs.core.next(ks);
ks = G__8159;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

