// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.connection_js');
goog.require('goog.object');
goog.scope(function(){
flureeworker.goog$module$goog$object = goog.module.get('goog.object');
});
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__64579 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64579__$1 = cljs.core.__destructure_map(map__64579);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64579__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64579__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"block","block",664686210),time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = flureeworker.goog$module$goog$object.get.call(null,obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__5642__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__64580 = cljs.core.get_global_hierarchy;
return (fexpr__64580.cljs$core$IFn$_invoke$arity$0 ? fexpr__64580.cljs$core$IFn$_invoke$arity$0() : fexpr__64580.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),(function() { 
var G__64581__delegate = function (conn_id,event,_){
return event;
};
var G__64581 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__64582__i = 0, G__64582__a = new Array(arguments.length -  2);
while (G__64582__i < G__64582__a.length) {G__64582__a[G__64582__i] = arguments[G__64582__i + 2]; ++G__64582__i;}
  _ = new cljs.core.IndexedSeq(G__64582__a,0,null);
} 
return G__64581__delegate.call(this,conn_id,event,_);};
G__64581.cljs$lang$maxFixedArity = 2;
G__64581.cljs$lang$applyTo = (function (arglist__64583){
var conn_id = cljs.core.first(arglist__64583);
arglist__64583 = cljs.core.next(arglist__64583);
var event = cljs.core.first(arglist__64583);
var _ = cljs.core.rest(arglist__64583);
return G__64581__delegate(conn_id,event,_);
});
G__64581.cljs$core$IFn$_invoke$arity$variadic = G__64581__delegate;
return G__64581;
})()
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setState","setState",552299271),(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setState",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connStatus","connStatus",63327857),(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connStatus",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"login","login",55217519),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"login",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"pwGenerate",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connClosed","connClosed",1810797125),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connClosed",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connReset","connReset",-1382938159),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connReset",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setTransact","setTransact",1791803585),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setTransact",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connInit","connInit",-148647574),(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn","conn",278309663),(0),new cljs.core.Keyword(null,"event","event",301435442),"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),(function (){var or__5045__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown Error.";
}
})(),new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),e_map,new cljs.core.Keyword(null,"status","status",-1997798413),"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt);
if(cljs.core.truth_(flureeql)){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64601){
var state_val_64602 = (state_64601[(1)]);
if((state_val_64602 === (1))){
var inst_64584 = new cljs.core.Keyword(null,"forceTime","forceTime",827124337).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_64585 = flureeworker.conn_id__GT_db(conn_id,inst_64584);
var inst_64586 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,new cljs.core.Keyword(null,"opts","opts",155075701),opts_SINGLEQUOTE_);
var inst_64587 = fluree.db.api.query.query(inst_64585,inst_64586);
var state_64601__$1 = state_64601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64601__$1,(2),inst_64587);
} else {
if((state_val_64602 === (2))){
var inst_64589 = (state_64601[(7)]);
var inst_64589__$1 = (state_64601[(2)]);
var inst_64590 = fluree.db.util.core.exception_QMARK_(inst_64589__$1);
var state_64601__$1 = (function (){var statearr_64603 = state_64601;
(statearr_64603[(7)] = inst_64589__$1);

return statearr_64603;
})();
if(inst_64590){
var statearr_64604_64617 = state_64601__$1;
(statearr_64604_64617[(1)] = (3));

} else {
var statearr_64605_64618 = state_64601__$1;
(statearr_64605_64618[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64602 === (3))){
var inst_64589 = (state_64601[(7)]);
var inst_64592 = flureeworker.error_return_map(inst_64589);
var state_64601__$1 = state_64601;
var statearr_64606_64619 = state_64601__$1;
(statearr_64606_64619[(2)] = inst_64592);

(statearr_64606_64619[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64602 === (4))){
var inst_64589 = (state_64601[(7)]);
var inst_64594 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_64595 = [inst_64589,"loaded"];
var inst_64596 = cljs.core.PersistentHashMap.fromArrays(inst_64594,inst_64595);
var state_64601__$1 = state_64601;
var statearr_64607_64620 = state_64601__$1;
(statearr_64607_64620[(2)] = inst_64596);

(statearr_64607_64620[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64602 === (5))){
var inst_64598 = (state_64601[(2)]);
var inst_64599 = (function (){var G__64608 = conn_id;
var G__64609 = new cljs.core.Keyword(null,"setState","setState",552299271);
var G__64610 = id;
var G__64611 = inst_64598;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64608,G__64609,G__64610,G__64611) : flureeworker.worker_action.call(null,G__64608,G__64609,G__64610,G__64611));
})();
var state_64601__$1 = state_64601;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64601__$1,inst_64599);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$process_query_$_state_machine__2684__auto__ = null;
var flureeworker$process_query_$_state_machine__2684__auto____0 = (function (){
var statearr_64612 = [null,null,null,null,null,null,null,null];
(statearr_64612[(0)] = flureeworker$process_query_$_state_machine__2684__auto__);

(statearr_64612[(1)] = (1));

return statearr_64612;
});
var flureeworker$process_query_$_state_machine__2684__auto____1 = (function (state_64601){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64601);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64613){var ex__2687__auto__ = e64613;
var statearr_64614_64621 = state_64601;
(statearr_64614_64621[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64601[(4)]))){
var statearr_64615_64622 = state_64601;
(statearr_64615_64622[(1)] = cljs.core.first((state_64601[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64623 = state_64601;
state_64601 = G__64623;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__2684__auto__ = function(state_64601){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__2684__auto____1.call(this,state_64601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__2684__auto____0;
flureeworker$process_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__2684__auto____1;
return flureeworker$process_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64616 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64616[(6)] = c__2706__auto__);

return statearr_64616;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__64624 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64624__$1 = cljs.core.__destructure_map(map__64624);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64624__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64624__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var query_ids = cljs.core.keys(queries);
var seq__64625 = cljs.core.seq(query_ids);
var chunk__64626 = null;
var count__64627 = (0);
var i__64628 = (0);
while(true){
if((i__64628 < count__64627)){
var id = chunk__64626.cljs$core$IIndexed$_nth$arity$2(null,i__64628);
flureeworker.process_query(conn_id,id,opts);


var G__64629 = seq__64625;
var G__64630 = chunk__64626;
var G__64631 = count__64627;
var G__64632 = (i__64628 + (1));
seq__64625 = G__64629;
chunk__64626 = G__64630;
count__64627 = G__64631;
i__64628 = G__64632;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__64625);
if(temp__5804__auto__){
var seq__64625__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__64625__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__64625__$1);
var G__64633 = cljs.core.chunk_rest(seq__64625__$1);
var G__64634 = c__5568__auto__;
var G__64635 = cljs.core.count(c__5568__auto__);
var G__64636 = (0);
seq__64625 = G__64633;
chunk__64626 = G__64634;
count__64627 = G__64635;
i__64628 = G__64636;
continue;
} else {
var id = cljs.core.first(seq__64625__$1);
flureeworker.process_query(conn_id,id,opts);


var G__64637 = cljs.core.next(seq__64625__$1);
var G__64638 = null;
var G__64639 = (0);
var G__64640 = (0);
seq__64625 = G__64637;
chunk__64626 = G__64638;
count__64627 = G__64639;
i__64628 = G__64640;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__64641 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64641,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64641,(1),null);
var cb = (function (header,data){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64649){
var state_val_64650 = (state_64649[(1)]);
if((state_val_64650 === (1))){
var inst_64644 = cljs.core.async.timeout((100));
var state_64649__$1 = state_64649;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64649__$1,(2),inst_64644);
} else {
if((state_val_64650 === (2))){
var inst_64646 = (state_64649[(2)]);
var inst_64647 = flureeworker.process_all_queries(conn_id);
var state_64649__$1 = (function (){var statearr_64651 = state_64649;
(statearr_64651[(7)] = inst_64646);

return statearr_64651;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64649__$1,inst_64647);
} else {
return null;
}
}
});
return (function() {
var flureeworker$ledger_listener_$_state_machine__2684__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__2684__auto____0 = (function (){
var statearr_64652 = [null,null,null,null,null,null,null,null];
(statearr_64652[(0)] = flureeworker$ledger_listener_$_state_machine__2684__auto__);

(statearr_64652[(1)] = (1));

return statearr_64652;
});
var flureeworker$ledger_listener_$_state_machine__2684__auto____1 = (function (state_64649){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64649);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64653){var ex__2687__auto__ = e64653;
var statearr_64654_64657 = state_64649;
(statearr_64654_64657[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64649[(4)]))){
var statearr_64655_64658 = state_64649;
(statearr_64655_64658[(1)] = cljs.core.first((state_64649[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64659 = state_64649;
state_64649 = G__64659;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__2684__auto__ = function(state_64649){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__2684__auto____1.call(this,state_64649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__2684__auto____0;
flureeworker$ledger_listener_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__2684__auto____1;
return flureeworker$ledger_listener_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64656 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64656[(6)] = c__2706__auto__);

return statearr_64656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__64660 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64660,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64660,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__64663 = config;
var map__64663__$1 = cljs.core.__destructure_map(map__64663);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64663__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64663__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64663__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64663__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64663__$1,new cljs.core.Keyword(null,"compact","compact",-348732150));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64663__$1,new cljs.core.Keyword(null,"private","private",-558947994));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"closed","closed",-919675359),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"conn","conn",278309663)],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"compact","compact",-348732150),compact], null),servers,(function (){var or__5045__auto__ = queries;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64664 = conn_data;
var map__64664__$1 = cljs.core.__destructure_map(map__64664);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64664__$1,new cljs.core.Keyword(null,"config","config",994861415));
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64664__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64664__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var map__64665 = config;
var map__64665__$1 = cljs.core.__destructure_map(map__64665);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64665__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64665__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64665__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64665__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64671){
var state_val_64672 = (state_64671[(1)]);
if((state_val_64672 === (1))){
var inst_64666 = cljs.core.async.timeout((100));
var state_64671__$1 = state_64671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64671__$1,(2),inst_64666);
} else {
if((state_val_64672 === (2))){
var inst_64668 = (state_64671[(2)]);
var inst_64669 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_64671__$1 = (function (){var statearr_64673 = state_64671;
(statearr_64673[(7)] = inst_64668);

return statearr_64673;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64671__$1,inst_64669);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_STAR__$_state_machine__2684__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__2684__auto____0 = (function (){
var statearr_64674 = [null,null,null,null,null,null,null,null];
(statearr_64674[(0)] = flureeworker$connect_STAR__$_state_machine__2684__auto__);

(statearr_64674[(1)] = (1));

return statearr_64674;
});
var flureeworker$connect_STAR__$_state_machine__2684__auto____1 = (function (state_64671){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64671);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64675){var ex__2687__auto__ = e64675;
var statearr_64676_64687 = state_64671;
(statearr_64676_64687[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64671[(4)]))){
var statearr_64677_64688 = state_64671;
(statearr_64677_64688[(1)] = cljs.core.first((state_64671[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64689 = state_64671;
state_64671 = G__64689;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__2684__auto__ = function(state_64671){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__2684__auto____1.call(this,state_64671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__2684__auto____0;
flureeworker$connect_STAR__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__2684__auto____1;
return flureeworker$connect_STAR__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64678 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64678[(6)] = c__2706__auto__);

return statearr_64678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}):null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__64679_64690 = conn_id;
var G__64680_64691 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__64681_64692 = ref;
var G__64682_64693 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64679_64690,G__64680_64691,G__64681_64692,G__64682_64693) : flureeworker.worker_action.call(null,G__64679_64690,G__64680_64691,G__64681_64692,G__64682_64693));

return flureeworker.process_all_queries(conn_id);
})).catch((function (error){
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__64683 = conn_id;
var G__64684 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__64685 = ref;
var G__64686 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64683,G__64684,G__64685,G__64686) : flureeworker.worker_action.call(null,G__64683,G__64684,G__64685,G__64686));
}));
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__64695 = arguments.length;
switch (G__64695) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
}));

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64696 = conn_data;
var map__64696__$1 = cljs.core.__destructure_map(map__64696);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64696__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64696__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64696__$1,new cljs.core.Keyword(null,"config","config",994861415));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64696__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"closed","closed",-919675359),true,new cljs.core.Keyword(null,"config","config",994861415),config,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null));
if((((conn_data == null)) || (new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection closed."], null);
}
}));

(flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2);

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__64703 = conn_id;
var G__64704 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__64705 = ref;
var G__64706 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64703,G__64704,G__64705,G__64706) : flureeworker.worker_action.call(null,G__64703,G__64704,G__64705,G__64706));
}catch (e64698){var e = e64698;
var msg = (function (){var or__5045__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__5045__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__64699 = conn_id;
var G__64700 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__64701 = ref;
var G__64702 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64699,G__64700,G__64701,G__64702) : flureeworker.worker_action.call(null,G__64699,G__64700,G__64701,G__64702));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e64707){var e = e64707;
var msg = (function (){var or__5045__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__5045__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__64708 = conn_id;
var G__64709 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__64710 = ref;
var G__64711 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64708,G__64709,G__64710,G__64711) : flureeworker.worker_action.call(null,G__64708,G__64709,G__64710,G__64711));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__64712 = config_STAR_;
var map__64712__$1 = cljs.core.__destructure_map(map__64712);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64712__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64712__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64712__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64712__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"finest","finest",-1359568890)):null);
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64718){
var state_val_64719 = (state_64718[(1)]);
if((state_val_64719 === (1))){
var inst_64713 = cljs.core.async.timeout((100));
var state_64718__$1 = state_64718;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64718__$1,(2),inst_64713);
} else {
if((state_val_64719 === (2))){
var inst_64715 = (state_64718[(2)]);
var inst_64716 = flureeworker.connect_STAR_(id,ref);
var state_64718__$1 = (function (){var statearr_64720 = state_64718;
(statearr_64720[(7)] = inst_64715);

return statearr_64720;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64718__$1,inst_64716);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_p_$_state_machine__2684__auto__ = null;
var flureeworker$connect_p_$_state_machine__2684__auto____0 = (function (){
var statearr_64721 = [null,null,null,null,null,null,null,null];
(statearr_64721[(0)] = flureeworker$connect_p_$_state_machine__2684__auto__);

(statearr_64721[(1)] = (1));

return statearr_64721;
});
var flureeworker$connect_p_$_state_machine__2684__auto____1 = (function (state_64718){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64718);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64722){var ex__2687__auto__ = e64722;
var statearr_64723_64734 = state_64718;
(statearr_64723_64734[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64718[(4)]))){
var statearr_64724_64735 = state_64718;
(statearr_64724_64735[(1)] = cljs.core.first((state_64718[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64736 = state_64718;
state_64718 = G__64736;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__2684__auto__ = function(state_64718){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__2684__auto____1.call(this,state_64718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__2684__auto____0;
flureeworker$connect_p_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__2684__auto____1;
return flureeworker$connect_p_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64725 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64725[(6)] = c__2706__auto__);

return statearr_64725;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}):null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__64726 = id;
var G__64727 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__64728 = ref;
var G__64729 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64726,G__64727,G__64728,G__64729) : flureeworker.worker_action.call(null,G__64726,G__64727,G__64728,G__64729));
})).catch((function (error){
var G__64730 = id;
var G__64731 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__64732 = ref;
var G__64733 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64730,G__64731,G__64732,G__64733) : flureeworker.worker_action.call(null,G__64730,G__64731,G__64732,G__64733));
}));
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"closed","closed",-919675359)], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__5775__auto__ = [];
var len__5769__auto___64804 = arguments.length;
var i__5770__auto___64805 = (0);
while(true){
if((i__5770__auto___64805 < len__5769__auto___64804)){
args__5775__auto__.push((arguments[i__5770__auto___64805]));

var G__64806 = (i__5770__auto___64805 + (1));
i__5770__auto___64805 = G__64806;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((4) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5776__auto__);
});

(flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__64742){
var vec__64743 = p__64742;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64743,(0),null);
var map__64746 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64746__$1 = cljs.core.__destructure_map(map__64746);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64746__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64746__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64746__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__64747 = conn_id;
var G__64748 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64749 = ref;
var G__64750 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64747,G__64748,G__64749,G__64750) : flureeworker.worker_action.call(null,G__64747,G__64748,G__64749,G__64750));
})());
var auth = null;
var c__2706__auto___64807 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64771){
var state_val_64772 = (state_64771[(1)]);
if((state_val_64772 === (1))){
var state_64771__$1 = state_64771;
var statearr_64773_64808 = state_64771__$1;
(statearr_64773_64808[(2)] = null);

(statearr_64773_64808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64772 === (2))){
var ___$1 = (function (){var statearr_64774 = state_64771;
(statearr_64774[(4)] = cljs.core.cons((5),(state_64771[(4)])));

return statearr_64774;
})();
var inst_64762 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_64763 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__64775 = conn_id;
var G__64776 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64777 = ref;
var G__64778 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64775,G__64776,G__64777,G__64778) : flureeworker.worker_action.call(null,G__64775,G__64776,G__64777,G__64778));
});
})();
var inst_64764 = inst_64762.then(inst_64763);
var inst_64765 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e64779){var ___$2 = e64779;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__64780 = conn_id;
var G__64781 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64782 = ref;
var G__64783 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64780,G__64781,G__64782,G__64783) : flureeworker.worker_action.call(null,G__64780,G__64781,G__64782,G__64783));
} else {
var G__64784 = conn_id;
var G__64785 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64786 = ref;
var G__64787 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64784,G__64785,G__64786,G__64787) : flureeworker.worker_action.call(null,G__64784,G__64785,G__64786,G__64787));

}
});
})();
var inst_64766 = inst_64764.catch(inst_64765);
var ___$2 = (function (){var statearr_64788 = state_64771;
(statearr_64788[(4)] = cljs.core.rest((state_64771[(4)])));

return statearr_64788;
})();
var state_64771__$1 = state_64771;
var statearr_64789_64809 = state_64771__$1;
(statearr_64789_64809[(2)] = inst_64766);

(statearr_64789_64809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64772 === (3))){
var inst_64769 = (state_64771[(2)]);
var state_64771__$1 = state_64771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64771__$1,inst_64769);
} else {
if((state_val_64772 === (4))){
var inst_64751 = (state_64771[(2)]);
var inst_64752 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64753 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64751);
var inst_64754 = [(400),inst_64753];
var inst_64755 = cljs.core.PersistentHashMap.fromArrays(inst_64752,inst_64754);
var inst_64756 = (function (){var G__64791 = conn_id;
var G__64792 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64793 = ref;
var G__64794 = inst_64755;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64791,G__64792,G__64793,G__64794) : flureeworker.worker_action.call(null,G__64791,G__64792,G__64793,G__64794));
})();
var state_64771__$1 = state_64771;
var statearr_64795_64810 = state_64771__$1;
(statearr_64795_64810[(2)] = inst_64756);

(statearr_64795_64810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64772 === (5))){
var ___$1 = (function (){var statearr_64796 = state_64771;
(statearr_64796[(4)] = cljs.core.rest((state_64771[(4)])));

return statearr_64796;
})();
var state_64771__$1 = state_64771;
var ex64790 = (state_64771__$1[(2)]);
var statearr_64797_64811 = state_64771__$1;
(statearr_64797_64811[(5)] = ex64790);


var statearr_64798_64812 = state_64771__$1;
(statearr_64798_64812[(1)] = (4));

(statearr_64798_64812[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$state_machine__2684__auto__ = null;
var flureeworker$state_machine__2684__auto____0 = (function (){
var statearr_64799 = [null,null,null,null,null,null,null];
(statearr_64799[(0)] = flureeworker$state_machine__2684__auto__);

(statearr_64799[(1)] = (1));

return statearr_64799;
});
var flureeworker$state_machine__2684__auto____1 = (function (state_64771){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64771);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64800){var ex__2687__auto__ = e64800;
var statearr_64801_64813 = state_64771;
(statearr_64801_64813[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64771[(4)]))){
var statearr_64802_64814 = state_64771;
(statearr_64802_64814[(1)] = cljs.core.first((state_64771[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64815 = state_64771;
state_64771 = G__64815;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$state_machine__2684__auto__ = function(state_64771){
switch(arguments.length){
case 0:
return flureeworker$state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$state_machine__2684__auto____1.call(this,state_64771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__2684__auto____0;
flureeworker$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__2684__auto____1;
return flureeworker$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64803 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64803[(6)] = c__2706__auto___64807);

return statearr_64803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return true;
}));

(flureeworker.login.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(flureeworker.login.cljs$lang$applyTo = (function (seq64737){
var G__64738 = cljs.core.first(seq64737);
var seq64737__$1 = cljs.core.next(seq64737);
var G__64739 = cljs.core.first(seq64737__$1);
var seq64737__$2 = cljs.core.next(seq64737__$1);
var G__64740 = cljs.core.first(seq64737__$2);
var seq64737__$3 = cljs.core.next(seq64737__$2);
var G__64741 = cljs.core.first(seq64737__$3);
var seq64737__$4 = cljs.core.next(seq64737__$3);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64738,G__64739,G__64740,G__64741,seq64737__$4);
}));

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__64816 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64816__$1 = cljs.core.__destructure_map(map__64816);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64816__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64816__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__64818 = conn_id;
var G__64819 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64820 = ref;
var G__64821 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64818,G__64819,G__64820,G__64821) : flureeworker.worker_action.call(null,G__64818,G__64819,G__64820,G__64821));
})());
var map__64817 = map_data;
var map__64817__$1 = cljs.core.__destructure_map(map__64817);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64817__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64817__$1,new cljs.core.Keyword(null,"password","password",417022471));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64817__$1,new cljs.core.Keyword(null,"options","options",99638489));
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),new cljs.core.Keyword(null,"user","user",1532431356),username);
var c__2706__auto___64875 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_64842){
var state_val_64843 = (state_64842[(1)]);
if((state_val_64843 === (1))){
var state_64842__$1 = state_64842;
var statearr_64844_64876 = state_64842__$1;
(statearr_64844_64876[(2)] = null);

(statearr_64844_64876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64843 === (2))){
var ___$1 = (function (){var statearr_64845 = state_64842;
(statearr_64845[(4)] = cljs.core.cons((5),(state_64842[(4)])));

return statearr_64845;
})();
var inst_64833 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_64834 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__64846 = conn_id;
var G__64847 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64848 = ref;
var G__64849 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64846,G__64847,G__64848,G__64849) : flureeworker.worker_action.call(null,G__64846,G__64847,G__64848,G__64849));
});
})();
var inst_64835 = inst_64833.then(inst_64834);
var inst_64836 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e64850){var ___$2 = e64850;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__64851 = conn_id;
var G__64852 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64853 = ref;
var G__64854 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64851,G__64852,G__64853,G__64854) : flureeworker.worker_action.call(null,G__64851,G__64852,G__64853,G__64854));
} else {
var G__64855 = conn_id;
var G__64856 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64857 = ref;
var G__64858 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64855,G__64856,G__64857,G__64858) : flureeworker.worker_action.call(null,G__64855,G__64856,G__64857,G__64858));

}
});
})();
var inst_64837 = inst_64835.catch(inst_64836);
var ___$2 = (function (){var statearr_64859 = state_64842;
(statearr_64859[(4)] = cljs.core.rest((state_64842[(4)])));

return statearr_64859;
})();
var state_64842__$1 = state_64842;
var statearr_64860_64877 = state_64842__$1;
(statearr_64860_64877[(2)] = inst_64837);

(statearr_64860_64877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64843 === (3))){
var inst_64840 = (state_64842[(2)]);
var state_64842__$1 = state_64842;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64842__$1,inst_64840);
} else {
if((state_val_64843 === (4))){
var inst_64822 = (state_64842[(2)]);
var inst_64823 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64824 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64822);
var inst_64825 = [(400),inst_64824];
var inst_64826 = cljs.core.PersistentHashMap.fromArrays(inst_64823,inst_64825);
var inst_64827 = (function (){var G__64862 = conn_id;
var G__64863 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64864 = ref;
var G__64865 = inst_64826;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64862,G__64863,G__64864,G__64865) : flureeworker.worker_action.call(null,G__64862,G__64863,G__64864,G__64865));
})();
var state_64842__$1 = state_64842;
var statearr_64866_64878 = state_64842__$1;
(statearr_64866_64878[(2)] = inst_64827);

(statearr_64866_64878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64843 === (5))){
var ___$1 = (function (){var statearr_64867 = state_64842;
(statearr_64867[(4)] = cljs.core.rest((state_64842[(4)])));

return statearr_64867;
})();
var state_64842__$1 = state_64842;
var ex64861 = (state_64842__$1[(2)]);
var statearr_64868_64879 = state_64842__$1;
(statearr_64868_64879[(5)] = ex64861);


var statearr_64869_64880 = state_64842__$1;
(statearr_64869_64880[(1)] = (4));

(statearr_64869_64880[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$pw_generate_$_state_machine__2684__auto__ = null;
var flureeworker$pw_generate_$_state_machine__2684__auto____0 = (function (){
var statearr_64870 = [null,null,null,null,null,null,null];
(statearr_64870[(0)] = flureeworker$pw_generate_$_state_machine__2684__auto__);

(statearr_64870[(1)] = (1));

return statearr_64870;
});
var flureeworker$pw_generate_$_state_machine__2684__auto____1 = (function (state_64842){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_64842);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e64871){var ex__2687__auto__ = e64871;
var statearr_64872_64881 = state_64842;
(statearr_64872_64881[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_64842[(4)]))){
var statearr_64873_64882 = state_64842;
(statearr_64873_64882[(1)] = cljs.core.first((state_64842[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64883 = state_64842;
state_64842 = G__64883;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__2684__auto__ = function(state_64842){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__2684__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__2684__auto____1.call(this,state_64842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__2684__auto____0;
flureeworker$pw_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__2684__auto____1;
return flureeworker$pw_generate_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_64874 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_64874[(6)] = c__2706__auto___64875);

return statearr_64874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"opts","opts",155075701)], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return new cljs.core.Keyword(null,"TODO","TODO",-523795145);
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__64884_SHARP_){
return (js_array[p1__64884_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),action_str,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"status","status",-1997798413),(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e64885){var e = e64885;
var data = (event["data"]);
var error_data = (function (){var temp__5802__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5802__auto__)){
var ex_data = temp__5802__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),(data["conn"]),new cljs.core.Keyword(null,"event","event",301435442),(data["action"]),new cljs.core.Keyword(null,"ref","ref",1289896967),(data["ref"]),new cljs.core.Keyword(null,"data","data",-232669377),error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5804__auto___64886 = cljs.core.not(self.document);
if(temp__5804__auto___64886){
var worker_QMARK__64887 = temp__5804__auto___64886;
(self.onerror = flureeworker.log_error);

(self.onmessage = flureeworker.decode_message);
} else {
}
var G__64888_64890 = null;
var G__64889_64891 = new cljs.core.Keyword(null,"connInit","connInit",-148647574);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__64888_64890,G__64889_64891) : flureeworker.worker_action.call(null,G__64888_64890,G__64889_64891));
