// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.js');
fluree.db.util.core.max_long = ((9007199254740991) - (1));
fluree.db.util.core.min_long = (- fluree.db.util.core.max_long);
fluree.db.util.core.max_integer = (2147483647);
fluree.db.util.core.min_integer = (- (2147483647));
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
fluree.db.util.core.cljs_env_QMARK_ = (function fluree$db$util$core$cljs_env_QMARK_(env){
return cljs.core.boolean$(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});
var ret__5824__auto___2822 = /**
 * Return then if we are generating cljs code and else for Clojure code.
 * https://groups.google.com/d/msg/clojurescript/iBY5HaQda4A/w1lAQi9_AwsJ
 */
fluree.db.util.core.if_cljs = (function fluree$db$util$core$if_cljs(_AMPERSAND_form,_AMPERSAND_env,then,else$){
if(fluree.db.util.core.cljs_env_QMARK_(_AMPERSAND_env)){
return then;
} else {
return else$;
}
});
(fluree.db.util.core.if_cljs.cljs$lang$macro = true);

var ret__5824__auto___2829 = (function (){
/**
 * A cross-platform variant of try-catch that catches all exceptions.
 * Does not (yet) support finally, and does not need or want an exception class.
 */
fluree.db.util.core.try_catchall = (function fluree$db$util$core$try_catchall(var_args){
var args__5775__auto__ = [];
var len__5769__auto___2830 = arguments.length;
var i__5770__auto___2831 = (0);
while(true){
if((i__5770__auto___2831 < len__5769__auto___2830)){
args__5775__auto__.push((arguments[i__5770__auto___2831]));

var G__2832 = (i__5770__auto___2831 + (1));
i__5770__auto___2831 = G__2832;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.util.core.try_catchall.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.util.core.try_catchall.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
var try_body = cljs.core.butlast(body);
var vec__2826 = cljs.core.last(body);
var seq__2827 = cljs.core.seq(vec__2826);
var first__2828 = cljs.core.first(seq__2827);
var seq__2827__$1 = cljs.core.next(seq__2827);
var catch$ = first__2828;
var first__2828__$1 = cljs.core.first(seq__2827__$1);
var seq__2827__$2 = cljs.core.next(seq__2827__$1);
var sym = first__2828__$1;
var catch_body = seq__2827__$2;
var catch_form = vec__2826;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(catch$,new cljs.core.Symbol(null,"catch","catch",-1616370245,null))){
} else {
throw (new Error("Assert failed: (= catch (quote catch))"));
}

if((sym instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? sym)"));
}

return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","if-cljs","fluree.db.util.core/if-cljs",-432169600,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"try","try",-1273693247,null),null,(1),null)),try_body,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"catch","catch",-1616370245,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("js","Object","js/Object",61215323,null),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,sym,null,(1),null)),catch_body], 0)))),null,(1),null))], 0)))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"try","try",-1273693247,null),null,(1),null)),try_body,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"catch","catch",-1616370245,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","Throwable","fluree.db.util.core/Throwable",853138167,null),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,sym,null,(1),null)),catch_body], 0)))),null,(1),null))], 0)))),null,(1),null))], 0))));
}));

(fluree.db.util.core.try_catchall.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.util.core.try_catchall.cljs$lang$applyTo = (function (seq2823){
var G__2824 = cljs.core.first(seq2823);
var seq2823__$1 = cljs.core.next(seq2823);
var G__2825 = cljs.core.first(seq2823__$1);
var seq2823__$2 = cljs.core.next(seq2823__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2824,G__2825,seq2823__$2);
}));

return null;
})()
;
(fluree.db.util.core.try_catchall.cljs$lang$macro = true);

var ret__5824__auto___2836 = (function (){
/**
 * Like try but supports catch*. catch* is like catch but supports CLJ/CLJS with
 *   less boilerplate. In CLJ it catches `Exception`. In CLJS it catches `:default`.
 *   Use it like this: `(try* ... (catch* err (handle-err err)))`.
 *   Also supports an optional finally clause.
 */
fluree.db.util.core.try_STAR_ = (function fluree$db$util$core$try_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___2837 = arguments.length;
var i__5770__auto___2838 = (0);
while(true){
if((i__5770__auto___2838 < len__5769__auto___2837)){
args__5775__auto__.push((arguments[i__5770__auto___2838]));

var G__2839 = (i__5770__auto___2838 + (1));
i__5770__auto___2838 = G__2839;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.util.core.try_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.util.core.try_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","if-cljs","fluree.db.util.core/if-cljs",-432169600,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("cljs-exceptions","try*","cljs-exceptions/try*",-1080387872,null),null,(1),null)),body))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("clj-exceptions","try*","clj-exceptions/try*",1421445009,null),null,(1),null)),body))),null,(1),null))], 0))));
}));

(fluree.db.util.core.try_STAR_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.util.core.try_STAR_.cljs$lang$applyTo = (function (seq2833){
var G__2834 = cljs.core.first(seq2833);
var seq2833__$1 = cljs.core.next(seq2833);
var G__2835 = cljs.core.first(seq2833__$1);
var seq2833__$2 = cljs.core.next(seq2833__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2834,G__2835,seq2833__$2);
}));

return null;
})()
;
(fluree.db.util.core.try_STAR_.cljs$lang$macro = true);

fluree.db.util.core.index_of = (function fluree$db$util$core$index_of(coll,value){
return cljs.core.some((function (p__2840){
var vec__2841 = p__2840;
var item = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2841,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2841,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,item)){
return idx;
} else {
return null;
}
}),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.range.cljs$core$IFn$_invoke$arity$0())));
});
/**
 * Generates random UUID in both clojure/script
 */
fluree.db.util.core.random_uuid = (function fluree$db$util$core$random_uuid(){
return cljs.core.random_uuid();
});
/**
 * Given a date, returns epoch millis if possible.
 */
fluree.db.util.core.date__GT_millis = (function fluree$db$util$core$date__GT_millis(date){
if(typeof date === 'string'){
return Date.parse(date).getTime();
} else {
if(typeof date === 'number'){
return date;
} else {
if((date instanceof Date)){
return date.getTime();
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid date: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([date], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-date","db/invalid-date",2030527951)], null));

}
}
}
});
/**
 * Returns current time in epoch milliseonds for closure/script
 */
fluree.db.util.core.current_time_millis = (function fluree$db$util$core$current_time_millis(){
return (new Date()).getTime();
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.util.core.response_time_formatted = (function fluree$db$util$core$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis() - start_time)),"ms"].join('');
});
fluree.db.util.core.deep_merge = (function fluree$db$util$core$deep_merge(var_args){
var args__5775__auto__ = [];
var len__5769__auto___2849 = arguments.length;
var i__5770__auto___2850 = (0);
while(true){
if((i__5770__auto___2850 < len__5769__auto___2849)){
args__5775__auto__.push((arguments[i__5770__auto___2850]));

var G__2851 = (i__5770__auto___2850 + (1));
i__5770__auto___2850 = G__2851;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.util.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.util.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (v,vs){
var rec_merge = (function fluree$db$util$core$rec_merge(v1,v2){
if(((cljs.core.map_QMARK_(v1)) && (cljs.core.map_QMARK_(v2)))){
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(fluree.db.util.core.deep_merge,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([v1,v2], 0));
} else {
return v2;
}
});
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,vs))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__2845_SHARP_,p2__2846_SHARP_){
return rec_merge(p1__2845_SHARP_,p2__2846_SHARP_);
}),v,vs);
} else {
return v;
}
}));

(fluree.db.util.core.deep_merge.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.util.core.deep_merge.cljs$lang$applyTo = (function (seq2847){
var G__2848 = cljs.core.first(seq2847);
var seq2847__$1 = cljs.core.next(seq2847);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2848,seq2847__$1);
}));

fluree.db.util.core.email_QMARK_ = (function fluree$db$util$core$email_QMARK_(email){
return cljs.core.re_matches(/^[\w-\+]+(\.[\w]+)*@[\w-]+(\.[\w]+)*(\.[a-z]{2,})$/,email);
});
/**
 * Tests if an predicate identity two-tuple
 *   in form of [pred-name-or-id pred-value]
 */
fluree.db.util.core.pred_ident_QMARK_ = (function fluree$db$util$core$pred_ident_QMARK_(x){
return ((cljs.core.sequential_QMARK_(x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),cljs.core.count(x))) && (typeof cljs.core.first(x) === 'string'))));
});
fluree.db.util.core.temp_ident_QMARK_ = (function fluree$db$util$core$temp_ident_QMARK_(x){
return typeof x === 'string';
});
/**
 * Tests if an _id is a numeric or predicate-ident
 */
fluree.db.util.core.subj_ident_QMARK_ = (function fluree$db$util$core$subj_ident_QMARK_(x){
return ((cljs.core.int_QMARK_(x)) || (fluree.db.util.core.pred_ident_QMARK_(x)));
});
/**
 * Converts string to integer. Assumes you've already verified the string is
 *   parsable to an integer.
 */
fluree.db.util.core.str__GT_int = (function fluree$db$util$core$str__GT_int(s){
return parseInt(s);
});
/**
 * Converts a keyword to string. Can safely be called on a
 *   string which will return itself.
 */
fluree.db.util.core.keyword__GT_str = (function fluree$db$util$core$keyword__GT_str(k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(k),(1));
} else {
if(typeof k === 'string'){
return k;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot convert type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(k))," to string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));

}
}
});
/**
 * Converts a string to a keyword, checking to see if
 *   the string starts with a ':', which it strips before converting.
 */
fluree.db.util.core.str__GT_keyword = (function fluree$db$util$core$str__GT_keyword(s){
if(typeof s === 'string'){
if(clojure.string.starts_with_QMARK_(s,":")){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(1)));
} else {
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(s);
}
} else {
if((s instanceof cljs.core.Keyword)){
return s;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot convert type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(s))," to keyword: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));

}
}
});
/**
 * Takes time as a string and returns an java.time.Instant.
 */
fluree.db.util.core.str__GT_epoch_ms = (function fluree$db$util$core$str__GT_epoch_ms(time_str){
try{return Date.parse(time_str);
}catch (e2852){var _ = e2852;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid time string. Ensure format is ISO-8601 compatible. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([time_str], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-time","db/invalid-time",-1496866235)], null));
}});
/**
 * Truncate string s to n characters.
 */
fluree.db.util.core.trunc = (function fluree$db$util$core$trunc(s,n){
if((cljs.core.count(s) < n)){
return s;
} else {
return [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),n)," ..."].join('');
}
});
var ret__5824__auto___2860 = (function (){
fluree.db.util.core.some_of = (function fluree$db$util$core$some_of(var_args){
var G__2859 = arguments.length;
switch (G__2859) {
case 2:
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__5794__auto__ = [];
var len__5769__auto___2862 = arguments.length;
var i__5770__auto___2863 = (0);
while(true){
if((i__5770__auto___2863 < len__5769__auto___2862)){
args_arr__5794__auto__.push((arguments[i__5770__auto___2863]));

var G__2864 = (i__5770__auto___2863 + (1));
i__5770__auto___2863 = G__2864;
continue;
} else {
}
break;
}

var argseq__5795__auto__ = (new cljs.core.IndexedSeq(args_arr__5794__auto__.slice((3)),(0),null));
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5795__auto__);

}
});

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return null;
}));

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
}));

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,more){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol(null,"x__2853__auto__","x__2853__auto__",1667289210,null),null,(1),null)),(new cljs.core.List(null,x,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"x__2853__auto__","x__2853__auto__",1667289210,null),null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","some-of","fluree.db.util.core/some-of",1946305325,null),null,(1),null)),more))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"x__2853__auto__","x__2853__auto__",1667289210,null),null,(1),null))], 0)))),null,(1),null))], 0))));
}));

/** @this {Function} */
(fluree.db.util.core.some_of.cljs$lang$applyTo = (function (seq2855){
var G__2856 = cljs.core.first(seq2855);
var seq2855__$1 = cljs.core.next(seq2855);
var G__2857 = cljs.core.first(seq2855__$1);
var seq2855__$2 = cljs.core.next(seq2855__$1);
var G__2858 = cljs.core.first(seq2855__$2);
var seq2855__$3 = cljs.core.next(seq2855__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2856,G__2857,G__2858,seq2855__$3);
}));

(fluree.db.util.core.some_of.cljs$lang$maxFixedArity = (3));

return null;
})()
;
(fluree.db.util.core.some_of.cljs$lang$macro = true);

/**
 * Filters map k/v pairs dropping any where predicate applied to value is false.
 */
fluree.db.util.core.filter_vals = (function fluree$db$util$core$filter_vals(pred,m){
return cljs.core.reduce_kv((function (m__$1,k,v){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(v) : pred.call(null,v)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,k,v);
} else {
return m__$1;
}
}),cljs.core.PersistentArrayMap.EMPTY,m);
});
/**
 * Remove all keys from a map that have nil or empty collection values.
 */
fluree.db.util.core.without_nils = (function fluree$db$util$core$without_nils(m){
return fluree.db.util.core.filter_vals((function (p1__2865_SHARP_){
if(cljs.core.coll_QMARK_(p1__2865_SHARP_)){
return cljs.core.not_empty(p1__2865_SHARP_);
} else {
return (!((p1__2865_SHARP_ == null)));
}
}),m);
});
/**
 * Like range, but includes start/end values.
 */
fluree.db.util.core.inclusive_range = (function fluree$db$util$core$inclusive_range(var_args){
var G__2867 = arguments.length;
switch (G__2867) {
case 0:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$1 = (function (end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1((end + (1)));
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2(start,(end + (1)));
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,(end + step),step);
}));

(fluree.db.util.core.inclusive_range.cljs$lang$maxFixedArity = 3);

/**
 * x-platform, returns true if is an execption
 */
fluree.db.util.core.exception_QMARK_ = (function fluree$db$util$core$exception_QMARK_(x){
return (x instanceof Error);
});
fluree.db.util.core.url_encode = (function fluree$db$util$core$url_encode(string){
var G__2869 = string;
var G__2869__$1 = (((G__2869 == null))?null:cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__2869));
var G__2869__$2 = (((G__2869__$1 == null))?null:encodeURIComponent(G__2869__$1));
if((G__2869__$2 == null)){
return null;
} else {
return G__2869__$2.replace("+","%20");
}
});
fluree.db.util.core.url_decode = (function fluree$db$util$core$url_decode(var_args){
var G__2871 = arguments.length;
switch (G__2871) {
case 1:
return fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$1 = (function (string){
return fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$2(string,"UTF-8");
}));

(fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$2 = (function (string,encoding){
var G__2872 = string;
var G__2872__$1 = (((G__2872 == null))?null:cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__2872));
if((G__2872__$1 == null)){
return null;
} else {
return decodeURIComponent(G__2872__$1);
}
}));

(fluree.db.util.core.url_decode.cljs$lang$maxFixedArity = 2);

fluree.db.util.core.map_invert = (function fluree$db$util$core$map_invert(m){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m__$1,p__2874){
var vec__2875 = p__2874;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2875,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__2875,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,v,k);
}),cljs.core.PersistentArrayMap.EMPTY,m);
});
/**
 * Zero pads x
 */
fluree.db.util.core.zero_pad = (function fluree$db$util$core$zero_pad(x,pad){
var s = cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
while(true){
if((s.length < pad)){
var G__2878 = ["0",s].join('');
s = G__2878;
continue;
} else {
return s;
}
break;
}
});
